package Net::SSLLabs::Info;

use strict;
use warnings;

sub new {
    my ( $class, $json ) = @_;
    my $self = $json;
    bless $self, $class;
    return $self;
}

sub version {
    my ($self) = @_;
    return $self->{version};
}

sub current_assessments {
    my ($self) = @_;
    return $self->{currentAssessments};
}

sub messages {
    my ($self) = @_;
    return @{ $self->{messages} };
}

sub max_assessments {
    my ($self) = @_;
    return $self->{maxAssessments};
}

sub criteria_version {
    my ($self) = @_;
    return $self->{criteriaVersion};
}

1;
__END__

=head1 NAME

Net::SSLLabs::Info - Info object

=head1 METHODS

=head2 new

a new C<Net::SSLLabs::Info> object, accepts a JSON object as it's parameter.

=head2 version

SSL Labs software version as a string (e.g., "1.11.14")

=head2 criteria_version

rating criteria version as a string (e.g., "2009f")

=head2 max_assessments

the maximum number of concurrent assessments the client is allowed to initiate.

=head2 current_assessments

the number of ongoing assessments submitted by this client.

=head2 new_assessment_cool_off

the cool-off period after each new assessment; you're not allowed to submit a new assessment before the cool-off expires, otherwise you'll get a 429.

=head2 messages

a list of messages (strings). Messages can be public (sent to everyone) and private (sent only to the invoking client). Private messages are prefixed with "[Private]".
