# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20220307120119;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              496|
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{ja} = {"811454", "鵡川",
"81480", "久喜",
"812995", "石岡",
"814225", "武蔵野三鷹",
"81585", "揖斐川",
"819734", "日田",
"819675", "熊本一の宮",
"818366", "宇部",
"817728", "峰山",
"8186552", "倉敷",
"818203", "柳井",
"818543", "安来",
"817905", "福崎",
"818948", "宇和",
"815763", "下呂",
"812552", "上越",
"818877", "嶺北",
"812962", "下館",
"817715", "亀岡",
"814708", "大原",
"812974", "水海道",
"811363", "倶知安",
"818248", "庄原",
"815758", "郡上八幡",
"812571", "六日町",
"812412", "喜多方",
"812745", "藤岡",
"819802", "南大東",
"817947", "三木",
"818798", "土庄",
"811546", "釧路",
"818846", "丹生谷",
"819969", "中甑",
"814280", "立川",
"81191", "一関",
"81937", "北九州",
"811975", "水沢",
"812653", "飯田",
"812917", "水戸",
"818382", "萩",
"812693", "中野",
"818387", "田万川",
"819578", "島原",
"812474", "石川",
"812834", "宇都宮",
"812565", "三条",
"81439", "木更津",
"819973", "種子島",
"817942", "加古川",
"817476", "下市",
"819807", "沖縄宮古",
"8112392", "夕張",
"8199347", "鹿児島",
"815589", "修善寺大仁",
"812417", "会津山口",
"811564", "上士幌",
"81988", "那覇",
"817238", "寝屋川",
"81196", "盛岡",
"818676", "久世",
"812378", "寒河江",
"818872", "室戸",
"812967", "笠間",
"818684", "津山",
"81952", "佐賀",
"811398", "熊石",
"81126", "岩見沢",
"812557", "新井",
"811551", "十勝池田",
"815366", "設楽",
"812618", "大町",
"811954", "二戸",
"8199345", "鹿児島",
"81885", "小松島",
"819788", "国東",
"817484", "八日市",
"819599", "大瀬戸",
"812486", "須賀川",
"812955", "常陸大宮",
"818675", "久世",
"818559", "川本",
"81438", "木更津",
"8163", "大阪",
"8125480", "村上",
"81566", "刈谷",
"81493", "東松山",
"811632", "天塩",
"819232", "前原",
"812858", "真岡",
"818397", "小郡",
"81552", "甲府",
"811942", "岩泉",
"81464", "厚木",
"8147950", "八日市場",
"81244", "原町",
"811238", "栗山",
"817475", "下市",
"815392", "浜松",
"819948", "志布志",
"819543", "武雄",
"81989", "那覇",
"812239", "仙台",
"8186698", "倉敷",
"812566", "三条",
"815973", "尾鷲",
"811757", "野辺地",
"811648", "焼尻",
"812485", "白河",
"811938", "宮古",
"812956", "常陸大宮",
"812389", "米沢",
"81726", "茨木",
"812939", "水戸",
"819727", "臼杵",
"811533", "根室",
"818833", "鴨島",
"818473", "甲山",
"819437", "田主丸",
"812649", "長野",
"818694", "岡山",
"812582", "長岡",
"817954", "西脇",
"81423", "国分寺",
"817494", "彦根",
"8112396", "栗山",
"817673", "羽咋",
"819932", "指宿",
"818802", "窪川",
"817906", "播磨山崎",
"817454", "大和高田",
"818807", "宿毛",
"819937", "加世田",
"812879", "烏山",
"81721", "富田林",
"818973", "新居浜",
"814283", "青梅",
"811878", "大曲",
"81250", "新津",
"8182920", "廿日市",
"819432", "八女",
"812587", "長岡",
"8188091", "窪川",
"81930", "行橋",
"819722", "佐伯",
"819676", "高森",
"817994", "洲本",
"818654", "鴨方",
"818365", "宇部",
"811984", "花巻",
"81888", "高知",
"81537", "掛川",
"812996", "潮来",
"814226", "武蔵野三鷹",
"811752", "むつ",
"81985", "宮崎",
"811976", "北上",
"81487", "浦和",
"815734", "恵那",
"817363", "和歌山橋本",
"8183767", "下関",
"811545", "釧路",
"81182", "横手",
"81852", "松江",
"815397", "浜松",
"81561", "瀬戸",
"818845", "丹生谷",
"819684", "山鹿",
"81177", "青森",
"8125489", "津川",
"8188093", "窪川",
"811947", "久慈",
"812898", "鹿沼",
"812746", "富岡",
"811637", "北見枝幸",
"812544", "新発田",
"817716", "園部",
"81294", "常陸太田",
"81263", "松本",
"812853", "小山",
"818842", "阿南",
"811542", "釧路",
"81592", "津",
"819806", "沖縄宮古",
"817964", "豊岡",
"819208", "対馬佐賀",
"81762", "金沢",
"81276", "太田",
"812416", "田島",
"815999", "津",
"81725", "和泉",
"818677", "新見",
"811233", "千歳",
"819943", "鹿屋",
"812556", "糸魚川",
"818838", "阿波池田",
"817230", "寝屋川",
"811538", "根室標津",
"818478", "東城",
"81240", "磐城富岡",
"815978", "熊野",
"811643", "石狩深川",
"815367", "設楽",
"811933", "釜石",
"819435", "八女",
"817678", "七尾",
"818362", "宇部",
"819725", "佐伯",
"81565", "豊田",
"81460", "小田原",
"812487", "須賀川",
"818374", "長門",
"811869", "大館",
"8188090", "窪川",
"814288", "青梅",
"811873", "角館",
"812482", "白河",
"817704", "敦賀",
"818367", "宇部",
"812585", "長岡",
"818978", "伯方",
"812244", "白石",
"818299", "広島",
"81569", "半田",
"815362", "新城",
"814700", "鴨川",
"8188099", "土佐清水",
"817353", "新宮",
"8125483", "村上",
"812794", "渋川",
"8186998", "岡山瀬戸",
"818240", "東広島",
"818805", "土佐中村",
"819935", "加世田",
"811584", "遠軽",
"81822", "広島",
"81986", "都城",
"81729", "八尾",
"815959", "亀山",
"818672", "福渡",
"817368", "岩出",
"81934", "北九州",
"818876", "土佐山田",
"81542", "静岡",
"811635", "浜頓別",
"818664", "高梁",
"8125481", "村上",
"81892", "久万",
"811945", "久慈",
"817914", "相生",
"811547", "白糠",
"815395", "浜松",
"818847", "牟岐",
"817472", "五条",
"817946", "三木",
"81774", "宇治",
"812893", "宇都宮",
"817464", "吉野",
"81220", "迫",
"81568", "春日井",
"812890", "宇都宮",
"818806", "宿毛",
"8112397", "栗山",
"819936", "加世田",
"817907", "播磨山崎",
"817723", "宮津",
"81534", "浜松",
"81942", "久留米",
"814298", "飯能",
"81436", "市原",
"818943", "八幡浜",
"81199", "盛岡",
"818894", "須崎",
"819677", "矢部",
"815768", "下呂",
"812586", "長岡",
"811353", "余市",
"812997", "潮来",
"814227", "武蔵野三鷹",
"812784", "沼田",
"818208", "久賀",
"81227", "仙台",
"818548", "石見大田",
"81798", "西宮",
"818243", "東広島",
"815753", "関",
"81969", "天草",
"812562", "三条",
"811977", "北上",
"814703", "館山",
"813", "東京",
"815396", "浜松",
"81728", "寝屋川",
"812574", "柏崎",
"817945", "加古川",
"812747", "富岡",
"811636", "北見枝幸",
"812658", "伊那",
"81484", "川口",
"81586", "一宮",
"811946", "久慈",
"814770", "市川",
"8112395", "栗山",
"818793", "三本松",
"81174", "蟹田",
"814998", "小笠原",
"811464", "静内",
"817717", "園部",
"818875", "土佐山田",
"817712", "亀岡",
"812965", "下館",
"819978", "徳之島",
"812698", "飯山",
"812415", "柳津",
"812742", "藤岡",
"819573", "諫早",
"8183766", "下関",
"81886", "徳島",
"81922", "福岡",
"819805", "名護",
"812373", "村山",
"81162", "稚内",
"81581", "高富",
"812567", "巻",
"81467", "藤沢",
"811972", "水沢",
"81125", "滝川",
"81965", "八代",
"818385", "萩",
"812957", "大子",
"819940", "志布志",
"81992", "鹿児島",
"811756", "野辺地",
"812992", "石岡",
"814222", "武蔵野三鷹",
"812613", "大町",
"819664", "人吉",
"8186994", "岡山瀬戸",
"811554", "帯広",
"81834", "徳山",
"811393", "松前",
"819726", "臼杵",
"819672", "熊本一の宮",
"812679", "佐久",
"812555", "糸魚川",
"819783", "豊後高田",
"817902", "福崎",
"81877", "丸亀",
"81166", "旭川",
"814286", "相模原",
"818205", "柳井",
"818545", "木次",
"81926", "福岡",
"817903", "福崎",
"817727", "峰山",
"819782", "豊後高田",
"815765", "下呂",
"818976", "新居浜",
"819954", "加治木",
"81235", "鶴岡",
"812612", "大町",
"814223", "武蔵野三鷹",
"812993", "石岡",
"811357", "岩内",
"819673", "熊本一の宮",
"8188092", "窪川",
"811392", "木古内",
"818947", "宇和",
"812789", "前橋",
"812372", "村山",
"817366", "岩出",
"814707", "大原",
"81280", "古河",
"818878", "嶺北",
"812655", "飯田",
"812579", "小出",
"811973", "水沢",
"8153974", "天竜",
"8145", "横浜",
"815757", "郡上八幡",
"818247", "庄原",
"817713", "亀岡",
"81188", "秋田",
"817948", "三木",
"818797", "土庄",
"818360", "小郡",
"811654", "名寄",
"811365", "倶知安",
"81478", "佐原",
"819572", "諫早",
"8167", "大阪",
"812743", "藤岡",
"819577", "島原",
"8147955", "八日市場",
"818388", "田万川",
"8198294", "延岡",
"819808", "八重山",
"818792", "三本松",
"817684", "輪島",
"819546", "鹿島",
"812695", "中野",
"8125485", "津川",
"818242", "東広島",
"815984", "松阪",
"812418", "会津山口",
"812563", "三条",
"815752", "関",
"812968", "笠間",
"814702", "館山",
"81432", "千葉",
"819975", "名瀬",
"81946", "甘木",
"812377", "寒河江",
"819744", "三重",
"811536", "厚岸",
"818836", "脇町",
"812558", "新井",
"818476", "府中",
"81582", "岐阜",
"811397", "奥尻",
"818942", "八幡浜",
"81577", "高山",
"811352", "余市",
"812617", "大町",
"8125487", "津川",
"811734", "五所川原",
"811559", "帯広",
"819787", "国東",
"817722", "宮津",
"817676", "七尾",
"8147957", "八日市場",
"8124196", "柳津",
"812674", "小諸",
"818954", "宇和島",
"819976", "名瀬",
"817473", "五条",
"8112391", "夕張",
"812696", "飯山",
"818398", "小郡",
"812857", "真岡",
"819205", "厳原",
"812892", "宇都宮",
"81977", "別府",
"819947", "志布志",
"818673", "福渡",
"811237", "栗山",
"817969", "浜坂",
"81737", "湯浅",
"815994", "阿児",
"81559", "沼津",
"811937", "宮古",
"815363", "新城",
"811647", "羽幌",
"817352", "新宮",
"812560", "糸魚川",
"819438", "田主丸",
"817734", "福知山",
"817675", "七尾",
"819728", "臼杵",
"81546", "静岡",
"815744", "美濃加茂",
"812483", "白河",
"8128798", "大田原",
"81958", "長崎",
"811535", "厚岸",
"811864", "大館",
"818564", "益田",
"818835", "脇町",
"818475", "府中",
"81896", "伊予三島",
"814772", "市川",
"81591", "津",
"8112393", "夕張",
"81272", "前橋",
"81766", "高岡",
"819938", "加世田",
"818808", "土佐清水",
"814777", "船橋",
"81243", "二本松",
"818363", "宇部",
"818294", "廿日市",
"811877", "大曲",
"815766", "下呂",
"812799", "長野原",
"818975", "新居浜",
"812588", "長岡",
"817357", "串本",
"81494", "秩父",
"811642", "石狩深川",
"814285", "相模原",
"818514", "海士",
"811589", "興部",
"811932", "釜石",
"815564", "鰍沢青柳",
"818206", "柳井",
"81463", "平塚",
"81596", "伊勢",
"818546", "掛合",
"8186553", "倉敷",
"811366", "寿都",
"815954", "上野",
"81555", "吉田",
"814220", "国分寺",
"81424", "武蔵野三鷹",
"819942", "大根占",
"815398", "浜松",
"818669", "総社",
"8188096", "土佐清水",
"811232", "千歳",
"812656", "伊那",
"811638", "利尻礼文",
"812897", "鹿沼",
"812852", "小山",
"8198298", "日向",
"817365", "和歌山橋本",
"811543", "釧路",
"818843", "阿南",
"814996", "八丈島",
"81134", "小樽",
"8112399", "栗山",
"819576", "島原",
"811854", "男鹿",
"818554", "浜田",
"819824", "延岡",
"818264", "安芸吉田",
"811235", "夕張",
"814754", "茂原",
"81928", "福岡",
"81545", "富士",
"819945", "鹿屋",
"81849", "福山",
"812855", "小山",
"812550", "安塚",
"819547", "鹿島",
"812376", "寒河江",
"817362", "和歌山橋本",
"81260", "阿南町",
"818678", "新見",
"812234", "仙台",
"819433", "八女",
"812384", "米沢",
"818477", "東城",
"811396", "江差",
"817614", "小松",
"819723", "佐伯",
"811537", "中標津",
"818837", "阿波池田",
"812644", "木曾福島",
"817959", "三田",
"815368", "設楽",
"81742", "奈良",
"811753", "むつ",
"812616", "大町",
"812934", "高萩",
"815977", "熊野",
"81253", "新潟",
"81933", "北九州",
"819786", "杵築",
"817677", "七尾",
"818972", "新居浜",
"81825", "広島",
"81476", "成田",
"814282", "青梅",
"811645", "留萌",
"81551", "韮崎",
"81862", "岡山",
"812488", "須賀川",
"811935", "釜石",
"81998", "鹿児島",
"812874", "大田原",
"817940", "加古川",
"81792", "姫路",
"814287", "青梅",
"8124197", "柳津",
"817459", "大和榛原",
"817355", "新宮",
"818977", "伯方",
"818803", "土佐中村",
"819933", "指宿",
"817726", "峰山",
"818368", "宇部",
"817672", "羽咋",
"81948", "飯塚",
"818464", "竹原",
"815972", "尾鷲",
"811875", "角館",
"81471", "柏",
"8125486", "津川",
"814775", "船橋",
"818946", "宇和",
"818472", "甲山",
"818832", "鴨島",
"811532", "根室",
"811356", "岩内",
"812583", "長岡",
"81420", "所沢",
"81562", "尾張横須賀",
"814706", "大原",
"815393", "浜松",
"817367", "岩出",
"8199343", "鹿児島",
"818246", "三次",
"81845", "因島",
"819542", "武雄",
"815756", "郡上八幡",
"812895", "宇都宮",
"8112390", "夕張",
"818796", "土庄",
"81722", "堺",
"818848", "牟岐",
"811548", "弟子屈",
"814794", "銚子",
"81549", "静岡",
"81765", "魚津",
"811943", "岩泉",
"812549", "津川",
"81899", "松山",
"818594", "米子",
"819233", "前原",
"814776", "船橋",
"818945", "八幡浜",
"817908", "播磨山崎",
"81192", "大船渡",
"81828", "広島",
"811524", "網走",
"819554", "伊万里",
"814297", "飯能",
"811876", "大曲",
"81284", "足利",
"819678", "矢部",
"815767", "下呂",
"817725", "宮津",
"818547", "掛合",
"818207", "久賀",
"81949", "直方",
"817356", "串本",
"814228", "武蔵野三鷹",
"812998", "潮来",
"811978", "北上",
"812580", "十日町",
"811367", "寿都",
"8125482", "村上",
"818795", "三本松",
"81236", "山形",
"818873", "安芸",
"812979", "竜ケ崎",
"81898", "今治",
"819964", "川内",
"812692", "中野",
"81956", "佐世保",
"818245", "三次",
"812913", "鉾田",
"818584", "倉吉",
"81962", "熊本",
"815755", "関",
"812896", "鹿沼",
"812657", "伊那",
"812748", "富岡",
"81925", "福岡",
"819972", "種子島",
"81548", "榛原",
"814705", "館山",
"817718", "園部",
"81427", "相模原",
"817943", "加古川",
"81833", "下松",
"81929", "福岡",
"8144", "川崎",
"81734", "和歌山",
"812839", "佐野",
"819803", "名護",
"812375", "村山",
"819977", "瀬戸内",
"814992", "伊豆大島",
"812652", "飯田",
"812856", "真岡",
"818383", "萩",
"812697", "飯山",
"812963", "下館",
"811374", "森",
"8188097", "土佐清水",
"811236", "千歳",
"815584", "下田",
"819946", "鹿屋",
"811362", "倶知安",
"81533", "豊橋",
"819575", "諫早",
"812413", "喜多方",
"81848", "尾道",
"812568", "巻",
"811646", "羽幌",
"818542", "安来",
"818202", "柳井",
"818689", "岡山",
"811936", "宮古",
"812553", "上越",
"815762", "下呂",
"8188095", "土佐清水",
"819785", "豊後高田",
"81142", "伊達",
"819594", "有川",
"812615", "大町",
"811395", "江差",
"817967", "八鹿",
"815993", "鳥羽",
"811566", "十勝清水",
"818662", "高梁",
"819949", "大根占",
"81535", "浜松",
"812238", "仙台",
"818493", "尾道",
"81144", "苫小牧",
"818674", "久世",
"811858", "能代",
"818558", "川本",
"812836", "佐野",
"812476", "三春",
"817474", "五条",
"818268", "千代田",
"819828", "高千穂",
"814758", "東金",
"81839", "山口",
"817912", "相生",
"812859", "小山",
"818953", "宇和島",
"818391", "小郡",
"817955", "三田",
"812242", "白石",
"818695", "岡山瀬戸",
"817486", "水口",
"817702", "敦賀",
"818563", "益田",
"8188098", "土佐清水",
"811863", "鹿角",
"8186999", "岡山瀬戸",
"815743", "美濃加茂",
"812484", "白河",
"818377", "下関",
"8198296", "日向",
"811582", "紋別",
"817733", "福知山",
"817618", "加賀",
"818686", "津山",
"812388", "長井",
"811939", "宮古",
"817495", "長浜",
"81987", "日南",
"811956", "岩手",
"812792", "渋川",
"812938", "水戸",
"81485", "熊谷",
"812648", "長野",
"81778", "武生",
"815563", "鰍沢青柳",
"81489", "草加",
"812797", "渋川",
"8182941", "広島",
"81179", "三戸",
"817455", "大和高田",
"811587", "中湧別",
"818372", "長門",
"81964", "松橋",
"818293", "廿日市",
"81124", "芦別",
"8175", "京都",
"811456", "門別富川",
"812878", "烏山",
"818364", "宇部",
"817707", "小浜",
"818655", "鴨方",
"817995", "洲本",
"81938", "北九州",
"812247", "大河原",
"81835", "防府",
"814798", "八日市場",
"817917", "竜野",
"819685", "玉名",
"818844", "阿南",
"81923", "福岡",
"811544", "釧路",
"812899", "鹿沼",
"818598", "根雨",
"815735", "恵那",
"8186691", "倉敷",
"81277", "桐生",
"8182943", "広島",
"8111", "札幌",
"81282", "栃木",
"812545", "村上",
"818667", "井原",
"815953", "上野",
"817962", "豊岡",
"812976", "竜ケ崎",
"818656", "笠岡",
"817996", "津名",
"811336", "石狩",
"819674", "熊本一の宮",
"81178", "八戸",
"819735", "日田",
"811552", "帯広",
"81488", "浦和",
"814224", "武蔵野三鷹",
"812994", "石岡",
"818949", "宇和",
"819662", "人吉",
"81259", "佐渡",
"8168", "大阪",
"812787", "沼田",
"81779", "大野",
"811455", "鵡川",
"811986", "遠野",
"819953", "大口",
"81270", "伊勢崎",
"811528", "美幌",
"81939", "北九州",
"8188094", "窪川",
"81724", "岸和田貝塚",
"817904", "福崎",
"817456", "大和高田",
"819558", "唐津",
"81763", "福野",
"812744", "藤岡",
"811653", "士別",
"818588", "郡家",
"81246", "いわき",
"812975", "水海道",
"819968", "出水",
"818290", "広島",
"817714", "亀岡",
"812911", "鉾田",
"812546", "村上",
"814709", "鴨川",
"815736", "中津川",
"81538", "磐田",
"81157", "北見",
"811974", "水沢",
"818249", "東広島",
"81564", "岡崎",
"819686", "玉名",
"81593", "四日市",
"812577", "六日町",
"81466", "藤沢",
"815588", "修善寺大仁",
"8198292", "延岡",
"812572", "柏崎",
"819743", "三重",
"817239", "寝屋川",
"811378", "今金",
"812564", "三条",
"812835", "佐野",
"812475", "石川",
"81744", "大和高田",
"815983", "松阪",
"811462", "浦河",
"81587", "一宮",
"817683", "輪島",
"81543", "静岡",
"81572", "多治見",
"81893", "大洲",
"81864", "倉敷",
"819789", "杵築",
"812673", "小諸",
"811955", "二戸",
"819598", "福江",
"81823", "呉",
"818685", "津山",
"81935", "北九州",
"817496", "長浜",
"811733", "五所川原",
"81775", "大津",
"812782", "沼田",
"818490", "尾道",
"819667", "水俣",
"812551", "上越",
"817956", "三田",
"81226", "気仙沼",
"818696", "備前",
"811557", "十勝池田",
"817485", "八日市",
"818892", "佐川",
"812619", "大町",
"812796", "渋川",
"815769", "荘川",
"81465", "小田原",
"811952", "二戸",
"811586", "中湧別",
"8198297", "日向",
"818549", "石見大田",
"818682", "津山",
"814240", "国分寺",
"811457", "門別富川",
"812785", "沼田",
"819553", "伊万里",
"817482", "八日市",
"812246", "大河原",
"81245", "福島",
"818895", "須崎",
"819737", "玖珠",
"811523", "斜里",
"817706", "小浜",
"817944", "加古川",
"812575", "十日町",
"812659", "伊那",
"817916", "竜野",
"817466", "十津川",
"812472", "石川",
"812832", "佐野",
"811658", "上川",
"818583", "倉吉",
"8125484", "村上",
"812914", "鉾田",
"819963", "川内",
"818874", "安芸",
"811465", "静内",
"8198295", "日向",
"811562", "本別",
"81553", "山梨",
"812977", "竜ケ崎",
"818666", "井原",
"81229", "古川",
"81492", "川越",
"812414", "柳津",
"811567", "十勝清水",
"81225", "石巻",
"817966", "八鹿",
"812972", "水海道",
"815988", "三瀬谷",
"815583", "下田",
"812640", "長野",
"81262", "長野",
"81776", "福井",
"812930", "水戸",
"819913", "硫黄島",
"812964", "下館",
"819979", "徳之島",
"818384", "萩",
"81936", "北九州",
"81473", "市川",
"812477", "三春",
"812837", "佐野",
"817688", "能都",
"819804", "名護",
"81853", "出雲",
"81183", "湯沢",
"819732", "日田",
"81249", "郡山",
"811555", "帯広",
"817487", "水口",
"8153977", "天竜",
"819665", "人吉",
"812678", "佐久",
"818376", "美祢",
"819593", "大瀬戸",
"811452", "早来",
"81984", "小林",
"818687", "美作",
"812554", "上越",
"811738", "鰺ケ沢",
"81740", "今津",
"811957", "岩手",
"812230", "仙台",
"812233", "岩沼",
"819682", "山鹿",
"81486", "浦和",
"81584", "大垣",
"81176", "十和田",
"815732", "恵那",
"815998", "阿児",
"814753", "茂原",
"819823", "延岡",
"818263", "加計",
"8186993", "備前",
"812542", "新発田",
"818958", "御荘",
"818553", "浜田",
"811853", "男鹿",
"817965", "豊岡",
"8125488", "津川",
"815748", "美濃白川",
"817497", "長浜",
"817452", "大和高田",
"811868", "鷹巣",
"818568", "津和野",
"818479", "東城",
"819666", "水俣",
"812933", "高萩",
"811539", "根室標津",
"811754", "むつ",
"818375", "美祢",
"81468", "横須賀",
"811982", "花巻",
"8166", "大阪",
"812643", "木曾福島",
"819724", "佐伯",
"817738", "舞鶴",
"817992", "洲本",
"811332", "当別",
"815979", "熊野",
"817613", "小松",
"818652", "倉敷",
"819434", "八女",
"811556", "帯広",
"812383", "米沢",
"817957", "丹波柏原",
"81434", "千葉",
"818697", "備前",
"81298", "土浦",
"812245", "大河原",
"818692", "邑久",
"817952", "西脇",
"812584", "長岡",
"81727", "池田",
"818896", "須崎",
"818657", "笠岡",
"817705", "小浜",
"817997", "津名",
"811337", "石狩",
"811987", "遠野",
"812786", "沼田",
"818463", "竹原",
"81233", "新庄",
"8199331", "鹿児島",
"814289", "青梅",
"817457", "大和高田",
"811585", "遠軽",
"819934", "指宿",
"818804", "土佐中村",
"817492", "彦根",
"812795", "渋川",
"81531", "田原",
"818298", "廿日市",
"812873", "大田原",
"818593", "米子",
"811944", "岩泉",
"811541", "弟子屈",
"8153962", "天竜",
"818665", "高梁",
"811634", "浜頓別",
"812547", "村上",
"811466", "えりも",
"814793", "銚子",
"81567", "津島",
"817465", "吉野",
"81797", "西宮",
"81228", "築館",
"815958", "亀山",
"815737", "中津川",
"812576", "十日町",
"815394", "浜松",
"817915", "相生",
"819687", "玉名",
"81963", "熊本",
"818680", "岡山",
"819204", "郷ノ浦",
"815986", "松阪",
"817968", "浜坂",
"819544", "武雄",
"819746", "竹田",
"81832", "下関",
"81578", "神岡",
"8198291", "延岡",
"812237", "仙台",
"818955", "宇和島",
"818592", "米子",
"815995", "阿児",
"818557", "川本",
"811857", "能代",
"814792", "銚子",
"817686", "能都",
"814757", "東金",
"819827", "高千穂",
"818267", "千代田",
"817674", "羽咋",
"817735", "福知山",
"817493", "彦根",
"812830", "宇都宮",
"818378", "下関",
"812676", "佐久",
"81979", "中津",
"812872", "大田原",
"817953", "西脇",
"8198293", "延岡",
"818693", "邑久",
"812387", "長井",
"81950", "平戸",
"817617", "加賀",
"81739", "田辺",
"818474", "府中",
"81924", "福岡",
"818565", "益田",
"818834", "鴨島",
"811534", "中標津",
"811865", "大館",
"811736", "五所川原",
"812647", "長野",
"815745", "美濃加茂",
"81138", "函館",
"81557", "伊東",
"812937", "水戸",
"818462", "竹原",
"815974", "尾鷲",
"818467", "木江",
"812932", "高萩",
"812798", "長野原",
"812642", "木曾福島",
"818295", "廿日市",
"811983", "花巻",
"812589", "長岡",
"811588", "興部",
"817612", "小松",
"811333", "当別",
"817993", "洲本",
"812382", "米沢",
"812877", "黒磯",
"815565", "鰍沢青柳",
"81482", "川口",
"81975", "大分",
"814284", "立川",
"814771", "市川",
"819956", "加治木",
"81857", "鳥取",
"818974", "新居浜",
"81143", "室蘭",
"812248", "大河原",
"817453", "大和高田",
"81172", "弘前",
"818262", "加計",
"819822", "延岡",
"814752", "茂原",
"811639", "利尻礼文",
"814797", "八日市場",
"8165", "大阪",
"812543", "新発田",
"817468", "上北山",
"811852", "男鹿",
"815955", "上野",
"81944", "瀬高",
"818552", "浜田",
"811656", "美深",
"81878", "高松",
"81532", "豊橋",
"818597", "根雨",
"819683", "山鹿",
"812232", "岩沼",
"8112398", "栗山",
"817364", "和歌山橋本",
"815733", "恵那",
"818668", "井原",
"815399", "天竜",
"819955", "加治木",
"81544", "富士宮",
"8182942", "広島",
"8161", "大阪",
"81932", "北九州",
"815764", "下呂",
"818544", "木次",
"818204", "柳井",
"815566", "身延",
"812788", "前橋",
"81863", "玉野",
"819733", "日田",
"811527", "美幌",
"8186995", "岡山瀬戸",
"81743", "奈良",
"819557", "唐津",
"81252", "新潟",
"818296", "広島",
"811453", "早来",
"819592", "大瀬戸",
"81266", "諏訪",
"819967", "出水",
"818587", "郡家",
"817949", "加古川",
"812654", "飯田",
"8186997", "岡山瀬戸",
"814994", "三宅",
"81288", "今市",
"815956", "上野",
"818879", "室戸",
"814701", "鴨川",
"811364", "倶知安",
"812973", "水海道",
"811655", "名寄",
"8178", "神戸",
"815582", "下田",
"812578", "六日町",
"811372", "鹿部",
"819912", "中之島",
"811377", "八雲",
"817685", "輪島",
"8112394", "夕張",
"8153960", "天竜",
"81723", "堺",
"815587", "修善寺大仁",
"812419", "田島",
"811563", "本別",
"815996", "阿児",
"817950", "三田",
"818690", "岡山",
"819974", "屋久島",
"818956", "宇和島",
"812833", "宇都宮",
"819809", "八重山",
"812473", "石川",
"81875", "観音寺",
"81426", "八王子",
"819962", "川内",
"815985", "松阪",
"81550", "御殿場",
"812694", "中野",
"818582", "倉吉",
"819597", "福江",
"811735", "五所川原",
"815746", "美濃加茂",
"819552", "伊万里",
"81563", "西尾",
"817483", "八日市",
"811522", "斜里",
"81594", "桑名",
"811866", "鷹巣",
"819668", "水俣",
"812559", "安塚",
"811953", "二戸",
"812675", "佐久",
"81764", "富山",
"81793", "姫路",
"81738", "御坊",
"817736", "舞鶴",
"818683", "津山",
"811558", "広尾",
"811732", "五所川原",
"812783", "沼田",
"818466", "木江",
"81474", "船橋",
"819679", "高森",
"819555", "唐津",
"818660", "岡山瀬戸",
"811354", "余市",
"814229", "武蔵野三鷹",
"812999", "潮来",
"811525", "網走",
"818893", "佐川",
"81184", "本荘",
"818944", "八幡浜",
"812672", "小諸",
"8153963", "天竜",
"812876", "黒磯",
"814291", "飯能",
"817724", "宮津",
"819738", "玖珠",
"8183768", "下関",
"81292", "水戸",
"81429", "所沢",
"819957", "加治木",
"817682", "輪島",
"814796", "八日市場",
"811463", "浦河",
"818794", "三本松",
"818596", "米子",
"81222", "仙台",
"8153961", "天竜",
"819742", "三重",
"812573", "柏崎",
"814704", "館山",
"815754", "関",
"812978", "竜ケ崎",
"818585", "倉吉",
"818244", "三次",
"815982", "松阪",
"81983", "高鍋",
"81947", "田川",
"819965", "川内",
"815987", "三瀬谷",
"812236", "仙台",
"812374", "村山",
"812569", "巻",
"819747", "竹田",
"818556", "江津",
"812838", "佐野",
"811856", "能代",
"819574", "諫早",
"812478", "三春",
"811652", "士別",
"81495", "本庄",
"815585", "下田",
"814756", "東金",
"819826", "日向",
"818266", "千代田",
"817687", "能都",
"811375", "八雲",
"817488", "水口",
"819952", "大口",
"81927", "福岡",
"8186992", "備前",
"81167", "富良野",
"819784", "豊後高田",
"81425", "立川",
"81462", "厚木",
"81554", "大月",
"812677", "佐久",
"8186697", "倉敷",
"817960", "八鹿",
"817616", "小松",
"811394", "松前",
"81242", "会津若松",
"812386", "長井",
"818688", "美作",
"811553", "帯広",
"81273", "高崎",
"819663", "人吉",
"812614", "大町",
"812936", "水戸",
"811958", "岩手",
"819595", "有川",
"812646", "長野",
"811737", "鰺ケ沢",
"819944", "鹿屋",
"815586", "下田",
"814755", "東金",
"811234", "千歳",
"818265", "安芸吉田",
"819825", "日向",
"811376", "八雲",
"818555", "江津",
"818679", "新見",
"811855", "能代",
"815952", "上野",
"8198299", "日向",
"815997", "阿児",
"817963", "豊岡",
"8164", "大阪",
"8186996", "岡山瀬戸",
"812235", "仙台",
"818957", "御荘",
"81268", "上田",
"812854", "小山",
"81234", "酒田",
"81286", "宇都宮",
"812935", "水戸",
"818373", "長門",
"815747", "美濃白川",
"819596", "福江",
"812645", "木曾福島",
"818292", "広島",
"818567", "津和野",
"811867", "鷹巣",
"817615", "小松",
"8152", "名古屋",
"812385", "米沢",
"812489", "須賀川",
"817498", "長浜",
"811934", "釜石",
"815562", "鰍沢青柳",
"811644", "留萌",
"818512", "西郷",
"818698", "備前",
"817958", "丹波柏原",
"817737", "舞鶴",
"817998", "津名",
"817732", "福知山",
"811583", "紋別",
"81281", "宇都宮",
"812793", "渋川",
"817354", "新宮",
"812570", "小出",
"812875", "大田原",
"812243", "白石",
"8162", "大阪",
"81547", "島田",
"811862", "鹿角",
"814281", "相模原",
"811526", "網走",
"818562", "益田",
"817703", "敦賀",
"817458", "大和榛原",
"81583", "岐阜",
"815742", "美濃加茂",
"818297", "廿日市",
"811874", "角館",
"81940", "宗像",
"818369", "宇部",
"819556", "唐津",
"8198290", "延岡",
"811549", "釧路",
"8169", "大阪",
"817463", "吉野",
"812894", "宇都宮",
"818586", "倉吉",
"819966", "出水",
"8126177", "長野",
"81827", "岩国",
"81433", "千葉",
"818952", "宇和島",
"815738", "中津川",
"815992", "鳥羽",
"818595", "米子",
"815957", "上野",
"818663", "総社",
"819688", "玉名",
"812780", "前橋",
"814795", "銚子",};
$areanames{en} = {"812955", "Hitachi\-Omiya\,\ Ibaraki",
"812486", "Sukagawa\,\ Fukushima",
"817962", "Toyooka\,\ Hyogo",
"818667", "Ibara\,\ Okayama",
"81282", "Tochigi\,\ Tochigi",
"812545", "Murakami\,\ Niigata",
"819599", "Oseto\,\ Nagasaki",
"817484", "Yokaichi\,\ Shiga",
"8111", "Sapporo\,\ Hokkaido",
"819788", "Kunisaki\,\ Oita",
"8182943", "Hiroshima\,\ Hiroshima",
"81277", "Kiryu\,\ Gunma",
"8186691", "Kurashiki\,\ Okayama",
"81885", "Komatsushima\,\ Tokushima",
"812618", "Omachi\,\ Nagano",
"811954", "Ninohe\,\ Iwate",
"8199345", "Kagoshima\,\ Kagoshima",
"815366", "Shitara\,\ Aichi",
"815735", "Ena\,\ Gifu",
"812899", "Kanuma\,\ Tochigi",
"818844", "Anan\,\ Tokushima",
"81952", "Saga\,\ Saga",
"81923", "Fukuoka\,\ Fukuoka",
"811398", "Kumaishi\,\ Hokkaido",
"81126", "Iwamizawa\,\ Hokkaido",
"811544", "Kushiro\,\ Hokkaido",
"814798", "Yokaichiba\,\ Chiba",
"81835", "Hofu\,\ Yamaguchi",
"819685", "Tamana\,\ Kumamoto",
"818684", "Tsuyama\,\ Okayama",
"812967", "Kasama\,\ Ibaraki",
"812247", "Ogawara\,\ Miyagi",
"818872", "Muroto\,\ Kochi",
"818676", "Kuse\,\ Okayama",
"812378", "Sagae\,\ Yamagata",
"818364", "Ube\,\ Yamaguchi",
"817707", "Obama\,\ Fukui",
"818655", "Kamogata\,\ Okayama",
"817995", "Sumoto\,\ Hyogo",
"81938", "Kitakyushu\,\ Fukuoka",
"817238", "Neyagawa\,\ Osaka",
"812878", "Nasukarasuyama\,\ Tochigi",
"81196", "Morioka\,\ Iwate",
"811564", "Kamishihoro\,\ Hokkaido",
"818293", "Hatsukaichi\,\ Hiroshima",
"81124", "Ashibetsu\,\ Hokkaido",
"81988", "Naha\,\ Okinawa",
"8175", "Kyoto\,\ Kyoto",
"8199347", "Kagoshima\,\ Kagoshima",
"8153976", "Hamamatsu\,\ Shizuoka",
"818372", "Nagato\,\ Yamaguchi",
"81179", "Sannohe\,\ Aomori",
"8112392", "Yubari\,\ Hokkaido",
"817455", "Yamatotakada\,\ Nara",
"811587", "Nakayubetsu\,\ Hokkaido",
"817942", "Kakogawa\,\ Hyogo",
"817476", "Shimonoseki\,\ Yamaguchi",
"81439", "Kisarazu\,\ Chiba",
"8182941", "Hiroshima\,\ Hiroshima",
"812565", "Sanjo\,\ Niigata",
"812834", "Utsunomiya\,\ Tochigi",
"812797", "Shibukawa\,\ Gunma",
"819578", "Shimabara\,\ Nagasaki",
"812474", "Ishikawa\,\ Fukushima",
"81489", "Soka\,\ Saitama",
"818387", "Tamagawa\,\ Yamaguchi",
"81778", "Takefu\,\ Fukui",
"812693", "Nakano\,\ Nagano",
"812648", "Nagano\,\ Nagano",
"818382", "Hagi\,\ Yamaguchi",
"812917", "Mito\,\ Ibaraki",
"81485", "Kumagaya\,\ Saitama",
"811956", "Iwate\,\ Iwate",
"81987", "Nichinan\,\ Miyazaki",
"812792", "Shibukawa\,\ Gunma",
"812938", "Mito\,\ Ibaraki",
"811975", "Mizusawa\,\ Iwate",
"812653", "Iida\,\ Nagano",
"817495", "Nagahama\,\ Shiga",
"81937", "Kitakyushu\,\ Fukuoka",
"818686", "Tsuyama\,\ Okayama",
"814280", "Tachikawa\,\ Tokyo",
"812388", "Nagai\,\ Yamagata",
"81191", "Ichinoseki\,\ Iwate",
"811939", "Miyako\,\ Iwate",
"811546", "Kushiro\,\ Hokkaido",
"811582", "Monbetsu\,\ Hokkaido",
"8198296", "Hyuga\,\ Miyazaki",
"817733", "Fukuchiyama\,\ Kyoto",
"817618", "Kaga\,\ Ishikawa",
"819802", "Minamidaito\,\ Okinawa",
"818798", "Tonosho\,\ Kagawa",
"817947", "Miki\,\ Hyogo",
"812412", "Kitakata\,\ Fukushima",
"812745", "Fujioka\,\ Gunma",
"8153967", "Hamamatsu\,\ Shizuoka",
"812571", "Muika\,\ Niigata",
"818377", "Shimonoseki\,\ Yamaguchi",
"811363", "Kutchan\,\ Hokkaido",
"818248", "Shobara\,\ Hiroshima",
"812484", "Shirakawa\,\ Fukushima",
"815743", "Minokamo\,\ Gifu",
"8186999", "Seto\,\ Okayama",
"818563", "Masuda\,\ Shimane",
"8188098", "Tosashimizu\,\ Kochi",
"811863", "Kazuno\,\ Akita",
"817702", "Tsuruga\,\ Fukui",
"812962", "Shimodate\,\ Ibaraki",
"817715", "Kameoka\,\ Kyoto",
"817486", "Minakuchi\,\ Shiga",
"817955", "Sanda\,\ Hyogo",
"812242", "Shiroishi\,\ Miyagi",
"818695", "Seto\,\ Okayama",
"817912", "Aioi\,\ Hyogo",
"812859", "Oyama\,\ Tochigi",
"818953", "Uwajima\,\ Ehime",
"818391", "Ogori\,\ Yamaguchi",
"8126178", "Omachi\,\ Nagano",
"819828", "Takachiho\,\ Miyazaki",
"815763", "Gero\,\ Gifu",
"81839", "Yamaguchi\,\ Yamaguchi",
"814758", "Togane\,\ Chiba",
"812552", "Joetsu\,\ Niigata",
"817905", "Fukusaki\,\ Hyogo",
"818948", "Uwajima\,\ Ehime",
"818543", "Yasugi\,\ Shimane",
"818203", "Yanai\,\ Yamaguchi",
"8153965", "Hamamatsu\,\ Shizuoka",
"812476", "Miharu\,\ Fukushima",
"8186552", "Kurashiki\,\ Okayama",
"811858", "Noshiro\,\ Akita",
"818558", "Kawamoto\,\ Shimane",
"812836", "Sano\,\ Tochigi",
"818366", "Ube\,\ Yamaguchi",
"819734", "Hita\,\ Oita",
"818674", "Kuse\,\ Okayama",
"81585", "Ibigawa\,\ Gifu",
"818493", "Onomichi\,\ Hiroshima",
"812238", "Sendai\,\ Miyagi",
"81144", "Tomakomai\,\ Hokkaido",
"812995", "Ishioka\,\ Ibaraki",
"81535", "Hamamatsu\,\ Shizuoka",
"81480", "Kuki\,\ Saitama",
"818662", "Takahashi\,\ Okayama",
"811454", "Mukawa\,\ Hokkaido",
"815993", "Toba\,\ Mie",
"81263", "Matsumoto\,\ Nagano",
"818892", "Sakawa\,\ Kochi",
"812619", "Omachi\,\ Nagano",
"817716", "Sonobe\,\ Kyoto",
"81294", "Hitachiota\,\ Ibaraki",
"817485", "Yokaichi\,\ Shiga",
"817956", "Sanda\,\ Hyogo",
"812544", "Shibata\,\ Niigata",
"81226", "Kesennuma\,\ Miyagi",
"818696", "Bizen\,\ Okayama",
"812746", "Tomioka\,\ Gunma",
"812782", "Numata\,\ Gunma",
"818490", "Onomichi\,\ Hiroshima",
"819667", "Minamata\,\ Kumamoto",
"812551", "Joetsu\,\ Niigata",
"812898", "Kanuma\,\ Tochigi",
"81775", "Otsu\,\ Shiga",
"811947", "Kuji\,\ Iwate",
"811733", "Goshogawara\,\ Aomori",
"817496", "Nagahama\,\ Shiga",
"818685", "Tsuyama\,\ Okayama",
"819684", "Yamaga\,\ Kumamoto",
"81177", "Aomori\,\ Aomori",
"8125489", "Tsugawa\,\ Niigata",
"81935", "Kitakyushu\,\ Fukuoka",
"811545", "Kushiro\,\ Hokkaido",
"81182", "Yokote\,\ Akita",
"81852", "Matsue\,\ Shimane",
"81823", "Kure\,\ Hiroshima",
"81561", "Seto\,\ Aichi",
"8126171", "Omachi\,\ Nagano",
"8183767", "Shimonoseki\,\ Yamaguchi",
"81487", "Urawa\,\ Saitama",
"815734", "Ena\,\ Gifu",
"819598", "Fukue\,\ Nagasaki",
"812673", "Komoro\,\ Nagano",
"811955", "Ninohe\,\ Iwate",
"819789", "Kitsuki\,\ Oita",
"81985", "Miyazaki\,\ Miyazaki",
"811976", "Kitakami\,\ Iwate",
"812996", "Itako\,\ Ibaraki",
"811752", "Mutsu\,\ Aomori",
"81864", "Kurashiki\,\ Okayama",
"81537", "Kakegawa\,\ Shizuoka",
"81888", "Kochi\,\ Kochi",
"81893", "Ozu\,\ Ehime",
"811984", "Hanamaki\,\ Iwate",
"817994", "Sumoto\,\ Hyogo",
"818654", "Kamogata\,\ Okayama",
"818365", "Ube\,\ Yamaguchi",
"81572", "Tajimi\,\ Gifu",
"819722", "Saiki\,\ Oita",
"81930", "Yukuhashi\,\ Fukuoka",
"819676", "Takamori\,\ Kumamoto",
"812587", "Nagaoka\,\ Niigata",
"81543", "Shizuoka\,\ Shizuoka",
"817683", "Wajima\,\ Ishikawa",
"8126173", "Omachi\,\ Nagano",
"81587", "Ichinomiya\,\ Aichi",
"811462", "Urakawa\,\ Hokkaido",
"819432", "Yame\,\ Fukuoka",
"8182920", "Hatsukaichi\,\ Hiroshima",
"815983", "Matsusaka\,\ Mie",
"814283", "Ome\,\ Tokyo",
"811878", "Omagari\,\ Akita",
"812475", "Ishikawa\,\ Fukushima",
"81250", "Niitsu\,\ Niigata",
"81744", "Yamatotakada\,\ Nara",
"812835", "Sano\,\ Tochigi",
"812564", "Sanjo\,\ Niigata",
"811378", "Imakane\,\ Hokkaido",
"81721", "Tondabayashi\,\ Osaka",
"812879", "Nasukarasuyama\,\ Tochigi",
"817239", "Neyagawa\,\ Osaka",
"818973", "Niihama\,\ Ehime",
"818807", "Sukumo\,\ Kochi",
"819937", "Kaseda\,\ Kagoshima",
"817454", "Yamatotakada\,\ Nara",
"8198292", "Nobeoka\,\ Miyazaki",
"812572", "Kashiwazaki\,\ Niigata",
"819743", "Mie\,\ Oita",
"81466", "Fujisawa\,\ Kanagawa",
"819932", "Ibusuki\,\ Kagoshima",
"81593", "Yokkaichi\,\ Mie",
"812577", "Muika\,\ Niigata",
"8112396", "Kuriyama\,\ Hokkaido",
"817673", "Hakui\,\ Ishikawa",
"819686", "Tamana\,\ Kumamoto",
"818249", "Higashi\-ku\,\ Hiroshima",
"81423", "Kokubunji\,\ Tokyo",
"81564", "Okazaki\,\ Aichi",
"817494", "Hikone\,\ Shiga",
"811974", "Mizusawa\,\ Iwate",
"81157", "Kitami\,\ Hokkaido",
"81538", "Iwata\,\ Shizuoka",
"814709", "Kamogawa\,\ Chiba",
"815736", "Nakatsugawa\,\ Gifu",
"818694", "Okayama\,\ Okayama",
"812582", "Nagaoka\,\ Niigata",
"817954", "Nishiwaki\,\ Hyogo",
"812546", "Murakami\,\ Niigata",
"819437", "Tanushimaru\,\ Fukuoka",
"817714", "Kameoka\,\ Kyoto",
"812911", "Hokota\,\ Ibaraki",
"812649", "Nagano\,\ Nagano",
"818290", "Hiroshima\,\ Hiroshima",
"819727", "Usuki\,\ Oita",
"811533", "Nemuro\,\ Hokkaido",
"812939", "Mito\,\ Ibaraki",
"8126174", "Omachi\,\ Nagano",
"818833", "Kamojima\,\ Tokushima",
"811938", "Miyako\,\ Iwate",
"819968", "Izumi\,\ Kagoshima",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"81726", "Ibaraki\,\ Osaka",
"812389", "Yonezawa\,\ Yamagata",
"812485", "Shirakawa\,\ Fukushima",
"811653", "Shibetsu\,\ Hokkaido",
"818588", "Koge\,\ Tottori",
"81246", "Iwaki\,\ Fukushima",
"811757", "Noheji\,\ Aomori",
"8153972", "Hamamatsu\,\ Shizuoka",
"815973", "Owase\,\ Mie",
"812744", "Fujioka\,\ Gunma",
"81763", "Fukuno\,\ Toyama",
"812566", "Sanjo\,\ Niigata",
"819558", "Karatsu\,\ Saga",
"8186698", "Kurashiki\,\ Okayama",
"812239", "Sendai\,\ Miyagi",
"819543", "Takeo\,\ Saga",
"81989", "Naha\,\ Okinawa",
"815392", "Hamamatsu\,\ Shizuoka",
"819948", "Shibushi\,\ Kagoshima",
"817904", "Fukusaki\,\ Hyogo",
"817456", "Yamatotakada\,\ Nara",
"81244", "Hobara\,\ Fukushima",
"81939", "Kitakyushu\,\ Fukuoka",
"811528", "Bihoro\,\ Hokkaido",
"811238", "Kuriyama\,\ Hokkaido",
"817475", "Shimonoseki\,\ Yamaguchi",
"8147950", "Yokaichiba\,\ Chiba",
"81270", "Isesaki\,\ Gunma",
"819953", "Okuchi\,\ Kagoshima",
"818397", "Ogori\,\ Yamaguchi",
"81552", "Kofu\,\ Yamanashi",
"811986", "Tono\,\ Iwate",
"811942", "Iwaizumi\,\ Iwate",
"81464", "Atsugi\,\ Kanagawa",
"81779", "Ono\,\ Gifu",
"819232", "Maebaru\,\ Fukuoka",
"811455", "Mukawa\,\ Hokkaido",
"812858", "Mooka\,\ Tochigi",
"81493", "Higashimatsuyama\,\ Saitama",
"818949", "Uwajima\,\ Ehime",
"819662", "Hitoyoshi\,\ Kumamoto",
"81259", "Sado\,\ Niigata",
"811632", "Teshio\,\ Hokkaido",
"8168", "Osaka\,\ Osaka",
"812787", "Numata\,\ Gunma",
"81566", "Kariya\,\ Aichi",
"81488", "Urawa\,\ Saitama",
"812994", "Ishioka\,\ Ibaraki",
"8163", "Osaka\,\ Osaka",
"811552", "Obihiro\,\ Hokkaido",
"8125480", "Murakami\,\ Niigata",
"81438", "Kisarazu\,\ Chiba",
"818675", "Kuse\,\ Okayama",
"818559", "Kawamoto\,\ Shimane",
"81178", "Hachinohe\,\ Aomori",
"819735", "Hita\,\ Oita",
"818656", "Kasaoka\,\ Okayama",
"817996", "Tsuna\,\ Hyogo",
"811336", "Ishikari\,\ Hokkaido",
"812230", "Sendai\,\ Miyagi",
"817464", "Yoshino\,\ Nara",
"81740", "Imazu\,\ Shiga",
"811957", "Iwate\,\ Iwate",
"812893", "Utsunomiya\,\ Tochigi",
"81774", "Uji\,\ Kyoto",
"817946", "Miki\,\ Hyogo",
"812554", "Joetsu\,\ Niigata",
"811547", "Shiranuka\,\ Hokkaido",
"815395", "Hamamatsu\,\ Shizuoka",
"818687", "Mimasaka\,\ Okayama",
"817914", "Aioi\,\ Hyogo",
"819593", "Oseto\,\ Nagasaki",
"811452", "Hayakita\,\ Hokkaido",
"81984", "Kobayashi\,\ Miyazaki",
"8125481", "Murakami\,\ Niigata",
"81892", "Kumakogen\,\ Ehime",
"811945", "Kuji\,\ Iwate",
"812678", "Saku\,\ Nagano",
"818376", "Mine\,\ Yamaguchi",
"811635", "Hamatonbetsu\,\ Hokkaido",
"8126179", "Omachi\,\ Nagano",
"819665", "Hitoyoshi\,\ Kumamoto",
"818664", "Takahashi\,\ Okayama",
"81542", "Shizuoka\,\ Shizuoka",
"811555", "Obihiro\,\ Hokkaido",
"817487", "Minakuchi\,\ Shiga",
"81249", "Koriyama\,\ Fukushima",
"81934", "Kitakyushu\,\ Fukuoka",
"81729", "Yao\,\ Osaka",
"815959", "Kameyama\,\ Mie",
"819732", "Hita\,\ Oita",
"817368", "Iwade\,\ Wakayama",
"811584", "Engaru\,\ Hokkaido",
"81986", "Miyakonojo\,\ Miyazaki",
"81822", "Hiroshima\,\ Hiroshima",
"81853", "Izumo\,\ Shimane",
"81183", "Yuzawa\,\ Akita",
"818240", "Higashi\-ku\,\ Hiroshima",
"819804", "Nago\,\ Okinawa",
"819935", "Kaseda\,\ Kagoshima",
"817688", "Noto\,\ Ishikawa",
"8186998", "Seto\,\ Okayama",
"817353", "Shingu\,\ Fukuoka",
"8125483", "Murakami\,\ Niigata",
"812794", "Shibukawa\,\ Gunma",
"812837", "Sano\,\ Tochigi",
"81473", "Ichikawa\,\ Chiba",
"812477", "Miharu\,\ Fukushima",
"8153975", "Hamamatsu\,\ Shizuoka",
"814700", "Kamogawa\,\ Chiba",
"8188099", "Tosashimizu\,\ Kochi",
"818384", "Hagi\,\ Yamaguchi",
"81936", "Kitakyushu\,\ Fukuoka",
"819979", "Tokunoshima\,\ Kagoshima",
"815362", "Shinshiro\,\ Aichi",
"812964", "Shimodate\,\ Ibaraki",
"818299", "Hiroshima\,\ Hiroshima",
"81569", "Handa\,\ Aichi",
"812930", "Mito\,\ Ibaraki",
"812585", "Nagaoka\,\ Niigata",
"818978", "Hakata\,\ Ehime",
"812244", "Shiroishi\,\ Miyagi",
"81262", "Nagano\,\ Nagano",
"81776", "Fukui\,\ Fukui",
"815583", "Shimoda\,\ Shizuoka",
"817704", "Tsuruga\,\ Fukui",
"812640", "Nagano\,\ Nagano",
"818367", "Ube\,\ Yamaguchi",
"81225", "Ishinomaki\,\ Miyagi",
"812482", "Shirakawa\,\ Fukushima",
"812414", "Yanaizu\,\ Fukushima",
"811873", "Kakunodate\,\ Akita",
"814288", "Ome\,\ Tokyo",
"818666", "Ibara\,\ Okayama",
"81492", "Kawagoe\,\ Saitama",
"818374", "Nagato\,\ Yamaguchi",
"811869", "Odate\,\ Akita",
"812487", "Sukagawa\,\ Fukushima",
"81553", "Yamanashi\,\ Yamanashi",
"81460", "Odawara\,\ Kanagawa",
"811562", "Honbetsu\,\ Hokkaido",
"8198295", "Hyuga\,\ Miyazaki",
"819725", "Saiki\,\ Oita",
"81565", "Toyota\,\ Aichi",
"817678", "Nanao\,\ Ishikawa",
"818362", "Ube\,\ Yamaguchi",
"819435", "Yame\,\ Fukuoka",
"811465", "Shizunai\,\ Hokkaido",
"818874", "Aki\,\ Kochi",
"819963", "Satsumasendai\,\ Kagoshima",
"811933", "Kamaishi\,\ Iwate",
"818583", "Kurayoshi\,\ Tottori",
"811658", "Kamikawa\,\ Hokkaido",
"815367", "Shitara\,\ Aichi",
"8125484", "Murakami\,\ Niigata",
"812914", "Hokota\,\ Ibaraki",
"812832", "Sano\,\ Tochigi",
"817466", "Totsukawa\,\ Nara",
"812472", "Ishikawa\,\ Fukushima",
"815978", "Kumano\,\ Mie",
"812575", "Tokamachi\,\ Niigata",
"812659", "Ina\,\ Nagano",
"818478", "Tojo\,\ Hiroshima",
"817944", "Kakogawa\,\ Hyogo",
"812556", "Itoigawa\,\ Niigata",
"817230", "Neyagawa\,\ Osaka",
"817706", "Obama\,\ Fukui",
"819943", "Kanoya\,\ Kagoshima",
"818677", "Niimi\,\ Okayama",
"811523", "Shari\,\ Hokkaido",
"819737", "Kusu\,\ Oita",
"818895", "Susaki\,\ Kochi",
"811233", "Chitose\,\ Hokkaido",
"812246", "Ogawara\,\ Miyagi",
"81245", "Fukushima\,\ Fukushima",
"817482", "Yokaichi\,\ Shiga",
"815999", "Tsu\,\ Mie",
"81725", "Izumi\,\ Osaka",
"8153966", "Hamamatsu\,\ Shizuoka",
"819553", "Imari\,\ Saga",
"81762", "Kanazawa\,\ Ishikawa",
"81276", "Ota\,\ Gunma",
"812416", "Tajima\,\ Fukushima",
"812785", "Numata\,\ Gunma",
"817964", "Toyooka\,\ Hyogo",
"814240", "Kokubunji\,\ Tokyo",
"818682", "Tsuyama\,\ Okayama",
"8198297", "Hyuga\,\ Miyazaki",
"818842", "Anan\,\ Tokushima",
"811542", "Kushiro\,\ Hokkaido",
"811586", "Nakayubetsu\,\ Hokkaido",
"81592", "Tsu\,\ Mie",
"812853", "Oyama\,\ Tochigi",
"8126170", "Omachi\,\ Nagano",
"812796", "Shibukawa\,\ Gunma",
"815769", "Shokawa\,\ Gifu",
"81465", "Odawara\,\ Kanagawa",
"811952", "Ninohe\,\ Iwate",
"817915", "Aioi\,\ Hyogo",
"819687", "Tamana\,\ Kumamoto",
"819783", "Bungotakada\,\ Oita",
"812576", "Tokamachi\,\ Niigata",
"815394", "Hamamatsu\,\ Shizuoka",
"817902", "Fukusaki\,\ Hyogo",
"812679", "Saku\,\ Nagano",
"812555", "Itoigawa\,\ Niigata",
"815737", "Nakatsugawa\,\ Gifu",
"815958", "Kameyama\,\ Mie",
"817465", "Yoshino\,\ Nara",
"81797", "Nishinomiya\,\ Hyogo",
"819726", "Usuki\,\ Oita",
"81567", "Tsushima\,\ Aichi",
"81834", "Tokuyama\,\ Yamaguchi",
"811393", "Matsumae\,\ Hokkaido",
"811554", "Obihiro\,\ Hokkaido",
"811466", "Erimo\,\ Hokkaido",
"814793", "Choshi\,\ Chiba",
"8186994", "Seto\,\ Okayama",
"812547", "Murakami\,\ Niigata",
"819664", "Hitoyoshi\,\ Kumamoto",
"818665", "Takahashi\,\ Okayama",
"811634", "Hamatonbetsu\,\ Hokkaido",
"811756", "Noheji\,\ Aomori",
"811541", "Teshikaga\,\ Hokkaido",
"812992", "Ishioka\,\ Ibaraki",
"812613", "Omachi\,\ Nagano",
"811944", "Iwaizumi\,\ Iwate",
"81992", "Kagoshima\,\ Kagoshima",
"812957", "Daigo\,\ Ibaraki",
"819940", "Shibushi\,\ Kagoshima",
"818593", "Yonago\,\ Tottori",
"812873", "Otawara\,\ Tochigi",
"81965", "Yatsushiro\,\ Kumamoto",
"818298", "Hatsukaichi\,\ Hiroshima",
"818385", "Hagi\,\ Yamaguchi",
"81531", "Tahara\,\ Aichi",
"81467", "Fujisawa\,\ Kanagawa",
"811972", "Mizusawa\,\ Iwate",
"81125", "Takikawa\,\ Hokkaido",
"812795", "Shibukawa\,\ Gunma",
"81162", "Wakkanai\,\ Hokkaido",
"817492", "Hikone\,\ Shiga",
"819934", "Ibusuki\,\ Kagoshima",
"812373", "Murayama\,\ Yamagata",
"819805", "Nago\,\ Okinawa",
"814289", "Ome\,\ Tokyo",
"8183766", "Shimonoseki\,\ Yamaguchi",
"817457", "Yamatotakada\,\ Nara",
"81922", "Fukuoka\,\ Fukuoka",
"81886", "Tokushima\,\ Tokushima",
"811585", "Engaru\,\ Hokkaido",
"818463", "Takehara\,\ Hiroshima",
"81233", "Shinjo\,\ Yamagata",
"8199331", "Kagoshima\,\ Kagoshima",
"812415", "Yanaizu\,\ Fukushima",
"812742", "Fujioka\,\ Gunma",
"819573", "Isahaya\,\ Nagasaki",
"812786", "Numata\,\ Gunma",
"811987", "Tono\,\ Iwate",
"812698", "Iiyama\,\ Nagano",
"818657", "Kasaoka\,\ Okayama",
"817705", "Obama\,\ Fukui",
"817997", "Tsuna\,\ Hyogo",
"811337", "Ishikari\,\ Hokkaido",
"818896", "Susaki\,\ Kochi",
"812245", "Ogawara\,\ Miyagi",
"818692", "Oku\,\ Okayama",
"817952", "Nishiwaki\,\ Hyogo",
"819978", "Tokunoshima\,\ Kagoshima",
"81727", "Ikeda\,\ Osaka",
"812584", "Nagaoka\,\ Niigata",
"817712", "Kameoka\,\ Kyoto",
"81298", "Tsuchiura\,\ Ibaraki",
"812965", "Shimodate\,\ Ibaraki",
"81434", "Chiba\,\ Chiba",
"818697", "Bizen\,\ Okayama",
"814998", "Ogasawara\,\ Tokyo",
"811464", "Shizunai\,\ Hokkaido",
"819434", "Yame\,\ Fukuoka",
"817717", "Sonobe\,\ Kyoto",
"811556", "Obihiro\,\ Hokkaido",
"812383", "Yonezawa\,\ Yamagata",
"817992", "Sumoto\,\ Hyogo",
"817738", "Maizuru\,\ Kyoto",
"811332", "Tobetsu\,\ Hokkaido",
"817613", "Komatsu\,\ Ishikawa",
"815979", "Kumano\,\ Mie",
"818652", "Kurashiki\,\ Okayama",
"8112395", "Kuriyama\,\ Hokkaido",
"81174", "Kanita\,\ Aomori",
"819724", "Saiki\,\ Oita",
"814770", "Ichikawa\,\ Chiba",
"8166", "Osaka\,\ Osaka",
"81468", "Yokosuka\,\ Kanagawa",
"81586", "Ichinomiya\,\ Aichi",
"811982", "Hanamaki\,\ Iwate",
"811946", "Kuji\,\ Iwate",
"812933", "Takahagi\,\ Ibaraki",
"811754", "Mutsu\,\ Aomori",
"818375", "Mine\,\ Yamaguchi",
"81484", "Kawaguchi\,\ Saitama",
"812747", "Tomioka\,\ Gunma",
"818479", "Tojo\,\ Hiroshima",
"812658", "Ina\,\ Nagano",
"819666", "Minamata\,\ Kumamoto",
"811868", "Takanosu\,\ Akita",
"817945", "Kakogawa\,\ Hyogo",
"818568", "Tsuwano\,\ Shimane",
"817452", "Yamatotakada\,\ Nara",
"813", "Tokyo",
"81728", "Neyagawa\,\ Osaka",
"812574", "Kashiwazaki\,\ Niigata",
"814703", "Tateyama\,\ Chiba",
"817497", "Nagahama\,\ Shiga",
"811977", "Kitakami\,\ Iwate",
"815753", "Sekigahara\,\ Gifu",
"812562", "Sanjo\,\ Niigata",
"81969", "Amakusa\,\ Kumamoto",
"818243", "Higashi\-ku\,\ Hiroshima",
"817965", "Toyooka\,\ Hyogo",
"81798", "Nishinomiya\,\ Hyogo",
"8125488", "Tsugawa\,\ Niigata",
"81227", "Sendai\,\ Miyagi",
"812784", "Numata\,\ Gunma",
"812997", "Itako\,\ Ibaraki",
"818553", "Hamada\,\ Shimane",
"811853", "Oga\,\ Akita",
"818958", "Misho\,\ Ehime",
"812586", "Nagaoka\,\ Niigata",
"812542", "Shibata\,\ Niigata",
"811353", "Yoichi\,\ Hokkaido",
"818894", "Susaki\,\ Kochi",
"814753", "Mobara\,\ Chiba",
"819823", "Nobeoka\,\ Miyazaki",
"8186993", "Bizen\,\ Okayama",
"815768", "Gero\,\ Gifu",
"818263", "Kake\,\ Hiroshima",
"818943", "Yawatahama\,\ Ehime",
"81199", "Morioka\,\ Iwate",
"814298", "Hanno\,\ Saitama",
"81436", "Ichihara\,\ Chiba",
"81942", "Kurume\,\ Fukuoka",
"815732", "Ena\,\ Gifu",
"815998", "Ago\,\ Mie",
"81534", "Hamamatsu\,\ Shizuoka",
"81176", "Towada\,\ Aomori",
"817723", "Miyazu\,\ Kyoto",
"818806", "Sukumo\,\ Kochi",
"81584", "Ogaki\,\ Gifu",
"819936", "Kaseda\,\ Kagoshima",
"8112397", "Kuriyama\,\ Hokkaido",
"81486", "Urawa\,\ Saitama",
"81568", "Kasugai\,\ Aichi",
"812890", "Utsunomiya\,\ Tochigi",
"812233", "Iwanuma\,\ Miyagi",
"819682", "Yamaga\,\ Kumamoto",
"818668", "Ibara\,\ Okayama",
"8124196", "Yanaizu\,\ Fukushima",
"812674", "Komoro\,\ Nagano",
"8147957", "Yokaichiba\,\ Chiba",
"815733", "Ena\,\ Gifu",
"8112398", "Kuriyama\,\ Hokkaido",
"819787", "Kunisaki\,\ Oita",
"817722", "Miyazu\,\ Kyoto",
"817676", "Nanao\,\ Ishikawa",
"819683", "Yamaga\,\ Kumamoto",
"812232", "Iwanuma\,\ Miyagi",
"81878", "Takamatsu\,\ Kagawa",
"811734", "Goshogawara\,\ Aomori",
"81532", "Toyohashi\,\ Aichi",
"811559", "Obihiro\,\ Hokkaido",
"8125487", "Tsugawa\,\ Niigata",
"811656", "Bifuka\,\ Hokkaido",
"811852", "Oga\,\ Akita",
"818552", "Hamada\,\ Shimane",
"81944", "Setaka\,\ Fukuoka",
"817468", "Kamikitayama\,\ Nara",
"8153971", "Hamamatsu\,\ Shizuoka",
"8165", "Osaka\,\ Osaka",
"812543", "Shibata\,\ Niigata",
"811352", "Yoichi\,\ Hokkaido",
"81577", "Takayama\,\ Gifu",
"814797", "Yokaichiba\,\ Chiba",
"818476", "Fuchu\,\ Hiroshima",
"81582", "Gifu\,\ Gifu",
"811397", "Okushiri\,\ Hokkaido",
"818942", "Yawatahama\,\ Ehime",
"818262", "Kake\,\ Hiroshima",
"819822", "Nobeoka\,\ Miyazaki",
"811536", "Akkeshi\,\ Hokkaido",
"818836", "Mima\,\ Tokushima",
"814752", "Mobara\,\ Chiba",
"819744", "Mie\,\ Oita",
"81172", "Hirosaki\,\ Aomori",
"817453", "Yamatotakada\,\ Nara",
"812377", "Sagae\,\ Yamagata",
"81946", "Amagi\,\ Fukuoka",
"819975", "Naze\,\ Kagoshima",
"818974", "Niihama\,\ Ehime",
"81143", "Muroran\,\ Hokkaido",
"812248", "Ogawara\,\ Miyagi",
"812968", "Kasama\,\ Ibaraki",
"819956", "Kajiki\,\ Kagoshima",
"814702", "Tateyama\,\ Chiba",
"81432", "Chiba\,\ Chiba",
"81857", "Tottori\,\ Tottori",
"812563", "Sanjo\,\ Niigata",
"814771", "Ichikawa\,\ Chiba",
"815752", "Sekigahara\,\ Gifu",
"81482", "Kawaguchi\,\ Saitama",
"81975", "Oita\,\ Oita",
"814284", "Tachikawa\,\ Tokyo",
"8153973", "Hamamatsu\,\ Shizuoka",
"812877", "Kuroiso\,\ Tochigi",
"819546", "Kashima\,\ Saga",
"812695", "Nakano\,\ Nagano",
"818242", "Higashi\-ku\,\ Hiroshima",
"815984", "Matsusaka\,\ Mie",
"8125485", "Tsugawa\,\ Niigata",
"812382", "Yonezawa\,\ Yamagata",
"817684", "Wajima\,\ Ishikawa",
"819808", "Yaeyama\ District\,\ Okinawa",
"8198294", "Nobeoka\,\ Miyazaki",
"811588", "Okoppe\,\ Hokkaido",
"817612", "Komatsu\,\ Ishikawa",
"811333", "Tobetsu\,\ Hokkaido",
"817993", "Sumoto\,\ Hyogo",
"812589", "Nagaoka\,\ Niigata",
"811983", "Hanamaki\,\ Iwate",
"8147955", "Yokaichiba\,\ Chiba",
"818388", "Tamagawa\,\ Yamaguchi",
"818295", "Hatsukaichi\,\ Hiroshima",
"819577", "Shimabara\,\ Nagasaki",
"818467", "Mima\,\ Tokushima",
"812798", "Naganohara\,\ Gunma",
"812932", "Takahagi\,\ Ibaraki",
"819572", "Isahaya\,\ Nagasaki",
"812743", "Fujioka\,\ Gunma",
"8167", "Osaka\,\ Osaka",
"815974", "Owase\,\ Mie",
"81557", "Ito\,\ Shizuoka",
"812937", "Mito\,\ Ibaraki",
"81478", "Sawara\,\ Chiba",
"818462", "Takehara\,\ Hiroshima",
"811654", "Nayoro\,\ Hokkaido",
"811365", "Kutchan\,\ Hokkaido",
"815745", "Minokamo\,\ Gifu",
"81138", "Hakodate\,\ Hokkaido",
"818360", "Ogori\,\ Yamaguchi",
"812647", "Nagano\,\ Nagano",
"811736", "Goshogawara\,\ Aomori",
"81924", "Fukuoka\,\ Fukuoka",
"81188", "Akita\,\ Akita",
"818565", "Masuda\,\ Shimane",
"818834", "Kamojima\,\ Tokushima",
"818797", "Tonosho\,\ Kagawa",
"817948", "Miki\,\ Hyogo",
"811534", "Nakashibetsu\,\ Hokkaido",
"811865", "Odate\,\ Akita",
"81950", "Hirado\,\ Nagasaki",
"817617", "Kaga\,\ Ishikawa",
"81739", "Tanabe\,\ Wakayama",
"818474", "Fuchu\,\ Hiroshima",
"812387", "Nagai\,\ Yamagata",
"817713", "Kameoka\,\ Kyoto",
"817953", "Nishiwaki\,\ Hyogo",
"8198293", "Nobeoka\,\ Miyazaki",
"818693", "Oku\,\ Okayama",
"81979", "Nakatsu\,\ Oita",
"818247", "Shobara\,\ Hiroshima",
"812872", "Otawara\,\ Tochigi",
"818378", "Shimonoseki\,\ Yamaguchi",
"812676", "Saku\,\ Nagano",
"812655", "Iida\,\ Nagano",
"811973", "Mizusawa\,\ Iwate",
"8145", "Yokohama\,\ Kanagawa",
"817493", "Hikone\,\ Shiga",
"812830", "Utsunomiya\,\ Tochigi",
"81280", "Koga\,\ Ibaraki",
"817674", "Hakui\,\ Ishikawa",
"8126172", "Omachi\,\ Nagano",
"817735", "Fukuchiyama\,\ Kyoto",
"812372", "Murayama\,\ Yamagata",
"817366", "Iwade\,\ Wakayama",
"811392", "Kikonai\,\ Hokkaido",
"818947", "Uwajima\,\ Ehime",
"812789", "Maebashi\,\ Gunma",
"814757", "Togane\,\ Chiba",
"819827", "Takachiho\,\ Miyazaki",
"811357", "Iwanai\,\ Hokkaido",
"817686", "Noto\,\ Ishikawa",
"814792", "Choshi\,\ Chiba",
"818557", "Kawamoto\,\ Shimane",
"812612", "Omachi\,\ Nagano",
"812993", "Ishioka\,\ Ibaraki",
"811857", "Noshiro\,\ Akita",
"818592", "Yonago\,\ Tottori",
"81235", "Tsuruoka\,\ Yamagata",
"815995", "Ago\,\ Mie",
"812237", "Sendai\,\ Miyagi",
"819954", "Kajiki\,\ Kagoshima",
"818955", "Uwajima\,\ Ehime",
"818976", "Niihama\,\ Ehime",
"81832", "Shimonoseki\,\ Yamaguchi",
"815765", "Gero\,\ Gifu",
"81578", "Kamioka\,\ Akita",
"8198291", "Nobeoka\,\ Miyazaki",
"817903", "Fukusaki\,\ Hyogo",
"819746", "Taketa\,\ Oita",
"819782", "Bungotakada\,\ Oita",
"815986", "Matsusaka\,\ Mie",
"817968", "Hamasaka\,\ Hyogo",
"819544", "Takeo\,\ Saga",
"818545", "Kisuki\,\ Shimane",
"81926", "Fukuoka\,\ Fukuoka",
"818205", "Yanai\,\ Yamaguchi",
"814286", "Sagamihara\,\ Kanagawa",
"818680", "Okayama\,\ Okayama",
"81166", "Asahikawa\,\ Hokkaido",
"81877", "Marugame\,\ Kagawa",
"81963", "Kumamoto\,\ Kumamoto",
"818683", "Tsuyama\,\ Okayama",
"811558", "Hiroo\,\ Hokkaido",
"811543", "Kushiro\,\ Hokkaido",
"818843", "Anan\,\ Tokushima",
"817736", "Maizuru\,\ Kyoto",
"8198298", "Hyuga\,\ Miyazaki",
"81738", "Gobo\,\ Wakayama",
"81793", "Himeji\,\ Hyogo",
"812852", "Oyama\,\ Tochigi",
"811953", "Ninohe\,\ Iwate",
"812559", "Yasuzuka\,\ Niigata",
"812675", "Saku\,\ Nagano",
"812897", "Kanuma\,\ Tochigi",
"81764", "Toyama\,\ Toyama",
"812656", "Ina\,\ Nagano",
"819668", "Minamata\,\ Kumamoto",
"811522", "Shari\,\ Hokkaido",
"811232", "Chitose\,\ Hokkaido",
"81594", "Kuwana\,\ Mie",
"811866", "Takanosu\,\ Akita",
"818669", "Soja\,\ Okayama",
"815398", "Hamamatsu\,\ Shizuoka",
"8188096", "Tosashimizu\,\ Kochi",
"817483", "Yokaichi\,\ Shiga",
"81563", "Nishio\,\ Aichi",
"814220", "Kokubunji\,\ Tokyo",
"81555", "Fujiyoshida\,\ Yamanashi",
"819552", "Imari\,\ Saga",
"811366", "Suttsu\,\ Hokkaido",
"815746", "Minokamo\,\ Gifu",
"8186553", "Kurashiki\,\ Okayama",
"819597", "Fukue\,\ Nagasaki",
"811735", "Goshogawara\,\ Aomori",
"815985", "Matsusaka\,\ Mie",
"81550", "Gotenba\,\ Shizuoka",
"812694", "Nakano\,\ Nagano",
"818546", "Kakeya\,\ Shimane",
"81596", "Ise\,\ Mie",
"818582", "Kurayoshi\,\ Tottori",
"811932", "Kamaishi\,\ Iwate",
"818206", "Yanai\,\ Yamaguchi",
"81463", "Hiratsuka\,\ Kanagawa",
"819962", "Satsumasendai\,\ Kagoshima",
"814285", "Sagamihara\,\ Kanagawa",
"812473", "Ishikawa\,\ Fukushima",
"818514", "Ama\,\ Shimane",
"81875", "Kan\'onji\,\ Kagawa",
"811589", "Okoppe\,\ Hokkaido",
"81426", "Hachioji\,\ Tokyo",
"817357", "Kushimoto\,\ Wakayama",
"81494", "Chichibu\,\ Saitama",
"819809", "Yaeyama\ District\,\ Okinawa",
"812833", "Utsunomiya\,\ Tochigi",
"818956", "Uwajima\,\ Ehime",
"818975", "Niihama\,\ Ehime",
"819974", "Yakushima\,\ Kagoshima",
"812588", "Nagaoka\,\ Niigata",
"815766", "Gero\,\ Gifu",
"812799", "Naganohara\,\ Gunma",
"8126176", "Omachi\,\ Nagano",
"817950", "Sanda\,\ Hyogo",
"818690", "Okayama\,\ Okayama",
"811877", "Omagari\,\ Akita",
"811563", "Honbetsu\,\ Hokkaido",
"818294", "Hatsukaichi\,\ Hiroshima",
"815996", "Ago\,\ Mie",
"814777", "Funabashi\,\ Chiba",
"81243", "Nihonmatsu\,\ Fukushima",
"818363", "Ube\,\ Yamaguchi",
"812419", "Tajima\,\ Fukushima",
"819938", "Kaseda\,\ Kagoshima",
"8112394", "Yubari\,\ Hokkaido",
"81723", "Sakai\,\ Osaka",
"818808", "Tosashimizu\,\ Kochi",
"81272", "Maebashi\,\ Gunma",
"81766", "Takaoka\,\ Toyama",
"817685", "Wajima\,\ Ishikawa",
"811377", "Yakumo\,\ Hokkaido",
"8112393", "Yubari\,\ Hokkaido",
"81591", "Tsu\,\ Mie",
"811372", "Shikabe\,\ Hokkaido",
"818475", "Fuchu\,\ Hiroshima",
"81896", "Iyomishima\,\ Ehime",
"815582", "Shimoda\,\ Shizuoka",
"814772", "Ichikawa\,\ Chiba",
"812578", "Muika\,\ Niigata",
"81958", "Nagasaki\,\ Nagasaki",
"811535", "Akkeshi\,\ Hokkaido",
"811864", "Odate\,\ Akita",
"818835", "Mima\,\ Tokushima",
"818564", "Masuda\,\ Shimane",
"8178", "Kobe\,\ Hyogo",
"815744", "Minokamo\,\ Gifu",
"812483", "Shirakawa\,\ Fukushima",
"818879", "Muroto\,\ Kochi",
"814701", "Kamogawa\,\ Chiba",
"811364", "Kutchan\,\ Hokkaido",
"811655", "Nayoro\,\ Hokkaido",
"8128798", "Otawara\,\ Tochigi",
"81546", "Shizuoka\,\ Shizuoka",
"8153969", "Hamamatsu\,\ Shizuoka",
"819728", "Usuki\,\ Oita",
"817734", "Fukuchiyama\,\ Kyoto",
"817675", "Nanao\,\ Ishikawa",
"819438", "Tanushimaru\,\ Fukuoka",
"81288", "Imabari\,\ Ehime",
"812560", "Itoigawa\,\ Niigata",
"8186997", "Seto\,\ Okayama",
"812654", "Iida\,\ Nagano",
"811647", "Haboro\,\ Hokkaido",
"817949", "Kakogawa\,\ Hyogo",
"817352", "Shingu\,\ Fukuoka",
"815363", "Shinshiro\,\ Aichi",
"818587", "Koge\,\ Tottori",
"819967", "Izumi\,\ Kagoshima",
"811937", "Miyako\,\ Iwate",
"81559", "Numazu\,\ Shizuoka",
"815994", "Ago\,\ Mie",
"818296", "Hiroshima\,\ Hiroshima",
"811453", "Hayakita\,\ Hokkaido",
"819592", "Oseto\,\ Nagasaki",
"81266", "Suwa\,\ Nagano",
"8153978", "Hamamatsu\,\ Shizuoka",
"81252", "Niigata\,\ Niigata",
"819557", "Karatsu\,\ Saga",
"81743", "Nara\,\ Nara",
"81737", "Yuasa\,\ Wakayama",
"817969", "Hamasaka\,\ Hyogo",
"8186995", "Seto\,\ Okayama",
"811527", "Bihoro\,\ Hokkaido",
"819733", "Hita\,\ Oita",
"811237", "Kuriyama\,\ Hokkaido",
"819947", "Shibushi\,\ Kagoshima",
"812892", "Utsunomiya\,\ Tochigi",
"81863", "Tamano\,\ Okayama",
"81977", "Beppu\,\ Oita",
"812788", "Maebashi\,\ Gunma",
"812857", "Mooka\,\ Tochigi",
"818204", "Yanai\,\ Yamaguchi",
"815566", "Minobu\,\ Yamanashi",
"818544", "Kisuki\,\ Shimane",
"812696", "Iiyama\,\ Nagano",
"818398", "Ogori\,\ Yamaguchi",
"8112391", "Yubari\,\ Hokkaido",
"81932", "Kitakyushu\,\ Fukuoka",
"815764", "Gero\,\ Gifu",
"8161", "Osaka\,\ Osaka",
"819976", "Naze\,\ Kagoshima",
"8182942", "Hiroshima\,\ Hiroshima",
"818954", "Uwajima\,\ Ehime",
"819955", "Kajiki\,\ Kagoshima",
"81544", "Fujinomiya\,\ Shizuoka",
"818594", "Yonago\,\ Tottori",
"819233", "Maebaru\,\ Fukuoka",
"812646", "Nagano\,\ Nagano",
"81765", "Uozu\,\ Toyama",
"811943", "Iwaizumi\,\ Iwate",
"812549", "Tsugawa\,\ Niigata",
"81899", "Matsuyama\,\ Ehime",
"812936", "Mito\,\ Ibaraki",
"812614", "Omachi\,\ Nagano",
"811958", "Iwate\,\ Iwate",
"819663", "Hitoyoshi\,\ Kumamoto",
"81549", "Shizuoka\,\ Shizuoka",
"81273", "Takasaki\,\ Gunma",
"814794", "Choshi\,\ Chiba",
"812386", "Nagai\,\ Yamagata",
"818688", "Mimasaka\,\ Okayama",
"811553", "Obihiro\,\ Hokkaido",
"817616", "Komatsu\,\ Ishikawa",
"811394", "Matsumae\,\ Hokkaido",
"81242", "Aizuwakamatsu\,\ Fukushima",
"811548", "Teshikaga\,\ Hokkaido",
"818796", "Tonosho\,\ Kagawa",
"81722", "Sakai\,\ Osaka",
"8112390", "Yubari\,\ Hokkaido",
"8153964", "Hamamatsu\,\ Shizuoka",
"8186697", "Kurashiki\,\ Okayama",
"812677", "Saku\,\ Nagano",
"812895", "Utsunomiya\,\ Tochigi",
"8199343", "Kagoshima\,\ Kagoshima",
"818246", "Miyoshi\,\ Hiroshima",
"819542", "Takeo\,\ Saga",
"81845", "Innoshima\,\ Hiroshima",
"81462", "Atsugi\,\ Kanagawa",
"81554", "Otsuki\,\ Yamanashi",
"817367", "Iwade\,\ Wakayama",
"81167", "Furano\,\ Hokkaido",
"819784", "Bungotakada\,\ Oita",
"815393", "Hamamatsu\,\ Shizuoka",
"81425", "Tachikawa\,\ Tokyo",
"817488", "Minakuchi\,\ Shiga",
"819952", "Okuchi\,\ Kagoshima",
"8186992", "Bizen\,\ Okayama",
"81927", "Fukuoka\,\ Fukuoka",
"811375", "Yakumo\,\ Hokkaido",
"811356", "Iwanai\,\ Hokkaido",
"812583", "Nagaoka\,\ Niigata",
"81420", "Tokorozawa\,\ Saitama",
"817687", "Noto\,\ Ishikawa",
"818832", "Kamojima\,\ Tokushima",
"814756", "Togane\,\ Chiba",
"819826", "Hyuga\,\ Miyazaki",
"811532", "Nemuro\,\ Hokkaido",
"814775", "Funabashi\,\ Chiba",
"818946", "Uwajima\,\ Ehime",
"815585", "Shimoda\,\ Shizuoka",
"811652", "Shibetsu\,\ Hokkaido",
"81495", "Honjo\,\ Saitama",
"81471", "Kashiwa\,\ Chiba",
"8125486", "Tsugawa\,\ Niigata",
"819574", "Isahaya\,\ Nagasaki",
"811875", "Kakunodate\,\ Akita",
"812478", "Miharu\,\ Fukushima",
"815972", "Owase\,\ Mie",
"812838", "Sano\,\ Tochigi",
"818556", "Gotsu\,\ Shimane",
"81948", "Iizuka\,\ Fukuoka",
"811856", "Noshiro\,\ Akita",
"818464", "Takehara\,\ Hiroshima",
"818368", "Ube\,\ Yamaguchi",
"817672", "Hakui\,\ Ishikawa",
"819747", "Taketa\,\ Oita",
"812374", "Murayama\,\ Yamagata",
"819933", "Ibusuki\,\ Kagoshima",
"818977", "Hakata\,\ Ehime",
"812236", "Sendai\,\ Miyagi",
"817355", "Shingu\,\ Fukuoka",
"814287", "Ome\,\ Tokyo",
"8124197", "Yanaizu\,\ Fukushima",
"81792", "Himeji\,\ Hyogo",
"812874", "Otawara\,\ Tochigi",
"817940", "Kakogawa\,\ Hyogo",
"81947", "Tagawa\,\ Fukuoka",
"819965", "Satsumasendai\,\ Kagoshima",
"811935", "Kamaishi\,\ Iwate",
"81998", "Kagoshima\,\ Kagoshima",
"818585", "Kurayoshi\,\ Tottori",
"815982", "Matsusaka\,\ Mie",
"818244", "Miyoshi\,\ Hiroshima",
"812488", "Sukagawa\,\ Fukushima",
"81983", "Takanabe\,\ Miyazaki",
"811645", "Rumoi\,\ Hokkaido",
"815754", "Sekigahara\,\ Gifu",
"81551", "Nirasaki\,\ Yamanashi",
"81862", "Okayama\,\ Okayama",
"814282", "Ome\,\ Tokyo",
"818972", "Niihama\,\ Ehime",
"81825", "Hiroshima\,\ Hiroshima",
"81476", "Narita\,\ Chiba",
"814704", "Tateyama\,\ Chiba",
"819742", "Mie\,\ Oita",
"819786", "Kitsuki\,\ Oita",
"812573", "Kashiwazaki\,\ Niigata",
"817677", "Nanao\,\ Ishikawa",
"81933", "Kitakyushu\,\ Fukuoka",
"81222", "Sendai\,\ Miyagi",
"815977", "Kumano\,\ Mie",
"81253", "Niigata\,\ Niigata",
"811753", "Mutsu\,\ Aomori",
"81742", "Nara\,\ Nara",
"812934", "Takahagi\,\ Ibaraki",
"812616", "Omachi\,\ Nagano",
"817959", "Sanda\,\ Hyogo",
"815368", "Shitara\,\ Aichi",
"818596", "Yonago\,\ Tottori",
"819723", "Saiki\,\ Oita",
"811537", "Nakashibetsu\,\ Hokkaido",
"818477", "Tojo\,\ Hiroshima",
"811396", "Esashi\,\ Hokkaido",
"817614", "Komatsu\,\ Ishikawa",
"819433", "Yame\,\ Fukuoka",
"812384", "Yonezawa\,\ Yamagata",
"811463", "Urakawa\,\ Hokkaido",
"814796", "Yokaichiba\,\ Chiba",
"817682", "Wajima\,\ Ishikawa",
"819957", "Kajiki\,\ Kagoshima",
"812234", "Sendai\,\ Miyagi",
"81292", "Mito\,\ Ibaraki",
"81429", "Tokorozawa\,\ Saitama",
"819738", "Kusu\,\ Oita",
"8183768", "Shimonoseki\,\ Yamaguchi",
"812376", "Sagae\,\ Yamagata",
"818678", "Niimi\,\ Okayama",
"81260", "Anan\,\ Nagano",
"814291", "Hanno\,\ Saitama",
"817724", "Miyazu\,\ Kyoto",
"812550", "Yasuzuka\,\ Niigata",
"819547", "Kashima\,\ Saga",
"812876", "Kuroiso\,\ Tochigi",
"812855", "Oyama\,\ Tochigi",
"81849", "Fukuyama\,\ Hiroshima",
"812672", "Komoro\,\ Nagano",
"81545", "Fuji\,\ Shizuoka",
"818944", "Yawatahama\,\ Ehime",
"819945", "Kanoya\,\ Kagoshima",
"812999", "Itako\,\ Ibaraki",
"819824", "Nobeoka\,\ Miyazaki",
"811525", "Abashiri\,\ Hokkaido",
"818893", "Sakawa\,\ Kochi",
"811235", "Yubari\,\ Hokkaido",
"814754", "Mobara\,\ Chiba",
"81184", "Yurihonjo\,\ Akita",
"81928", "Fukuoka\,\ Fukuoka",
"811354", "Yoichi\,\ Hokkaido",
"818660", "Seto\,\ Okayama",
"811854", "Oga\,\ Akita",
"818466", "Mima\,\ Tokushima",
"81474", "Funabashi\,\ Chiba",
"819679", "Takamori\,\ Kumamoto",
"818554", "Hamada\,\ Shimane",
"819555", "Karatsu\,\ Saga",
"8112399", "Kuriyama\,\ Hokkaido",
"819576", "Shimabara\,\ Nagasaki",
"812783", "Numata\,\ Gunma",
"811732", "Goshogawara\,\ Aomori",
"81134", "Otaru\,\ Hokkaido",
"811395", "Esashi\,\ Hokkaido",
"819688", "Tamana\,\ Kumamoto",
"812780", "Maebashi\,\ Gunma",
"814795", "Choshi\,\ Chiba",
"818663", "Soja\,\ Okayama",
"812615", "Omachi\,\ Nagano",
"815992", "Toba\,\ Mie",
"815738", "Nakatsugawa\,\ Gifu",
"818595", "Yonago\,\ Tottori",
"81142", "Date\,\ Hokkaido",
"81827", "Iwakuni\,\ Yamaguchi",
"818952", "Uwajima\,\ Ehime",
"81433", "Chiba\,\ Chiba",
"819785", "Bungotakada\,\ Oita",
"812553", "Joetsu\,\ Niigata",
"8153979", "Hamamatsu\,\ Shizuoka",
"8188095", "Tosashimizu\,\ Kochi",
"815762", "Gero\,\ Gifu",
"818202", "Yanai\,\ Yamaguchi",
"818689", "Okayama\,\ Okayama",
"819966", "Izumi\,\ Kagoshima",
"811936", "Miyako\,\ Iwate",
"818542", "Yasugi\,\ Shimane",
"818586", "Kurayoshi\,\ Tottori",
"811646", "Haboro\,\ Hokkaido",
"812894", "Utsunomiya\,\ Tochigi",
"8198290", "Nobeoka\,\ Miyazaki",
"811549", "Kushiro\,\ Hokkaido",
"8169", "Osaka\,\ Osaka",
"817463", "Yoshino\,\ Nara",
"81848", "Onomichi\,\ Hiroshima",
"819556", "Karatsu\,\ Saga",
"81940", "Munakata\,\ Fukuoka",
"811874", "Kakunodate\,\ Akita",
"8153968", "Hamamatsu\,\ Shizuoka",
"819575", "Isahaya\,\ Nagasaki",
"818369", "Ube\,\ Yamaguchi",
"812413", "Kitakata\,\ Fukushima",
"818297", "Hatsukaichi\,\ Hiroshima",
"81533", "Toyohashi\,\ Aichi",
"815742", "Minokamo\,\ Gifu",
"811362", "Kutchan\,\ Hokkaido",
"815584", "Shimoda\,\ Shizuoka",
"817703", "Tsuruga\,\ Fukui",
"819946", "Kanoya\,\ Kagoshima",
"81583", "Gifu\,\ Gifu",
"81547", "Shimada\,\ Shizuoka",
"811862", "Kazuno\,\ Akita",
"8188097", "Tosashimizu\,\ Kochi",
"8126175", "Omachi\,\ Nagano",
"811526", "Abashiri\,\ Hokkaido",
"811236", "Chitose\,\ Hokkaido",
"814281", "Sagamihara\,\ Kanagawa",
"818562", "Masuda\,\ Shimane",
"812243", "Shiroishi\,\ Miyagi",
"8162", "Osaka\,\ Osaka",
"811374", "Mori\,\ Hokkaido",
"812963", "Shimodate\,\ Ibaraki",
"812875", "Otawara\,\ Tochigi",
"812697", "Iiyama\,\ Nagano",
"812856", "Mooka\,\ Tochigi",
"818383", "Hagi\,\ Yamaguchi",
"812652", "Iida\,\ Nagano",
"812793", "Shibukawa\,\ Gunma",
"817354", "Shingu\,\ Fukuoka",
"819977", "Setouchi\,\ Kagoshima",
"81281", "Utsunomiya\,\ Tochigi",
"81734", "Wakayama\,\ Wakayama",
"819803", "Nago\,\ Okinawa",
"812375", "Murayama\,\ Yamagata",
"812839", "Sano\,\ Tochigi",
"81929", "Fukuoka\,\ Fukuoka",
"817732", "Fukuchiyama\,\ Kyoto",
"817998", "Tsuna\,\ Hyogo",
"8144", "Kawasaki\,\ Kanagawa",
"811583", "Monbetsu\,\ Hokkaido",
"81427", "Sagamihara\,\ Kanagawa",
"81833", "Kudamatsu\,\ Yamaguchi",
"817943", "Kakogawa\,\ Hyogo",
"817737", "Maizuru\,\ Kyoto",
"81548", "Haibara\,\ Shizuoka",
"814705", "Tateyama\,\ Chiba",
"817718", "Sonobe\,\ Kyoto",
"818698", "Bizen\,\ Okayama",
"81925", "Fukuoka\,\ Fukuoka",
"818512", "Nishigo\,\ Fukushima",
"812657", "Ina\,\ Nagano",
"812748", "Tomioka\,\ Gunma",
"81962", "Kumamoto\,\ Kumamoto",
"815755", "Sekigahara\,\ Gifu",
"812896", "Kanuma\,\ Tochigi",
"811644", "Rumoi\,\ Hokkaido",
"81956", "Sasebo\,\ Nagasaki",
"812692", "Nakano\,\ Nagano",
"812913", "Hokota\,\ Ibaraki",
"818245", "Miyoshi\,\ Hiroshima",
"818584", "Kurayoshi\,\ Tottori",
"81898", "Imabari\,\ Ehime",
"811934", "Kamaishi\,\ Iwate",
"819964", "Satsumasendai\,\ Kagoshima",
"812489", "Sukagawa\,\ Fukushima",
"818873", "Aki\,\ Kochi",
"817498", "Nagahama\,\ Shiga",
"81236", "Yamagata\,\ Yamagata",
"812385", "Yonezawa\,\ Yamagata",
"8152", "Nagoya\,\ Aichi",
"817615", "Komatsu\,\ Ishikawa",
"818567", "Tsuwano\,\ Shimane",
"811867", "Takanosu\,\ Akita",
"8125482", "Murakami\,\ Niigata",
"819596", "Fukue\,\ Nagasaki",
"818292", "Hiroshima\,\ Hiroshima",
"811367", "Suttsu\,\ Hokkaido",
"812935", "Mito\,\ Ibaraki",
"812580", "Tokamachi\,\ Niigata",
"818373", "Nagato\,\ Yamaguchi",
"811978", "Kitakami\,\ Iwate",
"81286", "Utsunomiya\,\ Tochigi",
"817356", "Kushimoto\,\ Wakayama",
"812998", "Itako\,\ Ibaraki",
"81949", "Nogata\,\ Fukuoka",
"81234", "Sakata\,\ Yamagata",
"812854", "Oyama\,\ Tochigi",
"818547", "Kakeya\,\ Shimane",
"817725", "Miyazu\,\ Kyoto",
"81268", "Ueda\,\ Nagano",
"815767", "Gero\,\ Gifu",
"81284", "Ashikaga\,\ Tochigi",
"8186996", "Seto\,\ Okayama",
"812235", "Sendai\,\ Miyagi",
"818957", "Misho\,\ Ehime",
"817963", "Toyooka\,\ Hyogo",
"8164", "Osaka\,\ Osaka",
"815997", "Ago\,\ Mie",
"8198299", "Hyuga\,\ Miyazaki",
"811876", "Omagari\,\ Akita",
"819554", "Imari\,\ Saga",
"818555", "Gotsu\,\ Shimane",
"818679", "Niimi\,\ Okayama",
"814297", "Hanno\,\ Saitama",
"811855", "Noshiro\,\ Akita",
"811376", "Yakumo\,\ Hokkaido",
"81828", "Hiroshima\,\ Hiroshima",
"811524", "Abashiri\,\ Hokkaido",
"811234", "Chitose\,\ Hokkaido",
"814755", "Togane\,\ Chiba",
"8153970", "Hamamatsu\,\ Shizuoka",
"819825", "Hyuga\,\ Miyazaki",
"814776", "Funabashi\,\ Chiba",
"819944", "Kanoya\,\ Kagoshima",
"818945", "Yawatahama\,\ Ehime",
"81192", "Ofunato\,\ Iwate",
"815586", "Shimoda\,\ Shizuoka",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;