# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20220305001842;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              496|
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{ja} = {"811878", "大曲",
"8126177", "長野",
"81534", "浜松",
"818955", "宇和島",
"819945", "鹿屋",
"812917", "水戸",
"812239", "仙台",
"815763", "下呂",
"812787", "沼田",
"811582", "紋別",
"819936", "加世田",
"812566", "三条",
"811456", "門別富川",
"817687", "能都",
"814796", "八日市場",
"8186552", "倉敷",
"818553", "浜田",
"811363", "倶知安",
"814297", "飯能",
"811528", "美幌",
"81542", "静岡",
"819733", "日田",
"812997", "潮来",
"8198293", "延岡",
"819543", "武雄",
"8198295", "日向",
"81174", "蟹田",
"818895", "須崎",
"815582", "下田",
"812780", "前橋",
"819827", "高千穂",
"818948", "宇和",
"817612", "小松",
"815363", "新城",
"81142", "伊達",
"81553", "山梨",
"812387", "長井",
"819802", "南大東",
"81480", "久喜",
"814282", "青梅",
"81928", "福岡",
"812857", "真岡",
"81423", "国分寺",
"819232", "前原",
"812792", "渋川",
"814228", "武蔵野三鷹",
"818384", "萩",
"812484", "白河",
"81956", "佐世保",
"817734", "福知山",
"819577", "島原",
"81134", "小樽",
"818266", "千代田",
"814756", "東金",
"818954", "宇和島",
"8163", "大阪",
"81964", "松橋",
"819944", "鹿屋",
"8199331", "鹿児島",
"811866", "鷹巣",
"812957", "大子",
"81220", "迫",
"818586", "倉吉",
"818593", "米子",
"815978", "熊野",
"81877", "丸亀",
"818848", "牟岐",
"819679", "高森",
"812890", "宇都宮",
"812578", "六日町",
"818360", "小郡",
"81432", "千葉",
"818464", "竹原",
"812897", "鹿沼",
"819663", "人吉",
"8167", "大阪",
"812672", "小諸",
"817943", "加古川",
"818367", "宇部",
"818894", "須崎",
"811557", "十勝池田",
"812646", "長野",
"812485", "白河",
"818385", "萩",
"817735", "福知山",
"819788", "国東",
"811978", "北上",
"819722", "佐伯",
"818265", "安芸吉田",
"814755", "東金",
"817678", "七尾",
"818549", "石見大田",
"818208", "久賀",
"811238", "栗山",
"815757", "郡上八幡",
"811865", "大館",
"818585", "倉吉",
"812879", "烏山",
"818838", "阿波池田",
"81721", "富田林",
"817230", "寝屋川",
"812658", "伊那",
"81566", "刈谷",
"81468", "横須賀",
"819682", "山鹿",
"818793", "三本松",
"818567", "津和野",
"811357", "岩内",
"819432", "八女",
"811952", "二戸",
"81857", "鳥取",
"81963", "熊本",
"814794", "銚子",
"81729", "八尾",
"8125489", "津川",
"81948", "飯塚",
"819934", "指宿",
"812564", "三条",
"811454", "鵡川",
"81284", "足利",
"811643", "石狩深川",
"8124196", "柳津",
"812378", "寒河江",
"818478", "東城",
"819205", "厳原",
"8112391", "夕張",
"815952", "上野",
"812413", "喜多方",
"812645", "木曾福島",
"812486", "須賀川",
"817736", "舞鶴",
"811462", "浦河",
"812552", "上越",
"811757", "野辺地",
"818292", "広島",
"81166", "旭川",
"81487", "浦和",
"8165", "大阪",
"818584", "倉吉",
"812963", "下館",
"81936", "北九州",
"811397", "奥尻",
"811864", "大館",
"81227", "仙台",
"819972", "種子島",
"8186999", "岡山瀬戸",
"819743", "三重",
"812618", "大町",
"817907", "播磨山崎",
"81725", "和泉",
"818956", "宇和島",
"812587", "長岡",
"817718", "園部",
"818264", "安芸吉田",
"814754", "茂原",
"819946", "鹿屋",
"818673", "福渡",
"819935", "加世田",
"812565", "三条",
"811455", "鵡川",
"814795", "銚子",
"815563", "鰍沢青柳",
"81533", "豊橋",
"819599", "大瀬戸",
"8178", "神戸",
"812698", "飯山",
"815987", "三瀬谷",
"818896", "須崎",
"81240", "磐城富岡",
"811563", "本別",
"812644", "木曾福島",
"81424", "武蔵野三鷹",
"81294", "常陸太田",
"811987", "遠野",
"819204", "郷ノ浦",
"811852", "男鹿",
"817702", "敦賀",
"818466", "木江",
"8183767", "下関",
"817473", "五条",
"812979", "竜ケ崎",
"81554", "大月",
"815397", "浜松",
"81892", "久万",
"815992", "鳥羽",
"812580", "十日町",
"817959", "三田",
"818669", "総社",
"817727", "峰山",
"8147957", "八日市場",
"812998", "潮来",
"811527", "美幌",
"814298", "飯能",
"817688", "能都",
"81742", "奈良",
"812788", "前橋",
"814220", "国分寺",
"818656", "笠岡",
"817966", "八鹿",
"814703", "館山",
"812836", "佐野",
"81947", "田川",
"818973", "新居浜",
"8198291", "延岡",
"811734", "五所川原",
"819672", "熊本一の宮",
"81467", "藤沢",
"811544", "釧路",
"811877", "大曲",
"81734", "和歌山",
"819578", "島原",
"8153977", "天竜",
"8186998", "岡山瀬戸",
"814227", "武蔵野三鷹",
"81549", "静岡",
"812679", "佐久",
"812858", "真岡",
"8186697", "倉敷",
"81862", "岡山",
"815734", "恵那",
"81586", "一宮",
"812388", "長井",
"81488", "浦和",
"817456", "大和高田",
"819957", "加治木",
"818947", "宇和",
"818243", "東広島",
"817363", "和歌山橋本",
"819828", "高千穂",
"81983", "高鍋",
"818376", "美祢",
"812476", "三春",
"81774", "宇治",
"812232", "岩沼",
"818683", "津山",
"818696", "備前",
"812577", "六日町",
"811943", "岩泉",
"81228", "築館",
"811652", "士別",
"811536", "厚岸",
"8199347", "鹿児島",
"818847", "牟岐",
"811735", "五所川原",
"815977", "熊野",
"811545", "釧路",
"81471", "柏",
"81596", "伊勢",
"811589", "興部",
"81439", "木更津",
"81196", "盛岡",
"817496", "長浜",
"817483", "八日市",
"811977", "北上",
"812543", "新発田",
"811372", "鹿部",
"815735", "恵那",
"819787", "国東",
"815589", "修善寺大仁",
"812936", "水戸",
"818873", "安芸",
"812570", "小出",
"818368", "宇部",
"811558", "広尾",
"81545", "富士",
"812799", "長野原",
"814281", "相模原",
"8125488", "津川",
"815746", "美濃加茂",
"812898", "鹿沼",
"819809", "八重山",
"814289", "青梅",
"818695", "岡山瀬戸",
"819979", "徳之島",
"811535", "厚岸",
"818568", "津和野",
"81460", "小田原",
"811736", "五所川原",
"8188094", "窪川",
"812657", "伊那",
"818837", "阿波池田",
"811546", "釧路",
"815758", "郡上八幡",
"818654", "鴨方",
"817964", "豊岡",
"81276", "太田",
"812834", "宇都宮",
"811933", "釜石",
"811237", "栗山",
"81940", "宗像",
"819592", "大瀬戸",
"818207", "久賀",
"81766", "高岡",
"812242", "白石",
"817677", "七尾",
"8112395", "栗山",
"8112393", "夕張",
"817495", "長浜",
"81722", "堺",
"817238", "寝屋川",
"815736", "中津川",
"812935", "水戸",
"811336", "石狩",
"817357", "串本",
"818662", "高梁",
"817952", "西脇",
"812474", "石川",
"818374", "長門",
"819963", "川内",
"815999", "津",
"81236", "山形",
"815745", "美濃加茂",
"817454", "大和高田",
"812377", "寒河江",
"818477", "東城",
"81927", "福岡",
"812972", "水海道",
"812743", "藤岡",
"811534", "中標津",
"815988", "三瀬谷",
"812697", "飯山",
"81878", "高松",
"812872", "大田原",
"819552", "伊万里",
"81899", "松山",
"818694", "岡山",
"818542", "安来",
"818655", "鴨方",
"817965", "豊岡",
"812835", "佐野",
"817717", "園部",
"812588", "長岡",
"817908", "播磨山崎",
"812617", "大町",
"811398", "熊石",
"81885", "小松島",
"817992", "洲本",
"818803", "土佐中村",
"81263", "松本",
"817728", "峰山",
"812934", "高萩",
"81984", "小林",
"8188096", "土佐清水",
"81125", "滝川",
"817494", "彦根",
"815398", "浜松",
"8125480", "村上",
"815959", "亀山",
"815744", "美濃加茂",
"817455", "大和高田",
"817912", "相生",
"812551", "上越",
"818299", "広島",
"812475", "石川",
"818375", "美祢",
"812559", "安塚",
"8183766", "下関",
"818698", "備前",
"812640", "長野",
"815984", "松阪",
"811538", "根室標津",
"81543", "静岡",
"81568", "春日井",
"819723", "佐伯",
"818565", "益田",
"818249", "東広島",
"8111", "札幌",
"812673", "小諸",
"817942", "加古川",
"8182941", "広島",
"811394", "松前",
"811867", "鷹巣",
"812956", "常陸大宮",
"818587", "郡家",
"81466", "藤沢",
"81989", "那覇",
"819662", "人吉",
"81827", "岩国",
"815755", "関",
"812584", "長岡",
"818267", "千代田",
"81946", "甘木",
"814757", "東金",
"81270", "伊勢崎",
"817904", "福崎",
"8198298", "日向",
"817498", "長浜",
"815394", "浜松",
"81587", "一宮",
"814709", "鴨川",
"818512", "西郷",
"812938", "水戸",
"817724", "宮津",
"81292", "水戸",
"814701", "鴨川",
"812647", "長野",
"8162", "大阪",
"811632", "天塩",
"818366", "宇部",
"811556", "帯広",
"815748", "美濃白川",
"812896", "鹿沼",
"811984", "花巻",
"81143", "室蘭",
"818592", "米子",
"81552", "甲府",
"8112399", "栗山",
"815985", "松阪",
"814283", "青梅",
"81985", "宮崎",
"819803", "名護",
"81938", "北九州",
"818564", "益田",
"811354", "余市",
"812996", "潮来",
"81124", "芦別",
"812786", "沼田",
"812793", "渋川",
"819937", "加世田",
"819233", "前原",
"812567", "巻",
"811457", "門別富川",
"8124197", "柳津",
"817686", "能都",
"814797", "八日市場",
"81433", "千葉",
"812838", "佐野",
"817968", "浜坂",
"815754", "関",
"81282", "栃木",
"815583", "下田",
"817905", "福崎",
"818879", "室戸",
"812585", "長岡",
"817613", "小松",
"815362", "新城",
"812549", "津川",
"811395", "江差",
"817725", "宮津",
"819576", "島原",
"811583", "紋別",
"811754", "むつ",
"819542", "武雄",
"815395", "浜松",
"812386", "長井",
"818493", "尾道",
"811362", "倶知安",
"818552", "浜田",
"814992", "伊豆大島",
"819732", "日田",
"812856", "真岡",
"81473", "市川",
"817458", "大和榛原",
"818689", "岡山",
"819826", "日向",
"815762", "下呂",
"812560", "糸魚川",
"818378", "下関",
"812478", "三春",
"8125481", "村上",
"815986", "松阪",
"815993", "鳥羽",
"819969", "中甑",
"812995", "石岡",
"81962", "熊本",
"812785", "沼田",
"8198290", "延岡",
"817685", "輪島",
"819947", "志布志",
"81277", "桐生",
"81434", "千葉",
"817906", "播磨山崎",
"818957", "御荘",
"812586", "長岡",
"811562", "本別",
"8164", "大阪",
"817472", "五条",
"811853", "男鹿",
"811396", "江差",
"81775", "大津",
"817703", "敦賀",
"817726", "峰山",
"815562", "鰍沢青柳",
"811939", "宮古",
"819575", "諫早",
"814771", "市川",
"819940", "志布志",
"815396", "浜松",
"812385", "米沢",
"812855", "小山",
"819742", "三重",
"81474", "船橋",
"819973", "種子島",
"811986", "遠野",
"812962", "下館",
"81926", "福岡",
"818467", "木江",
"812894", "宇都宮",
"818672", "福渡",
"819825", "日向",
"81958", "長崎",
"818364", "宇部",
"811554", "帯広",
"811463", "浦河",
"812553", "上越",
"81250", "新津",
"817684", "輪島",
"81532", "豊橋",
"812784", "沼田",
"81798", "西宮",
"818293", "廿日市",
"81779", "大野",
"811356", "岩内",
"812994", "石岡",
"815953", "上野",
"811738", "鰺ケ沢",
"81172", "弘前",
"812412", "喜多方",
"81544", "富士宮",
"811548", "弟子屈",
"812955", "常陸大宮",
"815756", "郡上八幡",
"812914", "鉾田",
"81144", "苫小牧",
"815738", "中津川",
"812854", "小山",
"819683", "山鹿",
"818792", "三本松",
"81572", "多治見",
"819433", "八女",
"812384", "米沢",
"811953", "二戸",
"81893", "大洲",
"819574", "諫早",
"811642", "石狩深川",
"812487", "須賀川",
"818387", "田万川",
"817737", "舞鶴",
"81739", "田辺",
"811756", "野辺地",
"819824", "延岡",
"818365", "宇部",
"811555", "帯広",
"812895", "宇都宮",
"81559", "沼津",
"812614", "大町",
"814758", "東金",
"817675", "七尾",
"817714", "亀岡",
"818268", "千代田",
"812930", "水戸",
"811235", "夕張",
"818205", "柳井",
"818588", "郡家",
"8188097", "土佐清水",
"811868", "鷹巣",
"812655", "飯田",
"818835", "脇町",
"812542", "新発田",
"8182943", "広島",
"818846", "丹生谷",
"81429", "所沢",
"817482", "八日市",
"811537", "中標津",
"812694", "中野",
"81551", "韮崎",
"818872", "室戸",
"812576", "十日町",
"8188092", "窪川",
"818697", "備前",
"81743", "奈良",
"819208", "対馬佐賀",
"812375", "村山",
"818475", "府中",
"818559", "川本",
"815747", "美濃白川",
"8186993", "備前",
"8186995", "岡山瀬戸",
"818690", "岡山",
"817355", "新宮",
"812648", "長野",
"8112390", "夕張",
"811942", "岩泉",
"818682", "津山",
"819786", "杵築",
"815769", "荘川",
"812233", "岩沼",
"812937", "水戸",
"811976", "北上",
"811653", "士別",
"81863", "玉野",
"81848", "尾道",
"817497", "長浜",
"818242", "東広島",
"811876", "大曲",
"81425", "立川",
"812654", "飯田",
"818834", "鴨島",
"81930", "行橋",
"817674", "羽咋",
"817715", "亀岡",
"81797", "西宮",
"812615", "大町",
"811234", "千歳",
"818204", "柳井",
"817362", "和歌山橋本",
"818657", "笠岡",
"817967", "八鹿",
"812837", "佐野",
"814798", "八日市場",
"812568", "巻",
"819938", "加世田",
"81992", "鹿児島",
"81555", "吉田",
"811526", "網走",
"817949", "加古川",
"812695", "中野",
"812477", "三春",
"818377", "下関",
"818972", "新居浜",
"81246", "いわき",
"814702", "館山",
"817354", "新宮",
"818946", "宇和",
"819673", "熊本一の宮",
"81724", "岸和田貝塚",
"818474", "府中",
"812374", "村山",
"819956", "加治木",
"817457", "大和高田",
"8153962", "天竜",
"817960", "八鹿",
"81281", "宇都宮",
"812830", "宇都宮",
"814226", "武蔵野三鷹",
"8125483", "村上",
"811639", "利尻礼文",
"8125485", "津川",
"811875", "角館",
"815974", "尾鷲",
"81567", "津島",
"817716", "園部",
"818958", "御荘",
"812616", "大町",
"818391", "小郡",
"819948", "志布志",
"812574", "柏崎",
"818802", "窪川",
"817993", "洲本",
"81828", "広島",
"818844", "阿南",
"811525", "網走",
"81188", "秋田",
"812419", "田島",
"812696", "飯山",
"8112398", "栗山",
"818945", "八幡浜",
"81535", "浜松",
"819955", "加治木",
"81167", "富良野",
"812873", "大田原",
"811974", "水沢",
"81723", "堺",
"81969", "天草",
"81486", "浦和",
"818543", "安来",
"814225", "武蔵野三鷹",
"8153974", "天竜",
"819553", "伊万里",
"81950", "平戸",
"819784", "豊後高田",
"813", "東京",
"817676", "七尾",
"81744", "大和高田",
"811236", "千歳",
"818663", "総社",
"817953", "西脇",
"818206", "柳井",
"811874", "角館",
"81937", "北九州",
"812742", "藤岡",
"811547", "白糠",
"812973", "水海道",
"811737", "鰺ケ沢",
"819962", "川内",
"81226", "気仙沼",
"812656", "伊那",
"818836", "脇町",
"811524", "網走",
"818845", "丹生谷",
"812575", "十日町",
"814240", "国分寺",
"81864", "倉敷",
"812376", "寒河江",
"818476", "府中",
"818944", "八幡浜",
"817463", "吉野",
"81965", "八代",
"819954", "加治木",
"812243", "白石",
"81977", "別府",
"814772", "市川",
"81179", "三戸",
"811337", "石狩",
"817356", "串本",
"81531", "田原",
"819593", "大瀬戸",
"811932", "釜石",
"814224", "武蔵野三鷹",
"81262", "長野",
"817738", "舞鶴",
"818388", "田万川",
"812488", "須賀川",
"819785", "豊後高田",
"818679", "新見",
"811975", "水沢",
"815737", "中津川",
"8198299", "日向",
"81183", "湯沢",
"812483", "白河",
"812619", "大町",
"818383", "萩",
"817733", "福知山",
"819437", "田主丸",
"811957", "岩手",
"81823", "呉",
"811352", "余市",
"818562", "益田",
"819687", "玉名",
"819665", "人吉",
"812416", "田島",
"817468", "上北山",
"817945", "加古川",
"8186691", "倉敷",
"812248", "大河原",
"81547", "島田",
"815752", "関",
"812550", "安塚",
"818290", "広島",
"819598", "福江",
"818554", "浜田",
"811364", "倶知安",
"814994", "三宅",
"819734", "日田",
"81986", "都城",
"8198297", "日向",
"818796", "土庄",
"819544", "武雄",
"81949", "直方",
"81728", "寝屋川",
"818297", "廿日市",
"812557", "新井",
"811752", "むつ",
"811646", "羽幌",
"811635", "浜頓別",
"8198292", "延岡",
"81583", "岐阜",
"815764", "下呂",
"818668", "井原",
"817958", "丹波柏原",
"818595", "米子",
"812978", "竜ケ崎",
"8186553", "倉敷",
"815957", "上野",
"812878", "烏山",
"815982", "松阪",
"812659", "伊那",
"818548", "石見大田",
"81593", "四日市",
"819558", "唐津",
"811566", "十勝清水",
"812582", "長岡",
"817902", "福崎",
"818893", "佐川",
"811392", "木古内",
"81253", "新潟",
"818463", "竹原",
"819664", "人吉",
"819977", "瀬戸内",
"817476", "下市",
"81764", "富山",
"817944", "加古川",
"818514", "海士",
"817998", "津名",
"817722", "宮津",
"815566", "身延",
"819735", "日田",
"818479", "東城",
"818555", "江津",
"811365", "倶知安",
"815997", "阿児",
"81832", "下関",
"81242", "会津若松",
"815392", "浜松",
"81465", "小田原",
"817707", "小浜",
"811857", "能代",
"818594", "米子",
"811982", "花巻",
"819746", "竹田",
"811634", "浜頓別",
"818953", "宇和島",
"815765", "下呂",
"819943", "鹿屋",
"81234", "酒田",
"818676", "久世",
"81763", "福野",
"812992", "石岡",
"81273", "高崎",
"81929", "福岡",
"815979", "熊野",
"817682", "輪島",
"812782", "沼田",
"811587", "中湧別",
"81594", "桑名",
"812579", "小出",
"812571", "六日町",
"81852", "松江",
"819678", "矢部",
"815366", "設楽",
"814280", "立川",
"817475", "下市",
"812414", "柳津",
"814793", "銚子",
"81233", "新庄",
"812797", "渋川",
"819933", "指宿",
"811453", "早来",
"812563", "三条",
"819572", "諫早",
"811644", "留萌",
"815565", "鰍沢青柳",
"8168", "大阪",
"812852", "小山",
"818794", "三本松",
"811366", "寿都",
"818556", "江津",
"814996", "八丈島",
"814287", "青梅",
"812382", "米沢",
"819807", "沖縄宮古",
"819546", "鹿島",
"812965", "下館",
"818490", "尾道",
"817617", "加賀",
"81482", "川口",
"819822", "延岡",
"815766", "下呂",
"819789", "杵築",
"815587", "修善寺大仁",
"818675", "久世",
"8175", "京都",
"812238", "仙台",
"81222", "仙台",
"81492", "川越",
"811658", "上川",
"819666", "水俣",
"81925", "福岡",
"8188099", "土佐清水",
"812415", "柳津",
"817946", "三木",
"817474", "五条",
"811564", "上士幌",
"812643", "木曾福島",
"8169", "大阪",
"81184", "本荘",
"818949", "宇和",
"811378", "今金",
"818795", "三本松",
"819727", "臼杵",
"81584", "大垣",
"815564", "鰍沢青柳",
"811645", "留萌",
"811552", "帯広",
"818362", "宇部",
"811636", "北見枝幸",
"818263", "加計",
"814753", "茂原",
"814229", "武蔵野三鷹",
"818674", "久世",
"818583", "倉吉",
"81776", "福井",
"812964", "下館",
"818596", "米子",
"812892", "宇都宮",
"81266", "諏訪",
"811863", "鹿角",
"812677", "佐久",
"819744", "三重",
"817364", "和歌山橋本",
"818202", "柳井",
"819597", "福江",
"811232", "千歳",
"81888", "高知",
"81835", "防府",
"81245", "福島",
"811333", "当別",
"817672", "羽咋",
"812247", "大河原",
"8166", "大阪",
"81934", "北九州",
"812652", "飯田",
"818832", "鴨島",
"819966", "出水",
"818244", "三次",
"812746", "富岡",
"817485", "八日市",
"819688", "玉名",
"815733", "恵那",
"81942", "久留米",
"812545", "村上",
"811958", "岩手",
"819438", "田主丸",
"81462", "厚木",
"818660", "岡山瀬戸",
"817950", "三田",
"818875", "土佐山田",
"812589", "長岡",
"815399", "天竜",
"815958", "亀山",
"81875", "観音寺",
"811733", "五所川原",
"81426", "八王子",
"811543", "釧路",
"812977", "竜ケ崎",
"818472", "甲山",
"812372", "村山",
"811936", "宮古",
"818667", "井原",
"817957", "丹波柏原",
"817352", "新宮",
"814704", "館山",
"814776", "船橋",
"818974", "新居浜",
"818685", "津山",
"812558", "新井",
"811945", "久慈",
"818298", "廿日市",
"8188098", "土佐清水",
"8147955", "八日市場",
"819978", "徳之島",
"818245", "三次",
"817365", "和歌山橋本",
"81564", "岡崎",
"812612", "大町",
"817712", "亀岡",
"81249", "郡山",
"81839", "山口",
"819557", "唐津",
"818806", "宿毛",
"818874", "安芸",
"818547", "掛合",
"81793", "姫路",
"81286", "宇都宮",
"812692", "中野",
"817484", "八日市",
"812544", "新発田",
"812877", "黒磯",
"814705", "館山",
"818975", "新居浜",
"8144", "川崎",
"817917", "竜野",
"811858", "能代",
"817239", "寝屋川",
"815998", "阿児",
"8199345", "鹿児島",
"8199343", "鹿児島",
"818684", "津山",
"817997", "津名",
"81898", "今治",
"811944", "岩泉",
"819964", "川内",
"8186994", "岡山瀬戸",
"81489", "草加",
"81740", "今津",
"817453", "大和高田",
"818246", "三次",
"812744", "藤岡",
"819677", "矢部",
"8112392", "夕張",
"817366", "岩出",
"812473", "石川",
"818373", "長門",
"818805", "土佐中村",
"811588", "興部",
"81548", "榛原",
"81563", "西尾",
"811522", "斜里",
"8112397", "栗山",
"817963", "豊岡",
"812833", "宇都宮",
"814706", "大原",
"811934", "釜石",
"815588", "修善寺大仁",
"81727", "池田",
"8188090", "窪川",
"818976", "新居浜",
"8125486", "津川",
"81225", "石巻",
"817618", "加賀",
"819952", "大口",
"81495", "本庄",
"818942", "八幡浜",
"812899", "鹿沼",
"819808", "八重山",
"814288", "青梅",
"811551", "十勝池田",
"814222", "武蔵野三鷹",
"81922", "福岡",
"812798", "長野原",
"811559", "帯広",
"818369", "宇部",
"812789", "前橋",
"815743", "美濃加茂",
"815972", "尾鷲",
"814291", "飯能",
"819965", "川内",
"812745", "藤岡",
"812999", "潮来",
"81485", "熊谷",
"817493", "彦根",
"817486", "水口",
"81438", "木更津",
"818842", "阿南",
"8153960", "天竜",
"812546", "村上",
"81176", "十和田",
"818804", "土佐中村",
"81933", "北九州",
"812237", "仙台",
"812933", "高萩",
"8125484", "村上",
"812572", "柏崎",
"818876", "土佐山田",
"812911", "鉾田",
"812678", "佐久",
"812389", "米沢",
"812859", "小山",
"811935", "釜石",
"814775", "船橋",
"812230", "仙台",
"819912", "中之島",
"818686", "津山",
"819782", "豊後高田",
"81478", "佐原",
"818693", "邑久",
"8186996", "岡山瀬戸",
"811946", "久慈",
"811533", "根室",
"81229", "古川",
"819728", "臼杵",
"811377", "八雲",
"811972", "水沢",
"819976", "名瀬",
"811983", "花巻",
"81157", "北見",
"81494", "秩父",
"819942", "大根占",
"811567", "十勝清水",
"818952", "宇和島",
"81182", "横手",
"818808", "土佐清水",
"817723", "宮津",
"811585", "遠軽",
"811541", "弟子屈",
"81822", "広島",
"815393", "浜松",
"811549", "釧路",
"815585", "下田",
"818677", "新見",
"812583", "長岡",
"81582", "岐阜",
"817903", "福崎",
"818892", "佐川",
"81427", "相模原",
"819747", "竹田",
"812674", "小諸",
"817615", "小松",
"818462", "竹原",
"811393", "松前",
"817706", "小浜",
"812967", "笠間",
"811856", "能代",
"815983", "松阪",
"815996", "阿児",
"8188091", "窪川",
"819724", "佐伯",
"814285", "相模原",
"819805", "名護",
"812795", "渋川",
"81557", "伊東",
"8153961", "天竜",
"812417", "会津山口",
"81252", "新潟",
"819968", "出水",
"812748", "富岡",
"811956", "岩手",
"819686", "玉名",
"81592", "津",
"811584", "遠軽",
"818397", "小郡",
"811753", "むつ",
"81738", "御坊",
"817614", "小松",
"815956", "上野",
"812675", "佐久",
"815753", "関",
"81192", "大船渡",
"815584", "下田",
"811938", "宮古",
"81484", "川口",
"811647", "羽幌",
"812794", "渋川",
"818296", "広島",
"812556", "糸魚川",
"817732", "福知山",
"811466", "えりも",
"812482", "白河",
"818382", "萩",
"819725", "佐伯",
"814284", "立川",
"81268", "上田",
"819804", "名護",
"81833", "下松",
"818797", "土庄",
"81243", "二本松",
"818563", "益田",
"811353", "余市",
"81778", "武生",
"81853", "出雲",
"811553", "帯広",
"818363", "宇部",
"814752", "茂原",
"81975", "大分",
"818262", "加計",
"817947", "三木",
"819974", "屋久島",
"819667", "水俣",
"818582", "倉吉",
"811862", "鹿角",
"812893", "宇都宮",
"81762", "金沢",
"817488", "水口",
"81272", "前橋",
"819435", "八女",
"811955", "二戸",
"819685", "玉名",
"812839", "佐野",
"817969", "浜坂",
"818878", "嶺北",
"815955", "上野",
"81834", "徳山",
"81244", "原町",
"812676", "佐久",
"81420", "所沢",
"811854", "男鹿",
"818597", "根雨",
"81988", "那覇",
"81935", "北九州",
"817704", "敦賀",
"812642", "木曾福島",
"811637", "北見枝幸",
"81561", "瀬戸",
"81726", "茨木",
"818688", "美作",
"81550", "御殿場",
"818295", "廿日市",
"811465", "静内",
"812555", "糸魚川",
"817459", "大和榛原",
"819726", "臼杵",
"81569", "半田",
"815994", "阿児",
"8198294", "延岡",
"817940", "加古川",
"815367", "設楽",
"819975", "名瀬",
"811539", "根室標津",
"81537", "掛川",
"818248", "庄原",
"819823", "延岡",
"817368", "岩出",
"8198296", "日向",
"819573", "諫早",
"8183768", "下関",
"81177", "青森",
"81979", "中津",
"814792", "銚子",
"819932", "指宿",
"81493", "東松山",
"811452", "早来",
"812562", "三条",
"811586", "中湧別",
"812853", "小山",
"81280", "古河",
"819684", "山鹿",
"819434", "八女",
"812383", "米沢",
"811954", "二戸",
"81998", "鹿児島",
"812939", "水戸",
"815767", "下呂",
"815586", "下田",
"814708", "大原",
"812913", "鉾田",
"81577", "高山",
"818978", "伯方",
"815954", "上野",
"81565", "豊田",
"817616", "小松",
"817705", "小浜",
"811855", "能代",
"815995", "阿児",
"819547", "鹿島",
"81939", "北九州",
"819737", "玖珠",
"812993", "石岡",
"818557", "川本",
"811367", "寿都",
"814286", "相模原",
"819806", "沖縄宮古",
"812554", "上越",
"811464", "静内",
"817683", "輪島",
"812783", "沼田",
"812796", "渋川",
"818294", "廿日市",
"812876", "黒磯",
"811654", "名寄",
"8112394", "夕張",
"818546", "掛合",
"81463", "平塚",
"812234", "仙台",
"81581", "高富",
"819556", "唐津",
"818807", "宿毛",
"8186992", "備前",
"8186698", "倉敷",
"81546", "静岡",
"8186997", "岡山瀬戸",
"819675", "熊本一の宮",
"817996", "津名",
"81987", "日南",
"811374", "森",
"812693", "中野",
"81952", "佐賀",
"817916", "竜野",
"812968", "笠間",
"8188093", "窪川",
"8188095", "土佐清水",
"8182942", "広島",
"812613", "大町",
"812489", "須賀川",
"817713", "亀岡",
"818678", "新見",
"818398", "小郡",
"81191", "一関",
"8125487", "津川",
"819949", "大根占",
"8153963", "天竜",
"814770", "市川",
"812235", "仙台",
"81538", "磐田",
"81792", "姫路",
"81585", "揖斐川",
"8161", "大阪",
"8145", "横浜",
"811655", "名寄",
"812747", "富岡",
"819674", "熊本一の宮",
"811542", "釧路",
"812373", "村山",
"818473", "甲山",
"8125482", "村上",
"81199", "盛岡",
"81436", "市原",
"819967", "出水",
"817466", "十津川",
"811732", "五所川原",
"812418", "会津山口",
"8152", "名古屋",
"812246", "大河原",
"819596", "福江",
"81178", "八戸",
"817353", "新宮",
"815732", "恵那",
"811375", "八雲",
"818798", "土庄",
"8128798", "大田原",
"81578", "神岡",
"811648", "焼尻",
"817673", "羽咋",
"81924", "福岡",
"814777", "船橋",
"8112396", "栗山",
"811233", "千歳",
"81476", "成田",
"811937", "宮古",
"817956", "三田",
"818666", "井原",
"81591", "津",
"81825", "広島",
"818203", "柳井",
"811332", "当別",
"81259", "佐渡",
"812976", "竜ケ崎",
"81260", "阿南町",
"812653", "飯田",
"818833", "鴨島",
"81138", "函館",
"818544", "木次",
"818877", "嶺北",
"819554", "伊万里",
"81562", "尾張横須賀",
"81886", "徳島",
"818692", "邑久",
"819783", "豊後高田",
"812236", "仙台",
"812874", "大田原",
"811973", "水沢",
"812547", "村上",
"811532", "根室",
"81849", "福山",
"817487", "水口",
"811656", "美深",
"81126", "岩見沢",
"819668", "水俣",
"817948", "三木",
"817465", "吉野",
"812569", "巻",
"818680", "岡山",
"812245", "大河原",
"819913", "硫黄島",
"819595", "有川",
"818843", "阿南",
"811376", "八雲",
"817492", "彦根",
"81298", "土浦",
"812573", "柏崎",
"811947", "久慈",
"8147950", "八日市場",
"817994", "洲本",
"81923", "福岡",
"812932", "高萩",
"818687", "美作",
"81162", "稚内",
"811638", "利尻礼文",
"818665", "高梁",
"817955", "三田",
"812975", "水海道",
"817914", "相生",
"818598", "根雨",
"815973", "尾鷲",
"815742", "美濃加茂",
"811869", "大館",
"812875", "大田原",
"814223", "武蔵野三鷹",
"81932", "北九州",
"818545", "木次",
"814700", "鴨川",
"8182920", "廿日市",
"819555", "唐津",
"812244", "白石",
"81464", "厚木",
"81737", "湯浅",
"818652", "倉敷",
"817962", "豊岡",
"812832", "佐野",
"819594", "有川",
"817367", "岩出",
"818247", "庄原",
"818943", "八幡浜",
"819676", "高森",
"81944", "瀬高",
"817464", "吉野",
"81288", "今市",
"81235", "鶴岡",
"81845", "因島",
"815368", "設楽",
"819953", "大口",
"817995", "洲本",
"812649", "長野",
"811523", "斜里",
"814998", "小笠原",
"818558", "川本",
"819738", "玖珠",
"818240", "東広島",
"817915", "相生",
"811873", "角館",
"812974", "水海道",
"817452", "大和高田",
"818977", "伯方",
"812472", "石川",
"818372", "長門",
"81765", "魚津",
"81896", "伊予三島",
"814707", "大原",
"817954", "西脇",
"818664", "高梁",
"815768", "下呂",};
$areanames{en} = {"811982", "Hanamaki\,\ Iwate",
"818594", "Yonago\,\ Tottori",
"811857", "Noshiro\,\ Akita",
"817707", "Obama\,\ Fukui",
"817735", "Fukuchiyama\,\ Kyoto",
"81465", "Odawara\,\ Kanagawa",
"812485", "Shirakawa\,\ Fukushima",
"818385", "Hagi\,\ Yamaguchi",
"819788", "Kunisaki\,\ Oita",
"819746", "Taketa\,\ Oita",
"811978", "Kitakami\,\ Iwate",
"818953", "Uwajima\,\ Ehime",
"811634", "Hamatonbetsu\,\ Hokkaido",
"818676", "Kuse\,\ Okayama",
"819722", "Saiki\,\ Oita",
"81234", "Sakata\,\ Yamagata",
"819943", "Kanoya\,\ Kagoshima",
"815765", "Gero\,\ Gifu",
"819663", "Hitoyoshi\,\ Kumamoto",
"818464", "Takehara\,\ Hiroshima",
"812897", "Kanuma\,\ Tochigi",
"817943", "Kakogawa\,\ Hyogo",
"815566", "Minobu\,\ Yamanashi",
"817722", "Miyazu\,\ Kyoto",
"817998", "Tsuna\,\ Hyogo",
"812672", "Komoro\,\ Nagano",
"818514", "Ama\,\ Shimane",
"8167", "Osaka\,\ Osaka",
"818367", "Ube\,\ Yamaguchi",
"818894", "Susaki\,\ Kochi",
"818555", "Gotsu\,\ Shimane",
"811365", "Kutchan\,\ Hokkaido",
"818479", "Tojo\,\ Hiroshima",
"819735", "Hita\,\ Oita",
"81242", "Aizuwakamatsu\,\ Fukushima",
"81832", "Shimonoseki\,\ Yamaguchi",
"815392", "Hamamatsu\,\ Shizuoka",
"812646", "Nagano\,\ Nagano",
"815997", "Ago\,\ Mie",
"818893", "Sakawa\,\ Kochi",
"817902", "Fukusaki\,\ Hyogo",
"819679", "Takamori\,\ Kumamoto",
"812582", "Nagaoka\,\ Niigata",
"812890", "Utsunomiya\,\ Tochigi",
"819664", "Hitoyoshi\,\ Kumamoto",
"818463", "Takehara\,\ Hiroshima",
"812578", "Muika\,\ Niigata",
"81253", "Niigata\,\ Niigata",
"811392", "Kikonai\,\ Hokkaido",
"817944", "Kakogawa\,\ Hyogo",
"81432", "Chiba\,\ Chiba",
"818360", "Ogori\,\ Yamaguchi",
"81764", "Toyama\,\ Toyama",
"817476", "Shimonoseki\,\ Yamaguchi",
"819977", "Setouchi\,\ Kagoshima",
"818954", "Uwajima\,\ Ehime",
"814756", "Togane\,\ Chiba",
"812878", "Nasukarasuyama\,\ Tochigi",
"819944", "Kanoya\,\ Kagoshima",
"812659", "Ina\,\ Nagano",
"815982", "Matsusaka\,\ Mie",
"8163", "Osaka\,\ Osaka",
"818593", "Yonago\,\ Tottori",
"818586", "Kurayoshi\,\ Tottori",
"811866", "Takanosu\,\ Akita",
"812957", "Daigo\,\ Ibaraki",
"8199331", "Kagoshima\,\ Kagoshima",
"81877", "Marugame\,\ Kagawa",
"819558", "Karatsu\,\ Saga",
"815978", "Kumano\,\ Mie",
"81593", "Yokkaichi\,\ Mie",
"812857", "Mooka\,\ Tochigi",
"811635", "Hamatonbetsu\,\ Hokkaido",
"81928", "Fukuoka\,\ Fukuoka",
"814282", "Ome\,\ Tokyo",
"819802", "Minamidaito\,\ Okinawa",
"81480", "Kuki\,\ Saitama",
"812387", "Nagai\,\ Yamagata",
"818668", "Ibara\,\ Okayama",
"81583", "Gifu\,\ Gifu",
"815764", "Gero\,\ Gifu",
"8198292", "Nobeoka\,\ Miyazaki",
"81956", "Sasebo\,\ Nagasaki",
"817734", "Fukuchiyama\,\ Kyoto",
"812484", "Shirakawa\,\ Fukushima",
"818384", "Hagi\,\ Yamaguchi",
"812792", "Shibukawa\,\ Gunma",
"8126173", "Omachi\,\ Nagano",
"818595", "Yonago\,\ Tottori",
"8126175", "Omachi\,\ Nagano",
"81423", "Kokubunji\,\ Tokyo",
"819232", "Maebaru\,\ Fukuoka",
"81134", "Otaru\,\ Hokkaido",
"819577", "Shimabara\,\ Nagasaki",
"8186553", "Kurashiki\,\ Okayama",
"818796", "Tonosho\,\ Kagawa",
"819734", "Hita\,\ Oita",
"81986", "Miyakonojo\,\ Miyazaki",
"8198297", "Hyuga\,\ Miyazaki",
"818895", "Susaki\,\ Kochi",
"818554", "Hamada\,\ Shimane",
"811364", "Kutchan\,\ Hokkaido",
"819827", "Takachiho\,\ Miyazaki",
"815582", "Shimoda\,\ Shizuoka",
"812780", "Maebashi\,\ Gunma",
"819544", "Takeo\,\ Saga",
"818948", "Uwajima\,\ Ehime",
"811752", "Mutsu\,\ Aomori",
"818297", "Hatsukaichi\,\ Hiroshima",
"81728", "Neyagawa\,\ Osaka",
"81949", "Nogata\,\ Fukuoka",
"811646", "Haboro\,\ Hokkaido",
"81553", "Yamanashi\,\ Yamanashi",
"81142", "Date\,\ Hokkaido",
"815363", "Shinshiro\,\ Aichi",
"817612", "Komatsu\,\ Ishikawa",
"814796", "Yokaichiba\,\ Chiba",
"817687", "Noto\,\ Ishikawa",
"812566", "Sanjo\,\ Niigata",
"819936", "Kaseda\,\ Kagoshima",
"811582", "Monbetsu\,\ Hokkaido",
"819665", "Hitoyoshi\,\ Kumamoto",
"812787", "Numata\,\ Gunma",
"8126172", "Omachi\,\ Nagano",
"8186691", "Kurashiki\,\ Okayama",
"817945", "Kakogawa\,\ Hyogo",
"817468", "Kamikitayama\,\ Nara",
"8186552", "Kurashiki\,\ Okayama",
"812416", "Tajima\,\ Fukushima",
"812997", "Itako\,\ Ibaraki",
"819733", "Hita\,\ Oita",
"81542", "Shizuoka\,\ Shizuoka",
"81547", "Shimada\,\ Shizuoka",
"812248", "Ogawara\,\ Miyagi",
"811528", "Bihoro\,\ Hokkaido",
"811363", "Kutchan\,\ Hokkaido",
"818553", "Hamada\,\ Shimane",
"814297", "Hanno\,\ Saitama",
"819598", "Fukue\,\ Nagasaki",
"818290", "Hiroshima\,\ Hiroshima",
"81174", "Kanita\,\ Aomori",
"8153971", "Hamamatsu\,\ Shizuoka",
"819543", "Takeo\,\ Saga",
"8198295", "Hyuga\,\ Miyazaki",
"8198293", "Nobeoka\,\ Miyazaki",
"815752", "Sekigahara\,\ Gifu",
"812550", "Yasuzuka\,\ Niigata",
"817733", "Fukuchiyama\,\ Kyoto",
"812483", "Shirakawa\,\ Fukushima",
"818383", "Hagi\,\ Yamaguchi",
"812619", "Omachi\,\ Nagano",
"811878", "Omagari\,\ Akita",
"81183", "Yuzawa\,\ Akita",
"819687", "Tamana\,\ Kumamoto",
"818562", "Masuda\,\ Shimane",
"811352", "Yoichi\,\ Hokkaido",
"81823", "Kure\,\ Hiroshima",
"818955", "Uwajima\,\ Ehime",
"811957", "Iwate\,\ Iwate",
"81534", "Hamamatsu\,\ Shizuoka",
"819437", "Tanushimaru\,\ Fukuoka",
"815763", "Gero\,\ Gifu",
"812239", "Sendai\,\ Miyagi",
"812917", "Mito\,\ Ibaraki",
"819945", "Kanoya\,\ Kagoshima",
"814753", "Mobara\,\ Chiba",
"818263", "Kake\,\ Hiroshima",
"81554", "Otsuki\,\ Yamanashi",
"811552", "Obihiro\,\ Hokkaido",
"818362", "Ube\,\ Yamaguchi",
"815992", "Toba\,\ Mie",
"81892", "Kumakogen\,\ Ehime",
"818674", "Kuse\,\ Okayama",
"811863", "Kazuno\,\ Akita",
"81266", "Suwa\,\ Nagano",
"812892", "Utsunomiya\,\ Tochigi",
"812964", "Shimodate\,\ Ibaraki",
"818596", "Yonago\,\ Tottori",
"81776", "Fukui\,\ Fukui",
"818583", "Kurayoshi\,\ Tottori",
"819744", "Mie\,\ Oita",
"812677", "Saku\,\ Nagano",
"818669", "Soja\,\ Okayama",
"817959", "Sanda\,\ Hyogo",
"812580", "Tokamachi\,\ Niigata",
"811378", "Imakane\,\ Hokkaido",
"811563", "Honbetsu\,\ Hokkaido",
"818949", "Uwajima\,\ Ehime",
"818896", "Susaki\,\ Kochi",
"81294", "Hitachiota\,\ Ibaraki",
"819727", "Usuki\,\ Oita",
"818466", "Mima\,\ Tokushima",
"81584", "Ogaki\,\ Gifu",
"817702", "Tsuruga\,\ Fukui",
"811852", "Oga\,\ Akita",
"811987", "Tono\,\ Iwate",
"811645", "Rumoi\,\ Hokkaido",
"8183767", "Shimonoseki\,\ Yamaguchi",
"814795", "Choshi\,\ Chiba",
"811455", "Mukawa\,\ Hokkaido",
"81925", "Fukuoka\,\ Fukuoka",
"812565", "Sanjo\,\ Niigata",
"819935", "Kaseda\,\ Kagoshima",
"819666", "Minamata\,\ Kumamoto",
"817946", "Miki\,\ Hyogo",
"819599", "Oseto\,\ Nagasaki",
"81533", "Toyohashi\,\ Aichi",
"812415", "Yanaizu\,\ Fukushima",
"8188099", "Tosashimizu\,\ Kochi",
"8178", "Kobe\,\ Hyogo",
"811564", "Kamishihoro\,\ Hokkaido",
"812698", "Iiyama\,\ Nagano",
"81184", "Yurihonjo\,\ Akita",
"8169", "Osaka\,\ Osaka",
"811864", "Odate\,\ Akita",
"811397", "Okushiri\,\ Hokkaido",
"8175", "Kyoto\,\ Kyoto",
"81936", "Kitakyushu\,\ Fukuoka",
"812963", "Shimodate\,\ Ibaraki",
"818584", "Kurayoshi\,\ Tottori",
"819743", "Mie\,\ Oita",
"8186999", "Seto\,\ Okayama",
"81492", "Kawagoe\,\ Saitama",
"81222", "Sendai\,\ Miyagi",
"81227", "Sendai\,\ Miyagi",
"812238", "Sendai\,\ Miyagi",
"814754", "Mobara\,\ Chiba",
"817718", "Sonobe\,\ Kyoto",
"812587", "Nagaoka\,\ Niigata",
"818956", "Uwajima\,\ Ehime",
"81725", "Izumi\,\ Osaka",
"812618", "Omachi\,\ Nagano",
"811658", "Kamikawa\,\ Hokkaido",
"819946", "Kanoya\,\ Kagoshima",
"818292", "Hiroshima\,\ Hiroshima",
"812965", "Shimodate\,\ Ibaraki",
"811757", "Noheji\,\ Aomori",
"811462", "Urakawa\,\ Hokkaido",
"817736", "Maizuru\,\ Kyoto",
"812552", "Joetsu\,\ Niigata",
"812486", "Sukagawa\,\ Fukushima",
"817617", "Kaga\,\ Ishikawa",
"818490", "Onomichi\,\ Hiroshima",
"81166", "Asahikawa\,\ Hokkaido",
"818675", "Kuse\,\ Okayama",
"8165", "Osaka\,\ Osaka",
"819789", "Kitsuki\,\ Oita",
"815766", "Gero\,\ Gifu",
"819822", "Nobeoka\,\ Miyazaki",
"81482", "Kawaguchi\,\ Saitama",
"81487", "Urawa\,\ Saitama",
"812563", "Sanjo\,\ Niigata",
"811453", "Hayakita\,\ Hokkaido",
"819933", "Ibusuki\,\ Kagoshima",
"812378", "Sagae\,\ Yamagata",
"818478", "Tojo\,\ Hiroshima",
"81233", "Shinjo\,\ Yamagata",
"812797", "Shibukawa\,\ Gunma",
"8124196", "Yanaizu\,\ Fukushima",
"814793", "Choshi\,\ Chiba",
"8153969", "Hamamatsu\,\ Shizuoka",
"8168", "Osaka\,\ Osaka",
"812413", "Kitakata\,\ Fukushima",
"811644", "Rumoi\,\ Hokkaido",
"819572", "Isahaya\,\ Nagasaki",
"8112391", "Yubari\,\ Hokkaido",
"812382", "Yonezawa\,\ Yamagata",
"814287", "Ome\,\ Tokyo",
"811366", "Suttsu\,\ Hokkaido",
"818556", "Gotsu\,\ Shimane",
"812852", "Oyama\,\ Tochigi",
"819546", "Kashima\,\ Saga",
"811952", "Ninohe\,\ Iwate",
"819432", "Yame\,\ Fukuoka",
"811357", "Iwanai\,\ Hokkaido",
"818567", "Tsuwano\,\ Shimane",
"81594", "Kuwana\,\ Mie",
"819682", "Yamaga\,\ Kumamoto",
"81468", "Yokosuka\,\ Kanagawa",
"81857", "Tottori\,\ Tottori",
"812571", "Muika\,\ Niigata",
"81852", "Matsue\,\ Shimane",
"812564", "Sanjo\,\ Niigata",
"811454", "Mukawa\,\ Hokkaido",
"819934", "Ibusuki\,\ Kagoshima",
"81948", "Iizuka\,\ Fukuoka",
"8125489", "Tsugawa\,\ Niigata",
"81729", "Yao\,\ Osaka",
"81963", "Kumamoto\,\ Kumamoto",
"814794", "Choshi\,\ Chiba",
"812414", "Yanaizu\,\ Fukushima",
"817475", "Shimonoseki\,\ Yamaguchi",
"815366", "Shitara\,\ Aichi",
"814280", "Tachikawa\,\ Tokyo",
"81284", "Ashikaga\,\ Tochigi",
"81929", "Fukuoka\,\ Fukuoka",
"81273", "Takasaki\,\ Gunma",
"817678", "Nanao\,\ Ishikawa",
"814755", "Togane\,\ Chiba",
"812992", "Ishioka\,\ Ibaraki",
"81763", "Fukuno\,\ Toyama",
"815979", "Kumano\,\ Mie",
"811238", "Kuriyama\,\ Hokkaido",
"811587", "Nakayubetsu\,\ Hokkaido",
"812782", "Numata\,\ Gunma",
"812879", "Nasukarasuyama\,\ Tochigi",
"818585", "Kurayoshi\,\ Tottori",
"817682", "Wajima\,\ Ishikawa",
"811865", "Odate\,\ Akita",
"81566", "Kariya\,\ Aichi",
"812658", "Ina\,\ Nagano",
"817230", "Neyagawa\,\ Osaka",
"81721", "Tondabayashi\,\ Osaka",
"815998", "Ago\,\ Mie",
"812799", "Naganohara\,\ Gunma",
"8199343", "Kagoshima\,\ Kagoshima",
"81545", "Fuji\,\ Shizuoka",
"8199345", "Kagoshima\,\ Kagoshima",
"811558", "Hiroo\,\ Hokkaido",
"818368", "Ube\,\ Yamaguchi",
"81898", "Imabari\,\ Ehime",
"817997", "Tsuna\,\ Hyogo",
"815746", "Minokamo\,\ Gifu",
"8125488", "Tsugawa\,\ Niigata",
"818684", "Tsuyama\,\ Okayama",
"814281", "Sagamihara\,\ Kanagawa",
"811944", "Iwaizumi\,\ Iwate",
"814289", "Ome\,\ Tokyo",
"819809", "Yaeyama\ District\,\ Okinawa",
"812898", "Kanuma\,\ Tochigi",
"817483", "Yokaichi\,\ Shiga",
"817496", "Nagahama\,\ Shiga",
"814705", "Tateyama\,\ Chiba",
"81439", "Kisarazu\,\ Chiba",
"81196", "Morioka\,\ Iwate",
"815735", "Ena\,\ Gifu",
"811372", "Shikabe\,\ Hokkaido",
"818975", "Niihama\,\ Ehime",
"812543", "Shibata\,\ Niigata",
"811977", "Kitakami\,\ Iwate",
"812936", "Mito\,\ Ibaraki",
"819787", "Kunisaki\,\ Oita",
"8144", "Kawasaki\,\ Kanagawa",
"817239", "Neyagawa\,\ Osaka",
"818873", "Aki\,\ Kochi",
"811858", "Noshiro\,\ Akita",
"818806", "Sukumo\,\ Kochi",
"819557", "Karatsu\,\ Saga",
"815977", "Kumano\,\ Mie",
"811735", "Goshogawara\,\ Aomori",
"81839", "Yamaguchi\,\ Yamaguchi",
"81249", "Koriyama\,\ Fukushima",
"81596", "Ise\,\ Mie",
"818547", "Kakeya\,\ Shimane",
"81471", "Kashiwa\,\ Chiba",
"811545", "Kushiro\,\ Hokkaido",
"818874", "Aki\,\ Kochi",
"817484", "Yokaichi\,\ Shiga",
"812692", "Nakano\,\ Nagano",
"81286", "Utsunomiya\,\ Tochigi",
"81793", "Himeji\,\ Hyogo",
"812877", "Kuroiso\,\ Tochigi",
"811589", "Okoppe\,\ Hokkaido",
"812544", "Shibata\,\ Niigata",
"819978", "Tokunoshima\,\ Kagoshima",
"818696", "Bizen\,\ Okayama",
"818683", "Tsuyama\,\ Okayama",
"812232", "Iwanuma\,\ Miyagi",
"811943", "Iwaizumi\,\ Iwate",
"812577", "Muika\,\ Niigata",
"818245", "Miyoshi\,\ Hiroshima",
"8153968", "Hamamatsu\,\ Shizuoka",
"8199347", "Kagoshima\,\ Kagoshima",
"81564", "Okazaki\,\ Aichi",
"811536", "Akkeshi\,\ Hokkaido",
"811652", "Shibetsu\,\ Hokkaido",
"817712", "Kameoka\,\ Kyoto",
"812612", "Omachi\,\ Nagano",
"818685", "Tsuyama\,\ Okayama",
"8153972", "Hamamatsu\,\ Shizuoka",
"817456", "Yamatotakada\,\ Nara",
"819957", "Kajiki\,\ Kagoshima",
"81488", "Urawa\,\ Saitama",
"8188098", "Tosashimizu\,\ Kochi",
"818298", "Hatsukaichi\,\ Hiroshima",
"811945", "Kuji\,\ Iwate",
"818947", "Uwajima\,\ Ehime",
"818243", "Higashi\-ku\,\ Hiroshima",
"81983", "Takanabe\,\ Miyazaki",
"819828", "Takachiho\,\ Miyazaki",
"81774", "Uji\,\ Kyoto",
"818376", "Mine\,\ Yamaguchi",
"8126171", "Omachi\,\ Nagano",
"812476", "Miharu\,\ Fukushima",
"8147955", "Yokaichiba\,\ Chiba",
"811733", "Goshogawara\,\ Aomori",
"81426", "Hachioji\,\ Tokyo",
"81875", "Kan\'onji\,\ Kagawa",
"815958", "Kameyama\,\ Mie",
"819578", "Shimabara\,\ Nagasaki",
"812372", "Murayama\,\ Yamagata",
"81549", "Shizuoka\,\ Shizuoka",
"8186998", "Seto\,\ Okayama",
"811543", "Kushiro\,\ Hokkaido",
"814704", "Tateyama\,\ Chiba",
"817352", "Shingu\,\ Fukuoka",
"812679", "Saku\,\ Nagano",
"818667", "Ibara\,\ Okayama",
"811936", "Miyako\,\ Iwate",
"818974", "Niihama\,\ Ehime",
"812388", "Nagai\,\ Yamagata",
"815734", "Ena\,\ Gifu",
"8186697", "Kurashiki\,\ Okayama",
"81862", "Okayama\,\ Okayama",
"81586", "Ichinomiya\,\ Aichi",
"814776", "Funabashi\,\ Chiba",
"812858", "Mooka\,\ Tochigi",
"814703", "Tateyama\,\ Chiba",
"812836", "Sano\,\ Tochigi",
"818656", "Kasaoka\,\ Okayama",
"817485", "Yokaichi\,\ Shiga",
"814220", "Kokubunji\,\ Tokyo",
"819438", "Tanushimaru\,\ Fukuoka",
"818973", "Niihama\,\ Ehime",
"811958", "Iwate\,\ Iwate",
"812545", "Murakami\,\ Niigata",
"81942", "Kurume\,\ Fukuoka",
"81947", "Tagawa\,\ Fukuoka",
"815733", "Ena\,\ Gifu",
"819688", "Tamana\,\ Kumamoto",
"811734", "Goshogawara\,\ Aomori",
"8153973", "Hamamatsu\,\ Shizuoka",
"8153975", "Hamamatsu\,\ Shizuoka",
"8198291", "Nobeoka\,\ Miyazaki",
"812589", "Nagaoka\,\ Niigata",
"818660", "Seto\,\ Okayama",
"817950", "Sanda\,\ Hyogo",
"81734", "Wakayama\,\ Wakayama",
"811877", "Omagari\,\ Akita",
"811544", "Kushiro\,\ Hokkaido",
"81467", "Fujisawa\,\ Kanagawa",
"81462", "Atsugi\,\ Kanagawa",
"8147957", "Yokaichiba\,\ Chiba",
"811333", "Tobetsu\,\ Hokkaido",
"81245", "Fukushima\,\ Fukushima",
"81835", "Hofu\,\ Yamaguchi",
"811232", "Chitose\,\ Hokkaido",
"81888", "Kochi\,\ Kochi",
"819597", "Fukue\,\ Nagasaki",
"818202", "Yanai\,\ Yamaguchi",
"81934", "Kitakyushu\,\ Fukuoka",
"814298", "Hanno\,\ Saitama",
"8166", "Osaka\,\ Osaka",
"811527", "Bihoro\,\ Hokkaido",
"812247", "Ogawara\,\ Miyagi",
"817672", "Hakui\,\ Ishikawa",
"812998", "Itako\,\ Ibaraki",
"819966", "Izumi\,\ Kagoshima",
"818832", "Kamojima\,\ Tokushima",
"812652", "Iida\,\ Nagano",
"812788", "Maebashi\,\ Gunma",
"81742", "Nara\,\ Nara",
"812746", "Tomioka\,\ Gunma",
"817688", "Noto\,\ Ishikawa",
"818244", "Miyoshi\,\ Hiroshima",
"81478", "Sawara\,\ Chiba",
"819782", "Bungotakada\,\ Oita",
"818693", "Oku\,\ Okayama",
"818686", "Tsuyama\,\ Okayama",
"817455", "Yamatotakada\,\ Nara",
"815744", "Minokamo\,\ Gifu",
"817912", "Aioi\,\ Hyogo",
"811946", "Kuji\,\ Iwate",
"8186996", "Seto\,\ Okayama",
"819728", "Usuki\,\ Oita",
"811533", "Nemuro\,\ Hokkaido",
"812551", "Joetsu\,\ Niigata",
"812559", "Yasuzuka\,\ Niigata",
"811972", "Mizusawa\,\ Iwate",
"811377", "Yakumo\,\ Hokkaido",
"812475", "Ishikawa\,\ Fukushima",
"818375", "Mine\,\ Yamaguchi",
"818299", "Hiroshima\,\ Hiroshima",
"812934", "Takahagi\,\ Ibaraki",
"81263", "Matsumoto\,\ Nagano",
"817992", "Sumoto\,\ Hyogo",
"81885", "Komatsushima\,\ Tokushima",
"812678", "Saku\,\ Nagano",
"8153964", "Hamamatsu\,\ Shizuoka",
"812859", "Oyama\,\ Tochigi",
"8188096", "Tosashimizu\,\ Kochi",
"812389", "Yonezawa\,\ Yamagata",
"81984", "Kobayashi\,\ Miyazaki",
"815959", "Kameyama\,\ Mie",
"8125480", "Murakami\,\ Niigata",
"815398", "Hamamatsu\,\ Shizuoka",
"817494", "Hikone\,\ Shiga",
"81125", "Takikawa\,\ Hokkaido",
"811935", "Kamaishi\,\ Iwate",
"812230", "Sendai\,\ Miyagi",
"814775", "Funabashi\,\ Chiba",
"812835", "Sano\,\ Tochigi",
"81438", "Kisarazu\,\ Chiba",
"817965", "Toyooka\,\ Hyogo",
"818655", "Kamogata\,\ Okayama",
"817486", "Minakuchi\,\ Shiga",
"817493", "Hikone\,\ Shiga",
"81485", "Kumagaya\,\ Saitama",
"812546", "Murakami\,\ Niigata",
"812588", "Nagaoka\,\ Niigata",
"817717", "Sonobe\,\ Kyoto",
"818842", "Anan\,\ Tokushima",
"812933", "Takahagi\,\ Ibaraki",
"812237", "Sendai\,\ Miyagi",
"81933", "Kitakyushu\,\ Fukuoka",
"81176", "Towada\,\ Aomori",
"812911", "Hokota\,\ Ibaraki",
"812572", "Kashiwazaki\,\ Niigata",
"8125484", "Murakami\,\ Niigata",
"811398", "Kumaishi\,\ Hokkaido",
"81878", "Takamatsu\,\ Kagawa",
"812697", "Iiyama\,\ Nagano",
"811534", "Nakashibetsu\,\ Hokkaido",
"812789", "Maebashi\,\ Gunma",
"812872", "Otawara\,\ Tochigi",
"818694", "Okayama\,\ Okayama",
"819965", "Satsumasendai\,\ Kagoshima",
"814291", "Hanno\,\ Saitama",
"815972", "Owase\,\ Mie",
"819552", "Imari\,\ Saga",
"81899", "Matsuyama\,\ Ehime",
"815743", "Minokamo\,\ Gifu",
"812999", "Itako\,\ Ibaraki",
"812745", "Fujioka\,\ Gunma",
"818542", "Yasugi\,\ Shimane",
"818662", "Takahashi\,\ Okayama",
"817952", "Nishiwaki\,\ Hyogo",
"817357", "Kushimoto\,\ Wakayama",
"811336", "Ishikari\,\ Hokkaido",
"812474", "Ishikawa\,\ Fukushima",
"818374", "Nagato\,\ Yamaguchi",
"814288", "Ome\,\ Tokyo",
"812899", "Kanuma\,\ Tochigi",
"819808", "Yaeyama\ District\,\ Okinawa",
"817454", "Yamatotakada\,\ Nara",
"815745", "Minokamo\,\ Gifu",
"81236", "Yamagata\,\ Yamagata",
"815999", "Tsu\,\ Mie",
"819963", "Satsumasendai\,\ Kagoshima",
"812743", "Fujioka\,\ Gunma",
"818369", "Ube\,\ Yamaguchi",
"811559", "Obihiro\,\ Hokkaido",
"81927", "Fukuoka\,\ Fukuoka",
"812798", "Naganohara\,\ Gunma",
"81922", "Fukuoka\,\ Fukuoka",
"818477", "Tojo\,\ Hiroshima",
"812377", "Sagae\,\ Yamagata",
"817495", "Nagahama\,\ Shiga",
"811934", "Kamaishi\,\ Iwate",
"812833", "Utsunomiya\,\ Tochigi",
"817963", "Toyooka\,\ Hyogo",
"8112393", "Yubari\,\ Hokkaido",
"8112395", "Kuriyama\,\ Hokkaido",
"815736", "Nakatsugawa\,\ Gifu",
"817238", "Neyagawa\,\ Osaka",
"818976", "Niihama\,\ Ehime",
"81727", "Ikeda\,\ Osaka",
"81722", "Sakai\,\ Osaka",
"819952", "Okuchi\,\ Kagoshima",
"81495", "Honjo\,\ Saitama",
"812935", "Mito\,\ Ibaraki",
"817618", "Kaga\,\ Ishikawa",
"81225", "Ishinomaki\,\ Miyagi",
"8125486", "Tsugawa\,\ Niigata",
"818942", "Yawatahama\,\ Ehime",
"812657", "Ina\,\ Nagano",
"811736", "Goshogawara\,\ Aomori",
"81460", "Odawara\,\ Kanagawa",
"811546", "Kushiro\,\ Hokkaido",
"81563", "Nishio\,\ Aichi",
"81548", "Haibara\,\ Shizuoka",
"8153966", "Hamamatsu\,\ Shizuoka",
"811588", "Okoppe\,\ Hokkaido",
"81766", "Takaoka\,\ Toyama",
"819592", "Oseto\,\ Nagasaki",
"81940", "Munakata\,\ Fukuoka",
"811237", "Kuriyama\,\ Hokkaido",
"811933", "Kamaishi\,\ Iwate",
"812834", "Utsunomiya\,\ Tochigi",
"81276", "Ota\,\ Gunma",
"817964", "Toyooka\,\ Hyogo",
"818654", "Kamogata\,\ Okayama",
"8112397", "Kuriyama\,\ Hokkaido",
"817677", "Nanao\,\ Ishikawa",
"812242", "Shiroishi\,\ Miyagi",
"811522", "Shari\,\ Hokkaido",
"817453", "Yamatotakada\,\ Nara",
"81740", "Imazu\,\ Shiga",
"81489", "Soka\,\ Saitama",
"818695", "Seto\,\ Okayama",
"8186994", "Seto\,\ Okayama",
"819964", "Satsumasendai\,\ Kagoshima",
"812744", "Fujioka\,\ Gunma",
"818246", "Miyoshi\,\ Hiroshima",
"811535", "Akkeshi\,\ Hokkaido",
"817366", "Iwade\,\ Wakayama",
"819979", "Tokunoshima\,\ Kagoshima",
"8112392", "Yubari\,\ Hokkaido",
"818373", "Nagato\,\ Yamaguchi",
"812473", "Ishikawa\,\ Fukushima",
"818568", "Tsuwano\,\ Shimane",
"811647", "Haboro\,\ Hokkaido",
"81484", "Kawaguchi\,\ Saitama",
"812482", "Shirakawa\,\ Fukushima",
"818382", "Hagi\,\ Yamaguchi",
"817732", "Fukuchiyama\,\ Kyoto",
"812556", "Itoigawa\,\ Niigata",
"811466", "Erimo\,\ Hokkaido",
"818296", "Hiroshima\,\ Hiroshima",
"812794", "Shibukawa\,\ Gunma",
"815762", "Gero\,\ Gifu",
"812560", "Itoigawa\,\ Niigata",
"819826", "Hyuga\,\ Miyazaki",
"818689", "Okayama\,\ Okayama",
"819725", "Saiki\,\ Oita",
"81778", "Takefu\,\ Fukui",
"818563", "Masuda\,\ Shimane",
"8125481", "Murakami\,\ Niigata",
"811353", "Yoichi\,\ Hokkaido",
"818378", "Shimonoseki\,\ Yamaguchi",
"812478", "Miharu\,\ Fukushima",
"81833", "Kudamatsu\,\ Yamaguchi",
"818797", "Tonosho\,\ Kagawa",
"81243", "Nihonmatsu\,\ Fukushima",
"819804", "Nago\,\ Okinawa",
"81268", "Ueda\,\ Nagano",
"814284", "Tachikawa\,\ Tokyo",
"812675", "Saku\,\ Nagano",
"819576", "Shimabara\,\ Nagasaki",
"817725", "Miyazu\,\ Kyoto",
"817614", "Komatsu\,\ Ishikawa",
"811754", "Mutsu\,\ Aomori",
"811583", "Monbetsu\,\ Hokkaido",
"811938", "Miyako\,\ Iwate",
"815584", "Shimoda\,\ Shizuoka",
"81192", "Ofunato\,\ Iwate",
"815395", "Hamamatsu\,\ Shizuoka",
"815753", "Sekigahara\,\ Gifu",
"819542", "Takeo\,\ Saga",
"812856", "Mooka\,\ Tochigi",
"819732", "Hita\,\ Oita",
"81473", "Ichikawa\,\ Chiba",
"811362", "Kutchan\,\ Hokkaido",
"818552", "Hamada\,\ Shimane",
"818493", "Onomichi\,\ Hiroshima",
"812386", "Nagai\,\ Yamagata",
"815583", "Shimoda\,\ Shizuoka",
"81282", "Tochigi\,\ Tochigi",
"815754", "Sekigahara\,\ Gifu",
"817968", "Hamasaka\,\ Hyogo",
"812838", "Sano\,\ Tochigi",
"819686", "Tamana\,\ Kumamoto",
"818879", "Muroto\,\ Kochi",
"812585", "Nagaoka\,\ Niigata",
"817905", "Fukusaki\,\ Hyogo",
"811956", "Iwate\,\ Iwate",
"815362", "Shinshiro\,\ Aichi",
"817613", "Komatsu\,\ Ishikawa",
"811753", "Mutsu\,\ Aomori",
"81738", "Gobo\,\ Wakayama",
"811395", "Esashi\,\ Hokkaido",
"818397", "Ogori\,\ Yamaguchi",
"812549", "Tsugawa\,\ Niigata",
"811584", "Engaru\,\ Hokkaido",
"81592", "Tsu\,\ Mie",
"815985", "Matsusaka\,\ Mie",
"8112399", "Kuriyama\,\ Hokkaido",
"818564", "Masuda\,\ Shimane",
"811354", "Yoichi\,\ Hokkaido",
"812996", "Itako\,\ Ibaraki",
"81938", "Kitakyushu\,\ Fukuoka",
"81985", "Miyazaki\,\ Miyazaki",
"819803", "Nago\,\ Okinawa",
"814283", "Ome\,\ Tokyo",
"81124", "Ashibetsu\,\ Hokkaido",
"819968", "Izumi\,\ Kagoshima",
"81252", "Niigata\,\ Niigata",
"814797", "Yokaichiba\,\ Chiba",
"81433", "Chiba\,\ Chiba",
"817686", "Noto\,\ Ishikawa",
"812748", "Tomioka\,\ Gunma",
"8124197", "Yanaizu\,\ Fukushima",
"819233", "Maebaru\,\ Fukuoka",
"819937", "Kaseda\,\ Kagoshima",
"812793", "Shibukawa\,\ Gunma",
"812786", "Numata\,\ Gunma",
"8162", "Osaka\,\ Osaka",
"812647", "Nagano\,\ Nagano",
"819724", "Saiki\,\ Oita",
"815996", "Ago\,\ Mie",
"815983", "Matsusaka\,\ Mie",
"818366", "Ube\,\ Yamaguchi",
"819805", "Nago\,\ Okinawa",
"811556", "Obihiro\,\ Hokkaido",
"814285", "Sagamihara\,\ Kanagawa",
"811632", "Teshio\,\ Hokkaido",
"8126178", "Omachi\,\ Nagano",
"818592", "Yonago\,\ Tottori",
"81552", "Kofu\,\ Yamanashi",
"81557", "Ito\,\ Shizuoka",
"81143", "Muroran\,\ Hokkaido",
"812795", "Shibukawa\,\ Gunma",
"811984", "Hanamaki\,\ Iwate",
"812896", "Kanuma\,\ Tochigi",
"818677", "Niimi\,\ Okayama",
"815394", "Hamamatsu\,\ Shizuoka",
"815585", "Shimoda\,\ Shizuoka",
"817498", "Nagahama\,\ Shiga",
"817903", "Fukusaki\,\ Hyogo",
"818892", "Sakawa\,\ Kochi",
"81587", "Ichinomiya\,\ Aichi",
"81582", "Gifu\,\ Gifu",
"812583", "Nagaoka\,\ Niigata",
"81292", "Mito\,\ Ibaraki",
"817724", "Miyazu\,\ Kyoto",
"812938", "Mito\,\ Ibaraki",
"817615", "Komatsu\,\ Ishikawa",
"812674", "Komoro\,\ Nagano",
"819747", "Taketa\,\ Oita",
"818512", "Nishigo\,\ Fukushima",
"814709", "Kamogawa\,\ Chiba",
"81427", "Sagamihara\,\ Kanagawa",
"814701", "Kamogawa\,\ Chiba",
"811856", "Noshiro\,\ Akita",
"812967", "Kasama\,\ Ibaraki",
"817706", "Obama\,\ Fukui",
"811393", "Matsumae\,\ Hokkaido",
"818462", "Takehara\,\ Hiroshima",
"817723", "Miyazu\,\ Kyoto",
"817942", "Kakogawa\,\ Hyogo",
"812673", "Komoro\,\ Nagano",
"818808", "Tosashimizu\,\ Kochi",
"81182", "Yokote\,\ Akita",
"8111", "Sapporo\,\ Hokkaido",
"811585", "Engaru\,\ Hokkaido",
"81466", "Fujisawa\,\ Kanagawa",
"81989", "Naha\,\ Okinawa",
"819662", "Hitoyoshi\,\ Kumamoto",
"818587", "Koge\,\ Tottori",
"811867", "Takanosu\,\ Akita",
"811394", "Matsumae\,\ Hokkaido",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"8182941", "Hiroshima\,\ Hiroshima",
"815393", "Hamamatsu\,\ Shizuoka",
"815755", "Sekigahara\,\ Gifu",
"81822", "Hiroshima\,\ Hiroshima",
"81827", "Iwakuni\,\ Yamaguchi",
"811541", "Teshikaga\,\ Hokkaido",
"8198298", "Hyuga\,\ Miyazaki",
"811549", "Kushiro\,\ Hokkaido",
"817904", "Fukusaki\,\ Hyogo",
"81270", "Isesaki\,\ Gunma",
"814757", "Togane\,\ Chiba",
"81946", "Amagi\,\ Fukuoka",
"812584", "Nagaoka\,\ Niigata",
"818698", "Bizen\,\ Okayama",
"819976", "Naze\,\ Kagoshima",
"8183766", "Shimonoseki\,\ Yamaguchi",
"811983", "Hanamaki\,\ Iwate",
"812640", "Nagano\,\ Nagano",
"81494", "Chichibu\,\ Saitama",
"81568", "Kasugai\,\ Aichi",
"819723", "Saiki\,\ Oita",
"81543", "Shizuoka\,\ Shizuoka",
"81157", "Kitami\,\ Hokkaido",
"815984", "Matsusaka\,\ Mie",
"818249", "Higashi\-ku\,\ Hiroshima",
"818952", "Uwajima\,\ Ehime",
"818565", "Masuda\,\ Shimane",
"819547", "Kashima\,\ Saga",
"819824", "Nobeoka\,\ Miyazaki",
"815995", "Ago\,\ Mie",
"818365", "Ube\,\ Yamaguchi",
"811555", "Obihiro\,\ Hokkaido",
"814286", "Sagamihara\,\ Kanagawa",
"811367", "Suttsu\,\ Hokkaido",
"818557", "Kawamoto\,\ Shimane",
"812993", "Ishioka\,\ Ibaraki",
"81939", "Kitakyushu\,\ Fukuoka",
"819737", "Kusu\,\ Oita",
"8153979", "Hamamatsu\,\ Shizuoka",
"818294", "Hatsukaichi\,\ Hiroshima",
"812796", "Shibukawa\,\ Gunma",
"812783", "Numata\,\ Gunma",
"812895", "Utsunomiya\,\ Tochigi",
"817683", "Wajima\,\ Ishikawa",
"811464", "Shizunai\,\ Hokkaido",
"812554", "Joetsu\,\ Niigata",
"812913", "Hokota\,\ Ibaraki",
"81144", "Tomakomai\,\ Hokkaido",
"815586", "Shimoda\,\ Shizuoka",
"815767", "Gero\,\ Gifu",
"812939", "Mito\,\ Ibaraki",
"81893", "Ozu\,\ Ehime",
"811953", "Ninohe\,\ Iwate",
"818978", "Hakata\,\ Ehime",
"819433", "Yame\,\ Fukuoka",
"812384", "Yonezawa\,\ Yamagata",
"81572", "Tajimi\,\ Gifu",
"819683", "Yamaga\,\ Kumamoto",
"81577", "Takayama\,\ Gifu",
"812854", "Oyama\,\ Tochigi",
"815738", "Nakatsugawa\,\ Gifu",
"8126176", "Omachi\,\ Nagano",
"81565", "Toyota\,\ Aichi",
"817616", "Komatsu\,\ Ishikawa",
"819574", "Isahaya\,\ Nagasaki",
"811855", "Noshiro\,\ Akita",
"817705", "Obama\,\ Fukui",
"811756", "Noheji\,\ Aomori",
"81739", "Tanabe\,\ Wakayama",
"817737", "Maizuru\,\ Kyoto",
"818387", "Tamagawa\,\ Yamaguchi",
"812487", "Sukagawa\,\ Fukushima",
"812412", "Kitakata\,\ Fukushima",
"81172", "Hirosaki\,\ Aomori",
"81177", "Aomori\,\ Aomori",
"8183768", "Shimonoseki\,\ Yamaguchi",
"819573", "Isahaya\,\ Nagasaki",
"811586", "Nakayubetsu\,\ Hokkaido",
"812562", "Sanjo\,\ Niigata",
"811452", "Hayakita\,\ Hokkaido",
"81493", "Higashimatsuyama\,\ Saitama",
"819932", "Ibusuki\,\ Kagoshima",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"811548", "Teshikaga\,\ Hokkaido",
"81979", "Nakatsu\,\ Oita",
"814792", "Choshi\,\ Chiba",
"81544", "Fujinomiya\,\ Shizuoka",
"812914", "Hokota\,\ Ibaraki",
"81998", "Kagoshima\,\ Kagoshima",
"811954", "Ninohe\,\ Iwate",
"819434", "Yame\,\ Fukuoka",
"812383", "Yonezawa\,\ Yamagata",
"819684", "Yamaga\,\ Kumamoto",
"81280", "Koga\,\ Ibaraki",
"812853", "Oyama\,\ Tochigi",
"819975", "Naze\,\ Kagoshima",
"815367", "Shitara\,\ Aichi",
"818293", "Hatsukaichi\,\ Hiroshima",
"81798", "Nishinomiya\,\ Hyogo",
"812784", "Numata\,\ Gunma",
"81537", "Kakegawa\,\ Shizuoka",
"818248", "Shobara\,\ Hiroshima",
"81532", "Toyohashi\,\ Aichi",
"817684", "Wajima\,\ Ishikawa",
"812553", "Joetsu\,\ Niigata",
"81250", "Niitsu\,\ Niigata",
"811463", "Urakawa\,\ Hokkaido",
"817368", "Iwade\,\ Wakayama",
"819823", "Nobeoka\,\ Miyazaki",
"8198296", "Hyuga\,\ Miyazaki",
"811356", "Iwanai\,\ Hokkaido",
"812994", "Ishioka\,\ Ibaraki",
"81779", "Ono\,\ Gifu",
"81550", "Gotenba\,\ Shizuoka",
"81474", "Funabashi\,\ Chiba",
"819742", "Mie\,\ Oita",
"818688", "Mimasaka\,\ Okayama",
"812894", "Utsunomiya\,\ Tochigi",
"818467", "Mima\,\ Tokushima",
"81926", "Fukuoka\,\ Fukuoka",
"811465", "Shizunai\,\ Hokkaido",
"812555", "Itoigawa\,\ Niigata",
"812962", "Shimodate\,\ Ibaraki",
"818295", "Hatsukaichi\,\ Hiroshima",
"811986", "Tono\,\ Iwate",
"8198294", "Nobeoka\,\ Miyazaki",
"819825", "Hyuga\,\ Miyazaki",
"815994", "Ago\,\ Mie",
"81569", "Handa\,\ Aichi",
"819726", "Usuki\,\ Oita",
"817940", "Kakogawa\,\ Hyogo",
"818364", "Ube\,\ Yamaguchi",
"811554", "Obihiro\,\ Hokkaido",
"81958", "Nagasaki\,\ Nagasaki",
"812676", "Saku\,\ Nagano",
"814771", "Ichikawa\,\ Chiba",
"81834", "Tokuyama\,\ Yamaguchi",
"81244", "Hobara\,\ Fukushima",
"819575", "Isahaya\,\ Nagasaki",
"811939", "Miyako\,\ Iwate",
"817704", "Tsuruga\,\ Fukui",
"81935", "Kitakyushu\,\ Fukuoka",
"819940", "Shibushi\,\ Kagoshima",
"81988", "Naha\,\ Okinawa",
"811854", "Oga\,\ Akita",
"81420", "Tokorozawa\,\ Saitama",
"8126170", "Omachi\,\ Nagano",
"812855", "Oyama\,\ Tochigi",
"81726", "Ibaraki\,\ Osaka",
"81561", "Seto\,\ Aichi",
"812385", "Yonezawa\,\ Yamagata",
"81277", "Kiryu\,\ Gunma",
"81272", "Maebashi\,\ Gunma",
"81434", "Chiba\,\ Chiba",
"817488", "Minakuchi\,\ Shiga",
"819947", "Shibushi\,\ Kagoshima",
"81762", "Kanazawa\,\ Ishikawa",
"819685", "Tamana\,\ Kumamoto",
"811562", "Honbetsu\,\ Hokkaido",
"812586", "Nagaoka\,\ Niigata",
"818957", "Misho\,\ Ehime",
"811955", "Ninohe\,\ Iwate",
"819435", "Yame\,\ Fukuoka",
"817969", "Hamasaka\,\ Hyogo",
"812839", "Sano\,\ Tochigi",
"8164", "Osaka\,\ Osaka",
"817703", "Tsuruga\,\ Fukui",
"81775", "Otsu\,\ Shiga",
"811396", "Esashi\,\ Hokkaido",
"8126174", "Omachi\,\ Nagano",
"811853", "Oga\,\ Akita",
"815993", "Toba\,\ Mie",
"815986", "Matsusaka\,\ Mie",
"818262", "Kake\,\ Hiroshima",
"812995", "Ishioka\,\ Ibaraki",
"81975", "Oita\,\ Oita",
"814752", "Mobara\,\ Chiba",
"818363", "Ube\,\ Yamaguchi",
"811553", "Obihiro\,\ Hokkaido",
"81853", "Izumo\,\ Shimane",
"819974", "Yakushima\,\ Kagoshima",
"817947", "Miki\,\ Hyogo",
"81962", "Kumamoto\,\ Kumamoto",
"812893", "Utsunomiya\,\ Tochigi",
"817685", "Wajima\,\ Ishikawa",
"811862", "Kazuno\,\ Akita",
"8198290", "Nobeoka\,\ Miyazaki",
"818582", "Kurayoshi\,\ Tottori",
"819667", "Minamata\,\ Kumamoto",
"812785", "Numata\,\ Gunma",
"8112396", "Kuriyama\,\ Hokkaido",
"814777", "Funabashi\,\ Chiba",
"81924", "Fukuoka\,\ Fukuoka",
"817673", "Hakui\,\ Ishikawa",
"81259", "Sado\,\ Niigata",
"811332", "Tobetsu\,\ Hokkaido",
"81825", "Hiroshima\,\ Hiroshima",
"818203", "Yanai\,\ Yamaguchi",
"818666", "Ibara\,\ Okayama",
"817956", "Sanda\,\ Hyogo",
"81591", "Tsu\,\ Mie",
"811233", "Chitose\,\ Hokkaido",
"81476", "Narita\,\ Chiba",
"811937", "Miyako\,\ Iwate",
"8125485", "Tsugawa\,\ Niigata",
"8125483", "Murakami\,\ Niigata",
"81281", "Utsunomiya\,\ Tochigi",
"812830", "Utsunomiya\,\ Tochigi",
"8153967", "Hamamatsu\,\ Shizuoka",
"81138", "Hakodate\,\ Hokkaido",
"818833", "Kamojima\,\ Tokushima",
"812653", "Iida\,\ Nagano",
"81260", "Anan\,\ Nagano",
"818972", "Niihama\,\ Ehime",
"811375", "Yakumo\,\ Hokkaido",
"818798", "Tonosho\,\ Kagawa",
"818377", "Shimonoseki\,\ Yamaguchi",
"815732", "Ena\,\ Gifu",
"812477", "Miharu\,\ Fukushima",
"817354", "Shingu\,\ Fukuoka",
"8128798", "Otawara\,\ Tochigi",
"814702", "Tateyama\,\ Chiba",
"81246", "Iwaki\,\ Fukushima",
"818474", "Fuchu\,\ Hiroshima",
"812374", "Murayama\,\ Yamagata",
"81578", "Kamioka\,\ Akita",
"818946", "Uwajima\,\ Ehime",
"817457", "Yamatotakada\,\ Nara",
"819956", "Kajiki\,\ Kagoshima",
"8125482", "Murakami\,\ Niigata",
"81992", "Kagoshima\,\ Kagoshima",
"81555", "Fujiyoshida\,\ Yamanashi",
"812373", "Murayama\,\ Yamagata",
"819938", "Kaseda\,\ Kagoshima",
"811542", "Kushiro\,\ Hokkaido",
"812747", "Tomioka\,\ Gunma",
"814798", "Yokaichiba\,\ Chiba",
"817466", "Totsukawa\,\ Nara",
"819967", "Izumi\,\ Kagoshima",
"811732", "Goshogawara\,\ Aomori",
"81436", "Ichihara\,\ Chiba",
"81199", "Morioka\,\ Iwate",
"811526", "Abashiri\,\ Hokkaido",
"812246", "Ogawara\,\ Miyagi",
"8152", "Nagoya\,\ Aichi",
"817353", "Shingu\,\ Fukuoka",
"81178", "Hachinohe\,\ Aomori",
"812695", "Nakano\,\ Nagano",
"819596", "Fukue\,\ Nagasaki",
"817949", "Kakogawa\,\ Hyogo",
"81191", "Ichinoseki\,\ Iwate",
"811876", "Omagari\,\ Akita",
"818398", "Ogori\,\ Yamaguchi",
"818242", "Higashi\-ku\,\ Hiroshima",
"812235", "Sendai\,\ Miyagi",
"814770", "Ichikawa\,\ Chiba",
"81930", "Yukuhashi\,\ Fukuoka",
"8153965", "Hamamatsu\,\ Shizuoka",
"818834", "Kamojima\,\ Tokushima",
"812654", "Iida\,\ Nagano",
"81425", "Tachikawa\,\ Tokyo",
"8125487", "Tsugawa\,\ Niigata",
"812615", "Omachi\,\ Nagano",
"81792", "Himeji\,\ Hyogo",
"81797", "Nishinomiya\,\ Hyogo",
"81585", "Ibigawa\,\ Gifu",
"817715", "Kameoka\,\ Kyoto",
"81538", "Iwata\,\ Shizuoka",
"817674", "Hakui\,\ Ishikawa",
"812837", "Sano\,\ Tochigi",
"818657", "Kasaoka\,\ Okayama",
"811655", "Nayoro\,\ Hokkaido",
"8145", "Yokohama\,\ Kanagawa",
"818204", "Yanai\,\ Yamaguchi",
"8161", "Osaka\,\ Osaka",
"811234", "Chitose\,\ Hokkaido",
"811942", "Iwaizumi\,\ Iwate",
"812968", "Kasama\,\ Ibaraki",
"8112390", "Yubari\,\ Hokkaido",
"81952", "Saga\,\ Saga",
"812233", "Iwanuma\,\ Miyagi",
"8188095", "Tosashimizu\,\ Kochi",
"812937", "Mito\,\ Ibaraki",
"815769", "Shokawa\,\ Gifu",
"819786", "Kitsuki\,\ Oita",
"818682", "Tsuyama\,\ Okayama",
"817713", "Kameoka\,\ Kyoto",
"812613", "Omachi\,\ Nagano",
"812489", "Sukagawa\,\ Fukushima",
"811976", "Kitakami\,\ Iwate",
"8182942", "Hiroshima\,\ Hiroshima",
"817497", "Nagahama\,\ Shiga",
"81848", "Onomichi\,\ Hiroshima",
"81863", "Tamano\,\ Okayama",
"811653", "Shibetsu\,\ Hokkaido",
"818678", "Niimi\,\ Okayama",
"818559", "Kawamoto\,\ Shimane",
"818475", "Fuchu\,\ Hiroshima",
"812375", "Murayama\,\ Yamagata",
"8186995", "Seto\,\ Okayama",
"8186993", "Bizen\,\ Okayama",
"817996", "Tsuna\,\ Hyogo",
"818690", "Okayama\,\ Okayama",
"811374", "Mori\,\ Hokkaido",
"81987", "Nichinan\,\ Miyazaki",
"812693", "Nakano\,\ Nagano",
"812648", "Nagano\,\ Nagano",
"817355", "Shingu\,\ Fukuoka",
"81546", "Shizuoka\,\ Shizuoka",
"8182943", "Hiroshima\,\ Hiroshima",
"8186698", "Kurashiki\,\ Okayama",
"812542", "Shibata\,\ Niigata",
"81551", "Nirasaki\,\ Yamanashi",
"812694", "Nakano\,\ Nagano",
"811537", "Nakashibetsu\,\ Hokkaido",
"817482", "Yokaichi\,\ Shiga",
"81429", "Tokorozawa\,\ Saitama",
"812576", "Tokamachi\,\ Niigata",
"818872", "Muroto\,\ Kochi",
"8153978", "Hamamatsu\,\ Shizuoka",
"8186997", "Seto\,\ Okayama",
"81743", "Nara\,\ Nara",
"818697", "Bizen\,\ Okayama",
"812930", "Mito\,\ Ibaraki",
"812876", "Kuroiso\,\ Tochigi",
"817714", "Kameoka\,\ Kyoto",
"817675", "Nanao\,\ Ishikawa",
"814758", "Togane\,\ Chiba",
"812614", "Omachi\,\ Nagano",
"81559", "Numazu\,\ Shizuoka",
"818205", "Yanai\,\ Yamaguchi",
"8112394", "Yubari\,\ Hokkaido",
"811235", "Yubari\,\ Hokkaido",
"811654", "Nayoro\,\ Hokkaido",
"818546", "Kakeya\,\ Shimane",
"811868", "Takanosu\,\ Akita",
"8188097", "Tosashimizu\,\ Kochi",
"818588", "Koge\,\ Tottori",
"818835", "Mima\,\ Tokushima",
"8186992", "Bizen\,\ Okayama",
"818807", "Sukumo\,\ Kochi",
"812655", "Iida\,\ Nagano",
"819556", "Karatsu\,\ Saga",
"812234", "Sendai\,\ Miyagi",
"81463", "Hiratsuka\,\ Kanagawa",
"812488", "Sukagawa\,\ Fukushima",
"818388", "Tamagawa\,\ Yamaguchi",
"817738", "Maizuru\,\ Kyoto",
"81262", "Nagano\,\ Nagano",
"811873", "Kakunodate\,\ Akita",
"817915", "Aioi\,\ Hyogo",
"817452", "Yamatotakada\,\ Nara",
"818679", "Niimi\,\ Okayama",
"819785", "Bungotakada\,\ Oita",
"818372", "Nagato\,\ Yamaguchi",
"815737", "Nakatsugawa\,\ Gifu",
"812472", "Ishikawa\,\ Fukushima",
"818977", "Hakata\,\ Ehime",
"811975", "Mizusawa\,\ Iwate",
"815768", "Gero\,\ Gifu",
"817954", "Nishiwaki\,\ Hyogo",
"818664", "Takahashi\,\ Okayama",
"81896", "Iyomishima\,\ Ehime",
"81765", "Uozu\,\ Toyama",
"8198299", "Hyuga\,\ Miyazaki",
"818944", "Yawatahama\,\ Ehime",
"818476", "Fuchu\,\ Hiroshima",
"812376", "Sagae\,\ Yamagata",
"81864", "Kurashiki\,\ Okayama",
"812649", "Nagano\,\ Nagano",
"819954", "Kajiki\,\ Kagoshima",
"817995", "Sumoto\,\ Hyogo",
"81965", "Yatsushiro\,\ Kumamoto",
"817463", "Yoshino\,\ Nara",
"819738", "Kusu\,\ Oita",
"814772", "Ichikawa\,\ Chiba",
"81977", "Beppu\,\ Oita",
"814998", "Ogasawara\,\ Tokyo",
"818558", "Kawamoto\,\ Shimane",
"811523", "Shari\,\ Hokkaido",
"812243", "Shiroishi\,\ Miyagi",
"811932", "Kamaishi\,\ Iwate",
"819593", "Oseto\,\ Nagasaki",
"817356", "Kushimoto\,\ Wakayama",
"81531", "Tahara\,\ Aichi",
"81179", "Sannohe\,\ Aomori",
"811337", "Ishikari\,\ Hokkaido",
"818240", "Higashi\-ku\,\ Hiroshima",
"81737", "Yuasa\,\ Wakayama",
"81464", "Atsugi\,\ Kanagawa",
"811524", "Abashiri\,\ Hokkaido",
"812244", "Shiroishi\,\ Miyagi",
"817367", "Iwade\,\ Wakayama",
"812832", "Sano\,\ Tochigi",
"818652", "Kurashiki\,\ Okayama",
"817962", "Toyooka\,\ Hyogo",
"81944", "Setaka\,\ Fukuoka",
"819676", "Takamori\,\ Kumamoto",
"812575", "Tokamachi\,\ Niigata",
"818247", "Shobara\,\ Hiroshima",
"818943", "Yawatahama\,\ Ehime",
"8126179", "Omachi\,\ Nagano",
"819953", "Okuchi\,\ Kagoshima",
"815368", "Shitara\,\ Aichi",
"81235", "Tsuruoka\,\ Yamagata",
"81845", "Innoshima\,\ Hiroshima",
"814240", "Kokubunji\,\ Tokyo",
"81288", "Imabari\,\ Ehime",
"817464", "Yoshino\,\ Nara",
"812875", "Otawara\,\ Tochigi",
"81744", "Yamatotakada\,\ Nara",
"817676", "Nanao\,\ Ishikawa",
"813", "Tokyo",
"811869", "Odate\,\ Akita",
"818206", "Yanai\,\ Yamaguchi",
"817953", "Nishiwaki\,\ Hyogo",
"818663", "Soja\,\ Okayama",
"811236", "Chitose\,\ Hokkaido",
"814700", "Kamogawa\,\ Chiba",
"818545", "Kisuki\,\ Shimane",
"811547", "Shiranuka\,\ Hokkaido",
"81932", "Kitakyushu\,\ Fukuoka",
"81937", "Kitakyushu\,\ Fukuoka",
"812742", "Fujioka\,\ Gunma",
"8153976", "Hamamatsu\,\ Shizuoka",
"811874", "Kakunodate\,\ Akita",
"818836", "Mima\,\ Tokushima",
"812656", "Ina\,\ Nagano",
"81226", "Kesennuma\,\ Miyagi",
"819555", "Karatsu\,\ Saga",
"8182920", "Hatsukaichi\,\ Hiroshima",
"819962", "Satsumasendai\,\ Kagoshima",
"811974", "Mizusawa\,\ Iwate",
"812873", "Otawara\,\ Tochigi",
"81167", "Furano\,\ Hokkaido",
"81162", "Wakkanai\,\ Hokkaido",
"81486", "Urawa\,\ Saitama",
"81969", "Amakusa\,\ Kumamoto",
"817955", "Sanda\,\ Hyogo",
"818665", "Takahashi\,\ Okayama",
"81723", "Sakai\,\ Osaka",
"817914", "Aioi\,\ Hyogo",
"818543", "Yasugi\,\ Shimane",
"819784", "Bungotakada\,\ Oita",
"815742", "Minokamo\,\ Gifu",
"819553", "Imari\,\ Saga",
"815973", "Owase\,\ Mie",
"81950", "Hirado\,\ Nagasaki",
"8112398", "Kuriyama\,\ Hokkaido",
"811376", "Yakumo\,\ Hokkaido",
"818843", "Anan\,\ Tokushima",
"81298", "Tsuchiura\,\ Ibaraki",
"817492", "Hikone\,\ Shiga",
"811947", "Kuji\,\ Iwate",
"81535", "Hamamatsu\,\ Shizuoka",
"812573", "Kashiwazaki\,\ Niigata",
"818945", "Yawatahama\,\ Ehime",
"818687", "Mimasaka\,\ Okayama",
"812932", "Takahagi\,\ Ibaraki",
"819955", "Kajiki\,\ Kagoshima",
"81923", "Fukuoka\,\ Fukuoka",
"817994", "Sumoto\,\ Hyogo",
"8147950", "Yokaichiba\,\ Chiba",
"819668", "Minamata\,\ Kumamoto",
"812574", "Kashiwazaki\,\ Niigata",
"817948", "Miki\,\ Hyogo",
"817465", "Yoshino\,\ Nara",
"81828", "Hiroshima\,\ Hiroshima",
"817993", "Sumoto\,\ Hyogo",
"811525", "Abashiri\,\ Hokkaido",
"812245", "Ogawara\,\ Miyagi",
"818680", "Okayama\,\ Okayama",
"818844", "Anan\,\ Tokushima",
"812696", "Iiyama\,\ Nagano",
"812419", "Tajima\,\ Fukushima",
"81188", "Akita\,\ Akita",
"811875", "Kakunodate\,\ Akita",
"818544", "Kisuki\,\ Shimane",
"812236", "Sendai\,\ Miyagi",
"819783", "Bungotakada\,\ Oita",
"818692", "Oku\,\ Okayama",
"81886", "Tokushima\,\ Tokushima",
"81567", "Tsushima\,\ Aichi",
"819554", "Imari\,\ Saga",
"815974", "Owase\,\ Mie",
"812616", "Omachi\,\ Nagano",
"812547", "Murakami\,\ Niigata",
"818958", "Misho\,\ Ehime",
"8153970", "Hamamatsu\,\ Shizuoka",
"811973", "Mizusawa\,\ Iwate",
"812874", "Otawara\,\ Tochigi",
"817716", "Sonobe\,\ Kyoto",
"819948", "Shibushi\,\ Kagoshima",
"81126", "Iwamizawa\,\ Hokkaido",
"811656", "Bifuka\,\ Hokkaido",
"817487", "Minakuchi\,\ Shiga",
"81849", "Fukuyama\,\ Hiroshima",
"818391", "Ogori\,\ Yamaguchi",
"811532", "Nemuro\,\ Hokkaido",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;