# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20220305001841;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[2-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[2-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"4934633", "Braunsbedra",
"496356", "Carlsberg\ Pfalz",
"495304", "Meine",
"497465", "Emmingen\-Liptingen",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"4939928", "Möllenhagen",
"492330", "Herdecke",
"495109", "Ronnenberg",
"492245", "Much",
"495407", "Wallenhorst",
"496052", "Bad\ Orb",
"4933654", "Fünfeichen",
"494945", "Grossefehn\-Timmel",
"4935471", "Birkenhainchen",
"4933677", "Glienicke\ bei\ Beeskow",
"4933084", "Gutengermendorf",
"4934297", "Liebertwolkwitz",
"495101", "Pattensen",
"495072", "Neustadt\-Mandelsloh",
"4933874", "Stechow\ Brandenburg",
"496831", "Saarlouis",
"498544", "Eging\ am\ See",
"498734", "Reisbach\ Niederbayern",
"497384", "Schelklingen\-Hütten",
"492236", "Wesseling\ Rheinland",
"4936330", "Grossberndten",
"495924", "Bad\ Bentheim\-Gildehaus",
"494936", "Grossheide",
"495035", "Gross\ Munzel",
"495961", "Haselünne",
"497181", "Schorndorf\ Württemberg",
"492547", "Rosendahl\-Osterwick",
"494148", "Drochtersen\-Assel",
"494543", "Nusse",
"4937607", "Ebersbrunn\ Sachsen",
"494733", "Butjadingen\-Burhave",
"492737", "Netphen\-Deuz",
"4938826", "Dassow",
"498502", "Fürstenzell",
"4936043", "Kirchheilingen",
"494827", "Wacken",
"493774", "Schwarzenberg",
"496594", "Birresborn",
"499080", "Harburg\ Schwaben",
"492823", "Goch",
"494194", "Sievershütten",
"497955", "Wallhausen\ Württemberg",
"49271", "Siegen",
"494275", "Ehrenburg",
"498193", "Geltendorf",
"49761", "Freiburg\ im\ Breisgau",
"492975", "Schmallenberg\-Oberkirchen",
"4939952", "Grammentin",
"4936423", "Orlamünde",
"4933602", "Alt\ Zeschdorf",
"4939321", "Arneburg",
"4939088", "Letzlingen",
"4938231", "Barth",
"497158", "Neuhausen\ auf\ den\ Fildern",
"499282", "Naila",
"499853", "Wilburgstetten",
"497553", "Salem\ Baden",
"4939751", "Penkun",
"492573", "Nordwalde",
"496479", "Waldbrunn\ Westerwald",
"4935932", "Guttau",
"495451", "Ibbenbüren",
"4933924", "Rägelin",
"495459", "Hörstel",
"492932", "Neheim\-Hüsten",
"499562", "Sonnefeld",
"496471", "Weilburg",
"495157", "Emmerthal\-Börry",
"494232", "Langwedel\ Kreis\ Verden",
"4936929", "Ruhla",
"4939779", "Eggesin",
"495840", "Schnackenburg",
"499642", "Kemnath\ Stadt",
"4938751", "Picher",
"4936372", "Kleinneuhausen",
"494404", "Elsfleth",
"4935820", "Zodel",
"492832", "Kevelaer",
"495182", "Gronau\ Leine",
"497962", "Fichtenau",
"492525", "Beckum\-Neubeckum",
"494442", "Lohne\ Oldenburg",
"499676", "Winklarn",
"493375", "Königs\ Wusterhausen",
"498403", "Pförring",
"4939487", "Friedrichsbrunn",
"4939976", "Gross\ Bützin",
"492303", "Unna",
"499257", "Zell\ Oberfranken",
"499953", "Pilsting",
"494307", "Raisdorf",
"499604", "Wernberg\-Köblitz",
"497071", "Tübingen",
"497626", "Kandern",
"496383", "Glan\-Münchweiler",
"496396", "Hinterweidenthal",
"498224", "Offingen\ Donau",
"4938321", "Martensdorf\ bei\ Stralsund",
"498581", "Waldkirchen\ Niederbayern",
"499338", "Röttingen\ Unterfranken",
"492923", "Lippetal\-Herzfeld",
"492227", "Bornheim\-Merten",
"4933965", "Herzsprung\ bei\ Wittstock",
"494927", "Krummhörn\-Loquard",
"494223", "Ganderkesee\-Bookholzberg",
"4933835", "Golzow\ bei\ Brandenburg",
"4934494", "Ehrenhain",
"496092", "Heimbuchenthal",
"496228", "Schönau\ Odenwald",
"498269", "Unteregg\ bei\ Mindelheim",
"4934652", "Allstedt",
"499555", "Schlüsselfeld\-Aschbach",
"497144", "Marbach\ am\ Neckar",
"498261", "Mindelheim",
"493332", "Schwedt\/Oder",
"492051", "Velbert",
"4935953", "Burkau",
"495861", "Dannenberg\ Elbe",
"498621", "Trostberg",
"498346", "Pforzen",
"492446", "Heimbach\ Eifel",
"498076", "Pfaffing",
"496668", "Birstein\-Lichenroth",
"497452", "Nagold",
"4939395", "Wanzer",
"498629", "Palling",
"497586", "Herbertingen",
"4939826", "Blankensee\ bei\ Neustrelitz",
"494663", "Süderlügum",
"492667", "Stein\-Neukirch",
"499170", "Schwanstetten",
"498042", "Lenggries",
"498372", "Obergünzburg",
"495491", "Damme\ Dümmer",
"492472", "Monschau",
"495705", "Petershagen\-Windheim",
"4934922", "Mühlanger",
"4937294", "Grünhainichen",
"498664", "Chieming",
"495824", "Bad\ Bodenteich",
"494836", "Hennstedt\ Dithmarschen",
"496008", "Echzell",
"495768", "Petershagen\-Heimsen",
"495197", "Soltau\-Frielingen",
"499463", "Wald\ Oberpfalz",
"497266", "Kirchardt",
"4939863", "Seehausen\ bei\ Prenzlau",
"4939933", "Vollrathsruhe",
"494845", "Ostenfeld\ Husum",
"494154", "Trittau",
"4934461", "Nebra\ Unstrut",
"496087", "Waldems",
"496554", "Waxweiler",
"495506", "Adelebsen",
"495574", "Oberweser",
"499209", "Emtmannsberg",
"498153", "Wessling",
"494722", "Cuxhaven\-Altenbruch",
"4934721", "Nienburg\ Saale",
"498558", "Hohenau\ Niederbayern",
"494351", "Eckernförde",
"492685", "Flammersfeld",
"498335", "Fellheim",
"492435", "Erkelenz\-Lövenich",
"499201", "Gesees",
"4934604", "Niemberg",
"4938845", "Kaarssen",
"497134", "Weinsberg",
"493342", "Neuenhagen\ bei\ Berlin",
"494475", "Molbergen",
"499078", "Mertingen",
"499348", "Werbach\-Gamburg",
"4936338", "Bleicherode",
"492526", "Sendenhorst",
"499675", "Altendorf\ am\ Nabburg",
"498781", "Rottenburg\ an\ der\ Laaber",
"493304", "Velten",
"497331", "Geislingen\ an\ der\ Steige",
"4989", "Munich",
"497625", "Zell\ im\ Wiesental",
"495251", "Paderborn",
"493969", "Siedenbollentin",
"4939387", "Havelberg",
"496395", "Münchweiler\ an\ der\ Rodalb",
"492725", "Lennestadt\-Oedingen",
"494432", "Dötlingen\-Brettorf",
"495027", "Linsburg",
"496271", "Eberbach\ Baden",
"495259", "Bad\ Driburg\-Neuenheerse",
"494682", "Amrum",
"493961", "Altentreptow",
"492804", "Xanten\-Marienbaum",
"492842", "Kamp\-Lintfort",
"499556", "Geiselwind",
"4939605", "Gross\ Nemerow",
"4935876", "Weissenberg\ Sachsen",
"499482", "Wörth\ an\ der\ Donau",
"498807", "Diessen\ am\ Ammersee",
"499632", "Waldsassen",
"496122", "Hofheim\-Wallau",
"495654", "Herleshausen",
"4938229", "Bad\ Sülze",
"4939080", "Kalbe\ Milde",
"495903", "Emsbüren",
"494522", "Plön",
"495207", "Schloss\ Holte\-Stukenbrock",
"498230", "Gablingen",
"496362", "Alsenz",
"498345", "Stöttwang",
"498075", "Amerang",
"492445", "Schleiden\ Eifel",
"497585", "Ostrach",
"496674", "Friedewald\ Hessen",
"4938794", "Cumlosen",
"496066", "Michelstadt\-Vielbrunn",
"496754", "Martinstein",
"495706", "Porta\ Westfalica",
"4934361", "Dahlen\ Sachsen",
"494835", "Albersdorf\ Holstein",
"498678", "Marktl",
"495774", "Wagenfeld\-Ströhen",
"498851", "Kochel\ am\ See",
"497265", "Angelbachtal",
"4939853", "Holzendorf\ bei\ Prenzlau",
"494846", "Hattstedt",
"499191", "Forchheim\ Oberfranken",
"495505", "Hardegsen",
"495163", "Fallingbostel\-Dorfmark",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"499199", "Kunreuth",
"4937369", "Wolkenstein",
"495323", "Clausthal\-Zellerfeld",
"494872", "Hanerau\-Hademarschen",
"492693", "Antweiler",
"492686", "Weyerbusch",
"4936732", "Könitz",
"498336", "Erkheim",
"492436", "Wegberg\-Rödgen",
"497567", "Leutkirch\-Friesenhofen",
"499867", "Geslau",
"499394", "Esselbach",
"494743", "Langen\ bei\ Bremerhaven",
"4935607", "Jänschwalde",
"494972", "Langeoog",
"492272", "Bedburg\ Erft",
"496355", "Albisheim\ Pfrimm",
"492747", "Molzhain",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"499263", "Ludwigsstadt",
"497466", "Beuron",
"495045", "Springe\-Bennigsen",
"495375", "Müden\ Aller",
"498702", "Wörth\ an\ der\ Isar",
"496133", "Oppenheim",
"494533", "Reinfeld\ Holstein",
"495648", "Brakel\-Gehrden",
"496849", "Kirkel",
"492246", "Lohmar\ Rheinland",
"498744", "Gerzen",
"4936024", "Diedorf\ bei\ Mühlhausen",
"4938853", "Drönnewitz\ bei\ Hagenow",
"494946", "Grossefehn\-Bagband",
"4935385", "Annaburg",
"499188", "Postbauer\-Heng",
"498534", "Tettenweis",
"496841", "Homburg\ Saar",
"497252", "Bretten",
"4936252", "Tambach\-Dietharz",
"498023", "Bayrischzell",
"499107", "Trautskirchen",
"495332", "Schöppenstedt",
"499409", "Pielenhofen",
"499401", "Neutraubling",
"492235", "Erftstadt",
"494935", "Juist",
"4935828", "Reichenbach\ OL",
"495036", "Neustadt\-Schneeren",
"495803", "Rosche",
"494609", "Eggebek",
"4934973", "Osternienburg",
"499151", "Hersbruck",
"492773", "Haiger",
"492942", "Geseke",
"494242", "Syke",
"497673", "Schönau\ im\ Schwarzwald",
"494777", "Cadenberge",
"499762", "Saal\ an\ der\ Saale",
"493491", "Lutherstadt\ Wittenberg",
"498203", "Grossaitingen",
"494276", "Borstel\ bei\ Sulingen",
"493869", "Dümmer",
"4939832", "Wesenberg",
"4936204", "Stotternheim",
"499354", "Rieneck",
"4934905", "Wörlitz",
"493861", "Plate",
"497753", "Albbruck",
"492904", "Bestwig",
"494204", "Thedinghausen",
"4933209", "Caputh",
"492653", "Kaisersesch",
"496428", "Stadtallendorf",
"492369", "Dorsten\-Wulfen",
"498469", "Freystadt\-Burggriesbach",
"498167", "Zolling",
"494423", "Fedderwarden",
"498327", "Rettenberg",
"49251", "Münster",
"495694", "Diemelstadt",
"492427", "Nideggen",
"4939421", "Osterwieck",
"492129", "Haan\ Rheinland",
"492361", "Recklinghausen",
"498461", "Beilngries",
"498424", "Nassenfels",
"492324", "Hattingen\ Ruhr",
"4933989", "Sadenbeck",
"4939009", "Badel",
"492164", "Jüchen\-Otzenrath",
"493574", "Lauchhammer",
"494950", "Holtland",
"494441", "Vechta",
"492738", "Netphen",
"496737", "Köngernheim",
"495384", "Seesen\-Gross\ Rhüden",
"492548", "Dülmen\-Rorup",
"492839", "Straelen\-Herongen",
"496236", "Neuhofen\ Pfalz",
"499166", "Münchsteinach",
"499641", "Grafenwöhr",
"4938737", "Ganzlin",
"499326", "Markt\ Einersheim",
"492831", "Geldern",
"4935475", "Straupitz",
"497961", "Ellwangen\ Jagst",
"495181", "Alfeld\ Leine",
"495465", "Neuenkirchen\ bei\ Bramsche",
"497046", "Zaberfeld",
"497376", "Langenenslingen",
"4937381", "Penig",
"492052", "Velbert\-Langenberg",
"4934424", "Reuden\ bei\ Zeitz",
"496245", "Biblis",
"498262", "Mittelneufnach",
"497304", "Blaustein\ Württemberg",
"493331", "Angermünde",
"4935243", "Weinböhla",
"4933336", "Passow\ Kreis\ Uckermark",
"499220", "Kasendorf\-Azendorf",
"497072", "Gomaringen",
"499974", "Traitsching",
"4938391", "Altenkirchen\ Rügen",
"4935693", "Lauschütz",
"498456", "Lenting",
"499906", "Mariaposching",
"498582", "Röhrnbach",
"498041", "Bad\ Tölz",
"495492", "Steinfeld\ Oldenburg",
"4936843", "Benshausen",
"492471", "Roetgen\ Eifel",
"495553", "Kalefeld",
"495158", "Hemeringen",
"4934343", "Regis\-Breitingen",
"4938789", "Wolfshagen\ bei\ Perleberg",
"494173", "Wulfsen",
"4936967", "Geisa",
"498295", "Altenmünster\ Schwaben",
"498379", "Waltenhofen\-Oberdorf",
"496573", "Gillenfeld",
"498622", "Tacherting\-Peterskirchen",
"4939325", "Vinzelberg",
"495862", "Hitzacker\ Elbe",
"498106", "Vaterstetten",
"497459", "Nagold\-Hochdorf",
"497157", "Waldenbuch",
"493996", "Teterow",
"4938454", "Kritzkow",
"4937208", "Auerswalde",
"497451", "Horb\ am\ Neckar",
"497940", "Künzelsau",
"4939888", "Lychen",
"495955", "Esterwegen",
"494721", "Cuxhaven",
"494352", "Damp",
"49671", "Bad\ Kreuznach",
"4936640", "Remptendorf",
"499202", "Waischenfeld",
"499244", "Betzenstein",
"492594", "Dülmen",
"49561", "Kassel",
"493585", "Löbau",
"494764", "Gnarrenburg\-Klenkendorf",
"4938206", "Graal\-Müritz\ Seeheilbad",
"494828", "Lägerdorf",
"496051", "Gelnhausen",
"496227", "Walldorf\ Baden",
"4939206", "Eichenbarleben",
"494484", "Hude\-Wüsting",
"494928", "Ihlow\-Riepe",
"4935020", "Struppen",
"495626", "Bad\ Zwesten",
"495102", "Laatzen",
"499337", "Gaukönigshofen",
"495341", "Salzgitter",
"495071", "Schwarmstedt",
"494634", "Husby",
"492228", "Remagen\-Rolandseck",
"4938755", "Eldena",
"496059", "Jossgrund",
"4935434", "Altdöbern",
"4936603", "Weida",
"4939998", "Loitz\ bei\ Demmin",
"495855", "Nahrendorf",
"495144", "Wathlingen",
"4939364", "Dolle",
"499434", "Bodenwöhr",
"4933762", "Zeuthen",
"496875", "Nonnweiler\-Primstal",
"492383", "Bönen",
"498633", "Tüssling",
"496726", "Lorch\ Rheingau",
"497182", "Welzheim",
"4938325", "Rolofshagen",
"495962", "Herzlake",
"494308", "Schwedeneck",
"498509", "Ruderting",
"496303", "Enkenbach\-Alsenborn",
"494365", "Heringsdorf\ Holstein",
"496525", "Irrel",
"4939454", "Elbingerode\ Harz",
"493883", "Hagenow",
"498501", "Thyrnau",
"494125", "Seestermühe",
"493647", "Pössneck",
"496832", "Beckingen\-Reimsbach",
"493466", "Artern\ Unstrut",
"4933831", "Weseram",
"4939242", "Prödel",
"4939391", "Lückstedt",
"499874", "Neuendettelsau",
"496435", "Wallmerod",
"497574", "Gammertingen",
"4935200", "Arnsdorf\ bei\ Dresden",
"498557", "Mauth",
"4935774", "Boxberg\ Sachsen",
"498084", "Taufkirchen\ Vils",
"497506", "Wangen\-Leupolz",
"494392", "Nortorf\ bei\ Neumünster",
"4933458", "Falkenberg\ Mark",
"492554", "Laer\ Kreis\ Steinfurt",
"49931", "Würzburg",
"495198", "Schneverdingen\-Wintermoor",
"494239", "Dörverden\-Westen",
"495767", "Warmsen",
"499569", "Sesslach",
"4939402", "Völpke",
"495452", "Mettingen\ Westfalen",
"496007", "Rosbach\-Rodheim",
"495593", "Bovenden\-Lenglern",
"495586", "Wieda",
"492065", "Duisburg\-Rheinhausen",
"496472", "Weilmünster",
"492931", "Arnsberg",
"4934465", "Bad\ Bibra",
"499561", "Coburg",
"4933368", "Hohensaaten",
"494231", "Verden\ Aller",
"4939743", "Zerrenthin",
"4935327", "Priessen",
"499289", "Schwarzenbach\ am\ Wald",
"495266", "Lemgo\-Kirchheide",
"497824", "Schwanau",
"499524", "Zeil\ am\ Main",
"496667", "Steinau\-Ulmbach",
"492605", "Löf",
"496446", "Hohenahr",
"499281", "Hof\ Saale",
"497705", "Wolterdingen\ Schwarzw",
"497259", "Östringen\-Odenheim",
"4936482", "Triptis",
"498808", "Pähl",
"4938841", "Neuhaus\ Elbe",
"497251", "Bruchsal",
"495625", "Naumburg\ Hessen",
"496842", "Blieskastel",
"494971", "Esens",
"494260", "Visselhövede\-Wittorf",
"496804", "Mandelbachtal",
"495028", "Pennigsehl",
"498709", "Eching\ Niederbayern",
"495292", "Lichtenau\-Atteln",
"492271", "Bergheim\ Erft",
"492395", "Finnentrop\-Rönkhausen",
"496876", "Weiskirchen\ Saar",
"4938425", "Kirchdorf\ Poel",
"496725", "Gau\-Algesheim",
"499444", "Siegenburg",
"494366", "Grömitz\-Cismar",
"496526", "Bollendorf",
"494602", "Freienwill",
"494126", "Horst\ Holstein",
"4939601", "Friedland",
"499347", "Wittighausen",
"499077", "Bachhagel",
"495331", "Wolfenbüttel",
"494644", "Karby",
"4939724", "Klein\ Bünzow",
"495339", "Gielde",
"499402", "Regenstauf",
"4937434", "Bobenneukirchen",
"49906", "Donauwörth",
"4935265", "Glaubitz",
"499724", "Stadtlauringen",
"496693", "Neuental",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"499868", "Schillingsfürst",
"497568", "Bad\ Wurzach\-Hauerz",
"497323", "Gerstetten",
"497163", "Ebersbach\ an\ der\ Fils",
"496436", "Dornburg\ Hessen",
"4936648", "Dittersdorf\ bei\ Schleiz",
"499805", "Burgoberbach",
"497505", "Fronreute",
"492941", "Lippstadt",
"4933704", "Baruth\ Mark",
"499152", "Hartenstein\ Mittelfranken",
"4936741", "Bad\ Blankenburg",
"494241", "Bassum",
"499498", "Laaber",
"494249", "Bassum\-Nordwohlde",
"4937327", "Rechenberg\-Bienenmühle",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"4939053", "Süplingen",
"498677", "Burghausen\ Salzach",
"49361", "Erfurt",
"495585", "Herzberg\-Sieber",
"497903", "Mainhardt",
"4939346", "Tucheim",
"492754", "Bad\ Laasphe\-Feudingen",
"492066", "Duisburg\-Homberg",
"497654", "Löffingen",
"499373", "Amorbach",
"495265", "Dörentrup",
"497774", "Eigeltingen",
"492674", "Bad\ Bertrich",
"4937757", "Rittersgrün",
"499420", "Feldkirchen\ Niederbayern",
"495208", "Leopoldshöhe",
"492606", "Winningen\ Mosel",
"492362", "Dorsten",
"498462", "Berching",
"496445", "Schöffengrund",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"497706", "Oberbaldingen",
"4939267", "Schneidlingen",
"497332", "Lauterstein",
"498782", "Pfeffenhausen",
"4933436", "Prötzel",
"496340", "Wörth\-Schaidt",
"496235", "Schifferstadt",
"493341", "Strausberg",
"499165", "Sugenheim",
"4934324", "Ostrau\ Sachsen",
"499325", "Kleinlangheim",
"497803", "Gengenbach",
"499503", "Oberhaid\ Oberfranken",
"499639", "Mähring",
"4933747", "Marzahna",
"495466", "Merzen",
"499187", "Altdorf\ bei\ Nürnberg",
"492841", "Moers",
"497045", "Oberderdingen",
"497375", "Obermarchtal",
"4934203", "Zwenkau",
"499481", "Pfatter",
"496246", "Eich\ Rheinhessen",
"4938302", "Sagard",
"4935028", "Krippen",
"499631", "Tirschenreuth",
"495647", "Lichtenau\-Kleinenberg",
"4933733", "Stülpe",
"492133", "Dormagen",
"495883", "Lemgow",
"495252", "Bad\ Lippspringe",
"494137", "Barendorf",
"492538", "Drensteinfurt\-Rinkerode",
"4937348", "Oberwiesenthal\ Kurort",
"494431", "Wildeshausen",
"496747", "Emmelshausen",
"493962", "Penzlin\ bei\ Waren",
"494681", "Wyk\ auf\ Föhr",
"492355", "Schalksmühle",
"499905", "Bernried\ Niederbayern",
"496272", "Hirschhorn\ Neckar",
"4934746", "Giersleben",
"494564", "Schashagen",
"496324", "Hassloch",
"496164", "Reichelsheim\ Odenwald",
"4938724", "Siggelkow",
"498296", "Villenbach",
"498283", "Neuburg\ an\ der\ Kammel",
"499234", "Neusorg",
"4933979", "Wusterhausen\ Dosse",
"4934901", "Rosslau\ Elbe",
"496361", "Rockenhausen",
"498105", "Gilching",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"494521", "Eutin",
"4938464", "Bernitt",
"494529", "Süsel\-Bujendorf",
"498563", "Bad\ Birnbach\ Rottal",
"498328", "Balderschwang",
"492428", "Niederzier",
"492984", "Hallenberg",
"496129", "Schlangenbad",
"494284", "Selsingen",
"498168", "Attenkirchen",
"49651", "Trier",
"496427", "Cölbe\-Schönstadt",
"495956", "Rastdorf",
"497930", "Boxberg\ Baden",
"4938354", "Wusterhusen",
"496653", "Burghaun",
"494871", "Hohenwestedt",
"4933473", "Zechin",
"495673", "Immenhausen\ Hessen",
"4938377", "Zinnowitz",
"4935208", "Radeburg",
"49365", "Gera",
"4939425", "Dingelstedt\ am\ Huy",
"498039", "Rott\ am\ Inn",
"4935052", "Kipsdorf\ Kurort",
"495753", "Auetal\-Bernsen",
"499192", "Gräfenberg",
"494778", "Wingst",
"493586", "Neugersdorf\ Sachsen",
"498031", "Rosenheim\ Oberbayern",
"496773", "Kamp\-Bornhofen",
"4934443", "Teuchern",
"4933232", "Brieselang",
"4935341", "Bad\ Liebenwerda",
"499176", "Allersberg",
"499104", "Emskirchen",
"496782", "Birkenfeld\ Nahe",
"4939925", "Wredenhagen",
"497971", "Gaildorf",
"497260", "Sinsheim\-Hilsbach",
"494830", "Süderhastedt",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"499142", "Treuchtlingen",
"493733", "Annaberg\-Buchholz",
"498340", "Baisweil",
"492440", "Nettersheim\-Tondorf",
"492951", "Büren",
"494251", "Hoya",
"4939600", "Zwiedorf",
"495682", "Borken\ Hessen",
"495432", "Löningen",
"4938293", "Kühlungsborn\ Ostseebad",
"492534", "Münster\-Roxel",
"497062", "Beilstein\ Württemberg",
"499964", "Stallwang",
"4933479", "Küstrin\-Kietz",
"498246", "Waal",
"492744", "Herdorf",
"4935793", "Elstra",
"497644", "Kenzingen",
"498537", "Bad\ Füssing\-Aigen",
"497366", "Abtsgmünd",
"495475", "Bohmte\-Hunteburg",
"499929", "Ruhmannsfelden",
"497126", "Burladingen\-Melchingen",
"499921", "Regen",
"498272", "Wertingen",
"496455", "Frankenau\ Hessen",
"497249", "Stutensee",
"495872", "Stoetze",
"498324", "Hindelang",
"492424", "Vettweiss",
"496283", "Hardheim\ Odenwald",
"4938792", "Lenzen\ \(Elbe\)",
"496296", "Ahorn\ Baden",
"496852", "Nohfelden",
"494288", "Horstedt\ Kreis\ Rotenburg",
"498121", "Markt\ Schwaben",
"494505", "Stockelsdorf\-Curau",
"492461", "Jülich",
"498361", "Nesselwang",
"496105", "Mörfelden\-Walldorf",
"495846", "Gartow\ Niedersachsen",
"496328", "Elmstein",
"4935606", "Briesen\ bei\ Cottbus",
"498369", "Rückholz",
"496563", "Kyllburg",
"494323", "Bornhöved",
"498427", "Wellheim",
"499238", "Röslau",
"49851", "Passau",
"492327", "Bochum\-Wattenscheid",
"494163", "Horneburg\ Niederelbe",
"499454", "Aufhausen\ Oberpfalz",
"4939085", "Zichtau",
"494706", "Schiffdorf",
"4936734", "Leutenberg",
"494774", "Hechthausen",
"495835", "Wahrenholz",
"4934241", "Jesewitz",
"4939881", "Ringenwalde\ bei\ Templin",
"495522", "Osterode\ am\ Harz",
"494903", "Wymeer",
"494207", "Oyten",
"499357", "Gräfendorf\ Bayern",
"497620", "Schopfheim\-Gersbach",
"493391", "Neuruppin",
"496039", "Karben",
"492203", "Cologne\-Porz",
"498773", "Neufahrn\ in\ Niederbayern",
"496031", "Friedberg\ Hessen",
"4934691", "Könnern",
"499382", "Gerolzhofen",
"4936254", "Friedrichswerth",
"494803", "Pahlen",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"495609", "Ahnatal",
"4936022", "Grossengottern",
"495601", "Schauenburg",
"4934955", "Gossa",
"496865", "Mettlach\-Orscholz",
"494332", "Hamdorf\ bei\ Rendsburg",
"495069", "Nordstemmen",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"499093", "Polsingen",
"499086", "Fremdingen",
"495935", "Twist\-Schöninghsdorf",
"4936703", "Gräfenthal",
"496701", "Sprendlingen\ Rheinhessen",
"498725", "Wurmannsquick",
"4939991", "Daberkow",
"4939059", "Wegenstedt",
"497431", "Albstadt\-Ebingen",
"495946", "Georgsdorf",
"497681", "Waldkirch\ Breisgau",
"496643", "Herbstein",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"499448", "Hausen\ Niederbayern",
"4933838", "Päwesin",
"495743", "Espelkamp\-Gestringen",
"4933394", "Blumberg\ Kreis\ Barnim",
"492991", "Marsberg\-Bredelar",
"493307", "Zehdenick",
"496887", "Schmelz\ Saar",
"495533", "Bodenwerder",
"495138", "Sehnde",
"499829", "Flachslanden",
"497529", "Waldburg\ Württemberg",
"4936781", "Grossbreitenbach",
"4933093", "Fürstenberg\ Havel",
"49208", "Oberhausen\ Rheinland",
"498686", "Petting",
"49711", "Stuttgart",
"492336", "Schwelm",
"4936202", "Neudietendorf",
"4939398", "Gross\ Garz",
"499397", "Wertheim\-Dertingen",
"497564", "Bad\ Wurzach",
"499728", "Wülfershausen\ Unterfranken",
"495423", "Versmold",
"493722", "Limbach\-Oberfrohna",
"4933451", "Heckelberg",
"4933361", "Joachimsthal",
"496677", "Neuenstein\ Hessen",
"4935877", "Cunewalde",
"493663", "Schleiz",
"495276", "Marienmünster",
"497055", "Neuweiler\ Kreis\ Calw",
"492678", "Büchel\ bei\ Cochem",
"492851", "Rees",
"496256", "Lampertheim\-Hüttenfeld",
"492859", "Wesel\-Bislich",
"495204", "Steinhagen\ Westfalen",
"4939293", "Dreileben",
"495657", "Meissner",
"493836", "Wolgast",
"495242", "Rheda\-Wiedenbrück",
"495777", "Diepenau\-Essern",
"4939386", "Seehausen\ Altmark",
"492758", "Bad\ Berleburg\-Girkhausen",
"499571", "Lichtenfels\ Bayern",
"496757", "Becherbach\ bei\ Kirn",
"498445", "Gerolsbach",
"496462", "Gladenbach",
"492261", "Gummersbach",
"495543", "Staufenberg\ Niedersachsen",
"498051", "Prien\ am\ Chiemsee",
"495148", "Steinhorst\ Niedersachsen",
"4938848", "Vellahn",
"494961", "Papenburg",
"493682", "Zella\-Mehlis",
"4933082", "Menz\ Kreis\ Oberhavel",
"499438", "Fensterbach",
"4936335", "Grosswechsungen",
"495733", "Vlotho",
"4933652", "Neuzelle",
"496866", "Perl\-Nennig",
"492269", "Kierspe\-Rönsahl",
"4939827", "Schwarz\ bei\ Neustrelitz",
"497147", "Sachsenheim\ Württemberg",
"492581", "Warendorf",
"497449", "Baiersbronn\-Obertal",
"499085", "Alerheim",
"495936", "Twist",
"497950", "Schnelldorf",
"497441", "Freudenstadt",
"494488", "Westerstede",
"494924", "Moormerland\-Oldersum",
"496483", "Selters\ Taunus",
"498726", "Schönau\ Niederbayern",
"496633", "Homberg\ Ohm",
"492224", "Bad\ Honnef",
"494638", "Tarp",
"498303", "Waltenhofen",
"492403", "Eschweiler\ Rheinland",
"496509", "Büdlich",
"495945", "Wilsum",
"494109", "Tangstedt\ Bz\ Hamburg",
"494407", "Wardenburg",
"494101", "Pinneberg",
"494342", "Preetz\ Kreis\ Plön",
"4939749", "Grambow\ bei\ Pasewalk",
"496501", "Konz",
"493475", "Lutherstadt\ Eisleben",
"499607", "Luhe\-Wildenau",
"499254", "Gefrees",
"4933872", "Hohennauen",
"4939608", "Staven",
"4935891", "Rothenburg\ OL",
"4939977", "Jördenstorf",
"494451", "Varel\ Jadebusen",
"498685", "Kirchanschöring",
"498435", "Ehekirchen",
"492335", "Wetter\ Ruhr",
"499779", "Nordheim\ von\ der\ Rhön",
"4933604", "Lebus",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"496084", "Schmitten\ Taunus",
"492153", "Nettetal\-Lobberich",
"495232", "Lage\ Lippe",
"496557", "Hallschlag",
"4939954", "Stavenhagen\ Reuterstadt",
"492558", "Horstmar",
"497173", "Heubach",
"497578", "Wald\ Hohenz",
"499651", "Vohenstrauss",
"499659", "Leuchtenberg",
"492664", "Rennerod",
"499123", "Lauf\ an\ der\ Pegnitz",
"495275", "Höxter\-Ottbergen",
"497056", "Gechingen",
"497764", "Herrischried",
"499528", "Donnersdorf",
"499363", "Arnstein\ Unterfranken",
"496255", "Lindenfels",
"4935934", "Grossdubrau",
"492372", "Hemer",
"4933922", "Karwesee",
"493522", "Grossenhain\ Sachsen",
"497352", "Ochsenhausen",
"495194", "Bispingen",
"497729", "Tennenbronn",
"498667", "Seeon\-Seebruck",
"495827", "Unterlüss",
"497721", "Villingen\ im\ Schwarzwald",
"492621", "Lahnstein",
"498446", "Pörnbach",
"495223", "Bünde",
"4936849", "Kleinschmalkalden",
"493935", "Tangerhütte",
"499175", "Spalt",
"497387", "Hohenstein\ Württemberg",
"492502", "Nottuln",
"4933844", "Brück\ Brandenburg",
"4938783", "Dallmin",
"498547", "Osterhofen\-Gergweis",
"492734", "Freudenberg\ Westfalen",
"498236", "Fischach",
"497484", "Simmersfeld",
"499294", "Regnitzlosau",
"497634", "Sulzburg",
"493601", "Mühlhausen\ Thüringen",
"4933830", "Ziesar",
"4936374", "Weissensee",
"4935388", "Klöden",
"499978", "Schönthal\ Oberpfalz",
"4935021", "Königstein\ Sächsische\ Schweiz",
"493533", "Elsterwerda",
"498091", "Kirchseeon",
"495442", "Barnstorf\ Kreis\ Diepholz",
"498330", "Legau",
"498245", "Türkheim\ Wertach",
"496262", "Aglasterhausen",
"4934492", "Lucka",
"499132", "Herzogenaurach",
"495307", "Braunschweig\-Wenden",
"4935825", "Kodersdorf",
"4934654", "Stolberg\ Harz",
"492680", "Mündersbach",
"497365", "Essingen\ Württemberg",
"495476", "Ostercappeln\-Venne",
"4937341", "Ehrenfriedersdorf",
"4938486", "Gustävel",
"497125", "Bad\ Urach",
"494182", "Tostedt",
"497308", "Nersingen",
"4933633", "Spreenhagen",
"496582", "Freudenburg",
"496456", "Haina\ Kloster",
"495404", "Westerkappeln",
"493946", "Quedlinburg",
"4933676", "Friedland\ bei\ Beeskow",
"497083", "Bad\ Herrenalb",
"496371", "Landstuhl",
"496041", "Glauburg",
"4934296", "Groitzsch\ bei\ Pegau",
"495722", "Bückeburg",
"492520", "Wadersloh\-Diestedde",
"493423", "Eilenburg",
"4937292", "Oederan",
"498178", "Icking",
"498573", "Ering",
"496049", "Kefenrod",
"496295", "Rosenberg\ Baden",
"495351", "Helmstedt",
"4934924", "Zahna",
"494506", "Stockelsdorf\-Krumbeck",
"4934383", "Trebsen\ Mulde",
"497392", "Laupheim",
"496106", "Rodgau",
"495845", "Bergen\ Dumme",
"496622", "Bebra",
"495154", "Aerzen",
"496174", "Königstein\ im\ Taunus",
"4935201", "Langebrück",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"4938827", "Kalkhorst",
"494705", "Wremen",
"494491", "Friesoythe",
"494499", "Barssel",
"49871", "Landshut",
"4939390", "Iden",
"4935249", "Basslitz",
"492598", "Senden\-Ottmarsbocholt",
"495836", "Wittingen\-Radenbeck",
"492193", "Dabringhausen",
"4937606", "Lengenfeld\ Vogtland",
"496763", "Kirchberg\ Hunsrück",
"494824", "Krempe",
"494768", "Hipstedt",
"496597", "Jünkerath",
"494861", "Tönning",
"497231", "Pforzheim",
"4935975", "Hohnstein",
"498823", "Mittenwald",
"495663", "Spangenberg",
"4939921", "Ankershagen",
"494331", "Rendsburg",
"495644", "Willebadessen\-Peckelsheim",
"492455", "Waldfeucht",
"499184", "Deining\ Oberpfalz",
"498133", "Haimhausen\ Oberbayern",
"495062", "Holle\ bei\ Hildesheim",
"494339", "Christiansholm",
"49921", "Bayreuth",
"498538", "Pocking\-Hartkirchen",
"499381", "Volkach",
"496744", "Oberwesel",
"495126", "Algermissen",
"495602", "Hessisch\ Lichtenau",
"4935478", "Goyatz",
"494134", "Embsen\ Kreis\ Lüneburg",
"495366", "Jembke",
"498841", "Murnau\ am\ Staffelsee",
"4936484", "Knau\ bei\ Pössneck",
"497475", "Burladingen",
"496534", "Mülheim\ Mosel",
"4933203", "Kleinmachnow",
"496023", "Alzenau\ in\ Unterfranken",
"494856", "Kronprinzenkoog",
"494292", "Ritterhude",
"492992", "Marsberg",
"495971", "Rheine",
"4939722", "Sarnow\ bei\ Anklam",
"4937432", "Pausa\ Vogtland",
"496440", "Kölschhausen",
"493441", "Zeitz",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"497432", "Albstadt\-Tailfingen",
"4938376", "Zirchow",
"4939003", "Jübar",
"497682", "Elzach",
"494625", "Jübek",
"497835", "Zell\ am\ Harmersbach",
"499535", "Pfarrweisach",
"494265", "Fintel",
"4933437", "Reichenberg\ bei\ Strausberg",
"4938333", "Horst\ bei\ Grimmen",
"493721", "Meinersdorf",
"499358", "Gössenheim",
"496203", "Ladenburg",
"4933702", "Wünsdorf",
"499745", "Wildflecken",
"494208", "Grasberg",
"4939328", "Rochau",
"4938859", "Alt\ Zachun",
"493764", "Meerane",
"496185", "Hammersbach\ Hessen",
"498860", "Bernbeuren",
"499822", "Bechhofen\ an\ der\ Heide",
"497522", "Wangen\ im\ Allgäu",
"4939266", "Förderstedt",
"496167", "Modautal",
"492563", "Stadtlohn",
"495241", "Gütersloh",
"499933", "Wallersdorf",
"4939885", "Jakobshagen",
"493578", "Kamenz",
"494793", "Hambergen",
"496327", "Neustadt\-Lachen",
"4936944", "Rentwertshausen",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"496461", "Biedenkopf",
"4934776", "Rothenschirmbach",
"499572", "Burgkunstadt",
"494287", "Heeslingen\-Boitzen",
"4936626", "Auma",
"496424", "Ebsdorfergrund",
"499736", "Oberthulba",
"492852", "Hamminkeln",
"492296", "Reichshof\-Brüchermühle",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"4939223", "Theessen",
"499546", "Burgebrach",
"4933746", "Werbig\ bei\ Jüterbog",
"495439", "Bersenbrück",
"4937326", "Frauenstein\ Sachsen",
"492952", "Rüthen",
"499302", "Rottendorf\ Unterfranken",
"495137", "Seelze",
"499141", "Weissenburg\ in\ Bayern",
"4938223", "Saal\ Vorpom",
"494883", "Süderstapel",
"499666", "Illschwang",
"494252", "Bruchhausen\-Vilsen",
"496888", "Lebach\-Steinbach",
"495681", "Homberg\ Efze",
"4938758", "Dömitz",
"499149", "Weissenburg\-Suffersheim",
"499447", "Essing",
"495431", "Quakenbrück",
"497946", "Bretzfeld",
"4934322", "Rosswein",
"497138", "Schwaigern",
"494466", "Wittmund\-Ardorf",
"496789", "Heimbach\ Nahe",
"4939995", "Nossendorf",
"497533", "Allensbach",
"499833", "Heidenheim\ Mittelfranken",
"497743", "Ühlingen\-Birkendorf",
"496781", "Idar\-Oberstein",
"499344", "Gerchsheim",
"499074", "Höchstädt\ an\ der\ Donau",
"497972", "Gschwend\ bei\ Gaildorf",
"492643", "Altenahr",
"4969", "Frankfurt\ am\ Main",
"4939859", "Fürstenwerder",
"498395", "Tannheim\ Württemberg",
"493928", "Schönebeck\ Elbe",
"4938328", "Miltzow",
"493634", "Sömmerda",
"4938871", "Mühlen\ Eichsen",
"497024", "Wendlingen\ am\ Neckar",
"499922", "Zwiesel",
"4937363", "Zöblitz",
"498271", "Meitingen",
"4937756", "Breitenbrunn\ Erzgebirge",
"4939347", "Kade",
"4935723", "Bernsdorf\ OL",
"492865", "Raesfeld",
"497935", "Schrozberg",
"4938304", "Garz\ Rügen",
"497657", "Eisenbach\ Hochschwarzwald",
"496758", "Waldböckelheim",
"498122", "Erding",
"494753", "Balje",
"498362", "Füssen",
"496345", "Albersweiler",
"497204", "Malsch\-Völkersbach",
"492462", "Linnich",
"4938462", "Baumgarten",
"495055", "Fassberg",
"499473", "Kallmünz",
"4936785", "Gräfinau\-Angstedt",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"4939034", "Fleetmark",
"498754", "Volkenschwand",
"4938722", "Raduhn",
"498066", "Bad\ Feilnbach",
"495658", "Wehretal",
"492256", "Mechernich\-Satzvey",
"494956", "Uplengen",
"492677", "Lutzerath",
"497242", "Rheinstetten",
"496851", "St\ Wendel",
"494673", "Joldelund",
"496678", "Wildeck\-Hönebach",
"497777", "Sauldorf",
"4933234", "Wustermark",
"495521", "Herzberg\ am\ Harz",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"4935054", "Lauenstein\ Sachsen",
"498450", "Ingolstadt\-Zuchering",
"495284", "Schwalenberg",
"496032", "Bad\ Nauheim",
"495529", "Rhumspringe",
"499727", "Schonungen\-Marktsteinach",
"499398", "Birkenfeld\ bei\ Würzburg",
"49511", "Hannover",
"497423", "Oberndorf\ am\ Neckar",
"495564", "Dassel",
"496336", "Dellfeld",
"4938352", "Kemnitz\ bei\ Greifswald",
"493366", "Beeskow",
"4936331", "Ilfeld",
"499665", "Königstein\ Oberpfalz",
"499608", "Kohlberg\ Oberpfalz",
"497945", "Wüstenrot",
"4937463", "Bergen\ Vogtland",
"494465", "Friedeburg\ Ostfriesland",
"49340", "Dessau\ Anh",
"492501", "Münster\-Hiltrup",
"494408", "Hude\ Oldenburg",
"496403", "Linden\ Hessen",
"492509", "Nottuln\-Appelhülsen",
"4935756", "Hosena",
"4938428", "Hohenkirchen\ bei\ Wismar",
"493644", "Apolda",
"4935363", "Fermerswalde",
"498383", "Grünenbach\ Allgäu",
"499334", "Giebelstadt",
"496589", "Kell\ am\ See",
"494637", "Sterup",
"497733", "Engen\ Hegau",
"4935453", "Drahnsdorf",
"496224", "Sandhausen\ Baden",
"494189", "Undeloh",
"492633", "Brohl\-Lützing",
"494487", "Grossenkneten\-Huntlosen",
"494181", "Buchholz\ in\ der\ Nordheide",
"497148", "Grossbottwar",
"497543", "Kressbronn\ am\ Bodensee",
"499843", "Burgbernheim",
"496581", "Saarburg",
"494384", "Selent",
"496269", "Gundelsheim\ Württemberg",
"492866", "Dorsten\-Rhade",
"4934422", "Osterfeld",
"498092", "Grafing\ bei\ München",
"497936", "Schrozberg\-Bartenstein",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"495441", "Diepholz",
"4935895", "Klitten",
"493971", "Anklam",
"4935268", "Stauchitz",
"495147", "Uetze\-Hänigsen",
"499131", "Erlangen",
"496261", "Mosbach\ Baden",
"4939773", "Altwarp",
"496346", "Annweiler\ am\ Trifels",
"4938452", "Lalendorf",
"496621", "Bad\ Hersfeld",
"497391", "Ehingen\ Donau",
"495056", "Winsen\-Meissendorf",
"495764", "Steyerberg",
"496004", "Lich\-Eberstadt",
"497275", "Kandel",
"496629", "Schenklengsfeld",
"495828", "Himbergen",
"4936645", "Mühltroff",
"49461", "Flensburg",
"496042", "Büdingen\ Hessen",
"498065", "Tuntenhausen\-Schönau",
"496372", "Bruchmühlbach\-Miesau",
"4939207", "Colbitz",
"492255", "Euskirchen\-Flamersheim",
"494955", "Westoverledingen",
"495721", "Stadthagen",
"49941", "Regensburg",
"499527", "Knetzgau",
"496664", "Sinntal\-Sterbfritz",
"495352", "Schöningen",
"497194", "Spiegelberg",
"494862", "Garding",
"498554", "Schönberg\ Niederbayern",
"497232", "Königsbach\-Stein",
"497577", "Veringenstadt",
"494158", "Roseburg",
"492557", "Wettringen\ Kreis\ Steinfurt",
"4934263", "Hohburg",
"4939320", "Schinne",
"496558", "Büdesheim\ Eifel",
"494492", "Saterland",
"494553", "Geschendorf",
"499225", "Stadtsteinach",
"495173", "Uetze",
"496335", "Trulben",
"4938320", "Tribsees",
"492456", "Selfkant",
"4933764", "Mittenwalde\ Mark",
"497307", "Senden\ Iller",
"492582", "Everswinkel",
"497442", "Baiersbronn",
"4939362", "Grieben\ bei\ Tangerhütte",
"498052", "Aschau\ im\ Chiemgau",
"493431", "Döbeln",
"497404", "Epfendorf",
"492262", "Wiehl",
"496430", "Hahnstätten",
"495308", "Lehre",
"4936966", "Kaltennordheim",
"494962", "Papenburg\-Aschendorf",
"493681", "Suhl",
"495365", "Wolfsburg\-Neindorf",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"499977", "Arnschwang",
"497476", "Bisingen",
"494144", "Himmelpforten",
"494855", "Eddelak",
"4939244", "Steutz",
"496544", "Rhaunen",
"4938207", "Stäbelow",
"4935025", "Liebstadt",
"496734", "Flonheim",
"499426", "Oberschneiding",
"497223", "Bühl\ Baden",
"4938750", "Malliss",
"4939452", "Ilsenburg",
"498143", "Inning\ am\ Ammersee",
"498548", "Vilshofen\-Sandbach",
"494349", "Dänischenhagen",
"495634", "Waldeck\-Sachsenhausen",
"494102", "Ahrensburg",
"497388", "Pfronstetten",
"494626", "Treia",
"496502", "Schweich",
"495484", "Lienen\-Kattenvenne",
"498250", "Hilgertshausen\-Tandern",
"4936923", "Treffurt",
"499536", "Kirchlauter",
"497836", "Schiltach",
"4934639", "Wallendorf\ Luppe",
"495850", "Neetze",
"499652", "Waidhaus",
"49465", "Sylt",
"494266", "Brockel",
"493871", "Parchim",
"4938736", "Goldberg",
"499746", "Zeitlofs",
"494452", "Zetel\-Neuenburg",
"494767", "Bremervörde\-Bevern",
"4936083", "Uder",
"497663", "Eichstetten",
"492597", "Senden\ Westfalen",
"4935772", "Rietschen",
"492763", "Drolshagen\-Bleche",
"496186", "Grosskrotzenburg",
"499943", "Lam\ Oberpfalz",
"495231", "Detmold",
"4936653", "Lehesten\ Thüringer\ Wald",
"499772", "Bischofsheim\ an\ der\ Rhön",
"492174", "Burscheid\ Rheinland",
"493564", "Schwarze\ Pumpe",
"497351", "Biberach\ an\ der\ Riss",
"4935205", "Ottendorf\-Okrilla",
"497722", "Triberg\ im\ Schwarzwald",
"4939428", "Pabstorf",
"495083", "Hohne\ bei\ Celle",
"492622", "Bendorf\ am\ Rhein",
"4936873", "Themar",
"4935971", "Sebnitz",
"493529", "Heidenau\ Sachsen",
"4933337", "Altkünkendorf",
"498177", "Münsing\ Starnberger\ See",
"499735", "Massbach",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"492295", "Ruppichteroth",
"492379", "Menden\-Asbeck",
"4939404", "Ausleben",
"492371", "Iserlohn",
"492041", "Bottrop",
"497154", "Kornwestheim",
"499545", "Buttenheim",
"494120", "Ellerhoop",
"493521", "Meissen",
"492574", "Saerbeck",
"496785", "Herrstein",
"4939955", "Jürgenstorf",
"492506", "Münster\-Wolbeck",
"4933605", "Boossen",
"4938483", "Brüel",
"495435", "Berge\ bei\ Quakenbrück",
"495685", "Knüllwald",
"49351", "Dresden",
"4938209", "Sanitz\ bei\ Rostock",
"4933920", "Walsleben\ bei\ Neuruppin",
"496120", "Aarbergen",
"498232", "Schwabmünchen",
"493361", "Fürstenwalde\ Spree",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"499854", "Wittelshofen",
"499145", "Solnhofen",
"497554", "Heiligenberg\ Baden",
"493976", "Torgelow\ bei\ Ueckermünde",
"498194", "Vilgertshofen",
"4936427", "Dornburg\ Saale",
"4935935", "Kleinwelka",
"497939", "Schrozberg\-Spielbach",
"496266", "Hassmersheim",
"492861", "Borken\ Westfalen",
"497931", "Bad\ Mergentheim",
"495446", "Rehden",
"493904", "Haldensleben",
"497668", "Ihringen",
"496452", "Battenberg\ Eder",
"493773", "Johanngeorgenstadt",
"496586", "Beuren\ Hochwald",
"496593", "Hillesheim\ Eifel",
"496198", "Eppstein",
"494186", "Buchholz\-Trelde",
"492824", "Kalkar",
"494193", "Henstedt\-Ulzburg",
"499948", "Eschlkam",
"495472", "Bad\ Essen",
"496855", "Freisen",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"494544", "Berkenthin",
"4936334", "Wolkramshausen",
"4936076", "Niederorschel",
"4937603", "Wildenfels",
"4933870", "Zollchow\ bei\ Rathenow",
"495726", "Wiedensahl",
"494734", "Stadland\-Seefeld",
"495875", "Emmendorf",
"497228", "Forbach",
"495051", "Bergen\ Kreis\ Celle",
"498543", "Aidenbach",
"496349", "Billigheim\-Ingenheim",
"496102", "Neu\-Isenburg",
"498733", "Mengkofen",
"496341", "Landau\ in\ der\ Pfalz",
"496071", "Dieburg",
"496626", "Wildeck\-Obersuhl",
"497383", "Münsingen\-Buttenhausen",
"495923", "Schüttorf",
"494502", "Lübeck\-Travemünde",
"4934293", "Naunhof\ bei\ Grimma",
"499480", "Sünching",
"495832", "Hankensbüttel",
"492182", "Grevenbroich\-Kapellen",
"4933673", "Weichensdorf",
"4938392", "Sassnitz",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"495303", "Wendeburg",
"493537", "Jessen\ Elster",
"499278", "Weidenberg",
"4934637", "Frankleben",
"495525", "Walkenried",
"4937382", "Geringswalde",
"498845", "Bad\ Kohlgrub",
"4934925", "Bad\ Schmiedeberg",
"497471", "Hechingen",
"493693", "Meiningen",
"493686", "Eisfeld",
"499385", "Kolitzheim",
"496158", "Riedstadt",
"498722", "Gangkofen",
"4934600", "Ostrau\ Saalkreis",
"494153", "Lauenburg\ Elbe",
"494558", "Todesfelde",
"492157", "Nettetal\-Kaldenkirchen",
"496553", "Schönecken",
"495932", "Haren\ Ems",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"492451", "Geilenkirchen",
"495573", "Uslar\-Volpriehausen",
"4936208", "Ermstedt",
"494240", "Syke\-Heiligenfelde",
"49355", "Cottbus",
"494335", "Hohn\ bei\ Rendsburg",
"494346", "Gettorf",
"494621", "Schleswig",
"498663", "Ruhpolding",
"495823", "Bienenbüttel",
"49661", "Fulda",
"499464", "Walderbach",
"494372", "Westfehmarn",
"499421", "Straubing",
"4935974", "Hinterhermsdorf",
"493445", "Naumburg\ Saale",
"495975", "Rheine\-Mesum",
"494664", "Neukirchen\ bei\ Niebüll",
"499367", "Unterpleichfeld",
"499127", "Rosstal\ Mittelfranken",
"4939401", "Neuwegersleben",
"49571", "Minden\ Westfalen",
"499429", "Rain\ Niederbayern",
"497738", "Steisslingen",
"496637", "Feldatal",
"492924", "Möhnesee",
"498388", "Hergensweiler",
"495236", "Blomberg\-Grossenmarpe",
"497250", "Kraichtal",
"492638", "Waldbreitbach",
"494224", "Gross\ Ippener",
"4933845", "Borkheide",
"497143", "Besigheim",
"496181", "Hanau",
"499848", "Simmershofen",
"493876", "Perleberg",
"499741", "Bad\ Brückenau",
"497839", "Schapbach",
"496384", "Konken",
"494269", "Ahausen\-Kirchwalsede",
"4936375", "Kindelbrück",
"498223", "Ichenhausen",
"493725", "Zschopau",
"494261", "Rotenburg\ Wümme",
"492961", "Brilon",
"4936028", "Kammerforst\ Thüringen",
"499749", "Oberbach\ Unterfranken",
"499531", "Ebern",
"497831", "Hausach",
"4933832", "Rogäsen",
"4939483", "Ballenstedt",
"4933962", "Heiligengrabe",
"4939241", "Leitzkau",
"498404", "Oberdolling",
"492304", "Schwerte",
"499954", "Simbach\ Niederbayern",
"497052", "Bad\ Liebenzell",
"4939209", "Wanzleben",
"499603", "Floss",
"498442", "Wolnzach",
"496465", "Breidenbach\ bei\ Biedenkopf",
"496408", "Buseck",
"494403", "Bad\ Zwischenahn",
"492407", "Herzogenrath\-Kohlscheid",
"497356", "Schemmerhofen",
"495245", "Herzebrock\-Clarholz",
"495361", "Wolfsburg",
"498846", "Uffing\ am\ Staffelsee",
"495121", "Hildesheim",
"493685", "Hildburghausen",
"495129", "Söhlde",
"49551", "Göttingen",
"495427", "Melle\-Buer",
"492694", "Wershofen",
"4936742", "Uhlstädt",
"499386", "Prosselsheim",
"4939349", "Parey\ Elbe",
"499393", "Rothenfels\ Unterfranken",
"493435", "Oschatz",
"497428", "Rosenfeld",
"495164", "Hodenhagen",
"499082", "Oettingen\ in\ Bayern",
"4939857", "Drense",
"495324", "Vienenburg",
"494336", "Owschlag",
"494758", "Nordleda",
"496753", "Meisenheim",
"499560", "Grub\ am\ Forst",
"494230", "Verden\-Walle",
"4939084", "Lindstedt",
"4936735", "Probstzella",
"49375", "Zwickau",
"495942", "Uelsen",
"495773", "Stemwede\-Wehdem",
"4936941", "Wasungen",
"495653", "Sontra",
"4935843", "Hirschfelde\ bei\ Zittau",
"494859", "Windbergen",
"495904", "Lengerich\ Emsl",
"499280", "Selbitz\ Oberfranken",
"495976", "Salzbergen",
"494851", "Marne",
"496673", "Haunetal",
"4933928", "Wildberg\ Brandenburg",
"493923", "Zerbst",
"495235", "Blomberg\ Lippe",
"4939924", "Stuer",
"4936693", "Crossen\ an\ der\ Elster",
"496050", "Biebergemünd",
"498432", "Burgheim",
"499097", "Marxheim",
"492332", "Gevelsberg",
"498682", "Laufen\ Salzach",
"4939296", "Welsleben",
"4933088", "Falkenthal",
"4938842", "Lüttenmark",
"493726", "Flöha",
"4936481", "Neustadt\ an\ der\ Orla",
"4939383", "Sandau\ Elbe",
"492803", "Wesel\-Büderich",
"493525", "Riesa",
"492375", "Balve",
"492045", "Bottrop\-Kirchhellen",
"496252", "Heppenheim\ Bergstrasse",
"497841", "Achern",
"499549", "Lisberg",
"4939602", "Kleeth",
"492291", "Waldbröl",
"495272", "Brakel\ Westfalen",
"493303", "Birkenwerder",
"4933878", "Nennhausen",
"496466", "Dautphetal\-Friedensdorf",
"497133", "Lauffen\ am\ Neckar",
"496647", "Herbstein\-Stockhausen",
"497748", "Grafenhausen\ Hochschwarzwald",
"497355", "Hochdorf\ Riss",
"495246", "Verl",
"492323", "Herne",
"499938", "Moos\ Niederbayern",
"498423", "Titting",
"494167", "Apensen",
"492568", "Heek",
"494469", "Wangerooge",
"496567", "Oberkail",
"493573", "Senftenberg",
"496786", "Kempfeld",
"492163", "Schwalmtal\ Niederrhein",
"494327", "Grossenaspe",
"499624", "Ensdorf\ Oberpfalz",
"4935796", "Panschwitz\-Kuckau",
"498370", "Wiggensbach",
"492505", "Altenberge\ Westfalen",
"499172", "Georgensgmünd",
"494461", "Jever",
"4939031", "Dähre",
"496287", "Limbach\ Baden",
"495436", "Nortrup",
"497941", "Öhringen",
"495693", "Volkmarsen",
"495686", "Schwarzenborn\ Knüll",
"499661", "Sulzbach\-Rosenberg",
"497949", "Pfedelbach\-Untersteinbach",
"499146", "Markt\ Berolzheim",
"4937298", "Oelsnitz\ Erzgebirge",
"49371", "Chemnitz\ Sachsen",
"4933231", "Pausin",
"499135", "Hessdorf\ Mittelfranken",
"496265", "Billigheim\ Baden",
"499353", "Karlstadt",
"495445", "Drebber",
"497754", "Görwihl",
"497066", "Bad\ Rappenau\-Bonfeld",
"492903", "Meschede\-Freienohl",
"4933976", "Wutike",
"492207", "Kürten\-Dürscheid",
"494203", "Weyhe\ bei\ Bremen",
"492654", "Polch",
"492774", "Dietzhölztal",
"496585", "Ralingen",
"498276", "Baar\ Schwaben",
"497674", "Todtmoos",
"494185", "Marxen\ Auetal",
"497122", "St\ Johann\ Württemberg",
"4936200", "Elxleben\ bei\ Arnstadt",
"4938296", "Rerik\ Ostseebad",
"498657", "Ramsau\ bei\ Berchtesgaden",
"497362", "Bopfingen",
"498204", "Mickhausen",
"496856", "St\ Wendel\-Niederkirchen",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"496028", "Sulzbach\ am\ Main",
"496292", "Seckach",
"494959", "Dollart",
"494951", "Weener",
"495725", "Lindhorst\ bei\ Stadthagen",
"4934977", "Quellendorf",
"49214", "Leverkusen",
"498061", "Bad\ Aibling",
"4936255", "Goldbach\ bei\ Gotha",
"493737", "Rochlitz",
"492251", "Euskirchen",
"498024", "Holzkirchen",
"4933933", "Lindow\ Mark",
"497271", "Wörth\ am\ Rhein",
"495842", "Schnega",
"496625", "Niederaula",
"497395", "Ehingen\-Dächingen",
"4938874", "Lützow",
"498743", "Geisenhausen",
"496331", "Pirmasens",
"499221", "Kulmbach",
"494702", "Sandstedt",
"499229", "Mainleus",
"498138", "Schwabhausen\ bei\ Dachau",
"496339", "Grosssteinhausen",
"498533", "Rotthalmünster",
"494744", "Loxstedt",
"4938301", "Putbus",
"4934783", "Gerbstedt",
"4933439", "Fredersdorf\-Vogelsdorf",
"499264", "Küps",
"4936020", "Ebeleben",
"4933395", "Zerpenschleuse",
"496134", "Mainz\-Kastel",
"4934498", "Rositz",
"4935603", "Burg\ Spreewald",
"4930", "Berlin",
"494534", "Steinburg\ Kreis\ Storman",
"498721", "Eggenfelden",
"4936644", "Hirschberg\ Saale",
"4933601", "Podelzig",
"499243", "Pottenstein",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"495931", "Meppen",
"497446", "Lossburg",
"4939322", "Tangermünde",
"495065", "Sibbesse",
"492593", "Ascheberg\ Westfalen",
"492586", "Beelen",
"495939", "Sustrum",
"492452", "Heinsberg\ Rheinland",
"494763", "Gnarrenburg",
"496824", "Ottweiler",
"4939951", "Faulenrost",
"497667", "Breisach\ am\ Rhein",
"497472", "Rottenburg\ am\ Neckar",
"493860", "Raben\ Steinfeld",
"496861", "Merzig",
"495605", "Kaufungen\ Hessen",
"4933708", "Rangsdorf",
"494966", "Neubörger",
"4936926", "Creuzburg",
"492266", "Lindlar",
"496869", "Merzig\-Silwingen",
"498764", "Mauern\ Kreis\ Freising",
"498056", "Eggstätt",
"499422", "Bogen\ Niederbayern",
"494371", "Burg\ auf\ Fehmarn",
"498460", "Berching\-Holnstein",
"492360", "Haltern\-Lippramsdorf",
"493984", "Prenzlau",
"4939752", "Blumenhagen\ bei\ Strasburg",
"4935931", "Königswartha",
"494295", "Emtinghausen",
"4936963", "Dorndorf\ Rhön",
"496506", "Welschbillig",
"495554", "Moringen",
"4938450", "Tarnow\ bei\ Bützow",
"494106", "Quickborn\ Kreis\ Pinneberg",
"494622", "Taarstedt",
"497685", "Gutach\-Bleibach",
"494174", "Stelle\ Kreis\ Harburg",
"4934347", "Oelzschau\ bei\ Borna",
"4938232", "Zingst\ Ostseebad",
"4936847", "Steinbach\-Hallenberg",
"497435", "Albstadt\-Laufen",
"496574", "Hasborn",
"499742", "Kalbach\ Rhön",
"499277", "Warmensteinach",
"499973", "Furth\ im\ Wald",
"4935697", "Bagenz",
"494262", "Visselhövede",
"499656", "Moosbach\ bei\ Vohenstrauss",
"492962", "Olsberg",
"4935472", "Schlepzig",
"499532", "Maroldsweisach",
"497832", "Haslach\ im\ Kinzigtal",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"497525", "Aulendorf",
"499825", "Herrieden",
"499776", "Mellrichstadt",
"493841", "Wismar",
"4935247", "Zehren\ Sachsen",
"499704", "Euerdorf",
"496182", "Seligenstadt",
"497303", "Illertissen",
"494456", "Varel\-Altjührden",
"499575", "Weismain",
"492626", "Selters\ Westferwald",
"495228", "Vlotho\-Exter",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"492102", "Ratingen",
"497726", "Bad\ Dürrheim",
"4938733", "Karbow\-Vietlübbe",
"4939728", "Medow\ bei\ Anklam",
"497227", "Lichtenau\ Baden",
"4937438", "Bad\ Brambach",
"495383", "Lutter\ am\ Barenberge",
"497051", "Calw",
"492855", "Voerde\ Niederrhein",
"4935894", "Hähnichen",
"4935456", "Terpt",
"498239", "Langenneufnach",
"499128", "Feucht",
"4938728", "Domsühl",
"499523", "Hofheim\ in\ Unterfranken",
"497823", "Seelbach\ Schutter",
"494255", "Martfeld",
"493606", "Heiligenstadt\ Heilbad",
"4934921", "Kemberg",
"499305", "Estenfeld",
"498231", "Königsbrunn\ bei\ Augsburg",
"493362", "Erkner",
"492955", "Büren\-Wewelsburg",
"4935323", "Sonnewalde",
"4939747", "Züsedom",
"49771", "Donaueschingen",
"497975", "Untergröningen",
"49261", "Koblenz\ am\ Rhein",
"495594", "Bovenden\-Reyershausen",
"4937423", "Adorf\ Vogtland",
"496451", "Frankenberg\ Eder",
"495177", "Edemissen\-Abbensen",
"493941", "Halberstadt",
"4935204", "Wilsdruff",
"499925", "Bayerisch\ Eisenstein",
"492158", "Grefrath\ bei\ Krefeld",
"494557", "Blunk",
"493949", "Oschersleben\ Bode",
"492553", "Ochtrup",
"499190", "Heroldsbach",
"498392", "Markt\ Rettenbach",
"495471", "Bohmte",
"496157", "Pfungstadt",
"4939829", "Blankenförde",
"4934722", "Preusslitz",
"4939405", "Hötensleben",
"497573", "Stetten\ am\ kalten\ Markt",
"499873", "Abenberg\-Wassermungenau",
"492862", "Südlohn",
"498083", "Isen",
"4934462", "Laucha\ Unstrut",
"497932", "Niederstetten\ Württemberg",
"4935753", "Grossräschen",
"494509", "Gross\ Grönau",
"492408", "Aachen\-Kornelimünster",
"496109", "Frankfurt\-Bergen\-Enkheim",
"496407", "Rabenau\ Hessen",
"495052", "Hermannsburg",
"4933765", "Märkisch\ Buchholz",
"498365", "Wertach",
"496342", "Schweigen\-Rechtenbach",
"492465", "Inden",
"496101", "Bad\ Vilbel",
"4933841", "Belzig",
"494501", "Kastorf\ Holstein",
"496304", "Wolfstein\ Pfalz",
"497245", "Durmersheim",
"495356", "Helmstedt\-Barmke",
"4934328", "Hartha\ bei\ Döbeln",
"4936371", "Schlossvippach",
"496046", "Ortenberg\ Hessen",
"4938752", "Zierzow\ bei\ Ludwigslust",
"496035", "Reichelsheim\ Wetterau",
"4939776", "Hintersee",
"495143", "Winsen\ Aller",
"4935024", "Stadt\ Wehlen",
"499433", "Nabburg",
"497236", "Keltern",
"495250", "Delbrück\ Westfalen",
"492384", "Welver",
"493395", "Pritzwalk",
"499683", "Friedenfels",
"4934651", "Rossla",
"498634", "Garching\ an\ der\ Alz",
"4939245", "Loburg",
"499847", "Ergersheim",
"495831", "Wittingen",
"4937344", "Crottendorf\ Sachsen",
"4938322", "Richtenberg",
"492181", "Grevenbroich",
"4936607", "Niederpöllnitz",
"492637", "Weissenthurm",
"494483", "Ovelgönne\-Grossenmeer",
"494496", "Friesoythe\-Markhausen",
"494633", "Satrup",
"498387", "Weiler\-Simmerberg",
"4934223", "Dommitzsch",
"496638", "Schwalmtal\-Renzendorf",
"495839", "Wittingen\-Ohrdorf",
"497942", "Neuenstein\ Württemberg",
"499374", "Eschau",
"4934362", "Mügeln\ bei\ Oschatz",
"497773", "Bodman\-Ludwigshafen",
"492673", "Ellenz\-Poltersdorf",
"494256", "Hilgermissen",
"493605", "Leinefelde",
"499662", "Vilseck",
"494892", "Schenefeld\ Mittelholstein",
"499306", "Kist",
"4937366", "Rübenau",
"4937204", "Lichtenstein\ Sachsen",
"4938458", "Zehna",
"497976", "Sulzbach\-Laufen",
"4935726", "Gross\ Särchen",
"499179", "Freystadt",
"497904", "Ilshofen",
"493931", "Stendal",
"499171", "Roth\ Mittelfranken",
"492753", "Erndtebrück",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"497653", "Lenzkirch",
"494757", "Wanna",
"494462", "Wittmund",
"4936731", "Unterloquitz",
"497129", "Lichtenstein\ Württemberg",
"4937323", "Lichtenberg\ Erzgebirge",
"4936945", "Henneberg",
"499926", "Frauenau",
"49981", "Ansbach",
"49751", "Ravensburg",
"4938226", "Dierhagen\ Ostseebad",
"497427", "Schömberg\ bei\ Balingen",
"4939884", "Hassleben\ bei\ Prenzlau",
"4934244", "Mockrehna",
"497121", "Reutlingen",
"497361", "Aalen",
"499723", "Röthlein",
"496694", "Neukirchen\ Knüll",
"497324", "Herbrechtingen",
"498241", "Buchloe",
"495428", "Melle\-Neuenkirchen",
"497164", "Boll\ Kreis\ Göppingen",
"498249", "Ettringen\ Wertach",
"498095", "Aying",
"492647", "Kesseling",
"495849", "Waddeweitz",
"497747", "Berau",
"496648", "Bad\ Salzschlirf",
"494643", "Gelting\ Angeln",
"497272", "Rülzheim",
"4938422", "Neukloster",
"498366", "Oy\-Mittelberg",
"499837", "Haundorf",
"495841", "Lüchow\ Wendland",
"496291", "Adelsheim",
"499443", "Abensberg",
"497246", "Malsch\ Kreis\ Karlsruhe",
"495355", "Frellstedt",
"4937430", "Eichigt",
"494952", "Rhauderfehn",
"492252", "Zülpich",
"496045", "Gedern",
"498062", "Bruckmühl\ Mangfall",
"496375", "Wallhalben",
"496803", "Mandelbachtal\-Ommersheim",
"496036", "Wölfersheim",
"497340", "Neenstetten",
"497235", "Unterreichenbach\ Kreis\ Calw",
"494865", "Osterhever",
"496332", "Zweibrücken",
"499222", "Presseck",
"494495", "Friesoythe\-Thüle",
"4936784", "Stützerbach",
"499089", "Bissingen\-Unterringingen",
"497445", "Pfalzgrafenweiler",
"496706", "Wallhausen\ Nahe",
"4939035", "Kuhfelde",
"495754", "Extertal\-Bremke",
"495066", "Sarstedt",
"492585", "Warendorf\-Hoetmar",
"493594", "Bischofswerda",
"499081", "Nördlingen",
"496774", "Kaub",
"4939831", "Feldberg",
"496207", "Wald\-Michelbach",
"4939006", "Miesterhorst",
"495362", "Wolfsburg\-Fallersleben",
"492208", "Niederkassel",
"496654", "Gersfeld\ Rhön",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"4933477", "Trebnitz\ bei\ Müncheberg",
"4938373", "Katzow",
"495606", "Zierenberg",
"4936459", "Blankenhain\ Thüringen",
"495674", "Grebenstein",
"494965", "Surwold",
"492265", "Reichshof\-Eckenhagen",
"4933454", "Wölsickendorf\/Wollenberg",
"498055", "Halfing",
"4938720", "Grebbin",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"498564", "Johanniskirchen",
"492983", "Winterberg\-Siedlinghausen",
"4933235", "Friesack",
"494283", "Tarmstedt",
"494296", "Schwanewede\-Aschwarden",
"494852", "Brunsbüttel",
"496505", "Kordel",
"493471", "Bernburg\ Saale",
"494105", "Seevetal",
"49811", "Hallbergmoos",
"494328", "Rickling",
"494563", "Scharbeutz\-Haffkrug",
"496568", "Wolsfeld",
"4933206", "Fichtenwalde",
"496323", "Edenkoben",
"496163", "Höchst\ im\ Odenwald",
"494168", "Neu\ Wulmstorf\-Elstorf",
"492567", "Ahaus\-Alstätte",
"4939422", "Badersleben",
"498284", "Ziemetshausen",
"499937", "Oberpöring",
"499233", "Arzberg\ Oberfranken",
"495941", "Neuenhaus\ Dinkel",
"497436", "Messstetten\-Oberdigisheim",
"499655", "Tännesberg",
"4934773", "Schwittersdorf",
"49991", "Deggendorf",
"499826", "Weidenbach\ Mittelfranken",
"4939226", "Hohenziatz",
"498137", "Petershausen",
"499775", "Schönau\ an\ der\ Brend",
"4936623", "Berga\ Elster",
"492339", "Sprockhövel\-Hasslinghausen",
"498431", "Neuburg\ an\ der\ Donau",
"4939994", "Metschow",
"492331", "Hagen\ Westfalen",
"4934207", "Zwochau",
"494455", "Jade\-Schweiburg",
"498681", "Waging\ am\ See",
"4933743", "Blönsdorf",
"499576", "Lichtenfels\-Isling",
"492625", "Ochtendung",
"4939458", "Heudeber",
"497725", "Königsfeld\ im\ Schwarzwald",
"499504", "Stadelhofen",
"497804", "Oppenau",
"493831", "Stralsund",
"497842", "Kappelrodeck",
"499542", "Schesslitz",
"496251", "Bensheim",
"492292", "Windeck\ Sieg",
"495271", "Höxter",
"4939263", "Unseburg",
"4938305", "Gingst",
"499732", "Hammelburg",
"492856", "Hamminkeln\-Brünen",
"496027", "Stockstadt\ am\ Main",
"492657", "Uersfeld",
"498706", "Vilsheim",
"496871", "Wadern",
"495859", "Thomasburg",
"497462", "Immendingen",
"496658", "Poppenhausen\ Wasserkuppe",
"492204", "Bensberg",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"495851", "Dahlenburg",
"4936730", "Sitzendorf",
"4934779", "Abberode",
"494976", "Spiekeroog",
"4933608", "Jacobsdorf\ Mark",
"499453", "Thalmassing",
"497256", "Philippsburg",
"495345", "Baddeckenstedt",
"498207", "Affing",
"4934976", "Gröbzig",
"4933701", "Grossbeeren",
"498654", "Freilassing",
"4936744", "Remda",
"494942", "Südbrookmerland",
"494773", "Lamstedt",
"492777", "Breitscheid\ Hessen",
"496055", "Freigericht",
"492242", "Hennef\ Sieg",
"4935938", "Grosspostwitz\ OL",
"496564", "Neuerburg\ Eifel",
"495336", "Semmenstedt",
"499627", "Freudenberg\ Oberpfalz",
"494324", "Brokstedt",
"494164", "Harsefeld",
"4938856", "Pritzier\ bei\ Hagenow",
"498505", "Hutthurm",
"494121", "Elmshorn",
"4939082", "Mieste",
"494361", "Oldenburg\ in\ Holstein",
"492423", "Langerwehe",
"498323", "Immenstadt\ im\ Allgäu",
"49611", "Wiesbaden",
"494129", "Haseldorf",
"496284", "Mudau",
"49451", "Lübeck",
"495032", "Neustadt\ am\ Rübenberge",
"497952", "Gerabronn",
"499766", "Grosswenkheim",
"494246", "Twistringen\-Heiligenloh",
"4938844", "Gülze",
"4935797", "Schwepnitz",
"494537", "Sülfeld\ Holstein",
"496439", "Holzappel",
"492533", "Münster\-Nienberge",
"499963", "Konzell",
"499267", "Nordhalben",
"4938379", "Benz\ Usedom",
"4936453", "Mellingen",
"492972", "Schmallenberg",
"4939922", "Dambeck\ bei\ Röbel",
"492743", "Daaden",
"496431", "Limburg\ an\ der\ Lahn",
"496681", "Hilders",
"494747", "Beverstedt",
"497643", "Herbolzheim\ Breisgau",
"494272", "Siedenburg",
"499285", "Kirchenlamitz",
"4938297", "Moitin",
"492601", "Nauort",
"493544", "Luckau\ Brandenburg",
"497709", "Wutach",
"495807", "Altenmedingen",
"494340", "Achterwehr",
"494235", "Langwedel\-Etelsen",
"4933977", "Gumtow",
"4939604", "Wildberg\ bei\ Altentreptow",
"492935", "Sundern\-Hachen",
"498251", "Aichach",
"499565", "Untersiemau",
"499103", "Cadolzburg",
"498259", "Schiltberg",
"4939721", "Liepen\ bei\ Anklam",
"498027", "Dietramszell",
"497808", "Hohberg\ bei\ Offenburg",
"4937431", "Mehltheuer\ Vogtland",
"497031", "Böblingen",
"492835", "Issum",
"493629", "Stadtilm",
"497965", "Ellwangen\-Röhlingen",
"495185", "Duingen",
"4934928", "Seegrehna",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"4938721", "Ziegendorf",
"493621", "Gotha\ Thüringen",
"496620", "Philippsthal\ Werra",
"493346", "Seelow",
"499378", "Eichenbühl\-Riedern",
"4934904", "Oranienbaum",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"493372", "Jüterbog",
"495203", "Werther\ Westfalen",
"495907", "Geeste",
"4936205", "Gräfenroda",
"494445", "Visbek\ Kreis\ Vechta",
"4938461", "Bützow",
"492522", "Oelde",
"4935873", "Herrnhut",
"497328", "Königsbronn",
"497563", "Kisslegg",
"496698", "Schrecksbach",
"495424", "Bad\ Rothenfelde",
"492697", "Blankenheim\-Ahrhütte",
"4938351", "Mesekenhagen",
"492872", "Rhede\ Westfalen",
"495327", "Bad\ Grund\ Harz",
"499636", "Plössberg",
"495167", "Walsrode\-Westenholz",
"499493", "Beratzhausen",
"497852", "Willstätt",
"499552", "Burghaslach",
"493335", "Finowfurt",
"496241", "Worms",
"495461", "Bramsche\ Hase",
"496095", "Bessenbach",
"496249", "Guntersblum",
"4933848", "Raben",
"4939856", "Beenz\ bei\ Prenzlau",
"495744", "Hüllhorst",
"497455", "Dornhan",
"495534", "Eschershausen\ an\ der\ Lenne",
"494526", "Ascheberg\ Holstein",
"496126", "Idstein",
"4936378", "Ostramondra",
"498291", "Zusmarshausen",
"4935384", "Steinsdorf\ bei\ Jessen",
"496644", "Grebenhain",
"4934321", "Leisnig",
"4936025", "Körner",
"498045", "Lenggries\-Fall",
"498375", "Weitnau",
"496062", "Erbach\ Odenwald",
"495702", "Petershagen\-Lahde",
"494180", "Königsmoor",
"4934658", "Hayn\ Harz",
"4937329", "Grosshartmannsdorf",
"496580", "Zemmer",
"499094", "Tagmersheim",
"498036", "Stephanskirchen\ Simssee",
"498803", "Peissenberg",
"493581", "Görlitz",
"494842", "Nordstrand",
"492432", "Wassenberg",
"498332", "Ottobeuren",
"494804", "Nordhastedt",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"492682", "Hamm\ Sieg",
"494876", "Reher\ Holstein",
"495951", "Werlte",
"4938872", "Rehna",
"494725", "Helgoland",
"495193", "Schneverdingen",
"496239", "Bobenheim\-Roxheim",
"492836", "Wachtendonk",
"499467", "Michelsneukirchen",
"497966", "Unterschneidheim",
"495186", "Salzhemmendorf\-Wallensen",
"4935930", "Seitschen",
"499646", "Freihung",
"499321", "Kitzingen",
"494472", "Lastrup",
"496231", "Hochdorf\-Assenheim",
"499161", "Neustadt\ an\ der\ Aisch",
"492663", "Westerburg\ Westerwald",
"497763", "Murg",
"494667", "Dagebüll",
"499364", "Zellingen",
"494446", "Bakum\ Kreis\ Vechta",
"4938451", "Hoppenrade\ bei\ Güstrow",
"499672", "Neunburg\ vorm\ Wald",
"492351", "Lüdenscheid",
"499901", "Hengersberg\ Bayern",
"497174", "Mögglingen",
"494435", "Grossenkneten",
"492722", "Attendorn",
"495520", "Braunlage",
"496392", "Hauenstein\ Pfalz",
"498157", "Feldafing",
"4936738", "Königsee",
"498459", "Manching",
"492359", "Kierspe",
"497622", "Schopfheim",
"499635", "Bärnau",
"496096", "Wiesen\ Unterfranken",
"492845", "Neukirchen\-Vluyn",
"496083", "Weilrod",
"492154", "Willich",
"4933925", "Wustrau\-Altfriesack",
"497371", "Riedlingen\ Württemberg",
"497041", "Mühlacker",
"4939973", "Altkalen",
"496308", "Olsbrücken",
"494303", "Schlesen",
"493991", "Waren\ Müritz",
"497582", "Bad\ Buchau",
"492307", "Kamen",
"498407", "Grossmehring",
"499253", "Weissenstadt",
"497456", "Haiterbach",
"498072", "Haag\ in\ Oberbayern",
"498342", "Marktoberdorf",
"494525", "Ahrensbök",
"492404", "Alsdorf\ Rheinland",
"498304", "Wildpoldsried",
"497262", "Eppingen",
"4935329", "Dollenchen",
"4933085", "Seilershof",
"494832", "Meldorf",
"4936332", "Ellrich",
"498046", "Bad\ Heilbrunn",
"498376", "Sulzberg\ Allgäu",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"4937384", "Wechselburg",
"498035", "Raubling",
"494923", "Krummhörn\-Pewsum",
"495502", "Dransfeld",
"4933875", "Rhinow",
"496484", "Beselich",
"496634", "Gemünden\ Felda",
"4939823", "Rechlin",
"492927", "Neuengeseke",
"492223", "Königswinter",
"495544", "Reinhardshagen",
"494875", "Stafstedt",
"492388", "Hamm\-Uentrop",
"498638", "Waldkraiburg",
"495734", "Bergkirchen\ Westfalen",
"496387", "Sankt\ Julian",
"496721", "Bingen\ am\ Rhein",
"495042", "Bad\ Münder\ am\ Deister",
"495372", "Meinersen",
"4939394", "Hohenberg\-Krusemark",
"492391", "Plettenberg",
"493907", "Gardelegen",
"498705", "Altfraunhofen",
"496352", "Kirchheimbolanden",
"492275", "Kerpen\-Buir",
"49471", "Bremerhaven",
"4935771", "Bad\ Muskau",
"494975", "Westerholt\ Ostfriesland",
"498824", "Oberau\ Loisach",
"495664", "Morschen",
"498861", "Schongau",
"495621", "Bad\ Wildungen",
"497255", "Graben\-Neudorf",
"4936077", "Grossbodungen",
"495346", "Liebenburg",
"4938823", "Selmsdorf",
"492827", "Goch\-Hassum",
"4937295", "Lugau\ Erzgebirge",
"496056", "Bad\ Soden\-Salmünster",
"496764", "Rheinböllen",
"494823", "Wilster",
"498869", "Kinsau",
"4934920", "Kropstädt",
"494932", "Norderney",
"492232", "Brühl\ Rheinland",
"493461", "Merseburg\ Saale",
"4934636", "Schafstädt",
"495153", "Salzhemmendorf",
"494178", "Radbruch",
"495335", "Schladen",
"496173", "Kronberg\ im\ Taunus",
"496578", "Salmtal",
"493327", "Werder\ Havel",
"497084", "Schömberg\ bei\ Neuenbürg",
"498506", "Bad\ Höhenstadt",
"499857", "Schopfloch\ Mittelfranken",
"4934605", "Gröbers",
"497557", "Herdwangen\-Schönach",
"49228", "Bonn",
"498574", "Wittibreut",
"499765", "Trappstadt",
"4933637", "Beerfelde",
"4936258", "Friemar",
"494245", "Neuenkirchen\ bei\ Bassum",
"494330", "Emkendorf",
"499708", "Bad\ Bocklet",
"492945", "Lippstadt\-Benninghausen",
"495403", "Bad\ Iburg",
"4939361", "Lüderitz",
"4936463", "Gebstedt",
"4940", "Hamburg",
"493744", "Auerbach\ Vogtland",
"4934673", "Heldrungen",
"496441", "Wetzlar",
"492733", "Hilchenbach",
"497483", "Horb\-Mühringen",
"499286", "Oberkotzau",
"499293", "Berg\ Oberfranken",
"497633", "Staufen\ im\ Breisgau",
"494737", "Stadland\-Schwei",
"494547", "Gudow\ Lauenburg",
"4936766", "Schalkau",
"4939451", "Wasserleben",
"496147", "Trebur",
"495261", "Lemgo",
"492543", "Billerbeck\ Westfalen",
"496449", "Ehringshausen\-Katzenfurt",
"495224", "Enger\ Westfalen",
"494236", "Kirchlinteln",
"4936969", "Merkers",
"4936370", "Grossenehrich",
"4938787", "Glöwen",
"499566", "Meeder",
"4934495", "Dobitschen",
"4933834", "Pritzerbe",
"4933964", "Fretzdorf",
"4935822", "Hagenwerder",
"4936426", "Ottendorf\ bei\ Stadtroda",
"4933398", "Werneuchen",
"49211", "Düsseldorf",
"496423", "Wetter\ Hessen",
"492529", "Oelde\-Stromberg",
"4934206", "Rötha",
"493379", "Mahlow",
"4936940", "Oepfershausen",
"497336", "Lonsee",
"493371", "Luckenwalde",
"492521", "Beckum",
"4937202", "Claussnitz\ bei\ Chemnitz",
"497032", "Herrenberg",
"492564", "Vreden",
"499628", "Ursensollen",
"4938791", "Bad\ Wilsnack",
"494794", "Worpswede\-Ostersode",
"4934364", "Wermsdorf",
"493622", "Waltershausen\ Thüringen",
"492778", "Siegbach",
"499551", "Burgwindheim",
"4934692", "Alsleben\ Saale",
"498265", "Pfaffenhausen\ Schwaben",
"497851", "Kehl",
"496242", "Osthofen",
"493763", "Glauchau",
"495462", "Ankum",
"498208", "Eurasburg\ bei\ Augsburg",
"498585", "Grainet",
"496276", "Hesseneck",
"493966", "Cölpin",
"495677", "Calden\-Westuffeln",
"4933433", "Buckow\ Märkische\ Schweiz",
"4939882", "Gollin",
"4934242", "Hohenpriessnitz",
"496657", "Hofbieber",
"496204", "Viernheim",
"497345", "Langenau\ Württemberg",
"4935609", "Drachhausen",
"492871", "Bocholt",
"498292", "Dinkelscherben",
"497807", "Neuried\ Ortenaukreis",
"498028", "Fischbachau",
"498856", "Penzberg",
"4939007", "Tangeln",
"4933476", "Neuhardenberg",
"495495", "Vörden\ Kreis\ Vechta",
"496061", "Michelstadt",
"496024", "Schöllkrippen",
"495808", "Gerdau",
"4938424", "Bobitz",
"4934446", "Grosskorbetha",
"4935342", "Mühlberg\ Elbe",
"495865", "Gusborn",
"498331", "Memmingen",
"492431", "Erkelenz",
"496743", "Bacharach",
"499205", "Vorbach",
"494748", "Stubben\ bei\ Bremerhaven",
"4933207", "Gross\ Kreutz",
"494355", "Rieseby",
"4934743", "Ermsleben",
"492681", "Altenkirchen\ Westerwald",
"496138", "Mommenheim",
"492689", "Dierdorf",
"499268", "Teuschnitz",
"494133", "Wittorf\ Kreis\ Lüneburg",
"492137", "Neuss\-Norf",
"495952", "Sögel",
"496533", "Morbach\ Hunsrück",
"4935264", "Strehla",
"494849", "Hooge",
"495643", "Borgentreich",
"4937435", "Reuth\ bei\ Plauen",
"498134", "Odelzhausen",
"499183", "Burgthann",
"499196", "Wiesenttal",
"494841", "Husum\ Nordsee",
"4938725", "Gross\ Godems",
"4933452", "Neulewin",
"495105", "Barsinghausen",
"494941", "Aurich",
"495168", "Walsrode\-Stellichte",
"497424", "Spaichingen",
"4933230", "Börnicke\ Kreis\ Havelland",
"495563", "Kreiensen",
"495328", "Altenau\ Harz",
"492241", "Siegburg",
"4936201", "Walschleben",
"497461", "Tuttlingen",
"496872", "Losheim\ am\ See",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"495283", "Lügde\-Rischenau",
"495852", "Bleckede",
"496697", "Willingshausen",
"4939389", "Schollene",
"497327", "Dischingen",
"494606", "Wanderup",
"498753", "Elsendorf\ Niederbayern",
"494122", "Uetersen",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"496522", "Mettendorf",
"495908", "Wietmarschen\-Lohne",
"4939030", "Brunau",
"494362", "Heiligenhafen",
"494674", "Ockholm",
"499377", "Freudenberg\-Boxtal",
"495031", "Wunstorf",
"495965", "Klein\ Berssen",
"4938355", "Züssow",
"4939408", "Hadmersleben",
"494754", "Bülkau",
"497720", "Schwenningen\ am\ Neckar",
"497203", "Walzbachtal",
"499406", "Mintraching",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"492620", "Neuhäusel\ Westerwald",
"499474", "Schmidmühlen",
"496835", "Beckingen",
"4933362", "Liepe\ Kreis\ Barnim",
"4939992", "Görmin",
"4939056", "Klüden",
"493866", "Cambs",
"496432", "Diez",
"492971", "Schmallenberg\-Dorlar",
"4933768", "Prieros",
"4935727", "Burghammer",
"494271", "Sulingen",
"4939343", "Jerichow",
"496682", "Tann\ Rhön",
"497440", "Bad\ Rippoldsau",
"497951", "Crailsheim",
"4936021", "Schlotheim",
"493496", "Köthen\ Anhalt",
"4937367", "Lengefeld\ Erzgebirge",
"497023", "Weilheim\ an\ der\ Teck",
"4938300", "Insel\ Hiddensee",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"4934325", "Mochau\-Lüttewitz",
"497959", "Frankenhardt",
"498252", "Schrobenhausen",
"496500", "Waldrach",
"499834", "Theilenhofen",
"497534", "Reichenau\ Baden",
"496475", "Weilmünster\-Wolfenhausen",
"493501", "Pirna",
"497744", "Stühlingen",
"4939248", "Dobritz",
"499343", "Lauda\-Königshofen",
"499073", "Gundelfingen\ an\ der\ Donau",
"495455", "Tecklenburg\-Brochterbeck",
"492644", "Linz\ am\ Rhein",
"497702", "Blumberg\ Baden",
"492366", "Herten\ Westfalen",
"498466", "Denkendorf\ Oberbayern",
"494884", "Schwabstedt",
"492602", "Montabaur",
"4938227", "Lüdershagen\ bei\ Barth",
"498862", "Steingaden\ Oberbayern",
"495622", "Fritzlar",
"496154", "Ober\-Ramstadt",
"494554", "Wahlstedt",
"499820", "Lehrberg",
"497520", "Bodnegg",
"495174", "Lahstedt",
"496722", "Rüdesheim\ am\ Rhein",
"498158", "Tutzing",
"498553", "Spiegelau",
"496359", "Grünstadt",
"4938455", "Plaaz",
"492392", "Werdohl",
"495371", "Gifhorn",
"495041", "Springe\ Deister",
"495295", "Lichtenau\ Westfalen",
"495379", "Sassenburg\-Grussendorf",
"4939324", "Kläden\ bei\ Stendal",
"496351", "Eisenberg\ Pfalz",
"4936642", "Harra",
"494605", "Medelby",
"4936948", "Römhild",
"4939489", "Strassberg\ Harz",
"4938234", "Born\ Darss",
"494668", "Klanxbüll",
"493677", "Ilmenau\ Thüringen",
"496663", "Steinau\ an\ der\ Strasse",
"4936606", "Kraftsdorf",
"4939203", "Barleben",
"495966", "Meppen\-Apeldorn",
"49861", "Traunstein",
"492850", "Rees\-Haldern",
"497193", "Sulzbach\ an\ der\ Murr",
"494931", "Norden",
"4933921", "Zechlinerhütte",
"499405", "Bad\ Abbach",
"493462", "Bad\ Dürrenberg",
"4939754", "Löcknitz\ Vorpom",
"495763", "Uchte",
"496836", "Überherrn",
"496003", "Rosbach\ von\ der\ Höhe",
"499468", "Zell\ Oberpfalz",
"4939777", "Borkenfriede",
"494939", "Baltrum",
"498637", "Lohkirchen",
"494383", "Grebin",
"499802", "Ansbach\-Katterbach",
"497502", "Wolpertswende",
"492387", "Drensteinfurt\-Walstedde",
"493865", "Holthusen",
"4939746", "Krackow",
"499333", "Sommerhausen",
"498384", "Röthenbach\ Allgäu",
"492928", "Soest\-Ostönnen",
"492484", "Mechernich\-Eiserfey",
"4935474", "Schönwalde\ bei\ Lübben",
"495060", "Bodenburg",
"497734", "Gailingen",
"496223", "Neckargemünd",
"492634", "Rengsdorf",
"497544", "Markdorf",
"499844", "Obernzenn",
"499155", "Simmelsdorf",
"4934425", "Droyssig",
"4935892", "Horka\ OL",
"496476", "Mengerskirchen",
"495582", "Sankt\ Andreasberg",
"496404", "Lich\ Hessen",
"495456", "Westerkappeln\-Velpe",
"4937467", "Klingenthal\ Sachsen",
"493643", "Weimar\ Thüringen",
"496442", "Braunfels",
"498465", "Kipfenberg",
"492365", "Marl",
"492308", "Unna\-Hemmerde",
"495262", "Extertal",
"496307", "Schopp",
"4939038", "Henningen",
"4935775", "Pechern",
"498785", "Rottenburg\-Oberroning",
"493987", "Templin",
"497240", "Pfinztal",
"497335", "Wiesensteig",
"4937609", "Wolkenburg\ Mulde",
"497153", "Plochingen",
"497558", "Illmensee",
"499671", "Oberviechtach",
"4933333", "Tantow",
"4935246", "Ziegenhain\ Sachsen",
"493563", "Spremberg",
"492173", "Langenfeld\ Rheinland",
"493328", "Teltow",
"4937291", "Augustusburg",
"494479", "Molbergen\-Peheim",
"4939400", "Wefensleben",
"494177", "Drage\ Elbe",
"494471", "Cloppenburg",
"495084", "Hambühren",
"499162", "Scheinfeld",
"4935696", "Briesnig",
"496232", "Speyer",
"4934299", "Gaschwitz",
"496827", "Eppelborn",
"4935058", "Pretzschendorf",
"497664", "Freiburg\-Tiengen",
"498266", "Kirchheim\ in\ Schwaben",
"492828", "Emmerich\-Elten",
"4933679", "Wendisch\ Rietz",
"492056", "Heiligenhaus",
"4934464", "Freyburg\ Unstrut",
"492764", "Welschen\ Ennest",
"4933238", "Senzke",
"499944", "Miltach",
"497042", "Vaihingen\ an\ der\ Enz",
"4936087", "Wüstheuterode",
"498593", "Untergriesbach",
"496275", "Rothenberg\ Odenwald",
"498586", "Hauzenberg",
"497629", "Tegernau\ Baden",
"493965", "Burow\ bei\ Altentreptow",
"492352", "Altena\ Westfalen",
"498452", "Geisenfeld",
"492721", "Lennestadt",
"4935202", "Klingenberg\ Sachsen",
"4934601", "Teutschenthal",
"497346", "Illerkirchberg",
"495255", "Altenbeken",
"497621", "Lörrach",
"496391", "Dahn",
"498144", "Grafrath",
"497261", "Sinsheim",
"4938754", "Leussow\ bei\ Ludwigslust",
"4936927", "Unterellen",
"4935435", "Gollmitz\ bei\ Calau",
"495633", "Diemelsee",
"494839", "Wöhrden\ Dithmarschen",
"497269", "Sulzfeld\ Baden",
"495483", "Lienen",
"494143", "Drochtersen",
"496543", "Büchenbeuren",
"498349", "Stötten\ am\ Auerberg",
"492449", "Blankenheim\ Ahr",
"497581", "Saulgau",
"4938203", "Bad\ Doberan",
"4939365", "Bellingen\ bei\ Stendal",
"498102", "Höhenkirchen\-Siegertsbrunn",
"498341", "Kaufbeuren",
"498071", "Wasserburg\ am\ Inn",
"496733", "Gau\-Odernheim",
"492441", "Kall",
"49202", "Wuppertal",
"497224", "Gernsbach",
"4939455", "Schierke",
"497403", "Dunningen",
"499206", "Mistelgau\-Obernsees",
"4934346", "Narsdorf",
"4936846", "Suhl\-Dietzhausen",
"494356", "Gross\ Wittensee",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"4938324", "Velgast",
"4937342", "Cranzahl",
"499274", "Hollfeld",
"4934491", "Schmölln\ Thüringen",
"499920", "Bischofsmais",
"495509", "Rosdorf\ Kreis\ Göttingen",
"499195", "Adelsdorf\ Mittelfranken",
"4935022", "Bad\ Schandau",
"4938308", "Göhren\ Rügen",
"496893", "Saarbrücken\-Ensheim",
"4934635", "Bad\ Lauchstädt",
"492524", "Ennigerloh",
"4933978", "Segeletz",
"497948", "Öhringen\-Ohrnberg",
"499605", "Weiherhammer",
"493306", "Gransee",
"49231", "Dortmund",
"49841", "Ingolstadt\ Donau",
"4934606", "Teicha\ Sachsen\-Anhalt",
"494468", "Friedeburg\-Reepsholt",
"497136", "Bad\ Friedrichshall",
"492561", "Ahaus",
"499931", "Plattling",
"495947", "Laar\ Vechte",
"4937602", "Kirchberg\ Sachsen",
"494405", "Edewecht",
"494791", "Osterholz\-Scharmbeck",
"4939824", "Hohenzieritz",
"4935241", "Lommatzsch",
"49381", "Rostock",
"4935209", "Mohorn",
"499554", "Untersteinbach\ Unterfranken",
"4937383", "Lunzenau",
"497854", "Kehl\-Goldscheuer",
"497145", "Markgröningen",
"499087", "Marktoffingen",
"4935691", "Bärenklau\ NL",
"498225", "Jettingen\-Scheppach",
"4934292", "Brandis\ bei\ Wurzen",
"493723", "Hohenstein\-Ernstthal",
"496201", "Weinheim\ Bergstr",
"492874", "Isselburg",
"4933672", "Pfaffendorfb\ Beeskow",
"496209", "Mörlenbach",
"4937296", "Stollberg\ Erzgebirge",
"495422", "Melle",
"4938393", "Binz\ Ostseebad",
"4938482", "Warin",
"496756", "Winterbach\ Soonwald",
"495704", "Petershagen\-Friedewalde",
"495776", "Preussisch\ Ströhen",
"4936841", "Schleusingen",
"498665", "Inzell",
"4934341", "Geithain",
"496642", "Schlitz",
"495825", "Wieren",
"495532", "Stadtoldendorf",
"496257", "Seeheim\-Jugenheim",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"494958", "Jemgum",
"495656", "Waldkappel",
"496029", "Mömbris",
"496021", "Aschaffenburg",
"496676", "Hohenroda\ Hessen",
"49395", "Neubrandenburg",
"4935937", "Prischwitz",
"4936425", "Isserstedt",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"495277", "Höxter\-Fürstenau",
"4934496", "Nöbdenitz",
"495742", "Preussisch\ Oldendorf",
"499383", "Wiesentheid",
"498334", "Bad\ Grönenbach",
"492434", "Wegberg",
"499396", "Urspringen\ bei\ Lohr",
"493695", "Bad\ Salzungen",
"494802", "Wrohm",
"492684", "Puderbach\ Westerwald",
"498131", "Dachau",
"496555", "Bleialf",
"4933607", "Briesen\ Mark",
"494844", "Pellworm",
"494155", "Büchen",
"496338", "Hornbach\ Pfalz",
"4939957", "Gielow",
"498687", "Taching\-Tengling",
"494333", "Erfde",
"499228", "Thurnau",
"492337", "Hagen\-Dahl",
"499092", "Wemding",
"498139", "Röhrmoos",
"4937349", "Scheibenberg",
"494944", "Wiesmoor",
"4936601", "Hermsdorf\ Thüringen",
"492244", "Königswinter\-Oberpleis",
"498536", "Kösslarn",
"497367", "Aalen\-Ebnat",
"497429", "Egesheim",
"498652", "Berchtesgaden",
"497127", "Neckartenzlingen",
"4936649", "Gefell\ bei\ Schleiz",
"498247", "Bad\ Wörishofen",
"498772", "Mallersdorf\-Pfaffenberg",
"495305", "Sickte",
"4936464", "Wormstedt",
"494902", "Jemgum\-Ditzum",
"495523", "Bad\ Sachsa",
"495368", "Parsau",
"4933926", "Herzberg\ Mark",
"497464", "Talheim\ Kreis\ Tuttlingen",
"495128", "Hohenhameln",
"492202", "Bergisch\ Gladbach",
"496853", "Marpingen",
"494671", "Bredstedt",
"495034", "Neustadt\-Hagen",
"496282", "Walldürn",
"494858", "Sankt\ Margarethen\ Holstein",
"495873", "Eimke",
"4936377", "Rastenberg",
"4938780", "Lanz\ Brandenburg",
"49385", "Schwerin",
"499471", "Burglengenfeld",
"494322", "Bordesholm",
"495190", "Soltau\-Emmingen",
"498545", "Hofkirchen\ Bayern",
"496562", "Speicher",
"4933833", "Wollin\ bei\ Brandenburg",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"494162", "Jork",
"4939482", "Gatersleben",
"495925", "Wietmarschen",
"4933847", "Görzke",
"494751", "Otterndorf",
"493937", "Osterburg\ Altmark",
"498735", "Gangkofen\-Kollbach",
"499177", "Heideck",
"497385", "Gomadingen",
"4935955", "Pulsnitz",
"492974", "Schmallenberg\-Fredeburg",
"494274", "Varrel\ bei\ Sulingen",
"494206", "Stuhr\-Heiligenrode",
"4939393", "Werben\ Elbe",
"499356", "Burgsinn",
"4933876", "Buschow",
"497063", "Bad\ Wimpfen",
"49391", "Magdeburg",
"494195", "Hartenholm",
"4938824", "Mallentin",
"498273", "Nordendorf",
"496595", "Dockweiler",
"497954", "Kirchberg\ an\ der\ Jagst",
"494920", "Wirdum",
"494707", "Langen\-Neuenwalde",
"497741", "Tiengen\ Hochrhein",
"496783", "Baumholder",
"493576", "Weisswasser",
"492166", "Mönchengladbach\-Rheydt",
"498426", "Walting\ Kreis\ Eichstätt",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"4939741", "Jatznick",
"4939061", "Weferlingen",
"4939298", "Barby\ Elbe",
"493504", "Dippoldiswalde",
"499831", "Gunzenhausen",
"497531", "Konstanz",
"495696", "Bad\ Arolsen\-Landau",
"4933086", "Grieben\ Kreis\ Oberhavel",
"495683", "Wabern\ Hessen",
"499738", "Rottershausen",
"496297", "Ravenstein\ Baden",
"495433", "Badbergen",
"493542", "Lübbenau\ Spreewald",
"4933656", "Bahro",
"499143", "Pappenheim\ Mittelfranken",
"494881", "Friedrichstadt",
"4934927", "Globig\-Bleddin",
"499548", "Mühlhausen\ Mittelfranken",
"4938843", "Bennin",
"494559", "Wensin",
"496159", "Messel",
"495171", "Peine",
"496457", "Burgwald\ Eder",
"492192", "Hückeswagen",
"496762", "Kastellaun",
"498745", "Bodenkirchen",
"493947", "Thale",
"498535", "Haarbach",
"496151", "Darmstadt",
"4939382", "Kamern",
"494551", "Bad\ Segeberg",
"495306", "Cremlingen",
"495662", "Felsberg\ Hessen",
"498822", "Oberammergau",
"497478", "Hirrlingen",
"4936454", "Magdala",
"4936692", "Bürgel",
"495044", "Springe\-Eldagsen",
"495374", "Isenbüttel",
"498572", "Tann\ Niederbayern",
"499428", "Kirchroth",
"498237", "Aindling",
"4933369", "Oderberg",
"497082", "Neuenbürg\ Württemberg",
"4933970", "Neustadt\ Dosse",
"495723", "Bad\ Nenndorf",
"498546", "Windorf\-Otterskirchen",
"49581", "Uelzen",
"495926", "Engden",
"494934", "Marienhafe",
"4939603", "Burg\ Stargard",
"496623", "Rotenburg\ an\ der\ Fulda",
"4936206", "Grossfahner",
"492234", "Frechen",
"497386", "Hayingen",
"497393", "Munderkingen",
"493973", "Pasewalk",
"494268", "Bötersen",
"499133", "Baiersdorf\ Mittelfranken",
"496263", "Neckargerach",
"497838", "Nordrach",
"49821", "Augsburg",
"494205", "Ottersberg",
"499748", "Motten",
"499355", "Frammersbach",
"495443", "Lemförde",
"492905", "Bestwig\-Ramsbeck",
"492639", "Anhausen\ Kreis\ Neuwied",
"496188", "Kahl\ am\ Main",
"494183", "Jesteburg",
"499841", "Bad\ Windsheim",
"497739", "Hilzingen",
"495837", "Sprakensehl",
"497541", "Friedrichshafen",
"4936737", "Drognitz",
"498389", "Weissensberg",
"4939999", "Tutow",
"496583", "Palzem",
"496596", "Üdersdorf",
"4936743", "Teichel",
"498381", "Lindenberg\ im\ Allgäu",
"497731", "Singen\ Hohentwiel",
"492631", "Neuwied",
"4935842", "Oderwitz",
"496401", "Grünberg\ Hessen",
"492165", "Jüchen",
"4939855", "Parmen\-Weggun",
"492325", "Wanne\-Eickel",
"495222", "Bad\ Salzuflen",
"4939051", "Calvörde",
"496409", "Biebertal",
"496107", "Kelsterbach",
"495695", "Twistetal",
"4936026", "Struth\ bei\ Mühlhausen",
"492373", "Menden\ Sauerland",
"492043", "Gladbeck",
"4933932", "Fehrbellin",
"4933397", "Wandlitz",
"493523", "Coswig\ bei\ Dresden",
"499674", "Schönsee",
"498320", "Missen\-Wilhams",
"499606", "Pfreimd",
"499122", "Schwabach",
"4938788", "Gross\ Warnow",
"494474", "Garrel",
"4938855", "Lübtheen",
"497135", "Brackenheim",
"4935383", "Elster\ Elbe",
"497353", "Schwendi",
"494406", "Berne",
"4937209", "Einsiedel\ bei\ Chemnitz",
"499941", "Kötzting",
"495937", "Geeste\-Gross\ Hesepe",
"495233", "Steinheim\ Westfalen",
"492152", "Kempen",
"4933731", "Trebbin",
"498727", "Falkenberg\ Niederbayern",
"497669", "St\ Märgen",
"493925", "Stassfurt",
"4934782", "Mansfeld\ Südharz",
"4939889", "Boitzenburg",
"497661", "Kirchzarten",
"494770", "Wischhafen",
"497146", "Remseck\ am\ Neckar",
"492761", "Olpe\ Biggesee",
"4935602", "Drebkau",
"492724", "Finnentrop\-Serkenrode",
"4936257", "Luisenthal\ Thüringen",
"498226", "Bibertal",
"497938", "Mulfingen\ Jagst",
"4934975", "Görzig\ Kreis\ Köthen",
"497624", "Grenzach\-Wyhlen",
"496867", "Perl",
"496394", "Bundenthal",
"497172", "Lorch\ Württemberg",
"4938796", "Viesecke",
"4933638", "Rüdersdorf\ bei\ Berlin",
"494343", "Laboe",
"496078", "Gross\-Umstadt",
"496348", "Offenbach\ an\ der\ Queich",
"496755", "Odernheim\ am\ Glan",
"495775", "Diepenau",
"498141", "Fürstenfeldbruck",
"498302", "Görisried",
"497264", "Bad\ Rappenau",
"492402", "Stolberg\ Rheinland",
"495826", "Suderburg",
"498666", "Teisendorf",
"49591", "Lingen\ \(Ems\)",
"494834", "Büsum",
"4935874", "Bernstadt\ an\ der\ Eigen",
"498344", "Westendorf\ bei\ Kaufbeuren",
"498074", "Schnaitsee",
"492444", "Schleiden\-Gemünd",
"495655", "Wanfried",
"497221", "Baden\-Baden",
"496675", "Breitenbach\ am\ Herzberg",
"497229", "Iffezheim",
"4934903", "Coswig\ Anhalt",
"497584", "Altshausen",
"495732", "Löhne",
"499271", "Thurnau\-Alladorf",
"499279", "Mistelgau",
"499395", "Triefenstein",
"493433", "Borna\ Stadt",
"495542", "Witzenhausen",
"493683", "Schmalkalden",
"496482", "Runkel",
"496556", "Pronsfeld",
"493847", "Sternberg",
"495504", "Friedland\ Kreis\ Göttingen",
"494156", "Talkau",
"4934441", "Hohenmölsen",
"498771", "Ergoldsbach",
"496033", "Butzbach",
"496806", "Heusweiler",
"4933052", "Leegebruch",
"495145", "Beedenbostel",
"495854", "Bleckede\-Barskamp",
"499435", "Schwarzenfeld",
"496874", "Wadern\-Nunkirchen",
"493386", "Premnitz",
"499088", "Mönchsdeggingen",
"497422", "Schramberg",
"4933208", "Fahrland",
"494635", "Sörup",
"4935473", "Neu\ Lübbenau",
"494485", "Elsfleth\-Huntorf",
"498651", "Bad\ Reichenhall",
"496561", "Bitburg",
"494646", "Mohrkirch",
"494321", "Neumünster",
"499472", "Hohenfels\ Oberpfalz",
"495948", "Itterbeck",
"494161", "Buxtehude",
"498123", "Moosinning",
"4935245", "Burkhardswalde\-Munzig",
"494752", "Neuhaus\ Oste",
"494467", "Wittmund\-Funnix",
"494169", "Sauensiek",
"49631", "Kaiserslautern",
"494329", "Langwedel\ Holstein",
"496569", "Bickendorf",
"498363", "Pfronten",
"492463", "Titz",
"4939008", "Kunrau",
"496281", "Buchen\ Odenwald",
"499446", "Altmannstein",
"497947", "Forchtenberg",
"497243", "Ettlingen",
"494672", "Langenhorn",
"4935695", "Simmersdorf",
"497150", "Korntal\-Münchingen",
"495136", "Burgdorf\ Kreis\ Hannover",
"4938732", "Gallin\ bei\ Lübz",
"494124", "Glückstadt",
"494364", "Dahme\ Kreis\ Ostholstein",
"496524", "Rodershausen",
"492338", "Breckerfeld",
"499923", "Teisnach",
"499227", "Neuenmarkt",
"4936845", "Gehlberg",
"4934345", "Bad\ Lausick",
"4936761", "Heubisch",
"4939456", "Altenbrak",
"496337", "Grossbundenbach",
"492555", "Schöppingen",
"4936041", "Bad\ Tennstedt",
"496434", "Bad\ Camberg",
"499875", "Wolframs\-Eschenbach",
"497575", "Messkirch",
"4936421", "Camburg",
"496684", "Hofbieber\-Schwarzbach",
"499726", "Euerbach",
"4939323", "Schönhausen\ Elbe",
"498085", "Sankt\ Wolfgang",
"494140", "Estorf\ Kreis\ Stade",
"497825", "Kippenheim",
"499525", "Königsberg\ in\ Bayern",
"492676", "Ulmen",
"495278", "Höxter\-Ovenhausen",
"4939204", "Niederndodeleben",
"4936962", "Vacha",
"4935436", "Laasow\ bei\ Calau",
"493541", "Calau",
"4935829", "Gersdorf\ bei\ Görlitz",
"499303", "Eibelstadt",
"498067", "Tuntenhausen",
"4938233", "Prerow\ Ostseebad",
"497704", "Geisingen\ Baden",
"493731", "Freiberg\ Sachsen",
"492953", "Wünnenberg",
"492257", "Reckerscheid",
"494253", "Asendorf\ Kreis\ Diepholz",
"494957", "Detern",
"494882", "Lunden",
"492604", "Nassau\ Lahn",
"496258", "Gernsheim",
"497277", "Wörth\-Büchelberg",
"497973", "Obersontheim",
"497742", "Klettgau",
"492642", "Remagen",
"493838", "Bergen\ auf\ Rügen",
"497656", "Schluchsee",
"4939753", "Strasburg",
"492064", "Dinslaken",
"499832", "Wassertrüdingen",
"497532", "Meersburg",
"4939366", "Kehnert",
"498254", "Altomünster",
"499178", "Abenberg\ Mittelfranken",
"4938228", "Dettmannsdorf\-Kölzow",
"493624", "Ohrdruf",
"499573", "Staffelstein\ Oberfranken",
"497034", "Ehningen",
"492562", "Gronau\ Westfalen",
"499932", "Osterhofen",
"4936605", "Bad\ Köstritz",
"4938753", "Wöbbelin",
"494792", "Worpswede",
"4939247", "Güterglück",
"4938204", "Broderstorf",
"494857", "Barlt",
"493661", "Greiz",
"496660", "Steinau\-Marjoss",
"4936920", "Grossenlupnitz",
"492853", "Schermbeck",
"49971", "Bad\ Kissingen",
"495429", "Melle\-Wellingholzhausen",
"495127", "Harsum",
"4938323", "Prohn",
"495367", "Rühen",
"498550", "Philippsreut",
"496202", "Schwetzingen",
"499975", "Waldmünchen\-Geigant",
"4937368", "Deutschneudorf",
"498248", "Lamerdingen",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"4934222", "Arzberg\ bei\ Torgau",
"495464", "Alfhausen",
"497128", "Sonnenbühl",
"4938456", "Langhagen\ bei\ Güstrow",
"4935728", "Uhyst\ Spree",
"4933767", "Friedersdorf\ bei\ Berlin",
"499823", "Leutershausen",
"496244", "Westhofen\ Rheinhessenen",
"497305", "Erbach\ Donau",
"4933334", "Greiffenberg",
"499547", "Zapfendorf",
"4934426", "Kayna",
"495531", "Holzminden",
"4935322", "Doberlug\-Kirchhain",
"4935951", "Neukirch\ Lausitz",
"494286", "Gyhum",
"494293", "Ottersberg\-Fischerhude",
"496298", "Möckmühl",
"496022", "Obernburg\ am\ Main",
"4939407", "Seehausen\ Börde",
"4937422", "Markneukirchen",
"495741", "Lübbecke",
"499737", "Wartmannsroth",
"492993", "Marsberg\-Canstein",
"492297", "Wildbergerhütte",
"4936870", "Masserberg",
"495848", "Trebel",
"496166", "Fischbachtal",
"498294", "Horgau",
"497433", "Balingen",
"499236", "Nagel",
"497683", "Simonswald",
"496641", "Lauterbach\ Hessen",
"496326", "Deidesheim",
"499245", "Obertrubach",
"499099", "Kaisheim",
"494708", "Ringstedt",
"496703", "Wöllstein\ Rheinhessen",
"495063", "Bad\ Salzdetfurth",
"496220", "Wilhelmsfeld",
"4934463", "Bad\ Kösen",
"494765", "Ebersdorf\ bei\ Bremervörde",
"4939931", "Röbel\ Müritz",
"4939861", "Gramzow\ bei\ Prenzlau",
"492595", "Olfen",
"4935752", "Ruhland",
"4939745", "Hetzdorf\ bei\ Strasburg",
"499091", "Monheim\ Schwaben",
"495603", "Gudensberg",
"495954", "Lorup",
"499324", "Dettelbach",
"494627", "Dörpstedt",
"497723", "Furtwangen\ im\ Schwarzwald",
"496234", "Mutterstadt",
"495082", "Langlingen",
"492623", "Ransbach\-Baumbach",
"499164", "Langenfeld\ Mittelfranken",
"4938356", "Behrenhoff",
"498670", "Reischach\ Kreis\ Altötting",
"499369", "Uettingen",
"49951", "Bamberg",
"49781", "Offenburg",
"499427", "Leiblfing",
"498238", "Gessertshausen",
"499129", "Wendelstein",
"4937468", "Treuen\ Vogtland",
"4939000", "Beetzendorf",
"4938423", "Bad\ Kleinen",
"497477", "Jungingen\ bei\ Hechingen",
"499976", "Rötz",
"4938726", "Spornitz",
"498454", "Karlshuld",
"492354", "Meinerzhagen",
"499904", "Lalling",
"497171", "Schwäbisch\ Gmünd",
"499653", "Eslarn",
"499773", "Unsleben",
"492151", "Krefeld",
"4938466", "Jürgenshagen",
"499942", "Viechtach",
"497044", "Mönsheim",
"497374", "Uttenweiler",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"496458", "Rosenthal\ Hessen",
"494453", "Zetel",
"492762", "Wenden\ Südsauerland",
"4933200", "Bergholz\-Rehbrücke",
"496192", "Hofheim\ am\ Taunus",
"492159", "Meerbusch\-Osterath",
"497306", "Vöhringen\ Iller",
"4935263", "Gröditz\ bei\ Riesa",
"498104", "Sauerlach",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"497222", "Rastatt",
"494285", "Rhade\ bei\ Zeven",
"493994", "Malchin",
"498176", "Egling\ bei\ Wolfratshausen",
"492985", "Winterberg\-Niedersfeld",
"496108", "Mühlheim\ am\ Main",
"494103", "Wedel",
"4934363", "Cavertitz",
"494508", "Krummesse",
"492409", "Stolberg\-Gressenich",
"496503", "Hermeskeil",
"498142", "Olching",
"496165", "Breuberg",
"492401", "Baesweiler",
"4936947", "Jüchsen",
"4937752", "Eibenstock",
"499070", "Tapfheim",
"499340", "Königheim\-Brehmen",
"499235", "Thierstein",
"496325", "Lambrecht\ Pfalz",
"499246", "Pegnitz\-Trockau",
"497443", "Dornstetten",
"4939055", "Hörsingen",
"496631", "Alsfeld",
"494766", "Basdahl",
"496639", "Ottrau",
"4939851", "Göritz\ bei\ Prenzlau",
"495838", "Gross\ Oesingen",
"492596", "Nordkirchen",
"492583", "Sassenberg",
"496187", "Schöneck",
"499272", "Fichtelberg",
"499747", "Geroda\ Bayern",
"495731", "Bad\ Oeynhausen",
"4937322", "Brand\-Erbisdorf",
"492263", "Engelskirchen",
"497837", "Oberharmersbach",
"495541", "Hann\.\ Münden",
"4933434", "Herzfelde\ bei\ Strausberg",
"498053", "Bad\ Endorf",
"494963", "Dörpen",
"494267", "Lauenbrück",
"496805", "Kleinblittersdorf",
"495146", "Wietze",
"4939344", "Güsen",
"4938307", "Poseritz",
"495661", "Melsungen",
"498821", "Garmisch\-Partenkirchen",
"4936622", "Triebes",
"4937360", "Olbernhau",
"496868", "Mettlach\-Tünsdorf",
"494863", "Sankt\ Peter\-Ording",
"496724", "Stromberg\ Hunsrück",
"492394", "Neuenrade\-Affeln",
"492867", "Heiden\ Kreis\ Borken",
"499436", "Nittenau",
"497937", "Dörzbach",
"4933742", "Oehna\ Brandenburg",
"497233", "Niefern\-Öschelbronn",
"493385", "Rathenow",
"492191", "Remscheid",
"495172", "Ilsede",
"496761", "Simmern\ Hunsrück",
"496152", "Gross\-Gerau",
"495624", "Bad\ Emstal",
"4934772", "Helbra",
"494636", "Langballig",
"498728", "Geratskirchen",
"494552", "Leezen",
"494486", "Edewecht\-Friedrichsfehn",
"4938851", "Zarrentin",
"494493", "Friesoythe\-Gehlenberg",
"4938220", "Wustrow\ Ostseebad",
"4934205", "Markranstädt",
"4939089", "Bismark\ Altmark",
"4939262", "Güsten\ Anh",
"493464", "Sangerhausen",
"493421", "Torgau",
"496420", "Lahntal",
"498571", "Simbach\ am\ Inn",
"499445", "Neustadt\ an\ der\ Donau",
"495353", "Königslutter\ am\ Elm",
"4936928", "Neuenhof\ Thüringen",
"497081", "Bad\ Wildbad",
"495135", "Burgwedel\-Fuhrberg",
"496043", "Nidda",
"496373", "Schönenberg\-Kübelberg",
"497542", "Tettnang",
"499842", "Uffenheim",
"4938372", "Usedom",
"499180", "Pyrbaum",
"497732", "Radolfzell\ am\ Bodensee",
"492556", "Metelen",
"492482", "Hellenthal",
"498382", "Lindau\ Bodensee",
"4939929", "Jabel\ bei\ Waren",
"492632", "Andernach",
"4937436", "Weischlitz",
"493741", "Plauen",
"497576", "Krauchenwies",
"499876", "Rohr\ Mittelfranken",
"4939726", "Ducherow",
"4933237", "Paulinenaue",
"499725", "Poppenhausen\ Unterfranken",
"4935057", "Hermsdorf\ Erzgebirge",
"499804", "Aurach",
"498086", "Buchbach\ Oberbayern",
"493531", "Finsterwalde",
"497504", "Horgenzell",
"498093", "Glonn\ Kreis\ Ebersberg",
"497826", "Schuttertal",
"499526", "Riedbach",
"49791", "Schwäbisch\ Hall",
"492675", "Ediger\-Eller",
"495264", "Kalletal",
"497775", "Mühlingen",
"496444", "Bischoffen",
"4933475", "Letschin",
"4936878", "Oberland",
"4939423", "Wegeleben",
"493603", "Bad\ Langensalza",
"496402", "Hungen",
"495584", "Hattorf\ am\ Harz",
"497655", "Feldberg\-Altglashütten",
"4939037", "Pretzier",
"495221", "Herford",
"496347", "Hochstadt\ Pfalz",
"492755", "Bad\ Berleburg\-Schwarzenau",
"4934445", "Stössen",
"498805", "Hohenpeissenberg",
"4936452", "Berlstedt",
"496821", "Neunkirchen\ Saar",
"4936694", "Schkölen\ Thüringen",
"4934638", "Zöschen",
"498724", "Massing",
"492226", "Rheinbach",
"4939923", "Priborn",
"498868", "Schwabsoien",
"495934", "Haren\-Rütenbrock",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"49481", "Heide\ Holstein",
"494926", "Krummhörn\-Greetsiel",
"4939384", "Arendsee\ Altmark",
"495025", "Estorf\ Weser",
"4933201", "Gross\ Glienicke",
"498761", "Moosburg\ an\ der\ Isar",
"499350", "Eussenheim\-Hundsbach",
"496728", "Ober\-Hilbersheim",
"497627", "Steinen\ Kreis\ Lörrach",
"498152", "Herrsching\ am\ Ammersee",
"496397", "Leimen\ Pfalz",
"496864", "Mettlach",
"494723", "Cuxhaven\-Altenwalde",
"4938295", "Satow\ bei\ Bad\ Doberan",
"493981", "Neustrelitz",
"494662", "Leck",
"499256", "Stammbach",
"497453", "Altensteig\ Württemberg",
"499677", "Oberviechtach\-Pullenried",
"4935795", "Königsbrück",
"494171", "Winsen\ Luhe",
"499462", "Falkenstein\ Oberpfalz",
"496571", "Wittlich",
"492473", "Simmerath",
"498373", "Altusried",
"498043", "Jachenau",
"4933981", "Putlitz",
"495551", "Northeim",
"494179", "Winsen\-Tönnhausen",
"4939001", "Apenburg",
"494477", "Lastrup\-Hemmelte",
"4938331", "Rakow\ Vorpom",
"499865", "Adelshofen\ Mittelfranken",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"496382", "Lauterecken",
"499701", "Sandberg\ Unterfranken",
"499495", "Breitenbrunn\ Oberpfalz",
"492922", "Werl",
"4933396", "Klosterfelde",
"496093", "Laufach",
"496086", "Grävenwiesbach",
"4936428", "Stadtroda",
"495507", "Ebergötzen",
"494222", "Ganderkesee",
"493844", "Schwaan",
"494837", "Neuenkirchen\ Dithmarschen",
"4938797", "Karstädt\ Kreis\ Prignitz",
"492833", "Kerken",
"495196", "Wietzendorf",
"497963", "Adelmannsfelden",
"497267", "Gemmingen",
"4939083", "Messdorf",
"495183", "Lamspringe",
"4936256", "Wechmar",
"498444", "Schweitenkirchen",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"499952", "Eichendorf",
"497054", "Wildberg\ Württemberg",
"497587", "Hosskirch",
"492302", "Witten",
"498402", "Münchsmünster",
"492666", "Freilingen\ Westerwald",
"494443", "Dinklage",
"4935844", "Oybin\ Kurort",
"4939221", "Möckern\ bei\ Magdeburg",
"495205", "Bielefeld\-Sennestadt",
"498347", "Friesenried",
"492447", "Dahlem\ bei\ Kall",
"497636", "Münstertal\ Schwarzwald",
"495650", "Cornberg",
"493679", "Neuhaus\ am\ Rennweg",
"492736", "Burbach\ Siegerl",
"499852", "Feuchtwangen",
"497552", "Pfullendorf",
"498234", "Bobingen",
"499283", "Rehau",
"497486", "Horb\-Altheim",
"4938221", "Marlow",
"492546", "Coesfeld\-Lette",
"493671", "Saalfeld\ Saale",
"4936736", "Arnsgereuth",
"496670", "Ludwigsau\ Hessen",
"4934953", "Gräfenhainichen",
"492237", "Kerpen\ Rheinland\-Türnich",
"492933", "Sundern\ Sauerland",
"499563", "Rödental",
"494233", "Blender",
"496238", "Dirmstein",
"493322", "Falkensee",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"499105", "Grosshabersdorf",
"492572", "Emsdetten",
"4937361", "Neuhausen\ Erzgebirge",
"4936027", "Lengenfeld\ Unterm\ Stein",
"495474", "Stemwede\-Dielingen",
"496454", "Lichtenfels\-Sachsenberg",
"495406", "Belm",
"493944", "Blankenburg\ Harz",
"492822", "Emmerich",
"4938873", "Carlow",
"492535", "Sendenhorst\-Albersloh",
"499965", "Sankt\ Englmar",
"495377", "Ehra\-Lessien",
"4935604", "Krieschow",
"493902", "Diesdorf\ Altm",
"4938850", "Gammelin",
"499908", "Schöfweg",
"492358", "Meinerzhagen\-Valbert",
"498458", "Gaimersheim",
"497645", "Freiamt",
"498192", "Schondorf\ am\ Ammersee",
"496357", "Standenbühl",
"492745", "Brachbach\ Sieg",
"496104", "Heusenstamm",
"497130", "Löwenstein\ Württemberg",
"495156", "Coppenbrügge",
"494504", "Ratekau",
"4935872", "Neusalza\-Spremberg",
"494732", "Stadland\-Rodenkirchen",
"498503", "Neuhaus\ am\ Inn",
"493881", "Grevesmühlen",
"4938429", "Glasin",
"498165", "Neufahrn\ bei\ Freising",
"496142", "Rüsselsheim",
"496301", "Otterbach\ Pfalz",
"498325", "Oberstaufen\-Thalkirchdorf",
"492425", "Nideggen\-Embken",
"494542", "Mölln\ Lauenburg",
"493998", "Demmin",
"492381", "Hamm\ Westfalen",
"4936207", "Plaue\ Thüringen",
"498631", "Mühldorf\ am\ Inn",
"4939295", "Zuchau",
"498639", "Neumarkt\-Sankt\ Veit",
"492389", "Werne",
"495073", "Neustadt\-Esperke",
"495834", "Wittingen\-Knesebeck",
"496053", "Wächtersbach",
"49491", "Leer\ Ostfriesland",
"494826", "Hohenlockstedt",
"49221", "Cologne",
"494775", "Grossenwörden",
"497635", "Schliengen",
"492735", "Neunkirchen\ Siegerl",
"497485", "Empfingen",
"499295", "Töpen",
"4937604", "Mosel",
"499371", "Miltenberg",
"495037", "Bad\ Rehburg",
"4936333", "Heringen\ Helme",
"494422", "Sande\ Kreis\ Friesl",
"492545", "Rosendahl\-Darfeld",
"499174", "Hilpoltstein",
"4935361", "Schlieben",
"4933877", "Nitzahn",
"493628", "Arnstadt",
"495820", "Suhlendorf",
"499106", "Markt\ Erlbach",
"499622", "Hirschau\ Oberpfalz",
"4933657", "Steinsdorf\ Brandenburg",
"497124", "Trochtelfingen\ Hohenz",
"495468", "Bramsche\-Engter",
"4934926", "Pretzsch\ Elbe",
"498202", "Althegnenberg",
"497364", "Oberkochen",
"496550", "Irrhausen",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"492247", "Neunkirchen\-Seelscheid",
"492943", "Erwitte",
"4933087", "Bredereiche",
"492772", "Herborn\ Hessen",
"4933674", "Trebatsch",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"4934294", "Rackwitz",
"494243", "Twistringen",
"494947", "Aurich\-Ogenbargen",
"497672", "St\ Blasien",
"4935451", "Dahme\ Brandenburg",
"492536", "Münster\-Albachten",
"497467", "Neuhausen\ ob\ Eck",
"499966", "Wiesenfelden",
"497329", "Steinheim\ am\ Albuch",
"492652", "Mendig",
"496691", "Schwalmstadt",
"497646", "Weisweil\ Breisgau",
"497321", "Heidenheim\ an\ der\ Brenz",
"4939822", "Kratzeburg",
"497161", "Göppingen",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"495844", "Clenze",
"495155", "Emmerthal",
"4933927", "Linum",
"498022", "Tegernsee",
"4939771", "Ueckermünde",
"4938759", "Tewswoos",
"495333", "Dettum",
"496175", "Friedrichsdorf\ Taunus",
"498649", "Schleching",
"496294", "Krautheim\ Jagst",
"498166", "Allershausen\ Oberbayern",
"495802", "Wrestedt",
"498326", "Fischen\ im\ Allgäu",
"492426", "Nörvenich",
"498641", "Grassau\ Kreis\ Traunstein",
"4938484", "Ventschow",
"498703", "Essenbach",
"496132", "Ingelheim\ am\ Rhein",
"4933846", "Dippmannsdorf",
"499262", "Wallenfels",
"494532", "Bargteheide",
"4939858", "Bietikow",
"494973", "Wittmund\-Burhafe",
"494277", "Schwaförden",
"494742", "Dorum",
"492273", "Kerpen\-Horrem",
"492977", "Schmallenberg\-Bödefeld",
"4939972", "Walkendorf",
"4936376", "Straussfurt",
"494704", "Drangstedt",
"497957", "Kressberg",
"497253", "Bad\ Schönborn",
"4934261", "Kühren\ bei\ Wurzen",
"494825", "Burg\ Dithmarschen",
"493588", "Niesky",
"494776", "Osten\-Altendorf",
"493591", "Bautzen",
"495162", "Fallingbostel",
"498806", "Utting\ am\ Ammersee",
"499084", "Bissingen\ Schwaben",
"498033", "Oberaudorf",
"4935936", "Sohland\ Spree",
"496771", "St\ Goarshausen",
"495322", "Bad\ Harzburg",
"4936462", "Ossmannstedt",
"4934497", "Langenleuba\-Niederhain",
"4938785", "Berge\ bei\ Perleberg",
"492225", "Meckenheim\ Rheinland",
"494925", "Hinte",
"495751", "Rinteln",
"4934672", "Rossleben",
"495671", "Hofgeismar",
"492692", "Kelberg",
"495026", "Steimbke",
"495858", "Hitzacker\-Wietzetze",
"496659", "Eichenzell",
"4938858", "Lassahn",
"4939329", "Möringen",
"496651", "Rasdorf",
"494873", "Aukrug",
"4939956", "Neukalen",
"498561", "Pfarrkirchen\ Niederbayern",
"499255", "Marktleugast",
"494305", "Westensee",
"49241", "Aachen",
"49831", "Kempten\ Allgäu",
"494128", "Kollmar",
"492527", "Lippetal\-Lippborg",
"4935823", "Ostritz",
"4939484", "Harzgerode",
"496123", "Eltville\ am\ Rhein",
"496363", "Niederkirchen",
"4933606", "Müllrose",
"493377", "Zossen\ Brandenburg",
"495902", "Freren",
"494523", "Malente",
"4934978", "Radegast\ Kreis\ Köthen",
"4936921", "Wutha\-Farnroda",
"495944", "Hoogstede",
"498281", "Thannhausen\ Schwaben",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"496438", "Hünfelden",
"492687", "Horhausen\ Westerwald",
"494433", "Dötlingen",
"498337", "Altenstadt\ Iller",
"494683", "Oldsum",
"497566", "Argenbühl",
"495300", "Salzgitter\-Üfingen",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"492131", "Neuss",
"4934607", "Wettin",
"498434", "Rennertshofen",
"4936651", "Lobenstein",
"492334", "Hagen\-Hohenlimburg",
"498684", "Fridolfing",
"499633", "Mitterteich",
"4934385", "Mutzschen",
"4936081", "Arenshausen",
"494847", "Oster\-Ohrstedt",
"496085", "Waldsolms",
"492843", "Rheinberg",
"493834", "Greifswald",
"4937297", "Thum\ Sachsen",
"495195", "Neuenkirchen\ bei\ Soltau",
"4936871", "Bad\ Colberg\-Heldburg",
"495707", "Petershagen\ Weser",
"498258", "Sielenbach",
"4936075", "Dingelstädt\ Eichsfeld",
"495274", "Nieheim",
"497765", "Rickenbach\ Hotzenwald",
"497708", "Geisingen\-Leipferdingen",
"4935973", "Stolpen",
"492608", "Welschneudorf",
"496254", "Lautertal\ Odenwald",
"495206", "Bielefeld\-Jöllenbeck",
"494478", "Cappeln\ Oldenburg",
"4935056", "Altenberg\ Sachsen",
"496473", "Leun",
"4933971", "Kyritz\ Brandenburg",
"493329", "Stahnsdorf",
"4937437", "Bad\ Elster",
"493321", "Nauen\ Brandenburg",
"4939727", "Spantekow",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"495592", "Gleichen\-Bremke",
"492571", "Greven\ Westfalen",
"499345", "Külsheim\ Baden",
"499075", "Glött",
"495453", "Recke",
"493364", "Eisenhüttenstadt",
"497551", "Überlingen\ Bodensee",
"499851", "Dinkelsbühl",
"4934909", "Aken\ Elbe",
"4933205", "Michendorf",
"493672", "Rudolstadt",
"492864", "Reken",
"4939036", "Binde",
"493901", "Salzwedel",
"497934", "Weikersheim",
"496398", "Vorderweidenthal",
"497628", "Efringen\-Kirchen",
"496727", "Gensingen",
"494393", "Boostedt",
"498191", "Landsberg\ am\ Lech",
"4935248", "Schönfeld\ bei\ Grossenhain",
"493909", "Klötze\ Altmark",
"493635", "Kölleda",
"496226", "Meckesheim",
"498867", "Rottenbuch\ Oberbayern",
"498394", "Lautrach",
"4934742", "Sylda",
"499336", "Bütthard",
"4939005", "Kusey",
"497025", "Neuffen",
"4935698", "Hornow",
"492821", "Kleve\ Niederrhein",
"498348", "Bidingen",
"4934348", "Frohburg",
"492448", "Hellenthal\-Rescheid",
"4939050", "Bartensleben",
"494731", "Nordenham",
"496447", "Langgöns\-Niederkleen",
"4937754", "Zwönitz",
"4936848", "Wernshausen",
"496302", "Winnweiler",
"495963", "Bawinkel",
"497183", "Rudersberg\ Württemberg",
"494541", "Ratzeburg",
"496666", "Freiensteinau",
"496074", "Rödermark",
"496344", "Schwegenheim",
"497268", "Bad\ Rappenau\-Obergimpern",
"4935389", "Holzdorf\ Elster",
"495054", "Bergen\-Sülze",
"495766", "Rehburg\-Loccum",
"4938306", "Samtens",
"496833", "Rehlingen\-Siersburg",
"494838", "Tellingstedt",
"4937203", "Gersdorf\ bei\ Chemnitz",
"495508", "Gleichen\-Rittmarshausen",
"4933432", "Müncheberg",
"4934243", "Bad\ Düben",
"4939883", "Gross\ Dölln",
"495103", "Wennigsen\ Deister",
"495565", "Einbeck\-Wenzen",
"4937324", "Reinsberg\ Sachsen",
"498556", "Haidmühle",
"492382", "Ahlen\ Westfalen",
"4939225", "Altengrabow",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"4938225", "Trinwillershagen",
"499720", "Üchtelhausen",
"4936946", "Erbenhausen\ Thüringen",
"496358", "Kriegsfeld",
"494353", "Ascheffel",
"498762", "Wartenberg\ Oberbayern",
"496745", "Gondershausen",
"4934774", "Röblingen\ am\ See",
"498457", "Vohburg\ an\ der\ Donau",
"492357", "Herscheid\ Westfalen",
"499203", "Neudrossenfeld",
"499907", "Zenting",
"4936608", "Seelingstädt\ bei\ Gera",
"498151", "Starnberg",
"496535", "Osann\-Monzel",
"497474", "Haigerloch",
"495378", "Sassenburg\-Platendorf",
"494135", "Kirchgellersen",
"4933744", "Hohenseefeld",
"492454", "Gangelt",
"4936701", "Lichte",
"4939993", "Hohenmocker",
"495645", "Borgentreich\-Borgholz",
"4936624", "Teichwolframsdorf",
"499185", "Mühlhausen\ Oberpfalz",
"4939342", "Gladau",
"494172", "Salzhausen",
"4934327", "Waldheim\ Sachsen",
"496572", "Manderscheid\ Eifel",
"499461", "Roding",
"4937365", "Sayda",
"499469", "Roding\-Neubäu",
"495552", "Katlenburg",
"496237", "Maxdorf",
"492750", "Diedenshausen",
"494938", "Hagermarsch",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"499167", "Oberscheinfeld",
"495636", "Lichtenfels\-Goddelsheim",
"494624", "Kropp",
"492238", "Pulheim",
"4935725", "Wittichenau",
"494661", "Niebüll",
"494146", "Stade\-Bützfleth",
"4939264", "Kroppenstedt",
"499424", "Strasskirchen",
"495863", "Zernien",
"498623", "Kirchweidach",
"496736", "Bechenheim",
"493765", "Reichenbach\ Vogtland",
"498263", "Breitenbrunn\ Schwaben",
"492053", "Velbert\-Neviges",
"496184", "Langenselbold",
"49621", "Mannheim",
"492921", "Soest",
"4936783", "Gehren\ Thüringen",
"4933470", "Lietzen",
"494221", "Delmenhorst",
"494264", "Sottrum\ Kreis\ Rotenburg",
"492964", "Brilon\-Alme",
"499534", "Burgpreppach",
"498583", "Neureichenau",
"497834", "Wolfach",
"497343", "Buch\ bei\ Illertissen",
"497073", "Ammerbuch",
"499744", "Zeitlofs\-Detter",
"496381", "Kusel",
"4938374", "Lassan\ bei\ Wolgast",
"492301", "Holzwickede",
"4939291", "Calbe\ Saale",
"499951", "Landau\ an\ der\ Isar",
"496425", "Rauschenberg\ Hessen",
"4939748", "Viereck",
"4933363", "Altenhof\ Kreis\ Barnim",
"492309", "Waltrop",
"497156", "Ditzingen",
"495130", "Wedemark",
"492104", "Mettmann",
"4938727", "Mestlin",
"495672", "Bad\ Karlshafen",
"492691", "Adenau",
"496746", "Pfalzfeld",
"497570", "Sigmaringen\-Gutenstein",
"495364", "Velpke",
"4935240", "Tauscha\ bei\ Grossenhain",
"4939399", "Kleinau",
"496536", "Kleinich",
"496652", "Hünfeld",
"494136", "Scharnebeck",
"495161", "Walsrode",
"493592", "Kirschau",
"494948", "Wiesmoor\-Marcardsmoor",
"496772", "Nastätten",
"496247", "Worms\-Pfeddersheim",
"4939406", "Harbke",
"4937465", "Tannenbergsthal\ Vogtland",
"495321", "Goslar",
"492248", "Hennef\-Uckerath",
"495646", "Willebadessen",
"495329", "Schulenberg\ im\ Oberharz",
"4935365", "Falkenberg\ Elster",
"499186", "Lauterhofen\ Oberpfalz",
"495467", "Voltlage",
"4933054", "Liebenwalde",
"499193", "Höchstadt\ an\ der\ Aisch",
"495752", "Auetal\-Hattendorf",
"498282", "Krumbach\ Schwaben",
"4935455", "Walddrehna",
"495485", "Ladbergen",
"495635", "Vöhl",
"496545", "Blankenrath",
"498562", "Triftern",
"495909", "Wettrup",
"494854", "Friedrichskoog",
"4935893", "Mücka",
"495901", "Fürstenau\ bei\ Bramsche",
"496735", "Eppelsheim",
"4939775", "Ahlbeck\ bei\ Torgelow",
"4939246", "Lindau\ Anh",
"494480", "Ovelgönne\-Strückhausen",
"497958", "Rot\ Am\ See\-Brettheim",
"494630", "Barderup",
"4936643", "Thimmendorf",
"493963", "Woldegk",
"495957", "Lindern\ Oldenburg",
"495253", "Bad\ Driburg",
"492132", "Meerbusch\-Büderich",
"495882", "Gorleben",
"499734", "Burkardroth",
"498783", "Rohr\ in\ Niederbayern",
"492294", "Morsbach\ Sieg",
"497333", "Laichingen",
"4936840", "Trusetal",
"496426", "Fronhausen",
"4939058", "Uthmöden",
"4938457", "Krakow\ am\ See",
"497844", "Rheinau",
"499544", "Baunach",
"4933766", "Teupitz",
"492175", "Leichlingen\ Rheinland",
"497802", "Oberkirch\ Baden",
"499502", "Frensdorf",
"4933839", "Wusterwitz",
"4933969", "Stepenitz",
"4939202", "Gross\ Ammensleben",
"4936964", "Dermbach\ Rhön",
"4938781", "Mellen",
"494464", "Wittmund\-Carolinensiel",
"4938202", "Volkenshagen",
"499076", "Wittislingen",
"499346", "Grünsfeld",
"499621", "Amberg\ Oberpfalz",
"494367", "Grossenbrode",
"499664", "Hahnbach",
"493378", "Ludwigsfelde",
"49641", "Giessen",
"496527", "Oberweis",
"498463", "Greding",
"492363", "Datteln",
"494127", "Westerhorn",
"492528", "Ennigerloh\-Enniger",
"498170", "Strasslach\-Dingharting",
"497944", "Kupferzell",
"494421", "Wilhelmshaven",
"499372", "Klingenberg\ am\ Main",
"4939457", "Benneckenstein\ Harz",
"4934208", "Löbnitz\ bei\ Delitzsch",
"497751", "Waldshut",
"493863", "Crivitz",
"494385", "Hohenfelde\ bei\ Kiel",
"492651", "Mayen",
"4935023", "Bad\ Gottleuba",
"497322", "Giengen\ an\ der\ Brenz",
"496692", "Neustadt\ Hessen",
"495857", "Bleckede\-Brackede",
"497162", "Süssen",
"493636", "Greussen",
"4933631", "Bad\ Saarow\-Pieskow",
"4934224", "Belgern\ Sachsen",
"499335", "Aub\ Kreis\ Würzburg",
"493493", "Bitterfeld",
"492779", "Greifenstein\-Beilstein",
"492771", "Dillenburg",
"499153", "Schnaittach",
"492590", "Dülmen\-Buldern",
"4936925", "Marksuhl",
"497026", "Lenningen",
"497671", "Todtnau",
"4937343", "Jöhstadt",
"494954", "Moormerland",
"492607", "Kobern\-Gondorf",
"494603", "Havetoft",
"498064", "Au\ bei\ Bad\ Aibling",
"498756", "Nandlstadt",
"497707", "Bräunlingen",
"492254", "Weilerswist",
"497195", "Winnenden",
"4939740", "Nechlin",
"498642", "Übersee",
"496665", "Sinntal\-Altengronau",
"4936085", "Reinholterode",
"499403", "Donaustauf",
"498257", "Inchenhofen",
"498029", "Kreuth\ bei\ Tegernsee",
"496068", "Beerfelden",
"49234", "Bochum",
"498021", "Waakirchen",
"495765", "Raddestorf",
"4933332", "Gartz\ Oder",
"497274", "Germersheim",
"4934381", "Colditz",
"4935324", "Crinitz",
"494848", "Rantrum",
"496843", "Gersheim",
"4936071", "Teistungen",
"497300", "Roggenburg",
"496334", "Thaleischweiler\-Fröschen",
"4935203", "Tharandt",
"4936875", "Straufhain\-Streufdorf",
"4933478", "Gross\ Neuendorf",
"499261", "Kronach",
"4935754", "Klettwitz",
"498555", "Perlesreut",
"496131", "Mainz",
"494531", "Bad\ Oldesloe",
"494749", "Schiffdorf\-Geestenseth",
"494741", "Nordholz\ bei\ Bremerhaven",
"494539", "Westerau",
"498338", "Böhen",
"492688", "Kroppach",
"496139", "Budenheim",
"495293", "Paderborn\-Dahl",
"495286", "Ottenstein\ Niedersachsen",
"499269", "Tettau\ Kreis\ Kronach",
"4935439", "Zinnitz",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"496848", "Homburg\-Einöd",
"4939953", "Schwinkendorf",
"494843", "Viöl",
"4933603", "Falkenhagen\ bei\ Seelow",
"495326", "Langelsheim",
"4936422", "Reinstädt\ Thüringen",
"495641", "Warburg",
"499637", "Falkenberg\ Oberpfalz",
"494334", "Bredenbek\ bei\ Rendsburg",
"4935826", "Königshain\ bei\ Görlitz",
"495166", "Walsrode\-Kirchboitzen",
"498802", "Huglfing",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"4938485", "Dabel",
"4936042", "Tonna",
"494131", "Lüneburg",
"496531", "Bernkastel\-Kues",
"499384", "Schwanfeld",
"498333", "Babenhausen\ Schwaben",
"496741", "St\ Goar",
"492433", "Hückelhoven",
"494139", "Hohnstorf\ Elbe",
"492696", "Nohn\ Eifel",
"495022", "Wietzen",
"4936762", "Steinach\ Thüringen",
"492683", "Asbach\ Westerwald",
"495906", "Lünne",
"4939459", "Hasselfelde",
"494608", "Handewitt",
"4935933", "Neschwitz",
"494665", "Emmelsbüll\-Horsbüll",
"499408", "Altenthann",
"496063", "Bad\ König",
"495703", "Hille",
"4936961", "Bad\ Liebenstein",
"499465", "Neukirchen\-Balbini",
"493868", "Rastow",
"494877", "Hennstedt\ bei\ Itzehoe",
"493724", "Burgstädt",
"496385", "Reichenbach\-Steegen",
"492873", "Isselburg\-Werth",
"4937605", "Hartenstein\ Sachsen",
"497562", "Isny\ im\ Allgäu",
"4939820", "Triepkendorf",
"4936458", "Bad\ Berka",
"4934632", "Mücheln\ Geiseltal",
"492925", "Warstein\-Allagen",
"4933051", "Nassenheide",
"499158", "Offenhausen\ Mittelfranken",
"499553", "Ebrach\ Oberfranken",
"497853", "Kehl\-Bodersweier",
"493761", "Werdau\ Sachsen",
"499492", "Parsberg",
"4938731", "Lübz",
"4934295", "Krensitz",
"496464", "Angelburg",
"4933675", "Tauche",
"49961", "Weiden\ in\ der\ Oberpfalz",
"495244", "Rietberg",
"496894", "St\ Ingbert",
"49441", "Oldenburg",
"495202", "Oerlinghausen",
"494527", "Bosau",
"496429", "Schweinsberg\ Hessen",
"492523", "Wadersloh",
"492368", "Oer\-Erkenschwick",
"498468", "Altmannstein\-Pondorf",
"496127", "Niedernhausen\ Taunus",
"496421", "Marburg",
"492305", "Castrop\-Rauxel",
"498405", "Stammham\ bei\ Ingolstadt",
"499955", "Mamming",
"495684", "Frielendorf",
"4934923", "Cobbelsdorf",
"495434", "Essen\ Oldenburg",
"494426", "Wangerland\-Horumersiel",
"497555", "Deggenhausertal",
"499855", "Dentlein\ am\ Forst",
"499144", "Pleinfeld",
"492575", "Greven\-Reckenfeld",
"4935952", "Grossröhrsdorf\ OL",
"499341", "Tauberbischofsheim",
"499071", "Dillingen\ an\ der\ Donau",
"499102", "Wilhermsdorf",
"495337", "Kissenbrück",
"496784", "Weierbach",
"499626", "Hohenburg",
"4937421", "Oelsnitz\ Vogtland",
"4934384", "Grossbothen",
"499349", "Werbach\-Wenkheim",
"497021", "Kirchheim\ unter\ Teck",
"497676", "Feldberg\ Schwarzwald",
"492825", "Uedem",
"4936074", "Worbis",
"492776", "Bad\ Endbach\-Hartenrod",
"498274", "Buttenwiesen",
"497257", "Bruchsal\-Untergrombach",
"497953", "Blaufelden",
"498206", "Egling\ an\ der\ Paar",
"493631", "Nordhausen\ Thüringen",
"4936336", "Klettenberg",
"496630", "Schwalmtal\-Storndorf",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"492742", "Wissen",
"4939862", "Schmölln\ bei\ Prenzlau",
"492973", "Eslohe\ Sauerland",
"4939932", "Malchow\ bei\ Waren",
"497642", "Endingen\ Kaiserstuhl",
"4935751", "Welzow",
"494977", "Blomberg\ Ostfriesland",
"493968", "Schönbeck",
"494273", "Kirchdorf\ bei\ Sulingen",
"4939397", "Geestgottberg",
"495258", "Salzkotten",
"492656", "Virneburg",
"498707", "Adlkofen",
"492532", "Ostbevern",
"499962", "Schwarzach\ Niederbayern",
"498858", "Kochel\-Walchensee",
"4938784", "Kleinow\ Kreis\ Prignitz",
"498671", "Altötting",
"4933843", "Niemegk",
"498026", "Hausham",
"498679", "Burgkirchen\ an\ der\ Alz",
"4933837", "Brielow",
"4933967", "Freyenstein",
"494545", "Seedorf\ Lauenburg",
"499120", "Leinburg",
"498322", "Oberstdorf",
"492422", "Kreuzau",
"496145", "Flörsheim\ am\ Main",
"496854", "Oberthal\ Saar",
"495806", "Barum\ bei\ Bad\ Bevensen",
"4936373", "Buttstädt",
"495033", "Wunstorf\-Grossenheidorn",
"4938459", "Laage",
"499360", "Thüngen",
"495874", "Soltendieck",
"498751", "Mainburg",
"494735", "Butjadingen\-Stollhamm",
"495281", "Bad\ Pyrmont",
"494746", "Hagen\ bei\ Bremerhaven",
"4934653", "Rottleberode",
"4939485", "Gernrode\ Harz",
"495524", "Bad\ Lauterberg\ im\ Harz",
"494536", "Steinhorst\ Lauenburg",
"497463", "Mühlheim\ an\ der\ Donau",
"499266", "Mitwitz",
"496136", "Nieder\-Olm",
"494772", "Oberndorf\ Oste",
"494943", "Grossefehn",
"494247", "Affinghausen",
"495561", "Einbeck",
"492243", "Eitorf",
"492947", "Anröchte",
"4934221", "Schildau\ Gneisenaustadt",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"492150", "Meerbusch\-Lank",
"499452", "Langquaid",
"49531", "Braunschweig",
"499198", "Heiligenstadt\ in\ Oberfranken",
"492542", "Gescher",
"494425", "Wangerland\-Hooksiel",
"4938876", "Roggendorf",
"497482", "Horb\-Dettingen",
"498507", "Neuburg\ am\ Inn",
"499292", "Konradsreuth",
"492732", "Kreuztal",
"499856", "Dürrwangen",
"497556", "Uhldingen\-Mühlhofen",
"497632", "Badenweiler",
"499625", "Kastl\ bei\ Amberg",
"493641", "Jena",
"492504", "Telgte",
"497675", "Bernau\ Baden",
"492058", "Wülfrath",
"49291", "Meschede",
"496229", "Neckarsteinach",
"492826", "Kranenburg\ Niederrhein",
"494184", "Hanstedt\ Nordheide",
"498268", "Tussenhausen",
"492775", "Driedorf",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"496057", "Flörsbachtal",
"49421", "Bremen",
"499090", "Rain\ Lech",
"499339", "Ippesheim",
"496584", "Wellen\ Mosel",
"499331", "Ochsenfurt",
"4936733", "Kaulsdorf",
"495347", "Burgdorf\ bei\ Salzgitter",
"4934956", "Zörbig",
"498205", "Dasing",
"496221", "Heidelberg",
"4937321", "Frankenstein\ Sachsen",
"498196", "Pürgen",
"499134", "Neunkirchen\ am\ Brand",
"4939852", "Schönermark\ bei\ Prenzlau",
"496264", "Neudenau",
"4939978", "Gross\ Roge",
"494381", "Lütjenburg",
"497348", "Beimerstetten",
"492655", "Weibern",
"495444", "Wagenfeld",
"497755", "Weilheim\ Kreis\ Waldshut",
"495761", "Stolzenau",
"4933974", "Dessow",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"4938729", "Marnitz",
"498025", "Miesbach",
"4939607", "Kotelow",
"494933", "Dornum\ Ostfriesland",
"494237", "Bendingbostel",
"4936695", "Söllmnitz",
"495152", "Hessisch\ Oldendorf",
"496624", "Heringen\ Werra",
"492937", "Arnsberg\-Oeventrop",
"492233", "Hürth\ Rheinland",
"499567", "Sesslach\-Gemünda",
"495769", "Steyerberg\-Voigtei",
"497394", "Schelklingen",
"494546", "Mustin\ Lauenburg",
"4938294", "Neubukow",
"496661", "Schlüchtern",
"496146", "Hochheim\ am\ Main",
"495805", "Oetzen",
"497191", "Backnang",
"499287", "Selb",
"496669", "Neuhof\-Hauswurz",
"498628", "Kienberg\ Oberbayern",
"495724", "Obernkirchen",
"494736", "Butjadingen\-Tossens",
"494358", "Loose\ bei\ Eckernförde",
"496353", "Freinsheim",
"494745", "Bad\ Bederkesa",
"499208", "Bindlach",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"494535", "Nahe",
"49335", "Frankfurt\ \(Oder\)",
"498551", "Freyung",
"499265", "Pressig",
"495373", "Hillerse\ Kreis\ Gifhorn",
"495043", "Lauenau",
"496135", "Bodenheim\ Rhein",
"4936450", "Kranichfeld",
"494822", "Kellinghusen",
"4938847", "Boizenburg\ Elbe",
"494922", "Borkum",
"495503", "Nörten\-Hardenberg",
"495108", "Gehrden\ Han",
"492222", "Bornheim\ Rheinland",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"495325", "Goslar\-Hahnenklee",
"495165", "Rethem\ Aller",
"493337", "Biesenthal\ Brandenburg",
"4933094", "Löwenberg",
"4938828", "Schönberg",
"492695", "Insul",
"4938371", "Karlshagen",
"495905", "Beesten",
"492443", "Mechernich",
"498343", "Aitrang",
"498073", "Gars\ am\ Inn",
"496731", "Alzey",
"494447", "Vechta\-Langförden",
"4939294", "Gross\ Rosenburg",
"4934907", "Jeber\-Bergfrieden",
"494149", "Fredenbeck",
"494141", "Stade",
"494302", "Kirchbarkau",
"496541", "Traben\-Trarbach",
"499252", "Helmbrechts",
"497583", "Bad\ Schussenried",
"494666", "Ladelund",
"4939926", "Grabowhöfe",
"499647", "Kirchenthumbach",
"494344", "Schönberg\ Holstein",
"495631", "Korbach",
"4937439", "Jocketa",
"495481", "Lengerich\ Westfalen",
"492837", "Weeze",
"499466", "Stamsried",
"497967", "Jagstzell",
"495187", "Delligsen",
"497263", "Waibstadt",
"494833", "Wesselburen",
"496838", "Saarwellingen",
"4934771", "Querfurt",
"492723", "Kirchhundem",
"4939086", "Jävenitz",
"493874", "Ludwigslust",
"497623", "Rheinfelden\ Baden",
"496386", "Altenkirchen\ Pfalz",
"4938852", "Wittenburg",
"496393", "Fischbach\ bei\ Dahn",
"498591", "Obernzell",
"4936253", "Georgenthal\ Thüringer\ Wald",
"495234", "Horn\-Bad\ Meinberg",
"496082", "Niederreifenberg",
"4933741", "Niedergörsdorf",
"49281", "Wesel",
"498650", "Marktschellenberg",
"4936704", "Steinheid",
"4936621", "Elsterberg\ bei\ Plauen",
"496478", "Greifenstein\-Ulm",
"49331", "Potsdam",
"494473", "Emstek",
"498377", "Unterthingau",
"4935387", "Seyda",
"493561", "Guben",
"492171", "Leverkusen\-Opladen",
"495192", "Munster",
"497354", "Erolzheim",
"494320", "Heidmühlen",
"495458", "Hopsten",
"492374", "Iserlohn\-Letmathe",
"497151", "Waiblingen",
"499673", "Tiefenbach\ Oberpfalz",
"4934785", "Sandersleben",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"492662", "Hachenburg",
"497159", "Renningen",
"498406", "Böhmfeld",
"492306", "Lünen",
"497457", "Rottenburg\-Ergenzingen",
"499956", "Eichendorf\-Aufhausen",
"4935605", "Komptendorf",
"497762", "Wehr\ Baden",
"499342", "Wertheim",
"499072", "Lauingen\ Donau",
"499101", "Langenzenn",
"497974", "Bühlerzell",
"499407", "Wenzenbach",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"497906", "Braunsbach",
"4939200", "Gommern",
"4939774", "Mönkebude",
"498253", "Pöttmes",
"493675", "Sonneberg\ Thüringen",
"4936842", "Oberhof\ Thüringen",
"4934342", "Neukieritzsch",
"499376", "Collenberg",
"494607", "Janneby",
"4938481", "Witzin",
"497703", "Bonndorf\ im\ Schwarzwald",
"4937346", "Geyer",
"492954", "Rüthen\-Oestereiden",
"494254", "Eystrup",
"497220", "Forbach\-Hundsbach",
"492603", "Bad\ Ems",
"497166", "Adelberg",
"496433", "Hadamar",
"492741", "Betzdorf",
"496683", "Ehrenberg\ Rhön",
"496696", "Gilserberg",
"497641", "Emmendingen",
"497326", "Neresheim",
"4939327", "Klietz",
"499961", "Mitterfels",
"499270", "Creussen",
"497022", "Nürtingen",
"4936965", "Stadtlengsfeld",
"499924", "Bodenmais",
"4933438", "Altlandsberg",
"499638", "Neualbenreuth",
"493632", "Sondershausen",
"492421", "Düren",
"498321", "Sonthofen",
"4937601", "Mülsen\ Skt\ Jacob",
"496305", "Hochspeyer",
"498161", "Freising",
"497244", "Weingarten\ Baden",
"496128", "Taunusstein",
"498467", "Kinding",
"492367", "Henrichenburg",
"498752", "Au\ in\ der\ Hallertau",
"494123", "Barmstedt",
"494528", "Schönwalde\ am\ Bungsberg",
"494363", "Lensahn",
"496523", "Holsthum",
"492429", "Hürtgenwald",
"4935206", "Kreischa\ bei\ Dresden",
"4933055", "Kremmen",
"4935364", "Lebusa",
"498124", "Forstern\ Oberbayern",
"498364", "Seeg",
"497202", "Karlsbad",
"492464", "Aldenhoven\ bei\ Jülich",
"4937464", "Schöneck\ Vogtland",
"4935477", "Rietzneuendorf\-Friedrichshof",
"498038", "Vogtareuth",
"497660", "St\ Peter\ Schwarzwald",
"494771", "Hemmoor",
"499157", "Alfeld\ Mittelfranken",
"495562", "Dassel\-Markoldendorf",
"496190", "Hattersheim\ am\ Main",
"4935692", "Kerkwitz",
"499451", "Schierling",
"4935454", "Uckro",
"4938735", "Plau\ am\ See",
"4934291", "Borsdorf",
"494779", "Freiburg\ Elbe",
"4933671", "Lieberose",
"496034", "Wöllstadt",
"495853", "Neu\ Darchau",
"4934609", "Salzmünde",
"495282", "Schieder\-Schwalenberg",
"4935242", "Nossen",
"498635", "Pleiskirchen",
"496873", "Nonnweiler",
"492385", "Hamm\-Rhynern",
"493394", "Wittstock\ Dosse",
"493867", "Lübstorf",
"496656", "Ebersburg",
"494132", "Amelinghausen",
"495604", "Grossalmerode",
"498708", "Weihmichl\-Unterneuhausen",
"496532", "Zeltingen\-Rachtig",
"495953", "Börger",
"495257", "Hövelhof",
"493967", "Oertzenhof\ bei\ Strasburg",
"498765", "Bruckberg\ Niederbayern",
"496742", "Boppard",
"495676", "Liebenau\ Hessen",
"495021", "Nienburg\ Weser",
"498809", "Wessobrunn",
"498380", "Achberg",
"499182", "Velburg",
"496704", "Langenlonsheim",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"495064", "Gross\ Düngen",
"4934467", "Eckartsberga",
"4933089", "Himmelpfort",
"492630", "Mülheim\-Kärlich",
"497258", "Oberderdingen\-Flehingen",
"496825", "Illingen\ Saar",
"495642", "Warburg\-Scherfede",
"4936084", "Heuthen",
"493596", "Neustadt\ in\ Sachsen",
"496776", "Dachsenhausen",
"498801", "Seeshaupt",
"493583", "Zittau",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"495555", "Moringen\-Fredelsloh",
"496400", "Mücke",
"498293", "Welden\ bei\ Augsburg",
"496575", "Landscheid",
"497434", "Winterlingen",
"497684", "Glottertal",
"494175", "Egestorf\ Nordheide",
"4939062", "Bebertal",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"494294", "Riede\ Kreis\ Verden",
"4935755", "Ortrand",
"492994", "Marsberg\-Westheim",
"497337", "Nellingen\ Alb",
"4939742", "Brüssow\ bei\ Pasewalk",
"499197", "Egloffstein",
"496150", "Weiterstadt",
"499499", "Painten",
"494550", "Bühnsdorf",
"499824", "Dietenhofen",
"497524", "Bad\ Waldsee",
"492948", "Lippstadt\-Rebbeke",
"4939348", "Klitsche",
"4933763", "Bestensee",
"494248", "Bassum\-Neubruchhausen",
"499491", "Hemau",
"496243", "Monsheim",
"493762", "Crimmitschau",
"49731", "Ulm\ Donau",
"499869", "Wettringen\ Mittelfranken",
"497569", "Isny\-Eisenbach",
"497561", "Leutkirch\ im\ Allgäu",
"499861", "Rothenburg\ ob\ der\ Tauber",
"4936602", "Ronneburg\ Thüringen",
"4938327", "Elmenhorst\ Vorpom",
"495201", "Halle\ Westfalen",
"496422", "Kirchhain",
"4936646", "Tanna\ bei\ Schleiz",
"4939243", "Nedlitz\ bei\ Zerbst",
"4939481", "Hedersleben\ bei\ Aschersleben",
"495209", "Gütersloh\-Friedrichsdorf",
"4938757", "Neustadt\-Glewe",
"4936924", "Mihla",
"493623", "Friedrichroda",
"499574", "Marktzeuln",
"497033", "Weil\ Der\ Stadt",
"497806", "Bad\ Peterstal\-Griesbach",
"4933929", "Gühlen\-Glienicke",
"498857", "Benediktbeuern",
"496655", "Neuhof\ Kreis\ Fulda",
"497347", "Dietenheim",
"4938334", "Grammendorf",
"4937755", "Schönheide\ Erzgebirge",
"497402", "Fluorn\-Winzeln",
"492264", "Marienheide",
"498766", "Gammelsdorf",
"498054", "Breitbrunn\ am\ Chiemsee",
"495675", "Trendelburg",
"494964", "Rhede\ Ems",
"4935032", "Langenhennersdorf",
"497444", "Alpirsbach",
"494921", "Emden\ Stadt",
"495755", "Kalletal\-Varenholz",
"496826", "Bexbach",
"496058", "Gründau",
"4936029", "Menteroda",
"498267", "Dirlewang",
"49760", "Oberried\ Breisgau",
"492584", "Warendorf\-Milte",
"494929", "Ihlow\ Kreis\ Aurich",
"496775", "Strüth\ Taunus",
"494104", "Aumühle\ bei\ Hamburg",
"495632", "Willingen\ Upland",
"4936943", "Bettenhausen\ Thüringen",
"495482", "Tecklenburg",
"4937325", "Niederbobritzsch",
"496504", "Thalfang",
"495556", "Lindau\ Harz",
"4939208", "Loitsche",
"498285", "Burtenbach",
"494176", "Marschacht",
"496732", "Wörrstadt",
"4939052", "Erxleben\ bei\ Haldensleben",
"4939996", "Törpin",
"4935841", "Grossschönau\ Sachsen",
"4939224", "Büden",
"494142", "Steinkirchen\ Kreis\ Stade",
"496542", "Bullay",
"499251", "Münchberg",
"498565", "Dietersburg\-Baumgarten",
"499774", "Oberelsbach",
"496081", "Usingen",
"497373", "Zwiefalten",
"497043", "Maulbronn",
"4935267", "Diesbar\-Seusslitz",
"4936691", "Eisenberg\ Thüringen",
"494454", "Jade",
"497420", "Deisslingen",
"4933366", "Chorin",
"4933204", "Beelitz\ Mark",
"4936483", "Ziegenrück",
"498453", "Reichertshofen\ Oberbayern",
"492353", "Halver",
"4936209", "Klettbach",
"499207", "Königsfeld\ Oberfranken",
"499903", "Schöllnach",
"498592", "Wegscheid\ Niederbayern",
"499654", "Pleystein",
"494357", "Sehestedt\ Eider",
"497152", "Leonberg\ Württemberg",
"4938427", "Blowatz",
"499288", "Bad\ Steben",
"492661", "Bad\ Marienberg\ Westerwald",
"497761", "Bad\ Säckingen",
"499568", "Neustadt\ bei\ Coburg",
"499323", "Iphofen",
"492938", "Ense",
"497724", "St\ Georgen\ im\ Schwarzwald",
"4933456", "Wriezen",
"496233", "Frankenthal\ Pfalz",
"495199", "Schneverdingen\-Heber",
"494238", "Neddenaverbergen",
"492624", "Höhr\-Grenzhausen",
"499163", "Dachsbach",
"499505", "Litzendorf",
"497805", "Appenweier",
"4939004", "Köckte\ bei\ Gardelegen",
"495191", "Soltau",
"493562", "Forst\ Lausitz",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"496837", "Wallerfangen",
"495583", "Braunlage\-Hohegeiss",
"4939033", "Wallstawe",
"492838", "Sonsbeck",
"4933338", "Stolpe\/Oder",
"497905", "Langenburg",
"499648", "Neustadt\ am\ Kulm",
"496020", "Heigenbrücken",
"4939427", "Ströbeck",
"499375", "Freudenberg\ Baden",
"4938375", "Koserow",
"495263", "Barntrup",
"492739", "Wilnsdorf",
"492541", "Coesfeld",
"496443", "Ehringshausen\ Dill",
"497631", "Müllheim\ Baden",
"497165", "Göppingen\-Hohenstaufen",
"496695", "Jesberg",
"4935053", "Glashütte\ Sachsen",
"497325", "Sontheim\ an\ der\ Brenz",
"494382", "Wangels",
"497503", "Wilhelmsdorf\ Württemberg",
"499803", "Colmberg",
"4933233", "Ketzin",
"498094", "Steinhöring",
"493338", "Bernau\ Brandenburg",
"495401", "Georgsmarienhütte",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"4933472", "Golzow\ bei\ Seelow",
"499332", "Marktbreit",
"496222", "Wiesloch",
"497458", "Ebhausen",
"4939886", "Milmersdorf",
"497192", "Murrhardt",
"496306", "Trippstadt",
"495354", "Jerxheim",
"4934775", "Wippra",
"493886", "Gadebusch",
"496374", "Weilerbach",
"496044", "Schotten\ Hessen",
"4938224", "Gresenhorst",
"495159", "Coppenbrügge\-Bisperode",
"496171", "Oberursel\ Taunus",
"495457", "Hopsten\-Schale",
"496002", "Ober\-Mörlen",
"4936625", "Langenwetzendorf",
"4933931", "Rheinsberg\ Mark",
"498378", "Buchenberg\ bei\ Kempten",
"4933745", "Petkus",
"4938208", "Kavelstorf",
"495151", "Hameln",
"496477", "Greifenstein\-Nenderoth",
"494821", "Itzehoe",
"4937364", "Reitzenhain\ Erzgebirge",
"495623", "Edertal",
"494829", "Wewelsfleth",
"49681", "Saarbrücken",
"494494", "Bösel\ Oldenburg",
"4934202", "Delitzsch",
"4935601", "Peitz",
"4938303", "Sellin\ Ostseebad",
"498636", "Ampfing",
"4939265", "Löderburg",
"496723", "Oestrich\-Winkel",
"49203", "Duisburg",
"494864", "Oldenswort",
"4937206", "Frankenberg\ Sachsen",
"492393", "Sundern\-Allendorf",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"497234", "Tiefenbronn",
"4935724", "Lohsa",
"498552", "Grafenau\ Niederbayern",
"4934781", "Greifenhagen",
"497053", "Bad\ Teinach\-Zavelstein",
"499366", "Geroldshausen\ Unterfranken",
"499602", "Neustadt\ an\ der\ Waldnaab",
"499126", "Eckental",
"494444", "Goldenstedt",
"495381", "Seesen",
"49521", "Bielefeld",
"494402", "Rastede",
"498020", "Weyarn",
"492834", "Straelen",
"4938488", "Demen",
"497964", "Stödtlen",
"495184", "Freden\ Leine",
"498443", "Hohenwart\ Paar",
"4939087", "Jerchel\ Altmark",
"499644", "Pressath",
"494347", "Flintbek",
"4938793", "Dergenthin",
"493334", "Eberswalde",
"497142", "Bietigheim\-Bissingen",
"496094", "Weibersbrunn",
"492156", "Willich\-Anrath",
"497309", "Weissenhorn",
"4939854", "Kleptow",
"493843", "Güstrow",
"494740", "Loxstedt\-Dedesdorf",
"495425", "Borgholzhausen",
"493437", "Grimma",
"497176", "Spraitbach",
"4938309", "Trent",
"499260", "Wilhelmsthal\ Oberfranken",
"496130", "Schwabenheim\ an\ der\ Selz",
"499971", "Cham",
"498222", "Burgau\ Schwaben",
"4935386", "Prettin",
"495822", "Ebstorf",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"496645", "Ulrichstein",
"4939039", "Bonese",
"492406", "Herzogenrath",
"498306", "Ronsberg",
"497357", "Attenweiler",
"492474", "Nideggen\-Schmidt",
"498374", "Dietmannsried",
"4938292", "Kröpelin",
"4937608", "Waldenburg\ Sachsen",
"49212", "Solingen",
"498171", "Wolfratshausen",
"495745", "Stemwede\-Levern",
"497454", "Sulz\ am\ Neckar",
"495358", "Bahrdorf\-Mackendorf",
"496048", "Büdingen\-Eckartshausen",
"49341", "Leipzig",
"492377", "Wickede\ Ruhr",
"4933972", "Breddin",
"495535", "Polle",
"498179", "Eurasburg\ an\ der\ Loisach",
"494805", "Schafstedt",
"4933678", "Storkow\ Mark",
"495546", "Scheden",
"4934298", "Taucha\ bei\ Leipzig",
"493877", "Wittenberge",
"494724", "Cuxhaven\-Lüdingworth",
"4934741", "Frose",
"49881", "Weilheim\ in\ Oberbayern",
"4933239", "Gross\ Behnitz",
"492591", "Lüdinghausen",
"495572", "Bodenfelde",
"492770", "Eschenburg",
"494761", "Bremervörde",
"4939927", "Nossentiner\ Hütte",
"494152", "Geesthacht",
"498723", "Arnstorf",
"496636", "Romrod",
"494769", "Bremervörde\-Iselersheim",
"496552", "Olzheim",
"499241", "Pegnitz",
"494498", "Saterland\-Ramsloh",
"495933", "Lathen",
"495237", "Augustdorf",
"496486", "Katzenelnbogen",
"4935792", "Ossling",
"492599", "Ascheberg\-Herbern",
"4934906", "Raguhn",
"494481", "Hatten\-Sandkrug",
"497448", "Seewald",
"495344", "Lengede",
"494631", "Glücksburg\ Ostsee",
"495074", "Rodewald",
"495833", "Brome",
"492196", "Wermelskirchen",
"492183", "Rommerskirchen",
"496766", "Kisselbach",
"496054", "Birstein",
"496587", "Zerf",
"494639", "Schafflund",
"494489", "Apen",
"492588", "Harsewinkel\-Greffen",
"494187", "Holm\-Seppensen",
"495447", "Lembruch",
"499431", "Schwandorf",
"495149", "Wienhausen",
"492205", "Rösrath",
"499681", "Windischeschenbach",
"4936203", "Vieselbach",
"492268", "Kürten",
"494968", "Neulehe",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"495302", "Vechelde",
"495141", "Celle",
"499439", "Neunburg\-Kemnath",
"496267", "Fahrenbach\ Baden",
"4939606", "Glienke",
"498504", "Tittling",
"496285", "Walldürn\-Altheim",
"497382", "Römerstein",
"494108", "Rosengarten\ Kreis\ Harburg",
"492507", "Havixbeck",
"498732", "Frontenhausen",
"496103", "Langen\ Hessen",
"496508", "Hetzerath\ Mosel",
"494503", "Timmendorfer\ Strand",
"495922", "Bad\ Bentheim",
"4939292", "Biederitz",
"494165", "Hollenstedt\ Nordheide",
"496565", "Dudeldorf",
"498542", "Ortenburg",
"497579", "Schwenningen\ Baden",
"498081", "Dorfen\ Stadt",
"4939341", "Redekin",
"4936702", "Lauscha",
"499658", "Georgenberg",
"499871", "Windsbach",
"497571", "Sigmaringen",
"499778", "Fladungen",
"49345", "Halle\ Saale",
"492551", "Steinfurt\-Burgsteinfurt",
"495473", "Ostercappeln",
"493772", "Schneeberg\ Erzgebirge",
"496592", "Daun",
"494458", "Wiefelstede\-Spohle",
"496453", "Gemünden\ Wohra",
"4936023", "Horsmar",
"4938854", "Redefin",
"493943", "Wernigerode",
"494192", "Bad\ Bramstedt",
"4935600", "Döbern\ NL",
"495320", "Torfhaus",
"497728", "Niedereschach",
"496627", "Nentershausen\ Hessen",
"492934", "Sundern\-Altenhellefeld",
"4939488", "Güntersberge",
"499564", "Bad\ Rodach",
"495226", "Bruchmühlen\ Westfalen",
"492628", "Rhens",
"494234", "Dörverden",
"4936949", "Obermassfeld\-Grimmenthal",
"49911", "Nuremberg",
"499529", "Oberaurach",
"499284", "Schwarzenbach\ an\ der\ Saale",
"493735", "Marienberg\ Sachsen",
"498233", "Kissing",
"499521", "Hassfurt",
"497821", "Lahr\ Schwarzwald",
"495068", "Elze\ Leine",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"494703", "Loxstedt\-Donnern",
"4936764", "Neuhaus\-Schierschnitz",
"498656", "Anger",
"497254", "Waghäusel",
"498532", "Griesbach\ im\ Rottal",
"492195", "Radevormwald",
"498742", "Velden\ Vils",
"496765", "Gemünden\ Hunsrück",
"4933769", "Töpchin",
"498704", "Altdorf\-Pfettrach",
"495608", "Söhrewald",
"4933836", "Butzow\ bei\ Brandenburg",
"496809", "Grossrosseln",
"492206", "Overath",
"4933966", "Dranse",
"493381", "Brandenburg\ an\ der\ Havel",
"4936424", "Kahla\ Thüringen",
"494974", "Neuharlingersiel",
"498825", "Krün",
"495665", "Guxhagen",
"492274", "Elsdorf\ Rheinland",
"497085", "Enzklösterle",
"499147", "Nennslingen",
"4939201", "Wolmirstedt",
"495131", "Garbsen",
"496286", "Walldürn\-Rippberg",
"496293", "Schefflenz",
"495139", "Burgwedel",
"499441", "Kelheim",
"495437", "Menslage",
"494298", "Lilienthal",
"493425", "Wurzen",
"495843", "Wustrow\ Wendland",
"494166", "Ahlerstedt",
"4933923", "Flecken\ Zechlin",
"496566", "Körperich",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"496787", "Niederbrombach",
"494641", "Süderbrarup",
"4939975", "Thürkow",
"494326", "Wankendorf",
"492902", "Warstein",
"493535", "Herzberg\ Elster",
"499352", "Lohr\ am\ Main",
"49541", "Osnabrück",
"499729", "Grettstadt",
"495527", "Duderstadt",
"494202", "Achim\ bei\ Bremen",
"499721", "Schweinfurt",
"493745", "Falkenstein\ Vogtland",
"498243", "Fuchstal",
"497123", "Metzingen\ Württemberg",
"499828", "Rügland",
"497528", "Neukirch\ bei\ Tettnang",
"497363", "Lauchheim",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"499764", "Höchheim",
"492944", "Rietberg\-Mastholte",
"4939388", "Goldbeck\ Altm",
"4933653", "Ziltendorf",
"494244", "Harpstedt",
"493933", "Genthin",
"499173", "Thalmässing",
"492751", "Bad\ Berleburg",
"497651", "Titisee\-Neustadt",
"495225", "Spenge",
"498422", "Dollnstein",
"4933873", "Grosswudicke",
"4937600", "Neumark\ Sachsen",
"492162", "Viersen",
"4939825", "Wokuhl",
"4939396", "Neukirchen\ Altmark",
"492759", "Bad\ Berleburg\-Aue",
"4936337", "Schiedungen",
"4939409", "Eilsleben",
"496857", "Namborn",
"493546", "Lübben\ Spreewald",
"497771", "Stockach",
"492858", "Hünxe",
"495692", "Wolfhagen",
"492671", "Cochem",
"495273", "Beverungen",
"495977", "Spelle",
"493302", "Hennigsdorf",
"499365", "Rimpar",
"4933331", "Casekow",
"4934382", "Nerchau",
"492958", "Büren\-Harth",
"49201", "Essen",
"496253", "Fürth\ Odenwald",
"4935954", "Grossharthau",
"493447", "Altenburg\ Thüringen",
"494258", "Schwarme",
"4937293", "Eppendorf\ Sachsen",
"4938825", "Klütz",
"497132", "Neckarsulm",
"493344", "Bad\ Freienwalde",
"499484", "Brennberg",
"499928", "Kirchdorf\ im\ Wald",
"498433", "Königsmoos",
"492333", "Ennepetal",
"498683", "Tittmoning",
"499634", "Wiesau",
"494337", "Jevenstedt",
"49209", "Gelsenkirchen",
"492844", "Rheinberg\-Orsoy",
"4939934", "Gross\ Plasten",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"495426", "Glandorf",
"494434", "Colnrade",
"494684", "Langeness\ Hallig",
"492802", "Alpen",
"497175", "Leinzell",
"498847", "Obersöchering",
"4936072", "Weissenborn\-Lüderode",
"494561", "Neustadt\ in\ Holstein",
"496646", "Grebenau",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"495772", "Espelkamp",
"496161", "Brensbach",
"492405", "Würselen",
"495943", "Emlichheim",
"499231", "Marktredwitz",
"495247", "Harsewinkel",
"496752", "Kirn\ Nahe",
"496467", "Hatzfeld\ Eder",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"49431", "Kiel",
"496329", "Weidenthal\ Pfalz",
"498368", "Halblech",
"495746", "Rödinghausen",
"4938201", "Gelbensande",
"492981", "Winterberg\ Westfalen",
"4935827", "Nieder\-Seifersdorf",
"494281", "Zeven",
"497248", "Marxzell",
"4936465", "Oberndorf\ bei\ Apolda",
"496672", "Eiterfeld",
"4938782", "Reetz\ bei\ Perleberg",
"496124", "Bad\ Schwalbach",
"494289", "Kirchtimke",
"495652", "Bad\ Sooden\-Allendorf",
"496364", "Nussbach\ Pfalz",
"496897", "Sulzbach\ Saar",
"495536", "Holzminden\-Neuhaus",
"494524", "Scharbeutz\-Pönitz",
"494806", "Sarzbüttel",
"495545", "Hedemünden",
"499392", "Faulbach\ Unterfranken",
"4933632", "Hangelsberg",
"494874", "Todenbüttel",
"493727", "Mittweida",
"498034", "Brannenburg",
"499083", "Möttingen",
"496635", "Kirtorf",
"4935608", "Gross\ Ossnig",
"4934493", "Gössnitz\ Thüringen",
"496485", "Nentershausen\ Westerwald",
"495309", "Lehre\-Wendhausen",
"499682", "Erbendorf",
"4937320", "Mulda\ Sachsen",
"4936259", "Tabarz\ Thüringer\ Wald",
"495142", "Eschede",
"495301", "Lehre\-Essenrode",
"494482", "Hatten",
"494556", "Ahrensbök\-Gnissau",
"494632", "Steinbergkirche",
"495176", "Edemissen",
"4938332", "Gross\ Bisdorf",
"4939887", "Gerswalde",
"497425", "Trossingen",
"4933703", "Sperenberg",
"498731", "Dingolfing",
"498549", "Vilshofen\-Pleinting",
"496343", "Bad\ Bergzabern",
"496073", "Babenhausen\ Hessen",
"497381", "Münsingen",
"4937207", "Hainichen\ Sachsen",
"494348", "Schönkirchen",
"495921", "Nordhorn",
"4939222", "Möser",
"494755", "Ihlienworth",
"495053", "Fassberg\-Müden",
"497389", "Heroldstatt",
"496834", "Bous",
"4939054", "Flechtingen",
"498541", "Vilshofen\ Niederbayern",
"4936968", "Rossdorf\ Rhön",
"4933435", "Rehfelde",
"497184", "Kaisersbach",
"495964", "Lähden",
"49721", "Karlsruhe",
"492636", "Burgbrohl",
"494497", "Barssel\-Harkebrügge",
"495238", "Nieheim\-Himmighausen",
"496599", "Weidenbach\ bei\ Gerolstein",
"498393", "Holzgünz",
"498386", "Oberstaufen",
"492486", "Nettersheim",
"492552", "Steinfurt\-Borghorst",
"497736", "Tengen",
"497546", "Oberteuringen",
"499846", "Ipsheim",
"4939426", "Hessen",
"493771", "Aue\ Sachsen",
"496591", "Gerolstein",
"4933202", "Töplitz",
"494191", "Kaltenkirchen\ Holstein",
"498082", "Schwindegg",
"492863", "Velen",
"497237", "Neulingen\ Enzkreis",
"497933", "Creglingen",
"496650", "Hosenfeld",
"494394", "Bokhorst",
"497572", "Mengen\ Württemberg",
"499872", "Heilsbronn",
"4936451", "Buttelstedt",
"494885", "Bergenhusen",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"492378", "Fröndenberg\-Langschede",
"4934745", "Winningen\ Sachsen\-Anhalt",
"493528", "Radeberg",
"4939002", "Oebisfelde",
"496047", "Altenstadt\ Hessen",
"495357", "Grasleben",
"4938738", "Karow\ bei\ Lübz",
"497822", "Ettenheim",
"499522", "Eltmann",
"496474", "Villmar\-Aumenau",
"499835", "Ehingen\ Mittelfranken",
"4937433", "Gutenfürst",
"4939723", "Krien",
"497358", "Eberhardzell\-Füramoos",
"492645", "Vettelschoss",
"497745", "Jestetten",
"496406", "Lollar",
"495454", "Hörstel\-Riesenbeck",
"494401", "Brake\ Unterweser",
"4938723", "Kladrum",
"494795", "Garlstedt",
"492565", "Gronau\-Epe",
"499935", "Stephansposching",
"495086", "Celle\-Scheuen",
"492103", "Hilden",
"496507", "Neumagen\-Dhron",
"494409", "Westerstede\-Ocholt",
"492508", "Drensteinfurt",
"494107", "Siek\ Kreis\ Stormarn",
"498640", "Reit\ Im\ Winkl",
"4933367", "Friedrichswalde\ Brandenburg",
"4935266", "Heyda\ bei\ Riesa",
"495382", "Bad\ Gandersheim",
"496268", "Hüffenhardt",
"494967", "Rhauderfehn\-Burlage",
"494263", "Scheessel",
"492963", "Brilon\-Messinghausen",
"492267", "Wipperfürth",
"498584", "Breitenberg\ Niederbayern",
"499533", "Untermerzbach",
"497833", "Hornberg\ Schwarzwaldbahn",
"4933474", "Neutrebbin",
"498057", "Aschau\-Sachrang",
"496205", "Hockenheim",
"497344", "Blaubeuren",
"499972", "Waldmünchen",
"4933457", "Altreetz",
"4938353", "Gützkow\ bei\ Greifswald",
"498221", "Günzburg",
"495448", "Barver",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"497141", "Ludwigsburg\ Württemberg",
"492587", "Ennigerloh\-Westkirchen",
"494188", "Welle\ Nordheide",
"492054", "Essen\-Kettwig",
"496183", "Erlensee",
"4934444", "Lützen",
"496196", "Bad\ Soden\ am\ Taunus",
"496588", "Pluwig",
"4938370", "Kröslin",
"497666", "Denzlingen",
"497447", "Baiersbronn\-Schwarzenberg",
"499946", "Hohenwarth\ bei\ Kötzing",
"4938426", "Neuburg\-Steinhausen",
"499423", "Geiselhöring",
"497226", "Bühl\-Sand",
"495864", "Jameln",
"498624", "Obing",
"4939345", "Parchen",
"498661", "Grabenstätt\ Chiemsee",
"495821", "Bad\ Bevensen",
"4938222", "Semlow",
"498146", "Moorenweis",
"495494", "Holdorf\ Niedersachsen",
"492627", "Braubach",
"494623", "Böklund",
"496628", "Oberaula",
"498669", "Traunreut",
"497727", "Vöhrenbach",
"495829", "Wriedel",
"496559", "Leidenborn",
"4933734", "Felgentreu",
"492453", "Heinsberg\-Randerath",
"495571", "Uslar",
"492592", "Selm",
"4935722", "Lauta\ bei\ Hoyerswerda",
"494159", "Basthorst",
"494762", "Kutenholz",
"4936739", "Rottenbach",
"4934204", "Schkeuditz",
"494151", "Schwarzenbek",
"4939997", "Jarmen",
"498135", "Sulzemoos",
"499777", "Ostheim\ von\ der\ Rhön",
"499242", "Gössweinstein",
"496551", "Prüm",
"493691", "Eisenach\ Thüringen",
"494354", "Fleckeby",
"499657", "Waldthurn",
"499204", "Plankenfels",
"4937362", "Seiffen\ Erzgebirge",
"497473", "Mössingen",
"499276", "Bischofsgrün",
"496788", "Sien",
"494796", "Teufelsmoor",
"497139", "Neuenstadt\ am\ Kocher",
"4933849", "Wiesenburg\ Mark",
"492566", "Legden",
"4938326", "Grimmen",
"499936", "Wallerfing",
"495085", "Burgdorf\-Ehlershausen",
"4934344", "Kohren\-Sahlis",
"497131", "Heilbronn\ Neckar",
"4936844", "Rohr\ Thüringen",
"499733", "Münnerstadt",
"498784", "Hohenthann",
"492293", "Nümbrecht",
"4939772", "Rothemühl",
"497334", "Deggingen",
"493301", "Oranienburg",
"494297", "Ottersberg\-Posthausen",
"495438", "Bakum\-Lüsche",
"4936379", "Holzengel",
"4938453", "Mistorf",
"499148", "Ettenstatt",
"496881", "Lebach",
"497843", "Renchen",
"499543", "Hirschaid",
"4934262", "Falkenhain\ bei\ Wurzen",
"4937328", "Grossschirma",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"496274", "Waldbrunn\ Odenwald",
"493964", "Bredenfelde\ bei\ Strasburg",
"492801", "Xanten",
"496206", "Lampertheim",
"4938756", "Grabow",
"495254", "Paderborn\-Schloss\ Neuhaus",
"495607", "Fuldatal",
"498630", "Oberneukirchen",
"4939205", "Langenweddingen",
"496195", "Kelkheim\ Taunus",
"4936647", "Saalburg\ Thüringen",
"4939971", "Gnoien",
"497665", "March\ Breisgau",
"493921", "Burg\ bei\ Magdeburg",
"499945", "Arnbruck",
"496707", "Windesheim",
"495067", "Bockenem",
"492982", "Medebach",
"4934929", "Straach",
"4937462", "Rothenkirchen\ Vogtland",
"492857", "Rees\-Mehr",
"494853", "Sankt\ Michaelisdonn",
"496026", "Grossostheim",
"495659", "Ringgau",
"494282", "Sittensen",
"496858", "Ottweiler\-Fürth",
"495651", "Eschwege",
"497225", "Gaggenau",
"4934466", "Janisroda",
"4935362", "Schönewalde\ bei\ Herzberg",
"496322", "Bad\ Dürkheim",
"494562", "Grömitz",
"499232", "Wunsiedel",
"495771", "Rahden\ Westfalen",
"498145", "Mammendorf",
"496162", "Reinheim\ Odenwald",
"496751", "Bad\ Sobernheim",
"4935244", "Krögis",
"4939821", "Carpin",
"4934423", "Heuckewalde",
"499827", "Lichtenau\ Mittelfranken",
"497527", "Wolfegg",
"49741", "Rottweil",
"498136", "Markt\ Indersdorf",
"499194", "Ebermannstadt",
"4935694", "Gosda\ bei\ Klinge",
"499391", "Marktheidenfeld",
"4935452", "Golssen",
"495363", "Wolfsburg\-Vorsfelde",
"495528", "Gieboldehausen",
"499275", "Speichersdorf",
"495123", "Schellerten",
"4936082", "Ershausen",
"493382", "Lehnin",
"4935773", "Schleife",
"4936652", "Wurzbach",
"4933335", "Pinnow\ Kreis\ Uckermark",
"495294", "Hövelhof\-Espeln",
"496802", "Völklingen\-Lauterbach",
"4938821", "Lüdersdorf",
"4938378", "Heringsdorf\ Seebad",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"498531", "Pocking",
"496155", "Griesheim\ Hessen",
"496844", "Blieskastel\-Altheim",
"4935207", "Moritzburg",
"494338", "Alt\ Duvenstedt",
"495175", "Lehrte\-Arpke",
"498741", "Vilsbiburg",
"496333", "Waldfischbach\-Burgalben",
"499927", "Kirchberg\ Wald",
"497426", "Gosheim",
"499223", "Rugendorf",
"499404", "Nittendorf",
"4939744", "Rothenklempenow",
"494756", "Odisheim",
"494642", "Kappeln\ Schlei",
"497273", "Hagenbach\ Pfalz",
"497977", "Oberrot\ bei\ Gaildorf",
"494953", "Bunde",
"494257", "Schweringen",
"493448", "Meuselwitz\ Thüringen",
"495132", "Lehrte",
"499307", "Altertheim",
"494604", "Grossenwiehe",
"498063", "Feldkirchen\-Westerham",
"492957", "Wünnenberg\-Haaren",
"492253", "Bad\ Münstereifel",
"499442", "Riedenburg",
"4935476", "Wittmannsdorf\-Bückchen",
"495978", "Hörstel\-Dreierwalde",
"4935433", "Vetschau",
"4936604", "Münchenbernsdorf",
"492635", "Rheinbrohl",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"498385", "Hergatz",
"492485", "Schleiden\-Dreiborn",
"4939959", "Dargun",
"493494", "Wolfen",
"497735", "Öhningen",
"497545", "Immenstaad\ am\ Bodensee",
"499845", "Oberdachstetten",
"499154", "Pommelsbrunn",
"4933609", "Brieskow\-Finkenheerd",
"493821", "Ribnitz\-Damgarten",
"499351", "Gemünden\ am\ Main",
"4936628", "Zeulenroda",
"4935027", "Weesenstein",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"4933748", "Treuenbrietzen",
"4939363", "Angern",
"4938205", "Tessin\ bei\ Rostock",
"494209", "Schwanewede",
"499722", "Werneck",
"4936461", "Bad\ Sulza",
"499359", "Karlstadt\-Wiesenfeld",
"494893", "Hohenaspe",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"4939453", "Derenburg",
"496898", "Völklingen",
"492364", "Haltern\ Westfalen",
"498464", "Dietfurt\ an\ der\ Altmühl",
"4935939", "Hochkirch",
"497943", "Schöntal\ Jagst",
"497247", "Linkenheim\-Hochstetten",
"492672", "Treis\-Karden",
"495691", "Bad\ Arolsen",
"4936922", "Gerstungen",
"498367", "Rosshaupten\ Forggensee",
"499836", "Gunzenhausen\-Cronheim",
"492752", "Bad\ Laasphe",
"494463", "Wangerland",
"497652", "Hinterzarten",
"496468", "Dautphetal\-Mornshausen",
"495248", "Langenberg\ Kreis\ Gütersloh",
"498421", "Eichstätt\ Bayern",
"492646", "Königsfeld\ Eifel",
"497746", "Wutöschingen",
"496405", "Laubach\ Hessen",
"492161", "Mönchengladbach",
"4939268", "Egeln",
"493571", "Hoyerswerda",};
$areanames{de} = {"496663", "Steinau\ an\ der\ Straße",
"4938234", "Born\ Darß",
"499636", "Plößberg",
"4935938", "Großpostwitz\ OL",
"494509", "Groß\ Grönau",
"494483", "Ovelgönne\-Großenmeer",
"4935753", "Großräschen",
"499656", "Moosbach\ bei\ Vohenstrauß",
"492339", "Sprockhövel\-Haßlinghausen",
"4935726", "Groß\ Särchen",
"497355", "Hochdorf\ Riß",
"496252", "Heppenheim\ Bergstraße",
"499141", "Weißenburg\ in\ Bayern",
"4936484", "Knau\ bei\ Pößneck",
"497351", "Biberach\ an\ der\ Riß",
"492203", "Köln\-Porz",
"495827", "Unterlüß",
"498633", "Tüßling",
"493647", "Pößneck",
"495384", "Seesen\-Groß\ Rhüden",
"4934901", "Roßlau\ Elbe",
"4939976", "Groß\ Bützin",
"4989", "München",
"498807", "Dießen\ am\ Ammersee",
"499242", "Gößweinstein",
"494497", "Barßel\-Harkebrügge",
"495053", "Faßberg\-Müden",
"498367", "Roßhaupten\ Forggensee",
"49911", "Nürnberg",
"4936949", "Obermaßfeld\-Grimmenthal",
"496364", "Nußbach\ Pfalz",
"496321", "Neustadt\ an\ der\ Weinstraße",
"4934493", "Gößnitz\ Thüringen",
"4936072", "Weißenborn\-Lüderode",
"494684", "Langeneß\ Hallig",
"4939934", "Groß\ Plasten",
"495064", "Groß\ Düngen",
"4935841", "Großschönau\ Sachsen",
"4935952", "Großröhrsdorf\ OL",
"499567", "Seßlach\-Gemünda",
"4939883", "Groß\ Dölln",
"4935248", "Schönfeld\ bei\ Großenhain",
"498170", "Straßlach\-Dingharting",
"497162", "Süßen",
"4935240", "Tauscha\ bei\ Großenhain",
"49221", "Köln",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"4934445", "Stößen",
"498536", "Kößlarn",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;