# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210602223259;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[3-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[3-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{de} = {"49221", "Köln",
"4938234", "Born\ Darß",
"497355", "Hochdorf\ Riß",
"4934493", "Gößnitz\ Thüringen",
"494509", "Groß\ Grönau",
"4936949", "Obermaßfeld\-Grimmenthal",
"498536", "Kößlarn",
"4935952", "Großröhrsdorf\ OL",
"495053", "Faßberg\-Müden",
"4939883", "Groß\ Dölln",
"499656", "Moosbach\ bei\ Vohenstrauß",
"494483", "Ovelgönne\-Großenmeer",
"499242", "Gößweinstein",
"4939976", "Groß\ Bützin",
"4934901", "Roßlau\ Elbe",
"495064", "Groß\ Düngen",
"4935841", "Großschönau\ Sachsen",
"496321", "Neustadt\ an\ der\ Weinstraße",
"498807", "Dießen\ am\ Ammersee",
"4935248", "Schönfeld\ bei\ Großenhain",
"4939934", "Groß\ Plasten",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"493647", "Pößneck",
"498170", "Straßlach\-Dingharting",
"494497", "Barßel\-Harkebrügge",
"4936484", "Knau\ bei\ Pößneck",
"4935726", "Groß\ Särchen",
"492339", "Sprockhövel\-Haßlinghausen",
"4934445", "Stößen",
"494684", "Langeneß\ Hallig",
"499141", "Weißenburg\ in\ Bayern",
"4935753", "Großräschen",
"498367", "Roßhaupten\ Forggensee",
"492203", "Köln\-Porz",
"497351", "Biberach\ an\ der\ Riß",
"496364", "Nußbach\ Pfalz",
"499567", "Seßlach\-Gemünda",
"49911", "Nürnberg",
"497162", "Süßen",
"4935938", "Großpostwitz\ OL",
"498633", "Tüßling",
"496252", "Heppenheim\ Bergstraße",
"496663", "Steinau\ an\ der\ Straße",
"499636", "Plößberg",
"495827", "Unterlüß",
"4935240", "Tauscha\ bei\ Großenhain",
"495384", "Seesen\-Groß\ Rhüden",
"4936072", "Weißenborn\-Lüderode",
"4989", "München",};
$areanames{en} = {"496565", "Dudeldorf",
"495574", "Oberweser",
"4938724", "Siggelkow",
"494805", "Schafstedt",
"494935", "Juist",
"498034", "Brannenburg",
"499088", "Mönchsdeggingen",
"4935324", "Crinitz",
"495904", "Lengerich\ Emsl",
"4939831", "Feldberg",
"494851", "Marne",
"4939084", "Lindstedt",
"495834", "Wittingen\-Knesebeck",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"499407", "Wenzenbach",
"493586", "Neugersdorf\ Sachsen",
"499251", "Münchberg",
"495704", "Petershagen\-Friedewalde",
"4936084", "Heuthen",
"495604", "Grossalmerode",
"496224", "Sandhausen\ Baden",
"499473", "Kallmünz",
"495681", "Homberg\ Efze",
"494635", "Sörup",
"493693", "Meiningen",
"499205", "Vorbach",
"494735", "Butjadingen\-Stollhamm",
"499357", "Gräfendorf\ Bayern",
"496873", "Nonnweiler",
"496737", "Köngernheim",
"497581", "Saulgau",
"497504", "Horgenzell",
"4935872", "Neusalza\-Spremberg",
"492971", "Schmallenberg\-Dorlar",
"492555", "Schöppingen",
"496637", "Feldatal",
"496159", "Messel",
"4933765", "Märkisch\ Buchholz",
"492501", "Münster\-Hiltrup",
"497974", "Bühlerzell",
"496533", "Morbach\ Hunsrück",
"492584", "Warendorf\-Milte",
"494963", "Dörpen",
"497774", "Eigeltingen",
"495492", "Steinfeld\ Oldenburg",
"494663", "Süderlügum",
"4939832", "Wesenberg",
"495194", "Bispingen",
"497674", "Todtmoos",
"494763", "Gnarrenburg",
"492771", "Dillenburg",
"494122", "Uetersen",
"492671", "Cochem",
"498506", "Bad\ Höhenstadt",
"497062", "Beilstein\ Württemberg",
"495374", "Isenbüttel",
"497821", "Lahr\ Schwarzwald",
"4935973", "Stolpen",
"499953", "Pilsting",
"4933927", "Linum",
"492824", "Kalkar",
"495283", "Lügde\-Rischenau",
"493386", "Premnitz",
"499653", "Eslarn",
"4939933", "Vollrathsruhe",
"496461", "Biedenkopf",
"4936702", "Lauscha",
"494188", "Welle\ Nordheide",
"493841", "Wismar",
"492355", "Schalksmühle",
"499480", "Sünching",
"492207", "Kürten\-Dürscheid",
"4933962", "Heiligengrabe",
"4936701", "Lichte",
"497381", "Münsingen",
"498170", "Strasslach\-Dingharting",
"497304", "Blaustein\ Württemberg",
"4933872", "Hohennauen",
"498456", "Lenting",
"4939857", "Drense",
"499861", "Rothenburg\ ob\ der\ Tauber",
"492301", "Holzwickede",
"496333", "Waldfischbach\-Burgalben",
"492384", "Welver",
"498294", "Horgau",
"492405", "Würselen",
"497454", "Sulz\ am\ Neckar",
"494261", "Rotenburg\ Wümme",
"497152", "Leonberg\ Württemberg",
"492273", "Kerpen\-Horrem",
"494367", "Grossenbrode",
"4934295", "Krensitz",
"498306", "Ronsberg",
"497485", "Empfingen",
"4933969", "Stepenitz",
"495044", "Springe\-Eldagsen",
"492451", "Geilenkirchen",
"494836", "Hennstedt\ Dithmarschen",
"496185", "Hammersbach\ Hessen",
"4936603", "Weida",
"492208", "Niederkassel",
"495345", "Baddeckenstedt",
"4937603", "Wildenfels",
"496452", "Battenberg\ Eder",
"496154", "Ober\-Ramstadt",
"4935267", "Diesbar\-Seusslitz",
"4934343", "Regis\-Breitingen",
"497051", "Calw",
"498563", "Bad\ Birnbach\ Rottal",
"4933675", "Tauche",
"495199", "Schneverdingen\-Heber",
"494706", "Schiffdorf",
"499236", "Nagel",
"495441", "Diepholz",
"492054", "Essen\-Kettwig",
"494606", "Wanderup",
"4939603", "Burg\ Stargard",
"496302", "Winnweiler",
"498667", "Seeon\-Seebruck",
"495839", "Wittingen\-Ohrdorf",
"499146", "Markt\ Berolzheim",
"494252", "Bruchhausen\-Vilsen",
"495909", "Wettrup",
"497161", "Göppingen",
"49203", "Duisburg",
"492462", "Linnich",
"492164", "Jüchen\-Otzenrath",
"498039", "Rott\ am\ Inn",
"4936253", "Georgenthal\ Thüringer\ Wald",
"495426", "Glandorf",
"499852", "Feuchtwangen",
"498535", "Haarbach",
"494187", "Holm\-Seppensen",
"496229", "Neckarsteinach",
"495609", "Ahnatal",
"495545", "Hedemünden",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"49721", "Karlsruhe",
"492389", "Werne",
"496638", "Schwalmtal\-Renzendorf",
"499262", "Wallenfels",
"496772", "Nastätten",
"496672", "Eiterfeld",
"497309", "Weissenhorn",
"4934776", "Rothenschirmbach",
"498363", "Pfronten",
"496502", "Schweich",
"494862", "Garding",
"497459", "Nagold\-Hochdorf",
"4935774", "Boxberg\ Sachsen",
"498431", "Neuburg\ an\ der\ Donau",
"493725", "Zschopau",
"4938374", "Lassan\ bei\ Wolgast",
"497945", "Wüstenrot",
"499087", "Marktoffingen",
"499408", "Altenthann",
"497222", "Rastatt",
"4936734", "Leutenberg",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"495379", "Sassenburg\-Grussendorf",
"497745", "Jestetten",
"49345", "Halle\ Saale",
"493925", "Stassfurt",
"497645", "Freiamt",
"492436", "Wegberg\-Rödgen",
"4936074", "Worbis",
"4938821", "Lüdersdorf",
"498335", "Fellheim",
"499358", "Gössenheim",
"494921", "Emden\ Stadt",
"499106", "Markt\ Erlbach",
"4934779", "Abberode",
"497375", "Obermarchtal",
"4934772", "Helbra",
"497471", "Hechingen",
"4933434", "Herzfelde\ bei\ Strausberg",
"497253", "Bad\ Schönborn",
"492474", "Nideggen\-Schmidt",
"494721", "Cuxhaven",
"4938826", "Dassow",
"494621", "Schleswig",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"494334", "Bredenbek\ bei\ Rendsburg",
"495351", "Helmstedt",
"494946", "Grossefehn\-Bagband",
"492592", "Selm",
"492248", "Hennef\-Uckerath",
"4934771", "Querfurt",
"495257", "Hövelhof",
"4933920", "Walsleben\ bei\ Neuruppin",
"495305", "Sickte",
"494746", "Hagen\ bei\ Bremerhaven",
"495401", "Georgsmarienhütte",
"495484", "Lienen\-Kattenvenne",
"495182", "Gronau\ Leine",
"494646", "Mohrkirch",
"496342", "Schweigen\-Rechtenbach",
"497045", "Oberderdingen",
"493529", "Heidenau\ Sachsen",
"495455", "Tecklenburg\-Brochterbeck",
"497835", "Zell\ am\ Harmersbach",
"499823", "Leutershausen",
"494230", "Verden\-Walle",
"497905", "Langenburg",
"492954", "Rüthen\-Oestereiden",
"4938455", "Plaaz",
"499448", "Hausen\ Niederbayern",
"4933847", "Görzke",
"497575", "Messkirch",
"492985", "Winterberg\-Niedersfeld",
"497951", "Crailsheim",
"4935434", "Altdöbern",
"497651", "Titisee\-Neustadt",
"492685", "Flammersfeld",
"4934975", "Görzig\ Kreis\ Köthen",
"497751", "Waldshut",
"4934224", "Belgern\ Sachsen",
"495128", "Hohenhameln",
"497705", "Wolterdingen\ Schwarzw",
"494223", "Ganderkesee\-Bookholzberg",
"492654", "Polch",
"498067", "Tuntenhausen",
"494498", "Saterland\-Ramsloh",
"492754", "Bad\ Laasphe\-Feudingen",
"495975", "Rheine\-Mesum",
"4933395", "Zerpenschleuse",
"499383", "Wiesentheid",
"499190", "Heroldsbach",
"494534", "Steinburg\ Kreis\ Storman",
"495551", "Northeim",
"495505", "Hardegsen",
"496430", "Hahnstätten",
"494874", "Todenbüttel",
"492392", "Werdohl",
"498639", "Neumarkt\-Sankt\ Veit",
"498157", "Feldafing",
"498282", "Krumbach\ Schwaben",
"496848", "Homburg\-Einöd",
"496542", "Bullay",
"498809", "Wessobrunn",
"496298", "Möckmühl",
"496423", "Wetter\ Hessen",
"499274", "Hollfeld",
"497195", "Winnenden",
"495775", "Diepenau",
"496764", "Rheinböllen",
"494140", "Estorf\ Kreis\ Stade",
"493329", "Stahnsdorf",
"495675", "Trendelburg",
"496664", "Sinntal\-Sterbfritz",
"49961", "Weiden\ in\ der\ Oberpfalz",
"492541", "Coesfeld",
"497762", "Wehr\ Baden",
"49971", "Bad\ Kissingen",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"494339", "Christiansholm",
"497544", "Markdorf",
"4935828", "Reichenbach\ OL",
"499135", "Hessdorf\ Mittelfranken",
"498158", "Tutzing",
"497123", "Metzingen\ Württemberg",
"496297", "Ravenstein\ Baden",
"496286", "Walldürn\-Rippberg",
"497130", "Löwenstein\ Württemberg",
"498546", "Windorf\-Otterskirchen",
"497962", "Fichtenau",
"49991", "Deggendorf",
"496391", "Dahn",
"495944", "Hoogstede",
"4939484", "Harzgerode",
"499163", "Dachsbach",
"499447", "Essing",
"492526", "Sendenhorst",
"495336", "Semmenstedt",
"4938843", "Bennin",
"499722", "Werneck",
"494295", "Emtinghausen",
"494845", "Ostenfeld\ Husum",
"499622", "Hirschau\ Oberpfalz",
"497240", "Pfinztal",
"499922", "Zwiesel",
"495562", "Dassel\-Markoldendorf",
"495127", "Harsum",
"499245", "Obertrubach",
"495744", "Hüllhorst",
"494486", "Edewecht\-Friedrichsfehn",
"4933876", "Buschow",
"4936484", "Knau\ bei\ Pössneck",
"494497", "Barssel\-Harkebrügge",
"4933966", "Dranse",
"495644", "Willebadessen\-Peckelsheim",
"498734", "Reisbach\ Niederbayern",
"494153", "Lauenburg\ Elbe",
"4934321", "Leisnig",
"4938297", "Moitin",
"497806", "Bad\ Peterstal\-Griesbach",
"498634", "Garching\ an\ der\ Alz",
"497936", "Schrozberg\-Bartenstein",
"492247", "Neunkirchen\-Seelscheid",
"4934781", "Greifenhagen",
"4934673", "Heldrungen",
"494539", "Westerau",
"4935243", "Weinböhla",
"497344", "Blaubeuren",
"495258", "Salzkotten",
"498346", "Pforzen",
"496669", "Neuhof\-Hauswurz",
"498460", "Berching\-Holnstein",
"4937465", "Tannenbergsthal\ Vogtland",
"497636", "Münstertal\ Schwarzwald",
"496591", "Gerolstein",
"492445", "Schleiden\ Eifel",
"497736", "Tengen",
"4936465", "Oberndorf\ bei\ Apolda",
"499279", "Mistelgau",
"496171", "Oberursel\ Taunus",
"493631", "Nordhausen\ Thüringen",
"498076", "Pfaffing",
"495536", "Holzminden\-Neuhaus",
"493731", "Freiberg\ Sachsen",
"4938228", "Dettmannsdorf\-Kölzow",
"4934782", "Mansfeld\ Südharz",
"492137", "Neuss\-Norf",
"493931", "Stendal",
"492759", "Bad\ Berleburg\-Aue",
"495362", "Wolfsburg\-Fallersleben",
"498321", "Sonthofen",
"4934322", "Rosswein",
"4935876", "Weissenberg\ Sachsen",
"4936206", "Grossfahner",
"493681", "Suhl",
"4935691", "Bärenklau\ NL",
"4937206", "Frankenberg\ Sachsen",
"495586", "Wieda",
"492252", "Zülpich",
"496408", "Buseck",
"498191", "Landsberg\ am\ Lech",
"497173", "Heubach",
"4933397", "Wandlitz",
"496096", "Wiesen\ Unterfranken",
"4933743", "Blönsdorf",
"494462", "Wittmund",
"494164", "Harsefeld",
"495693", "Volkmarsen",
"496087", "Waldems",
"493574", "Lauchhammer",
"4936336", "Klettenberg",
"496358", "Kriegsfeld",
"493904", "Haldensleben",
"492196", "Wermelskirchen",
"493981", "Neustrelitz",
"493834", "Greifswald",
"4939206", "Eichenbarleben",
"49385", "Schwerin",
"499638", "Neualbenreuth",
"496262", "Aglasterhausen",
"4933845", "Borkheide",
"492836", "Wachtendonk",
"494208", "Grasberg",
"499738", "Rottershausen",
"499672", "Neunburg\ vorm\ Wald",
"498784", "Hohenthann",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"495103", "Wennigsen\ Deister",
"498684", "Fridolfing",
"499772", "Bischofsheim\ an\ der\ Rhön",
"4938457", "Krakow\ am\ See",
"495177", "Edemissen\-Abbensen",
"499972", "Waldmünchen",
"492429", "Hürtgenwald",
"492606", "Winningen\ Mosel",
"4935692", "Kerkwitz",
"498571", "Simbach\ am\ Inn",
"495031", "Wunstorf",
"499938", "Moos\ Niederbayern",
"4934977", "Quellendorf",
"499502", "Frensdorf",
"492368", "Oer\-Erkenschwick",
"494829", "Wewelsfleth",
"496146", "Hochheim\ am\ Main",
"4938797", "Karstädt\ Kreis\ Prignitz",
"498041", "Bad\ Tölz",
"495841", "Lüchow\ Wendland",
"499229", "Mainleus",
"496852", "Nohfelden",
"4936043", "Kirchheilingen",
"496558", "Büdesheim\ Eifel",
"4939088", "Letzlingen",
"495826", "Suderburg",
"499185", "Mühlhausen\ Oberpfalz",
"499452", "Langquaid",
"4938728", "Domsühl",
"498203", "Grossaitingen",
"499154", "Pommelsbrunn",
"498026", "Hausham",
"497269", "Sulzfeld\ Baden",
"497024", "Wendlingen\ am\ Neckar",
"495439", "Bersenbrück",
"4934923", "Cobbelsdorf",
"492862", "Südlohn",
"499302", "Rottendorf\ Unterfranken",
"492568", "Heek",
"496236", "Neuhofen\ Pfalz",
"497393", "Munderkingen",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"4938378", "Heringsdorf\ Seebad",
"4939422", "Badersleben",
"495166", "Walsrode\-Kirchboitzen",
"4936738", "Königsee",
"49760", "Oberried\ Breisgau",
"494971", "Esens",
"4935453", "Drahnsdorf",
"497325", "Sontheim\ an\ der\ Brenz",
"496022", "Obernburg\ am\ Main",
"492963", "Brilon\-Messinghausen",
"496861", "Merzig",
"499333", "Sommerhausen",
"493441", "Zeitz",
"494501", "Kastorf\ Holstein",
"492763", "Drolshagen\-Bleche",
"492663", "Westerburg\ Westerwald",
"494671", "Bredstedt",
"498232", "Schwabmünchen",
"4937422", "Markneukirchen",
"492567", "Ahaus\-Alstätte",
"492424", "Vettweiss",
"494771", "Hemmoor",
"4936422", "Reinstädt\ Thüringen",
"499365", "Rimpar",
"4937421", "Oelsnitz\ Vogtland",
"498142", "Olching",
"498444", "Schweitenkirchen",
"492935", "Sundern\-Hachen",
"4936421", "Camburg",
"494169", "Sauensiek",
"497854", "Kehl\-Goldscheuer",
"4938295", "Satow\ bei\ Bad\ Doberan",
"492851", "Rees",
"49211", "Düsseldorf",
"496653", "Burghaun",
"4937467", "Klingenthal\ Sachsen",
"496753", "Meisenheim",
"495056", "Winsen\-Meissendorf",
"493909", "Klötze\ Altmark",
"492735", "Neunkirchen\ Siegerl",
"498856", "Penzberg",
"4939421", "Osterwieck",
"496557", "Hallschlag",
"499461", "Roding",
"492635", "Rheinbrohl",
"497446", "Lossburg",
"499637", "Falkenberg\ Oberpfalz",
"494355", "Rieseby",
"499873", "Abenberg\-Wassermungenau",
"494207", "Oyten",
"499737", "Wartmannsroth",
"498266", "Kirchheim\ in\ Schwaben",
"494384", "Selent",
"4935895", "Klitten",
"497525", "Aulendorf",
"499533", "Untermerzbach",
"492261", "Gummersbach",
"494405", "Edewecht",
"495434", "Essen\ Oldenburg",
"494451", "Varel\ Jadebusen",
"497264", "Bad\ Rappenau",
"495132", "Lehrte",
"4934384", "Grossbothen",
"494273", "Kirchdorf\ bei\ Sulingen",
"492367", "Henrichenburg",
"499937", "Oberpöring",
"495242", "Rheda\-Wiedenbrück",
"4935793", "Elstra",
"499565", "Untersiemau",
"495925", "Wietmarschen",
"4938393", "Binz\ Ostseebad",
"4936026", "Struth\ bei\ Mühlhausen",
"496407", "Rabenau\ Hessen",
"494824", "Krempe",
"498092", "Grafing\ bei\ München",
"496473", "Leun",
"4935386", "Prettin",
"4938326", "Grimmen",
"496251", "Bensheim",
"496205", "Hockenheim",
"496357", "Standenbühl",
"495625", "Naumburg\ Hessen",
"493379", "Mahlow",
"4934263", "Hohburg",
"495725", "Lindhorst\ bei\ Stadthagen",
"4935726", "Gross\ Särchen",
"4938874", "Lützow",
"497356", "Schemmerhofen",
"498860", "Bernbeuren",
"4939855", "Parmen\-Weggun",
"498102", "Höhenkirchen\-Siegertsbrunn",
"492295", "Ruppichteroth",
"495060", "Bodenburg",
"492845", "Neukirchen\-Vluyn",
"498404", "Oberdolling",
"494526", "Ascheberg\ Holstein",
"4936021", "Schlotheim",
"499171", "Roth\ Mittelfranken",
"4938321", "Martensdorf\ bei\ Stralsund",
"4934297", "Liebertwolkwitz",
"494479", "Molbergen\-Peheim",
"498385", "Hergatz",
"497629", "Tegernau\ Baden",
"4938781", "Mellen",
"497729", "Tennenbronn",
"493949", "Oschersleben\ Bode",
"492486", "Nettersheim",
"4935053", "Glashütte\ Sachsen",
"4935722", "Lauta\ bei\ Hoyerswerda",
"4933925", "Wustrau\-Altfriesack",
"4938782", "Reetz\ bei\ Perleberg",
"494541", "Ratzeburg",
"4939753", "Strasburg",
"4938322", "Richtenberg",
"496788", "Sien",
"4936029", "Menteroda",
"495529", "Rhumspringe",
"492339", "Sprockhövel\-Hasslinghausen",
"495476", "Ostercappeln\-Venne",
"4936022", "Grossengottern",
"4935389", "Holzdorf\ Elster",
"498825", "Krün",
"495025", "Estorf\ Weser",
"4938789", "Wolfshagen\ bei\ Perleberg",
"497556", "Uhldingen\-Mühlhofen",
"4936426", "Ottendorf\ bei\ Stadtroda",
"496163", "Höchst\ im\ Odenwald",
"496447", "Langgöns\-Niederkleen",
"493867", "Lübstorf",
"494326", "Wankendorf",
"4938450", "Tarnow\ bei\ Bützow",
"496622", "Bebra",
"494959", "Dollart",
"495202", "Oerlinghausen",
"4933767", "Friedersdorf\ bei\ Berlin",
"49208", "Oberhausen\ Rheinland",
"496722", "Rüdesheim\ am\ Rhein",
"496245", "Biblis",
"498585", "Grainet",
"494137", "Barendorf",
"4934745", "Winningen\ Sachsen\-Anhalt",
"497148", "Grossbottwar",
"498554", "Schönberg\ Niederbayern",
"4939426", "Hessen",
"49671", "Bad\ Kreuznach",
"495468", "Bramsche\-Engter",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"49661", "Fulda",
"492153", "Nettetal\-Lobberich",
"499495", "Breitenbrunn\ Oberpfalz",
"496135", "Bodenheim\ Rhein",
"497272", "Rülzheim",
"495329", "Schulenberg\ im\ Oberharz",
"495956", "Rastdorf",
"493675", "Sonneberg\ Thüringen",
"494247", "Affinghausen",
"496053", "Wächtersbach",
"499286", "Oberkotzau",
"499847", "Ergersheim",
"495656", "Waldkappel",
"498250", "Hilgertshausen\-Tandern",
"499391", "Marktheidenfeld",
"4933438", "Altlandsberg",
"494445", "Visbek\ Kreis\ Vechta",
"497237", "Neulingen\ Enzkreis",
"498741", "Vilsbiburg",
"4939954", "Stavenhagen\ Reuterstadt",
"495467", "Voltlage",
"495143", "Winsen\ Aller",
"499964", "Stallwang",
"4938224", "Gresenhorst",
"498641", "Grassau\ Kreis\ Traunstein",
"492334", "Hagen\-Hohenlimburg",
"496383", "Glan\-Münchweiler",
"495524", "Bad\ Lauterberg\ im\ Harz",
"496190", "Hattersheim\ am\ Main",
"494248", "Bassum\-Neubruchhausen",
"497331", "Geislingen\ an\ der\ Steige",
"499423", "Geiselhöring",
"496274", "Waldbrunn\ Odenwald",
"495265", "Dörentrup",
"492646", "Königsfeld\ Eifel",
"497435", "Albstadt\-Laufen",
"499848", "Simmershofen",
"499542", "Schesslitz",
"499664", "Hahnbach",
"499764", "Höchheim",
"4935363", "Fermerswalde",
"492921", "Soest",
"493562", "Forst\ Lausitz",
"493868", "Rastow",
"498726", "Schönau\ Niederbayern",
"493644", "Apolda",
"493744", "Auerbach\ Vogtland",
"497624", "Grenzach\-Wyhlen",
"493944", "Blankenburg\ Harz",
"497724", "St\ Georgen\ im\ Schwarzwald",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"497463", "Mühlheim\ an\ der\ Donau",
"497147", "Sachsenheim\ Württemberg",
"492621", "Lahnstein",
"495233", "Steinheim\ Westfalen",
"494172", "Salzhausen",
"494474", "Garrel",
"492721", "Lennestadt",
"498243", "Fuchstal",
"492534", "Münster\-Roxel",
"496583", "Palzem",
"495324", "Vienenburg",
"4939202", "Gross\ Ammensleben",
"4936209", "Klettbach",
"4936332", "Ellrich",
"4937209", "Einsiedel\ bei\ Chemnitz",
"496787", "Niederbrombach",
"496696", "Gilserberg",
"4939488", "Güntersberge",
"492874", "Isselburg",
"494392", "Nortorf\ bei\ Neumünster",
"497531", "Konstanz",
"498165", "Neufahrn\ bei\ Freising",
"499342", "Wertheim",
"4936651", "Lobenstein",
"4937202", "Claussnitz\ bei\ Chemnitz",
"4936202", "Neudietendorf",
"4939209", "Wanzleben",
"494954", "Moormerland",
"4933363", "Altenhof\ Kreis\ Barnim",
"498055", "Halfing",
"495931", "Meppen",
"493362", "Erkner",
"4935265", "Glaubitz",
"4936201", "Walschleben",
"4935696", "Briesnig",
"499072", "Lauingen\ Donau",
"495855", "Nahrendorf",
"496106", "Rodgau",
"4936652", "Wurzbach",
"498084", "Taufkirchen\ Vils",
"493876", "Perleberg",
"498133", "Haimhausen\ Oberbayern",
"4933677", "Glienicke\ bei\ Beeskow",
"494754", "Bülkau",
"4939201", "Wolmirstedt",
"495731", "Bad\ Oeynhausen",
"4936331", "Ilfeld",
"492223", "Königswinter",
"495631", "Korbach",
"492827", "Goch\-Hassum",
"495453", "Recke",
"495271", "Höxter",
"495377", "Ehra\-Lessien",
"4937608", "Waldenburg\ Sachsen",
"497043", "Maulbronn",
"4936608", "Seelingstädt\ bei\ Gera",
"499089", "Bissingen\-Unterringingen",
"495303", "Wendeburg",
"496068", "Beerfelden",
"4939608", "Staven",
"4933841", "Belzig",
"499554", "Untersteinbach\ Unterfranken",
"492770", "Eschenburg",
"493394", "Wittstock\ Dosse",
"4934348", "Frohburg",
"496158", "Riedstadt",
"492387", "Drensteinfurt\-Walstedde",
"4933454", "Wölsickendorf\/Wollenberg",
"497307", "Senden\ Iller",
"497255", "Graben\-Neudorf",
"492204", "Bensberg",
"4935266", "Heyda\ bei\ Riesa",
"497373", "Zwiefalten",
"4935695", "Simmersdorf",
"494364", "Dahme\ Kreis\ Ostholstein",
"4933849", "Wiesenburg\ Mark",
"492058", "Wülfrath",
"497457", "Rottenburg\-Ergenzingen",
"498847", "Obersöchering",
"4936258", "Friemar",
"4934383", "Trebsen\ Mulde",
"499102", "Wilhermsdorf",
"499481", "Pfatter",
"495673", "Immenhausen\ Hessen",
"499404", "Nittendorf",
"497193", "Sulzbach\ an\ der\ Murr",
"495907", "Geeste",
"498171", "Wolfratshausen",
"495837", "Sprakensehl",
"495773", "Stemwede\-Wehdem",
"496425", "Rauschenberg\ Hessen",
"499354", "Rieneck",
"495503", "Nörten\-Hardenberg",
"494260", "Visselhövede\-Wittorf",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"4935841", "Grossschönau\ Sachsen",
"493594", "Bischofswerda",
"494189", "Undeloh",
"496227", "Walldorf\ Baden",
"495607", "Fuldatal",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"495707", "Petershagen\ Weser",
"499385", "Kolitzheim",
"4933870", "Zollchow\ bei\ Rathenow",
"494942", "Südbrookmerland",
"492596", "Nordkirchen",
"497703", "Bonndorf\ im\ Schwarzwald",
"492587", "Ennigerloh\-Westkirchen",
"497977", "Oberrot\ bei\ Gaildorf",
"496634", "Gemünden\ Felda",
"492683", "Asbach\ Westerwald",
"4935454", "Uckro",
"496734", "Flonheim",
"4935842", "Oderwitz",
"494564", "Schashagen",
"496804", "Mandelbachtal",
"496881", "Lebach",
"492983", "Winterberg\-Siedlinghausen",
"498591", "Obernzell",
"497573", "Stetten\ am\ kalten\ Markt",
"498669", "Traunreut",
"494742", "Dorum",
"495186", "Salzhemmendorf\-Wallensen",
"497833", "Hornberg\ Schwarzwaldbahn",
"494642", "Kappeln\ Schlei",
"497777", "Sauldorf",
"497903", "Mainhardt",
"495197", "Soltau\-Frielingen",
"496346", "Annweiler\ am\ Trifels",
"499825", "Herrieden",
"493437", "Grimma",
"4933978", "Segeletz",
"4934746", "Giersleben",
"492588", "Harsewinkel\-Greffen",
"499243", "Pottenstein",
"49231", "Dortmund",
"4934361", "Dahlen\ Sachsen",
"4939425", "Dingelstedt\ am\ Huy",
"497802", "Oberkirch\ Baden",
"497932", "Niederstetten\ Württemberg",
"497632", "Badenweiler",
"494843", "Viöl",
"494293", "Ottersberg\-Fischerhude",
"4936425", "Isserstedt",
"497732", "Radolfzell\ am\ Bodensee",
"4934327", "Waldheim\ Sachsen",
"499165", "Sugenheim",
"498342", "Marktoberdorf",
"495198", "Schneverdingen\-Wintermoor",
"4934924", "Zahna",
"4938292", "Kröpelin",
"498072", "Haag\ in\ Oberbayern",
"495838", "Gross\ Oesingen",
"495532", "Stadtoldendorf",
"495908", "Wietmarschen\-Lohne",
"499084", "Bissingen\ Schwaben",
"499120", "Leinburg",
"498038", "Vogtareuth",
"495872", "Stoetze",
"499133", "Baiersdorf\ Mittelfranken",
"497125", "Bad\ Urach",
"4934362", "Mügeln\ bei\ Oschatz",
"496228", "Schönau\ Odenwald",
"495608", "Söhrewald",
"495366", "Jembke",
"492388", "Hamm\-Uentrop",
"496639", "Ottrau",
"496157", "Pfungstadt",
"4935892", "Horka\ OL",
"497308", "Nersingen",
"499741", "Bad\ Brückenau",
"499641", "Grafenwöhr",
"49251", "Münster",
"497666", "Denzlingen",
"494791", "Osterholz\-Scharmbeck",
"497966", "Unterschneidheim",
"4939856", "Beenz\ bei\ Prenzlau",
"498664", "Chieming",
"499941", "Kötzting",
"498764", "Mauern\ Kreis\ Freising",
"498423", "Titting",
"497458", "Ebhausen",
"496282", "Walldürn",
"496809", "Grossrosseln",
"498542", "Ortenburg",
"492828", "Emmerich\-Elten",
"492522", "Oelde",
"495332", "Schöppenstedt",
"499726", "Euerbach",
"493961", "Altentreptow",
"499626", "Hohenburg",
"492443", "Mechernich",
"499409", "Pielenhofen",
"4933744", "Hohenseefeld",
"495378", "Sassenburg\-Platendorf",
"494101", "Pinneberg",
"494184", "Hanstedt\ Nordheide",
"494482", "Hatten",
"4933926", "Herzberg\ Mark",
"499926", "Frauenau",
"493761", "Werdau\ Sachsen",
"499359", "Karlstadt\-Wiesenfeld",
"4935891", "Rothenburg\ OL",
"493661", "Greiz",
"494155", "Büchen",
"4933967", "Freyenstein",
"496039", "Karben",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"4935823", "Ostritz",
"4933877", "Nitzahn",
"492957", "Wünnenberg\-Haaren",
"494765", "Ebersdorf\ bei\ Bremervörde",
"497066", "Bad\ Rappenau\-Bonfeld",
"4939852", "Schönermark\ bei\ Prenzlau",
"494665", "Emmelsbüll\-Horsbüll",
"495948", "Itterbeck",
"495648", "Brakel\-Gehrden",
"494965", "Surwold",
"498064", "Au\ bei\ Bad\ Aibling",
"4939859", "Fürstenwerder",
"49381", "Rostock",
"4933921", "Zechlinerhütte",
"496535", "Osann\-Monzel",
"492657", "Uersfeld",
"492553", "Ochtrup",
"496875", "Nonnweiler\-Primstal",
"495864", "Jameln",
"493382", "Lehnin",
"4938325", "Rolofshagen",
"494877", "Hennstedt\ bei\ Itzehoe",
"498452", "Geisenfeld",
"499203", "Neudrossenfeld",
"494733", "Butjadingen\-Burhave",
"4935385", "Annaburg",
"494920", "Wirdum",
"497842", "Kappelrodeck",
"494633", "Satrup",
"4938848", "Vellahn",
"493695", "Bad\ Salzungen",
"4938785", "Berge\ bei\ Perleberg",
"4935725", "Wittichenau",
"494537", "Sülfeld\ Holstein",
"4933922", "Karwesee",
"496667", "Steinau\-Ulmbach",
"498302", "Görisried",
"4933929", "Gühlen\-Glienicke",
"499371", "Miltenberg",
"4939851", "Göritz\ bei\ Prenzlau",
"499277", "Warmensteinach",
"494803", "Pahlen",
"494933", "Dornum\ Ostfriesland",
"493528", "Radeberg",
"496563", "Kyllburg",
"4936025", "Körner",
"497156", "Ditzingen",
"4935364", "Lebusa",
"499191", "Forchheim\ Oberfranken",
"4935248", "Schönfeld\ bei\ Grossenhain",
"4935877", "Cunewalde",
"492275", "Kerpen\-Buir",
"497483", "Horb\-Mühringen",
"492403", "Eschweiler\ Rheinland",
"496431", "Limburg\ an\ der\ Lahn",
"497032", "Herrenberg",
"496335", "Trulben",
"495129", "Söhlde",
"494499", "Barssel",
"494141", "Stade",
"492353", "Halver",
"4934742", "Sylda",
"499701", "Sandberg\ Unterfranken",
"494231", "Verden\ Aller",
"4938223", "Saal\ Vorpom",
"497348", "Beimerstetten",
"495254", "Paderborn\-Schloss\ Neuhaus",
"4939953", "Schwinkendorf",
"498772", "Mallersdorf\-Pfaffenberg",
"4934741", "Frose",
"498638", "Waldkraiburg",
"499655", "Tännesberg",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"497950", "Schnelldorf",
"494337", "Jevenstedt",
"494126", "Horst\ Holstein",
"499571", "Lichtenfels\ Bayern",
"499955", "Mamming",
"498502", "Fürstenzell",
"496849", "Kirkel",
"498808", "Pähl",
"493328", "Teltow",
"499831", "Gunzenhausen",
"496363", "Niederkirchen",
"499901", "Hengersberg\ Bayern",
"4938296", "Rerik\ Ostseebad",
"496776", "Dachsenhausen",
"495073", "Neustadt\-Esperke",
"4933054", "Liebenwalde",
"497347", "Dietenheim",
"492244", "Königswinter\-Oberpleis",
"496676", "Hohenroda\ Hessen",
"494372", "Westfehmarn",
"498533", "Rotthalmünster",
"498637", "Lohkirchen",
"494338", "Alt\ Duvenstedt",
"499266", "Mitwitz",
"496506", "Welschbillig",
"498807", "Diessen\ am\ Ammersee",
"493327", "Werder\ Havel",
"4938827", "Kalkhorst",
"497226", "Bühl\-Sand",
"499092", "Wemding",
"496034", "Wöllstadt",
"498565", "Dietersburg\-Baumgarten",
"497131", "Heilbronn\ Neckar",
"498224", "Offingen\ Donau",
"496183", "Erlensee",
"492432", "Wassenberg",
"498333", "Babenhausen\ Schwaben",
"496456", "Haina\ Kloster",
"4935054", "Lauenstein\ Sachsen",
"494832", "Meldorf",
"497643", "Herbolzheim\ Breisgau",
"495259", "Bad\ Driburg\-Neuenheerse",
"494902", "Jemgum\-Ditzum",
"4939205", "Langenweddingen",
"4936335", "Grosswechsungen",
"4939754", "Löcknitz\ Vorpom",
"497743", "Ühlingen\-Birkendorf",
"493923", "Zerbst",
"496668", "Birstein\-Lichenroth",
"499232", "Wunsiedel",
"494702", "Sandstedt",
"493623", "Friedrichroda",
"49541", "Osnabrück",
"493723", "Hohenstein\-Ernstthal",
"494602", "Freienwill",
"4936205", "Gräfenroda",
"4937754", "Zwönitz",
"496306", "Trippstadt",
"497943", "Schöntal\ Jagst",
"498320", "Missen\-Wilhams",
"499278", "Weidenberg",
"493464", "Sangerhausen",
"496294", "Krautheim\ Jagst",
"496844", "Blieskastel\-Altheim",
"4938873", "Carlow",
"498365", "Wertach",
"499142", "Treuchtlingen",
"499444", "Siegenburg",
"494256", "Hilgermissen",
"492958", "Büren\-Harth",
"495947", "Laar\ Vechte",
"494192", "Bad\ Bramstedt",
"492758", "Bad\ Berleburg\-Girkhausen",
"495647", "Lichtenau\-Kleinenberg",
"494494", "Bösel\ Oldenburg",
"499856", "Dürrwangen",
"498461", "Beilngries",
"4933846", "Dippmannsdorf",
"495422", "Melle",
"495543", "Staufenberg\ Niedersachsen",
"494322", "Bordesholm",
"495206", "Bielefeld\-Jöllenbeck",
"496626", "Wildeck\-Obersuhl",
"4935773", "Schleife",
"493303", "Birkenwerder",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"496726", "Lorch\ Rheingau",
"497552", "Pfullendorf",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"498823", "Mittenwald",
"4936733", "Kaulsdorf",
"496409", "Biebertal",
"4938373", "Katzow",
"493377", "Zossen\ Brandenburg",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"496359", "Grünstadt",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"494882", "Lunden",
"494209", "Schwanewede",
"495952", "Sögel",
"499639", "Mähring",
"499157", "Alfeld\ Mittelfranken",
"496641", "Lauterbach\ Hessen",
"498383", "Grünenbach\ Allgäu",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"496741", "St\ Goar",
"49431", "Kiel",
"4933762", "Zeuthen",
"4933769", "Töpchin",
"492428", "Niederzier",
"492843", "Rheinberg",
"492293", "Nümbrecht",
"499282", "Naila",
"495752", "Auetal\-Hattendorf",
"492369", "Dorsten\-Wulfen",
"495652", "Bad\ Sooden\-Allendorf",
"498274", "Buttenwiesen",
"4935727", "Burghammer",
"4938787", "Glöwen",
"498106", "Vaterstetten",
"496084", "Schmitten\ Taunus",
"494443", "Dinklage",
"494167", "Apensen",
"4933458", "Falkenberg\ Mark",
"494828", "Lägerdorf",
"494522", "Plön",
"493973", "Pasewalk",
"4935387", "Seyda",
"4934291", "Borsdorf",
"4938327", "Elmenhorst\ Vorpom",
"496120", "Aarbergen",
"497352", "Ochsenhausen",
"495594", "Bovenden\-Reyershausen",
"496055", "Freigericht",
"493907", "Gardelegen",
"493773", "Johanngeorgenstadt",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"4936254", "Friedrichswerth",
"496133", "Oppenheim",
"4936027", "Lengenfeld\ Unterm\ Stein",
"492482", "Hellenthal",
"499493", "Beratzhausen",
"4939061", "Weferlingen",
"496559", "Leidenborn",
"499228", "Thurnau",
"497181", "Schorndorf\ Württemberg",
"498370", "Wiggensbach",
"497402", "Fluorn\-Winzeln",
"498687", "Taching\-Tengling",
"4939062", "Bebertal",
"4937604", "Mosel",
"4936604", "Münchenbernsdorf",
"492065", "Duisburg\-Rheinhausen",
"495840", "Schnackenburg",
"49451", "Lübeck",
"4933965", "Herzsprung\ bei\ Wittstock",
"496243", "Monsheim",
"4934299", "Gaschwitz",
"496893", "Saarbrücken\-Ensheim",
"498583", "Neureichenau",
"4933875", "Rhinow",
"492991", "Marsberg\-Bredelar",
"492691", "Adenau",
"4934292", "Brandis\ bei\ Wurzen",
"4934344", "Kohren\-Sahlis",
"497268", "Bad\ Rappenau\-Obergimpern",
"495438", "Bakum\-Lüsche",
"4939604", "Wildberg\ bei\ Altentreptow",
"495472", "Bad\ Essen",
"496165", "Breuberg",
"495174", "Lahstedt",
"496692", "Neustadt\ Hessen",
"4934976", "Gröbzig",
"4933748", "Treuenbrietzen",
"497465", "Emmingen\-Liptingen",
"4933679", "Wendisch\ Rietz",
"495235", "Blomberg\ Lippe",
"494204", "Thedinghausen",
"499734", "Burkardroth",
"494281", "Zeven",
"499634", "Wiesau",
"492850", "Rees\-Haldern",
"499804", "Aurach",
"4938456", "Langhagen\ bei\ Güstrow",
"492364", "Haltern\ Westfalen",
"495437", "Menslage",
"497267", "Gemmingen",
"4933672", "Pfaffendorfb\ Beeskow",
"497361", "Aalen",
"499346", "Grünsfeld",
"496825", "Illingen\ Saar",
"494168", "Neu\ Wulmstorf\-Elstorf",
"4939207", "Colbitz",
"4933671", "Lieberose",
"499076", "Wittislingen",
"496102", "Neu\-Isenburg",
"494827", "Wacken",
"496404", "Lich\ Hessen",
"4936337", "Schiedungen",
"493366", "Beeskow",
"495263", "Barntrup",
"4935974", "Hinterhermsdorf",
"497433", "Balingen",
"493838", "Bergen\ auf\ Rügen",
"499321", "Kitzingen",
"4933396", "Klosterfelde",
"497420", "Deisslingen",
"493578", "Kamenz",
"497082", "Neuenbürg\ Württemberg",
"4937207", "Hainichen\ Sachsen",
"496385", "Reichenbach\-Steegen",
"4939934", "Gross\ Plasten",
"499227", "Neuenmarkt",
"494770", "Wischhafen",
"495145", "Beedenbostel",
"4936207", "Plaue\ Thüringen",
"492225", "Meckenheim\ Rheinland",
"498135", "Sulzemoos",
"499158", "Offenhausen\ Mittelfranken",
"492942", "Geseke",
"49861", "Traunstein",
"4938825", "Klütz",
"49871", "Landshut",
"494683", "Oldsum",
"495853", "Neu\ Darchau",
"492427", "Nideggen",
"492564", "Vreden",
"492642", "Remagen",
"4934242", "Hohenpriessnitz",
"498053", "Bad\ Endorf",
"492742", "Wissen",
"497561", "Leutkirch\ im\ Allgäu",
"499546", "Burgebrach",
"4934241", "Jesewitz",
"498722", "Gangkofen",
"498622", "Tacherting\-Peterskirchen",
"4938723", "Kladrum",
"495661", "Melsungen",
"4933974", "Dessow",
"4935323", "Sonnewalde",
"495761", "Stolzenau",
"4939083", "Messdorf",
"496554", "Waxweiler",
"4936083", "Uder",
"493332", "Schwedt\/Oder",
"494176", "Marschacht",
"499521", "Hassfurt",
"495961", "Haselünne",
"4934928", "Seegrehna",
"4938796", "Viesecke",
"498245", "Türkheim\ Wertach",
"493378", "Ludwigsfelde",
"496585", "Ralingen",
"49581", "Uelzen",
"495382", "Bad\ Gandersheim",
"496142", "Rüsselsheim",
"496444", "Bischoffen",
"498557", "Mauth",
"494478", "Cappeln\ Oldenburg",
"495105", "Barsinghausen",
"496856", "St\ Wendel\-Niederkirchen",
"494134", "Embsen\ Kreis\ Lüneburg",
"495151", "Hameln",
"497728", "Niedereschach",
"494432", "Dötlingen\-Brettorf",
"498753", "Elsendorf\ Niederbayern",
"4934775", "Wippra",
"497628", "Efringen\-Kirchen",
"4938791", "Bad\ Wilsnack",
"494244", "Harpstedt",
"492372", "Hemer",
"498022", "Tegernsee",
"4938780", "Lanz\ Brandenburg",
"498861", "Schongau",
"4938792", "Lenzen\ \(Elbe\)",
"495822", "Ebstorf",
"492338", "Breckerfeld",
"495528", "Gieboldehausen",
"4935244", "Krögis",
"496789", "Heimbach\ Nahe",
"499170", "Schwanstetten",
"4938320", "Tribsees",
"495695", "Twistetal",
"4936020", "Ebeleben",
"492866", "Dorsten\-Rhade",
"499306", "Kist",
"496232", "Speyer",
"497175", "Leinzell",
"499294", "Regnitzlosau",
"499844", "Obernzenn",
"494340", "Achterwehr",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"496092", "Heimbuchenthal",
"497395", "Ehingen\-Dächingen",
"494466", "Wittmund\-Ardorf",
"4933676", "Friedland\ bei\ Beeskow",
"498407", "Grossmehring",
"4939483", "Ballenstedt",
"495582", "Sankt\ Andreasberg",
"4938452", "Lalendorf",
"4938844", "Gülze",
"492256", "Mechernich\-Satzvey",
"494958", "Jemgum",
"4938459", "Laage",
"498205", "Dasing",
"492192", "Hückeswagen",
"494758", "Nordleda",
"499183", "Burgthann",
"4935697", "Bagenz",
"4936483", "Ziegenrück",
"498251", "Aichach",
"499676", "Winklarn",
"499776", "Mellrichstadt",
"492572", "Emsdetten",
"496266", "Hassmersheim",
"493496", "Köthen\ Anhalt",
"492832", "Kevelaer",
"492538", "Drensteinfurt\-Rinkerode",
"495328", "Altenau\ Harz",
"492902", "Warstein",
"4933368", "Hohensaaten",
"492602", "Montabaur",
"4938451", "Hoppenrade\ bei\ Güstrow",
"497682", "Elzach",
"499976", "Rötz",
"495221", "Herford",
"496684", "Hofbieber\-Schwarzbach",
"492633", "Brohl\-Lützing",
"496701", "Sprendlingen\ Rheinhessen",
"492733", "Hilchenbach",
"496784", "Weierbach",
"4935342", "Mühlberg\ Elbe",
"496755", "Odernheim\ am\ Glan",
"494249", "Bassum\-Nordwohlde",
"498262", "Mittelneufnach",
"495327", "Bad\ Grund\ Harz",
"496655", "Neuhof\ Kreis\ Fulda",
"495136", "Burgdorf\ Kreis\ Hannover",
"496571", "Wittlich",
"492620", "Neuhäusel\ Westerwald",
"496831", "Saarlouis",
"492803", "Wesel\-Büderich",
"499363", "Arnstein\ Unterfranken",
"492933", "Sundern\ Sauerland",
"493869", "Dümmer",
"496449", "Ehringshausen\-Katzenfurt",
"498640", "Reit\ Im\ Winkl",
"499431", "Schwandorf",
"495246", "Verl",
"494957", "Detern",
"4935058", "Pretzschendorf",
"4934296", "Groitzsch\ bei\ Pegau",
"494139", "Hohnstorf\ Elbe",
"4934223", "Dommitzsch",
"4935433", "Vetschau",
"497323", "Gerstetten",
"499335", "Aub\ Kreis\ Würzburg",
"494757", "Wanna",
"494553", "Geschendorf",
"4935341", "Bad\ Liebenwerda",
"496026", "Grossostheim",
"49341", "Leipzig",
"495723", "Bad\ Nenndorf",
"498121", "Markt\ Schwaben",
"4936330", "Grossberndten",
"495623", "Edertal",
"4939200", "Gommern",
"496203", "Ladenburg",
"495527", "Duderstadt",
"492337", "Hagen\-Dahl",
"497234", "Tiefenbronn",
"495162", "Fallingbostel",
"495464", "Alfhausen",
"496475", "Weilmünster\-Wolfenhausen",
"4937462", "Rothenkirchen\ Vogtland",
"498236", "Fischach",
"496371", "Landstuhl",
"4936462", "Ossmannstedt",
"499563", "Rödental",
"4936200", "Elxleben\ bei\ Arnstadt",
"495923", "Schüttorf",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"4939427", "Ströbeck",
"494275", "Ehrenburg",
"493647", "Pössneck",
"498146", "Moorenweis",
"494403", "Bad\ Zwischenahn",
"496041", "Glauburg",
"4936461", "Bad\ Sulza",
"4933433", "Buckow\ Märkische\ Schweiz",
"499535", "Pfarrweisach",
"4934325", "Mochau\-Lüttewitz",
"498558", "Hohenau\ Niederbayern",
"494477", "Lastrup\-Hemmelte",
"4933766", "Teupitz",
"497144", "Marbach\ am\ Neckar",
"497442", "Baiersbronn",
"493947", "Thale",
"4934785", "Sandersleben",
"499875", "Wolframs\-Eschenbach",
"494353", "Ascheffel",
"497727", "Vöhrenbach",
"495052", "Hermannsburg",
"497627", "Steinen\ Kreis\ Lörrach",
"4936427", "Dornburg\ Saale",
"494267", "Lauenbrück",
"492373", "Menden\ Sauerland",
"498206", "Egling\ an\ der\ Paar",
"498023", "Bayrischzell",
"4936945", "Henneberg",
"498394", "Lautrach",
"495823", "Bienenbüttel",
"495448", "Barver",
"4934444", "Lützen",
"494361", "Oldenburg\ in\ Holstein",
"496220", "Wilhelmsfeld",
"4939030", "Brunau",
"497387", "Hohenstein\ Württemberg",
"4933638", "Rüdersdorf\ bei\ Berlin",
"494465", "Friedeburg\ Ostfriesland",
"496233", "Frankenthal\ Pfalz",
"499867", "Geslau",
"492307", "Kamen",
"492255", "Euskirchen\-Flamersheim",
"4938462", "Baumgarten",
"497204", "Malsch\-Völkersbach",
"499128", "Feucht",
"499505", "Litzendorf",
"4938461", "Bützow",
"493391", "Neuruppin",
"499975", "Waldmünchen\-Geigant",
"493847", "Sternberg",
"496524", "Rodershausen",
"495383", "Lutter\ am\ Barenberge",
"495190", "Soltau\-Emmingen",
"4936626", "Auma",
"496467", "Hatzfeld\ Eder",
"499551", "Burgwindheim",
"4936693", "Crossen\ an\ der\ Elster",
"4938427", "Blowatz",
"499775", "Schönau\ an\ der\ Brend",
"499675", "Altendorf\ am\ Nabburg",
"492043", "Gladbeck",
"498752", "Au\ in\ der\ Hallertau",
"494433", "Dötlingen",
"498652", "Berchtesgaden",
"495274", "Nieheim",
"496265", "Billigheim\ Baden",
"496855", "Freisen",
"4939749", "Grambow\ bei\ Pasewalk",
"4936742", "Uhlstädt",
"492573", "Nordwalde",
"492677", "Lutzerath",
"494561", "Neustadt\ in\ Holstein",
"492903", "Meschede\-Freienohl",
"492833", "Kerken",
"492777", "Breitscheid\ Hessen",
"496631", "Alsfeld",
"492603", "Bad\ Ems",
"497587", "Hosskirch",
"492977", "Schmallenberg\-Bödefeld",
"496731", "Alzey",
"499749", "Oberbach\ Unterfranken",
"497683", "Simonswald",
"492507", "Havixbeck",
"4939742", "Brüssow\ bei\ Pasewalk",
"494109", "Tangstedt\ Bz\ Hamburg",
"496093", "Laufach",
"497176", "Spraitbach",
"493591", "Bautzen",
"495696", "Bad\ Arolsen\-Landau",
"499257", "Zell\ Oberfranken",
"4939741", "Jatznick",
"499305", "Estenfeld",
"492865", "Raesfeld",
"4934953", "Gräfenhainichen",
"499351", "Gemünden\ am\ Main",
"4939366", "Kehnert",
"496324", "Hassloch",
"495583", "Braunlage\-Hohegeiss",
"493969", "Siedenbollentin",
"4938758", "Dömitz",
"492193", "Dabringhausen",
"4937366", "Rübenau",
"499401", "Neutraubling",
"499484", "Brennberg",
"499182", "Velburg",
"4936741", "Bad\ Blankenburg",
"494857", "Barlt",
"497300", "Roggenburg",
"4936844", "Rohr\ Thüringen",
"4939459", "Hasselfelde",
"4936452", "Berlstedt",
"493342", "Neuenhagen\ bei\ Berlin",
"496150", "Weiterstadt",
"4933477", "Trebnitz\ bei\ Müncheberg",
"4938483", "Brüel",
"497322", "Giengen\ an\ der\ Brenz",
"496476", "Mengerskirchen",
"4936643", "Thimmendorf",
"4936459", "Blankenhain\ Thüringen",
"499081", "Nördlingen",
"4939452", "Ilsenburg",
"494858", "Sankt\ Margarethen\ Holstein",
"494552", "Leezen",
"492632", "Andernach",
"499536", "Kirchlauter",
"4939451", "Wasserleben",
"4934494", "Ehrenhain",
"492732", "Kreuztal",
"492678", "Büchel\ bei\ Cochem",
"498263", "Breitenbrunn\ Schwaben",
"492778", "Siegbach",
"499876", "Rohr\ Mittelfranken",
"4939995", "Nossendorf",
"494276", "Borstel\ bei\ Sulingen",
"49731", "Ulm\ Donau",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"4936451", "Buttelstedt",
"492932", "Neheim\-Hüsten",
"498145", "Mammendorf",
"492508", "Drensteinfurt",
"492802", "Alpen",
"493764", "Meerane",
"495135", "Burgwedel\-Fuhrberg",
"496329", "Weidenthal\ Pfalz",
"4934205", "Markranstädt",
"494402", "Rastede",
"49561", "Kassel",
"493542", "Lübbenau\ Spreewald",
"494181", "Buchholz\ in\ der\ Nordheide",
"494104", "Aumühle\ bei\ Hamburg",
"493423", "Eilenburg",
"49571", "Minden\ Westfalen",
"496468", "Dautphetal\-Mornshausen",
"4935477", "Rietzneuendorf\-Friedrichshof",
"497522", "Wangen\ im\ Allgäu",
"497443", "Dornstetten",
"498179", "Eurasburg\ an\ der\ Loisach",
"49591", "Lingen\ \(Ems\)",
"4937437", "Bad\ Elster",
"493964", "Bredenfelde\ bei\ Strasburg",
"496656", "Ebersburg",
"494352", "Damp",
"496756", "Winterbach\ Soonwald",
"495053", "Fassberg\-Müden",
"499336", "Bütthard",
"4935756", "Hosena",
"494268", "Bötersen",
"495722", "Bückeburg",
"4937320", "Mulda\ Sachsen",
"495622", "Fritzlar",
"496202", "Schwetzingen",
"4939056", "Klüden",
"499944", "Miltach",
"498661", "Grabenstätt\ Chiemsee",
"4938356", "Behrenhoff",
"494794", "Worpswede\-Ostersode",
"498761", "Moosburg\ an\ der\ Isar",
"495163", "Fallingbostel\-Dorfmark",
"495447", "Lembruch",
"498095", "Aying",
"497388", "Pfronstetten",
"499744", "Zeitlofs\-Detter",
"499644", "Pressath",
"495922", "Bad\ Bentheim",
"492308", "Unna\-Hemmerde",
"499868", "Schillingsfürst",
"499562", "Sonnefeld",
"49751", "Ravensburg",
"499127", "Rosstal\ Mittelfranken",
"495245", "Herzebrock\-Clarholz",
"492666", "Freilingen\ Westerwald",
"4939320", "Schinne",
"495953", "Börger",
"494883", "Süderstapel",
"4935751", "Welzow",
"49881", "Weilheim\ in\ Oberbayern",
"4937348", "Oberwiesenthal\ Kurort",
"498382", "Lindau\ Bodensee",
"496398", "Vorderweidenthal",
"499374", "Eschau",
"492156", "Willich\-Anrath",
"4939051", "Calvörde",
"4938351", "Mesekenhagen",
"492842", "Kamp\-Lintfort",
"492548", "Dülmen\-Rorup",
"498105", "Gilching",
"492292", "Windeck\ Sieg",
"4939825", "Wokuhl",
"498151", "Starnberg",
"499283", "Rehau",
"495753", "Auetal\-Bernsen",
"496056", "Bad\ Soden\-Salmünster",
"497249", "Stutensee",
"4939264", "Kroppenstedt",
"4939348", "Klitsche",
"495653", "Sontra",
"494323", "Bornhöved",
"497657", "Eisenbach\ Hochschwarzwald",
"495022", "Wietzen",
"497139", "Neuenstadt\ am\ Kocher",
"495861", "Dannenberg\ Elbe",
"4937383", "Lunzenau",
"493302", "Hennigsdorf",
"498822", "Oberammergau",
"496166", "Fischbachtal",
"498061", "Bad\ Aibling",
"4939059", "Wegenstedt",
"497553", "Salem\ Baden",
"4939052", "Erxleben\ bei\ Haldensleben",
"4938352", "Kemnitz\ bei\ Greifswald",
"4939723", "Krien",
"494330", "Emkendorf",
"497957", "Kressberg",
"4939383", "Sandau\ Elbe",
"4935752", "Ruhland",
"4935023", "Bad\ Gottleuba",
"492066", "Duisburg\-Homberg",
"499904", "Lalling",
"4939456", "Altenbrak",
"499834", "Theilenhofen",
"492750", "Diedenshausen",
"495407", "Wallenhorst",
"499574", "Marktzeuln",
"498582", "Röhrnbach",
"496242", "Osthofen",
"496725", "Gau\-Algesheim",
"495205", "Bielefeld\-Sennestadt",
"496625", "Niederaula",
"495357", "Grasleben",
"495251", "Paderborn",
"499704", "Euerdorf",
"494234", "Dörverden",
"499604", "Wernberg\-Köblitz",
"499681", "Windischeschenbach",
"495473", "Ostercappeln",
"494442", "Lohne\ Oldenburg",
"494144", "Himmelpforten",
"498469", "Freystadt\-Burggriesbach",
"497477", "Jungingen\ bei\ Hechingen",
"496660", "Steinau\-Marjoss",
"494523", "Malente",
"494627", "Dörpstedt",
"4939037", "Pretzier",
"499270", "Creussen",
"498328", "Balderschwang",
"497353", "Schwendi",
"4938207", "Stäbelow",
"493772", "Schneeberg\ Erzgebirge",
"4939777", "Borkenfriede",
"496434", "Bad\ Camberg",
"493672", "Rudolstadt",
"497275", "Kandel",
"496132", "Ingelheim\ am\ Rhein",
"494927", "Krummhörn\-Loquard",
"499492", "Parsberg",
"4935955", "Pulsnitz",
"499194", "Ebermannstadt",
"497403", "Dunningen",
"4937327", "Rechenberg\-Bienenmühle",
"498221", "Günzburg",
"4936924", "Mihla",
"4939746", "Krackow",
"493937", "Osterburg\ Altmark",
"496103", "Langen\ Hessen",
"492131", "Neuss",
"497478", "Hirrlingen",
"4939361", "Lüderitz",
"499545", "Buttenheim",
"4934425", "Droyssig",
"4933333", "Tantow",
"497432", "Albstadt\-Tailfingen",
"497134", "Weinsberg",
"495262", "Extertal",
"498327", "Rettenberg",
"496031", "Friedberg\ Hessen",
"498136", "Markt\ Indersdorf",
"4937361", "Neuhausen\ Erzgebirge",
"4933203", "Kleinmachnow",
"493533", "Elsterwerda",
"494928", "Ihlow\-Riepe",
"492226", "Rheinbach",
"493737", "Rochlitz",
"497083", "Bad\ Herrenalb",
"4939327", "Klietz",
"4939924", "Stuer",
"4933653", "Ziltendorf",
"494175", "Egestorf\ Nordheide",
"496693", "Neuental",
"496586", "Beuren\ Hochwald",
"4937362", "Seiffen\ Erzgebirge",
"498246", "Waal",
"496597", "Jünkerath",
"4939362", "Grieben\ bei\ Tangerhütte",
"4937369", "Wolkenstein",
"4939398", "Gross\ Garz",
"497244", "Weingarten\ Baden",
"495358", "Bahrdorf\-Mackendorf",
"4937430", "Eichigt",
"492241", "Siegburg",
"4936373", "Buttstädt",
"498723", "Arnstorf",
"495121", "Hildesheim",
"498623", "Kirchweidach",
"4938733", "Karbow\-Vietlübbe",
"4938466", "Jürgenshagen",
"4936621", "Elsterberg\ bei\ Plauen",
"494491", "Friesoythe",
"494149", "Fredenbeck",
"4933235", "Friesack",
"499345", "Külsheim\ Baden",
"496826", "Bexbach",
"498464", "Dietfurt\ an\ der\ Altmühl",
"499199", "Kunreuth",
"499441", "Kelheim",
"495236", "Blomberg\-Grossenmarpe",
"497466", "Beuron",
"4935203", "Tharandt",
"497340", "Neenstetten",
"497958", "Rot\ Am\ See\-Brettheim",
"498630", "Oberneukirchen",
"4933087", "Bredereiche",
"496439", "Holzappel",
"493461", "Merseburg\ Saale",
"492943", "Erwitte",
"496841", "Homburg\ Saar",
"496291", "Adelsheim",
"495146", "Wietze",
"496397", "Leimen\ Pfalz",
"496386", "Altenkirchen\ Pfalz",
"494682", "Amrum",
"494239", "Dörverden\-Westen",
"4936622", "Triebes",
"495852", "Bleckede",
"4933470", "Lietzen",
"499075", "Glött",
"492547", "Rosendahl\-Osterwick",
"499426", "Oberschneiding",
"492643", "Altenahr",
"498052", "Aschau\ im\ Chiemgau",
"492743", "Daaden",
"4939035", "Kuhfelde",
"497428", "Rosenfeld",
"499202", "Waischenfeld",
"498453", "Reichertshofen\ Oberbayern",
"494732", "Stadland\-Rodenkirchen",
"496336", "Dellfeld",
"498271", "Meitingen",
"497843", "Renchen",
"494632", "Steinbergkirche",
"4939246", "Lindau\ Anh",
"498377", "Unterthingau",
"494778", "Wingst",
"4936940", "Oepfershausen",
"4933932", "Fehrbellin",
"498303", "Waltenhofen",
"4934636", "Schafstädt",
"496644", "Grebenhain",
"4933703", "Sperenberg",
"496744", "Oberwesel",
"493448", "Meuselwitz\ Thüringen",
"494932", "Norderney",
"496127", "Niedernhausen\ Taunus",
"494289", "Kirchtimke",
"4939775", "Ahlbeck\ bei\ Torgelow",
"494508", "Krummesse",
"4938205", "Tessin\ bei\ Rostock",
"494802", "Wrohm",
"4938754", "Leussow\ bei\ Ludwigslust",
"496868", "Mettlach\-Tünsdorf",
"496562", "Speicher",
"499956", "Eichendorf\-Aufhausen",
"494125", "Seestermühe",
"4936873", "Themar",
"499468", "Zell\ Oberpfalz",
"4936963", "Dorndorf\ Rhön",
"495495", "Vörden\ Kreis\ Vechta",
"4933931", "Rheinsberg\ Mark",
"495286", "Ottenstein\ Niedersachsen",
"492858", "Hünxe",
"492552", "Steinfurt\-Borghorst",
"499656", "Moosbach\ bei\ Vohenstrauss",
"496536", "Kleinich",
"4938233", "Prerow\ Ostseebad",
"495171", "Peine",
"494966", "Neubörger",
"492268", "Kürten",
"498773", "Neufahrn\ in\ Niederbayern",
"495037", "Bad\ Rehburg",
"492694", "Wershofen",
"496876", "Weiskirchen\ Saar",
"494458", "Wiefelstede\-Spohle",
"497569", "Isny\-Eisenbach",
"4935932", "Guttau",
"4935939", "Hochkirch",
"498503", "Neuhaus\ am\ Inn",
"492994", "Marsberg\-Westheim",
"4939862", "Schmölln\ bei\ Prenzlau",
"494666", "Ladelund",
"4939003", "Jübar",
"4938303", "Sellin\ Ostseebad",
"496362", "Alsenz",
"494766", "Basdahl",
"4939972", "Walkendorf",
"498707", "Adlkofen",
"494308", "Schwedeneck",
"4939861", "Gramzow\ bei\ Prenzlau",
"4933833", "Wollin\ bei\ Brandenburg",
"496258", "Gernsheim",
"4939971", "Gnoien",
"497482", "Horb\-Dettingen",
"499529", "Oberaurach",
"497184", "Kaisersbach",
"493987", "Templin",
"492402", "Stolberg\ Rheinland",
"493996", "Teterow",
"492181", "Grevenbroich",
"492104", "Mettmann",
"497033", "Weil\ Der\ Stadt",
"4939827", "Schwarz\ bei\ Neustrelitz",
"4935931", "Königswartha",
"496004", "Lich\-Eberstadt",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"496081", "Usingen",
"493583", "Zittau",
"495769", "Steyerberg\-Voigtei",
"492352", "Altena\ Westfalen",
"496257", "Seeheim\-Jugenheim",
"496305", "Hochspeyer",
"499093", "Polsingen",
"4936764", "Neuhaus\-Schierschnitz",
"4935602", "Drebkau",
"499324", "Dettelbach",
"496351", "Eisenberg\ Pfalz",
"496455", "Frankenau\ Hessen",
"4935609", "Drachhausen",
"496401", "Grünberg\ Hessen",
"492433", "Hückelhoven",
"496484", "Beselich",
"496182", "Seligenstadt",
"4933237", "Paulinenaue",
"497364", "Oberkochen",
"495072", "Neustadt\-Mandelsloh",
"492267", "Wipperfürth",
"498532", "Griesbach\ im\ Rottal",
"499855", "Dentlein\ am\ Forst",
"499931", "Plattling",
"492361", "Recklinghausen",
"4939296", "Welsleben",
"4935601", "Peitz",
"4939223", "Theessen",
"494284", "Selsingen",
"4937296", "Stollberg\ Erzgebirge",
"499631", "Tirschenreuth",
"492465", "Inden",
"4933085", "Seilershof",
"494307", "Raisdorf",
"498708", "Weihmichl\-Unterneuhausen",
"494255", "Martfeld",
"498366", "Oy\-Mittelberg",
"4938859", "Alt\ Zachun",
"494865", "Osterhever",
"497260", "Sinsheim\-Hilsbach",
"49391", "Magdeburg",
"496505", "Kordel",
"4934462", "Laucha\ Unstrut",
"496551", "Prüm",
"499467", "Michelsneukirchen",
"499143", "Pappenheim\ Mittelfranken",
"495964", "Lähden",
"4933602", "Alt\ Zeschdorf",
"499524", "Zeil\ am\ Main",
"4934498", "Rositz",
"4933609", "Brieskow\-Finkenheerd",
"494193", "Henstedt\-Ulzburg",
"495664", "Morschen",
"496675", "Breitenbach\ am\ Herzberg",
"4939883", "Gross\ Dölln",
"495764", "Steyerberg",
"496775", "Strüth\ Taunus",
"4934906", "Raguhn",
"492857", "Rees\-Mehr",
"499265", "Pressig",
"495423", "Versmold",
"49371", "Chemnitz\ Sachsen",
"49361", "Erfurt",
"495848", "Trebel",
"495542", "Witzenhausen",
"4938852", "Wittenburg",
"498332", "Ottobeuren",
"497427", "Schömberg\ bei\ Balingen",
"4936785", "Gräfinau\-Angstedt",
"4938851", "Zarrentin",
"497564", "Bad\ Wurzach",
"494903", "Wymeer",
"494833", "Wesselburen",
"497642", "Endingen\ Kaiserstuhl",
"499220", "Kasendorf\-Azendorf",
"4937325", "Niederbobritzsch",
"498378", "Buchenberg\ bei\ Kempten",
"494777", "Cadenberge",
"4936848", "Wernshausen",
"492561", "Ahaus",
"497742", "Klettgau",
"4934461", "Nebra\ Unstrut",
"494977", "Blomberg\ Ostfriesland",
"497225", "Gaggenau",
"4939325", "Vinzelberg",
"494703", "Loxstedt\-Donnern",
"499233", "Arzberg\ Oberfranken",
"493622", "Waltershausen\ Thüringen",
"4933601", "Podelzig",
"497942", "Neuenstein\ Württemberg",
"493722", "Limbach\-Oberfrohna",
"494603", "Havetoft",
"493447", "Altenburg\ Thüringen",
"496128", "Taunusstein",
"496867", "Perl",
"499841", "Bad\ Windsheim",
"4938856", "Pritzier\ bei\ Hagenow",
"492175", "Leichlingen\ Rheinland",
"499386", "Prosselsheim",
"499397", "Wertheim\-Dertingen",
"495064", "Gross\ Düngen",
"4933606", "Müllrose",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"4934909", "Aken\ Elbe",
"494347", "Flintbek",
"4934466", "Janisroda",
"4939820", "Triepkendorf",
"494241", "Bassum",
"496426", "Fronhausen",
"495452", "Mettingen\ Westfalen",
"495154", "Aerzen",
"494131", "Lüneburg",
"496345", "Albersweiler",
"497042", "Vaihingen\ an\ der\ Enz",
"499826", "Weidenbach\ Mittelfranken",
"495185", "Duingen",
"492628", "Rhens",
"492928", "Soest\-Ostönnen",
"495302", "Vechelde",
"4934901", "Rosslau\ Elbe",
"493861", "Plate",
"492595", "Olfen",
"496441", "Wetzlar",
"499439", "Neunburg\-Kemnath",
"494943", "Grossefehn",
"498550", "Philippsreut",
"497702", "Blumberg\ Baden",
"4939291", "Calbe\ Saale",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"492682", "Hamm\ Sieg",
"494547", "Gudow\ Lauenburg",
"4937291", "Augustusburg",
"492982", "Medebach",
"497572", "Mengen\ Württemberg",
"4935606", "Briesen\ bei\ Cottbus",
"49212", "Solingen",
"4938425", "Kirchdorf\ Poel",
"494743", "Langen\ bei\ Bremerhaven",
"497832", "Haslach\ im\ Kinzigtal",
"494643", "Gelting\ Angeln",
"495672", "Bad\ Karlshafen",
"498254", "Altomünster",
"499103", "Cadolzburg",
"495772", "Espelkamp",
"497192", "Murrhardt",
"4937292", "Oederan",
"496545", "Blankenrath",
"4937344", "Crottendorf\ Sachsen",
"4936947", "Jüchsen",
"498285", "Burtenbach",
"4939292", "Biederitz",
"492395", "Finnentrop\-Rönkhausen",
"4939344", "Güsen",
"495502", "Dransfeld",
"495808", "Gerdau",
"4939268", "Egeln",
"496049", "Kefenrod",
"4934604", "Niemberg",
"499177", "Heideck",
"497256", "Philippsburg",
"498073", "Gars\ am\ Inn",
"4939976", "Gross\ Bützin",
"497965", "Ellwangen\-Röhlingen",
"492323", "Herne",
"495533", "Bodenwerder",
"495159", "Coppenbrügge\-Bisperode",
"495873", "Eimke",
"499434", "Bodenwöhr",
"4935936", "Sohland\ Spree",
"499132", "Herzogenaurach",
"495807", "Altenmedingen",
"495937", "Geeste\-Gross\ Hesepe",
"497665", "March\ Breisgau",
"499178", "Abenberg\ Mittelfranken",
"497765", "Rickenbach\ Hotzenwald",
"492330", "Herdecke",
"495520", "Braunlage",
"4934207", "Zwochau",
"496834", "Bous",
"494156", "Talkau",
"499242", "Gössweinstein",
"497620", "Schopfheim\-Gersbach",
"496574", "Hasborn",
"495565", "Einbeck\-Wenzen",
"497933", "Creglingen",
"499925", "Bayerisch\ Eisenstein",
"497720", "Schwenningen\ am\ Neckar",
"497803", "Gengenbach",
"499625", "Kastl\ bei\ Amberg",
"497633", "Staufen\ im\ Breisgau",
"494842", "Nordstrand",
"494292", "Ritterhude",
"4937435", "Reuth\ bei\ Plauen",
"499725", "Poppenhausen\ Unterfranken",
"498869", "Kinsau",
"497733", "Engen\ Hegau",
"498343", "Aitrang",
"4935475", "Straupitz",
"495069", "Nordstemmen",
"496681", "Hilders",
"495224", "Enger\ Westfalen",
"496781", "Idar\-Oberstein",
"496704", "Langenlonsheim",
"492523", "Wadersloh",
"495333", "Dettum",
"4933230", "Börnicke\ Kreis\ Havelland",
"498259", "Schiltberg",
"492627", "Braubach",
"499166", "Münchsteinach",
"4934632", "Mücheln\ Geiseltal",
"497141", "Ludwigsburg\ Württemberg",
"494483", "Ovelgönne\-Grossenmeer",
"4934639", "Wallendorf\ Luppe",
"496044", "Schotten\ Hessen",
"492927", "Neuengeseke",
"49841", "Ingolstadt\ Donau",
"4939997", "Jarmen",
"495320", "Torfhaus",
"4939242", "Prödel",
"4939394", "Hohenberg\-Krusemark",
"4939241", "Leitzkau",
"497126", "Burladingen\-Melchingen",
"496374", "Weilerbach",
"495365", "Wolfsburg\-Neindorf",
"4936928", "Neuenhof\ Thüringen",
"499398", "Birkenfeld\ bei\ Würzburg",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"495461", "Bramsche\ Hase",
"4939928", "Möllenhagen",
"497231", "Pforzheim",
"494348", "Schönkirchen",
"498124", "Forstern\ Oberbayern",
"494950", "Holtland",
"497337", "Nellingen\ Alb",
"498422", "Dollnstein",
"498543", "Aidenbach",
"4933475", "Letschin",
"496283", "Hardheim\ Odenwald",
"492234", "Frechen",
"492774", "Dietzhölztal",
"496887", "Schmelz\ Saar",
"494421", "Wilhelmshaven",
"498586", "Hauzenberg",
"492674", "Bad\ Bertrich",
"496246", "Eich\ Rheinhessen",
"495191", "Soltau",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"4938332", "Gross\ Bisdorf",
"497771", "Stockach",
"4938209", "Sanitz\ bei\ Rostock",
"497671", "Todtnau",
"4939779", "Eggesin",
"492581", "Warendorf",
"4939772", "Rothemühl",
"492504", "Telgte",
"497971", "Gaildorf",
"4938202", "Volkenshagen",
"4936648", "Dittersdorf\ bei\ Schleiz",
"497555", "Deggenhausertal",
"4939039", "Bonese",
"492974", "Schmallenberg\-Fredeburg",
"497584", "Altshausen",
"4938488", "Demen",
"499129", "Wendelstein",
"493976", "Torgelow\ bei\ Ueckermünde",
"496327", "Neustadt\-Lachen",
"495655", "Wanfried",
"499285", "Kirchenlamitz",
"495755", "Kalletal\-Varenholz",
"494446", "Bakum\ Kreis\ Vechta",
"4933476", "Neuhardenberg",
"4939771", "Ueckermünde",
"499254", "Gefrees",
"4938201", "Gelbensande",
"496221", "Heidelberg",
"495684", "Frielendorf",
"495601", "Schauenburg",
"4939884", "Hassleben\ bei\ Prenzlau",
"495831", "Wittingen",
"4939031", "Dähre",
"494854", "Friedrichskoog",
"495901", "Fürstenau\ bei\ Bramsche",
"4938331", "Rakow\ Vorpom",
"498177", "Münsing\ Starnberger\ See",
"495571", "Uslar",
"498031", "Rosenheim\ Oberbayern",
"495955", "Esterwegen",
"494885", "Bergenhusen",
"496136", "Nieder\-Olm",
"498386", "Oberstaufen",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"4935935", "Kleinwelka",
"492152", "Kempen",
"495041", "Springe\ Deister",
"492454", "Gangelt",
"499948", "Eschlkam",
"499350", "Eussenheim\-Hundsbach",
"492485", "Schleiden\-Dreiborn",
"498841", "Murnau\ am\ Staffelsee",
"497273", "Hagenbach\ Pfalz",
"498291", "Zusmarshausen",
"494264", "Sottrum\ Kreis\ Rotenburg",
"497451", "Horb\ am\ Neckar",
"496052", "Bad\ Orb",
"497355", "Hochdorf\ Riss",
"4939975", "Thürkow",
"492381", "Hamm\ Westfalen",
"4939224", "Büden",
"492304", "Schwerte",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"499648", "Neustadt\ am\ Kulm",
"494525", "Ahrensbök",
"4939740", "Nechlin",
"499748", "Motten",
"497384", "Schelklingen\-Hütten",
"492296", "Reichshof\-Brüchermühle",
"496162", "Reinheim\ Odenwald",
"496464", "Angelburg",
"495475", "Bohmte\-Hunteburg",
"494108", "Rosengarten\ Kreis\ Harburg",
"493844", "Schwaan",
"4937436", "Weischlitz",
"496527", "Oberweis",
"496623", "Rotenburg\ an\ der\ Fulda",
"495203", "Werther\ Westfalen",
"4935476", "Wittmannsdorf\-Bückchen",
"495026", "Steimbke",
"496723", "Oestrich\-Winkel",
"493306", "Gransee",
"495277", "Höxter\-Fürstenau",
"496630", "Schwalmtal\-Storndorf",
"492821", "Kleve\ Niederrhein",
"493968", "Schönbeck",
"497824", "Schwanau",
"4933731", "Trebbin",
"495371", "Gifhorn",
"4935605", "Komptendorf",
"4936450", "Kranichfeld",
"498166", "Allershausen\ Oberbayern",
"493563", "Spremberg",
"496061", "Michelstadt",
"494107", "Siek\ Kreis\ Stormarn",
"4933834", "Pritzerbe",
"4938426", "Neuburg\-Steinhausen",
"492161", "Mönchengladbach",
"495278", "Höxter\-Ovenhausen",
"493967", "Oertzenhof\ bei\ Strasburg",
"497164", "Boll\ Kreis\ Göppingen",
"495232", "Lage\ Lippe",
"494859", "Windbergen",
"497462", "Immendingen",
"49941", "Regensburg",
"4933633", "Spreenhagen",
"496695", "Jesberg",
"494173", "Wulfsen",
"4933089", "Himmelpfort",
"495142", "Eschede",
"495444", "Wagenfeld",
"492051", "Velbert",
"496382", "Lauterecken",
"497085", "Enzklösterle",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"4938234", "Born\ Darss",
"492779", "Greifenstein\-Beilstein",
"49681", "Saarbrücken",
"497054", "Wildberg\ Württemberg",
"493535", "Herzberg\ Elster",
"499422", "Bogen\ Niederbayern",
"496151", "Darmstadt",
"499543", "Hirschaid",
"498056", "Eggstätt",
"499647", "Kirchenthumbach",
"492509", "Nottuln\-Appelhülsen",
"496105", "Mörfelden\-Walldorf",
"4939004", "Köckte\ bei\ Gardelegen",
"499080", "Harburg\ Schwaben",
"499747", "Geroda\ Bayern",
"4938304", "Garz\ Rügen",
"4933082", "Menz\ Kreis\ Oberhavel",
"4934465", "Bad\ Bibra",
"4939321", "Arneburg",
"496328", "Elmstein",
"492745", "Brachbach\ Sieg",
"4933605", "Boossen",
"497436", "Messstetten\-Oberdigisheim",
"495266", "Lemgo\-Kirchheide",
"492645", "Vettelschoss",
"499073", "Gundelfingen\ an\ der\ Donau",
"4936964", "Dermbach\ Rhön",
"4937367", "Lengefeld\ Erzgebirge",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"498178", "Icking",
"4936781", "Grossbreitenbach",
"4938855", "Lübtheen",
"492945", "Lippstadt\-Benninghausen",
"498434", "Rennertshofen",
"4940", "Hamburg",
"4937321", "Frankenstein\ Sachsen",
"492222", "Bornheim\ Rheinland",
"496582", "Freudenburg",
"496888", "Lebach\-Steinbach",
"4937322", "Brand\-Erbisdorf",
"494269", "Ahausen\-Kirchwalsede",
"4939329", "Möringen",
"494393", "Boostedt",
"494180", "Königsmoor",
"493335", "Finowfurt",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"4933704", "Baruth\ Mark",
"499343", "Lauda\-Königshofen",
"49221", "Cologne",
"493431", "Döbeln",
"497389", "Heroldstatt",
"4939322", "Tangermünde",
"4938753", "Wöbbelin",
"498725", "Wurmannsquick",
"4937329", "Grosshartmannsdorf",
"492309", "Waltrop",
"499869", "Wettringen\ Mittelfranken",
"496263", "Neckargerach",
"4934905", "Wörlitz",
"494435", "Grossenkneten",
"4933338", "Stolpe\/Oder",
"492045", "Bottrop\-Kirchhellen",
"493493", "Bitterfeld",
"495102", "Laatzen",
"495481", "Lengerich\ Westfalen",
"499673", "Tiefenbach\ Oberpfalz",
"495404", "Westerkappeln",
"499907", "Zenting",
"499837", "Haundorf",
"499773", "Unsleben",
"496145", "Flörsheim\ am\ Main",
"499607", "Luhe\-Wildenau",
"4939404", "Ausleben",
"499973", "Furth\ im\ Wald",
"494237", "Bendingbostel",
"495354", "Jerxheim",
"497248", "Marxzell",
"494331", "Rendsburg",
"499503", "Oberhaid\ Oberfranken",
"4933208", "Fahrland",
"494724", "Cuxhaven\-Lüdingworth",
"497138", "Schwaigern",
"492471", "Roetgen\ Eifel",
"492253", "Bad\ Münstereifel",
"494624", "Kropp",
"497474", "Haigerloch",
"497172", "Lorch\ Württemberg",
"496235", "Schifferstadt",
"495692", "Wolfhagen",
"494463", "Wangerland",
"4939050", "Bartensleben",
"499186", "Lauterhofen\ Oberpfalz",
"499197", "Egloffstein",
"495825", "Wieren",
"4939393", "Werben\ Elbe",
"494924", "Moormerland\-Oldersum",
"498025", "Miesbach",
"492375", "Balve",
"4937326", "Frauenstein\ Sachsen",
"4939747", "Züsedom",
"496761", "Simmern\ Hunsrück",
"499377", "Freudenberg\-Boxtal",
"496661", "Schlüchtern",
"496599", "Weidenbach\ bei\ Gerolstein",
"492195", "Radevormwald",
"499453", "Thalmassing",
"498202", "Althegnenberg",
"4938738", "Karow\ bei\ Lübz",
"4938429", "Glasin",
"499271", "Thurnau\-Alladorf",
"4936378", "Ostramondra",
"4938422", "Neukloster",
"495585", "Herzberg\-Sieber",
"494871", "Hohenwestedt",
"499303", "Eibelstadt",
"492863", "Velen",
"4935208", "Radeburg",
"496095", "Bessenbach",
"497392", "Laupheim",
"495554", "Moringen",
"494531", "Bad\ Oldesloe",
"492651", "Mayen",
"498468", "Altmannstein\-Pondorf",
"4937295", "Lugau\ Erzgebirge",
"4933086", "Grieben\ Kreis\ Oberhavel",
"492751", "Bad\ Berleburg",
"497685", "Gutach\-Bleibach",
"497654", "Löffingen",
"497754", "Görwihl",
"492605", "Löf",
"498756", "Nandlstadt",
"492905", "Bestwig\-Ramsbeck",
"492835", "Issum",
"498656", "Anger",
"497954", "Kirchberg\ an\ der\ Jagst",
"492575", "Greven\-Reckenfeld",
"495250", "Delbrück\ Westfalen",
"4939295", "Zuchau",
"496853", "Marpingen",
"492951", "Büren",
"495741", "Lübbecke",
"494406", "Berne",
"498467", "Kinding",
"498143", "Inning\ am\ Ammersee",
"493546", "Lübben\ Spreewald",
"4937431", "Mehltheuer\ Vogtland",
"495641", "Warburg",
"4937343", "Jöhstadt",
"4935471", "Birkenhainchen",
"496652", "Hünfeld",
"494929", "Ihlow\ Kreis\ Aurich",
"498265", "Pfaffenhausen\ Schwaben",
"4939343", "Jerichow",
"494356", "Gross\ Wittensee",
"496752", "Kirn\ Nahe",
"495941", "Neuenhaus\ Dinkel",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"499378", "Eichenbühl\-Riedern",
"496394", "Bundenthal",
"4937439", "Jocketa",
"493521", "Meissen",
"499332", "Marktbreit",
"496023", "Alzenau\ in\ Unterfranken",
"495726", "Wiedensahl",
"492962", "Olsberg",
"4937360", "Olbernhau",
"496206", "Lampertheim",
"495626", "Bad\ Zwesten",
"495926", "Engden",
"4935472", "Schlepzig",
"497541", "Friedrichshafen",
"4935028", "Krippen",
"492762", "Wenden\ Südsauerland",
"4939388", "Goldbeck\ Altm",
"499566", "Meeder",
"492662", "Hachenburg",
"4939728", "Medow\ bei\ Anklam",
"4937432", "Pausa\ Vogtland",
"498233", "Kissing",
"498324", "Hindelang",
"493346", "Seelow",
"4934635", "Bad\ Lauchstädt",
"4939776", "Hintersee",
"497071", "Tübingen",
"493881", "Grevesmühlen",
"494148", "Drochtersen\-Assel",
"498093", "Glonn\ Kreis\ Ebersberg",
"4938206", "Graal\-Müritz\ Seeheilbad",
"493634", "Sömmerda",
"496472", "Weilmünster",
"4939245", "Loburg",
"496174", "Königstein\ im\ Taunus",
"495165", "Rethem\ Aller",
"499198", "Heiligenstadt\ in\ Oberfranken",
"4939036", "Binde",
"494556", "Ahrensbök\-Gnissau",
"496438", "Hünfelden",
"497959", "Frankenhardt",
"497326", "Neresheim",
"495055", "Fassberg",
"496594", "Birresborn",
"498801", "Seeshaupt",
"499872", "Heilsbronn",
"497445", "Pfalzgrafenweiler",
"49375", "Zwickau",
"492636", "Burgbrohl",
"4933479", "Küstrin\-Kietz",
"493321", "Nauen\ Brandenburg",
"499532", "Maroldsweisach",
"499908", "Schöfweg",
"495084", "Hambühren",
"492736", "Burbach\ Siegerl",
"49365", "Gera",
"49395", "Neubrandenburg",
"493425", "Wurzen",
"499608", "Kohlberg\ Oberpfalz",
"494238", "Neddenaverbergen",
"499708", "Bad\ Bocklet",
"4933472", "Golzow\ bei\ Seelow",
"499366", "Geroldshausen\ Unterfranken",
"497247", "Linkenheim\-Hochstetten",
"498731", "Dingolfing",
"498631", "Mühldorf\ am\ Inn",
"494272", "Siedenburg",
"4939457", "Benneckenstein\ Harz",
"498574", "Wittibreut",
"492686", "Weyerbusch",
"497429", "Egesheim",
"492697", "Blankenheim\-Ahrhütte",
"495034", "Neustadt\-Hagen",
"4937297", "Thum\ Sachsen",
"492593", "Ascheberg\ Westfalen",
"494779", "Freiburg\ Elbe",
"497706", "Oberbaldingen",
"495183", "Lamspringe",
"4936949", "Obermassfeld\-Grimmenthal",
"498781", "Rottenburg\ an\ der\ Laaber",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"498704", "Altdorf\-Pfettrach",
"496343", "Bad\ Bergzabern",
"497906", "Braunsbach",
"498681", "Waging\ am\ See",
"497836", "Schiltach",
"496869", "Merzig\-Silwingen",
"497576", "Krauchenwies",
"494288", "Horstedt\ Kreis\ Rotenburg",
"494509", "Gross\ Grönau",
"493831", "Stralsund",
"493984", "Prenzlau",
"493901", "Salzwedel",
"495676", "Liebenau\ Hessen",
"496073", "Babenhausen\ Hessen",
"495776", "Preussisch\ Ströhen",
"499469", "Roding\-Neubäu",
"493571", "Hoyerswerda",
"498194", "Vilgertshofen",
"497252", "Bretten",
"496007", "Rosbach\-Rodheim",
"494161", "Buxtehude",
"495976", "Salzbergen",
"4936941", "Wasungen",
"493601", "Mühlhausen\ Thüringen",
"492173", "Langenfeld\ Rheinland",
"492859", "Wesel\-Bislich",
"495506", "Adelebsen",
"499382", "Gerolzhofen",
"4934493", "Gössnitz\ Thüringen",
"492269", "Kierspe\-Rönsahl",
"498374", "Dietmannsried",
"497568", "Bad\ Wurzach\-Hauerz",
"497021", "Kirchheim\ unter\ Teck",
"4935930", "Seitschen",
"492393", "Sundern\-Allendorf",
"49981", "Ansbach",
"496543", "Büchenbeuren",
"499151", "Hersbruck",
"498283", "Neuburg\ an\ der\ Kammel",
"496124", "Bad\ Schwalbach",
"4939745", "Hetzdorf\ bei\ Strasburg",
"496422", "Kirchhain",
"49421", "Bremen",
"497376", "Langenenslingen",
"4939888", "Lychen",
"496747", "Emmelshausen",
"4934426", "Kayna",
"496647", "Herbstein\-Stockhausen",
"499105", "Grosshabersdorf",
"499822", "Bechhofen\ an\ der\ Heide",
"499528", "Donnersdorf",
"497046", "Zaberfeld",
"4936843", "Benshausen",
"494745", "Bad\ Bederkesa",
"495456", "Westerkappeln\-Velpe",
"4934907", "Jeber\-Bergfrieden",
"493371", "Luckenwalde",
"495294", "Hövelhof\-Espeln",
"495844", "Clenze",
"4938484", "Ventschow",
"493475", "Lutherstadt\ Eisleben",
"49641", "Giessen",
"494222", "Ganderkesee",
"495768", "Petershagen\-Heimsen",
"495306", "Cremlingen",
"494945", "Grossefehn\-Timmel",
"4936644", "Hirschberg\ Saale",
"49711", "Stuttgart",
"4939991", "Daberkow",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"499527", "Knetzgau",
"498345", "Stöttwang",
"499162", "Scheinfeld",
"499464", "Walderbach",
"492360", "Haltern\-Lippramsdorf",
"499723", "Röthlein",
"497735", "Öhningen",
"492446", "Heimbach\ Eifel",
"4935600", "Döbern\ NL",
"497635", "Schliengen",
"497935", "Schrozberg",
"495563", "Kreiensen",
"497805", "Appenweier",
"499923", "Teisnach",
"4939455", "Schierke",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"495767", "Warmsen",
"4933708", "Rangsdorf",
"497851", "Kehl",
"497763", "Murg",
"4936968", "Rossdorf\ Rhön",
"494674", "Ockholm",
"4939999", "Tutow",
"497663", "Eichstetten",
"4936878", "Oberland",
"494774", "Hechthausen",
"492421", "Düren",
"497567", "Leutkirch\-Friesenhofen",
"4934637", "Frankleben",
"497122", "St\ Johann\ Württemberg",
"497424", "Spaichingen",
"496864", "Mettlach",
"495875", "Emmendorf",
"498426", "Walting\ Kreis\ Eichstätt",
"494504", "Ratekau",
"498709", "Eching\ Niederbayern",
"4939247", "Güterglück",
"492325", "Wanne\-Eickel",
"495535", "Polle",
"4939992", "Görmin",
"497963", "Adelmannsfelden",
"494974", "Neuharlingersiel",
"496648", "Bad\ Salzschlirf",
"498075", "Amerang",
"496400", "Mücke",
"498545", "Hofkirchen\ Bayern",
"4934202", "Delitzsch",
"496285", "Walldürn\-Altheim",
"499221", "Kulmbach",
"4934651", "Rossla",
"496254", "Lautertal\ Odenwald",
"4939826", "Blankensee\ bei\ Neustrelitz",
"494821", "Itzehoe",
"4936694", "Schkölen\ Thüringen",
"4938308", "Göhren\ Rügen",
"495363", "Wolfsburg\-Vorsfelde",
"4939008", "Kunrau",
"496008", "Echzell",
"4938850", "Gammelin",
"495849", "Waddeweitz",
"497261", "Sinsheim",
"494152", "Geesthacht",
"494454", "Jade",
"495431", "Quakenbrück",
"499246", "Pegnitz\-Trockau",
"496550", "Irrhausen",
"492264", "Marienheide",
"4934443", "Teuchern",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"494485", "Elsfleth\-Huntorf",
"4933838", "Päwesin",
"498379", "Waltenhofen\-Oberdorf",
"497367", "Aalen\-Ebnat",
"494381", "Lütjenburg",
"4934652", "Allstedt",
"494296", "Schwanewede\-Aschwarden",
"494846", "Hattstedt",
"492525", "Beckum\-Neubeckum",
"495335", "Schladen",
"496129", "Schlangenbad",
"494287", "Heeslingen\-Boitzen",
"496872", "Losheim\ am\ See",
"493385", "Rathenow",
"496578", "Salmtal",
"496838", "Saarwellingen",
"496532", "Zeltingen\-Rachtig",
"4939829", "Blankenförde",
"494962", "Papenburg\-Aschendorf",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"494662", "Leck",
"493860", "Raben\ Steinfeld",
"4939822", "Kratzeburg",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"498649", "Schleching",
"495228", "Vlotho\-Exter",
"494762", "Kutenholz",
"496440", "Kölschhausen",
"494123", "Barmstedt",
"494544", "Berkenthin",
"4934206", "Rötha",
"4936374", "Weissensee",
"492406", "Herzogenrath",
"4939821", "Carpin",
"498257", "Inchenhofen",
"497486", "Horb\-Altheim",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"4935937", "Prischwitz",
"496198", "Eppstein",
"4935204", "Wilsdruff",
"4935755", "Ortrand",
"499472", "Hohenfels\ Oberpfalz",
"499174", "Hilpoltstein",
"494240", "Syke\-Heiligenfelde",
"4939055", "Hörsingen",
"4939977", "Jördenstorf",
"499438", "Fensterbach",
"4938355", "Züssow",
"499394", "Esselbach",
"4933654", "Fünfeichen",
"493585", "Löbau",
"4935951", "Neukirch\ Lausitz",
"499206", "Mistelgau\-Obernsees",
"494736", "Butjadingen\-Tossens",
"496332", "Zweibrücken",
"494636", "Langballig",
"492238", "Pulheim",
"498867", "Rottenbuch\ Oberbayern",
"494936", "Grossheide",
"494806", "Sarzbüttel",
"497153", "Plochingen",
"496566", "Körperich",
"494344", "Schönberg\ Holstein",
"492272", "Bedburg\ Erft",
"495067", "Bockenem",
"4936923", "Treffurt",
"497063", "Bad\ Wimpfen",
"498551", "Freyung",
"4939996", "Törpin",
"498505", "Hutthurm",
"499952", "Eichendorf",
"495157", "Emmerthal\-Börry",
"4933334", "Greiffenberg",
"4935952", "Grossröhrsdorf\ OL",
"495939", "Sustrum",
"495282", "Schieder\-Schwalenberg",
"492556", "Metelen",
"499652", "Waidhaus",
"4933204", "Beelitz\ Mark",
"4939923", "Priborn",
"496048", "Büdingen\-Eckartshausen",
"4939408", "Hadmersleben",
"494253", "Asendorf\ Kreis\ Diepholz",
"4934422", "Osterfeld",
"492624", "Höhr\-Grenzhausen",
"492724", "Finnentrop\-Serkenrode",
"494471", "Cloppenburg",
"497621", "Lörrach",
"492463", "Titz",
"495158", "Hemeringen",
"497721", "Villingen\ im\ Schwarzwald",
"493941", "Halberstadt",
"493641", "Jena",
"493741", "Plauen",
"495546", "Scheden",
"499853", "Wilburgstetten",
"496047", "Altenstadt\ Hessen",
"499179", "Freystadt",
"492924", "Möhnesee",
"492435", "Erkelenz\-Lövenich",
"499661", "Sulzbach\-Rosenberg",
"4937365", "Sayda",
"497646", "Weisweil\ Breisgau",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"497746", "Wutöschingen",
"498336", "Erkheim",
"496271", "Eberbach\ Baden",
"4934467", "Eckartsberga",
"4933607", "Briesen\ Mark",
"496453", "Gemünden\ Wohra",
"498868", "Schwabsoien",
"492237", "Kerpen\ Rheinland\-Türnich",
"498562", "Triftern",
"497334", "Deggingen",
"4939365", "Bellingen\ bei\ Stendal",
"498744", "Gerzen",
"497946", "Bretzfeld",
"496303", "Enkenbach\-Alsenborn",
"492331", "Hagen\ Westfalen",
"495521", "Herzberg\ am\ Harz",
"495068", "Elze\ Leine",
"499961", "Mitterfels",
"493726", "Flöha",
"495734", "Bergkirchen\ Westfalen",
"494751", "Otterndorf",
"4933232", "Brieselang",
"4937384", "Wechselburg",
"495634", "Waldeck\-Sachsenhausen",
"494605", "Medelby",
"497223", "Bühl\ Baden",
"498258", "Sielenbach",
"499235", "Thierstein",
"494705", "Wremen",
"495346", "Liebenburg",
"4936946", "Erbenhausen\ Thüringen",
"4939724", "Klein\ Bünzow",
"498081", "Dorfen\ Stadt",
"494835", "Albersdorf\ Holstein",
"496186", "Grosskrotzenburg",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"4939384", "Arendsee\ Altmark",
"4935024", "Stadt\ Wehlen",
"495934", "Haren\-Rütenbrock",
"494951", "Weener",
"4933239", "Gross\ Behnitz",
"495425", "Borgholzhausen",
"499263", "Ludwigsstadt",
"496837", "Wallerfangen",
"4935607", "Jänschwalde",
"496773", "Kamp\-Bornhofen",
"498536", "Kösslarn",
"496673", "Haunetal",
"494195", "Hartenholm",
"497534", "Reichenau\ Baden",
"496707", "Windesheim",
"492871", "Bocholt",
"494349", "Dänischenhagen",
"499145", "Solnhofen",
"498362", "Füssen",
"4936625", "Langenwetzendorf",
"496503", "Hermeskeil",
"4939263", "Unseburg",
"495321", "Goslar",
"4933231", "Pausin",
"494863", "Sankt\ Peter\-Ording",
"493671", "Saalfeld\ Saale",
"498036", "Stephanskirchen\ Simssee",
"496131", "Mainz",
"492103", "Hilden",
"493771", "Aue\ Sachsen",
"497183", "Rudersberg\ Württemberg",
"499149", "Weissenburg\-Suffersheim",
"495836", "Wittingen\-Radenbeck",
"499491", "Hemau",
"495906", "Lünne",
"4933843", "Niemegk",
"496226", "Meckesheim",
"499395", "Triefenstein",
"4934722", "Preusslitz",
"495606", "Zierenberg",
"495706", "Porta\ Westfalica",
"496003", "Rosbach\ von\ der\ Höhe",
"494441", "Vechta",
"495368", "Parsau",
"493501", "Pirna",
"4934382", "Nerchau",
"497034", "Ehningen",
"495429", "Melle\-Wellingholzhausen",
"4938876", "Roggendorf",
"493971", "Anklam",
"4933745", "Petkus",
"4934381", "Colditz",
"497506", "Wangen\-Leupolz",
"492693", "Antweiler",
"4934721", "Nienburg\ Saale",
"492597", "Senden\ Westfalen",
"499682", "Erbendorf",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"492586", "Beelen",
"494839", "Wöhrden\ Dithmarschen",
"497976", "Sulzbach\-Laufen",
"4933970", "Neustadt\ Dosse",
"495252", "Bad\ Lippspringe",
"494609", "Eggebek",
"495187", "Delligsen",
"497676", "Feldberg\ Schwarzwald",
"496347", "Hochstadt\ Pfalz",
"495196", "Wietzendorf",
"498504", "Tittling",
"492993", "Marsberg\-Canstein",
"498581", "Waldkirchen\ Niederbayern",
"496241", "Worms",
"494426", "Wangerland\-Horumersiel",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"499099", "Kaisheim",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"492826", "Kranenburg\ Niederrhein",
"499728", "Wülfershausen\ Unterfranken",
"4935843", "Hirschfelde\ bei\ Zittau",
"494545", "Seedorf\ Lauenburg",
"499628", "Ursensollen",
"499928", "Kirchdorf\ im\ Wald",
"495021", "Nienburg\ Weser",
"493301", "Oranienburg",
"495862", "Hitzacker\ Elbe",
"4934925", "Bad\ Schmiedeberg",
"498821", "Garmisch\-Partenkirchen",
"4936424", "Kahla\ Thüringen",
"498062", "Bruckmühl\ Mangfall",
"497306", "Vöhringen\ Iller",
"492291", "Waldbröl",
"492841", "Moers",
"497668", "Ihringen",
"499175", "Spalt",
"497844", "Rheinau",
"4938828", "Schönberg",
"498152", "Herrsching\ am\ Ammersee",
"498454", "Karlshuld",
"497456", "Haiterbach",
"498846", "Uffing\ am\ Staffelsee",
"498296", "Villenbach",
"496743", "Bacharach",
"498304", "Wildpoldsried",
"498381", "Lindenberg\ im\ Allgäu",
"496643", "Herbstein",
"497667", "Breisach\ am\ Rhein",
"498679", "Burgkirchen\ an\ der\ Alz",
"4938293", "Kühlungsborn\ Ostseebad",
"494834", "Büsum",
"495851", "Dahlenburg",
"4935247", "Zehren\ Sachsen",
"495805", "Oetzen",
"497563", "Kisslegg",
"495935", "Twist\-Schöninghsdorf",
"498051", "Prien\ am\ Chiemsee",
"496292", "Seckach",
"498509", "Ruderting",
"496842", "Blieskastel",
"495635", "Vöhl",
"493462", "Bad\ Dürrenberg",
"4934363", "Cavertitz",
"4938226", "Dierhagen\ Ostseebad",
"49511", "Hannover",
"497967", "Jagstzell",
"494681", "Wyk\ auf\ Föhr",
"494604", "Grossenwiehe",
"4939956", "Neukalen",
"492056", "Heiligenhaus",
"499234", "Neusorg",
"494704", "Drangstedt",
"495963", "Bawinkel",
"499523", "Hofheim\ in\ Unterfranken",
"4937600", "Neumark\ Sachsen",
"499442", "Riedenburg",
"4935455", "Walddrehna",
"499144", "Pleinfeld",
"499727", "Schonungen\-Marktsteinach",
"499627", "Freudenberg\ Oberpfalz",
"492166", "Mönchengladbach\-Rheydt",
"499927", "Kirchberg\ Wald",
"495424", "Bad\ Rothenfelde",
"498161", "Freising",
"496066", "Michelstadt\-Vielbrunn",
"495763", "Uchte",
"494492", "Saterland",
"494194", "Sievershütten",
"4939600", "Zwiedorf",
"495663", "Spangenberg",
"498459", "Manching",
"496650", "Hosenfeld",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"492242", "Hennef\ Sieg",
"492598", "Senden\-Ottmarsbocholt",
"4933878", "Nennhausen",
"4935795", "Königsbrück",
"497363", "Lauchheim",
"492925", "Warstein\-Allagen",
"492625", "Ochtendung",
"492725", "Lennestadt\-Oedingen",
"496348", "Offenbach\ an\ der\ Queich",
"49821", "Augsburg",
"494283", "Tarmstedt",
"4935893", "Mücka",
"496032", "Bad\ Nauheim",
"497335", "Wiesensteig",
"499323", "Iphofen",
"499094", "Tagmersheim",
"498745", "Bodenkirchen",
"4938847", "Boizenburg\ Elbe",
"496078", "Gross\-Umstadt",
"492434", "Wegberg",
"496483", "Selters\ Taunus",
"492132", "Meerbusch\-Büderich",
"495367", "Rühen",
"498222", "Burgau\ Schwaben",
"497431", "Albstadt\-Ebingen",
"4935694", "Gosda\ bei\ Klinge",
"495261", "Lemgo",
"4935826", "Königshain\ bei\ Görlitz",
"4939204", "Niederndodeleben",
"492529", "Oelde\-Stromberg",
"496050", "Biebergemünd",
"495339", "Gielde",
"4936334", "Wolkramshausen",
"4934692", "Alsleben\ Saale",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"499402", "Regenstauf",
"498253", "Pöttmes",
"499104", "Emskirchen",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"497228", "Forbach",
"4933923", "Flecken\ Zechlin",
"492150", "Meerbusch\-Lank",
"498375", "Weitnau",
"493592", "Kirschau",
"494489", "Apen",
"4937204", "Lichtenstein\ Sachsen",
"4936204", "Stotternheim",
"499352", "Lohr\ am\ Main",
"4937755", "Schönheide\ Erzgebirge",
"4935822", "Hagenwerder",
"495845", "Bergen\ Dumme",
"495295", "Lichtenau\ Westfalen",
"496732", "Wörrstadt",
"494336", "Owschlag",
"499268", "Teuschnitz",
"4939853", "Holzendorf\ bei\ Prenzlau",
"498045", "Lenggries\-Fall",
"494944", "Wiesmoor",
"496678", "Wildeck\-Hönebach",
"4934691", "Könnern",
"494644", "Karby",
"494744", "Loxstedt",
"494127", "Westerhorn",
"498549", "Vilshofen\-Pleinting",
"496802", "Völklingen\-Lauterbach",
"496508", "Hetzerath\ Mosel",
"494562", "Grömitz",
"4935829", "Gersdorf\ bei\ Görlitz",
"4939952", "Grammentin",
"498705", "Altfraunhofen",
"494258", "Schwarme",
"4938222", "Semlow",
"4933055", "Kremmen",
"498651", "Bad\ Reichenhall",
"4933977", "Gumtow",
"498751", "Mainburg",
"495153", "Salzhemmendorf",
"4934328", "Hartha\ bei\ Döbeln",
"495035", "Gross\ Munzel",
"499552", "Burghaslach",
"4938229", "Bad\ Sülze",
"492656", "Virneburg",
"4939959", "Dargun",
"494536", "Steinhorst\ Lauenburg",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"492202", "Bergisch\ Gladbach",
"493685", "Hildburghausen",
"494876", "Reher\ Holstein",
"497939", "Schrozberg\-Spielbach",
"496458", "Rosenthal\ Hessen",
"497739", "Hilzingen",
"499276", "Bischofsgrün",
"49234", "Bochum",
"497157", "Waldenbuch",
"4939951", "Faulenrost",
"496666", "Freiensteinau",
"494362", "Heiligenhafen",
"4934743", "Ermsleben",
"495063", "Bad\ Salzdetfurth",
"496766", "Kisselbach",
"4938221", "Marlow",
"498349", "Stötten\ am\ Auerberg",
"496308", "Olsbrücken",
"496373", "Schönenberg\-Kübelberg",
"4935365", "Falkenberg\ Elster",
"495921", "Nordhorn",
"497546", "Oberteuringen",
"496457", "Burgwald\ Eder",
"499561", "Coburg",
"498544", "Eging\ am\ See",
"496201", "Weinheim\ Bergstr",
"496284", "Mudau",
"495621", "Bad\ Wildungen",
"492233", "Hürth\ Rheinland",
"498123", "Moosinning",
"497158", "Neuhausen\ auf\ den\ Fildern",
"495721", "Stadthagen",
"498762", "Wartenberg\ Oberbayern",
"496255", "Lindenfels",
"494749", "Schiffdorf\-Geestenseth",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"496307", "Schopp",
"494305", "Westensee",
"494257", "Schweringen",
"495946", "Georgsdorf",
"494351", "Eckernförde",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"492524", "Ennigerloh",
"494455", "Jade\-Schweiburg",
"496580", "Zemmer",
"492265", "Reichshof\-Eckenhagen",
"495646", "Willebadessen",
"499857", "Schopfloch\ Mittelfranken",
"494484", "Hude\-Wüsting",
"496043", "Nidda",
"494401", "Brake\ Unterweser",
"495746", "Rödinghausen",
"493541", "Calau",
"494182", "Tostedt",
"4937607", "Ebersbrunn\ Sachsen",
"496573", "Gillenfeld",
"497934", "Weikersheim",
"498636", "Ampfing",
"497804", "Oppenau",
"4938872", "Rehna",
"492855", "Voerde\ Niederrhein",
"499267", "Nordhalben",
"4936607", "Niederpöllnitz",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"492931", "Arnsberg",
"4935263", "Gröditz\ bei\ Riesa",
"497346", "Illerkirchberg",
"492801", "Xanten",
"496833", "Rehlingen\-Siersburg",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"496677", "Neuenstein\ Hessen",
"496703", "Wöllstein\ Rheinhessen",
"498344", "Westendorf\ bei\ Kaufbeuren",
"4934347", "Oelzschau\ bei\ Borna",
"499465", "Neukirchen\-Balbini",
"495223", "Bünde",
"492631", "Neuwied",
"496507", "Neumagen\-Dhron",
"4939607", "Kotelow",
"494128", "Kollmar",
"497734", "Gailingen",
"497634", "Sulzburg",
"498806", "Utting\ am\ Ammersee",
"496865", "Mettlach\-Orscholz",
"495874", "Soltendieck",
"497321", "Heidenheim\ an\ der\ Brenz",
"4935724", "Lohsa",
"4938784", "Kleinow\ Kreis\ Prignitz",
"494505", "Stockelsdorf\-Curau",
"499420", "Feldkirchen\ Niederbayern",
"493445", "Naumburg\ Saale",
"4935384", "Steinsdorf\ bei\ Jessen",
"499082", "Oettingen\ in\ Bayern",
"4938324", "Velgast",
"494551", "Bad\ Segeberg",
"492324", "Hattingen\ Ruhr",
"495534", "Eschershausen\ an\ der\ Lenne",
"4935240", "Tauscha\ bei\ Grossenhain",
"498074", "Schnaitsee",
"497227", "Lichtenau\ Baden",
"494975", "Westerholt\ Ostfriesland",
"493886", "Gadebusch",
"4936024", "Diedorf\ bei\ Mühlhausen",
"494775", "Grossenwörden",
"4936257", "Luisenthal\ Thüringen",
"4938871", "Mühlen\ Eichsen",
"493341", "Strausberg",
"499433", "Nabburg",
"497425", "Trossingen",
"4938824", "Mallentin",
"495584", "Hattorf\ am\ Harz",
"496323", "Edenkoben",
"493606", "Heiligenstadt\ Heilbad",
"494166", "Ahlerstedt",
"4933436", "Prötzel",
"495971", "Rheine",
"499078", "Mertingen",
"4933763", "Bestensee",
"496094", "Weibersbrunn",
"495555", "Moringen\-Fredelsloh",
"4936071", "Teistungen",
"495771", "Rahden\ Westfalen",
"497449", "Baiersbronn\-Obertal",
"493576", "Weisswasser",
"4938371", "Karlshagen",
"497191", "Backnang",
"495671", "Hofgeismar",
"4936731", "Unterloquitz",
"4935771", "Bad\ Muskau",
"493836", "Wolgast",
"492904", "Bestwig",
"497571", "Sigmaringen",
"498593", "Untergriesbach",
"492981", "Winterberg\ Westfalen",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"4935772", "Rietschen",
"492834", "Straelen",
"497955", "Wallhausen\ Württemberg",
"4939428", "Pabstorf",
"492574", "Saerbeck",
"4938372", "Usedom",
"498686", "Petting",
"497831", "Hausach",
"4936732", "Könitz",
"4936739", "Rottenbach",
"499348", "Werbach\-Gamburg",
"4938379", "Benz\ Usedom",
"4936428", "Stadtroda",
"4936072", "Weissenborn\-Lüderode",
"497684", "Glottertal",
"497655", "Feldberg\-Altglashütten",
"4935032", "Langenhennersdorf",
"497755", "Weilheim\ Kreis\ Waldshut",
"492681", "Altenkirchen\ Westerwald",
"492604", "Nassau\ Lahn",
"496442", "Braunfels",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"496523", "Holsthum",
"495384", "Seesen\-Gross\ Rhüden",
"495301", "Lehre\-Essenrode",
"495207", "Schloss\ Holte\-Stukenbrock",
"495355", "Frellstedt",
"496627", "Nentershausen\ Hessen",
"496727", "Gensingen",
"4935436", "Laasow\ bei\ Calau",
"495273", "Beverungen",
"495451", "Ibbenbüren",
"494434", "Colnrade",
"4934293", "Naunhof\ bei\ Grimma",
"494132", "Amelinghausen",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"4934920", "Kropstädt",
"494178", "Radbruch",
"497041", "Mühlacker",
"497371", "Riedlingen\ Württemberg",
"4935975", "Hohnstein",
"498393", "Holzgünz",
"495824", "Bad\ Bodenteich",
"4935057", "Hermsdorf\ Erzgebirge",
"498024", "Holzkirchen",
"497277", "Wörth\-Büchelberg",
"498269", "Unteregg\ bei\ Mindelheim",
"494925", "Hinte",
"492374", "Iserlohn\-Letmathe",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"494892", "Schenefeld\ Mittelholstein",
"494242", "Syke",
"494725", "Helgoland",
"497203", "Walzbachtal",
"4937757", "Rittersgrün",
"494625", "Jübek",
"499548", "Mühlhausen\ Mittelfranken",
"497026", "Lenningen",
"499292", "Konradsreuth",
"499842", "Uffenheim",
"497475", "Burladingen",
"496234", "Mutterstadt",
"495462", "Ankum",
"493635", "Kölleda",
"496175", "Friedrichsdorf\ Taunus",
"497232", "Königsbach\-Stein",
"495164", "Hodenhagen",
"493735", "Marienberg\ Sachsen",
"499943", "Lam\ Oberpfalz",
"494793", "Hambergen",
"492839", "Straelen\-Herongen",
"498421", "Eichstätt\ Bayern",
"4935698", "Hornow",
"498325", "Oberstaufen\-Thalkirchdorf",
"499547", "Zapfendorf",
"4936704", "Steinheid",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"492426", "Nörvenich",
"4936255", "Goldbach\ bei\ Gotha",
"493935", "Tangerhütte",
"4933964", "Fretzdorf",
"498446", "Pörnbach",
"4933367", "Friedrichswalde\ Brandenburg",
"494103", "Wedel",
"4933874", "Stechow\ Brandenburg",
"495208", "Leopoldshöhe",
"493663", "Schleiz",
"496628", "Oberaula",
"4937605", "Hartenstein\ Sachsen",
"4936605", "Bad\ Köstritz",
"496728", "Ober\-Hilbersheim",
"493763", "Glauchau",
"495054", "Bergen\-Sülze",
"496595", "Dockweiler",
"492441", "Kall",
"4939605", "Gross\ Nemerow",
"493963", "Woldegk",
"497444", "Alpirsbach",
"497142", "Bietigheim\-Bissingen",
"4933673", "Weichensdorf",
"4934345", "Bad\ Lausick",
"494177", "Drage\ Elbe",
"495085", "Burgdorf\-Ehlershausen",
"498029", "Kreuth\ bei\ Tegernsee",
"4938722", "Raduhn",
"492379", "Menden\-Asbeck",
"494841", "Husum\ Nordsee",
"4935322", "Doberlug\-Kirchhain",
"4939082", "Mieste",
"496782", "Birkenfeld\ Nahe",
"49202", "Wuppertal",
"495829", "Wriedel",
"496682", "Tann\ Rhön",
"499347", "Wittighausen",
"496239", "Bobenheim\-Roxheim",
"4936082", "Ershausen",
"4939089", "Bismark\ Altmark",
"4935329", "Dollenchen",
"497266", "Kirchardt",
"4938729", "Marnitz",
"495436", "Nortrup",
"499241", "Pegnitz",
"4935874", "Bernstadt\ an\ der\ Eigen",
"499131", "Erlangen",
"492545", "Rosendahl\-Darfeld",
"499077", "Bachhagel",
"494826", "Hohenlockstedt",
"4936081", "Arenshausen",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"496395", "Münchweiler\ an\ der\ Rodalb",
"4938721", "Ziegendorf",
"4934243", "Bad\ Düben",
"496420", "Lahntal",
"498629", "Palling",
"497354", "Erolzheim",
"4938793", "Dergenthin",
"495592", "Gleichen\-Bremke",
"495248", "Langenberg\ Kreis\ Gütersloh",
"499865", "Adelshofen\ Mittelfranken",
"492305", "Castrop\-Rauxel",
"492257", "Reckerscheid",
"492351", "Lüdenscheid",
"494524", "Scharbeutz\-Pönitz",
"498406", "Böhmfeld",
"497385", "Gomadingen",
"496082", "Niederreifenberg",
"494143", "Drochtersen",
"494467", "Wittmund\-Funnix",
"497404", "Epfendorf",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"4939086", "Jävenitz",
"492455", "Waldfeucht",
"499193", "Höchstadt\ an\ der\ Aisch",
"496433", "Hadamar",
"492484", "Mechernich\-Eiserfey",
"492401", "Baesweiler",
"492182", "Grevenbroich\-Kapellen",
"494265", "Fintel",
"4938726", "Spornitz",
"496267", "Fahrenbach\ Baden",
"499573", "Staffelstein\ Oberfranken",
"499677", "Oberviechtach\-Pullenried",
"497825", "Kippenheim",
"499903", "Schöllnach",
"499777", "Ostheim\ von\ der\ Rhön",
"496361", "Rockenhausen",
"499833", "Heidenheim\ Mittelfranken",
"495172", "Ilsede",
"499603", "Floss",
"495474", "Stemwede\-Dielingen",
"496465", "Breidenbach\ bei\ Biedenkopf",
"499977", "Arnschwang",
"499820", "Lehrberg",
"494233", "Blender",
"495138", "Sehnde",
"4934324", "Ostrau\ Sachsen",
"4934927", "Globig\-Bleddin",
"492505", "Altenberge\ Westfalen",
"496109", "Frankfurt\-Bergen\-Enkheim",
"4936481", "Neustadt\ an\ der\ Orla",
"497554", "Heiligenberg\ Baden",
"497585", "Ostrach",
"492975", "Schmallenberg\-Oberkirchen",
"4933747", "Marzahna",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"492551", "Steinfurt\-Burgsteinfurt",
"494324", "Brokstedt",
"492775", "Driedorf",
"492675", "Ediger\-Eller",
"4939481", "Hedersleben\ bei\ Aschersleben",
"498556", "Haidmühle",
"496857", "Namborn",
"499373", "Amorbach",
"494855", "Eddelak",
"497250", "Kraichtal",
"4939482", "Gatersleben",
"4939208", "Loitsche",
"4938453", "Mistorf",
"496028", "Sulzbach\ am\ Main",
"496561", "Bitburg",
"494931", "Norden",
"495954", "Lorup",
"4936338", "Bleicherode",
"494884", "Schwabstedt",
"495654", "Herleshausen",
"4937208", "Auerswalde",
"494631", "Glücksburg\ Ostsee",
"498272", "Wertingen",
"499201", "Gesees",
"494731", "Nordenham",
"4936208", "Ermstedt",
"499284", "Schwarzenbach\ an\ der\ Saale",
"495754", "Extertal\-Bremke",
"499255", "Marktleugast",
"499307", "Altertheim",
"498238", "Gessertshausen",
"492867", "Heiden\ Kreis\ Borken",
"4934973", "Osternienburg",
"4939489", "Strassberg\ Harz",
"4936482", "Triptis",
"495685", "Knüllwald",
"497941", "Öhringen",
"492336", "Schwelm",
"4938328", "Miltzow",
"499966", "Wiesenfelden",
"4935388", "Klöden",
"493721", "Meinersdorf",
"49335", "Frankfurt\ \(Oder\)",
"493621", "Gotha\ Thüringen",
"4938845", "Kaarssen",
"4938788", "Gross\ Warnow",
"492944", "Rietberg\-Mastholte",
"498435", "Ehekirchen",
"4935728", "Uhyst\ Spree",
"4989", "Munich",
"4933457", "Altreetz",
"496027", "Stockstadt\ am\ Main",
"4935439", "Zinnitz",
"492744", "Herdorf",
"498331", "Memmingen",
"496276", "Hesseneck",
"49340", "Dessau\ Anh",
"492644", "Linz\ am\ Rhein",
"4934222", "Arzberg\ bei\ Torgau",
"493921", "Burg\ bei\ Magdeburg",
"499766", "Grosswenkheim",
"492562", "Gronau\ Westfalen",
"497741", "Tiengen\ Hochrhein",
"498237", "Aindling",
"499666", "Illschwang",
"497641", "Emmendingen",
"4936028", "Kammerforst\ Thüringen",
"494529", "Süsel\-Bujendorf",
"498463", "Greding",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"4935797", "Schwepnitz",
"498624", "Obing",
"495541", "Hann\.\ Münden",
"498724", "Massing",
"4934221", "Schildau\ Gneisenaustadt",
"497726", "Bad\ Dürrheim",
"493946", "Quedlinburg",
"497626", "Kandern",
"493334", "Eberswalde",
"496552", "Olzheim",
"496858", "Ottweiler\-Fürth",
"49355", "Cottbus",
"496268", "Hüffenhardt",
"499632", "Waldsassen",
"495326", "Langelsheim",
"492536", "Münster\-Albachten",
"499732", "Hammelburg",
"494202", "Achim\ bei\ Bremen",
"497165", "Göppingen\-Hohenstaufen",
"4933439", "Fredersdorf\-Vogelsdorf",
"499778", "Fladungen",
"496694", "Neukirchen\ Knüll",
"498531", "Pocking",
"4934774", "Röblingen\ am\ See",
"4933432", "Müncheberg",
"499978", "Schönthal\ Oberpfalz",
"495071", "Schwarmstedt",
"495137", "Seelze",
"495659", "Ringgau",
"497243", "Ettlingen",
"499932", "Osterhofen",
"499289", "Schwarzenbach\ am\ Wald",
"499802", "Ansbach\-Katterbach",
"492362", "Dorsten",
"495247", "Harsewinkel",
"497133", "Lauffen\ am\ Neckar",
"4935245", "Burkhardswalde\-Munzig",
"494329", "Langwedel\ Holstein",
"494956", "Uplengen",
"498086", "Buchbach\ Oberbayern",
"496402", "Hungen",
"496104", "Heusenstamm",
"4936076", "Niederorschel",
"496181", "Hanau",
"494468", "Friedeburg\-Reepsholt",
"495341", "Salzgitter",
"4936463", "Gebstedt",
"4936736", "Arnsgereuth",
"495445", "Drebber",
"497084", "Schömberg\ bei\ Neuenbürg",
"493874", "Ludwigslust",
"4937463", "Bergen\ Vogtland",
"4938376", "Zirchow",
"496352", "Kirchheimbolanden",
"497055", "Neuweiler\ Kreis\ Calw",
"494756", "Odisheim",
"4935873", "Herrnhut",
"499148", "Ettenstatt",
"492952", "Rüthen",
"492752", "Bad\ Laasphe",
"4933971", "Kyritz\ Brandenburg",
"498043", "Jachenau",
"499556", "Geiselwind",
"492652", "Mendig",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"4934244", "Mockrehna",
"495428", "Melle\-Neuenkirchen",
"495293", "Paderborn\-Dahl",
"495843", "Wustrow\ Wendland",
"492394", "Neuenrade\-Affeln",
"496130", "Schwabenheim\ an\ der\ Selz",
"498457", "Vohburg\ an\ der\ Donau",
"4938375", "Koserow",
"494872", "Hanerau\-Hademarschen",
"4939957", "Gielow",
"4938227", "Lüdershagen\ bei\ Barth",
"4936735", "Probstzella",
"4935775", "Pechern",
"498373", "Altusried",
"494532", "Bargteheide",
"4933972", "Breddin",
"497391", "Ehingen\ Donau",
"494838", "Tellingstedt",
"492206", "Overath",
"499238", "Röslau",
"494708", "Ringstedt",
"494366", "Grömitz\-Cismar",
"496762", "Kastellaun",
"494608", "Handewitt",
"4935246", "Ziegenhain\ Sachsen",
"4933979", "Wusterhausen\ Dosse",
"496123", "Eltville\ am\ Rhein",
"499272", "Fichtelberg",
"496544", "Rhaunen",
"4936075", "Dingelstädt\ Eichsfeld",
"498284", "Ziemetshausen",
"496074", "Rödermark",
"495065", "Sibbesse",
"4935827", "Nieder\-Seifersdorf",
"4933873", "Grosswudicke",
"499406", "Mintraching",
"4939931", "Röbel\ Müritz",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"499729", "Grettstadt",
"492472", "Monschau",
"499929", "Ruhmannsfelden",
"493683", "Schmalkalden",
"4935971", "Sebnitz",
"492174", "Burscheid\ Rheinland",
"499356", "Burgsinn",
"4933674", "Trebatsch",
"495691", "Bad\ Arolsen",
"498380", "Achberg",
"497171", "Schwäbisch\ Gmünd",
"498193", "Geltendorf",
"493596", "Neustadt\ in\ Sachsen",
"498677", "Burghausen\ Salzach",
"497669", "St\ Märgen",
"492594", "Dülmen",
"496736", "Bechenheim",
"495033", "Wunstorf\-Grossenheidorn",
"498573", "Ering",
"494332", "Hamdorf\ bei\ Rendsburg",
"496636", "Romrod",
"496806", "Heusweiler",
"495155", "Emmerthal",
"498507", "Neuburg\ am\ Inn",
"496344", "Schwegenheim",
"4939932", "Malchow\ bei\ Waren",
"495184", "Freden\ Leine",
"495101", "Pattensen",
"4936703", "Gräfenthal",
"495482", "Tecklenburg",
"498703", "Essenbach",
"496045", "Gedern",
"498678", "Marktl",
"4939601", "Friedland",
"4933848", "Raben",
"492263", "Engelskirchen",
"4936259", "Tabarz\ Thüringer\ Wald",
"494271", "Sulingen",
"4934341", "Geithain",
"498732", "Frontenhausen",
"494453", "Zetel",
"499871", "Windsbach",
"4936252", "Tambach\-Dietharz",
"498802", "Huglfing",
"499531", "Ebern",
"493322", "Falkensee",
"4937601", "Mülsen\ Skt\ Jacob",
"494303", "Schlesen",
"4936601", "Hermsdorf\ Thüringen",
"49228", "Bonn",
"499086", "Fremdingen",
"496253", "Fürth\ Odenwald",
"4937602", "Kirchberg\ Sachsen",
"496471", "Weilburg",
"499097", "Marxheim",
"495850", "Neetze",
"4936602", "Ronneburg\ Thüringen",
"492235", "Erftstadt",
"4934294", "Rackwitz",
"4934342", "Neukieritzsch",
"49331", "Potsdam",
"4939602", "Kleeth",
"493588", "Niesky",
"495364", "Velpke",
"497072", "Gomaringen",
"496375", "Wallhalben",
"4937609", "Wolkenburg\ Mulde",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"498458", "Gaimersheim",
"492661", "Bad\ Marienberg\ Westerwald",
"499435", "Schwarzenfeld",
"497423", "Oberndorf\ am\ Neckar",
"4939085", "Zichtau",
"492761", "Olpe\ Biggesee",
"497542", "Tettnang",
"497664", "Freiburg\-Tiengen",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"494773", "Lamstedt",
"494837", "Neuenkirchen\ Dithmarschen",
"4938725", "Gross\ Godems",
"497764", "Herrischried",
"496195", "Kelkheim\ Taunus",
"494673", "Joldelund",
"492599", "Ascheberg\-Herbern",
"494973", "Wittmund\-Burhafe",
"498766", "Gammelsdorf",
"496349", "Billigheim\-Ingenheim",
"494707", "Langen\-Neuenwalde",
"498666", "Teisendorf",
"4933989", "Sadenbeck",
"494607", "Janneby",
"497964", "Stödtlen",
"494503", "Timmendorfer\ Strand",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"499331", "Ochsenfurt",
"4936085", "Reinholterode",
"493522", "Grossenhain\ Sachsen",
"492961", "Brilon",
"496751", "Bad\ Sobernheim",
"499624", "Ensdorf\ Oberpfalz",
"4938823", "Selmsdorf",
"499724", "Stadtlauringen",
"496651", "Rasdorf",
"499463", "Wald\ Oberpfalz",
"495225", "Spenge",
"499147", "Nennslingen",
"495942", "Uelsen",
"4933764", "Mittenwalde\ Mark",
"495642", "Warburg\-Scherfede",
"49351", "Dresden",
"4933981", "Putlitz",
"495742", "Preussisch\ Oldendorf",
"496835", "Beckingen",
"494186", "Buchholz\-Trelde",
"495427", "Melle\-Buer",
"492853", "Schermbeck",
"496575", "Landscheid",
"495564", "Dassel",
"499924", "Bodenmais",
"492528", "Ennigerloh\-Enniger",
"492822", "Emmerich",
"495372", "Meinersen",
"497229", "Iffezheim",
"4937464", "Schöneck\ Vogtland",
"494488", "Westerstede",
"496161", "Brensbach",
"4936464", "Wormstedt",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"498066", "Bad\ Feilnbach",
"492695", "Insul",
"492382", "Ahlen\ Westfalen",
"499269", "Tettau\ Kreis\ Kronach",
"4935820", "Zodel",
"496051", "Gelnhausen",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"499180", "Pyrbaum",
"499393", "Rothenfels\ Unterfranken",
"49281", "Wesel",
"492151", "Krefeld",
"495042", "Bad\ Münder\ am\ Deister",
"494343", "Laboe",
"4934773", "Schwittersdorf",
"497154", "Kornwestheim",
"497452", "Nagold",
"498292", "Dinkelscherben",
"498548", "Vilshofen\-Sandbach",
"496509", "Büdlich",
"4938220", "Wustrow\ Ostseebad",
"496645", "Ulrichstein",
"499107", "Trautskirchen",
"495832", "Hankensbüttel",
"4935268", "Stauchitz",
"496745", "Gondershausen",
"495902", "Freren",
"4936256", "Wechmar",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"495572", "Bodenfelde",
"495602", "Hessisch\ Lichtenau",
"49441", "Oldenburg",
"496222", "Wiesloch",
"499173", "Thalmässing",
"495702", "Petershagen\-Lahde",
"494947", "Aurich\-Ogenbargen",
"497972", "Gschwend\ bei\ Gaildorf",
"4939606", "Glienke",
"492582", "Everswinkel",
"4934346", "Narsdorf",
"498650", "Marktschellenberg",
"4939485", "Gernrode\ Harz",
"497808", "Hohberg\ bei\ Offenburg",
"497502", "Wolpertswende",
"497938", "Mulfingen\ Jagst",
"494543", "Nusse",
"497738", "Steisslingen",
"494124", "Glückstadt",
"494422", "Sande\ Kreis\ Friesl",
"49621", "Mannheim",
"498348", "Bidingen",
"494747", "Beverstedt",
"4936606", "Kraftsdorf",
"497672", "St\ Blasien",
"495192", "Munster",
"495494", "Holdorf\ Niedersachsen",
"4937606", "Lengenfeld\ Vogtland",
"4933928", "Wildberg\ Brandenburg",
"495665", "Guxhagen",
"496674", "Friedewald\ Hessen",
"494948", "Wiesmoor\-Marcardsmoor",
"492246", "Lohmar\ Rheinland",
"497520", "Bodnegg",
"496774", "Kaub",
"495765", "Raddestorf",
"499264", "Küps",
"497937", "Dörzbach",
"4938454", "Kritzkow",
"4938842", "Lüttenmark",
"497807", "Neuried\ Ortenaukreis",
"494864", "Oldenswort",
"497159", "Renningen",
"496504", "Thalfang",
"496581", "Saarburg",
"498241", "Buchloe",
"494748", "Stubben\ bei\ Bremerhaven",
"498347", "Friesenried",
"4935435", "Gollmitz\ bei\ Calau",
"497533", "Allensbach",
"495965", "Klein\ Berssen",
"499525", "Königsberg\ in\ Bayern",
"497224", "Gernsbach",
"4939858", "Bietikow",
"492327", "Bochum\-Wattenscheid",
"4933394", "Blumberg\ Kreis\ Barnim",
"495633", "Diemelsee",
"495733", "Vlotho",
"496036", "Wölfersheim",
"499560", "Grub\ am\ Forst",
"498131", "Dachau",
"495803", "Rosche",
"495933", "Lathen",
"4938841", "Neuhaus\ Elbe",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"498226", "Bibertal",
"496152", "Gross\-Gerau",
"496454", "Lichtenfels\-Sachsenberg",
"499421", "Straubing",
"494550", "Bühnsdorf",
"496485", "Nentershausen\ Westerwald",
"496304", "Wolfstein\ Pfalz",
"496381", "Kusel",
"4935241", "Lommatzsch",
"4934783", "Gerbstedt",
"495141", "Celle",
"498743", "Geisenhausen",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"492052", "Velbert\-Langenberg",
"497333", "Laichingen",
"499325", "Kleinlangheim",
"496296", "Ahorn\ Baden",
"498547", "Osterhofen\-Gergweis",
"493466", "Artern\ Unstrut",
"4933435", "Rehfelde",
"496287", "Limbach\ Baden",
"494129", "Haseldorf",
"492527", "Lippetal\-Lippborg",
"495337", "Kissenbrück",
"494285", "Rhade\ bei\ Zeven",
"492162", "Viersen",
"492464", "Aldenhoven\ bei\ Jülich",
"4938794", "Cumlosen",
"492723", "Kirchhundem",
"499360", "Thüngen",
"4935242", "Nossen",
"494254", "Eystrup",
"495231", "Detmold",
"499446", "Altmannstein",
"492623", "Ransbach\-Baumbach",
"497461", "Tuttlingen",
"4934672", "Rossleben",
"494487", "Grossenkneten\-Huntlosen",
"496821", "Neunkirchen\ Saar",
"492923", "Lippetal\-Herzfeld",
"496062", "Erbach\ Odenwald",
"497365", "Essingen\ Württemberg",
"499854", "Wittelshofen",
"492630", "Mülheim\-Kärlich",
"494496", "Friesoythe\-Markhausen",
"4933976", "Wutike",
"4935249", "Basslitz",
"495126", "Algermissen",
"4939487", "Friedrichsbrunn",
"499651", "Vohenstrauss",
"496724", "Stromberg\ Hunsrück",
"497570", "Sigmaringen\-Gutenstein",
"495281", "Bad\ Pyrmont",
"496624", "Heringen\ Werra",
"4935894", "Hähnichen",
"495204", "Steinhagen\ Westfalen",
"493843", "Güstrow",
"494235", "Langwedel\-Etelsen",
"496147", "Trebur",
"499605", "Weiherhammer",
"499905", "Bernried\ Niederbayern",
"4933741", "Niedergörsdorf",
"497823", "Seelbach\ Schutter",
"498552", "Grafenau\ Niederbayern",
"499835", "Ehingen\ Mittelfranken",
"4934385", "Mutzschen",
"498858", "Kochel\-Walchensee",
"497448", "Seewald",
"4933366", "Chorin",
"499575", "Weismain",
"492680", "Mündersbach",
"4935693", "Lauschütz",
"499951", "Landau\ an\ der\ Isar",
"492377", "Wickede\ Ruhr",
"494263", "Scheessel",
"496435", "Wallmerod",
"497274", "Germersheim",
"4969", "Frankfurt\ am\ Main",
"498027", "Dietramszell",
"4933742", "Oehna\ Brandenburg",
"4936730", "Sitzendorf",
"492453", "Heinsberg\-Randerath",
"499195", "Adelsdorf\ Mittelfranken",
"495827", "Unterlüss",
"495168", "Walsrode\-Stellichte",
"4938370", "Kröslin",
"492271", "Bergheim\ Erft",
"497383", "Münsingen\-Buttenhausen",
"4933678", "Storkow\ Mark",
"499349", "Werbach\-Wenkheim",
"496237", "Maxdorf",
"496331", "Pirmasens",
"492303", "Unna",
"498276", "Baar\ Schwaben",
"499471", "Burglengenfeld",
"495683", "Wabern\ Hessen",
"4934929", "Straach",
"4936041", "Bad\ Tennstedt",
"499253", "Weissenstadt",
"496086", "Grävenwiesbach",
"498402", "Münchsmünster",
"498104", "Sauerlach",
"493691", "Eisenach\ Thüringen",
"493991", "Waren\ Müritz",
"494179", "Winsen\-Tönnhausen",
"4934922", "Mühlanger",
"494853", "Sankt\ Michaelisdonn",
"499375", "Freudenberg\ Baden",
"494761", "Bremervörde",
"4938294", "Neubukow",
"495300", "Salzgitter\-Üfingen",
"494661", "Niebüll",
"4934921", "Kemberg",
"492673", "Ellenz\-Poltersdorf",
"492773", "Haiger",
"498268", "Tussenhausen",
"492837", "Weeze",
"499549", "Lisberg",
"492607", "Kobern\-Gondorf",
"4934364", "Wermsdorf",
"492973", "Eslohe\ Sauerland",
"497583", "Bad\ Schussenried",
"496871", "Wadern",
"495176", "Edemissen",
"4936042", "Tonna",
"494961", "Papenburg",
"496531", "Bernkastel\-Kues",
"498361", "Nesselwang",
"4933768", "Prieros",
"494394", "Bokhorst",
"492872", "Rhede\ Westfalen",
"499636", "Plössberg",
"495322", "Bad\ Harzburg",
"492532", "Ostbevern",
"498267", "Dirlewang",
"492838", "Sonsbeck",
"499736", "Oberthulba",
"494206", "Stuhr\-Heiligenrode",
"492608", "Welschneudorf",
"492440", "Nettersheim\-Tondorf",
"4935451", "Dahme\ Brandenburg",
"499936", "Wallerfing",
"492366", "Herten\ Westfalen",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"499344", "Gerchsheim",
"498465", "Kipfenberg",
"498082", "Schwindegg",
"496406", "Lollar",
"49531", "Braunschweig",
"499074", "Höchstädt\ an\ der\ Donau",
"4939423", "Wegeleben",
"4935452", "Golssen",
"495882", "Gorleben",
"493364", "Eisenhüttenstadt",
"494952", "Rhauderfehn",
"4935844", "Oybin\ Kurort",
"495209", "Gütersloh\-Friedrichsdorf",
"496629", "Schenklengsfeld",
"496356", "Carlsberg\ Pfalz",
"494752", "Neuhaus\ Oste",
"498433", "Königsmoos",
"4933437", "Reichenberg\ bei\ Strausberg",
"4936423", "Orlamünde",
"4937423", "Adorf\ Vogtland",
"492378", "Fröndenberg\-Langschede",
"4938720", "Grebbin",
"498028", "Fischbachau",
"498561", "Pfarrkirchen\ Niederbayern",
"497053", "Bad\ Teinach\-Zavelstein",
"4935792", "Ossling",
"495522", "Osterode\ am\ Harz",
"492332", "Gevelsberg",
"495828", "Himbergen",
"499962", "Schwarzach\ Niederbayern",
"4937756", "Breitenbrunn\ Erzgebirge",
"4939080", "Kalbe\ Milde",
"4938392", "Sassnitz",
"49791", "Schwäbisch\ Hall",
"495167", "Walsrode\-Westenholz",
"495443", "Lemförde",
"499762", "Saal\ an\ der\ Saale",
"4933451", "Heckelberg",
"49761", "Freiburg\ im\ Breisgau",
"492566", "Legden",
"499662", "Vilseck",
"496238", "Dirmstein",
"49771", "Donaueschingen",
"499544", "Baunach",
"4934298", "Taucha\ bei\ Leipzig",
"4935056", "Altenberg\ Sachsen",
"499123", "Lauf\ an\ der\ Pegnitz",
"4934262", "Falkenhain\ bei\ Wurzen",
"496272", "Hirschhorn\ Neckar",
"497135", "Brackenheim",
"497245", "Durmersheim",
"4934261", "Kühren\ bei\ Wurzen",
"49551", "Göttingen",
"493564", "Schwarze\ Pumpe",
"4933452", "Neulewin",
"4933844", "Brück\ Brandenburg",
"494472", "Lastrup",
"498857", "Benediktbeuern",
"494174", "Stelle\ Kreis\ Harburg",
"497447", "Baiersbronn\-Schwarzenberg",
"497163", "Ebersbach\ an\ der\ Fils",
"4938391", "Altenkirchen\ Rügen",
"496556", "Pronsfeld",
"497722", "Triberg\ im\ Schwarzwald",
"497622", "Schopfheim",
"49209", "Gelsenkirchen",
"497753", "Albbruck",
"494327", "Grossenaspe",
"498728", "Geratskirchen",
"497653", "Lenzkirch",
"4935052", "Kipsdorf\ Kurort",
"4935723", "Bernsdorf\ OL",
"498628", "Kienberg\ Oberbayern",
"4938783", "Dallmin",
"496446", "Hohenahr",
"497557", "Herdwangen\-Schönach",
"4935383", "Elster\ Elbe",
"4939752", "Blumenhagen\ bei\ Strasburg",
"494221", "Delmenhorst",
"4938323", "Prohn",
"493866", "Cambs",
"4936023", "Horsmar",
"496854", "Oberthal\ Saar",
"493338", "Bernau\ Brandenburg",
"4937752", "Eibenstock",
"497953", "Blaufelden",
"4935796", "Panschwitz\-Kuckau",
"493372", "Jüterbog",
"494136", "Scharnebeck",
"495957", "Lindern\ Oldenburg",
"496421", "Marburg",
"499152", "Hartenstein\ Mittelfranken",
"492948", "Lippstadt\-Rebbeke",
"494246", "Twistringen\-Heiligenloh",
"499454", "Aufhausen\ Oberpfalz",
"4935825", "Kodersdorf",
"4935264", "Strehla",
"495553", "Kalefeld",
"492864", "Reken",
"4933456", "Wriezen",
"499381", "Volkach",
"4939751", "Penkun",
"499287", "Selb",
"495139", "Burgwedel",
"499846", "Ipsheim",
"496325", "Lambrecht\ Pfalz",
"497022", "Nürtingen",
"495657", "Meissner",
"494162", "Jork",
"497251", "Bruchsal",
"4933052", "Leegebruch",
"494464", "Wittmund\-Carolinensiel",
"497473", "Mössingen",
"496108", "Mühlheim\ am\ Main",
"494527", "Bosau",
"4938377", "Zinnowitz",
"492254", "Weilerswist",
"4939955", "Jürgenstorf",
"494623", "Böklund",
"494723", "Cuxhaven\-Altenwalde",
"4936737", "Drognitz",
"4938225", "Trinwillershagen",
"497357", "Attenweiler",
"49214", "Leverkusen",
"494630", "Barderup",
"493902", "Diesdorf\ Altm",
"4936077", "Grossbodungen",
"494923", "Krummhörn\-Pewsum",
"498395", "Tannheim\ Württemberg",
"496698", "Schrecksbach",
"498682", "Laufen\ Salzach",
"499774", "Oberelsbach",
"499674", "Schönsee",
"498782", "Pfeffenhausen",
"495403", "Bad\ Iburg",
"493494", "Wolfen",
"495275", "Höxter\-Ottbergen",
"496264", "Neudenau",
"496029", "Mömbris",
"499504", "Stadelhofen",
"4935456", "Terpt",
"495353", "Königslutter\ am\ Elm",
"4933051", "Nassenheide",
"499974", "Traitsching",
"4937468", "Treuen\ Vogtland",
"492129", "Haan\ Rheinland",
"496525", "Irrel",
"498239", "Langenneufnach",
"4934926", "Pretzsch\ Elbe",
"4935362", "Schönewalde\ bei\ Herzberg",
"496697", "Willingshausen",
"496786", "Kempfeld",
"495083", "Hohne\ bei\ Celle",
"494382", "Wangels",
"493965", "Burow\ bei\ Altentreptow",
"49481", "Heide\ Holstein",
"496593", "Hillesheim\ Eifel",
"493765", "Reichenbach\ Vogtland",
"49921", "Bayreuth",
"494151", "Schwarzenbek",
"497262", "Eppingen",
"495432", "Löningen",
"494105", "Seevetal",
"4938727", "Mestlin",
"498094", "Steinhöring",
"499745", "Wildflecken",
"493933", "Genthin",
"497940", "Künzelsau",
"494528", "Schönwalde\ am\ Bungsberg",
"494822", "Kellinghusen",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"496107", "Kelsterbach",
"4939087", "Jerchel\ Altmark",
"4935327", "Priessen",
"495244", "Rietberg",
"497358", "Eberhardzell\-Füramoos",
"498323", "Immenstadt\ im\ Allgäu",
"493537", "Jessen\ Elster",
"498330", "Legau",
"4936087", "Wüstheuterode",
"493877", "Wittenberge",
"499945", "Arnbruck",
"493733", "Annaberg\-Buchholz",
"4935361", "Schlieben",
"494795", "Garlstedt",
"499222", "Presseck",
"496173", "Kronberg\ im\ Taunus",
"4933398", "Werneuchen",
"4933362", "Liepe\ Kreis\ Barnim",
"492947", "Anröchte",
"496024", "Schöllkrippen",
"496269", "Gundelsheim\ Württemberg",
"499779", "Nordheim\ von\ der\ Rhön",
"495466", "Merzen",
"496393", "Fischbach\ bei\ Dahn",
"497236", "Keltern",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"4936653", "Lehesten\ Thüringer\ Wald",
"4939854", "Kleptow",
"492422", "Kreuzau",
"492543", "Billerbeck\ Westfalen",
"498234", "Bobingen",
"497121", "Reutlingen",
"499288", "Bad\ Steben",
"492647", "Kesseling",
"4933369", "Oderberg",
"495658", "Wehretal",
"492747", "Molzhain",
"494328", "Rickling",
"498727", "Falkenberg\ Niederbayern",
"4936333", "Heringen\ Helme",
"4938458", "Zehna",
"4939203", "Barleben",
"497558", "Illmensee",
"494469", "Wangerooge",
"497852", "Willstätt",
"4933924", "Rägelin",
"498442", "Wolnzach",
"498144", "Grafrath",
"499161", "Neustadt\ an\ der\ Aisch",
"497146", "Remseck\ am\ Neckar",
"4934978", "Radegast\ Kreis\ Köthen",
"4933746", "Werbig\ bei\ Jüterbog",
"493337", "Biesenthal\ Brandenburg",
"4936203", "Vieselbach",
"4937203", "Gersdorf\ bei\ Chemnitz",
"4933361", "Joachimsthal",
"49241", "Aachen",
"4936965", "Stadtlengsfeld",
"4936875", "Straufhain\-Streufdorf",
"498281", "Thannhausen\ Schwaben",
"498204", "Mickhausen",
"499153", "Schnaittach",
"496541", "Traben\-Trarbach",
"4934464", "Freyburg\ Unstrut",
"498387", "Weiler\-Simmerberg",
"4933604", "Lebus",
"495552", "Katlenburg",
"497394", "Schelklingen",
"495858", "Hitzacker\-Wietzetze",
"492297", "Wildbergerhütte",
"492391", "Plettenberg",
"497023", "Weilheim\ an\ der\ Teck",
"4938854", "Redefin",
"493307", "Zehdenick",
"495027", "Linsburg",
"497652", "Hinterzarten",
"4936458", "Bad\ Berka",
"498168", "Attenkirchen",
"496526", "Bollendorf",
"4939033", "Wallstawe",
"4938333", "Horst\ bei\ Grimmen",
"496479", "Waldbrunn\ Westerwald",
"4939773", "Altwarp",
"4939458", "Heudeber",
"498670", "Reischach\ Kreis\ Altötting",
"4938203", "Bad\ Doberan",
"497952", "Gerabronn",
"495276", "Marienmünster",
"498683", "Tittmoning",
"49471", "Bremerhaven",
"496341", "Landau\ in\ der\ Pfalz",
"49461", "Flensburg",
"4936762", "Steinach\ Thüringen",
"498783", "Rohr\ in\ Niederbayern",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"495181", "Alfeld\ Leine",
"494135", "Kirchgellersen",
"4935604", "Krieschow",
"499339", "Ippesheim",
"496897", "Sulzbach\ Saar",
"496247", "Worms\-Pfeddersheim",
"4933835", "Golzow\ bei\ Brandenburg",
"495352", "Schöningen",
"493865", "Holthusen",
"49491", "Leer\ Ostfriesland",
"496445", "Schöffengrund",
"492591", "Lüdinghausen",
"4933733", "Stülpe",
"494163", "Horneburg\ Niederelbe",
"494447", "Vechta\-Langförden",
"495694", "Diemelstadt",
"497174", "Mögglingen",
"4934606", "Teicha\ Sachsen\-Anhalt",
"497472", "Rottenburg\ am\ Neckar",
"499845", "Oberdachstetten",
"499295", "Töpen",
"496326", "Deidesheim",
"4939346", "Tucheim",
"494622", "Taarstedt",
"492171", "Leverkusen\-Opladen",
"494722", "Cuxhaven\-Altenbruch",
"493603", "Bad\ Langensalza",
"494245", "Neuenkirchen\ bei\ Bassum",
"4937346", "Geyer",
"4939727", "Spantekow",
"4939005", "Kusey",
"494922", "Borkum",
"496659", "Eichenzell",
"4938305", "Gingst",
"493677", "Ilmenau\ Thüringen",
"498450", "Ingolstadt\-Zuchering",
"4935027", "Weesenstein",
"498176", "Egling\ bei\ Wolfratshausen",
"493573", "Senftenberg",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"496071", "Dieburg",
"4939387", "Havelberg",
"4936761", "Heubisch",
"4933631", "Bad\ Saarow\-Pieskow",
"4938737", "Ganzlin",
"495361", "Wolfsburg",
"4936377", "Rastenberg",
"494823", "Wilster",
"498322", "Oberstdorf",
"4935934", "Grossdubrau",
"4935207", "Moritzburg",
"496138", "Mommenheim",
"499498", "Laaber",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"497235", "Unterreichenbach\ Kreis\ Calw",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"4939225", "Altengrabow",
"493632", "Sondershausen",
"494830", "Süderhastedt",
"499223", "Rugendorf",
"495465", "Neuenkirchen\ bei\ Bramsche",
"496474", "Villmar\-Aumenau",
"495082", "Langlingen",
"49831", "Kempten\ Allgäu",
"499534", "Burgpreppach",
"497145", "Markgröningen",
"494383", "Grebin",
"499874", "Neuendettelsau",
"496898", "Völklingen",
"496592", "Daun",
"494274", "Varrel\ bei\ Sulingen",
"495433", "Badbergen",
"497263", "Waibstadt",
"4936640", "Remptendorf",
"4933632", "Hangelsberg",
"4939396", "Neukirchen\ Altmark",
"4938759", "Tewswoos",
"499921", "Regen",
"495028", "Pennigsehl",
"4937323", "Lichtenberg\ Erzgebirge",
"495561", "Einbeck",
"4936783", "Gehren\ Thüringen",
"497853", "Kehl\-Bodersweier",
"494106", "Quickborn\ Kreis\ Pinneberg",
"4933337", "Altkünkendorf",
"498167", "Zolling",
"498443", "Hohenwart\ Paar",
"496785", "Herrstein",
"4933207", "Gross\ Kreutz",
"499621", "Amberg\ Oberpfalz",
"496754", "Martinstein",
"4939323", "Schönhausen\ Elbe",
"4938752", "Zierzow\ bei\ Ludwigslust",
"499721", "Schweinfurt",
"496654", "Gersfeld\ Rhön",
"493966", "Cölpin",
"4938751", "Picher",
"492964", "Brilon\-Alme",
"4933657", "Steinsdorf\ Brandenburg",
"499334", "Giebelstadt",
"49851", "Passau",
"498388", "Hergensweiler",
"496392", "Hauenstein\ Pfalz",
"494796", "Teufelsmoor",
"497961", "Ellwangen\ Jagst",
"495109", "Ronnenberg",
"499946", "Hohenwarth\ bei\ Kötzing",
"492423", "Langerwehe",
"499646", "Freihung",
"495857", "Bleckede\-Brackede",
"499090", "Rain\ Lech",
"497661", "Kirchzarten",
"499746", "Zeitlofs",
"4939748", "Viereck",
"497761", "Bad\ Säckingen",
"492542", "Gescher",
"4939885", "Jakobshagen",
"492664", "Rennerod",
"498057", "Aschau\-Sachrang",
"492764", "Welschen\ Ennest",
"4937368", "Deutschneudorf",
"4938756", "Grabow",
"4939399", "Kleinau",
"497151", "Waiblingen",
"494262", "Visselhövede",
"496589", "Kell\ am\ See",
"498249", "Ettringen\ Wertach",
"492452", "Heinsberg\ Rheinland",
"499376", "Collenberg",
"492154", "Willich",
"496085", "Waldsolms",
"497382", "Römerstein",
"499568", "Neustadt\ bei\ Coburg",
"492302", "Witten",
"4939244", "Steutz",
"49781", "Offenburg",
"4935020", "Struppen",
"496054", "Birstein",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"4939391", "Lückstedt",
"494408", "Hude\ Oldenburg",
"496462", "Gladenbach",
"496164", "Reichelsheim\ Odenwald",
"494740", "Loxstedt\-Dedesdorf",
"495175", "Lehrte\-Arpke",
"498553", "Spiegelau",
"497528", "Neukirch\ bei\ Tettnang",
"497822", "Ettenheim",
"492064", "Dinslaken",
"494358", "Loose\ bei\ Eckernförde",
"498139", "Röhrmoos",
"498657", "Ramsau\ bei\ Berchtesgaden",
"492638", "Waldbreitbach",
"495149", "Wienhausen",
"499836", "Gunzenhausen\-Cronheim",
"495491", "Damme\ Dümmer",
"499906", "Mariaposching",
"492738", "Netphen",
"492672", "Treis\-Karden",
"492772", "Herborn\ Hessen",
"494121", "Elmshorn",
"499576", "Lichtenfels\-Isling",
"499429", "Rain\ Niederbayern",
"492972", "Schmallenberg",
"497582", "Bad\ Buchau",
"499606", "Pfreimd",
"4936628", "Zeulenroda",
"494236", "Kirchlinteln",
"492938", "Ense",
"492502", "Nottuln",
"495682", "Borken\ Hessen",
"494146", "Stade\-Bützfleth",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"498403", "Pförring",
"499252", "Helmbrechts",
"496436", "Dornburg\ Hessen",
"497328", "Königsbronn",
"4938423", "Bad\ Kleinen",
"499187", "Altdorf\ bei\ Nürnberg",
"499196", "Wiesenttal",
"494558", "Todesfelde",
"494852", "Brunsbüttel",
"498083", "Isen",
"4934601", "Teutschenthal",
"492565", "Gronau\-Epe",
"497136", "Bad\ Friedrichshall",
"494953", "Bunde",
"495883", "Lemgow",
"4939341", "Redekin",
"492224", "Bad\ Honnef",
"4935473", "Neu\ Lübbenau",
"497327", "Dischingen",
"4937341", "Ehrenfriedersdorf",
"498134", "Odelzhausen",
"498432", "Burgheim",
"494753", "Balje",
"4936766", "Schalkau",
"499188", "Postbauer\-Heng",
"497221", "Baden\-Baden",
"494557", "Blunk",
"4937433", "Gutenfürst",
"4939058", "Uthmöden",
"492159", "Meerbusch\-Osterath",
"496555", "Bleialf",
"492637", "Weissenthurm",
"494480", "Ovelgönne\-Strückhausen",
"492737", "Netphen\-Deuz",
"4934609", "Salzmünde",
"492873", "Isselburg\-Werth",
"4939349", "Parey\ Elbe",
"4937294", "Grünhainichen",
"494861", "Tönning",
"4937342", "Cranzahl",
"492533", "Münster\-Nienberge",
"496584", "Wellen\ Mosel",
"495323", "Clausthal\-Zellerfeld",
"496501", "Konz",
"497246", "Malsch\ Kreis\ Karlsruhe",
"4939294", "Gross\ Rosenburg",
"4933200", "Bergholz\-Rehbrücke",
"499261", "Kronach",
"4937349", "Scheibenberg",
"4939342", "Gladau",
"492520", "Wadersloh\-Diestedde",
"496059", "Jossgrund",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"499367", "Unterpleichfeld",
"496771", "St\ Goarshausen",
"492937", "Arnsberg\-Oeventrop",
"492365", "Marl",
"499805", "Burgoberbach",
"499935", "Stephansposching",
"493643", "Weimar\ Thüringen",
"498466", "Denkendorf\ Oberbayern",
"496824", "Ottweiler",
"4934904", "Oranienbaum",
"494407", "Wardenburg",
"498340", "Baisweil",
"499851", "Dinkelsbühl",
"497527", "Wolfegg",
"4933473", "Zechin",
"49911", "Nuremberg",
"494473", "Emstek",
"497464", "Talheim\ Kreis\ Tuttlingen",
"495234", "Horn\-Bad\ Meinberg",
"497162", "Süssen",
"494251", "Hoya",
"494357", "Sehestedt\ Eider",
"497930", "Boxberg\ Baden",
"499735", "Massbach",
"493943", "Wernigerode",
"494205", "Ottersberg",
"497723", "Furtwangen\ im\ Schwarzwald",
"499635", "Bärnau",
"492461", "Jülich",
"4936647", "Saalburg\ Thüringen",
"4939405", "Hötensleben",
"497623", "Rheinfelden\ Baden",
"4936370", "Grossenehrich",
"496207", "Wald\-Michelbach",
"496355", "Albisheim\ Pfrimm",
"497052", "Bad\ Liebenzell",
"499963", "Konzell",
"496384", "Konken",
"492333", "Ennepetal",
"495523", "Bad\ Sachsa",
"496301", "Otterbach\ Pfalz",
"495442", "Barnstorf\ Kreis\ Diepholz",
"495144", "Wathlingen",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"4935200", "Arnsdorf\ bei\ Dresden",
"496405", "Laubach\ Hessen",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"499567", "Sesslach\-Gemünda",
"496451", "Frankenberg\ Eder",
"499424", "Strasskirchen",
"499122", "Schwabach",
"4939266", "Förderstedt",
"496334", "Thaleischweiler\-Fröschen",
"492383", "Bönen",
"497303", "Illertissen",
"4936870", "Masserberg",
"499392", "Faulbach\ Unterfranken",
"496746", "Pfalzfeld",
"495043", "Lauenau",
"498369", "Rückholz",
"492274", "Elsdorf\ Rheinland",
"496646", "Grebenau",
"494342", "Preetz\ Kreis\ Plön",
"497453", "Altensteig\ Württemberg",
"498293", "Welden\ bei\ Augsburg",
"4936695", "Söllmnitz",
"497271", "Wörth\ am\ Rhein",
"495457", "Hopsten\-Schale",
"4935608", "Gross\ Ossnig",
"492823", "Goch",
"492448", "Hellenthal\-Rescheid",
"499954", "Simbach\ Niederbayern",
"495373", "Hillerse\ Kreis\ Gifhorn",
"4936943", "Bettenhausen\ Thüringen",
"495255", "Altenbeken",
"495307", "Braunschweig\-Wenden",
"496721", "Bingen\ am\ Rhein",
"499654", "Pleystein",
"495201", "Halle\ Westfalen",
"496621", "Bad\ Hersfeld",
"495284", "Schwalenberg",
"4933830", "Ziesar",
"498065", "Tuntenhausen\-Schönau",
"4936842", "Oberhof\ Thüringen",
"494964", "Rhede\ Ems",
"4936454", "Magdala",
"497707", "Bräunlingen",
"497973", "Obersontheim",
"492583", "Sassenberg",
"496534", "Mülheim\ Mosel",
"492687", "Horhausen\ Westerwald",
"4934955", "Gossa",
"495865", "Gusborn",
"496874", "Wadern\-Nunkirchen",
"492696", "Nohn\ Eifel",
"497503", "Wilhelmsdorf\ Württemberg",
"494298", "Lilienthal",
"494542", "Mölln\ Lauenburg",
"494848", "Rantrum",
"494423", "Fedderwarden",
"497577", "Veringenstadt",
"497673", "Schönau\ im\ Schwarzwald",
"494764", "Gnarrenburg\-Klenkendorf",
"4934491", "Schmölln\ Thüringen",
"497773", "Bodman\-Ludwigshafen",
"4939454", "Elbingerode\ Harz",
"497837", "Oberharmersbach",
"494664", "Neukirchen\ bei\ Niebüll",
"4936849", "Kleinschmalkalden",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"495193", "Schneverdingen",
"495677", "Calden\-Westuffeln",
"495903", "Emsbüren",
"4934492", "Lucka",
"4933608", "Jacobsdorf\ Mark",
"495777", "Diepenau\-Essern",
"495833", "Brome",
"493994", "Malchin",
"498033", "Oberaudorf",
"495573", "Uslar\-Volpriehausen",
"498020", "Weyarn",
"4938858", "Lassahn",
"495507", "Ebergötzen",
"499172", "Georgensgmünd",
"4936841", "Schleusingen",
"4938300", "Insel\ Hiddensee",
"495603", "Gudensberg",
"4933094", "Löwenberg",
"499474", "Schmidmühlen",
"496223", "Neckargemünd",
"4939000", "Beetzendorf",
"495977", "Spelle",
"495820", "Suhlendorf",
"495703", "Hille",
"4936744", "Remda",
"4939926", "Grabowhöfe",
"495632", "Willingen\ Upland",
"496295", "Rosenberg\ Baden",
"499326", "Markt\ Einersheim",
"495732", "Löhne",
"499659", "Leuchtenberg",
"495932", "Haren\ Ems",
"495802", "Wrestedt",
"493361", "Fürstenwalde\ Spree",
"495508", "Gleichen\-Rittmarshausen",
"496486", "Katzenelnbogen",
"4939744", "Rothenklempenow",
"4936926", "Creuzburg",
"495978", "Hörstel\-Dreierwalde",
"499071", "Dillingen\ an\ der\ Donau",
"4939993", "Hohenmocker",
"493433", "Borna\ Stadt",
"497440", "Bad\ Rippoldsau",
"494495", "Friesoythe\-Thüle",
"497366", "Abtsgmünd",
"499341", "Tauberbischofsheim",
"497708", "Geisingen\-Leipferdingen",
"496339", "Grosssteinhausen",
"492688", "Kroppach",
"494297", "Ottersberg\-Posthausen",
"494847", "Oster\-Ohrstedt",
"497578", "Wald\ Hohenz",
"494286", "Gyhum",
"4936645", "Mühltroff",
"4939407", "Seehausen\ Börde",
"498364", "Seeg",
"499445", "Neustadt\ an\ der\ Donau",
"4938485", "Dabel",
"497532", "Meersburg",
"497838", "Nordrach",
"495458", "Hopsten",
"492163", "Schwalmtal\ Niederrhein",
"492447", "Dahlem\ bei\ Kall",
"494171", "Winsen\ Luhe",
"499526", "Riedbach",
"492722", "Attendorn",
"495966", "Meppen\-Apeldorn",
"492622", "Bendorf\ am\ Rhein",
"492922", "Werl",
"496063", "Bad\ König",
"495766", "Rehburg\-Loccum",
"493561", "Guben",
"495308", "Lehre",
"492245", "Much",
"4934653", "Rottleberode",
"4938464", "Bernitt",
"49261", "Koblenz\ am\ Rhein",
"497566", "Argenbühl",
"49271", "Siegen",
"4934203", "Zwenkau",
"4935938", "Grosspostwitz\ OL",
"498225", "Jettingen\-Scheppach",
"494769", "Bremervörde\-Iselersheim",
"498642", "Übersee",
"498742", "Velden\ Vils",
"492053", "Velbert\-Neviges",
"4939978", "Gross\ Roge",
"4934441", "Hohenmölsen",
"498427", "Wellheim",
"497332", "Lauterstein",
"496035", "Reichelsheim\ Wetterau",
"498564", "Johanniskirchen",
"49291", "Meschede",
"499207", "Königsfeld\ Oberfranken",
"498338", "Böhen",
"494737", "Stadland\-Schwei",
"494873", "Aukrug",
"499355", "Frammersbach",
"494159", "Basthorst",
"494637", "Sterup",
"498372", "Obergünzburg",
"494533", "Reinfeld\ Holstein",
"493928", "Schönebeck\ Elbe",
"497748", "Grafenhausen\ Hochschwarzwald",
"499384", "Schwanfeld",
"492861", "Borken\ Westfalen",
"499405", "Bad\ Abbach",
"4934446", "Grosskorbetha",
"493628", "Arnstadt",
"496663", "Steinau\ an\ der\ Strasse",
"4935025", "Liebstadt",
"497948", "Öhringen\-Ohrnberg",
"496763", "Kirchberg\ Hunsrück",
"495066", "Sarstedt",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"496424", "Ebsdorfergrund",
"496122", "Hofheim\-Wallau",
"499451", "Schierling",
"496567", "Oberkail",
"4938307", "Poseritz",
"4939007", "Tangeln",
"49201", "Essen",
"4933837", "Brielow",
"496805", "Kleinblittersdorf",
"495156", "Coppenbrügge",
"492953", "Wünnenberg",
"496851", "St\ Wendel",
"499824", "Dietenhofen",
"4936624", "Teichwolframsdorf",
"492753", "Erndtebrück",
"498042", "Lenggries",
"4939823", "Rechlin",
"49611", "Wiesbaden",
"494224", "Gross\ Ippener",
"492653", "Kaisersesch",
"492557", "Wettringen\ Kreis\ Steinfurt",
"496635", "Kirtorf",
"496735", "Eppelsheim",
"495292", "Lichtenau\-Atteln",
"495842", "Schnega",
"4939929", "Jabel\ bei\ Waren",
"4936922", "Gerstungen",
"499971", "Cham",
"498538", "Pocking\-Hartkirchen",
"499555", "Schlüsselfeld\-Aschbach",
"497129", "Lichtenstein\ Württemberg",
"495032", "Neustadt\ am\ Rübenberge",
"493395", "Pritzwalk",
"498572", "Tann\ Niederbayern",
"494333", "Erfde",
"493491", "Lutherstadt\ Wittenberg",
"4935953", "Burkau",
"494320", "Heidmühlen",
"496261", "Mosbach\ Baden",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"499671", "Oberviechtach",
"498702", "Wörth\ an\ der\ Isar",
"495483", "Lienen",
"4936929", "Ruhla",
"4939922", "Dambeck\ bei\ Röbel",
"4934638", "Zöschen",
"494365", "Heringsdorf\ Holstein",
"4939921", "Ankershagen",
"4936967", "Geisa",
"495650", "Cornberg",
"4937364", "Reitzenhain\ Erzgebirge",
"492407", "Herzogenrath\-Kohlscheid",
"499280", "Selbitz\ Oberfranken",
"4939248", "Dobritz",
"4939364", "Dolle",
"492251", "Euskirchen",
"492473", "Simmerath",
"493682", "Zella\-Mehlis",
"494461", "Jever",
"4936921", "Wutha\-Farnroda",
"497254", "Waghäusel",
"492357", "Herscheid\ Westfalen",
"498192", "Schondorf\ am\ Ammersee",
"492205", "Rösrath",
"496188", "Kahl\ am\ Main",
"498665", "Inzell",
"496252", "Heppenheim\ Bergstrasse",
"499829", "Flachslanden",
"498765", "Bruckberg\ Niederbayern",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"492408", "Aachen\-Kornelimünster",
"4939887", "Gerswalde",
"499436", "Nittenau",
"495241", "Gütersloh",
"496196", "Bad\ Soden\ am\ Taunus",
"495347", "Burgdorf\ bei\ Salzgitter",
"498091", "Kirchseeon",
"497073", "Ammerbuch",
"493883", "Hagenow",
"4936846", "Suhl\-Dietzhausen",
"496187", "Schöneck",
"492358", "Meinerzhagen\-Valbert",
"496836", "Überherrn",
"494185", "Marxen\ Auetal",
"497343", "Buch\ bei\ Illertissen",
"4934423", "Heuckewalde",
"4933335", "Pinnow\ Kreis\ Uckermark",
"498537", "Bad\ Füssing\-Aigen",
"492262", "Wiehl",
"498633", "Tüssling",
"498733", "Mengkofen",
"494452", "Zetel\-Neuenburg",
"495131", "Garbsen",
"494154", "Trittau",
"496429", "Schweinsberg\ Hessen",
"498803", "Peissenberg",
"496706", "Wallhausen\ Nahe",
"4934496", "Nöbdenitz",
"495226", "Bruchmühlen\ Westfalen",
"4933205", "Michendorf",
"494302", "Kirchbarkau",
"4937298", "Oelsnitz\ Erzgebirge",
"499462", "Falkenstein\ Oberpfalz",
"499164", "Langenfeld\ Mittelfranken",
"495943", "Emlichheim",
"49741", "Rottweil",
"497259", "Östringen\-Odenheim",
"4939400", "Wefensleben",
"495643", "Borgentreich",
"498141", "Fürstenfeldbruck",
"496046", "Ortenberg\ Hessen",
"495743", "Espelkamp\-Gestringen",
"492558", "Horstmar",
"4939298", "Barby\ Elbe",
"492852", "Hamminkeln",
"4939262", "Güsten\ Anh",
"497422", "Schramberg",
"498337", "Altenstadt\ Iller",
"499208", "Bindlach",
"497124", "Trochtelfingen\ Hohenz",
"497543", "Kressbronn\ am\ Bodensee",
"4933233", "Ketzin",
"494638", "Tarp",
"494772", "Oberndorf\ Oste",
"4938735", "Plau\ am\ See",
"497747", "Berau",
"498231", "Königsbrunn\ bei\ Augsburg",
"4936375", "Kindelbrück",
"494672", "Langenhorn",
"494972", "Langeoog",
"4939054", "Flechtingen",
"493727", "Mittweida",
"497947", "Forchtenberg",
"4938354", "Wusterhusen",
"499085", "Alerheim",
"494938", "Hagermarsch",
"492236", "Wesseling\ Rheinland",
"4935205", "Ottendorf\-Okrilla",
"494502", "Lübeck\-Travemünde",
"496021", "Aschaffenburg",
"4935754", "Klettwitz",
"496568", "Wolsfeld",
"493523", "Coswig\ bei\ Dresden",
"492676", "Ulmen",
"496244", "Westhofen\ Rheinhessenen",
"496894", "St\ Ingbert",
"4934204", "Schkeuditz",
"498584", "Breitenberg\ Niederbayern",
"498501", "Thyrnau",
"492776", "Bad\ Endbach\-Hartenrod",
"499572", "Burgkunstadt",
"499832", "Wassertrüdingen",
"498555", "Perlesreut",
"498771", "Ergoldsbach",
"499602", "Neustadt\ an\ der\ Waldnaab",
"495173", "Uetze",
"4936692", "Bürgel",
"4933088", "Falkenthal",
"498671", "Altötting",
"494232", "Langwedel\ Kreis\ Verden",
"492506", "Münster\-Wolbeck",
"495859", "Thomasburg",
"497586", "Herbertingen",
"495593", "Bovenden\-Lenglern",
"497031", "Böblingen",
"495686", "Schwarzenborn\ Knüll",
"494142", "Steinkirchen\ Kreis\ Stade",
"493581", "Görlitz",
"4936691", "Eisenberg\ Thüringen",
"493504", "Dippoldiswalde",
"4935206", "Kreischa\ bei\ Dresden",
"499256", "Stammbach",
"496083", "Weilrod",
"494444", "Goldenstedt",
"496478", "Greifenstein\-Ulm",
"4934654", "Stolberg\ Harz",
"499192", "Gräfenberg",
"494856", "Kronprinzenkoog",
"4936376", "Straussfurt",
"496134", "Mainz\-Kastel",
"492183", "Rommerskirchen",
"496432", "Diez",
"4938736", "Goldberg",
"493774", "Schwarzenberg",
"492456", "Selfkant",
"499372", "Klingenberg\ am\ Main",
"498384", "Röthenbach\ Allgäu",
"498207", "Affing",
"499338", "Röttingen\ Unterfranken",
"493821", "Ribnitz\-Damgarten",
"4937328", "Grossschirma",
"4936845", "Gehlberg",
"494266", "Brockel",
"497841", "Achern",
"498273", "Nordendorf",
"492306", "Lünen",
"4939328", "Rochau",
"492844", "Rheinberg\-Orsoy",
"4933656", "Bahro",
"492294", "Morsbach\ Sieg",
"497386", "Hayingen",
"498405", "Stammham\ bei\ Ingolstadt",
"496340", "Wörth\-Schaidt",
"496466", "Dautphetal\-Friedensdorf",
"498824", "Oberau\ Loisach",
"4936743", "Teichel",
"493381", "Brandenburg\ an\ der\ Havel",
"493304", "Velten",
"4933206", "Fichtenwalde",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"4934495", "Dobitschen",
"496658", "Poppenhausen\ Wasserkuppe",
"4933336", "Passow\ Kreis\ Uckermark",
"496758", "Waldböckelheim",
"4939743", "Zerrenthin",
"497826", "Schuttertal",
"4939994", "Metschow",
"492590", "Dülmen\-Buldern",
"4939397", "Geestgottberg",
"498462", "Berching",
"494191", "Kaltenkirchen\ Holstein",
"4938481", "Witzin",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"493679", "Neuhaus\ am\ Rennweg",
"496139", "Budenheim",
"495325", "Goslar\-Hahnenklee",
"496657", "Hofbieber",
"492535", "Sendenhorst\-Albersloh",
"496757", "Becherbach\ bei\ Kirn",
"499141", "Weissenburg\ in\ Bayern",
"496553", "Schönecken",
"499499", "Painten",
"497166", "Adelberg",
"4933093", "Fürstenberg\ Havel",
"4936649", "Gefell\ bei\ Schleiz",
"494684", "Langeness\ Hallig",
"4939038", "Henningen",
"499231", "Marktredwitz",
"495446", "Rehden",
"4936453", "Mellingen",
"499337", "Gaukönigshofen",
"498208", "Eurasburg\ bei\ Augsburg",
"494755", "Ihlienworth",
"496249", "Guntersblum",
"497056", "Gechingen",
"498054", "Breitbrunn\ am\ Chiemsee",
"494955", "Westoverledingen",
"4938482", "Warin",
"492667", "Stein\-Neukirch",
"499126", "Eckental",
"492563", "Stadtlohn",
"4939453", "Derenburg",
"4938208", "Kavelstorf",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"495854", "Bleckede\-Barskamp",
"498085", "Sankt\ Wolfgang",
"4936642", "Harra",
"496275", "Rothenberg\ Odenwald",
"497132", "Neckarsulm",
"495264", "Kalletal",
"497434", "Winterlingen",
"4939386", "Seehausen\ Altmark",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"4934445", "Stössen",
"492431", "Erkelenz",
"499665", "Königstein\ Oberpfalz",
"496403", "Linden\ Hessen",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"499765", "Trappstadt",
"4939726", "Ducherow",
"4936944", "Rentwertshausen",
"497660", "St\ Peter\ Schwarzwald",
"499091", "Monheim\ Schwaben",
"496477", "Greifenstein\-Nenderoth",
"4939347", "Kade",
"499965", "Sankt\ Englmar",
"492335", "Wetter\ Ruhr",
"495525", "Walkenried",
"496353", "Freinsheim",
"4934607", "Wettin",
"4938750", "Malliss",
"499633", "Mitterteich",
"497625", "Zell\ im\ Wiesental",
"499733", "Münnerstadt",
"494203", "Weyhe\ bei\ Bremen",
"499920", "Bischofsmais",
"497725", "Königsfeld\ im\ Schwarzwald",
"495108", "Gehrden\ Han",
"498389", "Weissensberg",
"494475", "Molbergen",
"494371", "Burg\ auf\ Fehmarn",
"497242", "Rheinstetten",
"492363", "Datteln",
"499803", "Colmberg",
"494277", "Schwaförden",
"499720", "Üchtelhausen",
"493745", "Falkenstein\ Vogtland",
"499933", "Wallersdorf",
"493375", "Königs\ Wusterhausen",
"496588", "Pluwig",
"496209", "Mörlenbach",
"4933234", "Wustermark",
"4937382", "Geringswalde",
"498592", "Wegscheid\ Niederbayern",
"498248", "Lamerdingen",
"4939389", "Schollene",
"494641", "Süderbrarup",
"494741", "Nordholz\ bei\ Bremerhaven",
"495406", "Belm",
"49631", "Kaiserslautern",
"4939053", "Süplingen",
"4937438", "Bad\ Brambach",
"4938353", "Gützkow\ bei\ Greifswald",
"4939722", "Sarnow\ bei\ Anklam",
"494941", "Aurich",
"4939382", "Kamern",
"4935753", "Grossräschen",
"4935022", "Bad\ Schandau",
"4935478", "Goyatz",
"4939390", "Iden",
"493471", "Bernburg\ Saale",
"499569", "Sesslach",
"495356", "Helmstedt\-Barmke",
"496322", "Bad\ Dürkheim",
"497025", "Neuffen",
"497150", "Korntal\-Münchingen",
"494626", "Treia",
"4935021", "Königstein\ Sächsische\ Schweiz",
"4939721", "Liepen\ bei\ Anklam",
"494409", "Westerstede\-Ocholt",
"497476", "Bisingen",
"499184", "Deining\ Oberpfalz",
"499101", "Langenzenn",
"497529", "Waldburg\ Württemberg",
"499482", "Wörth\ an\ der\ Donau",
"4937381", "Penig",
"498138", "Schwabhausen\ bei\ Dachau",
"499155", "Simmelsdorf",
"492228", "Remagen\-Rolandseck",
"494926", "Krummhörn\-Greetsiel",
"495148", "Steinhorst\ Niedersachsen",
"4934424", "Reuden\ bei\ Zeitz",
"492739", "Wilnsdorf",
"492157", "Nettetal\-Kaldenkirchen",
"498392", "Markt\ Rettenbach",
"492639", "Anhausen\ Kreis\ Neuwied",
"4936925", "Marksuhl",
"49651", "Trier",
"494893", "Hohenaspe",
"494243", "Twistringen",
"497202", "Karlsbad",
"496057", "Flörsbachtal",
"493605", "Leinefelde",
"499428", "Kirchroth",
"499293", "Berg\ Oberfranken",
"499843", "Burgbernheim",
"4939925", "Wredenhagen",
"499369", "Uettingen",
"495556", "Lindau\ Harz",
"494165", "Hollenstedt\ Nordheide",
"4933478", "Gross\ Neuendorf",
"496443", "Ehringshausen\ Dill",
"496167", "Modautal",
"4936646", "Tanna\ bei\ Schleiz",
"496522", "Mettendorf",
"493863", "Crivitz",
"494120", "Ellerhoop",
"497656", "Schluchsee",
"4938486", "Gustävel",
"498654", "Freilassing",
"497329", "Steinheim\ am\ Albuch",
"495272", "Brakel\ Westfalen",
"494133", "Wittorf\ Kreis\ Lüneburg",
"498754", "Volkenschwand",
"498785", "Rottenburg\-Oberroning",
"495238", "Nieheim\-Himmighausen",
"494559", "Wensin",
"498685", "Kirchanschöring",
"4933652", "Neuzelle",
"493544", "Luckau\ Brandenburg",
"494102", "Ahrensburg",
"494404", "Elsfleth",
"496827", "Eppelborn",
"494481", "Hatten\-Sandkrug",
"495435", "Berge\ bei\ Quakenbrück",
"497265", "Angelbachtal",
"496500", "Waldrach",
"493762", "Crimmitschau",
"4933201", "Gross\ Glienicke",
"4937363", "Zöblitz",
"499260", "Wilhelmsthal\ Oberfranken",
"495331", "Wolfenbüttel",
"492521", "Beckum",
"4939363", "Angern",
"494354", "Fleckeby",
"4933331", "Casekow",
"493962", "Penzlin\ bei\ Waren",
"497143", "Besigheim",
"497467", "Neuhausen\ ob\ Eck",
"494385", "Hohenfelde\ bei\ Kiel",
"496670", "Ludwigsau\ Hessen",
"495237", "Augustdorf",
"497524", "Bad\ Waldsee",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"4934956", "Zörbig",
"497233", "Niefern\-Öschelbronn",
"499225", "Stadtsteinach",
"496396", "Hinterweidenthal",
"495147", "Uetze\-Hänigsen",
"492158", "Grefrath\ bei\ Krefeld",
"494792", "Worpswede",
"499942", "Viechtach",
"496387", "Sankt\ Julian",
"495624", "Bad\ Emstal",
"496281", "Buchen\ Odenwald",
"496204", "Viernheim",
"4933209", "Caputh",
"498541", "Vilshofen\ Niederbayern",
"495724", "Obernkirchen",
"4933332", "Gartz\ Oder",
"4935954", "Grossharthau",
"499427", "Leiblfing",
"496058", "Gründau",
"499564", "Bad\ Rodach",
"4933202", "Töplitz",
"495924", "Bad\ Bentheim\-Gildehaus",
"497220", "Forbach\-Hundsbach",
"499642", "Kemnath\ Stadt",
"494825", "Burg\ Dithmarschen",
"499742", "Kalbach\ Rhön",
"4934600", "Ostrau\ Saalkreis",
"4938757", "Neustadt\-Glewe",
"492546", "Coesfeld\-Lette",
"493344", "Bad\ Freienwalde",
"498326", "Fischen\ im\ Allgäu",
"4935201", "Langebrück",
"492425", "Nideggen\-Embken",
"495531", "Holzminden",
"4939824", "Hohenzieritz",
"494554", "Wahlstedt",
"4936623", "Berga\ Elster",
"4939265", "Löderburg",
"498071", "Wasserburg\ am\ Inn",
"493636", "Greussen",
"498137", "Petershausen",
"4938731", "Lübz",
"497324", "Herbrechtingen",
"4933637", "Beerfelde",
"4936371", "Schlossvippach",
"492227", "Bornheim\-Merten",
"497731", "Singen\ Hohentwiel",
"4938732", "Gallin\ bei\ Lübz",
"498247", "Bad\ Wörishofen",
"496587", "Zerf",
"4936372", "Kleinneuhausen",
"497631", "Müllheim\ Baden",
"496596", "Üdersdorf",
"496783", "Baumholder",
"492734", "Freudenberg\ Westfalen",
"495086", "Celle\-Scheuen",
"492634", "Rengsdorf",
"496683", "Ehrenberg\ Rhön",
"4935209", "Mohorn",
"498341", "Kaufbeuren",
"499364", "Zellingen",
"492804", "Xanten\-Marienbaum",
"4935202", "Klingenberg\ Sachsen",
"492934", "Sundern\-Altenhellefeld",
"498445", "Gerolsbach",
"4938428", "Hohenkirchen\ bei\ Wismar",
"497931", "Bad\ Mergentheim",
"4936379", "Holzengel",
"495036", "Neustadt\-Schneeren",
"496733", "Gau\-Odernheim",
"492601", "Nauort",
"496633", "Homberg\ Ohm",
"492684", "Puderbach\ Westerwald",
"4939406", "Harbke",
"497704", "Geisingen\ Baden",
"4936962", "Vacha",
"4933701", "Grossbeeren",
"492655", "Weibern",
"494967", "Rhauderfehn\-Burlage",
"497681", "Waldkirch\ Breisgau",
"492755", "Bad\ Berleburg\-Schwarzenau",
"497834", "Wolfach",
"4939998", "Loitz\ bei\ Demmin",
"492571", "Greven\ Westfalen",
"497904", "Ilshofen",
"494667", "Dagebüll",
"498706", "Vilsheim",
"492955", "Büren\-Wewelsburg",
"494767", "Bremervörde\-Bevern",
"498368", "Halblech",
"4936969", "Merkers",
"496803", "Mandelbachtal\-Ommersheim",
"492831", "Geldern",
"492984", "Hallenberg",
"497574", "Gammertingen",
"496620", "Philippsthal\ Werra",
"494563", "Scharbeutz\-Haffkrug",
"492449", "Blankenheim\ Ahr",
"492191", "Remscheid",
"4937324", "Reinsberg\ Sachsen",
"4936927", "Unterellen",
"499275", "Speichersdorf",
"497194", "Spiegelberg",
"495774", "Wagenfeld\-Ströhen",
"496765", "Gemünden\ Hunsrück",
"4936784", "Stützerbach",
"4933933", "Lindow\ Mark",
"495674", "Grebenstein",
"496665", "Sinntal\-Altengronau",
"498252", "Schrobenhausen",
"499403", "Donaustauf",
"4933702", "Wünsdorf",
"4936961", "Bad\ Liebenstein",
"4936871", "Bad\ Colberg\-Heldburg",
"498196", "Pürgen",
"494535", "Nahe",
"495504", "Friedland\ Kreis\ Göttingen",
"4939324", "Kläden\ bei\ Stendal",
"494875", "Stafstedt",
"499353", "Karlstadt",
"4939927", "Nossentiner\ Hütte",
"493686", "Eisfeld",
"492203", "Cologne\-Porz",
"496231", "Hochdorf\-Assenheim",
"4930", "Berlin",
"498376", "Sulzberg\ Allgäu",
"4939001", "Apenburg",
"4933832", "Rogäsen",
"4936840", "Trusetal",
"4938301", "Putbus",
"496337", "Grossbundenbach",
"498021", "Waakirchen",
"496126", "Idstein",
"498862", "Steingaden\ Oberbayern",
"492371", "Iserlohn",
"494849", "Hooge",
"494363", "Lensahn",
"4934658", "Hayn\ Harz",
"4933839", "Wusterwitz",
"495821", "Bad\ Bevensen",
"4938231", "Barth",
"497374", "Uttenweiler",
"495062", "Holle\ bei\ Hildesheim",
"4938309", "Trent",
"495485", "Ladbergen",
"4939009", "Badel",
"497044", "Mönsheim",
"4938232", "Zingst\ Ostseebad",
"4935933", "Neschwitz",
"4934208", "Löbnitz\ bei\ Delitzsch",
"495152", "Hessisch\ Oldendorf",
"494431", "Wildeshausen",
"492041", "Bottrop",
"495454", "Hörstel\-Riesenbeck",
"494335", "Hohn\ bei\ Rendsburg",
"495846", "Gartow\ Niedersachsen",
"499657", "Waldthurn",
"499553", "Ebrach\ Oberfranken",
"4939973", "Altkalen",
"498046", "Bad\ Heilbrunn",
"495304", "Meine",
"4939863", "Seehausen\ bei\ Prenzlau",
"4939002", "Oebisfelde",
"495381", "Seesen",
"4933084", "Gutengermendorf",
"4938302", "Sagard",
"4933831", "Weseram",
"499466", "Stamsried",
"497441", "Freudenstadt",
"4933734", "Felgentreu",
"499340", "Königheim\-Brehmen",
"498851", "Kochel\ am\ See",
"498805", "Hohenpeissenberg",
"492444", "Schleiden\-Gemünd",
"495051", "Bergen\ Kreis\ Celle",
"498735", "Gangkofen\-Kollbach",
"492856", "Hamminkeln\-Brünen",
"495509", "Rosdorf\ Kreis\ Göttingen",
"498635", "Pleiskirchen",
"499658", "Georgenberg",
"4939222", "Möser",
"49811", "Hallbergmoos",
"493421", "Torgau",
"494183", "Jesteburg",
"496042", "Büdingen\ Hessen",
"497345", "Langenau\ Württemberg",
"494776", "Osten\-Altendorf",
"497709", "Wutach",
"4936948", "Römhild",
"496372", "Bruchmühlbach\-Miesau",
"497426", "Gosheim",
"4939221", "Möckern\ bei\ Magdeburg",
"496338", "Hornbach\ Pfalz",
"4935603", "Burg\ Spreewald",
"492689", "Dierdorf",
"497579", "Schwenningen\ Baden",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"492232", "Brühl\ Rheinland",
"494506", "Stockelsdorf\-Krumbeck",
"498424", "Nassenfels",
"496866", "Perl\-Nennig",
"498122", "Erding",
"495161", "Walsrode",
"497839", "Schapbach",
"494976", "Spiekeroog",
"499070", "Tapfheim",
"4939267", "Schneidlingen",
"498663", "Ruhpolding",
"493525", "Riesa",
"495459", "Hörstel",
"493998", "Demmin",
"4939881", "Ringenwalde\ bei\ Templin",
"4939034", "Fleetmark",
"499083", "Möttingen",
"496256", "Lampertheim\-Hüttenfeld",
"4938334", "Grammendorf",
"4939774", "Mönkebude",
"496192", "Hofheim\ am\ Taunus",
"49906", "Donauwörth",
"4938204", "Broderstorf",
"4938755", "Eldena",
"495309", "Lehre\-Wendhausen",
"49521", "Bielefeld",
"497545", "Immenstaad\ am\ Bodensee",
"499134", "Neunkirchen\ am\ Brand",
"496572", "Manderscheid\ Eifel",
"499244", "Betzenstein",
"494456", "Varel\-Altjührden",
"496832", "Beckingen\-Reimsbach",
"4933603", "Falkenhagen\ bei\ Seelow",
"495745", "Stemwede\-Levern",
"4934463", "Bad\ Kösen",
"494968", "Neulehe",
"495645", "Borgentreich\-Borgholz",
"492266", "Lindlar",
"4939889", "Boitzenburg",
"4939882", "Gollin",
"494668", "Klanxbüll",
"495945", "Wilsum",
"494768", "Hipstedt",
"498367", "Rosshaupten\ Forggensee",
"495222", "Bad\ Salzuflen",
"498261", "Mindelheim",
"4938853", "Drönnewitz\ bei\ Hagenow",
"494844", "Pellworm",
"494294", "Riede\ Kreis\ Verden",
"494158", "Roseburg",
"492692", "Kelberg",
"4934497", "Langenleuba\-Niederhain",
"499683", "Friedenfels",
"495471", "Bohmte",
"495253", "Bad\ Driburg",
"497949", "Pfedelbach\-Untersteinbach",
"4939395", "Wanzer",
"496364", "Nussbach\ Pfalz",
"495375", "Müden\ Aller",
"493629", "Stadtilm",
"492992", "Marsberg",
"494546", "Mustin\ Lauenburg",
"492825", "Uedem",
"498845", "Bad\ Kohlgrub",
"498295", "Altenmünster\ Schwaben",
"492102", "Ratingen",
"492404", "Alsdorf\ Rheinland",
"4936847", "Steinbach\-Hallenberg",
"497455", "Dornhan",
"497182", "Welzheim",
"497484", "Simmersfeld",
"4939886", "Milmersdorf",
"495045", "Springe\-Bennigsen",
"4934903", "Coswig\ Anhalt",
"494521", "Eutin",
"499176", "Allersberg",
"492354", "Meinerzhagen",
"4933474", "Neutrebbin",
"497305", "Erbach\ Donau",
"496002", "Ober\-Mörlen",
"497257", "Bruchsal\-Untergrombach",
"497351", "Biberach\ an\ der\ Riss",
"492385", "Hamm\-Rhynern",
"495705", "Petershagen\-Windheim",
"499396", "Urspringen\ bei\ Lohr",
"495605", "Kaufungen\ Hessen",
"4936920", "Grossenlupnitz",
"494634", "Husby",
"495651", "Eschwege",
"4939226", "Hohenziatz",
"495751", "Rinteln",
"499281", "Hof\ Saale",
"497128", "Sonnenbühl",
"494734", "Stadland\-Seefeld",
"499204", "Plankenfels",
"498153", "Wessling",
"4937293", "Eppendorf\ Sachsen",
"496564", "Neuerburg\ Eifel",
"496427", "Cölbe\-Schönstadt",
"494881", "Friedrichstadt",
"4939293", "Dreileben",
"494804", "Nordhastedt",
"495951", "Werlte",
"498035", "Raubling",
"494934", "Marienhafe",
"495905", "Beesten",
"496742", "Boppard",
"495835", "Wahrenholz",
"496642", "Schlitz",
"494346", "Gettorf",
"497775", "Mühlingen",
"495195", "Neuenkirchen\ bei\ Soltau",
"499827", "Lichtenau\ Mittelfranken",
"497675", "Bernau\ Baden",
"4933238", "Senzke",
"494425", "Wangerland\-Hooksiel",
"4935474", "Schönwalde\ bei\ Lübben",
"495863", "Zernien",
"497505", "Fronreute",
"494321", "Neumünster",
"492554", "Laer\ Kreis\ Steinfurt",
"49465", "Sylt",
"492585", "Warendorf\-Hoetmar",
"4937434", "Bobenneukirchen",
"497975", "Untergröningen",
"497551", "Überlingen\ Bodensee",
"498063", "Feldkirchen\-Westerham",
"499522", "Eltmann",
"493331", "Angermünde",
"499828", "Rügland",
"495962", "Herzlake",
"499167", "Oberscheinfeld",
"499443", "Abensberg",
"492626", "Selters\ Westferwald",
"492409", "Stolberg\-Gressenich",
"495130", "Wedemark",
"495544", "Reinhardshagen",
"498621", "Trostberg",
"4938424", "Bobitz",
"495123", "Schellerten",
"498721", "Eggenfelden",
"4933836", "Butzow\ bei\ Brandenburg",
"492359", "Kierspe",
"493435", "Oschatz",
"495662", "Felsberg\ Hessen",
"494493", "Friesoythe\-Gehlenberg",
"497744", "Stühlingen",
"4939006", "Miesterhorst",
"4938306", "Samtens",
"497644", "Kenzingen",
"492741", "Betzdorf",
"497562", "Isny\ im\ Allgäu",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"497127", "Neckartenzlingen",
"49951", "Bamberg",
"498334", "Bad\ Grönenbach",
"496293", "Schefflenz",
"496843", "Gersheim",
"492941", "Lippstadt",
"4934605", "Gröbers",
"497336", "Lonsee",
"496428", "Stadtallendorf",
"493724", "Burgstädt",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"497944", "Kupferzell",
"493624", "Ohrdruf",
"4939345", "Parchen",
"495636", "Lichtenfels\-Goddelsheim",
"493531", "Finsterwalde",
"496033", "Butzbach",
"4939409", "Eilsleben",
"498230", "Gablingen",
"493871", "Parchim",
"497081", "Bad\ Wildbad",
"492133", "Dormagen",
"496184", "Langenselbold",
"496101", "Bad\ Vilbel",
"496482", "Runkel",
"4939402", "Völpke",
"4936966", "Kaltennordheim",
"495344", "Lengede",
"497258", "Oberderdingen\-Flehingen",
"498223", "Ichenhausen",
"495936", "Twist",
"496020", "Heigenbrücken",
"496155", "Griesheim\ Hessen",
"495806", "Barum\ bei\ Bad\ Bevensen",
"494639", "Schafflund",
"499209", "Emtmannsberg",
"492243", "Eitorf",
"4934633", "Braunsbedra",
"49931", "Würzburg",
"498534", "Tettenweis",
"497362", "Bopfingen",
"495074", "Rodewald",
"4939401", "Neuwegersleben",
"496691", "Schwalmstadt",
"496569", "Bickendorf",
"492165", "Jüchen",
"494282", "Sittensen",
"494939", "Baltrum",
"4939243", "Nedlitz\ bei\ Zerbst",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;