# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::IM;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20201204215956;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '1624[5-8]\\d{5}',
                'geographic' => '1624[5-8]\\d{5}',
                'mobile' => '
          76245[06]\\d{4}|
          7(?:
            4576|
            [59]24\\d|
            624[0-4689]
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '70\\d{8}',
                'specialrate' => '(
          8(?:
            440[49]06|
            72299\\d
          )\\d{3}|
          (?:
            8(?:
              45|
              70
            )|
            90[0167]
          )624\\d{4}
        )|(
          3440[49]06\\d{3}|
          (?:
            3(?:
              08162|
              3\\d{4}|
              45624|
              7(?:
                0624|
                2299
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '808162\\d{4}',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"442896", "Belfast",
"441982", "Builth\ Wells",
"441646", "Milford\ Haven",
"441732", "Sevenoaks",
"441845", "Thirsk",
"441744", "St\ Helens",
"441244", "Chester",
"4418512", "Stornoway",
"441392", "Exeter",
"441349", "Dingwall",
"441896", "Galashiels",
"441592", "Kirkcaldy",
"441549", "Lairg",
"441695", "Skelmersdale",
"441558", "Llandeilo",
"4413396", "Ballater",
"441905", "Worcester",
"441210", "Birmingham",
"441358", "Ellon",
"4415396", "Sedbergh",
"441420", "Alton",
"441279", "Bishops\ Stortford",
"441442", "Hemel\ Hempstead",
"441499", "Inveraray",
"441779", "Peterhead",
"441859", "Harris",
"441280", "Buckingham",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441780", "Stamford",
"4418470", "Thurso\/Tongue",
"441924", "Wakefield",
"441908", "Milton\ Keynes",
"4414235", "Harrogate",
"441555", "Lanark",
"441461", "Gretna",
"441673", "Market\ Rasen",
"441652", "Brigg",
"441355", "East\ Kilbride",
"441997", "Strathpeffer",
"441912", "Tyneside",
"441456", "Glenurquhart",
"441621", "Maldon",
"441698", "Motherwell",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441387", "Dumfries",
"4419649", "Hornsea",
"441833", "Barnard\ Castle",
"441848", "Thornhill",
"4414233", "Boroughbridge",
"441474", "Gravesend",
"441294", "Ardrossan",
"441794", "Romsey",
"4416973", "Wigton",
"441458", "Glastonbury",
"441895", "Uxbridge",
"441239", "Cardigan",
"4413391", "Aboyne\/Ballater",
"441989", "Ross\-on\-Wye",
"4418473", "Thurso",
"4413398", "Aboyne",
"442895", "Belfast",
"441599", "Kyle",
"441542", "Keith",
"441334", "St\ Andrews",
"441520", "Lochcarron",
"441342", "East\ Grinstead",
"441534", "Jersey",
"441320", "Fort\ Augustus",
"4414230", "Harrogate\/Boroughbridge",
"441727", "St\ Albans",
"4418902", "Coldstream",
"441963", "Wincanton",
"441227", "Canterbury",
"4413885", "Stanhope\ \(Eastgate\)",
"441772", "Preston",
"441753", "Slough",
"441449", "Stowmarket",
"441492", "Colwyn\ Bay",
"441253", "Blackpool",
"4418475", "Thurso",
"441556", "Castle\ Douglas",
"441807", "Ballindalloch",
"441356", "Brechin",
"441873", "Abergavenny",
"441852", "Kilmelford",
"4419752", "Alford\ \(Aberdeen\)",
"441659", "Sanquhar",
"441487", "Warboys",
"442898", "Belfast",
"442821", "Martinstown",
"441947", "Whitby",
"441919", "Durham",
"441633", "Newport",
"441455", "Hinckley",
"441561", "Laurencekirk",
"4415079", "Alford\ \(Lincs\)",
"4413397", "Ballater",
"441361", "Duns",
"441821", "Kinrossie",
"441970", "Aberystwyth",
"441856", "Orkney",
"441373", "Frome",
"4416865", "Newtown",
"441352", "Mold",
"441655", "Maybole",
"441573", "Kelso",
"441307", "Forfar",
"441433", "Hathersage",
"441743", "Shrewsbury",
"441687", "Mallaig",
"441243", "Chichester",
"4416863", "Llanidloes",
"4420", "London",
"441738", "Perth",
"441988", "Wigtown",
"4418904", "Coldstream",
"441598", "Lynton",
"4412290", "Barrow\-in\-Furness\/Millom",
"441700", "Rothesay",
"441398", "Dulverton",
"441915", "Sunderland",
"441200", "Clitheroe",
"442842", "Kircubbin",
"441692", "North\ Walsham",
"442820", "Ballycastle",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"441918", "Tyneside",
"441395", "Budleigh\ Salterton",
"441346", "Fraserburgh",
"441899", "Biggar",
"441842", "Thetford",
"441360", "Killearn",
"4419754", "Alford\ \(Aberdeen\)",
"441971", "Scourie",
"441546", "Lochgilphead",
"441235", "Abingdon",
"4414303", "North\ Cave",
"441985", "Warminster",
"441560", "Moscow",
"441834", "Narberth",
"441767", "Sandy",
"441923", "Watford",
"441267", "Carmarthen",
"441445", "Gairloch",
"441276", "Camberley",
"441496", "Port\ Ellen",
"4414305", "North\ Cave",
"441957", "Mid\ Yell",
"441776", "Stranraer",
"441902", "Wolverhampton",
"441674", "Montrose",
"441559", "Llandysul",
"4414300", "North\ Cave\/Market\ Weighton",
"441359", "Pakenham",
"441211", "Birmingham",
"4417683", "Appleby",
"441754", "Skegness",
"441278", "Bridgwater",
"441855", "Ballachulish",
"4418514", "Great\ Bernera",
"441254", "Blackburn",
"441778", "Bourne",
"441656", "Bridgend",
"441407", "Holyhead",
"441452", "Gloucester",
"441293", "Crawley",
"441473", "Ipswich",
"441661", "Prudhoe",
"441916", "Tyneside",
"441793", "Swindon",
"442887", "Dungannon",
"441348", "Fishguard",
"441887", "Aberfeldy",
"441548", "Kingsbridge",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441634", "Medway",
"441236", "Coatbridge",
"441545", "Llanarth",
"4414349", "Bellingham",
"4412295", "Barrow\-in\-Furness",
"441736", "Penzance",
"441642", "Middlesbrough",
"441986", "Bungay",
"441620", "North\ Berwick",
"442892", "Lisburn",
"44118", "Reading",
"441892", "Tunbridge\ Wells",
"441495", "Pontypool",
"441858", "Market\ Harborough",
"441275", "Clevedon",
"4412293", "Millom",
"441775", "Spalding",
"441874", "Brecon",
"441931", "Shap",
"4414372", "Clynderwen\ \(Clunderwen\)",
"441909", "Worksop",
"4416860", "Newtown\/Llanidloes",
"441460", "Chard",
"441446", "Barry",
"441832", "Clopton",
"441467", "Inverurie",
"441844", "Thame",
"441745", "Rhyl",
"441536", "Kettering",
"441245", "Chelmsford",
"4414302", "North\ Cave",
"441476", "Grantham",
"441296", "Aylesbury",
"441639", "Neath",
"441796", "Pitlochry",
"441913", "Durham",
"442844", "Downpatrick",
"441694", "Church\ Stretton",
"441904", "York",
"441653", "Malton",
"442879", "Magherafelt",
"441672", "Marlborough",
"441381", "Fortrose",
"441575", "Kirriemuir",
"441581", "New\ Luce",
"441375", "Grays\ Thurrock",
"4419647", "Patrington",
"441879", "Scarinish",
"44238", "Southampton",
"441435", "Heathfield",
"441928", "Runcorn",
"44131", "Edinburgh",
"441759", "Pocklington",
"441880", "Tarbert",
"441443", "Pontypridd",
"441259", "Alloa",
"441438", "Stevenage",
"4416974", "Raughton\ Head",
"44151", "Liverpool",
"4419641", "Hornsea\/Patrington",
"441925", "Warrington",
"442880", "Carrickmore",
"442311", "Southampton",
"441554", "Llanelli",
"4419648", "Hornsea",
"441578", "Lauder",
"441969", "Leyburn",
"441354", "Chatteris",
"44147984", "Carrbridge",
"4418474", "Thurso",
"441400", "Honington",
"4415076", "Louth",
"4416862", "Llanidloes",
"441593", "Lybster",
"441233", "Ashford\ \(Kent\)",
"441733", "Peterborough",
"441983", "Isle\ of\ Wight",
"441748", "Richmond",
"441248", "Bangor\ \(Gwynedd\)",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441295", "Banbury",
"441475", "Greenock",
"441795", "Sittingbourne",
"441481", "Guernsey",
"441950", "Sandwick",
"4414375", "Clynderwen\ \(Clunderwen\)",
"44147982", "Nethy\ Bridge",
"441644", "New\ Galloway",
"442894", "Antrim",
"441335", "Ashbourne",
"441746", "Bridgnorth",
"441260", "Congleton",
"441246", "Chesterfield",
"441535", "Keighley",
"441760", "Swaffham",
"441567", "Killin",
"4414373", "Clynderwen\ \(Clunderwen\)",
"441436", "Helensburgh",
"441827", "Tamworth",
"4412292", "Barrow\-in\-Furness",
"441367", "Faringdon",
"4414234", "Boroughbridge",
"4413399", "Ballater",
"441576", "Lockerbie",
"4415077", "Louth",
"441872", "Truro",
"4415242", "Hornby",
"442827", "Ballymoney",
"441376", "Braintree",
"441207", "Consett",
"441707", "Welwyn\ Garden\ City",
"441252", "Aldershot",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441493", "Great\ Yarmouth",
"441273", "Brighton",
"441752", "Plymouth",
"441773", "Ripley",
"4415078", "Alford\ \(Lincs\)",
"441962", "Winchester",
"441926", "Warwick",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441543", "Cannock",
"4419646", "Patrington",
"441343", "Elgin",
"44141", "Glasgow",
"441538", "Ipstones",
"441300", "Cerne\ Abbas",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"441298", "Buxton",
"441454", "Chipping\ Sodbury",
"441798", "Pulborough",
"44241", "Coventry",
"441721", "Peebles",
"441977", "Pontefract",
"441756", "Skipton",
"441256", "Basingstoke",
"44116", "Leicester",
"441654", "Machynlleth",
"441903", "Worthing",
"441678", "Bala",
"441922", "Walsall",
"44161", "Manchester",
"441843", "Thanet",
"441480", "Huntingdon",
"441951", "Colonsay",
"4412294", "Barrow\-in\-Furness",
"441838", "Dalmally",
"4414232", "Harrogate",
"441261", "Banff",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441761", "Temple\ Cloud",
"442838", "Portadown",
"441914", "Tyneside",
"4418900", "Coldstream\/Ayton",
"4417684", "Pooley\ Bridge",
"441594", "Lydney",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"44147985", "Dulnain\ Bridge",
"441394", "Felixstowe",
"441539", "Kendal",
"441501", "Harthill",
"441479", "Grantown\-on\-Spey",
"441242", "Cheltenham",
"441299", "Bewdley",
"441720", "Isles\ of\ Scilly",
"441636", "Newark\-on\-Trent",
"441799", "Saffron\ Walden",
"441301", "Arrochar",
"441234", "Bedford",
"441984", "Watchet\ \(Williton\)",
"441835", "St\ Boswells",
"4414346", "Hexham",
"4418513", "Stornoway",
"441327", "Daventry",
"441432", "Hereford",
"441527", "Redditch",
"441444", "Haywards\ Heath",
"441353", "Ely",
"4418515", "Stornoway",
"441372", "Esher",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441876", "Lochmaddy",
"442867", "Lisnaskea",
"441553", "Kings\ Lynn",
"441572", "Oakham",
"441675", "Coleshill",
"4418510", "Great\ Bernera\/Stornoway",
"441580", "Cranbrook",
"4414347", "Hexham",
"441380", "Devizes",
"4414304", "North\ Cave",
"441854", "Ullapool",
"441255", "Clacton\-on\-Sea",
"441878", "Lochboisdale",
"4419753", "Strathdon",
"441929", "Wareham",
"44281", "Northern\ Ireland",
"441600", "Monmouth",
"441638", "Newmarket",
"4419755", "Alford\ \(Aberdeen\)",
"441787", "Sudbury",
"442893", "Ballyclare",
"441937", "Wetherby",
"441643", "Minehead",
"441287", "Guisborough",
"441344", "Bracknell",
"441635", "Newbury",
"441332", "Derby",
"441544", "Kington",
"441427", "Gainsborough",
"4418905", "Ayton",
"4413882", "Stanhope\ \(Eastgate\)",
"441792", "Swansea",
"441749", "Shepton\ Mallet",
"441292", "Ayr",
"441249", "Chippenham",
"441217", "Birmingham",
"4418472", "Thurso",
"441472", "Grimsby",
"441453", "Dursley",
"441274", "Bradford",
"4418903", "Coldstream",
"441494", "High\ Wycombe",
"441758", "Pwllheli",
"441875", "Tranent",
"4416864", "Llanidloes",
"441258", "Blandford",
"441439", "Helmsley",
"4412180", "Birmingham",
"4414348", "Hexham",
"441676", "Meriden",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"441579", "Liskeard",
"441968", "Penicuik",
"442310", "Portsmouth",
"442881", "Newtownstewart",
"441667", "Nairn",
"441379", "Diss",
"441202", "Bournemouth",
"441702", "Southend\-on\-Sea",
"441341", "Barmouth",
"441257", "Coppull",
"441757", "Selby",
"44117", "Bristol",
"441668", "Bamburgh",
"441967", "Strontian",
"441223", "Cambridge",
"4414236", "Harrogate",
"441723", "Scarborough",
"441285", "Cirencester",
"441428", "Haslemere",
"441884", "Tiverton",
"441935", "Yeovil",
"441785", "Stafford",
"4418477", "Tongue",
"441491", "Henley\-on\-Thames",
"441271", "Barnstaple",
"441771", "Maud",
"441550", "Llandovery",
"441350", "Dunkeld",
"441404", "Honiton",
"441900", "Workington",
"4418478", "Thurso",
"4413393", "Aboyne",
"441215", "Birmingham",
"441469", "Killingholme",
"4419644", "Patrington",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441288", "Bude",
"441425", "Ringwood",
"4419467", "Gosforth",
"441788", "Rugby",
"4414379", "Haverfordwest",
"441938", "Welshpool",
"4418471", "Thurso\/Tongue",
"441943", "Guiseley",
"441637", "Newquay",
"441562", "Kidderminster",
"441526", "Martin",
"441665", "Alnwick",
"4415395", "Grange\-over\-Sands",
"441362", "Dereham",
"441483", "Guildford",
"441840", "Camelford",
"441822", "Tavistock",
"442877", "Limavady",
"441326", "Falmouth",
"4413395", "Aboyne",
"441866", "Kilchrenan",
"4414342", "Bellingham",
"441803", "Torquay",
"441877", "Callander",
"442866", "Enniskillen",
"441629", "Matlock",
"442840", "Banbridge",
"441690", "Betws\-y\-Coed",
"441528", "Laggan",
"441709", "Rotherham",
"441328", "Fakenham",
"441209", "Redruth",
"441591", "Llanwrtyd\ Wells",
"441304", "Dover",
"44239", "Portsmouth",
"441450", "Hawick",
"441981", "Wormbridge",
"442868", "Kesh",
"4413390", "Aboyne\/Ballater",
"44113", "Leeds",
"4414238", "Harrogate",
"441286", "Caernarfon",
"4414231", "Harrogate\/Boroughbridge",
"441786", "Stirling",
"441684", "Malvern",
"441651", "Oldmeldrum",
"441837", "Okehampton",
"441383", "Dunfermline",
"441462", "Hitchin",
"4414237", "Harrogate",
"4415074", "Alford\ \(Lincs\)",
"441583", "Carradale",
"441216", "Birmingham",
"441993", "Witney",
"442837", "Armagh",
"441677", "Bedale",
"441829", "Tarporley",
"44291", "Cardiff",
"441369", "Dunoon",
"441954", "Madingley",
"441603", "Norwich",
"441978", "Wrexham",
"441569", "Stonehaven",
"4418476", "Tongue",
"442829", "Kilrea",
"442890", "Belfast",
"441622", "Maidstone",
"441911", "Tyneside\/Durham\/Sunderland",
"441525", "Leighton\ Buzzard",
"441666", "Malmesbury",
"441264", "Andover",
"441865", "Oxford",
"441325", "Darlington",
"441764", "Crieff",
"441466", "Huntly",
"441337", "Ladybank",
"441422", "Halifax",
"441440", "Haverhill",
"441883", "Caterham",
"441403", "Horsham",
"4418909", "Ayton",
"441797", "Rye",
"441297", "Axminster",
"441212", "Birmingham",
"441477", "Holmes\ Chapel",
"442825", "Ballymena",
"441529", "Sleaford",
"441590", "Lymington",
"441708", "Romford",
"4412291", "Barrow\-in\-Furness\/Millom",
"441208", "Bodmin",
"441329", "Fareham",
"441869", "Bicester",
"441224", "Aberdeen",
"441724", "Scunthorpe",
"4412298", "Barrow\-in\-Furness",
"441825", "Uckfield",
"4414306", "Market\ Weighton",
"441980", "Amesbury",
"441626", "Newton\ Abbot",
"441451", "Stow\-on\-the\-Wold",
"441565", "Knutsford",
"4417687", "Keswick",
"441730", "Petersfield",
"441484", "Huddersfield",
"441828", "Coupar\ Angus",
"441368", "Dunbar",
"4416866", "Newtown",
"4415072", "Spilsby\ \(Horncastle\)",
"441568", "Leominster",
"442828", "Larne",
"4412297", "Millom",
"441641", "Strathy",
"442891", "Bangor\ \(Co\.\ Down\)",
"441910", "Tyneside\/Durham\/Sunderland",
"441205", "Boston",
"441650", "Cemmaes\ Road",
"4419759", "Alford\ \(Aberdeen\)",
"441944", "West\ Heslerton",
"441932", "Weybridge",
"441782", "Stoke\-on\-Trent",
"441282", "Burnley",
"441270", "Crewe",
"441490", "Corwen",
"441429", "Hartlepool",
"441770", "Isle\ of\ Arran",
"4412296", "Barrow\-in\-Furness",
"4414308", "Market\ Weighton",
"4414301", "North\ Cave\/Market\ Weighton",
"441747", "Shaftesbury",
"441683", "Moffat",
"44147986", "Cairngorm",
"441465", "Girvan",
"4416867", "Llanidloes",
"441862", "Tain",
"441340", "Craigellachie\ \(Aberlour\)",
"441322", "Dartford",
"441366", "Downham\ Market",
"4418519", "Great\ Bernera",
"441540", "Kingussie",
"441522", "Lincoln",
"441625", "Macclesfield",
"441566", "Launceston",
"441377", "Driffield",
"441503", "Looe",
"441669", "Rothbury",
"441577", "Kinross",
"441303", "Folkestone",
"441841", "Newquay\ \(Padstow\)",
"441604", "Northampton",
"441953", "Wymondham",
"441972", "Glenborrodale",
"441706", "Rochdale",
"441206", "Colchester",
"4419642", "Hornsea",
"441263", "Cromer",
"44147981", "Aviemore",
"442841", "Rostrevor",
"441763", "Royston",
"441691", "Oswestry",
"441628", "Maidenhead",
"4416861", "Newtown\/Llanidloes",
"441584", "Ludlow",
"4414307", "Market\ Weighton",
"441384", "Dudley",
"441289", "Berwick\-upon\-Tweed",
"4414344", "Bellingham",
"441789", "Stratford\-upon\-Avon",
"441939", "Wem",
"4416868", "Newtown",
"441994", "St\ Clears",
"4415073", "Louth",
"441306", "Dorking",
"441506", "Bathgate",
"441631", "Oban",
"441857", "Sanday",
"441609", "Northallerton",
"4414377", "Haverfordwest",
"441563", "Kilmarnock",
"441823", "Taunton",
"441482", "Kingston\-upon\-Hull",
"441363", "Crediton",
"441284", "Bury\ St\ Edmunds",
"441934", "Weston\-super\-Mare",
"441885", "Pencombe",
"441784", "Staines",
"441942", "Wigan",
"4415075", "Spilsby\ \(Horncastle\)",
"441871", "Castlebay",
"441920", "Ware",
"442885", "Ballygawley",
"442871", "Londonderry",
"441389", "Dumbarton",
"441405", "Goole",
"441214", "Birmingham",
"441570", "Lampeter",
"441408", "Golspie",
"441424", "Hastings",
"441888", "Turriff",
"441547", "Knighton",
"441751", "Pickering",
"4419640", "Hornsea\/Patrington",
"441347", "Easingwold",
"441664", "Melton\ Mowbray",
"4418479", "Tongue",
"44115", "Nottingham",
"441722", "Salisbury",
"441740", "Sedgefield",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441766", "Porthmadog",
"4414378", "Haverfordwest",
"441777", "Retford",
"441497", "Hay\-on\-Wye",
"441277", "Brentwood",
"4419643", "Patrington",
"441623", "Mansfield",
"4415394", "Hawkshead",
"4414239", "Boroughbridge",
"441268", "Basildon",
"441809", "Tomdoun",
"441768", "Penrith",
"4413394", "Ballater",
"441489", "Bishops\ Waltham",
"441305", "Dorchester",
"441505", "Johnstone",
"441974", "Llanon",
"442886", "Cookstown",
"441949", "Whatton",
"441992", "Lea\ Valley",
"441917", "Sunderland",
"4419645", "Hornsea",
"441406", "Holbeach",
"441382", "Dundee",
"441463", "Inverness",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"441671", "Newton\ Stewart",
"441582", "Luton",
"441685", "Merthyr\ Tydfil",
"441737", "Redhill",
"441987", "Ebbsfleet",
"4414376", "Haverfordwest",
"441237", "Bideford",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441397", "Fort\ William",
"441597", "Llandrindod\ Wells",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441290", "Cumnock",
"441308", "Bridport",
"441790", "Spilsby",
"441729", "Settle",
"441508", "Brooke",
"441955", "Wick",
"441330", "Banchory",
"441524", "Lancaster",
"441864", "Abington\ \(Crawford\)",
"441530", "Coalville",
"441324", "Falkirk",
"441765", "Ripon",
"441948", "Whitchurch",
"441283", "Burton\-on\-Trent",
"4413392", "Aboyne",
"442897", "Saintfield",
"441933", "Wellingborough",
"441647", "Moretonhampstead",
"4412299", "Millom",
"4414345", "Haltwhistle",
"441670", "Morpeth",
"4418901", "Coldstream\/Ayton",
"441269", "Ammanford",
"442830", "Newry",
"441808", "Tomatin",
"441769", "South\ Molton",
"4419757", "Strathdon",
"4418908", "Coldstream",
"441225", "Bath",
"441488", "Hungerford",
"441364", "Ashburton",
"441725", "Rockbourne",
"441824", "Ruthin",
"441959", "Westerham",
"4414343", "Haltwhistle",
"4418516", "Great\ Bernera",
"441830", "Kirkwhelpington",
"441564", "Lapworth",
"441228", "Carlisle",
"441485", "Hunstanton",
"441309", "Forres",
"441728", "Saxmundham",
"441291", "Chepstow",
"4419758", "Strathdon",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"441509", "Loughborough",
"441663", "New\ Mills",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441606", "Northwich",
"441531", "Ledbury",
"4418907", "Ayton",
"441805", "Torrington",
"44247", "Coventry",
"441704", "Southport",
"441204", "Bolton",
"441213", "Birmingham",
"441457", "Glossop",
"442882", "Omagh",
"441689", "Orpington",
"441945", "Wisbech",
"4413873", "Langholm",
"441586", "Campbeltown",
"441882", "Kinloch\ Rannoch",
"441386", "Evesham",
"4418906", "Ayton",
"441697", "Brampton",
"441870", "Isle\ of\ Benbecula",
"4418518", "Stornoway",
"442870", "Coleraine",
"4418511", "Great\ Bernera\/Stornoway",
"44292", "Cardiff",
"441588", "Bishops\ Castle",
"441464", "Insch",
"441388", "Bishop\ Auckland",
"441226", "Barnsley",
"441630", "Market\ Drayton",
"441726", "St\ Austell",
"441262", "Bridlington",
"4414309", "Market\ Weighton",
"441624", "Isle\ of\ Man",
"441608", "Chipping\ Norton",
"441952", "Telford",
"441502", "Lowestoft",
"441357", "Strathaven",
"441241", "Arbroath",
"44147983", "Boat\ of\ Garten",
"441806", "Shetland",
"441302", "Doncaster",
"441557", "Kirkcudbright",
"441323", "Eastbourne",
"441863", "Ardgay",
"4416869", "Newtown",
"442889", "Fivemiletown",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441946", "Whitehaven",
"441371", "Great\ Dunmow",
"4418517", "Stornoway",
"441409", "Holsworthy",
"441571", "Lochinver",
"441750", "Selkirk",
"441431", "Helmsdale",
"441250", "Blairgowrie",
"441889", "Rugeley",
"4419756", "Strathdon",
"44114", "Sheffield",
"441995", "Garstang",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:0|([5-8]\d{5})$)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/1624$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;