# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20201204215956;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[4-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[4-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{de} = {"4936484", "Knau\ bei\ Pößneck",
"4989", "München",
"496321", "Neustadt\ an\ der\ Weinstraße",
"495384", "Seesen\-Groß\ Rhüden",
"4939883", "Groß\ Dölln",
"498367", "Roßhaupten\ Forggensee",
"492203", "Köln\-Porz",
"4935240", "Tauscha\ bei\ Großenhain",
"4936949", "Obermaßfeld\-Grimmenthal",
"4939976", "Groß\ Bützin",
"498807", "Dießen\ am\ Ammersee",
"494509", "Groß\ Grönau",
"499135", "Heßdorf\ Mittelfrankenanken",
"4935952", "Großröhrsdorf\ OL",
"499656", "Moosbach\ bei\ Vohenstrauß",
"4935753", "Großräschen",
"497355", "Hochdorf\ Riß",
"4934445", "Stößen",
"499242", "Gößweinstein",
"493647", "Pößneck",
"49221", "Köln",
"499567", "Seßlach\-Gemünda",
"4934901", "Roßlau\ Elbe",
"497351", "Biberach\ an\ der\ Riß",
"4935726", "Groß\ Särchen",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"498633", "Tüßling",
"496364", "Nußbach\ Pfalz",
"49911", "Nürnberg",
"4936072", "Weißenborn\-Lüderode",
"496252", "Heppenheim\ Bergstraße",
"4935248", "Schönfeld\ bei\ Großenhain",
"495064", "Groß\ Düngen",
"494497", "Barßel\-Harkebrügge",
"492339", "Sprockhövel\-Haßlinghausen",
"4934493", "Gößnitz\ Thüringen",
"499636", "Plößberg",
"494483", "Ovelgönne\-Großenmeer",
"498170", "Straßlach\-Dingharting",
"4935841", "Großschönau\ Sachsen",
"494684", "Langeneß\ Hallig",
"498536", "Kößlarn",
"4935938", "Großpostwitz\ OL",
"495053", "Faßberg\-Müden",
"4939934", "Groß\ Plasten",
"495827", "Unterlüß",
"4938234", "Born\ Darß",
"497162", "Süßen",
"499141", "Weißenburg\ in\ Bayern",
"496663", "Steinau\ an\ der\ Straße",};
$areanames{en} = {"4938720", "Grebbin",
"495191", "Soltau",
"496349", "Billigheim\-Ingenheim",
"496392", "Hauenstein\ Pfalz",
"492435", "Erkelenz\-Lövenich",
"497573", "Stetten\ am\ kalten\ Markt",
"495423", "Versmold",
"494608", "Handewitt",
"496732", "Wörrstadt",
"497448", "Seewald",
"492054", "Essen\-Kettwig",
"495457", "Hopsten\-Schale",
"499545", "Buttenheim",
"495531", "Holzminden",
"4938856", "Pritzier\ bei\ Hagenow",
"4937600", "Neumark\ Sachsen",
"499642", "Kemnath\ Stadt",
"4935935", "Kleinwelka",
"495606", "Zierenberg",
"494921", "Emden\ Stadt",
"498330", "Legau",
"4939426", "Hessen",
"4939996", "Törpin",
"496442", "Braunfels",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"497738", "Steisslingen",
"495805", "Oetzen",
"4934383", "Trebsen\ Mulde",
"492694", "Wershofen",
"495704", "Petershagen\-Friedewalde",
"495064", "Gross\ Düngen",
"4936021", "Schlotheim",
"4933087", "Bredereiche",
"4933204", "Beelitz\ Mark",
"492336", "Schwelm",
"492844", "Rheinberg\-Orsoy",
"492745", "Brachbach\ Sieg",
"495509", "Rosdorf\ Kreis\ Göttingen",
"497021", "Kirchheim\ unter\ Teck",
"499473", "Kallmünz",
"4935248", "Schönfeld\ bei\ Grossenhain",
"499293", "Berg\ Oberfranken",
"498505", "Hutthurm",
"493529", "Heidenau\ Sachsen",
"497395", "Ehingen\-Dächingen",
"4939747", "Züsedom",
"493869", "Dümmer",
"496673", "Haunetal",
"499548", "Mühlhausen\ Mittelfranken",
"4935476", "Wittmannsdorf\-Bückchen",
"498024", "Holzkirchen",
"4937298", "Oelsnitz\ Erzgebirge",
"497346", "Illerkirchberg",
"4933839", "Wusterwitz",
"493724", "Burgstädt",
"498809", "Wessobrunn",
"4936742", "Uhlstädt",
"497735", "Öhningen",
"494141", "Stade",
"497834", "Wolfach",
"495808", "Gerdau",
"493537", "Jessen\ Elster",
"49971", "Bad\ Kissingen",
"494605", "Medelby",
"4934673", "Heldrungen",
"4933363", "Altenhof\ Kreis\ Barnim",
"494502", "Lübeck\-Travemünde",
"494357", "Sehestedt\ Eider",
"4933978", "Segeletz",
"497445", "Pfalzgrafenweiler",
"496387", "Sankt\ Julian",
"494806", "Sarzbüttel",
"498463", "Greding",
"4935602", "Drebkau",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"494323", "Bornhöved",
"49251", "Münster",
"4936943", "Bettenhausen\ Thüringen",
"4938202", "Volkenshagen",
"498347", "Friesenried",
"4935477", "Rietzneuendorf\-Friedrichshof",
"492941", "Lippstadt",
"4939341", "Redekin",
"492872", "Rhede\ Westfalen",
"49721", "Karlsruhe",
"499267", "Nordhalben",
"494769", "Bremervörde\-Iselersheim",
"499923", "Teisnach",
"4933433", "Buckow\ Märkische\ Schweiz",
"499658", "Georgenberg",
"494488", "Westerstede",
"4938872", "Rehna",
"495371", "Gifhorn",
"494725", "Helgoland",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"4939265", "Löderburg",
"494824", "Krempe",
"499674", "Schönsee",
"4934424", "Reuden\ bei\ Zeitz",
"496474", "Villmar\-Aumenau",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"4939746", "Krackow",
"496294", "Krautheim\ Jagst",
"494564", "Schashagen",
"496458", "Rosenthal\ Hessen",
"499776", "Mellrichstadt",
"4935385", "Annaburg",
"4936940", "Oepfershausen",
"4937324", "Reinsberg\ Sachsen",
"4933638", "Rüdersdorf\ bei\ Berlin",
"497661", "Kirchzarten",
"497154", "Kornwestheim",
"497452", "Nagold",
"498766", "Gammelsdorf",
"495241", "Gütersloh",
"499235", "Thierstein",
"498722", "Gangkofen",
"499560", "Grub\ am\ Forst",
"497333", "Laichingen",
"498664", "Chieming",
"4933924", "Rägelin",
"498151", "Starnberg",
"499820", "Lehrberg",
"499238", "Röslau",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"4939009", "Badel",
"497181", "Schorndorf\ Württemberg",
"493377", "Zossen\ Brandenburg",
"496356", "Carlsberg\ Pfalz",
"495726", "Wiedensahl",
"4933874", "Stechow\ Brandenburg",
"497175", "Leinzell",
"495624", "Bad\ Emstal",
"4938723", "Kladrum",
"499321", "Kitzingen",
"4935452", "Golssen",
"499655", "Tännesberg",
"494485", "Elsfleth\-Huntorf",
"498389", "Weissensberg",
"496821", "Neunkirchen\ Saar",
"4936422", "Reinstädt\ Thüringen",
"4939244", "Steutz",
"499307", "Altertheim",
"499552", "Burghaslach",
"4933086", "Grieben\ Kreis\ Oberhavel",
"4939862", "Schmölln\ bei\ Prenzlau",
"494471", "Cloppenburg",
"499856", "Dürrwangen",
"497931", "Bad\ Mergentheim",
"496561", "Bitburg",
"496455", "Frankenau\ Hessen",
"499143", "Pappenheim\ Mittelfranken",
"493683", "Schmalkalden",
"4937603", "Wildenfels",
"492273", "Kerpen\-Horrem",
"492752", "Bad\ Laasphe",
"49355", "Cottbus",
"496034", "Wöllstadt",
"4939427", "Ströbeck",
"4936734", "Leutenberg",
"4939997", "Jarmen",
"495203", "Werther\ Westfalen",
"492261", "Gummersbach",
"493562", "Forst\ Lausitz",
"497732", "Radolfzell\ am\ Bodensee",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"498323", "Immenstadt\ im\ Allgäu",
"499648", "Neustadt\ am\ Kulm",
"493866", "Cambs",
"4934909", "Aken\ Elbe",
"494463", "Wangerland",
"492951", "Büren",
"4933334", "Greiffenberg",
"497392", "Laupheim",
"496573", "Gillenfeld",
"498806", "Utting\ am\ Ammersee",
"498502", "Fürstenzell",
"493629", "Stadtilm",
"4936081", "Arenshausen",
"49261", "Koblenz\ am\ Rhein",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"496398", "Vorderweidenthal",
"498141", "Fürstenfeldbruck",
"495251", "Paderborn",
"4936602", "Ronneburg\ Thüringen",
"4938780", "Lanz\ Brandenburg",
"4937423", "Adorf\ Vogtland",
"497442", "Baiersbronn",
"497144", "Marbach\ am\ Neckar",
"4939607", "Kotelow",
"495177", "Edemissen\-Abbensen",
"494505", "Stockelsdorf\-Curau",
"495961", "Haselünne",
"492903", "Meschede\-Freienohl",
"494602", "Freienwill",
"492353", "Halver",
"499101", "Langenzenn",
"496735", "Eppelsheim",
"493935", "Tangerhütte",
"496834", "Bous",
"496346", "Annweiler\ am\ Trifels",
"494508", "Krummesse",
"4934604", "Niemberg",
"492327", "Bochum\-Wattenscheid",
"497673", "Schönau\ im\ Schwarzwald",
"494330", "Emkendorf",
"496395", "Münchweiler\ an\ der\ Rodalb",
"495284", "Schwalenberg",
"492432", "Wassenberg",
"4939405", "Hötensleben",
"4938750", "Malliss",
"496021", "Aschaffenburg",
"4938332", "Gross\ Bisdorf",
"496007", "Rosbach\-Rodheim",
"495609", "Ahnatal",
"492742", "Wissen",
"496276", "Hesseneck",
"492301", "Holzwickede",
"4935021", "Königstein\ Sächsische\ Schweiz",
"499153", "Schnaittach",
"495363", "Wolfsburg\-Vorsfelde",
"492984", "Hallenberg",
"4939033", "Wallstawe",
"495802", "Wrestedt",
"499846", "Ipsheim",
"4939456", "Altenbrak",
"496445", "Schöffengrund",
"497387", "Hohenstein\ Württemberg",
"492339", "Sprockhövel\-Hasslinghausen",
"492594", "Dülmen",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"493967", "Oertzenhof\ bei\ Strasburg",
"495631", "Korbach",
"4933231", "Pausin",
"499127", "Rosstal\ Mittelfrankenanken",
"499334", "Giebelstadt",
"4938826", "Dassow",
"499542", "Schesslitz",
"495506", "Adelebsen",
"497458", "Ebhausen",
"4938753", "Wöbbelin",
"495524", "Bad\ Lauterberg\ im\ Harz",
"495447", "Lembruch",
"494934", "Marienhafe",
"497474", "Haigerloch",
"497172", "Lorch\ Württemberg",
"4937384", "Wechselburg",
"495864", "Jameln",
"495765", "Raddestorf",
"499092", "Wemding",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"4935793", "Elstra",
"496359", "Grünstadt",
"498291", "Zusmarshausen",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"49621", "Mannheim",
"499180", "Pyrbaum",
"498728", "Geratskirchen",
"499833", "Heidenheim\ Mittelfranken",
"492755", "Bad\ Berleburg\-Schwarzenau",
"4939457", "Benneckenstein\ Harz",
"498386", "Oberstaufen",
"496333", "Waldfischbach\-Burgalben",
"4936962", "Vacha",
"49365", "Gera",
"4938827", "Kalkhorst",
"493583", "Zittau",
"4939030", "Brunau",
"496154", "Ober\-Ramstadt",
"496452", "Battenberg\ Eder",
"4936701", "Lichte",
"4938462", "Baumgarten",
"497906", "Braunsbach",
"496661", "Schlüchtern",
"4936452", "Berlstedt",
"499555", "Schlüsselfeld\-Aschbach",
"499461", "Roding",
"494482", "Hatten",
"499652", "Waidhaus",
"494184", "Hanstedt\ Nordheide",
"494151", "Schwarzenbek",
"497807", "Neuried\ Ortenaukreis",
"498670", "Reischach\ Kreis\ Altötting",
"495382", "Bad\ Gandersheim",
"493441", "Zeitz",
"494664", "Neukirchen\ bei\ Niebüll",
"496175", "Friedrichsdorf\ Taunus",
"494722", "Cuxhaven\-Altenbruch",
"4936482", "Triptis",
"496181", "Hanau",
"494766", "Basdahl",
"499574", "Marktzeuln",
"497356", "Schemmerhofen",
"4939487", "Friedrichsbrunn",
"492758", "Bad\ Berleburg\-Girkhausen",
"492774", "Dietzhölztal",
"4939295", "Zuchau",
"492676", "Ulmen",
"494277", "Schwaförden",
"494497", "Barssel\-Harkebrügge",
"499779", "Nordheim\ von\ der\ Rhön",
"498564", "Johanniskirchen",
"4939606", "Glienke",
"497034", "Ehningen",
"493391", "Neuruppin",
"498725", "Wurmannsquick",
"494103", "Wedel",
"498824", "Oberau\ Loisach",
"499087", "Marktoffingen",
"499232", "Wunsiedel",
"4938783", "Dallmin",
"498031", "Rosenheim\ Oberbayern",
"497561", "Leutkirch\ im\ Allgäu",
"497455", "Dornhan",
"493731", "Freiberg\ Sachsen",
"497821", "Lahr\ Schwarzwald",
"495768", "Petershagen\-Heimsen",
"493504", "Dippoldiswalde",
"494347", "Flintbek",
"4933674", "Trebatsch",
"4934364", "Wermsdorf",
"494322", "Bordesholm",
"495944", "Hoogstede",
"497977", "Oberrot\ bei\ Gaildorf",
"494366", "Grömitz\-Cismar",
"4934920", "Kropstädt",
"497161", "Göppingen",
"497654", "Löffingen",
"492905", "Bestwig\-Ramsbeck",
"4936841", "Schleusingen",
"4938377", "Zinnowitz",
"494503", "Timmendorfer\ Strand",
"492358", "Meinerzhagen\-Valbert",
"498462", "Berching",
"492374", "Iserlohn\-Letmathe",
"498651", "Bad\ Reichenhall",
"498426", "Walting\ Kreis\ Eichstätt",
"498325", "Oberstaufen\-Thalkirchdorf",
"4939975", "Thürkow",
"498091", "Kirchseeon",
"495205", "Bielefeld\-Sennestadt",
"493663", "Schleiz",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"4938485", "Dabel",
"4937464", "Schöneck\ Vogtland",
"495368", "Parsau",
"499158", "Offenhausen\ Mittelfranken",
"494747", "Beverstedt",
"499472", "Hohenfels\ Oberpfalz",
"499174", "Hilpoltstein",
"499292", "Konradsreuth",
"4938297", "Moitin",
"4939083", "Messdorf",
"496581", "Saarburg",
"496672", "Eiterfeld",
"498369", "Rückholz",
"494465", "Friedeburg\ Ostfriesland",
"494551", "Bad\ Segeberg",
"4939222", "Möser",
"4935697", "Bagenz",
"496575", "Landscheid",
"493331", "Angermünde",
"492244", "Königswinter\-Oberpleis",
"499155", "Simmelsdorf",
"4933979", "Wusterhausen\ Dosse",
"495365", "Wolfsburg\-Neindorf",
"4938455", "Plaaz",
"4939053", "Süplingen",
"498450", "Ingolstadt\-Zuchering",
"496554", "Waxweiler",
"494468", "Friedeburg\-Reepsholt",
"4936465", "Oberndorf\ bei\ Apolda",
"4939825", "Wokuhl",
"4933743", "Blönsdorf",
"498231", "Königsbrunn\ bei\ Augsburg",
"496578", "Salmtal",
"498328", "Balderschwang",
"497720", "Schwenningen\ am\ Neckar",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"4934203", "Zwenkau",
"499287", "Selb",
"492621", "Lahnstein",
"492456", "Selfkant",
"495329", "Schulenberg\ im\ Oberharz",
"495208", "Leopoldshöhe",
"497234", "Tiefenbronn",
"496443", "Ehringshausen\ Dill",
"498684", "Fridolfing",
"4935249", "Basslitz",
"492355", "Schalksmühle",
"494206", "Stuhr\-Heiligenrode",
"493933", "Genthin",
"4934261", "Kühren\ bei\ Wurzen",
"492607", "Kobern\-Gondorf",
"496733", "Gau\-Odernheim",
"4934345", "Bad\ Lausick",
"497681", "Waldkirch\ Breisgau",
"4933838", "Päwesin",
"4938352", "Kemnitz\ bei\ Greifswald",
"4937342", "Cranzahl",
"495422", "Melle",
"497675", "Bernau\ Baden",
"497572", "Mengen\ Württemberg",
"495466", "Merzen",
"496393", "Fischbach\ bei\ Dahn",
"495337", "Kissenbrück",
"493946", "Quedlinburg",
"499527", "Knetzgau",
"496746", "Pfalzfeld",
"493682", "Zella\-Mehlis",
"499444", "Siegenburg",
"499199", "Kunreuth",
"499142", "Treuchtlingen",
"493585", "Löbau",
"496644", "Grebenhain",
"492753", "Erndtebrück",
"499867", "Geslau",
"4935754", "Klettwitz",
"49781", "Offenburg",
"492272", "Bedburg\ Erft",
"493571", "Hoyerswerda",
"492449", "Blankenheim\ Ahr",
"496335", "Trulben",
"499553", "Ebrach\ Oberfranken",
"4938848", "Vellahn",
"494224", "Gross\ Ippener",
"495051", "Bergen\ Kreis\ Celle",
"4939050", "Bartensleben",
"496894", "St\ Ingbert",
"4938794", "Cumlosen",
"495763", "Uchte",
"495691", "Bad\ Arolsen",
"4936335", "Grosswechsungen",
"499394", "Esselbach",
"4938733", "Karbow\-Vietlübbe",
"492534", "Münster\-Roxel",
"494108", "Rosengarten\ Kreis\ Harburg",
"496436", "Dornburg\ Hessen",
"4939366", "Kehnert",
"495841", "Lüchow\ Wendland",
"499835", "Ehingen\ Mittelfranken",
"499734", "Burkardroth",
"499220", "Kasendorf\-Azendorf",
"492739", "Wilnsdorf",
"499636", "Plössberg",
"494105", "Seevetal",
"498723", "Arnstorf",
"4938376", "Zirchow",
"497427", "Schömberg\ bei\ Balingen",
"497332", "Lauterstein",
"497544", "Markdorf",
"4934923", "Cobbelsdorf",
"497453", "Altensteig\ Württemberg",
"4934493", "Gössnitz\ Thüringen",
"496207", "Wald\-Michelbach",
"4935205", "Ottendorf\-Okrilla",
"498541", "Vilshofen\ Niederbayern",
"4938296", "Rerik\ Ostseebad",
"496500", "Waldrach",
"498404", "Oberdolling",
"498102", "Höhenkirchen\-Siegertsbrunn",
"496221", "Heidelberg",
"4939080", "Kalbe\ Milde",
"495084", "Hambühren",
"4935696", "Briesnig",
"496173", "Kronberg\ im\ Taunus",
"493998", "Demmin",
"499256", "Stammbach",
"493588", "Niesky",
"4934722", "Preusslitz",
"493847", "Sternberg",
"4939008", "Kunrau",
"494641", "Süderbrarup",
"493464", "Sangerhausen",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"499922", "Zwiesel",
"492873", "Isselburg\-Werth",
"496338", "Hornbach\ Pfalz",
"499966", "Wiesenfelden",
"492861", "Borken\ Westfalen",
"495803", "Rosche",
"4936925", "Marksuhl",
"49760", "Oberried\ Breisgau",
"499543", "Hirschaid",
"4935955", "Pulsnitz",
"495041", "Springe\ Deister",
"492521", "Beckum",
"498206", "Egling\ an\ der\ Paar",
"492743", "Daaden",
"496654", "Gersfeld\ Rhön",
"499721", "Schweinfurt",
"496161", "Brensbach",
"4939855", "Parmen\-Weggun",
"496678", "Wildeck\-Hönebach",
"495326", "Langelsheim",
"496756", "Winterbach\ Soonwald",
"4934776", "Rothenschirmbach",
"499454", "Aufhausen\ Oberpfalz",
"494684", "Langeness\ Hallig",
"499152", "Hartenstein\ Mittelfranken",
"495362", "Wolfsburg\-Fallersleben",
"4938425", "Kirchdorf\ Poel",
"497575", "Messkirch",
"492433", "Hückelhoven",
"496094", "Weibersbrunn",
"495425", "Borgholzhausen",
"4939397", "Geestgottberg",
"497672", "St\ Blasien",
"4935362", "Schönewalde\ bei\ Herzberg",
"4938322", "Richtenberg",
"497581", "Saulgau",
"494209", "Schwanewede",
"494328", "Rickling",
"4934291", "Borsdorf",
"495851", "Dahlenburg",
"4933603", "Falkenhagen\ bei\ Seelow",
"494231", "Verden\ Aller",
"498468", "Altmannstein\-Pondorf",
"492507", "Havixbeck",
"492352", "Altena\ Westfalen",
"4934651", "Rossla",
"498584", "Breitenberg\ Niederbayern",
"4933847", "Görzke",
"496234", "Mutterstadt",
"497443", "Dornstetten",
"4937433", "Gutenfürst",
"498551", "Freyung",
"498465", "Kipfenberg",
"4935841", "Grossschönau\ Sachsen",
"494603", "Havetoft",
"492902", "Warstein",
"49491", "Leer\ Ostfriesland",
"497578", "Wald\ Hohenz",
"497554", "Heiligenberg\ Baden",
"499376", "Collenberg",
"495428", "Melle\-Neuenkirchen",
"495771", "Rahden\ Westfalen",
"498170", "Strasslach\-Dingharting",
"493306", "Gransee",
"496572", "Manderscheid\ Eifel",
"499481", "Pfatter",
"497393", "Munderkingen",
"494426", "Wangerland\-Horumersiel",
"492360", "Haltern\-Lippramsdorf",
"4939885", "Jakobshagen",
"496675", "Breitenbach\ am\ Herzberg",
"494462", "Wittmund",
"494164", "Harsefeld",
"4936875", "Straufhain\-Streufdorf",
"499295", "Töpen",
"496681", "Hilders",
"498503", "Neuhaus\ am\ Inn",
"496876", "Weiskirchen\ Saar",
"497733", "Engen\ Hegau",
"493563", "Spremberg",
"499246", "Pegnitz\-Trockau",
"4939728", "Medow\ bei\ Anklam",
"4937360", "Olbernhau",
"495202", "Oerlinghausen",
"498366", "Oy\-Mittelberg",
"4936257", "Luisenthal\ Thüringen",
"498322", "Oberstdorf",
"49211", "Düsseldorf",
"498641", "Grassau\ Kreis\ Traunstein",
"4934953", "Gräfenhainichen",
"4936205", "Gräfenroda",
"495264", "Kalletal",
"49681", "Saarbrücken",
"497335", "Wiesensteig",
"495677", "Calden\-Westuffeln",
"4933762", "Zeuthen",
"497644", "Kenzingen",
"495978", "Hörstel\-Dreierwalde",
"499233", "Arzberg\ Oberfranken",
"4934463", "Bad\ Kösen",
"4937430", "Eichigt",
"494102", "Ahrensburg",
"497746", "Wutöschingen",
"494404", "Elsfleth",
"495954", "Lorup",
"494541", "Ratzeburg",
"493987", "Templin",
"496787", "Niederbrombach",
"492254", "Weilerswist",
"4936784", "Stützerbach",
"499925", "Bayerisch\ Eisenstein",
"499148", "Ettenstatt",
"4937363", "Zöblitz",
"4939774", "Mönkebude",
"49931", "Würzburg",
"4936256", "Wechmar",
"494976", "Spiekeroog",
"497367", "Aalen\-Ebnat",
"4937755", "Schönheide\ Erzgebirge",
"497436", "Messstetten\-Oberdigisheim",
"494757", "Wanna",
"495383", "Lutter\ am\ Barenberge",
"492964", "Brilon\-Alme",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"498105", "Gilching",
"494723", "Cuxhaven\-Altenwalde",
"493949", "Oschersleben\ Bode",
"496453", "Gemünden\ Wohra",
"495109", "Ronnenberg",
"499196", "Wiesenttal",
"499653", "Eslarn",
"494483", "Ovelgönne\-Grossenmeer",
"492446", "Heimbach\ Eifel",
"492275", "Kerpen\-Buir",
"4935724", "Lohsa",
"496332", "Zweibrücken",
"496544", "Rhaunen",
"499928", "Kirchdorf\ im\ Wald",
"493886", "Gadebusch",
"496427", "Cölbe\-Schönstadt",
"493671", "Saalfeld\ Saale",
"499627", "Freudenberg\ Oberpfalz",
"494877", "Hennstedt\ bei\ Itzehoe",
"499145", "Solnhofen",
"4934782", "Mansfeld\ Südharz",
"495131", "Garbsen",
"493685", "Hildburghausen",
"495304", "Meine",
"499536", "Kirchlauter",
"4933846", "Dippmannsdorf",
"499832", "Wassertrüdingen",
"495975", "Rheine\-Mesum",
"496401", "Grünberg\ Hessen",
"498224", "Offingen\ Donau",
"497173", "Heubach",
"496439", "Holzappel",
"4939396", "Neukirchen\ Altmark",
"492634", "Rengsdorf",
"499093", "Polsingen",
"492736", "Burbach\ Siegerl",
"4937204", "Lichtenstein\ Sachsen",
"497221", "Baden\-Baden",
"499639", "Mähring",
"496223", "Neckargemünd",
"499468", "Zell\ Oberpfalz",
"4933366", "Chorin",
"496185", "Hammersbach\ Hessen",
"4935209", "Mohorn",
"498067", "Tuntenhausen",
"495372", "Meinersen",
"494155", "Büchen",
"496668", "Birstein\-Lichenroth",
"494893", "Hohenaspe",
"493445", "Naumburg\ Saale",
"496171", "Oberursel\ Taunus",
"496257", "Seeheim\-Jugenheim",
"493496", "Köthen\ Anhalt",
"497403", "Dunningen",
"498707", "Adlkofen",
"494643", "Gelting\ Angeln",
"4936946", "Erbenhausen\ Thüringen",
"494287", "Heeslingen\-Boitzen",
"492942", "Geseke",
"492686", "Weyerbusch",
"492871", "Bocholt",
"498721", "Eggenfelden",
"497529", "Waldburg\ Württemberg",
"499206", "Mistelgau\-Obernsees",
"4939740", "Nechlin",
"495242", "Rheda\-Wiedenbrück",
"498454", "Karlshuld",
"496550", "Irrhausen",
"498152", "Herrsching\ am\ Ammersee",
"499077", "Bachhagel",
"4933703", "Sperenberg",
"493395", "Pritzwalk",
"497825", "Kippenheim",
"493346", "Seelow",
"497724", "St\ Georgen\ im\ Schwarzwald",
"4935473", "Neu\ Lübbenau",
"4934243", "Bad\ Düben",
"4933437", "Reichenberg\ bei\ Strausberg",
"498035", "Raubling",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"497626", "Kandern",
"497451", "Horb\ am\ Neckar",
"493735", "Marienberg\ Sachsen",
"498543", "Aidenbach",
"493834", "Greifswald",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"4938853", "Drönnewitz\ bei\ Hagenow",
"498246", "Waal",
"496637", "Feldatal",
"495693", "Volkmarsen",
"495761", "Stolzenau",
"497484", "Simmersfeld",
"497182", "Welzheim",
"4939423", "Wegeleben",
"4939993", "Hohenmocker",
"497568", "Bad\ Wurzach\-Hauerz",
"498038", "Vogtareuth",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"4937607", "Ebersbrunn\ Sachsen",
"499366", "Geroldshausen\ Unterfranken",
"495156", "Coppenbrügge",
"4935893", "Mücka",
"499170", "Schwanstetten",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"495843", "Wustrow\ Wendland",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"499503", "Oberhaid\ Oberfranken",
"4935388", "Klöden",
"498295", "Altenmünster\ Schwaben",
"4934781", "Greifenhagen",
"498376", "Sulzberg\ Allgäu",
"492424", "Vettweiss",
"492166", "Mönchengladbach\-Rheydt",
"495027", "Linsburg",
"496629", "Schenklengsfeld",
"492547", "Rosendahl\-Osterwick",
"4939268", "Egeln",
"4938727", "Mestlin",
"492751", "Bad\ Berleburg",
"499429", "Rain\ Niederbayern",
"493573", "Senftenberg",
"499551", "Burgwindheim",
"499465", "Neukirchen\-Balbini",
"495053", "Fassberg\-Müden",
"496866", "Perl\-Nennig",
"496188", "Kahl\ am\ Main",
"496562", "Speicher",
"494158", "Roseburg",
"494174", "Stelle\ Kreis\ Harburg",
"499747", "Geroda\ Bayern",
"494472", "Lastrup",
"494249", "Bassum\-Nordwohlde",
"494292", "Ritterhude",
"497932", "Niederstetten\ Württemberg",
"493448", "Meuselwitz\ Thüringen",
"4939934", "Gross\ Plasten",
"496665", "Sinntal\-Altengronau",
"496526", "Bollendorf",
"496504", "Thalfang",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"499105", "Grosshabersdorf",
"496731", "Alzey",
"494838", "Tellingstedt",
"493931", "Stendal",
"497683", "Simonswald",
"4939829", "Blankenförde",
"493909", "Klötze\ Altmark",
"495258", "Salzkotten",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"495494", "Holdorf\ Niedersachsen",
"495192", "Munster",
"495149", "Wienhausen",
"495274", "Nieheim",
"497247", "Linkenheim\-Hochstetten",
"4938459", "Laage",
"4935032", "Langenhennersdorf",
"498259", "Schiltberg",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"4937606", "Lengenfeld\ Vogtland",
"492406", "Herzogenrath",
"496391", "Dahn",
"49831", "Kempten\ Allgäu",
"4938850", "Gammelin",
"492305", "Castrop\-Rauxel",
"4935361", "Schlieben",
"492657", "Uersfeld",
"494256", "Hilgermissen",
"492958", "Büren\-Harth",
"496286", "Walldürn\-Rippberg",
"4934292", "Brandis\ bei\ Wurzen",
"4938321", "Martensdorf\ bei\ Stralsund",
"498233", "Kissing",
"4937295", "Lugau\ Erzgebirge",
"492974", "Schmallenberg\-Fredeburg",
"495635", "Vöhl",
"499641", "Grafenwöhr",
"4934652", "Allstedt",
"494922", "Borkum",
"495344", "Lengede",
"492623", "Ransbach\-Baumbach",
"495532", "Stadtoldendorf",
"494966", "Neubörger",
"492268", "Kürten",
"495836", "Wittingen\-Radenbeck",
"4935245", "Burkhardswalde\-Munzig",
"496441", "Wetzlar",
"4938726", "Spornitz",
"4938224", "Gresenhorst",
"498093", "Glonn\ Kreis\ Ebersberg",
"494527", "Bosau",
"492265", "Reichshof\-Eckenhagen",
"498639", "Neumarkt\-Sankt\ Veit",
"4936947", "Jüchsen",
"4935842", "Oderwitz",
"495937", "Geeste\-Gross\ Hesepe",
"497706", "Oberbaldingen",
"4935264", "Strehla",
"493661", "Greiz",
"494444", "Goldenstedt",
"494142", "Steinkirchen\ Kreis\ Stade",
"497066", "Bad\ Rappenau\-Bonfeld",
"498536", "Kösslarn",
"492308", "Unna\-Hemmerde",
"497022", "Nürtingen",
"4933367", "Friedrichswalde\ Brandenburg",
"496583", "Palzem",
"494553", "Geschendorf",
"4935938", "Grosspostwitz\ OL",
"492955", "Büren\-Wewelsburg",
"495255", "Altenbeken",
"496028", "Sulzbach\ am\ Main",
"497163", "Ebersbach\ an\ der\ Fils",
"494539", "Westerau",
"4933436", "Prötzel",
"494394", "Bokhorst",
"498145", "Mammendorf",
"494501", "Kastorf\ Holstein",
"4936374", "Weissensee",
"495965", "Klein\ Berssen",
"498196", "Pürgen",
"495187", "Delligsen",
"492237", "Kerpen\ Rheinland\-Türnich",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"494636", "Langballig",
"4939743", "Zerrenthin",
"494835", "Albersdorf\ Holstein",
"4939384", "Arendsee\ Altmark",
"494734", "Stadland\-Seefeld",
"498292", "Dinkelscherben",
"498249", "Ettringen\ Wertach",
"495036", "Neustadt\-Schneeren",
"499603", "Floss",
"492364", "Haltern\ Westfalen",
"498158", "Tutzing",
"495248", "Langenberg\ Kreis\ Gütersloh",
"497257", "Bruchsal\-Untergrombach",
"499369", "Uettingen",
"496403", "Linden\ Hessen",
"4939036", "Binde",
"495159", "Coppenbrügge\-Bisperode",
"497668", "Ihringen",
"497171", "Schwäbisch\ Gmünd",
"4939453", "Derenburg",
"499325", "Kleinlangheim",
"495593", "Bovenden\-Lenglern",
"49991", "Deggendorf",
"497967", "Jagstzell",
"4938823", "Selmsdorf",
"497223", "Bühl\ Baden",
"499091", "Monheim\ Schwaben",
"494475", "Molbergen",
"498379", "Waltenhofen\-Oberdorf",
"494295", "Emtinghausen",
"497935", "Schrozberg",
"496626", "Wildeck\-Obersuhl",
"4935797", "Schwepnitz",
"496565", "Dudeldorf",
"496451", "Frankenberg\ Eder",
"495378", "Sassenburg\-Platendorf",
"4939298", "Barby\ Elbe",
"499426", "Oberschneiding",
"499651", "Vohenstrauss",
"494481", "Hatten\-Sandkrug",
"496825", "Illingen\ Saar",
"499462", "Falkenstein\ Oberpfalz",
"496724", "Stromberg\ Hunsrück",
"499164", "Langenfeld\ Mittelfranken",
"495354", "Jerxheim",
"492948", "Lippstadt\-Rebbeke",
"496869", "Merzig\-Silwingen",
"4938757", "Neustadt\-Glewe",
"494246", "Twistringen\-Heiligenloh",
"492647", "Kesseling",
"492945", "Lippstadt\-Benninghausen",
"4933396", "Klosterfelde",
"494543", "Nusse",
"4938787", "Glöwen",
"492586", "Beelen",
"495381", "Seesen",
"497938", "Mulfingen\ Jagst",
"494298", "Lilienthal",
"494478", "Cappeln\ Oldenburg",
"494454", "Jade",
"494152", "Geesthacht",
"496568", "Wolsfeld",
"495904", "Lengerich\ Emsl",
"496182", "Seligenstadt",
"496484", "Beselich",
"495375", "Müden\ Aller",
"494721", "Cuxhaven",
"492689", "Dierdorf",
"4936209", "Klettbach",
"4939600", "Zwiedorf",
"497665", "March\ Breisgau",
"499209", "Emtmannsberg",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"494707", "Langen\-Neuenwalde",
"497562", "Isny\ im\ Allgäu",
"495476", "Ostercappeln\-Venne",
"4939483", "Ballenstedt",
"497822", "Ettenheim",
"492204", "Bensberg",
"496650", "Hosenfeld",
"4934721", "Nienburg\ Saale",
"499231", "Marktredwitz",
"495245", "Herzebrock\-Clarholz",
"497629", "Tegernau\ Baden",
"4939603", "Burg\ Stargard",
"497391", "Ehingen\ Donau",
"498734", "Reisbach\ Niederbayern",
"495300", "Salzgitter\-Üfingen",
"492952", "Rüthen",
"497025", "Neuffen",
"498636", "Ampfing",
"496247", "Worms\-Pfeddersheim",
"496683", "Ehrenberg\ Rhön",
"498501", "Thyrnau",
"497709", "Wutach",
"494627", "Dörpstedt",
"497731", "Singen\ Hohentwiel",
"498394", "Lautrach",
"4936624", "Teichwolframsdorf",
"492226", "Rheinbach",
"4936842", "Oberhof\ Thüringen",
"4933397", "Wandlitz",
"492630", "Mülheim\-Kärlich",
"493561", "Guben",
"492262", "Wiehl",
"49541", "Osnabrück",
"493821", "Ribnitz\-Damgarten",
"494928", "Ihlow\-Riepe",
"497504", "Horgenzell",
"497441", "Freudenstadt",
"494832", "Meldorf",
"498553", "Spiegelau",
"4939408", "Hadmersleben",
"495926", "Engden",
"495962", "Herzlake",
"494536", "Steinhorst\ Lauenburg",
"498444", "Schweitenkirchen",
"498142", "Olching",
"4934327", "Waldheim\ Sachsen",
"494639", "Schafflund",
"495773", "Stemwede\-Wehdem",
"495198", "Schneverdingen\-Wintermoor",
"495252", "Bad\ Lippspringe",
"4939221", "Möckern\ bei\ Magdeburg",
"4939889", "Boitzenburg",
"498867", "Rottenbuch\ Oberbayern",
"4934441", "Hohenmölsen",
"492431", "Erkelenz",
"4938429", "Glasin",
"496022", "Obernburg\ am\ Main",
"495195", "Neuenkirchen\ bei\ Soltau",
"497583", "Bad\ Schussenried",
"495853", "Neu\ Darchau",
"4939859", "Fürstenwerder",
"496066", "Michelstadt\-Vielbrunn",
"494233", "Blender",
"4939324", "Kläden\ bei\ Stendal",
"496706", "Wallhausen\ Nahe",
"4936929", "Ruhla",
"495146", "Wietze",
"499404", "Nittendorf",
"499102", "Wilhermsdorf",
"4939037", "Pretzier",
"492409", "Stolberg\-Gressenich",
"495827", "Unterlüss",
"494148", "Drochtersen\-Assel",
"4938756", "Grabow",
"49431", "Kiel",
"499976", "Rötz",
"492863", "Velen",
"4936766", "Schalkau",
"495535", "Polle",
"4934262", "Falkenhain\ bei\ Wurzen",
"495632", "Willingen\ Upland",
"492523", "Wadersloh",
"495043", "Lauenau",
"494925", "Hinte",
"4938351", "Mesekenhagen",
"4935796", "Panschwitz\-Kuckau",
"492741", "Betzdorf",
"4937341", "Ehrenfriedersdorf",
"496163", "Höchst\ im\ Odenwald",
"499723", "Röthlein",
"495839", "Wittingen\-Ohrdorf",
"492557", "Wettringen\ Kreis\ Steinfurt",
"492302", "Witten",
"495052", "Hermannsburg",
"492157", "Nettetal\-Kaldenkirchen",
"497933", "Creglingen",
"4939924", "Stuer",
"494473", "Emstek",
"494293", "Ottersberg\-Fischerhude",
"4939005", "Kusey",
"496563", "Kyllburg",
"499141", "Weissenburg\ in\ Bayern",
"495135", "Burgwedel\-Fuhrberg",
"493681", "Suhl",
"493876", "Perleberg",
"496857", "Namborn",
"492271", "Bergheim\ Erft",
"496306", "Trippstadt",
"493675", "Sonneberg\ Thüringen",
"4938737", "Ganzlin",
"495842", "Schnega",
"4936961", "Bad\ Liebenstein",
"495971", "Rheine",
"4935208", "Radeburg",
"496405", "Laubach\ Hessen",
"4939056", "Klüden",
"49471", "Bremerhaven",
"499605", "Weiherhammer",
"4933746", "Werbig\ bei\ Jüterbog",
"499502", "Frensdorf",
"499357", "Gräfendorf\ Bayern",
"495167", "Walsrode\-Westenholz",
"497269", "Sulzfeld\ Baden",
"495546", "Scheden",
"498020", "Weyarn",
"497183", "Rudersberg\ Württemberg",
"4934206", "Rötha",
"496047", "Altenstadt\ Hessen",
"4938461", "Bützow",
"497225", "Gaggenau",
"495692", "Wolfhagen",
"4936702", "Lauscha",
"499323", "Iphofen",
"4936451", "Buttelstedt",
"497959", "Frankenhardt",
"497228", "Forbach",
"497309", "Weissenhorn",
"498846", "Uffing\ am\ Staffelsee",
"498334", "Bad\ Grönenbach",
"497663", "Eichstetten",
"498542", "Ortenburg",
"4936481", "Neustadt\ an\ der\ Orla",
"495060", "Bodenburg",
"494136", "Scharnebeck",
"4939086", "Jävenitz",
"499907", "Zenting",
"496408", "Buseck",
"497331", "Geislingen\ an\ der\ Steige",
"499608", "Kohlberg\ Oberpfalz",
"4936076", "Niederorschel",
"4936338", "Bleicherode",
"498153", "Wessling",
"495138", "Sehnde",
"497402", "Fluorn\-Winzeln",
"498056", "Eggstätt",
"498139", "Röhrmoos",
"494545", "Seedorf\ Lauenburg",
"492943", "Erwitte",
"494642", "Kappeln\ Schlei",
"499921", "Regen",
"4934927", "Globig\-Bleddin",
"4934497", "Langenleuba\-Niederhain",
"4938845", "Kaarssen",
"495373", "Hillerse\ Kreis\ Gifhorn",
"496266", "Hassmersheim",
"4935974", "Hinterhermsdorf",
"496222", "Wiesloch",
"4938370", "Kröslin",
"494849", "Hooge",
"494892", "Schenefeld\ Mittelholstein",
"4935389", "Holzdorf\ Elster",
"4939087", "Jerchel\ Altmark",
"4938293", "Kühlungsborn\ Ostseebad",
"4939204", "Niederndodeleben",
"494238", "Neddenaverbergen",
"498652", "Berchtesgaden",
"4935693", "Lauschütz",
"4933835", "Golzow\ bei\ Brandenburg",
"4936077", "Grossbodungen",
"4934348", "Frohburg",
"498555", "Perlesreut",
"498461", "Beilngries",
"495775", "Diepenau",
"495874", "Soltendieck",
"495858", "Hitzacker\-Wietzetze",
"499386", "Prosselsheim",
"494321", "Neumünster",
"497126", "Burladingen\-Melchingen",
"4936082", "Ershausen",
"497162", "Süssen",
"497464", "Talheim\ Kreis\ Tuttlingen",
"4940", "Hamburg",
"499471", "Burglengenfeld",
"494856", "Kronprinzenkoog",
"497023", "Weilheim\ an\ der\ Teck",
"496582", "Freudenburg",
"4938373", "Katzow",
"4936601", "Hermsdorf\ Thüringen",
"493332", "Schwedt\/Oder",
"493544", "Luckau\ Brandenburg",
"494552", "Leezen",
"494307", "Raisdorf",
"499728", "Wülfershausen\ Unterfranken",
"492528", "Ennigerloh\-Enniger",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"4938234", "Born\ Darss",
"4934926", "Pretzsch\ Elbe",
"4934496", "Nöbdenitz",
"494143", "Drochtersen",
"4938458", "Zehna",
"495236", "Blomberg\-Grossenmarpe",
"498092", "Grafing\ bei\ München",
"492622", "Bendorf\ am\ Rhein",
"496597", "Jünkerath",
"495533", "Bodenwerder",
"494267", "Lauenbrück",
"494923", "Krummhörn\-Pewsum",
"496129", "Schlangenbad",
"495045", "Springe\-Bennigsen",
"492666", "Freilingen\ Westerwald",
"492525", "Beckum\-Neubeckum",
"4938736", "Goldberg",
"492865", "Raesfeld",
"497150", "Korntal\-Münchingen",
"4938488", "Demen",
"492764", "Welschen\ Ennest",
"4939363", "Angern",
"494957", "Detern",
"499564", "Bad\ Rodach",
"4939978", "Gross\ Roge",
"495407", "Wallenhorst",
"494776", "Osten\-Altendorf",
"4938331", "Rakow\ Vorpom",
"498232", "Schwabmünchen",
"499725", "Poppenhausen\ Unterfranken",
"496165", "Breuberg",
"499824", "Dietenhofen",
"494674", "Ockholm",
"495193", "Schneverdingen",
"4934207", "Zwochau",
"497585", "Ostrach",
"495754", "Extertal\-Bremke",
"497946", "Bretzfeld",
"496324", "Hassloch",
"497682", "Elzach",
"495855", "Nahrendorf",
"497571", "Sigmaringen",
"49381", "Rostock",
"495656", "Waldkappel",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"4935022", "Bad\ Schandau",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"492837", "Weeze",
"498574", "Wittibreut",
"494235", "Langwedel\-Etelsen",
"4935939", "Hochkirch",
"4933747", "Marzahna",
"498558", "Hohenau\ Niederbayern",
"4933232", "Brieselang",
"497306", "Vöhringen\ Iller",
"494101", "Pinneberg",
"4939342", "Gladau",
"495848", "Trebel",
"4933967", "Freyenstein",
"498642", "Übersee",
"497563", "Kisslegg",
"498033", "Oberaudorf",
"4933457", "Altreetz",
"496086", "Grävenwiesbach",
"494139", "Hohnstorf\ Elbe",
"498545", "Hofkirchen\ Bayern",
"492590", "Dülmen\-Buldern",
"4938871", "Mühlen\ Eichsen",
"493733", "Annaberg\-Buchholz",
"497823", "Seelbach\ Schutter",
"4937367", "Lengefeld\ Erzgebirge",
"494153", "Lauenburg\ Elbe",
"494794", "Worpswede\-Ostersode",
"4937436", "Weischlitz",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"498136", "Markt\ Indersdorf",
"495074", "Rodewald",
"4934467", "Eckartsberga",
"496183", "Erlensee",
"492297", "Wildbergerhütte",
"496269", "Gundelsheim\ Württemberg",
"494127", "Westerhorn",
"494334", "Bredenbek\ bei\ Rendsburg",
"494542", "Mölln\ Lauenburg",
"493578", "Kamenz",
"494846", "Hattstedt",
"493672", "Rudolstadt",
"496331", "Pirmasens",
"4936642", "Harra",
"4939390", "Iden",
"495434", "Essen\ Oldenburg",
"493581", "Görlitz",
"494947", "Aurich\-Ogenbargen",
"495132", "Lehrte",
"4935329", "Dollenchen",
"4933606", "Müllrose",
"49871", "Landshut",
"4939954", "Stavenhagen\ Reuterstadt",
"496663", "Steinau\ an\ der\ Strasse",
"493991", "Waren\ Müritz",
"496228", "Schönau\ Odenwald",
"499463", "Wald\ Oberpfalz",
"495055", "Fassberg",
"4936421", "Camburg",
"4939861", "Gramzow\ bei\ Prenzlau",
"4935451", "Dahme\ Brandenburg",
"498548", "Vilshofen\-Sandbach",
"492804", "Xanten\-Marienbaum",
"497222", "Rastatt",
"495695", "Twistetal",
"497266", "Kirchardt",
"495592", "Gleichen\-Bremke",
"499505", "Litzendorf",
"499602", "Neustadt\ an\ der\ Waldnaab",
"492065", "Duisburg\-Rheinhausen",
"498293", "Welden\ bei\ Augsburg",
"4933472", "Golzow\ bei\ Seelow",
"495646", "Willebadessen",
"496402", "Hungen",
"496104", "Heusenstamm",
"4936208", "Ermstedt",
"4934773", "Schwittersdorf",
"499831", "Gunzenhausen",
"497777", "Sauldorf",
"495845", "Bergen\ Dumme",
"495744", "Hüllhorst",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"496464", "Angelburg",
"499722", "Werneck",
"496162", "Reinheim\ Odenwald",
"4939409", "Eilsleben",
"494558", "Todesfelde",
"499766", "Grosswenkheim",
"493338", "Bernau\ Brandenburg",
"496126", "Idstein",
"4933607", "Briesen\ Mark",
"499151", "Hersbruck",
"4933843", "Niemegk",
"495361", "Wolfsburg",
"492303", "Unna",
"496588", "Pluwig",
"499664", "Hahnbach",
"492862", "Südlohn",
"4939393", "Werben\ Elbe",
"492826", "Kranenburg\ Niederrhein",
"4936878", "Oberland",
"499277", "Warmensteinach",
"494779", "Freiburg\ Elbe",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"4938304", "Garz\ Rügen",
"4934632", "Mücheln\ Geiseltal",
"495042", "Bad\ Münder\ am\ Deister",
"496697", "Willingshausen",
"495633", "Diemelsee",
"4939888", "Lychen",
"492522", "Oelde",
"492566", "Legden",
"492625", "Ochtendung",
"499103", "Cadolzburg",
"492351", "Lüdenscheid",
"497949", "Pfedelbach\-Untersteinbach",
"494232", "Langwedel\ Kreis\ Verden",
"495659", "Ringgau",
"496057", "Flörsbachtal",
"4935052", "Kipsdorf\ Kurort",
"497671", "Todtnau",
"492770", "Eschenburg",
"495556", "Lindau\ Harz",
"4936022", "Grossengottern",
"499347", "Wittighausen",
"498267", "Dirlewang",
"497685", "Gutach\-Bleibach",
"495852", "Bleckede",
"496023", "Alzenau\ in\ Unterfranken",
"497582", "Bad\ Buchau",
"497165", "Göppingen\-Hohenstaufen",
"492850", "Rees\-Haldern",
"4933456", "Wriezen",
"498143", "Inning\ am\ Ammersee",
"4937366", "Rübenau",
"4934905", "Wörlitz",
"495253", "Bad\ Driburg",
"4936253", "Georgenthal\ Thüringer\ Wald",
"495772", "Espelkamp",
"498552", "Grafenau\ Niederbayern",
"496150", "Weiterstadt",
"4936693", "Crossen\ an\ der\ Elster",
"4936741", "Bad\ Blankenburg",
"494833", "Wesselburen",
"4933966", "Dranse",
"497129", "Lichtenstein\ Württemberg",
"495963", "Bawinkel",
"498856", "Penzberg",
"492384", "Welver",
"494180", "Königsmoor",
"4938428", "Hohenkirchen\ bei\ Wismar",
"492263", "Engelskirchen",
"492927", "Neuengeseke",
"494859", "Windbergen",
"498095", "Aying",
"495520", "Braunlage",
"495201", "Halle\ Westfalen",
"4934956", "Zörbig",
"4969", "Frankfurt\ am\ Main",
"4933094", "Löwenberg",
"4939858", "Bietikow",
"498321", "Sonthofen",
"492628", "Rhens",
"492953", "Wünnenberg",
"4935601", "Peitz",
"4937437", "Bad\ Elster",
"493644", "Apolda",
"494461", "Jever",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"4935775", "Pechern",
"496571", "Wittlich",
"498238", "Gessertshausen",
"493335", "Finowfurt",
"4936928", "Neuenhof\ Thüringen",
"499482", "Wörth\ an\ der\ Donau",
"499184", "Deining\ Oberpfalz",
"4934466", "Janisroda",
"497324", "Herbrechtingen",
"496682", "Tann\ Rhön",
"4938201", "Gelbensande",
"498046", "Bad\ Heilbrunn",
"496585", "Ralingen",
"492627", "Braubach",
"496592", "Daun",
"497373", "Zwiefalten",
"499281", "Hof\ Saale",
"496695", "Jesberg",
"494630", "Barderup",
"494262", "Visselhövede",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"4937432", "Pausa\ Vogtland",
"499275", "Speichersdorf",
"499495", "Breitenbrunn\ Oberpfalz",
"492928", "Soest\-Ostönnen",
"4935828", "Reichenbach\ OL",
"496744", "Oberwesel",
"492653", "Kaisersesch",
"497138", "Schwaigern",
"493944", "Blankenburg\ Harz",
"499446", "Altmannstein",
"494952", "Rhauderfehn",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"4939928", "Möllenhagen",
"498237", "Aindling",
"496646", "Grebenau",
"498082", "Schwindegg",
"492196", "Wermelskirchen",
"496434", "Bad\ Camberg",
"496132", "Ingelheim\ am\ Rhein",
"4939346", "Tucheim",
"497243", "Ettlingen",
"499736", "Oberthulba",
"498265", "Pfaffenhausen\ Schwaben",
"492639", "Anhausen\ Kreis\ Neuwied",
"499345", "Külsheim\ Baden",
"495331", "Wolfenbüttel",
"499634", "Wiesau",
"492832", "Kevelaer",
"496055", "Freigericht",
"4939741", "Jatznick",
"499396", "Urspringen\ bei\ Lohr",
"495228", "Vlotho\-Exter",
"495309", "Lehre\-Wendhausen",
"492601", "Nauort",
"495663", "Spangenberg",
"4935204", "Wilsdruff",
"4933051", "Nassenheide",
"492536", "Münster\-Albachten",
"492233", "Hürth\ Rheinland",
"495183", "Lamspringe",
"496058", "Gründau",
"495225", "Spenge",
"496074", "Rödermark",
"4936334", "Wolkramshausen",
"498657", "Ramsau\ bei\ Berchtesgaden",
"4935057", "Hermsdorf\ Erzgebirge",
"494409", "Westerstede\-Ocholt",
"493329", "Stahnsdorf",
"4936027", "Lengenfeld\ Unterm\ Stein",
"497971", "Gaildorf",
"494431", "Wildeshausen",
"497842", "Kappelrodeck",
"498268", "Tussenhausen",
"498623", "Kirchweidach",
"49911", "Nuremberg",
"4933476", "Neuhardenberg",
"499348", "Werbach\-Gamburg",
"497546", "Oberteuringen",
"4936646", "Tanna\ bei\ Schleiz",
"497135", "Brackenheim",
"496587", "Zerf",
"496848", "Homburg\-Einöd",
"4934637", "Frankleben",
"494741", "Nordholz\ bei\ Bremerhaven",
"4938323", "Prohn",
"493337", "Biesenthal\ Brandenburg",
"493466", "Artern\ Unstrut",
"4935363", "Fermerswalde",
"499964", "Stallwang",
"494557", "Blunk",
"494302", "Kirchbarkau",
"4935755", "Ortrand",
"498406", "Böhmfeld",
"497052", "Bad\ Liebenzell",
"49231", "Dortmund",
"496698", "Schrecksbach",
"494863", "Sankt\ Peter\-Ording",
"4934976", "Gröbzig",
"499498", "Laaber",
"499278", "Weidenberg",
"495933", "Lathen",
"495086", "Celle\-Scheuen",
"499254", "Gefrees",
"4933602", "Alt\ Zeschdorf",
"494523", "Malente",
"492925", "Warstein\-Allagen",
"4939421", "Osterwieck",
"4939991", "Daberkow",
"498751", "Mainburg",
"4935433", "Vetschau",
"498166", "Allershausen\ Oberbayern",
"4938851", "Zarrentin",
"498547", "Osterhofen\-Gergweis",
"496201", "Weinheim\ Bergstr",
"498424", "Nassenfels",
"4933477", "Trebnitz\ bei\ Müncheberg",
"498122", "Erding",
"4934344", "Kohren\-Sahlis",
"495585", "Herzberg\-Sieber",
"497193", "Sulzbach\ an\ der\ Murr",
"496239", "Bobenheim\-Roxheim",
"498370", "Wiggensbach",
"494364", "Dahme\ Kreis\ Ostholstein",
"495682", "Borken\ Hessen",
"4934783", "Gerbstedt",
"495946", "Georgsdorf",
"497754", "Görwihl",
"4936026", "Struth\ bei\ Mühlhausen",
"4935891", "Rothenburg\ OL",
"4939208", "Loitsche",
"495571", "Uslar",
"4935056", "Altenberg\ Sachsen",
"499073", "Gundelfingen\ an\ der\ Donau",
"497656", "Schluchsee",
"493841", "Wismar",
"4938454", "Kritzkow",
"494948", "Wiesmoor\-Marcardsmoor",
"496772", "Nastätten",
"496253", "Fürth\ Odenwald",
"499176", "Allersberg",
"4936464", "Wormstedt",
"494283", "Tarmstedt",
"4939824", "Hohenzieritz",
"498703", "Essenbach",
"4934977", "Quellendorf",
"494125", "Seestermühe",
"492246", "Lohmar\ Rheinland",
"497533", "Allensbach",
"492295", "Ruppichteroth",
"498063", "Feldkirchen\-Westerham",
"494169", "Sauensiek",
"493691", "Eisenach\ Thüringen",
"496227", "Walldorf\ Baden",
"4934636", "Schafstädt",
"497045", "Oberderdingen",
"493763", "Glauchau",
"4936647", "Saalburg\ Thüringen",
"4938320", "Tribsees",
"499360", "Thüngen",
"496659", "Eichenzell",
"492152", "Kempen",
"492454", "Gangelt",
"4939389", "Schollene",
"497620", "Schopfheim\-Gersbach",
"4936379", "Holzengel",
"492721", "Lennestadt",
"497236", "Keltern",
"4935874", "Bernstadt\ an\ der\ Eigen",
"4938484", "Ventschow",
"494945", "Grossefehn\-Timmel",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"4937465", "Tannenbergsthal\ Vogtland",
"492543", "Billerbeck\ Westfalen",
"4934462", "Laucha\ Unstrut",
"496852", "Nohfelden",
"499521", "Hassfurt",
"494882", "Lunden",
"4933763", "Bestensee",
"496556", "Pronsfeld",
"499861", "Rothenburg\ ob\ der\ Tauber",
"494128", "Kollmar",
"4933675", "Tauche",
"497775", "Mühlingen",
"4933701", "Grossbeeren",
"4937362", "Seiffen\ Erzgebirge",
"496361", "Rockenhausen",
"4933452", "Neulewin",
"495126", "Algermissen",
"492680", "Mündersbach",
"499352", "Lohr\ am\ Main",
"495162", "Fallingbostel",
"495464", "Alfhausen",
"498686", "Petting",
"496633", "Homberg\ Ohm",
"4933962", "Heiligengrabe",
"496042", "Büdingen\ Hessen",
"49335", "Frankfurt\ \(Oder\)",
"4939347", "Kade",
"499433", "Nabburg",
"498784", "Hohenthann",
"4935471", "Birkenhainchen",
"4938229", "Bad\ Sülze",
"4934241", "Jesewitz",
"494204", "Thedinghausen",
"497646", "Weisweil\ Breisgau",
"4933742", "Oehna\ Brandenburg",
"4933237", "Paulinenaue",
"4939052", "Erxleben\ bei\ Haldensleben",
"493362", "Erkner",
"4934443", "Teuchern",
"494406", "Berne",
"497744", "Stühlingen",
"495956", "Rastdorf",
"495777", "Diepenau\-Essern",
"496138", "Mommenheim",
"498557", "Mauth",
"498302", "Görisried",
"4935027", "Weesenstein",
"495222", "Bad\ Salzuflen",
"4934202", "Delitzsch",
"495266", "Lemgo\-Kirchheide",
"496373", "Schönenberg\-Kübelberg",
"498741", "Vilsbiburg",
"492838", "Sonsbeck",
"492922", "Werl",
"494623", "Böklund",
"499873", "Abenberg\-Wassermungenau",
"498250", "Hilgertshausen\-Tandern",
"494268", "Bötersen",
"497055", "Neuweiler\ Kreis\ Calw",
"498431", "Neuburg\ an\ der\ Donau",
"494305", "Westensee",
"4935725", "Wittichenau",
"493425", "Wurzen",
"492256", "Mechernich\-Satzvey",
"4938353", "Gützkow\ bei\ Greifswald",
"494958", "Jemgum",
"4937343", "Jöhstadt",
"497132", "Neckarsulm",
"497434", "Winterlingen",
"494974", "Neuharlingersiel",
"496243", "Monsheim",
"498085", "Sankt\ Wolfgang",
"499727", "Schonungen\-Marktsteinach",
"496167", "Modautal",
"494308", "Schwedeneck",
"4936785", "Gräfinau\-Angstedt",
"492553", "Ochtrup",
"4939601", "Friedland",
"494955", "Westoverledingen",
"498071", "Wasserburg\ am\ Inn",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"4939775", "Ahlbeck\ bei\ Torgelow",
"496842", "Blieskastel",
"493771", "Aue\ Sachsen",
"4937754", "Zwönitz",
"492867", "Heiden\ Kreis\ Borken",
"499272", "Fichtelberg",
"499492", "Parsberg",
"499194", "Ebermannstadt",
"496692", "Neustadt\ Hessen",
"492527", "Lippetal\-Lippborg",
"494265", "Fintel",
"496595", "Dockweiler",
"492444", "Schleiden\-Gemünd",
"492501", "Münster\-Hiltrup",
"4936087", "Wüstheuterode",
"495563", "Kreiensen",
"4936204", "Stotternheim",
"494237", "Bendingbostel",
"492636", "Burgbrohl",
"495823", "Bienenbüttel",
"496052", "Bad\ Orb",
"492835", "Issum",
"492734", "Freudenberg\ Westfalen",
"499534", "Burgpreppach",
"499342", "Wertheim",
"4939223", "Theessen",
"4936072", "Weissenborn\-Lüderode",
"495306", "Cremlingen",
"495857", "Bleckede\-Brackede",
"498630", "Oberneukirchen",
"498262", "Mittelneufnach",
"499701", "Sandberg\ Unterfranken",
"4939082", "Mieste",
"496135", "Bodenheim\ Rhein",
"497587", "Hosskirch",
"498226", "Bibertal",
"492394", "Neuenrade\-Affeln",
"498204", "Mickhausen",
"496656", "Ebersburg",
"493677", "Ilmenau\ Thüringen",
"496421", "Marburg",
"4939884", "Hassleben\ bei\ Prenzlau",
"494885", "Bergenhusen",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"4938308", "Göhren\ Rügen",
"496855", "Freisen",
"492643", "Altenahr",
"495324", "Vienenburg",
"496754", "Martinstein",
"494942", "Südbrookmerland",
"495137", "Seelze",
"499621", "Amberg\ Oberpfalz",
"494871", "Hohenwestedt",
"497520", "Bodnegg",
"4934922", "Mühlanger",
"4934492", "Lucka",
"496559", "Leidenborn",
"497963", "Adelmannsfelden",
"497227", "Lichtenau\ Baden",
"495129", "Söhlde",
"496045", "Gedern",
"498586", "Hauzenberg",
"496533", "Morbach\ Hunsrück",
"4933734", "Felgentreu",
"4939481", "Hedersleben\ bei\ Aschersleben",
"499355", "Frammersbach",
"495165", "Rethem\ Aller",
"4935342", "Mühlberg\ Elbe",
"496096", "Wiesen\ Unterfranken",
"499607", "Luhe\-Wildenau",
"497253", "Bad\ Schönborn",
"496407", "Rabenau\ Hessen",
"499908", "Schöfweg",
"495168", "Walsrode\-Stellichte",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"499358", "Gössenheim",
"495671", "Hofgeismar",
"499374", "Eschau",
"497556", "Uhldingen\-Mühlhofen",
"499905", "Bernried\ Niederbayern",
"497852", "Willstätt",
"495685", "Knüllwald",
"492379", "Menden\-Asbeck",
"495582", "Sankt\ Andreasberg",
"494240", "Syke\-Heiligenfelde",
"494703", "Loxstedt\-Donnern",
"496236", "Neuhofen\ Pfalz",
"496620", "Philippsthal\ Werra",
"498283", "Neuburg\ an\ der\ Kammel",
"4938821", "Lüdersdorf",
"496048", "Büdingen\-Eckartshausen",
"499420", "Feldkirchen\ Niederbayern",
"4939451", "Wasserleben",
"4938732", "Gallin\ bei\ Lübz",
"499179", "Freystadt",
"499244", "Betzenstein",
"4936924", "Mihla",
"498364", "Seeg",
"497633", "Staufen\ im\ Breisgau",
"4939329", "Möringen",
"497042", "Vaihingen\ an\ der\ Enz",
"492158", "Grefrath\ bei\ Krefeld",
"492472", "Monschau",
"492174", "Burscheid\ Rheinland",
"4935954", "Grossharthau",
"492292", "Windeck\ Sieg",
"493591", "Bautzen",
"494122", "Uetersen",
"493304", "Velten",
"494166", "Ahlerstedt",
"496781", "Idar\-Oberstein",
"494547", "Gudow\ Lauenburg",
"493981", "Neustrelitz",
"4939854", "Kleptow",
"494751", "Otterndorf",
"497361", "Aalen",
"496858", "Ottweiler\-Fürth",
"496874", "Wadern\-Nunkirchen",
"4938424", "Bobitz",
"496775", "Strüth\ Taunus",
"494862", "Garding",
"4939245", "Loburg",
"494826", "Hohenlockstedt",
"499676", "Winklarn",
"497053", "Bad\ Teinach\-Zavelstein",
"492779", "Greifenstein\-Beilstein",
"496476", "Mengerskirchen",
"496296", "Ahorn\ Baden",
"494522", "Plön",
"495932", "Haren\ Ems",
"499774", "Oberelsbach",
"494625", "Jübek",
"499875", "Wolframs\-Eschenbach",
"492558", "Horstmar",
"4938333", "Horst\ bei\ Grimmen",
"496245", "Biblis",
"492574", "Saerbeck",
"497940", "Künzelsau",
"493423", "Eilenburg",
"494303", "Schlesen",
"4939361", "Lüderitz",
"4936735", "Probstzella",
"495650", "Cornberg",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"498764", "Mauern\ Kreis\ Freising",
"497843", "Renchen",
"494770", "Wischhafen",
"4935829", "Gersdorf\ bei\ Görlitz",
"498666", "Teisendorf",
"4936450", "Kranichfeld",
"498622", "Tacherting\-Peterskirchen",
"495828", "Himbergen",
"493606", "Heiligenstadt\ Heilbad",
"497761", "Bad\ Säckingen",
"494351", "Eckernförde",
"4939929", "Jabel\ bei\ Waren",
"496375", "Wallhalben",
"495182", "Gronau\ Leine",
"495484", "Lienen\-Kattenvenne",
"493531", "Finsterwalde",
"492232", "Brühl\ Rheinland",
"4933875", "Rhinow",
"497156", "Ditzingen",
"496381", "Kusel",
"495724", "Obernkirchen",
"4935691", "Bärenklau\ NL",
"495825", "Wieren",
"4935384", "Steinsdorf\ bei\ Jessen",
"492833", "Kerken",
"4937325", "Niederbobritzsch",
"495451", "Ibbenbüren",
"495626", "Bad\ Zwesten",
"495565", "Einbeck\-Wenzen",
"495662", "Felsberg\ Hessen",
"494384", "Selent",
"4934322", "Rosswein",
"495529", "Rhumspringe",
"498868", "Schwabsoien",
"497242", "Rheinstetten",
"495197", "Soltau\-Frielingen",
"496133", "Oppenheim",
"494939", "Baltrum",
"4933925", "Wustrau\-Altfriesack",
"494953", "Bunde",
"496159", "Messel",
"4936603", "Weida",
"495403", "Bad\ Iburg",
"492555", "Schöppingen",
"492461", "Jülich",
"492652", "Mendig",
"498083", "Isen",
"494189", "Undeloh",
"496036", "Wölfersheim",
"4938371", "Karlshagen",
"4936847", "Steinbach\-Hallenberg",
"494263", "Scheessel",
"492859", "Wesel\-Bislich",
"494927", "Krummhörn\-Loquard",
"496593", "Hillesheim\ Eifel",
"4939264", "Kroppenstedt",
"4934425", "Droyssig",
"499854", "Wittelshofen",
"4937422", "Markneukirchen",
"496043", "Nidda",
"497965", "Ellwangen\-Röhlingen",
"493371", "Luckenwalde",
"496535", "Osann\-Monzel",
"4936483", "Ziegenrück",
"494708", "Ringstedt",
"492056", "Heiligenhaus",
"499134", "Neunkirchen\ am\ Brand",
"493385", "Rathenow",
"497255", "Graben\-Neudorf",
"499353", "Karlstadt",
"495163", "Fallingbostel\-Dorfmark",
"492645", "Vettelschoss",
"495066", "Sarstedt",
"496853", "Marpingen",
"492334", "Hagen\-Hohenlimburg",
"492542", "Gescher",
"492599", "Ascheberg\-Herbern",
"496195", "Kelkheim\ Taunus",
"495022", "Wietzen",
"494883", "Süderstapel",
"499339", "Ippesheim",
"492153", "Nettetal\-Lobberich",
"496827", "Eppelborn",
"495604", "Grossalmerode",
"496567", "Oberkail",
"4936846", "Suhl\-Dietzhausen",
"496146", "Hochheim\ am\ Main",
"497937", "Dörzbach",
"495706", "Porta\ Westfalica",
"492696", "Nohn\ Eifel",
"4938782", "Reetz\ bei\ Perleberg",
"499742", "Kalbach\ Rhön",
"494477", "Lastrup\-Hemmelte",
"4939209", "Wanzleben",
"494297", "Ottersberg\-Posthausen",
"498026", "Hausham",
"493762", "Crimmitschau",
"497635", "Schliengen",
"493726", "Flöha",
"498062", "Bruckmühl\ Mangfall",
"495377", "Ehra\-Lessien",
"4936762", "Steinach\ Thüringen",
"497532", "Meersburg",
"497344", "Blaubeuren",
"4935934", "Grossdubrau",
"497836", "Schiltach",
"499951", "Landau\ an\ der\ Isar",
"4934745", "Winningen\ Sachsen\-Anhalt",
"493624", "Ohrdruf",
"4938752", "Zierzow\ bei\ Ludwigslust",
"4935268", "Stauchitz",
"496252", "Heppenheim\ Bergstrasse",
"496198", "Eppstein",
"4933205", "Michendorf",
"496773", "Kamp\-Bornhofen",
"498341", "Kaufbeuren",
"493973", "Pasewalk",
"499261", "Kronach",
"498702", "Wörth\ an\ der\ Isar",
"4935792", "Ossling",
"4938228", "Dettmannsdorf\-Kölzow",
"494282", "Sittensen",
"492947", "Anröchte",
"497258", "Oberderdingen\-Flehingen",
"499903", "Schöllnach",
"4939388", "Goldbeck\ Altm",
"495683", "Wabern\ Hessen",
"495247", "Harsewinkel",
"497274", "Germersheim",
"497192", "Murrhardt",
"4936963", "Dorndorf\ Rhön",
"498157", "Feldafing",
"499072", "Lauingen\ Donau",
"4936378", "Ostramondra",
"498271", "Meitingen",
"4936453", "Mellingen",
"49641", "Giessen",
"494804", "Nordhastedt",
"49961", "Weiden\ in\ der\ Oberpfalz",
"498123", "Moosinning",
"494705", "Wremen",
"497667", "Breisach\ am\ Rhein",
"498285", "Burtenbach",
"498628", "Kienberg\ Oberbayern",
"499343", "Lauda\-Königshofen",
"497245", "Durmersheim",
"496027", "Stockstadt\ am\ Main",
"498263", "Breitenbrunn\ Schwaben",
"495665", "Guxhagen",
"499107", "Trautskirchen",
"497476", "Bisingen",
"495562", "Dassel\-Markoldendorf",
"494936", "Grossheide",
"492238", "Pulheim",
"4936691", "Eisenberg\ Thüringen",
"4936743", "Teichel",
"496053", "Wächtersbach",
"495822", "Ebstorf",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"499493", "Beratzhausen",
"497381", "Münsingen",
"494528", "Schönwalde\ am\ Bungsberg",
"497904", "Ilshofen",
"497375", "Obermarchtal",
"4934672", "Rossleben",
"494186", "Buchholz\-Trelde",
"496761", "Simmern\ Hunsrück",
"496039", "Karben",
"496693", "Neuental",
"493961", "Altentreptow",
"4933362", "Liepe\ Kreis\ Barnim",
"498384", "Röthenbach\ Allgäu",
"492856", "Hamminkeln\-Brünen",
"4938203", "Bad\ Doberan",
"4939294", "Gross\ Rosenburg",
"496843", "Gersheim",
"4935603", "Burg\ Spreewald",
"492655", "Weibern",
"49375", "Zwickau",
"492552", "Steinfurt\-Borghorst",
"492307", "Kamen",
"4933841", "Belzig",
"494829", "Wewelsfleth",
"492957", "Wünnenberg\-Haaren",
"492776", "Bad\ Endbach\-Hartenrod",
"496479", "Waldbrunn\ Westerwald",
"496242", "Osthofen",
"497133", "Lauffen\ am\ Neckar",
"492674", "Bad\ Bertrich",
"495935", "Twist\-Schöninghsdorf",
"499941", "Kötzting",
"4934297", "Liebertwolkwitz",
"494622", "Taarstedt",
"499872", "Heilsbronn",
"492267", "Wipperfürth",
"492923", "Lippetal\-Herzfeld",
"494525", "Ahrensbök",
"494666", "Ladelund",
"4939391", "Lückstedt",
"499576", "Lichtenfels\-Isling",
"497354", "Erolzheim",
"494865", "Osterhever",
"494764", "Gnarrenburg\-Klenkendorf",
"4934382", "Nerchau",
"495171", "Peine",
"494837", "Neuenkirchen\ Dithmarschen",
"498303", "Waltenhofen",
"496372", "Bruchmühlbach\-Miesau",
"495185", "Duingen",
"4935324", "Crinitz",
"492235", "Erftstadt",
"498669", "Traunreut",
"495223", "Bünde",
"4939959", "Dargun",
"493631", "Nordhausen\ Thüringen",
"49202", "Wuppertal",
"496120", "Aarbergen",
"497248", "Marxzell",
"497159", "Renningen",
"498862", "Steingaden\ Oberbayern",
"495257", "Hövelhof",
"498029", "Kreuth\ bei\ Tegernsee",
"494285", "Rhade\ bei\ Zeven",
"4934296", "Groitzsch\ bei\ Pegau",
"494123", "Barmstedt",
"498705", "Altfraunhofen",
"494271", "Sulingen",
"495028", "Pennigsehl",
"497839", "Schapbach",
"494491", "Friesoythe",
"492548", "Dülmen\-Rorup",
"497950", "Schnelldorf",
"4936628", "Zeulenroda",
"496255", "Lindenfels",
"499748", "Motten",
"493447", "Altenburg\ Thüringen",
"4938722", "Raduhn",
"498065", "Tuntenhausen\-Schönau",
"492473", "Simmerath",
"492293", "Nümbrecht",
"496187", "Schöneck",
"497260", "Sinsheim\-Hilsbach",
"497043", "Maulbronn",
"493765", "Reichenbach\ Vogtland",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"497632", "Badenweiler",
"499438", "Fensterbach",
"493737", "Rochlitz",
"49951", "Bamberg",
"498282", "Krumbach\ Schwaben",
"497567", "Leutkirch\-Friesenhofen",
"497146", "Remseck\ am\ Neckar",
"494702", "Sandstedt",
"4936423", "Orlamünde",
"4939863", "Seehausen\ bei\ Prenzlau",
"4938309", "Trent",
"496638", "Schwalmtal\-Renzendorf",
"4935453", "Drahnsdorf",
"4934605", "Gröbers",
"4934771", "Querfurt",
"499075", "Glött",
"4937602", "Kirchberg\ Sachsen",
"49271", "Siegen",
"495583", "Braunlage\-Hohegeiss",
"497195", "Winnenden",
"4939404", "Ausleben",
"499081", "Nördlingen",
"497853", "Kehl\-Bodersweier",
"4933432", "Müncheberg",
"495286", "Ottenstein\ Niedersachsen",
"499078", "Mertingen",
"497773", "Bodman\-Ludwigshafen",
"4939328", "Rochau",
"497252", "Bretten",
"495441", "Diepholz",
"499435", "Schwarzenfeld",
"493382", "Lehnin",
"496836", "Überherrn",
"496532", "Zeltingen\-Rachtig",
"496344", "Schwegenheim",
"497962", "Fichtenau",
"4938873", "Carlow",
"496635", "Kirtorf",
"499844", "Obernzenn",
"496667", "Steinau\-Ulmbach",
"499745", "Wildflecken",
"495731", "Bad\ Oeynhausen",
"495069", "Nordstemmen",
"492596", "Nordkirchen",
"4935600", "Döbern\ NL",
"49741", "Rottweil",
"499467", "Michelsneukirchen",
"495504", "Friedland\ Kreis\ Göttingen",
"499336", "Bütthard",
"494288", "Horstedt\ Kreis\ Rotenburg",
"498708", "Weihmichl\-Unterneuhausen",
"4933335", "Pinnow\ Kreis\ Uckermark",
"497300", "Roggenburg",
"492545", "Rosendahl\-Darfeld",
"496274", "Waldbrunn\ Odenwald",
"496192", "Hofheim\ am\ Taunus",
"494943", "Grossefehn",
"495025", "Estorf\ Weser",
"492642", "Remagen",
"496258", "Gernsheim",
"4936643", "Thimmendorf",
"499901", "Hengersberg\ Bayern",
"495681", "Homberg\ Efze",
"4938326", "Grimmen",
"499384", "Schwanfeld",
"495675", "Trendelburg",
"497124", "Trochtelfingen\ Hohenz",
"497422", "Schramberg",
"497337", "Nellingen\ Alb",
"4933209", "Caputh",
"497466", "Beuron",
"492389", "Werne",
"495572", "Bodenfelde",
"498752", "Au\ in\ der\ Hallertau",
"492934", "Sundern\-Altenhellefeld",
"498273", "Nordendorf",
"4938721", "Ziegendorf",
"496202", "Schwetzingen",
"498121", "Markt\ Schwaben",
"4934973", "Osternienburg",
"4933678", "Storkow\ Mark",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"4936020", "Ebeleben",
"499953", "Pilsting",
"497329", "Steinheim\ am\ Albuch",
"4937468", "Treuen\ Vogtland",
"492482", "Hellenthal",
"495234", "Horn\-Bad\ Meinberg",
"494755", "Ihlienworth",
"4937601", "Mülsen\ Skt\ Jacob",
"497365", "Essingen\ Württemberg",
"494854", "Friedrichskoog",
"493971", "Anklam",
"4939754", "Löcknitz\ Vorpom",
"499628", "Ursensollen",
"4934772", "Helbra",
"498343", "Aitrang",
"496771", "St\ Goarshausen",
"496428", "Stadtallendorf",
"499263", "Ludwigsstadt",
"499927", "Kirchberg\ Wald",
"493546", "Lübben\ Spreewald",
"4933473", "Zechin",
"496785", "Herrstein",
"496851", "St\ Wendel",
"4939343", "Jerichow",
"494758", "Nordleda",
"499522", "Eltmann",
"499147", "Nennslingen",
"494774", "Hechthausen",
"499566", "Meeder",
"499625", "Kastl\ bei\ Amberg",
"494875", "Stafstedt",
"496425", "Rauschenberg\ Hessen",
"499826", "Weidenbach\ Mittelfranken",
"494881", "Friedrichstadt",
"496788", "Sien",
"492151", "Krefeld",
"499303", "Eibelstadt",
"492664", "Rennerod",
"492722", "Attendorn",
"496041", "Glauburg",
"4939205", "Langenweddingen",
"496803", "Mandelbachtal\-Ommersheim",
"4933834", "Pritzerbe",
"4933767", "Friedersdorf\ bei\ Berlin",
"498679", "Burgkirchen\ an\ der\ Alz",
"496362", "Alsenz",
"495977", "Spelle",
"496326", "Deidesheim",
"497944", "Kupferzell",
"492103", "Hilden",
"499351", "Gemünden\ am\ Main",
"495161", "Walsrode",
"495654", "Herleshausen",
"492463", "Titz",
"4933929", "Gühlen\-Glienicke",
"494951", "Weener",
"495401", "Georgsmarienhütte",
"498075", "Amerang",
"493874", "Ludwigslust",
"4936252", "Tambach\-Dietharz",
"498081", "Dorfen\ Stadt",
"496304", "Wolfstein\ Pfalz",
"4938844", "Gülze",
"4937329", "Grosshartmannsdorf",
"4935975", "Hohnstein",
"494261", "Rotenburg\ Wümme",
"496591", "Gerolstein",
"499282", "Naila",
"49851", "Passau",
"497084", "Schömberg\ bei\ Neuenbürg",
"495439", "Bersenbrück",
"4936692", "Bürgel",
"492831", "Geldern",
"497340", "Neenstetten",
"492505", "Altenberge\ Westfalen",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"496109", "Frankfurt\-Bergen\-Enkheim",
"494903", "Wymeer",
"4933361", "Joachimsthal",
"495453", "Recke",
"492602", "Montabaur",
"499804", "Aurach",
"49461", "Flensburg",
"4936941", "Wasungen",
"496131", "Mainz",
"4933766", "Teupitz",
"495427", "Melle\-Buer",
"495544", "Reinhardshagen",
"495332", "Schöppenstedt",
"497577", "Veringenstadt",
"499708", "Bad\ Bocklet",
"494327", "Grossenaspe",
"497972", "Gschwend\ bei\ Gaildorf",
"492330", "Herdecke",
"4936739", "Rottenbach",
"494432", "Dötlingen\-Brettorf",
"497841", "Achern",
"494134", "Embsen\ Kreis\ Lüneburg",
"494353", "Ascheffel",
"4938327", "Elmenhorst\ Vorpom",
"497763", "Murg",
"493533", "Elsterwerda",
"4934633", "Braunsbedra",
"498745", "Bodenkirchen",
"498467", "Kinding",
"498336", "Erkheim",
"492508", "Drensteinfurt",
"496383", "Glan\-Münchweiler",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"4936640", "Remptendorf",
"496264", "Neudenau",
"4934381", "Colditz",
"4933470", "Lietzen",
"497051", "Calw",
"494339", "Christiansholm",
"498435", "Ehekirchen",
"4935436", "Laasow\ bei\ Calau",
"4939925", "Wredenhagen",
"4939004", "Köckte\ bei\ Gardelegen",
"4935825", "Kodersdorf",
"494742", "Dorum",
"498054", "Breitbrunn\ am\ Chiemsee",
"4936023", "Horsmar",
"493421", "Torgau",
"496677", "Neuenstein\ Hessen",
"4935053", "Glashütte\ Sachsen",
"49581", "Uelzen",
"495733", "Vlotho",
"492725", "Lennestadt\-Oedingen",
"497202", "Karlsbad",
"492824", "Kalkar",
"499569", "Sesslach",
"492564", "Vreden",
"499829", "Flachslanden",
"496337", "Grossbundenbach",
"496466", "Dautphetal\-Friedensdorf",
"4935774", "Boxberg\ Sachsen",
"499865", "Adelshofen\ Mittelfranken",
"4939226", "Hohenziatz",
"499764", "Höchheim",
"496422", "Kirchhain",
"496124", "Bad\ Schwalbach",
"494941", "Aurich",
"499622", "Hirschau\ Oberpfalz",
"494872", "Hanerau\-Hademarschen",
"499666", "Illschwang",
"499525", "Königsberg\ in\ Bayern",
"497428", "Rosenfeld",
"495554", "Moringen",
"499837", "Haundorf",
"497771", "Stockach",
"4934904", "Oranienbaum",
"495443", "Lemförde",
"496329", "Weidenthal\ Pfalz",
"4938781", "Mellen",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"4936761", "Heubisch",
"496205", "Hockenheim",
"4938751", "Picher",
"494343", "Laboe",
"498380", "Achberg",
"495672", "Bad\ Karlshafen",
"497425", "Trossingen",
"4938356", "Behrenhoff",
"4937346", "Geyer",
"494107", "Siek\ Kreis\ Stormarn",
"497851", "Kehl",
"499083", "Möttingen",
"499936", "Wallerfing",
"496782", "Birkenfeld\ Nahe",
"494121", "Elmshorn",
"499186", "Lauterhofen\ Oberpfalz",
"499868", "Schillingsfürst",
"4939724", "Klein\ Bünzow",
"493744", "Auerbach\ Vogtland",
"4934446", "Grosskorbetha",
"494273", "Kirchdorf\ bei\ Sulingen",
"494493", "Friesoythe\-Gehlenberg",
"497326", "Neresheim",
"4934609", "Salzmünde",
"499528", "Donnersdorf",
"494752", "Neuhaus\ Oste",
"4933230", "Börnicke\ Kreis\ Havelland",
"497362", "Bopfingen",
"492485", "Schleiden\-Dreiborn",
"497803", "Gengenbach",
"4938305", "Gingst",
"492471", "Roetgen\ Eifel",
"493592", "Kirschau",
"492291", "Waldbröl",
"4936703", "Gräfenthal",
"493695", "Bad\ Salzungen",
"497041", "Mühlacker",
"4935020", "Struppen",
"492608", "Welschneudorf",
"495173", "Uetze",
"496084", "Schmitten\ Taunus",
"498742", "Velden\ Vils",
"495221", "Herford",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"497304", "Blaustein\ Württemberg",
"497975", "Untergröningen",
"494435", "Grossenkneten",
"493361", "Fürstenwalde\ Spree",
"4933654", "Fünfeichen",
"4939362", "Grieben\ bei\ Tangerhütte",
"4935023", "Bad\ Gottleuba",
"494467", "Wittmund\-Funnix",
"494336", "Owschlag",
"4934224", "Belgern\ Sachsen",
"4939031", "Dähre",
"497131", "Heilbronn\ Neckar",
"494844", "Pellworm",
"494745", "Bad\ Bederkesa",
"4933989", "Sadenbeck",
"4933233", "Ketzin",
"499943", "Lam\ Oberpfalz",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"4939955", "Jürgenstorf",
"495207", "Schloss\ Holte\-Stukenbrock",
"494796", "Teufelsmoor",
"492921", "Soest",
"499288", "Bad\ Steben",
"498134", "Odelzhausen",
"498432", "Burgheim",
"496340", "Wörth\-Schaidt",
"498327", "Rettenberg",
"499271", "Thurnau\-Alladorf",
"497383", "Münsingen\-Buttenhausen",
"499491", "Hemau",
"4935692", "Kerkwitz",
"499285", "Kirchenlamitz",
"4934321", "Leisnig",
"4938292", "Kröpelin",
"496691", "Schwalmstadt",
"493963", "Woldegk",
"49861", "Traunstein",
"4935728", "Uhyst\ Spree",
"496763", "Kirchberg\ Hunsrück",
"499123", "Lauf\ an\ der\ Pegnitz",
"496003", "Rosbach\ von\ der\ Höhe",
"4936083", "Uder",
"494748", "Stubben\ bei\ Bremerhaven",
"496841", "Homburg\ Saar",
"493772", "Schneeberg\ Erzgebirge",
"495436", "Nortrup",
"499157", "Alfeld\ Mittelfranken",
"498072", "Haag\ in\ Oberbayern",
"495367", "Rühen",
"4937208", "Auerswalde",
"499341", "Tauberbischofsheim",
"495335", "Schladen",
"492323", "Herne",
"495644", "Willebadessen\-Peckelsheim",
"496106", "Rodgau",
"4938372", "Usedom",
"49451", "Lübeck",
"497954", "Kirchberg\ an\ der\ Jagst",
"495746", "Rödinghausen",
"498261", "Mindelheim",
"492605", "Löf",
"492502", "Nottuln",
"492357", "Herscheid\ Westfalen",
"496051", "Gelnhausen",
"4937421", "Oelsnitz\ Vogtland",
"497264", "Bad\ Rappenau",
"493860", "Raben\ Steinfeld",
"4936606", "Kraftsdorf",
"496363", "Niederkirchen",
"499409", "Pielenhofen",
"499088", "Mönchsdeggingen",
"4936840", "Trusetal",
"495276", "Marienmünster",
"492404", "Alsdorf\ Rheinland",
"492102", "Ratingen",
"493372", "Jüterbog",
"496506", "Welschbillig",
"4936375", "Kindelbrück",
"4934921", "Kemberg",
"4934491", "Schmölln\ Thüringen",
"494348", "Schönkirchen",
"495767", "Warmsen",
"496631", "Alsfeld",
"499431", "Schwandorf",
"495445", "Drebber",
"496802", "Völklingen\-Lauterbach",
"4938225", "Trinwillershagen",
"494964", "Rhede\ Ems",
"499302", "Rottendorf\ Unterfranken",
"495346", "Liebenburg",
"495834", "Wittingen\-Knesebeck",
"4939482", "Gatersleben",
"499741", "Bad\ Brückenau",
"4933208", "Fahrland",
"497808", "Hohberg\ bei\ Offenburg",
"4935265", "Glaubitz",
"492723", "Kirchhundem",
"492541", "Coesfeld",
"4935341", "Bad\ Liebenwerda",
"494498", "Saterland\-Ramsloh",
"495021", "Nienburg\ Weser",
"494254", "Eystrup",
"499523", "Hofheim\ in\ Unterfranken",
"496284", "Mudau",
"4933679", "Wendisch\ Rietz",
"498534", "Tettenweis",
"496430", "Hahnstätten",
"493843", "Güstrow",
"494275", "Ehrenburg",
"494495", "Friesoythe\-Thüle",
"498342", "Marktoberdorf",
"496251", "Bensheim",
"49395", "Neubrandenburg",
"494281", "Zeven",
"4937294", "Grünhainichen",
"499262", "Wallenfels",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"498061", "Bad\ Aibling",
"497531", "Konstanz",
"493761", "Werdau\ Sachsen",
"493693", "Meiningen",
"4939452", "Ilsenburg",
"494446", "Bakum\ Kreis\ Vechta",
"497704", "Geisingen\ Baden",
"4935244", "Krögis",
"4936967", "Geisa",
"499952", "Eichendorf",
"497805", "Appenweier",
"498272", "Wertingen",
"4938731", "Lübz",
"498194", "Vilgertshofen",
"494634", "Husby",
"498753", "Elsendorf\ Niederbayern",
"495448", "Barver",
"497457", "Rottenburg\-Ergenzingen",
"494736", "Butjadingen\-Tossens",
"496203", "Ladenburg",
"497191", "Backnang",
"499085", "Alerheim",
"498727", "Falkenberg\ Niederbayern",
"495573", "Uslar\-Volpriehausen",
"4933974", "Dessow",
"497423", "Oberndorf\ am\ Neckar",
"499071", "Dillingen\ an\ der\ Donau",
"494743", "Langen\ bei\ Bremerhaven",
"493494", "Wolfen",
"4933741", "Niedergörsdorf",
"495909", "Wettrup",
"496008", "Echzell",
"4936966", "Kaltennordheim",
"492684", "Puderbach\ Westerwald",
"4939051", "Calvörde",
"493968", "Schönbeck",
"494861", "Tönning",
"499128", "Feucht",
"497388", "Pfronstetten",
"499945", "Arnbruck",
"495931", "Meppen",
"4938466", "Jürgenshagen",
"494521", "Eutin",
"497726", "Bad\ Dürrheim",
"495181", "Alfeld\ Leine",
"493344", "Bad\ Freienwalde",
"497762", "Wehr\ Baden",
"494352", "Damp",
"4934263", "Hohburg",
"493635", "Kölleda",
"4933928", "Wildberg\ Brandenburg",
"497624", "Grenzach\-Wyhlen",
"495175", "Lehrte\-Arpke",
"496382", "Lauterecken",
"493836", "Wolgast",
"494433", "Dötlingen",
"497973", "Obersontheim",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"499204", "Plankenfels",
"4937328", "Grossschirma",
"498621", "Trostberg",
"498456", "Lenting",
"49291", "Meschede",
"4933878", "Nennhausen",
"496397", "Leimen\ Pfalz",
"495333", "Dettum",
"4939602", "Kleeth",
"492325", "Wanne\-Eickel",
"498179", "Eurasburg\ an\ der\ Loisach",
"492369", "Dorsten\-Wulfen",
"497486", "Horb\-Altheim",
"4936607", "Niederpöllnitz",
"493937", "Osterburg\ Altmark",
"495661", "Melsungen",
"4936843", "Benshausen",
"492603", "Bad\ Ems",
"496737", "Köngernheim",
"494902", "Jemgum\-Ditzum",
"499364", "Zellingen",
"495154", "Aerzen",
"495452", "Mettingen\ Westfalen",
"497371", "Riedlingen\ Württemberg",
"499283", "Rehau",
"4936738", "Königsee",
"496765", "Gemünden\ Hunsrück",
"493965", "Burow\ bei\ Altentreptow",
"499647", "Kirchenthumbach",
"496864", "Mettlach",
"499948", "Eschlkam",
"497385", "Gomadingen",
"496447", "Langgöns\-Niederkleen",
"496524", "Rodershausen",
"494176", "Marschacht",
"498374", "Dietmannsried",
"4936071", "Teistungen",
"492426", "Nörvenich",
"492651", "Mayen",
"492462", "Linnich",
"492164", "Jüchen\-Otzenrath",
"49521", "Bielefeld",
"4939248", "Dobritz",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"492224", "Bad\ Honnef",
"499955", "Mamming",
"497802", "Oberkirch\ Baden",
"4939992", "Görmin",
"4939422", "Badersleben",
"4933338", "Stolpe\/Oder",
"497631", "Müllheim\ Baden",
"499229", "Mainleus",
"4938852", "Wittenburg",
"497506", "Wangen\-Leupolz",
"499265", "Pressig",
"496783", "Baumholder",
"497363", "Lauchheim",
"498634", "Garching\ an\ der\ Alz",
"494753", "Balje",
"494272", "Siedenburg",
"494194", "Sievershütten",
"498345", "Stöttwang",
"494492", "Saterland",
"4936427", "Dornburg\ Saale",
"4935892", "Horka\ OL",
"495673", "Immenhausen\ Hessen",
"498446", "Pörnbach",
"499082", "Oettingen\ in\ Bayern",
"4939325", "Vinzelberg",
"499190", "Heroldsbach",
"498281", "Thannhausen\ Schwaben",
"495924", "Bad\ Bentheim\-Gildehaus",
"494534", "Steinburg\ Kreis\ Storman",
"494342", "Preetz\ Kreis\ Plön",
"493378", "Ludwigsfelde",
"492440", "Nettersheim\-Tondorf",
"496704", "Langenlonsheim",
"493904", "Haldensleben",
"496805", "Kleinblittersdorf",
"499406", "Mintraching",
"495442", "Barnstorf\ Kreis\ Diepholz",
"495144", "Wathlingen",
"493381", "Brandenburg\ an\ der\ Havel",
"499097", "Marxheim",
"498254", "Altomünster",
"497961", "Ellwangen\ Jagst",
"493375", "Königs\ Wusterhausen",
"496531", "Bernkastel\-Kues",
"4934461", "Nebra\ Unstrut",
"496509", "Büdlich",
"4938206", "Graal\-Müritz\ Seeheilbad",
"4935606", "Briesen\ bei\ Cottbus",
"497251", "Bruchsal",
"4937361", "Neuhausen\ Erzgebirge",
"499268", "Teuschnitz",
"496423", "Wetter\ Hessen",
"4933702", "Wünsdorf",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"4933451", "Heckelberg",
"494873", "Aukrug",
"49811", "Hallbergmoos",
"498348", "Bidingen",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"496457", "Burgwald\ Eder",
"497203", "Walzbachtal",
"4936625", "Langenwetzendorf",
"495732", "Löhne",
"499974", "Traitsching",
"499305", "Estenfeld",
"4934242", "Hohenpriessnitz",
"494487", "Grossenkneten\-Huntlosen",
"499657", "Waldthurn",
"4935472", "Schlepzig",
"4935843", "Hirschfelde\ bei\ Zittau",
"495561", "Einbeck",
"495455", "Tecklenburg\-Brochterbeck",
"4938207", "Stäbelow",
"494358", "Loose\ bei\ Eckernförde",
"495821", "Bad\ Bevensen",
"4937431", "Mehltheuer\ Vogtland",
"4935607", "Jänschwalde",
"49341", "Leipzig",
"495034", "Neustadt\-Hagen",
"4939779", "Eggesin",
"498176", "Egling\ bei\ Wolfratshausen",
"492366", "Herten\ Westfalen",
"492747", "Molzhain",
"496002", "Ober\-Mörlen",
"498073", "Gars\ am\ Inn",
"492465", "Inden",
"492551", "Steinfurt\-Burgsteinfurt",
"493773", "Johanngeorgenstadt",
"494179", "Winsen\-Tönnhausen",
"494244", "Harpstedt",
"495807", "Altenmedingen",
"492429", "Hürtgenwald",
"496624", "Heringen\ Werra",
"4939742", "Brüssow\ bei\ Pasewalk",
"497382", "Römerstein",
"4933052", "Leegebruch",
"499424", "Strasskirchen",
"496762", "Kastellaun",
"499122", "Schwabach",
"493962", "Penzlin\ bei\ Waren",
"496726", "Lorch\ Rheingau",
"499166", "Münchsteinach",
"495356", "Helmstedt\-Barmke",
"4938876", "Roggendorf",
"499547", "Zapfendorf",
"4937209", "Einsiedel\ bei\ Chemnitz",
"499942", "Viechtach",
"494456", "Varel\-Altjührden",
"494621", "Schleswig",
"495906", "Lünne",
"499871", "Windsbach",
"4936426", "Ottendorf\ bei\ Stadtroda",
"4933082", "Menz\ Kreis\ Oberhavel",
"496486", "Katzenelnbogen",
"498433", "Königsmoos",
"4935456", "Terpt",
"492994", "Marsberg\-Westheim",
"492584", "Warendorf\-Milte",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"498507", "Neuburg\ am\ Inn",
"496241", "Worms",
"497729", "Tennenbronn",
"4934293", "Naunhof\ bei\ Grimma",
"498861", "Schongau",
"495320", "Torfhaus",
"497524", "Bad\ Waldsee",
"495458", "Hopsten",
"495294", "Hövelhof\-Espeln",
"495474", "Stemwede\-Dielingen",
"495172", "Ilsede",
"496385", "Reichenbach\-Steegen",
"497447", "Baiersbronn\-Schwarzenberg",
"497765", "Rickenbach\ Hotzenwald",
"4933601", "Podelzig",
"494355", "Rieseby",
"498459", "Manching",
"493632", "Sondershausen",
"498743", "Geisenhausen",
"496371", "Landstuhl",
"492206", "Overath",
"493535", "Herzberg\ Elster",
"494607", "Janneby",
"4934653", "Rottleberode",
"4933933", "Lindow\ Mark",
"497352", "Ochsenhausen",
"494762", "Kutenholz",
"49201", "Essen",
"4934638", "Zöschen",
"492991", "Marsberg\-Bredelar",
"4939882", "Gollin",
"499775", "Schönau\ an\ der\ Brend",
"499874", "Neuendettelsau",
"494624", "Kropp",
"492672", "Treis\-Karden",
"496244", "Westhofen\ Rheinhessenen",
"494973", "Wittmund\-Burhafe",
"4934924", "Zahna",
"4934494", "Ehrenhain",
"497433", "Balingen",
"492575", "Greven\-Reckenfeld",
"492581", "Warendorf",
"497459", "Nagold\-Hochdorf",
"499236", "Nagel",
"498765", "Bruckberg\ Niederbayern",
"497743", "Ühlingen\-Birkendorf",
"4936028", "Kammerforst\ Thüringen",
"496420", "Lahntal",
"4939206", "Eichenbarleben",
"4936849", "Kleinschmalkalden",
"4935058", "Pretzschendorf",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"496358", "Kriegsfeld",
"496374", "Weilerbach",
"495485", "Ladbergen",
"495471", "Bohmte",
"495725", "Lindhorst\ bei\ Stadthagen",
"496355", "Albisheim\ Pfrimm",
"495824", "Bad\ Bodenteich",
"4935753", "Grossräschen",
"492733", "Hilchenbach",
"4935365", "Falkenberg\ Elster",
"494371", "Burg\ auf\ Fehmarn",
"495564", "Dassel",
"499407", "Wenzenbach",
"497176", "Spraitbach",
"4937291", "Augustusburg",
"4938325", "Rolofshagen",
"494385", "Hohenfelde\ bei\ Kiel",
"4938793", "Dergenthin",
"492393", "Sundern\-Allendorf",
"495031", "Wunstorf",
"495769", "Steyerberg\-Voigtei",
"4935241", "Lommatzsch",
"499533", "Untermerzbach",
"492554", "Laer\ Kreis\ Steinfurt",
"494241", "Bassum",
"4935827", "Nieder\-Seifersdorf",
"4936922", "Gerstungen",
"498382", "Lindau\ Bodensee",
"493883", "Hagenow",
"4935952", "Grossröhrsdorf\ OL",
"494486", "Edewecht\-Friedrichsfehn",
"499656", "Moosbach\ bei\ Vohenstrauss",
"499421", "Straubing",
"4939927", "Nossentiner\ Hütte",
"497073", "Ammerbuch",
"492759", "Bad\ Berleburg\-Aue",
"4939852", "Schönermark\ bei\ Prenzlau",
"492443", "Mechernich",
"499855", "Dentlein\ am\ Forst",
"496456", "Haina\ Kloster",
"496621", "Bad\ Hersfeld",
"4933971", "Kyritz\ Brandenburg",
"4938422", "Neukloster",
"499193", "Höchstadt\ an\ der\ Aisch",
"499778", "Fladungen",
"498251", "Aichach",
"497964", "Stödtlen",
"4933744", "Hohenseefeld",
"496342", "Schweigen\-Rechtenbach",
"496534", "Mülheim\ Mosel",
"496701", "Sprendlingen\ Rheinhessen",
"4939054", "Flechtingen",
"493901", "Salzwedel",
"499135", "Hessdorf\ Mittelfrankenanken",
"495141", "Celle",
"4939348", "Klitsche",
"497254", "Waghäusel",
"496061", "Michelstadt",
"492436", "Wegberg\-Rödgen",
"4934204", "Schkeuditz",
"492367", "Henrichenburg",
"498177", "Münsing\ Starnberger\ See",
"496753", "Meisenheim",
"495323", "Clausthal\-Zellerfeld",
"492644", "Linz\ am\ Rhein",
"492335", "Wetter\ Ruhr",
"496449", "Ehringshausen\-Katzenfurt",
"496272", "Hirschhorn\ Neckar",
"4939926", "Grabowhöfe",
"498203", "Grossaitingen",
"4935435", "Gollmitz\ bei\ Calau",
"495502", "Dransfeld",
"495357", "Grasleben",
"496727", "Gensingen",
"499167", "Oberscheinfeld",
"499546", "Burgebrach",
"4933631", "Bad\ Saarow\-Pieskow",
"495605", "Kaufungen\ Hessen",
"497348", "Beimerstetten",
"49711", "Stuttgart",
"4934785", "Sandersleben",
"499842", "Uffenheim",
"4935826", "Königshain\ bei\ Görlitz",
"493628", "Arnstadt",
"499971", "Cham",
"495806", "Barum\ bei\ Bad\ Bevensen",
"497634", "Sulzburg",
"498363", "Pfronten",
"495608", "Söhrewald",
"497345", "Langenau\ Württemberg",
"492173", "Langenfeld\ Rheinland",
"493522", "Grossenhain\ Sachsen",
"497736", "Tengen",
"495907", "Geeste",
"4934978", "Radegast\ Kreis\ Köthen",
"499243", "Pottenstein",
"4934363", "Cavertitz",
"4937752", "Eibenstock",
"4933673", "Weichensdorf",
"498631", "Mühldorf\ am\ Inn",
"4936648", "Dittersdorf\ bei\ Schleiz",
"494191", "Kaltenkirchen\ Holstein",
"496873", "Nonnweiler",
"492338", "Breckerfeld",
"498506", "Bad\ Höhenstadt",
"498802", "Huglfing",
"493303", "Birkenwerder",
"494423", "Fedderwarden",
"4936202", "Neudietendorf",
"497275", "Kandel",
"4933478", "Gross\ Neuendorf",
"494509", "Gross\ Grönau",
"499373", "Amorbach",
"492207", "Kürten\-Dürscheid",
"494606", "Wanderup",
"495921", "Nordhorn",
"4936074", "Worbis",
"494531", "Bad\ Oldesloe",
"4933765", "Märkisch\ Buchholz",
"494805", "Schafstedt",
"4939084", "Lindstedt",
"497446", "Lossburg",
"494704", "Drangstedt",
"4937463", "Bergen\ Vogtland",
"4939207", "Colbitz",
"498284", "Ziemetshausen",
"499099", "Kaisheim",
"499633", "Mitterteich",
"497244", "Weingarten\ Baden",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"495277", "Höxter\-Fürstenau",
"496433", "Hadamar",
"494382", "Wangels",
"495664", "Morschen",
"4934342", "Neukieritzsch",
"4934299", "Gaschwitz",
"495151", "Hameln",
"4938355", "Züssow",
"495766", "Rehburg\-Loccum",
"498241", "Buchloe",
"495722", "Bückeburg",
"496507", "Neumagen\-Dhron",
"496352", "Kirchheimbolanden",
"4935723", "Bernsdorf\ OL",
"4938452", "Lalendorf",
"4934445", "Stössen",
"499852", "Feuchtwangen",
"497905", "Langenburg",
"4939822", "Kratzeburg",
"497374", "Uttenweiler",
"499556", "Geiselwind",
"495347", "Burgdorf\ bei\ Salzgitter",
"4936462", "Ossmannstedt",
"4939957", "Gielow",
"494768", "Hipstedt",
"497358", "Eberhardzell\-Füramoos",
"496861", "Merzig",
"4937203", "Gersdorf\ bei\ Chemnitz",
"499659", "Leuchtenberg",
"498385", "Hergatz",
"494489", "Apen",
"492977", "Schmallenberg\-Bödefeld",
"497420", "Deisslingen",
"493943", "Wernigerode",
"4938306", "Samtens",
"492654", "Polch",
"496743", "Bacharach",
"495103", "Wennigsen\ Deister",
"492678", "Büchel\ bei\ Cochem",
"49385", "Schwerin",
"492161", "Mönchengladbach",
"498388", "Hergensweiler",
"492681", "Altenkirchen\ Westerwald",
"499227", "Neuenmarkt",
"499963", "Konzell",
"4939972", "Walkendorf",
"493491", "Lutherstadt\ Wittenberg",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"492572", "Emsdetten",
"492675", "Ediger\-Eller",
"499772", "Bischofsheim\ an\ der\ Rhön",
"495934", "Haren\-Rütenbrock",
"494447", "Vechta\-Langförden",
"4935872", "Neusalza\-Spremberg",
"4938482", "Warin",
"494524", "Scharbeutz\-Pönitz",
"4934464", "Freyburg\ Unstrut",
"499253", "Weissenstadt",
"4939225", "Altengrabow",
"494864", "Oldenswort",
"497355", "Hochdorf\ Riss",
"494765", "Ebersdorf\ bei\ Bremervörde",
"4933238", "Senzke",
"494737", "Stadland\-Schwei",
"497621", "Lörrach",
"497456", "Haiterbach",
"49906", "Donauwörth",
"4939773", "Altwarp",
"4937364", "Reitzenhain\ Erzgebirge",
"4936783", "Gehren\ Thüringen",
"493341", "Strausberg",
"4933454", "Wölsickendorf\/Wollenberg",
"495184", "Freden\ Leine",
"495482", "Tecklenburg",
"492234", "Frechen",
"496073", "Babenhausen\ Hessen",
"4935028", "Krippen",
"498624", "Obing",
"4933964", "Fretzdorf",
"498726", "Schönau\ Niederbayern",
"498762", "Wartenberg\ Oberbayern",
"499201", "Gesees",
"494284", "Selsingen",
"498805", "Hohenpeissenberg",
"498704", "Altdorf\-Pfettrach",
"498531", "Pocking",
"497739", "Hilzingen",
"4937434", "Bobenneukirchen",
"496254", "Lautertal\ Odenwald",
"493622", "Waltershausen\ Thüringen",
"499848", "Simmershofen",
"493525", "Riesa",
"498509", "Ruderting",
"498064", "Au\ bei\ Bad\ Aibling",
"497534", "Reichenau\ Baden",
"493764", "Meerane",
"493865", "Holthusen",
"495508", "Gleichen\-Rittmarshausen",
"494802", "Wrohm",
"498423", "Titting",
"498191", "Landsberg\ am\ Lech",
"496348", "Offenbach\ an\ der\ Queich",
"499280", "Selbitz\ Oberfranken",
"49611", "Wiesbaden",
"494506", "Stockelsdorf\-Krumbeck",
"494631", "Glücksburg\ Ostsee",
"497727", "Vöhrenbach",
"494609", "Eggebek",
"499074", "Höchstädt\ an\ der\ Donau",
"498457", "Vohburg\ an\ der\ Donau",
"497194", "Spiegelberg",
"497449", "Baiersbronn\-Obertal",
"497272", "Rülzheim",
"49281", "Wesel",
"497753", "Albbruck",
"4935202", "Klingenberg\ Sachsen",
"494363", "Lensahn",
"496396", "Hinterweidenthal",
"4936332", "Ellrich",
"492401", "Baesweiler",
"494740", "Loxstedt\-Dedesdorf",
"498783", "Rohr\ in\ Niederbayern",
"499132", "Herzogenaurach",
"499434", "Bodenwöhr",
"494203", "Weyhe\ bei\ Bremen",
"496736", "Bechenheim",
"496345", "Albersweiler",
"496634", "Gemünden\ Felda",
"495831", "Wittingen",
"499845", "Oberdachstetten",
"499744", "Zeitlofs\-Detter",
"494177", "Drage\ Elbe",
"496446", "Hohenahr",
"493528", "Radeberg",
"495602", "Hessisch\ Lichtenau",
"499646", "Freihung",
"495505", "Hardegsen",
"493868", "Rastow",
"494961", "Papenburg",
"4938307", "Poseritz",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"492453", "Heinsberg\-Randerath",
"496281", "Buchen\ Odenwald",
"499549", "Lisberg",
"498808", "Pähl",
"492332", "Gevelsberg",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"496275", "Rothenberg\ Odenwald",
"4939956", "Neukalen",
"494251", "Hoya",
"492427", "Nideggen",
"4933604", "Lebus",
"494340", "Achterwehr",
"497072", "Gomaringen",
"496694", "Neukirchen\ Knüll",
"499149", "Weissenburg\-Suffersheim",
"499192", "Gräfenberg",
"499274", "Hollfeld",
"4936848", "Wernshausen",
"497903", "Mainhardt",
"4936029", "Menteroda",
"493996", "Teterow",
"4938724", "Siggelkow",
"496745", "Gondershausen",
"496844", "Blieskastel\-Altheim",
"493586", "Neugersdorf\ Sachsen",
"49761", "Freiburg\ im\ Breisgau",
"499080", "Harburg\ Schwaben",
"495105", "Barsinghausen",
"4933873", "Grosswudicke",
"498383", "Grünenbach\ Allgäu",
"496336", "Dellfeld",
"496467", "Hatzfeld\ Eder",
"4934639", "Wallendorf\ Luppe",
"496435", "Wallmerod",
"492392", "Werdohl",
"4933200", "Bergholz\-Rehbrücke",
"497951", "Crailsheim",
"499836", "Gunzenhausen\-Cronheim",
"499344", "Gerchsheim",
"499532", "Maroldsweisach",
"4939243", "Nedlitz\ bei\ Zerbst",
"499635", "Bärnau",
"495641", "Warburg",
"496054", "Birstein",
"4936733", "Kaulsdorf",
"492732", "Kreuztal",
"4939751", "Penkun",
"4937604", "Mosel",
"497261", "Sinsheim",
"496078", "Gross\-Umstadt",
"4939402", "Völpke",
"498677", "Burghausen\ Salzach",
"4933434", "Herzfelde\ bei\ Strausberg",
"492387", "Drensteinfurt\-Walstedde",
"495224", "Enger\ Westfalen",
"498304", "Wildpoldsried",
"4936605", "Bad\ Köstritz",
"496081", "Usingen",
"49651", "Trier",
"494106", "Quickborn\ Kreis\ Pinneberg",
"497742", "Klettgau",
"496438", "Hünfelden",
"498591", "Obernzell",
"4939386", "Seehausen\ Altmark",
"499937", "Oberpöring",
"493364", "Eisenhüttenstadt",
"4934423", "Heuckewalde",
"499638", "Neualbenreuth",
"4936376", "Straussfurt",
"497134", "Weinsberg",
"497432", "Albstadt\-Tailfingen",
"494841", "Husum\ Nordsee",
"4935266", "Heyda\ bei\ Riesa",
"494972", "Langeoog",
"492673", "Ellenz\-Poltersdorf",
"495108", "Gehrden\ Han",
"497327", "Dischingen",
"4937323", "Lichtenberg\ Erzgebirge",
"499187", "Altdorf\ bei\ Nürnberg",
"4933831", "Weseram",
"493647", "Pössneck",
"499965", "Sankt\ Englmar",
"4938226", "Dierhagen\ Ostseebad",
"498131", "Dachau",
"499929", "Ruhmannsfelden",
"494763", "Gnarrenburg",
"4933923", "Flecken\ Zechlin",
"497353", "Schwendi",
"499255", "Marktleugast",
"492924", "Möhnesee",
"499120", "Leinburg",
"4939387", "Havelberg",
"498851", "Kochel\ am\ See",
"4936377", "Rastenberg",
"4938841", "Neuhaus\ Elbe",
"494208", "Grasberg",
"494329", "Langwedel\ Holstein",
"495584", "Hattorf\ am\ Harz",
"493431", "Döbeln",
"497854", "Kehl\-Goldscheuer",
"498469", "Freystadt\-Burggriesbach",
"494365", "Heringsdorf\ Holstein",
"497755", "Weilheim\ Kreis\ Waldshut",
"499372", "Klingenberg\ am\ Main",
"495468", "Bramsche\-Engter",
"496872", "Losheim\ am\ See",
"493741", "Plauen",
"498041", "Bad\ Tölz",
"494466", "Wittmund\-Ardorf",
"4933920", "Walsleben\ bei\ Neuruppin",
"494337", "Jevenstedt",
"494422", "Sande\ Kreis\ Friesl",
"494124", "Glückstadt",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"498803", "Peissenberg",
"493302", "Hennigsdorf",
"492294", "Morsbach\ Sieg",
"498326", "Fischen\ im\ Allgäu",
"492474", "Nideggen\-Schmidt",
"4939349", "Parey\ Elbe",
"4939292", "Biederitz",
"493863", "Crivitz",
"498362", "Füssen",
"4936944", "Rentwertshausen",
"4935267", "Diesbar\-Seusslitz",
"497044", "Mönsheim",
"495206", "Bielefeld\-Jöllenbeck",
"4937320", "Mulda\ Sachsen",
"4938227", "Lüdershagen\ bei\ Barth",
"499242", "Gössweinstein",
"493523", "Coswig\ bei\ Dresden",
"492455", "Waldfeucht",
"492561", "Ahaus",
"495503", "Nörten\-Hardenberg",
"4936965", "Stadtlengsfeld",
"4933870", "Zollchow\ bei\ Rathenow",
"499843", "Burgbernheim",
"4933479", "Küstrin\-Kietz",
"492821", "Kleve\ Niederrhein",
"494944", "Wiesmoor",
"495437", "Menslage",
"495366", "Jembke",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"496752", "Kirn\ Nahe",
"495322", "Bad\ Harzburg",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"498202", "Althegnenberg",
"4934384", "Grossbothen",
"497774", "Eigeltingen",
"4934743", "Ermsleben",
"4934691", "Könnern",
"496107", "Kelsterbach",
"4935322", "Doberlug\-Kirchhain",
"497676", "Feldberg\ Schwarzwald",
"4939001", "Apenburg",
"495465", "Neuenkirchen\ bei\ Bramsche",
"495551", "Northeim",
"4936730", "Sitzendorf",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"498771", "Ergoldsbach",
"496343", "Bad\ Bergzabern",
"497579", "Schwenningen\ Baden",
"4936649", "Gefell\ bei\ Schleiz",
"495429", "Melle\-Wellingholzhausen",
"4933203", "Kleinmachnow",
"498785", "Rottenburg\-Oberroning",
"494205", "Ottersberg",
"497336", "Lonsee",
"497467", "Neuhausen\ ob\ Eck",
"49941", "Regensburg",
"49661", "Fulda",
"497745", "Jestetten",
"497844", "Rheinau",
"494131", "Lüneburg",
"494109", "Tangstedt\ Bz\ Hamburg",
"4935771", "Bad\ Muskau",
"4935605", "Komptendorf",
"4938205", "Tessin\ bei\ Rostock",
"498841", "Murnau\ am\ Staffelsee",
"492738", "Netphen",
"495483", "Lienen",
"499252", "Helmbrechts",
"499773", "Unsleben",
"499198", "Heiligenstadt\ in\ Oberfranken",
"496261", "Mosbach\ Baden",
"497054", "Wildberg\ Württemberg",
"498106", "Vaterstetten",
"4934901", "Rosslau\ Elbe",
"492448", "Hellenthal\-Rescheid",
"4934658", "Hayn\ Harz",
"499962", "Schwarzach\ Niederbayern",
"499926", "Frauenau",
"4934298", "Taucha\ bei\ Leipzig",
"497435", "Albstadt\-Laufen",
"492573", "Nordwalde",
"4936626", "Auma",
"498051", "Prien\ am\ Chiemsee",
"494975", "Westerholt\ Ostfriesland",
"4938784", "Kleinow\ Kreis\ Prignitz",
"4934600", "Ostrau\ Saalkreis",
"498084", "Taufkirchen\ Vils",
"499827", "Lichtenau\ Mittelfranken",
"496301", "Otterbach\ Pfalz",
"4935932", "Guttau",
"4933239", "Gross\ Behnitz",
"4936764", "Neuhaus\-Schierschnitz",
"4937383", "Lunzenau",
"499146", "Markt\ Berolzheim",
"495404", "Westerkappeln",
"495102", "Laatzen",
"494954", "Moormerland",
"499567", "Sesslach\-Gemünda",
"4938754", "Leussow\ bei\ Ludwigslust",
"49751", "Ravensburg",
"493871", "Parchim",
"496742", "Boppard",
"493686", "Eisfeld",
"499853", "Wilburgstetten",
"497081", "Bad\ Wildbad",
"499195", "Adelsdorf\ Mittelfranken",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"494264", "Sottrum\ Kreis\ Rotenburg",
"496594", "Birresborn",
"496339", "Grosssteinhausen",
"4939832", "Wesenberg",
"492445", "Schleiden\ Eifel",
"494383", "Grebin",
"495723", "Bad\ Nenndorf",
"496353", "Freinsheim",
"492834", "Straelen",
"492735", "Neunkirchen\ Siegerl",
"4939721", "Liepen\ bei\ Anklam",
"499632", "Waldsassen",
"499260", "Wilhelmsthal\ Oberfranken",
"495541", "Hann\.\ Münden",
"499535", "Pfarrweisach",
"495976", "Salzbergen",
"496327", "Neustadt\-Lachen",
"498340", "Baisweil",
"496134", "Mainz\-Kastel",
"496432", "Diez",
"492395", "Finnentrop\-Rönkhausen",
"497748", "Grafenhausen\ Hochschwarzwald",
"4935455", "Walddrehna",
"498205", "Dasing",
"494884", "Schwabstedt",
"4936425", "Isserstedt",
"49591", "Lingen\ \(Ems\)",
"496854", "Oberthal\ Saar",
"496755", "Odernheim\ am\ Glan",
"495325", "Goslar\-Hahnenklee",
"494771", "Hemmoor",
"492333", "Ennepetal",
"492154", "Willich",
"492452", "Heinsberg\ Rheinland",
"498368", "Halblech",
"492661", "Bad\ Marienberg\ Westerwald",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"495603", "Gudensberg",
"4939034", "Fleetmark",
"4934221", "Schildau\ Gneisenaustadt",
"494202", "Achim\ bei\ Bremen",
"499133", "Baiersdorf\ Mittelfrankenanken",
"4938392", "Sassnitz",
"498782", "Pfeffenhausen",
"4939327", "Klietz",
"496044", "Schotten\ Hessen",
"495462", "Ankum",
"495164", "Hodenhagen",
"499354", "Rieneck",
"497576", "Krauchenwies",
"499378", "Eichenbühl\-Riedern",
"495651", "Eschwege",
"495426", "Glandorf",
"492359", "Kierspe",
"49221", "Cologne",
"497941", "Öhringen",
"497121", "Reutlingen",
"499375", "Freudenberg\ Baden",
"495684", "Frielendorf",
"499904", "Lalling",
"494362", "Heiligenhafen",
"499381", "Volkach",
"494326", "Wankendorf",
"4934324", "Ostrau\ Sachsen",
"497273", "Hagenbach\ Pfalz",
"498124", "Forstern\ Oberbayern",
"498422", "Dollnstein",
"494803", "Pahlen",
"498466", "Denkendorf\ Oberbayern",
"498337", "Altenstadt\ Iller",
"4933333", "Tantow",
"492931", "Arnsberg",
"499245", "Obertrubach",
"495231", "Detmold",
"492181", "Grevenbroich",
"493623", "Friedrichroda",
"498365", "Wertach",
"494469", "Wangerooge",
"497343", "Buch\ bei\ Illertissen",
"4933394", "Blumberg\ Kreis\ Barnim",
"492175", "Leichlingen\ Rheinland",
"498208", "Eurasburg\ bei\ Augsburg",
"494425", "Wangerland\-Hooksiel",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"4939262", "Güsten\ Anh",
"496676", "Hohenroda\ Hessen",
"496881", "Lebach",
"495209", "Gütersloh\-Friedrichsdorf",
"495328", "Altenau\ Harz",
"496758", "Waldböckelheim",
"494851", "Marne",
"496875", "Nonnweiler\-Primstal",
"496774", "Kaub",
"4936459", "Blankenhain\ Thüringen",
"497130", "Löwenstein\ Württemberg",
"496062", "Erbach\ Odenwald",
"4935820", "Zodel",
"496026", "Grossostheim",
"4933768", "Prieros",
"495553", "Kalefeld",
"492405", "Würselen",
"496341", "Landau\ in\ der\ Pfalz",
"498773", "Neufahrn\ in\ Niederbayern",
"4933475", "Letschin",
"498252", "Schrobenhausen",
"494638", "Tarp",
"497477", "Jungingen\ bei\ Hechingen",
"499106", "Markt\ Erlbach",
"495199", "Schneverdingen\-Heber",
"495444", "Wagenfeld",
"495142", "Eschede",
"4936969", "Merkers",
"495527", "Duderstadt",
"4939364", "Dolle",
"4933652", "Neuzelle",
"493902", "Diesdorf\ Altm",
"494187", "Holm\-Seppensen",
"4935756", "Hosena",
"495636", "Lichtenfels\-Goddelsheim",
"4938391", "Altenkirchen\ Rügen",
"4934222", "Arzberg\ bei\ Torgau",
"494965", "Surwold",
"492563", "Stadtlohn",
"495835", "Wahrenholz",
"499841", "Bad\ Windsheim",
"499972", "Waldmünchen",
"495734", "Bergkirchen\ Westfalen",
"496157", "Pfungstadt",
"492823", "Goch",
"4936645", "Mühltroff",
"497708", "Geisingen\-Leipferdingen",
"49841", "Ingolstadt\ Donau",
"4938796", "Viesecke",
"498538", "Pocking\-Hartkirchen",
"496271", "Eberbach\ Baden",
"492306", "Lünen",
"4934975", "Görzig\ Kreis\ Köthen",
"494255", "Martfeld",
"496285", "Walldürn\-Altheim",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"496123", "Eltville\ am\ Rhein",
"492857", "Rees\-Mehr",
"494929", "Ihlow\ Kreis\ Aurich",
"494192", "Bad\ Bramstedt",
"494494", "Bösel\ Oldenburg",
"494149", "Fredenbeck",
"498535", "Haarbach",
"494274", "Varrel\ bei\ Sulingen",
"4935694", "Gosda\ bei\ Klinge",
"494258", "Schwarme",
"498043", "Jachenau",
"499340", "Königheim\-Brehmen",
"492777", "Breitscheid\ Hessen",
"4939203", "Barleben",
"4937467", "Klingenthal\ Sachsen",
"498801", "Seeshaupt",
"4938294", "Neubukow",
"496050", "Biebergemünd",
"493861", "Plate",
"494968", "Neulehe",
"492266", "Lindlar",
"494667", "Dagebüll",
"495838", "Gross\ Oesingen",
"493521", "Meissen",
"497705", "Wolterdingen\ Schwarzw",
"492222", "Bornheim\ Rheinland",
"497804", "Oppenau",
"494344", "Schönberg\ Holstein",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"494532", "Bargteheide",
"495966", "Meppen\-Apeldorn",
"494635", "Sörup",
"495922", "Bad\ Bentheim",
"4938374", "Lassan\ bei\ Wolgast",
"499270", "Creussen",
"494836", "Hennstedt\ Dithmarschen",
"4939345", "Parchen",
"493433", "Borna\ Stadt",
"499084", "Bissingen\ Schwaben",
"4938233", "Prerow\ Ostseebad",
"4933677", "Glienicke\ bei\ Beeskow",
"498146", "Moorenweis",
"492408", "Aachen\-Kornelimünster",
"498378", "Buchenberg\ bei\ Kempten",
"494843", "Viöl",
"492671", "Cochem",
"492582", "Everswinkel",
"495379", "Sassenburg\-Grussendorf",
"492685", "Flammersfeld",
"498133", "Haimhausen\ Oberbayern",
"4935772", "Rietschen",
"492992", "Marsberg",
"497351", "Biberach\ an\ der\ Riss",
"4939200", "Gommern",
"496868", "Mettlach\-Tünsdorf",
"496186", "Grosskrotzenburg",
"494761", "Bremervörde",
"499944", "Miltach",
"494156", "Talkau",
"498248", "Lamerdingen",
"497826", "Schuttertal",
"493634", "Sömmerda",
"495472", "Bad\ Essen",
"495174", "Lahstedt",
"497566", "Argenbühl",
"497625", "Zell\ im\ Wiesental",
"495292", "Lichtenau\-Atteln",
"498036", "Stephanskirchen\ Simssee",
"497147", "Sachsenheim\ Württemberg",
"497522", "Wangen\ im\ Allgäu",
"496083", "Weilrod",
"4933676", "Friedland\ bei\ Beeskow",
"495158", "Hemeringen",
"498593", "Untergriesbach",
"497669", "St\ Märgen",
"4938328", "Miltzow",
"499205", "Vorbach",
"497303", "Illertissen",
"4935973", "Stolpen",
"4935931", "Königswartha",
"499208", "Bindlach",
"4939923", "Priborn",
"497953", "Blaufelden",
"492137", "Neuss\-Norf",
"494120", "Ellerhoop",
"495032", "Neustadt\ am\ Rübenberge",
"498296", "Villenbach",
"492324", "Hattingen\ Ruhr",
"495643", "Borgentreich",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"498245", "Türkheim\ Wertach",
"494372", "Westfehmarn",
"497263", "Waibstadt",
"4936025", "Körner",
"496837", "Wallerfangen",
"497628", "Efringen\-Kirchen",
"4939831", "Feldberg",
"495155", "Emmerthal",
"4935823", "Ostritz",
"499365", "Rimpar",
"499466", "Stamsried",
"499337", "Gaukönigshofen",
"499422", "Bogen\ Niederbayern",
"496764", "Rheinböllen",
"4938797", "Karstädt\ Kreis\ Prignitz",
"496865", "Mettlach\-Orscholz",
"493964", "Bredenfelde\ bei\ Strasburg",
"492597", "Senden\ Westfalen",
"496622", "Bebra",
"497384", "Schelklingen\-Hütten",
"4939722", "Sarnow\ bei\ Anklam",
"496666", "Freiensteinau",
"496525", "Irrel",
"492129", "Haan\ Rheinland",
"497939", "Schrozberg\-Spielbach",
"494242", "Syke",
"494479", "Molbergen\-Peheim",
"498375", "Weitnau",
"496569", "Bickendorf",
"492165", "Jüchen",
"498381", "Lindenberg\ im\ Allgäu",
"4934635", "Bad\ Lauchstädt",
"496004", "Lich\-Eberstadt",
"492688", "Kroppach",
"497702", "Blumberg\ Baden",
"492225", "Meckenheim\ Rheinland",
"494146", "Stade\-Bützfleth",
"499954", "Simbach\ Niederbayern",
"4939776", "Hintersee",
"499978", "Schönthal\ Oberpfalz",
"496297", "Ravenstein\ Baden",
"495233", "Steinheim\ Westfalen",
"492183", "Rommerskirchen",
"493621", "Gotha\ Thüringen",
"496477", "Greifenstein\-Nenderoth",
"4936254", "Friedrichswerth",
"499677", "Oberviechtach\-Pullenried",
"494827", "Wacken",
"4938842", "Lüttenmark",
"499264", "Küps",
"494853", "Sankt\ Michaelisdonn",
"498635", "Pleiskirchen",
"492269", "Kierspe\-Rönsahl",
"49203", "Duisburg",
"497026", "Lenningen",
"498344", "Westendorf\ bei\ Kaufbeuren",
"494195", "Hartenholm",
"4936694", "Schkölen\ Thüringen",
"496130", "Schwabenheim\ an\ der\ Selz",
"498532", "Griesbach\ im\ Rottal",
"497062", "Beilstein\ Württemberg",
"497123", "Metzingen\ Württemberg",
"498667", "Seeon\-Seebruck",
"4933093", "Fürstenberg\ Havel",
"494950", "Holtland",
"496068", "Beerfelden",
"494839", "Wöhrden\ Dithmarschen",
"499383", "Wiesentheid",
"497271", "Wörth\ am\ Rhein",
"4939291", "Calbe\ Saale",
"497157", "Waldenbuch",
"495259", "Bad\ Driburg\-Neuenheerse",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"495148", "Steinhorst\ Niedersachsen",
"49531", "Braunschweig",
"494632", "Steinbergkirche",
"498258", "Sielenbach",
"495925", "Wietmarschen",
"494260", "Visselhövede\-Wittorf",
"498192", "Schondorf\ am\ Ammersee",
"498274", "Buttenwiesen",
"494535", "Nahe",
"492933", "Sundern\ Sauerland",
"496804", "Mandelbachtal",
"4933844", "Brück\ Brandenburg",
"499131", "Erlangen",
"495145", "Beedenbostel",
"496029", "Mömbris",
"49441", "Oldenburg",
"4937206", "Frankenberg\ Sachsen",
"492104", "Mettmann",
"492402", "Stolberg\ Rheinland",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"495653", "Sontra",
"4938303", "Sellin\ Ostseebad",
"495196", "Wietzendorf",
"497943", "Schöntal\ Jagst",
"4939394", "Hohenberg\-Krusemark",
"4934692", "Alsleben\ Saale",
"496282", "Walldürn",
"4939002", "Oebisfelde",
"494252", "Bruchhausen\-Vilsen",
"498638", "Waldkraiburg",
"492331", "Hagen\ Westfalen",
"494773", "Lamstedt",
"492309", "Waltrop",
"492228", "Remagen\-Rolandseck",
"495832", "Hankensbüttel",
"499975", "Waldmünchen\-Geigant",
"494962", "Papenburg\-Aschendorf",
"495536", "Holzminden\-Neuhaus",
"494926", "Krummhörn\-Greetsiel",
"495601", "Schauenburg",
"4935726", "Gross\ Särchen",
"492663", "Westerburg\ Westerwald",
"495454", "Hörstel\-Riesenbeck",
"495152", "Hessisch\ Oldendorf",
"497528", "Neukirch\ bei\ Tettnang",
"494381", "Lütjenburg",
"499326", "Markt\ Einersheim",
"4938300", "Insel\ Hiddensee",
"4937207", "Hainichen\ Sachsen",
"495721", "Stadthagen",
"496351", "Eisenberg\ Pfalz",
"4935025", "Liebstadt",
"495035", "Gross\ Munzel",
"495543", "Staufenberg\ Niedersachsen",
"499803", "Colmberg",
"4939953", "Schwinkendorf",
"4933235", "Friesack",
"499469", "Roding\-Neubäu",
"496303", "Enkenbach\-Alsenborn",
"492588", "Harsewinkel\-Greffen",
"4935727", "Burghammer",
"492464", "Aldenhoven\ bei\ Jülich",
"492162", "Viersen",
"496669", "Neuhof\-Hauswurz",
"494245", "Neuenkirchen\ bei\ Bassum",
"498372", "Obergünzburg",
"495067", "Bockenem",
"496522", "Mettendorf",
"497083", "Bad\ Herrenalb",
"497936", "Schrozberg\-Bartenstein",
"492697", "Blankenheim\-Ahrhütte",
"495707", "Petershagen\ Weser",
"494296", "Schwanewede\-Aschwarden",
"499851", "Dinkelsbühl",
"496566", "Körperich",
"496625", "Niederaula",
"4934774", "Röblingen\ am\ See",
"496147", "Trebur",
"4939752", "Blumenhagen\ bei\ Strasburg",
"4939401", "Neuwegersleben",
"496826", "Bexbach",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"497837", "Oberharmersbach",
"496628", "Oberaula",
"4938209", "Sanitz\ bei\ Rostock",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"493727", "Mittweida",
"496263", "Neckargerach",
"499428", "Kirchroth",
"49214", "Leverkusen",
"4935609", "Drachhausen",
"498027", "Dietramszell",
"492682", "Hamm\ Sieg",
"4939777", "Borkenfriede",
"499350", "Eussenheim\-Hundsbach",
"492585", "Warendorf\-Hoetmar",
"494159", "Basthorst",
"498053", "Bad\ Endorf",
"494248", "Bassum\-Neubruchhausen",
"492571", "Greven\ Westfalen",
"495246", "Verl",
"497569", "Isny\-Eisenbach",
"498761", "Moosburg\ an\ der\ Isar",
"4937348", "Oberwiesenthal\ Kurort",
"498039", "Rott\ am\ Inn",
"499202", "Waischenfeld",
"494133", "Wittorf\ Kreis\ Lüneburg",
"4933832", "Rogäsen",
"497666", "Denzlingen",
"497525", "Aulendorf",
"495475", "Bohmte\-Hunteburg",
"495295", "Lichtenau\ Westfalen",
"497622", "Schopfheim",
"496384", "Konken",
"4936085", "Reinholterode",
"497764", "Herrischried",
"492150", "Meerbusch\-Lank",
"494354", "Fleckeby",
"493342", "Neuenhagen\ bei\ Berlin",
"495481", "Lengerich\ Westfalen",
"495957", "Lindern\ Oldenburg",
"494407", "Wardenburg",
"4936653", "Lehesten\ Thüringer\ Wald",
"4935263", "Gröditz\ bei\ Riesa",
"493327", "Werder\ Havel",
"495776", "Preussisch\ Ströhen",
"499385", "Kolitzheim",
"497948", "Öhringen\-Ohrnberg",
"4937326", "Frauenstein\ Sachsen",
"497125", "Bad\ Urach",
"495674", "Grebenstein",
"495658", "Wehretal",
"4938223", "Saal\ Vorpom",
"499371", "Miltenberg",
"495923", "Schüttorf",
"492935", "Sundern\-Hachen",
"494533", "Reinfeld\ Holstein",
"4933926", "Herzberg\ Mark",
"498556", "Haidmühle",
"498361", "Nesselwang",
"494559", "Wensin",
"495820", "Suhlendorf",
"493594", "Bischofswerda",
"492171", "Leverkusen\-Opladen",
"4936458", "Bad\ Berka",
"492223", "Königswinter",
"496589", "Kell\ am\ See",
"4933769", "Töpchin",
"499241", "Pegnitz",
"495235", "Blomberg\ Lippe",
"494754", "Bülkau",
"498042", "Lenggries",
"498633", "Tüssling",
"494855", "Eddelak",
"4939383", "Sandau\ Elbe",
"497364", "Oberkochen",
"496871", "Wadern",
"4939744", "Rothenklempenow",
"494193", "Henstedt\-Ulzburg",
"494778", "Wingst",
"4934426", "Kayna",
"494421", "Wilhelmshaven",
"4936968", "Rossdorf\ Rhön",
"4933054", "Liebenwalde",
"4935201", "Langebrück",
"493301", "Oranienburg",
"492257", "Reckerscheid",
"496784", "Weierbach",
"493984", "Prenzlau",
"4936373", "Buttstädt",
"498860", "Bernbeuren",
"494858", "Sankt\ Margarethen\ Holstein",
"496751", "Bad\ Sobernheim",
"495321", "Goslar",
"4936331", "Ilfeld",
"494775", "Grossenwörden",
"494874", "Todenbüttel",
"499624", "Ensdorf\ Oberpfalz",
"4933084", "Gutengermendorf",
"499762", "Saal\ an\ der\ Saale",
"496424", "Ebsdorfergrund",
"496122", "Hofheim\-Wallau",
"4939246", "Lindau\ Anh",
"496888", "Lebach\-Steinbach",
"4933207", "Gross\ Kreutz",
"496166", "Fischbachtal",
"499726", "Euerbach",
"4936736", "Arnsgereuth",
"492562", "Gronau\ Westfalen",
"492526", "Sendenhorst",
"498239", "Langenneufnach",
"497204", "Malsch\-Völkersbach",
"492822", "Emmerich",
"495238", "Nieheim\-Himmighausen",
"499973", "Furth\ im\ Wald",
"492866", "Dorsten\-Rhade",
"498253", "Pöttmes",
"498772", "Mallersdorf\-Pfaffenberg",
"492938", "Ense",
"494236", "Kirchlinteln",
"492637", "Weissenthurm",
"496703", "Wöllstein\ Rheinhessen",
"495143", "Winsen\ Aller",
"497586", "Herbertingen",
"49361", "Erfurt",
"4935439", "Zinnitz",
"496063", "Bad\ König",
"497945", "Wüstenrot",
"4933876", "Buschow",
"497128", "Sonnenbühl",
"495552", "Katlenburg",
"495307", "Braunschweig\-Wenden",
"495655", "Wanfried",
"495136", "Burgdorf\ Kreis\ Hannover",
"498074", "Schnaitsee",
"4934746", "Giersleben",
"494243", "Twistringen",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"4939994", "Metschow",
"4936737", "Drognitz",
"493774", "Schwarzenberg",
"496305", "Hochspeyer",
"496657", "Hofbieber",
"493881", "Grevesmühlen",
"4938854", "Redefin",
"497071", "Tübingen",
"496268", "Hüffenhardt",
"499423", "Geiselhöring",
"4934341", "Geithain",
"492441", "Kall",
"497085", "Enzklösterle",
"4933206", "Fichtenwalde",
"4935894", "Hähnichen",
"499191", "Forchheim\ Oberfranken",
"4939247", "Güterglück",
"496623", "Rotenburg\ an\ der\ Fulda",
"4933877", "Nitzahn",
"497262", "Eppingen",
"497226", "Bühl\-Sand",
"4938451", "Hoppenrade\ bei\ Güstrow",
"492504", "Telgte",
"4939821", "Carpin",
"4936461", "Bad\ Sulza",
"495849", "Waddeweitz",
"4936608", "Seelingstädt\ bei\ Gera",
"499805", "Burgoberbach",
"4939933", "Vollrathsruhe",
"497952", "Gerabronn",
"499704", "Euerdorf",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"492391", "Plettenberg",
"496406", "Lollar",
"495642", "Warburg\-Scherfede",
"499606", "Pfreimd",
"495033", "Wunstorf\-Grossenheidorn",
"495545", "Hedemünden",
"499531", "Ebern",
"4933927", "Linum",
"49209", "Gelsenkirchen",
"497741", "Tiengen\ Hochrhein",
"498592", "Wegscheid\ Niederbayern",
"498549", "Vilshofen\-Pleinting",
"496190", "Hattersheim\ am\ Main",
"494135", "Kirchgellersen",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"497557", "Herdwangen\-Schönach",
"4939971", "Gnoien",
"4937327", "Rechenberg\-Bienenmühle",
"4938220", "Wustrow\ Ostseebad",
"498845", "Bad\ Kohlgrub",
"4938481", "Witzin",
"498744", "Gerzen",
"496082", "Niederreifenberg",
"495473", "Ostercappeln",
"495293", "Paderborn\-Dahl",
"496237", "Maxdorf",
"4936370", "Grossenehrich",
"496265", "Billigheim\ Baden",
"492993", "Marsberg\-Canstein",
"4933704", "Baruth\ Mark",
"498434", "Rennertshofen",
"497250", "Kraichtal",
"494842", "Nordstrand",
"497431", "Albstadt\-Ebingen",
"498055", "Halfing",
"4936845", "Gehlberg",
"494971", "Esens",
"496308", "Olsbrücken",
"496229", "Neckarsteinach",
"494167", "Apensen",
"494546", "Mustin\ Lauenburg",
"4934244", "Mockrehna",
"4935474", "Schönwalde\ bei\ Lübben",
"49571", "Minden\ Westfalen",
"492583", "Sassenberg",
"495833", "Brome",
"496897", "Sulzbach\ Saar",
"492724", "Finnentrop\-Serkenrode",
"492825", "Uedem",
"492662", "Hachenburg",
"492451", "Geilenkirchen",
"492565", "Gronau\-Epe",
"492626", "Selters\ Westferwald",
"494963", "Dörpen",
"499729", "Grettstadt",
"496283", "Hardheim\ Odenwald",
"492529", "Oelde\-Stromberg",
"496647", "Herbstein\-Stockhausen",
"498236", "Fischach",
"499765", "Trappstadt",
"494772", "Oberndorf\ Oste",
"499447", "Essing",
"4939323", "Schönhausen\ Elbe",
"499524", "Zeil\ am\ Main",
"494253", "Asendorf\ Kreis\ Diepholz",
"495652", "Bad\ Sooden\-Allendorf",
"492403", "Eschweiler\ Rheinland",
"495555", "Moringen\-Fredelsloh",
"495461", "Bramsche\ Hase",
"499737", "Wartmannsroth",
"49351", "Dresden",
"494239", "Dörverden\-Westen",
"4934607", "Wettin",
"497942", "Neuenstein\ Württemberg",
"496364", "Nussbach\ Pfalz",
"498781", "Rottenburg\ an\ der\ Laaber",
"495859", "Thomasburg",
"4933632", "Hangelsberg",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"499397", "Wertheim\-Dertingen",
"498858", "Kochel\-Walchensee",
"498421", "Eichstätt\ Bayern",
"498656", "Anger",
"496204", "Viernheim",
"492932", "Neheim\-Hüsten",
"498193", "Geltendorf",
"498754", "Volkenschwand",
"494633", "Satrup",
"4939604", "Wildberg\ bei\ Altentreptow",
"495574", "Oberweser",
"497166", "Adelberg",
"497122", "St\ Johann\ Württemberg",
"497424", "Spaichingen",
"499382", "Gerolzhofen",
"493435", "Oschatz",
"494361", "Oldenburg\ in\ Holstein",
"4936623", "Berga\ Elster",
"497751", "Waldshut",
"494556", "Ahrensbök\-Gnissau",
"4936201", "Walschleben",
"496128", "Taunusstein",
"497240", "Pfinztal",
"497063", "Bad\ Wimpfen",
"493745", "Falkenstein\ Vogtland",
"498533", "Rotthalmünster",
"493844", "Schwaan",
"496586", "Beuren\ Hochwald",
"498045", "Lenggries\-Fall",
"4933337", "Altkünkendorf",
"494852", "Brunsbüttel",
"492182", "Grevenbroich\-Kapellen",
"495232", "Lage\ Lippe",
"492484", "Mechernich\-Eiserfey",
"492828", "Emmerich\-Elten",
"497703", "Bonndorf\ im\ Schwarzwald",
"4936428", "Stadtroda",
"498407", "Grossmehring",
"492568", "Heek",
"492377", "Wickede\ Ruhr",
"4939881", "Ringenwalde\ bei\ Templin",
"497623", "Rheinfelden\ Baden",
"498167", "Zolling",
"498546", "Windorf\-Otterskirchen",
"496085", "Waldsolms",
"496071", "Dieburg",
"4936871", "Bad\ Colberg\-Heldburg",
"497268", "Bad\ Rappenau\-Obergimpern",
"497657", "Eisenbach\ Hochschwarzwald",
"497305", "Erbach\ Donau",
"495648", "Brakel\-Gehrden",
"497974", "Bühlerzell",
"494434", "Colnrade",
"495947", "Laar\ Vechte",
"494132", "Amelinghausen",
"499203", "Neudrossenfeld",
"497958", "Rot\ Am\ See\-Brettheim",
"498649", "Schleching",
"492247", "Neunkirchen\-Seelscheid",
"494646", "Mohrkirch",
"4936043", "Kirchheilingen",
"499961", "Mitterfels",
"492683", "Asbach\ Westerwald",
"4933731", "Trebbin",
"493493", "Bitterfeld",
"494845", "Ostenfeld\ Husum",
"4939484", "Harzgerode",
"498052", "Aschau\ im\ Chiemgau",
"494744", "Loxstedt",
"499177", "Heideck",
"499251", "Münchberg",
"496226", "Meckesheim",
"4933336", "Passow\ Kreis\ Uckermark",
"498135", "Sulzemoos",
"496262", "Aglasterhausen",
"496630", "Schwalmtal\-Storndorf",
"495139", "Burgwedel",
"4939320", "Schinne",
"497237", "Neulingen\ Enzkreis",
"496523", "Holsthum",
"497082", "Neuenbürg\ Württemberg",
"498138", "Schwabhausen\ bei\ Dachau",
"4934295", "Krensitz",
"499284", "Schwarzenbach\ an\ der\ Saale",
"495056", "Winsen\-Meissendorf",
"493679", "Neuhaus\ am\ Rennweg",
"4937292", "Oederan",
"4937349", "Scheibenberg",
"4938824", "Mallentin",
"499070", "Tapfheim",
"496557", "Hallschlag",
"493576", "Weisswasser",
"496302", "Winnweiler",
"498373", "Altusried",
"496741", "St\ Goar",
"494848", "Rantrum",
"4939454", "Elbingerode\ Harz",
"493941", "Halberstadt",
"492163", "Schwalmtal\ Niederrhein",
"495101", "Pattensen",
"4935242", "Nossen",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"495542", "Witzenhausen",
"4938208", "Kavelstorf",
"499631", "Tirschenreuth",
"495645", "Borgentreich\-Borgholz",
"497308", "Nersingen",
"497229", "Iffezheim",
"492066", "Duisburg\-Homberg",
"495127", "Harsum",
"496431", "Limburg\ an\ der\ Lahn",
"4935608", "Gross\ Ossnig",
"4935951", "Neukirch\ Lausitz",
"499802", "Ansbach\-Katterbach",
"497955", "Wallhausen\ Württemberg",
"495846", "Gartow\ Niedersachsen",
"4936921", "Wutha\-Farnroda",
"492604", "Nassau\ Lahn",
"4939851", "Göritz\ bei\ Prenzlau",
"495153", "Salzhemmendorf",
"496409", "Biebertal",
"499363", "Arnstein\ Unterfranken",
"495696", "Bad\ Arolsen\-Landau",
"498243", "Fuchstal",
"4933972", "Breddin",
"497265", "Angelbachtal",
"4934606", "Teicha\ Sachsen\-Anhalt",
"498687", "Taching\-Tengling",
"4933977", "Gumtow",
"4934385", "Mutzschen",
"495586", "Wieda",
"4937382", "Geringswalde",
"499931", "Plattling",
"495945", "Wilsum",
"4935933", "Neschwitz",
"497552", "Pfullendorf",
"497307", "Senden\ Iller",
"495128", "Hohenhameln",
"497655", "Feldberg\-Altglashütten",
"495882", "Gorleben",
"4939921", "Ankershagen",
"492904", "Bestwig",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"492381", "Hamm\ Westfalen",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"496087", "Waldems",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"498165", "Neufahrn\ bei\ Freising",
"496232", "Speyer",
"497143", "Besigheim",
"496660", "Steinau\-Marjoss",
"492375", "Balve",
"498324", "Hindelang",
"492296", "Reichshof\-Brüchermühle",
"4935247", "Zehren\ Sachsen",
"498137", "Petershausen",
"497046", "Zaberfeld",
"4936964", "Dermbach\ Rhön",
"495204", "Steinhagen\ Westfalen",
"4939748", "Viereck",
"497321", "Heidenheim\ an\ der\ Brenz",
"4938464", "Bernitt",
"499175", "Spalt",
"4937297", "Thum\ Sachsen",
"494847", "Oster\-Ohrstedt",
"496558", "Büdesheim\ Eifel",
"494162", "Jork",
"494464", "Wittmund\-Carolinensiel",
"4936454", "Magdala",
"493641", "Jena",
"496574", "Hasborn",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"494126", "Horst\ Holstein",
"492245", "Much",
"495364", "Velpke",
"494682", "Amrum",
"499452", "Langquaid",
"499154", "Pommelsbrunn",
"494946", "Grossefehn\-Bagband",
"499661", "Sulzbach\-Rosenberg",
"499178", "Abenberg\ Mittelfranken",
"492983", "Winterberg\-Siedlinghausen",
"4936484", "Knau\ bei\ Pössneck",
"496555", "Bleialf",
"496461", "Biedenkopf",
"492159", "Meerbusch\-Osterath",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"496652", "Hünfeld",
"492248", "Hennef\-Uckerath",
"4938379", "Benz\ Usedom",
"4936945", "Henneberg",
"4933088", "Falkenthal",
"499333", "Sommerhausen",
"49345", "Halle\ Saale",
"492593", "Ascheberg\ Westfalen",
"497235", "Unterreichenbach\ Kreis\ Calw",
"498685", "Kirchanschöring",
"499359", "Karlstadt\-Wiesenfeld",
"49208", "Oberhausen\ Rheinland",
"497267", "Gemmingen",
"498582", "Röhrnbach",
"49921", "Bayreuth",
"498168", "Attenkirchen",
"498671", "Altötting",
"492354", "Meinerzhagen",
"496833", "Rehlingen\-Siersburg",
"492378", "Fröndenberg\-Langschede",
"497957", "Kressberg",
"4935971", "Sebnitz",
"495948", "Itterbeck",
"497674", "Todtmoos",
"496092", "Heimbuchenthal",
"496049", "Kefenrod",
"495647", "Lichtenau\-Kleinenberg",
"492133", "Dormagen",
"495283", "Lügde\-Rischenau",
"495250", "Delbrück\ Westfalen",
"4939201", "Wolmirstedt",
"495431", "Quakenbrück",
"499445", "Neustadt\ an\ der\ Donau",
"492853", "Schermbeck",
"496127", "Niedernhausen\ Taunus",
"494269", "Ahausen\-Kirchwalsede",
"4935383", "Elster\ Elbe",
"496645", "Ulrichstein",
"492195", "Radevormwald",
"496542", "Bullay",
"496599", "Weidenbach\ bei\ Gerolstein",
"496334", "Thaleischweiler\-Fröschen",
"49771", "Donaueschingen",
"4938858", "Lassahn",
"492567", "Ahaus\-Alstätte",
"494183", "Jesteburg",
"4933332", "Gartz\ Oder",
"496696", "Gilserberg",
"4939998", "Loitz\ bei\ Demmin",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"4939428", "Pabstorf",
"492827", "Goch\-Hassum",
"494959", "Dollart",
"499276", "Bischofsgrün",
"493994", "Malchin",
"494830", "Süderhastedt",
"492801", "Xanten",
"4933435", "Rehfelde",
"496056", "Bad\ Soden\-Salmünster",
"495863", "Zernien",
"499395", "Triefenstein",
"492632", "Andernach",
"495523", "Bad\ Sachsa",
"492043", "Gladbeck",
"492535", "Sendenhorst\-Albersloh",
"497473", "Mössingen",
"4936604", "Münchenbernsdorf",
"496139", "Budenheim",
"494933", "Dornum\ Ostfriesland",
"498222", "Burgau\ Schwaben",
"4938231", "Barth",
"496101", "Bad\ Vilbel",
"499834", "Theilenhofen",
"498266", "Kirchheim\ in\ Schwaben",
"499735", "Massbach",
"495741", "Lübbecke",
"495302", "Vechelde",
"4939263", "Unseburg",
"499346", "Grünsfeld",
"492839", "Straelen\-Herongen",
"493322", "Falkensee",
"498823", "Mittenwald",
"495952", "Sögel",
"494402", "Rastede",
"494104", "Aumühle\ bei\ Hamburg",
"499738", "Rottershausen",
"493366", "Beeskow",
"493437", "Grimma",
"497033", "Weil\ Der\ Stadt",
"498563", "Bad\ Birnbach\ Rottal",
"497642", "Endingen\ Kaiserstuhl",
"4933637", "Beerfelde",
"497545", "Immenstaad\ am\ Bodensee",
"498857", "Benediktbeuern",
"495262", "Extertal",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"499398", "Birkenfeld\ bei\ Würzburg",
"4937605", "Hartenstein\ Sachsen",
"4933976", "Wutike",
"4935930", "Seitschen",
"495226", "Bruchmühlen\ Westfalen",
"49241", "Aachen",
"4938334", "Grammendorf",
"492538", "Drensteinfurt\-Rinkerode",
"498306", "Ronsberg",
"4937296", "Stollberg\ Erzgebirge",
"4935478", "Goyatz",
"498405", "Stammham\ bei\ Ingolstadt",
"495071", "Schwarmstedt",
"499573", "Staffelstein\ Oberfranken",
"495085", "Burgdorf\-Ehlershausen",
"492962", "Olsberg",
"4938393", "Binz\ Ostseebad",
"494791", "Osterholz\-Scharmbeck",
"496898", "Völklingen",
"494663", "Süderlügum",
"4938725", "Gross\ Godems",
"49212", "Solingen",
"4935246", "Ziegenhain\ Sachsen",
"497136", "Bad\ Friedrichshall",
"496020", "Heigenbrücken",
"499448", "Hausen\ Niederbayern",
"496648", "Bad\ Salzschlirf",
"492252", "Zülpich",
"4933708", "Rangsdorf",
"494331", "Rendsburg",
"492773", "Haiger",
"497232", "Königsbach\-Stein",
"497660", "St\ Peter\ Schwarzwald",
"492693", "Antweiler",
"495703", "Hille",
"492761", "Olpe\ Biggesee",
"492156", "Willich\-Anrath",
"4933395", "Zerpenschleuse",
"496655", "Neuhof\ Kreis\ Fulda",
"4938874", "Lützow",
"492843", "Rheinberg",
"494168", "Neu\ Wulmstorf\-Elstorf",
"496307", "Schopp",
"496552", "Olzheim",
"494671", "Bredstedt",
"493877", "Wittenberge",
"496856", "St\ Wendel\-Niederkirchen",
"4934422", "Osterfeld",
"495063", "Bad\ Salzdetfurth",
"499561", "Coburg",
"495166", "Walsrode\-Kirchboitzen",
"497574", "Gammertingen",
"499356", "Burgsinn",
"4989", "Munich",
"495424", "Bad\ Rothenfelde",
"496095", "Bessenbach",
"497558", "Illmensee",
"4937322", "Brand\-Erbisdorf",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"4934325", "Mochau\-Lüttewitz",
"495751", "Rinteln",
"492053", "Velbert\-Neviges",
"496238", "Dirmstein",
"498571", "Simbach\ am\ Inn",
"498585", "Grainet",
"496046", "Ortenberg\ Hessen",
"4933922", "Karwesee",
"498682", "Laufen\ Salzach",
"4936259", "Tabarz\ Thüringer\ Wald",
"4939035", "Kuhfelde",
"496235", "Schifferstadt",
"497930", "Boxberg\ Baden",
"492372", "Hemer",
"498464", "Dietfurt\ an\ der\ Altmühl",
"498847", "Obersöchering",
"497652", "Hinterzarten",
"4939608", "Staven",
"4939951", "Faulenrost",
"497461", "Tuttlingen",
"497555", "Deggenhausertal",
"494137", "Barendorf",
"495942", "Uelsen",
"495686", "Schwarzenborn\ Knüll",
"4933872", "Hohennauen",
"499906", "Mariaposching",
"494324", "Brokstedt",
"492242", "Hennef\ Sieg",
"493541", "Calau",
"4935454", "Uckro",
"496658", "Poppenhausen\ Wasserkuppe",
"496674", "Friedewald\ Hessen",
"4939399", "Kleinau",
"4939242", "Prödel",
"494165", "Hollenstedt\ Nordheide",
"4936424", "Kahla\ Thüringen",
"499294", "Regnitzlosau",
"498057", "Aschau\-Sachrang",
"499474", "Schmidmühlen",
"499172", "Georgensgmünd",
"496776", "Dachsenhausen",
"493976", "Torgelow\ bei\ Ueckermünde",
"497833", "Hornberg\ Schwarzwaldbahn",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"498023", "Bayrischzell",
"4936732", "Könitz",
"4933849", "Wiesenburg\ Mark",
"493723", "Hohenstein\-Ernstthal",
"494129", "Haseldorf",
"496267", "Fahrenbach\ Baden",
"498331", "Memmingen",
"497153", "Plochingen",
"492638", "Waldbreitbach",
"493603", "Bad\ Langensalza",
"492937", "Arnsberg\-Oeventrop",
"4934779", "Abberode",
"495265", "Dörentrup",
"494920", "Wirdum",
"49391", "Magdeburg",
"4938301", "Putbus",
"497542", "Tettnang",
"498663", "Ruhpolding",
"49671", "Bad\ Kreuznach",
"497334", "Deggingen",
"497127", "Neckartenzlingen",
"497645", "Freiamt",
"495308", "Lehre",
"4939062", "Bebertal",
"495955", "Esterwegen",
"494405", "Edewecht",
"496887", "Schmelz\ Saar",
"4935323", "Sonnewalde",
"492255", "Euskirchen\-Flamersheim",
"493462", "Bad\ Dürrenberg",
"499924", "Bodenmais",
"4934742", "Sylda",
"495190", "Soltau\-Emmingen",
"4939400", "Wefensleben",
"494857", "Barlt",
"4938755", "Eldena",
"495237", "Augustdorf",
"496293", "Schefflenz",
"496473", "Leun",
"497139", "Neuenstadt\ am\ Kocher",
"495082", "Langlingen",
"4933202", "Töplitz",
"494563", "Scharbeutz\-Haffkrug",
"4939488", "Güntersberge",
"499673", "Tiefenbach\ Oberpfalz",
"494823", "Wilster",
"4935795", "Königsbrück",
"497056", "Gechingen",
"498402", "Münchsmünster",
"498104", "Sauerlach",
"496849", "Kirkel",
"4939458", "Heudeber",
"494266", "Brockel",
"492667", "Stein\-Neukirch",
"494222", "Ganderkesee",
"4938828", "Schönberg",
"496596", "Üdersdorf",
"492192", "Hückeswagen",
"492274", "Elsdorf\ Rheinland",
"496545", "Blankenrath",
"498086", "Buchbach\ Oberbayern",
"496033", "Butzbach",
"4936744", "Remda",
"496642", "Schlitz",
"495406", "Belm",
"494956", "Uplengen",
"494777", "Cadenberge",
"499499", "Painten",
"499442", "Riedenburg",
"499144", "Pleinfeld",
"499279", "Mistelgau",
"4938785", "Berge\ bei\ Perleberg",
"495657", "Meissner",
"496059", "Jossgrund",
"495305", "Sickte",
"497947", "Forchtenberg",
"499732", "Hammelburg",
"494408", "Hude\ Oldenburg",
"498225", "Jettingen\-Scheppach",
"496136", "Nieder\-Olm",
"493328", "Teltow",
"495623", "Edertal",
"492532", "Ostbevern",
"494140", "Estorf\ Kreis\ Stade",
"492635", "Rheinbrohl",
"498269", "Unteregg\ bei\ Mindelheim",
"4935604", "Krieschow",
"4939293", "Dreileben",
"499392", "Faulbach\ Unterfranken",
"499349", "Werbach\-Wenkheim",
"4938204", "Broderstorf",
"492836", "Wachtendonk",
"499439", "Neunburg\-Kemnath",
"497256", "Philippsburg",
"4939973", "Altkalen",
"492132", "Meerbusch\-Büderich",
"495282", "Schieder\-Schwalenberg",
"492434", "Wegberg",
"496639", "Ottrau",
"4939749", "Grambow\ bei\ Pasewalk",
"495037", "Bad\ Rehburg",
"496093", "Laufach",
"497966", "Unterschneidheim",
"498583", "Neureichenau",
"4933837", "Brielow",
"4936075", "Dingelstädt\ Eichsfeld",
"496536", "Kleinich",
"4933764", "Mittenwalde\ Mark",
"4939085", "Zichtau",
"496832", "Beckingen\-Reimsbach",
"493386", "Premnitz",
"499401", "Neutraubling",
"4935873", "Herrnhut",
"4938483", "Brüel",
"498028", "Fischbachau",
"499544", "Baunach",
"499332", "Marktbreit",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"499427", "Leiblfing",
"496145", "Flörsheim\ am\ Main",
"497838", "Nordrach",
"4939772", "Rothemühl",
"492592", "Selm",
"496627", "Nentershausen\ Hessen",
"493471", "Bernburg\ Saale",
"498640", "Reit\ Im\ Winkl",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"4935200", "Arnsdorf\ bei\ Dresden",
"495705", "Petershagen\-Windheim",
"492695", "Insul",
"492982", "Medebach",
"494247", "Affinghausen",
"499749", "Oberbach\ Unterfranken",
"495065", "Sibbesse",
"492646", "Königsfeld\ Eifel",
"496196", "Bad\ Soden\ am\ Taunus",
"494683", "Oldsum",
"499453", "Thalmassing",
"492845", "Neukirchen\-Vluyn",
"496653", "Burghaun",
"492744", "Herdorf",
"495068", "Elze\ Leine",
"4939006", "Miesterhorst",
"498504", "Tittling",
"496400", "Mücke",
"4935434", "Altdöbern",
"497394", "Schelklingen",
"492587", "Ennigerloh\-Westkirchen",
"498731", "Dingolfing",
"494163", "Horneburg\ Niederelbe",
"494289", "Kirchtimke",
"497636", "Münstertal\ Schwarzwald",
"4935722", "Lauta\ bei\ Hoyerswerda",
"498025", "Miesbach",
"498709", "Eching\ Niederbayern",
"4936330", "Grossberndten",
"497220", "Forbach\-Hundsbach",
"493725", "Zschopau",
"49631", "Kaiserslautern",
"497734", "Gailingen",
"497835", "Zell\ am\ Harmersbach",
"4935698", "Hornow",
"4934343", "Regis\-Breitingen",
"493564", "Schwarze\ Pumpe",
"494604", "Grossenwiehe",
"49981", "Ansbach",
"4933745", "Petkus",
"4939823", "Rechlin",
"4936463", "Gebstedt",
"494706", "Schiffdorf",
"497444", "Alpirsbach",
"497142", "Bietigheim\-Bissingen",
"492058", "Wülfrath",
"4939055", "Hörsingen",
"496233", "Frankenthal\ Pfalz",
"4938453", "Mistorf",
"497527", "Wolfegg",
"495130", "Wedemark",
"4933089", "Himmelpfort",
"4938378", "Heringsdorf\ Seebad",
"4939931", "Röbel\ Müritz",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"495883", "Lemgow",
"4934205", "Markranstädt",
"4937202", "Claussnitz\ bei\ Chemnitz",
"497553", "Salem\ Baden",
"495939", "Sustrum",
"494529", "Süsel\-Bujendorf",
"498637", "Lohkirchen",
"496246", "Eich\ Rheinhessen",
"495850", "Neetze",
"4938735", "Plau\ am\ See",
"492772", "Herborn\ Hessen",
"4936333", "Heringen\ Helme",
"492253", "Bad\ Münstereifel",
"499572", "Burgkunstadt",
"4939007", "Tangeln",
"494724", "Cuxhaven\-Lüdingworth",
"499675", "Altendorf\ am\ Nabburg",
"494825", "Burg\ Dithmarschen",
"494662", "Leck",
"495384", "Seesen\-Gross\ Rhüden",
"496295", "Rosenberg\ Baden",
"496475", "Weilmünster\-Wolfenhausen",
"494230", "Verden\-Walle",
"495901", "Fürstenau\ bei\ Bramsche",
"499876", "Rohr\ Mittelfranken",
"494626", "Treia",
"499681", "Windischeschenbach",
"494451", "Varel\ Jadebusen",
"492227", "Bornheim\-Merten",
"492963", "Brilon\-Messinghausen",
"498629", "Palling",
"493605", "Leinefelde",
"494537", "Sülfeld\ Holstein",
"495263", "Barntrup",
"4935364", "Lebusa",
"492520", "Wadersloh\-Diestedde",
"4938324", "Velgast",
"4938450", "Tarnow\ bei\ Bützow",
"499234", "Neusorg",
"495953", "Börger",
"4938859", "Alt\ Zachun",
"494403", "Bad\ Zwischenahn",
"498822", "Oberammergau",
"498665", "Inzell",
"4939820", "Triepkendorf",
"4939999", "Tutow",
"499720", "Üchtelhausen",
"498562", "Triftern",
"497643", "Herbolzheim\ Breisgau",
"497032", "Herrenberg",
"4933836", "Butzow\ bei\ Brandenburg",
"4938221", "Marlow",
"498223", "Ichenhausen",
"498171", "Wolfratshausen",
"4936651", "Lobenstein",
"499480", "Sünching",
"492361", "Recklinghausen",
"495303", "Wendeburg",
"495826", "Suderburg",
"495862", "Hitzacker\ Elbe",
"499094", "Tagmersheim",
"498257", "Inchenhofen",
"495147", "Uetze\-Hänigsen",
"494932", "Norderney",
"495625", "Naumburg\ Hessen",
"497249", "Stutensee",
"497472", "Rottenburg\ am\ Neckar",
"497174", "Mögglingen",
"497158", "Neuhausen\ auf\ den\ Fildern",
"493907", "Gardelegen",
"496707", "Windesheim",
"492633", "Brohl\-Lützing",
"495522", "Osterode\ am\ Harz",
"499654", "Pleystein",
"494484", "Hude\-Wüsting",
"494182", "Tostedt",
"494828", "Lägerdorf",
"493921", "Burg\ bei\ Magdeburg",
"495351", "Helmstedt",
"499161", "Neustadt\ an\ der\ Aisch",
"496721", "Bingen\ am\ Rhein",
"496478", "Greifenstein\-Ulm",
"496298", "Möckmühl",
"499977", "Arnschwang",
"498550", "Philippsreut",
"496152", "Gross\-Gerau",
"496454", "Lichtenfels\-Sachsenberg",
"492556", "Metelen",
"4935203", "Tharandt",
"4934925", "Bad\ Schmiedeberg",
"4938847", "Boizenburg\ Elbe",
"4934495", "Dobitschen",
"4936371", "Schlossvippach",
"496543", "Büchenbeuren",
"492852", "Hamminkeln",
"496035", "Reichelsheim\ Wetterau",
"492598", "Senden\-Ottmarsbocholt",
"497832", "Haslach\ im\ Kinzigtal",
"494441", "Vechta",
"498066", "Bad\ Feilnbach",
"493722", "Limbach\-Oberfrohna",
"499338", "Röttingen\ Unterfranken",
"498022", "Tegernsee",
"4935752", "Ruhland",
"494286", "Gyhum",
"499221", "Kulmbach",
"4939727", "Spantekow",
"492687", "Horhausen\ Westerwald",
"492243", "Eitorf",
"498706", "Vilsheim",
"4936258", "Friemar",
"4938792", "Lenzen\ \(Elbe\)",
"495840", "Schnackenburg",
"496256", "Lampertheim\-Hüttenfeld",
"4933605", "Boossen",
"499173", "Thalmässing",
"4935953", "Burkau",
"499076", "Wittislingen",
"4936923", "Treffurt",
"497653", "Lenzkirch",
"499207", "Königsfeld\ Oberfranken",
"495943", "Emlichheim",
"4933656", "Bahro",
"4938423", "Bad\ Kleinen",
"497145", "Markgröningen",
"496838", "Saarwellingen",
"492373", "Menden\ Sauerland",
"494731", "Nordenham",
"497627", "Steinen\ Kreis\ Lörrach",
"494504", "Ratekau",
"4939853", "Holzendorf\ bei\ Prenzlau",
"497259", "Östringen\-Odenheim",
"499436", "Nittenau",
"495157", "Emmerthal\-Börry",
"4939398", "Gross\ Garz",
"499367", "Unterpleichfeld",
"496734", "Flonheim",
"49731", "Ulm\ Donau",
"4936873", "Themar",
"496835", "Beckingen",
"492052", "Velbert\-Langenberg",
"497148", "Grossbottwar",
"4939883", "Gross\ Dölln",
"496220", "Wilhelmsfeld",
"498683", "Tittmoning",
"496501", "Konz",
"498247", "Bad\ Wörishofen",
"496636", "Romrod",
"4933932", "Fehrbellin",
"4934907", "Jeber\-Bergfrieden",
"495123", "Schellerten",
"496394", "Bundenthal",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"4933848", "Raben",
"495271", "Höxter",
"495491", "Damme\ Dümmer",
"4933733", "Stülpe",
"496553", "Schönecken",
"49465", "Sylt",
"492842", "Kamp\-Lintfort",
"492971", "Schmallenberg\-Dorlar",
"495026", "Steimbke",
"4937435", "Reuth\ bei\ Plauen",
"492546", "Coesfeld\-Lette",
"492985", "Winterberg\-Niedersfeld",
"498377", "Unterthingau",
"495062", "Holle\ bei\ Hildesheim",
"4936041", "Bad\ Tennstedt",
"499746", "Zeitlofs",
"496527", "Oberweis",
"492692", "Kelberg",
"495702", "Petershagen\-Lahde",
"4936200", "Elxleben\ bei\ Arnstadt",
"496444", "Bischoffen",
"496142", "Rüsselsheim",
"492595", "Olfen",
"497233", "Niefern\-Öschelbronn",
"496867", "Perl",
"499644", "Pressath",
"499335", "Aub\ Kreis\ Würzburg",
"495341", "Salzgitter",
"4934362", "Mügeln\ bei\ Oschatz",
"492045", "Bottrop\-Kirchhellen",
"495525", "Walkenried",
"4933672", "Pfaffendorfb\ Beeskow",
"4934906", "Raguhn",
"494935", "Juist",
"495622", "Fritzlar",
"4937365", "Sayda",
"497475", "Burladingen",
"492533", "Münster\-Nienberge",
"495865", "Gusborn",
"495764", "Steyerberg",
"499393", "Rothenfels\ Unterfranken",
"495829", "Wriedel",
"492407", "Herzogenrath\-Kohlscheid",
"4939489", "Strassberg\ Harz",
"494550", "Bühnsdorf",
"4936621", "Elsterberg\ bei\ Plauen",
"4933965", "Herzsprung\ bei\ Wittstock",
"4936870", "Masserberg",
"497246", "Malsch\ Kreis\ Karlsruhe",
"499733", "Münnerstadt",
"496580", "Zemmer",
"492754", "Bad\ Laasphe\-Feudingen",
"496643", "Herbstein",
"496032", "Bad\ Nauheim",
"492855", "Voerde\ Niederrhein",
"496287", "Limbach\ Baden",
"492193", "Dabringhausen",
"492778", "Siegbach",
"492656", "Virneburg",
"492421", "Düren",
"4936203", "Vieselbach",
"4934955", "Gossa",
"494257", "Schweringen",
"499443", "Abensberg",
"4937462", "Rothenkirchen\ Vogtland",
"496155", "Griesheim\ Hessen",
"494171", "Winsen\ Luhe",
"498650", "Marktschellenberg",
"494668", "Klanxbüll",
"496893", "Saarbrücken\-Ensheim",
"495837", "Sprakensehl",
"4934465", "Bad\ Bibra",
"4939224", "Büden",
"494223", "Ganderkesee\-Bookholzberg",
"494967", "Rhauderfehn\-Burlage",
"499554", "Untersteinbach\ Unterfranken",
"497376", "Langenenslingen",
"494185", "Marxen\ Auetal",
"496158", "Riedstadt",
"494562", "Grömitz",
"495083", "Hohne\ bei\ Celle",
"497707", "Bräunlingen",
"495936", "Twist",
"494665", "Emmelsbüll\-Horsbüll",
"494526", "Ascheberg\ Holstein",
"4934444", "Lützen",
"4939726", "Ducherow",
"496292", "Seckach",
"496249", "Guntersblum",
"496174", "Königstein\ im\ Taunus",
"496472", "Weilmünster",
"498403", "Pförring",
"499672", "Neunburg\ vorm\ Wald",
"494822", "Kellinghusen",
"494188", "Welle\ Nordheide",
"499575", "Weismain",
"492858", "Hünxe",
"4939321", "Arneburg",
"492775", "Driedorf",
"492874", "Isselburg",
"49228", "Bonn",
"498537", "Bad\ Füssing\-Aigen",
"498565", "Dietersburg\-Baumgarten",
"4939459", "Hasselfelde",
"497543", "Kressbronn\ am\ Bodensee",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"498230", "Gablingen",
"4933657", "Steinsdorf\ Brandenburg",
"498724", "Massing",
"498825", "Krün",
"495528", "Gieboldehausen",
"498869", "Kinsau",
"497454", "Sulz\ am\ Neckar",
"497152", "Leonberg\ Württemberg",
"4937344", "Crottendorf\ Sachsen",
"497478", "Hirrlingen",
"494938", "Hagermarsch",
"4938354", "Wusterhusen",
"493831", "Stralsund",
"4936920", "Grossenlupnitz",
"492236", "Wesseling\ Rheinland",
"495186", "Salzhemmendorf\-Wallensen",
"494637", "Sterup",
"497721", "Villingen\ im\ Schwarzwald",
"492620", "Neuhäusel\ Westerwald",
"495353", "Königslutter\ am\ Elm",
"4934361", "Dahlen\ Sachsen",
"499163", "Dachsbach",
"496723", "Oestrich\-Winkel",
"493923", "Zerbst",
"4933671", "Lieberose",
"497440", "Bad\ Rippoldsau",
"4939267", "Schneidlingen",
"4938728", "Domsühl",
"4936622", "Triebes",
"498076", "Pfaffing",
"495432", "Löningen",
"496757", "Becherbach\ bei\ Kirn",
"495327", "Bad\ Grund\ Harz",
"4936844", "Rohr\ Thüringen",
"499289", "Schwarzenbach\ am\ Wald",
"496541", "Traben\-Trarbach",
"498207", "Affing",
"4935475", "Straupitz",
"495742", "Preussisch\ Oldendorf",
"498221", "Günzburg",
"496404", "Lich\ Hessen",
"496102", "Neu\-Isenburg",
"499604", "Wernberg\-Köblitz",
"4937608", "Waldenburg\ Sachsen",
"49481", "Heide\ Holstein",
"495301", "Lehre\-Essenrode",
"4934929", "Straach",
"492363", "Datteln",
"495339", "Gielde",
"495594", "Bovenden\-Reyershausen",
"492802", "Alpen",
"497224", "Gernsbach",
"498338", "Böhen",
"492506", "Münster\-Wolbeck",
"492631", "Neuwied",
"4935387", "Seyda",
"492203", "Cologne\-Porz",
"495261", "Lemgo",
"498335", "Fellheim",
"4935240", "Tauscha\ bei\ Grossenhain",
"4939322", "Tangermünde",
"493321", "Nauen\ Brandenburg",
"495951", "Werlte",
"494401", "Brake\ Unterweser",
"499377", "Freudenberg\-Boxtal",
"4930", "Berlin",
"4933438", "Altlandsberg",
"497641", "Emmendingen",
"49561", "Kassel",
"4939995", "Nossendorf",
"4939425", "Dingelstedt\ am\ Huy",
"494544", "Berkenthin",
"494332", "Hamdorf\ bei\ Rendsburg",
"4935936", "Sohland\ Spree",
"4933970", "Neustadt\ Dosse",
"493307", "Zehdenick",
"492251", "Euskirchen",
"4938855", "Lübtheen",
"496483", "Selters\ Taunus",
"495072", "Neustadt\-Mandelsloh",
"498367", "Rosshaupten\ Forggensee",
"494792", "Worpswede",
"494749", "Schiffdorf\-Geestenseth",
"4933633", "Spreenhagen",
"492961", "Brilon",
"4935895", "Klitten",
"495903", "Emsbüren",
"494453", "Zetel",
"499683", "Friedenfels",
"492382", "Ahlen\ Westfalen",
"494480", "Ovelgönne\-Strückhausen",
"4937293", "Eppendorf\ Sachsen",
"497429", "Egesheim",
"496231", "Hochdorf\-Assenheim",
"4935751", "Welzow",
"498554", "Schönberg\ Niederbayern",
"499932", "Osterhofen",
"495774", "Wagenfeld\-Ströhen",
"497747", "Berau",
"495875", "Emmendorf",
"4935243", "Weinböhla",
"496209", "Mörlenbach",
"496328", "Elmstein",
"498443", "Hohenwart\ Paar",
"495676", "Liebenau\ Hessen",
"4938791", "Bad\ Wilsnack",
"497465", "Emmingen\-Liptingen",
"497551", "Überlingen\ Bodensee",
"497366", "Abtsgmünd",
"494977", "Blomberg\ Ostfriesland",
"494756", "Odisheim",
"497322", "Giengen\ an\ der\ Brenz",
"499568", "Neustadt\ bei\ Coburg",
"496684", "Hofbieber\-Schwarzbach",
"498733", "Mengkofen",
"4933085", "Seilershof",
"499182", "Velburg",
"499484", "Brennberg",
"4936948", "Römhild",
"499828", "Rügland",
"494161", "Buxtehude",
"496786", "Kempfeld",
"4939059", "Wegenstedt",
"4933368", "Hohensaaten",
"497503", "Wilhelmsdorf\ Württemberg",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"493596", "Neustadt\ in\ Sachsen",
"499090", "Rain\ Lech",
"498393", "Holzgünz",
"4935937", "Prischwitz",
"492447", "Dahlem\ bei\ Kall",
"4939089", "Bismark\ Altmark",
"495044", "Springe\-Eldagsen",
"499869", "Wettringen\ Mittelfranken",
"492524", "Ennigerloh",
"4933931", "Rheinsberg\ Mark",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"499197", "Egloffstein",
"499529", "Oberaurach",
"492864", "Reken",
"499662", "Vilseck",
"4939745", "Hetzdorf\ bei\ Strasburg",
"494876", "Reher\ Holstein",
"494681", "Wyk\ auf\ Föhr",
"499626", "Hohenburg",
"499565", "Untersiemau",
"499451", "Schierling",
"496426", "Fronhausen",
"496651", "Rasdorf",
"4939266", "Förderstedt",
"4933055", "Kremmen",
"496462", "Gladenbach",
"499724", "Stadtlauringen",
"496164", "Reichelsheim\ Odenwald",
"499825", "Herrieden",
"497584", "Altshausen",
"496325", "Lambrecht\ Pfalz",
"495755", "Kalletal\-Varenholz",
"495854", "Bleckede\-Barskamp",
"4936042", "Tonna",
"49371", "Chemnitz\ Sachsen",
"4935386", "Prettin",
"492737", "Netphen\-Deuz",
"498581", "Waldkirchen\ Niederbayern",
"494234", "Dörverden",
"499403", "Donaustauf",
"498453", "Reichertshofen\ Oberbayern",
"497541", "Friedrichshafen",
"496108", "Mühlheim\ am\ Main",
"497976", "Sulzbach\-Laufen",
"494367", "Grossenbrode",
"498427", "Wellheim",
"4935327", "Priessen",
"498544", "Eging\ am\ See",
"496440", "Kölschhausen",
"4939406", "Harbke",
"498332", "Ottobeuren",
"497723", "Furtwangen\ im\ Schwarzwald",
"4938788", "Gross\ Warnow",
"494795", "Garlstedt",
"4934294", "Rackwitz",
"496224", "Sandhausen\ Baden",
"494644", "Karby",
"493461", "Merseburg\ Saale",
"4934654", "Stolberg\ Harz",
"4938825", "Klütz",
"494335", "Hohn\ bei\ Rendsburg",
"497404", "Epfendorf",
"494746", "Hagen\ bei\ Bremerhaven",
"4939455", "Schierke",
"495438", "Bakum\-Lüsche",
"49551", "Göttingen",
"496641", "Lauterbach\ Hessen",
"4938222", "Semlow",
"492191", "Remscheid",
"493574", "Lauchhammer",
"494338", "Alt\ Duvenstedt",
"4939485", "Gernrode\ Harz",
"492423", "Langerwehe",
"4936652", "Wurzbach",
"4933969", "Stepenitz",
"499441", "Kelheim",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"495435", "Berge\ bei\ Quakenbrück",
"4935844", "Oybin\ Kurort",
"4938758", "Dömitz",
"494173", "Wulfsen",
"49881", "Weilheim\ in\ Oberbayern",
"499286", "Oberkotzau",
"494221", "Delmenhorst",
"4937369", "Wolkenstein",
"495054", "Bergen\-Sülze",
"494207", "Oyten",
"492606", "Winningen\ Mosel",
"495694", "Diemelstadt",
"499391", "Marktheidenfeld",
"497483", "Horb\-Mühringen",
"495467", "Voltlage",
"499504", "Stadelhofen",
"4936372", "Kleinneuhausen",
"495336", "Semmenstedt",
"492064", "Dinslaken",
"496105", "Mörfelden\-Walldorf",
"492509", "Nottuln\-Appelhülsen",
"495844", "Clenze",
"495745", "Stemwede\-Levern",
"4939382", "Kamern",
"496465", "Breidenbach\ bei\ Biedenkopf",
"496551", "Prüm",
"494672", "Langenhorn",
"499822", "Bechhofen\ an\ der\ Heide",
"492973", "Eslohe\ Sauerland",
"499188", "Postbauer\-Heng",
"498234", "Bobingen",
"499562", "Sonnefeld",
"497328", "Königsbronn",
"499526", "Riedbach",
"499665", "Königstein\ Oberpfalz",
"493947", "Thale",
"496747", "Emmelshausen",
"492762", "Wenden\ Südsauerland",
"497231", "Pforzheim",
"496429", "Schweinsberg\ Hessen",
"4939296", "Welsleben",
"492624", "Höhr\-Grenzhausen",
"4936781", "Grossbreitenbach",
"498572", "Tann\ Niederbayern",
"496503", "Hermeskeil",
"498681", "Waging\ am\ See",
"4939771", "Ueckermünde",
"4939605", "Gross\ Nemerow",
"492388", "Hamm\-Uentrop",
"4937439", "Jocketa",
"495121", "Hildesheim",
"499637", "Falkenberg\ Oberpfalz",
"496322", "Bad\ Dürkheim",
"495752", "Auetal\-Hattendorf",
"497684", "Glottertal",
"499938", "Moos\ Niederbayern",
"495273", "Beverungen",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"4939038", "Henningen",
"492750", "Diedenshausen",
"497164", "Boll\ Kreis\ Göppingen",
"497462", "Immendingen",
"4939407", "Seehausen\ Börde",
"497426", "Gosheim",
"497651", "Titisee\-Neustadt",
"4933609", "Brieskow\-Finkenheerd",
"494393", "Boostedt",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"495941", "Neuenhaus\ Dinkel",
"499935", "Stephansposching",
"495872", "Stoetze",
"498678", "Marktl",
"498161", "Freising",
"4934328", "Hartha\ bei\ Döbeln",
"494733", "Butjadingen\-Burhave",
"498654", "Freilassing",
"496206", "Lampertheim",
"492371", "Iserlohn",
"492385", "Hamm\-Rhynern",
"498756", "Nandlstadt",
"492486", "Nettersheim",
"498094", "Steinhöring",
"499257", "Zell\ Oberfranken",
"494443", "Dinklage",
"496789", "Heimbach\ Nahe",
"499223", "Rugendorf",
"496468", "Dautphetal\-Mornshausen",
"4933398", "Werneuchen",
"494554", "Wahlstedt",
"49791", "Schwäbisch\ Hall",
"493542", "Lübbenau\ Spreewald",
"499185", "Mühlhausen\ Oberpfalz",
"492241", "Siegburg",
"493334", "Eberswalde",
"497325", "Sontheim\ an\ der\ Brenz",
"4939932", "Malchow\ bei\ Waren",
"499171", "Roth\ Mittelfranken",
"496584", "Wellen\ Mosel",
"493867", "Lübstorf",
"495073", "Neustadt\-Esperke",
"496482", "Runkel",
"496184", "Langenselbold",
"4939826", "Blankensee\ bei\ Neustrelitz",
"499571", "Lichtenfels\ Bayern",
"4934498", "Rositz",
"495902", "Freren",
"4934928", "Seegrehna",
"494452", "Zetel\-Neuenburg",
"499682", "Erbendorf",
"494154", "Trittau",
"499946", "Hohenwarth\ bei\ Kötzing",
"4938456", "Langhagen\ bei\ Güstrow",
"494661", "Niebüll",
"494178", "Radbruch",
"494793", "Hambergen",
"4937609", "Wolkenburg\ Mulde",
"492428", "Niederzier",
"4938302", "Sagard",
"498807", "Diessen\ am\ Ammersee",
"492771", "Dillenburg",
"4939061", "Weferlingen",
"494333", "Erfde",
"498821", "Garmisch\-Partenkirchen",
"4939003", "Jübar",
"498561", "Pfarrkirchen\ Niederbayern",
"497031", "Böblingen",
"4938729", "Marnitz",
"49421", "Bremen",
"493394", "Wittstock\ Dosse",
"4934741", "Frose",
"497824", "Schwanau",
"4933201", "Gross\ Glienicke",
"497725", "Königsfeld\ im\ Schwarzwald",
"492202", "Bergisch\ Gladbach",
"4935054", "Lauenstein\ Sachsen",
"493501", "Pirna",
"493636", "Greussen",
"4936024", "Diedorf\ bei\ Mühlhausen",
"498034", "Brannenburg",
"495176", "Edemissen",
"497564", "Bad\ Wurzach",
"4936337", "Schiedungen",
"4934346", "Narsdorf",
"49234", "Bochum",
"497728", "Niedereschach",
"4938843", "Bennin",
"495861", "Dannenberg\ Elbe",
"498320", "Missen\-Wilhams",
"492803", "Wesel\-Büderich",
"496347", "Hochstadt\ Pfalz",
"497485", "Empfingen",
"4935207", "Moritzburg",
"492041", "Bottrop",
"495521", "Herzberg\ am\ Harz",
"493838", "Bergen\ auf\ Rügen",
"494931", "Norden",
"497471", "Hechingen",
"495459", "Hörstel",
"496103", "Langen\ Hessen",
"495743", "Espelkamp\-Gestringen",
"492362", "Dorsten",
"498458", "Gaimersheim",
"498294", "Horgau",
"492425", "Nideggen\-Embken",
"495433", "Badbergen",
"4939976", "Gross\ Bützin",
"492851", "Rees",
"495507", "Ebergötzen",
"495352", "Schöningen",
"499162", "Scheinfeld",
"499464", "Walderbach",
"496722", "Rüdesheim\ am\ Rhein",
"493966", "Cölpin",
"499126", "Eckental",
"496766", "Kisselbach",
"494181", "Buchholz\ in\ der\ Nordheide",
"4938738", "Karow\ bei\ Lübz",
"497386", "Hayingen",
"496151", "Darmstadt",
"4933439", "Fredersdorf\-Vogelsdorf",
"494175", "Egestorf\ Nordheide",
"4933830", "Ziesar",
"496664", "Sinntal\-Sterbfritz",
"4935876", "Weissenberg\ Sachsen",
"499847", "Ergersheim",
"4938486", "Gustävel",
"496505", "Kordel",
"4934208", "Löbnitz\ bei\ Delitzsch",
"495446", "Rehden",
"4938375", "Koserow",
"499104", "Emskirchen",
"499402", "Regenstauf",
"4936949", "Obermassfeld\-Grimmenthal",
"496831", "Saarlouis",
"4939344", "Güsen",
"496809", "Grossrosseln",
"49340", "Dessau\ Anh",
"4935206", "Kreischa\ bei\ Dresden",
"495275", "Höxter\-Ottbergen",
"4939058", "Uthmöden",
"496024", "Schöllkrippen",
"495495", "Vörden\ Kreis\ Vechta",
"4933369", "Oderberg",
"4933748", "Treuenbrietzen",
"495281", "Bad\ Pyrmont",
"492131", "Neuss",
"493379", "Mahlow",
"492304", "Schwerte",
"4933833", "Wollin\ bei\ Brandenburg",
"492981", "Winterberg\ Westfalen",
"4935695", "Simmersdorf",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"4935877", "Cunewalde",
"499228", "Thurnau",
"4938295", "Satow\ bei\ Bad\ Doberan",
"498387", "Weiler\-Simmerberg",
"4937321", "Frankenstein\ Sachsen",
"492975", "Schmallenberg\-Oberkirchen",
"495634", "Waldeck\-Sachsenhausen",
"4939977", "Jördenstorf",
"499331", "Ochsenfurt",
"495345", "Baddeckenstedt",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"492591", "Lüdinghausen",
"4933921", "Zechlinerhütte",
"494767", "Bremervörde\-Bevern",
"499269", "Tettau\ Kreis\ Kronach",
"497357", "Attenweiler",
"497502", "Wolpertswende",
"49511", "Hannover",
"492264", "Marienheide",
"497806", "Bad\ Peterstal\-Griesbach",
"498349", "Stötten\ am\ Auerberg",
"498392", "Markt\ Rettenbach",
"4936644", "Hirschberg\ Saale",
"494445", "Visbek\ Kreis\ Vechta",
"492677", "Lutzerath",
"4939827", "Schwarz\ bei\ Neustrelitz",
"497323", "Gerstetten",
"494496", "Friesoythe\-Markhausen",
"494276", "Borstel\ bei\ Sulingen",
"4939952", "Grammentin",
"499225", "Stadtsteinach",
"493643", "Weimar\ Thüringen",
"492954", "Rüthen\-Oestereiden",
"4938457", "Krakow\ am\ See",
"499183", "Burgthann",
"498732", "Frontenhausen",
"495254", "Paderborn\-Schloss\ Neuhaus",
"4939241", "Leitzkau",
"4939088", "Letzlingen",
"495278", "Höxter\-Ovenhausen",
"499933", "Wallersdorf",
"499086", "Fremdingen",
"4934347", "Oelzschau\ bei\ Borna",
"4936336", "Klettenberg",
"498442", "Wolnzach",
"498144", "Grafrath",
"495964", "Lähden",
"496508", "Hetzerath\ Mosel",
"494346", "Gettorf",
"4933474", "Neutrebbin",
"492383", "Bönen",
"4936731", "Unterloquitz",
"4939000", "Beetzendorf",
"4939753", "Strasburg",
"497141", "Ludwigsburg\ Württemberg",
"494834", "Büsum",
"4939365", "Bellingen\ bei\ Stendal",
"494735", "Butjadingen\-Stollhamm",
"496670", "Ludwigsau\ Hessen",
"4938789", "Wolfshagen\ bei\ Perleberg",
"492365", "Marl",
"4939202", "Gross\ Ammensleben",
"495456", "Westerkappeln\-Velpe",
"495621", "Bad\ Wildungen",
"4933331", "Casekow",
"499324", "Dettelbach",
"497482", "Horb\-Dettingen",
"497184", "Kaisersbach",
"4936084", "Heuthen",
"492208", "Niederkassel",
"4936207", "Plaue\ Thüringen",
"494294", "Riede\ Kreis\ Verden",
"49331", "Potsdam",
"494474", "Garrel",
"494172", "Salzhausen",
"497934", "Weikersheim",
"494458", "Wiefelstede\-Spohle",
"495908", "Wietmarschen\-Lohne",
"498460", "Berching\-Holnstein",
"496564", "Neuerburg\ Eifel",
"4939886", "Milmersdorf",
"495607", "Fuldatal",
"493925", "Stassfurt",
"496824", "Ottweiler",
"495355", "Frellstedt",
"499165", "Sugenheim",
"496725", "Gau\-Algesheim",
"4938232", "Zingst\ Ostseebad",
"493969", "Siedenbollentin",
"499129", "Wendelstein",
"4937757", "Rittersgrün",
"496031", "Friedberg\ Hessen",
"497389", "Heroldstatt",
"492337", "Hagen\-Dahl",
"492422", "Kreuzau",
"494320", "Heidmühlen",
"492944", "Rietberg\-Mastholte",
"497570", "Sigmaringen\-Gutenstein",
"4936926", "Creuzburg",
"4938426", "Neuburg\-Steinhausen",
"49821", "Augsburg",
"4933653", "Ziltendorf",
"496291", "Adelsheim",
"496471", "Weilburg",
"4934775", "Wippra",
"495905", "Beesten",
"494455", "Jade\-Schweiburg",
"494561", "Neustadt\ in\ Holstein",
"4934601", "Teutschenthal",
"497347", "Dietenheim",
"496485", "Nentershausen\ Westerwald",
"4939856", "Beenz\ bei\ Prenzlau",
"495374", "Isenbüttel",
"496728", "Ober\-Hilbersheim",
"495358", "Bahrdorf\-Mackendorf",
"499671", "Oberviechtach",
"494821", "Itzehoe",
"493928", "Schönebeck\ Elbe",
"497664", "Freiburg\-Tiengen",
"498333", "Babenhausen\ Schwaben",
"496386", "Altenkirchen\ Pfalz",
"497151", "Waiblingen",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"4934223", "Dommitzsch",
"494356", "Gross\ Wittensee",
"493601", "Mühlhausen\ Thüringen",
"497722", "Triberg\ im\ Schwarzwald",
"492205", "Rösrath",
"4935024", "Stadt\ Wehlen",
"498661", "Grabenstätt\ Chiemsee",
"498178", "Icking",
"4933458", "Falkenberg\ Mark",
"498452", "Geisenfeld",
"492368", "Oer\-Erkenschwick",
"4938759", "Tewswoos",
"4937368", "Deutschneudorf",
"497277", "Wörth\-Büchelberg",
"495244", "Rietberg",
"4933234", "Wustermark",
"4937381", "Penig",
"499266", "Mitwitz",
"498735", "Gangkofen\-Kollbach",
"499222", "Presseck",
"4938427", "Blowatz",
"497024", "Wendlingen\ am\ Neckar",
"4939922", "Dambeck\ bei\ Röbel",
"4939857", "Drense",
"498346", "Pforzen",
"4935822", "Hagenwerder",
"4933981", "Putlitz",
"4936927", "Unterellen",
"499956", "Eichendorf\-Aufhausen",
"497831", "Hausach",
"499777", "Ostheim\ von\ der\ Rhön",
"498395", "Tannheim\ Württemberg",
"494499", "Barssel",
"494442", "Lohne\ Oldenburg",
"494144", "Himmelpforten",
"4937438", "Bad\ Brambach",
"4939039", "Bonese",
"498021", "Waakirchen",
"493721", "Meinersdorf",
"497505", "Fronreute",
"494732", "Stadland\-Rodenkirchen",
"499408", "Altenthann",
"4939723", "Krien",
"499089", "Bissingen\-Unterringingen",
"4933845", "Borkheide",
"498276", "Baar\ Schwaben",
"498445", "Gerolsbach",
"494392", "Nortorf\ bei\ Neumünster",
"494349", "Dänischenhagen",
"4936704", "Steinheid",
"497463", "Mühlheim\ an\ der\ Donau",
"495873", "Eimke",
"4939395", "Wanzer",
"499920", "Bischofsmais",
"495272", "Brakel\ Westfalen",
"495492", "Steinfeld\ Oldenburg",
"495194", "Bispingen",
"4936206", "Grossfahner",
"496323", "Edenkoben",
"495753", "Auetal\-Bernsen",
"496806", "Heusweiler",
"498573", "Ering",
"492051", "Velbert",
"499405", "Bad\ Abbach",
"4935773", "Schleife",
"496357", "Standenbühl",
"496502", "Schweich",
"4937756", "Breitenbrunn\ Erzgebirge",
"4933608", "Jacobsdorf\ Mark",
"493475", "Lutherstadt\ Eisleben",
"4936255", "Goldbach\ bei\ Gotha",
"499857", "Schopfloch\ Mittelfranken",
"492763", "Drolshagen\-Bleche",
"4934903", "Coswig\ Anhalt",
"492691", "Adenau",
"495534", "Eschershausen\ an\ der\ Lenne",
"499306", "Kist",
"494924", "Moormerland\-Oldersum",
"492841", "Moers",
"492972", "Schmallenberg",
"494673", "Joldelund",
"499823", "Leutershausen",
"4936695", "Söllmnitz",
"4939887", "Gerswalde",
"499563", "Rödental",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;