
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "lazy loader for Bread::Board containers",
  "AUTHOR" => "Roman Daniel <roman.daniel\@davosro.cz>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Bread-Board-LazyLoader",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Bread::Board::LazyLoader",
  "PREREQ_PM" => {
    "Bread::Board" => "0.28"
  },
  "TEST_REQUIRES" => {
    "Test::Exception" => 0
  },
  "VERSION" => "0.03",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Bread::Board" => "0.28",
  "Test::Exception" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



