# Copyright (C) 2001-2004 Daniel Berrange <dan@berrange.com>
#
# $Id: File-Path-Localize.spec.PL,v 1.4 2004/04/01 19:33:54 dan Exp $

use strict;

die unless (scalar @ARGV == 1);

unless (do 'lib/File/Path/Localize.pm')
  {
    if ($@) { die $@ };
    die "lib/File/Path/Localize.pm: $!";
  }

local $/ = undef;
$_ = <DATA>;
s/\@VERSION\@/$File::Path::Localize::VERSION/g;

open SPEC, ">$ARGV[0]" or die "$!";
print SPEC $_;
close SPEC;
__DATA__
# Automatically generated by File-Path-Localize.spec.PL

%define perlsitearch %(perl -e 'use Config; print $Config{installsitearch}')
%define perlsitelib %(perl -e 'use Config; print $Config{installsitelib}')
%define perlman1dir %(perl -e 'use Config; print "$Config{siteprefix}/man/man1"')
%define perlman3dir %(perl -e 'use Config; print "$Config{siteprefix}/man/man3"')
%define perlversion %(perl -e 'use Config; print $Config{version}')

%define appname File-Path-Localize

Summary: File::Path::Localize - A filename expander
Name: perl-%{appname}
Version: @VERSION@
Release: 1
Copyright: GPL
Group: Applications/Internet
Source: %{appname}-%{version}.tar.gz
BuildRoot: /var/tmp/%{appname}-%{version}-root
BuildArchitectures: noarch
Requires: perl = %{perlversion}

%description
File::Path::Localize is a library of methods for expanding a 
relative filename into a list of absolute filsnames using a 
path and set of locales.
 
%prep
%setup -q -n %{appname}-%{version}


%build
perl Makefile.PL
make


%install
rm -rf $RPM_BUILD_ROOT
make PREFIX=$RPM_BUILD_ROOT/usr install
find $RPM_BUILD_ROOT%{perlsitearch} -name perllocal.pod -exec rm -f {} \;


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
%doc AUTHORS
%doc COPYING
%doc README
%{perlman3dir}/*
%{perlsitelib}/File/Path/Localize.pm
%{perlsitearch}/auto/File/Path/Localize/
