package OpenInteract::Handler::TemplatesUsedBox;

# $Id: TemplatesUsedBox.pm,v 1.1 2002/08/25 00:03:48 lachoy Exp $

use strict;

$OpenInteract::Handler::TemplatesUsedBox::VERSION = substr(q$Revision: 1.1 $, 10);

# Simple handler to put the list of templates used into a more
# manageable form -- note that we can handle template objects and
# 'package::name' strings in \@{ $R->{templates_used} }

sub handler {
    my ( $class ) = @_;
    my $R = OpenInteract::Request->instance;
    my %tmpl_by_package = ();
    my %tmpl_used       = ();
    foreach my $template ( @{ $R->{templates_used} } ) {
        my ( $package, $name, $full_name );
        if ( ref $template ) {
            ( $package, $name ) = ( $template->{package}, $template->{name} );
        }
        else {
            ( $package, $name ) = $R->site_template->parse_name( $template );
            if ( $package and ! $name ) {
                $name    = $package;
                $package = '';
            }
            $full_name = $template;
        }
        next if ( $tmpl_used{ $package }{ $name } );
        $tmpl_used{ $package }{ $name }++;
        push @{ $tmpl_by_package{ $package } },
                            { name      => $name,
                              package   => $package,
                              full_name => $full_name };
    }
    foreach my $package ( keys %tmpl_by_package ) {
        $tmpl_by_package{ $package } = [ sort { $b->{name} cmp $a->{name} }
                                         @{ $tmpl_by_package{ $package } } ];
    }
    return $R->template->handler( {}, { templates_used => \%tmpl_by_package },
                                  { name => 'base_template::templates_used_box' } );
}

1;

__END__

=head1 NAME

OpenInteract::Handler::TemplatesUsedBox -- Generate 'Templates Used' box contents

=head1 SYNOPSIS

 # Add the box to a particular page
 [% OI.box_add( 'templates_used_box' ) %]

=head1 DESCRIPTION

B<templates_used> (if in 'site admin' group)

Displays a listing of the templates used for a request along with
links so you can quickly jump to one and edit it.

=head1 BUGS

None known.

=head1 TO DO

=head1 SEE ALSO

L<OpenInteract::Component|OpenInteract::Component>

L<OpenInteract::Handler::Box|OpenInteract::Handler::Box>

=head1 COPYRIGHT

Copyright (c) 2001-2002 intes.net, inc. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters <chris@cwinters.com>

=cut
