package OpenInteract::SQLInstall::Base;

# $Id: Base.pm,v 1.6 2001/10/18 01:29:15 lachoy Exp $

# Do installation of SQL for this package

use strict;
use vars qw( %HANDLERS );

@OpenInteract::SQLInstall::Base::ISA = qw( OpenInteract::SQLInstall );

my %files = (
   tables   => [ 'sessions.sql', 'object_keys.sql' ],
   security => [ 'install_security.dat' ],
);

%HANDLERS = (
   create_structure => { '_default_' => [ 'create_structure',
                                          { table_file_list => $files{tables} } ] },
   install_security => { '_default_' => [ 'install_data',
                                          { data_file_list => $files{security} } ] },
);

1;
