package Lingua::StopWords::SV;

use strict;
use warnings;

use Exporter;
our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw( getStopWords ) ] ); 
our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );
our $VERSION = $Lingua::StopWords::VERSION;

sub getStopWords {
    if ( @_ and $_[0] eq 'UTF-8' ) {
        # adding U0 causes the result to be flagged as UTF-8
        my %stoplist = map { ( pack("U0a*", $_), 1 ) } qw( 
            och det att i en jag hon som han på den med var sig för så
            till är men ett om hade de av icke mig du henne då sin nu har
            inte hans honom skulle hennes där min man ej vid kunde något
            från ut när efter upp vi dem vara vad över än dig kan sina
            här ha mot alla under någon eller allt mycket sedan ju denna
            själv detta åt utan varit hur ingen mitt ni bli blev oss din
            dessa några deras blir mina samma vilken er sådan vår blivit
            dess inom mellan sådant varför varje vilka ditt vem vilket
            sitta sådana vart dina vars vårt våra ert era vilkas 
        );
        return \%stoplist;
    }
    else {
        my %stoplist = map { ( $_, 1 ) } qw( 
            och det att i en jag hon som han p den med var sig fr s till
            r men ett om hade de av icke mig du henne d sin nu har inte
            hans honom skulle hennes dr min man ej vid kunde ngot frn ut
            nr efter upp vi dem vara vad ver n dig kan sina hr ha mot
            alla under ngon eller allt mycket sedan ju denna sjlv detta
            t utan varit hur ingen mitt ni bli blev oss din dessa ngra
            deras blir mina samma vilken er sdan vr blivit dess inom
            mellan sdant varfr varje vilka ditt vem vilket sitta sdana
            vart dina vars vrt vra ert era vilkas 
        );
        return \%stoplist;
    }
}

1;
