use strict;
use warnings;
use lib 'buildlib';

use Test::More tests => 8;
use KinoTestUtils qw( test_analyzer );

use KinoSearch::Analysis::Stopalizer;
use KinoSearch::Analysis::Tokenizer;
use KinoSearch::Analysis::PolyAnalyzer;

my $stopalizer = KinoSearch::Analysis::Stopalizer->new( language => 'en' );
test_analyzer( $stopalizer, 'the', [], "single stopword stopalized" );

my $tokenizer    = KinoSearch::Analysis::Tokenizer->new;
my $polyanalyzer = KinoSearch::Analysis::PolyAnalyzer->new(
    analyzers => [ $tokenizer, $stopalizer ], );
test_analyzer( $polyanalyzer, 'i am the walrus',
    ['walrus'], "multiple stopwords stopalized" );
