package Device::Gsm::Networks;

#
# Gsm networks data stolen from Gnokii
#
our %COUNTRIES = (
	'202'=> 'Greece',
	'204'=> 'Netherlands',
	'206'=> 'Belgium',
	'208'=> 'France',
	'213'=> 'Andorra',
	'214'=> 'Spain',
	'216'=> 'Hungary',
	'218'=> 'Bosnia Herzegovina',
	'219'=> 'Croatia',
	'220'=> 'Yugoslavia',
	'222'=> 'Italy',
	'226'=> 'Romania',
	'228'=> 'Switzerland',
	'230'=> 'Czech Republic',
	'231'=> 'Slovak Republic',
	'232'=> 'Austria',
	'234'=> 'United Kingdom',
	'238'=> 'Denmark',
	'240'=> 'Sweden',
	'242'=> 'Norway',
	'244'=> 'Finland',
	'246'=> 'Lithuania',
	'247'=> 'Latvia',
	'248'=> 'Estonia',
	'250'=> 'Russia',
	'255'=> 'Ukraine',
	'259'=> 'Moldova',
	'260'=> 'Poland',
	'262'=> 'Germany',
	'266'=> 'Gibraltar',
	'268'=> 'Portugal',
	'270'=> 'Luxembourg',
	'272'=> 'Ireland',
	'274'=> 'Iceland',
	'276'=> 'Albania',
	'278'=> 'Malta',
	'280'=> 'Cyprus',
	'282'=> 'Georgia',
	'283'=> 'Armenia',
	'284'=> 'Bulgaria',
	'286'=> 'Turkey',
	'290'=> 'Greenland',
	'293'=> 'Slovenia',
	'294'=> 'Macedonia',
	'302'=> 'Canada',
	'310'=> 'U.S.A.',
	'340'=> 'French West Indies',
	'400'=> 'Azerbaijan',
	'404'=> 'India',
	'410'=> 'Pakistan',
	'413'=> 'Sri Lanka',
	'415'=> 'Lebanon',
	'416'=> 'Jordan',
	'417'=> 'Syria',
	'418'=> 'Iraq',
	'419'=> 'Kuwait',
	'420'=> 'Saudi Arabia',
	'422'=> 'Oman',
	'424'=> 'United Arab Emirates',
	'425'=> 'Israel',
	'426'=> 'Bahrain',
	'427'=> 'Qatar',
	'432'=> 'Iran',
	'434'=> 'Uzbekistan',
	'437'=> 'Kyrgyz Republic',
	'452'=> 'Vietnam',
	'454'=> 'Hong Kong',
	'455'=> 'Macau',
	'456'=> 'Cambodia',
	'457'=> 'Lao',
	'460'=> 'China',
	'466'=> 'Taiwan',
	'470'=> 'Bangladesh',
	'502'=> 'Malaysia',
	'505'=> 'Australia',
	'510'=> 'Indonesia',
	'515'=> 'Philippines',
	'520'=> 'Thailand',
	'525'=> 'Singapore',
	'528'=> 'Brunei Darussalam',
	'530'=> 'New Zealand',
	'542'=> 'Fiji',
	'546'=> 'New Caledonia',
	'547'=> 'French Polynesia',
	'602'=> 'Egypt',
	'603'=> 'Algeria',
	'604'=> 'Morocco',
	'605'=> 'Tunisia',
	'608'=> 'Senegal',
	'611'=> 'Guinea',
	'612'=> 'Cote d\'Ivoire',
	'615'=> 'Togo',
	'617'=> 'Mauritius',
	'618'=> 'Liberia',
	'620'=> 'Ghana',
	'624'=> 'Cameroon',
	'625'=> 'Cape Verde',
	'633'=> 'Seychelles',
	'634'=> 'Mozambique',
	'634'=> 'Sudan',
	'635'=> 'Rwanda',
	'636'=> 'Ethiopia',
	'640'=> 'Tanzania',
	'641'=> 'Uganda',
	'645'=> 'Zambia',
	'646'=> 'Madagascar',
	'647'=> 'Reunion',
	'648'=> 'Zimbabwe',
	'649'=> 'Namibia',
	'650'=> 'Malawi',
	'651'=> 'Lesotho',
	'652'=> 'Botswana',
	'655'=> 'South Africa',
	'730'=> 'Chile',
	'734'=> 'Venezuela',
	undef=> 'unknown',
);

our %NETWORKS = (
	"20201"=> "Cosmote",
	"20205"=> "PANAFON",
	"20210"=> "TELESTET",
	"20404"=> "LIBERTEL",
	"20408"=> "KPN Telecom",
	"20412"=> "O2",
	"20416"=> "BEN",
	"20420"=> "Dutchtone NV",
	"20601"=> "PROXIMUS",
	"20610"=> "Mobistar",
	"20620"=> "Base",
	"20801"=> "ITINERIS",
	"20810"=> "SFR",
	"20820"=> "Bouygues Telecom",
	"21303"=> "MOBILAND",
	"21401"=> "Airtel GSM 900-Spain",
	"21403"=> "Retevision Movil",
	"21407"=> "MOVISTAR",
	"21601"=> "Pannon GSM",
	"21670"=> "Vodafone",
	"21630"=> "Westel 900",
	"21890"=> "GSMBIH",
	"21901"=> "CRONET",
	"21910"=> "VIP",
	"22001"=> "MOBTEL",
	"22002"=> "ProMonte GSM",
	"22003"=> "Telekom Srbije",
	"22201"=> "Telecom Italia Mobile",
	"22210"=> "OMNITEL",
	"22288"=> "Wind Telecomunicazioni SpA",
	"22601"=> "CONNEX GSM",
	"22610"=> "DIALOG",
	"22801"=> "NATEL International",
	"22802"=> "diAx Mobile AG",
	"23001"=> "T-Mobile CZ",
	"23002"=> "EuroTel",
	"23003"=> "Oskar",
	"23101"=> "Orange",
	"23102"=> "EuroTel GSM",
	"23201"=> "A1",
	"23203"=> "T-Mobile AT",
	"23205"=> "ONE",
	"23207"=> "tele.ring",
	"23410"=> "Cellnet",
	"23415"=> "Vodafone",
	"23430"=> "T-Mobile UK",
	"23433"=> "ORANGE",
	"23450"=> "Jersey Telecoms GSM",
	"23455"=> "Guernsey Telecoms GSM",
	"23458"=> "PRONTO GSM",
	"23801"=> "TDK-MOBIL",
	"23802"=> "SONOFON",
	"23820"=> "TELIA DK",
	"23830"=> "Mobilix",
	"24001"=> "Telia AB",
	"24007"=> "COMVIQ",
	"24008"=> "EUROPOLITAN",
	"24201"=> "Telenor Mobil",
	"24202"=> "NetCom GSM",
	"24403"=> "Telia City (Finland)",
	"24405"=> "Radiolinja",
	"24409"=> "Finnet",
	"24491"=> "Sonera",
	"24601"=> "OMNITEL",
	"24602"=> "Bite GSM",
	"24701"=> "LMT LV",
	"24702"=> "BALTCOM GSM",
	"24801"=> "EMT GSM",
	"24802"=> "Radiolinja Eesti AS",
	"24803"=> "Q GSM",
	"25001"=> "Mobile Telesystems",
	"25002"=> "North-West GSM",
	"25005"=> "Siberian Cellular Systems 900",
	"25007"=> "BM Telecom",
	"25010"=> "Don Telecom",
	"25012"=> "FECS-900",
	"25013"=> "Kuban GSM",
	"25039"=> "Uraltel",
	"25044"=> "North Caucasian GSM",
	"25099"=> "BeeLine",
	"25501"=> "UMC",
	"25502"=> "WellCOM",
	"25503"=> "Kyivstar",
	"25505"=> "Golden Telecom",
	"25901"=> "VOXTEL",
	"26001"=> "PLUS GSM",
	"26002"=> "ERA GSM",
	"26003"=> "IDEA Centertel",
	"26201"=> "T-Mobile D",
	"26202"=> "D2 PRIVAT",
	"26203"=> "E-Plus",
	"26207"=> "Interkom",
	"26601"=> "Gibtel GSM",
	"26801"=> "TELECEL",
	"26803"=> "OPTIMUS",
	"26806"=> "TMN",
	"27001"=> "LUXGSM",
	"27077"=> "TANGO",
	"27201"=> "EIRCELL-GSM",
	"27202"=> "Digifone",
	"27401"=> "Landssiminn GSM 900",
	"27402"=> "TAL hf",
	"27601"=> "AMC",
	"27801"=> "Vodafone Malta Limited",
	"28001"=> "CYTAGSM",
	"28201"=> "Geocell Limited",
	"28202"=> "Magti GSM",
	"28301"=> "ArmGSM",
	"28401"=> "M-TEL GSM BG",
	"28601"=> "Turkcell",
	"28602"=> "TELSIM GSM",
	"28801"=> "Faroese Telecom",
	"29001"=> "Tele Greenland",
	"29340"=> "SI.MOBIL d. d.",
	"29341"=> "MOBITEL",
	"29370"=> "SI VEGA 070",
	"29401"=> "MobiMak",
	"30237"=> "Microcell Connexions Inc",
	"30272"=> "Rogers AT&T",
	"31001"=> "Cellnet",
	"31002"=> "Sprint Spectrum",
	"31011"=> "Wireless 2000 Telephone Co.",
	"31015"=> "BellSouth Mobility DCS",
	"31016"=> "T-Mobile",
	"31017"=> "Pac Bell",
	"31020"=> "T-Mobile",
	"31021"=> "T-Mobile",
	"31022"=> "T-Mobile",
	"31023"=> "T-Mobile",
	"31024"=> "T-Mobile",
	"31025"=> "T-Mobile",
	"31026"=> "T-Mobile",
	"31027"=> "T-Mobile",
	"31031"=> "T-Mobile",
	"31038"=> "AT&T Wireless",
	"31058"=> "T-Mobile",
	"31066"=> "T-Mobile",
	"31077"=> "Iowa Wireless Services LP",
	"31080"=> "T-Mobile",
	"34001"=> "AMERIS",
	"40001"=> "AZERCELL GSM",
	"40002"=> "Bakcell GSM 2000",
	"40407"=> "TATA Cellular",
	"40410"=> "AirTel",
	"40411"=> "Essar Cellphone",
	"40412"=> "Escotel",
	"40414"=> "Modicom",
	"40415"=> "Essar Cellphone",
	"40420"=> "Max Touch",
	"40421"=> "BPL - Mobile",
	"40427"=> "BPL USWEST Cellular",
	"40430"=> "Command",
	"40440"=> "SkyCell",
	"40441"=> "RPG Cellular",
	"40442"=> "AIRCEL",
	"41001"=> "Mobilink",
	"41302"=> "DIALOG GSM",
	"41501"=> "CELLIS",
	"41503"=> "LIBANCELL",
	"41601"=> "Fastlink",
	"41709"=> "MOBILE SYRIA",
	"41902"=> "MTCNet",
	"42001"=> "Al Jawwal",
	"42007"=> "E.A.E",
	"42202"=> "GTO",
	"42402"=> "UAE-ETISALAT",
	"42501"=> "Partner Communications Company Ltd",
	"42601"=> "BHR MOBILE PLUS",
	"42701"=> "QATARNET",
	"43211"=> "TCI",
	"43404"=> "Daewoo Unitel",
	"43405"=> "Coscom",
	"43701"=> "Bitel",
	"45400"=> "TCSL GSM",
	"45404"=> "HKGHT",
	"45406"=> "SMARTONE GSM",
	"45410"=> "New World PCS",
	"45412"=> "PEOPLES",
	"45416"=> "SUNDAY",
	"45501"=> "TELEMOVEL+ GSM900-Macau",
	"45601"=> "MobiTel",
	"45602"=> "SAMART-GSM",
	"45701"=> "Lao Shinawatra Telecom",
	"46000"=> "China Telecom GSM",
	"46001"=> "CU-GSM",
	"46601"=> "Far EasTone Telecoms 900",
	"46606"=> "TUNTEX GSM 1800",
	"46688"=> "KG Telecom",
	"46692"=> "Chunghwa GSM",
	"46693"=> "MobiTai",
	"46697"=> "TWNGSM",
	"46699"=> "TransAsia",
	"47001"=> "GrameenPhone Ltd",
	"47019"=> "Mobile 2000",
	"50212"=> "Maxis Mobile",
	"50213"=> "TM Touch",
	"50216"=> "DiGi 1800",
	"50217"=> "ADAM",
	"50219"=> "CELCOM",
	"50501"=> "MobileNet",
	"50502"=> "OPTUS",
	"50503"=> "VODAFONE",
	"50508"=> "One.Tel",
	"51001"=> "SATELINDO",
	"51008"=> "LIPPO TELECOM",
	"51010"=> "TELKOMSEL",
	"51011"=> "Excelcom",
	"51021"=> "INDOSAT",
	"51501"=> "ISLACOM",
	"51502"=> "Globe Telecom",
	"52001"=> "AIS GSM",
	"52010"=> "WCS",
	"52018"=> "Worldphone 1800",
	"52023"=> "HELLO",
	"52501"=> "SingTel Mobile",
	"52502"=> "ST-PCN",
	"52503"=> "MOBILEONE",
	"52811"=> "DSTCom",
	"53001"=> "Vodafone New Zealand Limited",
	"54201"=> "Vodafone",
	"54601"=> "Mobilis",
	"54720"=> "VINI",
	"60201"=> "MobiNil",
	"60202"=> "Tunicell",
	"60301"=> "ALGERIAN MOBILE NETWORK",
	"60401"=> "I A M",
	"60801"=> "ALIZE",
	"61102"=> "Lagui",
	"61203"=> "IVOIRIS",
	"61205"=> "Telecel",
	"61501"=> "TOGO CELL",
	"61701"=> "Cellplus Mobile Comms",
	"61801"=> "Omega",
	"62001"=> "SPACEFON",
	"62501"=> "CVMOVEL",
	"63301"=> "Seychelles Cellular Services",
	"63310"=> "AIRTEL",
	"63401"=> "MobiTel",
	"63510"=> "Rwandacell",
	"63601"=> "ETMTN",
	"64001"=> "TRITEL",
	"64110"=> "MTN-Uganda",
	"64202"=> "ANTARIS",
	"64301"=> "T.D.M GSM 900",
	"64501"=> "ZAMCELL",
	"64601"=> "Madacom",
	"64603"=> "Sacel Madagascar S.A.",
	"64710"=> "SRR",
	"64801"=> "NET*ONE",
	"64803"=> "Telecel",
	"64901"=> "MTC",
	"65001"=> "Callpoint 900",
	"65101"=> "Vodacom Lesotho (Pty) Ltd",
	"65501"=> "Vodacom",
	"65510"=> "MTN",
	"68038"=> "NPI Wireless",
	"73001"=> "Entel Telefonia Movi",
	"73010"=> "Entel PCS",
	"73401"=> "Infonet",
	undef   => 'unknown',
);

sub name
{
    my $number = $_[0];
    return exists $NETWORKS{$number}
        ? $NETWORKS{$number}
        : 'unknown';
}

sub country
{
    my $number = $_[0];
    return exists $COUNTRIES{$number}
        ? $COUNTRIES{$number}
        : 'unknown';
}

1;

#
# End of module
