# $Id: 30gsmascii.t,v 1.2 2003/04/04 05:40:02 cosimo Exp $
# test gsm <=> ascii charset conversions

use Test;
use lib '../blib/lib';
use Device::Gsm;

BEGIN { plan tests => 28 };


my @test_string = (
	'$ABC$ABC@ABC@',
	'$$$$@@@@@@@$$',
	join('','A'..'Z'),
	join('','a'..'z'),
	join('','0'..'9'),
	"\r\n\r\r\r\n\n\n",
	'/n/n/n/r/r/r/n/n/n/r/r/r',
	'!@#$%&*()+=<>/- ',
	' !"# %&()*+,-./',
	'0123456789:;<=>?',
	'-ABCDEFGHIJKLMNO',
	'PQRSTUVWXYZ',
	'abcdefghijklmno',
	'pqrstuvwxyz'
);

#print '\r = ', ord("\r"), "\n";
#print '\n = ', ord("\n"), "\n";

foreach( @test_string ) {

	my $a1 = $_;
	my $a1_copy = $a1;

	my $a2 = Device::Gsm::_gsm2ascii(undef, Device::Gsm::_ascii2gsm(undef, $a1) );

#	print "\$a1[$a1] \$a2[$a2]\n";

	ok( $a1 eq $a2 );

	$a1 = Device::Gsm::_ascii2gsm(undef, $a1_copy);
	$a2 = Device::Gsm::_ascii2gsm(undef, Device::Gsm::_gsm2ascii(undef, $a1) );

	ok( $a1 eq $a2 );

}

#+CMGL: 5,3,,66
#079193235058580011A90C919333151254340000AD3BC4B23D3D2EB78EF3B60E749687F5E932885C66B3C3A079F9EC0EB3C3FAF4DB5D0E81C220797A5E76D3D3F2713A041ABEE7E9F61B
#+CMGL: 1,1,,110
#059172281991040B917228732143F90000202140311040806846F9BB0D2296EF613619444597E56F3708357DD7E96850D02C4F8FC3A99D8258B6A7C7E5D671DE06D963AE988DA548BBE7F4309B5D2683DE6E1008D59C5ED3EE992CC502C1CB7236C85E73C16036182CA668BEC9BA69B2D82C3AA7
#+CMGL: 2,1,,31
#0791932350593900040C919323988277190000208082319082000DC170382C168BC3E1B0582C06
#+CMGL: 3,1,,138
#069134660405F1040C913466844136000000302021105373408746F9BB0D6A86E5F4B41BA4748198E1BA383C4683786D351B586ECFD32EB83C6D7785E9BE9D8258B6A7C7E5D671DE06D963AE988DA548BBE7F4309B5D2683DE6ED0383CA6D7E7AE727B9E76C1E569BB2B4C07A1D2339CADE52ED3C573728A058297E56C90BDE682C16C30584CD17C9375D364B159744E01
#+CMGL: 4,1,,159
#0791932350591900040C91932309851333000030301290243340A046F9BB0DBAA6DD64D0B42CB797E520E79B5C96ED14C4B23D3D2EB78EF336C81E73C56C2C45DA3DA787D9EC3219F47683EEF7BBCC4577D35BEDB738CD2EB7E8F2F038ED3EBBD274102A6DC3D95AECB4BB8E4FB140F0B29C0DB2D75C30980D068B299A6FB20E640CB3C7EFF6777A4FBBCF2050B3CAA4268541271104CAC1604510288683C140206B59AEA3C962
#+CMGL: 6,1,,133
#0791933385280200040C919333883425580000200150112245408246F9BB0D82CADFF630082A7FDBDF3B05B16C4F8FCBADE3BC0DB2C75C311C4B9176CFE96136BB4C06BDDD2010AA39BDA6DD33598A058297E56C90BDE682C16C8AE69BAC73BED7E930A8F916A7D9651014FD7697E72FE7B4D8AA81AC65B96E7A85D15C389CA2D5020DD3E1370B341F97DBEF10
#+CMGL: 7,1,,110
#0791934329003065040C919343682183550000301082904490406746F9BB0D2ABAE5E9F17BA72096EDE971B9759CB741F6982B666329D2EE393DCC6697C9A0B71BC47E8FC36CF47B4E77B1DFE3309BFC6E87D36E102A6DC3D95AECB4BB8E4FB140F0B29C0DB2D75C30184ED17C9375D364B159744E01
#+CMGL: 8,1,,159
#0791932350591900040C91932309851343000030301290436240A046F9BB0DBAA6DD64D0B42CB797E520E79B5C8EED14C4B23D3D2EB78EF336C81E73C56C2C45DA3DA787D9EC3219F47683E661FA989D86CD5C75B26B1EA697D967F9BB0E77B9CB74102A6DC3D95AECB4BB8E4FB140F0B29C0DB2D75C30980D068B299A6FB20E640CB3C7EFF6777A4FBBCF2050B3CAA4268541271104CAC1604510288683C140206B59AEA3C962
#+CMGL: 9,1,,118
#0791449737019037040C914497676398780000201121616464007146F9BB0D1286E5EEB0380F82D6E9F4F478BD5310CBF6F4B8DC3ACEDB207BCC15B3B11469F79C1E66B3CB64D0DB0D32CBCB657398CD7619E5E5B2704A74BDE567102A3DC3D95A6679B92C9E93532C10BC2C6783EC35170C5683CD14CD3759E77CAFD361
#+CMGL: 10,1,,96
#0791932350591900040C9193239882777900003030621253314058A018CBA5DB857EA8D4AAA57AF500A393A064E2F922DF006910168F65FB7FE2D12197CDB34DB94038A3D3B4C386B7796D7C1B8A7ACDAEB5DD6F5B1FC1E0C3E3F2F98D5EB7E30CFE3B3EAFCFC156





# end of test
