# Basic example of using an embedded regex compiler to parse out the
# components of a simple date string. Requires "regex-compiler.pbc",
# which can be generated by running
#
#  parrot -o regex-compiler.pbc regex-compiler.pir
#

.sub main :main
        .local pmc match
        .local pmc compile_regex
        .local pmc regex1
        .local pmc regex2
        load_bytecode "regex-compiler.pbc"
        compile_regex = compreg "regex"
        regex1 = compile_regex("([a-zA-Z]<3>)\\ ([a-zA-Z]+)\\ *([0-9])+")
        match = regex1("Mon Sep  6 22:45:48 PDT 2004")

        print "regex match today =~ /<?weekday> <?month> *<?day>/ (sorta): "
        if match goto goodness
        print "failed\n"
        end

goodness:
        print "succeeded!\n"
        print "Matching range: "
        $I0 = match["0";0]
        print $I0
        print ".."
        $I0 = match["0";1]
        print $I0
        print "\n"

        print "Weekday: "
        $S0 = match["1"]
        print $S0
        print "\nMonth: "
        $S0 = match["2"]
        print $S0
        print "\nDay: "
        $S0 = match["3"]
        print $S0
        print "\n"
        end
.end
