# $Id: /parrot/offline/languages/plumhead/src/perl5re/gen_past_pir.pl 4209 2007-02-28T02:03:42.197222Z coke  $

=head1 NAME

gen_past_pir.pl - A PHP compiler based on Perl5.10 regexes

=head1 DESCRIPTION

Parse PHP and create PIR.

=cut

# pragmata
use strict;
use warnings;
# use features;

# Modules from CPAN
use File::Slurp ();

my $php_source = File::Slurp::read_file( $ARGV[0] );

# TODO: parse it

my $past_pir = <<'END_PAST';

#!/usr/bin/env parrot                                             
                                                                  
# Do not edit this file.                                          
# This file has been generated by gen_past_pir.pl
                                                                  
.sub 'php_init' :load :init                                       
                                                                  
  load_bytecode 'languages/plumhead/src/common/plumheadlib.pbc'   
  load_bytecode 'PAST-pm.pbc'                                     
  load_bytecode 'Parrot/HLLCompiler.pbc'                          
  load_bytecode 'MIME/Base64.pbc'                                 
  load_bytecode 'dumper.pbc'                                      
  load_bytecode 'PGE.pbc'                                         
  load_bytecode 'CGI/QueryHash.pbc'                               
                                                                  
.end                                                              
                                                                  
.sub plumhead :main                                               
                                                                  
    # look for subs in other namespaces                           
    .local pmc parse_get_sub, parse_post_sub   
    parse_get_sub  = get_global [ 'CGI'; 'QueryHash' ], 'parse_get'         
    parse_post_sub = get_global [ 'CGI'; 'QueryHash' ], 'parse_post'        
                                                                  
    # the superglobals                                            
    .local pmc superglobal_GET                                    
    ( superglobal_GET ) = parse_get_sub()                         
    set_global '_GET', superglobal_GET                            
                                                                  
    .local pmc superglobal_POST                                   
    ( superglobal_POST ) = parse_post_sub()                       
    set_global '_POST', superglobal_POST                          
                                                                  
    # The root node of PAST.                                      
    .local pmc past_root                                          
    past_root  = new 'PAST::Block'                                
    past_root.init('name' => 'plumhead_main')                     
                                                                  
    .local pmc past_stmts                                         
    past_stmts = new 'PAST::Stmts'                                
                                                                  
    .sym pmc past_temp                                            
    .sym pmc past_name                                            
    .sym pmc past_if_op                                           
                                                                  

                                                                  
  # start of ECHO node                                            
  .local pmc past_echo                                            
  past_echo = new 'PAST::Op'                                      
  past_echo.'attr'( 'name', 'echo', 1 )                           

                                                                  
  # start of NOQUOTE_STRING                                       
  .local string val                                               
  val = "Hello, World!"                                       
  past_temp = new 'PAST::Val'                                     
  .local pmc code_string                                          
  code_string = new 'PGE::CodeString'                             
  ( val ) = code_string.'escape'( val )                           
      past_temp.'init'( 'name' => val, 'vtype' => '.Undef' )      
  past_echo.'push'( past_temp )                    
  # end of NOQUOTE_STRING                                         
                                                                  

                                                                  
  past_stmts.'push'( past_echo )                    
  # end of ECHO node                                              

                                                                  
                                                                  
  past_root.'push'( past_stmts )                                  
                                                                  
    #'_dumper'(past_root, 'past')                                
    # '_dumper'(superglobal_POST , 'superglobal_POST')            
    # '_dumper'(superglobal_GET , 'superglobal_GET')              
                                                                  
    # .local pmc post                                             
    # post = past_root.'compile'( 'target' => 'post' )            
    # '_dumper'(post, 'post')                                     
                                                                  
    # .local pmc pir                                              
    # pir = past_root.'compile'( 'target' => 'pir' )              
    # print pir                                                   
                                                                  
    .local pmc pastcompiler, eval_past                            
    pastcompiler = new 'HLLCompiler'                              
    pastcompiler.'removestage'('parse')                           
    pastcompiler.'removestage'('past')                            
    eval_past = pastcompiler.'compile'(past_root)                 
    eval_past()                                                   
                                                                  
.end                                                              
                                                                  

END_PAST

if ( $php_source =~ m/Hello/ )
{
  print $past_pir;
}
