#! /usr/bin/perl
#---------------------------------------------------------------------

use strict;
use warnings;
use Test::More 0.88 tests => 5; # done_testing

use Test::DZil 'Builder';

#---------------------------------------------------------------------
sub make_ini
{
  my $ini = <<'END START';
name     = DZT-Sample
author   = E. Xavier Ample <example@example.org>
license  = Perl_5
copyright_holder = E. Xavier Ample
version          = 0.04

[GatherDir]
[Metadata]
END START

  $ini . join('', map { "$_\n" } @_);
} # end make_ini

#---------------------------------------------------------------------
sub build_tzil
{
  my $tzil = Builder->from_config(
    { dist_root => 'corpus/DZT' },
    {
      add_files => {
        'source/dist.ini' => make_ini(@_),
      },
    },
  );

  $tzil->build;

  return $tzil;
} # end build_tzil

#---------------------------------------------------------------------
# Collect the standard metadata generated by Dist::Zilla:

my %base = %{ build_tzil->distmeta };

#---------------------------------------------------------------------
{
  my $tzil = build_tzil('dynamic_config = 1');

  is_deeply($tzil->distmeta, { %base, dynamic_config => 1 }, 'dynamic_config');
}

#---------------------------------------------------------------------
{
  my $tzil = build_tzil('no_index.directory = tools');

  is_deeply($tzil->distmeta,
            { %base, no_index => { directory => ['tools'] } },
            'no_index 1 directory');
}

#---------------------------------------------------------------------
{
  my $tzil = build_tzil(
    'no_index.directory = tools',
    'no_index.directory = inc',
    'no_index.package   = Foo::Bar',
  );

  is_deeply($tzil->distmeta,
            { %base, no_index => { directory => [qw(tools inc)],
                                   package   => ['Foo::Bar'] } },
            'no_index 2 directories and package');
}

#---------------------------------------------------------------------
{
  my $tzil = build_tzil(
    'resources.bugtracker.mailto = bugs@example.com',
  );

  is_deeply(
    $tzil->distmeta,
    { %base, resources => { bugtracker => { mailto => 'bugs@example.com' } } },
    'bugtracker mailto');
}

#---------------------------------------------------------------------
{
  my $tzil = build_tzil(
    'resources.bugtracker.mailto = bugs@example.com',
    'resources.bugtracker.web    = http://example.com',
  );

  is_deeply(
    $tzil->distmeta,
    { %base, resources => { bugtracker => {
        mailto => 'bugs@example.com',
        web    => 'http://example.com' } } },
    'bugtracker mailto and web');
}

done_testing;
