#!perl

# Copyright (C) 2006-2007, The Perl Foundation.
# $Id: /mirror/trunk/languages/dotnet/t/staticmethod.t 32683 2008-11-15T00:33:41.705103Z coke  $

use strict;
use warnings;
use lib qw( lib ../lib ../../lib dotnet dotnet/t );

use DotNetTesting;

use Test::More tests => 4;

## Testing class for this file.t';
#
die unless compile_cs( "t.dll", <<'CSHARP');
namespace Testing
{
    public class Test
    {
        public static int x;
        public static int y;

        public static void set_x()
    	{
	    	x = 5;
    	}

	    public static void set_y(int y)
    	{
	    	Test.y = y;
    	}

        public static int add()
        {
            return x + y;
        }

        public void test_no_args()
    	{
            set_x();
	    }

	    public void test_args(int y)
    	{
            set_y(y);
	    }

        public int test_ret()
        {
            set_x();
            set_y(37);
            return add();
        }
    }
}
CSHARP

## Attempt to translate.
ok( translate( "t.dll", "t.pbc" ), 'translate' );

## Tests.
is( run_pir(<<'PIR'), <<'OUTPUT', 'test_no_args' );
.HLL 'dotnet'
.sub main
	.local pmc obj
	load_bytecode "t.pbc"
	obj = new [ "Testing" ; "Test" ]
	obj.test_no_args()
    $P0 = new 'Integer'
    $P0 = get_hll_global [ "Testing" ; "Test" ], "x"
	print $P0
	print "\n"
.end
PIR
5
OUTPUT

is( run_pir(<<'PIR'), <<'OUTPUT', 'test_args' );
.HLL 'dotnet'
.sub main
	.local pmc obj
	load_bytecode "t.pbc"
	obj = new [ "Testing" ; "Test" ]
	obj.test_args(10)
    $P0 = new 'Integer'
    $P0 = get_hll_global [ "Testing" ; "Test" ], "y"
	print $P0
	print "\n"
.end
PIR
10
OUTPUT

is( run_pir(<<'PIR'), <<'OUTPUT', 'test_ret' );
.sub main
	.local pmc obj
	load_bytecode "t.pbc"
	obj = new [ "Testing" ; "Test" ]
    $I0 = obj.test_ret()
	print $I0
	print "\n"
.end
PIR
42
OUTPUT

## Clean up.
unlink qw(t.dll t.pbc);

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
