# Copyright (C) 2001-2003, The Perl Foundation.
# $Id: /mirror/trunk/tools/build/revision_c.pl 14991 2006-10-17T23:47:17.413119Z particle  $

=head1 NAME

tools/build/revision_c.pl

=head1 DESCRIPTION

Creates F<src/revision.c> with current rev number taken from
F<.svn/entries> or F<.svk/entries> and config rev number of last
Parrot configure run.

=head1 SEE ALSO

F<config/gen/revision.pl>,
F<lib/Parrot/Revision.pm>,
F<include/parrot/config.h>

=cut

use warnings;
use strict;
use lib qw{lib . ../lib ../../ lib};
use Parrot::Revision;

print <<"EOF";
/* ex: set ro:
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *
 * This file is generated automatically by $0.
 *
 * Any changes made here will be lost!
 *
 */

#include "parrot/config.h"

/* also in "parrot/embed.h" */
PARROT_API int Parrot_revision(void);
/* also in "parrot/misc.h" */
PARROT_API int Parrot_config_revision(void);

int Parrot_revision(void)
{
    return ${Parrot::Revision::current};
}

int Parrot_config_revision(void)
{
    return ${Parrot::Revision::config};
}

/*
 * Local variables:
 *   c-file-style: "parrot"
 * End:
 * vim: expandtab shiftwidth=4:
 */
EOF

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
