#!/usr/bin/env python
#-*-coding:utf8-*-

import MySQLdb

class MySQL:
    """ 
      function: mysql connection & query function
        author: yekai@taobao.com
           gmt: 2012-11-21
    """
     
    def __init__(self, host, port, user, passWd, dbName, charset):
        self.myConn = self.buildMySQLConnection(host, port, user, passWd, dbName, charset)
        self.myCurs = self.myConn.cursor()
         
    def buildMySQLConnection(self, Host, Port, userName, passWord, dbName, charSet):
        if Host is None or Port is None or userName is None or passWord is None or dbName is None:
            raise inputParameterError("buildMySQLConnection: input parameter can't for empty!")
         
        try:
            myConn = MySQLdb.connect(host=Host, port=int(Port), user=userName, passwd=passWord, db=dbName)
        except Exception, e:
            print "\nbuildMySQLConnection: connect to [%s][%s][%s] failed, error: %s\n" % (Host, Port, dbName, e)
            return False
         
        return myConn
          
    def execQuery(self, mySql):
        if mySql is None:
            raise inputParameterError("execQuery: input parameter can't for empty!")
          
        try:
            ret = self.myCurs.execute(mySql)
            res = self.myCurs.fetchall();
        except Exception, e:
            print "execQuery: %s!" % (e)
            return False
         
        return res
         
    def execTrans(self, mySql, charSet = 'latin1'):
        if mySql is None:
            raise inputParameterError("execQuery: input parameter can't for empty!")
         
        try:
            mySql = unicode(mySql, charSet)
            self.myCurs.execute(mySql)
            self.myConn.commit()
            ret = True
        except Exception, e:
            ret = False
            self.myConn.rollback()
         
        return ret

if __name__ == "__main__":
    hostName = "172.24.64.233"
    userName = "monitor"
    passWord = "tb4monitor"
    mySql = mySql.MySQL(hostName, 3306, userName, passWord, 'mwiki', 'utf8')
