/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt.gui;

import java.awt.BorderLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import org.ttt.salt.gui.TBXAbstractAction;
import org.ttt.salt.gui.TBXValidatorPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TBXValidator
extends JFrame
implements WindowListener {
    public static final String RCSID = "$Id: TBXValidator.java 1 2008-05-23 03:51:58Z lanhel $";
    private static final String PREFIX = "TBX";
    private static final String SUFFIX = ".xml";
    private static final TBXValidator INSTANCE = new TBXValidator();
    private final Properties properties = new Properties();
    private final Collection<JFrame> windows = new HashSet<JFrame>();

    public static TBXValidator getInstance() {
        return INSTANCE;
    }

    public static void validateFile(File file) throws IOException {
        TBXValidator.checkSecurity(file, false);
    }

    public static void validateFiles(Collection<File> files) throws IOException {
        for (File file : files) {
            TBXValidator.validateFile(file);
        }
    }

    private static void checkSecurity(File f, boolean write) throws IOException {
        if (f != null) {
            if (f.isDirectory()) {
                String msg = "Path {0} is a directory.";
                Object[] arg = new Object[]{f.getAbsolutePath()};
                String fmt = MessageFormat.format(msg, arg);
                throw new SecurityException(fmt);
            }
            if (f.exists()) {
                if (!f.canRead()) {
                    String msg = "You do not have read permission to {0}.";
                    Object[] arg = new Object[]{f.getAbsolutePath()};
                    String fmt = MessageFormat.format(msg, arg);
                    throw new SecurityException(fmt);
                }
                if (write && !f.canWrite()) {
                    String msg = "You do not have write permission to {0}.";
                    Object[] arg = new Object[]{f.getAbsolutePath()};
                    String fmt = MessageFormat.format(msg, arg);
                    throw new SecurityException(fmt);
                }
            } else {
                String msg = "File does not exist: {0}.";
                Object[] arg = new Object[]{f.getAbsolutePath()};
                String fmt = MessageFormat.format(msg, arg);
                throw new IOException(fmt);
            }
        }
    }

    private TBXValidator() {
        ResourceBundle bndl = ResourceBundle.getBundle("org.ttt.salt.gui.TBXValidator");
        TBXAbstractAction.setResourceBundle(bndl);
        this.setTitle(bndl.getString("Title"));
        this.setLayout(new BorderLayout());
        this.add(new TBXValidatorPanel(bndl));
        this.pack();
        this.setDefaultCloseOperation(3);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void putProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public void windowOpened(WindowEvent evt) {
        JFrame win = (JFrame)evt.getWindow();
        this.windows.add(win);
    }

    @Override
    public void windowClosed(WindowEvent evt) {
        JFrame win = (JFrame)evt.getWindow();
        this.windows.remove(win);
    }

    @Override
    public void windowClosing(WindowEvent evt) {
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    public boolean closeAllWindows() {
        Object[] wins = this.windows.toArray();
        block6: for (int i = 0; i < wins.length; ++i) {
            JFrame frame = (JFrame)wins[i];
            frame.toFront();
            frame.dispatchEvent(new WindowEvent(frame, 201));
            switch (frame.getDefaultCloseOperation()) {
                case 3: {
                    frame.dispose();
                    continue block6;
                }
                case 2: {
                    frame.dispose();
                    continue block6;
                }
                case 0: {
                    continue block6;
                }
                case 1: {
                    frame.setVisible(false);
                    continue block6;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown JFrame default close operation: " + frame.getDefaultCloseOperation());
                }
            }
        }
        return this.windows.isEmpty();
    }
}

