/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt.dom.tbx;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.parsers.SAXParser;
import org.ttt.salt.Configuration;
import org.ttt.salt.TBXException;
import org.ttt.salt.XCSDocument;
import org.ttt.salt.XCSValidationException;
import org.ttt.salt.dom.tbx.TBXDocument;
import org.ttt.salt.dom.tbx.TBXElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class TBXParser
extends Observable
implements ContentHandler,
DTDHandler,
EntityResolver,
ErrorHandler {
    public static final String RCSID = "$Id: TBXParser.java 147 2012-06-02 14:37:43Z lanhel $";
    public static final Set<String> KNOWN_MISSING = new TreeSet<String>(Arrays.asList("martifHeader", "date", "note", "tig", "ntig", "ref", "xref", "hi", "foreign", "bpt", "ept", "it", "ph", "ut", "langSet", "p", "fileDesc", "titleStmt", "title", "publicationStmt", "sourceDesc", "encodingDesc", "ude", "map", "revisionDesc", "change", "text", "front", "body", "back", "refObjectList", "refObject", "item", "itemGrp", "itemSet", "termEntry", "termGrp", "termNote", "termNoteGrp", "term", "termComp", "termCompGrp", "termCompList", "transac", "transacGrp", "transacNote", "admin", "adminGrp", "adminNote", "descrip", "descripGrp", "descripNote"));
    private static final Logger LOGGER = Logger.getLogger("org.ttt.salt.dom.tbx");
    private Configuration config;
    private XMLReader reader;
    private EntityResolver resolver;
    private Map<String, URI> namespace = new HashMap<String, URI>();
    private XCSDocument xcsDocument;
    private TBXDocument document;
    private TBXElement current;
    private Stack<TBXElement> stack = new Stack();
    private Locator locator;
    private boolean collapseWhitespace;
    private SortedSet<XCSValidationException> exceptions = new TreeSet<XCSValidationException>();

    public TBXParser(EntityResolver r, Configuration c) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.resolver = r;
        this.config = c;
        try {
            this.reader = new SAXParser();
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
            this.reader.setContentHandler(this);
            this.reader.setDTDHandler(this);
            this.reader.setEntityResolver(this.resolver);
            this.reader.setErrorHandler(this);
        }
        catch (SAXNotRecognizedException err) {
            LOGGER.log(Level.SEVERE, "Required parser feature is unavailable.", err);
            throw err;
        }
        catch (SAXNotSupportedException err) {
            LOGGER.log(Level.SEVERE, "Could not set required parser feature.", err);
            throw err;
        }
    }

    public TBXDocument parse(InputSource src) throws SAXException, IOException {
        if (this.document == null) {
            TBXDocument ret = new TBXDocument(true);
            this.setTBXDocument(ret);
        }
        this.reader.parse(src);
        return this.getTBXDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTBXDocument(TBXDocument doc) {
        TBXParser tBXParser = this;
        synchronized (tBXParser) {
            if (this.document != null) {
                throw new IllegalStateException("TBXParser is already parsing a document.");
            }
            this.document = doc;
        }
    }

    public TBXDocument getTBXDocument() {
        return this.document;
    }

    public XCSDocument getXCSDocument() {
        return this.xcsDocument;
    }

    public void setDocumentLocator(Locator loc) {
        LOGGER.entering("TBXParser", "setDocumentLocator", String.format("Line=%d Col=%d", loc.getLineNumber(), loc.getColumnNumber()));
        this.locator = loc;
    }

    public void startDocument() throws SAXException {
        LOGGER.entering("TBXParser", "startDocument");
        assert (this.stack.isEmpty()) : "TBXParser stack is not empty.";
    }

    public void endDocument() throws SAXException {
        LOGGER.entering("TBXParser", "endDocument");
        assert (this.stack.isEmpty()) : "TBXParser stack is not empty.";
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        LOGGER.entering("TBXParser", "startPrefixMapping", String.format("prefix='%s', uri='%s'", prefix, uri));
        LOGGER.info(String.format("startPrefixMapping: prefix='%s' uri='%s'", prefix, uri));
        try {
            this.namespace.put(prefix, new URI(uri));
        }
        catch (URISyntaxException err) {
            throw new SAXParseException("Invalid URI", this.locator, err);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        LOGGER.entering("TBXParser", "enPrefixMapping", String.format("prefix='%s'", prefix));
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        LOGGER.entering("TBXParser", "startElement", String.format("Element %d: uri='%s' local='%s' qName='%s'", this.locator.getLineNumber(), uri, localName, qName));
        this.stack.push(this.current);
        this.current = this.document.createTBXElement(localName, this.locator);
        for (int i = 0; i < atts.getLength(); ++i) {
            LOGGER.finer(String.format("Attribute: qname='%s' local='%s' type='%s' uri='%s' value='%s'", atts.getQName(i), atts.getLocalName(i), atts.getType(i), atts.getURI(i), atts.getValue(i)));
            try {
                this.current.setAttribute(atts.getQName(i), atts.getValue(i));
                continue;
            }
            catch (DOMException err) {
                LOGGER.severe(String.format("<%s %s='%s'> line %d\n\t%s", localName, atts.getQName(i), atts.getValue(i), this.locator.getLineNumber(), err.getLocalizedMessage()));
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        Exception err;
        LOGGER.entering("TBXParser", "endElement", String.format("Element %d: uri='%s' local='%s' qName='%s'", this.locator.getLineNumber(), uri, localName, qName));
        this.current.endElement(this.locator);
        TBXElement child = this.current;
        this.current = this.stack.pop();
        if (this.current != null) {
            this.current.appendChild(child);
        }
        boolean valid = false;
        this.exceptions.clear();
        if (this.config.getCheckEachTerm() && localName.equals("encodingDesc")) {
            NodeList plist = child.getElementsByTagName("p");
            for (int i = 0; i < plist.getLength(); ++i) {
                TBXException tbxerr;
                String msg;
                Element p = (Element)plist.item(i);
                String xcsURI = null;
                if (p.hasAttribute("type")) {
                    if (p.getAttribute("type").equals("XCSURI")) {
                        xcsURI = p.getTextContent().trim();
                    } else {
                        if (p.getAttribute("type").equals("XCSContent")) {
                            throw new UnsupportedOperationException("XCSContent location type unsupported.");
                        }
                        if (p.getAttribute("type").equals("DCSName")) {
                            xcsURI = p.getTextContent().trim();
                        } else if (p.getAttribute("type").equals("XCSName")) {
                            xcsURI = p.getTextContent().trim();
                        }
                    }
                }
                if (xcsURI == null) {
                    LOGGER.warning("XCS not specified.");
                    FileNotFoundException err2 = new FileNotFoundException("XCS not specified.");
                    TBXException tbxerr2 = new TBXException(TBXException.Priority.XCS, err2);
                    this.document.addParseException(tbxerr2);
                    continue;
                }
                try {
                    LOGGER.info("Using XCS: " + xcsURI);
                    this.xcsDocument = new XCSDocument(xcsURI, this.resolver, this.config);
                    break;
                }
                catch (FileNotFoundException err3) {
                    msg = String.format("XCS file '%s' not found. Because of error: %s", xcsURI, err3.getMessage());
                    LOGGER.info(msg);
                    LOGGER.log(Level.FINE, msg, err3);
                    tbxerr = new TBXException(TBXException.Priority.XCS, err3);
                    this.document.addParseException(tbxerr);
                    continue;
                }
                catch (UnknownHostException err4) {
                    msg = String.format("XCS file '%s' not found. Unknown host: %s", xcsURI, err4.getMessage());
                    LOGGER.info(msg);
                    LOGGER.log(Level.FINE, msg, err4);
                    tbxerr = new TBXException(TBXException.Priority.XCS, err4);
                    this.document.addParseException(tbxerr);
                    continue;
                }
                catch (IOException err5) {
                    LOGGER.log(Level.SEVERE, "Exception building XCS", err5.toString());
                    throw new SAXException("Could not build XCS.", err5);
                }
                catch (ParserConfigurationException err6) {
                    LOGGER.log(Level.WARNING, "Exception building XCS", err6);
                }
            }
        } else if (this.config.getCheckEachTerm() && localName.equals("martifHeader")) {
            if (this.xcsDocument == null) {
                err = new FileNotFoundException("XCS not specified.");
                TBXException tbxerr = new TBXException(TBXException.Priority.XCS, err);
                this.document.addParseException(tbxerr);
            }
        } else if (this.config.getCheckEachTerm() && localName.equals("termEntry")) {
            try {
                if (this.xcsDocument != null) {
                    this.xcsDocument.validateTermEntry(child);
                    valid = true;
                }
            }
            catch (XCSValidationException err7) {
                this.exceptions.add(err7);
                TBXException tbxerr = new TBXException(TBXException.Priority.XCS, err7);
                this.document.addParseException(tbxerr);
            }
        } else if (localName.equals("date") && !this.current.getTextContent().trim().matches("\\d{4}-\\d{2}-\\d{2}")) {
            err = new IllegalArgumentException(String.format("Unrecognized date string %s: ISO 8601 yyyy-mm-dd required.", this.current.getTextContent().trim()));
        }
        Event evt = new Event(child, valid);
        this.setChanged();
        this.notifyObservers(evt);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        LOGGER.entering("TBXParser", "characters", String.format("'%s'", new String(ch, start, length)));
        String data = new String(ch, start, length);
        if (this.collapseWhitespace) {
            data = data.replaceAll("\\s+", " ");
        }
        Text text = this.document.createTextNode(data);
        this.current.appendChild(text);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        LOGGER.entering("TBXParser", "ignorableWhitespace", String.format("'%s'", new String(ch, start, length)));
        if (!this.collapseWhitespace) {
            String data = new String(ch, start, length);
            Text text = this.document.createTextNode(data);
            this.current.appendChild(text);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        LOGGER.entering("TBXParser", "processingInstruction", String.format("target='%s' data='%s'", target, data));
    }

    public void skippedEntity(String name) throws SAXException {
        LOGGER.entering("TBXParser", "skippedEntity", String.format("name='%s'", name));
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        LOGGER.entering("TBXParser", "notationDecl", String.format("name='%s' publicId='%s' systemId='%s'", name, publicId, systemId));
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        LOGGER.entering("TBXParser", "unparsedEntityDecl", String.format("name='%s' publicId='%s' systemId='%s' notationName='%s'", name, publicId, systemId, notationName));
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        LOGGER.entering("TBXParser", "resolvedEntity", String.format("publicId='%s' systemId='%s'", publicId, systemId));
        return this.resolver.resolveEntity(publicId, systemId);
    }

    public void warning(SAXParseException exception) throws SAXException {
        LOGGER.log(Level.SEVERE, "TBXParser SAX Warning", exception);
        this.document.addParseException(new TBXException(TBXException.Priority.XMLVALID_MINOR, exception));
    }

    public void error(SAXParseException exception) throws SAXException {
        LOGGER.log(Level.SEVERE, "TBXParser SAX Error", exception);
        this.document.addParseException(new TBXException(TBXException.Priority.XMLVALID_MAJOR, exception));
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        LOGGER.log(Level.SEVERE, "TBXParser SAX Fatal", exception);
        this.document.addParseException(new TBXException(TBXException.Priority.WELLFORMED, exception));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestAccess {
        TestAccess() {
        }

        XMLReader reader() {
            return TBXParser.this.reader;
        }

        TBXDocument document() {
            return TBXParser.this.document;
        }

        void document(TBXDocument doc) {
            TBXParser.this.document = doc;
        }

        TBXElement current() {
            return TBXParser.this.current;
        }

        Stack<TBXElement> stack() {
            return TBXParser.this.stack;
        }

        Locator locator() {
            return TBXParser.this.locator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Event {
        private TBXElement element;
        private boolean valid;

        private Event(TBXElement elem, boolean v) {
            this.element = elem;
            this.valid = v;
        }

        public TBXElement getTBXElement() {
            return this.element;
        }

        public TBXElement getParentTBXElement() {
            return TBXParser.this.current;
        }

        public TBXDocument getTBXDocument() {
            return TBXParser.this.document;
        }

        public boolean isXCSValid() {
            return this.valid;
        }

        public Locator getLocator() {
            return TBXParser.this.locator;
        }

        public SortedSet<XCSValidationException> getExceptions() {
            return TBXParser.this.exceptions;
        }
    }
}

