#!/usr/bin/env perl -w
use strict;
use Test;
BEGIN { plan tests => 49 }

open ICS, ">test1.ics";
while (<main::DATA>) { print ICS $_ }
close ICS;

use Tie::iCal;

# TIEHASH
ok(tie my %events1, 'Tie::iCal', "test1.ics", 'debug' => 0);
ok(tie my %events2, 'Tie::iCal', "test2.ics", 'debug' => 0);

ok(scalar(%events1) == 46);

while (my ($key, $value) = each %events1) {
    $events2{$key} = $value;
    ok(compare($events1{$key}, $events2{$key}));
}

untie %events1;
untie %events2;
unlink 'test1.ics';
unlink 'test2.ics';

exit;

sub compare {
    my ($a, $b) = @_;
    return 0 if ref($a) ne ref($b);
    if (ref($a) eq 'ARRAY') {
        return 0 if $#$a != $#$b;
        for my $i (0..$#$a) {
            return 0 if !compare($$a[$i], $$b[$i]);
        }
    } elsif (ref($a) eq 'HASH') {
        my @A = sort keys %$a;
        my @B = sort keys %$b;
        return 0 if $#A != $#B;
        for my $j (0..$#A) {
            return 0 if !compare($A[$j], $B[$j]);
            return 0 if !compare($$a{$A[$j]}, $$b{$B[$j]});
        }
    } else {
        return 0 if $a ne $b;
    }
    return 1;
}

__END__
BEGIN:VCALENDAR
VERSION
 :2.0
PRODID
 :-//Mozilla.org/NONSGML Mozilla Calendar V1.0//EN
BEGIN:VEVENT
UID
 :413dd998-67d6-11d9-9a33-e4a59cf11a95
SUMMARY
 :my event
DESCRIPTION
 :my note
LOCATION
 :my location
URL
 :http://myurl.com
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
X
 ;MEMBER=AlarmEmailAddress
 :me@myaddress
RRULE
 :FREQ=WEEKLY;INTERVAL=1;BYDAY=TU,WE,TH
EXDATE
 :20050118T000000
DTSTART
 :20050118T160000Z
DTEND
 :20050118T170000Z
DTSTAMP
 :20050116T154856Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :927172676
SUMMARY
 :Summer Bank Holiday
CATEGORIES
 :Holidays
CLASS
 :PUBLIC
DTSTART
 ;VALUE=DATE
 :20020826
DTSTAMP
 :20020430T114937Z
END:VEVENT
BEGIN:VEVENT
UID
 :1ce81410-4769-11d9-8693-ee0b0a9128b1
SUMMARY
 :Christmas Day
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20041228
DTEND
 ;VALUE=DATE
 :20041229
DTSTAMP
 :20041206T092748Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :2285be0e-4769-11d9-9032-fb135edc90b2
SUMMARY
 :Boxing Day
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20041227
DTEND
 ;VALUE=DATE
 :20041228
DTSTAMP
 :20041206T092802Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :3be6a610-4769-11d9-bf60-e015b2923205
SUMMARY
 :Good Friday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20050325
DTEND
 ;VALUE=DATE
 :20050326
DTSTAMP
 :20041206T092845Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :42faa140-4769-11d9-8181-bcd3c0ece72d
SUMMARY
 :Easter Monday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20050328
DTEND
 ;VALUE=DATE
 :20050329
DTSTAMP
 :20041206T092857Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :496a1a2e-4769-11d9-8b9e-9a84f95c649f
SUMMARY
 :Early May Bank Holiday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20050502
DTEND
 ;VALUE=DATE
 :20050503
DTSTAMP
 :20041206T092907Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :4f246064-4769-11d9-add5-c041a1ed7968
SUMMARY
 :Spring Bank Holiday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20050530
DTEND
 ;VALUE=DATE
 :20050531
DTSTAMP
 :20041206T092917Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :56208410-4769-11d9-840a-ff72353214de
SUMMARY
 :Summer Bank Holiday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20050829
DTEND
 ;VALUE=DATE
 :20050830
DTSTAMP
 :20041206T092929Z
LAST-MODIFIED
 :20041206T092938Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :6389be50-4769-11d9-b537-96d51d02ab76
SUMMARY
 :Christmas Day
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20051227
DTEND
 ;VALUE=DATE
 :20051228
DTSTAMP
 :20041206T092951Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :698ded6c-4769-11d9-9e35-8764b0ff2b8e
SUMMARY
 :Boxing Day
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20051226
DTEND
 ;VALUE=DATE
 :20051227
DTSTAMP
 :20041206T093001Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :7323412e-4769-11d9-8f2d-c469be04ddf5
SUMMARY
 :New Year's Day
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20060102
DTEND
 ;VALUE=DATE
 :20060103
DTSTAMP
 :20041206T093018Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :7ff3e4ee-4769-11d9-b1d4-e2dcd6159dd0
SUMMARY
 :Good Friday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20060414
DTEND
 ;VALUE=DATE
 :20060415
DTSTAMP
 :20041206T093038Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :85c3a04e-4769-11d9-8af7-cda5e3e98ebe
SUMMARY
 :Easter Monday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20060417
DTEND
 ;VALUE=DATE
 :20060418
DTSTAMP
 :20041206T093047Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :8c18df5e-4769-11d9-ac09-e97dffd65595
SUMMARY
 :Early May Bank Holiday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20060501
DTEND
 ;VALUE=DATE
 :20060502
DTSTAMP
 :20041206T093101Z
LAST-MODIFIED
 :20041206T093108Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :958a6fda-4769-11d9-88db-e91b56d7b8f8
SUMMARY
 :Spring Bank Holiday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20060529
DTEND
 ;VALUE=DATE
 :20060530
DTSTAMP
 :20041206T093113Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :9f39fd7a-4769-11d9-a665-99a1ee535d36
SUMMARY
 :Summer Bank Holiday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20060828
DTEND
 ;VALUE=DATE
 :20060829
DTSTAMP
 :20041206T093129Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :a6b9427c-4769-11d9-964c-e7e2f4c2006a
SUMMARY
 :Christmas Day
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20061225
DTEND
 ;VALUE=DATE
 :20061226
DTSTAMP
 :20041206T093144Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :ab98305a-4769-11d9-b056-be29252508db
SUMMARY
 :Boxing Day
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20061226
DTEND
 ;VALUE=DATE
 :20061227
DTSTAMP
 :20041206T093151Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :b36fac5e-4769-11d9-9833-cbe45ff8e08b
SUMMARY
 :New Year's Day
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20070101
DTEND
 ;VALUE=DATE
 :20070102
DTSTAMP
 :20041206T093204Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :ba1d2270-4769-11d9-bc2f-f524346ae56f
SUMMARY
 :Good Friday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20070406
DTEND
 ;VALUE=DATE
 :20070407
DTSTAMP
 :20041206T093217Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :bf0cc0c4-4769-11d9-bd28-8ce79732df58
SUMMARY
 :Easter Monday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20070409
DTEND
 ;VALUE=DATE
 :20070410
DTSTAMP
 :20041206T093225Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :c70f271c-4769-11d9-85d5-eeae49afa7c8
SUMMARY
 :Early May Bank Holiday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20070507
DTEND
 ;VALUE=DATE
 :20070508
DTSTAMP
 :20041206T093238Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :cd6b8d3a-4769-11d9-8ec2-b2672c137a80
SUMMARY
 :Spring Bank Holiday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20070528
DTEND
 ;VALUE=DATE
 :20070529
DTSTAMP
 :20041206T093248Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :d5de0218-4769-11d9-8ab6-fc42c8cf7511
SUMMARY
 :Summer Bank Holiday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20070827
DTEND
 ;VALUE=DATE
 :20070828
DTSTAMP
 :20041206T093303Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :e2435c06-4769-11d9-8189-85efc4fcc75a
SUMMARY
 :Christmas Day
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20071225
DTEND
 ;VALUE=DATE
 :20071226
DTSTAMP
 :20041206T093325Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :e6b9626c-4769-11d9-9636-b4b242071a07
SUMMARY
 :Boxing Day
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20071226
DTEND
 ;VALUE=DATE
 :20071227
DTSTAMP
 :20041206T093331Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :eed602a2-4769-11d9-9c29-87e14bef7e97
SUMMARY
 :New Year's Day
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
DTSTART
 ;VALUE=DATE
 :20080101
DTEND
 ;VALUE=DATE
 :20080102
DTSTAMP
 :20041206T093345Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :de525990-4768-11d9-b210-dbb23e96122f
SUMMARY
 :New Year's day
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
X-MOZILLA-LASTALARMACK
 :20041207T102901
X-MOZILLA-RECUR-DEFAULT-INTERVAL
 :0
DTSTART
 ;VALUE=DATE
 :20040101
DTEND
 ;VALUE=DATE
 :20040102
DTSTAMP
 :20041206T092559Z
LAST-MODIFIED
 :20041207T102901Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :eaabc7bc-4768-11d9-a9f0-d813f0b4250b
SUMMARY
 :Good Friday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
X-MOZILLA-LASTALARMACK
 :20041207T102901
X-MOZILLA-RECUR-DEFAULT-INTERVAL
 :0
DTSTART
 ;VALUE=DATE
 :20040409
DTEND
 ;VALUE=DATE
 :20040410
DTSTAMP
 :20041206T092625Z
LAST-MODIFIED
 :20041207T102903Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :f3741142-4768-11d9-90f2-b75bdc777a72
SUMMARY
 :Easter Monday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
X-MOZILLA-LASTALARMACK
 :20041207T102901
X-MOZILLA-RECUR-DEFAULT-INTERVAL
 :0
DTSTART
 ;VALUE=DATE
 :20040412
DTEND
 ;VALUE=DATE
 :20040413
DTSTAMP
 :20041206T092637Z
LAST-MODIFIED
 :20041207T102903Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :ffac1e82-4768-11d9-af34-c8169769d183
SUMMARY
 :Early May Bank Holiday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
X-MOZILLA-LASTALARMACK
 :20041207T102901
X-MOZILLA-RECUR-DEFAULT-INTERVAL
 :0
DTSTART
 ;VALUE=DATE
 :20040503
DTEND
 ;VALUE=DATE
 :20040504
DTSTAMP
 :20041206T092702Z
LAST-MODIFIED
 :20041207T102903Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :06af693c-4769-11d9-88da-f9a496177710
SUMMARY
 :Spring Bank Holiday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
X-MOZILLA-LASTALARMACK
 :20041207T102901
X-MOZILLA-RECUR-DEFAULT-INTERVAL
 :0
DTSTART
 ;VALUE=DATE
 :20040531
DTEND
 ;VALUE=DATE
 :20040601
DTSTAMP
 :20041206T092714Z
LAST-MODIFIED
 :20041207T102904Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :0fcfe9c4-4769-11d9-b1de-afc927cc7b57
SUMMARY
 :Summer Bank Holiday
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
X-MOZILLA-LASTALARMACK
 :20041207T102901
X-MOZILLA-RECUR-DEFAULT-INTERVAL
 :0
DTSTART
 ;VALUE=DATE
 :20040830
DTEND
 ;VALUE=DATE
 :20040831
DTSTAMP
 :20041206T092731Z
LAST-MODIFIED
 :20041207T102904Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
BEGIN:VEVENT
UID
 :359d52c2-4769-11d9-9cd3-fde74dbfad50
SUMMARY
 :New Year's Day
STATUS
 :TENTATIVE
CLASS
 :PRIVATE
X-MOZILLA-ALARM-DEFAULT-LENGTH
 :0
X-MOZILLA-LASTALARMACK
 :20050103T010338
X-MOZILLA-RECUR-DEFAULT-INTERVAL
 :0
DTSTART
 ;VALUE=DATE
 :20050103
DTEND
 ;VALUE=DATE
 :20050104
DTSTAMP
 :20041206T092833Z
LAST-MODIFIED
 :20050103T010338Z
BEGIN:VALARM
TRIGGER
 ;VALUE=DURATION
 :-PT1S
END:VALARM
END:VEVENT
END:VCALENDAR
BEGIN:VCALENDAR
VERSION
 :2.0
PRODID
 :-//Mozilla.org/NONSGML Mozilla Calendar V1.0//EN
BEGIN:VEVENT
UID
 :971445858
SUMMARY
 :Christmas Day
CATEGORIES
 :Holidays
CLASS
 :PUBLIC
DTSTART
 ;VALUE=DATE
 :20021225
DTSTAMP
 :20020430T114937Z
END:VEVENT
END:VCALENDAR
BEGIN:VCALENDAR
VERSION
 :2.0
PRODID
 :-//Mozilla.org/NONSGML Mozilla Calendar V1.0//EN
BEGIN:VEVENT
UID
 :925921922
SUMMARY
 :Boxing Day
CATEGORIES
 :Holidays
CLASS
 :PUBLIC
DTSTART
 ;VALUE=DATE
 :20021226
DTSTAMP
 :20020430T114937Z
END:VEVENT
END:VCALENDAR
BEGIN:VCALENDAR
VERSION
 :2.0
PRODID
 :-//Mozilla.org/NONSGML Mozilla Calendar V1.0//EN
BEGIN:VEVENT
UID
 :936923338
SUMMARY
 :New Year's Day
CATEGORIES
 :Holidays
CLASS
 :PUBLIC
DTSTART
 ;VALUE=DATE
 :20030101
DTSTAMP
 :20020430T114937Z
END:VEVENT
END:VCALENDAR
BEGIN:VCALENDAR
VERSION
 :2.0
PRODID
 :-//Mozilla.org/NONSGML Mozilla Calendar V1.0//EN
BEGIN:VEVENT
UID
 :962980365
SUMMARY
 :Good Friday
CATEGORIES
 :Holidays
CLASS
 :PUBLIC
DTSTART
 ;VALUE=DATE
 :20030418
DTSTAMP
 :20020430T114937Z
END:VEVENT
END:VCALENDAR
BEGIN:VCALENDAR
VERSION
 :2.0
PRODID
 :-//Mozilla.org/NONSGML Mozilla Calendar V1.0//EN
BEGIN:VEVENT
UID
 :909072250
SUMMARY
 :Easter Monday
CATEGORIES
 :Holidays
CLASS
 :PUBLIC
DTSTART
 ;VALUE=DATE
 :20030421
DTSTAMP
 :20020430T114937Z
END:VEVENT
END:VCALENDAR
BEGIN:VCALENDAR
VERSION
 :2.0
PRODID
 :-//Mozilla.org/NONSGML Mozilla Calendar V1.0//EN
BEGIN:VEVENT
UID
 :940352282
SUMMARY
 :May Bank Holiday
CATEGORIES
 :Holidays
CLASS
 :PUBLIC
DTSTART
 ;VALUE=DATE
 :20030505
DTSTAMP
 :20020430T114937Z
END:VEVENT
END:VCALENDAR
BEGIN:VCALENDAR
VERSION
 :2.0
PRODID
 :-//Mozilla.org/NONSGML Mozilla Calendar V1.0//EN
BEGIN:VEVENT
UID
 :975821516
SUMMARY
 :Spring Bank Holiday
CATEGORIES
 :Holidays
CLASS
 :PUBLIC
DTSTART
 ;VALUE=DATE
 :20030526
DTSTAMP
 :20020430T114937Z
END:VEVENT
END:VCALENDAR
BEGIN:VCALENDAR
VERSION
 :2.0
PRODID
 :-//Mozilla.org/NONSGML Mozilla Calendar V1.0//EN
BEGIN:VEVENT
UID
 :902762343
SUMMARY
 :Summer Bank Holiday
CATEGORIES
 :Holidays
CLASS
 :PUBLIC
DTSTART
 ;VALUE=DATE
 :20030825
DTSTAMP
 :20020430T114937Z
END:VEVENT
END:VCALENDAR
BEGIN:VCALENDAR
VERSION
 :2.0
PRODID
 :-//Mozilla.org/NONSGML Mozilla Calendar V1.0//EN
BEGIN:VEVENT
UID
 :956630271
SUMMARY
 :Christmas Day
CATEGORIES
 :Holidays
CLASS
 :PUBLIC
DTSTART
 ;VALUE=DATE
 :20031225
DTSTAMP
 :20020430T114937Z
END:VEVENT
END:VCALENDAR
BEGIN:VCALENDAR
VERSION
 :2.0
PRODID
 :-//Mozilla.org/NONSGML Mozilla Calendar V1.0//EN
BEGIN:VEVENT
UID
 :911737808
SUMMARY
 :Boxing Day
CATEGORIES
 :Holidays
CLASS
 :PUBLIC
DTSTART
 ;VALUE=DATE
 :20031226
DTSTAMP
 :20020430T114937Z
END:VEVENT
BEGIN:VEVENT
ORGANIZER:Mailto:B@example.com
ATTENDEE;ROLE=CHAIR;PARTSTAT=ACCEPTED;CN=BIG A:Mailto:A@example.com
ATTENDEE;RSVP=TRUE;CUTYPE=INDIVIDUAL;CN=B:Mailto:B@example.com
ATTENDEE;RSVP=TRUE;CUTYPE=INDIVIDUAL;CN=C:Mailto:C@example.com
ATTENDEE;RSVP=TRUE;CUTYPE=INDIVIDUAL;CN=Hal:Mailto:D@example.com
ATTENDEE;RSVP=FALSE;CUTYPE=ROOM:conf_Big@example.com
ATTENDEE:conf_Big1@example.com
ATTENDEE;ROLE=NON-PARTICIPANT;RSVP=FALSE:Mailto:E@example.com
DTSTAMP:19970611T190000Z
DTSTART:19970701T190000Z
DTEND:19970701T193000Z
SUMMARY:Conference
UID:calsrv.example.com-873970198738777@example.com
SEQUENCE:1
STATUS:CONFIRMED
END:VEVENT
END:VCALENDAR