@rem = '--*-Perl-*--
@echo off
perl\bin\perl -x -S %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
@rem ';
#!.\perl\bin\perl -w
#line 8
#
# Install Perl binary distribution.
# Takes care of munging a Config.pm template.
#

use Cwd;
use File::Path;
use vars '*SAVERR';

my %OPT = ();
my $PWD = cwd;
$PWD =~ s|/|\\|g;
my $FROM = "$PWD\\perl";
my $TO = shift;
die "usage: $0 [g:\\your\\top\\level\\install\\dir]\n"
	if $TO and $TO =~ /^-/;

die "Please run $0 from the top level directory of Perl binary distribution.\n"
	unless -e $FROM;


print <<EOT;

Welcome to the Perl Binary Distribution for the Alpha Win32
platform!

Before proceeding, please make sure you have at least 20MB of
free space on the destination volume.

It is an excellent idea to actually read the README and the
README.AlphaNT file before
getting on with it.  Hope you managed to.

EOT

if ($TO) {
    print "You've asked that the stuff be installed into `$TO'.\n";
    $TO = "" unless yes_or_no("Correct?");
}

TOP:
if (not $TO) {
    $TO = ask_for_it("Where would you like Perl to be installed?", "c:\\perl");
}

if ($TO =~ /[\s;,!|<>~\@\%\&\$\*\?\+]/) {
    print <<EOT;

Looks like you are trying to install Perl into a path that contains
spaces or other special characters.  Though the latest Windows
operating systems claim to support filenames with such special
characters, many existing utilities will have trouble with such
path names.  Chances are that you will find this is simply too
much of a bad idea to be worth it.

EOT

    $TO = "" if yes_or_no("Want to change your mind before it is too late?");
}

try_again("TOP") unless $TO;

$OPT{INST_DRV} = ($TO =~ /^([A-Z]:)/i or $FROM =~ /^([A-Z]:)/i ? $1 : "c:");
$TO = "$PWD\\$TO" unless $TO =~ /^([\/\\]|[A-Z]:)/i; 
$OPT{INST_TOP} = $TO;
$OPT{CCTOP} = "c:\\MSDEV";
$OPT{CCINCDIR} = "$OPT{CCTOP}\\include";
$OPT{CCLIBDIR} = "$OPT{CCTOP}\\lib";
$OPT{CC} = 'cl';
$OPT{CCFLAGS} = '-MD -DWIN32';
$OPT{LIBS} = 'oldnames.lib kernel32.lib user32.lib gdi32.lib  winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib  oleaut32.lib netapi32.lib uuid.lib wsock32.l ib mpr.lib winmm.lib  version.lib odbc32.lib odbccp32.lib';
$OPT{AR} = 'lib';
$OPT{LD} = 'link';
$OPT{LDDLFLAGS} = '-dll';
$OPT{LDFLAGS} = '-nologo -subsystem:windows';
$OPT{LIBC} = 'msvcrt.lib';
$OPT{MAKE} = 'nmake';

unless (-d $TO) {
    undef($TO), try_again("TOP") unless yes_or_no("Ok to create `$TO'?");
    mkpath($TO, 1, 0777);
    mkpath($TO."\\lib", 1, 0777);
    warn("Failed to create `$TO': $!\n"), undef($TO), try_again("TOP") unless -d $TO;
}

CC1:
if (yes_or_no("Do you have a C compiler?")) {
if (yes_or_no("Do you have the Borland C++ 5.x compiler?")) {
    my $top = ask_for_it("Where is Borland C++ installed?","c:\\bc5");
    warn("Sorry, `$top' doesn't exist.\n"), try_again("CC1") unless (-d $top);
    my $inc = ask_for_it("The compiler's include files are in...",
                         "$top\\include");
    warn("Sorry, `$inc' doesn't exist.\n"), try_again("CC1") unless (-d $inc);
    my $lib = ask_for_it("The compiler's libraries are in...",
                         "$top\\lib");
    warn("Sorry, `$lib' doesn't exist.\n"), try_again("CC1") unless (-d $lib);
    $OPT{CCTOP} = $top;
    $OPT{CCINCDIR} = $inc;
    $OPT{CCLIBDIR} = $lib;
}
elsif (yes_or_no("Do you have the Visual C++ compiler (v2.0 or later)?")) {
    my $top = ask_for_it("Where is Visual C++ installed?","c:\\msdev\\vc");
    warn("Sorry, `$top' doesn't exist.\n"), try_again("CC1") unless (-d $top);
    my $inc = ask_for_it("The compiler's include files are in...",
                         "$top\\include");
    warn("Sorry, `$inc' doesn't exist.\n"), try_again("CC1") unless (-d $inc);
    my $lib = ask_for_it("The compiler's libraries are in...",
                         "$top\\lib");
    warn("Sorry, `$lib' doesn't exist.\n"), try_again("CC1") unless (-d $lib);
    $OPT{CCTOP} = $top;
    $OPT{CCINCDIR} = $inc;
    $OPT{CCLIBDIR} = $lib;

    $OPT{CC} = 'cl';
    $OPT{CCFLAGS} = '-MD -DWIN32';
    $OPT{LIBS} = 'oldnames.lib kernel32.lib user32.lib gdi32.lib winspool.lib '
               . 'comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib '
	       . 'netapi32.lib uuid.lib wsock32.lib mpr.lib winmm.lib '
	       . 'version.lib odbc32.lib odbccp32.lib';
    $OPT{AR} = 'lib';
    $OPT{LD} = 'link';
    $OPT{LDDLFLAGS} = '-dll';
    $OPT{LDFLAGS} = '-nologo -subsystem:windows';
    $OPT{LIBC} = 'msvcrt.lib';
    $OPT{MAKE} = 'nmake';
}
else {
    print <<EOT;

Other compilers are not supported at this time.  We will leave the
default compiler settings as they were (MSVC 4.2).

EOT
}
}

HTML:
if (yes_or_no("\n\nInstall HTML documentation? (needs 4.5MB)")) {
    my $top = ask_for_it("Where should HTML be installed?",$TO."\\html");

    $OPT{HTMLTOP} = $top;
    $top =~ y[:\\][|/];
    $top = '/' . $top unless $top =~ m|^/|;

    print <<EOT;

`$OPT{HTMLTOP}' is probably accessible from your web server
by a different name than its actual physical location.  The default
below will have the appropriate value to access it as a local file
from your web browser, but you probably want to enter something like
`/perldocs', if that is how you intend accessing the perl document
root via your web server.

(Yeah, I know.  We should be generating transportable HTML instead
of this rooted-pathname mess.)

EOT

    $OPT{HTMLROOT} = ask_for_it("Root of the perl HTML tree?",$top);
    # try_again("HTML") unless yes_or_no("Proceed?");
}

print <<EOT;

We're now ready to copy files.

Perl will be installed in `$TO'.

EOT

print <<EOT if $OPT{HTMLTOP};
HTML documentation will be installed in `$OPT{HTMLTOP}'.
Document URLs will begin at `$OPT{HTMLROOT}'.

EOT

yes_or_die("Proceed?");

print "Copying distribution from `$FROM' to `$TO'\n\n";
system(qq[xcopy /f /r /i /e /d "$FROM" "$TO"]) and die "Copy failed! : $!";

# copy the VC import lib if they chose VC++
if ($OPT{CC} =~ /^cl/i) {
    system(qq[xcopy /f /r "$PWD\\vcsupport\\perl-vc.lib" "$TO\\lib\\CORE\\perl.lib"])
	and die "Copy failed! : $!"; 
}

if ($OPT{HTMLTOP}) {
    print "\n\nGenerating HTML from PODs...\n",
	  "\nThis will take a while, please be patient\n\n\n";

    mkpath($OPT{HTMLTOP}, 1, 0777) unless -d $OPT{HTMLTOP};
    # pod2html is noisy
    # Win95's shell won't understand redirection, so do it the long way
    # Nope, this won't work either, on Win95
#    open(SAVERR, ">&STDERR"); open(STDERR, ">nul");
#    my @cmd = ($^X,
#	       qq{distfiles\\perl5.004_02\\installhtml},
#	       qq{--podroot=perl},
#	       qq{--htmldir="$OPT{HTMLTOP}"},
#	       qq{--htmlroot="$OPT{HTMLROOT}"},
#	       qq{--recurse},
#	       qq{--libpod=perlfunc:perlguts:perlvar:perlrun:perlop}
#	      );
#    print join(" ", @cmd), "\n";
#    system(@cmd) and warn "HTML generation failed! : $!";
#    close STDERR; open(STDERR, ">&SAVERR");

    local @ARGV = (
	           qq{--podroot=perl},
	           qq{--htmldir=$OPT{HTMLTOP}},
	           qq{--htmlroot=$OPT{HTMLROOT}},
	           qq{--recurse},
	           qq{--libpod=perlfunc:perlguts:perlvar:perlrun:perlop}
	          );
    local $SIG{__WARN__} = sub {};  # suppress
    print join(" ", "installhtml", @ARGV), "\n";
    do "$PWD\\distfiles\\perl5.004_02\\installhtml";
    warn "HTML generation failed! : $@" if $@;
}

my $CFGPM = "$TO\\lib\\Config.pm";
print "\n\nGenerating new `$CFGPM'\n";

my $TEMPLATE = "$PWD\\Configpm.tpl";

open(T, "<$TEMPLATE") or die "Can't open $TEMPLATE: $!";
open(C, ">$CFGPM") or die "Can't open $CFGPM: $!";
while (<T>) {
    s/~(\w+)~/$OPT{$1}/g;
    print C $_;
}
close T; close C;

print <<EOT;

Perl has been successfully installed at `$TO'.

To start using Perl please add the following location to your
`Path' environment variable:

    $TO\\bin

You can do this in the `Environment' tab of the `System' Control Panel
(accessible by mousing "Start" -> "Settings" -> "Control Panel").

You can also set the `PERL5LIB' environment variable to a `;' separated
list of paths if you later install modules in locations other than
`$TO'.

Setting PERL5LIB is not required if you want to simply use the stuff
that got installed just now.

Have a nice day.


EOT

$_ = <STDIN>;		# hang around in case they ran it from Explorer

sub yes_or_die {
    my $m = shift || "Proceed?";
    print "$m [y] ";
    die "Bailing out\n" if scalar(<STDIN>) !~ /^\s*(y|$)/i;
}

sub yes_or_no {
    my $m = shift || "Which?";
    print "$m [y] ";
    return 1 if scalar(<STDIN>) =~ /^\s*(y|$)/i;
}

sub ask_for_it {
    my $m = shift || "Enter value";
    my $def = shift;
    $def = "" unless defined $def;
    print "$m \[$def\] ";
    my $v = <STDIN>;
    chomp $v;
    return ($v =~ /^\s*$/ ? $def : $v);
}

sub try_again {
    print "Let's try this again.\n";
    goto shift;
}

__END__
:endofperl
