#!/usr/bin/env perl

use strict;
use warnings;

use lib 'blib/lib';

use Test::More;

use File::Temp;
use Cwd;
use FindBin;
use File::Basename;

use Automate::Animate::FFmpeg;

my $curdir = Cwd::abs_path($FindBin::Bin);

my $anim_outfile = 'abc';

my @inpimages = (
	File::Spec->catfile($curdir, 't-data', 'images', 'red.png'),
	File::Spec->catfile($curdir, 't-data', 'images', 'green.png'),
	File::Spec->catfile($curdir, 't-data', 'images', 'blue.png'),
	File::Spec->catfile($curdir, 't-data', 'images', 'yellow.png'),
);
my $aaFF = Automate::Animate::FFmpeg->new({
	'input-images' => \@inpimages,
	'output-filename' => $anim_outfile,
});
$aaFF->frame_duration(3);
my $ret = $aaFF->_build_ffmpeg_cmdline();
ok(defined $ret, '_build_ffmpeg_cmdline()'." : called and got defined result.");
is(ref($ret), 'HASH', '_build_ffmpeg_cmdline()'." : called and got defined result which is a HASHref.");
for (qw/cmdline tmpfile/){
	ok(exists($ret->{$_}), '_build_ffmpeg_cmdline()'." : return contains key '$_'.");
}
ok(-f $ret->{'tmpfile'}, '_build_ffmpeg_cmdline()'." : created a tmpfile: '".$ret->{'tmpfile'}."'.");
ok(-s $ret->{'tmpfile'}, '_build_ffmpeg_cmdline()'." : created a tmpfile and it is not empty: '".$ret->{'tmpfile'}."'.");

# END
done_testing;
