package Image::Quantize;
require Exporter;
@ISA = qw(Exporter);
@EXPORT_OK = qw//;
%EXPORT_TAGS = (
    all => \@EXPORT_OK,
);
use warnings;
use strict;
use Carp;
our $VERSION = '0.00_04';
require XSLoader;
XSLoader::load ('Image::Quantize', $VERSION);

# Things which can be set.

my %settable = (
    dithering_level => {
	function => \& dithering_level,
    },
    max_colors => {
	function => \& max_colors,
    },
    quality => {
	arguments => 2,
	function => \& quality,
    },
    speed => {
	function => \& speed,
    },
    min_opacity => {
	function => \& min_opacity,
    },
    min_posterization => {
	function => \& min_posterization,
    },
    output_gamma => {
	function => \& output_gamma,
    },
);

sub new
{
    my ($class, %options) = @_;
    my $o = internal_new ();
    $o->set (%options);
    return $o;
}

no strict 'refs';

sub set
{
    my ($self, %options) = @_;
    for my $option (keys %options) {
	my $s = $settable{$option};
	if ($s) {
	    my $arg = $options{$option};
	    my @arg;
	    if ($s->{arguments}) {
		@arg = @$arg;
	    }
	    else {
		@arg = ($arg);
	    }
	    &{"Image::Quantize::$option"} ($self, @arg);
	}
    }
}

sub get
{
    my ($self, $option) = @_;
    return &{"Image::Quantize::$option"} ($self);
}

use strict 'refs';

sub set_log_callback
{
    my ($self, $function, $data) = @_;
    if ($function) {
	if (ref $function ne 'CODE') {
	    croak 'set_log_callback (\& function, $data);';
	}
    }
    set_log_callback_internal ($self, $function, $data);
}


1;
