use strict;
use warnings;
use ExtUtils::MakeMaker;

use lib 'inc';

use Devel::CheckLib;

check_lib_or_exit (lib => 'png', header => 'png.h');

my $pm = 'lib/Image/Quantize.pm';
my $github = 'github.com/benkasminbullock/image-quantize';
my $repo = "https://$github";

# C object files we are going to compile.

my $stems = [qw/blur libimagequant mediancut
		mempool nearest pam viter/];
my @objects = map {"$_.o"} @$stems;

WriteMakefile (
    NAME => 'Image::Quantize',
    VERSION_FROM => $pm,
    ABSTRACT_FROM => $pm,
    AUTHOR => 'Ben Bullock <bkb@cpan.org>',
    LICENSE => 'perl',
    PREREQ_PM => {
	# The module relies on stuff introduced in version 0.33 of the
	# following module, to do with setting memory.
	'Image::PNG::Libpng' => '0.33',
    },
    META_MERGE => {
	'meta-spec' => {
	    version => 2,
	},
        resources => {
            repository => {
		type => 'git',
		url => "git://$github.git",
		web => $repo,
	    },
            bugtracker => {
		web => "$repo/issues",
	    },
#	    homepage => 'http://',
        },
    },
    OBJECT => "Quantize.o @objects",
    LIBS => '-lpng',
    # This is going to foul things up on some systems, but setting
    # CCFLAGS fouls things up on every system. ExtUtils::MakeMaker,
    # what a nightmare it is.
    OPTIMIZE => '-g -Wall -O -std=c99',
    MIN_PERL_VERSION => '5.008001',
);
