WebShortcutSamples
==================

A collection of Internet/web shortcut files for various operating systems.

Shortcut Types
--------------
A summary of the shortcut types follows.  Note that I made these observations based on experimentation.
Examining source code would give a deeper understanding of what is happening, but I have not done that (yet).

### .url ###
- Legacy format used by Windows.
- The default for older versions of Internet Explorer (before version 9?).
- Still generated by Chrome and Firefox.
- The name of the link is not embedded in the file.  The name displayed in Explorer is the file name.
  Changing the name of the shortcut changes the name of the file, but does not affect the contents.

### .website ###
- New format used by Windows.
- See http://msdn.microsoft.com/en-us/library/gg131029%28v=vs.85%29.aspx
- This format was introduced in Internet Explorer 9.
- Called a "Pinned Site" in Windows.
- Based on exprimentation, I found programatically generating a .website file is non-trivial.
  If you don't get the parameters exactly right, it will not work properly.
  As of yet, I cannot find documentation describing the format.
- The name of the link appears to be embedded in the file.  The name displayed in Explorer is the name of the file.
  Changing the name of the shortcut changes the name of the file, but does not change the name in the file.

### .desktop ###
- This is a Free Desktop Entry, used by Gnome and KDE, as well as Solaris (which I think uses Gnome).
- See http://standards.freedesktop.org/desktop-entry-spec/latest/
- Can be used for application links as well as Internet Shortcuts.
- In Ubuntu 12.04 Gnome (English language):
  - The file name is the title of the websire.
  - The link name embedded in the desktop file is "Link to " followed by the title of website.
  - The file explorer displays the name embedded in the file (i.e. the one starting with "Link to").
  - When the file is renamed in explorer a "Name[en_US]" entry is added to the file with the new name.
    The old "Name" entry is also retained with the original link name.
    The file name is changed to the new name, inluding the "Link to".
- In Mint 14 KDE:
  - The file name and the name embedded in the file are both the same as the URL.
  - The file explorer displays the file name.
  - Renaming the file changes the file name, but does not change the embedded name.
  

### .webloc ###
- Used by Mac OSX.
- All webloc files are plist files.  There are two types of plist files: binary and xml.  Both use the same webloc extension.
- The shortcut is called a "Web Internet Location" in OSX.
- The link name is not stored in the file.
- Mac OSX displays the file name.
- Renaming the link changes the file name, but does not change the contents of the file.

Folder Structure
-------------------
The following is a description of this project's folder structure.

### fake ###
- These shortcuts were created using a text editor to serve as test cases.
- They demonstrate defects and variations which may not actually happen in the real world.

### real ###
- These are real shortcuts.
  These were all generated by opening a webpage in a browser, and dragging the URL from the address bar into a file explorer window.
- The following websites were used:
  - https://www.google.com/
  - http://www.myspace.com/
  - http://www.yahoo.com/
  - http://www.google.se/#sclient=tablet-gws&hl=sv&tbo=d&q=sverige&oq=sveri&gs_l=tablet-gws.1.1.0l3.13058.15637.28.17682.5.2.2.1.1.0.143.243.0j2.2.0...0.0...1ac.1.xX8iu4i9hYM&pbx=1&fp=1&bpcl=40096503&biw=1280&bih=800&bav=on.2,or.r_qf.&cad=b
  - http://www.microsoft.com/sv-se/default.aspx
  - http://www.baidu.com/
  - http://cn.yahoo.com/
  - http://japan.zdnet.com/
  - http://xn--fet810g.xn--fiqs8s/
  - http://www.xn--fiqs8sirgfmh.xn--zfr164b.cn/
- I used a set of real websites, including ones with non-latin titles and URLs.
  Note that I do not endorse these websites, I only chose them for demonstration purposes.
- Where possible, I tried to consolidate shortcuts and remove duplicates
  (for example webloc files are usually the same regardless of which browser was used).
- Each shortcut extension appears under its own folder.

### real/desktop/gnome ###
- Used Ubuntu 12.04 64 bit
- Used these browsers:
  - Firefox 17.0.1
  - I could not generate any shortcuts with Chrome 23.0.
    I received this error: There was an error getting information about "/".
- There is a sample of a renamed link in the "renamed" folder.
  this link was renamed from "Link to Google" to "Link to Google - renamed".

### real/desktop/kde ###
- Used Mint 14 KDE 64 bit with Firefox 16.0.2
- Based on a quick look, Kubuntu appears to work the same way (including the apparently incorrect "[$e]" encoding).
- The file names use funky slashes (UTF codepoint U+2044) as well as a : (colon).
  These don't work well on all filesystems so I replaced them with underscores.
- The sverige Google search URL was too long and caused problems on KDE.  Therefore I excluded it from the KDE folder.
  
### real/webloc ###
- I was not able to open all URLs with all browsers (due to hangs, etc.).
- Used Mac OSX 10.6.8 operating system.
- Used these browsers:
  - Safari 5.0.5
  - Firefox 17.0.1
  - Chrome 23.0
- Safari generates binary webloc files, whereas Chrome and Firefox generate XML webloc files.
  To get a larger set of samples, I used the built-in plist command line utility to convert the XML webloc's to binary webloc's and vice-versa.
  These are the commands I used for the conversion:
  - plutil -convert xml1 file
  - plutil -convert binary1 file
- For the most part, all of the webloc's matched eachother regardless of which browser was used.
  The converted shortcuts generated by plist matched as well.
- The only browser difference I observed: Firefox used percent encoding for non-latin URLs.
  I included these in their own "percent_encoded" folders.
- Mac OSX creates files starting with a . (period) which match the real filename.
  I understand these are part of the resource fork scheme.
  Because these files are hidden, they will not be copied when you copy the main webloc file.
  They should not be needed - the main webloc file should be sufficient.
  I did include these files in the dot_files folder for reference.
  Although the main webloc files were the same between browsers, the dot files varied for each browser.

### real/url ###
- Used:
  - Windows 8 Pro 64 bit - Chrome 23.0
  - Windows 8 Pro 64 bit - Firefox 17.0.1
  - Windows XP Home SP3 - Internet Explorer 8.0
- Each browser produced different shortcut contents and file names, so I made folders for each browser.
    
### real/website ###
- Use:
  - Windows 7 Pro 64 bit SP1 - Internet Explorer 9.0
  - Windows 8 Pro 64 bit - Internet Explorer 10.0.1
- Each environment was a little different, so I split the shortcuts into IE9 and IE10 folders.
  
Notes
-----
- Chrome OS does have shortcuts, but they do not appear to be normal files (so I don't think they can be copied).

Useful Commands
---------------
- Mass plist conversion (on Max OSX):
  - find . -name \*.webloc -exec plutil -convert binary1 "{}" \;
  - find . -name \*.webloc -exec plutil -convert xml1 "{}" \
- Mass conversion of binary files to hex for compare (on Linux):
  - find . -type f -iname \* -exec sh -c 'xxd "{}" > "{}.hex"' \;