use 5.006;
use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME             => 'Hypothesis::API',
    AUTHOR           => q{Brandon E. Barker <brandon.barker@cornell.edu>},
    VERSION_FROM     => 'lib/Hypothesis/API.pm',
    ABSTRACT_FROM    => 'lib/Hypothesis/API.pm',
    LICENSE          => 'artistic_2',
    META_MERGE => {
        'meta-spec' => { version => 2 },
        resources => {
            repository => {
                 type => 'git',
                 url  => 'https://github.com/bbarker/Hypothesis-API.git',
                 web  => 'https://github.com/bbarker/Hypothesis-API',
            },
        },
    },
    PL_FILES         => {},
    MIN_PERL_VERSION => 5.006,
    CONFIGURE_REQUIRES => {
        'ExtUtils::MakeMaker' => 0,
    },
    BUILD_REQUIRES => {
        'Test::More' => 0,
    },
    PREREQ_PM => {
        #'ABC'              => 1.6,
        #'Foo::Bar::Module' => 5.0401,
    },
    dist  => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean => { FILES => 'Hypothesis-API-*' },
);
