package Padre::Plugin::WxWidgets;
BEGIN {
  $Padre::Plugin::WxWidgets::VERSION = '0.01';
}

# ABSTRACT: wxWidgets support for Padre

use warnings;
use strict;

use base 'Padre::Plugin';

use Padre::Wx ();

sub padre_interfaces {
	'Padre::Plugin' => '0.47',;
}

sub menu_plugins_simple {
	my $self = shift;

	return (
		Wx::gettext('wxWidgets Support') => [
			Wx::gettext('About'), sub { $self->show_about },
		]
	);
}

sub show_about {
	my $about = Wx::AboutDialogInfo->new;
	$about->SetName("Padre::Plugin::WxWidgets");
	$about->SetDescription( Wx::gettext('wxWidgets support for Padre') );
	$about->SetVersion($Padre::Plugin::WxWidgets::VERSION);
	Wx::AboutBox($about);
	return;
}


1;


=pod

=head1 NAME

Padre::Plugin::WxWidgets - wxWidgets support for Padre

=head1 VERSION

version 0.01

=head1 SYNOPSIS

	$>padre
	Plugins -> wxWidgets Support -> *

=head1 DESCRIPTION

This provides basic development and documentation support for wxWidgets in L<Padre>. Once installed,
Padre will be able to provide help search support for Wx classes.

=head1 wxWidgets.pod

C<wxWidgets.pod> was generated by C<parse_wxwidgets_docs.pl>. The original wxWidgets HTML documentation
L<http://garr.dl.sourceforge.net/project/wxwindows/Documents/2.8.10/wxWidgets-2.8.10-HTML.zip>
is copyrighted as the follows:

    Copyright (c) 1992-2006 by Julian Smart, Robert Roebling, Vadim Zeitlin
    and other members of the wxWidgets team. Portions (c) 1996 Artificial
    Intelligence Applications Institute.

    The original documentation is licensed under wxWindows Library License version 3.1
    L<http://docs.wxwidgets.org/2.8.10/wx_wxlicense.html> and GNU Library
    General Public License version 2 L<http://docs.wxwidgets.org/2.8.10/wx_gnulicense.html>.

=head1 AUTHOR

Ahmad M. Zawawi <ahmad.zawawi@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2010 by Ahmad M. Zawawi.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut


__END__

