/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.javascript.host.css.BrowserConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class StyleAttributes {
    private static final Map<String, Definition> styles_ = new HashMap<String, Definition>();

    private StyleAttributes() {
    }

    public static Definition getDefinition(String propertyName, BrowserVersion browserVersion) {
        if (browserVersion == null) {
            return null;
        }
        Definition definition = styles_.get(propertyName);
        if (definition == null) {
            return null;
        }
        if (!definition.isAvailable(browserVersion)) {
            return null;
        }
        return definition;
    }

    public static List<Definition> getDefinitions(BrowserVersion browserVersion) {
        ArrayList<Definition> list = new ArrayList<Definition>();
        for (Definition definition : Definition.values()) {
            if (!definition.isAvailable(browserVersion)) continue;
            list.add(definition);
        }
        return list;
    }

    static {
        Definition.values();
    }

    public static enum Definition {
        MOZ_ANIMATION("MozAnimation", "-moz-animation", BrowserConfiguration.ff17up("")),
        MOZ_ANIMATION_DELAY("MozAnimationDelay", "-moz-animation-delay", BrowserConfiguration.ff17up("0s")),
        MOZ_ANIMATION_DIRECTION("MozAnimationDirection", "-moz-animation-direction", BrowserConfiguration.ff17up("normal")),
        MOZ_ANIMATION_DURATION("MozAnimationDuration", "-moz-animation-duration", BrowserConfiguration.ff17up("0s")),
        MOZ_ANIMATION_FILL_MODE("MozAnimationFillMode", "moz-annimation-fill-mode", BrowserConfiguration.ff17up("none")),
        MOZ_ANIMATION_ITERATION_COUNT("MozAnimationIterationCount", "-moz-animation-iteration-count", BrowserConfiguration.ff17up("1")),
        MOZ_ANIMATION_NAME("MozAnimationName", "moz-annimation-name", BrowserConfiguration.ff17up("none")),
        MOZ_ANIMATION_PLAY_STATE("MozAnimationPlayState", "moz-annimation-play-state", BrowserConfiguration.ff17up("running")),
        MOZ_ANIMATION_TIMING_FUNCTION("MozAnimationTimingFunction", "moz-annimation-timing-function", BrowserConfiguration.ff17up("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        MOZ_APPEARANCE("MozAppearance", "-moz-appearance", BrowserConfiguration.ff("none")),
        MOZ_BACKFACE_VISIBILITY("MozBackfaceVisibility", "-moz-backface-visibility", BrowserConfiguration.ff17up("visible")),
        MOZ_BACKGROUND_CLIP("MozBackgroundClip", "-moz-background-clip", BrowserConfiguration.ffBelow17("border")),
        MOZ_BACKGROUND_INLINE_POLICY("MozBackgroundInlinePolicy", "-moz-background-inline-policy", BrowserConfiguration.ff("continuous")),
        MOZ_BACKGROUND_ORIGIN("MozBackgroundOrigin", "-moz-background-origin", BrowserConfiguration.ffBelow17("padding")),
        MOZ_BACKGROUND_SIZE("MozBackgroundSize", "-moz-background-size", BrowserConfiguration.ffBelow17("auto auto")),
        MOZ_BINDING("MozBinding", "-moz-binding", BrowserConfiguration.ff("none")),
        MOZ_BORDER_BOTTOM_COLORS("MozBorderBottomColors", "-moz-border-bottom-colors", BrowserConfiguration.ff("none")),
        MOZ_BORDER_END("MozBorderEnd", "-moz-border-end", BrowserConfiguration.ff("")),
        MOZ_BORDER_END_COLOR("MozBorderEndColor", "-moz-border-end-color", BrowserConfiguration.ff("")),
        MOZ_BORDER_END_STYLE("MozBorderEndStyle", "-moz-border-end-style", BrowserConfiguration.ff("")),
        MOZ_BORDER_END_WIDTH("MozBorderEndWidth", "-moz-border-end-width", BrowserConfiguration.ff("")),
        MOZ_BORDER_IMAGE("MozBorderImage", "-moz-border-image", BrowserConfiguration.ffBelow17("none"), BrowserConfiguration.ff("")),
        MOZ_BORDER_LEFT_COLORS("MozBorderLeftColors", "-moz-border-left-colors", BrowserConfiguration.ff("none")),
        MOZ_BORDER_RADIUS("MozBorderRadius", "-moz-border-radius", BrowserConfiguration.ffBelow17("")),
        MOZ_BORDER_RADIUS_BOTTOMLEFT("MozBorderRadiusBottomleft", "-moz-border-radius-bottomleft", BrowserConfiguration.ffBelow17("0px")),
        MOZ_BORDER_RADIUS_BOTTOMRIGHT("MozBorderRadiusBottomright", "-moz-border-radius-bottomright", BrowserConfiguration.ffBelow17("0px")),
        MOZ_BORDER_RADIUS_TOPLEFT("MozBorderRadiusTopleft", "-moz-border-radius-topleft", BrowserConfiguration.ffBelow17("0px")),
        MOZ_BORDER_RADIUS_TOPRIGHT("MozBorderRadiusTopright", "-moz-border-radius-topright", BrowserConfiguration.ffBelow17("0px")),
        MOZ_BORDER_RIGHT_COLORS("MozBorderRightColors", "-moz-border-right-colors", BrowserConfiguration.ff("none")),
        MOZ_BORDER_START("MozBorderStart", "-moz-border-start", BrowserConfiguration.ff("")),
        MOZ_BORDER_START_COLOR("MozBorderStartColor", "-moz-border-start-color", BrowserConfiguration.ff("")),
        MOZ_BORDER_START_STYLE("MozBorderStartStyle", "-moz-border-start-style", BrowserConfiguration.ff("")),
        MOZ_BORDER_START_WIDTH("MozBorderStartWidth", "-moz-border-start-width", BrowserConfiguration.ff("")),
        MOZ_BORDER_TOP_COLORS("MozBorderTopColors", "-moz-border-top-colors", BrowserConfiguration.ff("none")),
        MOZ_BOX_ALIGN("MozBoxAlign", "-moz-box-align", BrowserConfiguration.ff("stretch")),
        MOZ_BOX_DIRECTION("MozBoxDirection", "-moz-box-direction", BrowserConfiguration.ff("normal")),
        MOZ_BOX_FLEX("MozBoxFlex", "-moz-box-flex", BrowserConfiguration.ff("0")),
        MOZ_BOX_ORDINAL_GROUP("MozBoxOrdinalGroup", "-moz-box-ordinal-group", BrowserConfiguration.ff("1")),
        MOZ_BOX_ORIENT("MozBoxOrient", "-moz-box-orient", BrowserConfiguration.ff("horizontal")),
        MOZ_BOX_PACK("MozBoxPack", "-moz-box-pack", BrowserConfiguration.ff("start")),
        MOZ_BOX_SHADOW("MozBoxShadow", "-moz-box-shadow", BrowserConfiguration.ffBelow17("none")),
        MOZ_BOX_SIZING("MozBoxSizing", "-moz-box-sizing", BrowserConfiguration.ff("content-box")),
        MOZ_COLUMN_COUNT("MozColumnCount", "-moz-column-count", BrowserConfiguration.ff("auto")),
        MOZ_COLUMN_GAP("MozColumnGap", "-moz-column-gap", BrowserConfiguration.ff("16px")),
        MOZ_COLUMN_RULE("MozColumnRule", "-moz-column-rule", BrowserConfiguration.ff("")),
        MOZ_COLUMN_RULE_COLOR("MozColumnRuleColor", "-moz-column-rule-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        MOZ_COLUMN_RULE_STYLE("MozColumnRuleStyle", "-moz-column-rule-style", BrowserConfiguration.ff("none")),
        MOZ_COLUMN_RULE_WIDTH("MozColumnRuleWidth", "-moz-column-rule-width", BrowserConfiguration.ff("0px")),
        MOZ_COLUMN_WIDTH("MozColumnWidth", "-moz-column-width", BrowserConfiguration.ff("auto")),
        MOZ_COLUMNS("MozColumns", "-moz-columns", BrowserConfiguration.ff17up("")),
        MOZ_FLOAT_EDGE("MozFloatEdge", "-moz-float-edge", BrowserConfiguration.ff("content-box")),
        MOZ_FONT_FEATURE_SETTINGS("MozFontFeatureSettings", "-moz-font-feature-settings", BrowserConfiguration.ff17up("normal")),
        MOZ_FONT_LANGUAGE_OVERRIDE("MozFontLanguageOverride", "-moz-font-language-override", BrowserConfiguration.ff17up("normal")),
        MOZ_FORCE_BROKEN_IMAGE_ICON("MozForceBrokenImageIcon", "-moz-force-broken-image-icon", BrowserConfiguration.ff("0")),
        MOZ_HYPHENS("MozHyphens", "-moz-hyphens", BrowserConfiguration.ff17up("manual")),
        MOZ_IMAGE_REGION("MozImageRegion", "-moz-image-region", BrowserConfiguration.ff("auto")),
        MOZ_MARGIN_END("MozMarginEnd", "-moz-margin-end", BrowserConfiguration.ff("")),
        MOZ_MARGIN_START("MozMarginStart", "-moz-margin-start", BrowserConfiguration.ff("")),
        MOZ_OPACITY("MozOpacity", "-moz-opacity", BrowserConfiguration.ffBelow17("1")),
        MOZ_ORIENT("MozOrient", "-moz-orient", BrowserConfiguration.ff17up("horizontal")),
        MOZ_OUTLINE("MozOutline", "-moz-outline", BrowserConfiguration.ffBelow17("")),
        MOZ_OUTLINE_COLOR("MozOutlineColor", "-moz-outline-color", BrowserConfiguration.ffBelow17("rgb(0, 0, 0)")),
        MOZ_OUTLINE_OFFSET("MozOutlineOffset", "-moz-outline-offset", BrowserConfiguration.ffBelow17("0px")),
        MOZ_OUTLINE_RADIUS("MozOutlineRadius", "-mz-outline-radius", BrowserConfiguration.ff("")),
        MOZ_OUTLINE_RADIUS_BOTTOMLEFT("MozOutlineRadiusBottomleft", "-moz-outline-radius-bottomleft", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_BOTTOMRIGHT("MozOutlineRadiusBottomright", "-moz-outline-radius-bottomright", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_TOPLEFT("MozOutlineRadiusTopleft", "-moz-outline-radius-topleft", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_TOPRIGHT("MozOutlineRadiusTopright", "-moz-outline-radius-topright", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_STYLE("MozOutlineStyle", "-moz-outline-style", BrowserConfiguration.ffBelow17("none")),
        MOZ_OUTLINE_WIDTH("MozOutlineWidth", "-moz-outline-width", BrowserConfiguration.ffBelow17("0px")),
        MOZ_PADDING_END("MozPaddingEnd", "-moz-padding-end", BrowserConfiguration.ff("")),
        MOZ_PADDING_START("MozPaddingStart", "-moz-padding-start", BrowserConfiguration.ff("")),
        MOZ_PERSPECTIVE("MozPerspective", "-moz-perspective", BrowserConfiguration.ff17up("none")),
        MOZ_PERSPECTIVE_ORIGIN("MozPerspectiveOrigin", "-moz-perspective-origin", BrowserConfiguration.ff17up("628px 170px")),
        MOZ_STACK_SIZING("MozStackSizing", "-moz-stack-sizing", BrowserConfiguration.ff("stretch-to-fit")),
        MOZ_TAB_SIZE("MozTabSize", "-moz-tab-size", BrowserConfiguration.ff17up("8")),
        MOZ_TEXT_ALIGN_LAST("MozTextAlignLast", "-moz-text-align-last", BrowserConfiguration.ff17up("auto")),
        MOZ_TEXT_BLINK("MozTextBlink", "-moz-text-blink", BrowserConfiguration.ff17up("none")),
        MOZ_TEXT_DECORATION_COLOR("MozTextDecorationColor", "-moz-text-decoration-color", BrowserConfiguration.ff17up("rgb(0, 0, 0)")),
        MOZ_TEXT_DECORATION_LINE("MozTextDecorationLine", "-moz-text-decoration-line", BrowserConfiguration.ff17up("none")),
        MOZ_TEXT_DECORATION_STYLE("MozTextDecorationStyle", "-moz-text-decoration-style", BrowserConfiguration.ff17up("solid")),
        MOZ_TEXT_SIZE_ADJUST("MozTextSizeAdjust", "-moz-text-size-adjust", BrowserConfiguration.ff17up("auto")),
        MOZ_TRANSFORM("MozTransform", "-moz-transform", BrowserConfiguration.ff("none")),
        MOZ_TRANSFORM_ORIGIN("MozTransformOrigin", "-moz-transform-origin", BrowserConfiguration.ffBelow17("50% 50%"), BrowserConfiguration.ff("628px 170px")),
        MOZ_TRANSFORM_STYLE("MozTransformStyle", "-moz-transform-style", BrowserConfiguration.ff17up("flat")),
        MOZ_TRANSITION("MozTransition", "-moz-transition", BrowserConfiguration.ff17up("")),
        MOZ_TRANSITION_DELAY("MozTransitionDelay", "-moz-transition-delay", BrowserConfiguration.ff17up("0s")),
        MOZ_TRANSITION_DURATION("MozTransitionDuration", "-moz-transition-duration", BrowserConfiguration.ff17up("0s")),
        MOZ_TRANSITION_PROPERTY("MozTransitionProperty", "-moz-transition-property", BrowserConfiguration.ff17up("all")),
        MOZ_TRANSITION_TIMING_FUNCTION("MozTransitionTimingFunction", "-moz-transition-timing-function", BrowserConfiguration.ff17up("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        MOZ_USER_FOCUS("MozUserFocus", "-moz-user-focus", BrowserConfiguration.ff("none")),
        MOZ_USER_INPUT("MozUserInput", "-moz-user-input", BrowserConfiguration.ff("auto")),
        MOZ_USER_MODIFY("MozUserModify", "-moz-user-modify", BrowserConfiguration.ff("read-only")),
        MOZ_USER_SELECT("MozUserSelect", "-moz-user-select", BrowserConfiguration.ff("auto")),
        MOZ_WINDOW_SHADOW("MozWindowShadow", "-moz-window-shadow", BrowserConfiguration.ff("default")),
        ANIMATION("animation", "animation", BrowserConfiguration.ff17up("")),
        ANIMATION_DELAY("animationDelay", "animation-delay", BrowserConfiguration.ff17up("0s")),
        ANIMATION_DIRECTION("animationDirection", "animation-direction", BrowserConfiguration.ff17up("normal")),
        ANIMATION_DURATION("animationDuration", "animation-duration", BrowserConfiguration.ff17up("0s")),
        ANIMATION_FILL_MODE("animationFillMode", "animation-fill-mode", BrowserConfiguration.ff17up("none")),
        ANIMATION_ITERATION_COUNT("animationIterationCount", "animation-iteration-count", BrowserConfiguration.ff17up("1")),
        ANIMATION_NAME("animationName", "animation-name", BrowserConfiguration.ff17up("none")),
        ANIMATION_PLAY_STATE("animationPlayState", "animation-play-state", BrowserConfiguration.ff17up("running")),
        ANIMATION_TIMING_FUNCTION("animationTimingFunction", "animation-timing-function", BrowserConfiguration.ff17up("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        AZIMUTH("azimuth", "azimuth", BrowserConfiguration.ffBelow17("")),
        BACKFACE_VISIBILITY("backfaceVisibility", "backface-visibility", BrowserConfiguration.ff17up("visible")),
        BACKGROUND_CLIP("backgroundClip", "background-clip", BrowserConfiguration.ff17up("border-box")),
        BACKGROUND_ORIGIN("backgroundOrigin", "background-origin", BrowserConfiguration.ff17up("padding-box")),
        BACKGROUND_SIZE("backgroundSize", "background-size", BrowserConfiguration.ff17up("auto auto")),
        BORDER_BOTTOM_LEFT_RADIUS("borderBottomLeftRadius", "border-bottom-left-radius", BrowserConfiguration.ff17up("0px")),
        BORDER_BOTTOM_RIGHT_RADIUS("borderBottomRightRadius", "border-bottom-right-radius", BrowserConfiguration.ff17up("0px")),
        BORDER_IMAGE("borderImage", "border-image", BrowserConfiguration.ff17up("")),
        BORDER_IMAGE_OUTSET("borderImageOutset", "border-image-outset", BrowserConfiguration.ff17up("0 0 0 0")),
        BORDER_IMAGE_REPEAT("borderImageRepeat", "border-image-repeat", BrowserConfiguration.ff17up("stretch stretch")),
        BORDER_IMAGE_SLICE("borderImageSlice", "border-image-slice", BrowserConfiguration.ff17up("100% 100% 100% 100%")),
        BORDER_IMAGE_SOURCE("borderImageSource", "border-image-source", BrowserConfiguration.ff17up("none")),
        BORDER_IMAGE_WIDTH("borderImageWidth", "border-image-width", BrowserConfiguration.ff17up("1 1 1 1")),
        BORDER_RADIUS("borderRadius", "border-radius", BrowserConfiguration.ff17up("")),
        BORDER_TOP_LEFT_RADIUS("borderTopLeftRadius", "border-top-left-radius", BrowserConfiguration.ff17up("0px")),
        BORDER_TOP_RIGHT_RADIUS("borderTopRightRadius", "border-top-right-radius", BrowserConfiguration.ff17up("0px")),
        BOX_SHADOW("boxShadow", "box-shadow", BrowserConfiguration.ff17up("none")),
        CLIP_PATH("clipPath", "clip-path", BrowserConfiguration.ff17up("none")),
        CLIP_RULE("clipRule", "clip-rule", BrowserConfiguration.ff17up("nonzero")),
        COLOR_INTERPOLATION("colorInterpolation", "color-interpolation", BrowserConfiguration.ff17up("srgb")),
        COLOR_INTERPOLATION_FILTERS("colorInterpolationFilters", "color-interpolation-filters", BrowserConfiguration.ff17up("linearrgb")),
        CUE("cue", "cue", BrowserConfiguration.ffBelow17("")),
        CUE_AFTER("cueAfter", "cue-after", BrowserConfiguration.ffBelow17("")),
        CUE_BEFORE("cueBefore", "cue-before", BrowserConfiguration.ffBelow17("")),
        DOMINANT_BASELINE("dominantBaseline", "dominant-baseline", BrowserConfiguration.ff17up("auto")),
        ELEVATION("elevation", "elevation", BrowserConfiguration.ffBelow17("")),
        FILL("fill", "fill", BrowserConfiguration.ff17up("rgb(0, 0, 0)")),
        FILL_OPACITY("fillOpacity", "fill-opacity", BrowserConfiguration.ff17up("1")),
        FILL_RULE("fillRule", "fill-rule", BrowserConfiguration.ff17up("nonzero")),
        FILTER("filter", "filter", BrowserConfiguration.ff17up("none"), BrowserConfiguration.ie("")),
        FLOOD_COLOR("floodColor", "flood-color", BrowserConfiguration.ff17up("rgb(0, 0, 0)")),
        FLOOD_OPACITY("floodOpacity", "flood-opacity", BrowserConfiguration.ff17up("1")),
        IMAGE_RENDERING("imageRendering", "image-rendering", BrowserConfiguration.ff17up("auto")),
        LIGHTING_COLOR("lightingColor", "lighting-color", BrowserConfiguration.ff17up("rgb(255, 255, 255)")),
        LINE_HEIGHT("lineHeight", "line-height", BrowserConfiguration.ff17up("19px"), BrowserConfiguration.ffBelow17("20px"), BrowserConfiguration.ie("20px")),
        MARKER("marker", "marker", BrowserConfiguration.ff17up("")),
        MARKER_END("markerEnd", "marker-end", BrowserConfiguration.ff17up("none")),
        MARKER_MID("markerMid", "marker-mid", BrowserConfiguration.ff17up("none")),
        MARKER_START("markerStart", "marker-start", BrowserConfiguration.ff17up("none")),
        MASK("mask", "mask", BrowserConfiguration.ff17up("none")),
        PAUSE("pause", "pause", BrowserConfiguration.ffBelow17("")),
        PAUSE_AFTER("pauseAfter", "pause-after", BrowserConfiguration.ffBelow17("")),
        PAUSE_BEFORE("pauseBefore", "pause-before", BrowserConfiguration.ffBelow17("")),
        PITCH("pitch", "pitch", BrowserConfiguration.ffBelow17("")),
        PITCH_RANGE("pitchRange", "pitch-range", BrowserConfiguration.ffBelow17("")),
        PERSPECTIVE("perspective", "perspective", BrowserConfiguration.ff17up("none")),
        PERSPECTIVE_ORIGIN("perspectiveOrigin", "perspective-origin", BrowserConfiguration.ff17up("628px 170px")),
        QUOTES("quotes", "quotes", BrowserConfiguration.ffBelow17(""), BrowserConfiguration.ff17up("\"\u201c\" \"\u201d\" \"\u2018\" \"\u2019\""), BrowserConfiguration.ie8up("")),
        RESIZE("resize", "resize", BrowserConfiguration.ff17up("none")),
        RICHNESS("richness", "richness", BrowserConfiguration.ffBelow17("")),
        SHAPE_RENDERING("shapeRendering", "shape-rendering", BrowserConfiguration.ff17up("auto")),
        SPEAK("speak", "speak", BrowserConfiguration.ffBelow17("")),
        SPEAK_HEADER("speakHeader", "speak-header", BrowserConfiguration.ffBelow17("")),
        SPEAK_NUMERAL("speakNumeral", "speak-numeral", BrowserConfiguration.ffBelow17("")),
        SPEAK_PUNCTUATION("speakPunctuation", "speak-punctuation", BrowserConfiguration.ffBelow17("")),
        SPEECH_RATE("speechRate", "speech-rate", BrowserConfiguration.ffBelow17("")),
        STOP_COLOR("stopColor", "stop-color", BrowserConfiguration.ff17up("rgb(0, 0, 0)")),
        STOP_OPACITY("stopOpacity", "stop-opacity", BrowserConfiguration.ff17up("1")),
        STROKE("stroke", "stroke", BrowserConfiguration.ff17up("none")),
        STROKE_DASHARRAY("strokeDasharray", "stroke-dasharray", BrowserConfiguration.ff17up("none")),
        STROKE_DASHOFFSET("strokeDashoffset", "stroke-dashoffset", BrowserConfiguration.ff17up("0px")),
        STROKE_LINECAP("strokeLinecap", "stroke-linecap", BrowserConfiguration.ff17up("butt")),
        STROKE_LINEJOIN("strokeLinejoin", "stroke-linejoin", BrowserConfiguration.ff17up("miter")),
        STROKE_MITERLIMIT("strokeMiterlimit", "stroke-miterlimit", BrowserConfiguration.ff17up("4")),
        STROKE_OPACITY("strokeOpacity", "stroke-opacity", BrowserConfiguration.ff17up("1")),
        STROKE_WIDTH("strokeWidth", "stroke-width", BrowserConfiguration.ff17up("1px")),
        STRESS("stress", "stress", BrowserConfiguration.ffBelow17("")),
        TEXT_ANCHOR("textAnchor", "text-anchor", BrowserConfiguration.ff17up("start")),
        TEXT_OVERFLOW("textOverflow", "text-overflow", BrowserConfiguration.ff17up("clip")),
        TEXT_RENDERING("textRendering", "text-rendering", BrowserConfiguration.ff17up("auto")),
        TRANSFORM("transform", "transform", BrowserConfiguration.ff17up("none")),
        TRANSFORM_ORIGIN("transformOrigin", "transform-origin", BrowserConfiguration.ff17up("628px 170px")),
        TRANSFORM_STYLE("transformStyle", "transform-style", BrowserConfiguration.ff17up("flat")),
        TRANSITION("transition", "transition", BrowserConfiguration.ff17up("")),
        TRANSITION_DELAY("transitionDelay", "transition-delay", BrowserConfiguration.ff17up("0s")),
        TRANSITION_DURATION("transitionDuration", "transition-duration", BrowserConfiguration.ff17up("0s")),
        TRANSITION_PROPERTY("transitionProperty", "transition-property", BrowserConfiguration.ff17up("all")),
        TRANSITION_TIMING_FUNCTION("transitionTimingFunction", "transition-timing-function", BrowserConfiguration.ff17up("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        UNICODE_BIDI("unicodeBidi", "unicode-bidi", BrowserConfiguration.ffBelow17("embed"), BrowserConfiguration.ff17up("-moz-isolate"), BrowserConfiguration.ie("embed")),
        VECTOR_EFFECT("vectorEffect", "vector-effect", BrowserConfiguration.ff17up("none")),
        VOICE_FAMILY("voiceFamily", "voice-family", BrowserConfiguration.ffBelow17("")),
        VOLUME("volume", "volume", BrowserConfiguration.ffBelow17("")),
        WORD_BREAK("wordBreak", "word-break", BrowserConfiguration.ff17up("normal"), BrowserConfiguration.ie(""));

        private final String propertyName_;
        private final String attributeName_;
        private final BrowserConfiguration[] browserConfigurations_;

        private Definition(String propertyName, String styleAttributeName, BrowserConfiguration ... browserConfigurations) {
            this.attributeName_ = styleAttributeName;
            this.propertyName_ = propertyName;
            this.browserConfigurations_ = browserConfigurations;
            styles_.put(this.propertyName_, this);
        }

        private boolean isAvailable(BrowserVersion browserVersion) {
            return BrowserConfiguration.isDefined(browserVersion, this.browserConfigurations_);
        }

        public String getPropertyName() {
            return this.propertyName_;
        }

        public String getAttributeName() {
            return this.attributeName_;
        }

        public String getDefaultComputedValue(BrowserVersion browserVersion) {
            return BrowserConfiguration.getMatchingConfiguration(browserVersion, this.browserConfigurations_).getDefaultValue();
        }
    }
}

