/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.html.IEConditionalCommentExpressionEvaluator;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.XMLString;
import org.cyberneko.html.HTMLScanner;

class HTMLScannerForIE
extends HTMLScanner {
    HTMLScannerForIE(BrowserVersion browserVersion) {
        this.fContentScanner = new ContentScannerForIE(browserVersion);
    }

    protected boolean skipMarkup(boolean balance) throws IOException {
        ContentScannerForIE contentScanner = (ContentScannerForIE)this.fContentScanner;
        String s = contentScanner.nextContent(30);
        if (s.startsWith("[if ") && s.contains("]>")) {
            String condition = StringUtils.substringBefore((String)s.substring(4), (String)"]>");
            try {
                int ch;
                if (IEConditionalCommentExpressionEvaluator.evaluate(condition, contentScanner.browserVersion_)) {
                    for (int i = 0; i < condition.length() + 6; ++i) {
                        this.read();
                    }
                    return true;
                }
                XMLStringBuffer buffer = new XMLStringBuffer();
                while ((ch = this.read()) != -1) {
                    buffer.append((char)ch);
                    if (!buffer.toString().endsWith("<![endif]>")) continue;
                    XMLStringBuffer trimmedBuffer = new XMLStringBuffer(buffer.ch, 0, buffer.length - 3);
                    this.fDocumentHandler.comment((XMLString)trimmedBuffer, this.locationAugs());
                    return true;
                }
            }
            catch (Exception e) {
                XMLStringBuffer buffer = new XMLStringBuffer("<!--");
                contentScanner.scanMarkupContent(buffer, '-');
                buffer.append("-->");
                this.fDocumentHandler.characters((XMLString)buffer, this.locationAugs());
                return true;
            }
        }
        return super.skipMarkup(balance);
    }

    class ContentScannerForIE
    extends HTMLScanner.ContentScanner {
        private final BrowserVersion browserVersion_;

        ContentScannerForIE(BrowserVersion browserVersion) {
            super((HTMLScanner)HTMLScannerForIE.this);
            this.browserVersion_ = browserVersion;
        }

        protected void scanComment() throws IOException {
            String s = this.nextContent(30);
            if (s.startsWith("[if ") && s.contains("]>")) {
                String commentTill = null;
                if (s.contains("]><!-->")) {
                    commentTill = "<![endif]-->";
                } else if (s.contains("]>-->")) {
                    commentTill = "<!--<![endif]-->";
                }
                String condition = StringUtils.substringBefore((String)s.substring(4), (String)"]>");
                try {
                    if (IEConditionalCommentExpressionEvaluator.evaluate(condition, this.browserVersion_)) {
                        for (int i = 0; i < condition.length() + 6; ++i) {
                            HTMLScannerForIE.this.read();
                        }
                        if (s.contains("]><!-->")) {
                            HTMLScannerForIE.this.skip("<!-->", false);
                        } else if (s.contains("]>-->")) {
                            HTMLScannerForIE.this.skip("-->", false);
                        }
                        return;
                    }
                    if (commentTill != null) {
                        int ch;
                        XMLStringBuffer buffer = new XMLStringBuffer();
                        while ((ch = HTMLScannerForIE.this.read()) != -1) {
                            buffer.append((char)ch);
                            if (!buffer.toString().endsWith(commentTill)) continue;
                            XMLStringBuffer trimmedBuffer = new XMLStringBuffer(buffer.ch, 0, buffer.length - 3);
                            HTMLScannerForIE.this.fDocumentHandler.comment((XMLString)trimmedBuffer, HTMLScannerForIE.this.locationAugs());
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    XMLStringBuffer buffer = new XMLStringBuffer("<!--");
                    this.scanMarkupContent(buffer, '-');
                    buffer.append("-->");
                    HTMLScannerForIE.this.fDocumentHandler.characters((XMLString)buffer, HTMLScannerForIE.this.locationAugs());
                    return;
                }
            }
            super.scanComment();
        }

        public String nextContent(int len) throws IOException {
            return super.nextContent(len);
        }

        public boolean scanMarkupContent(XMLStringBuffer buffer, char cend) throws IOException {
            return super.scanMarkupContent(buffer, cend);
        }
    }
}

