/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookiePathComparator;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BrowserCompatSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlUnitBrowserCompatCookieSpec
extends BrowserCompatSpec {
    private static final Comparator<Cookie> COOKIE_COMPARATOR = new CookiePathComparator();

    HtmlUnitBrowserCompatCookieSpec() {
        BasicPathHandler pathHandler = new BasicPathHandler(){

            public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
            }
        };
        this.registerAttribHandler("path", (CookieAttributeHandler)pathHandler);
    }

    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        List cookies = super.parse(header, origin);
        for (Cookie c : cookies) {
            if (!header.getValue().contains(c.getName() + "=\"" + c.getValue())) continue;
            ((BasicClientCookie)c).setValue('\"' + c.getValue() + '\"');
        }
        return cookies;
    }

    public List<Header> formatCookies(List<Cookie> cookies) {
        Collections.sort(cookies, COOKIE_COMPARATOR);
        return super.formatCookies(cookies);
    }
}

