/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRuleList;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import com.steadystate.css.dom.CSSImportRuleImpl;
import com.steadystate.css.dom.CSSMediaRuleImpl;
import com.steadystate.css.dom.CSSStyleRuleImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS21;
import com.steadystate.css.parser.SelectorListImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.ContentCondition;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSStyleSheet
extends SimpleScriptable {
    private static final Log LOG = LogFactory.getLog(CSSStyleSheet.class);
    private final org.w3c.dom.css.CSSStyleSheet wrapped_;
    private final HTMLElement ownerNode_;
    private CSSRuleList cssRules_;
    private Map<CSSImportRule, CSSStyleSheet> imports_ = new HashMap<CSSImportRule, CSSStyleSheet>();
    private String uri_;

    public CSSStyleSheet() {
        this.wrapped_ = new CSSStyleSheetImpl();
        this.ownerNode_ = null;
    }

    public CSSStyleSheet(HTMLElement element, InputSource source, String uri) {
        this.setParentScope(element.getWindow());
        this.setPrototype(this.getPrototype(CSSStyleSheet.class));
        this.wrapped_ = this.parseCSS(source);
        this.uri_ = uri;
        this.ownerNode_ = element;
    }

    public CSSStyleSheet(HTMLElement element, org.w3c.dom.css.CSSStyleSheet wrapped, String uri) {
        this.setParentScope(element.getWindow());
        this.setPrototype(this.getPrototype(CSSStyleSheet.class));
        this.wrapped_ = wrapped;
        this.uri_ = uri;
        this.ownerNode_ = element;
    }

    public org.w3c.dom.css.CSSStyleSheet getWrappedSheet() {
        return this.wrapped_;
    }

    public void modifyIfNecessary(ComputedCSSStyleDeclaration style, HTMLElement element) {
        org.w3c.dom.css.CSSRuleList rules = this.getWrappedSheet().getCssRules();
        this.modifyIfNecessary(style, element, rules, new HashSet<String>());
    }

    private void modifyIfNecessary(ComputedCSSStyleDeclaration style, HTMLElement element, org.w3c.dom.css.CSSRuleList rules, Set<String> alreadyProcessing) {
        if (rules == null) {
            return;
        }
        HtmlElement e = element.getDomNodeOrDie();
        for (int i = 0; i < rules.getLength(); ++i) {
            CSSMediaRuleImpl mediaRule;
            String media;
            CSSRule rule = rules.item(i);
            if (rule.getType() == 1) {
                CSSStyleRuleImpl styleRule = (CSSStyleRuleImpl)rule;
                SelectorList selectors = styleRule.getSelectors();
                for (int j = 0; j < selectors.getLength(); ++j) {
                    Selector selector = selectors.item(j);
                    boolean selected = this.selects(selector, e);
                    if (!selected) continue;
                    CSSStyleDeclaration dec = styleRule.getStyle();
                    style.applyStyleFromSelector(dec, selector);
                }
                continue;
            }
            if (rule.getType() == 3) {
                CSSImportRuleImpl importRule = (CSSImportRuleImpl)rule;
                CSSStyleSheet sheet = this.imports_.get(importRule);
                if (sheet == null) {
                    String uri = this.uri_ != null ? this.uri_ : e.getPage().getWebResponse().getWebRequest().getUrl().toExternalForm();
                    String href = importRule.getHref();
                    String url = UrlUtils.resolveUrl(uri, href);
                    sheet = CSSStyleSheet.loadStylesheet(this.getWindow(), this.ownerNode_, null, url);
                    this.imports_.put((CSSImportRule)importRule, sheet);
                }
                if (alreadyProcessing.contains(sheet.getUri())) continue;
                org.w3c.dom.css.CSSRuleList sheetRules = sheet.getWrappedSheet().getCssRules();
                alreadyProcessing.add(this.getUri());
                sheet.modifyIfNecessary(style, element, sheetRules, alreadyProcessing);
                continue;
            }
            if (rule.getType() != 4 || !CSSStyleSheet.isActive(media = (mediaRule = (CSSMediaRuleImpl)rule).getMedia().getMediaText())) continue;
            org.w3c.dom.css.CSSRuleList internalRules = mediaRule.getCssRules();
            this.modifyIfNecessary(style, element, internalRules, alreadyProcessing);
        }
    }

    public static CSSStyleSheet loadStylesheet(Window window, HTMLElement element, HtmlLink link, String url) {
        CSSStyleSheet sheet;
        HtmlPage page = (HtmlPage)element.getDomNodeOrDie().getPage();
        String uri = page.getWebResponse().getWebRequest().getUrl().toExternalForm();
        try {
            WebRequest request;
            WebClient client = page.getWebClient();
            if (link != null) {
                request = link.getWebRequest();
            } else {
                request = new WebRequest(new URL(url));
                String referer = page.getWebResponse().getWebRequest().getUrl().toExternalForm();
                request.setAdditionalHeader("Referer", referer);
            }
            uri = request.getUrl().toExternalForm();
            Cache cache = client.getCache();
            Object fromCache = cache.getCachedObject(request);
            if (fromCache != null && fromCache instanceof org.w3c.dom.css.CSSStyleSheet) {
                sheet = new CSSStyleSheet(element, (org.w3c.dom.css.CSSStyleSheet)fromCache, uri);
            } else {
                WebResponse response = client.loadWebResponse(request);
                uri = response.getWebRequest().getUrl().toExternalForm();
                client.printContentIfNecessary(response);
                client.throwFailingHttpStatusCodeExceptionIfNecessary(response);
                InputSource source = new InputSource();
                source.setByteStream(response.getContentAsStream());
                source.setEncoding(response.getContentCharset());
                sheet = new CSSStyleSheet(element, source, uri);
                cache.cacheIfPossible(request, response, sheet.getWrappedSheet());
            }
        }
        catch (FailingHttpStatusCodeException e) {
            LOG.error((Object)e.getMessage());
            InputSource source = new InputSource((Reader)new StringReader(""));
            sheet = new CSSStyleSheet(element, source, uri);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
            InputSource source = new InputSource((Reader)new StringReader(""));
            sheet = new CSSStyleSheet(element, source, uri);
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)("Exception: " + e));
        }
        return sheet;
    }

    boolean selects(Selector selector, HtmlElement element) {
        return CSSStyleSheet.selects(this.getBrowserVersion(), selector, element);
    }

    public static boolean selects(BrowserVersion browserVersion, Selector selector, HtmlElement element) {
        switch (selector.getSelectorType()) {
            case 1: {
                return true;
            }
            case 11: {
                if (element.getParentNode() == element.getPage()) {
                    return false;
                }
                DescendantSelector cs = (DescendantSelector)selector;
                if (!(element.getParentNode() instanceof HtmlElement)) {
                    return false;
                }
                HtmlElement parent = (HtmlElement)element.getParentNode();
                return CSSStyleSheet.selects(browserVersion, (Selector)cs.getSimpleSelector(), element) && parent != null && CSSStyleSheet.selects(browserVersion, cs.getAncestorSelector(), parent);
            }
            case 10: {
                DescendantSelector ds = (DescendantSelector)selector;
                if (CSSStyleSheet.selects(browserVersion, (Selector)ds.getSimpleSelector(), element)) {
                    DomNode ancestor = element.getParentNode();
                    while (ancestor instanceof HtmlElement) {
                        if (CSSStyleSheet.selects(browserVersion, ds.getAncestorSelector(), (HtmlElement)ancestor)) {
                            return true;
                        }
                        ancestor = ancestor.getParentNode();
                    }
                }
                return false;
            }
            case 0: {
                ConditionalSelector conditional = (ConditionalSelector)selector;
                Condition condition = conditional.getCondition();
                return CSSStyleSheet.selects(browserVersion, (Selector)conditional.getSimpleSelector(), element) && CSSStyleSheet.selects(browserVersion, condition, element);
            }
            case 4: {
                ElementSelector es = (ElementSelector)selector;
                String name = es.getLocalName();
                return name == null || name.equalsIgnoreCase(element.getTagName());
            }
            case 2: {
                return "html".equalsIgnoreCase(element.getTagName());
            }
            case 12: {
                SiblingSelector ss = (SiblingSelector)selector;
                DomNode prev = element.getPreviousSibling();
                return prev instanceof HtmlElement && CSSStyleSheet.selects(browserVersion, ss.getSelector(), (HtmlElement)prev) && CSSStyleSheet.selects(browserVersion, (Selector)ss.getSiblingSelector(), element);
            }
            case 3: {
                NegativeSelector ns = (NegativeSelector)selector;
                return !CSSStyleSheet.selects(browserVersion, (Selector)ns.getSimpleSelector(), element);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        LOG.error((Object)("Unknown CSS selector type '" + selector.getSelectorType() + "'."));
        return false;
    }

    static boolean selects(BrowserVersion browserVersion, Condition condition, HtmlElement element) {
        switch (condition.getConditionType()) {
            case 5: {
                AttributeCondition ac4 = (AttributeCondition)condition;
                return ac4.getValue().equals(element.getId());
            }
            case 9: {
                AttributeCondition ac3 = (AttributeCondition)condition;
                String v3 = ac3.getValue();
                String a3 = element.getAttribute("class");
                return a3.equals(v3) || a3.startsWith(v3 + " ") || a3.endsWith(" " + v3) || a3.contains(" " + v3 + " ");
            }
            case 0: {
                CombinatorCondition cc1 = (CombinatorCondition)condition;
                return CSSStyleSheet.selects(browserVersion, cc1.getFirstCondition(), element) && CSSStyleSheet.selects(browserVersion, cc1.getSecondCondition(), element);
            }
            case 4: {
                AttributeCondition ac1 = (AttributeCondition)condition;
                if (ac1.getSpecified()) {
                    return element.getAttribute(ac1.getLocalName()).equals(ac1.getValue());
                }
                return element.hasAttribute(ac1.getLocalName());
            }
            case 8: {
                AttributeCondition ac2 = (AttributeCondition)condition;
                String v = ac2.getValue();
                String a = element.getAttribute(ac2.getLocalName());
                return a.equals(v) || a.startsWith(v + "-") || a.endsWith("-" + v) || a.contains("-" + v + "-");
            }
            case 7: {
                AttributeCondition ac5 = (AttributeCondition)condition;
                String v2 = ac5.getValue();
                String a2 = element.getAttribute(ac5.getLocalName());
                return a2.equals(v2) || a2.startsWith(v2 + " ") || a2.endsWith(" " + v2) || a2.contains(" " + v2 + " ");
            }
            case 1: {
                CombinatorCondition cc2 = (CombinatorCondition)condition;
                return CSSStyleSheet.selects(browserVersion, cc2.getFirstCondition(), element) || CSSStyleSheet.selects(browserVersion, cc2.getSecondCondition(), element);
            }
            case 2: {
                NegativeCondition nc = (NegativeCondition)condition;
                return !CSSStyleSheet.selects(browserVersion, nc.getCondition(), element);
            }
            case 11: {
                return element.getParentNode().getChildNodes().getLength() == 1;
            }
            case 13: {
                ContentCondition cc = (ContentCondition)condition;
                return element.asText().contains(cc.getData());
            }
            case 6: {
                if (!browserVersion.hasFeature(BrowserVersionFeatures.CSS_SELECTOR_LANG)) {
                    return false;
                }
                String lcLang = ((LangCondition)condition).getLang();
                DomNode node = element;
                while (node instanceof HtmlElement) {
                    String nodeLang = node.getAttribute("lang");
                    if (nodeLang.startsWith(lcLang) && (nodeLang.length() == lcLang.length() || '-' == nodeLang.charAt(lcLang.length()))) {
                        return true;
                    }
                    node = node.getParentNode();
                }
                return false;
            }
            case 12: {
                String tagName = element.getTagName();
                return ((HtmlPage)element.getPage()).getElementsByTagName(tagName).getLength() == 1;
            }
            case 10: {
                return CSSStyleSheet.selectsPseudoClass(browserVersion, (AttributeCondition)condition, element);
            }
            case 3: {
                return false;
            }
        }
        LOG.error((Object)("Unknown CSS condition type '" + condition.getConditionType() + "'."));
        return false;
    }

    private static boolean selectsPseudoClass(BrowserVersion browserVersion, AttributeCondition condition, HtmlElement element) {
        if (!browserVersion.hasFeature(BrowserVersionFeatures.CSS_SPECIAL_PSEUDO_CLASSES)) {
            return false;
        }
        String value = condition.getValue();
        if ("root".equals(value)) {
            return element == element.getPage().getDocumentElement();
        }
        if ("enabled".equals(value)) {
            return element instanceof HtmlInput && !((HtmlInput)element).isDisabled() || element instanceof HtmlSelect && !((HtmlSelect)element).isDisabled();
        }
        if ("disabled".equals(value)) {
            return element instanceof HtmlInput && ((HtmlInput)element).isDisabled() || element instanceof HtmlSelect && ((HtmlSelect)element).isDisabled();
        }
        if ("checked".equals(value)) {
            return element instanceof HtmlCheckBoxInput && ((HtmlCheckBoxInput)element).isChecked() || element instanceof HtmlRadioButtonInput && ((HtmlRadioButtonInput)element).isChecked();
        }
        return false;
    }

    private org.w3c.dom.css.CSSStyleSheet parseCSS(InputSource source) {
        org.w3c.dom.css.CSSStyleSheet ss;
        try {
            ErrorHandler errorHandler = this.getWindow().getWebWindow().getWebClient().getCssErrorHandler();
            CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS21());
            parser.setErrorHandler(errorHandler);
            ss = parser.parseStyleSheet(source, null, null);
        }
        catch (Exception e) {
            LOG.error((Object)("Error parsing CSS from '" + CSSStyleSheet.toString(source) + "': " + e.getMessage()), (Throwable)e);
            ss = new CSSStyleSheetImpl();
        }
        catch (Error e) {
            LOG.error((Object)("Error parsing CSS from '" + CSSStyleSheet.toString(source) + "': " + e.getMessage()), (Throwable)e);
            ss = new CSSStyleSheetImpl();
        }
        return ss;
    }

    public SelectorList parseSelectors(InputSource source) {
        SelectorList selectors;
        try {
            ErrorHandler errorHandler = this.getWindow().getWebWindow().getWebClient().getCssErrorHandler();
            CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS21());
            parser.setErrorHandler(errorHandler);
            selectors = parser.parseSelectors(source);
            if (null == selectors) {
                selectors = new SelectorListImpl();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error parsing CSS selectors from '" + CSSStyleSheet.toString(source) + "': " + e.getMessage()), (Throwable)e);
            selectors = new SelectorListImpl();
        }
        catch (Error e) {
            LOG.error((Object)("Error parsing CSS selectors from '" + CSSStyleSheet.toString(source) + "': " + e.getMessage()), (Throwable)e);
            selectors = new SelectorListImpl();
        }
        return selectors;
    }

    private static String toString(InputSource source) {
        try {
            Reader reader = source.getCharacterStream();
            if (null != reader) {
                if (reader instanceof StringReader) {
                    StringReader sr = (StringReader)reader;
                    sr.reset();
                }
                return IOUtils.toString((Reader)reader);
            }
            InputStream is = source.getByteStream();
            if (null != is) {
                if (is instanceof ByteArrayInputStream) {
                    ByteArrayInputStream bis = (ByteArrayInputStream)is;
                    bis.reset();
                }
                return IOUtils.toString((InputStream)is);
            }
            return "";
        }
        catch (IOException e) {
            return "";
        }
    }

    public HTMLElement jsxGet_ownerNode() {
        return this.ownerNode_;
    }

    public HTMLElement jsxGet_owningElement() {
        return this.ownerNode_;
    }

    public CSSRuleList jsxGet_rules() {
        return this.jsxGet_cssRules();
    }

    public CSSRuleList jsxGet_cssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleList(this);
        }
        return this.cssRules_;
    }

    public String jsxGet_href() {
        HtmlElement node;
        BrowserVersion version = this.getBrowserVersion();
        if (this.ownerNode_ != null && (node = this.ownerNode_.getDomNodeOrDie()) instanceof HtmlLink) {
            HtmlLink link = (HtmlLink)node;
            HtmlPage page = (HtmlPage)link.getPage();
            String href = link.getHrefAttribute();
            if (!version.hasFeature(BrowserVersionFeatures.STYLESHEET_HREF_EXPANDURL)) {
                return href;
            }
            try {
                URL url = page.getFullyQualifiedUrl(href);
                return url.toExternalForm();
            }
            catch (MalformedURLException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (version.hasFeature(BrowserVersionFeatures.STYLESHEET_HREF_STYLE_EMPTY)) {
            return "";
        }
        if (version.hasFeature(BrowserVersionFeatures.STYLESHEET_HREF_STYLE_NULL)) {
            return null;
        }
        node = this.ownerNode_.getDomNodeOrDie();
        HtmlPage page = (HtmlPage)node.getPage();
        URL url = page.getWebResponse().getWebRequest().getUrl();
        return url.toExternalForm();
    }

    public int jsxFunction_insertRule(String rule, int position) {
        return this.wrapped_.insertRule(rule.trim(), position);
    }

    public void jsxFunction_deleteRule(int position) {
        this.wrapped_.deleteRule(position);
    }

    public int jsxFunction_addRule(String selector, String rule) {
        String completeRule = selector.trim() + " {" + rule + "}";
        this.wrapped_.insertRule(completeRule, this.wrapped_.getCssRules().getLength());
        return -1;
    }

    public void jsxFunction_removeRule(int position) {
        this.wrapped_.deleteRule(position);
    }

    public String getUri() {
        return this.uri_;
    }

    public boolean isActive() {
        String media;
        HtmlElement e = this.ownerNode_.getDomNodeOrNull();
        if (e instanceof HtmlStyle) {
            HtmlStyle style = (HtmlStyle)e;
            media = style.getMediaAttribute();
        } else if (e instanceof HtmlLink) {
            HtmlLink link = (HtmlLink)e;
            media = link.getMediaAttribute();
        } else {
            media = "";
        }
        return CSSStyleSheet.isActive(media);
    }

    private static boolean isActive(String media) {
        if (StringUtils.isBlank((String)media)) {
            return true;
        }
        for (String s : StringUtils.split((String)media, (char)',')) {
            String mediaType = s.trim();
            if (!"screen".equals(mediaType) && !"all".equals(mediaType)) continue;
            return true;
        }
        return false;
    }
}

