/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebResponseImpl
implements WebResponse,
Serializable {
    private static final long serialVersionUID = 2842434739251092348L;
    private static final Pattern patternEncoding_ = Pattern.compile("[a-zA-Z0-9][\\w:\\.-]*");
    private final transient Log log_ = LogFactory.getLog(WebResponseImpl.class);
    private long loadTime_;
    private WebResponseData responseData_;
    private String charset_;
    private WebRequestSettings requestSettings_;

    public WebResponseImpl(WebResponseData responseData, URL url, HttpMethod requestMethod, long loadTime) {
        this(responseData, "ISO-8859-1", new WebRequestSettings(url, requestMethod), loadTime);
    }

    public WebResponseImpl(WebResponseData responseData, String charset, WebRequestSettings requestSettings, long loadTime) {
        this.responseData_ = responseData;
        this.charset_ = charset;
        this.requestSettings_ = requestSettings;
        this.loadTime_ = loadTime;
    }

    @Override
    public WebRequestSettings getRequestSettings() {
        return this.requestSettings_;
    }

    @Override
    public HttpMethod getRequestMethod() {
        return this.getRequestSettings().getHttpMethod();
    }

    @Override
    public URL getRequestUrl() {
        return this.getRequestSettings().getUrl();
    }

    @Override
    public List<NameValuePair> getResponseHeaders() {
        return this.responseData_.getResponseHeaders();
    }

    @Override
    public String getResponseHeaderValue(String headerName) {
        for (NameValuePair pair : this.responseData_.getResponseHeaders()) {
            if (!pair.getName().equalsIgnoreCase(headerName)) continue;
            return pair.getValue();
        }
        return null;
    }

    @Override
    public int getStatusCode() {
        return this.responseData_.getStatusCode();
    }

    @Override
    public String getStatusMessage() {
        return this.responseData_.getStatusMessage();
    }

    @Override
    public String getContentType() {
        String contentTypeHeader = this.getResponseHeaderValue("content-type");
        if (contentTypeHeader == null) {
            return "";
        }
        int index = contentTypeHeader.indexOf(59);
        if (index == -1) {
            return contentTypeHeader;
        }
        return contentTypeHeader.substring(0, index);
    }

    @Override
    public String getContentCharSet() {
        String contentTypeHeader = this.getResponseHeaderValue("content-type");
        String charset = StringUtils.substringAfter((String)contentTypeHeader, (String)"charset=");
        if (StringUtils.isEmpty((String)charset)) {
            this.log_.debug((Object)"No charset specified in header, trying to guess it from content");
            byte[] body = this.responseData_.getBody();
            byte[] markerUTF8 = new byte[]{-17, -69, -65};
            byte[] markerUTF16BE = new byte[]{-2, -1};
            byte[] markerUTF16LE = new byte[]{-1, -2};
            if (body != null && ArrayUtils.isEquals((Object)markerUTF8, (Object)ArrayUtils.subarray((byte[])body, (int)0, (int)3))) {
                this.log_.debug((Object)"UTF-8 marker found");
                charset = "UTF-8";
            } else if (body != null && ArrayUtils.isEquals((Object)markerUTF16BE, (Object)ArrayUtils.subarray((byte[])body, (int)0, (int)2))) {
                this.log_.debug((Object)"UTF-16BE marker found");
                charset = "UTF-16BE";
            } else if (body != null && ArrayUtils.isEquals((Object)markerUTF16LE, (Object)ArrayUtils.subarray((byte[])body, (int)0, (int)2))) {
                this.log_.debug((Object)"UTF-16LE marker found");
                charset = "UTF-16LE";
            } else {
                String xmlEncoding = this.getXMLEncoding(body);
                if (xmlEncoding != null) {
                    this.log_.debug((Object)("XML encoding found: " + xmlEncoding));
                    charset = xmlEncoding;
                } else {
                    this.log_.debug((Object)("No charset guessed, using " + this.charset_));
                    charset = this.charset_;
                }
            }
        } else {
            Matcher matcher = patternEncoding_.matcher(charset);
            if (!matcher.find()) {
                charset = "ISO-8859-1";
            } else {
                charset = matcher.group();
                try {
                    if (!Charset.isSupported(charset)) {
                        this.log_.info((Object)("Unsupported charset: " + charset + ". Using default one: " + "ISO-8859-1"));
                        charset = "ISO-8859-1";
                    }
                }
                catch (IllegalCharsetNameException e) {
                    this.log_.info((Object)("Illegal charset: " + charset + ". Using default one: " + "ISO-8859-1"));
                    charset = "ISO-8859-1";
                }
            }
        }
        return charset;
    }

    @Override
    public String getContentAsString() {
        return this.getContentAsString(this.getContentCharSet());
    }

    @Override
    public String getContentAsString(String encoding) {
        byte[] body = this.responseData_.getBody();
        if (body != null) {
            try {
                return new String(body, encoding);
            }
            catch (UnsupportedEncodingException e) {
                this.log_.warn((Object)("Attempted to use unsupported encoding '" + encoding + "'; using default system encoding."));
                return new String(body);
            }
        }
        return null;
    }

    @Override
    public InputStream getContentAsStream() throws IOException {
        byte[] body = this.responseData_.getBody();
        if (body != null) {
            return new ByteArrayInputStream(body);
        }
        return null;
    }

    @Override
    public byte[] getContentAsBytes() {
        return this.responseData_.getBody();
    }

    @Override
    public long getLoadTime() {
        return this.loadTime_;
    }

    @Override
    @Deprecated
    public URL getUrl() {
        return this.getRequestSettings().getUrl();
    }

    @Override
    @Deprecated
    public long getLoadTimeInMilliSeconds() {
        return this.loadTime_;
    }

    @Override
    @Deprecated
    public byte[] getResponseBody() {
        return this.responseData_.getBody();
    }

    private String getXMLEncoding(byte[] body) {
        String declaration;
        int start;
        int index;
        String encoding = null;
        byte[] declarationPrefix = "<?xml ".getBytes();
        if (ArrayUtils.isEquals((Object)declarationPrefix, (Object)ArrayUtils.subarray((byte[])body, (int)0, (int)declarationPrefix.length)) && (index = ArrayUtils.indexOf((byte[])body, (byte)63, (int)2)) + 1 < body.length && body[index + 1] == 62 && (start = (declaration = new String(body, 0, index + 2)).indexOf("encoding")) != -1) {
            char delimiter;
            start += 8;
            block3: while (true) {
                switch (declaration.charAt(start)) {
                    case '\"': 
                    case '\'': {
                        delimiter = declaration.charAt(start);
                        break block3;
                    }
                    default: {
                        ++start;
                        continue block3;
                    }
                }
                break;
            }
            int end = declaration.indexOf(delimiter, ++start);
            encoding = declaration.substring(start, end);
        }
        return encoding;
    }
}

