# This file was automatically generated by Dist::Zilla::Plugin::MakeMaker v6.017.
use strict;
use warnings;

use 5.030000;

use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT" => "Direct access to the WebGPU native APIs.",
  "AUTHOR" => "Jon Gentle <cpan\@atrodo.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "WebGPU-Direct",
  "LICENSE" => "artistic_2",
  "MIN_PERL_VERSION" => "5.030000",
  "NAME" => "WebGPU::Direct",
  "PREREQ_PM" => {},
  "TEST_REQUIRES" => {
    "Test::More" => "0.96"
  },
  "VERSION" => "0.14",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Test::More" => "0.96"
);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.040
%WriteMakefileArgs = (
  %WriteMakefileArgs,

  OBJECT => ['$(BASEEXT)$(OBJ_EXT)'],
  "test" => { "TESTS" => "t/*.t" },
  depend => {
    'Direct.c' => 'Direct.xs xs/*.xs xs/*.c',
  },
);

my $addl_search = $ENV{ADDL_SEARCH} // '';
my $addl_L      = '';

if ( !$addl_search && -e 'webgpu/webgpu.h' )
{
  $addl_search = 'webgpu';
}

if ( $addl_search && -e "$addl_search/webgpu/webgpu.h" )
{
  $addl_search = "$addl_search/webgpu/";
}

if ($addl_search)
{
  $addl_L = "-L$addl_search";
}

my ($EXTRALIBS) = do
{
  local $SIG{__WARN__} = sub { };
  ExtUtils::Liblist->ext("-l_lib_test_$$");
};

sub is_lib
{
  my $lib = shift;

  my ($extra) = ExtUtils::Liblist->ext("$addl_L -l$lib");
  $extra =~ s/\Q$EXTRALIBS//;

  return !!$extra;
}

my $wgpu;
my @tests = qw/wgpu_native dawn_native/;
for my $wgpu_test (@tests)
{
  if ( is_lib($wgpu_test) )
  {
    $wgpu = $wgpu_test;
    last;
  }
}

if ( !$wgpu )
{
  die "Unable to locate WebGPU library (tried @tests)\n";
}

my @libs;
my @defines;

if ( is_lib('X11') )
{
  push @libs,    '-lX11';
  push @defines, '-DHAS_X11';
}

if ( is_lib('wayland-client') && qx/pkg-config --version 2>&1/ )
{
  my $scanner   = qx/pkg-config --variable=wayland_scanner wayland-scanner/;
  my $proto_dir = qx/pkg-config wayland-protocols --variable=pkgdatadir/;
  chomp $proto_dir;
  my $xml = "$proto_dir/stable/xdg-shell/xdg-shell.xml";

  if ( $scanner && -e $xml )
  {
    qx{wayland-scanner client-header $xml xdg-shell.h};
    qx{wayland-scanner private-code $xml xdg-shell.c};
    push @libs,    '-lwayland-client';
    push @defines, '-DHAS_WAYLAND';
    push $WriteMakefileArgs{OBJECT}->@*, 'xdg-shell.o';
  }
}

$WriteMakefileArgs{LIBS}   = "$addl_L -l$wgpu @libs";
$WriteMakefileArgs{DEFINE} = "@defines";
$WriteMakefileArgs{INC}    = "-I$addl_search/.."
    if $addl_search;


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
