use strict;
use Test::More;
use Tk;
##
## Almost all widget classes:  load module, create, pack, and
## destory an instance.
##
## Menu stuff not tested up to now
##

use vars '@class';

@class = qw(
Tk::FcyEntry	Entry
Tk::FileEntry	FileEntry
);

my $mw = Tk::MainWindow->new();
if (! $mw) {
  # there seems to be no x-server available or something else went wrong
  # .. skip all tests
  exit 0;
}

my $w;
my $module;
my $class;
while (@class)
{
    $module = shift @class;
    $class  = shift @class;
    print "Testing $class ($module)\n";
    undef($w);

    eval "require $module;";
    ok($@ eq "", "Error loading $module");

    eval { $w = $mw->$class(); };
    ok($@ eq "", "can't create $class widget");

    if (Tk::Exists($w))
    {
        if ($w->isa('Tk::Wm'))
        {
            # KDE-beta4 wm with policies:
            #     'interactive placement'
            #        okay with geometry and positionfrom
            #     'manual placement'
            #       geometry and positionfrom do not help
            eval { $w->positionfrom('user'); };
                #eval { $w->geometry('+10+10'); };
            ok ($@ eq "", 'Problem set postitionform to user');
    
                eval { $w->Popup; };
            ok ($@ eq "", "Can't Popup a $class widget")
        }
        else
          {
        ok(1); # dummy for above positionfrom test
            eval { $w->pack; };
        ok ($@ eq "", "Can't pack a $class widget")
          }
        eval { $mw->update; };
        ok ($@ eq "", "Error during 'update' for $class widget");

        eval { my @dummy = $w->configure; };
        ok ($@ eq "", "Error: configure list for $class");
        eval { $mw->update; };
        ok ($@ eq "", "Error: 'update' after configure for $class widget");

        eval { $w->destroy; };
        ok($@ eq "", "can't destroy $class widget");
        ok(!Tk::Exists($w) eq 1, "$class: widget not really destroyed");

        # XXX: destroy-destroy test disabled because nobody vote for this feature
    # Nick Ing-Simmmons wrote:
    # The only way to make test pass, is when Tk800 would fail, to specifcally look 
    # and see if method is 'destroy', and ignore it. Can be done but is it worth it?
    # Note I cannot call tk's internal destroy as I have no way of relating 
    # (now destroy has happened) the object back to interp/MainWindow that it used
    # to be associated with, and hence cannot create the args I need to pass
    # to the core.
        
        # since Tk8.0 a destroy on an already destroyed widget should
        # not complain
        #eval { $w->destroy; };
        #ok($@, "", "Ooops, destroying a destroyed widget should not complain");

    }
    else
    { 
        # Widget $class couldn't be created:
        # Popup/pack, update, destroy skipped
        diag("skipped Popup/pack, update, destroy skipped tests because widget $class could not be created");
    }
}

done_testing();
