#=======================================================================
#    ____  ____  _____              _    ____ ___   ____
#   |  _ \|  _ \|  ___|  _   _     / \  |  _ \_ _| |___ \
#   | |_) | | | | |_    (_) (_)   / _ \ | |_) | |    __) |
#   |  __/| |_| |  _|    _   _   / ___ \|  __/| |   / __/
#   |_|   |____/|_|     (_) (_) /_/   \_\_|  |___| |_____|
#
#   A Perl Module Chain to faciliate the Creation and Modification
#   of High-Quality "Portable Document Format (PDF)" Files.
#
#   Copyright 1999-2004 Alfred Reibenschuh <areibens@cpan.org>.
#
#=======================================================================
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the
#   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#   Boston, MA 02111-1307, USA.
#
#   $Id: traditional.pm,v 1.5 2004/06/07 19:44:42 fredo Exp $
#
#=======================================================================

$cmap->{traditional}={
    'g2u' => [
        0x0000, # G+0  U+0000  .notdef,  UNDEFINED
        0x0020, # G+1  U+0020  space,  SPACE
        0x0021, # G+2  U+0021  exclam,  EXCLAMATION MARK
        0x0022, # G+3  U+0022  quotedbl,  QUOTATION MARK
        0x0023, # G+4  U+0023  numbersign,  NUMBER SIGN
        0x0024, # G+5  U+0024  dollar,  DOLLAR SIGN
        0x0025, # G+6  U+0025  percent,  PERCENT SIGN
        0x0026, # G+7  U+0026  ampersand,  AMPERSAND
        0x0027, # G+8  U+0027  quotesingle,  APOSTROPHE
        0x0028, # G+9  U+0028  parenleft,  LEFT PARENTHESIS
        0x0029, # G+10  U+0029  parenright,  RIGHT PARENTHESIS
        0x002A, # G+11  U+002A  asterisk,  ASTERISK
        0x002B, # G+12  U+002B  plus,  PLUS SIGN
        0x002C, # G+13  U+002C  comma,  COMMA
        0x002D, # G+14  U+002D  hyphen,  HYPHEN-MINUS
        0x002E, # G+15  U+002E  period,  FULL STOP
        0x002F, # G+16  U+002F  slash,  SOLIDUS
        0x0030, # G+17  U+0030  zero,  DIGIT ZERO
        0x0031, # G+18  U+0031  one,  DIGIT ONE
        0x0032, # G+19  U+0032  two,  DIGIT TWO
        0x0033, # G+20  U+0033  three,  DIGIT THREE
        0x0034, # G+21  U+0034  four,  DIGIT FOUR
        0x0035, # G+22  U+0035  five,  DIGIT FIVE
        0x0036, # G+23  U+0036  six,  DIGIT SIX
        0x0037, # G+24  U+0037  seven,  DIGIT SEVEN
        0x0038, # G+25  U+0038  eight,  DIGIT EIGHT
        0x0039, # G+26  U+0039  nine,  DIGIT NINE
        0x003A, # G+27  U+003A  colon,  COLON
        0x003B, # G+28  U+003B  semicolon,  SEMICOLON
        0x003C, # G+29  U+003C  less,  LESS-THAN SIGN
        0x003D, # G+30  U+003D  equal,  EQUALS SIGN
        0x003E, # G+31  U+003E  greater,  GREATER-THAN SIGN
        0x003F, # G+32  U+003F  question,  QUESTION MARK
        0x0040, # G+33  U+0040  at,  COMMERCIAL AT
        0x0041, # G+34  U+0041  A,  LATIN CAPITAL LETTER A
        0x0042, # G+35  U+0042  B,  LATIN CAPITAL LETTER B
        0x0043, # G+36  U+0043  C,  LATIN CAPITAL LETTER C
        0x0044, # G+37  U+0044  D,  LATIN CAPITAL LETTER D
        0x0045, # G+38  U+0045  E,  LATIN CAPITAL LETTER E
        0x0046, # G+39  U+0046  F,  LATIN CAPITAL LETTER F
        0x0047, # G+40  U+0047  G,  LATIN CAPITAL LETTER G
        0x0048, # G+41  U+0048  H,  LATIN CAPITAL LETTER H
        0x0049, # G+42  U+0049  I,  LATIN CAPITAL LETTER I
        0x004A, # G+43  U+004A  J,  LATIN CAPITAL LETTER J
        0x004B, # G+44  U+004B  K,  LATIN CAPITAL LETTER K
        0x004C, # G+45  U+004C  L,  LATIN CAPITAL LETTER L
        0x004D, # G+46  U+004D  M,  LATIN CAPITAL LETTER M
        0x004E, # G+47  U+004E  N,  LATIN CAPITAL LETTER N
        0x004F, # G+48  U+004F  O,  LATIN CAPITAL LETTER O
        0x0050, # G+49  U+0050  P,  LATIN CAPITAL LETTER P
        0x0051, # G+50  U+0051  Q,  LATIN CAPITAL LETTER Q
        0x0052, # G+51  U+0052  R,  LATIN CAPITAL LETTER R
        0x0053, # G+52  U+0053  S,  LATIN CAPITAL LETTER S
        0x0054, # G+53  U+0054  T,  LATIN CAPITAL LETTER T
        0x0055, # G+54  U+0055  U,  LATIN CAPITAL LETTER U
        0x0056, # G+55  U+0056  V,  LATIN CAPITAL LETTER V
        0x0057, # G+56  U+0057  W,  LATIN CAPITAL LETTER W
        0x0058, # G+57  U+0058  X,  LATIN CAPITAL LETTER X
        0x0059, # G+58  U+0059  Y,  LATIN CAPITAL LETTER Y
        0x005A, # G+59  U+005A  Z,  LATIN CAPITAL LETTER Z
        0x005B, # G+60  U+005B  bracketleft,  LEFT SQUARE BRACKET
        0x005C, # G+61  U+005C  backslash,  REVERSE SOLIDUS
        0x005D, # G+62  U+005D  bracketright,  RIGHT SQUARE BRACKET
        0x005E, # G+63  U+005E  asciicircum,  CIRCUMFLEX ACCENT
        0x005F, # G+64  U+005F  underscore,  LOW LINE
        0x0060, # G+65  U+0060  grave,  GRAVE ACCENT
        0x0061, # G+66  U+0061  a,  LATIN SMALL LETTER A
        0x0062, # G+67  U+0062  b,  LATIN SMALL LETTER B
        0x0063, # G+68  U+0063  c,  LATIN SMALL LETTER C
        0x0064, # G+69  U+0064  d,  LATIN SMALL LETTER D
        0x0065, # G+70  U+0065  e,  LATIN SMALL LETTER E
        0x0066, # G+71  U+0066  f,  LATIN SMALL LETTER F
        0x0067, # G+72  U+0067  g,  LATIN SMALL LETTER G
        0x0068, # G+73  U+0068  h,  LATIN SMALL LETTER H
        0x0069, # G+74  U+0069  i,  LATIN SMALL LETTER I
        0x006A, # G+75  U+006A  j,  LATIN SMALL LETTER J
        0x006B, # G+76  U+006B  k,  LATIN SMALL LETTER K
        0x006C, # G+77  U+006C  l,  LATIN SMALL LETTER L
        0x006D, # G+78  U+006D  m,  LATIN SMALL LETTER M
        0x006E, # G+79  U+006E  n,  LATIN SMALL LETTER N
        0x006F, # G+80  U+006F  o,  LATIN SMALL LETTER O
        0x0070, # G+81  U+0070  p,  LATIN SMALL LETTER P
        0x0071, # G+82  U+0071  q,  LATIN SMALL LETTER Q
        0x0072, # G+83  U+0072  r,  LATIN SMALL LETTER R
        0x0073, # G+84  U+0073  s,  LATIN SMALL LETTER S
        0x0074, # G+85  U+0074  t,  LATIN SMALL LETTER T
        0x0075, # G+86  U+0075  u,  LATIN SMALL LETTER U
        0x0076, # G+87  U+0076  v,  LATIN SMALL LETTER V
        0x0077, # G+88  U+0077  w,  LATIN SMALL LETTER W
        0x0078, # G+89  U+0078  x,  LATIN SMALL LETTER X
        0x0079, # G+90  U+0079  y,  LATIN SMALL LETTER Y
        0x007A, # G+91  U+007A  z,  LATIN SMALL LETTER Z
        0x007B, # G+92  U+007B  braceleft,  LEFT CURLY BRACKET
        0x007C, # G+93  U+007C  bar,  VERTICAL LINE
        0x007D, # G+94  U+007D  braceright,  RIGHT CURLY BRACKET
        0x007E, # G+95  U+007E  asciitilde,  TILDE
        0x0000, # G+96  U+0000  .notdef,  UNDEFINED
        0x0000, # G+97  U+0000  .notdef,  UNDEFINED
        0x0000, # G+98  U+0000  .notdef,  UNDEFINED
        0x3000, # G+99  U+3000  uni3000,  IDEOGRAPHIC SPACE
        0xFF0C, # G+100  U+FF0C  uniFF0C,  FULLWIDTH COMMA
        0x3001, # G+101  U+3001  uni3001,  IDEOGRAPHIC COMMA
        0x3002, # G+102  U+3002  uni3002,  IDEOGRAPHIC FULL STOP
        0xFF0E, # G+103  U+FF0E  uniFF0E,  FULLWIDTH FULL STOP
        0x2022, # G+104  U+2022  bullet,  BULLET
        0xFF1B, # G+105  U+FF1B  uniFF1B,  FULLWIDTH SEMICOLON
        0xFF1A, # G+106  U+FF1A  uniFF1A,  FULLWIDTH COLON
        0xFF1F, # G+107  U+FF1F  uniFF1F,  FULLWIDTH QUESTION MARK
        0xFF01, # G+108  U+FF01  uniFF01,  FULLWIDTH EXCLAMATION MARK
        0xFE30, # G+109  U+FE30  uniFE30,  PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
        0x2026, # G+110  U+2026  ellipsis,  HORIZONTAL ELLIPSIS
        0x2025, # G+111  U+2025  twodotenleader,  TWO DOT LEADER
        0xFE50, # G+112  U+FE50  uniFE50,  SMALL COMMA
        0xFF64, # G+113  U+FF64  uniFF64,  HALFWIDTH IDEOGRAPHIC COMMA
        0xFE52, # G+114  U+FE52  uniFE52,  SMALL FULL STOP
        0x00B7, # G+115  U+00B7  periodcentered,  MIDDLE DOT
        0xFE54, # G+116  U+FE54  uniFE54,  SMALL SEMICOLON
        0xFE55, # G+117  U+FE55  uniFE55,  SMALL COLON
        0xFE56, # G+118  U+FE56  uniFE56,  SMALL QUESTION MARK
        0xFE57, # G+119  U+FE57  uniFE57,  SMALL EXCLAMATION MARK
        0xFF5C, # G+120  U+FF5C  uniFF5C,  FULLWIDTH VERTICAL LINE
        0x2013, # G+121  U+2013  endash,  EN DASH
        0xFE31, # G+122  U+FE31  uniFE31,  PRESENTATION FORM FOR VERTICAL EM DASH
        0x2014, # G+123  U+2014  emdash,  EM DASH
        0x0000, # G+124  U+0000  .notdef,  UNDEFINED
        0x0000, # G+125  U+0000  .notdef,  UNDEFINED
        0x0000, # G+126  U+0000  .notdef,  UNDEFINED
        0x0000, # G+127  U+0000  .notdef,  UNDEFINED
        0xFF08, # G+128  U+FF08  uniFF08,  FULLWIDTH LEFT PARENTHESIS
        0xFF09, # G+129  U+FF09  uniFF09,  FULLWIDTH RIGHT PARENTHESIS
        0xFE35, # G+130  U+FE35  uniFE35,  PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
        0xFE36, # G+131  U+FE36  uniFE36,  PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
        0xFF5B, # G+132  U+FF5B  uniFF5B,  FULLWIDTH LEFT CURLY BRACKET
        0xFF5D, # G+133  U+FF5D  uniFF5D,  FULLWIDTH RIGHT CURLY BRACKET
        0xFE37, # G+134  U+FE37  uniFE37,  PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
        0xFE38, # G+135  U+FE38  uniFE38,  PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
        0x3014, # G+136  U+3014  uni3014,  LEFT TORTOISE SHELL BRACKET
        0x3015, # G+137  U+3015  uni3015,  RIGHT TORTOISE SHELL BRACKET
        0xFE39, # G+138  U+FE39  uniFE39,  PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
        0xFE3A, # G+139  U+FE3A  uniFE3A,  PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
        0x3010, # G+140  U+3010  uni3010,  LEFT BLACK LENTICULAR BRACKET
        0x3011, # G+141  U+3011  uni3011,  RIGHT BLACK LENTICULAR BRACKET
        0xFE3B, # G+142  U+FE3B  uniFE3B,  PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
        0xFE3C, # G+143  U+FE3C  uniFE3C,  PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
        0x300A, # G+144  U+300A  uni300A,  LEFT DOUBLE ANGLE BRACKET
        0x300B, # G+145  U+300B  uni300B,  RIGHT DOUBLE ANGLE BRACKET
        0xFE3D, # G+146  U+FE3D  uniFE3D,  PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
        0xFE3E, # G+147  U+FE3E  uniFE3E,  PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
        0x3008, # G+148  U+3008  uni3008,  LEFT ANGLE BRACKET
        0x3009, # G+149  U+3009  uni3009,  RIGHT ANGLE BRACKET
        0xFE3F, # G+150  U+FE3F  uniFE3F,  PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
        0xFE40, # G+151  U+FE40  uniFE40,  PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
        0x300C, # G+152  U+300C  uni300C,  LEFT CORNER BRACKET
        0x300D, # G+153  U+300D  uni300D,  RIGHT CORNER BRACKET
        0xFE41, # G+154  U+FE41  uniFE41,  PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
        0xFE42, # G+155  U+FE42  uniFE42,  PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
        0x300E, # G+156  U+300E  uni300E,  LEFT WHITE CORNER BRACKET
        0x300F, # G+157  U+300F  uni300F,  RIGHT WHITE CORNER BRACKET
        0xFE43, # G+158  U+FE43  uniFE43,  PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
        0xFE44, # G+159  U+FE44  uniFE44,  PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
        0xFE59, # G+160  U+FE59  uniFE59,  SMALL LEFT PARENTHESIS
        0xFE5A, # G+161  U+FE5A  uniFE5A,  SMALL RIGHT PARENTHESIS
        0xFE5B, # G+162  U+FE5B  uniFE5B,  SMALL LEFT CURLY BRACKET
        0xFE5C, # G+163  U+FE5C  uniFE5C,  SMALL RIGHT CURLY BRACKET
        0xFE5D, # G+164  U+FE5D  uniFE5D,  SMALL LEFT TORTOISE SHELL BRACKET
        0xFE5E, # G+165  U+FE5E  uniFE5E,  SMALL RIGHT TORTOISE SHELL BRACKET
        0x2018, # G+166  U+2018  quoteleft,  LEFT SINGLE QUOTATION MARK
        0x2019, # G+167  U+2019  quoteright,  RIGHT SINGLE QUOTATION MARK
        0x201C, # G+168  U+201C  quotedblleft,  LEFT DOUBLE QUOTATION MARK
        0x201D, # G+169  U+201D  quotedblright,  RIGHT DOUBLE QUOTATION MARK
        0x301D, # G+170  U+301D  uni301D,  REVERSED DOUBLE PRIME QUOTATION MARK
        0x301E, # G+171  U+301E  uni301E,  DOUBLE PRIME QUOTATION MARK
        0x2035, # G+172  U+2035  uni2035,  REVERSED PRIME
        0x2032, # G+173  U+2032  minute,  PRIME
        0xFF03, # G+174  U+FF03  uniFF03,  FULLWIDTH NUMBER SIGN
        0xFF06, # G+175  U+FF06  uniFF06,  FULLWIDTH AMPERSAND
        0xFF0A, # G+176  U+FF0A  uniFF0A,  FULLWIDTH ASTERISK
        0x203B, # G+177  U+203B  uni203B,  REFERENCE MARK
        0x00A7, # G+178  U+00A7  section,  SECTION SIGN
        0x3003, # G+179  U+3003  uni3003,  DITTO MARK
        0x25CB, # G+180  U+25CB  circle,  WHITE CIRCLE
        0x25CF, # G+181  U+25CF  H18533,  BLACK CIRCLE
        0x25B3, # G+182  U+25B3  uni25B3,  WHITE UP-POINTING TRIANGLE
        0x25B2, # G+183  U+25B2  triagup,  BLACK UP-POINTING TRIANGLE
        0x25CE, # G+184  U+25CE  uni25CE,  BULLSEYE
        0x2606, # G+185  U+2606  uni2606,  WHITE STAR
        0x2605, # G+186  U+2605  a35,  BLACK STAR
        0x25C7, # G+187  U+25C7  uni25C7,  WHITE DIAMOND
        0x25C6, # G+188  U+25C6  a78,  BLACK DIAMOND
        0x25A1, # G+189  U+25A1  H22073,  WHITE SQUARE
        0x25A0, # G+190  U+25A0  filledbox,  BLACK SQUARE
        0x25BD, # G+191  U+25BD  uni25BD,  WHITE DOWN-POINTING TRIANGLE
        0x25BC, # G+192  U+25BC  triagdn,  BLACK DOWN-POINTING TRIANGLE
        0x32A3, # G+193  U+32A3  uni32A3,  CIRCLED IDEOGRAPH CORRECT
        0x2105, # G+194  U+2105  afii61248,  CARE OF
        0x203E, # G+195  U+203E  overline,  OVERLINE
        0x0000, # G+196  U+0000  .notdef,  UNDEFINED
        0xFF3F, # G+197  U+FF3F  uniFF3F,  FULLWIDTH LOW LINE
        0x0000, # G+198  U+0000  .notdef,  UNDEFINED
        0xFE49, # G+199  U+FE49  uniFE49,  DASHED OVERLINE
        0xFE4A, # G+200  U+FE4A  uniFE4A,  CENTRELINE OVERLINE
        0xFE4D, # G+201  U+FE4D  uniFE4D,  DASHED LOW LINE
        0xFE4E, # G+202  U+FE4E  uniFE4E,  CENTRELINE LOW LINE
        0xFE4B, # G+203  U+FE4B  uniFE4B,  WAVY OVERLINE
        0xFE4C, # G+204  U+FE4C  uniFE4C,  DOUBLE WAVY OVERLINE
        0xFE5F, # G+205  U+FE5F  uniFE5F,  SMALL NUMBER SIGN
        0xFE60, # G+206  U+FE60  uniFE60,  SMALL AMPERSAND
        0xFE61, # G+207  U+FE61  uniFE61,  SMALL ASTERISK
        0xFF0B, # G+208  U+FF0B  uniFF0B,  FULLWIDTH PLUS SIGN
        0xFF0D, # G+209  U+FF0D  uniFF0D,  FULLWIDTH HYPHEN-MINUS
        0x00D7, # G+210  U+00D7  multiply,  MULTIPLICATION SIGN
        0x00F7, # G+211  U+00F7  divide,  DIVISION SIGN
        0x00B1, # G+212  U+00B1  plusminus,  PLUS-MINUS SIGN
        0x221A, # G+213  U+221A  radical,  SQUARE ROOT
        0xFF1C, # G+214  U+FF1C  uniFF1C,  FULLWIDTH LESS-THAN SIGN
        0xFF1E, # G+215  U+FF1E  uniFF1E,  FULLWIDTH GREATER-THAN SIGN
        0xFF1D, # G+216  U+FF1D  uniFF1D,  FULLWIDTH EQUALS SIGN
        0x2266, # G+217  U+2266  uni2266,  LESS-THAN OVER EQUAL TO
        0x2267, # G+218  U+2267  uni2267,  GREATER-THAN OVER EQUAL TO
        0x2260, # G+219  U+2260  notequal,  NOT EQUAL TO
        0x221E, # G+220  U+221E  infinity,  INFINITY
        0x2252, # G+221  U+2252  uni2252,  APPROXIMATELY EQUAL TO OR THE IMAGE OF
        0x2261, # G+222  U+2261  equivalence,  IDENTICAL TO
        0xFE62, # G+223  U+FE62  uniFE62,  SMALL PLUS SIGN
        0xFE63, # G+224  U+FE63  uniFE63,  SMALL HYPHEN-MINUS
        0xFE64, # G+225  U+FE64  uniFE64,  SMALL LESS-THAN SIGN
        0xFE65, # G+226  U+FE65  uniFE65,  SMALL GREATER-THAN SIGN
        0xFE66, # G+227  U+FE66  uniFE66,  SMALL EQUALS SIGN
        0x223C, # G+228  U+223C  similar,  TILDE OPERATOR
        0x2229, # G+229  U+2229  intersection,  INTERSECTION
        0x222A, # G+230  U+222A  union,  UNION
        0x22A5, # G+231  U+22A5  perpendicular,  UP TACK
        0x2220, # G+232  U+2220  angle,  ANGLE
        0x221F, # G+233  U+221F  orthogonal,  RIGHT ANGLE
        0x22BF, # G+234  U+22BF  uni22BF,  RIGHT TRIANGLE
        0x33D2, # G+235  U+33D2  uni33D2,  SQUARE LOG
        0x33D1, # G+236  U+33D1  uni33D1,  SQUARE LN
        0x222B, # G+237  U+222B  integral,  INTEGRAL
        0x222E, # G+238  U+222E  uni222E,  CONTOUR INTEGRAL
        0x2235, # G+239  U+2235  uni2235,  BECAUSE
        0x2234, # G+240  U+2234  therefore,  THEREFORE
        0x2640, # G+241  U+2640  female,  FEMALE SIGN
        0x2642, # G+242  U+2642  male,  MALE SIGN
        0x2641, # G+243  U+2641  uni2641,  EARTH
        0x2609, # G+244  U+2609  uni2609,  SUN
        0x2191, # G+245  U+2191  arrowup,  UPWARDS ARROW
        0x2193, # G+246  U+2193  arrowdown,  DOWNWARDS ARROW
        0x2192, # G+247  U+2192  arrowright,  RIGHTWARDS ARROW
        0x2190, # G+248  U+2190  arrowleft,  LEFTWARDS ARROW
        0x2196, # G+249  U+2196  uni2196,  NORTH WEST ARROW
        0x2197, # G+250  U+2197  uni2197,  NORTH EAST ARROW
        0x2199, # G+251  U+2199  uni2199,  SOUTH WEST ARROW
        0x2198, # G+252  U+2198  uni2198,  SOUTH EAST ARROW
        0x2225, # G+253  U+2225  uni2225,  PARALLEL TO
        0x2223, # G+254  U+2223  uni2223,  DIVIDES
        0x0000, # G+255  U+0000  .notdef,  UNDEFINED
        0x0000, # G+256  U+0000  .notdef,  UNDEFINED
        0xFF0F, # G+257  U+FF0F  uniFF0F,  FULLWIDTH SOLIDUS
        0xFF3C, # G+258  U+FF3C  uniFF3C,  FULLWIDTH REVERSE SOLIDUS
        0xFF04, # G+259  U+FF04  uniFF04,  FULLWIDTH DOLLAR SIGN
        0x00A5, # G+260  U+00A5  yen,  YEN SIGN
        0x3012, # G+261  U+3012  uni3012,  POSTAL MARK
        0x00A2, # G+262  U+00A2  cent,  CENT SIGN
        0x00A3, # G+263  U+00A3  sterling,  POUND SIGN
        0xFF05, # G+264  U+FF05  uniFF05,  FULLWIDTH PERCENT SIGN
        0xFF20, # G+265  U+FF20  uniFF20,  FULLWIDTH COMMERCIAL AT
        0x2103, # G+266  U+2103  uni2103,  DEGREE CELSIUS
        0x2109, # G+267  U+2109  uni2109,  DEGREE FAHRENHEIT
        0xFE69, # G+268  U+FE69  uniFE69,  SMALL DOLLAR SIGN
        0xFE6A, # G+269  U+FE6A  uniFE6A,  SMALL PERCENT SIGN
        0xFE6B, # G+270  U+FE6B  uniFE6B,  SMALL COMMERCIAL AT
        0x33D5, # G+271  U+33D5  uni33D5,  SQUARE MIL
        0x339C, # G+272  U+339C  uni339C,  SQUARE MM
        0x339D, # G+273  U+339D  uni339D,  SQUARE CM
        0x339E, # G+274  U+339E  uni339E,  SQUARE KM
        0x33CE, # G+275  U+33CE  uni33CE,  SQUARE KM CAPITAL
        0x33A1, # G+276  U+33A1  uni33A1,  SQUARE M SQUARED
        0x338E, # G+277  U+338E  uni338E,  SQUARE MG
        0x338F, # G+278  U+338F  uni338F,  SQUARE KG
        0x33C4, # G+279  U+33C4  uni33C4,  SQUARE CC
        0x00B0, # G+280  U+00B0  degree,  DEGREE SIGN
        0x5159, # G+281  U+5159  uni5159,  CJK UNIFIED IDEOGRAPH-5159
        0x515B, # G+282  U+515B  uni515B,  CJK UNIFIED IDEOGRAPH-515B
        0x515E, # G+283  U+515E  uni515E,  CJK UNIFIED IDEOGRAPH-515E
        0x515D, # G+284  U+515D  uni515D,  CJK UNIFIED IDEOGRAPH-515D
        0x5161, # G+285  U+5161  uni5161,  CJK UNIFIED IDEOGRAPH-5161
        0x5163, # G+286  U+5163  uni5163,  CJK UNIFIED IDEOGRAPH-5163
        0x55E7, # G+287  U+55E7  uni55E7,  CJK UNIFIED IDEOGRAPH-55E7
        0x74E9, # G+288  U+74E9  uni74E9,  CJK UNIFIED IDEOGRAPH-74E9
        0x7CCE, # G+289  U+7CCE  uni7CCE,  CJK UNIFIED IDEOGRAPH-7CCE
        0x2581, # G+290  U+2581  uni2581,  LOWER ONE EIGHTH BLOCK
        0x2582, # G+291  U+2582  uni2582,  LOWER ONE QUARTER BLOCK
        0x2583, # G+292  U+2583  uni2583,  LOWER THREE EIGHTHS BLOCK
        0x2584, # G+293  U+2584  dnblock,  LOWER HALF BLOCK
        0x2585, # G+294  U+2585  uni2585,  LOWER FIVE EIGHTHS BLOCK
        0x2586, # G+295  U+2586  uni2586,  LOWER THREE QUARTERS BLOCK
        0x2587, # G+296  U+2587  uni2587,  LOWER SEVEN EIGHTHS BLOCK
        0x2588, # G+297  U+2588  block,  FULL BLOCK
        0x258F, # G+298  U+258F  uni258F,  LEFT ONE EIGHTH BLOCK
        0x258E, # G+299  U+258E  uni258E,  LEFT ONE QUARTER BLOCK
        0x258D, # G+300  U+258D  uni258D,  LEFT THREE EIGHTHS BLOCK
        0x258C, # G+301  U+258C  lfblock,  LEFT HALF BLOCK
        0x258B, # G+302  U+258B  uni258B,  LEFT FIVE EIGHTHS BLOCK
        0x258A, # G+303  U+258A  uni258A,  LEFT THREE QUARTERS BLOCK
        0x2589, # G+304  U+2589  uni2589,  LEFT SEVEN EIGHTHS BLOCK
        0x253C, # G+305  U+253C  SF050000,  BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
        0x2534, # G+306  U+2534  SF070000,  BOX DRAWINGS LIGHT UP AND HORIZONTAL
        0x252C, # G+307  U+252C  SF060000,  BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
        0x2524, # G+308  U+2524  SF090000,  BOX DRAWINGS LIGHT VERTICAL AND LEFT
        0x251C, # G+309  U+251C  SF080000,  BOX DRAWINGS LIGHT VERTICAL AND RIGHT
        0x2594, # G+310  U+2594  uni2594,  UPPER ONE EIGHTH BLOCK
        0x2500, # G+311  U+2500  SF100000,  BOX DRAWINGS LIGHT HORIZONTAL
        0x2502, # G+312  U+2502  SF110000,  BOX DRAWINGS LIGHT VERTICAL
        0x2595, # G+313  U+2595  uni2595,  RIGHT ONE EIGHTH BLOCK
        0x250C, # G+314  U+250C  SF010000,  BOX DRAWINGS LIGHT DOWN AND RIGHT
        0x2510, # G+315  U+2510  SF030000,  BOX DRAWINGS LIGHT DOWN AND LEFT
        0x2514, # G+316  U+2514  SF020000,  BOX DRAWINGS LIGHT UP AND RIGHT
        0x2518, # G+317  U+2518  SF040000,  BOX DRAWINGS LIGHT UP AND LEFT
        0x256D, # G+318  U+256D  uni256D,  BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
        0x256E, # G+319  U+256E  uni256E,  BOX DRAWINGS LIGHT ARC DOWN AND LEFT
        0x2570, # G+320  U+2570  uni2570,  BOX DRAWINGS LIGHT ARC UP AND RIGHT
        0x256F, # G+321  U+256F  uni256F,  BOX DRAWINGS LIGHT ARC UP AND LEFT
        0x2550, # G+322  U+2550  SF430000,  BOX DRAWINGS DOUBLE HORIZONTAL
        0x255E, # G+323  U+255E  SF360000,  BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
        0x256A, # G+324  U+256A  SF540000,  BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
        0x2561, # G+325  U+2561  SF190000,  BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
        0x25E2, # G+326  U+25E2  uni25E2,  BLACK LOWER RIGHT TRIANGLE
        0x25E3, # G+327  U+25E3  uni25E3,  BLACK LOWER LEFT TRIANGLE
        0x25E5, # G+328  U+25E5  uni25E5,  BLACK UPPER RIGHT TRIANGLE
        0x25E4, # G+329  U+25E4  uni25E4,  BLACK UPPER LEFT TRIANGLE
        0x2571, # G+330  U+2571  uni2571,  BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
        0x2572, # G+331  U+2572  uni2572,  BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
        0x2573, # G+332  U+2573  uni2573,  BOX DRAWINGS LIGHT DIAGONAL CROSS
        0xFF10, # G+333  U+FF10  uniFF10,  FULLWIDTH DIGIT ZERO
        0xFF11, # G+334  U+FF11  uniFF11,  FULLWIDTH DIGIT ONE
        0xFF12, # G+335  U+FF12  uniFF12,  FULLWIDTH DIGIT TWO
        0xFF13, # G+336  U+FF13  uniFF13,  FULLWIDTH DIGIT THREE
        0xFF14, # G+337  U+FF14  uniFF14,  FULLWIDTH DIGIT FOUR
        0xFF15, # G+338  U+FF15  uniFF15,  FULLWIDTH DIGIT FIVE
        0xFF16, # G+339  U+FF16  uniFF16,  FULLWIDTH DIGIT SIX
        0xFF17, # G+340  U+FF17  uniFF17,  FULLWIDTH DIGIT SEVEN
        0xFF18, # G+341  U+FF18  uniFF18,  FULLWIDTH DIGIT EIGHT
        0xFF19, # G+342  U+FF19  uniFF19,  FULLWIDTH DIGIT NINE
        0x2160, # G+343  U+2160  uni2160,  ROMAN NUMERAL ONE
        0x2161, # G+344  U+2161  uni2161,  ROMAN NUMERAL TWO
        0x2162, # G+345  U+2162  uni2162,  ROMAN NUMERAL THREE
        0x2163, # G+346  U+2163  uni2163,  ROMAN NUMERAL FOUR
        0x2164, # G+347  U+2164  uni2164,  ROMAN NUMERAL FIVE
        0x2165, # G+348  U+2165  uni2165,  ROMAN NUMERAL SIX
        0x2166, # G+349  U+2166  uni2166,  ROMAN NUMERAL SEVEN
        0x2167, # G+350  U+2167  uni2167,  ROMAN NUMERAL EIGHT
        0x2168, # G+351  U+2168  uni2168,  ROMAN NUMERAL NINE
        0x2169, # G+352  U+2169  uni2169,  ROMAN NUMERAL TEN
        0x3021, # G+353  U+3021  uni3021,  HANGZHOU NUMERAL ONE
        0x3022, # G+354  U+3022  uni3022,  HANGZHOU NUMERAL TWO
        0x3023, # G+355  U+3023  uni3023,  HANGZHOU NUMERAL THREE
        0x3024, # G+356  U+3024  uni3024,  HANGZHOU NUMERAL FOUR
        0x3025, # G+357  U+3025  uni3025,  HANGZHOU NUMERAL FIVE
        0x3026, # G+358  U+3026  uni3026,  HANGZHOU NUMERAL SIX
        0x3027, # G+359  U+3027  uni3027,  HANGZHOU NUMERAL SEVEN
        0x3028, # G+360  U+3028  uni3028,  HANGZHOU NUMERAL EIGHT
        0x3029, # G+361  U+3029  uni3029,  HANGZHOU NUMERAL NINE
        0x0000, # G+362  U+0000  .notdef,  UNDEFINED
        0x5344, # G+363  U+5344  uni5344,  CJK UNIFIED IDEOGRAPH-5344
        0x0000, # G+364  U+0000  .notdef,  UNDEFINED
        0xFF21, # G+365  U+FF21  uniFF21,  FULLWIDTH LATIN CAPITAL LETTER A
        0xFF22, # G+366  U+FF22  uniFF22,  FULLWIDTH LATIN CAPITAL LETTER B
        0xFF23, # G+367  U+FF23  uniFF23,  FULLWIDTH LATIN CAPITAL LETTER C
        0xFF24, # G+368  U+FF24  uniFF24,  FULLWIDTH LATIN CAPITAL LETTER D
        0xFF25, # G+369  U+FF25  uniFF25,  FULLWIDTH LATIN CAPITAL LETTER E
        0xFF26, # G+370  U+FF26  uniFF26,  FULLWIDTH LATIN CAPITAL LETTER F
        0xFF27, # G+371  U+FF27  uniFF27,  FULLWIDTH LATIN CAPITAL LETTER G
        0xFF28, # G+372  U+FF28  uniFF28,  FULLWIDTH LATIN CAPITAL LETTER H
        0xFF29, # G+373  U+FF29  uniFF29,  FULLWIDTH LATIN CAPITAL LETTER I
        0xFF2A, # G+374  U+FF2A  uniFF2A,  FULLWIDTH LATIN CAPITAL LETTER J
        0xFF2B, # G+375  U+FF2B  uniFF2B,  FULLWIDTH LATIN CAPITAL LETTER K
        0xFF2C, # G+376  U+FF2C  uniFF2C,  FULLWIDTH LATIN CAPITAL LETTER L
        0xFF2D, # G+377  U+FF2D  uniFF2D,  FULLWIDTH LATIN CAPITAL LETTER M
        0xFF2E, # G+378  U+FF2E  uniFF2E,  FULLWIDTH LATIN CAPITAL LETTER N
        0xFF2F, # G+379  U+FF2F  uniFF2F,  FULLWIDTH LATIN CAPITAL LETTER O
        0xFF30, # G+380  U+FF30  uniFF30,  FULLWIDTH LATIN CAPITAL LETTER P
        0xFF31, # G+381  U+FF31  uniFF31,  FULLWIDTH LATIN CAPITAL LETTER Q
        0xFF32, # G+382  U+FF32  uniFF32,  FULLWIDTH LATIN CAPITAL LETTER R
        0xFF33, # G+383  U+FF33  uniFF33,  FULLWIDTH LATIN CAPITAL LETTER S
        0xFF34, # G+384  U+FF34  uniFF34,  FULLWIDTH LATIN CAPITAL LETTER T
        0xFF35, # G+385  U+FF35  uniFF35,  FULLWIDTH LATIN CAPITAL LETTER U
        0xFF36, # G+386  U+FF36  uniFF36,  FULLWIDTH LATIN CAPITAL LETTER V
        0xFF37, # G+387  U+FF37  uniFF37,  FULLWIDTH LATIN CAPITAL LETTER W
        0xFF38, # G+388  U+FF38  uniFF38,  FULLWIDTH LATIN CAPITAL LETTER X
        0xFF39, # G+389  U+FF39  uniFF39,  FULLWIDTH LATIN CAPITAL LETTER Y
        0xFF3A, # G+390  U+FF3A  uniFF3A,  FULLWIDTH LATIN CAPITAL LETTER Z
        0xFF41, # G+391  U+FF41  uniFF41,  FULLWIDTH LATIN SMALL LETTER A
        0xFF42, # G+392  U+FF42  uniFF42,  FULLWIDTH LATIN SMALL LETTER B
        0xFF43, # G+393  U+FF43  uniFF43,  FULLWIDTH LATIN SMALL LETTER C
        0xFF44, # G+394  U+FF44  uniFF44,  FULLWIDTH LATIN SMALL LETTER D
        0xFF45, # G+395  U+FF45  uniFF45,  FULLWIDTH LATIN SMALL LETTER E
        0xFF46, # G+396  U+FF46  uniFF46,  FULLWIDTH LATIN SMALL LETTER F
        0xFF47, # G+397  U+FF47  uniFF47,  FULLWIDTH LATIN SMALL LETTER G
        0xFF48, # G+398  U+FF48  uniFF48,  FULLWIDTH LATIN SMALL LETTER H
        0xFF49, # G+399  U+FF49  uniFF49,  FULLWIDTH LATIN SMALL LETTER I
        0xFF4A, # G+400  U+FF4A  uniFF4A,  FULLWIDTH LATIN SMALL LETTER J
        0xFF4B, # G+401  U+FF4B  uniFF4B,  FULLWIDTH LATIN SMALL LETTER K
        0xFF4C, # G+402  U+FF4C  uniFF4C,  FULLWIDTH LATIN SMALL LETTER L
        0xFF4D, # G+403  U+FF4D  uniFF4D,  FULLWIDTH LATIN SMALL LETTER M
        0xFF4E, # G+404  U+FF4E  uniFF4E,  FULLWIDTH LATIN SMALL LETTER N
        0xFF4F, # G+405  U+FF4F  uniFF4F,  FULLWIDTH LATIN SMALL LETTER O
        0xFF50, # G+406  U+FF50  uniFF50,  FULLWIDTH LATIN SMALL LETTER P
        0xFF51, # G+407  U+FF51  uniFF51,  FULLWIDTH LATIN SMALL LETTER Q
        0xFF52, # G+408  U+FF52  uniFF52,  FULLWIDTH LATIN SMALL LETTER R
        0xFF53, # G+409  U+FF53  uniFF53,  FULLWIDTH LATIN SMALL LETTER S
        0xFF54, # G+410  U+FF54  uniFF54,  FULLWIDTH LATIN SMALL LETTER T
        0xFF55, # G+411  U+FF55  uniFF55,  FULLWIDTH LATIN SMALL LETTER U
        0xFF56, # G+412  U+FF56  uniFF56,  FULLWIDTH LATIN SMALL LETTER V
        0xFF57, # G+413  U+FF57  uniFF57,  FULLWIDTH LATIN SMALL LETTER W
        0xFF58, # G+414  U+FF58  uniFF58,  FULLWIDTH LATIN SMALL LETTER X
        0xFF59, # G+415  U+FF59  uniFF59,  FULLWIDTH LATIN SMALL LETTER Y
        0xFF5A, # G+416  U+FF5A  uniFF5A,  FULLWIDTH LATIN SMALL LETTER Z
        0x0391, # G+417  U+0391  Alpha,  GREEK CAPITAL LETTER ALPHA
        0x0392, # G+418  U+0392  Beta,  GREEK CAPITAL LETTER BETA
        0x0393, # G+419  U+0393  Gamma,  GREEK CAPITAL LETTER GAMMA
        0x0394, # G+420  U+0394  Delta,  GREEK CAPITAL LETTER DELTA
        0x0395, # G+421  U+0395  Epsilon,  GREEK CAPITAL LETTER EPSILON
        0x0396, # G+422  U+0396  Zeta,  GREEK CAPITAL LETTER ZETA
        0x0397, # G+423  U+0397  Eta,  GREEK CAPITAL LETTER ETA
        0x0398, # G+424  U+0398  Theta,  GREEK CAPITAL LETTER THETA
        0x0399, # G+425  U+0399  Iota,  GREEK CAPITAL LETTER IOTA
        0x039A, # G+426  U+039A  Kappa,  GREEK CAPITAL LETTER KAPPA
        0x039B, # G+427  U+039B  Lambda,  GREEK CAPITAL LETTER LAMDA
        0x039C, # G+428  U+039C  Mu,  GREEK CAPITAL LETTER MU
        0x039D, # G+429  U+039D  Nu,  GREEK CAPITAL LETTER NU
        0x039E, # G+430  U+039E  Xi,  GREEK CAPITAL LETTER XI
        0x039F, # G+431  U+039F  Omicron,  GREEK CAPITAL LETTER OMICRON
        0x03A0, # G+432  U+03A0  Pi,  GREEK CAPITAL LETTER PI
        0x03A1, # G+433  U+03A1  Rho,  GREEK CAPITAL LETTER RHO
        0x03A3, # G+434  U+03A3  Sigma,  GREEK CAPITAL LETTER SIGMA
        0x03A4, # G+435  U+03A4  Tau,  GREEK CAPITAL LETTER TAU
        0x03A5, # G+436  U+03A5  Upsilon,  GREEK CAPITAL LETTER UPSILON
        0x03A6, # G+437  U+03A6  Phi,  GREEK CAPITAL LETTER PHI
        0x03A7, # G+438  U+03A7  Chi,  GREEK CAPITAL LETTER CHI
        0x03A8, # G+439  U+03A8  Psi,  GREEK CAPITAL LETTER PSI
        0x03A9, # G+440  U+03A9  Omega,  GREEK CAPITAL LETTER OMEGA
        0x03B1, # G+441  U+03B1  alpha,  GREEK SMALL LETTER ALPHA
        0x03B2, # G+442  U+03B2  beta,  GREEK SMALL LETTER BETA
        0x03B3, # G+443  U+03B3  gamma,  GREEK SMALL LETTER GAMMA
        0x03B4, # G+444  U+03B4  delta,  GREEK SMALL LETTER DELTA
        0x03B5, # G+445  U+03B5  epsilon,  GREEK SMALL LETTER EPSILON
        0x03B6, # G+446  U+03B6  zeta,  GREEK SMALL LETTER ZETA
        0x03B7, # G+447  U+03B7  eta,  GREEK SMALL LETTER ETA
        0x03B8, # G+448  U+03B8  theta,  GREEK SMALL LETTER THETA
        0x03B9, # G+449  U+03B9  iota,  GREEK SMALL LETTER IOTA
        0x03BA, # G+450  U+03BA  kappa,  GREEK SMALL LETTER KAPPA
        0x03BB, # G+451  U+03BB  lambda,  GREEK SMALL LETTER LAMDA
        0x03BC, # G+452  U+03BC  mu,  GREEK SMALL LETTER MU
        0x03BD, # G+453  U+03BD  nu,  GREEK SMALL LETTER NU
        0x03BE, # G+454  U+03BE  xi,  GREEK SMALL LETTER XI
        0x03BF, # G+455  U+03BF  omicron,  GREEK SMALL LETTER OMICRON
        0x03C0, # G+456  U+03C0  pi,  GREEK SMALL LETTER PI
        0x03C1, # G+457  U+03C1  rho,  GREEK SMALL LETTER RHO
        0x03C3, # G+458  U+03C3  sigma,  GREEK SMALL LETTER SIGMA
        0x03C4, # G+459  U+03C4  tau,  GREEK SMALL LETTER TAU
        0x03C5, # G+460  U+03C5  upsilon,  GREEK SMALL LETTER UPSILON
        0x03C6, # G+461  U+03C6  phi,  GREEK SMALL LETTER PHI
        0x03C7, # G+462  U+03C7  chi,  GREEK SMALL LETTER CHI
        0x03C8, # G+463  U+03C8  psi,  GREEK SMALL LETTER PSI
        0x03C9, # G+464  U+03C9  omega,  GREEK SMALL LETTER OMEGA
        0x3105, # G+465  U+3105  uni3105,  BOPOMOFO LETTER B
        0x3106, # G+466  U+3106  uni3106,  BOPOMOFO LETTER P
        0x3107, # G+467  U+3107  uni3107,  BOPOMOFO LETTER M
        0x3108, # G+468  U+3108  uni3108,  BOPOMOFO LETTER F
        0x3109, # G+469  U+3109  uni3109,  BOPOMOFO LETTER D
        0x310A, # G+470  U+310A  uni310A,  BOPOMOFO LETTER T
        0x310B, # G+471  U+310B  uni310B,  BOPOMOFO LETTER N
        0x310C, # G+472  U+310C  uni310C,  BOPOMOFO LETTER L
        0x310D, # G+473  U+310D  uni310D,  BOPOMOFO LETTER G
        0x310E, # G+474  U+310E  uni310E,  BOPOMOFO LETTER K
        0x310F, # G+475  U+310F  uni310F,  BOPOMOFO LETTER H
        0x3110, # G+476  U+3110  uni3110,  BOPOMOFO LETTER J
        0x3111, # G+477  U+3111  uni3111,  BOPOMOFO LETTER Q
        0x3112, # G+478  U+3112  uni3112,  BOPOMOFO LETTER X
        0x3113, # G+479  U+3113  uni3113,  BOPOMOFO LETTER ZH
        0x3114, # G+480  U+3114  uni3114,  BOPOMOFO LETTER CH
        0x3115, # G+481  U+3115  uni3115,  BOPOMOFO LETTER SH
        0x3116, # G+482  U+3116  uni3116,  BOPOMOFO LETTER R
        0x3117, # G+483  U+3117  uni3117,  BOPOMOFO LETTER Z
        0x3118, # G+484  U+3118  uni3118,  BOPOMOFO LETTER C
        0x3119, # G+485  U+3119  uni3119,  BOPOMOFO LETTER S
        0x311A, # G+486  U+311A  uni311A,  BOPOMOFO LETTER A
        0x311B, # G+487  U+311B  uni311B,  BOPOMOFO LETTER O
        0x311C, # G+488  U+311C  uni311C,  BOPOMOFO LETTER E
        0x311D, # G+489  U+311D  uni311D,  BOPOMOFO LETTER EH
        0x311E, # G+490  U+311E  uni311E,  BOPOMOFO LETTER AI
        0x311F, # G+491  U+311F  uni311F,  BOPOMOFO LETTER EI
        0x3120, # G+492  U+3120  uni3120,  BOPOMOFO LETTER AU
        0x3121, # G+493  U+3121  uni3121,  BOPOMOFO LETTER OU
        0x3122, # G+494  U+3122  uni3122,  BOPOMOFO LETTER AN
        0x3123, # G+495  U+3123  uni3123,  BOPOMOFO LETTER EN
        0x3124, # G+496  U+3124  uni3124,  BOPOMOFO LETTER ANG
        0x3125, # G+497  U+3125  uni3125,  BOPOMOFO LETTER ENG
        0x3126, # G+498  U+3126  uni3126,  BOPOMOFO LETTER ER
        0x3127, # G+499  U+3127  uni3127,  BOPOMOFO LETTER I
        0x3128, # G+500  U+3128  uni3128,  BOPOMOFO LETTER U
        0x3129, # G+501  U+3129  uni3129,  BOPOMOFO LETTER IU
        0x02D9, # G+502  U+02D9  dotaccent,  DOT ABOVE
        0x02CA, # G+503  U+02CA  uni02CA,  MODIFIER LETTER ACUTE ACCENT
        0x02C7, # G+504  U+02C7  caron,  CARON
        0x02CB, # G+505  U+02CB  uni02CB,  MODIFIER LETTER GRAVE ACCENT
        0x2460, # G+506  U+2460  a120,  CIRCLED DIGIT ONE
        0x2461, # G+507  U+2461  a121,  CIRCLED DIGIT TWO
        0x2462, # G+508  U+2462  a122,  CIRCLED DIGIT THREE
        0x2463, # G+509  U+2463  a123,  CIRCLED DIGIT FOUR
        0x2464, # G+510  U+2464  a124,  CIRCLED DIGIT FIVE
        0x2465, # G+511  U+2465  a125,  CIRCLED DIGIT SIX
        0x2466, # G+512  U+2466  a126,  CIRCLED DIGIT SEVEN
        0x2467, # G+513  U+2467  a127,  CIRCLED DIGIT EIGHT
        0x2468, # G+514  U+2468  a128,  CIRCLED DIGIT NINE
        0x2469, # G+515  U+2469  a129,  CIRCLED NUMBER TEN
        0x2474, # G+516  U+2474  uni2474,  PARENTHESIZED DIGIT ONE
        0x2475, # G+517  U+2475  uni2475,  PARENTHESIZED DIGIT TWO
        0x2476, # G+518  U+2476  uni2476,  PARENTHESIZED DIGIT THREE
        0x2477, # G+519  U+2477  uni2477,  PARENTHESIZED DIGIT FOUR
        0x2478, # G+520  U+2478  uni2478,  PARENTHESIZED DIGIT FIVE
        0x2479, # G+521  U+2479  uni2479,  PARENTHESIZED DIGIT SIX
        0x247A, # G+522  U+247A  uni247A,  PARENTHESIZED DIGIT SEVEN
        0x247B, # G+523  U+247B  uni247B,  PARENTHESIZED DIGIT EIGHT
        0x247C, # G+524  U+247C  uni247C,  PARENTHESIZED DIGIT NINE
        0x247D, # G+525  U+247D  uni247D,  PARENTHESIZED NUMBER TEN
        0x2170, # G+526  U+2170  uni2170,  SMALL ROMAN NUMERAL ONE
        0x2171, # G+527  U+2171  uni2171,  SMALL ROMAN NUMERAL TWO
        0x2172, # G+528  U+2172  uni2172,  SMALL ROMAN NUMERAL THREE
        0x2173, # G+529  U+2173  uni2173,  SMALL ROMAN NUMERAL FOUR
        0x2174, # G+530  U+2174  uni2174,  SMALL ROMAN NUMERAL FIVE
        0x2175, # G+531  U+2175  uni2175,  SMALL ROMAN NUMERAL SIX
        0x2176, # G+532  U+2176  uni2176,  SMALL ROMAN NUMERAL SEVEN
        0x2177, # G+533  U+2177  uni2177,  SMALL ROMAN NUMERAL EIGHT
        0x2178, # G+534  U+2178  uni2178,  SMALL ROMAN NUMERAL NINE
        0x2179, # G+535  U+2179  uni2179,  SMALL ROMAN NUMERAL TEN
        0x4E28, # G+536  U+4E28  uni4E28,  CJK UNIFIED IDEOGRAPH-4E28
        0x4E36, # G+537  U+4E36  uni4E36,  CJK UNIFIED IDEOGRAPH-4E36
        0x4E3F, # G+538  U+4E3F  uni4E3F,  CJK UNIFIED IDEOGRAPH-4E3F
        0x2F05, # G+539  U+2F05  uni2F05,  KANGXI RADICAL HOOK
        0x2F07, # G+540  U+2F07  uni2F07,  KANGXI RADICAL LID
        0x5182, # G+541  U+5182  uni5182,  CJK UNIFIED IDEOGRAPH-5182
        0x5196, # G+542  U+5196  uni5196,  CJK UNIFIED IDEOGRAPH-5196
        0x51AB, # G+543  U+51AB  uni51AB,  CJK UNIFIED IDEOGRAPH-51AB
        0x2F13, # G+544  U+2F13  uni2F13,  KANGXI RADICAL WRAP
        0x2F16, # G+545  U+2F16  uni2F16,  KANGXI RADICAL HIDING ENCLOSURE
        0x2F19, # G+546  U+2F19  uni2F19,  KANGXI RADICAL SEAL
        0x2F1B, # G+547  U+2F1B  uni2F1B,  KANGXI RADICAL PRIVATE
        0x2F21, # G+548  U+2F21  uni2F21,  KANGXI RADICAL GO
        0x2F27, # G+549  U+2F27  uni2F27,  KANGXI RADICAL ROOF
        0x2F2E, # G+550  U+2F2E  uni2F2E,  KANGXI RADICAL RIVER
        0x5E7A, # G+551  U+5E7A  uni5E7A,  CJK UNIFIED IDEOGRAPH-5E7A
        0x5E7F, # G+552  U+5E7F  uni5E7F,  CJK UNIFIED IDEOGRAPH-5E7F
        0x5EF4, # G+553  U+5EF4  uni5EF4,  CJK UNIFIED IDEOGRAPH-5EF4
        0x5F50, # G+554  U+5F50  uni5F50,  CJK UNIFIED IDEOGRAPH-5F50
        0x5F61, # G+555  U+5F61  uni5F61,  CJK UNIFIED IDEOGRAPH-5F61
        0x2F41, # G+556  U+2F41  uni2F41,  KANGXI RADICAL RAP
        0x2F46, # G+557  U+2F46  uni2F46,  KANGXI RADICAL NOT
        0x7592, # G+558  U+7592  uni7592,  CJK UNIFIED IDEOGRAPH-7592
        0x7676, # G+559  U+7676  uni7676,  CJK UNIFIED IDEOGRAPH-7676
        0x2FA1, # G+560  U+2FA1  uni2FA1,  KANGXI RADICAL WALK
        0x2FAA, # G+561  U+2FAA  uni2FAA,  KANGXI RADICAL SLAVE
        0x2400, # G+562  U+2400  uni2400,  SYMBOL FOR NULL
        0x2401, # G+563  U+2401  uni2401,  SYMBOL FOR START OF HEADING
        0x2402, # G+564  U+2402  uni2402,  SYMBOL FOR START OF TEXT
        0x2403, # G+565  U+2403  uni2403,  SYMBOL FOR END OF TEXT
        0x2404, # G+566  U+2404  uni2404,  SYMBOL FOR END OF TRANSMISSION
        0x2405, # G+567  U+2405  uni2405,  SYMBOL FOR ENQUIRY
        0x2406, # G+568  U+2406  uni2406,  SYMBOL FOR ACKNOWLEDGE
        0x2407, # G+569  U+2407  uni2407,  SYMBOL FOR BELL
        0x2408, # G+570  U+2408  uni2408,  SYMBOL FOR BACKSPACE
        0x2409, # G+571  U+2409  uni2409,  SYMBOL FOR HORIZONTAL TABULATION
        0x240A, # G+572  U+240A  uni240A,  SYMBOL FOR LINE FEED
        0x240B, # G+573  U+240B  uni240B,  SYMBOL FOR VERTICAL TABULATION
        0x240C, # G+574  U+240C  uni240C,  SYMBOL FOR FORM FEED
        0x240D, # G+575  U+240D  uni240D,  SYMBOL FOR CARRIAGE RETURN
        0x240E, # G+576  U+240E  uni240E,  SYMBOL FOR SHIFT OUT
        0x240F, # G+577  U+240F  uni240F,  SYMBOL FOR SHIFT IN
        0x2410, # G+578  U+2410  uni2410,  SYMBOL FOR DATA LINK ESCAPE
        0x2411, # G+579  U+2411  uni2411,  SYMBOL FOR DEVICE CONTROL ONE
        0x2412, # G+580  U+2412  uni2412,  SYMBOL FOR DEVICE CONTROL TWO
        0x2413, # G+581  U+2413  uni2413,  SYMBOL FOR DEVICE CONTROL THREE
        0x2414, # G+582  U+2414  uni2414,  SYMBOL FOR DEVICE CONTROL FOUR
        0x2415, # G+583  U+2415  uni2415,  SYMBOL FOR NEGATIVE ACKNOWLEDGE
        0x2416, # G+584  U+2416  uni2416,  SYMBOL FOR SYNCHRONOUS IDLE
        0x2417, # G+585  U+2417  uni2417,  SYMBOL FOR END OF TRANSMISSION BLOCK
        0x2418, # G+586  U+2418  uni2418,  SYMBOL FOR CANCEL
        0x2419, # G+587  U+2419  uni2419,  SYMBOL FOR END OF MEDIUM
        0x241A, # G+588  U+241A  uni241A,  SYMBOL FOR SUBSTITUTE
        0x241B, # G+589  U+241B  uni241B,  SYMBOL FOR ESCAPE
        0x241C, # G+590  U+241C  uni241C,  SYMBOL FOR FILE SEPARATOR
        0x241D, # G+591  U+241D  uni241D,  SYMBOL FOR GROUP SEPARATOR
        0x241E, # G+592  U+241E  uni241E,  SYMBOL FOR RECORD SEPARATOR
        0x241F, # G+593  U+241F  uni241F,  SYMBOL FOR UNIT SEPARATOR
        0x2421, # G+594  U+2421  uni2421,  SYMBOL FOR DELETE
        0x2F00, # G+595  U+2F00  uni2F00,  KANGXI RADICAL ONE
        0x2F04, # G+596  U+2F04  uni2F04,  KANGXI RADICAL SECOND
        0x4E01, # G+597  U+4E01  uni4E01,  CJK UNIFIED IDEOGRAPH-4E01
        0x4E03, # G+598  U+4E03  uni4E03,  CJK UNIFIED IDEOGRAPH-4E03
        0x4E43, # G+599  U+4E43  uni4E43,  CJK UNIFIED IDEOGRAPH-4E43
        0x4E5D, # G+600  U+4E5D  uni4E5D,  CJK UNIFIED IDEOGRAPH-4E5D
        0x4E86, # G+601  U+4E86  uni4E86,  CJK UNIFIED IDEOGRAPH-4E86
        0x2F06, # G+602  U+2F06  uni2F06,  KANGXI RADICAL TWO
        0x4EBA, # G+603  U+4EBA  uni4EBA,  CJK UNIFIED IDEOGRAPH-4EBA
        0x513F, # G+604  U+513F  uni513F,  CJK UNIFIED IDEOGRAPH-513F
        0x5165, # G+605  U+5165  uni5165,  CJK UNIFIED IDEOGRAPH-5165
        0x516B, # G+606  U+516B  uni516B,  CJK UNIFIED IDEOGRAPH-516B
        0x2F0F, # G+607  U+2F0F  uni2F0F,  KANGXI RADICAL TABLE
        0x2F11, # G+608  U+2F11  uni2F11,  KANGXI RADICAL KNIFE
        0x5201, # G+609  U+5201  uni5201,  CJK UNIFIED IDEOGRAPH-5201
        0x2F12, # G+610  U+2F12  uni2F12,  KANGXI RADICAL POWER
        0x2F14, # G+611  U+2F14  uni2F14,  KANGXI RADICAL SPOON
        0x5341, # G+612  U+5341  uni5341,  CJK UNIFIED IDEOGRAPH-5341
        0x535C, # G+613  U+535C  uni535C,  CJK UNIFIED IDEOGRAPH-535C
        0x2F1C, # G+614  U+2F1C  uni2F1C,  KANGXI RADICAL AGAIN
        0x4E09, # G+615  U+4E09  uni4E09,  CJK UNIFIED IDEOGRAPH-4E09
        0x4E0B, # G+616  U+4E0B  uni4E0B,  CJK UNIFIED IDEOGRAPH-4E0B
        0x4E08, # G+617  U+4E08  uni4E08,  CJK UNIFIED IDEOGRAPH-4E08
        0x4E0A, # G+618  U+4E0A  uni4E0A,  CJK UNIFIED IDEOGRAPH-4E0A
        0x4E2B, # G+619  U+4E2B  uni4E2B,  CJK UNIFIED IDEOGRAPH-4E2B
        0x4E38, # G+620  U+4E38  uni4E38,  CJK UNIFIED IDEOGRAPH-4E38
        0x51E1, # G+621  U+51E1  uni51E1,  CJK UNIFIED IDEOGRAPH-51E1
        0x4E45, # G+622  U+4E45  uni4E45,  CJK UNIFIED IDEOGRAPH-4E45
        0x4E48, # G+623  U+4E48  uni4E48,  CJK UNIFIED IDEOGRAPH-4E48
        0x4E5F, # G+624  U+4E5F  uni4E5F,  CJK UNIFIED IDEOGRAPH-4E5F
        0x4E5E, # G+625  U+4E5E  uni4E5E,  CJK UNIFIED IDEOGRAPH-4E5E
        0x4E8E, # G+626  U+4E8E  uni4E8E,  CJK UNIFIED IDEOGRAPH-4E8E
        0x4EA1, # G+627  U+4EA1  uni4EA1,  CJK UNIFIED IDEOGRAPH-4EA1
        0x5140, # G+628  U+5140  uni5140,  CJK UNIFIED IDEOGRAPH-5140
        0x5203, # G+629  U+5203  uni5203,  CJK UNIFIED IDEOGRAPH-5203
        0x52FA, # G+630  U+52FA  uni52FA,  CJK UNIFIED IDEOGRAPH-52FA
        0x5343, # G+631  U+5343  uni5343,  CJK UNIFIED IDEOGRAPH-5343
        0x53C9, # G+632  U+53C9  uni53C9,  CJK UNIFIED IDEOGRAPH-53C9
        0x2F1D, # G+633  U+2F1D  uni2F1D,  KANGXI RADICAL MOUTH
        0x571F, # G+634  U+571F  uni571F,  CJK UNIFIED IDEOGRAPH-571F
        0x58EB, # G+635  U+58EB  uni58EB,  CJK UNIFIED IDEOGRAPH-58EB
        0x5915, # G+636  U+5915  uni5915,  CJK UNIFIED IDEOGRAPH-5915
        0x5927, # G+637  U+5927  uni5927,  CJK UNIFIED IDEOGRAPH-5927
        0x5973, # G+638  U+5973  uni5973,  CJK UNIFIED IDEOGRAPH-5973
        0x2F26, # G+639  U+2F26  uni2F26,  KANGXI RADICAL CHILD
        0x5B51, # G+640  U+5B51  uni5B51,  CJK UNIFIED IDEOGRAPH-5B51
        0x5B53, # G+641  U+5B53  uni5B53,  CJK UNIFIED IDEOGRAPH-5B53
        0x5BF8, # G+642  U+5BF8  uni5BF8,  CJK UNIFIED IDEOGRAPH-5BF8
        0x5C0F, # G+643  U+5C0F  uni5C0F,  CJK UNIFIED IDEOGRAPH-5C0F
        0x5C22, # G+644  U+5C22  uni5C22,  CJK UNIFIED IDEOGRAPH-5C22
        0x5C38, # G+645  U+5C38  uni5C38,  CJK UNIFIED IDEOGRAPH-5C38
        0x2F2D, # G+646  U+2F2D  uni2F2D,  KANGXI RADICAL MOUNTAIN
        0x5DDD, # G+647  U+5DDD  uni5DDD,  CJK UNIFIED IDEOGRAPH-5DDD
        0x5DE5, # G+648  U+5DE5  uni5DE5,  CJK UNIFIED IDEOGRAPH-5DE5
        0x2F30, # G+649  U+2F30  uni2F30,  KANGXI RADICAL ONESELF
        0x5DF2, # G+650  U+5DF2  uni5DF2,  CJK UNIFIED IDEOGRAPH-5DF2
        0x5DF3, # G+651  U+5DF3  uni5DF3,  CJK UNIFIED IDEOGRAPH-5DF3
        0x5DFE, # G+652  U+5DFE  uni5DFE,  CJK UNIFIED IDEOGRAPH-5DFE
        0x5E72, # G+653  U+5E72  uni5E72,  CJK UNIFIED IDEOGRAPH-5E72
        0x5EFE, # G+654  U+5EFE  uni5EFE,  CJK UNIFIED IDEOGRAPH-5EFE
        0x5F0B, # G+655  U+5F0B  uni5F0B,  CJK UNIFIED IDEOGRAPH-5F0B
        0x5F13, # G+656  U+5F13  uni5F13,  CJK UNIFIED IDEOGRAPH-5F13
        0x624D, # G+657  U+624D  uni624D,  CJK UNIFIED IDEOGRAPH-624D
        0x4E11, # G+658  U+4E11  uni4E11,  CJK UNIFIED IDEOGRAPH-4E11
        0x4E10, # G+659  U+4E10  uni4E10,  CJK UNIFIED IDEOGRAPH-4E10
        0x4E0D, # G+660  U+4E0D  uni4E0D,  CJK UNIFIED IDEOGRAPH-4E0D
        0x4E2D, # G+661  U+4E2D  uni4E2D,  CJK UNIFIED IDEOGRAPH-4E2D
        0x4E30, # G+662  U+4E30  uni4E30,  CJK UNIFIED IDEOGRAPH-4E30
        0x4E39, # G+663  U+4E39  uni4E39,  CJK UNIFIED IDEOGRAPH-4E39
        0x4E4B, # G+664  U+4E4B  uni4E4B,  CJK UNIFIED IDEOGRAPH-4E4B
        0x5C39, # G+665  U+5C39  uni5C39,  CJK UNIFIED IDEOGRAPH-5C39
        0x4E88, # G+666  U+4E88  uni4E88,  CJK UNIFIED IDEOGRAPH-4E88
        0x4E91, # G+667  U+4E91  uni4E91,  CJK UNIFIED IDEOGRAPH-4E91
        0x4E95, # G+668  U+4E95  uni4E95,  CJK UNIFIED IDEOGRAPH-4E95
        0x4E92, # G+669  U+4E92  uni4E92,  CJK UNIFIED IDEOGRAPH-4E92
        0x4E94, # G+670  U+4E94  uni4E94,  CJK UNIFIED IDEOGRAPH-4E94
        0x4EA2, # G+671  U+4EA2  uni4EA2,  CJK UNIFIED IDEOGRAPH-4EA2
        0x4EC1, # G+672  U+4EC1  uni4EC1,  CJK UNIFIED IDEOGRAPH-4EC1
        0x4EC0, # G+673  U+4EC0  uni4EC0,  CJK UNIFIED IDEOGRAPH-4EC0
        0x4EC3, # G+674  U+4EC3  uni4EC3,  CJK UNIFIED IDEOGRAPH-4EC3
        0x4EC6, # G+675  U+4EC6  uni4EC6,  CJK UNIFIED IDEOGRAPH-4EC6
        0x4EC7, # G+676  U+4EC7  uni4EC7,  CJK UNIFIED IDEOGRAPH-4EC7
        0x4ECD, # G+677  U+4ECD  uni4ECD,  CJK UNIFIED IDEOGRAPH-4ECD
        0x4ECA, # G+678  U+4ECA  uni4ECA,  CJK UNIFIED IDEOGRAPH-4ECA
        0x4ECB, # G+679  U+4ECB  uni4ECB,  CJK UNIFIED IDEOGRAPH-4ECB
        0x4EC4, # G+680  U+4EC4  uni4EC4,  CJK UNIFIED IDEOGRAPH-4EC4
        0x5143, # G+681  U+5143  uni5143,  CJK UNIFIED IDEOGRAPH-5143
        0x5141, # G+682  U+5141  uni5141,  CJK UNIFIED IDEOGRAPH-5141
        0x5167, # G+683  U+5167  uni5167,  CJK UNIFIED IDEOGRAPH-5167
        0x516D, # G+684  U+516D  uni516D,  CJK UNIFIED IDEOGRAPH-516D
        0x516E, # G+685  U+516E  uni516E,  CJK UNIFIED IDEOGRAPH-516E
        0x516C, # G+686  U+516C  uni516C,  CJK UNIFIED IDEOGRAPH-516C
        0x5197, # G+687  U+5197  uni5197,  CJK UNIFIED IDEOGRAPH-5197
        0x51F6, # G+688  U+51F6  uni51F6,  CJK UNIFIED IDEOGRAPH-51F6
        0x5206, # G+689  U+5206  uni5206,  CJK UNIFIED IDEOGRAPH-5206
        0x5207, # G+690  U+5207  uni5207,  CJK UNIFIED IDEOGRAPH-5207
        0x5208, # G+691  U+5208  uni5208,  CJK UNIFIED IDEOGRAPH-5208
        0x52FB, # G+692  U+52FB  uni52FB,  CJK UNIFIED IDEOGRAPH-52FB
        0x52FE, # G+693  U+52FE  uni52FE,  CJK UNIFIED IDEOGRAPH-52FE
        0x52FF, # G+694  U+52FF  uni52FF,  CJK UNIFIED IDEOGRAPH-52FF
        0x5316, # G+695  U+5316  uni5316,  CJK UNIFIED IDEOGRAPH-5316
        0x5339, # G+696  U+5339  uni5339,  CJK UNIFIED IDEOGRAPH-5339
        0x5348, # G+697  U+5348  uni5348,  CJK UNIFIED IDEOGRAPH-5348
        0x5347, # G+698  U+5347  uni5347,  CJK UNIFIED IDEOGRAPH-5347
        0x5345, # G+699  U+5345  uni5345,  CJK UNIFIED IDEOGRAPH-5345
        0x535E, # G+700  U+535E  uni535E,  CJK UNIFIED IDEOGRAPH-535E
        0x5384, # G+701  U+5384  uni5384,  CJK UNIFIED IDEOGRAPH-5384
        0x53CB, # G+702  U+53CB  uni53CB,  CJK UNIFIED IDEOGRAPH-53CB
        0x53CA, # G+703  U+53CA  uni53CA,  CJK UNIFIED IDEOGRAPH-53CA
        0x53CD, # G+704  U+53CD  uni53CD,  CJK UNIFIED IDEOGRAPH-53CD
        0x58EC, # G+705  U+58EC  uni58EC,  CJK UNIFIED IDEOGRAPH-58EC
        0x5929, # G+706  U+5929  uni5929,  CJK UNIFIED IDEOGRAPH-5929
        0x592B, # G+707  U+592B  uni592B,  CJK UNIFIED IDEOGRAPH-592B
        0x592A, # G+708  U+592A  uni592A,  CJK UNIFIED IDEOGRAPH-592A
        0x592D, # G+709  U+592D  uni592D,  CJK UNIFIED IDEOGRAPH-592D
        0x5B54, # G+710  U+5B54  uni5B54,  CJK UNIFIED IDEOGRAPH-5B54
        0x5C11, # G+711  U+5C11  uni5C11,  CJK UNIFIED IDEOGRAPH-5C11
        0x5C24, # G+712  U+5C24  uni5C24,  CJK UNIFIED IDEOGRAPH-5C24
        0x5C3A, # G+713  U+5C3A  uni5C3A,  CJK UNIFIED IDEOGRAPH-5C3A
        0x5C6F, # G+714  U+5C6F  uni5C6F,  CJK UNIFIED IDEOGRAPH-5C6F
        0x5DF4, # G+715  U+5DF4  uni5DF4,  CJK UNIFIED IDEOGRAPH-5DF4
        0x5E7B, # G+716  U+5E7B  uni5E7B,  CJK UNIFIED IDEOGRAPH-5E7B
        0x5EFF, # G+717  U+5EFF  uni5EFF,  CJK UNIFIED IDEOGRAPH-5EFF
        0x5F14, # G+718  U+5F14  uni5F14,  CJK UNIFIED IDEOGRAPH-5F14
        0x5F15, # G+719  U+5F15  uni5F15,  CJK UNIFIED IDEOGRAPH-5F15
        0x5FC3, # G+720  U+5FC3  uni5FC3,  CJK UNIFIED IDEOGRAPH-5FC3
        0x6208, # G+721  U+6208  uni6208,  CJK UNIFIED IDEOGRAPH-6208
        0x6236, # G+722  U+6236  uni6236,  CJK UNIFIED IDEOGRAPH-6236
        0x624B, # G+723  U+624B  uni624B,  CJK UNIFIED IDEOGRAPH-624B
        0x624E, # G+724  U+624E  uni624E,  CJK UNIFIED IDEOGRAPH-624E
        0x2F40, # G+725  U+2F40  uni2F40,  KANGXI RADICAL BRANCH
        0x6587, # G+726  U+6587  uni6587,  CJK UNIFIED IDEOGRAPH-6587
        0x6597, # G+727  U+6597  uni6597,  CJK UNIFIED IDEOGRAPH-6597
        0x65A4, # G+728  U+65A4  uni65A4,  CJK UNIFIED IDEOGRAPH-65A4
        0x65B9, # G+729  U+65B9  uni65B9,  CJK UNIFIED IDEOGRAPH-65B9
        0x65E5, # G+730  U+65E5  uni65E5,  CJK UNIFIED IDEOGRAPH-65E5
        0x66F0, # G+731  U+66F0  uni66F0,  CJK UNIFIED IDEOGRAPH-66F0
        0x6708, # G+732  U+6708  uni6708,  CJK UNIFIED IDEOGRAPH-6708
        0x6728, # G+733  U+6728  uni6728,  CJK UNIFIED IDEOGRAPH-6728
        0x6B20, # G+734  U+6B20  uni6B20,  CJK UNIFIED IDEOGRAPH-6B20
        0x6B62, # G+735  U+6B62  uni6B62,  CJK UNIFIED IDEOGRAPH-6B62
        0x6B79, # G+736  U+6B79  uni6B79,  CJK UNIFIED IDEOGRAPH-6B79
        0x6BCB, # G+737  U+6BCB  uni6BCB,  CJK UNIFIED IDEOGRAPH-6BCB
        0x6BD4, # G+738  U+6BD4  uni6BD4,  CJK UNIFIED IDEOGRAPH-6BD4
        0x6BDB, # G+739  U+6BDB  uni6BDB,  CJK UNIFIED IDEOGRAPH-6BDB
        0x6C0F, # G+740  U+6C0F  uni6C0F,  CJK UNIFIED IDEOGRAPH-6C0F
        0x6C34, # G+741  U+6C34  uni6C34,  CJK UNIFIED IDEOGRAPH-6C34
        0x706B, # G+742  U+706B  uni706B,  CJK UNIFIED IDEOGRAPH-706B
        0x722A, # G+743  U+722A  uni722A,  CJK UNIFIED IDEOGRAPH-722A
        0x7236, # G+744  U+7236  uni7236,  CJK UNIFIED IDEOGRAPH-7236
        0x723B, # G+745  U+723B  uni723B,  CJK UNIFIED IDEOGRAPH-723B
        0x7247, # G+746  U+7247  uni7247,  CJK UNIFIED IDEOGRAPH-7247
        0x7259, # G+747  U+7259  uni7259,  CJK UNIFIED IDEOGRAPH-7259
        0x725B, # G+748  U+725B  uni725B,  CJK UNIFIED IDEOGRAPH-725B
        0x72AC, # G+749  U+72AC  uni72AC,  CJK UNIFIED IDEOGRAPH-72AC
        0x738B, # G+750  U+738B  uni738B,  CJK UNIFIED IDEOGRAPH-738B
        0x4E19, # G+751  U+4E19  uni4E19,  CJK UNIFIED IDEOGRAPH-4E19
        0x4E16, # G+752  U+4E16  uni4E16,  CJK UNIFIED IDEOGRAPH-4E16
        0x4E15, # G+753  U+4E15  uni4E15,  CJK UNIFIED IDEOGRAPH-4E15
        0x4E14, # G+754  U+4E14  uni4E14,  CJK UNIFIED IDEOGRAPH-4E14
        0x4E18, # G+755  U+4E18  uni4E18,  CJK UNIFIED IDEOGRAPH-4E18
        0x4E3B, # G+756  U+4E3B  uni4E3B,  CJK UNIFIED IDEOGRAPH-4E3B
        0x4E4D, # G+757  U+4E4D  uni4E4D,  CJK UNIFIED IDEOGRAPH-4E4D
        0x4E4F, # G+758  U+4E4F  uni4E4F,  CJK UNIFIED IDEOGRAPH-4E4F
        0x4E4E, # G+759  U+4E4E  uni4E4E,  CJK UNIFIED IDEOGRAPH-4E4E
        0x4EE5, # G+760  U+4EE5  uni4EE5,  CJK UNIFIED IDEOGRAPH-4EE5
        0x4ED8, # G+761  U+4ED8  uni4ED8,  CJK UNIFIED IDEOGRAPH-4ED8
        0x4ED4, # G+762  U+4ED4  uni4ED4,  CJK UNIFIED IDEOGRAPH-4ED4
        0x4ED5, # G+763  U+4ED5  uni4ED5,  CJK UNIFIED IDEOGRAPH-4ED5
        0x4ED6, # G+764  U+4ED6  uni4ED6,  CJK UNIFIED IDEOGRAPH-4ED6
        0x4ED7, # G+765  U+4ED7  uni4ED7,  CJK UNIFIED IDEOGRAPH-4ED7
        0x4EE3, # G+766  U+4EE3  uni4EE3,  CJK UNIFIED IDEOGRAPH-4EE3
        0x4EE4, # G+767  U+4EE4  uni4EE4,  CJK UNIFIED IDEOGRAPH-4EE4
        0x4ED9, # G+768  U+4ED9  uni4ED9,  CJK UNIFIED IDEOGRAPH-4ED9
        0x4EDE, # G+769  U+4EDE  uni4EDE,  CJK UNIFIED IDEOGRAPH-4EDE
        0x5145, # G+770  U+5145  uni5145,  CJK UNIFIED IDEOGRAPH-5145
        0x5144, # G+771  U+5144  uni5144,  CJK UNIFIED IDEOGRAPH-5144
        0x5189, # G+772  U+5189  uni5189,  CJK UNIFIED IDEOGRAPH-5189
        0x518A, # G+773  U+518A  uni518A,  CJK UNIFIED IDEOGRAPH-518A
        0x51AC, # G+774  U+51AC  uni51AC,  CJK UNIFIED IDEOGRAPH-51AC
        0x51F9, # G+775  U+51F9  uni51F9,  CJK UNIFIED IDEOGRAPH-51F9
        0x51FA, # G+776  U+51FA  uni51FA,  CJK UNIFIED IDEOGRAPH-51FA
        0x51F8, # G+777  U+51F8  uni51F8,  CJK UNIFIED IDEOGRAPH-51F8
        0x520A, # G+778  U+520A  uni520A,  CJK UNIFIED IDEOGRAPH-520A
        0x52A0, # G+779  U+52A0  uni52A0,  CJK UNIFIED IDEOGRAPH-52A0
        0x529F, # G+780  U+529F  uni529F,  CJK UNIFIED IDEOGRAPH-529F
        0xE05B, # G+781  U+E05B  uniE05B,  
        0x5306, # G+782  U+5306  uni5306,  CJK UNIFIED IDEOGRAPH-5306
        0x5317, # G+783  U+5317  uni5317,  CJK UNIFIED IDEOGRAPH-5317
        0x531D, # G+784  U+531D  uni531D,  CJK UNIFIED IDEOGRAPH-531D
        0x4EDF, # G+785  U+4EDF  uni4EDF,  CJK UNIFIED IDEOGRAPH-4EDF
        0x534A, # G+786  U+534A  uni534A,  CJK UNIFIED IDEOGRAPH-534A
        0x5349, # G+787  U+5349  uni5349,  CJK UNIFIED IDEOGRAPH-5349
        0x5361, # G+788  U+5361  uni5361,  CJK UNIFIED IDEOGRAPH-5361
        0x5360, # G+789  U+5360  uni5360,  CJK UNIFIED IDEOGRAPH-5360
        0x536F, # G+790  U+536F  uni536F,  CJK UNIFIED IDEOGRAPH-536F
        0x536E, # G+791  U+536E  uni536E,  CJK UNIFIED IDEOGRAPH-536E
        0x53BB, # G+792  U+53BB  uni53BB,  CJK UNIFIED IDEOGRAPH-53BB
        0x53EF, # G+793  U+53EF  uni53EF,  CJK UNIFIED IDEOGRAPH-53EF
        0x53E4, # G+794  U+53E4  uni53E4,  CJK UNIFIED IDEOGRAPH-53E4
        0x53F3, # G+795  U+53F3  uni53F3,  CJK UNIFIED IDEOGRAPH-53F3
        0x53EC, # G+796  U+53EC  uni53EC,  CJK UNIFIED IDEOGRAPH-53EC
        0x53EE, # G+797  U+53EE  uni53EE,  CJK UNIFIED IDEOGRAPH-53EE
        0x53E9, # G+798  U+53E9  uni53E9,  CJK UNIFIED IDEOGRAPH-53E9
        0x53E8, # G+799  U+53E8  uni53E8,  CJK UNIFIED IDEOGRAPH-53E8
        0x53FC, # G+800  U+53FC  uni53FC,  CJK UNIFIED IDEOGRAPH-53FC
        0x53F8, # G+801  U+53F8  uni53F8,  CJK UNIFIED IDEOGRAPH-53F8
        0x53F5, # G+802  U+53F5  uni53F5,  CJK UNIFIED IDEOGRAPH-53F5
        0x53EB, # G+803  U+53EB  uni53EB,  CJK UNIFIED IDEOGRAPH-53EB
        0x53E6, # G+804  U+53E6  uni53E6,  CJK UNIFIED IDEOGRAPH-53E6
        0x53EA, # G+805  U+53EA  uni53EA,  CJK UNIFIED IDEOGRAPH-53EA
        0x53F2, # G+806  U+53F2  uni53F2,  CJK UNIFIED IDEOGRAPH-53F2
        0x53F1, # G+807  U+53F1  uni53F1,  CJK UNIFIED IDEOGRAPH-53F1
        0x53F0, # G+808  U+53F0  uni53F0,  CJK UNIFIED IDEOGRAPH-53F0
        0x53E5, # G+809  U+53E5  uni53E5,  CJK UNIFIED IDEOGRAPH-53E5
        0x53ED, # G+810  U+53ED  uni53ED,  CJK UNIFIED IDEOGRAPH-53ED
        0x53FB, # G+811  U+53FB  uni53FB,  CJK UNIFIED IDEOGRAPH-53FB
        0x56DB, # G+812  U+56DB  uni56DB,  CJK UNIFIED IDEOGRAPH-56DB
        0x56DA, # G+813  U+56DA  uni56DA,  CJK UNIFIED IDEOGRAPH-56DA
        0x5916, # G+814  U+5916  uni5916,  CJK UNIFIED IDEOGRAPH-5916
        0x592E, # G+815  U+592E  uni592E,  CJK UNIFIED IDEOGRAPH-592E
        0x5931, # G+816  U+5931  uni5931,  CJK UNIFIED IDEOGRAPH-5931
        0x5974, # G+817  U+5974  uni5974,  CJK UNIFIED IDEOGRAPH-5974
        0x5976, # G+818  U+5976  uni5976,  CJK UNIFIED IDEOGRAPH-5976
        0x5B55, # G+819  U+5B55  uni5B55,  CJK UNIFIED IDEOGRAPH-5B55
        0x5B83, # G+820  U+5B83  uni5B83,  CJK UNIFIED IDEOGRAPH-5B83
        0x5C3C, # G+821  U+5C3C  uni5C3C,  CJK UNIFIED IDEOGRAPH-5C3C
        0x5DE8, # G+822  U+5DE8  uni5DE8,  CJK UNIFIED IDEOGRAPH-5DE8
        0x5DE7, # G+823  U+5DE7  uni5DE7,  CJK UNIFIED IDEOGRAPH-5DE7
        0x5DE6, # G+824  U+5DE6  uni5DE6,  CJK UNIFIED IDEOGRAPH-5DE6
        0x5E02, # G+825  U+5E02  uni5E02,  CJK UNIFIED IDEOGRAPH-5E02
        0x5E03, # G+826  U+5E03  uni5E03,  CJK UNIFIED IDEOGRAPH-5E03
        0x5E73, # G+827  U+5E73  uni5E73,  CJK UNIFIED IDEOGRAPH-5E73
        0x5E7C, # G+828  U+5E7C  uni5E7C,  CJK UNIFIED IDEOGRAPH-5E7C
        0x5F01, # G+829  U+5F01  uni5F01,  CJK UNIFIED IDEOGRAPH-5F01
        0x5F18, # G+830  U+5F18  uni5F18,  CJK UNIFIED IDEOGRAPH-5F18
        0x5F17, # G+831  U+5F17  uni5F17,  CJK UNIFIED IDEOGRAPH-5F17
        0x5FC5, # G+832  U+5FC5  uni5FC5,  CJK UNIFIED IDEOGRAPH-5FC5
        0x620A, # G+833  U+620A  uni620A,  CJK UNIFIED IDEOGRAPH-620A
        0x6253, # G+834  U+6253  uni6253,  CJK UNIFIED IDEOGRAPH-6253
        0x6254, # G+835  U+6254  uni6254,  CJK UNIFIED IDEOGRAPH-6254
        0x6252, # G+836  U+6252  uni6252,  CJK UNIFIED IDEOGRAPH-6252
        0x6251, # G+837  U+6251  uni6251,  CJK UNIFIED IDEOGRAPH-6251
        0x65A5, # G+838  U+65A5  uni65A5,  CJK UNIFIED IDEOGRAPH-65A5
        0x65E6, # G+839  U+65E6  uni65E6,  CJK UNIFIED IDEOGRAPH-65E6
        0x672E, # G+840  U+672E  uni672E,  CJK UNIFIED IDEOGRAPH-672E
        0x672C, # G+841  U+672C  uni672C,  CJK UNIFIED IDEOGRAPH-672C
        0x672A, # G+842  U+672A  uni672A,  CJK UNIFIED IDEOGRAPH-672A
        0x672B, # G+843  U+672B  uni672B,  CJK UNIFIED IDEOGRAPH-672B
        0x672D, # G+844  U+672D  uni672D,  CJK UNIFIED IDEOGRAPH-672D
        0x6B63, # G+845  U+6B63  uni6B63,  CJK UNIFIED IDEOGRAPH-6B63
        0x6BCD, # G+846  U+6BCD  uni6BCD,  CJK UNIFIED IDEOGRAPH-6BCD
        0x6C11, # G+847  U+6C11  uni6C11,  CJK UNIFIED IDEOGRAPH-6C11
        0x6C10, # G+848  U+6C10  uni6C10,  CJK UNIFIED IDEOGRAPH-6C10
        0x6C38, # G+849  U+6C38  uni6C38,  CJK UNIFIED IDEOGRAPH-6C38
        0x6C41, # G+850  U+6C41  uni6C41,  CJK UNIFIED IDEOGRAPH-6C41
        0x6C40, # G+851  U+6C40  uni6C40,  CJK UNIFIED IDEOGRAPH-6C40
        0x6C3E, # G+852  U+6C3E  uni6C3E,  CJK UNIFIED IDEOGRAPH-6C3E
        0x72AF, # G+853  U+72AF  uni72AF,  CJK UNIFIED IDEOGRAPH-72AF
        0x7384, # G+854  U+7384  uni7384,  CJK UNIFIED IDEOGRAPH-7384
        0x7389, # G+855  U+7389  uni7389,  CJK UNIFIED IDEOGRAPH-7389
        0x74DC, # G+856  U+74DC  uni74DC,  CJK UNIFIED IDEOGRAPH-74DC
        0x74E6, # G+857  U+74E6  uni74E6,  CJK UNIFIED IDEOGRAPH-74E6
        0x7518, # G+858  U+7518  uni7518,  CJK UNIFIED IDEOGRAPH-7518
        0x751F, # G+859  U+751F  uni751F,  CJK UNIFIED IDEOGRAPH-751F
        0x2F64, # G+860  U+2F64  uni2F64,  KANGXI RADICAL USE
        0x7529, # G+861  U+7529  uni7529,  CJK UNIFIED IDEOGRAPH-7529
        0x2F65, # G+862  U+2F65  uni2F65,  KANGXI RADICAL FIELD
        0x7531, # G+863  U+7531  uni7531,  CJK UNIFIED IDEOGRAPH-7531
        0x7532, # G+864  U+7532  uni7532,  CJK UNIFIED IDEOGRAPH-7532
        0x7533, # G+865  U+7533  uni7533,  CJK UNIFIED IDEOGRAPH-7533
        0x2F66, # G+866  U+2F66  uni2F66,  KANGXI RADICAL BOLT OF CLOTH
        0x767D, # G+867  U+767D  uni767D,  CJK UNIFIED IDEOGRAPH-767D
        0x76AE, # G+868  U+76AE  uni76AE,  CJK UNIFIED IDEOGRAPH-76AE
        0x76BF, # G+869  U+76BF  uni76BF,  CJK UNIFIED IDEOGRAPH-76BF
        0x76EE, # G+870  U+76EE  uni76EE,  CJK UNIFIED IDEOGRAPH-76EE
        0x77DB, # G+871  U+77DB  uni77DB,  CJK UNIFIED IDEOGRAPH-77DB
        0x77E2, # G+872  U+77E2  uni77E2,  CJK UNIFIED IDEOGRAPH-77E2
        0x77F3, # G+873  U+77F3  uni77F3,  CJK UNIFIED IDEOGRAPH-77F3
        0x793A, # G+874  U+793A  uni793A,  CJK UNIFIED IDEOGRAPH-793A
        0x79BE, # G+875  U+79BE  uni79BE,  CJK UNIFIED IDEOGRAPH-79BE
        0x7A74, # G+876  U+7A74  uni7A74,  CJK UNIFIED IDEOGRAPH-7A74
        0x7ACB, # G+877  U+7ACB  uni7ACB,  CJK UNIFIED IDEOGRAPH-7ACB
        0x4E1E, # G+878  U+4E1E  uni4E1E,  CJK UNIFIED IDEOGRAPH-4E1E
        0x4E1F, # G+879  U+4E1F  uni4E1F,  CJK UNIFIED IDEOGRAPH-4E1F
        0x4E52, # G+880  U+4E52  uni4E52,  CJK UNIFIED IDEOGRAPH-4E52
        0x4E53, # G+881  U+4E53  uni4E53,  CJK UNIFIED IDEOGRAPH-4E53
        0x4E69, # G+882  U+4E69  uni4E69,  CJK UNIFIED IDEOGRAPH-4E69
        0x4E99, # G+883  U+4E99  uni4E99,  CJK UNIFIED IDEOGRAPH-4E99
        0x4EA4, # G+884  U+4EA4  uni4EA4,  CJK UNIFIED IDEOGRAPH-4EA4
        0x4EA6, # G+885  U+4EA6  uni4EA6,  CJK UNIFIED IDEOGRAPH-4EA6
        0x4EA5, # G+886  U+4EA5  uni4EA5,  CJK UNIFIED IDEOGRAPH-4EA5
        0x4EFF, # G+887  U+4EFF  uni4EFF,  CJK UNIFIED IDEOGRAPH-4EFF
        0x4F09, # G+888  U+4F09  uni4F09,  CJK UNIFIED IDEOGRAPH-4F09
        0x4F19, # G+889  U+4F19  uni4F19,  CJK UNIFIED IDEOGRAPH-4F19
        0x4F0A, # G+890  U+4F0A  uni4F0A,  CJK UNIFIED IDEOGRAPH-4F0A
        0x4F15, # G+891  U+4F15  uni4F15,  CJK UNIFIED IDEOGRAPH-4F15
        0x4F0D, # G+892  U+4F0D  uni4F0D,  CJK UNIFIED IDEOGRAPH-4F0D
        0x4F10, # G+893  U+4F10  uni4F10,  CJK UNIFIED IDEOGRAPH-4F10
        0x4F11, # G+894  U+4F11  uni4F11,  CJK UNIFIED IDEOGRAPH-4F11
        0x4F0F, # G+895  U+4F0F  uni4F0F,  CJK UNIFIED IDEOGRAPH-4F0F
        0x4EF2, # G+896  U+4EF2  uni4EF2,  CJK UNIFIED IDEOGRAPH-4EF2
        0x4EF6, # G+897  U+4EF6  uni4EF6,  CJK UNIFIED IDEOGRAPH-4EF6
        0x4EFB, # G+898  U+4EFB  uni4EFB,  CJK UNIFIED IDEOGRAPH-4EFB
        0x4EF0, # G+899  U+4EF0  uni4EF0,  CJK UNIFIED IDEOGRAPH-4EF0
        0x4EF3, # G+900  U+4EF3  uni4EF3,  CJK UNIFIED IDEOGRAPH-4EF3
        0x4EFD, # G+901  U+4EFD  uni4EFD,  CJK UNIFIED IDEOGRAPH-4EFD
        0x4F01, # G+902  U+4F01  uni4F01,  CJK UNIFIED IDEOGRAPH-4F01
        0x4F0B, # G+903  U+4F0B  uni4F0B,  CJK UNIFIED IDEOGRAPH-4F0B
        0x5149, # G+904  U+5149  uni5149,  CJK UNIFIED IDEOGRAPH-5149
        0x5147, # G+905  U+5147  uni5147,  CJK UNIFIED IDEOGRAPH-5147
        0x5146, # G+906  U+5146  uni5146,  CJK UNIFIED IDEOGRAPH-5146
        0x5148, # G+907  U+5148  uni5148,  CJK UNIFIED IDEOGRAPH-5148
        0x5168, # G+908  U+5168  uni5168,  CJK UNIFIED IDEOGRAPH-5168
        0x5171, # G+909  U+5171  uni5171,  CJK UNIFIED IDEOGRAPH-5171
        0x518D, # G+910  U+518D  uni518D,  CJK UNIFIED IDEOGRAPH-518D
        0x51B0, # G+911  U+51B0  uni51B0,  CJK UNIFIED IDEOGRAPH-51B0
        0x5217, # G+912  U+5217  uni5217,  CJK UNIFIED IDEOGRAPH-5217
        0x5211, # G+913  U+5211  uni5211,  CJK UNIFIED IDEOGRAPH-5211
        0x5212, # G+914  U+5212  uni5212,  CJK UNIFIED IDEOGRAPH-5212
        0x520E, # G+915  U+520E  uni520E,  CJK UNIFIED IDEOGRAPH-520E
        0x5216, # G+916  U+5216  uni5216,  CJK UNIFIED IDEOGRAPH-5216
        0x52A3, # G+917  U+52A3  uni52A3,  CJK UNIFIED IDEOGRAPH-52A3
        0x5308, # G+918  U+5308  uni5308,  CJK UNIFIED IDEOGRAPH-5308
        0x5321, # G+919  U+5321  uni5321,  CJK UNIFIED IDEOGRAPH-5321
        0x5320, # G+920  U+5320  uni5320,  CJK UNIFIED IDEOGRAPH-5320
        0x5370, # G+921  U+5370  uni5370,  CJK UNIFIED IDEOGRAPH-5370
        0x5371, # G+922  U+5371  uni5371,  CJK UNIFIED IDEOGRAPH-5371
        0x5409, # G+923  U+5409  uni5409,  CJK UNIFIED IDEOGRAPH-5409
        0x540F, # G+924  U+540F  uni540F,  CJK UNIFIED IDEOGRAPH-540F
        0x540C, # G+925  U+540C  uni540C,  CJK UNIFIED IDEOGRAPH-540C
        0x540A, # G+926  U+540A  uni540A,  CJK UNIFIED IDEOGRAPH-540A
        0x5410, # G+927  U+5410  uni5410,  CJK UNIFIED IDEOGRAPH-5410
        0x5401, # G+928  U+5401  uni5401,  CJK UNIFIED IDEOGRAPH-5401
        0x540B, # G+929  U+540B  uni540B,  CJK UNIFIED IDEOGRAPH-540B
        0x5404, # G+930  U+5404  uni5404,  CJK UNIFIED IDEOGRAPH-5404
        0x5411, # G+931  U+5411  uni5411,  CJK UNIFIED IDEOGRAPH-5411
        0x540D, # G+932  U+540D  uni540D,  CJK UNIFIED IDEOGRAPH-540D
        0x5408, # G+933  U+5408  uni5408,  CJK UNIFIED IDEOGRAPH-5408
        0x5403, # G+934  U+5403  uni5403,  CJK UNIFIED IDEOGRAPH-5403
        0x540E, # G+935  U+540E  uni540E,  CJK UNIFIED IDEOGRAPH-540E
        0x5406, # G+936  U+5406  uni5406,  CJK UNIFIED IDEOGRAPH-5406
        0x5412, # G+937  U+5412  uni5412,  CJK UNIFIED IDEOGRAPH-5412
        0x56E0, # G+938  U+56E0  uni56E0,  CJK UNIFIED IDEOGRAPH-56E0
        0x56DE, # G+939  U+56DE  uni56DE,  CJK UNIFIED IDEOGRAPH-56DE
        0x56DD, # G+940  U+56DD  uni56DD,  CJK UNIFIED IDEOGRAPH-56DD
        0x5733, # G+941  U+5733  uni5733,  CJK UNIFIED IDEOGRAPH-5733
        0x5730, # G+942  U+5730  uni5730,  CJK UNIFIED IDEOGRAPH-5730
        0x5728, # G+943  U+5728  uni5728,  CJK UNIFIED IDEOGRAPH-5728
        0x572D, # G+944  U+572D  uni572D,  CJK UNIFIED IDEOGRAPH-572D
        0x572C, # G+945  U+572C  uni572C,  CJK UNIFIED IDEOGRAPH-572C
        0x572F, # G+946  U+572F  uni572F,  CJK UNIFIED IDEOGRAPH-572F
        0x5729, # G+947  U+5729  uni5729,  CJK UNIFIED IDEOGRAPH-5729
        0x5919, # G+948  U+5919  uni5919,  CJK UNIFIED IDEOGRAPH-5919
        0x591A, # G+949  U+591A  uni591A,  CJK UNIFIED IDEOGRAPH-591A
        0x5937, # G+950  U+5937  uni5937,  CJK UNIFIED IDEOGRAPH-5937
        0x5938, # G+951  U+5938  uni5938,  CJK UNIFIED IDEOGRAPH-5938
        0x5984, # G+952  U+5984  uni5984,  CJK UNIFIED IDEOGRAPH-5984
        0x5978, # G+953  U+5978  uni5978,  CJK UNIFIED IDEOGRAPH-5978
        0x5983, # G+954  U+5983  uni5983,  CJK UNIFIED IDEOGRAPH-5983
        0x597D, # G+955  U+597D  uni597D,  CJK UNIFIED IDEOGRAPH-597D
        0x5979, # G+956  U+5979  uni5979,  CJK UNIFIED IDEOGRAPH-5979
        0x5982, # G+957  U+5982  uni5982,  CJK UNIFIED IDEOGRAPH-5982
        0x5981, # G+958  U+5981  uni5981,  CJK UNIFIED IDEOGRAPH-5981
        0x5B57, # G+959  U+5B57  uni5B57,  CJK UNIFIED IDEOGRAPH-5B57
        0x5B58, # G+960  U+5B58  uni5B58,  CJK UNIFIED IDEOGRAPH-5B58
        0x5B87, # G+961  U+5B87  uni5B87,  CJK UNIFIED IDEOGRAPH-5B87
        0x5B88, # G+962  U+5B88  uni5B88,  CJK UNIFIED IDEOGRAPH-5B88
        0x5B85, # G+963  U+5B85  uni5B85,  CJK UNIFIED IDEOGRAPH-5B85
        0x5B89, # G+964  U+5B89  uni5B89,  CJK UNIFIED IDEOGRAPH-5B89
        0x5BFA, # G+965  U+5BFA  uni5BFA,  CJK UNIFIED IDEOGRAPH-5BFA
        0x5C16, # G+966  U+5C16  uni5C16,  CJK UNIFIED IDEOGRAPH-5C16
        0x5C79, # G+967  U+5C79  uni5C79,  CJK UNIFIED IDEOGRAPH-5C79
        0x5DDE, # G+968  U+5DDE  uni5DDE,  CJK UNIFIED IDEOGRAPH-5DDE
        0x5E06, # G+969  U+5E06  uni5E06,  CJK UNIFIED IDEOGRAPH-5E06
        0x5E76, # G+970  U+5E76  uni5E76,  CJK UNIFIED IDEOGRAPH-5E76
        0x5E74, # G+971  U+5E74  uni5E74,  CJK UNIFIED IDEOGRAPH-5E74
        0x5F0F, # G+972  U+5F0F  uni5F0F,  CJK UNIFIED IDEOGRAPH-5F0F
        0x5F1B, # G+973  U+5F1B  uni5F1B,  CJK UNIFIED IDEOGRAPH-5F1B
        0x5FD9, # G+974  U+5FD9  uni5FD9,  CJK UNIFIED IDEOGRAPH-5FD9
        0x5FD6, # G+975  U+5FD6  uni5FD6,  CJK UNIFIED IDEOGRAPH-5FD6
        0x620E, # G+976  U+620E  uni620E,  CJK UNIFIED IDEOGRAPH-620E
        0x620C, # G+977  U+620C  uni620C,  CJK UNIFIED IDEOGRAPH-620C
        0x620D, # G+978  U+620D  uni620D,  CJK UNIFIED IDEOGRAPH-620D
        0x6210, # G+979  U+6210  uni6210,  CJK UNIFIED IDEOGRAPH-6210
        0x6263, # G+980  U+6263  uni6263,  CJK UNIFIED IDEOGRAPH-6263
        0x625B, # G+981  U+625B  uni625B,  CJK UNIFIED IDEOGRAPH-625B
        0x6258, # G+982  U+6258  uni6258,  CJK UNIFIED IDEOGRAPH-6258
        0x6536, # G+983  U+6536  uni6536,  CJK UNIFIED IDEOGRAPH-6536
        0x65E9, # G+984  U+65E9  uni65E9,  CJK UNIFIED IDEOGRAPH-65E9
        0x65E8, # G+985  U+65E8  uni65E8,  CJK UNIFIED IDEOGRAPH-65E8
        0x65EC, # G+986  U+65EC  uni65EC,  CJK UNIFIED IDEOGRAPH-65EC
        0x65ED, # G+987  U+65ED  uni65ED,  CJK UNIFIED IDEOGRAPH-65ED
        0x66F2, # G+988  U+66F2  uni66F2,  CJK UNIFIED IDEOGRAPH-66F2
        0x66F3, # G+989  U+66F3  uni66F3,  CJK UNIFIED IDEOGRAPH-66F3
        0x6709, # G+990  U+6709  uni6709,  CJK UNIFIED IDEOGRAPH-6709
        0x673D, # G+991  U+673D  uni673D,  CJK UNIFIED IDEOGRAPH-673D
        0x6734, # G+992  U+6734  uni6734,  CJK UNIFIED IDEOGRAPH-6734
        0x6731, # G+993  U+6731  uni6731,  CJK UNIFIED IDEOGRAPH-6731
        0x6735, # G+994  U+6735  uni6735,  CJK UNIFIED IDEOGRAPH-6735
        0x6B21, # G+995  U+6B21  uni6B21,  CJK UNIFIED IDEOGRAPH-6B21
        0x6B64, # G+996  U+6B64  uni6B64,  CJK UNIFIED IDEOGRAPH-6B64
        0x6B7B, # G+997  U+6B7B  uni6B7B,  CJK UNIFIED IDEOGRAPH-6B7B
        0x6C16, # G+998  U+6C16  uni6C16,  CJK UNIFIED IDEOGRAPH-6C16
        0x6C5D, # G+999  U+6C5D  uni6C5D,  CJK UNIFIED IDEOGRAPH-6C5D
        0x6C57, # G+1000  U+6C57  uni6C57,  CJK UNIFIED IDEOGRAPH-6C57
        0x6C59, # G+1001  U+6C59  uni6C59,  CJK UNIFIED IDEOGRAPH-6C59
        0x6C5F, # G+1002  U+6C5F  uni6C5F,  CJK UNIFIED IDEOGRAPH-6C5F
        0x6C60, # G+1003  U+6C60  uni6C60,  CJK UNIFIED IDEOGRAPH-6C60
        0x6C50, # G+1004  U+6C50  uni6C50,  CJK UNIFIED IDEOGRAPH-6C50
        0x6C55, # G+1005  U+6C55  uni6C55,  CJK UNIFIED IDEOGRAPH-6C55
        0x6C61, # G+1006  U+6C61  uni6C61,  CJK UNIFIED IDEOGRAPH-6C61
        0x6C5B, # G+1007  U+6C5B  uni6C5B,  CJK UNIFIED IDEOGRAPH-6C5B
        0x6C4D, # G+1008  U+6C4D  uni6C4D,  CJK UNIFIED IDEOGRAPH-6C4D
        0x6C4E, # G+1009  U+6C4E  uni6C4E,  CJK UNIFIED IDEOGRAPH-6C4E
        0x7070, # G+1010  U+7070  uni7070,  CJK UNIFIED IDEOGRAPH-7070
        0x725F, # G+1011  U+725F  uni725F,  CJK UNIFIED IDEOGRAPH-725F
        0x725D, # G+1012  U+725D  uni725D,  CJK UNIFIED IDEOGRAPH-725D
        0x767E, # G+1013  U+767E  uni767E,  CJK UNIFIED IDEOGRAPH-767E
        0x7AF9, # G+1014  U+7AF9  uni7AF9,  CJK UNIFIED IDEOGRAPH-7AF9
        0x7C73, # G+1015  U+7C73  uni7C73,  CJK UNIFIED IDEOGRAPH-7C73
        0x7CF8, # G+1016  U+7CF8  uni7CF8,  CJK UNIFIED IDEOGRAPH-7CF8
        0x7F36, # G+1017  U+7F36  uni7F36,  CJK UNIFIED IDEOGRAPH-7F36
        0x7F8A, # G+1018  U+7F8A  uni7F8A,  CJK UNIFIED IDEOGRAPH-7F8A
        0x7FBD, # G+1019  U+7FBD  uni7FBD,  CJK UNIFIED IDEOGRAPH-7FBD
        0x8001, # G+1020  U+8001  uni8001,  CJK UNIFIED IDEOGRAPH-8001
        0x8003, # G+1021  U+8003  uni8003,  CJK UNIFIED IDEOGRAPH-8003
        0x800C, # G+1022  U+800C  uni800C,  CJK UNIFIED IDEOGRAPH-800C
        0x8012, # G+1023  U+8012  uni8012,  CJK UNIFIED IDEOGRAPH-8012
        0x8033, # G+1024  U+8033  uni8033,  CJK UNIFIED IDEOGRAPH-8033
        0x807F, # G+1025  U+807F  uni807F,  CJK UNIFIED IDEOGRAPH-807F
        0x8089, # G+1026  U+8089  uni8089,  CJK UNIFIED IDEOGRAPH-8089
        0x808B, # G+1027  U+808B  uni808B,  CJK UNIFIED IDEOGRAPH-808B
        0x808C, # G+1028  U+808C  uni808C,  CJK UNIFIED IDEOGRAPH-808C
        0x81E3, # G+1029  U+81E3  uni81E3,  CJK UNIFIED IDEOGRAPH-81E3
        0x81EA, # G+1030  U+81EA  uni81EA,  CJK UNIFIED IDEOGRAPH-81EA
        0x81F3, # G+1031  U+81F3  uni81F3,  CJK UNIFIED IDEOGRAPH-81F3
        0x81FC, # G+1032  U+81FC  uni81FC,  CJK UNIFIED IDEOGRAPH-81FC
        0x820C, # G+1033  U+820C  uni820C,  CJK UNIFIED IDEOGRAPH-820C
        0x821B, # G+1034  U+821B  uni821B,  CJK UNIFIED IDEOGRAPH-821B
        0x821F, # G+1035  U+821F  uni821F,  CJK UNIFIED IDEOGRAPH-821F
        0x826E, # G+1036  U+826E  uni826E,  CJK UNIFIED IDEOGRAPH-826E
        0x8272, # G+1037  U+8272  uni8272,  CJK UNIFIED IDEOGRAPH-8272
        0x827E, # G+1038  U+827E  uni827E,  CJK UNIFIED IDEOGRAPH-827E
        0x866B, # G+1039  U+866B  uni866B,  CJK UNIFIED IDEOGRAPH-866B
        0x8840, # G+1040  U+8840  uni8840,  CJK UNIFIED IDEOGRAPH-8840
        0x884C, # G+1041  U+884C  uni884C,  CJK UNIFIED IDEOGRAPH-884C
        0x8863, # G+1042  U+8863  uni8863,  CJK UNIFIED IDEOGRAPH-8863
        0x897F, # G+1043  U+897F  uni897F,  CJK UNIFIED IDEOGRAPH-897F
        0x9621, # G+1044  U+9621  uni9621,  CJK UNIFIED IDEOGRAPH-9621
        0x4E32, # G+1045  U+4E32  uni4E32,  CJK UNIFIED IDEOGRAPH-4E32
        0x4EA8, # G+1046  U+4EA8  uni4EA8,  CJK UNIFIED IDEOGRAPH-4EA8
        0x4F4D, # G+1047  U+4F4D  uni4F4D,  CJK UNIFIED IDEOGRAPH-4F4D
        0x4F4F, # G+1048  U+4F4F  uni4F4F,  CJK UNIFIED IDEOGRAPH-4F4F
        0x4F47, # G+1049  U+4F47  uni4F47,  CJK UNIFIED IDEOGRAPH-4F47
        0x4F57, # G+1050  U+4F57  uni4F57,  CJK UNIFIED IDEOGRAPH-4F57
        0x4F5E, # G+1051  U+4F5E  uni4F5E,  CJK UNIFIED IDEOGRAPH-4F5E
        0x4F34, # G+1052  U+4F34  uni4F34,  CJK UNIFIED IDEOGRAPH-4F34
        0x4F5B, # G+1053  U+4F5B  uni4F5B,  CJK UNIFIED IDEOGRAPH-4F5B
        0x4F55, # G+1054  U+4F55  uni4F55,  CJK UNIFIED IDEOGRAPH-4F55
        0x4F30, # G+1055  U+4F30  uni4F30,  CJK UNIFIED IDEOGRAPH-4F30
        0x4F50, # G+1056  U+4F50  uni4F50,  CJK UNIFIED IDEOGRAPH-4F50
        0x4F51, # G+1057  U+4F51  uni4F51,  CJK UNIFIED IDEOGRAPH-4F51
        0x4F3D, # G+1058  U+4F3D  uni4F3D,  CJK UNIFIED IDEOGRAPH-4F3D
        0x4F3A, # G+1059  U+4F3A  uni4F3A,  CJK UNIFIED IDEOGRAPH-4F3A
        0x4F38, # G+1060  U+4F38  uni4F38,  CJK UNIFIED IDEOGRAPH-4F38
        0x4F43, # G+1061  U+4F43  uni4F43,  CJK UNIFIED IDEOGRAPH-4F43
        0x4F54, # G+1062  U+4F54  uni4F54,  CJK UNIFIED IDEOGRAPH-4F54
        0x4F3C, # G+1063  U+4F3C  uni4F3C,  CJK UNIFIED IDEOGRAPH-4F3C
        0x4F46, # G+1064  U+4F46  uni4F46,  CJK UNIFIED IDEOGRAPH-4F46
        0x4F63, # G+1065  U+4F63  uni4F63,  CJK UNIFIED IDEOGRAPH-4F63
        0x4F5C, # G+1066  U+4F5C  uni4F5C,  CJK UNIFIED IDEOGRAPH-4F5C
        0x4F60, # G+1067  U+4F60  uni4F60,  CJK UNIFIED IDEOGRAPH-4F60
        0x4F2F, # G+1068  U+4F2F  uni4F2F,  CJK UNIFIED IDEOGRAPH-4F2F
        0x4F4E, # G+1069  U+4F4E  uni4F4E,  CJK UNIFIED IDEOGRAPH-4F4E
        0x4F36, # G+1070  U+4F36  uni4F36,  CJK UNIFIED IDEOGRAPH-4F36
        0x4F59, # G+1071  U+4F59  uni4F59,  CJK UNIFIED IDEOGRAPH-4F59
        0x4F5D, # G+1072  U+4F5D  uni4F5D,  CJK UNIFIED IDEOGRAPH-4F5D
        0x4F48, # G+1073  U+4F48  uni4F48,  CJK UNIFIED IDEOGRAPH-4F48
        0x4F5A, # G+1074  U+4F5A  uni4F5A,  CJK UNIFIED IDEOGRAPH-4F5A
        0x514C, # G+1075  U+514C  uni514C,  CJK UNIFIED IDEOGRAPH-514C
        0x514B, # G+1076  U+514B  uni514B,  CJK UNIFIED IDEOGRAPH-514B
        0x514D, # G+1077  U+514D  uni514D,  CJK UNIFIED IDEOGRAPH-514D
        0x5175, # G+1078  U+5175  uni5175,  CJK UNIFIED IDEOGRAPH-5175
        0x51B6, # G+1079  U+51B6  uni51B6,  CJK UNIFIED IDEOGRAPH-51B6
        0x51B7, # G+1080  U+51B7  uni51B7,  CJK UNIFIED IDEOGRAPH-51B7
        0x5225, # G+1081  U+5225  uni5225,  CJK UNIFIED IDEOGRAPH-5225
        0x5224, # G+1082  U+5224  uni5224,  CJK UNIFIED IDEOGRAPH-5224
        0x5229, # G+1083  U+5229  uni5229,  CJK UNIFIED IDEOGRAPH-5229
        0x522A, # G+1084  U+522A  uni522A,  CJK UNIFIED IDEOGRAPH-522A
        0x5228, # G+1085  U+5228  uni5228,  CJK UNIFIED IDEOGRAPH-5228
        0x52AB, # G+1086  U+52AB  uni52AB,  CJK UNIFIED IDEOGRAPH-52AB
        0x52A9, # G+1087  U+52A9  uni52A9,  CJK UNIFIED IDEOGRAPH-52A9
        0x52AA, # G+1088  U+52AA  uni52AA,  CJK UNIFIED IDEOGRAPH-52AA
        0x52AC, # G+1089  U+52AC  uni52AC,  CJK UNIFIED IDEOGRAPH-52AC
        0x5323, # G+1090  U+5323  uni5323,  CJK UNIFIED IDEOGRAPH-5323
        0x5373, # G+1091  U+5373  uni5373,  CJK UNIFIED IDEOGRAPH-5373
        0x5375, # G+1092  U+5375  uni5375,  CJK UNIFIED IDEOGRAPH-5375
        0x541D, # G+1093  U+541D  uni541D,  CJK UNIFIED IDEOGRAPH-541D
        0x542D, # G+1094  U+542D  uni542D,  CJK UNIFIED IDEOGRAPH-542D
        0x541E, # G+1095  U+541E  uni541E,  CJK UNIFIED IDEOGRAPH-541E
        0x543E, # G+1096  U+543E  uni543E,  CJK UNIFIED IDEOGRAPH-543E
        0x5426, # G+1097  U+5426  uni5426,  CJK UNIFIED IDEOGRAPH-5426
        0x544E, # G+1098  U+544E  uni544E,  CJK UNIFIED IDEOGRAPH-544E
        0x5427, # G+1099  U+5427  uni5427,  CJK UNIFIED IDEOGRAPH-5427
        0x5446, # G+1100  U+5446  uni5446,  CJK UNIFIED IDEOGRAPH-5446
        0x5443, # G+1101  U+5443  uni5443,  CJK UNIFIED IDEOGRAPH-5443
        0x5433, # G+1102  U+5433  uni5433,  CJK UNIFIED IDEOGRAPH-5433
        0x5448, # G+1103  U+5448  uni5448,  CJK UNIFIED IDEOGRAPH-5448
        0x5442, # G+1104  U+5442  uni5442,  CJK UNIFIED IDEOGRAPH-5442
        0x541B, # G+1105  U+541B  uni541B,  CJK UNIFIED IDEOGRAPH-541B
        0x5429, # G+1106  U+5429  uni5429,  CJK UNIFIED IDEOGRAPH-5429
        0x544A, # G+1107  U+544A  uni544A,  CJK UNIFIED IDEOGRAPH-544A
        0x5439, # G+1108  U+5439  uni5439,  CJK UNIFIED IDEOGRAPH-5439
        0x543B, # G+1109  U+543B  uni543B,  CJK UNIFIED IDEOGRAPH-543B
        0x5438, # G+1110  U+5438  uni5438,  CJK UNIFIED IDEOGRAPH-5438
        0x542E, # G+1111  U+542E  uni542E,  CJK UNIFIED IDEOGRAPH-542E
        0x5435, # G+1112  U+5435  uni5435,  CJK UNIFIED IDEOGRAPH-5435
        0x5436, # G+1113  U+5436  uni5436,  CJK UNIFIED IDEOGRAPH-5436
        0x5420, # G+1114  U+5420  uni5420,  CJK UNIFIED IDEOGRAPH-5420
        0x543C, # G+1115  U+543C  uni543C,  CJK UNIFIED IDEOGRAPH-543C
        0x5440, # G+1116  U+5440  uni5440,  CJK UNIFIED IDEOGRAPH-5440
        0x5431, # G+1117  U+5431  uni5431,  CJK UNIFIED IDEOGRAPH-5431
        0x542B, # G+1118  U+542B  uni542B,  CJK UNIFIED IDEOGRAPH-542B
        0x541F, # G+1119  U+541F  uni541F,  CJK UNIFIED IDEOGRAPH-541F
        0x542C, # G+1120  U+542C  uni542C,  CJK UNIFIED IDEOGRAPH-542C
        0x56EA, # G+1121  U+56EA  uni56EA,  CJK UNIFIED IDEOGRAPH-56EA
        0x56F0, # G+1122  U+56F0  uni56F0,  CJK UNIFIED IDEOGRAPH-56F0
        0x56E4, # G+1123  U+56E4  uni56E4,  CJK UNIFIED IDEOGRAPH-56E4
        0x56EB, # G+1124  U+56EB  uni56EB,  CJK UNIFIED IDEOGRAPH-56EB
        0x574A, # G+1125  U+574A  uni574A,  CJK UNIFIED IDEOGRAPH-574A
        0x5751, # G+1126  U+5751  uni5751,  CJK UNIFIED IDEOGRAPH-5751
        0x5740, # G+1127  U+5740  uni5740,  CJK UNIFIED IDEOGRAPH-5740
        0x574D, # G+1128  U+574D  uni574D,  CJK UNIFIED IDEOGRAPH-574D
        0x5747, # G+1129  U+5747  uni5747,  CJK UNIFIED IDEOGRAPH-5747
        0x574E, # G+1130  U+574E  uni574E,  CJK UNIFIED IDEOGRAPH-574E
        0x573E, # G+1131  U+573E  uni573E,  CJK UNIFIED IDEOGRAPH-573E
        0x5750, # G+1132  U+5750  uni5750,  CJK UNIFIED IDEOGRAPH-5750
        0x574F, # G+1133  U+574F  uni574F,  CJK UNIFIED IDEOGRAPH-574F
        0x573B, # G+1134  U+573B  uni573B,  CJK UNIFIED IDEOGRAPH-573B
        0x58EF, # G+1135  U+58EF  uni58EF,  CJK UNIFIED IDEOGRAPH-58EF
        0x593E, # G+1136  U+593E  uni593E,  CJK UNIFIED IDEOGRAPH-593E
        0x599D, # G+1137  U+599D  uni599D,  CJK UNIFIED IDEOGRAPH-599D
        0x5992, # G+1138  U+5992  uni5992,  CJK UNIFIED IDEOGRAPH-5992
        0x59A8, # G+1139  U+59A8  uni59A8,  CJK UNIFIED IDEOGRAPH-59A8
        0x599E, # G+1140  U+599E  uni599E,  CJK UNIFIED IDEOGRAPH-599E
        0x59A3, # G+1141  U+59A3  uni59A3,  CJK UNIFIED IDEOGRAPH-59A3
        0x5999, # G+1142  U+5999  uni5999,  CJK UNIFIED IDEOGRAPH-5999
        0x5996, # G+1143  U+5996  uni5996,  CJK UNIFIED IDEOGRAPH-5996
        0x598D, # G+1144  U+598D  uni598D,  CJK UNIFIED IDEOGRAPH-598D
        0x59A4, # G+1145  U+59A4  uni59A4,  CJK UNIFIED IDEOGRAPH-59A4
        0x5993, # G+1146  U+5993  uni5993,  CJK UNIFIED IDEOGRAPH-5993
        0x598A, # G+1147  U+598A  uni598A,  CJK UNIFIED IDEOGRAPH-598A
        0x59A5, # G+1148  U+59A5  uni59A5,  CJK UNIFIED IDEOGRAPH-59A5
        0x5B5D, # G+1149  U+5B5D  uni5B5D,  CJK UNIFIED IDEOGRAPH-5B5D
        0x5B5C, # G+1150  U+5B5C  uni5B5C,  CJK UNIFIED IDEOGRAPH-5B5C
        0x5B5A, # G+1151  U+5B5A  uni5B5A,  CJK UNIFIED IDEOGRAPH-5B5A
        0x5B5B, # G+1152  U+5B5B  uni5B5B,  CJK UNIFIED IDEOGRAPH-5B5B
        0x5B8C, # G+1153  U+5B8C  uni5B8C,  CJK UNIFIED IDEOGRAPH-5B8C
        0x5B8B, # G+1154  U+5B8B  uni5B8B,  CJK UNIFIED IDEOGRAPH-5B8B
        0x5B8F, # G+1155  U+5B8F  uni5B8F,  CJK UNIFIED IDEOGRAPH-5B8F
        0x5C2C, # G+1156  U+5C2C  uni5C2C,  CJK UNIFIED IDEOGRAPH-5C2C
        0x5C40, # G+1157  U+5C40  uni5C40,  CJK UNIFIED IDEOGRAPH-5C40
        0x5C41, # G+1158  U+5C41  uni5C41,  CJK UNIFIED IDEOGRAPH-5C41
        0x5C3F, # G+1159  U+5C3F  uni5C3F,  CJK UNIFIED IDEOGRAPH-5C3F
        0x5C3E, # G+1160  U+5C3E  uni5C3E,  CJK UNIFIED IDEOGRAPH-5C3E
        0x5C90, # G+1161  U+5C90  uni5C90,  CJK UNIFIED IDEOGRAPH-5C90
        0x5C91, # G+1162  U+5C91  uni5C91,  CJK UNIFIED IDEOGRAPH-5C91
        0x5C94, # G+1163  U+5C94  uni5C94,  CJK UNIFIED IDEOGRAPH-5C94
        0x5C8C, # G+1164  U+5C8C  uni5C8C,  CJK UNIFIED IDEOGRAPH-5C8C
        0x5DEB, # G+1165  U+5DEB  uni5DEB,  CJK UNIFIED IDEOGRAPH-5DEB
        0x5E0C, # G+1166  U+5E0C  uni5E0C,  CJK UNIFIED IDEOGRAPH-5E0C
        0x5E8F, # G+1167  U+5E8F  uni5E8F,  CJK UNIFIED IDEOGRAPH-5E8F
        0x5E87, # G+1168  U+5E87  uni5E87,  CJK UNIFIED IDEOGRAPH-5E87
        0x5E8A, # G+1169  U+5E8A  uni5E8A,  CJK UNIFIED IDEOGRAPH-5E8A
        0x5EF7, # G+1170  U+5EF7  uni5EF7,  CJK UNIFIED IDEOGRAPH-5EF7
        0x5F04, # G+1171  U+5F04  uni5F04,  CJK UNIFIED IDEOGRAPH-5F04
        0x5F1F, # G+1172  U+5F1F  uni5F1F,  CJK UNIFIED IDEOGRAPH-5F1F
        0x5F64, # G+1173  U+5F64  uni5F64,  CJK UNIFIED IDEOGRAPH-5F64
        0x5F62, # G+1174  U+5F62  uni5F62,  CJK UNIFIED IDEOGRAPH-5F62
        0x5F77, # G+1175  U+5F77  uni5F77,  CJK UNIFIED IDEOGRAPH-5F77
        0x5F79, # G+1176  U+5F79  uni5F79,  CJK UNIFIED IDEOGRAPH-5F79
        0x5FD8, # G+1177  U+5FD8  uni5FD8,  CJK UNIFIED IDEOGRAPH-5FD8
        0x5FCC, # G+1178  U+5FCC  uni5FCC,  CJK UNIFIED IDEOGRAPH-5FCC
        0x5FD7, # G+1179  U+5FD7  uni5FD7,  CJK UNIFIED IDEOGRAPH-5FD7
        0x5FCD, # G+1180  U+5FCD  uni5FCD,  CJK UNIFIED IDEOGRAPH-5FCD
        0x5FF1, # G+1181  U+5FF1  uni5FF1,  CJK UNIFIED IDEOGRAPH-5FF1
        0x5FEB, # G+1182  U+5FEB  uni5FEB,  CJK UNIFIED IDEOGRAPH-5FEB
        0x5FF8, # G+1183  U+5FF8  uni5FF8,  CJK UNIFIED IDEOGRAPH-5FF8
        0x5FEA, # G+1184  U+5FEA  uni5FEA,  CJK UNIFIED IDEOGRAPH-5FEA
        0x6212, # G+1185  U+6212  uni6212,  CJK UNIFIED IDEOGRAPH-6212
        0x6211, # G+1186  U+6211  uni6211,  CJK UNIFIED IDEOGRAPH-6211
        0x6284, # G+1187  U+6284  uni6284,  CJK UNIFIED IDEOGRAPH-6284
        0x6297, # G+1188  U+6297  uni6297,  CJK UNIFIED IDEOGRAPH-6297
        0x6296, # G+1189  U+6296  uni6296,  CJK UNIFIED IDEOGRAPH-6296
        0x6280, # G+1190  U+6280  uni6280,  CJK UNIFIED IDEOGRAPH-6280
        0x6276, # G+1191  U+6276  uni6276,  CJK UNIFIED IDEOGRAPH-6276
        0x6289, # G+1192  U+6289  uni6289,  CJK UNIFIED IDEOGRAPH-6289
        0x626D, # G+1193  U+626D  uni626D,  CJK UNIFIED IDEOGRAPH-626D
        0x628A, # G+1194  U+628A  uni628A,  CJK UNIFIED IDEOGRAPH-628A
        0x627C, # G+1195  U+627C  uni627C,  CJK UNIFIED IDEOGRAPH-627C
        0x627E, # G+1196  U+627E  uni627E,  CJK UNIFIED IDEOGRAPH-627E
        0x6279, # G+1197  U+6279  uni6279,  CJK UNIFIED IDEOGRAPH-6279
        0x6273, # G+1198  U+6273  uni6273,  CJK UNIFIED IDEOGRAPH-6273
        0x6292, # G+1199  U+6292  uni6292,  CJK UNIFIED IDEOGRAPH-6292
        0x626F, # G+1200  U+626F  uni626F,  CJK UNIFIED IDEOGRAPH-626F
        0x6298, # G+1201  U+6298  uni6298,  CJK UNIFIED IDEOGRAPH-6298
        0x626E, # G+1202  U+626E  uni626E,  CJK UNIFIED IDEOGRAPH-626E
        0x6295, # G+1203  U+6295  uni6295,  CJK UNIFIED IDEOGRAPH-6295
        0x6293, # G+1204  U+6293  uni6293,  CJK UNIFIED IDEOGRAPH-6293
        0x6291, # G+1205  U+6291  uni6291,  CJK UNIFIED IDEOGRAPH-6291
        0x6286, # G+1206  U+6286  uni6286,  CJK UNIFIED IDEOGRAPH-6286
        0x6539, # G+1207  U+6539  uni6539,  CJK UNIFIED IDEOGRAPH-6539
        0x653B, # G+1208  U+653B  uni653B,  CJK UNIFIED IDEOGRAPH-653B
        0x6538, # G+1209  U+6538  uni6538,  CJK UNIFIED IDEOGRAPH-6538
        0x65F1, # G+1210  U+65F1  uni65F1,  CJK UNIFIED IDEOGRAPH-65F1
        0x66F4, # G+1211  U+66F4  uni66F4,  CJK UNIFIED IDEOGRAPH-66F4
        0x675F, # G+1212  U+675F  uni675F,  CJK UNIFIED IDEOGRAPH-675F
        0x674E, # G+1213  U+674E  uni674E,  CJK UNIFIED IDEOGRAPH-674E
        0x674F, # G+1214  U+674F  uni674F,  CJK UNIFIED IDEOGRAPH-674F
        0x6750, # G+1215  U+6750  uni6750,  CJK UNIFIED IDEOGRAPH-6750
        0x6751, # G+1216  U+6751  uni6751,  CJK UNIFIED IDEOGRAPH-6751
        0x675C, # G+1217  U+675C  uni675C,  CJK UNIFIED IDEOGRAPH-675C
        0x6756, # G+1218  U+6756  uni6756,  CJK UNIFIED IDEOGRAPH-6756
        0x675E, # G+1219  U+675E  uni675E,  CJK UNIFIED IDEOGRAPH-675E
        0x6749, # G+1220  U+6749  uni6749,  CJK UNIFIED IDEOGRAPH-6749
        0x6746, # G+1221  U+6746  uni6746,  CJK UNIFIED IDEOGRAPH-6746
        0x6760, # G+1222  U+6760  uni6760,  CJK UNIFIED IDEOGRAPH-6760
        0x6753, # G+1223  U+6753  uni6753,  CJK UNIFIED IDEOGRAPH-6753
        0x6757, # G+1224  U+6757  uni6757,  CJK UNIFIED IDEOGRAPH-6757
        0x6B65, # G+1225  U+6B65  uni6B65,  CJK UNIFIED IDEOGRAPH-6B65
        0x6BCF, # G+1226  U+6BCF  uni6BCF,  CJK UNIFIED IDEOGRAPH-6BCF
        0x6C42, # G+1227  U+6C42  uni6C42,  CJK UNIFIED IDEOGRAPH-6C42
        0x6C5E, # G+1228  U+6C5E  uni6C5E,  CJK UNIFIED IDEOGRAPH-6C5E
        0x6C99, # G+1229  U+6C99  uni6C99,  CJK UNIFIED IDEOGRAPH-6C99
        0x6C81, # G+1230  U+6C81  uni6C81,  CJK UNIFIED IDEOGRAPH-6C81
        0x6C88, # G+1231  U+6C88  uni6C88,  CJK UNIFIED IDEOGRAPH-6C88
        0x6C89, # G+1232  U+6C89  uni6C89,  CJK UNIFIED IDEOGRAPH-6C89
        0x6C85, # G+1233  U+6C85  uni6C85,  CJK UNIFIED IDEOGRAPH-6C85
        0x6C9B, # G+1234  U+6C9B  uni6C9B,  CJK UNIFIED IDEOGRAPH-6C9B
        0x6C6A, # G+1235  U+6C6A  uni6C6A,  CJK UNIFIED IDEOGRAPH-6C6A
        0x6C7A, # G+1236  U+6C7A  uni6C7A,  CJK UNIFIED IDEOGRAPH-6C7A
        0x6C90, # G+1237  U+6C90  uni6C90,  CJK UNIFIED IDEOGRAPH-6C90
        0x6C70, # G+1238  U+6C70  uni6C70,  CJK UNIFIED IDEOGRAPH-6C70
        0x6C8C, # G+1239  U+6C8C  uni6C8C,  CJK UNIFIED IDEOGRAPH-6C8C
        0x6C68, # G+1240  U+6C68  uni6C68,  CJK UNIFIED IDEOGRAPH-6C68
        0x6C96, # G+1241  U+6C96  uni6C96,  CJK UNIFIED IDEOGRAPH-6C96
        0x6C92, # G+1242  U+6C92  uni6C92,  CJK UNIFIED IDEOGRAPH-6C92
        0x6C7D, # G+1243  U+6C7D  uni6C7D,  CJK UNIFIED IDEOGRAPH-6C7D
        0x6C83, # G+1244  U+6C83  uni6C83,  CJK UNIFIED IDEOGRAPH-6C83
        0x6C72, # G+1245  U+6C72  uni6C72,  CJK UNIFIED IDEOGRAPH-6C72
        0x6C7E, # G+1246  U+6C7E  uni6C7E,  CJK UNIFIED IDEOGRAPH-6C7E
        0x6C74, # G+1247  U+6C74  uni6C74,  CJK UNIFIED IDEOGRAPH-6C74
        0x6C86, # G+1248  U+6C86  uni6C86,  CJK UNIFIED IDEOGRAPH-6C86
        0x6C76, # G+1249  U+6C76  uni6C76,  CJK UNIFIED IDEOGRAPH-6C76
        0x6C8D, # G+1250  U+6C8D  uni6C8D,  CJK UNIFIED IDEOGRAPH-6C8D
        0x6C94, # G+1251  U+6C94  uni6C94,  CJK UNIFIED IDEOGRAPH-6C94
        0x6C98, # G+1252  U+6C98  uni6C98,  CJK UNIFIED IDEOGRAPH-6C98
        0x6C82, # G+1253  U+6C82  uni6C82,  CJK UNIFIED IDEOGRAPH-6C82
        0x7076, # G+1254  U+7076  uni7076,  CJK UNIFIED IDEOGRAPH-7076
        0x707C, # G+1255  U+707C  uni707C,  CJK UNIFIED IDEOGRAPH-707C
        0x707D, # G+1256  U+707D  uni707D,  CJK UNIFIED IDEOGRAPH-707D
        0x7078, # G+1257  U+7078  uni7078,  CJK UNIFIED IDEOGRAPH-7078
        0x7262, # G+1258  U+7262  uni7262,  CJK UNIFIED IDEOGRAPH-7262
        0x7261, # G+1259  U+7261  uni7261,  CJK UNIFIED IDEOGRAPH-7261
        0x7260, # G+1260  U+7260  uni7260,  CJK UNIFIED IDEOGRAPH-7260
        0x72C4, # G+1261  U+72C4  uni72C4,  CJK UNIFIED IDEOGRAPH-72C4
        0x72C2, # G+1262  U+72C2  uni72C2,  CJK UNIFIED IDEOGRAPH-72C2
        0x7396, # G+1263  U+7396  uni7396,  CJK UNIFIED IDEOGRAPH-7396
        0x752C, # G+1264  U+752C  uni752C,  CJK UNIFIED IDEOGRAPH-752C
        0x752B, # G+1265  U+752B  uni752B,  CJK UNIFIED IDEOGRAPH-752B
        0x7537, # G+1266  U+7537  uni7537,  CJK UNIFIED IDEOGRAPH-7537
        0x7538, # G+1267  U+7538  uni7538,  CJK UNIFIED IDEOGRAPH-7538
        0x7682, # G+1268  U+7682  uni7682,  CJK UNIFIED IDEOGRAPH-7682
        0x76EF, # G+1269  U+76EF  uni76EF,  CJK UNIFIED IDEOGRAPH-76EF
        0x77E3, # G+1270  U+77E3  uni77E3,  CJK UNIFIED IDEOGRAPH-77E3
        0x79C1, # G+1271  U+79C1  uni79C1,  CJK UNIFIED IDEOGRAPH-79C1
        0x79C0, # G+1272  U+79C0  uni79C0,  CJK UNIFIED IDEOGRAPH-79C0
        0x79BF, # G+1273  U+79BF  uni79BF,  CJK UNIFIED IDEOGRAPH-79BF
        0x7A76, # G+1274  U+7A76  uni7A76,  CJK UNIFIED IDEOGRAPH-7A76
        0x7CFB, # G+1275  U+7CFB  uni7CFB,  CJK UNIFIED IDEOGRAPH-7CFB
        0x7F55, # G+1276  U+7F55  uni7F55,  CJK UNIFIED IDEOGRAPH-7F55
        0x8096, # G+1277  U+8096  uni8096,  CJK UNIFIED IDEOGRAPH-8096
        0x8093, # G+1278  U+8093  uni8093,  CJK UNIFIED IDEOGRAPH-8093
        0x809D, # G+1279  U+809D  uni809D,  CJK UNIFIED IDEOGRAPH-809D
        0x8098, # G+1280  U+8098  uni8098,  CJK UNIFIED IDEOGRAPH-8098
        0x809B, # G+1281  U+809B  uni809B,  CJK UNIFIED IDEOGRAPH-809B
        0x809A, # G+1282  U+809A  uni809A,  CJK UNIFIED IDEOGRAPH-809A
        0x80B2, # G+1283  U+80B2  uni80B2,  CJK UNIFIED IDEOGRAPH-80B2
        0x826F, # G+1284  U+826F  uni826F,  CJK UNIFIED IDEOGRAPH-826F
        0x8292, # G+1285  U+8292  uni8292,  CJK UNIFIED IDEOGRAPH-8292
        0x828B, # G+1286  U+828B  uni828B,  CJK UNIFIED IDEOGRAPH-828B
        0x828D, # G+1287  U+828D  uni828D,  CJK UNIFIED IDEOGRAPH-828D
        0x898B, # G+1288  U+898B  uni898B,  CJK UNIFIED IDEOGRAPH-898B
        0x89D2, # G+1289  U+89D2  uni89D2,  CJK UNIFIED IDEOGRAPH-89D2
        0x8A00, # G+1290  U+8A00  uni8A00,  CJK UNIFIED IDEOGRAPH-8A00
        0x8C37, # G+1291  U+8C37  uni8C37,  CJK UNIFIED IDEOGRAPH-8C37
        0x8C46, # G+1292  U+8C46  uni8C46,  CJK UNIFIED IDEOGRAPH-8C46
        0x8C55, # G+1293  U+8C55  uni8C55,  CJK UNIFIED IDEOGRAPH-8C55
        0x8C9D, # G+1294  U+8C9D  uni8C9D,  CJK UNIFIED IDEOGRAPH-8C9D
        0x8D64, # G+1295  U+8D64  uni8D64,  CJK UNIFIED IDEOGRAPH-8D64
        0x8D70, # G+1296  U+8D70  uni8D70,  CJK UNIFIED IDEOGRAPH-8D70
        0x8DB3, # G+1297  U+8DB3  uni8DB3,  CJK UNIFIED IDEOGRAPH-8DB3
        0x8EAB, # G+1298  U+8EAB  uni8EAB,  CJK UNIFIED IDEOGRAPH-8EAB
        0x8ECA, # G+1299  U+8ECA  uni8ECA,  CJK UNIFIED IDEOGRAPH-8ECA
        0x8F9B, # G+1300  U+8F9B  uni8F9B,  CJK UNIFIED IDEOGRAPH-8F9B
        0x8FB0, # G+1301  U+8FB0  uni8FB0,  CJK UNIFIED IDEOGRAPH-8FB0
        0x8FC2, # G+1302  U+8FC2  uni8FC2,  CJK UNIFIED IDEOGRAPH-8FC2
        0x8FC6, # G+1303  U+8FC6  uni8FC6,  CJK UNIFIED IDEOGRAPH-8FC6
        0x8FC5, # G+1304  U+8FC5  uni8FC5,  CJK UNIFIED IDEOGRAPH-8FC5
        0x8FC4, # G+1305  U+8FC4  uni8FC4,  CJK UNIFIED IDEOGRAPH-8FC4
        0x5DE1, # G+1306  U+5DE1  uni5DE1,  CJK UNIFIED IDEOGRAPH-5DE1
        0x2FA2, # G+1307  U+2FA2  uni2FA2,  KANGXI RADICAL CITY
        0x90A2, # G+1308  U+90A2  uni90A2,  CJK UNIFIED IDEOGRAPH-90A2
        0x90AA, # G+1309  U+90AA  uni90AA,  CJK UNIFIED IDEOGRAPH-90AA
        0x90A6, # G+1310  U+90A6  uni90A6,  CJK UNIFIED IDEOGRAPH-90A6
        0x90A3, # G+1311  U+90A3  uni90A3,  CJK UNIFIED IDEOGRAPH-90A3
        0x9149, # G+1312  U+9149  uni9149,  CJK UNIFIED IDEOGRAPH-9149
        0x91C6, # G+1313  U+91C6  uni91C6,  CJK UNIFIED IDEOGRAPH-91C6
        0x91CC, # G+1314  U+91CC  uni91CC,  CJK UNIFIED IDEOGRAPH-91CC
        0x9632, # G+1315  U+9632  uni9632,  CJK UNIFIED IDEOGRAPH-9632
        0x962E, # G+1316  U+962E  uni962E,  CJK UNIFIED IDEOGRAPH-962E
        0x9631, # G+1317  U+9631  uni9631,  CJK UNIFIED IDEOGRAPH-9631
        0x962A, # G+1318  U+962A  uni962A,  CJK UNIFIED IDEOGRAPH-962A
        0x962C, # G+1319  U+962C  uni962C,  CJK UNIFIED IDEOGRAPH-962C
        0x4E26, # G+1320  U+4E26  uni4E26,  CJK UNIFIED IDEOGRAPH-4E26
        0x4E56, # G+1321  U+4E56  uni4E56,  CJK UNIFIED IDEOGRAPH-4E56
        0x4E73, # G+1322  U+4E73  uni4E73,  CJK UNIFIED IDEOGRAPH-4E73
        0x4E8B, # G+1323  U+4E8B  uni4E8B,  CJK UNIFIED IDEOGRAPH-4E8B
        0x4E9B, # G+1324  U+4E9B  uni4E9B,  CJK UNIFIED IDEOGRAPH-4E9B
        0x4E9E, # G+1325  U+4E9E  uni4E9E,  CJK UNIFIED IDEOGRAPH-4E9E
        0x4EAB, # G+1326  U+4EAB  uni4EAB,  CJK UNIFIED IDEOGRAPH-4EAB
        0x4EAC, # G+1327  U+4EAC  uni4EAC,  CJK UNIFIED IDEOGRAPH-4EAC
        0x4F6F, # G+1328  U+4F6F  uni4F6F,  CJK UNIFIED IDEOGRAPH-4F6F
        0x4F9D, # G+1329  U+4F9D  uni4F9D,  CJK UNIFIED IDEOGRAPH-4F9D
        0x4F8D, # G+1330  U+4F8D  uni4F8D,  CJK UNIFIED IDEOGRAPH-4F8D
        0x4F73, # G+1331  U+4F73  uni4F73,  CJK UNIFIED IDEOGRAPH-4F73
        0x4F7F, # G+1332  U+4F7F  uni4F7F,  CJK UNIFIED IDEOGRAPH-4F7F
        0x4F6C, # G+1333  U+4F6C  uni4F6C,  CJK UNIFIED IDEOGRAPH-4F6C
        0x4F9B, # G+1334  U+4F9B  uni4F9B,  CJK UNIFIED IDEOGRAPH-4F9B
        0x4F8B, # G+1335  U+4F8B  uni4F8B,  CJK UNIFIED IDEOGRAPH-4F8B
        0x4F86, # G+1336  U+4F86  uni4F86,  CJK UNIFIED IDEOGRAPH-4F86
        0x4F83, # G+1337  U+4F83  uni4F83,  CJK UNIFIED IDEOGRAPH-4F83
        0x4F70, # G+1338  U+4F70  uni4F70,  CJK UNIFIED IDEOGRAPH-4F70
        0x4F75, # G+1339  U+4F75  uni4F75,  CJK UNIFIED IDEOGRAPH-4F75
        0x4F88, # G+1340  U+4F88  uni4F88,  CJK UNIFIED IDEOGRAPH-4F88
        0x4F69, # G+1341  U+4F69  uni4F69,  CJK UNIFIED IDEOGRAPH-4F69
        0x4F7B, # G+1342  U+4F7B  uni4F7B,  CJK UNIFIED IDEOGRAPH-4F7B
        0x4F96, # G+1343  U+4F96  uni4F96,  CJK UNIFIED IDEOGRAPH-4F96
        0x4F7E, # G+1344  U+4F7E  uni4F7E,  CJK UNIFIED IDEOGRAPH-4F7E
        0x4F8F, # G+1345  U+4F8F  uni4F8F,  CJK UNIFIED IDEOGRAPH-4F8F
        0x4F91, # G+1346  U+4F91  uni4F91,  CJK UNIFIED IDEOGRAPH-4F91
        0x4F7A, # G+1347  U+4F7A  uni4F7A,  CJK UNIFIED IDEOGRAPH-4F7A
        0x5154, # G+1348  U+5154  uni5154,  CJK UNIFIED IDEOGRAPH-5154
        0x5152, # G+1349  U+5152  uni5152,  CJK UNIFIED IDEOGRAPH-5152
        0x5155, # G+1350  U+5155  uni5155,  CJK UNIFIED IDEOGRAPH-5155
        0x5169, # G+1351  U+5169  uni5169,  CJK UNIFIED IDEOGRAPH-5169
        0x5177, # G+1352  U+5177  uni5177,  CJK UNIFIED IDEOGRAPH-5177
        0x5176, # G+1353  U+5176  uni5176,  CJK UNIFIED IDEOGRAPH-5176
        0x5178, # G+1354  U+5178  uni5178,  CJK UNIFIED IDEOGRAPH-5178
        0x51BD, # G+1355  U+51BD  uni51BD,  CJK UNIFIED IDEOGRAPH-51BD
        0x51FD, # G+1356  U+51FD  uni51FD,  CJK UNIFIED IDEOGRAPH-51FD
        0x523B, # G+1357  U+523B  uni523B,  CJK UNIFIED IDEOGRAPH-523B
        0x5238, # G+1358  U+5238  uni5238,  CJK UNIFIED IDEOGRAPH-5238
        0x5237, # G+1359  U+5237  uni5237,  CJK UNIFIED IDEOGRAPH-5237
        0x523A, # G+1360  U+523A  uni523A,  CJK UNIFIED IDEOGRAPH-523A
        0x5230, # G+1361  U+5230  uni5230,  CJK UNIFIED IDEOGRAPH-5230
        0x522E, # G+1362  U+522E  uni522E,  CJK UNIFIED IDEOGRAPH-522E
        0x5236, # G+1363  U+5236  uni5236,  CJK UNIFIED IDEOGRAPH-5236
        0x5241, # G+1364  U+5241  uni5241,  CJK UNIFIED IDEOGRAPH-5241
        0x52BE, # G+1365  U+52BE  uni52BE,  CJK UNIFIED IDEOGRAPH-52BE
        0x52BB, # G+1366  U+52BB  uni52BB,  CJK UNIFIED IDEOGRAPH-52BB
        0x5352, # G+1367  U+5352  uni5352,  CJK UNIFIED IDEOGRAPH-5352
        0x5354, # G+1368  U+5354  uni5354,  CJK UNIFIED IDEOGRAPH-5354
        0x5353, # G+1369  U+5353  uni5353,  CJK UNIFIED IDEOGRAPH-5353
        0x5351, # G+1370  U+5351  uni5351,  CJK UNIFIED IDEOGRAPH-5351
        0x5366, # G+1371  U+5366  uni5366,  CJK UNIFIED IDEOGRAPH-5366
        0x5377, # G+1372  U+5377  uni5377,  CJK UNIFIED IDEOGRAPH-5377
        0x5378, # G+1373  U+5378  uni5378,  CJK UNIFIED IDEOGRAPH-5378
        0x5379, # G+1374  U+5379  uni5379,  CJK UNIFIED IDEOGRAPH-5379
        0x53D6, # G+1375  U+53D6  uni53D6,  CJK UNIFIED IDEOGRAPH-53D6
        0x53D4, # G+1376  U+53D4  uni53D4,  CJK UNIFIED IDEOGRAPH-53D4
        0x53D7, # G+1377  U+53D7  uni53D7,  CJK UNIFIED IDEOGRAPH-53D7
        0x5473, # G+1378  U+5473  uni5473,  CJK UNIFIED IDEOGRAPH-5473
        0x5475, # G+1379  U+5475  uni5475,  CJK UNIFIED IDEOGRAPH-5475
        0x5496, # G+1380  U+5496  uni5496,  CJK UNIFIED IDEOGRAPH-5496
        0x5478, # G+1381  U+5478  uni5478,  CJK UNIFIED IDEOGRAPH-5478
        0x5495, # G+1382  U+5495  uni5495,  CJK UNIFIED IDEOGRAPH-5495
        0x5480, # G+1383  U+5480  uni5480,  CJK UNIFIED IDEOGRAPH-5480
        0x547B, # G+1384  U+547B  uni547B,  CJK UNIFIED IDEOGRAPH-547B
        0x5477, # G+1385  U+5477  uni5477,  CJK UNIFIED IDEOGRAPH-5477
        0x5484, # G+1386  U+5484  uni5484,  CJK UNIFIED IDEOGRAPH-5484
        0x5492, # G+1387  U+5492  uni5492,  CJK UNIFIED IDEOGRAPH-5492
        0x5486, # G+1388  U+5486  uni5486,  CJK UNIFIED IDEOGRAPH-5486
        0x547C, # G+1389  U+547C  uni547C,  CJK UNIFIED IDEOGRAPH-547C
        0x5490, # G+1390  U+5490  uni5490,  CJK UNIFIED IDEOGRAPH-5490
        0x5471, # G+1391  U+5471  uni5471,  CJK UNIFIED IDEOGRAPH-5471
        0x5476, # G+1392  U+5476  uni5476,  CJK UNIFIED IDEOGRAPH-5476
        0x548C, # G+1393  U+548C  uni548C,  CJK UNIFIED IDEOGRAPH-548C
        0x549A, # G+1394  U+549A  uni549A,  CJK UNIFIED IDEOGRAPH-549A
        0x5462, # G+1395  U+5462  uni5462,  CJK UNIFIED IDEOGRAPH-5462
        0x5468, # G+1396  U+5468  uni5468,  CJK UNIFIED IDEOGRAPH-5468
        0x548B, # G+1397  U+548B  uni548B,  CJK UNIFIED IDEOGRAPH-548B
        0x547D, # G+1398  U+547D  uni547D,  CJK UNIFIED IDEOGRAPH-547D
        0x548E, # G+1399  U+548E  uni548E,  CJK UNIFIED IDEOGRAPH-548E
        0x56FA, # G+1400  U+56FA  uni56FA,  CJK UNIFIED IDEOGRAPH-56FA
        0x5783, # G+1401  U+5783  uni5783,  CJK UNIFIED IDEOGRAPH-5783
        0x5777, # G+1402  U+5777  uni5777,  CJK UNIFIED IDEOGRAPH-5777
        0x576A, # G+1403  U+576A  uni576A,  CJK UNIFIED IDEOGRAPH-576A
        0x5769, # G+1404  U+5769  uni5769,  CJK UNIFIED IDEOGRAPH-5769
        0x5761, # G+1405  U+5761  uni5761,  CJK UNIFIED IDEOGRAPH-5761
        0x5766, # G+1406  U+5766  uni5766,  CJK UNIFIED IDEOGRAPH-5766
        0x5764, # G+1407  U+5764  uni5764,  CJK UNIFIED IDEOGRAPH-5764
        0x577C, # G+1408  U+577C  uni577C,  CJK UNIFIED IDEOGRAPH-577C
        0x591C, # G+1409  U+591C  uni591C,  CJK UNIFIED IDEOGRAPH-591C
        0x5949, # G+1410  U+5949  uni5949,  CJK UNIFIED IDEOGRAPH-5949
        0x5947, # G+1411  U+5947  uni5947,  CJK UNIFIED IDEOGRAPH-5947
        0x5948, # G+1412  U+5948  uni5948,  CJK UNIFIED IDEOGRAPH-5948
        0x5944, # G+1413  U+5944  uni5944,  CJK UNIFIED IDEOGRAPH-5944
        0x5954, # G+1414  U+5954  uni5954,  CJK UNIFIED IDEOGRAPH-5954
        0x59BE, # G+1415  U+59BE  uni59BE,  CJK UNIFIED IDEOGRAPH-59BE
        0x59BB, # G+1416  U+59BB  uni59BB,  CJK UNIFIED IDEOGRAPH-59BB
        0x59D4, # G+1417  U+59D4  uni59D4,  CJK UNIFIED IDEOGRAPH-59D4
        0x59B9, # G+1418  U+59B9  uni59B9,  CJK UNIFIED IDEOGRAPH-59B9
        0x59AE, # G+1419  U+59AE  uni59AE,  CJK UNIFIED IDEOGRAPH-59AE
        0x59D1, # G+1420  U+59D1  uni59D1,  CJK UNIFIED IDEOGRAPH-59D1
        0x59C6, # G+1421  U+59C6  uni59C6,  CJK UNIFIED IDEOGRAPH-59C6
        0x59D0, # G+1422  U+59D0  uni59D0,  CJK UNIFIED IDEOGRAPH-59D0
        0x59CD, # G+1423  U+59CD  uni59CD,  CJK UNIFIED IDEOGRAPH-59CD
        0x59CB, # G+1424  U+59CB  uni59CB,  CJK UNIFIED IDEOGRAPH-59CB
        0x59D3, # G+1425  U+59D3  uni59D3,  CJK UNIFIED IDEOGRAPH-59D3
        0x59CA, # G+1426  U+59CA  uni59CA,  CJK UNIFIED IDEOGRAPH-59CA
        0x59AF, # G+1427  U+59AF  uni59AF,  CJK UNIFIED IDEOGRAPH-59AF
        0x59B3, # G+1428  U+59B3  uni59B3,  CJK UNIFIED IDEOGRAPH-59B3
        0x59D2, # G+1429  U+59D2  uni59D2,  CJK UNIFIED IDEOGRAPH-59D2
        0x59C5, # G+1430  U+59C5  uni59C5,  CJK UNIFIED IDEOGRAPH-59C5
        0x5B5F, # G+1431  U+5B5F  uni5B5F,  CJK UNIFIED IDEOGRAPH-5B5F
        0x5B64, # G+1432  U+5B64  uni5B64,  CJK UNIFIED IDEOGRAPH-5B64
        0x5B63, # G+1433  U+5B63  uni5B63,  CJK UNIFIED IDEOGRAPH-5B63
        0x5B97, # G+1434  U+5B97  uni5B97,  CJK UNIFIED IDEOGRAPH-5B97
        0x5B9A, # G+1435  U+5B9A  uni5B9A,  CJK UNIFIED IDEOGRAPH-5B9A
        0x5B98, # G+1436  U+5B98  uni5B98,  CJK UNIFIED IDEOGRAPH-5B98
        0x5B9C, # G+1437  U+5B9C  uni5B9C,  CJK UNIFIED IDEOGRAPH-5B9C
        0x5B99, # G+1438  U+5B99  uni5B99,  CJK UNIFIED IDEOGRAPH-5B99
        0x5B9B, # G+1439  U+5B9B  uni5B9B,  CJK UNIFIED IDEOGRAPH-5B9B
        0x5C1A, # G+1440  U+5C1A  uni5C1A,  CJK UNIFIED IDEOGRAPH-5C1A
        0x5C48, # G+1441  U+5C48  uni5C48,  CJK UNIFIED IDEOGRAPH-5C48
        0x5C45, # G+1442  U+5C45  uni5C45,  CJK UNIFIED IDEOGRAPH-5C45
        0x5C46, # G+1443  U+5C46  uni5C46,  CJK UNIFIED IDEOGRAPH-5C46
        0x5CB7, # G+1444  U+5CB7  uni5CB7,  CJK UNIFIED IDEOGRAPH-5CB7
        0x5CA1, # G+1445  U+5CA1  uni5CA1,  CJK UNIFIED IDEOGRAPH-5CA1
        0x5CB8, # G+1446  U+5CB8  uni5CB8,  CJK UNIFIED IDEOGRAPH-5CB8
        0x5CA9, # G+1447  U+5CA9  uni5CA9,  CJK UNIFIED IDEOGRAPH-5CA9
        0x5CAB, # G+1448  U+5CAB  uni5CAB,  CJK UNIFIED IDEOGRAPH-5CAB
        0x5CB1, # G+1449  U+5CB1  uni5CB1,  CJK UNIFIED IDEOGRAPH-5CB1
        0x5CB3, # G+1450  U+5CB3  uni5CB3,  CJK UNIFIED IDEOGRAPH-5CB3
        0x5E18, # G+1451  U+5E18  uni5E18,  CJK UNIFIED IDEOGRAPH-5E18
        0x5E1A, # G+1452  U+5E1A  uni5E1A,  CJK UNIFIED IDEOGRAPH-5E1A
        0x5E16, # G+1453  U+5E16  uni5E16,  CJK UNIFIED IDEOGRAPH-5E16
        0x5E15, # G+1454  U+5E15  uni5E15,  CJK UNIFIED IDEOGRAPH-5E15
        0x5E1B, # G+1455  U+5E1B  uni5E1B,  CJK UNIFIED IDEOGRAPH-5E1B
        0x5E11, # G+1456  U+5E11  uni5E11,  CJK UNIFIED IDEOGRAPH-5E11
        0x5E78, # G+1457  U+5E78  uni5E78,  CJK UNIFIED IDEOGRAPH-5E78
        0x5E9A, # G+1458  U+5E9A  uni5E9A,  CJK UNIFIED IDEOGRAPH-5E9A
        0x5E97, # G+1459  U+5E97  uni5E97,  CJK UNIFIED IDEOGRAPH-5E97
        0x5E9C, # G+1460  U+5E9C  uni5E9C,  CJK UNIFIED IDEOGRAPH-5E9C
        0x5E95, # G+1461  U+5E95  uni5E95,  CJK UNIFIED IDEOGRAPH-5E95
        0x5E96, # G+1462  U+5E96  uni5E96,  CJK UNIFIED IDEOGRAPH-5E96
        0x5EF6, # G+1463  U+5EF6  uni5EF6,  CJK UNIFIED IDEOGRAPH-5EF6
        0x5F26, # G+1464  U+5F26  uni5F26,  CJK UNIFIED IDEOGRAPH-5F26
        0x5F27, # G+1465  U+5F27  uni5F27,  CJK UNIFIED IDEOGRAPH-5F27
        0x5F29, # G+1466  U+5F29  uni5F29,  CJK UNIFIED IDEOGRAPH-5F29
        0x5F80, # G+1467  U+5F80  uni5F80,  CJK UNIFIED IDEOGRAPH-5F80
        0x5F81, # G+1468  U+5F81  uni5F81,  CJK UNIFIED IDEOGRAPH-5F81
        0x5F7F, # G+1469  U+5F7F  uni5F7F,  CJK UNIFIED IDEOGRAPH-5F7F
        0x5F7C, # G+1470  U+5F7C  uni5F7C,  CJK UNIFIED IDEOGRAPH-5F7C
        0x5FDD, # G+1471  U+5FDD  uni5FDD,  CJK UNIFIED IDEOGRAPH-5FDD
        0x5FE0, # G+1472  U+5FE0  uni5FE0,  CJK UNIFIED IDEOGRAPH-5FE0
        0x5FFD, # G+1473  U+5FFD  uni5FFD,  CJK UNIFIED IDEOGRAPH-5FFD
        0x5FF5, # G+1474  U+5FF5  uni5FF5,  CJK UNIFIED IDEOGRAPH-5FF5
        0x5FFF, # G+1475  U+5FFF  uni5FFF,  CJK UNIFIED IDEOGRAPH-5FFF
        0x600F, # G+1476  U+600F  uni600F,  CJK UNIFIED IDEOGRAPH-600F
        0x6014, # G+1477  U+6014  uni6014,  CJK UNIFIED IDEOGRAPH-6014
        0x602F, # G+1478  U+602F  uni602F,  CJK UNIFIED IDEOGRAPH-602F
        0x6035, # G+1479  U+6035  uni6035,  CJK UNIFIED IDEOGRAPH-6035
        0x6016, # G+1480  U+6016  uni6016,  CJK UNIFIED IDEOGRAPH-6016
        0x602A, # G+1481  U+602A  uni602A,  CJK UNIFIED IDEOGRAPH-602A
        0x6015, # G+1482  U+6015  uni6015,  CJK UNIFIED IDEOGRAPH-6015
        0x6021, # G+1483  U+6021  uni6021,  CJK UNIFIED IDEOGRAPH-6021
        0x6027, # G+1484  U+6027  uni6027,  CJK UNIFIED IDEOGRAPH-6027
        0x6029, # G+1485  U+6029  uni6029,  CJK UNIFIED IDEOGRAPH-6029
        0x602B, # G+1486  U+602B  uni602B,  CJK UNIFIED IDEOGRAPH-602B
        0x601B, # G+1487  U+601B  uni601B,  CJK UNIFIED IDEOGRAPH-601B
        0x6216, # G+1488  U+6216  uni6216,  CJK UNIFIED IDEOGRAPH-6216
        0x6215, # G+1489  U+6215  uni6215,  CJK UNIFIED IDEOGRAPH-6215
        0x623F, # G+1490  U+623F  uni623F,  CJK UNIFIED IDEOGRAPH-623F
        0x623E, # G+1491  U+623E  uni623E,  CJK UNIFIED IDEOGRAPH-623E
        0x6240, # G+1492  U+6240  uni6240,  CJK UNIFIED IDEOGRAPH-6240
        0x627F, # G+1493  U+627F  uni627F,  CJK UNIFIED IDEOGRAPH-627F
        0x62C9, # G+1494  U+62C9  uni62C9,  CJK UNIFIED IDEOGRAPH-62C9
        0x62CC, # G+1495  U+62CC  uni62CC,  CJK UNIFIED IDEOGRAPH-62CC
        0x62C4, # G+1496  U+62C4  uni62C4,  CJK UNIFIED IDEOGRAPH-62C4
        0x62BF, # G+1497  U+62BF  uni62BF,  CJK UNIFIED IDEOGRAPH-62BF
        0x62C2, # G+1498  U+62C2  uni62C2,  CJK UNIFIED IDEOGRAPH-62C2
        0x62B9, # G+1499  U+62B9  uni62B9,  CJK UNIFIED IDEOGRAPH-62B9
        0x62D2, # G+1500  U+62D2  uni62D2,  CJK UNIFIED IDEOGRAPH-62D2
        0x62DB, # G+1501  U+62DB  uni62DB,  CJK UNIFIED IDEOGRAPH-62DB
        0x62AB, # G+1502  U+62AB  uni62AB,  CJK UNIFIED IDEOGRAPH-62AB
        0x62D3, # G+1503  U+62D3  uni62D3,  CJK UNIFIED IDEOGRAPH-62D3
        0x62D4, # G+1504  U+62D4  uni62D4,  CJK UNIFIED IDEOGRAPH-62D4
        0x62CB, # G+1505  U+62CB  uni62CB,  CJK UNIFIED IDEOGRAPH-62CB
        0x62C8, # G+1506  U+62C8  uni62C8,  CJK UNIFIED IDEOGRAPH-62C8
        0x62A8, # G+1507  U+62A8  uni62A8,  CJK UNIFIED IDEOGRAPH-62A8
        0x62BD, # G+1508  U+62BD  uni62BD,  CJK UNIFIED IDEOGRAPH-62BD
        0x62BC, # G+1509  U+62BC  uni62BC,  CJK UNIFIED IDEOGRAPH-62BC
        0x62D0, # G+1510  U+62D0  uni62D0,  CJK UNIFIED IDEOGRAPH-62D0
        0x62D9, # G+1511  U+62D9  uni62D9,  CJK UNIFIED IDEOGRAPH-62D9
        0x62C7, # G+1512  U+62C7  uni62C7,  CJK UNIFIED IDEOGRAPH-62C7
        0x62CD, # G+1513  U+62CD  uni62CD,  CJK UNIFIED IDEOGRAPH-62CD
        0x62B5, # G+1514  U+62B5  uni62B5,  CJK UNIFIED IDEOGRAPH-62B5
        0x62DA, # G+1515  U+62DA  uni62DA,  CJK UNIFIED IDEOGRAPH-62DA
        0x62B1, # G+1516  U+62B1  uni62B1,  CJK UNIFIED IDEOGRAPH-62B1
        0x62D8, # G+1517  U+62D8  uni62D8,  CJK UNIFIED IDEOGRAPH-62D8
        0x62D6, # G+1518  U+62D6  uni62D6,  CJK UNIFIED IDEOGRAPH-62D6
        0x62D7, # G+1519  U+62D7  uni62D7,  CJK UNIFIED IDEOGRAPH-62D7
        0x62C6, # G+1520  U+62C6  uni62C6,  CJK UNIFIED IDEOGRAPH-62C6
        0x62AC, # G+1521  U+62AC  uni62AC,  CJK UNIFIED IDEOGRAPH-62AC
        0x62CE, # G+1522  U+62CE  uni62CE,  CJK UNIFIED IDEOGRAPH-62CE
        0x653E, # G+1523  U+653E  uni653E,  CJK UNIFIED IDEOGRAPH-653E
        0x65A7, # G+1524  U+65A7  uni65A7,  CJK UNIFIED IDEOGRAPH-65A7
        0x65BC, # G+1525  U+65BC  uni65BC,  CJK UNIFIED IDEOGRAPH-65BC
        0x65FA, # G+1526  U+65FA  uni65FA,  CJK UNIFIED IDEOGRAPH-65FA
        0x6614, # G+1527  U+6614  uni6614,  CJK UNIFIED IDEOGRAPH-6614
        0x6613, # G+1528  U+6613  uni6613,  CJK UNIFIED IDEOGRAPH-6613
        0x660C, # G+1529  U+660C  uni660C,  CJK UNIFIED IDEOGRAPH-660C
        0x6606, # G+1530  U+6606  uni6606,  CJK UNIFIED IDEOGRAPH-6606
        0x6602, # G+1531  U+6602  uni6602,  CJK UNIFIED IDEOGRAPH-6602
        0x660E, # G+1532  U+660E  uni660E,  CJK UNIFIED IDEOGRAPH-660E
        0x6600, # G+1533  U+6600  uni6600,  CJK UNIFIED IDEOGRAPH-6600
        0x660F, # G+1534  U+660F  uni660F,  CJK UNIFIED IDEOGRAPH-660F
        0x6615, # G+1535  U+6615  uni6615,  CJK UNIFIED IDEOGRAPH-6615
        0x660A, # G+1536  U+660A  uni660A,  CJK UNIFIED IDEOGRAPH-660A
        0x6607, # G+1537  U+6607  uni6607,  CJK UNIFIED IDEOGRAPH-6607
        0x670D, # G+1538  U+670D  uni670D,  CJK UNIFIED IDEOGRAPH-670D
        0x670B, # G+1539  U+670B  uni670B,  CJK UNIFIED IDEOGRAPH-670B
        0x676D, # G+1540  U+676D  uni676D,  CJK UNIFIED IDEOGRAPH-676D
        0x678B, # G+1541  U+678B  uni678B,  CJK UNIFIED IDEOGRAPH-678B
        0x6795, # G+1542  U+6795  uni6795,  CJK UNIFIED IDEOGRAPH-6795
        0x6771, # G+1543  U+6771  uni6771,  CJK UNIFIED IDEOGRAPH-6771
        0x679C, # G+1544  U+679C  uni679C,  CJK UNIFIED IDEOGRAPH-679C
        0x6773, # G+1545  U+6773  uni6773,  CJK UNIFIED IDEOGRAPH-6773
        0x6777, # G+1546  U+6777  uni6777,  CJK UNIFIED IDEOGRAPH-6777
        0x6787, # G+1547  U+6787  uni6787,  CJK UNIFIED IDEOGRAPH-6787
        0x679D, # G+1548  U+679D  uni679D,  CJK UNIFIED IDEOGRAPH-679D
        0x6797, # G+1549  U+6797  uni6797,  CJK UNIFIED IDEOGRAPH-6797
        0x676F, # G+1550  U+676F  uni676F,  CJK UNIFIED IDEOGRAPH-676F
        0x6770, # G+1551  U+6770  uni6770,  CJK UNIFIED IDEOGRAPH-6770
        0x677F, # G+1552  U+677F  uni677F,  CJK UNIFIED IDEOGRAPH-677F
        0x6789, # G+1553  U+6789  uni6789,  CJK UNIFIED IDEOGRAPH-6789
        0x677E, # G+1554  U+677E  uni677E,  CJK UNIFIED IDEOGRAPH-677E
        0x6790, # G+1555  U+6790  uni6790,  CJK UNIFIED IDEOGRAPH-6790
        0x6775, # G+1556  U+6775  uni6775,  CJK UNIFIED IDEOGRAPH-6775
        0x679A, # G+1557  U+679A  uni679A,  CJK UNIFIED IDEOGRAPH-679A
        0x6793, # G+1558  U+6793  uni6793,  CJK UNIFIED IDEOGRAPH-6793
        0x677C, # G+1559  U+677C  uni677C,  CJK UNIFIED IDEOGRAPH-677C
        0x676A, # G+1560  U+676A  uni676A,  CJK UNIFIED IDEOGRAPH-676A
        0x6772, # G+1561  U+6772  uni6772,  CJK UNIFIED IDEOGRAPH-6772
        0x6B23, # G+1562  U+6B23  uni6B23,  CJK UNIFIED IDEOGRAPH-6B23
        0x6B66, # G+1563  U+6B66  uni6B66,  CJK UNIFIED IDEOGRAPH-6B66
        0x6B67, # G+1564  U+6B67  uni6B67,  CJK UNIFIED IDEOGRAPH-6B67
        0x6B7F, # G+1565  U+6B7F  uni6B7F,  CJK UNIFIED IDEOGRAPH-6B7F
        0x6C13, # G+1566  U+6C13  uni6C13,  CJK UNIFIED IDEOGRAPH-6C13
        0x6C1B, # G+1567  U+6C1B  uni6C1B,  CJK UNIFIED IDEOGRAPH-6C1B
        0x6CE3, # G+1568  U+6CE3  uni6CE3,  CJK UNIFIED IDEOGRAPH-6CE3
        0x6CE8, # G+1569  U+6CE8  uni6CE8,  CJK UNIFIED IDEOGRAPH-6CE8
        0x6CF3, # G+1570  U+6CF3  uni6CF3,  CJK UNIFIED IDEOGRAPH-6CF3
        0x6CB1, # G+1571  U+6CB1  uni6CB1,  CJK UNIFIED IDEOGRAPH-6CB1
        0x6CCC, # G+1572  U+6CCC  uni6CCC,  CJK UNIFIED IDEOGRAPH-6CCC
        0x6CE5, # G+1573  U+6CE5  uni6CE5,  CJK UNIFIED IDEOGRAPH-6CE5
        0x6CB3, # G+1574  U+6CB3  uni6CB3,  CJK UNIFIED IDEOGRAPH-6CB3
        0x6CBD, # G+1575  U+6CBD  uni6CBD,  CJK UNIFIED IDEOGRAPH-6CBD
        0x6CBE, # G+1576  U+6CBE  uni6CBE,  CJK UNIFIED IDEOGRAPH-6CBE
        0x6CBC, # G+1577  U+6CBC  uni6CBC,  CJK UNIFIED IDEOGRAPH-6CBC
        0x6CE2, # G+1578  U+6CE2  uni6CE2,  CJK UNIFIED IDEOGRAPH-6CE2
        0x6CAB, # G+1579  U+6CAB  uni6CAB,  CJK UNIFIED IDEOGRAPH-6CAB
        0x6CD5, # G+1580  U+6CD5  uni6CD5,  CJK UNIFIED IDEOGRAPH-6CD5
        0x6CD3, # G+1581  U+6CD3  uni6CD3,  CJK UNIFIED IDEOGRAPH-6CD3
        0x6CB8, # G+1582  U+6CB8  uni6CB8,  CJK UNIFIED IDEOGRAPH-6CB8
        0x6CC4, # G+1583  U+6CC4  uni6CC4,  CJK UNIFIED IDEOGRAPH-6CC4
        0x6CB9, # G+1584  U+6CB9  uni6CB9,  CJK UNIFIED IDEOGRAPH-6CB9
        0x6CC1, # G+1585  U+6CC1  uni6CC1,  CJK UNIFIED IDEOGRAPH-6CC1
        0x6CAE, # G+1586  U+6CAE  uni6CAE,  CJK UNIFIED IDEOGRAPH-6CAE
        0x6CD7, # G+1587  U+6CD7  uni6CD7,  CJK UNIFIED IDEOGRAPH-6CD7
        0x6CC5, # G+1588  U+6CC5  uni6CC5,  CJK UNIFIED IDEOGRAPH-6CC5
        0x6CF1, # G+1589  U+6CF1  uni6CF1,  CJK UNIFIED IDEOGRAPH-6CF1
        0x6CBF, # G+1590  U+6CBF  uni6CBF,  CJK UNIFIED IDEOGRAPH-6CBF
        0x6CBB, # G+1591  U+6CBB  uni6CBB,  CJK UNIFIED IDEOGRAPH-6CBB
        0x6CE1, # G+1592  U+6CE1  uni6CE1,  CJK UNIFIED IDEOGRAPH-6CE1
        0x6CDB, # G+1593  U+6CDB  uni6CDB,  CJK UNIFIED IDEOGRAPH-6CDB
        0x6CCA, # G+1594  U+6CCA  uni6CCA,  CJK UNIFIED IDEOGRAPH-6CCA
        0x6CAC, # G+1595  U+6CAC  uni6CAC,  CJK UNIFIED IDEOGRAPH-6CAC
        0x6CEF, # G+1596  U+6CEF  uni6CEF,  CJK UNIFIED IDEOGRAPH-6CEF
        0x6CDC, # G+1597  U+6CDC  uni6CDC,  CJK UNIFIED IDEOGRAPH-6CDC
        0x6CD6, # G+1598  U+6CD6  uni6CD6,  CJK UNIFIED IDEOGRAPH-6CD6
        0x6CE0, # G+1599  U+6CE0  uni6CE0,  CJK UNIFIED IDEOGRAPH-6CE0
        0x7095, # G+1600  U+7095  uni7095,  CJK UNIFIED IDEOGRAPH-7095
        0x708E, # G+1601  U+708E  uni708E,  CJK UNIFIED IDEOGRAPH-708E
        0x7092, # G+1602  U+7092  uni7092,  CJK UNIFIED IDEOGRAPH-7092
        0x708A, # G+1603  U+708A  uni708A,  CJK UNIFIED IDEOGRAPH-708A
        0x7099, # G+1604  U+7099  uni7099,  CJK UNIFIED IDEOGRAPH-7099
        0x722C, # G+1605  U+722C  uni722C,  CJK UNIFIED IDEOGRAPH-722C
        0x722D, # G+1606  U+722D  uni722D,  CJK UNIFIED IDEOGRAPH-722D
        0x7238, # G+1607  U+7238  uni7238,  CJK UNIFIED IDEOGRAPH-7238
        0x7248, # G+1608  U+7248  uni7248,  CJK UNIFIED IDEOGRAPH-7248
        0x7267, # G+1609  U+7267  uni7267,  CJK UNIFIED IDEOGRAPH-7267
        0x7269, # G+1610  U+7269  uni7269,  CJK UNIFIED IDEOGRAPH-7269
        0x72C0, # G+1611  U+72C0  uni72C0,  CJK UNIFIED IDEOGRAPH-72C0
        0x72CE, # G+1612  U+72CE  uni72CE,  CJK UNIFIED IDEOGRAPH-72CE
        0x72D9, # G+1613  U+72D9  uni72D9,  CJK UNIFIED IDEOGRAPH-72D9
        0x72D7, # G+1614  U+72D7  uni72D7,  CJK UNIFIED IDEOGRAPH-72D7
        0x72D0, # G+1615  U+72D0  uni72D0,  CJK UNIFIED IDEOGRAPH-72D0
        0x73A9, # G+1616  U+73A9  uni73A9,  CJK UNIFIED IDEOGRAPH-73A9
        0x73A8, # G+1617  U+73A8  uni73A8,  CJK UNIFIED IDEOGRAPH-73A8
        0x739F, # G+1618  U+739F  uni739F,  CJK UNIFIED IDEOGRAPH-739F
        0x73AB, # G+1619  U+73AB  uni73AB,  CJK UNIFIED IDEOGRAPH-73AB
        0x73A5, # G+1620  U+73A5  uni73A5,  CJK UNIFIED IDEOGRAPH-73A5
        0x753D, # G+1621  U+753D  uni753D,  CJK UNIFIED IDEOGRAPH-753D
        0x759D, # G+1622  U+759D  uni759D,  CJK UNIFIED IDEOGRAPH-759D
        0x7599, # G+1623  U+7599  uni7599,  CJK UNIFIED IDEOGRAPH-7599
        0x759A, # G+1624  U+759A  uni759A,  CJK UNIFIED IDEOGRAPH-759A
        0x7684, # G+1625  U+7684  uni7684,  CJK UNIFIED IDEOGRAPH-7684
        0x76C2, # G+1626  U+76C2  uni76C2,  CJK UNIFIED IDEOGRAPH-76C2
        0x76F2, # G+1627  U+76F2  uni76F2,  CJK UNIFIED IDEOGRAPH-76F2
        0x76F4, # G+1628  U+76F4  uni76F4,  CJK UNIFIED IDEOGRAPH-76F4
        0x77E5, # G+1629  U+77E5  uni77E5,  CJK UNIFIED IDEOGRAPH-77E5
        0x77FD, # G+1630  U+77FD  uni77FD,  CJK UNIFIED IDEOGRAPH-77FD
        0x793E, # G+1631  U+793E  uni793E,  CJK UNIFIED IDEOGRAPH-793E
        0x7940, # G+1632  U+7940  uni7940,  CJK UNIFIED IDEOGRAPH-7940
        0x7941, # G+1633  U+7941  uni7941,  CJK UNIFIED IDEOGRAPH-7941
        0x79C9, # G+1634  U+79C9  uni79C9,  CJK UNIFIED IDEOGRAPH-79C9
        0x79C8, # G+1635  U+79C8  uni79C8,  CJK UNIFIED IDEOGRAPH-79C8
        0x7A7A, # G+1636  U+7A7A  uni7A7A,  CJK UNIFIED IDEOGRAPH-7A7A
        0x7A79, # G+1637  U+7A79  uni7A79,  CJK UNIFIED IDEOGRAPH-7A79
        0x7AFA, # G+1638  U+7AFA  uni7AFA,  CJK UNIFIED IDEOGRAPH-7AFA
        0x7CFE, # G+1639  U+7CFE  uni7CFE,  CJK UNIFIED IDEOGRAPH-7CFE
        0x7F54, # G+1640  U+7F54  uni7F54,  CJK UNIFIED IDEOGRAPH-7F54
        0x7F8C, # G+1641  U+7F8C  uni7F8C,  CJK UNIFIED IDEOGRAPH-7F8C
        0x7F8B, # G+1642  U+7F8B  uni7F8B,  CJK UNIFIED IDEOGRAPH-7F8B
        0x8005, # G+1643  U+8005  uni8005,  CJK UNIFIED IDEOGRAPH-8005
        0x80BA, # G+1644  U+80BA  uni80BA,  CJK UNIFIED IDEOGRAPH-80BA
        0x80A5, # G+1645  U+80A5  uni80A5,  CJK UNIFIED IDEOGRAPH-80A5
        0x80A2, # G+1646  U+80A2  uni80A2,  CJK UNIFIED IDEOGRAPH-80A2
        0x80B1, # G+1647  U+80B1  uni80B1,  CJK UNIFIED IDEOGRAPH-80B1
        0x80A1, # G+1648  U+80A1  uni80A1,  CJK UNIFIED IDEOGRAPH-80A1
        0x80AB, # G+1649  U+80AB  uni80AB,  CJK UNIFIED IDEOGRAPH-80AB
        0x80A9, # G+1650  U+80A9  uni80A9,  CJK UNIFIED IDEOGRAPH-80A9
        0x80B4, # G+1651  U+80B4  uni80B4,  CJK UNIFIED IDEOGRAPH-80B4
        0x80AA, # G+1652  U+80AA  uni80AA,  CJK UNIFIED IDEOGRAPH-80AA
        0x80AF, # G+1653  U+80AF  uni80AF,  CJK UNIFIED IDEOGRAPH-80AF
        0x81E5, # G+1654  U+81E5  uni81E5,  CJK UNIFIED IDEOGRAPH-81E5
        0x81FE, # G+1655  U+81FE  uni81FE,  CJK UNIFIED IDEOGRAPH-81FE
        0x820D, # G+1656  U+820D  uni820D,  CJK UNIFIED IDEOGRAPH-820D
        0x82B3, # G+1657  U+82B3  uni82B3,  CJK UNIFIED IDEOGRAPH-82B3
        0x829D, # G+1658  U+829D  uni829D,  CJK UNIFIED IDEOGRAPH-829D
        0x8299, # G+1659  U+8299  uni8299,  CJK UNIFIED IDEOGRAPH-8299
        0x82AD, # G+1660  U+82AD  uni82AD,  CJK UNIFIED IDEOGRAPH-82AD
        0x82BD, # G+1661  U+82BD  uni82BD,  CJK UNIFIED IDEOGRAPH-82BD
        0x829F, # G+1662  U+829F  uni829F,  CJK UNIFIED IDEOGRAPH-829F
        0x82B9, # G+1663  U+82B9  uni82B9,  CJK UNIFIED IDEOGRAPH-82B9
        0x82B1, # G+1664  U+82B1  uni82B1,  CJK UNIFIED IDEOGRAPH-82B1
        0x82AC, # G+1665  U+82AC  uni82AC,  CJK UNIFIED IDEOGRAPH-82AC
        0x82A5, # G+1666  U+82A5  uni82A5,  CJK UNIFIED IDEOGRAPH-82A5
        0x82AF, # G+1667  U+82AF  uni82AF,  CJK UNIFIED IDEOGRAPH-82AF
        0x82B8, # G+1668  U+82B8  uni82B8,  CJK UNIFIED IDEOGRAPH-82B8
        0x82A3, # G+1669  U+82A3  uni82A3,  CJK UNIFIED IDEOGRAPH-82A3
        0x82B0, # G+1670  U+82B0  uni82B0,  CJK UNIFIED IDEOGRAPH-82B0
        0x82BE, # G+1671  U+82BE  uni82BE,  CJK UNIFIED IDEOGRAPH-82BE
        0x82B7, # G+1672  U+82B7  uni82B7,  CJK UNIFIED IDEOGRAPH-82B7
        0x864E, # G+1673  U+864E  uni864E,  CJK UNIFIED IDEOGRAPH-864E
        0x8671, # G+1674  U+8671  uni8671,  CJK UNIFIED IDEOGRAPH-8671
        0x521D, # G+1675  U+521D  uni521D,  CJK UNIFIED IDEOGRAPH-521D
        0x8868, # G+1676  U+8868  uni8868,  CJK UNIFIED IDEOGRAPH-8868
        0x8ECB, # G+1677  U+8ECB  uni8ECB,  CJK UNIFIED IDEOGRAPH-8ECB
        0x8FCE, # G+1678  U+8FCE  uni8FCE,  CJK UNIFIED IDEOGRAPH-8FCE
        0x8FD4, # G+1679  U+8FD4  uni8FD4,  CJK UNIFIED IDEOGRAPH-8FD4
        0x8FD1, # G+1680  U+8FD1  uni8FD1,  CJK UNIFIED IDEOGRAPH-8FD1
        0x90B5, # G+1681  U+90B5  uni90B5,  CJK UNIFIED IDEOGRAPH-90B5
        0x90B8, # G+1682  U+90B8  uni90B8,  CJK UNIFIED IDEOGRAPH-90B8
        0x90B1, # G+1683  U+90B1  uni90B1,  CJK UNIFIED IDEOGRAPH-90B1
        0x90B6, # G+1684  U+90B6  uni90B6,  CJK UNIFIED IDEOGRAPH-90B6
        0x91C7, # G+1685  U+91C7  uni91C7,  CJK UNIFIED IDEOGRAPH-91C7
        0x91D1, # G+1686  U+91D1  uni91D1,  CJK UNIFIED IDEOGRAPH-91D1
        0x9577, # G+1687  U+9577  uni9577,  CJK UNIFIED IDEOGRAPH-9577
        0x9580, # G+1688  U+9580  uni9580,  CJK UNIFIED IDEOGRAPH-9580
        0x961C, # G+1689  U+961C  uni961C,  CJK UNIFIED IDEOGRAPH-961C
        0x9640, # G+1690  U+9640  uni9640,  CJK UNIFIED IDEOGRAPH-9640
        0x963F, # G+1691  U+963F  uni963F,  CJK UNIFIED IDEOGRAPH-963F
        0x963B, # G+1692  U+963B  uni963B,  CJK UNIFIED IDEOGRAPH-963B
        0x9644, # G+1693  U+9644  uni9644,  CJK UNIFIED IDEOGRAPH-9644
        0x9642, # G+1694  U+9642  uni9642,  CJK UNIFIED IDEOGRAPH-9642
        0x96B9, # G+1695  U+96B9  uni96B9,  CJK UNIFIED IDEOGRAPH-96B9
        0x96E8, # G+1696  U+96E8  uni96E8,  CJK UNIFIED IDEOGRAPH-96E8
        0x9752, # G+1697  U+9752  uni9752,  CJK UNIFIED IDEOGRAPH-9752
        0x2FAE, # G+1698  U+2FAE  uni2FAE,  KANGXI RADICAL WRONG
        0x4E9F, # G+1699  U+4E9F  uni4E9F,  CJK UNIFIED IDEOGRAPH-4E9F
        0x4EAD, # G+1700  U+4EAD  uni4EAD,  CJK UNIFIED IDEOGRAPH-4EAD
        0x4EAE, # G+1701  U+4EAE  uni4EAE,  CJK UNIFIED IDEOGRAPH-4EAE
        0x4FE1, # G+1702  U+4FE1  uni4FE1,  CJK UNIFIED IDEOGRAPH-4FE1
        0x4FB5, # G+1703  U+4FB5  uni4FB5,  CJK UNIFIED IDEOGRAPH-4FB5
        0x4FAF, # G+1704  U+4FAF  uni4FAF,  CJK UNIFIED IDEOGRAPH-4FAF
        0x4FBF, # G+1705  U+4FBF  uni4FBF,  CJK UNIFIED IDEOGRAPH-4FBF
        0x4FE0, # G+1706  U+4FE0  uni4FE0,  CJK UNIFIED IDEOGRAPH-4FE0
        0x4FD1, # G+1707  U+4FD1  uni4FD1,  CJK UNIFIED IDEOGRAPH-4FD1
        0x4FCF, # G+1708  U+4FCF  uni4FCF,  CJK UNIFIED IDEOGRAPH-4FCF
        0x4FDD, # G+1709  U+4FDD  uni4FDD,  CJK UNIFIED IDEOGRAPH-4FDD
        0x4FC3, # G+1710  U+4FC3  uni4FC3,  CJK UNIFIED IDEOGRAPH-4FC3
        0x4FB6, # G+1711  U+4FB6  uni4FB6,  CJK UNIFIED IDEOGRAPH-4FB6
        0x4FD8, # G+1712  U+4FD8  uni4FD8,  CJK UNIFIED IDEOGRAPH-4FD8
        0x4FDF, # G+1713  U+4FDF  uni4FDF,  CJK UNIFIED IDEOGRAPH-4FDF
        0x4FCA, # G+1714  U+4FCA  uni4FCA,  CJK UNIFIED IDEOGRAPH-4FCA
        0x4FD7, # G+1715  U+4FD7  uni4FD7,  CJK UNIFIED IDEOGRAPH-4FD7
        0x4FAE, # G+1716  U+4FAE  uni4FAE,  CJK UNIFIED IDEOGRAPH-4FAE
        0x4FD0, # G+1717  U+4FD0  uni4FD0,  CJK UNIFIED IDEOGRAPH-4FD0
        0x4FC4, # G+1718  U+4FC4  uni4FC4,  CJK UNIFIED IDEOGRAPH-4FC4
        0x4FC2, # G+1719  U+4FC2  uni4FC2,  CJK UNIFIED IDEOGRAPH-4FC2
        0x4FDA, # G+1720  U+4FDA  uni4FDA,  CJK UNIFIED IDEOGRAPH-4FDA
        0x4FCE, # G+1721  U+4FCE  uni4FCE,  CJK UNIFIED IDEOGRAPH-4FCE
        0x4FDE, # G+1722  U+4FDE  uni4FDE,  CJK UNIFIED IDEOGRAPH-4FDE
        0x4FB7, # G+1723  U+4FB7  uni4FB7,  CJK UNIFIED IDEOGRAPH-4FB7
        0x5157, # G+1724  U+5157  uni5157,  CJK UNIFIED IDEOGRAPH-5157
        0x5192, # G+1725  U+5192  uni5192,  CJK UNIFIED IDEOGRAPH-5192
        0x5191, # G+1726  U+5191  uni5191,  CJK UNIFIED IDEOGRAPH-5191
        0x51A0, # G+1727  U+51A0  uni51A0,  CJK UNIFIED IDEOGRAPH-51A0
        0x524E, # G+1728  U+524E  uni524E,  CJK UNIFIED IDEOGRAPH-524E
        0x5243, # G+1729  U+5243  uni5243,  CJK UNIFIED IDEOGRAPH-5243
        0x524A, # G+1730  U+524A  uni524A,  CJK UNIFIED IDEOGRAPH-524A
        0x524D, # G+1731  U+524D  uni524D,  CJK UNIFIED IDEOGRAPH-524D
        0x524C, # G+1732  U+524C  uni524C,  CJK UNIFIED IDEOGRAPH-524C
        0x524B, # G+1733  U+524B  uni524B,  CJK UNIFIED IDEOGRAPH-524B
        0x5247, # G+1734  U+5247  uni5247,  CJK UNIFIED IDEOGRAPH-5247
        0x52C7, # G+1735  U+52C7  uni52C7,  CJK UNIFIED IDEOGRAPH-52C7
        0x52C9, # G+1736  U+52C9  uni52C9,  CJK UNIFIED IDEOGRAPH-52C9
        0x52C3, # G+1737  U+52C3  uni52C3,  CJK UNIFIED IDEOGRAPH-52C3
        0x52C1, # G+1738  U+52C1  uni52C1,  CJK UNIFIED IDEOGRAPH-52C1
        0x530D, # G+1739  U+530D  uni530D,  CJK UNIFIED IDEOGRAPH-530D
        0x5357, # G+1740  U+5357  uni5357,  CJK UNIFIED IDEOGRAPH-5357
        0x537B, # G+1741  U+537B  uni537B,  CJK UNIFIED IDEOGRAPH-537B
        0x539A, # G+1742  U+539A  uni539A,  CJK UNIFIED IDEOGRAPH-539A
        0x53DB, # G+1743  U+53DB  uni53DB,  CJK UNIFIED IDEOGRAPH-53DB
        0x54AC, # G+1744  U+54AC  uni54AC,  CJK UNIFIED IDEOGRAPH-54AC
        0x54C0, # G+1745  U+54C0  uni54C0,  CJK UNIFIED IDEOGRAPH-54C0
        0x54A8, # G+1746  U+54A8  uni54A8,  CJK UNIFIED IDEOGRAPH-54A8
        0x54CE, # G+1747  U+54CE  uni54CE,  CJK UNIFIED IDEOGRAPH-54CE
        0x54C9, # G+1748  U+54C9  uni54C9,  CJK UNIFIED IDEOGRAPH-54C9
        0x54B8, # G+1749  U+54B8  uni54B8,  CJK UNIFIED IDEOGRAPH-54B8
        0x54A6, # G+1750  U+54A6  uni54A6,  CJK UNIFIED IDEOGRAPH-54A6
        0x54B3, # G+1751  U+54B3  uni54B3,  CJK UNIFIED IDEOGRAPH-54B3
        0x54C7, # G+1752  U+54C7  uni54C7,  CJK UNIFIED IDEOGRAPH-54C7
        0x54C2, # G+1753  U+54C2  uni54C2,  CJK UNIFIED IDEOGRAPH-54C2
        0x54BD, # G+1754  U+54BD  uni54BD,  CJK UNIFIED IDEOGRAPH-54BD
        0x54AA, # G+1755  U+54AA  uni54AA,  CJK UNIFIED IDEOGRAPH-54AA
        0x54C1, # G+1756  U+54C1  uni54C1,  CJK UNIFIED IDEOGRAPH-54C1
        0x54C4, # G+1757  U+54C4  uni54C4,  CJK UNIFIED IDEOGRAPH-54C4
        0x54C8, # G+1758  U+54C8  uni54C8,  CJK UNIFIED IDEOGRAPH-54C8
        0x54AF, # G+1759  U+54AF  uni54AF,  CJK UNIFIED IDEOGRAPH-54AF
        0x54AB, # G+1760  U+54AB  uni54AB,  CJK UNIFIED IDEOGRAPH-54AB
        0x54B1, # G+1761  U+54B1  uni54B1,  CJK UNIFIED IDEOGRAPH-54B1
        0x54BB, # G+1762  U+54BB  uni54BB,  CJK UNIFIED IDEOGRAPH-54BB
        0x54A9, # G+1763  U+54A9  uni54A9,  CJK UNIFIED IDEOGRAPH-54A9
        0x54A7, # G+1764  U+54A7  uni54A7,  CJK UNIFIED IDEOGRAPH-54A7
        0x54BF, # G+1765  U+54BF  uni54BF,  CJK UNIFIED IDEOGRAPH-54BF
        0x56FF, # G+1766  U+56FF  uni56FF,  CJK UNIFIED IDEOGRAPH-56FF
        0x5782, # G+1767  U+5782  uni5782,  CJK UNIFIED IDEOGRAPH-5782
        0x578B, # G+1768  U+578B  uni578B,  CJK UNIFIED IDEOGRAPH-578B
        0x57A0, # G+1769  U+57A0  uni57A0,  CJK UNIFIED IDEOGRAPH-57A0
        0x57A3, # G+1770  U+57A3  uni57A3,  CJK UNIFIED IDEOGRAPH-57A3
        0x57A2, # G+1771  U+57A2  uni57A2,  CJK UNIFIED IDEOGRAPH-57A2
        0x57CE, # G+1772  U+57CE  uni57CE,  CJK UNIFIED IDEOGRAPH-57CE
        0x57AE, # G+1773  U+57AE  uni57AE,  CJK UNIFIED IDEOGRAPH-57AE
        0x5793, # G+1774  U+5793  uni5793,  CJK UNIFIED IDEOGRAPH-5793
        0x5955, # G+1775  U+5955  uni5955,  CJK UNIFIED IDEOGRAPH-5955
        0x5951, # G+1776  U+5951  uni5951,  CJK UNIFIED IDEOGRAPH-5951
        0x594F, # G+1777  U+594F  uni594F,  CJK UNIFIED IDEOGRAPH-594F
        0x594E, # G+1778  U+594E  uni594E,  CJK UNIFIED IDEOGRAPH-594E
        0x5950, # G+1779  U+5950  uni5950,  CJK UNIFIED IDEOGRAPH-5950
        0x59DC, # G+1780  U+59DC  uni59DC,  CJK UNIFIED IDEOGRAPH-59DC
        0x59D8, # G+1781  U+59D8  uni59D8,  CJK UNIFIED IDEOGRAPH-59D8
        0x59FF, # G+1782  U+59FF  uni59FF,  CJK UNIFIED IDEOGRAPH-59FF
        0x59E3, # G+1783  U+59E3  uni59E3,  CJK UNIFIED IDEOGRAPH-59E3
        0x59E8, # G+1784  U+59E8  uni59E8,  CJK UNIFIED IDEOGRAPH-59E8
        0x5A03, # G+1785  U+5A03  uni5A03,  CJK UNIFIED IDEOGRAPH-5A03
        0x59E5, # G+1786  U+59E5  uni59E5,  CJK UNIFIED IDEOGRAPH-59E5
        0x59EA, # G+1787  U+59EA  uni59EA,  CJK UNIFIED IDEOGRAPH-59EA
        0x59DA, # G+1788  U+59DA  uni59DA,  CJK UNIFIED IDEOGRAPH-59DA
        0x59E6, # G+1789  U+59E6  uni59E6,  CJK UNIFIED IDEOGRAPH-59E6
        0x5A01, # G+1790  U+5A01  uni5A01,  CJK UNIFIED IDEOGRAPH-5A01
        0x59FB, # G+1791  U+59FB  uni59FB,  CJK UNIFIED IDEOGRAPH-59FB
        0x5B69, # G+1792  U+5B69  uni5B69,  CJK UNIFIED IDEOGRAPH-5B69
        0x5BA3, # G+1793  U+5BA3  uni5BA3,  CJK UNIFIED IDEOGRAPH-5BA3
        0x5BA6, # G+1794  U+5BA6  uni5BA6,  CJK UNIFIED IDEOGRAPH-5BA6
        0x5BA4, # G+1795  U+5BA4  uni5BA4,  CJK UNIFIED IDEOGRAPH-5BA4
        0x5BA2, # G+1796  U+5BA2  uni5BA2,  CJK UNIFIED IDEOGRAPH-5BA2
        0x5BA5, # G+1797  U+5BA5  uni5BA5,  CJK UNIFIED IDEOGRAPH-5BA5
        0x5C01, # G+1798  U+5C01  uni5C01,  CJK UNIFIED IDEOGRAPH-5C01
        0x5C4E, # G+1799  U+5C4E  uni5C4E,  CJK UNIFIED IDEOGRAPH-5C4E
        0x5C4F, # G+1800  U+5C4F  uni5C4F,  CJK UNIFIED IDEOGRAPH-5C4F
        0x5C4D, # G+1801  U+5C4D  uni5C4D,  CJK UNIFIED IDEOGRAPH-5C4D
        0x5C4B, # G+1802  U+5C4B  uni5C4B,  CJK UNIFIED IDEOGRAPH-5C4B
        0x5CD9, # G+1803  U+5CD9  uni5CD9,  CJK UNIFIED IDEOGRAPH-5CD9
        0x5CD2, # G+1804  U+5CD2  uni5CD2,  CJK UNIFIED IDEOGRAPH-5CD2
        0x5DF7, # G+1805  U+5DF7  uni5DF7,  CJK UNIFIED IDEOGRAPH-5DF7
        0x5E1D, # G+1806  U+5E1D  uni5E1D,  CJK UNIFIED IDEOGRAPH-5E1D
        0x5E25, # G+1807  U+5E25  uni5E25,  CJK UNIFIED IDEOGRAPH-5E25
        0x5E1F, # G+1808  U+5E1F  uni5E1F,  CJK UNIFIED IDEOGRAPH-5E1F
        0x5E7D, # G+1809  U+5E7D  uni5E7D,  CJK UNIFIED IDEOGRAPH-5E7D
        0x5EA0, # G+1810  U+5EA0  uni5EA0,  CJK UNIFIED IDEOGRAPH-5EA0
        0x5EA6, # G+1811  U+5EA6  uni5EA6,  CJK UNIFIED IDEOGRAPH-5EA6
        0x5EFA, # G+1812  U+5EFA  uni5EFA,  CJK UNIFIED IDEOGRAPH-5EFA
        0x5F08, # G+1813  U+5F08  uni5F08,  CJK UNIFIED IDEOGRAPH-5F08
        0x5F2D, # G+1814  U+5F2D  uni5F2D,  CJK UNIFIED IDEOGRAPH-5F2D
        0x5F65, # G+1815  U+5F65  uni5F65,  CJK UNIFIED IDEOGRAPH-5F65
        0x5F88, # G+1816  U+5F88  uni5F88,  CJK UNIFIED IDEOGRAPH-5F88
        0x5F85, # G+1817  U+5F85  uni5F85,  CJK UNIFIED IDEOGRAPH-5F85
        0x5F8A, # G+1818  U+5F8A  uni5F8A,  CJK UNIFIED IDEOGRAPH-5F8A
        0x5F8B, # G+1819  U+5F8B  uni5F8B,  CJK UNIFIED IDEOGRAPH-5F8B
        0x5F87, # G+1820  U+5F87  uni5F87,  CJK UNIFIED IDEOGRAPH-5F87
        0x5F8C, # G+1821  U+5F8C  uni5F8C,  CJK UNIFIED IDEOGRAPH-5F8C
        0x5F89, # G+1822  U+5F89  uni5F89,  CJK UNIFIED IDEOGRAPH-5F89
        0x6012, # G+1823  U+6012  uni6012,  CJK UNIFIED IDEOGRAPH-6012
        0x601D, # G+1824  U+601D  uni601D,  CJK UNIFIED IDEOGRAPH-601D
        0x6020, # G+1825  U+6020  uni6020,  CJK UNIFIED IDEOGRAPH-6020
        0x6025, # G+1826  U+6025  uni6025,  CJK UNIFIED IDEOGRAPH-6025
        0x600E, # G+1827  U+600E  uni600E,  CJK UNIFIED IDEOGRAPH-600E
        0x6028, # G+1828  U+6028  uni6028,  CJK UNIFIED IDEOGRAPH-6028
        0x604D, # G+1829  U+604D  uni604D,  CJK UNIFIED IDEOGRAPH-604D
        0x6070, # G+1830  U+6070  uni6070,  CJK UNIFIED IDEOGRAPH-6070
        0x6068, # G+1831  U+6068  uni6068,  CJK UNIFIED IDEOGRAPH-6068
        0x6062, # G+1832  U+6062  uni6062,  CJK UNIFIED IDEOGRAPH-6062
        0x6046, # G+1833  U+6046  uni6046,  CJK UNIFIED IDEOGRAPH-6046
        0x6043, # G+1834  U+6043  uni6043,  CJK UNIFIED IDEOGRAPH-6043
        0x606C, # G+1835  U+606C  uni606C,  CJK UNIFIED IDEOGRAPH-606C
        0x606B, # G+1836  U+606B  uni606B,  CJK UNIFIED IDEOGRAPH-606B
        0x606A, # G+1837  U+606A  uni606A,  CJK UNIFIED IDEOGRAPH-606A
        0x6064, # G+1838  U+6064  uni6064,  CJK UNIFIED IDEOGRAPH-6064
        0x6241, # G+1839  U+6241  uni6241,  CJK UNIFIED IDEOGRAPH-6241
        0x62DC, # G+1840  U+62DC  uni62DC,  CJK UNIFIED IDEOGRAPH-62DC
        0x6316, # G+1841  U+6316  uni6316,  CJK UNIFIED IDEOGRAPH-6316
        0x6309, # G+1842  U+6309  uni6309,  CJK UNIFIED IDEOGRAPH-6309
        0x62FC, # G+1843  U+62FC  uni62FC,  CJK UNIFIED IDEOGRAPH-62FC
        0x62ED, # G+1844  U+62ED  uni62ED,  CJK UNIFIED IDEOGRAPH-62ED
        0x6301, # G+1845  U+6301  uni6301,  CJK UNIFIED IDEOGRAPH-6301
        0x62EE, # G+1846  U+62EE  uni62EE,  CJK UNIFIED IDEOGRAPH-62EE
        0x62FD, # G+1847  U+62FD  uni62FD,  CJK UNIFIED IDEOGRAPH-62FD
        0x6307, # G+1848  U+6307  uni6307,  CJK UNIFIED IDEOGRAPH-6307
        0x62F1, # G+1849  U+62F1  uni62F1,  CJK UNIFIED IDEOGRAPH-62F1
        0x62F7, # G+1850  U+62F7  uni62F7,  CJK UNIFIED IDEOGRAPH-62F7
        0x62EF, # G+1851  U+62EF  uni62EF,  CJK UNIFIED IDEOGRAPH-62EF
        0x62EC, # G+1852  U+62EC  uni62EC,  CJK UNIFIED IDEOGRAPH-62EC
        0x62FE, # G+1853  U+62FE  uni62FE,  CJK UNIFIED IDEOGRAPH-62FE
        0x62F4, # G+1854  U+62F4  uni62F4,  CJK UNIFIED IDEOGRAPH-62F4
        0x6311, # G+1855  U+6311  uni6311,  CJK UNIFIED IDEOGRAPH-6311
        0x6302, # G+1856  U+6302  uni6302,  CJK UNIFIED IDEOGRAPH-6302
        0x653F, # G+1857  U+653F  uni653F,  CJK UNIFIED IDEOGRAPH-653F
        0x6545, # G+1858  U+6545  uni6545,  CJK UNIFIED IDEOGRAPH-6545
        0x65AB, # G+1859  U+65AB  uni65AB,  CJK UNIFIED IDEOGRAPH-65AB
        0x65BD, # G+1860  U+65BD  uni65BD,  CJK UNIFIED IDEOGRAPH-65BD
        0x65E2, # G+1861  U+65E2  uni65E2,  CJK UNIFIED IDEOGRAPH-65E2
        0x6625, # G+1862  U+6625  uni6625,  CJK UNIFIED IDEOGRAPH-6625
        0x662D, # G+1863  U+662D  uni662D,  CJK UNIFIED IDEOGRAPH-662D
        0x6620, # G+1864  U+6620  uni6620,  CJK UNIFIED IDEOGRAPH-6620
        0x6627, # G+1865  U+6627  uni6627,  CJK UNIFIED IDEOGRAPH-6627
        0x662F, # G+1866  U+662F  uni662F,  CJK UNIFIED IDEOGRAPH-662F
        0x661F, # G+1867  U+661F  uni661F,  CJK UNIFIED IDEOGRAPH-661F
        0x6628, # G+1868  U+6628  uni6628,  CJK UNIFIED IDEOGRAPH-6628
        0x6631, # G+1869  U+6631  uni6631,  CJK UNIFIED IDEOGRAPH-6631
        0x6624, # G+1870  U+6624  uni6624,  CJK UNIFIED IDEOGRAPH-6624
        0x66F7, # G+1871  U+66F7  uni66F7,  CJK UNIFIED IDEOGRAPH-66F7
        0x67FF, # G+1872  U+67FF  uni67FF,  CJK UNIFIED IDEOGRAPH-67FF
        0x67D3, # G+1873  U+67D3  uni67D3,  CJK UNIFIED IDEOGRAPH-67D3
        0x67F1, # G+1874  U+67F1  uni67F1,  CJK UNIFIED IDEOGRAPH-67F1
        0x67D4, # G+1875  U+67D4  uni67D4,  CJK UNIFIED IDEOGRAPH-67D4
        0x67D0, # G+1876  U+67D0  uni67D0,  CJK UNIFIED IDEOGRAPH-67D0
        0x67EC, # G+1877  U+67EC  uni67EC,  CJK UNIFIED IDEOGRAPH-67EC
        0x67B6, # G+1878  U+67B6  uni67B6,  CJK UNIFIED IDEOGRAPH-67B6
        0x67AF, # G+1879  U+67AF  uni67AF,  CJK UNIFIED IDEOGRAPH-67AF
        0x67F5, # G+1880  U+67F5  uni67F5,  CJK UNIFIED IDEOGRAPH-67F5
        0x67E9, # G+1881  U+67E9  uni67E9,  CJK UNIFIED IDEOGRAPH-67E9
        0x67EF, # G+1882  U+67EF  uni67EF,  CJK UNIFIED IDEOGRAPH-67EF
        0x67C4, # G+1883  U+67C4  uni67C4,  CJK UNIFIED IDEOGRAPH-67C4
        0x67D1, # G+1884  U+67D1  uni67D1,  CJK UNIFIED IDEOGRAPH-67D1
        0x67B4, # G+1885  U+67B4  uni67B4,  CJK UNIFIED IDEOGRAPH-67B4
        0x67DA, # G+1886  U+67DA  uni67DA,  CJK UNIFIED IDEOGRAPH-67DA
        0x67E5, # G+1887  U+67E5  uni67E5,  CJK UNIFIED IDEOGRAPH-67E5
        0x67B8, # G+1888  U+67B8  uni67B8,  CJK UNIFIED IDEOGRAPH-67B8
        0x67CF, # G+1889  U+67CF  uni67CF,  CJK UNIFIED IDEOGRAPH-67CF
        0x67DE, # G+1890  U+67DE  uni67DE,  CJK UNIFIED IDEOGRAPH-67DE
        0x67F3, # G+1891  U+67F3  uni67F3,  CJK UNIFIED IDEOGRAPH-67F3
        0x67B0, # G+1892  U+67B0  uni67B0,  CJK UNIFIED IDEOGRAPH-67B0
        0x67D9, # G+1893  U+67D9  uni67D9,  CJK UNIFIED IDEOGRAPH-67D9
        0x67E2, # G+1894  U+67E2  uni67E2,  CJK UNIFIED IDEOGRAPH-67E2
        0x67DD, # G+1895  U+67DD  uni67DD,  CJK UNIFIED IDEOGRAPH-67DD
        0x67D2, # G+1896  U+67D2  uni67D2,  CJK UNIFIED IDEOGRAPH-67D2
        0x6B6A, # G+1897  U+6B6A  uni6B6A,  CJK UNIFIED IDEOGRAPH-6B6A
        0x6B83, # G+1898  U+6B83  uni6B83,  CJK UNIFIED IDEOGRAPH-6B83
        0x6B86, # G+1899  U+6B86  uni6B86,  CJK UNIFIED IDEOGRAPH-6B86
        0x6BB5, # G+1900  U+6BB5  uni6BB5,  CJK UNIFIED IDEOGRAPH-6BB5
        0x6BD2, # G+1901  U+6BD2  uni6BD2,  CJK UNIFIED IDEOGRAPH-6BD2
        0x6BD7, # G+1902  U+6BD7  uni6BD7,  CJK UNIFIED IDEOGRAPH-6BD7
        0x6C1F, # G+1903  U+6C1F  uni6C1F,  CJK UNIFIED IDEOGRAPH-6C1F
        0x6CC9, # G+1904  U+6CC9  uni6CC9,  CJK UNIFIED IDEOGRAPH-6CC9
        0x6D0B, # G+1905  U+6D0B  uni6D0B,  CJK UNIFIED IDEOGRAPH-6D0B
        0x6D32, # G+1906  U+6D32  uni6D32,  CJK UNIFIED IDEOGRAPH-6D32
        0x6D2A, # G+1907  U+6D2A  uni6D2A,  CJK UNIFIED IDEOGRAPH-6D2A
        0x6D41, # G+1908  U+6D41  uni6D41,  CJK UNIFIED IDEOGRAPH-6D41
        0x6D25, # G+1909  U+6D25  uni6D25,  CJK UNIFIED IDEOGRAPH-6D25
        0x6D0C, # G+1910  U+6D0C  uni6D0C,  CJK UNIFIED IDEOGRAPH-6D0C
        0x6D31, # G+1911  U+6D31  uni6D31,  CJK UNIFIED IDEOGRAPH-6D31
        0x6D1E, # G+1912  U+6D1E  uni6D1E,  CJK UNIFIED IDEOGRAPH-6D1E
        0x6D17, # G+1913  U+6D17  uni6D17,  CJK UNIFIED IDEOGRAPH-6D17
        0x6D3B, # G+1914  U+6D3B  uni6D3B,  CJK UNIFIED IDEOGRAPH-6D3B
        0x6D3D, # G+1915  U+6D3D  uni6D3D,  CJK UNIFIED IDEOGRAPH-6D3D
        0x6D3E, # G+1916  U+6D3E  uni6D3E,  CJK UNIFIED IDEOGRAPH-6D3E
        0x6D36, # G+1917  U+6D36  uni6D36,  CJK UNIFIED IDEOGRAPH-6D36
        0x6D1B, # G+1918  U+6D1B  uni6D1B,  CJK UNIFIED IDEOGRAPH-6D1B
        0x6CF5, # G+1919  U+6CF5  uni6CF5,  CJK UNIFIED IDEOGRAPH-6CF5
        0x6D39, # G+1920  U+6D39  uni6D39,  CJK UNIFIED IDEOGRAPH-6D39
        0x6D27, # G+1921  U+6D27  uni6D27,  CJK UNIFIED IDEOGRAPH-6D27
        0x6D38, # G+1922  U+6D38  uni6D38,  CJK UNIFIED IDEOGRAPH-6D38
        0x6D29, # G+1923  U+6D29  uni6D29,  CJK UNIFIED IDEOGRAPH-6D29
        0x6D2E, # G+1924  U+6D2E  uni6D2E,  CJK UNIFIED IDEOGRAPH-6D2E
        0x6D35, # G+1925  U+6D35  uni6D35,  CJK UNIFIED IDEOGRAPH-6D35
        0x6D0E, # G+1926  U+6D0E  uni6D0E,  CJK UNIFIED IDEOGRAPH-6D0E
        0x6D2B, # G+1927  U+6D2B  uni6D2B,  CJK UNIFIED IDEOGRAPH-6D2B
        0x70AB, # G+1928  U+70AB  uni70AB,  CJK UNIFIED IDEOGRAPH-70AB
        0x70BA, # G+1929  U+70BA  uni70BA,  CJK UNIFIED IDEOGRAPH-70BA
        0x70B3, # G+1930  U+70B3  uni70B3,  CJK UNIFIED IDEOGRAPH-70B3
        0x70AC, # G+1931  U+70AC  uni70AC,  CJK UNIFIED IDEOGRAPH-70AC
        0x70AF, # G+1932  U+70AF  uni70AF,  CJK UNIFIED IDEOGRAPH-70AF
        0x70AD, # G+1933  U+70AD  uni70AD,  CJK UNIFIED IDEOGRAPH-70AD
        0x70B8, # G+1934  U+70B8  uni70B8,  CJK UNIFIED IDEOGRAPH-70B8
        0x70AE, # G+1935  U+70AE  uni70AE,  CJK UNIFIED IDEOGRAPH-70AE
        0x70A4, # G+1936  U+70A4  uni70A4,  CJK UNIFIED IDEOGRAPH-70A4
        0x7230, # G+1937  U+7230  uni7230,  CJK UNIFIED IDEOGRAPH-7230
        0x7272, # G+1938  U+7272  uni7272,  CJK UNIFIED IDEOGRAPH-7272
        0x726F, # G+1939  U+726F  uni726F,  CJK UNIFIED IDEOGRAPH-726F
        0x7274, # G+1940  U+7274  uni7274,  CJK UNIFIED IDEOGRAPH-7274
        0x72E9, # G+1941  U+72E9  uni72E9,  CJK UNIFIED IDEOGRAPH-72E9
        0x72E0, # G+1942  U+72E0  uni72E0,  CJK UNIFIED IDEOGRAPH-72E0
        0x72E1, # G+1943  U+72E1  uni72E1,  CJK UNIFIED IDEOGRAPH-72E1
        0x73B7, # G+1944  U+73B7  uni73B7,  CJK UNIFIED IDEOGRAPH-73B7
        0x73CA, # G+1945  U+73CA  uni73CA,  CJK UNIFIED IDEOGRAPH-73CA
        0x73BB, # G+1946  U+73BB  uni73BB,  CJK UNIFIED IDEOGRAPH-73BB
        0x73B2, # G+1947  U+73B2  uni73B2,  CJK UNIFIED IDEOGRAPH-73B2
        0x73CD, # G+1948  U+73CD  uni73CD,  CJK UNIFIED IDEOGRAPH-73CD
        0x73C0, # G+1949  U+73C0  uni73C0,  CJK UNIFIED IDEOGRAPH-73C0
        0x73B3, # G+1950  U+73B3  uni73B3,  CJK UNIFIED IDEOGRAPH-73B3
        0x751A, # G+1951  U+751A  uni751A,  CJK UNIFIED IDEOGRAPH-751A
        0x752D, # G+1952  U+752D  uni752D,  CJK UNIFIED IDEOGRAPH-752D
        0x754F, # G+1953  U+754F  uni754F,  CJK UNIFIED IDEOGRAPH-754F
        0x754C, # G+1954  U+754C  uni754C,  CJK UNIFIED IDEOGRAPH-754C
        0x754E, # G+1955  U+754E  uni754E,  CJK UNIFIED IDEOGRAPH-754E
        0x754B, # G+1956  U+754B  uni754B,  CJK UNIFIED IDEOGRAPH-754B
        0x75AB, # G+1957  U+75AB  uni75AB,  CJK UNIFIED IDEOGRAPH-75AB
        0x75A4, # G+1958  U+75A4  uni75A4,  CJK UNIFIED IDEOGRAPH-75A4
        0x75A5, # G+1959  U+75A5  uni75A5,  CJK UNIFIED IDEOGRAPH-75A5
        0x75A2, # G+1960  U+75A2  uni75A2,  CJK UNIFIED IDEOGRAPH-75A2
        0x75A3, # G+1961  U+75A3  uni75A3,  CJK UNIFIED IDEOGRAPH-75A3
        0x7678, # G+1962  U+7678  uni7678,  CJK UNIFIED IDEOGRAPH-7678
        0x7686, # G+1963  U+7686  uni7686,  CJK UNIFIED IDEOGRAPH-7686
        0x7687, # G+1964  U+7687  uni7687,  CJK UNIFIED IDEOGRAPH-7687
        0x7688, # G+1965  U+7688  uni7688,  CJK UNIFIED IDEOGRAPH-7688
        0x76C8, # G+1966  U+76C8  uni76C8,  CJK UNIFIED IDEOGRAPH-76C8
        0x76C6, # G+1967  U+76C6  uni76C6,  CJK UNIFIED IDEOGRAPH-76C6
        0x76C3, # G+1968  U+76C3  uni76C3,  CJK UNIFIED IDEOGRAPH-76C3
        0x76C5, # G+1969  U+76C5  uni76C5,  CJK UNIFIED IDEOGRAPH-76C5
        0x7701, # G+1970  U+7701  uni7701,  CJK UNIFIED IDEOGRAPH-7701
        0x76F9, # G+1971  U+76F9  uni76F9,  CJK UNIFIED IDEOGRAPH-76F9
        0x76F8, # G+1972  U+76F8  uni76F8,  CJK UNIFIED IDEOGRAPH-76F8
        0x7709, # G+1973  U+7709  uni7709,  CJK UNIFIED IDEOGRAPH-7709
        0x770B, # G+1974  U+770B  uni770B,  CJK UNIFIED IDEOGRAPH-770B
        0x76FE, # G+1975  U+76FE  uni76FE,  CJK UNIFIED IDEOGRAPH-76FE
        0x76FC, # G+1976  U+76FC  uni76FC,  CJK UNIFIED IDEOGRAPH-76FC
        0x7707, # G+1977  U+7707  uni7707,  CJK UNIFIED IDEOGRAPH-7707
        0x77DC, # G+1978  U+77DC  uni77DC,  CJK UNIFIED IDEOGRAPH-77DC
        0x7802, # G+1979  U+7802  uni7802,  CJK UNIFIED IDEOGRAPH-7802
        0x7814, # G+1980  U+7814  uni7814,  CJK UNIFIED IDEOGRAPH-7814
        0x780C, # G+1981  U+780C  uni780C,  CJK UNIFIED IDEOGRAPH-780C
        0x780D, # G+1982  U+780D  uni780D,  CJK UNIFIED IDEOGRAPH-780D
        0x7946, # G+1983  U+7946  uni7946,  CJK UNIFIED IDEOGRAPH-7946
        0x7949, # G+1984  U+7949  uni7949,  CJK UNIFIED IDEOGRAPH-7949
        0x7948, # G+1985  U+7948  uni7948,  CJK UNIFIED IDEOGRAPH-7948
        0x7947, # G+1986  U+7947  uni7947,  CJK UNIFIED IDEOGRAPH-7947
        0x79B9, # G+1987  U+79B9  uni79B9,  CJK UNIFIED IDEOGRAPH-79B9
        0x79BA, # G+1988  U+79BA  uni79BA,  CJK UNIFIED IDEOGRAPH-79BA
        0x79D1, # G+1989  U+79D1  uni79D1,  CJK UNIFIED IDEOGRAPH-79D1
        0x79D2, # G+1990  U+79D2  uni79D2,  CJK UNIFIED IDEOGRAPH-79D2
        0x79CB, # G+1991  U+79CB  uni79CB,  CJK UNIFIED IDEOGRAPH-79CB
        0x7A7F, # G+1992  U+7A7F  uni7A7F,  CJK UNIFIED IDEOGRAPH-7A7F
        0x7A81, # G+1993  U+7A81  uni7A81,  CJK UNIFIED IDEOGRAPH-7A81
        0x7AFF, # G+1994  U+7AFF  uni7AFF,  CJK UNIFIED IDEOGRAPH-7AFF
        0x7AFD, # G+1995  U+7AFD  uni7AFD,  CJK UNIFIED IDEOGRAPH-7AFD
        0x7C7D, # G+1996  U+7C7D  uni7C7D,  CJK UNIFIED IDEOGRAPH-7C7D
        0x7D02, # G+1997  U+7D02  uni7D02,  CJK UNIFIED IDEOGRAPH-7D02
        0x7D05, # G+1998  U+7D05  uni7D05,  CJK UNIFIED IDEOGRAPH-7D05
        0x7D00, # G+1999  U+7D00  uni7D00,  CJK UNIFIED IDEOGRAPH-7D00
        0x7D09, # G+2000  U+7D09  uni7D09,  CJK UNIFIED IDEOGRAPH-7D09
        0x7D07, # G+2001  U+7D07  uni7D07,  CJK UNIFIED IDEOGRAPH-7D07
        0x7D04, # G+2002  U+7D04  uni7D04,  CJK UNIFIED IDEOGRAPH-7D04
        0x7D06, # G+2003  U+7D06  uni7D06,  CJK UNIFIED IDEOGRAPH-7D06
        0x7F38, # G+2004  U+7F38  uni7F38,  CJK UNIFIED IDEOGRAPH-7F38
        0x7F8E, # G+2005  U+7F8E  uni7F8E,  CJK UNIFIED IDEOGRAPH-7F8E
        0x7FBF, # G+2006  U+7FBF  uni7FBF,  CJK UNIFIED IDEOGRAPH-7FBF
        0x8010, # G+2007  U+8010  uni8010,  CJK UNIFIED IDEOGRAPH-8010
        0x800D, # G+2008  U+800D  uni800D,  CJK UNIFIED IDEOGRAPH-800D
        0x8011, # G+2009  U+8011  uni8011,  CJK UNIFIED IDEOGRAPH-8011
        0x8036, # G+2010  U+8036  uni8036,  CJK UNIFIED IDEOGRAPH-8036
        0x80D6, # G+2011  U+80D6  uni80D6,  CJK UNIFIED IDEOGRAPH-80D6
        0x80E5, # G+2012  U+80E5  uni80E5,  CJK UNIFIED IDEOGRAPH-80E5
        0x80DA, # G+2013  U+80DA  uni80DA,  CJK UNIFIED IDEOGRAPH-80DA
        0x80C3, # G+2014  U+80C3  uni80C3,  CJK UNIFIED IDEOGRAPH-80C3
        0x80C4, # G+2015  U+80C4  uni80C4,  CJK UNIFIED IDEOGRAPH-80C4
        0x80CC, # G+2016  U+80CC  uni80CC,  CJK UNIFIED IDEOGRAPH-80CC
        0x80E1, # G+2017  U+80E1  uni80E1,  CJK UNIFIED IDEOGRAPH-80E1
        0x80DB, # G+2018  U+80DB  uni80DB,  CJK UNIFIED IDEOGRAPH-80DB
        0x80CE, # G+2019  U+80CE  uni80CE,  CJK UNIFIED IDEOGRAPH-80CE
        0x80DE, # G+2020  U+80DE  uni80DE,  CJK UNIFIED IDEOGRAPH-80DE
        0x80E4, # G+2021  U+80E4  uni80E4,  CJK UNIFIED IDEOGRAPH-80E4
        0x80DD, # G+2022  U+80DD  uni80DD,  CJK UNIFIED IDEOGRAPH-80DD
        0x81F4, # G+2023  U+81F4  uni81F4,  CJK UNIFIED IDEOGRAPH-81F4
        0x8222, # G+2024  U+8222  uni8222,  CJK UNIFIED IDEOGRAPH-8222
        0x82E7, # G+2025  U+82E7  uni82E7,  CJK UNIFIED IDEOGRAPH-82E7
        0x8303, # G+2026  U+8303  uni8303,  CJK UNIFIED IDEOGRAPH-8303
        0x8305, # G+2027  U+8305  uni8305,  CJK UNIFIED IDEOGRAPH-8305
        0x82E3, # G+2028  U+82E3  uni82E3,  CJK UNIFIED IDEOGRAPH-82E3
        0x82DB, # G+2029  U+82DB  uni82DB,  CJK UNIFIED IDEOGRAPH-82DB
        0x82E6, # G+2030  U+82E6  uni82E6,  CJK UNIFIED IDEOGRAPH-82E6
        0x8304, # G+2031  U+8304  uni8304,  CJK UNIFIED IDEOGRAPH-8304
        0x82E5, # G+2032  U+82E5  uni82E5,  CJK UNIFIED IDEOGRAPH-82E5
        0x8302, # G+2033  U+8302  uni8302,  CJK UNIFIED IDEOGRAPH-8302
        0x8309, # G+2034  U+8309  uni8309,  CJK UNIFIED IDEOGRAPH-8309
        0x82D2, # G+2035  U+82D2  uni82D2,  CJK UNIFIED IDEOGRAPH-82D2
        0x82D7, # G+2036  U+82D7  uni82D7,  CJK UNIFIED IDEOGRAPH-82D7
        0x82F1, # G+2037  U+82F1  uni82F1,  CJK UNIFIED IDEOGRAPH-82F1
        0x8301, # G+2038  U+8301  uni8301,  CJK UNIFIED IDEOGRAPH-8301
        0x82DC, # G+2039  U+82DC  uni82DC,  CJK UNIFIED IDEOGRAPH-82DC
        0x82D4, # G+2040  U+82D4  uni82D4,  CJK UNIFIED IDEOGRAPH-82D4
        0x82D1, # G+2041  U+82D1  uni82D1,  CJK UNIFIED IDEOGRAPH-82D1
        0x82DE, # G+2042  U+82DE  uni82DE,  CJK UNIFIED IDEOGRAPH-82DE
        0x82D3, # G+2043  U+82D3  uni82D3,  CJK UNIFIED IDEOGRAPH-82D3
        0x82DF, # G+2044  U+82DF  uni82DF,  CJK UNIFIED IDEOGRAPH-82DF
        0x82EF, # G+2045  U+82EF  uni82EF,  CJK UNIFIED IDEOGRAPH-82EF
        0x8306, # G+2046  U+8306  uni8306,  CJK UNIFIED IDEOGRAPH-8306
        0x8650, # G+2047  U+8650  uni8650,  CJK UNIFIED IDEOGRAPH-8650
        0x8679, # G+2048  U+8679  uni8679,  CJK UNIFIED IDEOGRAPH-8679
        0x867B, # G+2049  U+867B  uni867B,  CJK UNIFIED IDEOGRAPH-867B
        0x867A, # G+2050  U+867A  uni867A,  CJK UNIFIED IDEOGRAPH-867A
        0x884D, # G+2051  U+884D  uni884D,  CJK UNIFIED IDEOGRAPH-884D
        0x886B, # G+2052  U+886B  uni886B,  CJK UNIFIED IDEOGRAPH-886B
        0x8981, # G+2053  U+8981  uni8981,  CJK UNIFIED IDEOGRAPH-8981
        0x89D4, # G+2054  U+89D4  uni89D4,  CJK UNIFIED IDEOGRAPH-89D4
        0x8A08, # G+2055  U+8A08  uni8A08,  CJK UNIFIED IDEOGRAPH-8A08
        0x8A02, # G+2056  U+8A02  uni8A02,  CJK UNIFIED IDEOGRAPH-8A02
        0x8A03, # G+2057  U+8A03  uni8A03,  CJK UNIFIED IDEOGRAPH-8A03
        0x8C9E, # G+2058  U+8C9E  uni8C9E,  CJK UNIFIED IDEOGRAPH-8C9E
        0x8CA0, # G+2059  U+8CA0  uni8CA0,  CJK UNIFIED IDEOGRAPH-8CA0
        0x8D74, # G+2060  U+8D74  uni8D74,  CJK UNIFIED IDEOGRAPH-8D74
        0x8D73, # G+2061  U+8D73  uni8D73,  CJK UNIFIED IDEOGRAPH-8D73
        0x8DB4, # G+2062  U+8DB4  uni8DB4,  CJK UNIFIED IDEOGRAPH-8DB4
        0x8ECD, # G+2063  U+8ECD  uni8ECD,  CJK UNIFIED IDEOGRAPH-8ECD
        0x8ECC, # G+2064  U+8ECC  uni8ECC,  CJK UNIFIED IDEOGRAPH-8ECC
        0x8FF0, # G+2065  U+8FF0  uni8FF0,  CJK UNIFIED IDEOGRAPH-8FF0
        0x8FE6, # G+2066  U+8FE6  uni8FE6,  CJK UNIFIED IDEOGRAPH-8FE6
        0x8FE2, # G+2067  U+8FE2  uni8FE2,  CJK UNIFIED IDEOGRAPH-8FE2
        0x8FEA, # G+2068  U+8FEA  uni8FEA,  CJK UNIFIED IDEOGRAPH-8FEA
        0x8FE5, # G+2069  U+8FE5  uni8FE5,  CJK UNIFIED IDEOGRAPH-8FE5
        0x8FED, # G+2070  U+8FED  uni8FED,  CJK UNIFIED IDEOGRAPH-8FED
        0x8FEB, # G+2071  U+8FEB  uni8FEB,  CJK UNIFIED IDEOGRAPH-8FEB
        0x8FE4, # G+2072  U+8FE4  uni8FE4,  CJK UNIFIED IDEOGRAPH-8FE4
        0x8FE8, # G+2073  U+8FE8  uni8FE8,  CJK UNIFIED IDEOGRAPH-8FE8
        0x90CA, # G+2074  U+90CA  uni90CA,  CJK UNIFIED IDEOGRAPH-90CA
        0x90CE, # G+2075  U+90CE  uni90CE,  CJK UNIFIED IDEOGRAPH-90CE
        0x90C1, # G+2076  U+90C1  uni90C1,  CJK UNIFIED IDEOGRAPH-90C1
        0x90C3, # G+2077  U+90C3  uni90C3,  CJK UNIFIED IDEOGRAPH-90C3
        0x914B, # G+2078  U+914B  uni914B,  CJK UNIFIED IDEOGRAPH-914B
        0x914A, # G+2079  U+914A  uni914A,  CJK UNIFIED IDEOGRAPH-914A
        0x91CD, # G+2080  U+91CD  uni91CD,  CJK UNIFIED IDEOGRAPH-91CD
        0x9582, # G+2081  U+9582  uni9582,  CJK UNIFIED IDEOGRAPH-9582
        0x9650, # G+2082  U+9650  uni9650,  CJK UNIFIED IDEOGRAPH-9650
        0x964B, # G+2083  U+964B  uni964B,  CJK UNIFIED IDEOGRAPH-964B
        0x964C, # G+2084  U+964C  uni964C,  CJK UNIFIED IDEOGRAPH-964C
        0x964D, # G+2085  U+964D  uni964D,  CJK UNIFIED IDEOGRAPH-964D
        0x9762, # G+2086  U+9762  uni9762,  CJK UNIFIED IDEOGRAPH-9762
        0x9769, # G+2087  U+9769  uni9769,  CJK UNIFIED IDEOGRAPH-9769
        0x97CB, # G+2088  U+97CB  uni97CB,  CJK UNIFIED IDEOGRAPH-97CB
        0x97ED, # G+2089  U+97ED  uni97ED,  CJK UNIFIED IDEOGRAPH-97ED
        0x97F3, # G+2090  U+97F3  uni97F3,  CJK UNIFIED IDEOGRAPH-97F3
        0x9801, # G+2091  U+9801  uni9801,  CJK UNIFIED IDEOGRAPH-9801
        0x98A8, # G+2092  U+98A8  uni98A8,  CJK UNIFIED IDEOGRAPH-98A8
        0x98DB, # G+2093  U+98DB  uni98DB,  CJK UNIFIED IDEOGRAPH-98DB
        0x98DF, # G+2094  U+98DF  uni98DF,  CJK UNIFIED IDEOGRAPH-98DF
        0x9996, # G+2095  U+9996  uni9996,  CJK UNIFIED IDEOGRAPH-9996
        0x9999, # G+2096  U+9999  uni9999,  CJK UNIFIED IDEOGRAPH-9999
        0x4E58, # G+2097  U+4E58  uni4E58,  CJK UNIFIED IDEOGRAPH-4E58
        0x4EB3, # G+2098  U+4EB3  uni4EB3,  CJK UNIFIED IDEOGRAPH-4EB3
        0x500C, # G+2099  U+500C  uni500C,  CJK UNIFIED IDEOGRAPH-500C
        0x500D, # G+2100  U+500D  uni500D,  CJK UNIFIED IDEOGRAPH-500D
        0x5023, # G+2101  U+5023  uni5023,  CJK UNIFIED IDEOGRAPH-5023
        0x4FEF, # G+2102  U+4FEF  uni4FEF,  CJK UNIFIED IDEOGRAPH-4FEF
        0x5026, # G+2103  U+5026  uni5026,  CJK UNIFIED IDEOGRAPH-5026
        0x5025, # G+2104  U+5025  uni5025,  CJK UNIFIED IDEOGRAPH-5025
        0x4FF8, # G+2105  U+4FF8  uni4FF8,  CJK UNIFIED IDEOGRAPH-4FF8
        0x5029, # G+2106  U+5029  uni5029,  CJK UNIFIED IDEOGRAPH-5029
        0x5016, # G+2107  U+5016  uni5016,  CJK UNIFIED IDEOGRAPH-5016
        0x5006, # G+2108  U+5006  uni5006,  CJK UNIFIED IDEOGRAPH-5006
        0x503C, # G+2109  U+503C  uni503C,  CJK UNIFIED IDEOGRAPH-503C
        0x501F, # G+2110  U+501F  uni501F,  CJK UNIFIED IDEOGRAPH-501F
        0x501A, # G+2111  U+501A  uni501A,  CJK UNIFIED IDEOGRAPH-501A
        0x5012, # G+2112  U+5012  uni5012,  CJK UNIFIED IDEOGRAPH-5012
        0x5011, # G+2113  U+5011  uni5011,  CJK UNIFIED IDEOGRAPH-5011
        0x4FFA, # G+2114  U+4FFA  uni4FFA,  CJK UNIFIED IDEOGRAPH-4FFA
        0x5000, # G+2115  U+5000  uni5000,  CJK UNIFIED IDEOGRAPH-5000
        0x5014, # G+2116  U+5014  uni5014,  CJK UNIFIED IDEOGRAPH-5014
        0x5028, # G+2117  U+5028  uni5028,  CJK UNIFIED IDEOGRAPH-5028
        0x4FF1, # G+2118  U+4FF1  uni4FF1,  CJK UNIFIED IDEOGRAPH-4FF1
        0x5021, # G+2119  U+5021  uni5021,  CJK UNIFIED IDEOGRAPH-5021
        0x500B, # G+2120  U+500B  uni500B,  CJK UNIFIED IDEOGRAPH-500B
        0x5019, # G+2121  U+5019  uni5019,  CJK UNIFIED IDEOGRAPH-5019
        0x5018, # G+2122  U+5018  uni5018,  CJK UNIFIED IDEOGRAPH-5018
        0x4FF3, # G+2123  U+4FF3  uni4FF3,  CJK UNIFIED IDEOGRAPH-4FF3
        0x4FEE, # G+2124  U+4FEE  uni4FEE,  CJK UNIFIED IDEOGRAPH-4FEE
        0x502D, # G+2125  U+502D  uni502D,  CJK UNIFIED IDEOGRAPH-502D
        0x502A, # G+2126  U+502A  uni502A,  CJK UNIFIED IDEOGRAPH-502A
        0x4FFE, # G+2127  U+4FFE  uni4FFE,  CJK UNIFIED IDEOGRAPH-4FFE
        0x502B, # G+2128  U+502B  uni502B,  CJK UNIFIED IDEOGRAPH-502B
        0x5009, # G+2129  U+5009  uni5009,  CJK UNIFIED IDEOGRAPH-5009
        0x517C, # G+2130  U+517C  uni517C,  CJK UNIFIED IDEOGRAPH-517C
        0x51A4, # G+2131  U+51A4  uni51A4,  CJK UNIFIED IDEOGRAPH-51A4
        0x51A5, # G+2132  U+51A5  uni51A5,  CJK UNIFIED IDEOGRAPH-51A5
        0x51A2, # G+2133  U+51A2  uni51A2,  CJK UNIFIED IDEOGRAPH-51A2
        0x51CD, # G+2134  U+51CD  uni51CD,  CJK UNIFIED IDEOGRAPH-51CD
        0x51CC, # G+2135  U+51CC  uni51CC,  CJK UNIFIED IDEOGRAPH-51CC
        0x51C6, # G+2136  U+51C6  uni51C6,  CJK UNIFIED IDEOGRAPH-51C6
        0x51CB, # G+2137  U+51CB  uni51CB,  CJK UNIFIED IDEOGRAPH-51CB
        0x5256, # G+2138  U+5256  uni5256,  CJK UNIFIED IDEOGRAPH-5256
        0x525C, # G+2139  U+525C  uni525C,  CJK UNIFIED IDEOGRAPH-525C
        0x5254, # G+2140  U+5254  uni5254,  CJK UNIFIED IDEOGRAPH-5254
        0x525B, # G+2141  U+525B  uni525B,  CJK UNIFIED IDEOGRAPH-525B
        0x525D, # G+2142  U+525D  uni525D,  CJK UNIFIED IDEOGRAPH-525D
        0x532A, # G+2143  U+532A  uni532A,  CJK UNIFIED IDEOGRAPH-532A
        0x537F, # G+2144  U+537F  uni537F,  CJK UNIFIED IDEOGRAPH-537F
        0x539F, # G+2145  U+539F  uni539F,  CJK UNIFIED IDEOGRAPH-539F
        0x539D, # G+2146  U+539D  uni539D,  CJK UNIFIED IDEOGRAPH-539D
        0x53DF, # G+2147  U+53DF  uni53DF,  CJK UNIFIED IDEOGRAPH-53DF
        0x54E8, # G+2148  U+54E8  uni54E8,  CJK UNIFIED IDEOGRAPH-54E8
        0x5510, # G+2149  U+5510  uni5510,  CJK UNIFIED IDEOGRAPH-5510
        0x5501, # G+2150  U+5501  uni5501,  CJK UNIFIED IDEOGRAPH-5501
        0x5537, # G+2151  U+5537  uni5537,  CJK UNIFIED IDEOGRAPH-5537
        0x54FC, # G+2152  U+54FC  uni54FC,  CJK UNIFIED IDEOGRAPH-54FC
        0x54E5, # G+2153  U+54E5  uni54E5,  CJK UNIFIED IDEOGRAPH-54E5
        0x54F2, # G+2154  U+54F2  uni54F2,  CJK UNIFIED IDEOGRAPH-54F2
        0x5506, # G+2155  U+5506  uni5506,  CJK UNIFIED IDEOGRAPH-5506
        0x54FA, # G+2156  U+54FA  uni54FA,  CJK UNIFIED IDEOGRAPH-54FA
        0x5514, # G+2157  U+5514  uni5514,  CJK UNIFIED IDEOGRAPH-5514
        0x54E9, # G+2158  U+54E9  uni54E9,  CJK UNIFIED IDEOGRAPH-54E9
        0x54ED, # G+2159  U+54ED  uni54ED,  CJK UNIFIED IDEOGRAPH-54ED
        0x54E1, # G+2160  U+54E1  uni54E1,  CJK UNIFIED IDEOGRAPH-54E1
        0x5509, # G+2161  U+5509  uni5509,  CJK UNIFIED IDEOGRAPH-5509
        0x54EE, # G+2162  U+54EE  uni54EE,  CJK UNIFIED IDEOGRAPH-54EE
        0x54EA, # G+2163  U+54EA  uni54EA,  CJK UNIFIED IDEOGRAPH-54EA
        0x54E6, # G+2164  U+54E6  uni54E6,  CJK UNIFIED IDEOGRAPH-54E6
        0x5527, # G+2165  U+5527  uni5527,  CJK UNIFIED IDEOGRAPH-5527
        0x5507, # G+2166  U+5507  uni5507,  CJK UNIFIED IDEOGRAPH-5507
        0x54FD, # G+2167  U+54FD  uni54FD,  CJK UNIFIED IDEOGRAPH-54FD
        0x550F, # G+2168  U+550F  uni550F,  CJK UNIFIED IDEOGRAPH-550F
        0x5703, # G+2169  U+5703  uni5703,  CJK UNIFIED IDEOGRAPH-5703
        0x5704, # G+2170  U+5704  uni5704,  CJK UNIFIED IDEOGRAPH-5704
        0x57C2, # G+2171  U+57C2  uni57C2,  CJK UNIFIED IDEOGRAPH-57C2
        0x57D4, # G+2172  U+57D4  uni57D4,  CJK UNIFIED IDEOGRAPH-57D4
        0x57CB, # G+2173  U+57CB  uni57CB,  CJK UNIFIED IDEOGRAPH-57CB
        0x57C3, # G+2174  U+57C3  uni57C3,  CJK UNIFIED IDEOGRAPH-57C3
        0x5809, # G+2175  U+5809  uni5809,  CJK UNIFIED IDEOGRAPH-5809
        0x590F, # G+2176  U+590F  uni590F,  CJK UNIFIED IDEOGRAPH-590F
        0x5957, # G+2177  U+5957  uni5957,  CJK UNIFIED IDEOGRAPH-5957
        0x5958, # G+2178  U+5958  uni5958,  CJK UNIFIED IDEOGRAPH-5958
        0x595A, # G+2179  U+595A  uni595A,  CJK UNIFIED IDEOGRAPH-595A
        0x5A11, # G+2180  U+5A11  uni5A11,  CJK UNIFIED IDEOGRAPH-5A11
        0x5A18, # G+2181  U+5A18  uni5A18,  CJK UNIFIED IDEOGRAPH-5A18
        0x5A1C, # G+2182  U+5A1C  uni5A1C,  CJK UNIFIED IDEOGRAPH-5A1C
        0x5A1F, # G+2183  U+5A1F  uni5A1F,  CJK UNIFIED IDEOGRAPH-5A1F
        0x5A1B, # G+2184  U+5A1B  uni5A1B,  CJK UNIFIED IDEOGRAPH-5A1B
        0x5A13, # G+2185  U+5A13  uni5A13,  CJK UNIFIED IDEOGRAPH-5A13
        0x59EC, # G+2186  U+59EC  uni59EC,  CJK UNIFIED IDEOGRAPH-59EC
        0x5A20, # G+2187  U+5A20  uni5A20,  CJK UNIFIED IDEOGRAPH-5A20
        0x5A23, # G+2188  U+5A23  uni5A23,  CJK UNIFIED IDEOGRAPH-5A23
        0x5A29, # G+2189  U+5A29  uni5A29,  CJK UNIFIED IDEOGRAPH-5A29
        0x5A25, # G+2190  U+5A25  uni5A25,  CJK UNIFIED IDEOGRAPH-5A25
        0x5A0C, # G+2191  U+5A0C  uni5A0C,  CJK UNIFIED IDEOGRAPH-5A0C
        0x5A09, # G+2192  U+5A09  uni5A09,  CJK UNIFIED IDEOGRAPH-5A09
        0x5B6B, # G+2193  U+5B6B  uni5B6B,  CJK UNIFIED IDEOGRAPH-5B6B
        0x5C58, # G+2194  U+5C58  uni5C58,  CJK UNIFIED IDEOGRAPH-5C58
        0x5BB0, # G+2195  U+5BB0  uni5BB0,  CJK UNIFIED IDEOGRAPH-5BB0
        0x5BB3, # G+2196  U+5BB3  uni5BB3,  CJK UNIFIED IDEOGRAPH-5BB3
        0x5BB6, # G+2197  U+5BB6  uni5BB6,  CJK UNIFIED IDEOGRAPH-5BB6
        0x5BB4, # G+2198  U+5BB4  uni5BB4,  CJK UNIFIED IDEOGRAPH-5BB4
        0x5BAE, # G+2199  U+5BAE  uni5BAE,  CJK UNIFIED IDEOGRAPH-5BAE
        0x5BB5, # G+2200  U+5BB5  uni5BB5,  CJK UNIFIED IDEOGRAPH-5BB5
        0x5BB9, # G+2201  U+5BB9  uni5BB9,  CJK UNIFIED IDEOGRAPH-5BB9
        0x5BB8, # G+2202  U+5BB8  uni5BB8,  CJK UNIFIED IDEOGRAPH-5BB8
        0x5C04, # G+2203  U+5C04  uni5C04,  CJK UNIFIED IDEOGRAPH-5C04
        0x5C51, # G+2204  U+5C51  uni5C51,  CJK UNIFIED IDEOGRAPH-5C51
        0x5C55, # G+2205  U+5C55  uni5C55,  CJK UNIFIED IDEOGRAPH-5C55
        0x5C50, # G+2206  U+5C50  uni5C50,  CJK UNIFIED IDEOGRAPH-5C50
        0x5CED, # G+2207  U+5CED  uni5CED,  CJK UNIFIED IDEOGRAPH-5CED
        0x5CFD, # G+2208  U+5CFD  uni5CFD,  CJK UNIFIED IDEOGRAPH-5CFD
        0x5CFB, # G+2209  U+5CFB  uni5CFB,  CJK UNIFIED IDEOGRAPH-5CFB
        0x5CEA, # G+2210  U+5CEA  uni5CEA,  CJK UNIFIED IDEOGRAPH-5CEA
        0x5CE8, # G+2211  U+5CE8  uni5CE8,  CJK UNIFIED IDEOGRAPH-5CE8
        0x5CF0, # G+2212  U+5CF0  uni5CF0,  CJK UNIFIED IDEOGRAPH-5CF0
        0x5CF6, # G+2213  U+5CF6  uni5CF6,  CJK UNIFIED IDEOGRAPH-5CF6
        0x5D01, # G+2214  U+5D01  uni5D01,  CJK UNIFIED IDEOGRAPH-5D01
        0x5CF4, # G+2215  U+5CF4  uni5CF4,  CJK UNIFIED IDEOGRAPH-5CF4
        0x5DEE, # G+2216  U+5DEE  uni5DEE,  CJK UNIFIED IDEOGRAPH-5DEE
        0x5E2D, # G+2217  U+5E2D  uni5E2D,  CJK UNIFIED IDEOGRAPH-5E2D
        0x5E2B, # G+2218  U+5E2B  uni5E2B,  CJK UNIFIED IDEOGRAPH-5E2B
        0x5EAB, # G+2219  U+5EAB  uni5EAB,  CJK UNIFIED IDEOGRAPH-5EAB
        0x5EAD, # G+2220  U+5EAD  uni5EAD,  CJK UNIFIED IDEOGRAPH-5EAD
        0x5EA7, # G+2221  U+5EA7  uni5EA7,  CJK UNIFIED IDEOGRAPH-5EA7
        0x5F31, # G+2222  U+5F31  uni5F31,  CJK UNIFIED IDEOGRAPH-5F31
        0x5F92, # G+2223  U+5F92  uni5F92,  CJK UNIFIED IDEOGRAPH-5F92
        0x5F91, # G+2224  U+5F91  uni5F91,  CJK UNIFIED IDEOGRAPH-5F91
        0x5F90, # G+2225  U+5F90  uni5F90,  CJK UNIFIED IDEOGRAPH-5F90
        0x6059, # G+2226  U+6059  uni6059,  CJK UNIFIED IDEOGRAPH-6059
        0x6063, # G+2227  U+6063  uni6063,  CJK UNIFIED IDEOGRAPH-6063
        0x6065, # G+2228  U+6065  uni6065,  CJK UNIFIED IDEOGRAPH-6065
        0x6050, # G+2229  U+6050  uni6050,  CJK UNIFIED IDEOGRAPH-6050
        0x6055, # G+2230  U+6055  uni6055,  CJK UNIFIED IDEOGRAPH-6055
        0x606D, # G+2231  U+606D  uni606D,  CJK UNIFIED IDEOGRAPH-606D
        0x6069, # G+2232  U+6069  uni6069,  CJK UNIFIED IDEOGRAPH-6069
        0x606F, # G+2233  U+606F  uni606F,  CJK UNIFIED IDEOGRAPH-606F
        0x6084, # G+2234  U+6084  uni6084,  CJK UNIFIED IDEOGRAPH-6084
        0x609F, # G+2235  U+609F  uni609F,  CJK UNIFIED IDEOGRAPH-609F
        0x609A, # G+2236  U+609A  uni609A,  CJK UNIFIED IDEOGRAPH-609A
        0x608D, # G+2237  U+608D  uni608D,  CJK UNIFIED IDEOGRAPH-608D
        0x6094, # G+2238  U+6094  uni6094,  CJK UNIFIED IDEOGRAPH-6094
        0x608C, # G+2239  U+608C  uni608C,  CJK UNIFIED IDEOGRAPH-608C
        0x6085, # G+2240  U+6085  uni6085,  CJK UNIFIED IDEOGRAPH-6085
        0x6096, # G+2241  U+6096  uni6096,  CJK UNIFIED IDEOGRAPH-6096
        0x6247, # G+2242  U+6247  uni6247,  CJK UNIFIED IDEOGRAPH-6247
        0x62F3, # G+2243  U+62F3  uni62F3,  CJK UNIFIED IDEOGRAPH-62F3
        0x6308, # G+2244  U+6308  uni6308,  CJK UNIFIED IDEOGRAPH-6308
        0x62FF, # G+2245  U+62FF  uni62FF,  CJK UNIFIED IDEOGRAPH-62FF
        0x634E, # G+2246  U+634E  uni634E,  CJK UNIFIED IDEOGRAPH-634E
        0x633E, # G+2247  U+633E  uni633E,  CJK UNIFIED IDEOGRAPH-633E
        0x632F, # G+2248  U+632F  uni632F,  CJK UNIFIED IDEOGRAPH-632F
        0x6355, # G+2249  U+6355  uni6355,  CJK UNIFIED IDEOGRAPH-6355
        0x6342, # G+2250  U+6342  uni6342,  CJK UNIFIED IDEOGRAPH-6342
        0x6346, # G+2251  U+6346  uni6346,  CJK UNIFIED IDEOGRAPH-6346
        0x634F, # G+2252  U+634F  uni634F,  CJK UNIFIED IDEOGRAPH-634F
        0x6349, # G+2253  U+6349  uni6349,  CJK UNIFIED IDEOGRAPH-6349
        0x633A, # G+2254  U+633A  uni633A,  CJK UNIFIED IDEOGRAPH-633A
        0x6350, # G+2255  U+6350  uni6350,  CJK UNIFIED IDEOGRAPH-6350
        0x633D, # G+2256  U+633D  uni633D,  CJK UNIFIED IDEOGRAPH-633D
        0x632A, # G+2257  U+632A  uni632A,  CJK UNIFIED IDEOGRAPH-632A
        0x632B, # G+2258  U+632B  uni632B,  CJK UNIFIED IDEOGRAPH-632B
        0x6328, # G+2259  U+6328  uni6328,  CJK UNIFIED IDEOGRAPH-6328
        0x634D, # G+2260  U+634D  uni634D,  CJK UNIFIED IDEOGRAPH-634D
        0x634C, # G+2261  U+634C  uni634C,  CJK UNIFIED IDEOGRAPH-634C
        0x6548, # G+2262  U+6548  uni6548,  CJK UNIFIED IDEOGRAPH-6548
        0x6549, # G+2263  U+6549  uni6549,  CJK UNIFIED IDEOGRAPH-6549
        0x6599, # G+2264  U+6599  uni6599,  CJK UNIFIED IDEOGRAPH-6599
        0x65C1, # G+2265  U+65C1  uni65C1,  CJK UNIFIED IDEOGRAPH-65C1
        0x65C5, # G+2266  U+65C5  uni65C5,  CJK UNIFIED IDEOGRAPH-65C5
        0x6642, # G+2267  U+6642  uni6642,  CJK UNIFIED IDEOGRAPH-6642
        0x6649, # G+2268  U+6649  uni6649,  CJK UNIFIED IDEOGRAPH-6649
        0x664F, # G+2269  U+664F  uni664F,  CJK UNIFIED IDEOGRAPH-664F
        0x6643, # G+2270  U+6643  uni6643,  CJK UNIFIED IDEOGRAPH-6643
        0x6652, # G+2271  U+6652  uni6652,  CJK UNIFIED IDEOGRAPH-6652
        0x664C, # G+2272  U+664C  uni664C,  CJK UNIFIED IDEOGRAPH-664C
        0x6645, # G+2273  U+6645  uni6645,  CJK UNIFIED IDEOGRAPH-6645
        0x6641, # G+2274  U+6641  uni6641,  CJK UNIFIED IDEOGRAPH-6641
        0x66F8, # G+2275  U+66F8  uni66F8,  CJK UNIFIED IDEOGRAPH-66F8
        0x6714, # G+2276  U+6714  uni6714,  CJK UNIFIED IDEOGRAPH-6714
        0x6715, # G+2277  U+6715  uni6715,  CJK UNIFIED IDEOGRAPH-6715
        0x6717, # G+2278  U+6717  uni6717,  CJK UNIFIED IDEOGRAPH-6717
        0x6821, # G+2279  U+6821  uni6821,  CJK UNIFIED IDEOGRAPH-6821
        0x6838, # G+2280  U+6838  uni6838,  CJK UNIFIED IDEOGRAPH-6838
        0x6848, # G+2281  U+6848  uni6848,  CJK UNIFIED IDEOGRAPH-6848
        0x6846, # G+2282  U+6846  uni6846,  CJK UNIFIED IDEOGRAPH-6846
        0x6853, # G+2283  U+6853  uni6853,  CJK UNIFIED IDEOGRAPH-6853
        0x6839, # G+2284  U+6839  uni6839,  CJK UNIFIED IDEOGRAPH-6839
        0x6842, # G+2285  U+6842  uni6842,  CJK UNIFIED IDEOGRAPH-6842
        0x6854, # G+2286  U+6854  uni6854,  CJK UNIFIED IDEOGRAPH-6854
        0x6829, # G+2287  U+6829  uni6829,  CJK UNIFIED IDEOGRAPH-6829
        0x68B3, # G+2288  U+68B3  uni68B3,  CJK UNIFIED IDEOGRAPH-68B3
        0x6817, # G+2289  U+6817  uni6817,  CJK UNIFIED IDEOGRAPH-6817
        0x684C, # G+2290  U+684C  uni684C,  CJK UNIFIED IDEOGRAPH-684C
        0x6851, # G+2291  U+6851  uni6851,  CJK UNIFIED IDEOGRAPH-6851
        0x683D, # G+2292  U+683D  uni683D,  CJK UNIFIED IDEOGRAPH-683D
        0x67F4, # G+2293  U+67F4  uni67F4,  CJK UNIFIED IDEOGRAPH-67F4
        0x6850, # G+2294  U+6850  uni6850,  CJK UNIFIED IDEOGRAPH-6850
        0x6840, # G+2295  U+6840  uni6840,  CJK UNIFIED IDEOGRAPH-6840
        0x683C, # G+2296  U+683C  uni683C,  CJK UNIFIED IDEOGRAPH-683C
        0x6843, # G+2297  U+6843  uni6843,  CJK UNIFIED IDEOGRAPH-6843
        0x682A, # G+2298  U+682A  uni682A,  CJK UNIFIED IDEOGRAPH-682A
        0x6845, # G+2299  U+6845  uni6845,  CJK UNIFIED IDEOGRAPH-6845
        0x6813, # G+2300  U+6813  uni6813,  CJK UNIFIED IDEOGRAPH-6813
        0x6818, # G+2301  U+6818  uni6818,  CJK UNIFIED IDEOGRAPH-6818
        0x6841, # G+2302  U+6841  uni6841,  CJK UNIFIED IDEOGRAPH-6841
        0x6B8A, # G+2303  U+6B8A  uni6B8A,  CJK UNIFIED IDEOGRAPH-6B8A
        0x6B89, # G+2304  U+6B89  uni6B89,  CJK UNIFIED IDEOGRAPH-6B89
        0x6BB7, # G+2305  U+6BB7  uni6BB7,  CJK UNIFIED IDEOGRAPH-6BB7
        0x6C23, # G+2306  U+6C23  uni6C23,  CJK UNIFIED IDEOGRAPH-6C23
        0x6C27, # G+2307  U+6C27  uni6C27,  CJK UNIFIED IDEOGRAPH-6C27
        0x6C28, # G+2308  U+6C28  uni6C28,  CJK UNIFIED IDEOGRAPH-6C28
        0x6C26, # G+2309  U+6C26  uni6C26,  CJK UNIFIED IDEOGRAPH-6C26
        0x6C24, # G+2310  U+6C24  uni6C24,  CJK UNIFIED IDEOGRAPH-6C24
        0x6CF0, # G+2311  U+6CF0  uni6CF0,  CJK UNIFIED IDEOGRAPH-6CF0
        0x6D6A, # G+2312  U+6D6A  uni6D6A,  CJK UNIFIED IDEOGRAPH-6D6A
        0x6D95, # G+2313  U+6D95  uni6D95,  CJK UNIFIED IDEOGRAPH-6D95
        0x6D88, # G+2314  U+6D88  uni6D88,  CJK UNIFIED IDEOGRAPH-6D88
        0x6D87, # G+2315  U+6D87  uni6D87,  CJK UNIFIED IDEOGRAPH-6D87
        0x6D66, # G+2316  U+6D66  uni6D66,  CJK UNIFIED IDEOGRAPH-6D66
        0x6D78, # G+2317  U+6D78  uni6D78,  CJK UNIFIED IDEOGRAPH-6D78
        0x6D77, # G+2318  U+6D77  uni6D77,  CJK UNIFIED IDEOGRAPH-6D77
        0x6D59, # G+2319  U+6D59  uni6D59,  CJK UNIFIED IDEOGRAPH-6D59
        0x6D93, # G+2320  U+6D93  uni6D93,  CJK UNIFIED IDEOGRAPH-6D93
        0x6D6C, # G+2321  U+6D6C  uni6D6C,  CJK UNIFIED IDEOGRAPH-6D6C
        0x6D89, # G+2322  U+6D89  uni6D89,  CJK UNIFIED IDEOGRAPH-6D89
        0x6D6E, # G+2323  U+6D6E  uni6D6E,  CJK UNIFIED IDEOGRAPH-6D6E
        0x6D5A, # G+2324  U+6D5A  uni6D5A,  CJK UNIFIED IDEOGRAPH-6D5A
        0x6D74, # G+2325  U+6D74  uni6D74,  CJK UNIFIED IDEOGRAPH-6D74
        0x6D69, # G+2326  U+6D69  uni6D69,  CJK UNIFIED IDEOGRAPH-6D69
        0x6D8C, # G+2327  U+6D8C  uni6D8C,  CJK UNIFIED IDEOGRAPH-6D8C
        0x6D8A, # G+2328  U+6D8A  uni6D8A,  CJK UNIFIED IDEOGRAPH-6D8A
        0x6D79, # G+2329  U+6D79  uni6D79,  CJK UNIFIED IDEOGRAPH-6D79
        0x6D85, # G+2330  U+6D85  uni6D85,  CJK UNIFIED IDEOGRAPH-6D85
        0x6D65, # G+2331  U+6D65  uni6D65,  CJK UNIFIED IDEOGRAPH-6D65
        0x6D94, # G+2332  U+6D94  uni6D94,  CJK UNIFIED IDEOGRAPH-6D94
        0x70CA, # G+2333  U+70CA  uni70CA,  CJK UNIFIED IDEOGRAPH-70CA
        0x70D8, # G+2334  U+70D8  uni70D8,  CJK UNIFIED IDEOGRAPH-70D8
        0x70E4, # G+2335  U+70E4  uni70E4,  CJK UNIFIED IDEOGRAPH-70E4
        0x70D9, # G+2336  U+70D9  uni70D9,  CJK UNIFIED IDEOGRAPH-70D9
        0x70C8, # G+2337  U+70C8  uni70C8,  CJK UNIFIED IDEOGRAPH-70C8
        0x70CF, # G+2338  U+70CF  uni70CF,  CJK UNIFIED IDEOGRAPH-70CF
        0x7239, # G+2339  U+7239  uni7239,  CJK UNIFIED IDEOGRAPH-7239
        0x7279, # G+2340  U+7279  uni7279,  CJK UNIFIED IDEOGRAPH-7279
        0x72FC, # G+2341  U+72FC  uni72FC,  CJK UNIFIED IDEOGRAPH-72FC
        0x72F9, # G+2342  U+72F9  uni72F9,  CJK UNIFIED IDEOGRAPH-72F9
        0x72FD, # G+2343  U+72FD  uni72FD,  CJK UNIFIED IDEOGRAPH-72FD
        0x72F8, # G+2344  U+72F8  uni72F8,  CJK UNIFIED IDEOGRAPH-72F8
        0x72F7, # G+2345  U+72F7  uni72F7,  CJK UNIFIED IDEOGRAPH-72F7
        0x7386, # G+2346  U+7386  uni7386,  CJK UNIFIED IDEOGRAPH-7386
        0x73ED, # G+2347  U+73ED  uni73ED,  CJK UNIFIED IDEOGRAPH-73ED
        0x7409, # G+2348  U+7409  uni7409,  CJK UNIFIED IDEOGRAPH-7409
        0x73EE, # G+2349  U+73EE  uni73EE,  CJK UNIFIED IDEOGRAPH-73EE
        0x73E0, # G+2350  U+73E0  uni73E0,  CJK UNIFIED IDEOGRAPH-73E0
        0x73EA, # G+2351  U+73EA  uni73EA,  CJK UNIFIED IDEOGRAPH-73EA
        0x73DE, # G+2352  U+73DE  uni73DE,  CJK UNIFIED IDEOGRAPH-73DE
        0x7554, # G+2353  U+7554  uni7554,  CJK UNIFIED IDEOGRAPH-7554
        0x755D, # G+2354  U+755D  uni755D,  CJK UNIFIED IDEOGRAPH-755D
        0x755C, # G+2355  U+755C  uni755C,  CJK UNIFIED IDEOGRAPH-755C
        0x755A, # G+2356  U+755A  uni755A,  CJK UNIFIED IDEOGRAPH-755A
        0x7559, # G+2357  U+7559  uni7559,  CJK UNIFIED IDEOGRAPH-7559
        0x75BE, # G+2358  U+75BE  uni75BE,  CJK UNIFIED IDEOGRAPH-75BE
        0x75C5, # G+2359  U+75C5  uni75C5,  CJK UNIFIED IDEOGRAPH-75C5
        0x75C7, # G+2360  U+75C7  uni75C7,  CJK UNIFIED IDEOGRAPH-75C7
        0x75B2, # G+2361  U+75B2  uni75B2,  CJK UNIFIED IDEOGRAPH-75B2
        0x75B3, # G+2362  U+75B3  uni75B3,  CJK UNIFIED IDEOGRAPH-75B3
        0x75BD, # G+2363  U+75BD  uni75BD,  CJK UNIFIED IDEOGRAPH-75BD
        0x75BC, # G+2364  U+75BC  uni75BC,  CJK UNIFIED IDEOGRAPH-75BC
        0x75B9, # G+2365  U+75B9  uni75B9,  CJK UNIFIED IDEOGRAPH-75B9
        0x75C2, # G+2366  U+75C2  uni75C2,  CJK UNIFIED IDEOGRAPH-75C2
        0x75B8, # G+2367  U+75B8  uni75B8,  CJK UNIFIED IDEOGRAPH-75B8
        0x768B, # G+2368  U+768B  uni768B,  CJK UNIFIED IDEOGRAPH-768B
        0x76B0, # G+2369  U+76B0  uni76B0,  CJK UNIFIED IDEOGRAPH-76B0
        0x76CA, # G+2370  U+76CA  uni76CA,  CJK UNIFIED IDEOGRAPH-76CA
        0x76CD, # G+2371  U+76CD  uni76CD,  CJK UNIFIED IDEOGRAPH-76CD
        0x76CE, # G+2372  U+76CE  uni76CE,  CJK UNIFIED IDEOGRAPH-76CE
        0x7729, # G+2373  U+7729  uni7729,  CJK UNIFIED IDEOGRAPH-7729
        0x771F, # G+2374  U+771F  uni771F,  CJK UNIFIED IDEOGRAPH-771F
        0x7720, # G+2375  U+7720  uni7720,  CJK UNIFIED IDEOGRAPH-7720
        0x7728, # G+2376  U+7728  uni7728,  CJK UNIFIED IDEOGRAPH-7728
        0x77E9, # G+2377  U+77E9  uni77E9,  CJK UNIFIED IDEOGRAPH-77E9
        0x7830, # G+2378  U+7830  uni7830,  CJK UNIFIED IDEOGRAPH-7830
        0x7827, # G+2379  U+7827  uni7827,  CJK UNIFIED IDEOGRAPH-7827
        0x7838, # G+2380  U+7838  uni7838,  CJK UNIFIED IDEOGRAPH-7838
        0x781D, # G+2381  U+781D  uni781D,  CJK UNIFIED IDEOGRAPH-781D
        0x7834, # G+2382  U+7834  uni7834,  CJK UNIFIED IDEOGRAPH-7834
        0x7837, # G+2383  U+7837  uni7837,  CJK UNIFIED IDEOGRAPH-7837
        0x7825, # G+2384  U+7825  uni7825,  CJK UNIFIED IDEOGRAPH-7825
        0x782D, # G+2385  U+782D  uni782D,  CJK UNIFIED IDEOGRAPH-782D
        0x7820, # G+2386  U+7820  uni7820,  CJK UNIFIED IDEOGRAPH-7820
        0x781F, # G+2387  U+781F  uni781F,  CJK UNIFIED IDEOGRAPH-781F
        0x7832, # G+2388  U+7832  uni7832,  CJK UNIFIED IDEOGRAPH-7832
        0x7955, # G+2389  U+7955  uni7955,  CJK UNIFIED IDEOGRAPH-7955
        0x7950, # G+2390  U+7950  uni7950,  CJK UNIFIED IDEOGRAPH-7950
        0x7960, # G+2391  U+7960  uni7960,  CJK UNIFIED IDEOGRAPH-7960
        0x795F, # G+2392  U+795F  uni795F,  CJK UNIFIED IDEOGRAPH-795F
        0x7956, # G+2393  U+7956  uni7956,  CJK UNIFIED IDEOGRAPH-7956
        0x795E, # G+2394  U+795E  uni795E,  CJK UNIFIED IDEOGRAPH-795E
        0x795D, # G+2395  U+795D  uni795D,  CJK UNIFIED IDEOGRAPH-795D
        0x7957, # G+2396  U+7957  uni7957,  CJK UNIFIED IDEOGRAPH-7957
        0x795A, # G+2397  U+795A  uni795A,  CJK UNIFIED IDEOGRAPH-795A
        0x79E4, # G+2398  U+79E4  uni79E4,  CJK UNIFIED IDEOGRAPH-79E4
        0x79E3, # G+2399  U+79E3  uni79E3,  CJK UNIFIED IDEOGRAPH-79E3
        0x79E7, # G+2400  U+79E7  uni79E7,  CJK UNIFIED IDEOGRAPH-79E7
        0x79DF, # G+2401  U+79DF  uni79DF,  CJK UNIFIED IDEOGRAPH-79DF
        0x79E6, # G+2402  U+79E6  uni79E6,  CJK UNIFIED IDEOGRAPH-79E6
        0x79E9, # G+2403  U+79E9  uni79E9,  CJK UNIFIED IDEOGRAPH-79E9
        0x79D8, # G+2404  U+79D8  uni79D8,  CJK UNIFIED IDEOGRAPH-79D8
        0x7A84, # G+2405  U+7A84  uni7A84,  CJK UNIFIED IDEOGRAPH-7A84
        0x7A88, # G+2406  U+7A88  uni7A88,  CJK UNIFIED IDEOGRAPH-7A88
        0x7AD9, # G+2407  U+7AD9  uni7AD9,  CJK UNIFIED IDEOGRAPH-7AD9
        0x7B06, # G+2408  U+7B06  uni7B06,  CJK UNIFIED IDEOGRAPH-7B06
        0x7B11, # G+2409  U+7B11  uni7B11,  CJK UNIFIED IDEOGRAPH-7B11
        0x7C89, # G+2410  U+7C89  uni7C89,  CJK UNIFIED IDEOGRAPH-7C89
        0x7D21, # G+2411  U+7D21  uni7D21,  CJK UNIFIED IDEOGRAPH-7D21
        0x7D17, # G+2412  U+7D17  uni7D17,  CJK UNIFIED IDEOGRAPH-7D17
        0x7D0B, # G+2413  U+7D0B  uni7D0B,  CJK UNIFIED IDEOGRAPH-7D0B
        0x7D0A, # G+2414  U+7D0A  uni7D0A,  CJK UNIFIED IDEOGRAPH-7D0A
        0x7D20, # G+2415  U+7D20  uni7D20,  CJK UNIFIED IDEOGRAPH-7D20
        0x7D22, # G+2416  U+7D22  uni7D22,  CJK UNIFIED IDEOGRAPH-7D22
        0x7D14, # G+2417  U+7D14  uni7D14,  CJK UNIFIED IDEOGRAPH-7D14
        0x7D10, # G+2418  U+7D10  uni7D10,  CJK UNIFIED IDEOGRAPH-7D10
        0x7D15, # G+2419  U+7D15  uni7D15,  CJK UNIFIED IDEOGRAPH-7D15
        0x7D1A, # G+2420  U+7D1A  uni7D1A,  CJK UNIFIED IDEOGRAPH-7D1A
        0x7D1C, # G+2421  U+7D1C  uni7D1C,  CJK UNIFIED IDEOGRAPH-7D1C
        0x7D0D, # G+2422  U+7D0D  uni7D0D,  CJK UNIFIED IDEOGRAPH-7D0D
        0x7D19, # G+2423  U+7D19  uni7D19,  CJK UNIFIED IDEOGRAPH-7D19
        0x7D1B, # G+2424  U+7D1B  uni7D1B,  CJK UNIFIED IDEOGRAPH-7D1B
        0x7F3A, # G+2425  U+7F3A  uni7F3A,  CJK UNIFIED IDEOGRAPH-7F3A
        0x7F5F, # G+2426  U+7F5F  uni7F5F,  CJK UNIFIED IDEOGRAPH-7F5F
        0x7F94, # G+2427  U+7F94  uni7F94,  CJK UNIFIED IDEOGRAPH-7F94
        0x7FC5, # G+2428  U+7FC5  uni7FC5,  CJK UNIFIED IDEOGRAPH-7FC5
        0x7FC1, # G+2429  U+7FC1  uni7FC1,  CJK UNIFIED IDEOGRAPH-7FC1
        0x8006, # G+2430  U+8006  uni8006,  CJK UNIFIED IDEOGRAPH-8006
        0x8004, # G+2431  U+8004  uni8004,  CJK UNIFIED IDEOGRAPH-8004
        0x8018, # G+2432  U+8018  uni8018,  CJK UNIFIED IDEOGRAPH-8018
        0x8015, # G+2433  U+8015  uni8015,  CJK UNIFIED IDEOGRAPH-8015
        0x8019, # G+2434  U+8019  uni8019,  CJK UNIFIED IDEOGRAPH-8019
        0x8017, # G+2435  U+8017  uni8017,  CJK UNIFIED IDEOGRAPH-8017
        0x803D, # G+2436  U+803D  uni803D,  CJK UNIFIED IDEOGRAPH-803D
        0x803F, # G+2437  U+803F  uni803F,  CJK UNIFIED IDEOGRAPH-803F
        0x80F1, # G+2438  U+80F1  uni80F1,  CJK UNIFIED IDEOGRAPH-80F1
        0x8102, # G+2439  U+8102  uni8102,  CJK UNIFIED IDEOGRAPH-8102
        0x80F0, # G+2440  U+80F0  uni80F0,  CJK UNIFIED IDEOGRAPH-80F0
        0x8105, # G+2441  U+8105  uni8105,  CJK UNIFIED IDEOGRAPH-8105
        0x80ED, # G+2442  U+80ED  uni80ED,  CJK UNIFIED IDEOGRAPH-80ED
        0x80F4, # G+2443  U+80F4  uni80F4,  CJK UNIFIED IDEOGRAPH-80F4
        0x8106, # G+2444  U+8106  uni8106,  CJK UNIFIED IDEOGRAPH-8106
        0x80F8, # G+2445  U+80F8  uni80F8,  CJK UNIFIED IDEOGRAPH-80F8
        0x80F3, # G+2446  U+80F3  uni80F3,  CJK UNIFIED IDEOGRAPH-80F3
        0x8108, # G+2447  U+8108  uni8108,  CJK UNIFIED IDEOGRAPH-8108
        0x80FD, # G+2448  U+80FD  uni80FD,  CJK UNIFIED IDEOGRAPH-80FD
        0x810A, # G+2449  U+810A  uni810A,  CJK UNIFIED IDEOGRAPH-810A
        0x80FC, # G+2450  U+80FC  uni80FC,  CJK UNIFIED IDEOGRAPH-80FC
        0x80EF, # G+2451  U+80EF  uni80EF,  CJK UNIFIED IDEOGRAPH-80EF
        0x81ED, # G+2452  U+81ED  uni81ED,  CJK UNIFIED IDEOGRAPH-81ED
        0x81EC, # G+2453  U+81EC  uni81EC,  CJK UNIFIED IDEOGRAPH-81EC
        0x8200, # G+2454  U+8200  uni8200,  CJK UNIFIED IDEOGRAPH-8200
        0x8210, # G+2455  U+8210  uni8210,  CJK UNIFIED IDEOGRAPH-8210
        0x822A, # G+2456  U+822A  uni822A,  CJK UNIFIED IDEOGRAPH-822A
        0x822B, # G+2457  U+822B  uni822B,  CJK UNIFIED IDEOGRAPH-822B
        0x8228, # G+2458  U+8228  uni8228,  CJK UNIFIED IDEOGRAPH-8228
        0x822C, # G+2459  U+822C  uni822C,  CJK UNIFIED IDEOGRAPH-822C
        0x82BB, # G+2460  U+82BB  uni82BB,  CJK UNIFIED IDEOGRAPH-82BB
        0x832B, # G+2461  U+832B  uni832B,  CJK UNIFIED IDEOGRAPH-832B
        0x8352, # G+2462  U+8352  uni8352,  CJK UNIFIED IDEOGRAPH-8352
        0x8354, # G+2463  U+8354  uni8354,  CJK UNIFIED IDEOGRAPH-8354
        0x834A, # G+2464  U+834A  uni834A,  CJK UNIFIED IDEOGRAPH-834A
        0x8338, # G+2465  U+8338  uni8338,  CJK UNIFIED IDEOGRAPH-8338
        0x8350, # G+2466  U+8350  uni8350,  CJK UNIFIED IDEOGRAPH-8350
        0x8349, # G+2467  U+8349  uni8349,  CJK UNIFIED IDEOGRAPH-8349
        0x8335, # G+2468  U+8335  uni8335,  CJK UNIFIED IDEOGRAPH-8335
        0x8334, # G+2469  U+8334  uni8334,  CJK UNIFIED IDEOGRAPH-8334
        0x834F, # G+2470  U+834F  uni834F,  CJK UNIFIED IDEOGRAPH-834F
        0x8332, # G+2471  U+8332  uni8332,  CJK UNIFIED IDEOGRAPH-8332
        0x8339, # G+2472  U+8339  uni8339,  CJK UNIFIED IDEOGRAPH-8339
        0x8336, # G+2473  U+8336  uni8336,  CJK UNIFIED IDEOGRAPH-8336
        0x8317, # G+2474  U+8317  uni8317,  CJK UNIFIED IDEOGRAPH-8317
        0x8340, # G+2475  U+8340  uni8340,  CJK UNIFIED IDEOGRAPH-8340
        0x8331, # G+2476  U+8331  uni8331,  CJK UNIFIED IDEOGRAPH-8331
        0x8328, # G+2477  U+8328  uni8328,  CJK UNIFIED IDEOGRAPH-8328
        0x8343, # G+2478  U+8343  uni8343,  CJK UNIFIED IDEOGRAPH-8343
        0x8654, # G+2479  U+8654  uni8654,  CJK UNIFIED IDEOGRAPH-8654
        0x868A, # G+2480  U+868A  uni868A,  CJK UNIFIED IDEOGRAPH-868A
        0x86AA, # G+2481  U+86AA  uni86AA,  CJK UNIFIED IDEOGRAPH-86AA
        0x8693, # G+2482  U+8693  uni8693,  CJK UNIFIED IDEOGRAPH-8693
        0x86A4, # G+2483  U+86A4  uni86A4,  CJK UNIFIED IDEOGRAPH-86A4
        0x86A9, # G+2484  U+86A9  uni86A9,  CJK UNIFIED IDEOGRAPH-86A9
        0x868C, # G+2485  U+868C  uni868C,  CJK UNIFIED IDEOGRAPH-868C
        0x86A3, # G+2486  U+86A3  uni86A3,  CJK UNIFIED IDEOGRAPH-86A3
        0x869C, # G+2487  U+869C  uni869C,  CJK UNIFIED IDEOGRAPH-869C
        0x8870, # G+2488  U+8870  uni8870,  CJK UNIFIED IDEOGRAPH-8870
        0x8877, # G+2489  U+8877  uni8877,  CJK UNIFIED IDEOGRAPH-8877
        0x8881, # G+2490  U+8881  uni8881,  CJK UNIFIED IDEOGRAPH-8881
        0x8882, # G+2491  U+8882  uni8882,  CJK UNIFIED IDEOGRAPH-8882
        0x887D, # G+2492  U+887D  uni887D,  CJK UNIFIED IDEOGRAPH-887D
        0x8879, # G+2493  U+8879  uni8879,  CJK UNIFIED IDEOGRAPH-8879
        0x8A18, # G+2494  U+8A18  uni8A18,  CJK UNIFIED IDEOGRAPH-8A18
        0x8A10, # G+2495  U+8A10  uni8A10,  CJK UNIFIED IDEOGRAPH-8A10
        0x8A0E, # G+2496  U+8A0E  uni8A0E,  CJK UNIFIED IDEOGRAPH-8A0E
        0x8A0C, # G+2497  U+8A0C  uni8A0C,  CJK UNIFIED IDEOGRAPH-8A0C
        0x8A15, # G+2498  U+8A15  uni8A15,  CJK UNIFIED IDEOGRAPH-8A15
        0x8A0A, # G+2499  U+8A0A  uni8A0A,  CJK UNIFIED IDEOGRAPH-8A0A
        0x8A17, # G+2500  U+8A17  uni8A17,  CJK UNIFIED IDEOGRAPH-8A17
        0x8A13, # G+2501  U+8A13  uni8A13,  CJK UNIFIED IDEOGRAPH-8A13
        0x8A16, # G+2502  U+8A16  uni8A16,  CJK UNIFIED IDEOGRAPH-8A16
        0x8A0F, # G+2503  U+8A0F  uni8A0F,  CJK UNIFIED IDEOGRAPH-8A0F
        0x8A11, # G+2504  U+8A11  uni8A11,  CJK UNIFIED IDEOGRAPH-8A11
        0x8C48, # G+2505  U+8C48  uni8C48,  CJK UNIFIED IDEOGRAPH-8C48
        0x8C7A, # G+2506  U+8C7A  uni8C7A,  CJK UNIFIED IDEOGRAPH-8C7A
        0x8C79, # G+2507  U+8C79  uni8C79,  CJK UNIFIED IDEOGRAPH-8C79
        0x8CA1, # G+2508  U+8CA1  uni8CA1,  CJK UNIFIED IDEOGRAPH-8CA1
        0x8CA2, # G+2509  U+8CA2  uni8CA2,  CJK UNIFIED IDEOGRAPH-8CA2
        0x8D77, # G+2510  U+8D77  uni8D77,  CJK UNIFIED IDEOGRAPH-8D77
        0x8EAC, # G+2511  U+8EAC  uni8EAC,  CJK UNIFIED IDEOGRAPH-8EAC
        0x8ED2, # G+2512  U+8ED2  uni8ED2,  CJK UNIFIED IDEOGRAPH-8ED2
        0x8ED4, # G+2513  U+8ED4  uni8ED4,  CJK UNIFIED IDEOGRAPH-8ED4
        0x8ECF, # G+2514  U+8ECF  uni8ECF,  CJK UNIFIED IDEOGRAPH-8ECF
        0x8FB1, # G+2515  U+8FB1  uni8FB1,  CJK UNIFIED IDEOGRAPH-8FB1
        0x9001, # G+2516  U+9001  uni9001,  CJK UNIFIED IDEOGRAPH-9001
        0x9006, # G+2517  U+9006  uni9006,  CJK UNIFIED IDEOGRAPH-9006
        0x8FF7, # G+2518  U+8FF7  uni8FF7,  CJK UNIFIED IDEOGRAPH-8FF7
        0x9000, # G+2519  U+9000  uni9000,  CJK UNIFIED IDEOGRAPH-9000
        0x8FFA, # G+2520  U+8FFA  uni8FFA,  CJK UNIFIED IDEOGRAPH-8FFA
        0x8FF4, # G+2521  U+8FF4  uni8FF4,  CJK UNIFIED IDEOGRAPH-8FF4
        0x9003, # G+2522  U+9003  uni9003,  CJK UNIFIED IDEOGRAPH-9003
        0x8FFD, # G+2523  U+8FFD  uni8FFD,  CJK UNIFIED IDEOGRAPH-8FFD
        0x9005, # G+2524  U+9005  uni9005,  CJK UNIFIED IDEOGRAPH-9005
        0x8FF8, # G+2525  U+8FF8  uni8FF8,  CJK UNIFIED IDEOGRAPH-8FF8
        0x9095, # G+2526  U+9095  uni9095,  CJK UNIFIED IDEOGRAPH-9095
        0x90E1, # G+2527  U+90E1  uni90E1,  CJK UNIFIED IDEOGRAPH-90E1
        0x90DD, # G+2528  U+90DD  uni90DD,  CJK UNIFIED IDEOGRAPH-90DD
        0x90E2, # G+2529  U+90E2  uni90E2,  CJK UNIFIED IDEOGRAPH-90E2
        0x9152, # G+2530  U+9152  uni9152,  CJK UNIFIED IDEOGRAPH-9152
        0x914D, # G+2531  U+914D  uni914D,  CJK UNIFIED IDEOGRAPH-914D
        0x914C, # G+2532  U+914C  uni914C,  CJK UNIFIED IDEOGRAPH-914C
        0x91D8, # G+2533  U+91D8  uni91D8,  CJK UNIFIED IDEOGRAPH-91D8
        0x91DD, # G+2534  U+91DD  uni91DD,  CJK UNIFIED IDEOGRAPH-91DD
        0x91D7, # G+2535  U+91D7  uni91D7,  CJK UNIFIED IDEOGRAPH-91D7
        0x91DC, # G+2536  U+91DC  uni91DC,  CJK UNIFIED IDEOGRAPH-91DC
        0x91D9, # G+2537  U+91D9  uni91D9,  CJK UNIFIED IDEOGRAPH-91D9
        0x9583, # G+2538  U+9583  uni9583,  CJK UNIFIED IDEOGRAPH-9583
        0x9662, # G+2539  U+9662  uni9662,  CJK UNIFIED IDEOGRAPH-9662
        0x9663, # G+2540  U+9663  uni9663,  CJK UNIFIED IDEOGRAPH-9663
        0x9661, # G+2541  U+9661  uni9661,  CJK UNIFIED IDEOGRAPH-9661
        0x965B, # G+2542  U+965B  uni965B,  CJK UNIFIED IDEOGRAPH-965B
        0x965D, # G+2543  U+965D  uni965D,  CJK UNIFIED IDEOGRAPH-965D
        0x9664, # G+2544  U+9664  uni9664,  CJK UNIFIED IDEOGRAPH-9664
        0x9658, # G+2545  U+9658  uni9658,  CJK UNIFIED IDEOGRAPH-9658
        0x965E, # G+2546  U+965E  uni965E,  CJK UNIFIED IDEOGRAPH-965E
        0x96BB, # G+2547  U+96BB  uni96BB,  CJK UNIFIED IDEOGRAPH-96BB
        0x98E2, # G+2548  U+98E2  uni98E2,  CJK UNIFIED IDEOGRAPH-98E2
        0x99AC, # G+2549  U+99AC  uni99AC,  CJK UNIFIED IDEOGRAPH-99AC
        0x9AA8, # G+2550  U+9AA8  uni9AA8,  CJK UNIFIED IDEOGRAPH-9AA8
        0x9AD8, # G+2551  U+9AD8  uni9AD8,  CJK UNIFIED IDEOGRAPH-9AD8
        0x2FBE, # G+2552  U+2FBE  uni2FBE,  KANGXI RADICAL FIGHT
        0x9B32, # G+2553  U+9B32  uni9B32,  CJK UNIFIED IDEOGRAPH-9B32
        0x9B3C, # G+2554  U+9B3C  uni9B3C,  CJK UNIFIED IDEOGRAPH-9B3C
        0x4E7E, # G+2555  U+4E7E  uni4E7E,  CJK UNIFIED IDEOGRAPH-4E7E
        0x507A, # G+2556  U+507A  uni507A,  CJK UNIFIED IDEOGRAPH-507A
        0x507D, # G+2557  U+507D  uni507D,  CJK UNIFIED IDEOGRAPH-507D
        0x505C, # G+2558  U+505C  uni505C,  CJK UNIFIED IDEOGRAPH-505C
        0x5047, # G+2559  U+5047  uni5047,  CJK UNIFIED IDEOGRAPH-5047
        0x5043, # G+2560  U+5043  uni5043,  CJK UNIFIED IDEOGRAPH-5043
        0x504C, # G+2561  U+504C  uni504C,  CJK UNIFIED IDEOGRAPH-504C
        0x505A, # G+2562  U+505A  uni505A,  CJK UNIFIED IDEOGRAPH-505A
        0x5049, # G+2563  U+5049  uni5049,  CJK UNIFIED IDEOGRAPH-5049
        0x5065, # G+2564  U+5065  uni5065,  CJK UNIFIED IDEOGRAPH-5065
        0x5076, # G+2565  U+5076  uni5076,  CJK UNIFIED IDEOGRAPH-5076
        0x504E, # G+2566  U+504E  uni504E,  CJK UNIFIED IDEOGRAPH-504E
        0x5055, # G+2567  U+5055  uni5055,  CJK UNIFIED IDEOGRAPH-5055
        0x5075, # G+2568  U+5075  uni5075,  CJK UNIFIED IDEOGRAPH-5075
        0x5074, # G+2569  U+5074  uni5074,  CJK UNIFIED IDEOGRAPH-5074
        0x5077, # G+2570  U+5077  uni5077,  CJK UNIFIED IDEOGRAPH-5077
        0x504F, # G+2571  U+504F  uni504F,  CJK UNIFIED IDEOGRAPH-504F
        0x500F, # G+2572  U+500F  uni500F,  CJK UNIFIED IDEOGRAPH-500F
        0x506F, # G+2573  U+506F  uni506F,  CJK UNIFIED IDEOGRAPH-506F
        0x506D, # G+2574  U+506D  uni506D,  CJK UNIFIED IDEOGRAPH-506D
        0x515C, # G+2575  U+515C  uni515C,  CJK UNIFIED IDEOGRAPH-515C
        0x5195, # G+2576  U+5195  uni5195,  CJK UNIFIED IDEOGRAPH-5195
        0x51F0, # G+2577  U+51F0  uni51F0,  CJK UNIFIED IDEOGRAPH-51F0
        0x526A, # G+2578  U+526A  uni526A,  CJK UNIFIED IDEOGRAPH-526A
        0x526F, # G+2579  U+526F  uni526F,  CJK UNIFIED IDEOGRAPH-526F
        0x52D2, # G+2580  U+52D2  uni52D2,  CJK UNIFIED IDEOGRAPH-52D2
        0x52D9, # G+2581  U+52D9  uni52D9,  CJK UNIFIED IDEOGRAPH-52D9
        0x52D8, # G+2582  U+52D8  uni52D8,  CJK UNIFIED IDEOGRAPH-52D8
        0x52D5, # G+2583  U+52D5  uni52D5,  CJK UNIFIED IDEOGRAPH-52D5
        0x5310, # G+2584  U+5310  uni5310,  CJK UNIFIED IDEOGRAPH-5310
        0x530F, # G+2585  U+530F  uni530F,  CJK UNIFIED IDEOGRAPH-530F
        0x5319, # G+2586  U+5319  uni5319,  CJK UNIFIED IDEOGRAPH-5319
        0x533F, # G+2587  U+533F  uni533F,  CJK UNIFIED IDEOGRAPH-533F
        0x5340, # G+2588  U+5340  uni5340,  CJK UNIFIED IDEOGRAPH-5340
        0x533E, # G+2589  U+533E  uni533E,  CJK UNIFIED IDEOGRAPH-533E
        0x53C3, # G+2590  U+53C3  uni53C3,  CJK UNIFIED IDEOGRAPH-53C3
        0x66FC, # G+2591  U+66FC  uni66FC,  CJK UNIFIED IDEOGRAPH-66FC
        0x5546, # G+2592  U+5546  uni5546,  CJK UNIFIED IDEOGRAPH-5546
        0x556A, # G+2593  U+556A  uni556A,  CJK UNIFIED IDEOGRAPH-556A
        0x5566, # G+2594  U+5566  uni5566,  CJK UNIFIED IDEOGRAPH-5566
        0x5544, # G+2595  U+5544  uni5544,  CJK UNIFIED IDEOGRAPH-5544
        0x555E, # G+2596  U+555E  uni555E,  CJK UNIFIED IDEOGRAPH-555E
        0x5561, # G+2597  U+5561  uni5561,  CJK UNIFIED IDEOGRAPH-5561
        0x5543, # G+2598  U+5543  uni5543,  CJK UNIFIED IDEOGRAPH-5543
        0x554A, # G+2599  U+554A  uni554A,  CJK UNIFIED IDEOGRAPH-554A
        0x5531, # G+2600  U+5531  uni5531,  CJK UNIFIED IDEOGRAPH-5531
        0x5556, # G+2601  U+5556  uni5556,  CJK UNIFIED IDEOGRAPH-5556
        0x554F, # G+2602  U+554F  uni554F,  CJK UNIFIED IDEOGRAPH-554F
        0x5555, # G+2603  U+5555  uni5555,  CJK UNIFIED IDEOGRAPH-5555
        0x552F, # G+2604  U+552F  uni552F,  CJK UNIFIED IDEOGRAPH-552F
        0x5564, # G+2605  U+5564  uni5564,  CJK UNIFIED IDEOGRAPH-5564
        0x5538, # G+2606  U+5538  uni5538,  CJK UNIFIED IDEOGRAPH-5538
        0x552E, # G+2607  U+552E  uni552E,  CJK UNIFIED IDEOGRAPH-552E
        0x555C, # G+2608  U+555C  uni555C,  CJK UNIFIED IDEOGRAPH-555C
        0x552C, # G+2609  U+552C  uni552C,  CJK UNIFIED IDEOGRAPH-552C
        0x5563, # G+2610  U+5563  uni5563,  CJK UNIFIED IDEOGRAPH-5563
        0x5533, # G+2611  U+5533  uni5533,  CJK UNIFIED IDEOGRAPH-5533
        0x5541, # G+2612  U+5541  uni5541,  CJK UNIFIED IDEOGRAPH-5541
        0x5557, # G+2613  U+5557  uni5557,  CJK UNIFIED IDEOGRAPH-5557
        0x5708, # G+2614  U+5708  uni5708,  CJK UNIFIED IDEOGRAPH-5708
        0x570B, # G+2615  U+570B  uni570B,  CJK UNIFIED IDEOGRAPH-570B
        0x5709, # G+2616  U+5709  uni5709,  CJK UNIFIED IDEOGRAPH-5709
        0x57DF, # G+2617  U+57DF  uni57DF,  CJK UNIFIED IDEOGRAPH-57DF
        0x5805, # G+2618  U+5805  uni5805,  CJK UNIFIED IDEOGRAPH-5805
        0x580A, # G+2619  U+580A  uni580A,  CJK UNIFIED IDEOGRAPH-580A
        0x5806, # G+2620  U+5806  uni5806,  CJK UNIFIED IDEOGRAPH-5806
        0x57E0, # G+2621  U+57E0  uni57E0,  CJK UNIFIED IDEOGRAPH-57E0
        0x57E4, # G+2622  U+57E4  uni57E4,  CJK UNIFIED IDEOGRAPH-57E4
        0x57FA, # G+2623  U+57FA  uni57FA,  CJK UNIFIED IDEOGRAPH-57FA
        0x5802, # G+2624  U+5802  uni5802,  CJK UNIFIED IDEOGRAPH-5802
        0x5835, # G+2625  U+5835  uni5835,  CJK UNIFIED IDEOGRAPH-5835
        0x57F7, # G+2626  U+57F7  uni57F7,  CJK UNIFIED IDEOGRAPH-57F7
        0x57F9, # G+2627  U+57F9  uni57F9,  CJK UNIFIED IDEOGRAPH-57F9
        0x5920, # G+2628  U+5920  uni5920,  CJK UNIFIED IDEOGRAPH-5920
        0x5962, # G+2629  U+5962  uni5962,  CJK UNIFIED IDEOGRAPH-5962
        0x5A36, # G+2630  U+5A36  uni5A36,  CJK UNIFIED IDEOGRAPH-5A36
        0x5A41, # G+2631  U+5A41  uni5A41,  CJK UNIFIED IDEOGRAPH-5A41
        0x5A49, # G+2632  U+5A49  uni5A49,  CJK UNIFIED IDEOGRAPH-5A49
        0x5A66, # G+2633  U+5A66  uni5A66,  CJK UNIFIED IDEOGRAPH-5A66
        0x5A6A, # G+2634  U+5A6A  uni5A6A,  CJK UNIFIED IDEOGRAPH-5A6A
        0x5A40, # G+2635  U+5A40  uni5A40,  CJK UNIFIED IDEOGRAPH-5A40
        0x5A3C, # G+2636  U+5A3C  uni5A3C,  CJK UNIFIED IDEOGRAPH-5A3C
        0x5A62, # G+2637  U+5A62  uni5A62,  CJK UNIFIED IDEOGRAPH-5A62
        0x5A5A, # G+2638  U+5A5A  uni5A5A,  CJK UNIFIED IDEOGRAPH-5A5A
        0x5A46, # G+2639  U+5A46  uni5A46,  CJK UNIFIED IDEOGRAPH-5A46
        0x5A4A, # G+2640  U+5A4A  uni5A4A,  CJK UNIFIED IDEOGRAPH-5A4A
        0x5B70, # G+2641  U+5B70  uni5B70,  CJK UNIFIED IDEOGRAPH-5B70
        0x5BC7, # G+2642  U+5BC7  uni5BC7,  CJK UNIFIED IDEOGRAPH-5BC7
        0x5BC5, # G+2643  U+5BC5  uni5BC5,  CJK UNIFIED IDEOGRAPH-5BC5
        0x5BC4, # G+2644  U+5BC4  uni5BC4,  CJK UNIFIED IDEOGRAPH-5BC4
        0x5BC2, # G+2645  U+5BC2  uni5BC2,  CJK UNIFIED IDEOGRAPH-5BC2
        0x5BBF, # G+2646  U+5BBF  uni5BBF,  CJK UNIFIED IDEOGRAPH-5BBF
        0x5BC6, # G+2647  U+5BC6  uni5BC6,  CJK UNIFIED IDEOGRAPH-5BC6
        0x5C09, # G+2648  U+5C09  uni5C09,  CJK UNIFIED IDEOGRAPH-5C09
        0x5C08, # G+2649  U+5C08  uni5C08,  CJK UNIFIED IDEOGRAPH-5C08
        0x5C07, # G+2650  U+5C07  uni5C07,  CJK UNIFIED IDEOGRAPH-5C07
        0x5C60, # G+2651  U+5C60  uni5C60,  CJK UNIFIED IDEOGRAPH-5C60
        0x5C5C, # G+2652  U+5C5C  uni5C5C,  CJK UNIFIED IDEOGRAPH-5C5C
        0x5C5D, # G+2653  U+5C5D  uni5C5D,  CJK UNIFIED IDEOGRAPH-5C5D
        0x5D07, # G+2654  U+5D07  uni5D07,  CJK UNIFIED IDEOGRAPH-5D07
        0x5D06, # G+2655  U+5D06  uni5D06,  CJK UNIFIED IDEOGRAPH-5D06
        0x5D0E, # G+2656  U+5D0E  uni5D0E,  CJK UNIFIED IDEOGRAPH-5D0E
        0x5D1B, # G+2657  U+5D1B  uni5D1B,  CJK UNIFIED IDEOGRAPH-5D1B
        0x5D16, # G+2658  U+5D16  uni5D16,  CJK UNIFIED IDEOGRAPH-5D16
        0x5D22, # G+2659  U+5D22  uni5D22,  CJK UNIFIED IDEOGRAPH-5D22
        0x5D11, # G+2660  U+5D11  uni5D11,  CJK UNIFIED IDEOGRAPH-5D11
        0x5D29, # G+2661  U+5D29  uni5D29,  CJK UNIFIED IDEOGRAPH-5D29
        0x5D14, # G+2662  U+5D14  uni5D14,  CJK UNIFIED IDEOGRAPH-5D14
        0x5D19, # G+2663  U+5D19  uni5D19,  CJK UNIFIED IDEOGRAPH-5D19
        0x5D24, # G+2664  U+5D24  uni5D24,  CJK UNIFIED IDEOGRAPH-5D24
        0x5D27, # G+2665  U+5D27  uni5D27,  CJK UNIFIED IDEOGRAPH-5D27
        0x5D17, # G+2666  U+5D17  uni5D17,  CJK UNIFIED IDEOGRAPH-5D17
        0x5DE2, # G+2667  U+5DE2  uni5DE2,  CJK UNIFIED IDEOGRAPH-5DE2
        0x5E38, # G+2668  U+5E38  uni5E38,  CJK UNIFIED IDEOGRAPH-5E38
        0x5E36, # G+2669  U+5E36  uni5E36,  CJK UNIFIED IDEOGRAPH-5E36
        0x5E33, # G+2670  U+5E33  uni5E33,  CJK UNIFIED IDEOGRAPH-5E33
        0x5E37, # G+2671  U+5E37  uni5E37,  CJK UNIFIED IDEOGRAPH-5E37
        0x5EB7, # G+2672  U+5EB7  uni5EB7,  CJK UNIFIED IDEOGRAPH-5EB7
        0x5EB8, # G+2673  U+5EB8  uni5EB8,  CJK UNIFIED IDEOGRAPH-5EB8
        0x5EB6, # G+2674  U+5EB6  uni5EB6,  CJK UNIFIED IDEOGRAPH-5EB6
        0x5EB5, # G+2675  U+5EB5  uni5EB5,  CJK UNIFIED IDEOGRAPH-5EB5
        0x5EBE, # G+2676  U+5EBE  uni5EBE,  CJK UNIFIED IDEOGRAPH-5EBE
        0x5F35, # G+2677  U+5F35  uni5F35,  CJK UNIFIED IDEOGRAPH-5F35
        0x5F37, # G+2678  U+5F37  uni5F37,  CJK UNIFIED IDEOGRAPH-5F37
        0x5F57, # G+2679  U+5F57  uni5F57,  CJK UNIFIED IDEOGRAPH-5F57
        0x5F6C, # G+2680  U+5F6C  uni5F6C,  CJK UNIFIED IDEOGRAPH-5F6C
        0x5F69, # G+2681  U+5F69  uni5F69,  CJK UNIFIED IDEOGRAPH-5F69
        0x5F6B, # G+2682  U+5F6B  uni5F6B,  CJK UNIFIED IDEOGRAPH-5F6B
        0x5F97, # G+2683  U+5F97  uni5F97,  CJK UNIFIED IDEOGRAPH-5F97
        0x5F99, # G+2684  U+5F99  uni5F99,  CJK UNIFIED IDEOGRAPH-5F99
        0x5F9E, # G+2685  U+5F9E  uni5F9E,  CJK UNIFIED IDEOGRAPH-5F9E
        0x5F98, # G+2686  U+5F98  uni5F98,  CJK UNIFIED IDEOGRAPH-5F98
        0x5FA1, # G+2687  U+5FA1  uni5FA1,  CJK UNIFIED IDEOGRAPH-5FA1
        0x5FA0, # G+2688  U+5FA0  uni5FA0,  CJK UNIFIED IDEOGRAPH-5FA0
        0x5F9C, # G+2689  U+5F9C  uni5F9C,  CJK UNIFIED IDEOGRAPH-5F9C
        0x607F, # G+2690  U+607F  uni607F,  CJK UNIFIED IDEOGRAPH-607F
        0x60A3, # G+2691  U+60A3  uni60A3,  CJK UNIFIED IDEOGRAPH-60A3
        0x6089, # G+2692  U+6089  uni6089,  CJK UNIFIED IDEOGRAPH-6089
        0x60A0, # G+2693  U+60A0  uni60A0,  CJK UNIFIED IDEOGRAPH-60A0
        0x60A8, # G+2694  U+60A8  uni60A8,  CJK UNIFIED IDEOGRAPH-60A8
        0x60CB, # G+2695  U+60CB  uni60CB,  CJK UNIFIED IDEOGRAPH-60CB
        0x60B4, # G+2696  U+60B4  uni60B4,  CJK UNIFIED IDEOGRAPH-60B4
        0x60E6, # G+2697  U+60E6  uni60E6,  CJK UNIFIED IDEOGRAPH-60E6
        0x60BD, # G+2698  U+60BD  uni60BD,  CJK UNIFIED IDEOGRAPH-60BD
        0x60C5, # G+2699  U+60C5  uni60C5,  CJK UNIFIED IDEOGRAPH-60C5
        0x60BB, # G+2700  U+60BB  uni60BB,  CJK UNIFIED IDEOGRAPH-60BB
        0x60B5, # G+2701  U+60B5  uni60B5,  CJK UNIFIED IDEOGRAPH-60B5
        0x60DC, # G+2702  U+60DC  uni60DC,  CJK UNIFIED IDEOGRAPH-60DC
        0x60BC, # G+2703  U+60BC  uni60BC,  CJK UNIFIED IDEOGRAPH-60BC
        0x60D8, # G+2704  U+60D8  uni60D8,  CJK UNIFIED IDEOGRAPH-60D8
        0x60D5, # G+2705  U+60D5  uni60D5,  CJK UNIFIED IDEOGRAPH-60D5
        0x60C6, # G+2706  U+60C6  uni60C6,  CJK UNIFIED IDEOGRAPH-60C6
        0x60DF, # G+2707  U+60DF  uni60DF,  CJK UNIFIED IDEOGRAPH-60DF
        0x60B8, # G+2708  U+60B8  uni60B8,  CJK UNIFIED IDEOGRAPH-60B8
        0x60DA, # G+2709  U+60DA  uni60DA,  CJK UNIFIED IDEOGRAPH-60DA
        0x60C7, # G+2710  U+60C7  uni60C7,  CJK UNIFIED IDEOGRAPH-60C7
        0x621A, # G+2711  U+621A  uni621A,  CJK UNIFIED IDEOGRAPH-621A
        0x621B, # G+2712  U+621B  uni621B,  CJK UNIFIED IDEOGRAPH-621B
        0x6248, # G+2713  U+6248  uni6248,  CJK UNIFIED IDEOGRAPH-6248
        0x63A0, # G+2714  U+63A0  uni63A0,  CJK UNIFIED IDEOGRAPH-63A0
        0x63A7, # G+2715  U+63A7  uni63A7,  CJK UNIFIED IDEOGRAPH-63A7
        0x6372, # G+2716  U+6372  uni6372,  CJK UNIFIED IDEOGRAPH-6372
        0x6396, # G+2717  U+6396  uni6396,  CJK UNIFIED IDEOGRAPH-6396
        0x63A2, # G+2718  U+63A2  uni63A2,  CJK UNIFIED IDEOGRAPH-63A2
        0x63A5, # G+2719  U+63A5  uni63A5,  CJK UNIFIED IDEOGRAPH-63A5
        0x6377, # G+2720  U+6377  uni6377,  CJK UNIFIED IDEOGRAPH-6377
        0x6367, # G+2721  U+6367  uni6367,  CJK UNIFIED IDEOGRAPH-6367
        0x6398, # G+2722  U+6398  uni6398,  CJK UNIFIED IDEOGRAPH-6398
        0x63AA, # G+2723  U+63AA  uni63AA,  CJK UNIFIED IDEOGRAPH-63AA
        0x6371, # G+2724  U+6371  uni6371,  CJK UNIFIED IDEOGRAPH-6371
        0x63A9, # G+2725  U+63A9  uni63A9,  CJK UNIFIED IDEOGRAPH-63A9
        0x6389, # G+2726  U+6389  uni6389,  CJK UNIFIED IDEOGRAPH-6389
        0x6383, # G+2727  U+6383  uni6383,  CJK UNIFIED IDEOGRAPH-6383
        0x639B, # G+2728  U+639B  uni639B,  CJK UNIFIED IDEOGRAPH-639B
        0x636B, # G+2729  U+636B  uni636B,  CJK UNIFIED IDEOGRAPH-636B
        0x63A8, # G+2730  U+63A8  uni63A8,  CJK UNIFIED IDEOGRAPH-63A8
        0x6384, # G+2731  U+6384  uni6384,  CJK UNIFIED IDEOGRAPH-6384
        0x6388, # G+2732  U+6388  uni6388,  CJK UNIFIED IDEOGRAPH-6388
        0x6399, # G+2733  U+6399  uni6399,  CJK UNIFIED IDEOGRAPH-6399
        0x63A1, # G+2734  U+63A1  uni63A1,  CJK UNIFIED IDEOGRAPH-63A1
        0x63AC, # G+2735  U+63AC  uni63AC,  CJK UNIFIED IDEOGRAPH-63AC
        0x6392, # G+2736  U+6392  uni6392,  CJK UNIFIED IDEOGRAPH-6392
        0x638F, # G+2737  U+638F  uni638F,  CJK UNIFIED IDEOGRAPH-638F
        0x6380, # G+2738  U+6380  uni6380,  CJK UNIFIED IDEOGRAPH-6380
        0x637B, # G+2739  U+637B  uni637B,  CJK UNIFIED IDEOGRAPH-637B
        0x6369, # G+2740  U+6369  uni6369,  CJK UNIFIED IDEOGRAPH-6369
        0x6368, # G+2741  U+6368  uni6368,  CJK UNIFIED IDEOGRAPH-6368
        0x637A, # G+2742  U+637A  uni637A,  CJK UNIFIED IDEOGRAPH-637A
        0x655D, # G+2743  U+655D  uni655D,  CJK UNIFIED IDEOGRAPH-655D
        0x6556, # G+2744  U+6556  uni6556,  CJK UNIFIED IDEOGRAPH-6556
        0x6551, # G+2745  U+6551  uni6551,  CJK UNIFIED IDEOGRAPH-6551
        0x6559, # G+2746  U+6559  uni6559,  CJK UNIFIED IDEOGRAPH-6559
        0x6557, # G+2747  U+6557  uni6557,  CJK UNIFIED IDEOGRAPH-6557
        0x555F, # G+2748  U+555F  uni555F,  CJK UNIFIED IDEOGRAPH-555F
        0x654F, # G+2749  U+654F  uni654F,  CJK UNIFIED IDEOGRAPH-654F
        0x6558, # G+2750  U+6558  uni6558,  CJK UNIFIED IDEOGRAPH-6558
        0x6555, # G+2751  U+6555  uni6555,  CJK UNIFIED IDEOGRAPH-6555
        0x6554, # G+2752  U+6554  uni6554,  CJK UNIFIED IDEOGRAPH-6554
        0x659C, # G+2753  U+659C  uni659C,  CJK UNIFIED IDEOGRAPH-659C
        0x659B, # G+2754  U+659B  uni659B,  CJK UNIFIED IDEOGRAPH-659B
        0x65AC, # G+2755  U+65AC  uni65AC,  CJK UNIFIED IDEOGRAPH-65AC
        0x65CF, # G+2756  U+65CF  uni65CF,  CJK UNIFIED IDEOGRAPH-65CF
        0x65CB, # G+2757  U+65CB  uni65CB,  CJK UNIFIED IDEOGRAPH-65CB
        0x65CC, # G+2758  U+65CC  uni65CC,  CJK UNIFIED IDEOGRAPH-65CC
        0x65CE, # G+2759  U+65CE  uni65CE,  CJK UNIFIED IDEOGRAPH-65CE
        0x665D, # G+2760  U+665D  uni665D,  CJK UNIFIED IDEOGRAPH-665D
        0x665A, # G+2761  U+665A  uni665A,  CJK UNIFIED IDEOGRAPH-665A
        0x6664, # G+2762  U+6664  uni6664,  CJK UNIFIED IDEOGRAPH-6664
        0x6668, # G+2763  U+6668  uni6668,  CJK UNIFIED IDEOGRAPH-6668
        0x6666, # G+2764  U+6666  uni6666,  CJK UNIFIED IDEOGRAPH-6666
        0x665E, # G+2765  U+665E  uni665E,  CJK UNIFIED IDEOGRAPH-665E
        0x66F9, # G+2766  U+66F9  uni66F9,  CJK UNIFIED IDEOGRAPH-66F9
        0x52D7, # G+2767  U+52D7  uni52D7,  CJK UNIFIED IDEOGRAPH-52D7
        0x671B, # G+2768  U+671B  uni671B,  CJK UNIFIED IDEOGRAPH-671B
        0x6881, # G+2769  U+6881  uni6881,  CJK UNIFIED IDEOGRAPH-6881
        0x68AF, # G+2770  U+68AF  uni68AF,  CJK UNIFIED IDEOGRAPH-68AF
        0x68A2, # G+2771  U+68A2  uni68A2,  CJK UNIFIED IDEOGRAPH-68A2
        0x6893, # G+2772  U+6893  uni6893,  CJK UNIFIED IDEOGRAPH-6893
        0x68B5, # G+2773  U+68B5  uni68B5,  CJK UNIFIED IDEOGRAPH-68B5
        0x687F, # G+2774  U+687F  uni687F,  CJK UNIFIED IDEOGRAPH-687F
        0x6876, # G+2775  U+6876  uni6876,  CJK UNIFIED IDEOGRAPH-6876
        0x68B1, # G+2776  U+68B1  uni68B1,  CJK UNIFIED IDEOGRAPH-68B1
        0x68A7, # G+2777  U+68A7  uni68A7,  CJK UNIFIED IDEOGRAPH-68A7
        0x6897, # G+2778  U+6897  uni6897,  CJK UNIFIED IDEOGRAPH-6897
        0x68B0, # G+2779  U+68B0  uni68B0,  CJK UNIFIED IDEOGRAPH-68B0
        0x6883, # G+2780  U+6883  uni6883,  CJK UNIFIED IDEOGRAPH-6883
        0x68C4, # G+2781  U+68C4  uni68C4,  CJK UNIFIED IDEOGRAPH-68C4
        0x68AD, # G+2782  U+68AD  uni68AD,  CJK UNIFIED IDEOGRAPH-68AD
        0x6886, # G+2783  U+6886  uni6886,  CJK UNIFIED IDEOGRAPH-6886
        0x6885, # G+2784  U+6885  uni6885,  CJK UNIFIED IDEOGRAPH-6885
        0x6894, # G+2785  U+6894  uni6894,  CJK UNIFIED IDEOGRAPH-6894
        0x689D, # G+2786  U+689D  uni689D,  CJK UNIFIED IDEOGRAPH-689D
        0x68A8, # G+2787  U+68A8  uni68A8,  CJK UNIFIED IDEOGRAPH-68A8
        0x689F, # G+2788  U+689F  uni689F,  CJK UNIFIED IDEOGRAPH-689F
        0x68A1, # G+2789  U+68A1  uni68A1,  CJK UNIFIED IDEOGRAPH-68A1
        0x6882, # G+2790  U+6882  uni6882,  CJK UNIFIED IDEOGRAPH-6882
        0x6B32, # G+2791  U+6B32  uni6B32,  CJK UNIFIED IDEOGRAPH-6B32
        0x6BBA, # G+2792  U+6BBA  uni6BBA,  CJK UNIFIED IDEOGRAPH-6BBA
        0x6BEB, # G+2793  U+6BEB  uni6BEB,  CJK UNIFIED IDEOGRAPH-6BEB
        0x6BEC, # G+2794  U+6BEC  uni6BEC,  CJK UNIFIED IDEOGRAPH-6BEC
        0x6C2B, # G+2795  U+6C2B  uni6C2B,  CJK UNIFIED IDEOGRAPH-6C2B
        0x6D8E, # G+2796  U+6D8E  uni6D8E,  CJK UNIFIED IDEOGRAPH-6D8E
        0x6DBC, # G+2797  U+6DBC  uni6DBC,  CJK UNIFIED IDEOGRAPH-6DBC
        0x6DF3, # G+2798  U+6DF3  uni6DF3,  CJK UNIFIED IDEOGRAPH-6DF3
        0x6DD9, # G+2799  U+6DD9  uni6DD9,  CJK UNIFIED IDEOGRAPH-6DD9
        0x6DB2, # G+2800  U+6DB2  uni6DB2,  CJK UNIFIED IDEOGRAPH-6DB2
        0x6DE1, # G+2801  U+6DE1  uni6DE1,  CJK UNIFIED IDEOGRAPH-6DE1
        0x6DCC, # G+2802  U+6DCC  uni6DCC,  CJK UNIFIED IDEOGRAPH-6DCC
        0x6DE4, # G+2803  U+6DE4  uni6DE4,  CJK UNIFIED IDEOGRAPH-6DE4
        0x6DFB, # G+2804  U+6DFB  uni6DFB,  CJK UNIFIED IDEOGRAPH-6DFB
        0x6DFA, # G+2805  U+6DFA  uni6DFA,  CJK UNIFIED IDEOGRAPH-6DFA
        0x6E05, # G+2806  U+6E05  uni6E05,  CJK UNIFIED IDEOGRAPH-6E05
        0x6DC7, # G+2807  U+6DC7  uni6DC7,  CJK UNIFIED IDEOGRAPH-6DC7
        0x6DCB, # G+2808  U+6DCB  uni6DCB,  CJK UNIFIED IDEOGRAPH-6DCB
        0x6DAF, # G+2809  U+6DAF  uni6DAF,  CJK UNIFIED IDEOGRAPH-6DAF
        0x6DD1, # G+2810  U+6DD1  uni6DD1,  CJK UNIFIED IDEOGRAPH-6DD1
        0x6DAE, # G+2811  U+6DAE  uni6DAE,  CJK UNIFIED IDEOGRAPH-6DAE
        0x6DDE, # G+2812  U+6DDE  uni6DDE,  CJK UNIFIED IDEOGRAPH-6DDE
        0x6DF9, # G+2813  U+6DF9  uni6DF9,  CJK UNIFIED IDEOGRAPH-6DF9
        0x6DB8, # G+2814  U+6DB8  uni6DB8,  CJK UNIFIED IDEOGRAPH-6DB8
        0x6DF7, # G+2815  U+6DF7  uni6DF7,  CJK UNIFIED IDEOGRAPH-6DF7
        0x6DF5, # G+2816  U+6DF5  uni6DF5,  CJK UNIFIED IDEOGRAPH-6DF5
        0x6DC5, # G+2817  U+6DC5  uni6DC5,  CJK UNIFIED IDEOGRAPH-6DC5
        0x6DD2, # G+2818  U+6DD2  uni6DD2,  CJK UNIFIED IDEOGRAPH-6DD2
        0x6E1A, # G+2819  U+6E1A  uni6E1A,  CJK UNIFIED IDEOGRAPH-6E1A
        0x6DB5, # G+2820  U+6DB5  uni6DB5,  CJK UNIFIED IDEOGRAPH-6DB5
        0x6DDA, # G+2821  U+6DDA  uni6DDA,  CJK UNIFIED IDEOGRAPH-6DDA
        0x6DEB, # G+2822  U+6DEB  uni6DEB,  CJK UNIFIED IDEOGRAPH-6DEB
        0x6DD8, # G+2823  U+6DD8  uni6DD8,  CJK UNIFIED IDEOGRAPH-6DD8
        0x6DEA, # G+2824  U+6DEA  uni6DEA,  CJK UNIFIED IDEOGRAPH-6DEA
        0x6DF1, # G+2825  U+6DF1  uni6DF1,  CJK UNIFIED IDEOGRAPH-6DF1
        0x6DEE, # G+2826  U+6DEE  uni6DEE,  CJK UNIFIED IDEOGRAPH-6DEE
        0x6DE8, # G+2827  U+6DE8  uni6DE8,  CJK UNIFIED IDEOGRAPH-6DE8
        0x6DC6, # G+2828  U+6DC6  uni6DC6,  CJK UNIFIED IDEOGRAPH-6DC6
        0x6DC4, # G+2829  U+6DC4  uni6DC4,  CJK UNIFIED IDEOGRAPH-6DC4
        0x6DAA, # G+2830  U+6DAA  uni6DAA,  CJK UNIFIED IDEOGRAPH-6DAA
        0x6DEC, # G+2831  U+6DEC  uni6DEC,  CJK UNIFIED IDEOGRAPH-6DEC
        0x6DBF, # G+2832  U+6DBF  uni6DBF,  CJK UNIFIED IDEOGRAPH-6DBF
        0x6DE6, # G+2833  U+6DE6  uni6DE6,  CJK UNIFIED IDEOGRAPH-6DE6
        0x70F9, # G+2834  U+70F9  uni70F9,  CJK UNIFIED IDEOGRAPH-70F9
        0x7109, # G+2835  U+7109  uni7109,  CJK UNIFIED IDEOGRAPH-7109
        0x710A, # G+2836  U+710A  uni710A,  CJK UNIFIED IDEOGRAPH-710A
        0x70FD, # G+2837  U+70FD  uni70FD,  CJK UNIFIED IDEOGRAPH-70FD
        0x70EF, # G+2838  U+70EF  uni70EF,  CJK UNIFIED IDEOGRAPH-70EF
        0x723D, # G+2839  U+723D  uni723D,  CJK UNIFIED IDEOGRAPH-723D
        0x727D, # G+2840  U+727D  uni727D,  CJK UNIFIED IDEOGRAPH-727D
        0x7281, # G+2841  U+7281  uni7281,  CJK UNIFIED IDEOGRAPH-7281
        0x731C, # G+2842  U+731C  uni731C,  CJK UNIFIED IDEOGRAPH-731C
        0x731B, # G+2843  U+731B  uni731B,  CJK UNIFIED IDEOGRAPH-731B
        0x7316, # G+2844  U+7316  uni7316,  CJK UNIFIED IDEOGRAPH-7316
        0x7313, # G+2845  U+7313  uni7313,  CJK UNIFIED IDEOGRAPH-7313
        0x7319, # G+2846  U+7319  uni7319,  CJK UNIFIED IDEOGRAPH-7319
        0x7387, # G+2847  U+7387  uni7387,  CJK UNIFIED IDEOGRAPH-7387
        0x7405, # G+2848  U+7405  uni7405,  CJK UNIFIED IDEOGRAPH-7405
        0x740A, # G+2849  U+740A  uni740A,  CJK UNIFIED IDEOGRAPH-740A
        0x7403, # G+2850  U+7403  uni7403,  CJK UNIFIED IDEOGRAPH-7403
        0x7406, # G+2851  U+7406  uni7406,  CJK UNIFIED IDEOGRAPH-7406
        0x73FE, # G+2852  U+73FE  uni73FE,  CJK UNIFIED IDEOGRAPH-73FE
        0x740D, # G+2853  U+740D  uni740D,  CJK UNIFIED IDEOGRAPH-740D
        0x74E0, # G+2854  U+74E0  uni74E0,  CJK UNIFIED IDEOGRAPH-74E0
        0x74F6, # G+2855  U+74F6  uni74F6,  CJK UNIFIED IDEOGRAPH-74F6
        0x74F7, # G+2856  U+74F7  uni74F7,  CJK UNIFIED IDEOGRAPH-74F7
        0x751C, # G+2857  U+751C  uni751C,  CJK UNIFIED IDEOGRAPH-751C
        0x7522, # G+2858  U+7522  uni7522,  CJK UNIFIED IDEOGRAPH-7522
        0x7565, # G+2859  U+7565  uni7565,  CJK UNIFIED IDEOGRAPH-7565
        0x7566, # G+2860  U+7566  uni7566,  CJK UNIFIED IDEOGRAPH-7566
        0x7562, # G+2861  U+7562  uni7562,  CJK UNIFIED IDEOGRAPH-7562
        0x7570, # G+2862  U+7570  uni7570,  CJK UNIFIED IDEOGRAPH-7570
        0x758F, # G+2863  U+758F  uni758F,  CJK UNIFIED IDEOGRAPH-758F
        0x75D4, # G+2864  U+75D4  uni75D4,  CJK UNIFIED IDEOGRAPH-75D4
        0x75D5, # G+2865  U+75D5  uni75D5,  CJK UNIFIED IDEOGRAPH-75D5
        0x75B5, # G+2866  U+75B5  uni75B5,  CJK UNIFIED IDEOGRAPH-75B5
        0x75CA, # G+2867  U+75CA  uni75CA,  CJK UNIFIED IDEOGRAPH-75CA
        0x75CD, # G+2868  U+75CD  uni75CD,  CJK UNIFIED IDEOGRAPH-75CD
        0x768E, # G+2869  U+768E  uni768E,  CJK UNIFIED IDEOGRAPH-768E
        0x76D4, # G+2870  U+76D4  uni76D4,  CJK UNIFIED IDEOGRAPH-76D4
        0x76D2, # G+2871  U+76D2  uni76D2,  CJK UNIFIED IDEOGRAPH-76D2
        0x76DB, # G+2872  U+76DB  uni76DB,  CJK UNIFIED IDEOGRAPH-76DB
        0x7737, # G+2873  U+7737  uni7737,  CJK UNIFIED IDEOGRAPH-7737
        0x773E, # G+2874  U+773E  uni773E,  CJK UNIFIED IDEOGRAPH-773E
        0x773C, # G+2875  U+773C  uni773C,  CJK UNIFIED IDEOGRAPH-773C
        0x7736, # G+2876  U+7736  uni7736,  CJK UNIFIED IDEOGRAPH-7736
        0x7738, # G+2877  U+7738  uni7738,  CJK UNIFIED IDEOGRAPH-7738
        0x773A, # G+2878  U+773A  uni773A,  CJK UNIFIED IDEOGRAPH-773A
        0x786B, # G+2879  U+786B  uni786B,  CJK UNIFIED IDEOGRAPH-786B
        0x7843, # G+2880  U+7843  uni7843,  CJK UNIFIED IDEOGRAPH-7843
        0x784E, # G+2881  U+784E  uni784E,  CJK UNIFIED IDEOGRAPH-784E
        0x7965, # G+2882  U+7965  uni7965,  CJK UNIFIED IDEOGRAPH-7965
        0x7968, # G+2883  U+7968  uni7968,  CJK UNIFIED IDEOGRAPH-7968
        0x796D, # G+2884  U+796D  uni796D,  CJK UNIFIED IDEOGRAPH-796D
        0x79FB, # G+2885  U+79FB  uni79FB,  CJK UNIFIED IDEOGRAPH-79FB
        0x7A92, # G+2886  U+7A92  uni7A92,  CJK UNIFIED IDEOGRAPH-7A92
        0x7A95, # G+2887  U+7A95  uni7A95,  CJK UNIFIED IDEOGRAPH-7A95
        0x7B20, # G+2888  U+7B20  uni7B20,  CJK UNIFIED IDEOGRAPH-7B20
        0x7B28, # G+2889  U+7B28  uni7B28,  CJK UNIFIED IDEOGRAPH-7B28
        0x7B1B, # G+2890  U+7B1B  uni7B1B,  CJK UNIFIED IDEOGRAPH-7B1B
        0x7B2C, # G+2891  U+7B2C  uni7B2C,  CJK UNIFIED IDEOGRAPH-7B2C
        0x7B26, # G+2892  U+7B26  uni7B26,  CJK UNIFIED IDEOGRAPH-7B26
        0x7B19, # G+2893  U+7B19  uni7B19,  CJK UNIFIED IDEOGRAPH-7B19
        0x7B1E, # G+2894  U+7B1E  uni7B1E,  CJK UNIFIED IDEOGRAPH-7B1E
        0x7B2E, # G+2895  U+7B2E  uni7B2E,  CJK UNIFIED IDEOGRAPH-7B2E
        0x7C92, # G+2896  U+7C92  uni7C92,  CJK UNIFIED IDEOGRAPH-7C92
        0x7C97, # G+2897  U+7C97  uni7C97,  CJK UNIFIED IDEOGRAPH-7C97
        0x7C95, # G+2898  U+7C95  uni7C95,  CJK UNIFIED IDEOGRAPH-7C95
        0x7D46, # G+2899  U+7D46  uni7D46,  CJK UNIFIED IDEOGRAPH-7D46
        0x7D43, # G+2900  U+7D43  uni7D43,  CJK UNIFIED IDEOGRAPH-7D43
        0x7D71, # G+2901  U+7D71  uni7D71,  CJK UNIFIED IDEOGRAPH-7D71
        0x7D2E, # G+2902  U+7D2E  uni7D2E,  CJK UNIFIED IDEOGRAPH-7D2E
        0x7D39, # G+2903  U+7D39  uni7D39,  CJK UNIFIED IDEOGRAPH-7D39
        0x7D3C, # G+2904  U+7D3C  uni7D3C,  CJK UNIFIED IDEOGRAPH-7D3C
        0x7D40, # G+2905  U+7D40  uni7D40,  CJK UNIFIED IDEOGRAPH-7D40
        0x7D30, # G+2906  U+7D30  uni7D30,  CJK UNIFIED IDEOGRAPH-7D30
        0x7D33, # G+2907  U+7D33  uni7D33,  CJK UNIFIED IDEOGRAPH-7D33
        0x7D44, # G+2908  U+7D44  uni7D44,  CJK UNIFIED IDEOGRAPH-7D44
        0x7D2F, # G+2909  U+7D2F  uni7D2F,  CJK UNIFIED IDEOGRAPH-7D2F
        0x7D42, # G+2910  U+7D42  uni7D42,  CJK UNIFIED IDEOGRAPH-7D42
        0x7D32, # G+2911  U+7D32  uni7D32,  CJK UNIFIED IDEOGRAPH-7D32
        0x7D31, # G+2912  U+7D31  uni7D31,  CJK UNIFIED IDEOGRAPH-7D31
        0x7F3D, # G+2913  U+7F3D  uni7F3D,  CJK UNIFIED IDEOGRAPH-7F3D
        0x7F9E, # G+2914  U+7F9E  uni7F9E,  CJK UNIFIED IDEOGRAPH-7F9E
        0x7F9A, # G+2915  U+7F9A  uni7F9A,  CJK UNIFIED IDEOGRAPH-7F9A
        0x7FCC, # G+2916  U+7FCC  uni7FCC,  CJK UNIFIED IDEOGRAPH-7FCC
        0x7FCE, # G+2917  U+7FCE  uni7FCE,  CJK UNIFIED IDEOGRAPH-7FCE
        0x7FD2, # G+2918  U+7FD2  uni7FD2,  CJK UNIFIED IDEOGRAPH-7FD2
        0x801C, # G+2919  U+801C  uni801C,  CJK UNIFIED IDEOGRAPH-801C
        0x804A, # G+2920  U+804A  uni804A,  CJK UNIFIED IDEOGRAPH-804A
        0x8046, # G+2921  U+8046  uni8046,  CJK UNIFIED IDEOGRAPH-8046
        0x812F, # G+2922  U+812F  uni812F,  CJK UNIFIED IDEOGRAPH-812F
        0x8116, # G+2923  U+8116  uni8116,  CJK UNIFIED IDEOGRAPH-8116
        0x8123, # G+2924  U+8123  uni8123,  CJK UNIFIED IDEOGRAPH-8123
        0x812B, # G+2925  U+812B  uni812B,  CJK UNIFIED IDEOGRAPH-812B
        0x8129, # G+2926  U+8129  uni8129,  CJK UNIFIED IDEOGRAPH-8129
        0x8130, # G+2927  U+8130  uni8130,  CJK UNIFIED IDEOGRAPH-8130
        0x8124, # G+2928  U+8124  uni8124,  CJK UNIFIED IDEOGRAPH-8124
        0x8202, # G+2929  U+8202  uni8202,  CJK UNIFIED IDEOGRAPH-8202
        0x8235, # G+2930  U+8235  uni8235,  CJK UNIFIED IDEOGRAPH-8235
        0x8237, # G+2931  U+8237  uni8237,  CJK UNIFIED IDEOGRAPH-8237
        0x8236, # G+2932  U+8236  uni8236,  CJK UNIFIED IDEOGRAPH-8236
        0x8239, # G+2933  U+8239  uni8239,  CJK UNIFIED IDEOGRAPH-8239
        0x838E, # G+2934  U+838E  uni838E,  CJK UNIFIED IDEOGRAPH-838E
        0x839E, # G+2935  U+839E  uni839E,  CJK UNIFIED IDEOGRAPH-839E
        0x8398, # G+2936  U+8398  uni8398,  CJK UNIFIED IDEOGRAPH-8398
        0x8378, # G+2937  U+8378  uni8378,  CJK UNIFIED IDEOGRAPH-8378
        0x83A2, # G+2938  U+83A2  uni83A2,  CJK UNIFIED IDEOGRAPH-83A2
        0x8396, # G+2939  U+8396  uni8396,  CJK UNIFIED IDEOGRAPH-8396
        0x83BD, # G+2940  U+83BD  uni83BD,  CJK UNIFIED IDEOGRAPH-83BD
        0x83AB, # G+2941  U+83AB  uni83AB,  CJK UNIFIED IDEOGRAPH-83AB
        0x8392, # G+2942  U+8392  uni8392,  CJK UNIFIED IDEOGRAPH-8392
        0x838A, # G+2943  U+838A  uni838A,  CJK UNIFIED IDEOGRAPH-838A
        0x8393, # G+2944  U+8393  uni8393,  CJK UNIFIED IDEOGRAPH-8393
        0x8389, # G+2945  U+8389  uni8389,  CJK UNIFIED IDEOGRAPH-8389
        0x83A0, # G+2946  U+83A0  uni83A0,  CJK UNIFIED IDEOGRAPH-83A0
        0x8377, # G+2947  U+8377  uni8377,  CJK UNIFIED IDEOGRAPH-8377
        0x837B, # G+2948  U+837B  uni837B,  CJK UNIFIED IDEOGRAPH-837B
        0x837C, # G+2949  U+837C  uni837C,  CJK UNIFIED IDEOGRAPH-837C
        0x8386, # G+2950  U+8386  uni8386,  CJK UNIFIED IDEOGRAPH-8386
        0x83A7, # G+2951  U+83A7  uni83A7,  CJK UNIFIED IDEOGRAPH-83A7
        0x8655, # G+2952  U+8655  uni8655,  CJK UNIFIED IDEOGRAPH-8655
        0x5F6A, # G+2953  U+5F6A  uni5F6A,  CJK UNIFIED IDEOGRAPH-5F6A
        0x86C7, # G+2954  U+86C7  uni86C7,  CJK UNIFIED IDEOGRAPH-86C7
        0x86C0, # G+2955  U+86C0  uni86C0,  CJK UNIFIED IDEOGRAPH-86C0
        0x86B6, # G+2956  U+86B6  uni86B6,  CJK UNIFIED IDEOGRAPH-86B6
        0x86C4, # G+2957  U+86C4  uni86C4,  CJK UNIFIED IDEOGRAPH-86C4
        0x86B5, # G+2958  U+86B5  uni86B5,  CJK UNIFIED IDEOGRAPH-86B5
        0x86C6, # G+2959  U+86C6  uni86C6,  CJK UNIFIED IDEOGRAPH-86C6
        0x86CB, # G+2960  U+86CB  uni86CB,  CJK UNIFIED IDEOGRAPH-86CB
        0x86B1, # G+2961  U+86B1  uni86B1,  CJK UNIFIED IDEOGRAPH-86B1
        0x86AF, # G+2962  U+86AF  uni86AF,  CJK UNIFIED IDEOGRAPH-86AF
        0x86C9, # G+2963  U+86C9  uni86C9,  CJK UNIFIED IDEOGRAPH-86C9
        0x8853, # G+2964  U+8853  uni8853,  CJK UNIFIED IDEOGRAPH-8853
        0x889E, # G+2965  U+889E  uni889E,  CJK UNIFIED IDEOGRAPH-889E
        0x8888, # G+2966  U+8888  uni8888,  CJK UNIFIED IDEOGRAPH-8888
        0x88AB, # G+2967  U+88AB  uni88AB,  CJK UNIFIED IDEOGRAPH-88AB
        0x8892, # G+2968  U+8892  uni8892,  CJK UNIFIED IDEOGRAPH-8892
        0x8896, # G+2969  U+8896  uni8896,  CJK UNIFIED IDEOGRAPH-8896
        0x888D, # G+2970  U+888D  uni888D,  CJK UNIFIED IDEOGRAPH-888D
        0x888B, # G+2971  U+888B  uni888B,  CJK UNIFIED IDEOGRAPH-888B
        0x8993, # G+2972  U+8993  uni8993,  CJK UNIFIED IDEOGRAPH-8993
        0x898F, # G+2973  U+898F  uni898F,  CJK UNIFIED IDEOGRAPH-898F
        0x8A2A, # G+2974  U+8A2A  uni8A2A,  CJK UNIFIED IDEOGRAPH-8A2A
        0x8A1D, # G+2975  U+8A1D  uni8A1D,  CJK UNIFIED IDEOGRAPH-8A1D
        0x8A23, # G+2976  U+8A23  uni8A23,  CJK UNIFIED IDEOGRAPH-8A23
        0x8A25, # G+2977  U+8A25  uni8A25,  CJK UNIFIED IDEOGRAPH-8A25
        0x8A31, # G+2978  U+8A31  uni8A31,  CJK UNIFIED IDEOGRAPH-8A31
        0x8A2D, # G+2979  U+8A2D  uni8A2D,  CJK UNIFIED IDEOGRAPH-8A2D
        0x8A1F, # G+2980  U+8A1F  uni8A1F,  CJK UNIFIED IDEOGRAPH-8A1F
        0x8A1B, # G+2981  U+8A1B  uni8A1B,  CJK UNIFIED IDEOGRAPH-8A1B
        0x8A22, # G+2982  U+8A22  uni8A22,  CJK UNIFIED IDEOGRAPH-8A22
        0x8C49, # G+2983  U+8C49  uni8C49,  CJK UNIFIED IDEOGRAPH-8C49
        0x8C5A, # G+2984  U+8C5A  uni8C5A,  CJK UNIFIED IDEOGRAPH-8C5A
        0x8CA9, # G+2985  U+8CA9  uni8CA9,  CJK UNIFIED IDEOGRAPH-8CA9
        0x8CAC, # G+2986  U+8CAC  uni8CAC,  CJK UNIFIED IDEOGRAPH-8CAC
        0x8CAB, # G+2987  U+8CAB  uni8CAB,  CJK UNIFIED IDEOGRAPH-8CAB
        0x8CA8, # G+2988  U+8CA8  uni8CA8,  CJK UNIFIED IDEOGRAPH-8CA8
        0x8CAA, # G+2989  U+8CAA  uni8CAA,  CJK UNIFIED IDEOGRAPH-8CAA
        0x8CA7, # G+2990  U+8CA7  uni8CA7,  CJK UNIFIED IDEOGRAPH-8CA7
        0x8D67, # G+2991  U+8D67  uni8D67,  CJK UNIFIED IDEOGRAPH-8D67
        0x8D66, # G+2992  U+8D66  uni8D66,  CJK UNIFIED IDEOGRAPH-8D66
        0x8DBE, # G+2993  U+8DBE  uni8DBE,  CJK UNIFIED IDEOGRAPH-8DBE
        0x8DBA, # G+2994  U+8DBA  uni8DBA,  CJK UNIFIED IDEOGRAPH-8DBA
        0x8EDB, # G+2995  U+8EDB  uni8EDB,  CJK UNIFIED IDEOGRAPH-8EDB
        0x8EDF, # G+2996  U+8EDF  uni8EDF,  CJK UNIFIED IDEOGRAPH-8EDF
        0x9019, # G+2997  U+9019  uni9019,  CJK UNIFIED IDEOGRAPH-9019
        0x900D, # G+2998  U+900D  uni900D,  CJK UNIFIED IDEOGRAPH-900D
        0x901A, # G+2999  U+901A  uni901A,  CJK UNIFIED IDEOGRAPH-901A
        0x9017, # G+3000  U+9017  uni9017,  CJK UNIFIED IDEOGRAPH-9017
        0x9023, # G+3001  U+9023  uni9023,  CJK UNIFIED IDEOGRAPH-9023
        0x901F, # G+3002  U+901F  uni901F,  CJK UNIFIED IDEOGRAPH-901F
        0x901D, # G+3003  U+901D  uni901D,  CJK UNIFIED IDEOGRAPH-901D
        0x9010, # G+3004  U+9010  uni9010,  CJK UNIFIED IDEOGRAPH-9010
        0x9015, # G+3005  U+9015  uni9015,  CJK UNIFIED IDEOGRAPH-9015
        0x901E, # G+3006  U+901E  uni901E,  CJK UNIFIED IDEOGRAPH-901E
        0x9020, # G+3007  U+9020  uni9020,  CJK UNIFIED IDEOGRAPH-9020
        0x900F, # G+3008  U+900F  uni900F,  CJK UNIFIED IDEOGRAPH-900F
        0x9022, # G+3009  U+9022  uni9022,  CJK UNIFIED IDEOGRAPH-9022
        0x9016, # G+3010  U+9016  uni9016,  CJK UNIFIED IDEOGRAPH-9016
        0x901B, # G+3011  U+901B  uni901B,  CJK UNIFIED IDEOGRAPH-901B
        0x9014, # G+3012  U+9014  uni9014,  CJK UNIFIED IDEOGRAPH-9014
        0x90E8, # G+3013  U+90E8  uni90E8,  CJK UNIFIED IDEOGRAPH-90E8
        0x90ED, # G+3014  U+90ED  uni90ED,  CJK UNIFIED IDEOGRAPH-90ED
        0x90FD, # G+3015  U+90FD  uni90FD,  CJK UNIFIED IDEOGRAPH-90FD
        0x9157, # G+3016  U+9157  uni9157,  CJK UNIFIED IDEOGRAPH-9157
        0x91CE, # G+3017  U+91CE  uni91CE,  CJK UNIFIED IDEOGRAPH-91CE
        0x91F5, # G+3018  U+91F5  uni91F5,  CJK UNIFIED IDEOGRAPH-91F5
        0x91E6, # G+3019  U+91E6  uni91E6,  CJK UNIFIED IDEOGRAPH-91E6
        0x91E3, # G+3020  U+91E3  uni91E3,  CJK UNIFIED IDEOGRAPH-91E3
        0x91E7, # G+3021  U+91E7  uni91E7,  CJK UNIFIED IDEOGRAPH-91E7
        0x91ED, # G+3022  U+91ED  uni91ED,  CJK UNIFIED IDEOGRAPH-91ED
        0x91E9, # G+3023  U+91E9  uni91E9,  CJK UNIFIED IDEOGRAPH-91E9
        0x9589, # G+3024  U+9589  uni9589,  CJK UNIFIED IDEOGRAPH-9589
        0x966A, # G+3025  U+966A  uni966A,  CJK UNIFIED IDEOGRAPH-966A
        0x9675, # G+3026  U+9675  uni9675,  CJK UNIFIED IDEOGRAPH-9675
        0x9673, # G+3027  U+9673  uni9673,  CJK UNIFIED IDEOGRAPH-9673
        0x9678, # G+3028  U+9678  uni9678,  CJK UNIFIED IDEOGRAPH-9678
        0x9670, # G+3029  U+9670  uni9670,  CJK UNIFIED IDEOGRAPH-9670
        0x9674, # G+3030  U+9674  uni9674,  CJK UNIFIED IDEOGRAPH-9674
        0x9676, # G+3031  U+9676  uni9676,  CJK UNIFIED IDEOGRAPH-9676
        0x9677, # G+3032  U+9677  uni9677,  CJK UNIFIED IDEOGRAPH-9677
        0x966C, # G+3033  U+966C  uni966C,  CJK UNIFIED IDEOGRAPH-966C
        0x96C0, # G+3034  U+96C0  uni96C0,  CJK UNIFIED IDEOGRAPH-96C0
        0x96EA, # G+3035  U+96EA  uni96EA,  CJK UNIFIED IDEOGRAPH-96EA
        0x96E9, # G+3036  U+96E9  uni96E9,  CJK UNIFIED IDEOGRAPH-96E9
        0x7AE0, # G+3037  U+7AE0  uni7AE0,  CJK UNIFIED IDEOGRAPH-7AE0
        0x7ADF, # G+3038  U+7ADF  uni7ADF,  CJK UNIFIED IDEOGRAPH-7ADF
        0x9802, # G+3039  U+9802  uni9802,  CJK UNIFIED IDEOGRAPH-9802
        0x9803, # G+3040  U+9803  uni9803,  CJK UNIFIED IDEOGRAPH-9803
        0x9B5A, # G+3041  U+9B5A  uni9B5A,  CJK UNIFIED IDEOGRAPH-9B5A
        0x9CE5, # G+3042  U+9CE5  uni9CE5,  CJK UNIFIED IDEOGRAPH-9CE5
        0x9E75, # G+3043  U+9E75  uni9E75,  CJK UNIFIED IDEOGRAPH-9E75
        0x9E7F, # G+3044  U+9E7F  uni9E7F,  CJK UNIFIED IDEOGRAPH-9E7F
        0x9EA5, # G+3045  U+9EA5  uni9EA5,  CJK UNIFIED IDEOGRAPH-9EA5
        0x9EBB, # G+3046  U+9EBB  uni9EBB,  CJK UNIFIED IDEOGRAPH-9EBB
        0x50A2, # G+3047  U+50A2  uni50A2,  CJK UNIFIED IDEOGRAPH-50A2
        0x508D, # G+3048  U+508D  uni508D,  CJK UNIFIED IDEOGRAPH-508D
        0x5085, # G+3049  U+5085  uni5085,  CJK UNIFIED IDEOGRAPH-5085
        0x5099, # G+3050  U+5099  uni5099,  CJK UNIFIED IDEOGRAPH-5099
        0x5091, # G+3051  U+5091  uni5091,  CJK UNIFIED IDEOGRAPH-5091
        0x5080, # G+3052  U+5080  uni5080,  CJK UNIFIED IDEOGRAPH-5080
        0x5096, # G+3053  U+5096  uni5096,  CJK UNIFIED IDEOGRAPH-5096
        0x5098, # G+3054  U+5098  uni5098,  CJK UNIFIED IDEOGRAPH-5098
        0x509A, # G+3055  U+509A  uni509A,  CJK UNIFIED IDEOGRAPH-509A
        0x6700, # G+3056  U+6700  uni6700,  CJK UNIFIED IDEOGRAPH-6700
        0x51F1, # G+3057  U+51F1  uni51F1,  CJK UNIFIED IDEOGRAPH-51F1
        0x5272, # G+3058  U+5272  uni5272,  CJK UNIFIED IDEOGRAPH-5272
        0x5274, # G+3059  U+5274  uni5274,  CJK UNIFIED IDEOGRAPH-5274
        0x5275, # G+3060  U+5275  uni5275,  CJK UNIFIED IDEOGRAPH-5275
        0x5269, # G+3061  U+5269  uni5269,  CJK UNIFIED IDEOGRAPH-5269
        0x52DE, # G+3062  U+52DE  uni52DE,  CJK UNIFIED IDEOGRAPH-52DE
        0x52DD, # G+3063  U+52DD  uni52DD,  CJK UNIFIED IDEOGRAPH-52DD
        0x52DB, # G+3064  U+52DB  uni52DB,  CJK UNIFIED IDEOGRAPH-52DB
        0x535A, # G+3065  U+535A  uni535A,  CJK UNIFIED IDEOGRAPH-535A
        0x53A5, # G+3066  U+53A5  uni53A5,  CJK UNIFIED IDEOGRAPH-53A5
        0x557B, # G+3067  U+557B  uni557B,  CJK UNIFIED IDEOGRAPH-557B
        0x5580, # G+3068  U+5580  uni5580,  CJK UNIFIED IDEOGRAPH-5580
        0x55A7, # G+3069  U+55A7  uni55A7,  CJK UNIFIED IDEOGRAPH-55A7
        0x557C, # G+3070  U+557C  uni557C,  CJK UNIFIED IDEOGRAPH-557C
        0x558A, # G+3071  U+558A  uni558A,  CJK UNIFIED IDEOGRAPH-558A
        0x559D, # G+3072  U+559D  uni559D,  CJK UNIFIED IDEOGRAPH-559D
        0x5598, # G+3073  U+5598  uni5598,  CJK UNIFIED IDEOGRAPH-5598
        0x5582, # G+3074  U+5582  uni5582,  CJK UNIFIED IDEOGRAPH-5582
        0x559C, # G+3075  U+559C  uni559C,  CJK UNIFIED IDEOGRAPH-559C
        0x55AA, # G+3076  U+55AA  uni55AA,  CJK UNIFIED IDEOGRAPH-55AA
        0x5594, # G+3077  U+5594  uni5594,  CJK UNIFIED IDEOGRAPH-5594
        0x5587, # G+3078  U+5587  uni5587,  CJK UNIFIED IDEOGRAPH-5587
        0x558B, # G+3079  U+558B  uni558B,  CJK UNIFIED IDEOGRAPH-558B
        0x5583, # G+3080  U+5583  uni5583,  CJK UNIFIED IDEOGRAPH-5583
        0x55B3, # G+3081  U+55B3  uni55B3,  CJK UNIFIED IDEOGRAPH-55B3
        0x55AE, # G+3082  U+55AE  uni55AE,  CJK UNIFIED IDEOGRAPH-55AE
        0x559F, # G+3083  U+559F  uni559F,  CJK UNIFIED IDEOGRAPH-559F
        0x553E, # G+3084  U+553E  uni553E,  CJK UNIFIED IDEOGRAPH-553E
        0x55B2, # G+3085  U+55B2  uni55B2,  CJK UNIFIED IDEOGRAPH-55B2
        0x559A, # G+3086  U+559A  uni559A,  CJK UNIFIED IDEOGRAPH-559A
        0x55BB, # G+3087  U+55BB  uni55BB,  CJK UNIFIED IDEOGRAPH-55BB
        0x55AC, # G+3088  U+55AC  uni55AC,  CJK UNIFIED IDEOGRAPH-55AC
        0x55B1, # G+3089  U+55B1  uni55B1,  CJK UNIFIED IDEOGRAPH-55B1
        0x557E, # G+3090  U+557E  uni557E,  CJK UNIFIED IDEOGRAPH-557E
        0x5589, # G+3091  U+5589  uni5589,  CJK UNIFIED IDEOGRAPH-5589
        0x55AB, # G+3092  U+55AB  uni55AB,  CJK UNIFIED IDEOGRAPH-55AB
        0x5599, # G+3093  U+5599  uni5599,  CJK UNIFIED IDEOGRAPH-5599
        0x570D, # G+3094  U+570D  uni570D,  CJK UNIFIED IDEOGRAPH-570D
        0x582F, # G+3095  U+582F  uni582F,  CJK UNIFIED IDEOGRAPH-582F
        0x582A, # G+3096  U+582A  uni582A,  CJK UNIFIED IDEOGRAPH-582A
        0x5834, # G+3097  U+5834  uni5834,  CJK UNIFIED IDEOGRAPH-5834
        0x5824, # G+3098  U+5824  uni5824,  CJK UNIFIED IDEOGRAPH-5824
        0x5830, # G+3099  U+5830  uni5830,  CJK UNIFIED IDEOGRAPH-5830
        0x5831, # G+3100  U+5831  uni5831,  CJK UNIFIED IDEOGRAPH-5831
        0x5821, # G+3101  U+5821  uni5821,  CJK UNIFIED IDEOGRAPH-5821
        0x581D, # G+3102  U+581D  uni581D,  CJK UNIFIED IDEOGRAPH-581D
        0x5820, # G+3103  U+5820  uni5820,  CJK UNIFIED IDEOGRAPH-5820
        0x58F9, # G+3104  U+58F9  uni58F9,  CJK UNIFIED IDEOGRAPH-58F9
        0x58FA, # G+3105  U+58FA  uni58FA,  CJK UNIFIED IDEOGRAPH-58FA
        0x5960, # G+3106  U+5960  uni5960,  CJK UNIFIED IDEOGRAPH-5960
        0x5A77, # G+3107  U+5A77  uni5A77,  CJK UNIFIED IDEOGRAPH-5A77
        0x5A9A, # G+3108  U+5A9A  uni5A9A,  CJK UNIFIED IDEOGRAPH-5A9A
        0x5A7F, # G+3109  U+5A7F  uni5A7F,  CJK UNIFIED IDEOGRAPH-5A7F
        0x5A92, # G+3110  U+5A92  uni5A92,  CJK UNIFIED IDEOGRAPH-5A92
        0x5A9B, # G+3111  U+5A9B  uni5A9B,  CJK UNIFIED IDEOGRAPH-5A9B
        0x5AA7, # G+3112  U+5AA7  uni5AA7,  CJK UNIFIED IDEOGRAPH-5AA7
        0x5B73, # G+3113  U+5B73  uni5B73,  CJK UNIFIED IDEOGRAPH-5B73
        0x5B71, # G+3114  U+5B71  uni5B71,  CJK UNIFIED IDEOGRAPH-5B71
        0x5BD2, # G+3115  U+5BD2  uni5BD2,  CJK UNIFIED IDEOGRAPH-5BD2
        0x5BCC, # G+3116  U+5BCC  uni5BCC,  CJK UNIFIED IDEOGRAPH-5BCC
        0x5BD3, # G+3117  U+5BD3  uni5BD3,  CJK UNIFIED IDEOGRAPH-5BD3
        0x5BD0, # G+3118  U+5BD0  uni5BD0,  CJK UNIFIED IDEOGRAPH-5BD0
        0x5C0A, # G+3119  U+5C0A  uni5C0A,  CJK UNIFIED IDEOGRAPH-5C0A
        0x5C0B, # G+3120  U+5C0B  uni5C0B,  CJK UNIFIED IDEOGRAPH-5C0B
        0x5C31, # G+3121  U+5C31  uni5C31,  CJK UNIFIED IDEOGRAPH-5C31
        0x5D4C, # G+3122  U+5D4C  uni5D4C,  CJK UNIFIED IDEOGRAPH-5D4C
        0x5D50, # G+3123  U+5D50  uni5D50,  CJK UNIFIED IDEOGRAPH-5D50
        0x5D34, # G+3124  U+5D34  uni5D34,  CJK UNIFIED IDEOGRAPH-5D34
        0x5D47, # G+3125  U+5D47  uni5D47,  CJK UNIFIED IDEOGRAPH-5D47
        0x5DFD, # G+3126  U+5DFD  uni5DFD,  CJK UNIFIED IDEOGRAPH-5DFD
        0x5E45, # G+3127  U+5E45  uni5E45,  CJK UNIFIED IDEOGRAPH-5E45
        0x5E3D, # G+3128  U+5E3D  uni5E3D,  CJK UNIFIED IDEOGRAPH-5E3D
        0x5E40, # G+3129  U+5E40  uni5E40,  CJK UNIFIED IDEOGRAPH-5E40
        0x5E43, # G+3130  U+5E43  uni5E43,  CJK UNIFIED IDEOGRAPH-5E43
        0x5E7E, # G+3131  U+5E7E  uni5E7E,  CJK UNIFIED IDEOGRAPH-5E7E
        0x5ECA, # G+3132  U+5ECA  uni5ECA,  CJK UNIFIED IDEOGRAPH-5ECA
        0x5EC1, # G+3133  U+5EC1  uni5EC1,  CJK UNIFIED IDEOGRAPH-5EC1
        0x5EC2, # G+3134  U+5EC2  uni5EC2,  CJK UNIFIED IDEOGRAPH-5EC2
        0x5EC4, # G+3135  U+5EC4  uni5EC4,  CJK UNIFIED IDEOGRAPH-5EC4
        0x5F3C, # G+3136  U+5F3C  uni5F3C,  CJK UNIFIED IDEOGRAPH-5F3C
        0x5F6D, # G+3137  U+5F6D  uni5F6D,  CJK UNIFIED IDEOGRAPH-5F6D
        0x5FA9, # G+3138  U+5FA9  uni5FA9,  CJK UNIFIED IDEOGRAPH-5FA9
        0x5FAA, # G+3139  U+5FAA  uni5FAA,  CJK UNIFIED IDEOGRAPH-5FAA
        0x5FA8, # G+3140  U+5FA8  uni5FA8,  CJK UNIFIED IDEOGRAPH-5FA8
        0x60D1, # G+3141  U+60D1  uni60D1,  CJK UNIFIED IDEOGRAPH-60D1
        0x60E1, # G+3142  U+60E1  uni60E1,  CJK UNIFIED IDEOGRAPH-60E1
        0x60B2, # G+3143  U+60B2  uni60B2,  CJK UNIFIED IDEOGRAPH-60B2
        0x60B6, # G+3144  U+60B6  uni60B6,  CJK UNIFIED IDEOGRAPH-60B6
        0x60E0, # G+3145  U+60E0  uni60E0,  CJK UNIFIED IDEOGRAPH-60E0
        0x611C, # G+3146  U+611C  uni611C,  CJK UNIFIED IDEOGRAPH-611C
        0x6123, # G+3147  U+6123  uni6123,  CJK UNIFIED IDEOGRAPH-6123
        0x60FA, # G+3148  U+60FA  uni60FA,  CJK UNIFIED IDEOGRAPH-60FA
        0x6115, # G+3149  U+6115  uni6115,  CJK UNIFIED IDEOGRAPH-6115
        0x60F0, # G+3150  U+60F0  uni60F0,  CJK UNIFIED IDEOGRAPH-60F0
        0x60FB, # G+3151  U+60FB  uni60FB,  CJK UNIFIED IDEOGRAPH-60FB
        0x60F4, # G+3152  U+60F4  uni60F4,  CJK UNIFIED IDEOGRAPH-60F4
        0x6168, # G+3153  U+6168  uni6168,  CJK UNIFIED IDEOGRAPH-6168
        0x60F1, # G+3154  U+60F1  uni60F1,  CJK UNIFIED IDEOGRAPH-60F1
        0x610E, # G+3155  U+610E  uni610E,  CJK UNIFIED IDEOGRAPH-610E
        0x60F6, # G+3156  U+60F6  uni60F6,  CJK UNIFIED IDEOGRAPH-60F6
        0x6109, # G+3157  U+6109  uni6109,  CJK UNIFIED IDEOGRAPH-6109
        0x6100, # G+3158  U+6100  uni6100,  CJK UNIFIED IDEOGRAPH-6100
        0x6112, # G+3159  U+6112  uni6112,  CJK UNIFIED IDEOGRAPH-6112
        0x621F, # G+3160  U+621F  uni621F,  CJK UNIFIED IDEOGRAPH-621F
        0x6249, # G+3161  U+6249  uni6249,  CJK UNIFIED IDEOGRAPH-6249
        0x63A3, # G+3162  U+63A3  uni63A3,  CJK UNIFIED IDEOGRAPH-63A3
        0x638C, # G+3163  U+638C  uni638C,  CJK UNIFIED IDEOGRAPH-638C
        0x63CF, # G+3164  U+63CF  uni63CF,  CJK UNIFIED IDEOGRAPH-63CF
        0x63C0, # G+3165  U+63C0  uni63C0,  CJK UNIFIED IDEOGRAPH-63C0
        0x63E9, # G+3166  U+63E9  uni63E9,  CJK UNIFIED IDEOGRAPH-63E9
        0x63C9, # G+3167  U+63C9  uni63C9,  CJK UNIFIED IDEOGRAPH-63C9
        0x63C6, # G+3168  U+63C6  uni63C6,  CJK UNIFIED IDEOGRAPH-63C6
        0x63CD, # G+3169  U+63CD  uni63CD,  CJK UNIFIED IDEOGRAPH-63CD
        0x63D2, # G+3170  U+63D2  uni63D2,  CJK UNIFIED IDEOGRAPH-63D2
        0x63E3, # G+3171  U+63E3  uni63E3,  CJK UNIFIED IDEOGRAPH-63E3
        0x63D0, # G+3172  U+63D0  uni63D0,  CJK UNIFIED IDEOGRAPH-63D0
        0x63E1, # G+3173  U+63E1  uni63E1,  CJK UNIFIED IDEOGRAPH-63E1
        0x63D6, # G+3174  U+63D6  uni63D6,  CJK UNIFIED IDEOGRAPH-63D6
        0x63ED, # G+3175  U+63ED  uni63ED,  CJK UNIFIED IDEOGRAPH-63ED
        0x63EE, # G+3176  U+63EE  uni63EE,  CJK UNIFIED IDEOGRAPH-63EE
        0x6376, # G+3177  U+6376  uni6376,  CJK UNIFIED IDEOGRAPH-6376
        0x63F4, # G+3178  U+63F4  uni63F4,  CJK UNIFIED IDEOGRAPH-63F4
        0x63EA, # G+3179  U+63EA  uni63EA,  CJK UNIFIED IDEOGRAPH-63EA
        0x63DB, # G+3180  U+63DB  uni63DB,  CJK UNIFIED IDEOGRAPH-63DB
        0x6452, # G+3181  U+6452  uni6452,  CJK UNIFIED IDEOGRAPH-6452
        0x63DA, # G+3182  U+63DA  uni63DA,  CJK UNIFIED IDEOGRAPH-63DA
        0x63F9, # G+3183  U+63F9  uni63F9,  CJK UNIFIED IDEOGRAPH-63F9
        0x655E, # G+3184  U+655E  uni655E,  CJK UNIFIED IDEOGRAPH-655E
        0x6566, # G+3185  U+6566  uni6566,  CJK UNIFIED IDEOGRAPH-6566
        0x6562, # G+3186  U+6562  uni6562,  CJK UNIFIED IDEOGRAPH-6562
        0x6563, # G+3187  U+6563  uni6563,  CJK UNIFIED IDEOGRAPH-6563
        0x6591, # G+3188  U+6591  uni6591,  CJK UNIFIED IDEOGRAPH-6591
        0x6590, # G+3189  U+6590  uni6590,  CJK UNIFIED IDEOGRAPH-6590
        0x65AF, # G+3190  U+65AF  uni65AF,  CJK UNIFIED IDEOGRAPH-65AF
        0x666E, # G+3191  U+666E  uni666E,  CJK UNIFIED IDEOGRAPH-666E
        0x6670, # G+3192  U+6670  uni6670,  CJK UNIFIED IDEOGRAPH-6670
        0x6674, # G+3193  U+6674  uni6674,  CJK UNIFIED IDEOGRAPH-6674
        0x6676, # G+3194  U+6676  uni6676,  CJK UNIFIED IDEOGRAPH-6676
        0x666F, # G+3195  U+666F  uni666F,  CJK UNIFIED IDEOGRAPH-666F
        0x6691, # G+3196  U+6691  uni6691,  CJK UNIFIED IDEOGRAPH-6691
        0x667A, # G+3197  U+667A  uni667A,  CJK UNIFIED IDEOGRAPH-667A
        0x667E, # G+3198  U+667E  uni667E,  CJK UNIFIED IDEOGRAPH-667E
        0x6677, # G+3199  U+6677  uni6677,  CJK UNIFIED IDEOGRAPH-6677
        0x66FE, # G+3200  U+66FE  uni66FE,  CJK UNIFIED IDEOGRAPH-66FE
        0x66FF, # G+3201  U+66FF  uni66FF,  CJK UNIFIED IDEOGRAPH-66FF
        0x671F, # G+3202  U+671F  uni671F,  CJK UNIFIED IDEOGRAPH-671F
        0x671D, # G+3203  U+671D  uni671D,  CJK UNIFIED IDEOGRAPH-671D
        0x68FA, # G+3204  U+68FA  uni68FA,  CJK UNIFIED IDEOGRAPH-68FA
        0x68D5, # G+3205  U+68D5  uni68D5,  CJK UNIFIED IDEOGRAPH-68D5
        0x68E0, # G+3206  U+68E0  uni68E0,  CJK UNIFIED IDEOGRAPH-68E0
        0x68D8, # G+3207  U+68D8  uni68D8,  CJK UNIFIED IDEOGRAPH-68D8
        0x68D7, # G+3208  U+68D7  uni68D7,  CJK UNIFIED IDEOGRAPH-68D7
        0x6905, # G+3209  U+6905  uni6905,  CJK UNIFIED IDEOGRAPH-6905
        0x68DF, # G+3210  U+68DF  uni68DF,  CJK UNIFIED IDEOGRAPH-68DF
        0x68F5, # G+3211  U+68F5  uni68F5,  CJK UNIFIED IDEOGRAPH-68F5
        0x68EE, # G+3212  U+68EE  uni68EE,  CJK UNIFIED IDEOGRAPH-68EE
        0x68E7, # G+3213  U+68E7  uni68E7,  CJK UNIFIED IDEOGRAPH-68E7
        0x68F9, # G+3214  U+68F9  uni68F9,  CJK UNIFIED IDEOGRAPH-68F9
        0x68D2, # G+3215  U+68D2  uni68D2,  CJK UNIFIED IDEOGRAPH-68D2
        0x68F2, # G+3216  U+68F2  uni68F2,  CJK UNIFIED IDEOGRAPH-68F2
        0x68E3, # G+3217  U+68E3  uni68E3,  CJK UNIFIED IDEOGRAPH-68E3
        0x68CB, # G+3218  U+68CB  uni68CB,  CJK UNIFIED IDEOGRAPH-68CB
        0x68CD, # G+3219  U+68CD  uni68CD,  CJK UNIFIED IDEOGRAPH-68CD
        0x690D, # G+3220  U+690D  uni690D,  CJK UNIFIED IDEOGRAPH-690D
        0x6912, # G+3221  U+6912  uni6912,  CJK UNIFIED IDEOGRAPH-6912
        0x690E, # G+3222  U+690E  uni690E,  CJK UNIFIED IDEOGRAPH-690E
        0x68C9, # G+3223  U+68C9  uni68C9,  CJK UNIFIED IDEOGRAPH-68C9
        0x68DA, # G+3224  U+68DA  uni68DA,  CJK UNIFIED IDEOGRAPH-68DA
        0x696E, # G+3225  U+696E  uni696E,  CJK UNIFIED IDEOGRAPH-696E
        0x68FB, # G+3226  U+68FB  uni68FB,  CJK UNIFIED IDEOGRAPH-68FB
        0x6B3E, # G+3227  U+6B3E  uni6B3E,  CJK UNIFIED IDEOGRAPH-6B3E
        0x6B3A, # G+3228  U+6B3A  uni6B3A,  CJK UNIFIED IDEOGRAPH-6B3A
        0x6B3D, # G+3229  U+6B3D  uni6B3D,  CJK UNIFIED IDEOGRAPH-6B3D
        0x6B98, # G+3230  U+6B98  uni6B98,  CJK UNIFIED IDEOGRAPH-6B98
        0x6B96, # G+3231  U+6B96  uni6B96,  CJK UNIFIED IDEOGRAPH-6B96
        0x6BBC, # G+3232  U+6BBC  uni6BBC,  CJK UNIFIED IDEOGRAPH-6BBC
        0x6BEF, # G+3233  U+6BEF  uni6BEF,  CJK UNIFIED IDEOGRAPH-6BEF
        0x6C2E, # G+3234  U+6C2E  uni6C2E,  CJK UNIFIED IDEOGRAPH-6C2E
        0x6C2F, # G+3235  U+6C2F  uni6C2F,  CJK UNIFIED IDEOGRAPH-6C2F
        0x6C2C, # G+3236  U+6C2C  uni6C2C,  CJK UNIFIED IDEOGRAPH-6C2C
        0x6E2F, # G+3237  U+6E2F  uni6E2F,  CJK UNIFIED IDEOGRAPH-6E2F
        0x6E38, # G+3238  U+6E38  uni6E38,  CJK UNIFIED IDEOGRAPH-6E38
        0x6E54, # G+3239  U+6E54  uni6E54,  CJK UNIFIED IDEOGRAPH-6E54
        0x6E21, # G+3240  U+6E21  uni6E21,  CJK UNIFIED IDEOGRAPH-6E21
        0x6E32, # G+3241  U+6E32  uni6E32,  CJK UNIFIED IDEOGRAPH-6E32
        0x6E67, # G+3242  U+6E67  uni6E67,  CJK UNIFIED IDEOGRAPH-6E67
        0x6E4A, # G+3243  U+6E4A  uni6E4A,  CJK UNIFIED IDEOGRAPH-6E4A
        0x6E20, # G+3244  U+6E20  uni6E20,  CJK UNIFIED IDEOGRAPH-6E20
        0x6E25, # G+3245  U+6E25  uni6E25,  CJK UNIFIED IDEOGRAPH-6E25
        0x6E23, # G+3246  U+6E23  uni6E23,  CJK UNIFIED IDEOGRAPH-6E23
        0x6E1B, # G+3247  U+6E1B  uni6E1B,  CJK UNIFIED IDEOGRAPH-6E1B
        0x6E5B, # G+3248  U+6E5B  uni6E5B,  CJK UNIFIED IDEOGRAPH-6E5B
        0x6E58, # G+3249  U+6E58  uni6E58,  CJK UNIFIED IDEOGRAPH-6E58
        0x6E24, # G+3250  U+6E24  uni6E24,  CJK UNIFIED IDEOGRAPH-6E24
        0x6E56, # G+3251  U+6E56  uni6E56,  CJK UNIFIED IDEOGRAPH-6E56
        0x6E6E, # G+3252  U+6E6E  uni6E6E,  CJK UNIFIED IDEOGRAPH-6E6E
        0x6E2D, # G+3253  U+6E2D  uni6E2D,  CJK UNIFIED IDEOGRAPH-6E2D
        0x6E26, # G+3254  U+6E26  uni6E26,  CJK UNIFIED IDEOGRAPH-6E26
        0x6E6F, # G+3255  U+6E6F  uni6E6F,  CJK UNIFIED IDEOGRAPH-6E6F
        0x6E34, # G+3256  U+6E34  uni6E34,  CJK UNIFIED IDEOGRAPH-6E34
        0x6E4D, # G+3257  U+6E4D  uni6E4D,  CJK UNIFIED IDEOGRAPH-6E4D
        0x6E3A, # G+3258  U+6E3A  uni6E3A,  CJK UNIFIED IDEOGRAPH-6E3A
        0x6E2C, # G+3259  U+6E2C  uni6E2C,  CJK UNIFIED IDEOGRAPH-6E2C
        0x6E43, # G+3260  U+6E43  uni6E43,  CJK UNIFIED IDEOGRAPH-6E43
        0x6E1D, # G+3261  U+6E1D  uni6E1D,  CJK UNIFIED IDEOGRAPH-6E1D
        0x6E3E, # G+3262  U+6E3E  uni6E3E,  CJK UNIFIED IDEOGRAPH-6E3E
        0x6ECB, # G+3263  U+6ECB  uni6ECB,  CJK UNIFIED IDEOGRAPH-6ECB
        0x6E89, # G+3264  U+6E89  uni6E89,  CJK UNIFIED IDEOGRAPH-6E89
        0x6E19, # G+3265  U+6E19  uni6E19,  CJK UNIFIED IDEOGRAPH-6E19
        0x6E4E, # G+3266  U+6E4E  uni6E4E,  CJK UNIFIED IDEOGRAPH-6E4E
        0x6E63, # G+3267  U+6E63  uni6E63,  CJK UNIFIED IDEOGRAPH-6E63
        0x6E44, # G+3268  U+6E44  uni6E44,  CJK UNIFIED IDEOGRAPH-6E44
        0x6E72, # G+3269  U+6E72  uni6E72,  CJK UNIFIED IDEOGRAPH-6E72
        0x6E69, # G+3270  U+6E69  uni6E69,  CJK UNIFIED IDEOGRAPH-6E69
        0x6E5F, # G+3271  U+6E5F  uni6E5F,  CJK UNIFIED IDEOGRAPH-6E5F
        0x7119, # G+3272  U+7119  uni7119,  CJK UNIFIED IDEOGRAPH-7119
        0x711A, # G+3273  U+711A  uni711A,  CJK UNIFIED IDEOGRAPH-711A
        0x7126, # G+3274  U+7126  uni7126,  CJK UNIFIED IDEOGRAPH-7126
        0x7130, # G+3275  U+7130  uni7130,  CJK UNIFIED IDEOGRAPH-7130
        0x7121, # G+3276  U+7121  uni7121,  CJK UNIFIED IDEOGRAPH-7121
        0x7136, # G+3277  U+7136  uni7136,  CJK UNIFIED IDEOGRAPH-7136
        0x716E, # G+3278  U+716E  uni716E,  CJK UNIFIED IDEOGRAPH-716E
        0x711C, # G+3279  U+711C  uni711C,  CJK UNIFIED IDEOGRAPH-711C
        0x724C, # G+3280  U+724C  uni724C,  CJK UNIFIED IDEOGRAPH-724C
        0x7284, # G+3281  U+7284  uni7284,  CJK UNIFIED IDEOGRAPH-7284
        0x7280, # G+3282  U+7280  uni7280,  CJK UNIFIED IDEOGRAPH-7280
        0x7336, # G+3283  U+7336  uni7336,  CJK UNIFIED IDEOGRAPH-7336
        0x7325, # G+3284  U+7325  uni7325,  CJK UNIFIED IDEOGRAPH-7325
        0x7334, # G+3285  U+7334  uni7334,  CJK UNIFIED IDEOGRAPH-7334
        0x7329, # G+3286  U+7329  uni7329,  CJK UNIFIED IDEOGRAPH-7329
        0x743A, # G+3287  U+743A  uni743A,  CJK UNIFIED IDEOGRAPH-743A
        0x742A, # G+3288  U+742A  uni742A,  CJK UNIFIED IDEOGRAPH-742A
        0x7433, # G+3289  U+7433  uni7433,  CJK UNIFIED IDEOGRAPH-7433
        0x7422, # G+3290  U+7422  uni7422,  CJK UNIFIED IDEOGRAPH-7422
        0x7425, # G+3291  U+7425  uni7425,  CJK UNIFIED IDEOGRAPH-7425
        0x7435, # G+3292  U+7435  uni7435,  CJK UNIFIED IDEOGRAPH-7435
        0x7436, # G+3293  U+7436  uni7436,  CJK UNIFIED IDEOGRAPH-7436
        0x7434, # G+3294  U+7434  uni7434,  CJK UNIFIED IDEOGRAPH-7434
        0x742F, # G+3295  U+742F  uni742F,  CJK UNIFIED IDEOGRAPH-742F
        0x741B, # G+3296  U+741B  uni741B,  CJK UNIFIED IDEOGRAPH-741B
        0x7426, # G+3297  U+7426  uni7426,  CJK UNIFIED IDEOGRAPH-7426
        0x7428, # G+3298  U+7428  uni7428,  CJK UNIFIED IDEOGRAPH-7428
        0x7525, # G+3299  U+7525  uni7525,  CJK UNIFIED IDEOGRAPH-7525
        0x7526, # G+3300  U+7526  uni7526,  CJK UNIFIED IDEOGRAPH-7526
        0x756B, # G+3301  U+756B  uni756B,  CJK UNIFIED IDEOGRAPH-756B
        0x756A, # G+3302  U+756A  uni756A,  CJK UNIFIED IDEOGRAPH-756A
        0x75E2, # G+3303  U+75E2  uni75E2,  CJK UNIFIED IDEOGRAPH-75E2
        0x75DB, # G+3304  U+75DB  uni75DB,  CJK UNIFIED IDEOGRAPH-75DB
        0x75E3, # G+3305  U+75E3  uni75E3,  CJK UNIFIED IDEOGRAPH-75E3
        0x75D9, # G+3306  U+75D9  uni75D9,  CJK UNIFIED IDEOGRAPH-75D9
        0x75D8, # G+3307  U+75D8  uni75D8,  CJK UNIFIED IDEOGRAPH-75D8
        0x75DE, # G+3308  U+75DE  uni75DE,  CJK UNIFIED IDEOGRAPH-75DE
        0x75E0, # G+3309  U+75E0  uni75E0,  CJK UNIFIED IDEOGRAPH-75E0
        0x767B, # G+3310  U+767B  uni767B,  CJK UNIFIED IDEOGRAPH-767B
        0x767C, # G+3311  U+767C  uni767C,  CJK UNIFIED IDEOGRAPH-767C
        0x7696, # G+3312  U+7696  uni7696,  CJK UNIFIED IDEOGRAPH-7696
        0x7693, # G+3313  U+7693  uni7693,  CJK UNIFIED IDEOGRAPH-7693
        0x76B4, # G+3314  U+76B4  uni76B4,  CJK UNIFIED IDEOGRAPH-76B4
        0x76DC, # G+3315  U+76DC  uni76DC,  CJK UNIFIED IDEOGRAPH-76DC
        0x774F, # G+3316  U+774F  uni774F,  CJK UNIFIED IDEOGRAPH-774F
        0x77ED, # G+3317  U+77ED  uni77ED,  CJK UNIFIED IDEOGRAPH-77ED
        0x785D, # G+3318  U+785D  uni785D,  CJK UNIFIED IDEOGRAPH-785D
        0x786C, # G+3319  U+786C  uni786C,  CJK UNIFIED IDEOGRAPH-786C
        0x786F, # G+3320  U+786F  uni786F,  CJK UNIFIED IDEOGRAPH-786F
        0x7A0D, # G+3321  U+7A0D  uni7A0D,  CJK UNIFIED IDEOGRAPH-7A0D
        0x7A08, # G+3322  U+7A08  uni7A08,  CJK UNIFIED IDEOGRAPH-7A08
        0x7A0B, # G+3323  U+7A0B  uni7A0B,  CJK UNIFIED IDEOGRAPH-7A0B
        0x7A05, # G+3324  U+7A05  uni7A05,  CJK UNIFIED IDEOGRAPH-7A05
        0x7A00, # G+3325  U+7A00  uni7A00,  CJK UNIFIED IDEOGRAPH-7A00
        0x7A98, # G+3326  U+7A98  uni7A98,  CJK UNIFIED IDEOGRAPH-7A98
        0x7A97, # G+3327  U+7A97  uni7A97,  CJK UNIFIED IDEOGRAPH-7A97
        0x7A96, # G+3328  U+7A96  uni7A96,  CJK UNIFIED IDEOGRAPH-7A96
        0x7AE5, # G+3329  U+7AE5  uni7AE5,  CJK UNIFIED IDEOGRAPH-7AE5
        0x7AE3, # G+3330  U+7AE3  uni7AE3,  CJK UNIFIED IDEOGRAPH-7AE3
        0x7B49, # G+3331  U+7B49  uni7B49,  CJK UNIFIED IDEOGRAPH-7B49
        0x7B56, # G+3332  U+7B56  uni7B56,  CJK UNIFIED IDEOGRAPH-7B56
        0x7B46, # G+3333  U+7B46  uni7B46,  CJK UNIFIED IDEOGRAPH-7B46
        0x7B50, # G+3334  U+7B50  uni7B50,  CJK UNIFIED IDEOGRAPH-7B50
        0x7B52, # G+3335  U+7B52  uni7B52,  CJK UNIFIED IDEOGRAPH-7B52
        0x7B54, # G+3336  U+7B54  uni7B54,  CJK UNIFIED IDEOGRAPH-7B54
        0x7B4D, # G+3337  U+7B4D  uni7B4D,  CJK UNIFIED IDEOGRAPH-7B4D
        0x7B4B, # G+3338  U+7B4B  uni7B4B,  CJK UNIFIED IDEOGRAPH-7B4B
        0x7B4F, # G+3339  U+7B4F  uni7B4F,  CJK UNIFIED IDEOGRAPH-7B4F
        0x7B51, # G+3340  U+7B51  uni7B51,  CJK UNIFIED IDEOGRAPH-7B51
        0x7C9F, # G+3341  U+7C9F  uni7C9F,  CJK UNIFIED IDEOGRAPH-7C9F
        0x7CA5, # G+3342  U+7CA5  uni7CA5,  CJK UNIFIED IDEOGRAPH-7CA5
        0x7D5E, # G+3343  U+7D5E  uni7D5E,  CJK UNIFIED IDEOGRAPH-7D5E
        0x7D50, # G+3344  U+7D50  uni7D50,  CJK UNIFIED IDEOGRAPH-7D50
        0x7D68, # G+3345  U+7D68  uni7D68,  CJK UNIFIED IDEOGRAPH-7D68
        0x7D55, # G+3346  U+7D55  uni7D55,  CJK UNIFIED IDEOGRAPH-7D55
        0x7D2B, # G+3347  U+7D2B  uni7D2B,  CJK UNIFIED IDEOGRAPH-7D2B
        0x7D6E, # G+3348  U+7D6E  uni7D6E,  CJK UNIFIED IDEOGRAPH-7D6E
        0x7D72, # G+3349  U+7D72  uni7D72,  CJK UNIFIED IDEOGRAPH-7D72
        0x7D61, # G+3350  U+7D61  uni7D61,  CJK UNIFIED IDEOGRAPH-7D61
        0x7D66, # G+3351  U+7D66  uni7D66,  CJK UNIFIED IDEOGRAPH-7D66
        0x7D62, # G+3352  U+7D62  uni7D62,  CJK UNIFIED IDEOGRAPH-7D62
        0x7D70, # G+3353  U+7D70  uni7D70,  CJK UNIFIED IDEOGRAPH-7D70
        0x7D73, # G+3354  U+7D73  uni7D73,  CJK UNIFIED IDEOGRAPH-7D73
        0x5584, # G+3355  U+5584  uni5584,  CJK UNIFIED IDEOGRAPH-5584
        0x7FD4, # G+3356  U+7FD4  uni7FD4,  CJK UNIFIED IDEOGRAPH-7FD4
        0x7FD5, # G+3357  U+7FD5  uni7FD5,  CJK UNIFIED IDEOGRAPH-7FD5
        0x800B, # G+3358  U+800B  uni800B,  CJK UNIFIED IDEOGRAPH-800B
        0x8052, # G+3359  U+8052  uni8052,  CJK UNIFIED IDEOGRAPH-8052
        0x8085, # G+3360  U+8085  uni8085,  CJK UNIFIED IDEOGRAPH-8085
        0x8155, # G+3361  U+8155  uni8155,  CJK UNIFIED IDEOGRAPH-8155
        0x8154, # G+3362  U+8154  uni8154,  CJK UNIFIED IDEOGRAPH-8154
        0x814B, # G+3363  U+814B  uni814B,  CJK UNIFIED IDEOGRAPH-814B
        0x8151, # G+3364  U+8151  uni8151,  CJK UNIFIED IDEOGRAPH-8151
        0x814E, # G+3365  U+814E  uni814E,  CJK UNIFIED IDEOGRAPH-814E
        0x8139, # G+3366  U+8139  uni8139,  CJK UNIFIED IDEOGRAPH-8139
        0x8146, # G+3367  U+8146  uni8146,  CJK UNIFIED IDEOGRAPH-8146
        0x813E, # G+3368  U+813E  uni813E,  CJK UNIFIED IDEOGRAPH-813E
        0x814C, # G+3369  U+814C  uni814C,  CJK UNIFIED IDEOGRAPH-814C
        0x8153, # G+3370  U+8153  uni8153,  CJK UNIFIED IDEOGRAPH-8153
        0x8174, # G+3371  U+8174  uni8174,  CJK UNIFIED IDEOGRAPH-8174
        0x8212, # G+3372  U+8212  uni8212,  CJK UNIFIED IDEOGRAPH-8212
        0x821C, # G+3373  U+821C  uni821C,  CJK UNIFIED IDEOGRAPH-821C
        0x83E9, # G+3374  U+83E9  uni83E9,  CJK UNIFIED IDEOGRAPH-83E9
        0x8403, # G+3375  U+8403  uni8403,  CJK UNIFIED IDEOGRAPH-8403
        0x83F8, # G+3376  U+83F8  uni83F8,  CJK UNIFIED IDEOGRAPH-83F8
        0x840D, # G+3377  U+840D  uni840D,  CJK UNIFIED IDEOGRAPH-840D
        0x83E0, # G+3378  U+83E0  uni83E0,  CJK UNIFIED IDEOGRAPH-83E0
        0x83C5, # G+3379  U+83C5  uni83C5,  CJK UNIFIED IDEOGRAPH-83C5
        0x840B, # G+3380  U+840B  uni840B,  CJK UNIFIED IDEOGRAPH-840B
        0x83C1, # G+3381  U+83C1  uni83C1,  CJK UNIFIED IDEOGRAPH-83C1
        0x83EF, # G+3382  U+83EF  uni83EF,  CJK UNIFIED IDEOGRAPH-83EF
        0x83F1, # G+3383  U+83F1  uni83F1,  CJK UNIFIED IDEOGRAPH-83F1
        0x83F4, # G+3384  U+83F4  uni83F4,  CJK UNIFIED IDEOGRAPH-83F4
        0x8457, # G+3385  U+8457  uni8457,  CJK UNIFIED IDEOGRAPH-8457
        0x840A, # G+3386  U+840A  uni840A,  CJK UNIFIED IDEOGRAPH-840A
        0x83F0, # G+3387  U+83F0  uni83F0,  CJK UNIFIED IDEOGRAPH-83F0
        0x840C, # G+3388  U+840C  uni840C,  CJK UNIFIED IDEOGRAPH-840C
        0x83CC, # G+3389  U+83CC  uni83CC,  CJK UNIFIED IDEOGRAPH-83CC
        0x83FD, # G+3390  U+83FD  uni83FD,  CJK UNIFIED IDEOGRAPH-83FD
        0x83F2, # G+3391  U+83F2  uni83F2,  CJK UNIFIED IDEOGRAPH-83F2
        0x83CA, # G+3392  U+83CA  uni83CA,  CJK UNIFIED IDEOGRAPH-83CA
        0x8438, # G+3393  U+8438  uni8438,  CJK UNIFIED IDEOGRAPH-8438
        0x840E, # G+3394  U+840E  uni840E,  CJK UNIFIED IDEOGRAPH-840E
        0x8404, # G+3395  U+8404  uni8404,  CJK UNIFIED IDEOGRAPH-8404
        0x83DC, # G+3396  U+83DC  uni83DC,  CJK UNIFIED IDEOGRAPH-83DC
        0x8407, # G+3397  U+8407  uni8407,  CJK UNIFIED IDEOGRAPH-8407
        0x83D4, # G+3398  U+83D4  uni83D4,  CJK UNIFIED IDEOGRAPH-83D4
        0x83DF, # G+3399  U+83DF  uni83DF,  CJK UNIFIED IDEOGRAPH-83DF
        0x865B, # G+3400  U+865B  uni865B,  CJK UNIFIED IDEOGRAPH-865B
        0x86DF, # G+3401  U+86DF  uni86DF,  CJK UNIFIED IDEOGRAPH-86DF
        0x86D9, # G+3402  U+86D9  uni86D9,  CJK UNIFIED IDEOGRAPH-86D9
        0x86ED, # G+3403  U+86ED  uni86ED,  CJK UNIFIED IDEOGRAPH-86ED
        0x86D4, # G+3404  U+86D4  uni86D4,  CJK UNIFIED IDEOGRAPH-86D4
        0x86DB, # G+3405  U+86DB  uni86DB,  CJK UNIFIED IDEOGRAPH-86DB
        0x86E4, # G+3406  U+86E4  uni86E4,  CJK UNIFIED IDEOGRAPH-86E4
        0x86D0, # G+3407  U+86D0  uni86D0,  CJK UNIFIED IDEOGRAPH-86D0
        0x86DE, # G+3408  U+86DE  uni86DE,  CJK UNIFIED IDEOGRAPH-86DE
        0x8857, # G+3409  U+8857  uni8857,  CJK UNIFIED IDEOGRAPH-8857
        0x88C1, # G+3410  U+88C1  uni88C1,  CJK UNIFIED IDEOGRAPH-88C1
        0x88C2, # G+3411  U+88C2  uni88C2,  CJK UNIFIED IDEOGRAPH-88C2
        0x88B1, # G+3412  U+88B1  uni88B1,  CJK UNIFIED IDEOGRAPH-88B1
        0x8983, # G+3413  U+8983  uni8983,  CJK UNIFIED IDEOGRAPH-8983
        0x8996, # G+3414  U+8996  uni8996,  CJK UNIFIED IDEOGRAPH-8996
        0x8A3B, # G+3415  U+8A3B  uni8A3B,  CJK UNIFIED IDEOGRAPH-8A3B
        0x8A60, # G+3416  U+8A60  uni8A60,  CJK UNIFIED IDEOGRAPH-8A60
        0x8A55, # G+3417  U+8A55  uni8A55,  CJK UNIFIED IDEOGRAPH-8A55
        0x8A5E, # G+3418  U+8A5E  uni8A5E,  CJK UNIFIED IDEOGRAPH-8A5E
        0x8A3C, # G+3419  U+8A3C  uni8A3C,  CJK UNIFIED IDEOGRAPH-8A3C
        0x8A41, # G+3420  U+8A41  uni8A41,  CJK UNIFIED IDEOGRAPH-8A41
        0x8A54, # G+3421  U+8A54  uni8A54,  CJK UNIFIED IDEOGRAPH-8A54
        0x8A5B, # G+3422  U+8A5B  uni8A5B,  CJK UNIFIED IDEOGRAPH-8A5B
        0x8A50, # G+3423  U+8A50  uni8A50,  CJK UNIFIED IDEOGRAPH-8A50
        0x8A46, # G+3424  U+8A46  uni8A46,  CJK UNIFIED IDEOGRAPH-8A46
        0x8A34, # G+3425  U+8A34  uni8A34,  CJK UNIFIED IDEOGRAPH-8A34
        0x8A3A, # G+3426  U+8A3A  uni8A3A,  CJK UNIFIED IDEOGRAPH-8A3A
        0x8A36, # G+3427  U+8A36  uni8A36,  CJK UNIFIED IDEOGRAPH-8A36
        0x8A56, # G+3428  U+8A56  uni8A56,  CJK UNIFIED IDEOGRAPH-8A56
        0x8C61, # G+3429  U+8C61  uni8C61,  CJK UNIFIED IDEOGRAPH-8C61
        0x8C82, # G+3430  U+8C82  uni8C82,  CJK UNIFIED IDEOGRAPH-8C82
        0x8CAF, # G+3431  U+8CAF  uni8CAF,  CJK UNIFIED IDEOGRAPH-8CAF
        0x8CBC, # G+3432  U+8CBC  uni8CBC,  CJK UNIFIED IDEOGRAPH-8CBC
        0x8CB3, # G+3433  U+8CB3  uni8CB3,  CJK UNIFIED IDEOGRAPH-8CB3
        0x8CBD, # G+3434  U+8CBD  uni8CBD,  CJK UNIFIED IDEOGRAPH-8CBD
        0x8CC1, # G+3435  U+8CC1  uni8CC1,  CJK UNIFIED IDEOGRAPH-8CC1
        0x8CBB, # G+3436  U+8CBB  uni8CBB,  CJK UNIFIED IDEOGRAPH-8CBB
        0x8CC0, # G+3437  U+8CC0  uni8CC0,  CJK UNIFIED IDEOGRAPH-8CC0
        0x8CB4, # G+3438  U+8CB4  uni8CB4,  CJK UNIFIED IDEOGRAPH-8CB4
        0x8CB7, # G+3439  U+8CB7  uni8CB7,  CJK UNIFIED IDEOGRAPH-8CB7
        0x8CB6, # G+3440  U+8CB6  uni8CB6,  CJK UNIFIED IDEOGRAPH-8CB6
        0x8CBF, # G+3441  U+8CBF  uni8CBF,  CJK UNIFIED IDEOGRAPH-8CBF
        0x8CB8, # G+3442  U+8CB8  uni8CB8,  CJK UNIFIED IDEOGRAPH-8CB8
        0x8D8A, # G+3443  U+8D8A  uni8D8A,  CJK UNIFIED IDEOGRAPH-8D8A
        0x8D85, # G+3444  U+8D85  uni8D85,  CJK UNIFIED IDEOGRAPH-8D85
        0x8D81, # G+3445  U+8D81  uni8D81,  CJK UNIFIED IDEOGRAPH-8D81
        0x8DCE, # G+3446  U+8DCE  uni8DCE,  CJK UNIFIED IDEOGRAPH-8DCE
        0x8DDD, # G+3447  U+8DDD  uni8DDD,  CJK UNIFIED IDEOGRAPH-8DDD
        0x8DCB, # G+3448  U+8DCB  uni8DCB,  CJK UNIFIED IDEOGRAPH-8DCB
        0x8DDA, # G+3449  U+8DDA  uni8DDA,  CJK UNIFIED IDEOGRAPH-8DDA
        0x8DD1, # G+3450  U+8DD1  uni8DD1,  CJK UNIFIED IDEOGRAPH-8DD1
        0x8DCC, # G+3451  U+8DCC  uni8DCC,  CJK UNIFIED IDEOGRAPH-8DCC
        0x8DDB, # G+3452  U+8DDB  uni8DDB,  CJK UNIFIED IDEOGRAPH-8DDB
        0x8DC6, # G+3453  U+8DC6  uni8DC6,  CJK UNIFIED IDEOGRAPH-8DC6
        0x8EFB, # G+3454  U+8EFB  uni8EFB,  CJK UNIFIED IDEOGRAPH-8EFB
        0x8EF8, # G+3455  U+8EF8  uni8EF8,  CJK UNIFIED IDEOGRAPH-8EF8
        0x8EFC, # G+3456  U+8EFC  uni8EFC,  CJK UNIFIED IDEOGRAPH-8EFC
        0x8F9C, # G+3457  U+8F9C  uni8F9C,  CJK UNIFIED IDEOGRAPH-8F9C
        0x902E, # G+3458  U+902E  uni902E,  CJK UNIFIED IDEOGRAPH-902E
        0x9035, # G+3459  U+9035  uni9035,  CJK UNIFIED IDEOGRAPH-9035
        0x9031, # G+3460  U+9031  uni9031,  CJK UNIFIED IDEOGRAPH-9031
        0x9038, # G+3461  U+9038  uni9038,  CJK UNIFIED IDEOGRAPH-9038
        0x9032, # G+3462  U+9032  uni9032,  CJK UNIFIED IDEOGRAPH-9032
        0x9036, # G+3463  U+9036  uni9036,  CJK UNIFIED IDEOGRAPH-9036
        0x9102, # G+3464  U+9102  uni9102,  CJK UNIFIED IDEOGRAPH-9102
        0x90F5, # G+3465  U+90F5  uni90F5,  CJK UNIFIED IDEOGRAPH-90F5
        0x9109, # G+3466  U+9109  uni9109,  CJK UNIFIED IDEOGRAPH-9109
        0x90FE, # G+3467  U+90FE  uni90FE,  CJK UNIFIED IDEOGRAPH-90FE
        0x9163, # G+3468  U+9163  uni9163,  CJK UNIFIED IDEOGRAPH-9163
        0x9165, # G+3469  U+9165  uni9165,  CJK UNIFIED IDEOGRAPH-9165
        0x91CF, # G+3470  U+91CF  uni91CF,  CJK UNIFIED IDEOGRAPH-91CF
        0x9214, # G+3471  U+9214  uni9214,  CJK UNIFIED IDEOGRAPH-9214
        0x9215, # G+3472  U+9215  uni9215,  CJK UNIFIED IDEOGRAPH-9215
        0x9223, # G+3473  U+9223  uni9223,  CJK UNIFIED IDEOGRAPH-9223
        0x9209, # G+3474  U+9209  uni9209,  CJK UNIFIED IDEOGRAPH-9209
        0x921E, # G+3475  U+921E  uni921E,  CJK UNIFIED IDEOGRAPH-921E
        0x920D, # G+3476  U+920D  uni920D,  CJK UNIFIED IDEOGRAPH-920D
        0x9210, # G+3477  U+9210  uni9210,  CJK UNIFIED IDEOGRAPH-9210
        0x9207, # G+3478  U+9207  uni9207,  CJK UNIFIED IDEOGRAPH-9207
        0x9211, # G+3479  U+9211  uni9211,  CJK UNIFIED IDEOGRAPH-9211
        0x9594, # G+3480  U+9594  uni9594,  CJK UNIFIED IDEOGRAPH-9594
        0x958F, # G+3481  U+958F  uni958F,  CJK UNIFIED IDEOGRAPH-958F
        0x958B, # G+3482  U+958B  uni958B,  CJK UNIFIED IDEOGRAPH-958B
        0x9591, # G+3483  U+9591  uni9591,  CJK UNIFIED IDEOGRAPH-9591
        0x9593, # G+3484  U+9593  uni9593,  CJK UNIFIED IDEOGRAPH-9593
        0x9592, # G+3485  U+9592  uni9592,  CJK UNIFIED IDEOGRAPH-9592
        0x958E, # G+3486  U+958E  uni958E,  CJK UNIFIED IDEOGRAPH-958E
        0x968A, # G+3487  U+968A  uni968A,  CJK UNIFIED IDEOGRAPH-968A
        0x968E, # G+3488  U+968E  uni968E,  CJK UNIFIED IDEOGRAPH-968E
        0x968B, # G+3489  U+968B  uni968B,  CJK UNIFIED IDEOGRAPH-968B
        0x967D, # G+3490  U+967D  uni967D,  CJK UNIFIED IDEOGRAPH-967D
        0x9685, # G+3491  U+9685  uni9685,  CJK UNIFIED IDEOGRAPH-9685
        0x9686, # G+3492  U+9686  uni9686,  CJK UNIFIED IDEOGRAPH-9686
        0x968D, # G+3493  U+968D  uni968D,  CJK UNIFIED IDEOGRAPH-968D
        0x9672, # G+3494  U+9672  uni9672,  CJK UNIFIED IDEOGRAPH-9672
        0x9684, # G+3495  U+9684  uni9684,  CJK UNIFIED IDEOGRAPH-9684
        0x96C1, # G+3496  U+96C1  uni96C1,  CJK UNIFIED IDEOGRAPH-96C1
        0x96C5, # G+3497  U+96C5  uni96C5,  CJK UNIFIED IDEOGRAPH-96C5
        0x96C4, # G+3498  U+96C4  uni96C4,  CJK UNIFIED IDEOGRAPH-96C4
        0x96C6, # G+3499  U+96C6  uni96C6,  CJK UNIFIED IDEOGRAPH-96C6
        0x96C7, # G+3500  U+96C7  uni96C7,  CJK UNIFIED IDEOGRAPH-96C7
        0x96EF, # G+3501  U+96EF  uni96EF,  CJK UNIFIED IDEOGRAPH-96EF
        0x96F2, # G+3502  U+96F2  uni96F2,  CJK UNIFIED IDEOGRAPH-96F2
        0x97CC, # G+3503  U+97CC  uni97CC,  CJK UNIFIED IDEOGRAPH-97CC
        0x9805, # G+3504  U+9805  uni9805,  CJK UNIFIED IDEOGRAPH-9805
        0x9806, # G+3505  U+9806  uni9806,  CJK UNIFIED IDEOGRAPH-9806
        0x9808, # G+3506  U+9808  uni9808,  CJK UNIFIED IDEOGRAPH-9808
        0x98E7, # G+3507  U+98E7  uni98E7,  CJK UNIFIED IDEOGRAPH-98E7
        0x98EA, # G+3508  U+98EA  uni98EA,  CJK UNIFIED IDEOGRAPH-98EA
        0x98EF, # G+3509  U+98EF  uni98EF,  CJK UNIFIED IDEOGRAPH-98EF
        0x98E9, # G+3510  U+98E9  uni98E9,  CJK UNIFIED IDEOGRAPH-98E9
        0x98F2, # G+3511  U+98F2  uni98F2,  CJK UNIFIED IDEOGRAPH-98F2
        0x98ED, # G+3512  U+98ED  uni98ED,  CJK UNIFIED IDEOGRAPH-98ED
        0x99AE, # G+3513  U+99AE  uni99AE,  CJK UNIFIED IDEOGRAPH-99AE
        0x99AD, # G+3514  U+99AD  uni99AD,  CJK UNIFIED IDEOGRAPH-99AD
        0x9EC3, # G+3515  U+9EC3  uni9EC3,  CJK UNIFIED IDEOGRAPH-9EC3
        0x9ECD, # G+3516  U+9ECD  uni9ECD,  CJK UNIFIED IDEOGRAPH-9ECD
        0x9ED1, # G+3517  U+9ED1  uni9ED1,  CJK UNIFIED IDEOGRAPH-9ED1
        0x4E82, # G+3518  U+4E82  uni4E82,  CJK UNIFIED IDEOGRAPH-4E82
        0x50AD, # G+3519  U+50AD  uni50AD,  CJK UNIFIED IDEOGRAPH-50AD
        0x50B5, # G+3520  U+50B5  uni50B5,  CJK UNIFIED IDEOGRAPH-50B5
        0x50B2, # G+3521  U+50B2  uni50B2,  CJK UNIFIED IDEOGRAPH-50B2
        0x50B3, # G+3522  U+50B3  uni50B3,  CJK UNIFIED IDEOGRAPH-50B3
        0x50C5, # G+3523  U+50C5  uni50C5,  CJK UNIFIED IDEOGRAPH-50C5
        0x50BE, # G+3524  U+50BE  uni50BE,  CJK UNIFIED IDEOGRAPH-50BE
        0x50AC, # G+3525  U+50AC  uni50AC,  CJK UNIFIED IDEOGRAPH-50AC
        0x50B7, # G+3526  U+50B7  uni50B7,  CJK UNIFIED IDEOGRAPH-50B7
        0x50BB, # G+3527  U+50BB  uni50BB,  CJK UNIFIED IDEOGRAPH-50BB
        0x50AF, # G+3528  U+50AF  uni50AF,  CJK UNIFIED IDEOGRAPH-50AF
        0x50C7, # G+3529  U+50C7  uni50C7,  CJK UNIFIED IDEOGRAPH-50C7
        0x527F, # G+3530  U+527F  uni527F,  CJK UNIFIED IDEOGRAPH-527F
        0x5277, # G+3531  U+5277  uni5277,  CJK UNIFIED IDEOGRAPH-5277
        0x527D, # G+3532  U+527D  uni527D,  CJK UNIFIED IDEOGRAPH-527D
        0x52DF, # G+3533  U+52DF  uni52DF,  CJK UNIFIED IDEOGRAPH-52DF
        0x52E6, # G+3534  U+52E6  uni52E6,  CJK UNIFIED IDEOGRAPH-52E6
        0x52E4, # G+3535  U+52E4  uni52E4,  CJK UNIFIED IDEOGRAPH-52E4
        0x52E2, # G+3536  U+52E2  uni52E2,  CJK UNIFIED IDEOGRAPH-52E2
        0x52E3, # G+3537  U+52E3  uni52E3,  CJK UNIFIED IDEOGRAPH-52E3
        0x532F, # G+3538  U+532F  uni532F,  CJK UNIFIED IDEOGRAPH-532F
        0x55DF, # G+3539  U+55DF  uni55DF,  CJK UNIFIED IDEOGRAPH-55DF
        0x55E8, # G+3540  U+55E8  uni55E8,  CJK UNIFIED IDEOGRAPH-55E8
        0x55D3, # G+3541  U+55D3  uni55D3,  CJK UNIFIED IDEOGRAPH-55D3
        0x55E6, # G+3542  U+55E6  uni55E6,  CJK UNIFIED IDEOGRAPH-55E6
        0x55CE, # G+3543  U+55CE  uni55CE,  CJK UNIFIED IDEOGRAPH-55CE
        0x55DC, # G+3544  U+55DC  uni55DC,  CJK UNIFIED IDEOGRAPH-55DC
        0x55C7, # G+3545  U+55C7  uni55C7,  CJK UNIFIED IDEOGRAPH-55C7
        0x55D1, # G+3546  U+55D1  uni55D1,  CJK UNIFIED IDEOGRAPH-55D1
        0x55E3, # G+3547  U+55E3  uni55E3,  CJK UNIFIED IDEOGRAPH-55E3
        0x55E4, # G+3548  U+55E4  uni55E4,  CJK UNIFIED IDEOGRAPH-55E4
        0x55EF, # G+3549  U+55EF  uni55EF,  CJK UNIFIED IDEOGRAPH-55EF
        0x55DA, # G+3550  U+55DA  uni55DA,  CJK UNIFIED IDEOGRAPH-55DA
        0x55E1, # G+3551  U+55E1  uni55E1,  CJK UNIFIED IDEOGRAPH-55E1
        0x55C5, # G+3552  U+55C5  uni55C5,  CJK UNIFIED IDEOGRAPH-55C5
        0x55C6, # G+3553  U+55C6  uni55C6,  CJK UNIFIED IDEOGRAPH-55C6
        0x55E5, # G+3554  U+55E5  uni55E5,  CJK UNIFIED IDEOGRAPH-55E5
        0x55C9, # G+3555  U+55C9  uni55C9,  CJK UNIFIED IDEOGRAPH-55C9
        0x5712, # G+3556  U+5712  uni5712,  CJK UNIFIED IDEOGRAPH-5712
        0x5713, # G+3557  U+5713  uni5713,  CJK UNIFIED IDEOGRAPH-5713
        0x585E, # G+3558  U+585E  uni585E,  CJK UNIFIED IDEOGRAPH-585E
        0x5851, # G+3559  U+5851  uni5851,  CJK UNIFIED IDEOGRAPH-5851
        0x5858, # G+3560  U+5858  uni5858,  CJK UNIFIED IDEOGRAPH-5858
        0x5857, # G+3561  U+5857  uni5857,  CJK UNIFIED IDEOGRAPH-5857
        0x585A, # G+3562  U+585A  uni585A,  CJK UNIFIED IDEOGRAPH-585A
        0x5854, # G+3563  U+5854  uni5854,  CJK UNIFIED IDEOGRAPH-5854
        0x586B, # G+3564  U+586B  uni586B,  CJK UNIFIED IDEOGRAPH-586B
        0x584C, # G+3565  U+584C  uni584C,  CJK UNIFIED IDEOGRAPH-584C
        0x586D, # G+3566  U+586D  uni586D,  CJK UNIFIED IDEOGRAPH-586D
        0x584A, # G+3567  U+584A  uni584A,  CJK UNIFIED IDEOGRAPH-584A
        0x5862, # G+3568  U+5862  uni5862,  CJK UNIFIED IDEOGRAPH-5862
        0x5852, # G+3569  U+5852  uni5852,  CJK UNIFIED IDEOGRAPH-5852
        0x584B, # G+3570  U+584B  uni584B,  CJK UNIFIED IDEOGRAPH-584B
        0x5967, # G+3571  U+5967  uni5967,  CJK UNIFIED IDEOGRAPH-5967
        0x5AC1, # G+3572  U+5AC1  uni5AC1,  CJK UNIFIED IDEOGRAPH-5AC1
        0x5AC9, # G+3573  U+5AC9  uni5AC9,  CJK UNIFIED IDEOGRAPH-5AC9
        0x5ACC, # G+3574  U+5ACC  uni5ACC,  CJK UNIFIED IDEOGRAPH-5ACC
        0x5ABE, # G+3575  U+5ABE  uni5ABE,  CJK UNIFIED IDEOGRAPH-5ABE
        0x5ABD, # G+3576  U+5ABD  uni5ABD,  CJK UNIFIED IDEOGRAPH-5ABD
        0x5ABC, # G+3577  U+5ABC  uni5ABC,  CJK UNIFIED IDEOGRAPH-5ABC
        0x5AB3, # G+3578  U+5AB3  uni5AB3,  CJK UNIFIED IDEOGRAPH-5AB3
        0x5AC2, # G+3579  U+5AC2  uni5AC2,  CJK UNIFIED IDEOGRAPH-5AC2
        0x5AB2, # G+3580  U+5AB2  uni5AB2,  CJK UNIFIED IDEOGRAPH-5AB2
        0x5D69, # G+3581  U+5D69  uni5D69,  CJK UNIFIED IDEOGRAPH-5D69
        0x5D6F, # G+3582  U+5D6F  uni5D6F,  CJK UNIFIED IDEOGRAPH-5D6F
        0x5E4C, # G+3583  U+5E4C  uni5E4C,  CJK UNIFIED IDEOGRAPH-5E4C
        0x5E79, # G+3584  U+5E79  uni5E79,  CJK UNIFIED IDEOGRAPH-5E79
        0x5EC9, # G+3585  U+5EC9  uni5EC9,  CJK UNIFIED IDEOGRAPH-5EC9
        0x5EC8, # G+3586  U+5EC8  uni5EC8,  CJK UNIFIED IDEOGRAPH-5EC8
        0x5F12, # G+3587  U+5F12  uni5F12,  CJK UNIFIED IDEOGRAPH-5F12
        0x5F59, # G+3588  U+5F59  uni5F59,  CJK UNIFIED IDEOGRAPH-5F59
        0x5FAC, # G+3589  U+5FAC  uni5FAC,  CJK UNIFIED IDEOGRAPH-5FAC
        0x5FAE, # G+3590  U+5FAE  uni5FAE,  CJK UNIFIED IDEOGRAPH-5FAE
        0x611A, # G+3591  U+611A  uni611A,  CJK UNIFIED IDEOGRAPH-611A
        0x610F, # G+3592  U+610F  uni610F,  CJK UNIFIED IDEOGRAPH-610F
        0x6148, # G+3593  U+6148  uni6148,  CJK UNIFIED IDEOGRAPH-6148
        0x611F, # G+3594  U+611F  uni611F,  CJK UNIFIED IDEOGRAPH-611F
        0x60F3, # G+3595  U+60F3  uni60F3,  CJK UNIFIED IDEOGRAPH-60F3
        0x611B, # G+3596  U+611B  uni611B,  CJK UNIFIED IDEOGRAPH-611B
        0x60F9, # G+3597  U+60F9  uni60F9,  CJK UNIFIED IDEOGRAPH-60F9
        0x6101, # G+3598  U+6101  uni6101,  CJK UNIFIED IDEOGRAPH-6101
        0x6108, # G+3599  U+6108  uni6108,  CJK UNIFIED IDEOGRAPH-6108
        0x614E, # G+3600  U+614E  uni614E,  CJK UNIFIED IDEOGRAPH-614E
        0x614C, # G+3601  U+614C  uni614C,  CJK UNIFIED IDEOGRAPH-614C
        0x6144, # G+3602  U+6144  uni6144,  CJK UNIFIED IDEOGRAPH-6144
        0x614D, # G+3603  U+614D  uni614D,  CJK UNIFIED IDEOGRAPH-614D
        0x613E, # G+3604  U+613E  uni613E,  CJK UNIFIED IDEOGRAPH-613E
        0x6134, # G+3605  U+6134  uni6134,  CJK UNIFIED IDEOGRAPH-6134
        0x6127, # G+3606  U+6127  uni6127,  CJK UNIFIED IDEOGRAPH-6127
        0x610D, # G+3607  U+610D  uni610D,  CJK UNIFIED IDEOGRAPH-610D
        0x6106, # G+3608  U+6106  uni6106,  CJK UNIFIED IDEOGRAPH-6106
        0x6137, # G+3609  U+6137  uni6137,  CJK UNIFIED IDEOGRAPH-6137
        0x6221, # G+3610  U+6221  uni6221,  CJK UNIFIED IDEOGRAPH-6221
        0x6222, # G+3611  U+6222  uni6222,  CJK UNIFIED IDEOGRAPH-6222
        0x6413, # G+3612  U+6413  uni6413,  CJK UNIFIED IDEOGRAPH-6413
        0x643E, # G+3613  U+643E  uni643E,  CJK UNIFIED IDEOGRAPH-643E
        0x641E, # G+3614  U+641E  uni641E,  CJK UNIFIED IDEOGRAPH-641E
        0x642A, # G+3615  U+642A  uni642A,  CJK UNIFIED IDEOGRAPH-642A
        0x642D, # G+3616  U+642D  uni642D,  CJK UNIFIED IDEOGRAPH-642D
        0x643D, # G+3617  U+643D  uni643D,  CJK UNIFIED IDEOGRAPH-643D
        0x642C, # G+3618  U+642C  uni642C,  CJK UNIFIED IDEOGRAPH-642C
        0x640F, # G+3619  U+640F  uni640F,  CJK UNIFIED IDEOGRAPH-640F
        0x641C, # G+3620  U+641C  uni641C,  CJK UNIFIED IDEOGRAPH-641C
        0x6414, # G+3621  U+6414  uni6414,  CJK UNIFIED IDEOGRAPH-6414
        0x640D, # G+3622  U+640D  uni640D,  CJK UNIFIED IDEOGRAPH-640D
        0x6436, # G+3623  U+6436  uni6436,  CJK UNIFIED IDEOGRAPH-6436
        0x6416, # G+3624  U+6416  uni6416,  CJK UNIFIED IDEOGRAPH-6416
        0x6417, # G+3625  U+6417  uni6417,  CJK UNIFIED IDEOGRAPH-6417
        0x6406, # G+3626  U+6406  uni6406,  CJK UNIFIED IDEOGRAPH-6406
        0x656C, # G+3627  U+656C  uni656C,  CJK UNIFIED IDEOGRAPH-656C
        0x659F, # G+3628  U+659F  uni659F,  CJK UNIFIED IDEOGRAPH-659F
        0x65B0, # G+3629  U+65B0  uni65B0,  CJK UNIFIED IDEOGRAPH-65B0
        0x6697, # G+3630  U+6697  uni6697,  CJK UNIFIED IDEOGRAPH-6697
        0x6689, # G+3631  U+6689  uni6689,  CJK UNIFIED IDEOGRAPH-6689
        0x6687, # G+3632  U+6687  uni6687,  CJK UNIFIED IDEOGRAPH-6687
        0x6688, # G+3633  U+6688  uni6688,  CJK UNIFIED IDEOGRAPH-6688
        0x6696, # G+3634  U+6696  uni6696,  CJK UNIFIED IDEOGRAPH-6696
        0x6684, # G+3635  U+6684  uni6684,  CJK UNIFIED IDEOGRAPH-6684
        0x6698, # G+3636  U+6698  uni6698,  CJK UNIFIED IDEOGRAPH-6698
        0x668D, # G+3637  U+668D  uni668D,  CJK UNIFIED IDEOGRAPH-668D
        0x6703, # G+3638  U+6703  uni6703,  CJK UNIFIED IDEOGRAPH-6703
        0x6994, # G+3639  U+6994  uni6994,  CJK UNIFIED IDEOGRAPH-6994
        0x696D, # G+3640  U+696D  uni696D,  CJK UNIFIED IDEOGRAPH-696D
        0x695A, # G+3641  U+695A  uni695A,  CJK UNIFIED IDEOGRAPH-695A
        0x6977, # G+3642  U+6977  uni6977,  CJK UNIFIED IDEOGRAPH-6977
        0x6960, # G+3643  U+6960  uni6960,  CJK UNIFIED IDEOGRAPH-6960
        0x6954, # G+3644  U+6954  uni6954,  CJK UNIFIED IDEOGRAPH-6954
        0x6975, # G+3645  U+6975  uni6975,  CJK UNIFIED IDEOGRAPH-6975
        0x6930, # G+3646  U+6930  uni6930,  CJK UNIFIED IDEOGRAPH-6930
        0x6982, # G+3647  U+6982  uni6982,  CJK UNIFIED IDEOGRAPH-6982
        0x694A, # G+3648  U+694A  uni694A,  CJK UNIFIED IDEOGRAPH-694A
        0x6968, # G+3649  U+6968  uni6968,  CJK UNIFIED IDEOGRAPH-6968
        0x696B, # G+3650  U+696B  uni696B,  CJK UNIFIED IDEOGRAPH-696B
        0x695E, # G+3651  U+695E  uni695E,  CJK UNIFIED IDEOGRAPH-695E
        0x6953, # G+3652  U+6953  uni6953,  CJK UNIFIED IDEOGRAPH-6953
        0x6979, # G+3653  U+6979  uni6979,  CJK UNIFIED IDEOGRAPH-6979
        0x6986, # G+3654  U+6986  uni6986,  CJK UNIFIED IDEOGRAPH-6986
        0x695D, # G+3655  U+695D  uni695D,  CJK UNIFIED IDEOGRAPH-695D
        0x6963, # G+3656  U+6963  uni6963,  CJK UNIFIED IDEOGRAPH-6963
        0x695B, # G+3657  U+695B  uni695B,  CJK UNIFIED IDEOGRAPH-695B
        0x6B47, # G+3658  U+6B47  uni6B47,  CJK UNIFIED IDEOGRAPH-6B47
        0x6B72, # G+3659  U+6B72  uni6B72,  CJK UNIFIED IDEOGRAPH-6B72
        0x6BC0, # G+3660  U+6BC0  uni6BC0,  CJK UNIFIED IDEOGRAPH-6BC0
        0x6BBF, # G+3661  U+6BBF  uni6BBF,  CJK UNIFIED IDEOGRAPH-6BBF
        0x6BD3, # G+3662  U+6BD3  uni6BD3,  CJK UNIFIED IDEOGRAPH-6BD3
        0x6BFD, # G+3663  U+6BFD  uni6BFD,  CJK UNIFIED IDEOGRAPH-6BFD
        0x6EA2, # G+3664  U+6EA2  uni6EA2,  CJK UNIFIED IDEOGRAPH-6EA2
        0x6EAF, # G+3665  U+6EAF  uni6EAF,  CJK UNIFIED IDEOGRAPH-6EAF
        0x6ED3, # G+3666  U+6ED3  uni6ED3,  CJK UNIFIED IDEOGRAPH-6ED3
        0x6EB6, # G+3667  U+6EB6  uni6EB6,  CJK UNIFIED IDEOGRAPH-6EB6
        0x6EC2, # G+3668  U+6EC2  uni6EC2,  CJK UNIFIED IDEOGRAPH-6EC2
        0x6E90, # G+3669  U+6E90  uni6E90,  CJK UNIFIED IDEOGRAPH-6E90
        0x6E9D, # G+3670  U+6E9D  uni6E9D,  CJK UNIFIED IDEOGRAPH-6E9D
        0x6EC7, # G+3671  U+6EC7  uni6EC7,  CJK UNIFIED IDEOGRAPH-6EC7
        0x6EC5, # G+3672  U+6EC5  uni6EC5,  CJK UNIFIED IDEOGRAPH-6EC5
        0x6EA5, # G+3673  U+6EA5  uni6EA5,  CJK UNIFIED IDEOGRAPH-6EA5
        0x6E98, # G+3674  U+6E98  uni6E98,  CJK UNIFIED IDEOGRAPH-6E98
        0x6EBC, # G+3675  U+6EBC  uni6EBC,  CJK UNIFIED IDEOGRAPH-6EBC
        0x6EBA, # G+3676  U+6EBA  uni6EBA,  CJK UNIFIED IDEOGRAPH-6EBA
        0x6EAB, # G+3677  U+6EAB  uni6EAB,  CJK UNIFIED IDEOGRAPH-6EAB
        0x6ED1, # G+3678  U+6ED1  uni6ED1,  CJK UNIFIED IDEOGRAPH-6ED1
        0x6E96, # G+3679  U+6E96  uni6E96,  CJK UNIFIED IDEOGRAPH-6E96
        0x6E9C, # G+3680  U+6E9C  uni6E9C,  CJK UNIFIED IDEOGRAPH-6E9C
        0x6EC4, # G+3681  U+6EC4  uni6EC4,  CJK UNIFIED IDEOGRAPH-6EC4
        0x6ED4, # G+3682  U+6ED4  uni6ED4,  CJK UNIFIED IDEOGRAPH-6ED4
        0x6EAA, # G+3683  U+6EAA  uni6EAA,  CJK UNIFIED IDEOGRAPH-6EAA
        0x6EA7, # G+3684  U+6EA7  uni6EA7,  CJK UNIFIED IDEOGRAPH-6EA7
        0x6EB4, # G+3685  U+6EB4  uni6EB4,  CJK UNIFIED IDEOGRAPH-6EB4
        0x714E, # G+3686  U+714E  uni714E,  CJK UNIFIED IDEOGRAPH-714E
        0x7159, # G+3687  U+7159  uni7159,  CJK UNIFIED IDEOGRAPH-7159
        0x7169, # G+3688  U+7169  uni7169,  CJK UNIFIED IDEOGRAPH-7169
        0x7164, # G+3689  U+7164  uni7164,  CJK UNIFIED IDEOGRAPH-7164
        0x7149, # G+3690  U+7149  uni7149,  CJK UNIFIED IDEOGRAPH-7149
        0x7167, # G+3691  U+7167  uni7167,  CJK UNIFIED IDEOGRAPH-7167
        0x715C, # G+3692  U+715C  uni715C,  CJK UNIFIED IDEOGRAPH-715C
        0x716C, # G+3693  U+716C  uni716C,  CJK UNIFIED IDEOGRAPH-716C
        0x7166, # G+3694  U+7166  uni7166,  CJK UNIFIED IDEOGRAPH-7166
        0x714C, # G+3695  U+714C  uni714C,  CJK UNIFIED IDEOGRAPH-714C
        0x7165, # G+3696  U+7165  uni7165,  CJK UNIFIED IDEOGRAPH-7165
        0x715E, # G+3697  U+715E  uni715E,  CJK UNIFIED IDEOGRAPH-715E
        0x7146, # G+3698  U+7146  uni7146,  CJK UNIFIED IDEOGRAPH-7146
        0x7168, # G+3699  U+7168  uni7168,  CJK UNIFIED IDEOGRAPH-7168
        0x7156, # G+3700  U+7156  uni7156,  CJK UNIFIED IDEOGRAPH-7156
        0x723A, # G+3701  U+723A  uni723A,  CJK UNIFIED IDEOGRAPH-723A
        0x7252, # G+3702  U+7252  uni7252,  CJK UNIFIED IDEOGRAPH-7252
        0x7337, # G+3703  U+7337  uni7337,  CJK UNIFIED IDEOGRAPH-7337
        0x7345, # G+3704  U+7345  uni7345,  CJK UNIFIED IDEOGRAPH-7345
        0x733F, # G+3705  U+733F  uni733F,  CJK UNIFIED IDEOGRAPH-733F
        0x733E, # G+3706  U+733E  uni733E,  CJK UNIFIED IDEOGRAPH-733E
        0x746F, # G+3707  U+746F  uni746F,  CJK UNIFIED IDEOGRAPH-746F
        0x745A, # G+3708  U+745A  uni745A,  CJK UNIFIED IDEOGRAPH-745A
        0x7455, # G+3709  U+7455  uni7455,  CJK UNIFIED IDEOGRAPH-7455
        0x745F, # G+3710  U+745F  uni745F,  CJK UNIFIED IDEOGRAPH-745F
        0x745E, # G+3711  U+745E  uni745E,  CJK UNIFIED IDEOGRAPH-745E
        0x7441, # G+3712  U+7441  uni7441,  CJK UNIFIED IDEOGRAPH-7441
        0x743F, # G+3713  U+743F  uni743F,  CJK UNIFIED IDEOGRAPH-743F
        0x7459, # G+3714  U+7459  uni7459,  CJK UNIFIED IDEOGRAPH-7459
        0x745B, # G+3715  U+745B  uni745B,  CJK UNIFIED IDEOGRAPH-745B
        0xE2A3, # G+3716  U+E2A3  uniE2A3,  
        0x7576, # G+3717  U+7576  uni7576,  CJK UNIFIED IDEOGRAPH-7576
        0x7578, # G+3718  U+7578  uni7578,  CJK UNIFIED IDEOGRAPH-7578
        0x7600, # G+3719  U+7600  uni7600,  CJK UNIFIED IDEOGRAPH-7600
        0x75F0, # G+3720  U+75F0  uni75F0,  CJK UNIFIED IDEOGRAPH-75F0
        0x7601, # G+3721  U+7601  uni7601,  CJK UNIFIED IDEOGRAPH-7601
        0x75F2, # G+3722  U+75F2  uni75F2,  CJK UNIFIED IDEOGRAPH-75F2
        0x75F1, # G+3723  U+75F1  uni75F1,  CJK UNIFIED IDEOGRAPH-75F1
        0x75FA, # G+3724  U+75FA  uni75FA,  CJK UNIFIED IDEOGRAPH-75FA
        0x75FF, # G+3725  U+75FF  uni75FF,  CJK UNIFIED IDEOGRAPH-75FF
        0x75F4, # G+3726  U+75F4  uni75F4,  CJK UNIFIED IDEOGRAPH-75F4
        0x75F3, # G+3727  U+75F3  uni75F3,  CJK UNIFIED IDEOGRAPH-75F3
        0x76DE, # G+3728  U+76DE  uni76DE,  CJK UNIFIED IDEOGRAPH-76DE
        0x76DF, # G+3729  U+76DF  uni76DF,  CJK UNIFIED IDEOGRAPH-76DF
        0x775B, # G+3730  U+775B  uni775B,  CJK UNIFIED IDEOGRAPH-775B
        0x776B, # G+3731  U+776B  uni776B,  CJK UNIFIED IDEOGRAPH-776B
        0x7766, # G+3732  U+7766  uni7766,  CJK UNIFIED IDEOGRAPH-7766
        0x775E, # G+3733  U+775E  uni775E,  CJK UNIFIED IDEOGRAPH-775E
        0x7763, # G+3734  U+7763  uni7763,  CJK UNIFIED IDEOGRAPH-7763
        0x7779, # G+3735  U+7779  uni7779,  CJK UNIFIED IDEOGRAPH-7779
        0x776A, # G+3736  U+776A  uni776A,  CJK UNIFIED IDEOGRAPH-776A
        0x776C, # G+3737  U+776C  uni776C,  CJK UNIFIED IDEOGRAPH-776C
        0x775C, # G+3738  U+775C  uni775C,  CJK UNIFIED IDEOGRAPH-775C
        0x7765, # G+3739  U+7765  uni7765,  CJK UNIFIED IDEOGRAPH-7765
        0x7768, # G+3740  U+7768  uni7768,  CJK UNIFIED IDEOGRAPH-7768
        0x7762, # G+3741  U+7762  uni7762,  CJK UNIFIED IDEOGRAPH-7762
        0x77EE, # G+3742  U+77EE  uni77EE,  CJK UNIFIED IDEOGRAPH-77EE
        0x788E, # G+3743  U+788E  uni788E,  CJK UNIFIED IDEOGRAPH-788E
        0x78B0, # G+3744  U+78B0  uni78B0,  CJK UNIFIED IDEOGRAPH-78B0
        0x7897, # G+3745  U+7897  uni7897,  CJK UNIFIED IDEOGRAPH-7897
        0x7898, # G+3746  U+7898  uni7898,  CJK UNIFIED IDEOGRAPH-7898
        0x788C, # G+3747  U+788C  uni788C,  CJK UNIFIED IDEOGRAPH-788C
        0x7889, # G+3748  U+7889  uni7889,  CJK UNIFIED IDEOGRAPH-7889
        0x787C, # G+3749  U+787C  uni787C,  CJK UNIFIED IDEOGRAPH-787C
        0x7891, # G+3750  U+7891  uni7891,  CJK UNIFIED IDEOGRAPH-7891
        0x7893, # G+3751  U+7893  uni7893,  CJK UNIFIED IDEOGRAPH-7893
        0x787F, # G+3752  U+787F  uni787F,  CJK UNIFIED IDEOGRAPH-787F
        0x797A, # G+3753  U+797A  uni797A,  CJK UNIFIED IDEOGRAPH-797A
        0x797F, # G+3754  U+797F  uni797F,  CJK UNIFIED IDEOGRAPH-797F
        0x7981, # G+3755  U+7981  uni7981,  CJK UNIFIED IDEOGRAPH-7981
        0x842C, # G+3756  U+842C  uni842C,  CJK UNIFIED IDEOGRAPH-842C
        0x79BD, # G+3757  U+79BD  uni79BD,  CJK UNIFIED IDEOGRAPH-79BD
        0x7A1C, # G+3758  U+7A1C  uni7A1C,  CJK UNIFIED IDEOGRAPH-7A1C
        0x7A1A, # G+3759  U+7A1A  uni7A1A,  CJK UNIFIED IDEOGRAPH-7A1A
        0x7A20, # G+3760  U+7A20  uni7A20,  CJK UNIFIED IDEOGRAPH-7A20
        0x7A14, # G+3761  U+7A14  uni7A14,  CJK UNIFIED IDEOGRAPH-7A14
        0x7A1F, # G+3762  U+7A1F  uni7A1F,  CJK UNIFIED IDEOGRAPH-7A1F
        0x7A1E, # G+3763  U+7A1E  uni7A1E,  CJK UNIFIED IDEOGRAPH-7A1E
        0x7A9F, # G+3764  U+7A9F  uni7A9F,  CJK UNIFIED IDEOGRAPH-7A9F
        0x7AA0, # G+3765  U+7AA0  uni7AA0,  CJK UNIFIED IDEOGRAPH-7AA0
        0x7B77, # G+3766  U+7B77  uni7B77,  CJK UNIFIED IDEOGRAPH-7B77
        0x7BC0, # G+3767  U+7BC0  uni7BC0,  CJK UNIFIED IDEOGRAPH-7BC0
        0x7B60, # G+3768  U+7B60  uni7B60,  CJK UNIFIED IDEOGRAPH-7B60
        0x7B6E, # G+3769  U+7B6E  uni7B6E,  CJK UNIFIED IDEOGRAPH-7B6E
        0x7B67, # G+3770  U+7B67  uni7B67,  CJK UNIFIED IDEOGRAPH-7B67
        0x7CB1, # G+3771  U+7CB1  uni7CB1,  CJK UNIFIED IDEOGRAPH-7CB1
        0x7CB3, # G+3772  U+7CB3  uni7CB3,  CJK UNIFIED IDEOGRAPH-7CB3
        0x7CB5, # G+3773  U+7CB5  uni7CB5,  CJK UNIFIED IDEOGRAPH-7CB5
        0x7D93, # G+3774  U+7D93  uni7D93,  CJK UNIFIED IDEOGRAPH-7D93
        0x7D79, # G+3775  U+7D79  uni7D79,  CJK UNIFIED IDEOGRAPH-7D79
        0x7D91, # G+3776  U+7D91  uni7D91,  CJK UNIFIED IDEOGRAPH-7D91
        0x7D81, # G+3777  U+7D81  uni7D81,  CJK UNIFIED IDEOGRAPH-7D81
        0x7D8F, # G+3778  U+7D8F  uni7D8F,  CJK UNIFIED IDEOGRAPH-7D8F
        0x7D5B, # G+3779  U+7D5B  uni7D5B,  CJK UNIFIED IDEOGRAPH-7D5B
        0x7F6E, # G+3780  U+7F6E  uni7F6E,  CJK UNIFIED IDEOGRAPH-7F6E
        0x7F69, # G+3781  U+7F69  uni7F69,  CJK UNIFIED IDEOGRAPH-7F69
        0x7F6A, # G+3782  U+7F6A  uni7F6A,  CJK UNIFIED IDEOGRAPH-7F6A
        0x7F72, # G+3783  U+7F72  uni7F72,  CJK UNIFIED IDEOGRAPH-7F72
        0x7FA9, # G+3784  U+7FA9  uni7FA9,  CJK UNIFIED IDEOGRAPH-7FA9
        0x7FA8, # G+3785  U+7FA8  uni7FA8,  CJK UNIFIED IDEOGRAPH-7FA8
        0x7FA4, # G+3786  U+7FA4  uni7FA4,  CJK UNIFIED IDEOGRAPH-7FA4
        0x8056, # G+3787  U+8056  uni8056,  CJK UNIFIED IDEOGRAPH-8056
        0x8058, # G+3788  U+8058  uni8058,  CJK UNIFIED IDEOGRAPH-8058
        0x8086, # G+3789  U+8086  uni8086,  CJK UNIFIED IDEOGRAPH-8086
        0x8084, # G+3790  U+8084  uni8084,  CJK UNIFIED IDEOGRAPH-8084
        0x8171, # G+3791  U+8171  uni8171,  CJK UNIFIED IDEOGRAPH-8171
        0x8170, # G+3792  U+8170  uni8170,  CJK UNIFIED IDEOGRAPH-8170
        0x8178, # G+3793  U+8178  uni8178,  CJK UNIFIED IDEOGRAPH-8178
        0x8165, # G+3794  U+8165  uni8165,  CJK UNIFIED IDEOGRAPH-8165
        0x816E, # G+3795  U+816E  uni816E,  CJK UNIFIED IDEOGRAPH-816E
        0x8173, # G+3796  U+8173  uni8173,  CJK UNIFIED IDEOGRAPH-8173
        0x816B, # G+3797  U+816B  uni816B,  CJK UNIFIED IDEOGRAPH-816B
        0x8179, # G+3798  U+8179  uni8179,  CJK UNIFIED IDEOGRAPH-8179
        0x817A, # G+3799  U+817A  uni817A,  CJK UNIFIED IDEOGRAPH-817A
        0x8166, # G+3800  U+8166  uni8166,  CJK UNIFIED IDEOGRAPH-8166
        0x8205, # G+3801  U+8205  uni8205,  CJK UNIFIED IDEOGRAPH-8205
        0x8247, # G+3802  U+8247  uni8247,  CJK UNIFIED IDEOGRAPH-8247
        0x8482, # G+3803  U+8482  uni8482,  CJK UNIFIED IDEOGRAPH-8482
        0x8477, # G+3804  U+8477  uni8477,  CJK UNIFIED IDEOGRAPH-8477
        0x843D, # G+3805  U+843D  uni843D,  CJK UNIFIED IDEOGRAPH-843D
        0x8431, # G+3806  U+8431  uni8431,  CJK UNIFIED IDEOGRAPH-8431
        0x8475, # G+3807  U+8475  uni8475,  CJK UNIFIED IDEOGRAPH-8475
        0x8466, # G+3808  U+8466  uni8466,  CJK UNIFIED IDEOGRAPH-8466
        0x846B, # G+3809  U+846B  uni846B,  CJK UNIFIED IDEOGRAPH-846B
        0x8449, # G+3810  U+8449  uni8449,  CJK UNIFIED IDEOGRAPH-8449
        0x846C, # G+3811  U+846C  uni846C,  CJK UNIFIED IDEOGRAPH-846C
        0x845B, # G+3812  U+845B  uni845B,  CJK UNIFIED IDEOGRAPH-845B
        0x843C, # G+3813  U+843C  uni843C,  CJK UNIFIED IDEOGRAPH-843C
        0x8435, # G+3814  U+8435  uni8435,  CJK UNIFIED IDEOGRAPH-8435
        0x8461, # G+3815  U+8461  uni8461,  CJK UNIFIED IDEOGRAPH-8461
        0x8463, # G+3816  U+8463  uni8463,  CJK UNIFIED IDEOGRAPH-8463
        0x8469, # G+3817  U+8469  uni8469,  CJK UNIFIED IDEOGRAPH-8469
        0x846D, # G+3818  U+846D  uni846D,  CJK UNIFIED IDEOGRAPH-846D
        0x8446, # G+3819  U+8446  uni8446,  CJK UNIFIED IDEOGRAPH-8446
        0x865E, # G+3820  U+865E  uni865E,  CJK UNIFIED IDEOGRAPH-865E
        0x865C, # G+3821  U+865C  uni865C,  CJK UNIFIED IDEOGRAPH-865C
        0x865F, # G+3822  U+865F  uni865F,  CJK UNIFIED IDEOGRAPH-865F
        0x86F9, # G+3823  U+86F9  uni86F9,  CJK UNIFIED IDEOGRAPH-86F9
        0x8713, # G+3824  U+8713  uni8713,  CJK UNIFIED IDEOGRAPH-8713
        0x8708, # G+3825  U+8708  uni8708,  CJK UNIFIED IDEOGRAPH-8708
        0x8707, # G+3826  U+8707  uni8707,  CJK UNIFIED IDEOGRAPH-8707
        0x8700, # G+3827  U+8700  uni8700,  CJK UNIFIED IDEOGRAPH-8700
        0x86FE, # G+3828  U+86FE  uni86FE,  CJK UNIFIED IDEOGRAPH-86FE
        0x86FB, # G+3829  U+86FB  uni86FB,  CJK UNIFIED IDEOGRAPH-86FB
        0x8702, # G+3830  U+8702  uni8702,  CJK UNIFIED IDEOGRAPH-8702
        0x8703, # G+3831  U+8703  uni8703,  CJK UNIFIED IDEOGRAPH-8703
        0x8706, # G+3832  U+8706  uni8706,  CJK UNIFIED IDEOGRAPH-8706
        0x870A, # G+3833  U+870A  uni870A,  CJK UNIFIED IDEOGRAPH-870A
        0x8859, # G+3834  U+8859  uni8859,  CJK UNIFIED IDEOGRAPH-8859
        0x88DF, # G+3835  U+88DF  uni88DF,  CJK UNIFIED IDEOGRAPH-88DF
        0x88D4, # G+3836  U+88D4  uni88D4,  CJK UNIFIED IDEOGRAPH-88D4
        0x88D9, # G+3837  U+88D9  uni88D9,  CJK UNIFIED IDEOGRAPH-88D9
        0x88DC, # G+3838  U+88DC  uni88DC,  CJK UNIFIED IDEOGRAPH-88DC
        0x88D8, # G+3839  U+88D8  uni88D8,  CJK UNIFIED IDEOGRAPH-88D8
        0x88DD, # G+3840  U+88DD  uni88DD,  CJK UNIFIED IDEOGRAPH-88DD
        0x88E1, # G+3841  U+88E1  uni88E1,  CJK UNIFIED IDEOGRAPH-88E1
        0x88CA, # G+3842  U+88CA  uni88CA,  CJK UNIFIED IDEOGRAPH-88CA
        0x88D5, # G+3843  U+88D5  uni88D5,  CJK UNIFIED IDEOGRAPH-88D5
        0x88D2, # G+3844  U+88D2  uni88D2,  CJK UNIFIED IDEOGRAPH-88D2
        0x899C, # G+3845  U+899C  uni899C,  CJK UNIFIED IDEOGRAPH-899C
        0x89E3, # G+3846  U+89E3  uni89E3,  CJK UNIFIED IDEOGRAPH-89E3
        0x8A6B, # G+3847  U+8A6B  uni8A6B,  CJK UNIFIED IDEOGRAPH-8A6B
        0x8A72, # G+3848  U+8A72  uni8A72,  CJK UNIFIED IDEOGRAPH-8A72
        0x8A73, # G+3849  U+8A73  uni8A73,  CJK UNIFIED IDEOGRAPH-8A73
        0x8A66, # G+3850  U+8A66  uni8A66,  CJK UNIFIED IDEOGRAPH-8A66
        0x8A69, # G+3851  U+8A69  uni8A69,  CJK UNIFIED IDEOGRAPH-8A69
        0x8A70, # G+3852  U+8A70  uni8A70,  CJK UNIFIED IDEOGRAPH-8A70
        0x8A87, # G+3853  U+8A87  uni8A87,  CJK UNIFIED IDEOGRAPH-8A87
        0x8A7C, # G+3854  U+8A7C  uni8A7C,  CJK UNIFIED IDEOGRAPH-8A7C
        0x8A63, # G+3855  U+8A63  uni8A63,  CJK UNIFIED IDEOGRAPH-8A63
        0x8AA0, # G+3856  U+8AA0  uni8AA0,  CJK UNIFIED IDEOGRAPH-8AA0
        0x8A71, # G+3857  U+8A71  uni8A71,  CJK UNIFIED IDEOGRAPH-8A71
        0x8A85, # G+3858  U+8A85  uni8A85,  CJK UNIFIED IDEOGRAPH-8A85
        0x8A6D, # G+3859  U+8A6D  uni8A6D,  CJK UNIFIED IDEOGRAPH-8A6D
        0x8A62, # G+3860  U+8A62  uni8A62,  CJK UNIFIED IDEOGRAPH-8A62
        0x8A6E, # G+3861  U+8A6E  uni8A6E,  CJK UNIFIED IDEOGRAPH-8A6E
        0x8A6C, # G+3862  U+8A6C  uni8A6C,  CJK UNIFIED IDEOGRAPH-8A6C
        0x8A79, # G+3863  U+8A79  uni8A79,  CJK UNIFIED IDEOGRAPH-8A79
        0x8A7B, # G+3864  U+8A7B  uni8A7B,  CJK UNIFIED IDEOGRAPH-8A7B
        0x8A3E, # G+3865  U+8A3E  uni8A3E,  CJK UNIFIED IDEOGRAPH-8A3E
        0x8A68, # G+3866  U+8A68  uni8A68,  CJK UNIFIED IDEOGRAPH-8A68
        0x8C62, # G+3867  U+8C62  uni8C62,  CJK UNIFIED IDEOGRAPH-8C62
        0x8C8A, # G+3868  U+8C8A  uni8C8A,  CJK UNIFIED IDEOGRAPH-8C8A
        0x8C89, # G+3869  U+8C89  uni8C89,  CJK UNIFIED IDEOGRAPH-8C89
        0x8CCA, # G+3870  U+8CCA  uni8CCA,  CJK UNIFIED IDEOGRAPH-8CCA
        0x8CC7, # G+3871  U+8CC7  uni8CC7,  CJK UNIFIED IDEOGRAPH-8CC7
        0x8CC8, # G+3872  U+8CC8  uni8CC8,  CJK UNIFIED IDEOGRAPH-8CC8
        0x8CC4, # G+3873  U+8CC4  uni8CC4,  CJK UNIFIED IDEOGRAPH-8CC4
        0x8CB2, # G+3874  U+8CB2  uni8CB2,  CJK UNIFIED IDEOGRAPH-8CB2
        0x8CC3, # G+3875  U+8CC3  uni8CC3,  CJK UNIFIED IDEOGRAPH-8CC3
        0x8CC2, # G+3876  U+8CC2  uni8CC2,  CJK UNIFIED IDEOGRAPH-8CC2
        0x8CC5, # G+3877  U+8CC5  uni8CC5,  CJK UNIFIED IDEOGRAPH-8CC5
        0x8DE1, # G+3878  U+8DE1  uni8DE1,  CJK UNIFIED IDEOGRAPH-8DE1
        0x8DDF, # G+3879  U+8DDF  uni8DDF,  CJK UNIFIED IDEOGRAPH-8DDF
        0x8DE8, # G+3880  U+8DE8  uni8DE8,  CJK UNIFIED IDEOGRAPH-8DE8
        0x8DEF, # G+3881  U+8DEF  uni8DEF,  CJK UNIFIED IDEOGRAPH-8DEF
        0x8DF3, # G+3882  U+8DF3  uni8DF3,  CJK UNIFIED IDEOGRAPH-8DF3
        0x8DFA, # G+3883  U+8DFA  uni8DFA,  CJK UNIFIED IDEOGRAPH-8DFA
        0x8DEA, # G+3884  U+8DEA  uni8DEA,  CJK UNIFIED IDEOGRAPH-8DEA
        0x8DE4, # G+3885  U+8DE4  uni8DE4,  CJK UNIFIED IDEOGRAPH-8DE4
        0x8DE6, # G+3886  U+8DE6  uni8DE6,  CJK UNIFIED IDEOGRAPH-8DE6
        0x8EB2, # G+3887  U+8EB2  uni8EB2,  CJK UNIFIED IDEOGRAPH-8EB2
        0x8F03, # G+3888  U+8F03  uni8F03,  CJK UNIFIED IDEOGRAPH-8F03
        0x8F09, # G+3889  U+8F09  uni8F09,  CJK UNIFIED IDEOGRAPH-8F09
        0x8EFE, # G+3890  U+8EFE  uni8EFE,  CJK UNIFIED IDEOGRAPH-8EFE
        0x8F0A, # G+3891  U+8F0A  uni8F0A,  CJK UNIFIED IDEOGRAPH-8F0A
        0x8F9F, # G+3892  U+8F9F  uni8F9F,  CJK UNIFIED IDEOGRAPH-8F9F
        0x8FB2, # G+3893  U+8FB2  uni8FB2,  CJK UNIFIED IDEOGRAPH-8FB2
        0x904B, # G+3894  U+904B  uni904B,  CJK UNIFIED IDEOGRAPH-904B
        0x904A, # G+3895  U+904A  uni904A,  CJK UNIFIED IDEOGRAPH-904A
        0x9053, # G+3896  U+9053  uni9053,  CJK UNIFIED IDEOGRAPH-9053
        0x9042, # G+3897  U+9042  uni9042,  CJK UNIFIED IDEOGRAPH-9042
        0x9054, # G+3898  U+9054  uni9054,  CJK UNIFIED IDEOGRAPH-9054
        0x903C, # G+3899  U+903C  uni903C,  CJK UNIFIED IDEOGRAPH-903C
        0x9055, # G+3900  U+9055  uni9055,  CJK UNIFIED IDEOGRAPH-9055
        0x9050, # G+3901  U+9050  uni9050,  CJK UNIFIED IDEOGRAPH-9050
        0x9047, # G+3902  U+9047  uni9047,  CJK UNIFIED IDEOGRAPH-9047
        0x904F, # G+3903  U+904F  uni904F,  CJK UNIFIED IDEOGRAPH-904F
        0x904E, # G+3904  U+904E  uni904E,  CJK UNIFIED IDEOGRAPH-904E
        0x904D, # G+3905  U+904D  uni904D,  CJK UNIFIED IDEOGRAPH-904D
        0x9051, # G+3906  U+9051  uni9051,  CJK UNIFIED IDEOGRAPH-9051
        0x903E, # G+3907  U+903E  uni903E,  CJK UNIFIED IDEOGRAPH-903E
        0x9041, # G+3908  U+9041  uni9041,  CJK UNIFIED IDEOGRAPH-9041
        0x9112, # G+3909  U+9112  uni9112,  CJK UNIFIED IDEOGRAPH-9112
        0x9117, # G+3910  U+9117  uni9117,  CJK UNIFIED IDEOGRAPH-9117
        0x916C, # G+3911  U+916C  uni916C,  CJK UNIFIED IDEOGRAPH-916C
        0x916A, # G+3912  U+916A  uni916A,  CJK UNIFIED IDEOGRAPH-916A
        0x9169, # G+3913  U+9169  uni9169,  CJK UNIFIED IDEOGRAPH-9169
        0x91C9, # G+3914  U+91C9  uni91C9,  CJK UNIFIED IDEOGRAPH-91C9
        0x9237, # G+3915  U+9237  uni9237,  CJK UNIFIED IDEOGRAPH-9237
        0x9257, # G+3916  U+9257  uni9257,  CJK UNIFIED IDEOGRAPH-9257
        0x9238, # G+3917  U+9238  uni9238,  CJK UNIFIED IDEOGRAPH-9238
        0x923D, # G+3918  U+923D  uni923D,  CJK UNIFIED IDEOGRAPH-923D
        0x9240, # G+3919  U+9240  uni9240,  CJK UNIFIED IDEOGRAPH-9240
        0x923E, # G+3920  U+923E  uni923E,  CJK UNIFIED IDEOGRAPH-923E
        0x925B, # G+3921  U+925B  uni925B,  CJK UNIFIED IDEOGRAPH-925B
        0x924B, # G+3922  U+924B  uni924B,  CJK UNIFIED IDEOGRAPH-924B
        0x9264, # G+3923  U+9264  uni9264,  CJK UNIFIED IDEOGRAPH-9264
        0x9251, # G+3924  U+9251  uni9251,  CJK UNIFIED IDEOGRAPH-9251
        0x9234, # G+3925  U+9234  uni9234,  CJK UNIFIED IDEOGRAPH-9234
        0x9249, # G+3926  U+9249  uni9249,  CJK UNIFIED IDEOGRAPH-9249
        0x924D, # G+3927  U+924D  uni924D,  CJK UNIFIED IDEOGRAPH-924D
        0x9245, # G+3928  U+9245  uni9245,  CJK UNIFIED IDEOGRAPH-9245
        0x9239, # G+3929  U+9239  uni9239,  CJK UNIFIED IDEOGRAPH-9239
        0x923F, # G+3930  U+923F  uni923F,  CJK UNIFIED IDEOGRAPH-923F
        0x925A, # G+3931  U+925A  uni925A,  CJK UNIFIED IDEOGRAPH-925A
        0x9598, # G+3932  U+9598  uni9598,  CJK UNIFIED IDEOGRAPH-9598
        0x9698, # G+3933  U+9698  uni9698,  CJK UNIFIED IDEOGRAPH-9698
        0x9694, # G+3934  U+9694  uni9694,  CJK UNIFIED IDEOGRAPH-9694
        0x9695, # G+3935  U+9695  uni9695,  CJK UNIFIED IDEOGRAPH-9695
        0x96CD, # G+3936  U+96CD  uni96CD,  CJK UNIFIED IDEOGRAPH-96CD
        0x96CB, # G+3937  U+96CB  uni96CB,  CJK UNIFIED IDEOGRAPH-96CB
        0x96C9, # G+3938  U+96C9  uni96C9,  CJK UNIFIED IDEOGRAPH-96C9
        0x96CA, # G+3939  U+96CA  uni96CA,  CJK UNIFIED IDEOGRAPH-96CA
        0x96F7, # G+3940  U+96F7  uni96F7,  CJK UNIFIED IDEOGRAPH-96F7
        0x96FB, # G+3941  U+96FB  uni96FB,  CJK UNIFIED IDEOGRAPH-96FB
        0x96F9, # G+3942  U+96F9  uni96F9,  CJK UNIFIED IDEOGRAPH-96F9
        0x96F6, # G+3943  U+96F6  uni96F6,  CJK UNIFIED IDEOGRAPH-96F6
        0x9756, # G+3944  U+9756  uni9756,  CJK UNIFIED IDEOGRAPH-9756
        0x9774, # G+3945  U+9774  uni9774,  CJK UNIFIED IDEOGRAPH-9774
        0x9776, # G+3946  U+9776  uni9776,  CJK UNIFIED IDEOGRAPH-9776
        0x9810, # G+3947  U+9810  uni9810,  CJK UNIFIED IDEOGRAPH-9810
        0x9811, # G+3948  U+9811  uni9811,  CJK UNIFIED IDEOGRAPH-9811
        0x9813, # G+3949  U+9813  uni9813,  CJK UNIFIED IDEOGRAPH-9813
        0x980A, # G+3950  U+980A  uni980A,  CJK UNIFIED IDEOGRAPH-980A
        0x9812, # G+3951  U+9812  uni9812,  CJK UNIFIED IDEOGRAPH-9812
        0x980C, # G+3952  U+980C  uni980C,  CJK UNIFIED IDEOGRAPH-980C
        0x98FC, # G+3953  U+98FC  uni98FC,  CJK UNIFIED IDEOGRAPH-98FC
        0x98F4, # G+3954  U+98F4  uni98F4,  CJK UNIFIED IDEOGRAPH-98F4
        0x98FD, # G+3955  U+98FD  uni98FD,  CJK UNIFIED IDEOGRAPH-98FD
        0x98FE, # G+3956  U+98FE  uni98FE,  CJK UNIFIED IDEOGRAPH-98FE
        0x99B3, # G+3957  U+99B3  uni99B3,  CJK UNIFIED IDEOGRAPH-99B3
        0x99B1, # G+3958  U+99B1  uni99B1,  CJK UNIFIED IDEOGRAPH-99B1
        0x99B4, # G+3959  U+99B4  uni99B4,  CJK UNIFIED IDEOGRAPH-99B4
        0x9AE1, # G+3960  U+9AE1  uni9AE1,  CJK UNIFIED IDEOGRAPH-9AE1
        0x9CE9, # G+3961  U+9CE9  uni9CE9,  CJK UNIFIED IDEOGRAPH-9CE9
        0x9E82, # G+3962  U+9E82  uni9E82,  CJK UNIFIED IDEOGRAPH-9E82
        0x9F0E, # G+3963  U+9F0E  uni9F0E,  CJK UNIFIED IDEOGRAPH-9F0E
        0x9F13, # G+3964  U+9F13  uni9F13,  CJK UNIFIED IDEOGRAPH-9F13
        0x9F20, # G+3965  U+9F20  uni9F20,  CJK UNIFIED IDEOGRAPH-9F20
        0x50E7, # G+3966  U+50E7  uni50E7,  CJK UNIFIED IDEOGRAPH-50E7
        0x50EE, # G+3967  U+50EE  uni50EE,  CJK UNIFIED IDEOGRAPH-50EE
        0x50E5, # G+3968  U+50E5  uni50E5,  CJK UNIFIED IDEOGRAPH-50E5
        0x50D6, # G+3969  U+50D6  uni50D6,  CJK UNIFIED IDEOGRAPH-50D6
        0x50ED, # G+3970  U+50ED  uni50ED,  CJK UNIFIED IDEOGRAPH-50ED
        0x50DA, # G+3971  U+50DA  uni50DA,  CJK UNIFIED IDEOGRAPH-50DA
        0x50D5, # G+3972  U+50D5  uni50D5,  CJK UNIFIED IDEOGRAPH-50D5
        0x50CF, # G+3973  U+50CF  uni50CF,  CJK UNIFIED IDEOGRAPH-50CF
        0x50D1, # G+3974  U+50D1  uni50D1,  CJK UNIFIED IDEOGRAPH-50D1
        0x50F1, # G+3975  U+50F1  uni50F1,  CJK UNIFIED IDEOGRAPH-50F1
        0x50CE, # G+3976  U+50CE  uni50CE,  CJK UNIFIED IDEOGRAPH-50CE
        0x50E9, # G+3977  U+50E9  uni50E9,  CJK UNIFIED IDEOGRAPH-50E9
        0x5162, # G+3978  U+5162  uni5162,  CJK UNIFIED IDEOGRAPH-5162
        0x51F3, # G+3979  U+51F3  uni51F3,  CJK UNIFIED IDEOGRAPH-51F3
        0x5283, # G+3980  U+5283  uni5283,  CJK UNIFIED IDEOGRAPH-5283
        0x5282, # G+3981  U+5282  uni5282,  CJK UNIFIED IDEOGRAPH-5282
        0x5331, # G+3982  U+5331  uni5331,  CJK UNIFIED IDEOGRAPH-5331
        0x53AD, # G+3983  U+53AD  uni53AD,  CJK UNIFIED IDEOGRAPH-53AD
        0x55FE, # G+3984  U+55FE  uni55FE,  CJK UNIFIED IDEOGRAPH-55FE
        0x5600, # G+3985  U+5600  uni5600,  CJK UNIFIED IDEOGRAPH-5600
        0x561B, # G+3986  U+561B  uni561B,  CJK UNIFIED IDEOGRAPH-561B
        0x5617, # G+3987  U+5617  uni5617,  CJK UNIFIED IDEOGRAPH-5617
        0x55FD, # G+3988  U+55FD  uni55FD,  CJK UNIFIED IDEOGRAPH-55FD
        0x5614, # G+3989  U+5614  uni5614,  CJK UNIFIED IDEOGRAPH-5614
        0x5606, # G+3990  U+5606  uni5606,  CJK UNIFIED IDEOGRAPH-5606
        0x5609, # G+3991  U+5609  uni5609,  CJK UNIFIED IDEOGRAPH-5609
        0x560D, # G+3992  U+560D  uni560D,  CJK UNIFIED IDEOGRAPH-560D
        0x560E, # G+3993  U+560E  uni560E,  CJK UNIFIED IDEOGRAPH-560E
        0x55F7, # G+3994  U+55F7  uni55F7,  CJK UNIFIED IDEOGRAPH-55F7
        0x5616, # G+3995  U+5616  uni5616,  CJK UNIFIED IDEOGRAPH-5616
        0x561F, # G+3996  U+561F  uni561F,  CJK UNIFIED IDEOGRAPH-561F
        0x5608, # G+3997  U+5608  uni5608,  CJK UNIFIED IDEOGRAPH-5608
        0x5610, # G+3998  U+5610  uni5610,  CJK UNIFIED IDEOGRAPH-5610
        0x55F6, # G+3999  U+55F6  uni55F6,  CJK UNIFIED IDEOGRAPH-55F6
        0x5718, # G+4000  U+5718  uni5718,  CJK UNIFIED IDEOGRAPH-5718
        0x5716, # G+4001  U+5716  uni5716,  CJK UNIFIED IDEOGRAPH-5716
        0x5875, # G+4002  U+5875  uni5875,  CJK UNIFIED IDEOGRAPH-5875
        0x587E, # G+4003  U+587E  uni587E,  CJK UNIFIED IDEOGRAPH-587E
        0x5883, # G+4004  U+5883  uni5883,  CJK UNIFIED IDEOGRAPH-5883
        0x5893, # G+4005  U+5893  uni5893,  CJK UNIFIED IDEOGRAPH-5893
        0x588A, # G+4006  U+588A  uni588A,  CJK UNIFIED IDEOGRAPH-588A
        0x5879, # G+4007  U+5879  uni5879,  CJK UNIFIED IDEOGRAPH-5879
        0x5885, # G+4008  U+5885  uni5885,  CJK UNIFIED IDEOGRAPH-5885
        0x587D, # G+4009  U+587D  uni587D,  CJK UNIFIED IDEOGRAPH-587D
        0x58FD, # G+4010  U+58FD  uni58FD,  CJK UNIFIED IDEOGRAPH-58FD
        0x5925, # G+4011  U+5925  uni5925,  CJK UNIFIED IDEOGRAPH-5925
        0x5922, # G+4012  U+5922  uni5922,  CJK UNIFIED IDEOGRAPH-5922
        0x5924, # G+4013  U+5924  uni5924,  CJK UNIFIED IDEOGRAPH-5924
        0x596A, # G+4014  U+596A  uni596A,  CJK UNIFIED IDEOGRAPH-596A
        0x5969, # G+4015  U+5969  uni5969,  CJK UNIFIED IDEOGRAPH-5969
        0x5AE1, # G+4016  U+5AE1  uni5AE1,  CJK UNIFIED IDEOGRAPH-5AE1
        0x5AE6, # G+4017  U+5AE6  uni5AE6,  CJK UNIFIED IDEOGRAPH-5AE6
        0x5AE9, # G+4018  U+5AE9  uni5AE9,  CJK UNIFIED IDEOGRAPH-5AE9
        0x5AD7, # G+4019  U+5AD7  uni5AD7,  CJK UNIFIED IDEOGRAPH-5AD7
        0x5AD6, # G+4020  U+5AD6  uni5AD6,  CJK UNIFIED IDEOGRAPH-5AD6
        0x5AD8, # G+4021  U+5AD8  uni5AD8,  CJK UNIFIED IDEOGRAPH-5AD8
        0x5AE3, # G+4022  U+5AE3  uni5AE3,  CJK UNIFIED IDEOGRAPH-5AE3
        0x5B75, # G+4023  U+5B75  uni5B75,  CJK UNIFIED IDEOGRAPH-5B75
        0x5BDE, # G+4024  U+5BDE  uni5BDE,  CJK UNIFIED IDEOGRAPH-5BDE
        0x5BE7, # G+4025  U+5BE7  uni5BE7,  CJK UNIFIED IDEOGRAPH-5BE7
        0x5BE1, # G+4026  U+5BE1  uni5BE1,  CJK UNIFIED IDEOGRAPH-5BE1
        0x5BE5, # G+4027  U+5BE5  uni5BE5,  CJK UNIFIED IDEOGRAPH-5BE5
        0x5BE6, # G+4028  U+5BE6  uni5BE6,  CJK UNIFIED IDEOGRAPH-5BE6
        0x5BE8, # G+4029  U+5BE8  uni5BE8,  CJK UNIFIED IDEOGRAPH-5BE8
        0x5BE2, # G+4030  U+5BE2  uni5BE2,  CJK UNIFIED IDEOGRAPH-5BE2
        0x5BE4, # G+4031  U+5BE4  uni5BE4,  CJK UNIFIED IDEOGRAPH-5BE4
        0x5BDF, # G+4032  U+5BDF  uni5BDF,  CJK UNIFIED IDEOGRAPH-5BDF
        0x5C0D, # G+4033  U+5C0D  uni5C0D,  CJK UNIFIED IDEOGRAPH-5C0D
        0x5C62, # G+4034  U+5C62  uni5C62,  CJK UNIFIED IDEOGRAPH-5C62
        0x5D84, # G+4035  U+5D84  uni5D84,  CJK UNIFIED IDEOGRAPH-5D84
        0x5D87, # G+4036  U+5D87  uni5D87,  CJK UNIFIED IDEOGRAPH-5D87
        0x5E5B, # G+4037  U+5E5B  uni5E5B,  CJK UNIFIED IDEOGRAPH-5E5B
        0x5E63, # G+4038  U+5E63  uni5E63,  CJK UNIFIED IDEOGRAPH-5E63
        0x5E55, # G+4039  U+5E55  uni5E55,  CJK UNIFIED IDEOGRAPH-5E55
        0x5E57, # G+4040  U+5E57  uni5E57,  CJK UNIFIED IDEOGRAPH-5E57
        0x5E54, # G+4041  U+5E54  uni5E54,  CJK UNIFIED IDEOGRAPH-5E54
        0x5ED3, # G+4042  U+5ED3  uni5ED3,  CJK UNIFIED IDEOGRAPH-5ED3
        0x5ED6, # G+4043  U+5ED6  uni5ED6,  CJK UNIFIED IDEOGRAPH-5ED6
        0x5F0A, # G+4044  U+5F0A  uni5F0A,  CJK UNIFIED IDEOGRAPH-5F0A
        0x5F46, # G+4045  U+5F46  uni5F46,  CJK UNIFIED IDEOGRAPH-5F46
        0x5F70, # G+4046  U+5F70  uni5F70,  CJK UNIFIED IDEOGRAPH-5F70
        0x5FB9, # G+4047  U+5FB9  uni5FB9,  CJK UNIFIED IDEOGRAPH-5FB9
        0x6147, # G+4048  U+6147  uni6147,  CJK UNIFIED IDEOGRAPH-6147
        0x613F, # G+4049  U+613F  uni613F,  CJK UNIFIED IDEOGRAPH-613F
        0x614B, # G+4050  U+614B  uni614B,  CJK UNIFIED IDEOGRAPH-614B
        0x6177, # G+4051  U+6177  uni6177,  CJK UNIFIED IDEOGRAPH-6177
        0x6162, # G+4052  U+6162  uni6162,  CJK UNIFIED IDEOGRAPH-6162
        0x6163, # G+4053  U+6163  uni6163,  CJK UNIFIED IDEOGRAPH-6163
        0x615F, # G+4054  U+615F  uni615F,  CJK UNIFIED IDEOGRAPH-615F
        0x615A, # G+4055  U+615A  uni615A,  CJK UNIFIED IDEOGRAPH-615A
        0x6158, # G+4056  U+6158  uni6158,  CJK UNIFIED IDEOGRAPH-6158
        0x6175, # G+4057  U+6175  uni6175,  CJK UNIFIED IDEOGRAPH-6175
        0x622A, # G+4058  U+622A  uni622A,  CJK UNIFIED IDEOGRAPH-622A
        0x6487, # G+4059  U+6487  uni6487,  CJK UNIFIED IDEOGRAPH-6487
        0x6458, # G+4060  U+6458  uni6458,  CJK UNIFIED IDEOGRAPH-6458
        0x6454, # G+4061  U+6454  uni6454,  CJK UNIFIED IDEOGRAPH-6454
        0x64A4, # G+4062  U+64A4  uni64A4,  CJK UNIFIED IDEOGRAPH-64A4
        0x6478, # G+4063  U+6478  uni6478,  CJK UNIFIED IDEOGRAPH-6478
        0x645F, # G+4064  U+645F  uni645F,  CJK UNIFIED IDEOGRAPH-645F
        0x647A, # G+4065  U+647A  uni647A,  CJK UNIFIED IDEOGRAPH-647A
        0x6451, # G+4066  U+6451  uni6451,  CJK UNIFIED IDEOGRAPH-6451
        0x6467, # G+4067  U+6467  uni6467,  CJK UNIFIED IDEOGRAPH-6467
        0x6434, # G+4068  U+6434  uni6434,  CJK UNIFIED IDEOGRAPH-6434
        0x646D, # G+4069  U+646D  uni646D,  CJK UNIFIED IDEOGRAPH-646D
        0x647B, # G+4070  U+647B  uni647B,  CJK UNIFIED IDEOGRAPH-647B
        0x6572, # G+4071  U+6572  uni6572,  CJK UNIFIED IDEOGRAPH-6572
        0x65A1, # G+4072  U+65A1  uni65A1,  CJK UNIFIED IDEOGRAPH-65A1
        0x65D7, # G+4073  U+65D7  uni65D7,  CJK UNIFIED IDEOGRAPH-65D7
        0x65D6, # G+4074  U+65D6  uni65D6,  CJK UNIFIED IDEOGRAPH-65D6
        0x66A2, # G+4075  U+66A2  uni66A2,  CJK UNIFIED IDEOGRAPH-66A2
        0x66A8, # G+4076  U+66A8  uni66A8,  CJK UNIFIED IDEOGRAPH-66A8
        0x669D, # G+4077  U+669D  uni669D,  CJK UNIFIED IDEOGRAPH-669D
        0x699C, # G+4078  U+699C  uni699C,  CJK UNIFIED IDEOGRAPH-699C
        0x69A8, # G+4079  U+69A8  uni69A8,  CJK UNIFIED IDEOGRAPH-69A8
        0x6995, # G+4080  U+6995  uni6995,  CJK UNIFIED IDEOGRAPH-6995
        0x69C1, # G+4081  U+69C1  uni69C1,  CJK UNIFIED IDEOGRAPH-69C1
        0x69AE, # G+4082  U+69AE  uni69AE,  CJK UNIFIED IDEOGRAPH-69AE
        0x69D3, # G+4083  U+69D3  uni69D3,  CJK UNIFIED IDEOGRAPH-69D3
        0x69CB, # G+4084  U+69CB  uni69CB,  CJK UNIFIED IDEOGRAPH-69CB
        0x699B, # G+4085  U+699B  uni699B,  CJK UNIFIED IDEOGRAPH-699B
        0x69B7, # G+4086  U+69B7  uni69B7,  CJK UNIFIED IDEOGRAPH-69B7
        0x69BB, # G+4087  U+69BB  uni69BB,  CJK UNIFIED IDEOGRAPH-69BB
        0x69AB, # G+4088  U+69AB  uni69AB,  CJK UNIFIED IDEOGRAPH-69AB
        0x69B4, # G+4089  U+69B4  uni69B4,  CJK UNIFIED IDEOGRAPH-69B4
        0x69D0, # G+4090  U+69D0  uni69D0,  CJK UNIFIED IDEOGRAPH-69D0
        0x69CD, # G+4091  U+69CD  uni69CD,  CJK UNIFIED IDEOGRAPH-69CD
        0x69AD, # G+4092  U+69AD  uni69AD,  CJK UNIFIED IDEOGRAPH-69AD
        0x69CC, # G+4093  U+69CC  uni69CC,  CJK UNIFIED IDEOGRAPH-69CC
        0x69A6, # G+4094  U+69A6  uni69A6,  CJK UNIFIED IDEOGRAPH-69A6
        0x69C3, # G+4095  U+69C3  uni69C3,  CJK UNIFIED IDEOGRAPH-69C3
        0x69A3, # G+4096  U+69A3  uni69A3,  CJK UNIFIED IDEOGRAPH-69A3
        0x6B49, # G+4097  U+6B49  uni6B49,  CJK UNIFIED IDEOGRAPH-6B49
        0x6B4C, # G+4098  U+6B4C  uni6B4C,  CJK UNIFIED IDEOGRAPH-6B4C
        0x6C33, # G+4099  U+6C33  uni6C33,  CJK UNIFIED IDEOGRAPH-6C33
        0x6F33, # G+4100  U+6F33  uni6F33,  CJK UNIFIED IDEOGRAPH-6F33
        0x6F14, # G+4101  U+6F14  uni6F14,  CJK UNIFIED IDEOGRAPH-6F14
        0x6EFE, # G+4102  U+6EFE  uni6EFE,  CJK UNIFIED IDEOGRAPH-6EFE
        0x6F13, # G+4103  U+6F13  uni6F13,  CJK UNIFIED IDEOGRAPH-6F13
        0x6EF4, # G+4104  U+6EF4  uni6EF4,  CJK UNIFIED IDEOGRAPH-6EF4
        0x6F29, # G+4105  U+6F29  uni6F29,  CJK UNIFIED IDEOGRAPH-6F29
        0x6F3E, # G+4106  U+6F3E  uni6F3E,  CJK UNIFIED IDEOGRAPH-6F3E
        0x6F20, # G+4107  U+6F20  uni6F20,  CJK UNIFIED IDEOGRAPH-6F20
        0x6F2C, # G+4108  U+6F2C  uni6F2C,  CJK UNIFIED IDEOGRAPH-6F2C
        0x6F0F, # G+4109  U+6F0F  uni6F0F,  CJK UNIFIED IDEOGRAPH-6F0F
        0x6F02, # G+4110  U+6F02  uni6F02,  CJK UNIFIED IDEOGRAPH-6F02
        0x6F22, # G+4111  U+6F22  uni6F22,  CJK UNIFIED IDEOGRAPH-6F22
        0x6EFF, # G+4112  U+6EFF  uni6EFF,  CJK UNIFIED IDEOGRAPH-6EFF
        0x6EEF, # G+4113  U+6EEF  uni6EEF,  CJK UNIFIED IDEOGRAPH-6EEF
        0x6F06, # G+4114  U+6F06  uni6F06,  CJK UNIFIED IDEOGRAPH-6F06
        0x6F31, # G+4115  U+6F31  uni6F31,  CJK UNIFIED IDEOGRAPH-6F31
        0x6F38, # G+4116  U+6F38  uni6F38,  CJK UNIFIED IDEOGRAPH-6F38
        0x6F32, # G+4117  U+6F32  uni6F32,  CJK UNIFIED IDEOGRAPH-6F32
        0x6F23, # G+4118  U+6F23  uni6F23,  CJK UNIFIED IDEOGRAPH-6F23
        0x6F15, # G+4119  U+6F15  uni6F15,  CJK UNIFIED IDEOGRAPH-6F15
        0x6F2B, # G+4120  U+6F2B  uni6F2B,  CJK UNIFIED IDEOGRAPH-6F2B
        0x6F2F, # G+4121  U+6F2F  uni6F2F,  CJK UNIFIED IDEOGRAPH-6F2F
        0x6F88, # G+4122  U+6F88  uni6F88,  CJK UNIFIED IDEOGRAPH-6F88
        0x6F2A, # G+4123  U+6F2A  uni6F2A,  CJK UNIFIED IDEOGRAPH-6F2A
        0x6EEC, # G+4124  U+6EEC  uni6EEC,  CJK UNIFIED IDEOGRAPH-6EEC
        0x6F01, # G+4125  U+6F01  uni6F01,  CJK UNIFIED IDEOGRAPH-6F01
        0x6EF2, # G+4126  U+6EF2  uni6EF2,  CJK UNIFIED IDEOGRAPH-6EF2
        0x6ECC, # G+4127  U+6ECC  uni6ECC,  CJK UNIFIED IDEOGRAPH-6ECC
        0x6EF7, # G+4128  U+6EF7  uni6EF7,  CJK UNIFIED IDEOGRAPH-6EF7
        0x7194, # G+4129  U+7194  uni7194,  CJK UNIFIED IDEOGRAPH-7194
        0x7199, # G+4130  U+7199  uni7199,  CJK UNIFIED IDEOGRAPH-7199
        0x717D, # G+4131  U+717D  uni717D,  CJK UNIFIED IDEOGRAPH-717D
        0x718A, # G+4132  U+718A  uni718A,  CJK UNIFIED IDEOGRAPH-718A
        0x7184, # G+4133  U+7184  uni7184,  CJK UNIFIED IDEOGRAPH-7184
        0x7192, # G+4134  U+7192  uni7192,  CJK UNIFIED IDEOGRAPH-7192
        0x723E, # G+4135  U+723E  uni723E,  CJK UNIFIED IDEOGRAPH-723E
        0x7292, # G+4136  U+7292  uni7292,  CJK UNIFIED IDEOGRAPH-7292
        0x7296, # G+4137  U+7296  uni7296,  CJK UNIFIED IDEOGRAPH-7296
        0x7344, # G+4138  U+7344  uni7344,  CJK UNIFIED IDEOGRAPH-7344
        0x7350, # G+4139  U+7350  uni7350,  CJK UNIFIED IDEOGRAPH-7350
        0x7464, # G+4140  U+7464  uni7464,  CJK UNIFIED IDEOGRAPH-7464
        0x7463, # G+4141  U+7463  uni7463,  CJK UNIFIED IDEOGRAPH-7463
        0x746A, # G+4142  U+746A  uni746A,  CJK UNIFIED IDEOGRAPH-746A
        0x7470, # G+4143  U+7470  uni7470,  CJK UNIFIED IDEOGRAPH-7470
        0x746D, # G+4144  U+746D  uni746D,  CJK UNIFIED IDEOGRAPH-746D
        0x7504, # G+4145  U+7504  uni7504,  CJK UNIFIED IDEOGRAPH-7504
        0x7591, # G+4146  U+7591  uni7591,  CJK UNIFIED IDEOGRAPH-7591
        0x7627, # G+4147  U+7627  uni7627,  CJK UNIFIED IDEOGRAPH-7627
        0x760D, # G+4148  U+760D  uni760D,  CJK UNIFIED IDEOGRAPH-760D
        0x760B, # G+4149  U+760B  uni760B,  CJK UNIFIED IDEOGRAPH-760B
        0x7609, # G+4150  U+7609  uni7609,  CJK UNIFIED IDEOGRAPH-7609
        0x7613, # G+4151  U+7613  uni7613,  CJK UNIFIED IDEOGRAPH-7613
        0x76E1, # G+4152  U+76E1  uni76E1,  CJK UNIFIED IDEOGRAPH-76E1
        0x76E3, # G+4153  U+76E3  uni76E3,  CJK UNIFIED IDEOGRAPH-76E3
        0x7784, # G+4154  U+7784  uni7784,  CJK UNIFIED IDEOGRAPH-7784
        0x777D, # G+4155  U+777D  uni777D,  CJK UNIFIED IDEOGRAPH-777D
        0x777F, # G+4156  U+777F  uni777F,  CJK UNIFIED IDEOGRAPH-777F
        0x7761, # G+4157  U+7761  uni7761,  CJK UNIFIED IDEOGRAPH-7761
        0x78C1, # G+4158  U+78C1  uni78C1,  CJK UNIFIED IDEOGRAPH-78C1
        0x789F, # G+4159  U+789F  uni789F,  CJK UNIFIED IDEOGRAPH-789F
        0x78A7, # G+4160  U+78A7  uni78A7,  CJK UNIFIED IDEOGRAPH-78A7
        0x78B3, # G+4161  U+78B3  uni78B3,  CJK UNIFIED IDEOGRAPH-78B3
        0x78A9, # G+4162  U+78A9  uni78A9,  CJK UNIFIED IDEOGRAPH-78A9
        0x78A3, # G+4163  U+78A3  uni78A3,  CJK UNIFIED IDEOGRAPH-78A3
        0x798E, # G+4164  U+798E  uni798E,  CJK UNIFIED IDEOGRAPH-798E
        0x798F, # G+4165  U+798F  uni798F,  CJK UNIFIED IDEOGRAPH-798F
        0x798D, # G+4166  U+798D  uni798D,  CJK UNIFIED IDEOGRAPH-798D
        0x7A2E, # G+4167  U+7A2E  uni7A2E,  CJK UNIFIED IDEOGRAPH-7A2E
        0x7A31, # G+4168  U+7A31  uni7A31,  CJK UNIFIED IDEOGRAPH-7A31
        0x7AAA, # G+4169  U+7AAA  uni7AAA,  CJK UNIFIED IDEOGRAPH-7AAA
        0x7AA9, # G+4170  U+7AA9  uni7AA9,  CJK UNIFIED IDEOGRAPH-7AA9
        0x7AED, # G+4171  U+7AED  uni7AED,  CJK UNIFIED IDEOGRAPH-7AED
        0x7AEF, # G+4172  U+7AEF  uni7AEF,  CJK UNIFIED IDEOGRAPH-7AEF
        0x7BA1, # G+4173  U+7BA1  uni7BA1,  CJK UNIFIED IDEOGRAPH-7BA1
        0x7B95, # G+4174  U+7B95  uni7B95,  CJK UNIFIED IDEOGRAPH-7B95
        0x7B8B, # G+4175  U+7B8B  uni7B8B,  CJK UNIFIED IDEOGRAPH-7B8B
        0x7B75, # G+4176  U+7B75  uni7B75,  CJK UNIFIED IDEOGRAPH-7B75
        0x7B97, # G+4177  U+7B97  uni7B97,  CJK UNIFIED IDEOGRAPH-7B97
        0x7B9D, # G+4178  U+7B9D  uni7B9D,  CJK UNIFIED IDEOGRAPH-7B9D
        0x7B94, # G+4179  U+7B94  uni7B94,  CJK UNIFIED IDEOGRAPH-7B94
        0x7B8F, # G+4180  U+7B8F  uni7B8F,  CJK UNIFIED IDEOGRAPH-7B8F
        0x7BB8, # G+4181  U+7BB8  uni7BB8,  CJK UNIFIED IDEOGRAPH-7BB8
        0x7B87, # G+4182  U+7B87  uni7B87,  CJK UNIFIED IDEOGRAPH-7B87
        0x7B84, # G+4183  U+7B84  uni7B84,  CJK UNIFIED IDEOGRAPH-7B84
        0x7CB9, # G+4184  U+7CB9  uni7CB9,  CJK UNIFIED IDEOGRAPH-7CB9
        0x7CBD, # G+4185  U+7CBD  uni7CBD,  CJK UNIFIED IDEOGRAPH-7CBD
        0x7CBE, # G+4186  U+7CBE  uni7CBE,  CJK UNIFIED IDEOGRAPH-7CBE
        0x7DBB, # G+4187  U+7DBB  uni7DBB,  CJK UNIFIED IDEOGRAPH-7DBB
        0x7DB0, # G+4188  U+7DB0  uni7DB0,  CJK UNIFIED IDEOGRAPH-7DB0
        0x7D9C, # G+4189  U+7D9C  uni7D9C,  CJK UNIFIED IDEOGRAPH-7D9C
        0x7DBD, # G+4190  U+7DBD  uni7DBD,  CJK UNIFIED IDEOGRAPH-7DBD
        0x7DBE, # G+4191  U+7DBE  uni7DBE,  CJK UNIFIED IDEOGRAPH-7DBE
        0x7DA0, # G+4192  U+7DA0  uni7DA0,  CJK UNIFIED IDEOGRAPH-7DA0
        0x7DCA, # G+4193  U+7DCA  uni7DCA,  CJK UNIFIED IDEOGRAPH-7DCA
        0x7DB4, # G+4194  U+7DB4  uni7DB4,  CJK UNIFIED IDEOGRAPH-7DB4
        0x7DB2, # G+4195  U+7DB2  uni7DB2,  CJK UNIFIED IDEOGRAPH-7DB2
        0x7DB1, # G+4196  U+7DB1  uni7DB1,  CJK UNIFIED IDEOGRAPH-7DB1
        0x7DBA, # G+4197  U+7DBA  uni7DBA,  CJK UNIFIED IDEOGRAPH-7DBA
        0x7DA2, # G+4198  U+7DA2  uni7DA2,  CJK UNIFIED IDEOGRAPH-7DA2
        0x7DBF, # G+4199  U+7DBF  uni7DBF,  CJK UNIFIED IDEOGRAPH-7DBF
        0x7DB5, # G+4200  U+7DB5  uni7DB5,  CJK UNIFIED IDEOGRAPH-7DB5
        0x7DB8, # G+4201  U+7DB8  uni7DB8,  CJK UNIFIED IDEOGRAPH-7DB8
        0x7DAD, # G+4202  U+7DAD  uni7DAD,  CJK UNIFIED IDEOGRAPH-7DAD
        0x7DD2, # G+4203  U+7DD2  uni7DD2,  CJK UNIFIED IDEOGRAPH-7DD2
        0x7DC7, # G+4204  U+7DC7  uni7DC7,  CJK UNIFIED IDEOGRAPH-7DC7
        0x7DAC, # G+4205  U+7DAC  uni7DAC,  CJK UNIFIED IDEOGRAPH-7DAC
        0x7F70, # G+4206  U+7F70  uni7F70,  CJK UNIFIED IDEOGRAPH-7F70
        0x7FE0, # G+4207  U+7FE0  uni7FE0,  CJK UNIFIED IDEOGRAPH-7FE0
        0x7FE1, # G+4208  U+7FE1  uni7FE1,  CJK UNIFIED IDEOGRAPH-7FE1
        0x7FDF, # G+4209  U+7FDF  uni7FDF,  CJK UNIFIED IDEOGRAPH-7FDF
        0x805E, # G+4210  U+805E  uni805E,  CJK UNIFIED IDEOGRAPH-805E
        0x805A, # G+4211  U+805A  uni805A,  CJK UNIFIED IDEOGRAPH-805A
        0x8087, # G+4212  U+8087  uni8087,  CJK UNIFIED IDEOGRAPH-8087
        0x8150, # G+4213  U+8150  uni8150,  CJK UNIFIED IDEOGRAPH-8150
        0x8180, # G+4214  U+8180  uni8180,  CJK UNIFIED IDEOGRAPH-8180
        0x818F, # G+4215  U+818F  uni818F,  CJK UNIFIED IDEOGRAPH-818F
        0x8188, # G+4216  U+8188  uni8188,  CJK UNIFIED IDEOGRAPH-8188
        0x818A, # G+4217  U+818A  uni818A,  CJK UNIFIED IDEOGRAPH-818A
        0x817F, # G+4218  U+817F  uni817F,  CJK UNIFIED IDEOGRAPH-817F
        0x8182, # G+4219  U+8182  uni8182,  CJK UNIFIED IDEOGRAPH-8182
        0x81E7, # G+4220  U+81E7  uni81E7,  CJK UNIFIED IDEOGRAPH-81E7
        0x81FA, # G+4221  U+81FA  uni81FA,  CJK UNIFIED IDEOGRAPH-81FA
        0x8207, # G+4222  U+8207  uni8207,  CJK UNIFIED IDEOGRAPH-8207
        0x8214, # G+4223  U+8214  uni8214,  CJK UNIFIED IDEOGRAPH-8214
        0x821E, # G+4224  U+821E  uni821E,  CJK UNIFIED IDEOGRAPH-821E
        0x824B, # G+4225  U+824B  uni824B,  CJK UNIFIED IDEOGRAPH-824B
        0x84C9, # G+4226  U+84C9  uni84C9,  CJK UNIFIED IDEOGRAPH-84C9
        0x84BF, # G+4227  U+84BF  uni84BF,  CJK UNIFIED IDEOGRAPH-84BF
        0x84C6, # G+4228  U+84C6  uni84C6,  CJK UNIFIED IDEOGRAPH-84C6
        0x84C4, # G+4229  U+84C4  uni84C4,  CJK UNIFIED IDEOGRAPH-84C4
        0x8499, # G+4230  U+8499  uni8499,  CJK UNIFIED IDEOGRAPH-8499
        0x849E, # G+4231  U+849E  uni849E,  CJK UNIFIED IDEOGRAPH-849E
        0x84B2, # G+4232  U+84B2  uni84B2,  CJK UNIFIED IDEOGRAPH-84B2
        0x849C, # G+4233  U+849C  uni849C,  CJK UNIFIED IDEOGRAPH-849C
        0x84CB, # G+4234  U+84CB  uni84CB,  CJK UNIFIED IDEOGRAPH-84CB
        0x84B8, # G+4235  U+84B8  uni84B8,  CJK UNIFIED IDEOGRAPH-84B8
        0x84C0, # G+4236  U+84C0  uni84C0,  CJK UNIFIED IDEOGRAPH-84C0
        0x84D3, # G+4237  U+84D3  uni84D3,  CJK UNIFIED IDEOGRAPH-84D3
        0x8490, # G+4238  U+8490  uni8490,  CJK UNIFIED IDEOGRAPH-8490
        0x84BC, # G+4239  U+84BC  uni84BC,  CJK UNIFIED IDEOGRAPH-84BC
        0x84D1, # G+4240  U+84D1  uni84D1,  CJK UNIFIED IDEOGRAPH-84D1
        0x84CA, # G+4241  U+84CA  uni84CA,  CJK UNIFIED IDEOGRAPH-84CA
        0x873F, # G+4242  U+873F  uni873F,  CJK UNIFIED IDEOGRAPH-873F
        0x871C, # G+4243  U+871C  uni871C,  CJK UNIFIED IDEOGRAPH-871C
        0x873B, # G+4244  U+873B  uni873B,  CJK UNIFIED IDEOGRAPH-873B
        0x8722, # G+4245  U+8722  uni8722,  CJK UNIFIED IDEOGRAPH-8722
        0x8725, # G+4246  U+8725  uni8725,  CJK UNIFIED IDEOGRAPH-8725
        0x8734, # G+4247  U+8734  uni8734,  CJK UNIFIED IDEOGRAPH-8734
        0x8718, # G+4248  U+8718  uni8718,  CJK UNIFIED IDEOGRAPH-8718
        0x8755, # G+4249  U+8755  uni8755,  CJK UNIFIED IDEOGRAPH-8755
        0x8737, # G+4250  U+8737  uni8737,  CJK UNIFIED IDEOGRAPH-8737
        0x8729, # G+4251  U+8729  uni8729,  CJK UNIFIED IDEOGRAPH-8729
        0x88F3, # G+4252  U+88F3  uni88F3,  CJK UNIFIED IDEOGRAPH-88F3
        0x8902, # G+4253  U+8902  uni8902,  CJK UNIFIED IDEOGRAPH-8902
        0x88F4, # G+4254  U+88F4  uni88F4,  CJK UNIFIED IDEOGRAPH-88F4
        0x88F9, # G+4255  U+88F9  uni88F9,  CJK UNIFIED IDEOGRAPH-88F9
        0x88F8, # G+4256  U+88F8  uni88F8,  CJK UNIFIED IDEOGRAPH-88F8
        0x88FD, # G+4257  U+88FD  uni88FD,  CJK UNIFIED IDEOGRAPH-88FD
        0x88E8, # G+4258  U+88E8  uni88E8,  CJK UNIFIED IDEOGRAPH-88E8
        0x891A, # G+4259  U+891A  uni891A,  CJK UNIFIED IDEOGRAPH-891A
        0x88EF, # G+4260  U+88EF  uni88EF,  CJK UNIFIED IDEOGRAPH-88EF
        0x8AA6, # G+4261  U+8AA6  uni8AA6,  CJK UNIFIED IDEOGRAPH-8AA6
        0x8A8C, # G+4262  U+8A8C  uni8A8C,  CJK UNIFIED IDEOGRAPH-8A8C
        0x8A9E, # G+4263  U+8A9E  uni8A9E,  CJK UNIFIED IDEOGRAPH-8A9E
        0x8AA3, # G+4264  U+8AA3  uni8AA3,  CJK UNIFIED IDEOGRAPH-8AA3
        0x8A8D, # G+4265  U+8A8D  uni8A8D,  CJK UNIFIED IDEOGRAPH-8A8D
        0x8AA1, # G+4266  U+8AA1  uni8AA1,  CJK UNIFIED IDEOGRAPH-8AA1
        0x8A93, # G+4267  U+8A93  uni8A93,  CJK UNIFIED IDEOGRAPH-8A93
        0x8AA4, # G+4268  U+8AA4  uni8AA4,  CJK UNIFIED IDEOGRAPH-8AA4
        0x8AAA, # G+4269  U+8AAA  uni8AAA,  CJK UNIFIED IDEOGRAPH-8AAA
        0x8AA5, # G+4270  U+8AA5  uni8AA5,  CJK UNIFIED IDEOGRAPH-8AA5
        0x8AA8, # G+4271  U+8AA8  uni8AA8,  CJK UNIFIED IDEOGRAPH-8AA8
        0x8A98, # G+4272  U+8A98  uni8A98,  CJK UNIFIED IDEOGRAPH-8A98
        0x8A91, # G+4273  U+8A91  uni8A91,  CJK UNIFIED IDEOGRAPH-8A91
        0x8A9A, # G+4274  U+8A9A  uni8A9A,  CJK UNIFIED IDEOGRAPH-8A9A
        0x8AA7, # G+4275  U+8AA7  uni8AA7,  CJK UNIFIED IDEOGRAPH-8AA7
        0x8C6A, # G+4276  U+8C6A  uni8C6A,  CJK UNIFIED IDEOGRAPH-8C6A
        0x8C8D, # G+4277  U+8C8D  uni8C8D,  CJK UNIFIED IDEOGRAPH-8C8D
        0x8C8C, # G+4278  U+8C8C  uni8C8C,  CJK UNIFIED IDEOGRAPH-8C8C
        0x8CD3, # G+4279  U+8CD3  uni8CD3,  CJK UNIFIED IDEOGRAPH-8CD3
        0x8CD1, # G+4280  U+8CD1  uni8CD1,  CJK UNIFIED IDEOGRAPH-8CD1
        0x8CD2, # G+4281  U+8CD2  uni8CD2,  CJK UNIFIED IDEOGRAPH-8CD2
        0x8D6B, # G+4282  U+8D6B  uni8D6B,  CJK UNIFIED IDEOGRAPH-8D6B
        0x8D99, # G+4283  U+8D99  uni8D99,  CJK UNIFIED IDEOGRAPH-8D99
        0x8D95, # G+4284  U+8D95  uni8D95,  CJK UNIFIED IDEOGRAPH-8D95
        0x8DFC, # G+4285  U+8DFC  uni8DFC,  CJK UNIFIED IDEOGRAPH-8DFC
        0x8F14, # G+4286  U+8F14  uni8F14,  CJK UNIFIED IDEOGRAPH-8F14
        0x8F12, # G+4287  U+8F12  uni8F12,  CJK UNIFIED IDEOGRAPH-8F12
        0x8F15, # G+4288  U+8F15  uni8F15,  CJK UNIFIED IDEOGRAPH-8F15
        0x8F13, # G+4289  U+8F13  uni8F13,  CJK UNIFIED IDEOGRAPH-8F13
        0x8FA3, # G+4290  U+8FA3  uni8FA3,  CJK UNIFIED IDEOGRAPH-8FA3
        0x9060, # G+4291  U+9060  uni9060,  CJK UNIFIED IDEOGRAPH-9060
        0x9058, # G+4292  U+9058  uni9058,  CJK UNIFIED IDEOGRAPH-9058
        0x905C, # G+4293  U+905C  uni905C,  CJK UNIFIED IDEOGRAPH-905C
        0x9063, # G+4294  U+9063  uni9063,  CJK UNIFIED IDEOGRAPH-9063
        0x9059, # G+4295  U+9059  uni9059,  CJK UNIFIED IDEOGRAPH-9059
        0x905E, # G+4296  U+905E  uni905E,  CJK UNIFIED IDEOGRAPH-905E
        0x9062, # G+4297  U+9062  uni9062,  CJK UNIFIED IDEOGRAPH-9062
        0x905D, # G+4298  U+905D  uni905D,  CJK UNIFIED IDEOGRAPH-905D
        0x905B, # G+4299  U+905B  uni905B,  CJK UNIFIED IDEOGRAPH-905B
        0x9119, # G+4300  U+9119  uni9119,  CJK UNIFIED IDEOGRAPH-9119
        0x9118, # G+4301  U+9118  uni9118,  CJK UNIFIED IDEOGRAPH-9118
        0x911E, # G+4302  U+911E  uni911E,  CJK UNIFIED IDEOGRAPH-911E
        0x9175, # G+4303  U+9175  uni9175,  CJK UNIFIED IDEOGRAPH-9175
        0x9178, # G+4304  U+9178  uni9178,  CJK UNIFIED IDEOGRAPH-9178
        0x9177, # G+4305  U+9177  uni9177,  CJK UNIFIED IDEOGRAPH-9177
        0x9174, # G+4306  U+9174  uni9174,  CJK UNIFIED IDEOGRAPH-9174
        0x9278, # G+4307  U+9278  uni9278,  CJK UNIFIED IDEOGRAPH-9278
        0x92AC, # G+4308  U+92AC  uni92AC,  CJK UNIFIED IDEOGRAPH-92AC
        0x9280, # G+4309  U+9280  uni9280,  CJK UNIFIED IDEOGRAPH-9280
        0x9285, # G+4310  U+9285  uni9285,  CJK UNIFIED IDEOGRAPH-9285
        0x9298, # G+4311  U+9298  uni9298,  CJK UNIFIED IDEOGRAPH-9298
        0x9296, # G+4312  U+9296  uni9296,  CJK UNIFIED IDEOGRAPH-9296
        0x927B, # G+4313  U+927B  uni927B,  CJK UNIFIED IDEOGRAPH-927B
        0x9293, # G+4314  U+9293  uni9293,  CJK UNIFIED IDEOGRAPH-9293
        0x929C, # G+4315  U+929C  uni929C,  CJK UNIFIED IDEOGRAPH-929C
        0x92A8, # G+4316  U+92A8  uni92A8,  CJK UNIFIED IDEOGRAPH-92A8
        0x927C, # G+4317  U+927C  uni927C,  CJK UNIFIED IDEOGRAPH-927C
        0x9291, # G+4318  U+9291  uni9291,  CJK UNIFIED IDEOGRAPH-9291
        0x95A1, # G+4319  U+95A1  uni95A1,  CJK UNIFIED IDEOGRAPH-95A1
        0x95A8, # G+4320  U+95A8  uni95A8,  CJK UNIFIED IDEOGRAPH-95A8
        0x95A9, # G+4321  U+95A9  uni95A9,  CJK UNIFIED IDEOGRAPH-95A9
        0x95A3, # G+4322  U+95A3  uni95A3,  CJK UNIFIED IDEOGRAPH-95A3
        0x95A5, # G+4323  U+95A5  uni95A5,  CJK UNIFIED IDEOGRAPH-95A5
        0x95A4, # G+4324  U+95A4  uni95A4,  CJK UNIFIED IDEOGRAPH-95A4
        0x9699, # G+4325  U+9699  uni9699,  CJK UNIFIED IDEOGRAPH-9699
        0x969C, # G+4326  U+969C  uni969C,  CJK UNIFIED IDEOGRAPH-969C
        0x969B, # G+4327  U+969B  uni969B,  CJK UNIFIED IDEOGRAPH-969B
        0x96CC, # G+4328  U+96CC  uni96CC,  CJK UNIFIED IDEOGRAPH-96CC
        0x96D2, # G+4329  U+96D2  uni96D2,  CJK UNIFIED IDEOGRAPH-96D2
        0x9700, # G+4330  U+9700  uni9700,  CJK UNIFIED IDEOGRAPH-9700
        0x977C, # G+4331  U+977C  uni977C,  CJK UNIFIED IDEOGRAPH-977C
        0x9785, # G+4332  U+9785  uni9785,  CJK UNIFIED IDEOGRAPH-9785
        0x97F6, # G+4333  U+97F6  uni97F6,  CJK UNIFIED IDEOGRAPH-97F6
        0x9817, # G+4334  U+9817  uni9817,  CJK UNIFIED IDEOGRAPH-9817
        0x9818, # G+4335  U+9818  uni9818,  CJK UNIFIED IDEOGRAPH-9818
        0x98AF, # G+4336  U+98AF  uni98AF,  CJK UNIFIED IDEOGRAPH-98AF
        0x98B1, # G+4337  U+98B1  uni98B1,  CJK UNIFIED IDEOGRAPH-98B1
        0x9903, # G+4338  U+9903  uni9903,  CJK UNIFIED IDEOGRAPH-9903
        0x9905, # G+4339  U+9905  uni9905,  CJK UNIFIED IDEOGRAPH-9905
        0x990C, # G+4340  U+990C  uni990C,  CJK UNIFIED IDEOGRAPH-990C
        0x9909, # G+4341  U+9909  uni9909,  CJK UNIFIED IDEOGRAPH-9909
        0x99C1, # G+4342  U+99C1  uni99C1,  CJK UNIFIED IDEOGRAPH-99C1
        0x9AAF, # G+4343  U+9AAF  uni9AAF,  CJK UNIFIED IDEOGRAPH-9AAF
        0x9AB0, # G+4344  U+9AB0  uni9AB0,  CJK UNIFIED IDEOGRAPH-9AB0
        0x9AE6, # G+4345  U+9AE6  uni9AE6,  CJK UNIFIED IDEOGRAPH-9AE6
        0x9B41, # G+4346  U+9B41  uni9B41,  CJK UNIFIED IDEOGRAPH-9B41
        0x9B42, # G+4347  U+9B42  uni9B42,  CJK UNIFIED IDEOGRAPH-9B42
        0x9CF4, # G+4348  U+9CF4  uni9CF4,  CJK UNIFIED IDEOGRAPH-9CF4
        0x9CF6, # G+4349  U+9CF6  uni9CF6,  CJK UNIFIED IDEOGRAPH-9CF6
        0x9CF3, # G+4350  U+9CF3  uni9CF3,  CJK UNIFIED IDEOGRAPH-9CF3
        0x9EBC, # G+4351  U+9EBC  uni9EBC,  CJK UNIFIED IDEOGRAPH-9EBC
        0x9F3B, # G+4352  U+9F3B  uni9F3B,  CJK UNIFIED IDEOGRAPH-9F3B
        0x9F4A, # G+4353  U+9F4A  uni9F4A,  CJK UNIFIED IDEOGRAPH-9F4A
        0x5104, # G+4354  U+5104  uni5104,  CJK UNIFIED IDEOGRAPH-5104
        0x5100, # G+4355  U+5100  uni5100,  CJK UNIFIED IDEOGRAPH-5100
        0x50FB, # G+4356  U+50FB  uni50FB,  CJK UNIFIED IDEOGRAPH-50FB
        0x50F5, # G+4357  U+50F5  uni50F5,  CJK UNIFIED IDEOGRAPH-50F5
        0x50F9, # G+4358  U+50F9  uni50F9,  CJK UNIFIED IDEOGRAPH-50F9
        0x5102, # G+4359  U+5102  uni5102,  CJK UNIFIED IDEOGRAPH-5102
        0x5108, # G+4360  U+5108  uni5108,  CJK UNIFIED IDEOGRAPH-5108
        0x5109, # G+4361  U+5109  uni5109,  CJK UNIFIED IDEOGRAPH-5109
        0x5105, # G+4362  U+5105  uni5105,  CJK UNIFIED IDEOGRAPH-5105
        0x51DC, # G+4363  U+51DC  uni51DC,  CJK UNIFIED IDEOGRAPH-51DC
        0x5287, # G+4364  U+5287  uni5287,  CJK UNIFIED IDEOGRAPH-5287
        0x5288, # G+4365  U+5288  uni5288,  CJK UNIFIED IDEOGRAPH-5288
        0x5289, # G+4366  U+5289  uni5289,  CJK UNIFIED IDEOGRAPH-5289
        0x528D, # G+4367  U+528D  uni528D,  CJK UNIFIED IDEOGRAPH-528D
        0x528A, # G+4368  U+528A  uni528A,  CJK UNIFIED IDEOGRAPH-528A
        0x52F0, # G+4369  U+52F0  uni52F0,  CJK UNIFIED IDEOGRAPH-52F0
        0x53B2, # G+4370  U+53B2  uni53B2,  CJK UNIFIED IDEOGRAPH-53B2
        0x562E, # G+4371  U+562E  uni562E,  CJK UNIFIED IDEOGRAPH-562E
        0x563B, # G+4372  U+563B  uni563B,  CJK UNIFIED IDEOGRAPH-563B
        0x5639, # G+4373  U+5639  uni5639,  CJK UNIFIED IDEOGRAPH-5639
        0x5632, # G+4374  U+5632  uni5632,  CJK UNIFIED IDEOGRAPH-5632
        0x563F, # G+4375  U+563F  uni563F,  CJK UNIFIED IDEOGRAPH-563F
        0x5634, # G+4376  U+5634  uni5634,  CJK UNIFIED IDEOGRAPH-5634
        0x5629, # G+4377  U+5629  uni5629,  CJK UNIFIED IDEOGRAPH-5629
        0x5653, # G+4378  U+5653  uni5653,  CJK UNIFIED IDEOGRAPH-5653
        0x564E, # G+4379  U+564E  uni564E,  CJK UNIFIED IDEOGRAPH-564E
        0x5657, # G+4380  U+5657  uni5657,  CJK UNIFIED IDEOGRAPH-5657
        0x5674, # G+4381  U+5674  uni5674,  CJK UNIFIED IDEOGRAPH-5674
        0x5636, # G+4382  U+5636  uni5636,  CJK UNIFIED IDEOGRAPH-5636
        0x562F, # G+4383  U+562F  uni562F,  CJK UNIFIED IDEOGRAPH-562F
        0x5630, # G+4384  U+5630  uni5630,  CJK UNIFIED IDEOGRAPH-5630
        0x5880, # G+4385  U+5880  uni5880,  CJK UNIFIED IDEOGRAPH-5880
        0x589F, # G+4386  U+589F  uni589F,  CJK UNIFIED IDEOGRAPH-589F
        0x589E, # G+4387  U+589E  uni589E,  CJK UNIFIED IDEOGRAPH-589E
        0x58B3, # G+4388  U+58B3  uni58B3,  CJK UNIFIED IDEOGRAPH-58B3
        0x589C, # G+4389  U+589C  uni589C,  CJK UNIFIED IDEOGRAPH-589C
        0x58AE, # G+4390  U+58AE  uni58AE,  CJK UNIFIED IDEOGRAPH-58AE
        0x58A9, # G+4391  U+58A9  uni58A9,  CJK UNIFIED IDEOGRAPH-58A9
        0x58A6, # G+4392  U+58A6  uni58A6,  CJK UNIFIED IDEOGRAPH-58A6
        0x596D, # G+4393  U+596D  uni596D,  CJK UNIFIED IDEOGRAPH-596D
        0x5B09, # G+4394  U+5B09  uni5B09,  CJK UNIFIED IDEOGRAPH-5B09
        0x5AFB, # G+4395  U+5AFB  uni5AFB,  CJK UNIFIED IDEOGRAPH-5AFB
        0x5B0B, # G+4396  U+5B0B  uni5B0B,  CJK UNIFIED IDEOGRAPH-5B0B
        0x5AF5, # G+4397  U+5AF5  uni5AF5,  CJK UNIFIED IDEOGRAPH-5AF5
        0x5B0C, # G+4398  U+5B0C  uni5B0C,  CJK UNIFIED IDEOGRAPH-5B0C
        0x5B08, # G+4399  U+5B08  uni5B08,  CJK UNIFIED IDEOGRAPH-5B08
        0x5BEE, # G+4400  U+5BEE  uni5BEE,  CJK UNIFIED IDEOGRAPH-5BEE
        0x5BEC, # G+4401  U+5BEC  uni5BEC,  CJK UNIFIED IDEOGRAPH-5BEC
        0x5BE9, # G+4402  U+5BE9  uni5BE9,  CJK UNIFIED IDEOGRAPH-5BE9
        0x5BEB, # G+4403  U+5BEB  uni5BEB,  CJK UNIFIED IDEOGRAPH-5BEB
        0x5C64, # G+4404  U+5C64  uni5C64,  CJK UNIFIED IDEOGRAPH-5C64
        0x5C65, # G+4405  U+5C65  uni5C65,  CJK UNIFIED IDEOGRAPH-5C65
        0x5D9D, # G+4406  U+5D9D  uni5D9D,  CJK UNIFIED IDEOGRAPH-5D9D
        0x5D94, # G+4407  U+5D94  uni5D94,  CJK UNIFIED IDEOGRAPH-5D94
        0x5E62, # G+4408  U+5E62  uni5E62,  CJK UNIFIED IDEOGRAPH-5E62
        0x5E5F, # G+4409  U+5E5F  uni5E5F,  CJK UNIFIED IDEOGRAPH-5E5F
        0x5E61, # G+4410  U+5E61  uni5E61,  CJK UNIFIED IDEOGRAPH-5E61
        0x5EE2, # G+4411  U+5EE2  uni5EE2,  CJK UNIFIED IDEOGRAPH-5EE2
        0x5EDA, # G+4412  U+5EDA  uni5EDA,  CJK UNIFIED IDEOGRAPH-5EDA
        0x5EDF, # G+4413  U+5EDF  uni5EDF,  CJK UNIFIED IDEOGRAPH-5EDF
        0x5EDD, # G+4414  U+5EDD  uni5EDD,  CJK UNIFIED IDEOGRAPH-5EDD
        0x5EE3, # G+4415  U+5EE3  uni5EE3,  CJK UNIFIED IDEOGRAPH-5EE3
        0x5EE0, # G+4416  U+5EE0  uni5EE0,  CJK UNIFIED IDEOGRAPH-5EE0
        0x5F48, # G+4417  U+5F48  uni5F48,  CJK UNIFIED IDEOGRAPH-5F48
        0x5F71, # G+4418  U+5F71  uni5F71,  CJK UNIFIED IDEOGRAPH-5F71
        0x5FB7, # G+4419  U+5FB7  uni5FB7,  CJK UNIFIED IDEOGRAPH-5FB7
        0x5FB5, # G+4420  U+5FB5  uni5FB5,  CJK UNIFIED IDEOGRAPH-5FB5
        0x6176, # G+4421  U+6176  uni6176,  CJK UNIFIED IDEOGRAPH-6176
        0x6167, # G+4422  U+6167  uni6167,  CJK UNIFIED IDEOGRAPH-6167
        0x616E, # G+4423  U+616E  uni616E,  CJK UNIFIED IDEOGRAPH-616E
        0x615D, # G+4424  U+615D  uni615D,  CJK UNIFIED IDEOGRAPH-615D
        0x6155, # G+4425  U+6155  uni6155,  CJK UNIFIED IDEOGRAPH-6155
        0x6182, # G+4426  U+6182  uni6182,  CJK UNIFIED IDEOGRAPH-6182
        0x617C, # G+4427  U+617C  uni617C,  CJK UNIFIED IDEOGRAPH-617C
        0x6170, # G+4428  U+6170  uni6170,  CJK UNIFIED IDEOGRAPH-6170
        0x616B, # G+4429  U+616B  uni616B,  CJK UNIFIED IDEOGRAPH-616B
        0x617E, # G+4430  U+617E  uni617E,  CJK UNIFIED IDEOGRAPH-617E
        0x61A7, # G+4431  U+61A7  uni61A7,  CJK UNIFIED IDEOGRAPH-61A7
        0x6190, # G+4432  U+6190  uni6190,  CJK UNIFIED IDEOGRAPH-6190
        0x61AB, # G+4433  U+61AB  uni61AB,  CJK UNIFIED IDEOGRAPH-61AB
        0x618E, # G+4434  U+618E  uni618E,  CJK UNIFIED IDEOGRAPH-618E
        0x61AC, # G+4435  U+61AC  uni61AC,  CJK UNIFIED IDEOGRAPH-61AC
        0x619A, # G+4436  U+619A  uni619A,  CJK UNIFIED IDEOGRAPH-619A
        0x61A4, # G+4437  U+61A4  uni61A4,  CJK UNIFIED IDEOGRAPH-61A4
        0x6194, # G+4438  U+6194  uni6194,  CJK UNIFIED IDEOGRAPH-6194
        0x61AE, # G+4439  U+61AE  uni61AE,  CJK UNIFIED IDEOGRAPH-61AE
        0x622E, # G+4440  U+622E  uni622E,  CJK UNIFIED IDEOGRAPH-622E
        0x6469, # G+4441  U+6469  uni6469,  CJK UNIFIED IDEOGRAPH-6469
        0x646F, # G+4442  U+646F  uni646F,  CJK UNIFIED IDEOGRAPH-646F
        0x6479, # G+4443  U+6479  uni6479,  CJK UNIFIED IDEOGRAPH-6479
        0x649E, # G+4444  U+649E  uni649E,  CJK UNIFIED IDEOGRAPH-649E
        0x64B2, # G+4445  U+64B2  uni64B2,  CJK UNIFIED IDEOGRAPH-64B2
        0x6488, # G+4446  U+6488  uni6488,  CJK UNIFIED IDEOGRAPH-6488
        0x6490, # G+4447  U+6490  uni6490,  CJK UNIFIED IDEOGRAPH-6490
        0x64B0, # G+4448  U+64B0  uni64B0,  CJK UNIFIED IDEOGRAPH-64B0
        0x64A5, # G+4449  U+64A5  uni64A5,  CJK UNIFIED IDEOGRAPH-64A5
        0x6493, # G+4450  U+6493  uni6493,  CJK UNIFIED IDEOGRAPH-6493
        0x6495, # G+4451  U+6495  uni6495,  CJK UNIFIED IDEOGRAPH-6495
        0x64A9, # G+4452  U+64A9  uni64A9,  CJK UNIFIED IDEOGRAPH-64A9
        0x6492, # G+4453  U+6492  uni6492,  CJK UNIFIED IDEOGRAPH-6492
        0x64AE, # G+4454  U+64AE  uni64AE,  CJK UNIFIED IDEOGRAPH-64AE
        0x64AD, # G+4455  U+64AD  uni64AD,  CJK UNIFIED IDEOGRAPH-64AD
        0x64AB, # G+4456  U+64AB  uni64AB,  CJK UNIFIED IDEOGRAPH-64AB
        0x649A, # G+4457  U+649A  uni649A,  CJK UNIFIED IDEOGRAPH-649A
        0x64AC, # G+4458  U+64AC  uni64AC,  CJK UNIFIED IDEOGRAPH-64AC
        0x6499, # G+4459  U+6499  uni6499,  CJK UNIFIED IDEOGRAPH-6499
        0x64A2, # G+4460  U+64A2  uni64A2,  CJK UNIFIED IDEOGRAPH-64A2
        0x64B3, # G+4461  U+64B3  uni64B3,  CJK UNIFIED IDEOGRAPH-64B3
        0x6575, # G+4462  U+6575  uni6575,  CJK UNIFIED IDEOGRAPH-6575
        0x6577, # G+4463  U+6577  uni6577,  CJK UNIFIED IDEOGRAPH-6577
        0x6578, # G+4464  U+6578  uni6578,  CJK UNIFIED IDEOGRAPH-6578
        0x66AE, # G+4465  U+66AE  uni66AE,  CJK UNIFIED IDEOGRAPH-66AE
        0x66AB, # G+4466  U+66AB  uni66AB,  CJK UNIFIED IDEOGRAPH-66AB
        0x66B4, # G+4467  U+66B4  uni66B4,  CJK UNIFIED IDEOGRAPH-66B4
        0x66B1, # G+4468  U+66B1  uni66B1,  CJK UNIFIED IDEOGRAPH-66B1
        0x6A23, # G+4469  U+6A23  uni6A23,  CJK UNIFIED IDEOGRAPH-6A23
        0x6A1F, # G+4470  U+6A1F  uni6A1F,  CJK UNIFIED IDEOGRAPH-6A1F
        0x69E8, # G+4471  U+69E8  uni69E8,  CJK UNIFIED IDEOGRAPH-69E8
        0x6A01, # G+4472  U+6A01  uni6A01,  CJK UNIFIED IDEOGRAPH-6A01
        0x6A1E, # G+4473  U+6A1E  uni6A1E,  CJK UNIFIED IDEOGRAPH-6A1E
        0x6A19, # G+4474  U+6A19  uni6A19,  CJK UNIFIED IDEOGRAPH-6A19
        0x69FD, # G+4475  U+69FD  uni69FD,  CJK UNIFIED IDEOGRAPH-69FD
        0x6A21, # G+4476  U+6A21  uni6A21,  CJK UNIFIED IDEOGRAPH-6A21
        0x6A13, # G+4477  U+6A13  uni6A13,  CJK UNIFIED IDEOGRAPH-6A13
        0x6A0A, # G+4478  U+6A0A  uni6A0A,  CJK UNIFIED IDEOGRAPH-6A0A
        0x69F3, # G+4479  U+69F3  uni69F3,  CJK UNIFIED IDEOGRAPH-69F3
        0x6A02, # G+4480  U+6A02  uni6A02,  CJK UNIFIED IDEOGRAPH-6A02
        0x6A05, # G+4481  U+6A05  uni6A05,  CJK UNIFIED IDEOGRAPH-6A05
        0x69ED, # G+4482  U+69ED  uni69ED,  CJK UNIFIED IDEOGRAPH-69ED
        0x6A11, # G+4483  U+6A11  uni6A11,  CJK UNIFIED IDEOGRAPH-6A11
        0x6B50, # G+4484  U+6B50  uni6B50,  CJK UNIFIED IDEOGRAPH-6B50
        0x6B4E, # G+4485  U+6B4E  uni6B4E,  CJK UNIFIED IDEOGRAPH-6B4E
        0x6BA4, # G+4486  U+6BA4  uni6BA4,  CJK UNIFIED IDEOGRAPH-6BA4
        0x6BC5, # G+4487  U+6BC5  uni6BC5,  CJK UNIFIED IDEOGRAPH-6BC5
        0x6BC6, # G+4488  U+6BC6  uni6BC6,  CJK UNIFIED IDEOGRAPH-6BC6
        0x6F3F, # G+4489  U+6F3F  uni6F3F,  CJK UNIFIED IDEOGRAPH-6F3F
        0x6F7C, # G+4490  U+6F7C  uni6F7C,  CJK UNIFIED IDEOGRAPH-6F7C
        0x6F84, # G+4491  U+6F84  uni6F84,  CJK UNIFIED IDEOGRAPH-6F84
        0x6F51, # G+4492  U+6F51  uni6F51,  CJK UNIFIED IDEOGRAPH-6F51
        0x6F66, # G+4493  U+6F66  uni6F66,  CJK UNIFIED IDEOGRAPH-6F66
        0x6F54, # G+4494  U+6F54  uni6F54,  CJK UNIFIED IDEOGRAPH-6F54
        0x6F86, # G+4495  U+6F86  uni6F86,  CJK UNIFIED IDEOGRAPH-6F86
        0x6F6D, # G+4496  U+6F6D  uni6F6D,  CJK UNIFIED IDEOGRAPH-6F6D
        0x6F5B, # G+4497  U+6F5B  uni6F5B,  CJK UNIFIED IDEOGRAPH-6F5B
        0x6F78, # G+4498  U+6F78  uni6F78,  CJK UNIFIED IDEOGRAPH-6F78
        0x6F6E, # G+4499  U+6F6E  uni6F6E,  CJK UNIFIED IDEOGRAPH-6F6E
        0x6F8E, # G+4500  U+6F8E  uni6F8E,  CJK UNIFIED IDEOGRAPH-6F8E
        0x6F7A, # G+4501  U+6F7A  uni6F7A,  CJK UNIFIED IDEOGRAPH-6F7A
        0x6F70, # G+4502  U+6F70  uni6F70,  CJK UNIFIED IDEOGRAPH-6F70
        0x6F64, # G+4503  U+6F64  uni6F64,  CJK UNIFIED IDEOGRAPH-6F64
        0x6F97, # G+4504  U+6F97  uni6F97,  CJK UNIFIED IDEOGRAPH-6F97
        0x6F58, # G+4505  U+6F58  uni6F58,  CJK UNIFIED IDEOGRAPH-6F58
        0x6ED5, # G+4506  U+6ED5  uni6ED5,  CJK UNIFIED IDEOGRAPH-6ED5
        0x6F6F, # G+4507  U+6F6F  uni6F6F,  CJK UNIFIED IDEOGRAPH-6F6F
        0x6F60, # G+4508  U+6F60  uni6F60,  CJK UNIFIED IDEOGRAPH-6F60
        0x6F5F, # G+4509  U+6F5F  uni6F5F,  CJK UNIFIED IDEOGRAPH-6F5F
        0x719F, # G+4510  U+719F  uni719F,  CJK UNIFIED IDEOGRAPH-719F
        0x71AC, # G+4511  U+71AC  uni71AC,  CJK UNIFIED IDEOGRAPH-71AC
        0x71B1, # G+4512  U+71B1  uni71B1,  CJK UNIFIED IDEOGRAPH-71B1
        0x71A8, # G+4513  U+71A8  uni71A8,  CJK UNIFIED IDEOGRAPH-71A8
        0x7256, # G+4514  U+7256  uni7256,  CJK UNIFIED IDEOGRAPH-7256
        0x729B, # G+4515  U+729B  uni729B,  CJK UNIFIED IDEOGRAPH-729B
        0x734E, # G+4516  U+734E  uni734E,  CJK UNIFIED IDEOGRAPH-734E
        0x7357, # G+4517  U+7357  uni7357,  CJK UNIFIED IDEOGRAPH-7357
        0x7469, # G+4518  U+7469  uni7469,  CJK UNIFIED IDEOGRAPH-7469
        0x748B, # G+4519  U+748B  uni748B,  CJK UNIFIED IDEOGRAPH-748B
        0x7483, # G+4520  U+7483  uni7483,  CJK UNIFIED IDEOGRAPH-7483
        0x747E, # G+4521  U+747E  uni747E,  CJK UNIFIED IDEOGRAPH-747E
        0x7480, # G+4522  U+7480  uni7480,  CJK UNIFIED IDEOGRAPH-7480
        0x757F, # G+4523  U+757F  uni757F,  CJK UNIFIED IDEOGRAPH-757F
        0x7620, # G+4524  U+7620  uni7620,  CJK UNIFIED IDEOGRAPH-7620
        0x7629, # G+4525  U+7629  uni7629,  CJK UNIFIED IDEOGRAPH-7629
        0x761F, # G+4526  U+761F  uni761F,  CJK UNIFIED IDEOGRAPH-761F
        0x7624, # G+4527  U+7624  uni7624,  CJK UNIFIED IDEOGRAPH-7624
        0x7626, # G+4528  U+7626  uni7626,  CJK UNIFIED IDEOGRAPH-7626
        0x7621, # G+4529  U+7621  uni7621,  CJK UNIFIED IDEOGRAPH-7621
        0x7622, # G+4530  U+7622  uni7622,  CJK UNIFIED IDEOGRAPH-7622
        0x769A, # G+4531  U+769A  uni769A,  CJK UNIFIED IDEOGRAPH-769A
        0x76BA, # G+4532  U+76BA  uni76BA,  CJK UNIFIED IDEOGRAPH-76BA
        0x76E4, # G+4533  U+76E4  uni76E4,  CJK UNIFIED IDEOGRAPH-76E4
        0x778E, # G+4534  U+778E  uni778E,  CJK UNIFIED IDEOGRAPH-778E
        0x7787, # G+4535  U+7787  uni7787,  CJK UNIFIED IDEOGRAPH-7787
        0x778C, # G+4536  U+778C  uni778C,  CJK UNIFIED IDEOGRAPH-778C
        0x7791, # G+4537  U+7791  uni7791,  CJK UNIFIED IDEOGRAPH-7791
        0x778B, # G+4538  U+778B  uni778B,  CJK UNIFIED IDEOGRAPH-778B
        0x78CB, # G+4539  U+78CB  uni78CB,  CJK UNIFIED IDEOGRAPH-78CB
        0x78C5, # G+4540  U+78C5  uni78C5,  CJK UNIFIED IDEOGRAPH-78C5
        0x78BA, # G+4541  U+78BA  uni78BA,  CJK UNIFIED IDEOGRAPH-78BA
        0x78CA, # G+4542  U+78CA  uni78CA,  CJK UNIFIED IDEOGRAPH-78CA
        0x78BE, # G+4543  U+78BE  uni78BE,  CJK UNIFIED IDEOGRAPH-78BE
        0x78D5, # G+4544  U+78D5  uni78D5,  CJK UNIFIED IDEOGRAPH-78D5
        0x78BC, # G+4545  U+78BC  uni78BC,  CJK UNIFIED IDEOGRAPH-78BC
        0x78D0, # G+4546  U+78D0  uni78D0,  CJK UNIFIED IDEOGRAPH-78D0
        0x7A3F, # G+4547  U+7A3F  uni7A3F,  CJK UNIFIED IDEOGRAPH-7A3F
        0x7A3C, # G+4548  U+7A3C  uni7A3C,  CJK UNIFIED IDEOGRAPH-7A3C
        0x7A40, # G+4549  U+7A40  uni7A40,  CJK UNIFIED IDEOGRAPH-7A40
        0x7A3D, # G+4550  U+7A3D  uni7A3D,  CJK UNIFIED IDEOGRAPH-7A3D
        0x7A37, # G+4551  U+7A37  uni7A37,  CJK UNIFIED IDEOGRAPH-7A37
        0x7A3B, # G+4552  U+7A3B  uni7A3B,  CJK UNIFIED IDEOGRAPH-7A3B
        0x7AAF, # G+4553  U+7AAF  uni7AAF,  CJK UNIFIED IDEOGRAPH-7AAF
        0x7AAE, # G+4554  U+7AAE  uni7AAE,  CJK UNIFIED IDEOGRAPH-7AAE
        0x7BAD, # G+4555  U+7BAD  uni7BAD,  CJK UNIFIED IDEOGRAPH-7BAD
        0x7BB1, # G+4556  U+7BB1  uni7BB1,  CJK UNIFIED IDEOGRAPH-7BB1
        0x7BC4, # G+4557  U+7BC4  uni7BC4,  CJK UNIFIED IDEOGRAPH-7BC4
        0x7BB4, # G+4558  U+7BB4  uni7BB4,  CJK UNIFIED IDEOGRAPH-7BB4
        0x7BC6, # G+4559  U+7BC6  uni7BC6,  CJK UNIFIED IDEOGRAPH-7BC6
        0x7BC7, # G+4560  U+7BC7  uni7BC7,  CJK UNIFIED IDEOGRAPH-7BC7
        0x7BC1, # G+4561  U+7BC1  uni7BC1,  CJK UNIFIED IDEOGRAPH-7BC1
        0x7BA0, # G+4562  U+7BA0  uni7BA0,  CJK UNIFIED IDEOGRAPH-7BA0
        0x7BCC, # G+4563  U+7BCC  uni7BCC,  CJK UNIFIED IDEOGRAPH-7BCC
        0x7CCA, # G+4564  U+7CCA  uni7CCA,  CJK UNIFIED IDEOGRAPH-7CCA
        0x7DE0, # G+4565  U+7DE0  uni7DE0,  CJK UNIFIED IDEOGRAPH-7DE0
        0x7DF4, # G+4566  U+7DF4  uni7DF4,  CJK UNIFIED IDEOGRAPH-7DF4
        0x7DEF, # G+4567  U+7DEF  uni7DEF,  CJK UNIFIED IDEOGRAPH-7DEF
        0x7DFB, # G+4568  U+7DFB  uni7DFB,  CJK UNIFIED IDEOGRAPH-7DFB
        0x7DD8, # G+4569  U+7DD8  uni7DD8,  CJK UNIFIED IDEOGRAPH-7DD8
        0x7DEC, # G+4570  U+7DEC  uni7DEC,  CJK UNIFIED IDEOGRAPH-7DEC
        0x7DDD, # G+4571  U+7DDD  uni7DDD,  CJK UNIFIED IDEOGRAPH-7DDD
        0x7DE8, # G+4572  U+7DE8  uni7DE8,  CJK UNIFIED IDEOGRAPH-7DE8
        0x7DE3, # G+4573  U+7DE3  uni7DE3,  CJK UNIFIED IDEOGRAPH-7DE3
        0x7DDA, # G+4574  U+7DDA  uni7DDA,  CJK UNIFIED IDEOGRAPH-7DDA
        0x7DDE, # G+4575  U+7DDE  uni7DDE,  CJK UNIFIED IDEOGRAPH-7DDE
        0x7DE9, # G+4576  U+7DE9  uni7DE9,  CJK UNIFIED IDEOGRAPH-7DE9
        0x7D9E, # G+4577  U+7D9E  uni7D9E,  CJK UNIFIED IDEOGRAPH-7D9E
        0x7DD9, # G+4578  U+7DD9  uni7DD9,  CJK UNIFIED IDEOGRAPH-7DD9
        0x7DF2, # G+4579  U+7DF2  uni7DF2,  CJK UNIFIED IDEOGRAPH-7DF2
        0x7DF9, # G+4580  U+7DF9  uni7DF9,  CJK UNIFIED IDEOGRAPH-7DF9
        0x7F75, # G+4581  U+7F75  uni7F75,  CJK UNIFIED IDEOGRAPH-7F75
        0x7F77, # G+4582  U+7F77  uni7F77,  CJK UNIFIED IDEOGRAPH-7F77
        0x7FAF, # G+4583  U+7FAF  uni7FAF,  CJK UNIFIED IDEOGRAPH-7FAF
        0x7FE9, # G+4584  U+7FE9  uni7FE9,  CJK UNIFIED IDEOGRAPH-7FE9
        0x8026, # G+4585  U+8026  uni8026,  CJK UNIFIED IDEOGRAPH-8026
        0x819B, # G+4586  U+819B  uni819B,  CJK UNIFIED IDEOGRAPH-819B
        0x819C, # G+4587  U+819C  uni819C,  CJK UNIFIED IDEOGRAPH-819C
        0x819D, # G+4588  U+819D  uni819D,  CJK UNIFIED IDEOGRAPH-819D
        0x81A0, # G+4589  U+81A0  uni81A0,  CJK UNIFIED IDEOGRAPH-81A0
        0x819A, # G+4590  U+819A  uni819A,  CJK UNIFIED IDEOGRAPH-819A
        0x8198, # G+4591  U+8198  uni8198,  CJK UNIFIED IDEOGRAPH-8198
        0x8517, # G+4592  U+8517  uni8517,  CJK UNIFIED IDEOGRAPH-8517
        0x853D, # G+4593  U+853D  uni853D,  CJK UNIFIED IDEOGRAPH-853D
        0x851A, # G+4594  U+851A  uni851A,  CJK UNIFIED IDEOGRAPH-851A
        0x84EE, # G+4595  U+84EE  uni84EE,  CJK UNIFIED IDEOGRAPH-84EE
        0x852C, # G+4596  U+852C  uni852C,  CJK UNIFIED IDEOGRAPH-852C
        0x852D, # G+4597  U+852D  uni852D,  CJK UNIFIED IDEOGRAPH-852D
        0x8513, # G+4598  U+8513  uni8513,  CJK UNIFIED IDEOGRAPH-8513
        0x8511, # G+4599  U+8511  uni8511,  CJK UNIFIED IDEOGRAPH-8511
        0x8523, # G+4600  U+8523  uni8523,  CJK UNIFIED IDEOGRAPH-8523
        0x8521, # G+4601  U+8521  uni8521,  CJK UNIFIED IDEOGRAPH-8521
        0x8514, # G+4602  U+8514  uni8514,  CJK UNIFIED IDEOGRAPH-8514
        0x84EC, # G+4603  U+84EC  uni84EC,  CJK UNIFIED IDEOGRAPH-84EC
        0x8525, # G+4604  U+8525  uni8525,  CJK UNIFIED IDEOGRAPH-8525
        0x84FF, # G+4605  U+84FF  uni84FF,  CJK UNIFIED IDEOGRAPH-84FF
        0x8506, # G+4606  U+8506  uni8506,  CJK UNIFIED IDEOGRAPH-8506
        0x8782, # G+4607  U+8782  uni8782,  CJK UNIFIED IDEOGRAPH-8782
        0x8774, # G+4608  U+8774  uni8774,  CJK UNIFIED IDEOGRAPH-8774
        0x8776, # G+4609  U+8776  uni8776,  CJK UNIFIED IDEOGRAPH-8776
        0x8760, # G+4610  U+8760  uni8760,  CJK UNIFIED IDEOGRAPH-8760
        0x8766, # G+4611  U+8766  uni8766,  CJK UNIFIED IDEOGRAPH-8766
        0x8778, # G+4612  U+8778  uni8778,  CJK UNIFIED IDEOGRAPH-8778
        0x8768, # G+4613  U+8768  uni8768,  CJK UNIFIED IDEOGRAPH-8768
        0x8759, # G+4614  U+8759  uni8759,  CJK UNIFIED IDEOGRAPH-8759
        0x8757, # G+4615  U+8757  uni8757,  CJK UNIFIED IDEOGRAPH-8757
        0x874C, # G+4616  U+874C  uni874C,  CJK UNIFIED IDEOGRAPH-874C
        0x8753, # G+4617  U+8753  uni8753,  CJK UNIFIED IDEOGRAPH-8753
        0x885B, # G+4618  U+885B  uni885B,  CJK UNIFIED IDEOGRAPH-885B
        0x885D, # G+4619  U+885D  uni885D,  CJK UNIFIED IDEOGRAPH-885D
        0x8910, # G+4620  U+8910  uni8910,  CJK UNIFIED IDEOGRAPH-8910
        0x8907, # G+4621  U+8907  uni8907,  CJK UNIFIED IDEOGRAPH-8907
        0x8912, # G+4622  U+8912  uni8912,  CJK UNIFIED IDEOGRAPH-8912
        0x8913, # G+4623  U+8913  uni8913,  CJK UNIFIED IDEOGRAPH-8913
        0x8915, # G+4624  U+8915  uni8915,  CJK UNIFIED IDEOGRAPH-8915
        0x890A, # G+4625  U+890A  uni890A,  CJK UNIFIED IDEOGRAPH-890A
        0x8ABC, # G+4626  U+8ABC  uni8ABC,  CJK UNIFIED IDEOGRAPH-8ABC
        0x8AD2, # G+4627  U+8AD2  uni8AD2,  CJK UNIFIED IDEOGRAPH-8AD2
        0x8AC7, # G+4628  U+8AC7  uni8AC7,  CJK UNIFIED IDEOGRAPH-8AC7
        0x8AC4, # G+4629  U+8AC4  uni8AC4,  CJK UNIFIED IDEOGRAPH-8AC4
        0x8A95, # G+4630  U+8A95  uni8A95,  CJK UNIFIED IDEOGRAPH-8A95
        0x8ACB, # G+4631  U+8ACB  uni8ACB,  CJK UNIFIED IDEOGRAPH-8ACB
        0x8AF8, # G+4632  U+8AF8  uni8AF8,  CJK UNIFIED IDEOGRAPH-8AF8
        0x8AB2, # G+4633  U+8AB2  uni8AB2,  CJK UNIFIED IDEOGRAPH-8AB2
        0x8AC9, # G+4634  U+8AC9  uni8AC9,  CJK UNIFIED IDEOGRAPH-8AC9
        0x8AC2, # G+4635  U+8AC2  uni8AC2,  CJK UNIFIED IDEOGRAPH-8AC2
        0x8ABF, # G+4636  U+8ABF  uni8ABF,  CJK UNIFIED IDEOGRAPH-8ABF
        0x8AB0, # G+4637  U+8AB0  uni8AB0,  CJK UNIFIED IDEOGRAPH-8AB0
        0x8AD6, # G+4638  U+8AD6  uni8AD6,  CJK UNIFIED IDEOGRAPH-8AD6
        0x8ACD, # G+4639  U+8ACD  uni8ACD,  CJK UNIFIED IDEOGRAPH-8ACD
        0x8AB6, # G+4640  U+8AB6  uni8AB6,  CJK UNIFIED IDEOGRAPH-8AB6
        0x8AB9, # G+4641  U+8AB9  uni8AB9,  CJK UNIFIED IDEOGRAPH-8AB9
        0x8ADB, # G+4642  U+8ADB  uni8ADB,  CJK UNIFIED IDEOGRAPH-8ADB
        0x8C4C, # G+4643  U+8C4C  uni8C4C,  CJK UNIFIED IDEOGRAPH-8C4C
        0x8C4E, # G+4644  U+8C4E  uni8C4E,  CJK UNIFIED IDEOGRAPH-8C4E
        0x8C6C, # G+4645  U+8C6C  uni8C6C,  CJK UNIFIED IDEOGRAPH-8C6C
        0x8CE0, # G+4646  U+8CE0  uni8CE0,  CJK UNIFIED IDEOGRAPH-8CE0
        0x8CDE, # G+4647  U+8CDE  uni8CDE,  CJK UNIFIED IDEOGRAPH-8CDE
        0x8CE6, # G+4648  U+8CE6  uni8CE6,  CJK UNIFIED IDEOGRAPH-8CE6
        0x8CE4, # G+4649  U+8CE4  uni8CE4,  CJK UNIFIED IDEOGRAPH-8CE4
        0x8CEC, # G+4650  U+8CEC  uni8CEC,  CJK UNIFIED IDEOGRAPH-8CEC
        0x8CED, # G+4651  U+8CED  uni8CED,  CJK UNIFIED IDEOGRAPH-8CED
        0x8CE2, # G+4652  U+8CE2  uni8CE2,  CJK UNIFIED IDEOGRAPH-8CE2
        0x8CE3, # G+4653  U+8CE3  uni8CE3,  CJK UNIFIED IDEOGRAPH-8CE3
        0x8CDC, # G+4654  U+8CDC  uni8CDC,  CJK UNIFIED IDEOGRAPH-8CDC
        0x8CEA, # G+4655  U+8CEA  uni8CEA,  CJK UNIFIED IDEOGRAPH-8CEA
        0x8CE1, # G+4656  U+8CE1  uni8CE1,  CJK UNIFIED IDEOGRAPH-8CE1
        0x8D6D, # G+4657  U+8D6D  uni8D6D,  CJK UNIFIED IDEOGRAPH-8D6D
        0x8D9F, # G+4658  U+8D9F  uni8D9F,  CJK UNIFIED IDEOGRAPH-8D9F
        0x8DA3, # G+4659  U+8DA3  uni8DA3,  CJK UNIFIED IDEOGRAPH-8DA3
        0x8E2B, # G+4660  U+8E2B  uni8E2B,  CJK UNIFIED IDEOGRAPH-8E2B
        0x8E10, # G+4661  U+8E10  uni8E10,  CJK UNIFIED IDEOGRAPH-8E10
        0x8E1D, # G+4662  U+8E1D  uni8E1D,  CJK UNIFIED IDEOGRAPH-8E1D
        0x8E22, # G+4663  U+8E22  uni8E22,  CJK UNIFIED IDEOGRAPH-8E22
        0x8E0F, # G+4664  U+8E0F  uni8E0F,  CJK UNIFIED IDEOGRAPH-8E0F
        0x8E29, # G+4665  U+8E29  uni8E29,  CJK UNIFIED IDEOGRAPH-8E29
        0x8E1F, # G+4666  U+8E1F  uni8E1F,  CJK UNIFIED IDEOGRAPH-8E1F
        0x8E21, # G+4667  U+8E21  uni8E21,  CJK UNIFIED IDEOGRAPH-8E21
        0x8E1E, # G+4668  U+8E1E  uni8E1E,  CJK UNIFIED IDEOGRAPH-8E1E
        0x8EBA, # G+4669  U+8EBA  uni8EBA,  CJK UNIFIED IDEOGRAPH-8EBA
        0x8F1D, # G+4670  U+8F1D  uni8F1D,  CJK UNIFIED IDEOGRAPH-8F1D
        0x8F1B, # G+4671  U+8F1B  uni8F1B,  CJK UNIFIED IDEOGRAPH-8F1B
        0x8F1F, # G+4672  U+8F1F  uni8F1F,  CJK UNIFIED IDEOGRAPH-8F1F
        0x8F29, # G+4673  U+8F29  uni8F29,  CJK UNIFIED IDEOGRAPH-8F29
        0x8F26, # G+4674  U+8F26  uni8F26,  CJK UNIFIED IDEOGRAPH-8F26
        0x8F2A, # G+4675  U+8F2A  uni8F2A,  CJK UNIFIED IDEOGRAPH-8F2A
        0x8F1C, # G+4676  U+8F1C  uni8F1C,  CJK UNIFIED IDEOGRAPH-8F1C
        0x8F1E, # G+4677  U+8F1E  uni8F1E,  CJK UNIFIED IDEOGRAPH-8F1E
        0x8F25, # G+4678  U+8F25  uni8F25,  CJK UNIFIED IDEOGRAPH-8F25
        0x9069, # G+4679  U+9069  uni9069,  CJK UNIFIED IDEOGRAPH-9069
        0x906E, # G+4680  U+906E  uni906E,  CJK UNIFIED IDEOGRAPH-906E
        0x9068, # G+4681  U+9068  uni9068,  CJK UNIFIED IDEOGRAPH-9068
        0x906D, # G+4682  U+906D  uni906D,  CJK UNIFIED IDEOGRAPH-906D
        0x9077, # G+4683  U+9077  uni9077,  CJK UNIFIED IDEOGRAPH-9077
        0x9130, # G+4684  U+9130  uni9130,  CJK UNIFIED IDEOGRAPH-9130
        0x912D, # G+4685  U+912D  uni912D,  CJK UNIFIED IDEOGRAPH-912D
        0x9127, # G+4686  U+9127  uni9127,  CJK UNIFIED IDEOGRAPH-9127
        0x9131, # G+4687  U+9131  uni9131,  CJK UNIFIED IDEOGRAPH-9131
        0x9187, # G+4688  U+9187  uni9187,  CJK UNIFIED IDEOGRAPH-9187
        0x9189, # G+4689  U+9189  uni9189,  CJK UNIFIED IDEOGRAPH-9189
        0x918B, # G+4690  U+918B  uni918B,  CJK UNIFIED IDEOGRAPH-918B
        0x9183, # G+4691  U+9183  uni9183,  CJK UNIFIED IDEOGRAPH-9183
        0x92C5, # G+4692  U+92C5  uni92C5,  CJK UNIFIED IDEOGRAPH-92C5
        0x92BB, # G+4693  U+92BB  uni92BB,  CJK UNIFIED IDEOGRAPH-92BB
        0x92B7, # G+4694  U+92B7  uni92B7,  CJK UNIFIED IDEOGRAPH-92B7
        0x92EA, # G+4695  U+92EA  uni92EA,  CJK UNIFIED IDEOGRAPH-92EA
        0x92E4, # G+4696  U+92E4  uni92E4,  CJK UNIFIED IDEOGRAPH-92E4
        0x92C1, # G+4697  U+92C1  uni92C1,  CJK UNIFIED IDEOGRAPH-92C1
        0x92B3, # G+4698  U+92B3  uni92B3,  CJK UNIFIED IDEOGRAPH-92B3
        0x92BC, # G+4699  U+92BC  uni92BC,  CJK UNIFIED IDEOGRAPH-92BC
        0x92D2, # G+4700  U+92D2  uni92D2,  CJK UNIFIED IDEOGRAPH-92D2
        0x92C7, # G+4701  U+92C7  uni92C7,  CJK UNIFIED IDEOGRAPH-92C7
        0x92F0, # G+4702  U+92F0  uni92F0,  CJK UNIFIED IDEOGRAPH-92F0
        0x92B2, # G+4703  U+92B2  uni92B2,  CJK UNIFIED IDEOGRAPH-92B2
        0x95AD, # G+4704  U+95AD  uni95AD,  CJK UNIFIED IDEOGRAPH-95AD
        0x95B1, # G+4705  U+95B1  uni95B1,  CJK UNIFIED IDEOGRAPH-95B1
        0x9704, # G+4706  U+9704  uni9704,  CJK UNIFIED IDEOGRAPH-9704
        0x9706, # G+4707  U+9706  uni9706,  CJK UNIFIED IDEOGRAPH-9706
        0x9707, # G+4708  U+9707  uni9707,  CJK UNIFIED IDEOGRAPH-9707
        0x9709, # G+4709  U+9709  uni9709,  CJK UNIFIED IDEOGRAPH-9709
        0x9760, # G+4710  U+9760  uni9760,  CJK UNIFIED IDEOGRAPH-9760
        0x978D, # G+4711  U+978D  uni978D,  CJK UNIFIED IDEOGRAPH-978D
        0x978B, # G+4712  U+978B  uni978B,  CJK UNIFIED IDEOGRAPH-978B
        0x978F, # G+4713  U+978F  uni978F,  CJK UNIFIED IDEOGRAPH-978F
        0x9821, # G+4714  U+9821  uni9821,  CJK UNIFIED IDEOGRAPH-9821
        0x982B, # G+4715  U+982B  uni982B,  CJK UNIFIED IDEOGRAPH-982B
        0x981C, # G+4716  U+981C  uni981C,  CJK UNIFIED IDEOGRAPH-981C
        0x98B3, # G+4717  U+98B3  uni98B3,  CJK UNIFIED IDEOGRAPH-98B3
        0x990A, # G+4718  U+990A  uni990A,  CJK UNIFIED IDEOGRAPH-990A
        0x9913, # G+4719  U+9913  uni9913,  CJK UNIFIED IDEOGRAPH-9913
        0x9912, # G+4720  U+9912  uni9912,  CJK UNIFIED IDEOGRAPH-9912
        0x9918, # G+4721  U+9918  uni9918,  CJK UNIFIED IDEOGRAPH-9918
        0x99DD, # G+4722  U+99DD  uni99DD,  CJK UNIFIED IDEOGRAPH-99DD
        0x99D0, # G+4723  U+99D0  uni99D0,  CJK UNIFIED IDEOGRAPH-99D0
        0x99DF, # G+4724  U+99DF  uni99DF,  CJK UNIFIED IDEOGRAPH-99DF
        0x99DB, # G+4725  U+99DB  uni99DB,  CJK UNIFIED IDEOGRAPH-99DB
        0x99D1, # G+4726  U+99D1  uni99D1,  CJK UNIFIED IDEOGRAPH-99D1
        0x99D5, # G+4727  U+99D5  uni99D5,  CJK UNIFIED IDEOGRAPH-99D5
        0x99D2, # G+4728  U+99D2  uni99D2,  CJK UNIFIED IDEOGRAPH-99D2
        0x99D9, # G+4729  U+99D9  uni99D9,  CJK UNIFIED IDEOGRAPH-99D9
        0x9AB7, # G+4730  U+9AB7  uni9AB7,  CJK UNIFIED IDEOGRAPH-9AB7
        0x9AEE, # G+4731  U+9AEE  uni9AEE,  CJK UNIFIED IDEOGRAPH-9AEE
        0x9AEF, # G+4732  U+9AEF  uni9AEF,  CJK UNIFIED IDEOGRAPH-9AEF
        0x9B27, # G+4733  U+9B27  uni9B27,  CJK UNIFIED IDEOGRAPH-9B27
        0x9B45, # G+4734  U+9B45  uni9B45,  CJK UNIFIED IDEOGRAPH-9B45
        0x9B44, # G+4735  U+9B44  uni9B44,  CJK UNIFIED IDEOGRAPH-9B44
        0x9B77, # G+4736  U+9B77  uni9B77,  CJK UNIFIED IDEOGRAPH-9B77
        0x9B6F, # G+4737  U+9B6F  uni9B6F,  CJK UNIFIED IDEOGRAPH-9B6F
        0x9D06, # G+4738  U+9D06  uni9D06,  CJK UNIFIED IDEOGRAPH-9D06
        0x9D09, # G+4739  U+9D09  uni9D09,  CJK UNIFIED IDEOGRAPH-9D09
        0x9D03, # G+4740  U+9D03  uni9D03,  CJK UNIFIED IDEOGRAPH-9D03
        0x9EA9, # G+4741  U+9EA9  uni9EA9,  CJK UNIFIED IDEOGRAPH-9EA9
        0x9EBE, # G+4742  U+9EBE  uni9EBE,  CJK UNIFIED IDEOGRAPH-9EBE
        0x9ECE, # G+4743  U+9ECE  uni9ECE,  CJK UNIFIED IDEOGRAPH-9ECE
        0x58A8, # G+4744  U+58A8  uni58A8,  CJK UNIFIED IDEOGRAPH-58A8
        0x2FD2, # G+4745  U+2FD2  uni2FD2,  KANGXI RADICAL TOOTH
        0x5112, # G+4746  U+5112  uni5112,  CJK UNIFIED IDEOGRAPH-5112
        0x5118, # G+4747  U+5118  uni5118,  CJK UNIFIED IDEOGRAPH-5118
        0x5114, # G+4748  U+5114  uni5114,  CJK UNIFIED IDEOGRAPH-5114
        0x5110, # G+4749  U+5110  uni5110,  CJK UNIFIED IDEOGRAPH-5110
        0x5115, # G+4750  U+5115  uni5115,  CJK UNIFIED IDEOGRAPH-5115
        0x5180, # G+4751  U+5180  uni5180,  CJK UNIFIED IDEOGRAPH-5180
        0x51AA, # G+4752  U+51AA  uni51AA,  CJK UNIFIED IDEOGRAPH-51AA
        0x51DD, # G+4753  U+51DD  uni51DD,  CJK UNIFIED IDEOGRAPH-51DD
        0x5291, # G+4754  U+5291  uni5291,  CJK UNIFIED IDEOGRAPH-5291
        0x5293, # G+4755  U+5293  uni5293,  CJK UNIFIED IDEOGRAPH-5293
        0x52F3, # G+4756  U+52F3  uni52F3,  CJK UNIFIED IDEOGRAPH-52F3
        0x5659, # G+4757  U+5659  uni5659,  CJK UNIFIED IDEOGRAPH-5659
        0x566B, # G+4758  U+566B  uni566B,  CJK UNIFIED IDEOGRAPH-566B
        0x5679, # G+4759  U+5679  uni5679,  CJK UNIFIED IDEOGRAPH-5679
        0x5669, # G+4760  U+5669  uni5669,  CJK UNIFIED IDEOGRAPH-5669
        0x5664, # G+4761  U+5664  uni5664,  CJK UNIFIED IDEOGRAPH-5664
        0x5678, # G+4762  U+5678  uni5678,  CJK UNIFIED IDEOGRAPH-5678
        0x566A, # G+4763  U+566A  uni566A,  CJK UNIFIED IDEOGRAPH-566A
        0x5668, # G+4764  U+5668  uni5668,  CJK UNIFIED IDEOGRAPH-5668
        0x5665, # G+4765  U+5665  uni5665,  CJK UNIFIED IDEOGRAPH-5665
        0x5671, # G+4766  U+5671  uni5671,  CJK UNIFIED IDEOGRAPH-5671
        0x566F, # G+4767  U+566F  uni566F,  CJK UNIFIED IDEOGRAPH-566F
        0x566C, # G+4768  U+566C  uni566C,  CJK UNIFIED IDEOGRAPH-566C
        0x5662, # G+4769  U+5662  uni5662,  CJK UNIFIED IDEOGRAPH-5662
        0x5676, # G+4770  U+5676  uni5676,  CJK UNIFIED IDEOGRAPH-5676
        0x58C1, # G+4771  U+58C1  uni58C1,  CJK UNIFIED IDEOGRAPH-58C1
        0x58BE, # G+4772  U+58BE  uni58BE,  CJK UNIFIED IDEOGRAPH-58BE
        0x58C7, # G+4773  U+58C7  uni58C7,  CJK UNIFIED IDEOGRAPH-58C7
        0x58C5, # G+4774  U+58C5  uni58C5,  CJK UNIFIED IDEOGRAPH-58C5
        0x596E, # G+4775  U+596E  uni596E,  CJK UNIFIED IDEOGRAPH-596E
        0x5B1D, # G+4776  U+5B1D  uni5B1D,  CJK UNIFIED IDEOGRAPH-5B1D
        0x5B34, # G+4777  U+5B34  uni5B34,  CJK UNIFIED IDEOGRAPH-5B34
        0x5B78, # G+4778  U+5B78  uni5B78,  CJK UNIFIED IDEOGRAPH-5B78
        0x5BF0, # G+4779  U+5BF0  uni5BF0,  CJK UNIFIED IDEOGRAPH-5BF0
        0x5C0E, # G+4780  U+5C0E  uni5C0E,  CJK UNIFIED IDEOGRAPH-5C0E
        0x5F4A, # G+4781  U+5F4A  uni5F4A,  CJK UNIFIED IDEOGRAPH-5F4A
        0x61B2, # G+4782  U+61B2  uni61B2,  CJK UNIFIED IDEOGRAPH-61B2
        0x6191, # G+4783  U+6191  uni6191,  CJK UNIFIED IDEOGRAPH-6191
        0x61A9, # G+4784  U+61A9  uni61A9,  CJK UNIFIED IDEOGRAPH-61A9
        0x618A, # G+4785  U+618A  uni618A,  CJK UNIFIED IDEOGRAPH-618A
        0x61CD, # G+4786  U+61CD  uni61CD,  CJK UNIFIED IDEOGRAPH-61CD
        0x61B6, # G+4787  U+61B6  uni61B6,  CJK UNIFIED IDEOGRAPH-61B6
        0x61BE, # G+4788  U+61BE  uni61BE,  CJK UNIFIED IDEOGRAPH-61BE
        0x61CA, # G+4789  U+61CA  uni61CA,  CJK UNIFIED IDEOGRAPH-61CA
        0x61C8, # G+4790  U+61C8  uni61C8,  CJK UNIFIED IDEOGRAPH-61C8
        0x6230, # G+4791  U+6230  uni6230,  CJK UNIFIED IDEOGRAPH-6230
        0x64C5, # G+4792  U+64C5  uni64C5,  CJK UNIFIED IDEOGRAPH-64C5
        0x64C1, # G+4793  U+64C1  uni64C1,  CJK UNIFIED IDEOGRAPH-64C1
        0x64CB, # G+4794  U+64CB  uni64CB,  CJK UNIFIED IDEOGRAPH-64CB
        0x64BB, # G+4795  U+64BB  uni64BB,  CJK UNIFIED IDEOGRAPH-64BB
        0x64BC, # G+4796  U+64BC  uni64BC,  CJK UNIFIED IDEOGRAPH-64BC
        0x64DA, # G+4797  U+64DA  uni64DA,  CJK UNIFIED IDEOGRAPH-64DA
        0x64C4, # G+4798  U+64C4  uni64C4,  CJK UNIFIED IDEOGRAPH-64C4
        0x64C7, # G+4799  U+64C7  uni64C7,  CJK UNIFIED IDEOGRAPH-64C7
        0x64C2, # G+4800  U+64C2  uni64C2,  CJK UNIFIED IDEOGRAPH-64C2
        0x64CD, # G+4801  U+64CD  uni64CD,  CJK UNIFIED IDEOGRAPH-64CD
        0x64BF, # G+4802  U+64BF  uni64BF,  CJK UNIFIED IDEOGRAPH-64BF
        0x64D2, # G+4803  U+64D2  uni64D2,  CJK UNIFIED IDEOGRAPH-64D2
        0x64D4, # G+4804  U+64D4  uni64D4,  CJK UNIFIED IDEOGRAPH-64D4
        0x64BE, # G+4805  U+64BE  uni64BE,  CJK UNIFIED IDEOGRAPH-64BE
        0x6574, # G+4806  U+6574  uni6574,  CJK UNIFIED IDEOGRAPH-6574
        0x66C6, # G+4807  U+66C6  uni66C6,  CJK UNIFIED IDEOGRAPH-66C6
        0x66C9, # G+4808  U+66C9  uni66C9,  CJK UNIFIED IDEOGRAPH-66C9
        0x66B9, # G+4809  U+66B9  uni66B9,  CJK UNIFIED IDEOGRAPH-66B9
        0x66C4, # G+4810  U+66C4  uni66C4,  CJK UNIFIED IDEOGRAPH-66C4
        0x66C7, # G+4811  U+66C7  uni66C7,  CJK UNIFIED IDEOGRAPH-66C7
        0x66B8, # G+4812  U+66B8  uni66B8,  CJK UNIFIED IDEOGRAPH-66B8
        0x6A3D, # G+4813  U+6A3D  uni6A3D,  CJK UNIFIED IDEOGRAPH-6A3D
        0x6A38, # G+4814  U+6A38  uni6A38,  CJK UNIFIED IDEOGRAPH-6A38
        0x6A3A, # G+4815  U+6A3A  uni6A3A,  CJK UNIFIED IDEOGRAPH-6A3A
        0x6A59, # G+4816  U+6A59  uni6A59,  CJK UNIFIED IDEOGRAPH-6A59
        0x6A6B, # G+4817  U+6A6B  uni6A6B,  CJK UNIFIED IDEOGRAPH-6A6B
        0x6A58, # G+4818  U+6A58  uni6A58,  CJK UNIFIED IDEOGRAPH-6A58
        0x6A39, # G+4819  U+6A39  uni6A39,  CJK UNIFIED IDEOGRAPH-6A39
        0x6A44, # G+4820  U+6A44  uni6A44,  CJK UNIFIED IDEOGRAPH-6A44
        0x6A62, # G+4821  U+6A62  uni6A62,  CJK UNIFIED IDEOGRAPH-6A62
        0x6A61, # G+4822  U+6A61  uni6A61,  CJK UNIFIED IDEOGRAPH-6A61
        0x6A4B, # G+4823  U+6A4B  uni6A4B,  CJK UNIFIED IDEOGRAPH-6A4B
        0x6A47, # G+4824  U+6A47  uni6A47,  CJK UNIFIED IDEOGRAPH-6A47
        0x6A35, # G+4825  U+6A35  uni6A35,  CJK UNIFIED IDEOGRAPH-6A35
        0x6A5F, # G+4826  U+6A5F  uni6A5F,  CJK UNIFIED IDEOGRAPH-6A5F
        0x6A48, # G+4827  U+6A48  uni6A48,  CJK UNIFIED IDEOGRAPH-6A48
        0x6B59, # G+4828  U+6B59  uni6B59,  CJK UNIFIED IDEOGRAPH-6B59
        0x6B77, # G+4829  U+6B77  uni6B77,  CJK UNIFIED IDEOGRAPH-6B77
        0x6C05, # G+4830  U+6C05  uni6C05,  CJK UNIFIED IDEOGRAPH-6C05
        0x6FC2, # G+4831  U+6FC2  uni6FC2,  CJK UNIFIED IDEOGRAPH-6FC2
        0x6FB1, # G+4832  U+6FB1  uni6FB1,  CJK UNIFIED IDEOGRAPH-6FB1
        0x6FA1, # G+4833  U+6FA1  uni6FA1,  CJK UNIFIED IDEOGRAPH-6FA1
        0x6FC3, # G+4834  U+6FC3  uni6FC3,  CJK UNIFIED IDEOGRAPH-6FC3
        0x6FA4, # G+4835  U+6FA4  uni6FA4,  CJK UNIFIED IDEOGRAPH-6FA4
        0x6FC1, # G+4836  U+6FC1  uni6FC1,  CJK UNIFIED IDEOGRAPH-6FC1
        0x6FA7, # G+4837  U+6FA7  uni6FA7,  CJK UNIFIED IDEOGRAPH-6FA7
        0x6FB3, # G+4838  U+6FB3  uni6FB3,  CJK UNIFIED IDEOGRAPH-6FB3
        0x6FC0, # G+4839  U+6FC0  uni6FC0,  CJK UNIFIED IDEOGRAPH-6FC0
        0x6FB9, # G+4840  U+6FB9  uni6FB9,  CJK UNIFIED IDEOGRAPH-6FB9
        0x6FB6, # G+4841  U+6FB6  uni6FB6,  CJK UNIFIED IDEOGRAPH-6FB6
        0x6FA6, # G+4842  U+6FA6  uni6FA6,  CJK UNIFIED IDEOGRAPH-6FA6
        0x6FA0, # G+4843  U+6FA0  uni6FA0,  CJK UNIFIED IDEOGRAPH-6FA0
        0x6FB4, # G+4844  U+6FB4  uni6FB4,  CJK UNIFIED IDEOGRAPH-6FB4
        0x71BE, # G+4845  U+71BE  uni71BE,  CJK UNIFIED IDEOGRAPH-71BE
        0x71C9, # G+4846  U+71C9  uni71C9,  CJK UNIFIED IDEOGRAPH-71C9
        0x71D0, # G+4847  U+71D0  uni71D0,  CJK UNIFIED IDEOGRAPH-71D0
        0x71D2, # G+4848  U+71D2  uni71D2,  CJK UNIFIED IDEOGRAPH-71D2
        0x71C8, # G+4849  U+71C8  uni71C8,  CJK UNIFIED IDEOGRAPH-71C8
        0x71D5, # G+4850  U+71D5  uni71D5,  CJK UNIFIED IDEOGRAPH-71D5
        0x71B9, # G+4851  U+71B9  uni71B9,  CJK UNIFIED IDEOGRAPH-71B9
        0x71CE, # G+4852  U+71CE  uni71CE,  CJK UNIFIED IDEOGRAPH-71CE
        0x71D9, # G+4853  U+71D9  uni71D9,  CJK UNIFIED IDEOGRAPH-71D9
        0x71DC, # G+4854  U+71DC  uni71DC,  CJK UNIFIED IDEOGRAPH-71DC
        0x71C3, # G+4855  U+71C3  uni71C3,  CJK UNIFIED IDEOGRAPH-71C3
        0x71C4, # G+4856  U+71C4  uni71C4,  CJK UNIFIED IDEOGRAPH-71C4
        0x7368, # G+4857  U+7368  uni7368,  CJK UNIFIED IDEOGRAPH-7368
        0x749C, # G+4858  U+749C  uni749C,  CJK UNIFIED IDEOGRAPH-749C
        0x74A3, # G+4859  U+74A3  uni74A3,  CJK UNIFIED IDEOGRAPH-74A3
        0x7498, # G+4860  U+7498  uni7498,  CJK UNIFIED IDEOGRAPH-7498
        0x749F, # G+4861  U+749F  uni749F,  CJK UNIFIED IDEOGRAPH-749F
        0x749E, # G+4862  U+749E  uni749E,  CJK UNIFIED IDEOGRAPH-749E
        0x74E2, # G+4863  U+74E2  uni74E2,  CJK UNIFIED IDEOGRAPH-74E2
        0x750C, # G+4864  U+750C  uni750C,  CJK UNIFIED IDEOGRAPH-750C
        0x750D, # G+4865  U+750D  uni750D,  CJK UNIFIED IDEOGRAPH-750D
        0x7634, # G+4866  U+7634  uni7634,  CJK UNIFIED IDEOGRAPH-7634
        0x7638, # G+4867  U+7638  uni7638,  CJK UNIFIED IDEOGRAPH-7638
        0x763A, # G+4868  U+763A  uni763A,  CJK UNIFIED IDEOGRAPH-763A
        0x76E7, # G+4869  U+76E7  uni76E7,  CJK UNIFIED IDEOGRAPH-76E7
        0x76E5, # G+4870  U+76E5  uni76E5,  CJK UNIFIED IDEOGRAPH-76E5
        0x77A0, # G+4871  U+77A0  uni77A0,  CJK UNIFIED IDEOGRAPH-77A0
        0x779E, # G+4872  U+779E  uni779E,  CJK UNIFIED IDEOGRAPH-779E
        0x779F, # G+4873  U+779F  uni779F,  CJK UNIFIED IDEOGRAPH-779F
        0x77A5, # G+4874  U+77A5  uni77A5,  CJK UNIFIED IDEOGRAPH-77A5
        0x78E8, # G+4875  U+78E8  uni78E8,  CJK UNIFIED IDEOGRAPH-78E8
        0x78DA, # G+4876  U+78DA  uni78DA,  CJK UNIFIED IDEOGRAPH-78DA
        0x78EC, # G+4877  U+78EC  uni78EC,  CJK UNIFIED IDEOGRAPH-78EC
        0x78E7, # G+4878  U+78E7  uni78E7,  CJK UNIFIED IDEOGRAPH-78E7
        0x79A6, # G+4879  U+79A6  uni79A6,  CJK UNIFIED IDEOGRAPH-79A6
        0x7A4D, # G+4880  U+7A4D  uni7A4D,  CJK UNIFIED IDEOGRAPH-7A4D
        0x7A4E, # G+4881  U+7A4E  uni7A4E,  CJK UNIFIED IDEOGRAPH-7A4E
        0x7A46, # G+4882  U+7A46  uni7A46,  CJK UNIFIED IDEOGRAPH-7A46
        0x7A4C, # G+4883  U+7A4C  uni7A4C,  CJK UNIFIED IDEOGRAPH-7A4C
        0x7A4B, # G+4884  U+7A4B  uni7A4B,  CJK UNIFIED IDEOGRAPH-7A4B
        0x7ABA, # G+4885  U+7ABA  uni7ABA,  CJK UNIFIED IDEOGRAPH-7ABA
        0x7BD9, # G+4886  U+7BD9  uni7BD9,  CJK UNIFIED IDEOGRAPH-7BD9
        0x7C11, # G+4887  U+7C11  uni7C11,  CJK UNIFIED IDEOGRAPH-7C11
        0x7BC9, # G+4888  U+7BC9  uni7BC9,  CJK UNIFIED IDEOGRAPH-7BC9
        0x7BE4, # G+4889  U+7BE4  uni7BE4,  CJK UNIFIED IDEOGRAPH-7BE4
        0x7BDB, # G+4890  U+7BDB  uni7BDB,  CJK UNIFIED IDEOGRAPH-7BDB
        0x7BE1, # G+4891  U+7BE1  uni7BE1,  CJK UNIFIED IDEOGRAPH-7BE1
        0x7BE9, # G+4892  U+7BE9  uni7BE9,  CJK UNIFIED IDEOGRAPH-7BE9
        0x7BE6, # G+4893  U+7BE6  uni7BE6,  CJK UNIFIED IDEOGRAPH-7BE6
        0x7CD5, # G+4894  U+7CD5  uni7CD5,  CJK UNIFIED IDEOGRAPH-7CD5
        0x7CD6, # G+4895  U+7CD6  uni7CD6,  CJK UNIFIED IDEOGRAPH-7CD6
        0x7E0A, # G+4896  U+7E0A  uni7E0A,  CJK UNIFIED IDEOGRAPH-7E0A
        0x7E11, # G+4897  U+7E11  uni7E11,  CJK UNIFIED IDEOGRAPH-7E11
        0x7E08, # G+4898  U+7E08  uni7E08,  CJK UNIFIED IDEOGRAPH-7E08
        0x7E1B, # G+4899  U+7E1B  uni7E1B,  CJK UNIFIED IDEOGRAPH-7E1B
        0x7E23, # G+4900  U+7E23  uni7E23,  CJK UNIFIED IDEOGRAPH-7E23
        0x7E1E, # G+4901  U+7E1E  uni7E1E,  CJK UNIFIED IDEOGRAPH-7E1E
        0x7E1D, # G+4902  U+7E1D  uni7E1D,  CJK UNIFIED IDEOGRAPH-7E1D
        0x7E09, # G+4903  U+7E09  uni7E09,  CJK UNIFIED IDEOGRAPH-7E09
        0x7E10, # G+4904  U+7E10  uni7E10,  CJK UNIFIED IDEOGRAPH-7E10
        0x7F79, # G+4905  U+7F79  uni7F79,  CJK UNIFIED IDEOGRAPH-7F79
        0x7FB2, # G+4906  U+7FB2  uni7FB2,  CJK UNIFIED IDEOGRAPH-7FB2
        0x7FF0, # G+4907  U+7FF0  uni7FF0,  CJK UNIFIED IDEOGRAPH-7FF0
        0x7FF1, # G+4908  U+7FF1  uni7FF1,  CJK UNIFIED IDEOGRAPH-7FF1
        0x7FEE, # G+4909  U+7FEE  uni7FEE,  CJK UNIFIED IDEOGRAPH-7FEE
        0x8028, # G+4910  U+8028  uni8028,  CJK UNIFIED IDEOGRAPH-8028
        0x81B3, # G+4911  U+81B3  uni81B3,  CJK UNIFIED IDEOGRAPH-81B3
        0x81A9, # G+4912  U+81A9  uni81A9,  CJK UNIFIED IDEOGRAPH-81A9
        0x81A8, # G+4913  U+81A8  uni81A8,  CJK UNIFIED IDEOGRAPH-81A8
        0x81FB, # G+4914  U+81FB  uni81FB,  CJK UNIFIED IDEOGRAPH-81FB
        0x8208, # G+4915  U+8208  uni8208,  CJK UNIFIED IDEOGRAPH-8208
        0x8258, # G+4916  U+8258  uni8258,  CJK UNIFIED IDEOGRAPH-8258
        0x8259, # G+4917  U+8259  uni8259,  CJK UNIFIED IDEOGRAPH-8259
        0x854A, # G+4918  U+854A  uni854A,  CJK UNIFIED IDEOGRAPH-854A
        0x8559, # G+4919  U+8559  uni8559,  CJK UNIFIED IDEOGRAPH-8559
        0x8548, # G+4920  U+8548  uni8548,  CJK UNIFIED IDEOGRAPH-8548
        0x8568, # G+4921  U+8568  uni8568,  CJK UNIFIED IDEOGRAPH-8568
        0x8569, # G+4922  U+8569  uni8569,  CJK UNIFIED IDEOGRAPH-8569
        0x8543, # G+4923  U+8543  uni8543,  CJK UNIFIED IDEOGRAPH-8543
        0x8549, # G+4924  U+8549  uni8549,  CJK UNIFIED IDEOGRAPH-8549
        0x856D, # G+4925  U+856D  uni856D,  CJK UNIFIED IDEOGRAPH-856D
        0x856A, # G+4926  U+856A  uni856A,  CJK UNIFIED IDEOGRAPH-856A
        0x855E, # G+4927  U+855E  uni855E,  CJK UNIFIED IDEOGRAPH-855E
        0x8783, # G+4928  U+8783  uni8783,  CJK UNIFIED IDEOGRAPH-8783
        0x879F, # G+4929  U+879F  uni879F,  CJK UNIFIED IDEOGRAPH-879F
        0x879E, # G+4930  U+879E  uni879E,  CJK UNIFIED IDEOGRAPH-879E
        0x87A2, # G+4931  U+87A2  uni87A2,  CJK UNIFIED IDEOGRAPH-87A2
        0x878D, # G+4932  U+878D  uni878D,  CJK UNIFIED IDEOGRAPH-878D
        0x8861, # G+4933  U+8861  uni8861,  CJK UNIFIED IDEOGRAPH-8861
        0x892A, # G+4934  U+892A  uni892A,  CJK UNIFIED IDEOGRAPH-892A
        0x8932, # G+4935  U+8932  uni8932,  CJK UNIFIED IDEOGRAPH-8932
        0x8925, # G+4936  U+8925  uni8925,  CJK UNIFIED IDEOGRAPH-8925
        0x892B, # G+4937  U+892B  uni892B,  CJK UNIFIED IDEOGRAPH-892B
        0x8921, # G+4938  U+8921  uni8921,  CJK UNIFIED IDEOGRAPH-8921
        0x89AA, # G+4939  U+89AA  uni89AA,  CJK UNIFIED IDEOGRAPH-89AA
        0x89A6, # G+4940  U+89A6  uni89A6,  CJK UNIFIED IDEOGRAPH-89A6
        0x8AE6, # G+4941  U+8AE6  uni8AE6,  CJK UNIFIED IDEOGRAPH-8AE6
        0x8AFA, # G+4942  U+8AFA  uni8AFA,  CJK UNIFIED IDEOGRAPH-8AFA
        0x8AEB, # G+4943  U+8AEB  uni8AEB,  CJK UNIFIED IDEOGRAPH-8AEB
        0x8AF1, # G+4944  U+8AF1  uni8AF1,  CJK UNIFIED IDEOGRAPH-8AF1
        0x8B00, # G+4945  U+8B00  uni8B00,  CJK UNIFIED IDEOGRAPH-8B00
        0x8ADC, # G+4946  U+8ADC  uni8ADC,  CJK UNIFIED IDEOGRAPH-8ADC
        0x8AE7, # G+4947  U+8AE7  uni8AE7,  CJK UNIFIED IDEOGRAPH-8AE7
        0x8AEE, # G+4948  U+8AEE  uni8AEE,  CJK UNIFIED IDEOGRAPH-8AEE
        0x8AFE, # G+4949  U+8AFE  uni8AFE,  CJK UNIFIED IDEOGRAPH-8AFE
        0x8B01, # G+4950  U+8B01  uni8B01,  CJK UNIFIED IDEOGRAPH-8B01
        0x8B02, # G+4951  U+8B02  uni8B02,  CJK UNIFIED IDEOGRAPH-8B02
        0x8AF7, # G+4952  U+8AF7  uni8AF7,  CJK UNIFIED IDEOGRAPH-8AF7
        0x8AED, # G+4953  U+8AED  uni8AED,  CJK UNIFIED IDEOGRAPH-8AED
        0x8AF3, # G+4954  U+8AF3  uni8AF3,  CJK UNIFIED IDEOGRAPH-8AF3
        0x8AF6, # G+4955  U+8AF6  uni8AF6,  CJK UNIFIED IDEOGRAPH-8AF6
        0x8AFC, # G+4956  U+8AFC  uni8AFC,  CJK UNIFIED IDEOGRAPH-8AFC
        0x8C6B, # G+4957  U+8C6B  uni8C6B,  CJK UNIFIED IDEOGRAPH-8C6B
        0x8C6D, # G+4958  U+8C6D  uni8C6D,  CJK UNIFIED IDEOGRAPH-8C6D
        0x8C93, # G+4959  U+8C93  uni8C93,  CJK UNIFIED IDEOGRAPH-8C93
        0x8CF4, # G+4960  U+8CF4  uni8CF4,  CJK UNIFIED IDEOGRAPH-8CF4
        0x8E44, # G+4961  U+8E44  uni8E44,  CJK UNIFIED IDEOGRAPH-8E44
        0x8E31, # G+4962  U+8E31  uni8E31,  CJK UNIFIED IDEOGRAPH-8E31
        0x8E34, # G+4963  U+8E34  uni8E34,  CJK UNIFIED IDEOGRAPH-8E34
        0x8E42, # G+4964  U+8E42  uni8E42,  CJK UNIFIED IDEOGRAPH-8E42
        0x8E39, # G+4965  U+8E39  uni8E39,  CJK UNIFIED IDEOGRAPH-8E39
        0x8E35, # G+4966  U+8E35  uni8E35,  CJK UNIFIED IDEOGRAPH-8E35
        0x8F3B, # G+4967  U+8F3B  uni8F3B,  CJK UNIFIED IDEOGRAPH-8F3B
        0x8F2F, # G+4968  U+8F2F  uni8F2F,  CJK UNIFIED IDEOGRAPH-8F2F
        0x8F38, # G+4969  U+8F38  uni8F38,  CJK UNIFIED IDEOGRAPH-8F38
        0x8F33, # G+4970  U+8F33  uni8F33,  CJK UNIFIED IDEOGRAPH-8F33
        0x8FA8, # G+4971  U+8FA8  uni8FA8,  CJK UNIFIED IDEOGRAPH-8FA8
        0x8FA6, # G+4972  U+8FA6  uni8FA6,  CJK UNIFIED IDEOGRAPH-8FA6
        0x9075, # G+4973  U+9075  uni9075,  CJK UNIFIED IDEOGRAPH-9075
        0x9074, # G+4974  U+9074  uni9074,  CJK UNIFIED IDEOGRAPH-9074
        0x9078, # G+4975  U+9078  uni9078,  CJK UNIFIED IDEOGRAPH-9078
        0x9072, # G+4976  U+9072  uni9072,  CJK UNIFIED IDEOGRAPH-9072
        0x907C, # G+4977  U+907C  uni907C,  CJK UNIFIED IDEOGRAPH-907C
        0x907A, # G+4978  U+907A  uni907A,  CJK UNIFIED IDEOGRAPH-907A
        0x9134, # G+4979  U+9134  uni9134,  CJK UNIFIED IDEOGRAPH-9134
        0x9192, # G+4980  U+9192  uni9192,  CJK UNIFIED IDEOGRAPH-9192
        0x9320, # G+4981  U+9320  uni9320,  CJK UNIFIED IDEOGRAPH-9320
        0x9336, # G+4982  U+9336  uni9336,  CJK UNIFIED IDEOGRAPH-9336
        0x92F8, # G+4983  U+92F8  uni92F8,  CJK UNIFIED IDEOGRAPH-92F8
        0x9333, # G+4984  U+9333  uni9333,  CJK UNIFIED IDEOGRAPH-9333
        0x932F, # G+4985  U+932F  uni932F,  CJK UNIFIED IDEOGRAPH-932F
        0x9322, # G+4986  U+9322  uni9322,  CJK UNIFIED IDEOGRAPH-9322
        0x92FC, # G+4987  U+92FC  uni92FC,  CJK UNIFIED IDEOGRAPH-92FC
        0x932B, # G+4988  U+932B  uni932B,  CJK UNIFIED IDEOGRAPH-932B
        0x9304, # G+4989  U+9304  uni9304,  CJK UNIFIED IDEOGRAPH-9304
        0x931A, # G+4990  U+931A  uni931A,  CJK UNIFIED IDEOGRAPH-931A
        0x9310, # G+4991  U+9310  uni9310,  CJK UNIFIED IDEOGRAPH-9310
        0x9326, # G+4992  U+9326  uni9326,  CJK UNIFIED IDEOGRAPH-9326
        0x9321, # G+4993  U+9321  uni9321,  CJK UNIFIED IDEOGRAPH-9321
        0x9315, # G+4994  U+9315  uni9315,  CJK UNIFIED IDEOGRAPH-9315
        0x932E, # G+4995  U+932E  uni932E,  CJK UNIFIED IDEOGRAPH-932E
        0x9319, # G+4996  U+9319  uni9319,  CJK UNIFIED IDEOGRAPH-9319
        0x95BB, # G+4997  U+95BB  uni95BB,  CJK UNIFIED IDEOGRAPH-95BB
        0x96A7, # G+4998  U+96A7  uni96A7,  CJK UNIFIED IDEOGRAPH-96A7
        0x96A8, # G+4999  U+96A8  uni96A8,  CJK UNIFIED IDEOGRAPH-96A8
        0x96AA, # G+5000  U+96AA  uni96AA,  CJK UNIFIED IDEOGRAPH-96AA
        0x96D5, # G+5001  U+96D5  uni96D5,  CJK UNIFIED IDEOGRAPH-96D5
        0x970E, # G+5002  U+970E  uni970E,  CJK UNIFIED IDEOGRAPH-970E
        0x9711, # G+5003  U+9711  uni9711,  CJK UNIFIED IDEOGRAPH-9711
        0x9716, # G+5004  U+9716  uni9716,  CJK UNIFIED IDEOGRAPH-9716
        0x970D, # G+5005  U+970D  uni970D,  CJK UNIFIED IDEOGRAPH-970D
        0x9713, # G+5006  U+9713  uni9713,  CJK UNIFIED IDEOGRAPH-9713
        0x970F, # G+5007  U+970F  uni970F,  CJK UNIFIED IDEOGRAPH-970F
        0x975B, # G+5008  U+975B  uni975B,  CJK UNIFIED IDEOGRAPH-975B
        0xE4C5, # G+5009  U+E4C5  uniE4C5,  
        0x9766, # G+5010  U+9766  uni9766,  CJK UNIFIED IDEOGRAPH-9766
        0x9798, # G+5011  U+9798  uni9798,  CJK UNIFIED IDEOGRAPH-9798
        0x9830, # G+5012  U+9830  uni9830,  CJK UNIFIED IDEOGRAPH-9830
        0x9838, # G+5013  U+9838  uni9838,  CJK UNIFIED IDEOGRAPH-9838
        0x983B, # G+5014  U+983B  uni983B,  CJK UNIFIED IDEOGRAPH-983B
        0x9837, # G+5015  U+9837  uni9837,  CJK UNIFIED IDEOGRAPH-9837
        0x982D, # G+5016  U+982D  uni982D,  CJK UNIFIED IDEOGRAPH-982D
        0x9839, # G+5017  U+9839  uni9839,  CJK UNIFIED IDEOGRAPH-9839
        0x9824, # G+5018  U+9824  uni9824,  CJK UNIFIED IDEOGRAPH-9824
        0x9910, # G+5019  U+9910  uni9910,  CJK UNIFIED IDEOGRAPH-9910
        0x9928, # G+5020  U+9928  uni9928,  CJK UNIFIED IDEOGRAPH-9928
        0x991E, # G+5021  U+991E  uni991E,  CJK UNIFIED IDEOGRAPH-991E
        0x991B, # G+5022  U+991B  uni991B,  CJK UNIFIED IDEOGRAPH-991B
        0x9921, # G+5023  U+9921  uni9921,  CJK UNIFIED IDEOGRAPH-9921
        0x991A, # G+5024  U+991A  uni991A,  CJK UNIFIED IDEOGRAPH-991A
        0x99ED, # G+5025  U+99ED  uni99ED,  CJK UNIFIED IDEOGRAPH-99ED
        0x99E2, # G+5026  U+99E2  uni99E2,  CJK UNIFIED IDEOGRAPH-99E2
        0x99F1, # G+5027  U+99F1  uni99F1,  CJK UNIFIED IDEOGRAPH-99F1
        0x9AB8, # G+5028  U+9AB8  uni9AB8,  CJK UNIFIED IDEOGRAPH-9AB8
        0x9ABC, # G+5029  U+9ABC  uni9ABC,  CJK UNIFIED IDEOGRAPH-9ABC
        0x9AFB, # G+5030  U+9AFB  uni9AFB,  CJK UNIFIED IDEOGRAPH-9AFB
        0x9AED, # G+5031  U+9AED  uni9AED,  CJK UNIFIED IDEOGRAPH-9AED
        0x9B28, # G+5032  U+9B28  uni9B28,  CJK UNIFIED IDEOGRAPH-9B28
        0x9B91, # G+5033  U+9B91  uni9B91,  CJK UNIFIED IDEOGRAPH-9B91
        0x9D15, # G+5034  U+9D15  uni9D15,  CJK UNIFIED IDEOGRAPH-9D15
        0x9D23, # G+5035  U+9D23  uni9D23,  CJK UNIFIED IDEOGRAPH-9D23
        0x9D26, # G+5036  U+9D26  uni9D26,  CJK UNIFIED IDEOGRAPH-9D26
        0x9D28, # G+5037  U+9D28  uni9D28,  CJK UNIFIED IDEOGRAPH-9D28
        0x9D12, # G+5038  U+9D12  uni9D12,  CJK UNIFIED IDEOGRAPH-9D12
        0x9D1B, # G+5039  U+9D1B  uni9D1B,  CJK UNIFIED IDEOGRAPH-9D1B
        0x9ED8, # G+5040  U+9ED8  uni9ED8,  CJK UNIFIED IDEOGRAPH-9ED8
        0x9ED4, # G+5041  U+9ED4  uni9ED4,  CJK UNIFIED IDEOGRAPH-9ED4
        0x9F8D, # G+5042  U+9F8D  uni9F8D,  CJK UNIFIED IDEOGRAPH-9F8D
        0x9F9C, # G+5043  U+9F9C  uni9F9C,  CJK UNIFIED IDEOGRAPH-9F9C
        0x512A, # G+5044  U+512A  uni512A,  CJK UNIFIED IDEOGRAPH-512A
        0x511F, # G+5045  U+511F  uni511F,  CJK UNIFIED IDEOGRAPH-511F
        0x5121, # G+5046  U+5121  uni5121,  CJK UNIFIED IDEOGRAPH-5121
        0x5132, # G+5047  U+5132  uni5132,  CJK UNIFIED IDEOGRAPH-5132
        0x52F5, # G+5048  U+52F5  uni52F5,  CJK UNIFIED IDEOGRAPH-52F5
        0x568E, # G+5049  U+568E  uni568E,  CJK UNIFIED IDEOGRAPH-568E
        0x5680, # G+5050  U+5680  uni5680,  CJK UNIFIED IDEOGRAPH-5680
        0x5690, # G+5051  U+5690  uni5690,  CJK UNIFIED IDEOGRAPH-5690
        0x5685, # G+5052  U+5685  uni5685,  CJK UNIFIED IDEOGRAPH-5685
        0x5687, # G+5053  U+5687  uni5687,  CJK UNIFIED IDEOGRAPH-5687
        0x568F, # G+5054  U+568F  uni568F,  CJK UNIFIED IDEOGRAPH-568F
        0x58D5, # G+5055  U+58D5  uni58D5,  CJK UNIFIED IDEOGRAPH-58D5
        0x58D3, # G+5056  U+58D3  uni58D3,  CJK UNIFIED IDEOGRAPH-58D3
        0x58D1, # G+5057  U+58D1  uni58D1,  CJK UNIFIED IDEOGRAPH-58D1
        0x58CE, # G+5058  U+58CE  uni58CE,  CJK UNIFIED IDEOGRAPH-58CE
        0x5B30, # G+5059  U+5B30  uni5B30,  CJK UNIFIED IDEOGRAPH-5B30
        0x5B2A, # G+5060  U+5B2A  uni5B2A,  CJK UNIFIED IDEOGRAPH-5B2A
        0x5B24, # G+5061  U+5B24  uni5B24,  CJK UNIFIED IDEOGRAPH-5B24
        0x5B7A, # G+5062  U+5B7A  uni5B7A,  CJK UNIFIED IDEOGRAPH-5B7A
        0x5C37, # G+5063  U+5C37  uni5C37,  CJK UNIFIED IDEOGRAPH-5C37
        0x5C68, # G+5064  U+5C68  uni5C68,  CJK UNIFIED IDEOGRAPH-5C68
        0x5DBC, # G+5065  U+5DBC  uni5DBC,  CJK UNIFIED IDEOGRAPH-5DBC
        0x5DBA, # G+5066  U+5DBA  uni5DBA,  CJK UNIFIED IDEOGRAPH-5DBA
        0x5DBD, # G+5067  U+5DBD  uni5DBD,  CJK UNIFIED IDEOGRAPH-5DBD
        0x5DB8, # G+5068  U+5DB8  uni5DB8,  CJK UNIFIED IDEOGRAPH-5DB8
        0x5E6B, # G+5069  U+5E6B  uni5E6B,  CJK UNIFIED IDEOGRAPH-5E6B
        0x5F4C, # G+5070  U+5F4C  uni5F4C,  CJK UNIFIED IDEOGRAPH-5F4C
        0x5FBD, # G+5071  U+5FBD  uni5FBD,  CJK UNIFIED IDEOGRAPH-5FBD
        0x61C9, # G+5072  U+61C9  uni61C9,  CJK UNIFIED IDEOGRAPH-61C9
        0x61C2, # G+5073  U+61C2  uni61C2,  CJK UNIFIED IDEOGRAPH-61C2
        0x61C7, # G+5074  U+61C7  uni61C7,  CJK UNIFIED IDEOGRAPH-61C7
        0x61E6, # G+5075  U+61E6  uni61E6,  CJK UNIFIED IDEOGRAPH-61E6
        0x61CB, # G+5076  U+61CB  uni61CB,  CJK UNIFIED IDEOGRAPH-61CB
        0x6232, # G+5077  U+6232  uni6232,  CJK UNIFIED IDEOGRAPH-6232
        0x6234, # G+5078  U+6234  uni6234,  CJK UNIFIED IDEOGRAPH-6234
        0x64CE, # G+5079  U+64CE  uni64CE,  CJK UNIFIED IDEOGRAPH-64CE
        0x64CA, # G+5080  U+64CA  uni64CA,  CJK UNIFIED IDEOGRAPH-64CA
        0x64D8, # G+5081  U+64D8  uni64D8,  CJK UNIFIED IDEOGRAPH-64D8
        0x64E0, # G+5082  U+64E0  uni64E0,  CJK UNIFIED IDEOGRAPH-64E0
        0x64F0, # G+5083  U+64F0  uni64F0,  CJK UNIFIED IDEOGRAPH-64F0
        0x64E6, # G+5084  U+64E6  uni64E6,  CJK UNIFIED IDEOGRAPH-64E6
        0x64EC, # G+5085  U+64EC  uni64EC,  CJK UNIFIED IDEOGRAPH-64EC
        0x64F1, # G+5086  U+64F1  uni64F1,  CJK UNIFIED IDEOGRAPH-64F1
        0x64E2, # G+5087  U+64E2  uni64E2,  CJK UNIFIED IDEOGRAPH-64E2
        0x64ED, # G+5088  U+64ED  uni64ED,  CJK UNIFIED IDEOGRAPH-64ED
        0x6582, # G+5089  U+6582  uni6582,  CJK UNIFIED IDEOGRAPH-6582
        0x6583, # G+5090  U+6583  uni6583,  CJK UNIFIED IDEOGRAPH-6583
        0x66D9, # G+5091  U+66D9  uni66D9,  CJK UNIFIED IDEOGRAPH-66D9
        0x66D6, # G+5092  U+66D6  uni66D6,  CJK UNIFIED IDEOGRAPH-66D6
        0x6A80, # G+5093  U+6A80  uni6A80,  CJK UNIFIED IDEOGRAPH-6A80
        0x6A94, # G+5094  U+6A94  uni6A94,  CJK UNIFIED IDEOGRAPH-6A94
        0x6A84, # G+5095  U+6A84  uni6A84,  CJK UNIFIED IDEOGRAPH-6A84
        0x6AA2, # G+5096  U+6AA2  uni6AA2,  CJK UNIFIED IDEOGRAPH-6AA2
        0x6A9C, # G+5097  U+6A9C  uni6A9C,  CJK UNIFIED IDEOGRAPH-6A9C
        0x6ADB, # G+5098  U+6ADB  uni6ADB,  CJK UNIFIED IDEOGRAPH-6ADB
        0x6AA3, # G+5099  U+6AA3  uni6AA3,  CJK UNIFIED IDEOGRAPH-6AA3
        0x6A7E, # G+5100  U+6A7E  uni6A7E,  CJK UNIFIED IDEOGRAPH-6A7E
        0x6A97, # G+5101  U+6A97  uni6A97,  CJK UNIFIED IDEOGRAPH-6A97
        0x6A90, # G+5102  U+6A90  uni6A90,  CJK UNIFIED IDEOGRAPH-6A90
        0x6AA0, # G+5103  U+6AA0  uni6AA0,  CJK UNIFIED IDEOGRAPH-6AA0
        0x6B5C, # G+5104  U+6B5C  uni6B5C,  CJK UNIFIED IDEOGRAPH-6B5C
        0x6BAE, # G+5105  U+6BAE  uni6BAE,  CJK UNIFIED IDEOGRAPH-6BAE
        0x6BDA, # G+5106  U+6BDA  uni6BDA,  CJK UNIFIED IDEOGRAPH-6BDA
        0x6C08, # G+5107  U+6C08  uni6C08,  CJK UNIFIED IDEOGRAPH-6C08
        0x6FD8, # G+5108  U+6FD8  uni6FD8,  CJK UNIFIED IDEOGRAPH-6FD8
        0x6FF1, # G+5109  U+6FF1  uni6FF1,  CJK UNIFIED IDEOGRAPH-6FF1
        0x6FDF, # G+5110  U+6FDF  uni6FDF,  CJK UNIFIED IDEOGRAPH-6FDF
        0x6FE0, # G+5111  U+6FE0  uni6FE0,  CJK UNIFIED IDEOGRAPH-6FE0
        0x6FDB, # G+5112  U+6FDB  uni6FDB,  CJK UNIFIED IDEOGRAPH-6FDB
        0x6FE4, # G+5113  U+6FE4  uni6FE4,  CJK UNIFIED IDEOGRAPH-6FE4
        0x6FEB, # G+5114  U+6FEB  uni6FEB,  CJK UNIFIED IDEOGRAPH-6FEB
        0x6FEF, # G+5115  U+6FEF  uni6FEF,  CJK UNIFIED IDEOGRAPH-6FEF
        0x6F80, # G+5116  U+6F80  uni6F80,  CJK UNIFIED IDEOGRAPH-6F80
        0x6FEC, # G+5117  U+6FEC  uni6FEC,  CJK UNIFIED IDEOGRAPH-6FEC
        0x6FE1, # G+5118  U+6FE1  uni6FE1,  CJK UNIFIED IDEOGRAPH-6FE1
        0x6FE9, # G+5119  U+6FE9  uni6FE9,  CJK UNIFIED IDEOGRAPH-6FE9
        0x6FD5, # G+5120  U+6FD5  uni6FD5,  CJK UNIFIED IDEOGRAPH-6FD5
        0x6FEE, # G+5121  U+6FEE  uni6FEE,  CJK UNIFIED IDEOGRAPH-6FEE
        0x6FF0, # G+5122  U+6FF0  uni6FF0,  CJK UNIFIED IDEOGRAPH-6FF0
        0x71E7, # G+5123  U+71E7  uni71E7,  CJK UNIFIED IDEOGRAPH-71E7
        0x71DF, # G+5124  U+71DF  uni71DF,  CJK UNIFIED IDEOGRAPH-71DF
        0x71EE, # G+5125  U+71EE  uni71EE,  CJK UNIFIED IDEOGRAPH-71EE
        0x71E6, # G+5126  U+71E6  uni71E6,  CJK UNIFIED IDEOGRAPH-71E6
        0x71E5, # G+5127  U+71E5  uni71E5,  CJK UNIFIED IDEOGRAPH-71E5
        0x71ED, # G+5128  U+71ED  uni71ED,  CJK UNIFIED IDEOGRAPH-71ED
        0x71EC, # G+5129  U+71EC  uni71EC,  CJK UNIFIED IDEOGRAPH-71EC
        0x71F4, # G+5130  U+71F4  uni71F4,  CJK UNIFIED IDEOGRAPH-71F4
        0x71E0, # G+5131  U+71E0  uni71E0,  CJK UNIFIED IDEOGRAPH-71E0
        0x7235, # G+5132  U+7235  uni7235,  CJK UNIFIED IDEOGRAPH-7235
        0x7246, # G+5133  U+7246  uni7246,  CJK UNIFIED IDEOGRAPH-7246
        0x7370, # G+5134  U+7370  uni7370,  CJK UNIFIED IDEOGRAPH-7370
        0x7372, # G+5135  U+7372  uni7372,  CJK UNIFIED IDEOGRAPH-7372
        0x74A9, # G+5136  U+74A9  uni74A9,  CJK UNIFIED IDEOGRAPH-74A9
        0x74B0, # G+5137  U+74B0  uni74B0,  CJK UNIFIED IDEOGRAPH-74B0
        0x74A6, # G+5138  U+74A6  uni74A6,  CJK UNIFIED IDEOGRAPH-74A6
        0x74A8, # G+5139  U+74A8  uni74A8,  CJK UNIFIED IDEOGRAPH-74A8
        0x7646, # G+5140  U+7646  uni7646,  CJK UNIFIED IDEOGRAPH-7646
        0x7642, # G+5141  U+7642  uni7642,  CJK UNIFIED IDEOGRAPH-7642
        0x764C, # G+5142  U+764C  uni764C,  CJK UNIFIED IDEOGRAPH-764C
        0x76EA, # G+5143  U+76EA  uni76EA,  CJK UNIFIED IDEOGRAPH-76EA
        0x77B3, # G+5144  U+77B3  uni77B3,  CJK UNIFIED IDEOGRAPH-77B3
        0x77AA, # G+5145  U+77AA  uni77AA,  CJK UNIFIED IDEOGRAPH-77AA
        0x77B0, # G+5146  U+77B0  uni77B0,  CJK UNIFIED IDEOGRAPH-77B0
        0x77AC, # G+5147  U+77AC  uni77AC,  CJK UNIFIED IDEOGRAPH-77AC
        0x77A7, # G+5148  U+77A7  uni77A7,  CJK UNIFIED IDEOGRAPH-77A7
        0x77AD, # G+5149  U+77AD  uni77AD,  CJK UNIFIED IDEOGRAPH-77AD
        0x77EF, # G+5150  U+77EF  uni77EF,  CJK UNIFIED IDEOGRAPH-77EF
        0x78F7, # G+5151  U+78F7  uni78F7,  CJK UNIFIED IDEOGRAPH-78F7
        0x78FA, # G+5152  U+78FA  uni78FA,  CJK UNIFIED IDEOGRAPH-78FA
        0x78F4, # G+5153  U+78F4  uni78F4,  CJK UNIFIED IDEOGRAPH-78F4
        0x78EF, # G+5154  U+78EF  uni78EF,  CJK UNIFIED IDEOGRAPH-78EF
        0x7901, # G+5155  U+7901  uni7901,  CJK UNIFIED IDEOGRAPH-7901
        0x79A7, # G+5156  U+79A7  uni79A7,  CJK UNIFIED IDEOGRAPH-79A7
        0x79AA, # G+5157  U+79AA  uni79AA,  CJK UNIFIED IDEOGRAPH-79AA
        0x7A57, # G+5158  U+7A57  uni7A57,  CJK UNIFIED IDEOGRAPH-7A57
        0x7ABF, # G+5159  U+7ABF  uni7ABF,  CJK UNIFIED IDEOGRAPH-7ABF
        0x7C07, # G+5160  U+7C07  uni7C07,  CJK UNIFIED IDEOGRAPH-7C07
        0x7C0D, # G+5161  U+7C0D  uni7C0D,  CJK UNIFIED IDEOGRAPH-7C0D
        0x7BFE, # G+5162  U+7BFE  uni7BFE,  CJK UNIFIED IDEOGRAPH-7BFE
        0x7BF7, # G+5163  U+7BF7  uni7BF7,  CJK UNIFIED IDEOGRAPH-7BF7
        0x7C0C, # G+5164  U+7C0C  uni7C0C,  CJK UNIFIED IDEOGRAPH-7C0C
        0x7BE0, # G+5165  U+7BE0  uni7BE0,  CJK UNIFIED IDEOGRAPH-7BE0
        0x7CE0, # G+5166  U+7CE0  uni7CE0,  CJK UNIFIED IDEOGRAPH-7CE0
        0x7CDC, # G+5167  U+7CDC  uni7CDC,  CJK UNIFIED IDEOGRAPH-7CDC
        0x7CDE, # G+5168  U+7CDE  uni7CDE,  CJK UNIFIED IDEOGRAPH-7CDE
        0x7CE2, # G+5169  U+7CE2  uni7CE2,  CJK UNIFIED IDEOGRAPH-7CE2
        0x7CDF, # G+5170  U+7CDF  uni7CDF,  CJK UNIFIED IDEOGRAPH-7CDF
        0x7CD9, # G+5171  U+7CD9  uni7CD9,  CJK UNIFIED IDEOGRAPH-7CD9
        0x7CDD, # G+5172  U+7CDD  uni7CDD,  CJK UNIFIED IDEOGRAPH-7CDD
        0x7E2E, # G+5173  U+7E2E  uni7E2E,  CJK UNIFIED IDEOGRAPH-7E2E
        0x7E3E, # G+5174  U+7E3E  uni7E3E,  CJK UNIFIED IDEOGRAPH-7E3E
        0x7E46, # G+5175  U+7E46  uni7E46,  CJK UNIFIED IDEOGRAPH-7E46
        0x7E37, # G+5176  U+7E37  uni7E37,  CJK UNIFIED IDEOGRAPH-7E37
        0x7E32, # G+5177  U+7E32  uni7E32,  CJK UNIFIED IDEOGRAPH-7E32
        0x7E43, # G+5178  U+7E43  uni7E43,  CJK UNIFIED IDEOGRAPH-7E43
        0x7E2B, # G+5179  U+7E2B  uni7E2B,  CJK UNIFIED IDEOGRAPH-7E2B
        0x7E3D, # G+5180  U+7E3D  uni7E3D,  CJK UNIFIED IDEOGRAPH-7E3D
        0x7E31, # G+5181  U+7E31  uni7E31,  CJK UNIFIED IDEOGRAPH-7E31
        0x7E45, # G+5182  U+7E45  uni7E45,  CJK UNIFIED IDEOGRAPH-7E45
        0x7E41, # G+5183  U+7E41  uni7E41,  CJK UNIFIED IDEOGRAPH-7E41
        0x7E34, # G+5184  U+7E34  uni7E34,  CJK UNIFIED IDEOGRAPH-7E34
        0x7E39, # G+5185  U+7E39  uni7E39,  CJK UNIFIED IDEOGRAPH-7E39
        0x7E48, # G+5186  U+7E48  uni7E48,  CJK UNIFIED IDEOGRAPH-7E48
        0x7E35, # G+5187  U+7E35  uni7E35,  CJK UNIFIED IDEOGRAPH-7E35
        0x7E3F, # G+5188  U+7E3F  uni7E3F,  CJK UNIFIED IDEOGRAPH-7E3F
        0x7E2F, # G+5189  U+7E2F  uni7E2F,  CJK UNIFIED IDEOGRAPH-7E2F
        0x7F44, # G+5190  U+7F44  uni7F44,  CJK UNIFIED IDEOGRAPH-7F44
        0x7FF3, # G+5191  U+7FF3  uni7FF3,  CJK UNIFIED IDEOGRAPH-7FF3
        0x7FFC, # G+5192  U+7FFC  uni7FFC,  CJK UNIFIED IDEOGRAPH-7FFC
        0x8071, # G+5193  U+8071  uni8071,  CJK UNIFIED IDEOGRAPH-8071
        0x8072, # G+5194  U+8072  uni8072,  CJK UNIFIED IDEOGRAPH-8072
        0x8070, # G+5195  U+8070  uni8070,  CJK UNIFIED IDEOGRAPH-8070
        0x806F, # G+5196  U+806F  uni806F,  CJK UNIFIED IDEOGRAPH-806F
        0x8073, # G+5197  U+8073  uni8073,  CJK UNIFIED IDEOGRAPH-8073
        0x81C6, # G+5198  U+81C6  uni81C6,  CJK UNIFIED IDEOGRAPH-81C6
        0x81C3, # G+5199  U+81C3  uni81C3,  CJK UNIFIED IDEOGRAPH-81C3
        0x81BA, # G+5200  U+81BA  uni81BA,  CJK UNIFIED IDEOGRAPH-81BA
        0x81C2, # G+5201  U+81C2  uni81C2,  CJK UNIFIED IDEOGRAPH-81C2
        0x81C0, # G+5202  U+81C0  uni81C0,  CJK UNIFIED IDEOGRAPH-81C0
        0x81BF, # G+5203  U+81BF  uni81BF,  CJK UNIFIED IDEOGRAPH-81BF
        0x81BD, # G+5204  U+81BD  uni81BD,  CJK UNIFIED IDEOGRAPH-81BD
        0x81C9, # G+5205  U+81C9  uni81C9,  CJK UNIFIED IDEOGRAPH-81C9
        0x81BE, # G+5206  U+81BE  uni81BE,  CJK UNIFIED IDEOGRAPH-81BE
        0x81E8, # G+5207  U+81E8  uni81E8,  CJK UNIFIED IDEOGRAPH-81E8
        0x8209, # G+5208  U+8209  uni8209,  CJK UNIFIED IDEOGRAPH-8209
        0x8271, # G+5209  U+8271  uni8271,  CJK UNIFIED IDEOGRAPH-8271
        0x85AA, # G+5210  U+85AA  uni85AA,  CJK UNIFIED IDEOGRAPH-85AA
        0x8584, # G+5211  U+8584  uni8584,  CJK UNIFIED IDEOGRAPH-8584
        0x857E, # G+5212  U+857E  uni857E,  CJK UNIFIED IDEOGRAPH-857E
        0x859C, # G+5213  U+859C  uni859C,  CJK UNIFIED IDEOGRAPH-859C
        0x8591, # G+5214  U+8591  uni8591,  CJK UNIFIED IDEOGRAPH-8591
        0x8594, # G+5215  U+8594  uni8594,  CJK UNIFIED IDEOGRAPH-8594
        0x85AF, # G+5216  U+85AF  uni85AF,  CJK UNIFIED IDEOGRAPH-85AF
        0x859B, # G+5217  U+859B  uni859B,  CJK UNIFIED IDEOGRAPH-859B
        0x8587, # G+5218  U+8587  uni8587,  CJK UNIFIED IDEOGRAPH-8587
        0x85A8, # G+5219  U+85A8  uni85A8,  CJK UNIFIED IDEOGRAPH-85A8
        0x858A, # G+5220  U+858A  uni858A,  CJK UNIFIED IDEOGRAPH-858A
        0x85A6, # G+5221  U+85A6  uni85A6,  CJK UNIFIED IDEOGRAPH-85A6
        0x8667, # G+5222  U+8667  uni8667,  CJK UNIFIED IDEOGRAPH-8667
        0x87C0, # G+5223  U+87C0  uni87C0,  CJK UNIFIED IDEOGRAPH-87C0
        0x87D1, # G+5224  U+87D1  uni87D1,  CJK UNIFIED IDEOGRAPH-87D1
        0x87B3, # G+5225  U+87B3  uni87B3,  CJK UNIFIED IDEOGRAPH-87B3
        0x87D2, # G+5226  U+87D2  uni87D2,  CJK UNIFIED IDEOGRAPH-87D2
        0x87C6, # G+5227  U+87C6  uni87C6,  CJK UNIFIED IDEOGRAPH-87C6
        0x87AB, # G+5228  U+87AB  uni87AB,  CJK UNIFIED IDEOGRAPH-87AB
        0x87BB, # G+5229  U+87BB  uni87BB,  CJK UNIFIED IDEOGRAPH-87BB
        0x87BA, # G+5230  U+87BA  uni87BA,  CJK UNIFIED IDEOGRAPH-87BA
        0x87C8, # G+5231  U+87C8  uni87C8,  CJK UNIFIED IDEOGRAPH-87C8
        0x87CB, # G+5232  U+87CB  uni87CB,  CJK UNIFIED IDEOGRAPH-87CB
        0x893B, # G+5233  U+893B  uni893B,  CJK UNIFIED IDEOGRAPH-893B
        0x8936, # G+5234  U+8936  uni8936,  CJK UNIFIED IDEOGRAPH-8936
        0x8944, # G+5235  U+8944  uni8944,  CJK UNIFIED IDEOGRAPH-8944
        0x8938, # G+5236  U+8938  uni8938,  CJK UNIFIED IDEOGRAPH-8938
        0x893D, # G+5237  U+893D  uni893D,  CJK UNIFIED IDEOGRAPH-893D
        0x89AC, # G+5238  U+89AC  uni89AC,  CJK UNIFIED IDEOGRAPH-89AC
        0x8B0E, # G+5239  U+8B0E  uni8B0E,  CJK UNIFIED IDEOGRAPH-8B0E
        0x8B17, # G+5240  U+8B17  uni8B17,  CJK UNIFIED IDEOGRAPH-8B17
        0x8B19, # G+5241  U+8B19  uni8B19,  CJK UNIFIED IDEOGRAPH-8B19
        0x8B1B, # G+5242  U+8B1B  uni8B1B,  CJK UNIFIED IDEOGRAPH-8B1B
        0x8B0A, # G+5243  U+8B0A  uni8B0A,  CJK UNIFIED IDEOGRAPH-8B0A
        0x8B20, # G+5244  U+8B20  uni8B20,  CJK UNIFIED IDEOGRAPH-8B20
        0x8B1D, # G+5245  U+8B1D  uni8B1D,  CJK UNIFIED IDEOGRAPH-8B1D
        0x8B04, # G+5246  U+8B04  uni8B04,  CJK UNIFIED IDEOGRAPH-8B04
        0x8B10, # G+5247  U+8B10  uni8B10,  CJK UNIFIED IDEOGRAPH-8B10
        0x8C41, # G+5248  U+8C41  uni8C41,  CJK UNIFIED IDEOGRAPH-8C41
        0x8C3F, # G+5249  U+8C3F  uni8C3F,  CJK UNIFIED IDEOGRAPH-8C3F
        0x8C73, # G+5250  U+8C73  uni8C73,  CJK UNIFIED IDEOGRAPH-8C73
        0x8CFA, # G+5251  U+8CFA  uni8CFA,  CJK UNIFIED IDEOGRAPH-8CFA
        0x8CFD, # G+5252  U+8CFD  uni8CFD,  CJK UNIFIED IDEOGRAPH-8CFD
        0x8CFC, # G+5253  U+8CFC  uni8CFC,  CJK UNIFIED IDEOGRAPH-8CFC
        0x8CF8, # G+5254  U+8CF8  uni8CF8,  CJK UNIFIED IDEOGRAPH-8CF8
        0x8CFB, # G+5255  U+8CFB  uni8CFB,  CJK UNIFIED IDEOGRAPH-8CFB
        0x8DA8, # G+5256  U+8DA8  uni8DA8,  CJK UNIFIED IDEOGRAPH-8DA8
        0x8E49, # G+5257  U+8E49  uni8E49,  CJK UNIFIED IDEOGRAPH-8E49
        0x8E4B, # G+5258  U+8E4B  uni8E4B,  CJK UNIFIED IDEOGRAPH-8E4B
        0x8E48, # G+5259  U+8E48  uni8E48,  CJK UNIFIED IDEOGRAPH-8E48
        0x8E4A, # G+5260  U+8E4A  uni8E4A,  CJK UNIFIED IDEOGRAPH-8E4A
        0x8F44, # G+5261  U+8F44  uni8F44,  CJK UNIFIED IDEOGRAPH-8F44
        0x8F3E, # G+5262  U+8F3E  uni8F3E,  CJK UNIFIED IDEOGRAPH-8F3E
        0x8F42, # G+5263  U+8F42  uni8F42,  CJK UNIFIED IDEOGRAPH-8F42
        0x8F45, # G+5264  U+8F45  uni8F45,  CJK UNIFIED IDEOGRAPH-8F45
        0x8F3F, # G+5265  U+8F3F  uni8F3F,  CJK UNIFIED IDEOGRAPH-8F3F
        0x907F, # G+5266  U+907F  uni907F,  CJK UNIFIED IDEOGRAPH-907F
        0x907D, # G+5267  U+907D  uni907D,  CJK UNIFIED IDEOGRAPH-907D
        0x9084, # G+5268  U+9084  uni9084,  CJK UNIFIED IDEOGRAPH-9084
        0x9081, # G+5269  U+9081  uni9081,  CJK UNIFIED IDEOGRAPH-9081
        0x9082, # G+5270  U+9082  uni9082,  CJK UNIFIED IDEOGRAPH-9082
        0x9080, # G+5271  U+9080  uni9080,  CJK UNIFIED IDEOGRAPH-9080
        0x9139, # G+5272  U+9139  uni9139,  CJK UNIFIED IDEOGRAPH-9139
        0x91A3, # G+5273  U+91A3  uni91A3,  CJK UNIFIED IDEOGRAPH-91A3
        0x919E, # G+5274  U+919E  uni919E,  CJK UNIFIED IDEOGRAPH-919E
        0x919C, # G+5275  U+919C  uni919C,  CJK UNIFIED IDEOGRAPH-919C
        0x934D, # G+5276  U+934D  uni934D,  CJK UNIFIED IDEOGRAPH-934D
        0x9382, # G+5277  U+9382  uni9382,  CJK UNIFIED IDEOGRAPH-9382
        0x9328, # G+5278  U+9328  uni9328,  CJK UNIFIED IDEOGRAPH-9328
        0x9375, # G+5279  U+9375  uni9375,  CJK UNIFIED IDEOGRAPH-9375
        0x934A, # G+5280  U+934A  uni934A,  CJK UNIFIED IDEOGRAPH-934A
        0x9365, # G+5281  U+9365  uni9365,  CJK UNIFIED IDEOGRAPH-9365
        0x934B, # G+5282  U+934B  uni934B,  CJK UNIFIED IDEOGRAPH-934B
        0x9318, # G+5283  U+9318  uni9318,  CJK UNIFIED IDEOGRAPH-9318
        0x937E, # G+5284  U+937E  uni937E,  CJK UNIFIED IDEOGRAPH-937E
        0x936C, # G+5285  U+936C  uni936C,  CJK UNIFIED IDEOGRAPH-936C
        0x935B, # G+5286  U+935B  uni935B,  CJK UNIFIED IDEOGRAPH-935B
        0x9370, # G+5287  U+9370  uni9370,  CJK UNIFIED IDEOGRAPH-9370
        0x935A, # G+5288  U+935A  uni935A,  CJK UNIFIED IDEOGRAPH-935A
        0x9354, # G+5289  U+9354  uni9354,  CJK UNIFIED IDEOGRAPH-9354
        0x95CA, # G+5290  U+95CA  uni95CA,  CJK UNIFIED IDEOGRAPH-95CA
        0x95CB, # G+5291  U+95CB  uni95CB,  CJK UNIFIED IDEOGRAPH-95CB
        0x95CC, # G+5292  U+95CC  uni95CC,  CJK UNIFIED IDEOGRAPH-95CC
        0x95C8, # G+5293  U+95C8  uni95C8,  CJK UNIFIED IDEOGRAPH-95C8
        0x95C6, # G+5294  U+95C6  uni95C6,  CJK UNIFIED IDEOGRAPH-95C6
        0x96B1, # G+5295  U+96B1  uni96B1,  CJK UNIFIED IDEOGRAPH-96B1
        0x96B8, # G+5296  U+96B8  uni96B8,  CJK UNIFIED IDEOGRAPH-96B8
        0x96D6, # G+5297  U+96D6  uni96D6,  CJK UNIFIED IDEOGRAPH-96D6
        0x971C, # G+5298  U+971C  uni971C,  CJK UNIFIED IDEOGRAPH-971C
        0x971E, # G+5299  U+971E  uni971E,  CJK UNIFIED IDEOGRAPH-971E
        0x97A0, # G+5300  U+97A0  uni97A0,  CJK UNIFIED IDEOGRAPH-97A0
        0x97D3, # G+5301  U+97D3  uni97D3,  CJK UNIFIED IDEOGRAPH-97D3
        0x9846, # G+5302  U+9846  uni9846,  CJK UNIFIED IDEOGRAPH-9846
        0x98B6, # G+5303  U+98B6  uni98B6,  CJK UNIFIED IDEOGRAPH-98B6
        0x9935, # G+5304  U+9935  uni9935,  CJK UNIFIED IDEOGRAPH-9935
        0x9A01, # G+5305  U+9A01  uni9A01,  CJK UNIFIED IDEOGRAPH-9A01
        0x99FF, # G+5306  U+99FF  uni99FF,  CJK UNIFIED IDEOGRAPH-99FF
        0x9BAE, # G+5307  U+9BAE  uni9BAE,  CJK UNIFIED IDEOGRAPH-9BAE
        0x9BAB, # G+5308  U+9BAB  uni9BAB,  CJK UNIFIED IDEOGRAPH-9BAB
        0x9BAA, # G+5309  U+9BAA  uni9BAA,  CJK UNIFIED IDEOGRAPH-9BAA
        0x9BAD, # G+5310  U+9BAD  uni9BAD,  CJK UNIFIED IDEOGRAPH-9BAD
        0x9D3B, # G+5311  U+9D3B  uni9D3B,  CJK UNIFIED IDEOGRAPH-9D3B
        0x9D3F, # G+5312  U+9D3F  uni9D3F,  CJK UNIFIED IDEOGRAPH-9D3F
        0x9E8B, # G+5313  U+9E8B  uni9E8B,  CJK UNIFIED IDEOGRAPH-9E8B
        0x9ECF, # G+5314  U+9ECF  uni9ECF,  CJK UNIFIED IDEOGRAPH-9ECF
        0x9EDE, # G+5315  U+9EDE  uni9EDE,  CJK UNIFIED IDEOGRAPH-9EDE
        0x9EDC, # G+5316  U+9EDC  uni9EDC,  CJK UNIFIED IDEOGRAPH-9EDC
        0x9EDD, # G+5317  U+9EDD  uni9EDD,  CJK UNIFIED IDEOGRAPH-9EDD
        0x9EDB, # G+5318  U+9EDB  uni9EDB,  CJK UNIFIED IDEOGRAPH-9EDB
        0x9F3E, # G+5319  U+9F3E  uni9F3E,  CJK UNIFIED IDEOGRAPH-9F3E
        0x9F4B, # G+5320  U+9F4B  uni9F4B,  CJK UNIFIED IDEOGRAPH-9F4B
        0x53E2, # G+5321  U+53E2  uni53E2,  CJK UNIFIED IDEOGRAPH-53E2
        0x5695, # G+5322  U+5695  uni5695,  CJK UNIFIED IDEOGRAPH-5695
        0x56AE, # G+5323  U+56AE  uni56AE,  CJK UNIFIED IDEOGRAPH-56AE
        0x58D9, # G+5324  U+58D9  uni58D9,  CJK UNIFIED IDEOGRAPH-58D9
        0x58D8, # G+5325  U+58D8  uni58D8,  CJK UNIFIED IDEOGRAPH-58D8
        0x5B38, # G+5326  U+5B38  uni5B38,  CJK UNIFIED IDEOGRAPH-5B38
        0x5F5D, # G+5327  U+5F5D  uni5F5D,  CJK UNIFIED IDEOGRAPH-5F5D
        0x61E3, # G+5328  U+61E3  uni61E3,  CJK UNIFIED IDEOGRAPH-61E3
        0x6233, # G+5329  U+6233  uni6233,  CJK UNIFIED IDEOGRAPH-6233
        0x64F4, # G+5330  U+64F4  uni64F4,  CJK UNIFIED IDEOGRAPH-64F4
        0x64F2, # G+5331  U+64F2  uni64F2,  CJK UNIFIED IDEOGRAPH-64F2
        0x64FE, # G+5332  U+64FE  uni64FE,  CJK UNIFIED IDEOGRAPH-64FE
        0x6506, # G+5333  U+6506  uni6506,  CJK UNIFIED IDEOGRAPH-6506
        0x64FA, # G+5334  U+64FA  uni64FA,  CJK UNIFIED IDEOGRAPH-64FA
        0x64FB, # G+5335  U+64FB  uni64FB,  CJK UNIFIED IDEOGRAPH-64FB
        0x64F7, # G+5336  U+64F7  uni64F7,  CJK UNIFIED IDEOGRAPH-64F7
        0x65B7, # G+5337  U+65B7  uni65B7,  CJK UNIFIED IDEOGRAPH-65B7
        0x66DC, # G+5338  U+66DC  uni66DC,  CJK UNIFIED IDEOGRAPH-66DC
        0x6726, # G+5339  U+6726  uni6726,  CJK UNIFIED IDEOGRAPH-6726
        0x6AB3, # G+5340  U+6AB3  uni6AB3,  CJK UNIFIED IDEOGRAPH-6AB3
        0x6AAC, # G+5341  U+6AAC  uni6AAC,  CJK UNIFIED IDEOGRAPH-6AAC
        0x6AC3, # G+5342  U+6AC3  uni6AC3,  CJK UNIFIED IDEOGRAPH-6AC3
        0x6ABB, # G+5343  U+6ABB  uni6ABB,  CJK UNIFIED IDEOGRAPH-6ABB
        0x6AB8, # G+5344  U+6AB8  uni6AB8,  CJK UNIFIED IDEOGRAPH-6AB8
        0x6AC2, # G+5345  U+6AC2  uni6AC2,  CJK UNIFIED IDEOGRAPH-6AC2
        0x6AAE, # G+5346  U+6AAE  uni6AAE,  CJK UNIFIED IDEOGRAPH-6AAE
        0x6AAF, # G+5347  U+6AAF  uni6AAF,  CJK UNIFIED IDEOGRAPH-6AAF
        0x6B5F, # G+5348  U+6B5F  uni6B5F,  CJK UNIFIED IDEOGRAPH-6B5F
        0x6B78, # G+5349  U+6B78  uni6B78,  CJK UNIFIED IDEOGRAPH-6B78
        0x6BAF, # G+5350  U+6BAF  uni6BAF,  CJK UNIFIED IDEOGRAPH-6BAF
        0x7009, # G+5351  U+7009  uni7009,  CJK UNIFIED IDEOGRAPH-7009
        0x700B, # G+5352  U+700B  uni700B,  CJK UNIFIED IDEOGRAPH-700B
        0x6FFE, # G+5353  U+6FFE  uni6FFE,  CJK UNIFIED IDEOGRAPH-6FFE
        0x7006, # G+5354  U+7006  uni7006,  CJK UNIFIED IDEOGRAPH-7006
        0x6FFA, # G+5355  U+6FFA  uni6FFA,  CJK UNIFIED IDEOGRAPH-6FFA
        0x7011, # G+5356  U+7011  uni7011,  CJK UNIFIED IDEOGRAPH-7011
        0x700F, # G+5357  U+700F  uni700F,  CJK UNIFIED IDEOGRAPH-700F
        0x71FB, # G+5358  U+71FB  uni71FB,  CJK UNIFIED IDEOGRAPH-71FB
        0x71FC, # G+5359  U+71FC  uni71FC,  CJK UNIFIED IDEOGRAPH-71FC
        0x71FE, # G+5360  U+71FE  uni71FE,  CJK UNIFIED IDEOGRAPH-71FE
        0x71F8, # G+5361  U+71F8  uni71F8,  CJK UNIFIED IDEOGRAPH-71F8
        0x7377, # G+5362  U+7377  uni7377,  CJK UNIFIED IDEOGRAPH-7377
        0x7375, # G+5363  U+7375  uni7375,  CJK UNIFIED IDEOGRAPH-7375
        0x74A7, # G+5364  U+74A7  uni74A7,  CJK UNIFIED IDEOGRAPH-74A7
        0x74BF, # G+5365  U+74BF  uni74BF,  CJK UNIFIED IDEOGRAPH-74BF
        0x7515, # G+5366  U+7515  uni7515,  CJK UNIFIED IDEOGRAPH-7515
        0x7656, # G+5367  U+7656  uni7656,  CJK UNIFIED IDEOGRAPH-7656
        0x7658, # G+5368  U+7658  uni7658,  CJK UNIFIED IDEOGRAPH-7658
        0x7652, # G+5369  U+7652  uni7652,  CJK UNIFIED IDEOGRAPH-7652
        0x77BD, # G+5370  U+77BD  uni77BD,  CJK UNIFIED IDEOGRAPH-77BD
        0x77BF, # G+5371  U+77BF  uni77BF,  CJK UNIFIED IDEOGRAPH-77BF
        0x77BB, # G+5372  U+77BB  uni77BB,  CJK UNIFIED IDEOGRAPH-77BB
        0x77BC, # G+5373  U+77BC  uni77BC,  CJK UNIFIED IDEOGRAPH-77BC
        0x790E, # G+5374  U+790E  uni790E,  CJK UNIFIED IDEOGRAPH-790E
        0x79AE, # G+5375  U+79AE  uni79AE,  CJK UNIFIED IDEOGRAPH-79AE
        0x7A61, # G+5376  U+7A61  uni7A61,  CJK UNIFIED IDEOGRAPH-7A61
        0x7A62, # G+5377  U+7A62  uni7A62,  CJK UNIFIED IDEOGRAPH-7A62
        0x7A60, # G+5378  U+7A60  uni7A60,  CJK UNIFIED IDEOGRAPH-7A60
        0x7AC4, # G+5379  U+7AC4  uni7AC4,  CJK UNIFIED IDEOGRAPH-7AC4
        0x7AC5, # G+5380  U+7AC5  uni7AC5,  CJK UNIFIED IDEOGRAPH-7AC5
        0x7C2B, # G+5381  U+7C2B  uni7C2B,  CJK UNIFIED IDEOGRAPH-7C2B
        0x7C27, # G+5382  U+7C27  uni7C27,  CJK UNIFIED IDEOGRAPH-7C27
        0x7C2A, # G+5383  U+7C2A  uni7C2A,  CJK UNIFIED IDEOGRAPH-7C2A
        0x7C1E, # G+5384  U+7C1E  uni7C1E,  CJK UNIFIED IDEOGRAPH-7C1E
        0x7C23, # G+5385  U+7C23  uni7C23,  CJK UNIFIED IDEOGRAPH-7C23
        0x7C21, # G+5386  U+7C21  uni7C21,  CJK UNIFIED IDEOGRAPH-7C21
        0x7CE7, # G+5387  U+7CE7  uni7CE7,  CJK UNIFIED IDEOGRAPH-7CE7
        0x7E54, # G+5388  U+7E54  uni7E54,  CJK UNIFIED IDEOGRAPH-7E54
        0x7E55, # G+5389  U+7E55  uni7E55,  CJK UNIFIED IDEOGRAPH-7E55
        0x7E5E, # G+5390  U+7E5E  uni7E5E,  CJK UNIFIED IDEOGRAPH-7E5E
        0x7E5A, # G+5391  U+7E5A  uni7E5A,  CJK UNIFIED IDEOGRAPH-7E5A
        0x7E61, # G+5392  U+7E61  uni7E61,  CJK UNIFIED IDEOGRAPH-7E61
        0x7E52, # G+5393  U+7E52  uni7E52,  CJK UNIFIED IDEOGRAPH-7E52
        0x7E59, # G+5394  U+7E59  uni7E59,  CJK UNIFIED IDEOGRAPH-7E59
        0x7F48, # G+5395  U+7F48  uni7F48,  CJK UNIFIED IDEOGRAPH-7F48
        0x7FF9, # G+5396  U+7FF9  uni7FF9,  CJK UNIFIED IDEOGRAPH-7FF9
        0x7FFB, # G+5397  U+7FFB  uni7FFB,  CJK UNIFIED IDEOGRAPH-7FFB
        0x8077, # G+5398  U+8077  uni8077,  CJK UNIFIED IDEOGRAPH-8077
        0x8076, # G+5399  U+8076  uni8076,  CJK UNIFIED IDEOGRAPH-8076
        0x81CD, # G+5400  U+81CD  uni81CD,  CJK UNIFIED IDEOGRAPH-81CD
        0x81CF, # G+5401  U+81CF  uni81CF,  CJK UNIFIED IDEOGRAPH-81CF
        0x820A, # G+5402  U+820A  uni820A,  CJK UNIFIED IDEOGRAPH-820A
        0x85CF, # G+5403  U+85CF  uni85CF,  CJK UNIFIED IDEOGRAPH-85CF
        0x85A9, # G+5404  U+85A9  uni85A9,  CJK UNIFIED IDEOGRAPH-85A9
        0x85CD, # G+5405  U+85CD  uni85CD,  CJK UNIFIED IDEOGRAPH-85CD
        0x85D0, # G+5406  U+85D0  uni85D0,  CJK UNIFIED IDEOGRAPH-85D0
        0x85C9, # G+5407  U+85C9  uni85C9,  CJK UNIFIED IDEOGRAPH-85C9
        0x85B0, # G+5408  U+85B0  uni85B0,  CJK UNIFIED IDEOGRAPH-85B0
        0x85BA, # G+5409  U+85BA  uni85BA,  CJK UNIFIED IDEOGRAPH-85BA
        0x85B9, # G+5410  U+85B9  uni85B9,  CJK UNIFIED IDEOGRAPH-85B9
        0x87EF, # G+5411  U+87EF  uni87EF,  CJK UNIFIED IDEOGRAPH-87EF
        0x87EC, # G+5412  U+87EC  uni87EC,  CJK UNIFIED IDEOGRAPH-87EC
        0x87F2, # G+5413  U+87F2  uni87F2,  CJK UNIFIED IDEOGRAPH-87F2
        0x87E0, # G+5414  U+87E0  uni87E0,  CJK UNIFIED IDEOGRAPH-87E0
        0x8986, # G+5415  U+8986  uni8986,  CJK UNIFIED IDEOGRAPH-8986
        0x89B2, # G+5416  U+89B2  uni89B2,  CJK UNIFIED IDEOGRAPH-89B2
        0x89F4, # G+5417  U+89F4  uni89F4,  CJK UNIFIED IDEOGRAPH-89F4
        0x8B28, # G+5418  U+8B28  uni8B28,  CJK UNIFIED IDEOGRAPH-8B28
        0x8B39, # G+5419  U+8B39  uni8B39,  CJK UNIFIED IDEOGRAPH-8B39
        0x8B2C, # G+5420  U+8B2C  uni8B2C,  CJK UNIFIED IDEOGRAPH-8B2C
        0x8B2B, # G+5421  U+8B2B  uni8B2B,  CJK UNIFIED IDEOGRAPH-8B2B
        0x8C50, # G+5422  U+8C50  uni8C50,  CJK UNIFIED IDEOGRAPH-8C50
        0x8D05, # G+5423  U+8D05  uni8D05,  CJK UNIFIED IDEOGRAPH-8D05
        0x8E59, # G+5424  U+8E59  uni8E59,  CJK UNIFIED IDEOGRAPH-8E59
        0x8E63, # G+5425  U+8E63  uni8E63,  CJK UNIFIED IDEOGRAPH-8E63
        0x8E66, # G+5426  U+8E66  uni8E66,  CJK UNIFIED IDEOGRAPH-8E66
        0x8E64, # G+5427  U+8E64  uni8E64,  CJK UNIFIED IDEOGRAPH-8E64
        0x8E5F, # G+5428  U+8E5F  uni8E5F,  CJK UNIFIED IDEOGRAPH-8E5F
        0x8E55, # G+5429  U+8E55  uni8E55,  CJK UNIFIED IDEOGRAPH-8E55
        0x8EC0, # G+5430  U+8EC0  uni8EC0,  CJK UNIFIED IDEOGRAPH-8EC0
        0x8F49, # G+5431  U+8F49  uni8F49,  CJK UNIFIED IDEOGRAPH-8F49
        0x8F4D, # G+5432  U+8F4D  uni8F4D,  CJK UNIFIED IDEOGRAPH-8F4D
        0x9087, # G+5433  U+9087  uni9087,  CJK UNIFIED IDEOGRAPH-9087
        0x9083, # G+5434  U+9083  uni9083,  CJK UNIFIED IDEOGRAPH-9083
        0x9088, # G+5435  U+9088  uni9088,  CJK UNIFIED IDEOGRAPH-9088
        0x91AB, # G+5436  U+91AB  uni91AB,  CJK UNIFIED IDEOGRAPH-91AB
        0x91AC, # G+5437  U+91AC  uni91AC,  CJK UNIFIED IDEOGRAPH-91AC
        0x91D0, # G+5438  U+91D0  uni91D0,  CJK UNIFIED IDEOGRAPH-91D0
        0x9394, # G+5439  U+9394  uni9394,  CJK UNIFIED IDEOGRAPH-9394
        0x938A, # G+5440  U+938A  uni938A,  CJK UNIFIED IDEOGRAPH-938A
        0x9396, # G+5441  U+9396  uni9396,  CJK UNIFIED IDEOGRAPH-9396
        0x93A2, # G+5442  U+93A2  uni93A2,  CJK UNIFIED IDEOGRAPH-93A2
        0x93B3, # G+5443  U+93B3  uni93B3,  CJK UNIFIED IDEOGRAPH-93B3
        0x93AE, # G+5444  U+93AE  uni93AE,  CJK UNIFIED IDEOGRAPH-93AE
        0x93AC, # G+5445  U+93AC  uni93AC,  CJK UNIFIED IDEOGRAPH-93AC
        0x93B0, # G+5446  U+93B0  uni93B0,  CJK UNIFIED IDEOGRAPH-93B0
        0x9398, # G+5447  U+9398  uni9398,  CJK UNIFIED IDEOGRAPH-9398
        0x939A, # G+5448  U+939A  uni939A,  CJK UNIFIED IDEOGRAPH-939A
        0x9397, # G+5449  U+9397  uni9397,  CJK UNIFIED IDEOGRAPH-9397
        0x95D4, # G+5450  U+95D4  uni95D4,  CJK UNIFIED IDEOGRAPH-95D4
        0x95D6, # G+5451  U+95D6  uni95D6,  CJK UNIFIED IDEOGRAPH-95D6
        0x95D0, # G+5452  U+95D0  uni95D0,  CJK UNIFIED IDEOGRAPH-95D0
        0x95D5, # G+5453  U+95D5  uni95D5,  CJK UNIFIED IDEOGRAPH-95D5
        0x96E2, # G+5454  U+96E2  uni96E2,  CJK UNIFIED IDEOGRAPH-96E2
        0x96DC, # G+5455  U+96DC  uni96DC,  CJK UNIFIED IDEOGRAPH-96DC
        0x96D9, # G+5456  U+96D9  uni96D9,  CJK UNIFIED IDEOGRAPH-96D9
        0x96DB, # G+5457  U+96DB  uni96DB,  CJK UNIFIED IDEOGRAPH-96DB
        0x96DE, # G+5458  U+96DE  uni96DE,  CJK UNIFIED IDEOGRAPH-96DE
        0x9724, # G+5459  U+9724  uni9724,  CJK UNIFIED IDEOGRAPH-9724
        0x97A3, # G+5460  U+97A3  uni97A3,  CJK UNIFIED IDEOGRAPH-97A3
        0x97A6, # G+5461  U+97A6  uni97A6,  CJK UNIFIED IDEOGRAPH-97A6
        0x97AD, # G+5462  U+97AD  uni97AD,  CJK UNIFIED IDEOGRAPH-97AD
        0x97F9, # G+5463  U+97F9  uni97F9,  CJK UNIFIED IDEOGRAPH-97F9
        0x984D, # G+5464  U+984D  uni984D,  CJK UNIFIED IDEOGRAPH-984D
        0x984F, # G+5465  U+984F  uni984F,  CJK UNIFIED IDEOGRAPH-984F
        0x984C, # G+5466  U+984C  uni984C,  CJK UNIFIED IDEOGRAPH-984C
        0x984E, # G+5467  U+984E  uni984E,  CJK UNIFIED IDEOGRAPH-984E
        0x9853, # G+5468  U+9853  uni9853,  CJK UNIFIED IDEOGRAPH-9853
        0x98BA, # G+5469  U+98BA  uni98BA,  CJK UNIFIED IDEOGRAPH-98BA
        0x993E, # G+5470  U+993E  uni993E,  CJK UNIFIED IDEOGRAPH-993E
        0x993F, # G+5471  U+993F  uni993F,  CJK UNIFIED IDEOGRAPH-993F
        0x993D, # G+5472  U+993D  uni993D,  CJK UNIFIED IDEOGRAPH-993D
        0x992E, # G+5473  U+992E  uni992E,  CJK UNIFIED IDEOGRAPH-992E
        0x99A5, # G+5474  U+99A5  uni99A5,  CJK UNIFIED IDEOGRAPH-99A5
        0x9A0E, # G+5475  U+9A0E  uni9A0E,  CJK UNIFIED IDEOGRAPH-9A0E
        0x9AC1, # G+5476  U+9AC1  uni9AC1,  CJK UNIFIED IDEOGRAPH-9AC1
        0x9B03, # G+5477  U+9B03  uni9B03,  CJK UNIFIED IDEOGRAPH-9B03
        0x9B06, # G+5478  U+9B06  uni9B06,  CJK UNIFIED IDEOGRAPH-9B06
        0x9B4F, # G+5479  U+9B4F  uni9B4F,  CJK UNIFIED IDEOGRAPH-9B4F
        0x9B4E, # G+5480  U+9B4E  uni9B4E,  CJK UNIFIED IDEOGRAPH-9B4E
        0x9B4D, # G+5481  U+9B4D  uni9B4D,  CJK UNIFIED IDEOGRAPH-9B4D
        0x9BCA, # G+5482  U+9BCA  uni9BCA,  CJK UNIFIED IDEOGRAPH-9BCA
        0x9BC9, # G+5483  U+9BC9  uni9BC9,  CJK UNIFIED IDEOGRAPH-9BC9
        0x9BFD, # G+5484  U+9BFD  uni9BFD,  CJK UNIFIED IDEOGRAPH-9BFD
        0x9BC8, # G+5485  U+9BC8  uni9BC8,  CJK UNIFIED IDEOGRAPH-9BC8
        0x9BC0, # G+5486  U+9BC0  uni9BC0,  CJK UNIFIED IDEOGRAPH-9BC0
        0x9D51, # G+5487  U+9D51  uni9D51,  CJK UNIFIED IDEOGRAPH-9D51
        0x9D5D, # G+5488  U+9D5D  uni9D5D,  CJK UNIFIED IDEOGRAPH-9D5D
        0x9D60, # G+5489  U+9D60  uni9D60,  CJK UNIFIED IDEOGRAPH-9D60
        0x9EE0, # G+5490  U+9EE0  uni9EE0,  CJK UNIFIED IDEOGRAPH-9EE0
        0x9F15, # G+5491  U+9F15  uni9F15,  CJK UNIFIED IDEOGRAPH-9F15
        0x9F2C, # G+5492  U+9F2C  uni9F2C,  CJK UNIFIED IDEOGRAPH-9F2C
        0x5133, # G+5493  U+5133  uni5133,  CJK UNIFIED IDEOGRAPH-5133
        0x56A5, # G+5494  U+56A5  uni56A5,  CJK UNIFIED IDEOGRAPH-56A5
        0x56A8, # G+5495  U+56A8  uni56A8,  CJK UNIFIED IDEOGRAPH-56A8
        0x58DE, # G+5496  U+58DE  uni58DE,  CJK UNIFIED IDEOGRAPH-58DE
        0x58DF, # G+5497  U+58DF  uni58DF,  CJK UNIFIED IDEOGRAPH-58DF
        0x58E2, # G+5498  U+58E2  uni58E2,  CJK UNIFIED IDEOGRAPH-58E2
        0x5BF5, # G+5499  U+5BF5  uni5BF5,  CJK UNIFIED IDEOGRAPH-5BF5
        0x9F90, # G+5500  U+9F90  uni9F90,  CJK UNIFIED IDEOGRAPH-9F90
        0x5EEC, # G+5501  U+5EEC  uni5EEC,  CJK UNIFIED IDEOGRAPH-5EEC
        0x61F2, # G+5502  U+61F2  uni61F2,  CJK UNIFIED IDEOGRAPH-61F2
        0x61F7, # G+5503  U+61F7  uni61F7,  CJK UNIFIED IDEOGRAPH-61F7
        0x61F6, # G+5504  U+61F6  uni61F6,  CJK UNIFIED IDEOGRAPH-61F6
        0x61F5, # G+5505  U+61F5  uni61F5,  CJK UNIFIED IDEOGRAPH-61F5
        0x6500, # G+5506  U+6500  uni6500,  CJK UNIFIED IDEOGRAPH-6500
        0x650F, # G+5507  U+650F  uni650F,  CJK UNIFIED IDEOGRAPH-650F
        0x66E0, # G+5508  U+66E0  uni66E0,  CJK UNIFIED IDEOGRAPH-66E0
        0x66DD, # G+5509  U+66DD  uni66DD,  CJK UNIFIED IDEOGRAPH-66DD
        0x6AE5, # G+5510  U+6AE5  uni6AE5,  CJK UNIFIED IDEOGRAPH-6AE5
        0x6ADD, # G+5511  U+6ADD  uni6ADD,  CJK UNIFIED IDEOGRAPH-6ADD
        0x6ADA, # G+5512  U+6ADA  uni6ADA,  CJK UNIFIED IDEOGRAPH-6ADA
        0x6AD3, # G+5513  U+6AD3  uni6AD3,  CJK UNIFIED IDEOGRAPH-6AD3
        0x701B, # G+5514  U+701B  uni701B,  CJK UNIFIED IDEOGRAPH-701B
        0x701F, # G+5515  U+701F  uni701F,  CJK UNIFIED IDEOGRAPH-701F
        0x7028, # G+5516  U+7028  uni7028,  CJK UNIFIED IDEOGRAPH-7028
        0x701A, # G+5517  U+701A  uni701A,  CJK UNIFIED IDEOGRAPH-701A
        0x701D, # G+5518  U+701D  uni701D,  CJK UNIFIED IDEOGRAPH-701D
        0x7015, # G+5519  U+7015  uni7015,  CJK UNIFIED IDEOGRAPH-7015
        0x7018, # G+5520  U+7018  uni7018,  CJK UNIFIED IDEOGRAPH-7018
        0x7206, # G+5521  U+7206  uni7206,  CJK UNIFIED IDEOGRAPH-7206
        0x720D, # G+5522  U+720D  uni720D,  CJK UNIFIED IDEOGRAPH-720D
        0x7258, # G+5523  U+7258  uni7258,  CJK UNIFIED IDEOGRAPH-7258
        0x72A2, # G+5524  U+72A2  uni72A2,  CJK UNIFIED IDEOGRAPH-72A2
        0x7378, # G+5525  U+7378  uni7378,  CJK UNIFIED IDEOGRAPH-7378
        0x737A, # G+5526  U+737A  uni737A,  CJK UNIFIED IDEOGRAPH-737A
        0x74BD, # G+5527  U+74BD  uni74BD,  CJK UNIFIED IDEOGRAPH-74BD
        0x74CA, # G+5528  U+74CA  uni74CA,  CJK UNIFIED IDEOGRAPH-74CA
        0x74E3, # G+5529  U+74E3  uni74E3,  CJK UNIFIED IDEOGRAPH-74E3
        0x7587, # G+5530  U+7587  uni7587,  CJK UNIFIED IDEOGRAPH-7587
        0x7586, # G+5531  U+7586  uni7586,  CJK UNIFIED IDEOGRAPH-7586
        0x765F, # G+5532  U+765F  uni765F,  CJK UNIFIED IDEOGRAPH-765F
        0x7661, # G+5533  U+7661  uni7661,  CJK UNIFIED IDEOGRAPH-7661
        0x77C7, # G+5534  U+77C7  uni77C7,  CJK UNIFIED IDEOGRAPH-77C7
        0x7919, # G+5535  U+7919  uni7919,  CJK UNIFIED IDEOGRAPH-7919
        0x79B1, # G+5536  U+79B1  uni79B1,  CJK UNIFIED IDEOGRAPH-79B1
        0x7A6B, # G+5537  U+7A6B  uni7A6B,  CJK UNIFIED IDEOGRAPH-7A6B
        0x7A69, # G+5538  U+7A69  uni7A69,  CJK UNIFIED IDEOGRAPH-7A69
        0x7C3E, # G+5539  U+7C3E  uni7C3E,  CJK UNIFIED IDEOGRAPH-7C3E
        0x7C3F, # G+5540  U+7C3F  uni7C3F,  CJK UNIFIED IDEOGRAPH-7C3F
        0x7C38, # G+5541  U+7C38  uni7C38,  CJK UNIFIED IDEOGRAPH-7C38
        0x7C3D, # G+5542  U+7C3D  uni7C3D,  CJK UNIFIED IDEOGRAPH-7C3D
        0x7C37, # G+5543  U+7C37  uni7C37,  CJK UNIFIED IDEOGRAPH-7C37
        0x7C40, # G+5544  U+7C40  uni7C40,  CJK UNIFIED IDEOGRAPH-7C40
        0x7E6B, # G+5545  U+7E6B  uni7E6B,  CJK UNIFIED IDEOGRAPH-7E6B
        0x7E6D, # G+5546  U+7E6D  uni7E6D,  CJK UNIFIED IDEOGRAPH-7E6D
        0x7E79, # G+5547  U+7E79  uni7E79,  CJK UNIFIED IDEOGRAPH-7E79
        0x7E69, # G+5548  U+7E69  uni7E69,  CJK UNIFIED IDEOGRAPH-7E69
        0x7E6A, # G+5549  U+7E6A  uni7E6A,  CJK UNIFIED IDEOGRAPH-7E6A
        0x7E73, # G+5550  U+7E73  uni7E73,  CJK UNIFIED IDEOGRAPH-7E73
        0x7F85, # G+5551  U+7F85  uni7F85,  CJK UNIFIED IDEOGRAPH-7F85
        0x7FB6, # G+5552  U+7FB6  uni7FB6,  CJK UNIFIED IDEOGRAPH-7FB6
        0x7FB9, # G+5553  U+7FB9  uni7FB9,  CJK UNIFIED IDEOGRAPH-7FB9
        0x7FB8, # G+5554  U+7FB8  uni7FB8,  CJK UNIFIED IDEOGRAPH-7FB8
        0x81D8, # G+5555  U+81D8  uni81D8,  CJK UNIFIED IDEOGRAPH-81D8
        0x85E9, # G+5556  U+85E9  uni85E9,  CJK UNIFIED IDEOGRAPH-85E9
        0x85DD, # G+5557  U+85DD  uni85DD,  CJK UNIFIED IDEOGRAPH-85DD
        0x85EA, # G+5558  U+85EA  uni85EA,  CJK UNIFIED IDEOGRAPH-85EA
        0x85D5, # G+5559  U+85D5  uni85D5,  CJK UNIFIED IDEOGRAPH-85D5
        0x85E4, # G+5560  U+85E4  uni85E4,  CJK UNIFIED IDEOGRAPH-85E4
        0x85E5, # G+5561  U+85E5  uni85E5,  CJK UNIFIED IDEOGRAPH-85E5
        0x85F7, # G+5562  U+85F7  uni85F7,  CJK UNIFIED IDEOGRAPH-85F7
        0x87FB, # G+5563  U+87FB  uni87FB,  CJK UNIFIED IDEOGRAPH-87FB
        0x8805, # G+5564  U+8805  uni8805,  CJK UNIFIED IDEOGRAPH-8805
        0x880D, # G+5565  U+880D  uni880D,  CJK UNIFIED IDEOGRAPH-880D
        0x87F9, # G+5566  U+87F9  uni87F9,  CJK UNIFIED IDEOGRAPH-87F9
        0x87FE, # G+5567  U+87FE  uni87FE,  CJK UNIFIED IDEOGRAPH-87FE
        0x8960, # G+5568  U+8960  uni8960,  CJK UNIFIED IDEOGRAPH-8960
        0x895F, # G+5569  U+895F  uni895F,  CJK UNIFIED IDEOGRAPH-895F
        0x8956, # G+5570  U+8956  uni8956,  CJK UNIFIED IDEOGRAPH-8956
        0x895E, # G+5571  U+895E  uni895E,  CJK UNIFIED IDEOGRAPH-895E
        0x8B41, # G+5572  U+8B41  uni8B41,  CJK UNIFIED IDEOGRAPH-8B41
        0x8B5C, # G+5573  U+8B5C  uni8B5C,  CJK UNIFIED IDEOGRAPH-8B5C
        0x8B58, # G+5574  U+8B58  uni8B58,  CJK UNIFIED IDEOGRAPH-8B58
        0x8B49, # G+5575  U+8B49  uni8B49,  CJK UNIFIED IDEOGRAPH-8B49
        0x8B5A, # G+5576  U+8B5A  uni8B5A,  CJK UNIFIED IDEOGRAPH-8B5A
        0x8B4E, # G+5577  U+8B4E  uni8B4E,  CJK UNIFIED IDEOGRAPH-8B4E
        0x8B4F, # G+5578  U+8B4F  uni8B4F,  CJK UNIFIED IDEOGRAPH-8B4F
        0x8B46, # G+5579  U+8B46  uni8B46,  CJK UNIFIED IDEOGRAPH-8B46
        0x8B59, # G+5580  U+8B59  uni8B59,  CJK UNIFIED IDEOGRAPH-8B59
        0x8D08, # G+5581  U+8D08  uni8D08,  CJK UNIFIED IDEOGRAPH-8D08
        0x8D0A, # G+5582  U+8D0A  uni8D0A,  CJK UNIFIED IDEOGRAPH-8D0A
        0x8E7C, # G+5583  U+8E7C  uni8E7C,  CJK UNIFIED IDEOGRAPH-8E7C
        0x8E72, # G+5584  U+8E72  uni8E72,  CJK UNIFIED IDEOGRAPH-8E72
        0x8E87, # G+5585  U+8E87  uni8E87,  CJK UNIFIED IDEOGRAPH-8E87
        0x8E76, # G+5586  U+8E76  uni8E76,  CJK UNIFIED IDEOGRAPH-8E76
        0x8E6C, # G+5587  U+8E6C  uni8E6C,  CJK UNIFIED IDEOGRAPH-8E6C
        0x8E7A, # G+5588  U+8E7A  uni8E7A,  CJK UNIFIED IDEOGRAPH-8E7A
        0x8E74, # G+5589  U+8E74  uni8E74,  CJK UNIFIED IDEOGRAPH-8E74
        0x8F54, # G+5590  U+8F54  uni8F54,  CJK UNIFIED IDEOGRAPH-8F54
        0x8F4E, # G+5591  U+8F4E  uni8F4E,  CJK UNIFIED IDEOGRAPH-8F4E
        0x8FAD, # G+5592  U+8FAD  uni8FAD,  CJK UNIFIED IDEOGRAPH-8FAD
        0x908A, # G+5593  U+908A  uni908A,  CJK UNIFIED IDEOGRAPH-908A
        0x908B, # G+5594  U+908B  uni908B,  CJK UNIFIED IDEOGRAPH-908B
        0x91B1, # G+5595  U+91B1  uni91B1,  CJK UNIFIED IDEOGRAPH-91B1
        0x91AE, # G+5596  U+91AE  uni91AE,  CJK UNIFIED IDEOGRAPH-91AE
        0x93E1, # G+5597  U+93E1  uni93E1,  CJK UNIFIED IDEOGRAPH-93E1
        0x93D1, # G+5598  U+93D1  uni93D1,  CJK UNIFIED IDEOGRAPH-93D1
        0x93DF, # G+5599  U+93DF  uni93DF,  CJK UNIFIED IDEOGRAPH-93DF
        0x93C3, # G+5600  U+93C3  uni93C3,  CJK UNIFIED IDEOGRAPH-93C3
        0x93C8, # G+5601  U+93C8  uni93C8,  CJK UNIFIED IDEOGRAPH-93C8
        0x93DC, # G+5602  U+93DC  uni93DC,  CJK UNIFIED IDEOGRAPH-93DC
        0x93DD, # G+5603  U+93DD  uni93DD,  CJK UNIFIED IDEOGRAPH-93DD
        0x93D6, # G+5604  U+93D6  uni93D6,  CJK UNIFIED IDEOGRAPH-93D6
        0x93E2, # G+5605  U+93E2  uni93E2,  CJK UNIFIED IDEOGRAPH-93E2
        0x93CD, # G+5606  U+93CD  uni93CD,  CJK UNIFIED IDEOGRAPH-93CD
        0x93D8, # G+5607  U+93D8  uni93D8,  CJK UNIFIED IDEOGRAPH-93D8
        0x93E4, # G+5608  U+93E4  uni93E4,  CJK UNIFIED IDEOGRAPH-93E4
        0x93D7, # G+5609  U+93D7  uni93D7,  CJK UNIFIED IDEOGRAPH-93D7
        0x93E8, # G+5610  U+93E8  uni93E8,  CJK UNIFIED IDEOGRAPH-93E8
        0x95DC, # G+5611  U+95DC  uni95DC,  CJK UNIFIED IDEOGRAPH-95DC
        0x96B4, # G+5612  U+96B4  uni96B4,  CJK UNIFIED IDEOGRAPH-96B4
        0x96E3, # G+5613  U+96E3  uni96E3,  CJK UNIFIED IDEOGRAPH-96E3
        0x972A, # G+5614  U+972A  uni972A,  CJK UNIFIED IDEOGRAPH-972A
        0x9727, # G+5615  U+9727  uni9727,  CJK UNIFIED IDEOGRAPH-9727
        0x9761, # G+5616  U+9761  uni9761,  CJK UNIFIED IDEOGRAPH-9761
        0x97DC, # G+5617  U+97DC  uni97DC,  CJK UNIFIED IDEOGRAPH-97DC
        0x97FB, # G+5618  U+97FB  uni97FB,  CJK UNIFIED IDEOGRAPH-97FB
        0x985E, # G+5619  U+985E  uni985E,  CJK UNIFIED IDEOGRAPH-985E
        0x9858, # G+5620  U+9858  uni9858,  CJK UNIFIED IDEOGRAPH-9858
        0x985B, # G+5621  U+985B  uni985B,  CJK UNIFIED IDEOGRAPH-985B
        0x98BC, # G+5622  U+98BC  uni98BC,  CJK UNIFIED IDEOGRAPH-98BC
        0x9945, # G+5623  U+9945  uni9945,  CJK UNIFIED IDEOGRAPH-9945
        0x9949, # G+5624  U+9949  uni9949,  CJK UNIFIED IDEOGRAPH-9949
        0x9A16, # G+5625  U+9A16  uni9A16,  CJK UNIFIED IDEOGRAPH-9A16
        0x9A19, # G+5626  U+9A19  uni9A19,  CJK UNIFIED IDEOGRAPH-9A19
        0x9B0D, # G+5627  U+9B0D  uni9B0D,  CJK UNIFIED IDEOGRAPH-9B0D
        0x9BE8, # G+5628  U+9BE8  uni9BE8,  CJK UNIFIED IDEOGRAPH-9BE8
        0x9BE7, # G+5629  U+9BE7  uni9BE7,  CJK UNIFIED IDEOGRAPH-9BE7
        0x9BD6, # G+5630  U+9BD6  uni9BD6,  CJK UNIFIED IDEOGRAPH-9BD6
        0x9BDB, # G+5631  U+9BDB  uni9BDB,  CJK UNIFIED IDEOGRAPH-9BDB
        0x9D89, # G+5632  U+9D89  uni9D89,  CJK UNIFIED IDEOGRAPH-9D89
        0x9D61, # G+5633  U+9D61  uni9D61,  CJK UNIFIED IDEOGRAPH-9D61
        0x9D72, # G+5634  U+9D72  uni9D72,  CJK UNIFIED IDEOGRAPH-9D72
        0x9D6A, # G+5635  U+9D6A  uni9D6A,  CJK UNIFIED IDEOGRAPH-9D6A
        0x9D6C, # G+5636  U+9D6C  uni9D6C,  CJK UNIFIED IDEOGRAPH-9D6C
        0x9E92, # G+5637  U+9E92  uni9E92,  CJK UNIFIED IDEOGRAPH-9E92
        0x9E97, # G+5638  U+9E97  uni9E97,  CJK UNIFIED IDEOGRAPH-9E97
        0x9E93, # G+5639  U+9E93  uni9E93,  CJK UNIFIED IDEOGRAPH-9E93
        0x9EB4, # G+5640  U+9EB4  uni9EB4,  CJK UNIFIED IDEOGRAPH-9EB4
        0x52F8, # G+5641  U+52F8  uni52F8,  CJK UNIFIED IDEOGRAPH-52F8
        0x56B7, # G+5642  U+56B7  uni56B7,  CJK UNIFIED IDEOGRAPH-56B7
        0x56B6, # G+5643  U+56B6  uni56B6,  CJK UNIFIED IDEOGRAPH-56B6
        0x56B4, # G+5644  U+56B4  uni56B4,  CJK UNIFIED IDEOGRAPH-56B4
        0x56BC, # G+5645  U+56BC  uni56BC,  CJK UNIFIED IDEOGRAPH-56BC
        0x58E4, # G+5646  U+58E4  uni58E4,  CJK UNIFIED IDEOGRAPH-58E4
        0x5B40, # G+5647  U+5B40  uni5B40,  CJK UNIFIED IDEOGRAPH-5B40
        0x5B43, # G+5648  U+5B43  uni5B43,  CJK UNIFIED IDEOGRAPH-5B43
        0x5B7D, # G+5649  U+5B7D  uni5B7D,  CJK UNIFIED IDEOGRAPH-5B7D
        0x5BF6, # G+5650  U+5BF6  uni5BF6,  CJK UNIFIED IDEOGRAPH-5BF6
        0x5DC9, # G+5651  U+5DC9  uni5DC9,  CJK UNIFIED IDEOGRAPH-5DC9
        0x61F8, # G+5652  U+61F8  uni61F8,  CJK UNIFIED IDEOGRAPH-61F8
        0x61FA, # G+5653  U+61FA  uni61FA,  CJK UNIFIED IDEOGRAPH-61FA
        0x6518, # G+5654  U+6518  uni6518,  CJK UNIFIED IDEOGRAPH-6518
        0x6514, # G+5655  U+6514  uni6514,  CJK UNIFIED IDEOGRAPH-6514
        0x6519, # G+5656  U+6519  uni6519,  CJK UNIFIED IDEOGRAPH-6519
        0x66E6, # G+5657  U+66E6  uni66E6,  CJK UNIFIED IDEOGRAPH-66E6
        0x6727, # G+5658  U+6727  uni6727,  CJK UNIFIED IDEOGRAPH-6727
        0x6AEC, # G+5659  U+6AEC  uni6AEC,  CJK UNIFIED IDEOGRAPH-6AEC
        0x703E, # G+5660  U+703E  uni703E,  CJK UNIFIED IDEOGRAPH-703E
        0x7030, # G+5661  U+7030  uni7030,  CJK UNIFIED IDEOGRAPH-7030
        0x7032, # G+5662  U+7032  uni7032,  CJK UNIFIED IDEOGRAPH-7032
        0x7210, # G+5663  U+7210  uni7210,  CJK UNIFIED IDEOGRAPH-7210
        0x737B, # G+5664  U+737B  uni737B,  CJK UNIFIED IDEOGRAPH-737B
        0x74CF, # G+5665  U+74CF  uni74CF,  CJK UNIFIED IDEOGRAPH-74CF
        0x7662, # G+5666  U+7662  uni7662,  CJK UNIFIED IDEOGRAPH-7662
        0x7665, # G+5667  U+7665  uni7665,  CJK UNIFIED IDEOGRAPH-7665
        0x7926, # G+5668  U+7926  uni7926,  CJK UNIFIED IDEOGRAPH-7926
        0x792A, # G+5669  U+792A  uni792A,  CJK UNIFIED IDEOGRAPH-792A
        0x792C, # G+5670  U+792C  uni792C,  CJK UNIFIED IDEOGRAPH-792C
        0x792B, # G+5671  U+792B  uni792B,  CJK UNIFIED IDEOGRAPH-792B
        0x7AC7, # G+5672  U+7AC7  uni7AC7,  CJK UNIFIED IDEOGRAPH-7AC7
        0x7AF6, # G+5673  U+7AF6  uni7AF6,  CJK UNIFIED IDEOGRAPH-7AF6
        0x7C4C, # G+5674  U+7C4C  uni7C4C,  CJK UNIFIED IDEOGRAPH-7C4C
        0x7C43, # G+5675  U+7C43  uni7C43,  CJK UNIFIED IDEOGRAPH-7C43
        0x7C4D, # G+5676  U+7C4D  uni7C4D,  CJK UNIFIED IDEOGRAPH-7C4D
        0x7CEF, # G+5677  U+7CEF  uni7CEF,  CJK UNIFIED IDEOGRAPH-7CEF
        0x7CF0, # G+5678  U+7CF0  uni7CF0,  CJK UNIFIED IDEOGRAPH-7CF0
        0x8FAE, # G+5679  U+8FAE  uni8FAE,  CJK UNIFIED IDEOGRAPH-8FAE
        0x7E7D, # G+5680  U+7E7D  uni7E7D,  CJK UNIFIED IDEOGRAPH-7E7D
        0x7E7C, # G+5681  U+7E7C  uni7E7C,  CJK UNIFIED IDEOGRAPH-7E7C
        0x7E82, # G+5682  U+7E82  uni7E82,  CJK UNIFIED IDEOGRAPH-7E82
        0x7F4C, # G+5683  U+7F4C  uni7F4C,  CJK UNIFIED IDEOGRAPH-7F4C
        0x8000, # G+5684  U+8000  uni8000,  CJK UNIFIED IDEOGRAPH-8000
        0x81DA, # G+5685  U+81DA  uni81DA,  CJK UNIFIED IDEOGRAPH-81DA
        0x8266, # G+5686  U+8266  uni8266,  CJK UNIFIED IDEOGRAPH-8266
        0x85FB, # G+5687  U+85FB  uni85FB,  CJK UNIFIED IDEOGRAPH-85FB
        0x85F9, # G+5688  U+85F9  uni85F9,  CJK UNIFIED IDEOGRAPH-85F9
        0x8611, # G+5689  U+8611  uni8611,  CJK UNIFIED IDEOGRAPH-8611
        0x85FA, # G+5690  U+85FA  uni85FA,  CJK UNIFIED IDEOGRAPH-85FA
        0x8606, # G+5691  U+8606  uni8606,  CJK UNIFIED IDEOGRAPH-8606
        0x860B, # G+5692  U+860B  uni860B,  CJK UNIFIED IDEOGRAPH-860B
        0x8607, # G+5693  U+8607  uni8607,  CJK UNIFIED IDEOGRAPH-8607
        0x860A, # G+5694  U+860A  uni860A,  CJK UNIFIED IDEOGRAPH-860A
        0x8814, # G+5695  U+8814  uni8814,  CJK UNIFIED IDEOGRAPH-8814
        0x8815, # G+5696  U+8815  uni8815,  CJK UNIFIED IDEOGRAPH-8815
        0x8964, # G+5697  U+8964  uni8964,  CJK UNIFIED IDEOGRAPH-8964
        0x89BA, # G+5698  U+89BA  uni89BA,  CJK UNIFIED IDEOGRAPH-89BA
        0x89F8, # G+5699  U+89F8  uni89F8,  CJK UNIFIED IDEOGRAPH-89F8
        0x8B70, # G+5700  U+8B70  uni8B70,  CJK UNIFIED IDEOGRAPH-8B70
        0x8B6C, # G+5701  U+8B6C  uni8B6C,  CJK UNIFIED IDEOGRAPH-8B6C
        0x8B66, # G+5702  U+8B66  uni8B66,  CJK UNIFIED IDEOGRAPH-8B66
        0x8B6F, # G+5703  U+8B6F  uni8B6F,  CJK UNIFIED IDEOGRAPH-8B6F
        0x8B5F, # G+5704  U+8B5F  uni8B5F,  CJK UNIFIED IDEOGRAPH-8B5F
        0x8B6B, # G+5705  U+8B6B  uni8B6B,  CJK UNIFIED IDEOGRAPH-8B6B
        0x8D0F, # G+5706  U+8D0F  uni8D0F,  CJK UNIFIED IDEOGRAPH-8D0F
        0x8D0D, # G+5707  U+8D0D  uni8D0D,  CJK UNIFIED IDEOGRAPH-8D0D
        0x8E89, # G+5708  U+8E89  uni8E89,  CJK UNIFIED IDEOGRAPH-8E89
        0x8E81, # G+5709  U+8E81  uni8E81,  CJK UNIFIED IDEOGRAPH-8E81
        0x8E85, # G+5710  U+8E85  uni8E85,  CJK UNIFIED IDEOGRAPH-8E85
        0x8E82, # G+5711  U+8E82  uni8E82,  CJK UNIFIED IDEOGRAPH-8E82
        0x91B4, # G+5712  U+91B4  uni91B4,  CJK UNIFIED IDEOGRAPH-91B4
        0x91CB, # G+5713  U+91CB  uni91CB,  CJK UNIFIED IDEOGRAPH-91CB
        0x9418, # G+5714  U+9418  uni9418,  CJK UNIFIED IDEOGRAPH-9418
        0x9403, # G+5715  U+9403  uni9403,  CJK UNIFIED IDEOGRAPH-9403
        0x93FD, # G+5716  U+93FD  uni93FD,  CJK UNIFIED IDEOGRAPH-93FD
        0x95E1, # G+5717  U+95E1  uni95E1,  CJK UNIFIED IDEOGRAPH-95E1
        0x9730, # G+5718  U+9730  uni9730,  CJK UNIFIED IDEOGRAPH-9730
        0x98C4, # G+5719  U+98C4  uni98C4,  CJK UNIFIED IDEOGRAPH-98C4
        0x9952, # G+5720  U+9952  uni9952,  CJK UNIFIED IDEOGRAPH-9952
        0x9951, # G+5721  U+9951  uni9951,  CJK UNIFIED IDEOGRAPH-9951
        0x99A8, # G+5722  U+99A8  uni99A8,  CJK UNIFIED IDEOGRAPH-99A8
        0x9A2B, # G+5723  U+9A2B  uni9A2B,  CJK UNIFIED IDEOGRAPH-9A2B
        0x9A30, # G+5724  U+9A30  uni9A30,  CJK UNIFIED IDEOGRAPH-9A30
        0x9A37, # G+5725  U+9A37  uni9A37,  CJK UNIFIED IDEOGRAPH-9A37
        0x9A35, # G+5726  U+9A35  uni9A35,  CJK UNIFIED IDEOGRAPH-9A35
        0x9C13, # G+5727  U+9C13  uni9C13,  CJK UNIFIED IDEOGRAPH-9C13
        0x9C0D, # G+5728  U+9C0D  uni9C0D,  CJK UNIFIED IDEOGRAPH-9C0D
        0x9E79, # G+5729  U+9E79  uni9E79,  CJK UNIFIED IDEOGRAPH-9E79
        0x9EB5, # G+5730  U+9EB5  uni9EB5,  CJK UNIFIED IDEOGRAPH-9EB5
        0x9EE8, # G+5731  U+9EE8  uni9EE8,  CJK UNIFIED IDEOGRAPH-9EE8
        0x9F2F, # G+5732  U+9F2F  uni9F2F,  CJK UNIFIED IDEOGRAPH-9F2F
        0x9F5F, # G+5733  U+9F5F  uni9F5F,  CJK UNIFIED IDEOGRAPH-9F5F
        0x9F63, # G+5734  U+9F63  uni9F63,  CJK UNIFIED IDEOGRAPH-9F63
        0x9F61, # G+5735  U+9F61  uni9F61,  CJK UNIFIED IDEOGRAPH-9F61
        0x5137, # G+5736  U+5137  uni5137,  CJK UNIFIED IDEOGRAPH-5137
        0x5138, # G+5737  U+5138  uni5138,  CJK UNIFIED IDEOGRAPH-5138
        0x56C1, # G+5738  U+56C1  uni56C1,  CJK UNIFIED IDEOGRAPH-56C1
        0x56C0, # G+5739  U+56C0  uni56C0,  CJK UNIFIED IDEOGRAPH-56C0
        0x56C2, # G+5740  U+56C2  uni56C2,  CJK UNIFIED IDEOGRAPH-56C2
        0x5914, # G+5741  U+5914  uni5914,  CJK UNIFIED IDEOGRAPH-5914
        0x5C6C, # G+5742  U+5C6C  uni5C6C,  CJK UNIFIED IDEOGRAPH-5C6C
        0x5DCD, # G+5743  U+5DCD  uni5DCD,  CJK UNIFIED IDEOGRAPH-5DCD
        0x61FC, # G+5744  U+61FC  uni61FC,  CJK UNIFIED IDEOGRAPH-61FC
        0x61FE, # G+5745  U+61FE  uni61FE,  CJK UNIFIED IDEOGRAPH-61FE
        0x651D, # G+5746  U+651D  uni651D,  CJK UNIFIED IDEOGRAPH-651D
        0x651C, # G+5747  U+651C  uni651C,  CJK UNIFIED IDEOGRAPH-651C
        0x6595, # G+5748  U+6595  uni6595,  CJK UNIFIED IDEOGRAPH-6595
        0x66E9, # G+5749  U+66E9  uni66E9,  CJK UNIFIED IDEOGRAPH-66E9
        0x6AFB, # G+5750  U+6AFB  uni6AFB,  CJK UNIFIED IDEOGRAPH-6AFB
        0x6B04, # G+5751  U+6B04  uni6B04,  CJK UNIFIED IDEOGRAPH-6B04
        0x6AFA, # G+5752  U+6AFA  uni6AFA,  CJK UNIFIED IDEOGRAPH-6AFA
        0x6BB2, # G+5753  U+6BB2  uni6BB2,  CJK UNIFIED IDEOGRAPH-6BB2
        0x704C, # G+5754  U+704C  uni704C,  CJK UNIFIED IDEOGRAPH-704C
        0x721B, # G+5755  U+721B  uni721B,  CJK UNIFIED IDEOGRAPH-721B
        0x72A7, # G+5756  U+72A7  uni72A7,  CJK UNIFIED IDEOGRAPH-72A7
        0x74D6, # G+5757  U+74D6  uni74D6,  CJK UNIFIED IDEOGRAPH-74D6
        0x74D4, # G+5758  U+74D4  uni74D4,  CJK UNIFIED IDEOGRAPH-74D4
        0x7669, # G+5759  U+7669  uni7669,  CJK UNIFIED IDEOGRAPH-7669
        0x77D3, # G+5760  U+77D3  uni77D3,  CJK UNIFIED IDEOGRAPH-77D3
        0x7C50, # G+5761  U+7C50  uni7C50,  CJK UNIFIED IDEOGRAPH-7C50
        0x7E8F, # G+5762  U+7E8F  uni7E8F,  CJK UNIFIED IDEOGRAPH-7E8F
        0x7E8C, # G+5763  U+7E8C  uni7E8C,  CJK UNIFIED IDEOGRAPH-7E8C
        0x7FBC, # G+5764  U+7FBC  uni7FBC,  CJK UNIFIED IDEOGRAPH-7FBC
        0x8617, # G+5765  U+8617  uni8617,  CJK UNIFIED IDEOGRAPH-8617
        0x862D, # G+5766  U+862D  uni862D,  CJK UNIFIED IDEOGRAPH-862D
        0x861A, # G+5767  U+861A  uni861A,  CJK UNIFIED IDEOGRAPH-861A
        0x8823, # G+5768  U+8823  uni8823,  CJK UNIFIED IDEOGRAPH-8823
        0x8822, # G+5769  U+8822  uni8822,  CJK UNIFIED IDEOGRAPH-8822
        0x8821, # G+5770  U+8821  uni8821,  CJK UNIFIED IDEOGRAPH-8821
        0x881F, # G+5771  U+881F  uni881F,  CJK UNIFIED IDEOGRAPH-881F
        0x896A, # G+5772  U+896A  uni896A,  CJK UNIFIED IDEOGRAPH-896A
        0x896C, # G+5773  U+896C  uni896C,  CJK UNIFIED IDEOGRAPH-896C
        0x89BD, # G+5774  U+89BD  uni89BD,  CJK UNIFIED IDEOGRAPH-89BD
        0x8B74, # G+5775  U+8B74  uni8B74,  CJK UNIFIED IDEOGRAPH-8B74
        0x8B77, # G+5776  U+8B77  uni8B77,  CJK UNIFIED IDEOGRAPH-8B77
        0x8B7D, # G+5777  U+8B7D  uni8B7D,  CJK UNIFIED IDEOGRAPH-8B7D
        0x8D13, # G+5778  U+8D13  uni8D13,  CJK UNIFIED IDEOGRAPH-8D13
        0x8E8A, # G+5779  U+8E8A  uni8E8A,  CJK UNIFIED IDEOGRAPH-8E8A
        0x8E8D, # G+5780  U+8E8D  uni8E8D,  CJK UNIFIED IDEOGRAPH-8E8D
        0x8E8B, # G+5781  U+8E8B  uni8E8B,  CJK UNIFIED IDEOGRAPH-8E8B
        0x8F5F, # G+5782  U+8F5F  uni8F5F,  CJK UNIFIED IDEOGRAPH-8F5F
        0x8FAF, # G+5783  U+8FAF  uni8FAF,  CJK UNIFIED IDEOGRAPH-8FAF
        0x91BA, # G+5784  U+91BA  uni91BA,  CJK UNIFIED IDEOGRAPH-91BA
        0x942E, # G+5785  U+942E  uni942E,  CJK UNIFIED IDEOGRAPH-942E
        0x9433, # G+5786  U+9433  uni9433,  CJK UNIFIED IDEOGRAPH-9433
        0x9435, # G+5787  U+9435  uni9435,  CJK UNIFIED IDEOGRAPH-9435
        0x943A, # G+5788  U+943A  uni943A,  CJK UNIFIED IDEOGRAPH-943A
        0x9438, # G+5789  U+9438  uni9438,  CJK UNIFIED IDEOGRAPH-9438
        0x9432, # G+5790  U+9432  uni9432,  CJK UNIFIED IDEOGRAPH-9432
        0x942B, # G+5791  U+942B  uni942B,  CJK UNIFIED IDEOGRAPH-942B
        0x95E2, # G+5792  U+95E2  uni95E2,  CJK UNIFIED IDEOGRAPH-95E2
        0x9738, # G+5793  U+9738  uni9738,  CJK UNIFIED IDEOGRAPH-9738
        0x9739, # G+5794  U+9739  uni9739,  CJK UNIFIED IDEOGRAPH-9739
        0x9732, # G+5795  U+9732  uni9732,  CJK UNIFIED IDEOGRAPH-9732
        0x97FF, # G+5796  U+97FF  uni97FF,  CJK UNIFIED IDEOGRAPH-97FF
        0x9867, # G+5797  U+9867  uni9867,  CJK UNIFIED IDEOGRAPH-9867
        0x9865, # G+5798  U+9865  uni9865,  CJK UNIFIED IDEOGRAPH-9865
        0x9957, # G+5799  U+9957  uni9957,  CJK UNIFIED IDEOGRAPH-9957
        0x9A45, # G+5800  U+9A45  uni9A45,  CJK UNIFIED IDEOGRAPH-9A45
        0x9A43, # G+5801  U+9A43  uni9A43,  CJK UNIFIED IDEOGRAPH-9A43
        0x9A40, # G+5802  U+9A40  uni9A40,  CJK UNIFIED IDEOGRAPH-9A40
        0x9A3E, # G+5803  U+9A3E  uni9A3E,  CJK UNIFIED IDEOGRAPH-9A3E
        0x9ACF, # G+5804  U+9ACF  uni9ACF,  CJK UNIFIED IDEOGRAPH-9ACF
        0x9B54, # G+5805  U+9B54  uni9B54,  CJK UNIFIED IDEOGRAPH-9B54
        0x9B51, # G+5806  U+9B51  uni9B51,  CJK UNIFIED IDEOGRAPH-9B51
        0x9C2D, # G+5807  U+9C2D  uni9C2D,  CJK UNIFIED IDEOGRAPH-9C2D
        0x9C25, # G+5808  U+9C25  uni9C25,  CJK UNIFIED IDEOGRAPH-9C25
        0x9DAF, # G+5809  U+9DAF  uni9DAF,  CJK UNIFIED IDEOGRAPH-9DAF
        0x9DB4, # G+5810  U+9DB4  uni9DB4,  CJK UNIFIED IDEOGRAPH-9DB4
        0x9DC2, # G+5811  U+9DC2  uni9DC2,  CJK UNIFIED IDEOGRAPH-9DC2
        0x9DB8, # G+5812  U+9DB8  uni9DB8,  CJK UNIFIED IDEOGRAPH-9DB8
        0x9E9D, # G+5813  U+9E9D  uni9E9D,  CJK UNIFIED IDEOGRAPH-9E9D
        0x9EEF, # G+5814  U+9EEF  uni9EEF,  CJK UNIFIED IDEOGRAPH-9EEF
        0x9F19, # G+5815  U+9F19  uni9F19,  CJK UNIFIED IDEOGRAPH-9F19
        0x9F5C, # G+5816  U+9F5C  uni9F5C,  CJK UNIFIED IDEOGRAPH-9F5C
        0x9F66, # G+5817  U+9F66  uni9F66,  CJK UNIFIED IDEOGRAPH-9F66
        0x9F67, # G+5818  U+9F67  uni9F67,  CJK UNIFIED IDEOGRAPH-9F67
        0x513C, # G+5819  U+513C  uni513C,  CJK UNIFIED IDEOGRAPH-513C
        0x513B, # G+5820  U+513B  uni513B,  CJK UNIFIED IDEOGRAPH-513B
        0x56C8, # G+5821  U+56C8  uni56C8,  CJK UNIFIED IDEOGRAPH-56C8
        0x56CA, # G+5822  U+56CA  uni56CA,  CJK UNIFIED IDEOGRAPH-56CA
        0x56C9, # G+5823  U+56C9  uni56C9,  CJK UNIFIED IDEOGRAPH-56C9
        0x5B7F, # G+5824  U+5B7F  uni5B7F,  CJK UNIFIED IDEOGRAPH-5B7F
        0x5DD4, # G+5825  U+5DD4  uni5DD4,  CJK UNIFIED IDEOGRAPH-5DD4
        0x5DD2, # G+5826  U+5DD2  uni5DD2,  CJK UNIFIED IDEOGRAPH-5DD2
        0x5F4E, # G+5827  U+5F4E  uni5F4E,  CJK UNIFIED IDEOGRAPH-5F4E
        0x61FF, # G+5828  U+61FF  uni61FF,  CJK UNIFIED IDEOGRAPH-61FF
        0x6524, # G+5829  U+6524  uni6524,  CJK UNIFIED IDEOGRAPH-6524
        0x6B0A, # G+5830  U+6B0A  uni6B0A,  CJK UNIFIED IDEOGRAPH-6B0A
        0x6B61, # G+5831  U+6B61  uni6B61,  CJK UNIFIED IDEOGRAPH-6B61
        0x7051, # G+5832  U+7051  uni7051,  CJK UNIFIED IDEOGRAPH-7051
        0x7058, # G+5833  U+7058  uni7058,  CJK UNIFIED IDEOGRAPH-7058
        0x7380, # G+5834  U+7380  uni7380,  CJK UNIFIED IDEOGRAPH-7380
        0x74E4, # G+5835  U+74E4  uni74E4,  CJK UNIFIED IDEOGRAPH-74E4
        0x758A, # G+5836  U+758A  uni758A,  CJK UNIFIED IDEOGRAPH-758A
        0x766E, # G+5837  U+766E  uni766E,  CJK UNIFIED IDEOGRAPH-766E
        0x766C, # G+5838  U+766C  uni766C,  CJK UNIFIED IDEOGRAPH-766C
        0x79B3, # G+5839  U+79B3  uni79B3,  CJK UNIFIED IDEOGRAPH-79B3
        0x7C60, # G+5840  U+7C60  uni7C60,  CJK UNIFIED IDEOGRAPH-7C60
        0x7C5F, # G+5841  U+7C5F  uni7C5F,  CJK UNIFIED IDEOGRAPH-7C5F
        0x807E, # G+5842  U+807E  uni807E,  CJK UNIFIED IDEOGRAPH-807E
        0x807D, # G+5843  U+807D  uni807D,  CJK UNIFIED IDEOGRAPH-807D
        0x81DF, # G+5844  U+81DF  uni81DF,  CJK UNIFIED IDEOGRAPH-81DF
        0x8972, # G+5845  U+8972  uni8972,  CJK UNIFIED IDEOGRAPH-8972
        0x896F, # G+5846  U+896F  uni896F,  CJK UNIFIED IDEOGRAPH-896F
        0x89FC, # G+5847  U+89FC  uni89FC,  CJK UNIFIED IDEOGRAPH-89FC
        0x8B80, # G+5848  U+8B80  uni8B80,  CJK UNIFIED IDEOGRAPH-8B80
        0x8D16, # G+5849  U+8D16  uni8D16,  CJK UNIFIED IDEOGRAPH-8D16
        0x8D17, # G+5850  U+8D17  uni8D17,  CJK UNIFIED IDEOGRAPH-8D17
        0x8E91, # G+5851  U+8E91  uni8E91,  CJK UNIFIED IDEOGRAPH-8E91
        0x8E93, # G+5852  U+8E93  uni8E93,  CJK UNIFIED IDEOGRAPH-8E93
        0x8F61, # G+5853  U+8F61  uni8F61,  CJK UNIFIED IDEOGRAPH-8F61
        0x9148, # G+5854  U+9148  uni9148,  CJK UNIFIED IDEOGRAPH-9148
        0x9444, # G+5855  U+9444  uni9444,  CJK UNIFIED IDEOGRAPH-9444
        0x9451, # G+5856  U+9451  uni9451,  CJK UNIFIED IDEOGRAPH-9451
        0x9452, # G+5857  U+9452  uni9452,  CJK UNIFIED IDEOGRAPH-9452
        0x973D, # G+5858  U+973D  uni973D,  CJK UNIFIED IDEOGRAPH-973D
        0x973E, # G+5859  U+973E  uni973E,  CJK UNIFIED IDEOGRAPH-973E
        0x97C3, # G+5860  U+97C3  uni97C3,  CJK UNIFIED IDEOGRAPH-97C3
        0x97C1, # G+5861  U+97C1  uni97C1,  CJK UNIFIED IDEOGRAPH-97C1
        0x986B, # G+5862  U+986B  uni986B,  CJK UNIFIED IDEOGRAPH-986B
        0x9955, # G+5863  U+9955  uni9955,  CJK UNIFIED IDEOGRAPH-9955
        0x9A55, # G+5864  U+9A55  uni9A55,  CJK UNIFIED IDEOGRAPH-9A55
        0x9A4D, # G+5865  U+9A4D  uni9A4D,  CJK UNIFIED IDEOGRAPH-9A4D
        0x9AD2, # G+5866  U+9AD2  uni9AD2,  CJK UNIFIED IDEOGRAPH-9AD2
        0x9B1A, # G+5867  U+9B1A  uni9B1A,  CJK UNIFIED IDEOGRAPH-9B1A
        0x9C49, # G+5868  U+9C49  uni9C49,  CJK UNIFIED IDEOGRAPH-9C49
        0x9C31, # G+5869  U+9C31  uni9C31,  CJK UNIFIED IDEOGRAPH-9C31
        0x9C3E, # G+5870  U+9C3E  uni9C3E,  CJK UNIFIED IDEOGRAPH-9C3E
        0x9C3B, # G+5871  U+9C3B  uni9C3B,  CJK UNIFIED IDEOGRAPH-9C3B
        0x9DD3, # G+5872  U+9DD3  uni9DD3,  CJK UNIFIED IDEOGRAPH-9DD3
        0x9DD7, # G+5873  U+9DD7  uni9DD7,  CJK UNIFIED IDEOGRAPH-9DD7
        0x9F34, # G+5874  U+9F34  uni9F34,  CJK UNIFIED IDEOGRAPH-9F34
        0x9F6C, # G+5875  U+9F6C  uni9F6C,  CJK UNIFIED IDEOGRAPH-9F6C
        0x9F6A, # G+5876  U+9F6A  uni9F6A,  CJK UNIFIED IDEOGRAPH-9F6A
        0x9F94, # G+5877  U+9F94  uni9F94,  CJK UNIFIED IDEOGRAPH-9F94
        0x56CC, # G+5878  U+56CC  uni56CC,  CJK UNIFIED IDEOGRAPH-56CC
        0x5DD6, # G+5879  U+5DD6  uni5DD6,  CJK UNIFIED IDEOGRAPH-5DD6
        0x6200, # G+5880  U+6200  uni6200,  CJK UNIFIED IDEOGRAPH-6200
        0x6523, # G+5881  U+6523  uni6523,  CJK UNIFIED IDEOGRAPH-6523
        0x652B, # G+5882  U+652B  uni652B,  CJK UNIFIED IDEOGRAPH-652B
        0x652A, # G+5883  U+652A  uni652A,  CJK UNIFIED IDEOGRAPH-652A
        0x66EC, # G+5884  U+66EC  uni66EC,  CJK UNIFIED IDEOGRAPH-66EC
        0x6B10, # G+5885  U+6B10  uni6B10,  CJK UNIFIED IDEOGRAPH-6B10
        0x74DA, # G+5886  U+74DA  uni74DA,  CJK UNIFIED IDEOGRAPH-74DA
        0x7ACA, # G+5887  U+7ACA  uni7ACA,  CJK UNIFIED IDEOGRAPH-7ACA
        0x7C64, # G+5888  U+7C64  uni7C64,  CJK UNIFIED IDEOGRAPH-7C64
        0x7C63, # G+5889  U+7C63  uni7C63,  CJK UNIFIED IDEOGRAPH-7C63
        0x7C65, # G+5890  U+7C65  uni7C65,  CJK UNIFIED IDEOGRAPH-7C65
        0x7E93, # G+5891  U+7E93  uni7E93,  CJK UNIFIED IDEOGRAPH-7E93
        0x7E96, # G+5892  U+7E96  uni7E96,  CJK UNIFIED IDEOGRAPH-7E96
        0x7E94, # G+5893  U+7E94  uni7E94,  CJK UNIFIED IDEOGRAPH-7E94
        0x81E2, # G+5894  U+81E2  uni81E2,  CJK UNIFIED IDEOGRAPH-81E2
        0x8638, # G+5895  U+8638  uni8638,  CJK UNIFIED IDEOGRAPH-8638
        0x863F, # G+5896  U+863F  uni863F,  CJK UNIFIED IDEOGRAPH-863F
        0x8831, # G+5897  U+8831  uni8831,  CJK UNIFIED IDEOGRAPH-8831
        0x8B8A, # G+5898  U+8B8A  uni8B8A,  CJK UNIFIED IDEOGRAPH-8B8A
        0x9090, # G+5899  U+9090  uni9090,  CJK UNIFIED IDEOGRAPH-9090
        0x908F, # G+5900  U+908F  uni908F,  CJK UNIFIED IDEOGRAPH-908F
        0x9463, # G+5901  U+9463  uni9463,  CJK UNIFIED IDEOGRAPH-9463
        0x9460, # G+5902  U+9460  uni9460,  CJK UNIFIED IDEOGRAPH-9460
        0x9464, # G+5903  U+9464  uni9464,  CJK UNIFIED IDEOGRAPH-9464
        0x9768, # G+5904  U+9768  uni9768,  CJK UNIFIED IDEOGRAPH-9768
        0x986F, # G+5905  U+986F  uni986F,  CJK UNIFIED IDEOGRAPH-986F
        0x995C, # G+5906  U+995C  uni995C,  CJK UNIFIED IDEOGRAPH-995C
        0x9A5A, # G+5907  U+9A5A  uni9A5A,  CJK UNIFIED IDEOGRAPH-9A5A
        0x9A5B, # G+5908  U+9A5B  uni9A5B,  CJK UNIFIED IDEOGRAPH-9A5B
        0x9A57, # G+5909  U+9A57  uni9A57,  CJK UNIFIED IDEOGRAPH-9A57
        0x9AD3, # G+5910  U+9AD3  uni9AD3,  CJK UNIFIED IDEOGRAPH-9AD3
        0x9AD4, # G+5911  U+9AD4  uni9AD4,  CJK UNIFIED IDEOGRAPH-9AD4
        0x9AD1, # G+5912  U+9AD1  uni9AD1,  CJK UNIFIED IDEOGRAPH-9AD1
        0x9C54, # G+5913  U+9C54  uni9C54,  CJK UNIFIED IDEOGRAPH-9C54
        0x9C57, # G+5914  U+9C57  uni9C57,  CJK UNIFIED IDEOGRAPH-9C57
        0x9C56, # G+5915  U+9C56  uni9C56,  CJK UNIFIED IDEOGRAPH-9C56
        0x9DE5, # G+5916  U+9DE5  uni9DE5,  CJK UNIFIED IDEOGRAPH-9DE5
        0x9E9F, # G+5917  U+9E9F  uni9E9F,  CJK UNIFIED IDEOGRAPH-9E9F
        0x9EF4, # G+5918  U+9EF4  uni9EF4,  CJK UNIFIED IDEOGRAPH-9EF4
        0x56D1, # G+5919  U+56D1  uni56D1,  CJK UNIFIED IDEOGRAPH-56D1
        0x58E9, # G+5920  U+58E9  uni58E9,  CJK UNIFIED IDEOGRAPH-58E9
        0x652C, # G+5921  U+652C  uni652C,  CJK UNIFIED IDEOGRAPH-652C
        0x705E, # G+5922  U+705E  uni705E,  CJK UNIFIED IDEOGRAPH-705E
        0x7671, # G+5923  U+7671  uni7671,  CJK UNIFIED IDEOGRAPH-7671
        0x7672, # G+5924  U+7672  uni7672,  CJK UNIFIED IDEOGRAPH-7672
        0x77D7, # G+5925  U+77D7  uni77D7,  CJK UNIFIED IDEOGRAPH-77D7
        0x7F50, # G+5926  U+7F50  uni7F50,  CJK UNIFIED IDEOGRAPH-7F50
        0x7F88, # G+5927  U+7F88  uni7F88,  CJK UNIFIED IDEOGRAPH-7F88
        0x8836, # G+5928  U+8836  uni8836,  CJK UNIFIED IDEOGRAPH-8836
        0x8839, # G+5929  U+8839  uni8839,  CJK UNIFIED IDEOGRAPH-8839
        0x8862, # G+5930  U+8862  uni8862,  CJK UNIFIED IDEOGRAPH-8862
        0x8B93, # G+5931  U+8B93  uni8B93,  CJK UNIFIED IDEOGRAPH-8B93
        0x8B92, # G+5932  U+8B92  uni8B92,  CJK UNIFIED IDEOGRAPH-8B92
        0x8B96, # G+5933  U+8B96  uni8B96,  CJK UNIFIED IDEOGRAPH-8B96
        0x8277, # G+5934  U+8277  uni8277,  CJK UNIFIED IDEOGRAPH-8277
        0x8D1B, # G+5935  U+8D1B  uni8D1B,  CJK UNIFIED IDEOGRAPH-8D1B
        0x91C0, # G+5936  U+91C0  uni91C0,  CJK UNIFIED IDEOGRAPH-91C0
        0x946A, # G+5937  U+946A  uni946A,  CJK UNIFIED IDEOGRAPH-946A
        0x9742, # G+5938  U+9742  uni9742,  CJK UNIFIED IDEOGRAPH-9742
        0x9748, # G+5939  U+9748  uni9748,  CJK UNIFIED IDEOGRAPH-9748
        0x9744, # G+5940  U+9744  uni9744,  CJK UNIFIED IDEOGRAPH-9744
        0x97C6, # G+5941  U+97C6  uni97C6,  CJK UNIFIED IDEOGRAPH-97C6
        0x9870, # G+5942  U+9870  uni9870,  CJK UNIFIED IDEOGRAPH-9870
        0x9A5F, # G+5943  U+9A5F  uni9A5F,  CJK UNIFIED IDEOGRAPH-9A5F
        0x9B22, # G+5944  U+9B22  uni9B22,  CJK UNIFIED IDEOGRAPH-9B22
        0x9B58, # G+5945  U+9B58  uni9B58,  CJK UNIFIED IDEOGRAPH-9B58
        0x9C5F, # G+5946  U+9C5F  uni9C5F,  CJK UNIFIED IDEOGRAPH-9C5F
        0x9DF9, # G+5947  U+9DF9  uni9DF9,  CJK UNIFIED IDEOGRAPH-9DF9
        0x9DFA, # G+5948  U+9DFA  uni9DFA,  CJK UNIFIED IDEOGRAPH-9DFA
        0x9E7C, # G+5949  U+9E7C  uni9E7C,  CJK UNIFIED IDEOGRAPH-9E7C
        0x9E7D, # G+5950  U+9E7D  uni9E7D,  CJK UNIFIED IDEOGRAPH-9E7D
        0x9F07, # G+5951  U+9F07  uni9F07,  CJK UNIFIED IDEOGRAPH-9F07
        0x9F77, # G+5952  U+9F77  uni9F77,  CJK UNIFIED IDEOGRAPH-9F77
        0x9F72, # G+5953  U+9F72  uni9F72,  CJK UNIFIED IDEOGRAPH-9F72
        0x5EF3, # G+5954  U+5EF3  uni5EF3,  CJK UNIFIED IDEOGRAPH-5EF3
        0x6B16, # G+5955  U+6B16  uni6B16,  CJK UNIFIED IDEOGRAPH-6B16
        0x7063, # G+5956  U+7063  uni7063,  CJK UNIFIED IDEOGRAPH-7063
        0x7C6C, # G+5957  U+7C6C  uni7C6C,  CJK UNIFIED IDEOGRAPH-7C6C
        0x7C6E, # G+5958  U+7C6E  uni7C6E,  CJK UNIFIED IDEOGRAPH-7C6E
        0x883B, # G+5959  U+883B  uni883B,  CJK UNIFIED IDEOGRAPH-883B
        0x89C0, # G+5960  U+89C0  uni89C0,  CJK UNIFIED IDEOGRAPH-89C0
        0x8EA1, # G+5961  U+8EA1  uni8EA1,  CJK UNIFIED IDEOGRAPH-8EA1
        0x91C1, # G+5962  U+91C1  uni91C1,  CJK UNIFIED IDEOGRAPH-91C1
        0x9472, # G+5963  U+9472  uni9472,  CJK UNIFIED IDEOGRAPH-9472
        0x9470, # G+5964  U+9470  uni9470,  CJK UNIFIED IDEOGRAPH-9470
        0x9871, # G+5965  U+9871  uni9871,  CJK UNIFIED IDEOGRAPH-9871
        0x995E, # G+5966  U+995E  uni995E,  CJK UNIFIED IDEOGRAPH-995E
        0x9AD6, # G+5967  U+9AD6  uni9AD6,  CJK UNIFIED IDEOGRAPH-9AD6
        0x9B23, # G+5968  U+9B23  uni9B23,  CJK UNIFIED IDEOGRAPH-9B23
        0x9ECC, # G+5969  U+9ECC  uni9ECC,  CJK UNIFIED IDEOGRAPH-9ECC
        0x7064, # G+5970  U+7064  uni7064,  CJK UNIFIED IDEOGRAPH-7064
        0x77DA, # G+5971  U+77DA  uni77DA,  CJK UNIFIED IDEOGRAPH-77DA
        0x8B9A, # G+5972  U+8B9A  uni8B9A,  CJK UNIFIED IDEOGRAPH-8B9A
        0x9477, # G+5973  U+9477  uni9477,  CJK UNIFIED IDEOGRAPH-9477
        0x97C9, # G+5974  U+97C9  uni97C9,  CJK UNIFIED IDEOGRAPH-97C9
        0x9A62, # G+5975  U+9A62  uni9A62,  CJK UNIFIED IDEOGRAPH-9A62
        0x9A65, # G+5976  U+9A65  uni9A65,  CJK UNIFIED IDEOGRAPH-9A65
        0x7E9C, # G+5977  U+7E9C  uni7E9C,  CJK UNIFIED IDEOGRAPH-7E9C
        0x8B9C, # G+5978  U+8B9C  uni8B9C,  CJK UNIFIED IDEOGRAPH-8B9C
        0x8EAA, # G+5979  U+8EAA  uni8EAA,  CJK UNIFIED IDEOGRAPH-8EAA
        0x91C5, # G+5980  U+91C5  uni91C5,  CJK UNIFIED IDEOGRAPH-91C5
        0x947D, # G+5981  U+947D  uni947D,  CJK UNIFIED IDEOGRAPH-947D
        0x947E, # G+5982  U+947E  uni947E,  CJK UNIFIED IDEOGRAPH-947E
        0x947C, # G+5983  U+947C  uni947C,  CJK UNIFIED IDEOGRAPH-947C
        0x9C77, # G+5984  U+9C77  uni9C77,  CJK UNIFIED IDEOGRAPH-9C77
        0x9C78, # G+5985  U+9C78  uni9C78,  CJK UNIFIED IDEOGRAPH-9C78
        0x9EF7, # G+5986  U+9EF7  uni9EF7,  CJK UNIFIED IDEOGRAPH-9EF7
        0x8C54, # G+5987  U+8C54  uni8C54,  CJK UNIFIED IDEOGRAPH-8C54
        0x947F, # G+5988  U+947F  uni947F,  CJK UNIFIED IDEOGRAPH-947F
        0x9E1A, # G+5989  U+9E1A  uni9E1A,  CJK UNIFIED IDEOGRAPH-9E1A
        0x7228, # G+5990  U+7228  uni7228,  CJK UNIFIED IDEOGRAPH-7228
        0x9A6A, # G+5991  U+9A6A  uni9A6A,  CJK UNIFIED IDEOGRAPH-9A6A
        0x9B31, # G+5992  U+9B31  uni9B31,  CJK UNIFIED IDEOGRAPH-9B31
        0x9E1B, # G+5993  U+9E1B  uni9E1B,  CJK UNIFIED IDEOGRAPH-9E1B
        0x9E1E, # G+5994  U+9E1E  uni9E1E,  CJK UNIFIED IDEOGRAPH-9E1E
        0x7C72, # G+5995  U+7C72  uni7C72,  CJK UNIFIED IDEOGRAPH-7C72
        0x4E42, # G+5996  U+4E42  uni4E42,  CJK UNIFIED IDEOGRAPH-4E42
        0x4E5C, # G+5997  U+4E5C  uni4E5C,  CJK UNIFIED IDEOGRAPH-4E5C
        0x2F10, # G+5998  U+2F10  uni2F10,  KANGXI RADICAL OPEN BOX
        0x2F15, # G+5999  U+2F15  uni2F15,  KANGXI RADICAL RIGHT OPEN BOX
        0x2F1A, # G+6000  U+2F1A  uni2F1A,  KANGXI RADICAL CLIFF
        0x4E07, # G+6001  U+4E07  uni4E07,  CJK UNIFIED IDEOGRAPH-4E07
        0x4E0C, # G+6002  U+4E0C  uni4E0C,  CJK UNIFIED IDEOGRAPH-4E0C
        0x4E47, # G+6003  U+4E47  uni4E47,  CJK UNIFIED IDEOGRAPH-4E47
        0x4E8D, # G+6004  U+4E8D  uni4E8D,  CJK UNIFIED IDEOGRAPH-4E8D
        0x2F1E, # G+6005  U+2F1E  uni2F1E,  KANGXI RADICAL ENCLOSURE
        0x2F2C, # G+6006  U+2F2C  uni2F2C,  KANGXI RADICAL SPROUT
        0x2F3B, # G+6007  U+2F3B  uni2F3B,  KANGXI RADICAL STEP
        0x4E0F, # G+6008  U+4E0F  uni4E0F,  CJK UNIFIED IDEOGRAPH-4E0F
        0x5187, # G+6009  U+5187  uni5187,  CJK UNIFIED IDEOGRAPH-5187
        0x4E0E, # G+6010  U+4E0E  uni4E0E,  CJK UNIFIED IDEOGRAPH-4E0E
        0x4E2E, # G+6011  U+4E2E  uni4E2E,  CJK UNIFIED IDEOGRAPH-4E2E
        0x4E93, # G+6012  U+4E93  uni4E93,  CJK UNIFIED IDEOGRAPH-4E93
        0x4EC2, # G+6013  U+4EC2  uni4EC2,  CJK UNIFIED IDEOGRAPH-4EC2
        0x4EC9, # G+6014  U+4EC9  uni4EC9,  CJK UNIFIED IDEOGRAPH-4EC9
        0x4EC8, # G+6015  U+4EC8  uni4EC8,  CJK UNIFIED IDEOGRAPH-4EC8
        0x5198, # G+6016  U+5198  uni5198,  CJK UNIFIED IDEOGRAPH-5198
        0x52FC, # G+6017  U+52FC  uni52FC,  CJK UNIFIED IDEOGRAPH-52FC
        0x536C, # G+6018  U+536C  uni536C,  CJK UNIFIED IDEOGRAPH-536C
        0x53B9, # G+6019  U+53B9  uni53B9,  CJK UNIFIED IDEOGRAPH-53B9
        0x5720, # G+6020  U+5720  uni5720,  CJK UNIFIED IDEOGRAPH-5720
        0x5903, # G+6021  U+5903  uni5903,  CJK UNIFIED IDEOGRAPH-5903
        0x592C, # G+6022  U+592C  uni592C,  CJK UNIFIED IDEOGRAPH-592C
        0x5C10, # G+6023  U+5C10  uni5C10,  CJK UNIFIED IDEOGRAPH-5C10
        0x5DFF, # G+6024  U+5DFF  uni5DFF,  CJK UNIFIED IDEOGRAPH-5DFF
        0x65E1, # G+6025  U+65E1  uni65E1,  CJK UNIFIED IDEOGRAPH-65E1
        0x2F4E, # G+6026  U+2F4E  uni2F4E,  KANGXI RADICAL WEAPON
        0x6BCC, # G+6027  U+6BCC  uni6BCC,  CJK UNIFIED IDEOGRAPH-6BCC
        0x2F53, # G+6028  U+2F53  uni2F53,  KANGXI RADICAL STEAM
        0x2F59, # G+6029  U+2F59  uni2F59,  KANGXI RADICAL HALF TREE TRUNK
        0x4E31, # G+6030  U+4E31  uni4E31,  CJK UNIFIED IDEOGRAPH-4E31
        0x4E3C, # G+6031  U+4E3C  uni4E3C,  CJK UNIFIED IDEOGRAPH-4E3C
        0x4EE8, # G+6032  U+4EE8  uni4EE8,  CJK UNIFIED IDEOGRAPH-4EE8
        0x4EDC, # G+6033  U+4EDC  uni4EDC,  CJK UNIFIED IDEOGRAPH-4EDC
        0x4EE9, # G+6034  U+4EE9  uni4EE9,  CJK UNIFIED IDEOGRAPH-4EE9
        0x4EE1, # G+6035  U+4EE1  uni4EE1,  CJK UNIFIED IDEOGRAPH-4EE1
        0x4EDD, # G+6036  U+4EDD  uni4EDD,  CJK UNIFIED IDEOGRAPH-4EDD
        0x4EDA, # G+6037  U+4EDA  uni4EDA,  CJK UNIFIED IDEOGRAPH-4EDA
        0x520C, # G+6038  U+520C  uni520C,  CJK UNIFIED IDEOGRAPH-520C
        0x5209, # G+6039  U+5209  uni5209,  CJK UNIFIED IDEOGRAPH-5209
        0x531C, # G+6040  U+531C  uni531C,  CJK UNIFIED IDEOGRAPH-531C
        0x534C, # G+6041  U+534C  uni534C,  CJK UNIFIED IDEOGRAPH-534C
        0x5722, # G+6042  U+5722  uni5722,  CJK UNIFIED IDEOGRAPH-5722
        0x5723, # G+6043  U+5723  uni5723,  CJK UNIFIED IDEOGRAPH-5723
        0x5917, # G+6044  U+5917  uni5917,  CJK UNIFIED IDEOGRAPH-5917
        0x592F, # G+6045  U+592F  uni592F,  CJK UNIFIED IDEOGRAPH-592F
        0x5B81, # G+6046  U+5B81  uni5B81,  CJK UNIFIED IDEOGRAPH-5B81
        0x5B84, # G+6047  U+5B84  uni5B84,  CJK UNIFIED IDEOGRAPH-5B84
        0x5C12, # G+6048  U+5C12  uni5C12,  CJK UNIFIED IDEOGRAPH-5C12
        0x5C3B, # G+6049  U+5C3B  uni5C3B,  CJK UNIFIED IDEOGRAPH-5C3B
        0x5C74, # G+6050  U+5C74  uni5C74,  CJK UNIFIED IDEOGRAPH-5C74
        0x5C73, # G+6051  U+5C73  uni5C73,  CJK UNIFIED IDEOGRAPH-5C73
        0x5E04, # G+6052  U+5E04  uni5E04,  CJK UNIFIED IDEOGRAPH-5E04
        0x5E80, # G+6053  U+5E80  uni5E80,  CJK UNIFIED IDEOGRAPH-5E80
        0x5E82, # G+6054  U+5E82  uni5E82,  CJK UNIFIED IDEOGRAPH-5E82
        0x5FC9, # G+6055  U+5FC9  uni5FC9,  CJK UNIFIED IDEOGRAPH-5FC9
        0x6209, # G+6056  U+6209  uni6209,  CJK UNIFIED IDEOGRAPH-6209
        0x6250, # G+6057  U+6250  uni6250,  CJK UNIFIED IDEOGRAPH-6250
        0x6C15, # G+6058  U+6C15  uni6C15,  CJK UNIFIED IDEOGRAPH-6C15
        0x6C36, # G+6059  U+6C36  uni6C36,  CJK UNIFIED IDEOGRAPH-6C36
        0x6C43, # G+6060  U+6C43  uni6C43,  CJK UNIFIED IDEOGRAPH-6C43
        0x6C3F, # G+6061  U+6C3F  uni6C3F,  CJK UNIFIED IDEOGRAPH-6C3F
        0x6C3B, # G+6062  U+6C3B  uni6C3B,  CJK UNIFIED IDEOGRAPH-6C3B
        0x72AE, # G+6063  U+72AE  uni72AE,  CJK UNIFIED IDEOGRAPH-72AE
        0x72B0, # G+6064  U+72B0  uni72B0,  CJK UNIFIED IDEOGRAPH-72B0
        0x738A, # G+6065  U+738A  uni738A,  CJK UNIFIED IDEOGRAPH-738A
        0x2F71, # G+6066  U+2F71  uni2F71,  KANGXI RADICAL TRACK
        0x808A, # G+6067  U+808A  uni808A,  CJK UNIFIED IDEOGRAPH-808A
        0x961E, # G+6068  U+961E  uni961E,  CJK UNIFIED IDEOGRAPH-961E
        0x4F0E, # G+6069  U+4F0E  uni4F0E,  CJK UNIFIED IDEOGRAPH-4F0E
        0x4F18, # G+6070  U+4F18  uni4F18,  CJK UNIFIED IDEOGRAPH-4F18
        0x4F2C, # G+6071  U+4F2C  uni4F2C,  CJK UNIFIED IDEOGRAPH-4F2C
        0x4EF5, # G+6072  U+4EF5  uni4EF5,  CJK UNIFIED IDEOGRAPH-4EF5
        0x4F14, # G+6073  U+4F14  uni4F14,  CJK UNIFIED IDEOGRAPH-4F14
        0x4EF1, # G+6074  U+4EF1  uni4EF1,  CJK UNIFIED IDEOGRAPH-4EF1
        0x4F00, # G+6075  U+4F00  uni4F00,  CJK UNIFIED IDEOGRAPH-4F00
        0x4EF7, # G+6076  U+4EF7  uni4EF7,  CJK UNIFIED IDEOGRAPH-4EF7
        0x4F08, # G+6077  U+4F08  uni4F08,  CJK UNIFIED IDEOGRAPH-4F08
        0x4F1D, # G+6078  U+4F1D  uni4F1D,  CJK UNIFIED IDEOGRAPH-4F1D
        0x4F02, # G+6079  U+4F02  uni4F02,  CJK UNIFIED IDEOGRAPH-4F02
        0x4F05, # G+6080  U+4F05  uni4F05,  CJK UNIFIED IDEOGRAPH-4F05
        0x4F22, # G+6081  U+4F22  uni4F22,  CJK UNIFIED IDEOGRAPH-4F22
        0x4F13, # G+6082  U+4F13  uni4F13,  CJK UNIFIED IDEOGRAPH-4F13
        0x4F04, # G+6083  U+4F04  uni4F04,  CJK UNIFIED IDEOGRAPH-4F04
        0x4EF4, # G+6084  U+4EF4  uni4EF4,  CJK UNIFIED IDEOGRAPH-4EF4
        0x4F12, # G+6085  U+4F12  uni4F12,  CJK UNIFIED IDEOGRAPH-4F12
        0x51B1, # G+6086  U+51B1  uni51B1,  CJK UNIFIED IDEOGRAPH-51B1
        0x5213, # G+6087  U+5213  uni5213,  CJK UNIFIED IDEOGRAPH-5213
        0x5210, # G+6088  U+5210  uni5210,  CJK UNIFIED IDEOGRAPH-5210
        0x52A6, # G+6089  U+52A6  uni52A6,  CJK UNIFIED IDEOGRAPH-52A6
        0x5322, # G+6090  U+5322  uni5322,  CJK UNIFIED IDEOGRAPH-5322
        0x531F, # G+6091  U+531F  uni531F,  CJK UNIFIED IDEOGRAPH-531F
        0x534D, # G+6092  U+534D  uni534D,  CJK UNIFIED IDEOGRAPH-534D
        0x538A, # G+6093  U+538A  uni538A,  CJK UNIFIED IDEOGRAPH-538A
        0x5407, # G+6094  U+5407  uni5407,  CJK UNIFIED IDEOGRAPH-5407
        0x56E1, # G+6095  U+56E1  uni56E1,  CJK UNIFIED IDEOGRAPH-56E1
        0x56DF, # G+6096  U+56DF  uni56DF,  CJK UNIFIED IDEOGRAPH-56DF
        0x572E, # G+6097  U+572E  uni572E,  CJK UNIFIED IDEOGRAPH-572E
        0x572A, # G+6098  U+572A  uni572A,  CJK UNIFIED IDEOGRAPH-572A
        0x5734, # G+6099  U+5734  uni5734,  CJK UNIFIED IDEOGRAPH-5734
        0x593C, # G+6100  U+593C  uni593C,  CJK UNIFIED IDEOGRAPH-593C
        0x5980, # G+6101  U+5980  uni5980,  CJK UNIFIED IDEOGRAPH-5980
        0x597C, # G+6102  U+597C  uni597C,  CJK UNIFIED IDEOGRAPH-597C
        0x5985, # G+6103  U+5985  uni5985,  CJK UNIFIED IDEOGRAPH-5985
        0x597B, # G+6104  U+597B  uni597B,  CJK UNIFIED IDEOGRAPH-597B
        0x597E, # G+6105  U+597E  uni597E,  CJK UNIFIED IDEOGRAPH-597E
        0x5977, # G+6106  U+5977  uni5977,  CJK UNIFIED IDEOGRAPH-5977
        0x597F, # G+6107  U+597F  uni597F,  CJK UNIFIED IDEOGRAPH-597F
        0x5B56, # G+6108  U+5B56  uni5B56,  CJK UNIFIED IDEOGRAPH-5B56
        0x5C15, # G+6109  U+5C15  uni5C15,  CJK UNIFIED IDEOGRAPH-5C15
        0x5C25, # G+6110  U+5C25  uni5C25,  CJK UNIFIED IDEOGRAPH-5C25
        0x5C7C, # G+6111  U+5C7C  uni5C7C,  CJK UNIFIED IDEOGRAPH-5C7C
        0x5C7A, # G+6112  U+5C7A  uni5C7A,  CJK UNIFIED IDEOGRAPH-5C7A
        0x5C7B, # G+6113  U+5C7B  uni5C7B,  CJK UNIFIED IDEOGRAPH-5C7B
        0x5C7E, # G+6114  U+5C7E  uni5C7E,  CJK UNIFIED IDEOGRAPH-5C7E
        0x5DDF, # G+6115  U+5DDF  uni5DDF,  CJK UNIFIED IDEOGRAPH-5DDF
        0x5E75, # G+6116  U+5E75  uni5E75,  CJK UNIFIED IDEOGRAPH-5E75
        0x5E84, # G+6117  U+5E84  uni5E84,  CJK UNIFIED IDEOGRAPH-5E84
        0x5F02, # G+6118  U+5F02  uni5F02,  CJK UNIFIED IDEOGRAPH-5F02
        0x5F1A, # G+6119  U+5F1A  uni5F1A,  CJK UNIFIED IDEOGRAPH-5F1A
        0x5F74, # G+6120  U+5F74  uni5F74,  CJK UNIFIED IDEOGRAPH-5F74
        0x5FD5, # G+6121  U+5FD5  uni5FD5,  CJK UNIFIED IDEOGRAPH-5FD5
        0x5FD4, # G+6122  U+5FD4  uni5FD4,  CJK UNIFIED IDEOGRAPH-5FD4
        0x5FCF, # G+6123  U+5FCF  uni5FCF,  CJK UNIFIED IDEOGRAPH-5FCF
        0x625C, # G+6124  U+625C  uni625C,  CJK UNIFIED IDEOGRAPH-625C
        0x625E, # G+6125  U+625E  uni625E,  CJK UNIFIED IDEOGRAPH-625E
        0x6264, # G+6126  U+6264  uni6264,  CJK UNIFIED IDEOGRAPH-6264
        0x6261, # G+6127  U+6261  uni6261,  CJK UNIFIED IDEOGRAPH-6261
        0x6266, # G+6128  U+6266  uni6266,  CJK UNIFIED IDEOGRAPH-6266
        0x6262, # G+6129  U+6262  uni6262,  CJK UNIFIED IDEOGRAPH-6262
        0x6259, # G+6130  U+6259  uni6259,  CJK UNIFIED IDEOGRAPH-6259
        0x6260, # G+6131  U+6260  uni6260,  CJK UNIFIED IDEOGRAPH-6260
        0x625A, # G+6132  U+625A  uni625A,  CJK UNIFIED IDEOGRAPH-625A
        0x6265, # G+6133  U+6265  uni6265,  CJK UNIFIED IDEOGRAPH-6265
        0x6537, # G+6134  U+6537  uni6537,  CJK UNIFIED IDEOGRAPH-6537
        0x65EF, # G+6135  U+65EF  uni65EF,  CJK UNIFIED IDEOGRAPH-65EF
        0x65EE, # G+6136  U+65EE  uni65EE,  CJK UNIFIED IDEOGRAPH-65EE
        0x673E, # G+6137  U+673E  uni673E,  CJK UNIFIED IDEOGRAPH-673E
        0x6739, # G+6138  U+6739  uni6739,  CJK UNIFIED IDEOGRAPH-6739
        0x6738, # G+6139  U+6738  uni6738,  CJK UNIFIED IDEOGRAPH-6738
        0x673B, # G+6140  U+673B  uni673B,  CJK UNIFIED IDEOGRAPH-673B
        0x673A, # G+6141  U+673A  uni673A,  CJK UNIFIED IDEOGRAPH-673A
        0x673F, # G+6142  U+673F  uni673F,  CJK UNIFIED IDEOGRAPH-673F
        0x673C, # G+6143  U+673C  uni673C,  CJK UNIFIED IDEOGRAPH-673C
        0x6733, # G+6144  U+6733  uni6733,  CJK UNIFIED IDEOGRAPH-6733
        0x6C18, # G+6145  U+6C18  uni6C18,  CJK UNIFIED IDEOGRAPH-6C18
        0x6C46, # G+6146  U+6C46  uni6C46,  CJK UNIFIED IDEOGRAPH-6C46
        0x6C52, # G+6147  U+6C52  uni6C52,  CJK UNIFIED IDEOGRAPH-6C52
        0x6C5C, # G+6148  U+6C5C  uni6C5C,  CJK UNIFIED IDEOGRAPH-6C5C
        0x6C4F, # G+6149  U+6C4F  uni6C4F,  CJK UNIFIED IDEOGRAPH-6C4F
        0x6C4A, # G+6150  U+6C4A  uni6C4A,  CJK UNIFIED IDEOGRAPH-6C4A
        0x6C54, # G+6151  U+6C54  uni6C54,  CJK UNIFIED IDEOGRAPH-6C54
        0x6C4B, # G+6152  U+6C4B  uni6C4B,  CJK UNIFIED IDEOGRAPH-6C4B
        0x6C4C, # G+6153  U+6C4C  uni6C4C,  CJK UNIFIED IDEOGRAPH-6C4C
        0x7071, # G+6154  U+7071  uni7071,  CJK UNIFIED IDEOGRAPH-7071
        0x725E, # G+6155  U+725E  uni725E,  CJK UNIFIED IDEOGRAPH-725E
        0x72B4, # G+6156  U+72B4  uni72B4,  CJK UNIFIED IDEOGRAPH-72B4
        0x72B5, # G+6157  U+72B5  uni72B5,  CJK UNIFIED IDEOGRAPH-72B5
        0x738E, # G+6158  U+738E  uni738E,  CJK UNIFIED IDEOGRAPH-738E
        0x752A, # G+6159  U+752A  uni752A,  CJK UNIFIED IDEOGRAPH-752A
        0x767F, # G+6160  U+767F  uni767F,  CJK UNIFIED IDEOGRAPH-767F
        0x7A75, # G+6161  U+7A75  uni7A75,  CJK UNIFIED IDEOGRAPH-7A75
        0x2F79, # G+6162  U+2F79  uni2F79,  KANGXI RADICAL NET
        0x2F8B, # G+6163  U+2F8B  uni2F8B,  KANGXI RADICAL GRASS
        0x827C, # G+6164  U+827C  uni827C,  CJK UNIFIED IDEOGRAPH-827C
        0x8280, # G+6165  U+8280  uni8280,  CJK UNIFIED IDEOGRAPH-8280
        0x827D, # G+6166  U+827D  uni827D,  CJK UNIFIED IDEOGRAPH-827D
        0x827F, # G+6167  U+827F  uni827F,  CJK UNIFIED IDEOGRAPH-827F
        0x2F8C, # G+6168  U+2F8C  uni2F8C,  KANGXI RADICAL TIGER
        0x2F91, # G+6169  U+2F91  uni2F91,  KANGXI RADICAL WEST
        0x9099, # G+6170  U+9099  uni9099,  CJK UNIFIED IDEOGRAPH-9099
        0xE7D3, # G+6171  U+E7D3  uniE7D3,  
        0x9098, # G+6172  U+9098  uni9098,  CJK UNIFIED IDEOGRAPH-9098
        0x909B, # G+6173  U+909B  uni909B,  CJK UNIFIED IDEOGRAPH-909B
        0x9094, # G+6174  U+9094  uni9094,  CJK UNIFIED IDEOGRAPH-9094
        0x9622, # G+6175  U+9622  uni9622,  CJK UNIFIED IDEOGRAPH-9622
        0x9624, # G+6176  U+9624  uni9624,  CJK UNIFIED IDEOGRAPH-9624
        0x9620, # G+6177  U+9620  uni9620,  CJK UNIFIED IDEOGRAPH-9620
        0x9623, # G+6178  U+9623  uni9623,  CJK UNIFIED IDEOGRAPH-9623
        0x4F56, # G+6179  U+4F56  uni4F56,  CJK UNIFIED IDEOGRAPH-4F56
        0x4F3B, # G+6180  U+4F3B  uni4F3B,  CJK UNIFIED IDEOGRAPH-4F3B
        0x4F62, # G+6181  U+4F62  uni4F62,  CJK UNIFIED IDEOGRAPH-4F62
        0x4F49, # G+6182  U+4F49  uni4F49,  CJK UNIFIED IDEOGRAPH-4F49
        0x4F53, # G+6183  U+4F53  uni4F53,  CJK UNIFIED IDEOGRAPH-4F53
        0x4F64, # G+6184  U+4F64  uni4F64,  CJK UNIFIED IDEOGRAPH-4F64
        0x4F3E, # G+6185  U+4F3E  uni4F3E,  CJK UNIFIED IDEOGRAPH-4F3E
        0x4F67, # G+6186  U+4F67  uni4F67,  CJK UNIFIED IDEOGRAPH-4F67
        0x4F52, # G+6187  U+4F52  uni4F52,  CJK UNIFIED IDEOGRAPH-4F52
        0x4F5F, # G+6188  U+4F5F  uni4F5F,  CJK UNIFIED IDEOGRAPH-4F5F
        0x4F41, # G+6189  U+4F41  uni4F41,  CJK UNIFIED IDEOGRAPH-4F41
        0x4F58, # G+6190  U+4F58  uni4F58,  CJK UNIFIED IDEOGRAPH-4F58
        0x4F2D, # G+6191  U+4F2D  uni4F2D,  CJK UNIFIED IDEOGRAPH-4F2D
        0x4F33, # G+6192  U+4F33  uni4F33,  CJK UNIFIED IDEOGRAPH-4F33
        0x4F3F, # G+6193  U+4F3F  uni4F3F,  CJK UNIFIED IDEOGRAPH-4F3F
        0x4F61, # G+6194  U+4F61  uni4F61,  CJK UNIFIED IDEOGRAPH-4F61
        0x518F, # G+6195  U+518F  uni518F,  CJK UNIFIED IDEOGRAPH-518F
        0x51B9, # G+6196  U+51B9  uni51B9,  CJK UNIFIED IDEOGRAPH-51B9
        0x521C, # G+6197  U+521C  uni521C,  CJK UNIFIED IDEOGRAPH-521C
        0x521E, # G+6198  U+521E  uni521E,  CJK UNIFIED IDEOGRAPH-521E
        0x5221, # G+6199  U+5221  uni5221,  CJK UNIFIED IDEOGRAPH-5221
        0x52AD, # G+6200  U+52AD  uni52AD,  CJK UNIFIED IDEOGRAPH-52AD
        0x52AE, # G+6201  U+52AE  uni52AE,  CJK UNIFIED IDEOGRAPH-52AE
        0x5309, # G+6202  U+5309  uni5309,  CJK UNIFIED IDEOGRAPH-5309
        0x5363, # G+6203  U+5363  uni5363,  CJK UNIFIED IDEOGRAPH-5363
        0x5372, # G+6204  U+5372  uni5372,  CJK UNIFIED IDEOGRAPH-5372
        0x538E, # G+6205  U+538E  uni538E,  CJK UNIFIED IDEOGRAPH-538E
        0x538F, # G+6206  U+538F  uni538F,  CJK UNIFIED IDEOGRAPH-538F
        0x5430, # G+6207  U+5430  uni5430,  CJK UNIFIED IDEOGRAPH-5430
        0x5437, # G+6208  U+5437  uni5437,  CJK UNIFIED IDEOGRAPH-5437
        0x542A, # G+6209  U+542A  uni542A,  CJK UNIFIED IDEOGRAPH-542A
        0x5454, # G+6210  U+5454  uni5454,  CJK UNIFIED IDEOGRAPH-5454
        0x5445, # G+6211  U+5445  uni5445,  CJK UNIFIED IDEOGRAPH-5445
        0x5419, # G+6212  U+5419  uni5419,  CJK UNIFIED IDEOGRAPH-5419
        0x541C, # G+6213  U+541C  uni541C,  CJK UNIFIED IDEOGRAPH-541C
        0x5425, # G+6214  U+5425  uni5425,  CJK UNIFIED IDEOGRAPH-5425
        0x5418, # G+6215  U+5418  uni5418,  CJK UNIFIED IDEOGRAPH-5418
        0x543D, # G+6216  U+543D  uni543D,  CJK UNIFIED IDEOGRAPH-543D
        0x544F, # G+6217  U+544F  uni544F,  CJK UNIFIED IDEOGRAPH-544F
        0x5441, # G+6218  U+5441  uni5441,  CJK UNIFIED IDEOGRAPH-5441
        0x5428, # G+6219  U+5428  uni5428,  CJK UNIFIED IDEOGRAPH-5428
        0x5424, # G+6220  U+5424  uni5424,  CJK UNIFIED IDEOGRAPH-5424
        0x5447, # G+6221  U+5447  uni5447,  CJK UNIFIED IDEOGRAPH-5447
        0x56EE, # G+6222  U+56EE  uni56EE,  CJK UNIFIED IDEOGRAPH-56EE
        0x56E7, # G+6223  U+56E7  uni56E7,  CJK UNIFIED IDEOGRAPH-56E7
        0x56E5, # G+6224  U+56E5  uni56E5,  CJK UNIFIED IDEOGRAPH-56E5
        0x5741, # G+6225  U+5741  uni5741,  CJK UNIFIED IDEOGRAPH-5741
        0x5745, # G+6226  U+5745  uni5745,  CJK UNIFIED IDEOGRAPH-5745
        0x574C, # G+6227  U+574C  uni574C,  CJK UNIFIED IDEOGRAPH-574C
        0x5749, # G+6228  U+5749  uni5749,  CJK UNIFIED IDEOGRAPH-5749
        0x574B, # G+6229  U+574B  uni574B,  CJK UNIFIED IDEOGRAPH-574B
        0x5752, # G+6230  U+5752  uni5752,  CJK UNIFIED IDEOGRAPH-5752
        0x5906, # G+6231  U+5906  uni5906,  CJK UNIFIED IDEOGRAPH-5906
        0x5940, # G+6232  U+5940  uni5940,  CJK UNIFIED IDEOGRAPH-5940
        0x59A6, # G+6233  U+59A6  uni59A6,  CJK UNIFIED IDEOGRAPH-59A6
        0x5998, # G+6234  U+5998  uni5998,  CJK UNIFIED IDEOGRAPH-5998
        0x59A0, # G+6235  U+59A0  uni59A0,  CJK UNIFIED IDEOGRAPH-59A0
        0x5997, # G+6236  U+5997  uni5997,  CJK UNIFIED IDEOGRAPH-5997
        0x598E, # G+6237  U+598E  uni598E,  CJK UNIFIED IDEOGRAPH-598E
        0x59A2, # G+6238  U+59A2  uni59A2,  CJK UNIFIED IDEOGRAPH-59A2
        0x5990, # G+6239  U+5990  uni5990,  CJK UNIFIED IDEOGRAPH-5990
        0x598F, # G+6240  U+598F  uni598F,  CJK UNIFIED IDEOGRAPH-598F
        0x59A7, # G+6241  U+59A7  uni59A7,  CJK UNIFIED IDEOGRAPH-59A7
        0x59A1, # G+6242  U+59A1  uni59A1,  CJK UNIFIED IDEOGRAPH-59A1
        0x5B8E, # G+6243  U+5B8E  uni5B8E,  CJK UNIFIED IDEOGRAPH-5B8E
        0x5B92, # G+6244  U+5B92  uni5B92,  CJK UNIFIED IDEOGRAPH-5B92
        0x5C28, # G+6245  U+5C28  uni5C28,  CJK UNIFIED IDEOGRAPH-5C28
        0x5C2A, # G+6246  U+5C2A  uni5C2A,  CJK UNIFIED IDEOGRAPH-5C2A
        0x5C8D, # G+6247  U+5C8D  uni5C8D,  CJK UNIFIED IDEOGRAPH-5C8D
        0x5C8F, # G+6248  U+5C8F  uni5C8F,  CJK UNIFIED IDEOGRAPH-5C8F
        0x5C88, # G+6249  U+5C88  uni5C88,  CJK UNIFIED IDEOGRAPH-5C88
        0x5C8B, # G+6250  U+5C8B  uni5C8B,  CJK UNIFIED IDEOGRAPH-5C8B
        0x5C89, # G+6251  U+5C89  uni5C89,  CJK UNIFIED IDEOGRAPH-5C89
        0x5C92, # G+6252  U+5C92  uni5C92,  CJK UNIFIED IDEOGRAPH-5C92
        0x5C8A, # G+6253  U+5C8A  uni5C8A,  CJK UNIFIED IDEOGRAPH-5C8A
        0x5C86, # G+6254  U+5C86  uni5C86,  CJK UNIFIED IDEOGRAPH-5C86
        0x5C93, # G+6255  U+5C93  uni5C93,  CJK UNIFIED IDEOGRAPH-5C93
        0x5C95, # G+6256  U+5C95  uni5C95,  CJK UNIFIED IDEOGRAPH-5C95
        0x5DE0, # G+6257  U+5DE0  uni5DE0,  CJK UNIFIED IDEOGRAPH-5DE0
        0x5E0A, # G+6258  U+5E0A  uni5E0A,  CJK UNIFIED IDEOGRAPH-5E0A
        0x5E0E, # G+6259  U+5E0E  uni5E0E,  CJK UNIFIED IDEOGRAPH-5E0E
        0x5E8B, # G+6260  U+5E8B  uni5E8B,  CJK UNIFIED IDEOGRAPH-5E8B
        0x5E89, # G+6261  U+5E89  uni5E89,  CJK UNIFIED IDEOGRAPH-5E89
        0x5E8C, # G+6262  U+5E8C  uni5E8C,  CJK UNIFIED IDEOGRAPH-5E8C
        0x5E88, # G+6263  U+5E88  uni5E88,  CJK UNIFIED IDEOGRAPH-5E88
        0x5E8D, # G+6264  U+5E8D  uni5E8D,  CJK UNIFIED IDEOGRAPH-5E8D
        0x5F05, # G+6265  U+5F05  uni5F05,  CJK UNIFIED IDEOGRAPH-5F05
        0x5F1D, # G+6266  U+5F1D  uni5F1D,  CJK UNIFIED IDEOGRAPH-5F1D
        0x5F78, # G+6267  U+5F78  uni5F78,  CJK UNIFIED IDEOGRAPH-5F78
        0x5F76, # G+6268  U+5F76  uni5F76,  CJK UNIFIED IDEOGRAPH-5F76
        0x5FD2, # G+6269  U+5FD2  uni5FD2,  CJK UNIFIED IDEOGRAPH-5FD2
        0x5FD1, # G+6270  U+5FD1  uni5FD1,  CJK UNIFIED IDEOGRAPH-5FD1
        0x5FD0, # G+6271  U+5FD0  uni5FD0,  CJK UNIFIED IDEOGRAPH-5FD0
        0x5FED, # G+6272  U+5FED  uni5FED,  CJK UNIFIED IDEOGRAPH-5FED
        0x5FE8, # G+6273  U+5FE8  uni5FE8,  CJK UNIFIED IDEOGRAPH-5FE8
        0x5FEE, # G+6274  U+5FEE  uni5FEE,  CJK UNIFIED IDEOGRAPH-5FEE
        0x5FF3, # G+6275  U+5FF3  uni5FF3,  CJK UNIFIED IDEOGRAPH-5FF3
        0x5FE1, # G+6276  U+5FE1  uni5FE1,  CJK UNIFIED IDEOGRAPH-5FE1
        0x5FE4, # G+6277  U+5FE4  uni5FE4,  CJK UNIFIED IDEOGRAPH-5FE4
        0x5FE3, # G+6278  U+5FE3  uni5FE3,  CJK UNIFIED IDEOGRAPH-5FE3
        0x5FFA, # G+6279  U+5FFA  uni5FFA,  CJK UNIFIED IDEOGRAPH-5FFA
        0x5FEF, # G+6280  U+5FEF  uni5FEF,  CJK UNIFIED IDEOGRAPH-5FEF
        0x5FF7, # G+6281  U+5FF7  uni5FF7,  CJK UNIFIED IDEOGRAPH-5FF7
        0x5FFB, # G+6282  U+5FFB  uni5FFB,  CJK UNIFIED IDEOGRAPH-5FFB
        0x6000, # G+6283  U+6000  uni6000,  CJK UNIFIED IDEOGRAPH-6000
        0x5FF4, # G+6284  U+5FF4  uni5FF4,  CJK UNIFIED IDEOGRAPH-5FF4
        0x623A, # G+6285  U+623A  uni623A,  CJK UNIFIED IDEOGRAPH-623A
        0x6283, # G+6286  U+6283  uni6283,  CJK UNIFIED IDEOGRAPH-6283
        0x628C, # G+6287  U+628C  uni628C,  CJK UNIFIED IDEOGRAPH-628C
        0x628E, # G+6288  U+628E  uni628E,  CJK UNIFIED IDEOGRAPH-628E
        0x628F, # G+6289  U+628F  uni628F,  CJK UNIFIED IDEOGRAPH-628F
        0x6294, # G+6290  U+6294  uni6294,  CJK UNIFIED IDEOGRAPH-6294
        0x6287, # G+6291  U+6287  uni6287,  CJK UNIFIED IDEOGRAPH-6287
        0x6271, # G+6292  U+6271  uni6271,  CJK UNIFIED IDEOGRAPH-6271
        0x627B, # G+6293  U+627B  uni627B,  CJK UNIFIED IDEOGRAPH-627B
        0x627A, # G+6294  U+627A  uni627A,  CJK UNIFIED IDEOGRAPH-627A
        0x6270, # G+6295  U+6270  uni6270,  CJK UNIFIED IDEOGRAPH-6270
        0x6281, # G+6296  U+6281  uni6281,  CJK UNIFIED IDEOGRAPH-6281
        0x6288, # G+6297  U+6288  uni6288,  CJK UNIFIED IDEOGRAPH-6288
        0x6277, # G+6298  U+6277  uni6277,  CJK UNIFIED IDEOGRAPH-6277
        0x627D, # G+6299  U+627D  uni627D,  CJK UNIFIED IDEOGRAPH-627D
        0x6272, # G+6300  U+6272  uni6272,  CJK UNIFIED IDEOGRAPH-6272
        0x6274, # G+6301  U+6274  uni6274,  CJK UNIFIED IDEOGRAPH-6274
        0x65F0, # G+6302  U+65F0  uni65F0,  CJK UNIFIED IDEOGRAPH-65F0
        0x65F4, # G+6303  U+65F4  uni65F4,  CJK UNIFIED IDEOGRAPH-65F4
        0x65F3, # G+6304  U+65F3  uni65F3,  CJK UNIFIED IDEOGRAPH-65F3
        0x65F2, # G+6305  U+65F2  uni65F2,  CJK UNIFIED IDEOGRAPH-65F2
        0x65F5, # G+6306  U+65F5  uni65F5,  CJK UNIFIED IDEOGRAPH-65F5
        0x6745, # G+6307  U+6745  uni6745,  CJK UNIFIED IDEOGRAPH-6745
        0x6747, # G+6308  U+6747  uni6747,  CJK UNIFIED IDEOGRAPH-6747
        0x6759, # G+6309  U+6759  uni6759,  CJK UNIFIED IDEOGRAPH-6759
        0x6755, # G+6310  U+6755  uni6755,  CJK UNIFIED IDEOGRAPH-6755
        0x674C, # G+6311  U+674C  uni674C,  CJK UNIFIED IDEOGRAPH-674C
        0x6748, # G+6312  U+6748  uni6748,  CJK UNIFIED IDEOGRAPH-6748
        0x675D, # G+6313  U+675D  uni675D,  CJK UNIFIED IDEOGRAPH-675D
        0x674D, # G+6314  U+674D  uni674D,  CJK UNIFIED IDEOGRAPH-674D
        0x675A, # G+6315  U+675A  uni675A,  CJK UNIFIED IDEOGRAPH-675A
        0x674B, # G+6316  U+674B  uni674B,  CJK UNIFIED IDEOGRAPH-674B
        0x6BD0, # G+6317  U+6BD0  uni6BD0,  CJK UNIFIED IDEOGRAPH-6BD0
        0x6C19, # G+6318  U+6C19  uni6C19,  CJK UNIFIED IDEOGRAPH-6C19
        0x6C1A, # G+6319  U+6C1A  uni6C1A,  CJK UNIFIED IDEOGRAPH-6C1A
        0x6C78, # G+6320  U+6C78  uni6C78,  CJK UNIFIED IDEOGRAPH-6C78
        0x6C67, # G+6321  U+6C67  uni6C67,  CJK UNIFIED IDEOGRAPH-6C67
        0x6C6B, # G+6322  U+6C6B  uni6C6B,  CJK UNIFIED IDEOGRAPH-6C6B
        0x6C84, # G+6323  U+6C84  uni6C84,  CJK UNIFIED IDEOGRAPH-6C84
        0x6C8B, # G+6324  U+6C8B  uni6C8B,  CJK UNIFIED IDEOGRAPH-6C8B
        0x6C8F, # G+6325  U+6C8F  uni6C8F,  CJK UNIFIED IDEOGRAPH-6C8F
        0x6C71, # G+6326  U+6C71  uni6C71,  CJK UNIFIED IDEOGRAPH-6C71
        0x6C6F, # G+6327  U+6C6F  uni6C6F,  CJK UNIFIED IDEOGRAPH-6C6F
        0x6C69, # G+6328  U+6C69  uni6C69,  CJK UNIFIED IDEOGRAPH-6C69
        0x6C9A, # G+6329  U+6C9A  uni6C9A,  CJK UNIFIED IDEOGRAPH-6C9A
        0x6C6D, # G+6330  U+6C6D  uni6C6D,  CJK UNIFIED IDEOGRAPH-6C6D
        0x6C87, # G+6331  U+6C87  uni6C87,  CJK UNIFIED IDEOGRAPH-6C87
        0x6C95, # G+6332  U+6C95  uni6C95,  CJK UNIFIED IDEOGRAPH-6C95
        0x6C9C, # G+6333  U+6C9C  uni6C9C,  CJK UNIFIED IDEOGRAPH-6C9C
        0x6C66, # G+6334  U+6C66  uni6C66,  CJK UNIFIED IDEOGRAPH-6C66
        0x6C73, # G+6335  U+6C73  uni6C73,  CJK UNIFIED IDEOGRAPH-6C73
        0x6C65, # G+6336  U+6C65  uni6C65,  CJK UNIFIED IDEOGRAPH-6C65
        0x6C7B, # G+6337  U+6C7B  uni6C7B,  CJK UNIFIED IDEOGRAPH-6C7B
        0x6C8E, # G+6338  U+6C8E  uni6C8E,  CJK UNIFIED IDEOGRAPH-6C8E
        0x7074, # G+6339  U+7074  uni7074,  CJK UNIFIED IDEOGRAPH-7074
        0x707A, # G+6340  U+707A  uni707A,  CJK UNIFIED IDEOGRAPH-707A
        0x7263, # G+6341  U+7263  uni7263,  CJK UNIFIED IDEOGRAPH-7263
        0x72BF, # G+6342  U+72BF  uni72BF,  CJK UNIFIED IDEOGRAPH-72BF
        0x72BD, # G+6343  U+72BD  uni72BD,  CJK UNIFIED IDEOGRAPH-72BD
        0x72C3, # G+6344  U+72C3  uni72C3,  CJK UNIFIED IDEOGRAPH-72C3
        0x72C6, # G+6345  U+72C6  uni72C6,  CJK UNIFIED IDEOGRAPH-72C6
        0x72C1, # G+6346  U+72C1  uni72C1,  CJK UNIFIED IDEOGRAPH-72C1
        0x72BA, # G+6347  U+72BA  uni72BA,  CJK UNIFIED IDEOGRAPH-72BA
        0x72C5, # G+6348  U+72C5  uni72C5,  CJK UNIFIED IDEOGRAPH-72C5
        0x7395, # G+6349  U+7395  uni7395,  CJK UNIFIED IDEOGRAPH-7395
        0x7397, # G+6350  U+7397  uni7397,  CJK UNIFIED IDEOGRAPH-7397
        0x7393, # G+6351  U+7393  uni7393,  CJK UNIFIED IDEOGRAPH-7393
        0x7394, # G+6352  U+7394  uni7394,  CJK UNIFIED IDEOGRAPH-7394
        0x7392, # G+6353  U+7392  uni7392,  CJK UNIFIED IDEOGRAPH-7392
        0x753A, # G+6354  U+753A  uni753A,  CJK UNIFIED IDEOGRAPH-753A
        0x7539, # G+6355  U+7539  uni7539,  CJK UNIFIED IDEOGRAPH-7539
        0x7594, # G+6356  U+7594  uni7594,  CJK UNIFIED IDEOGRAPH-7594
        0x7595, # G+6357  U+7595  uni7595,  CJK UNIFIED IDEOGRAPH-7595
        0x7681, # G+6358  U+7681  uni7681,  CJK UNIFIED IDEOGRAPH-7681
        0x793D, # G+6359  U+793D  uni793D,  CJK UNIFIED IDEOGRAPH-793D
        0x8034, # G+6360  U+8034  uni8034,  CJK UNIFIED IDEOGRAPH-8034
        0x8095, # G+6361  U+8095  uni8095,  CJK UNIFIED IDEOGRAPH-8095
        0x8099, # G+6362  U+8099  uni8099,  CJK UNIFIED IDEOGRAPH-8099
        0x8090, # G+6363  U+8090  uni8090,  CJK UNIFIED IDEOGRAPH-8090
        0x8092, # G+6364  U+8092  uni8092,  CJK UNIFIED IDEOGRAPH-8092
        0x809C, # G+6365  U+809C  uni809C,  CJK UNIFIED IDEOGRAPH-809C
        0x8290, # G+6366  U+8290  uni8290,  CJK UNIFIED IDEOGRAPH-8290
        0x828F, # G+6367  U+828F  uni828F,  CJK UNIFIED IDEOGRAPH-828F
        0x8285, # G+6368  U+8285  uni8285,  CJK UNIFIED IDEOGRAPH-8285
        0x828E, # G+6369  U+828E  uni828E,  CJK UNIFIED IDEOGRAPH-828E
        0x8291, # G+6370  U+8291  uni8291,  CJK UNIFIED IDEOGRAPH-8291
        0x8293, # G+6371  U+8293  uni8293,  CJK UNIFIED IDEOGRAPH-8293
        0x828A, # G+6372  U+828A  uni828A,  CJK UNIFIED IDEOGRAPH-828A
        0x8283, # G+6373  U+8283  uni8283,  CJK UNIFIED IDEOGRAPH-8283
        0x8284, # G+6374  U+8284  uni8284,  CJK UNIFIED IDEOGRAPH-8284
        0x2F98, # G+6375  U+2F98  uni2F98,  KANGXI RADICAL BADGER
        0x8FC9, # G+6376  U+8FC9  uni8FC9,  CJK UNIFIED IDEOGRAPH-8FC9
        0x8FBF, # G+6377  U+8FBF  uni8FBF,  CJK UNIFIED IDEOGRAPH-8FBF
        0x909F, # G+6378  U+909F  uni909F,  CJK UNIFIED IDEOGRAPH-909F
        0x90A1, # G+6379  U+90A1  uni90A1,  CJK UNIFIED IDEOGRAPH-90A1
        0x90A5, # G+6380  U+90A5  uni90A5,  CJK UNIFIED IDEOGRAPH-90A5
        0x909E, # G+6381  U+909E  uni909E,  CJK UNIFIED IDEOGRAPH-909E
        0x90A7, # G+6382  U+90A7  uni90A7,  CJK UNIFIED IDEOGRAPH-90A7
        0x90A0, # G+6383  U+90A0  uni90A0,  CJK UNIFIED IDEOGRAPH-90A0
        0x9630, # G+6384  U+9630  uni9630,  CJK UNIFIED IDEOGRAPH-9630
        0x9628, # G+6385  U+9628  uni9628,  CJK UNIFIED IDEOGRAPH-9628
        0x962F, # G+6386  U+962F  uni962F,  CJK UNIFIED IDEOGRAPH-962F
        0x962D, # G+6387  U+962D  uni962D,  CJK UNIFIED IDEOGRAPH-962D
        0x4E33, # G+6388  U+4E33  uni4E33,  CJK UNIFIED IDEOGRAPH-4E33
        0x4F98, # G+6389  U+4F98  uni4F98,  CJK UNIFIED IDEOGRAPH-4F98
        0x4F7C, # G+6390  U+4F7C  uni4F7C,  CJK UNIFIED IDEOGRAPH-4F7C
        0x4F85, # G+6391  U+4F85  uni4F85,  CJK UNIFIED IDEOGRAPH-4F85
        0x4F7D, # G+6392  U+4F7D  uni4F7D,  CJK UNIFIED IDEOGRAPH-4F7D
        0x4F80, # G+6393  U+4F80  uni4F80,  CJK UNIFIED IDEOGRAPH-4F80
        0x4F87, # G+6394  U+4F87  uni4F87,  CJK UNIFIED IDEOGRAPH-4F87
        0x4F76, # G+6395  U+4F76  uni4F76,  CJK UNIFIED IDEOGRAPH-4F76
        0x4F74, # G+6396  U+4F74  uni4F74,  CJK UNIFIED IDEOGRAPH-4F74
        0x4F89, # G+6397  U+4F89  uni4F89,  CJK UNIFIED IDEOGRAPH-4F89
        0x4F84, # G+6398  U+4F84  uni4F84,  CJK UNIFIED IDEOGRAPH-4F84
        0x4F77, # G+6399  U+4F77  uni4F77,  CJK UNIFIED IDEOGRAPH-4F77
        0x4F4C, # G+6400  U+4F4C  uni4F4C,  CJK UNIFIED IDEOGRAPH-4F4C
        0x4F97, # G+6401  U+4F97  uni4F97,  CJK UNIFIED IDEOGRAPH-4F97
        0x4F6A, # G+6402  U+4F6A  uni4F6A,  CJK UNIFIED IDEOGRAPH-4F6A
        0x4F9A, # G+6403  U+4F9A  uni4F9A,  CJK UNIFIED IDEOGRAPH-4F9A
        0x4F79, # G+6404  U+4F79  uni4F79,  CJK UNIFIED IDEOGRAPH-4F79
        0x4F81, # G+6405  U+4F81  uni4F81,  CJK UNIFIED IDEOGRAPH-4F81
        0x4F78, # G+6406  U+4F78  uni4F78,  CJK UNIFIED IDEOGRAPH-4F78
        0x4F90, # G+6407  U+4F90  uni4F90,  CJK UNIFIED IDEOGRAPH-4F90
        0x4F9C, # G+6408  U+4F9C  uni4F9C,  CJK UNIFIED IDEOGRAPH-4F9C
        0x4F94, # G+6409  U+4F94  uni4F94,  CJK UNIFIED IDEOGRAPH-4F94
        0x4F9E, # G+6410  U+4F9E  uni4F9E,  CJK UNIFIED IDEOGRAPH-4F9E
        0x4F92, # G+6411  U+4F92  uni4F92,  CJK UNIFIED IDEOGRAPH-4F92
        0x4F82, # G+6412  U+4F82  uni4F82,  CJK UNIFIED IDEOGRAPH-4F82
        0x4F95, # G+6413  U+4F95  uni4F95,  CJK UNIFIED IDEOGRAPH-4F95
        0x4F6B, # G+6414  U+4F6B  uni4F6B,  CJK UNIFIED IDEOGRAPH-4F6B
        0x4F6E, # G+6415  U+4F6E  uni4F6E,  CJK UNIFIED IDEOGRAPH-4F6E
        0x519E, # G+6416  U+519E  uni519E,  CJK UNIFIED IDEOGRAPH-519E
        0x51BC, # G+6417  U+51BC  uni51BC,  CJK UNIFIED IDEOGRAPH-51BC
        0x51BE, # G+6418  U+51BE  uni51BE,  CJK UNIFIED IDEOGRAPH-51BE
        0x5235, # G+6419  U+5235  uni5235,  CJK UNIFIED IDEOGRAPH-5235
        0x5232, # G+6420  U+5232  uni5232,  CJK UNIFIED IDEOGRAPH-5232
        0x5233, # G+6421  U+5233  uni5233,  CJK UNIFIED IDEOGRAPH-5233
        0x5246, # G+6422  U+5246  uni5246,  CJK UNIFIED IDEOGRAPH-5246
        0x5231, # G+6423  U+5231  uni5231,  CJK UNIFIED IDEOGRAPH-5231
        0x52BC, # G+6424  U+52BC  uni52BC,  CJK UNIFIED IDEOGRAPH-52BC
        0x530A, # G+6425  U+530A  uni530A,  CJK UNIFIED IDEOGRAPH-530A
        0x530B, # G+6426  U+530B  uni530B,  CJK UNIFIED IDEOGRAPH-530B
        0x533C, # G+6427  U+533C  uni533C,  CJK UNIFIED IDEOGRAPH-533C
        0x5392, # G+6428  U+5392  uni5392,  CJK UNIFIED IDEOGRAPH-5392
        0x5394, # G+6429  U+5394  uni5394,  CJK UNIFIED IDEOGRAPH-5394
        0x5487, # G+6430  U+5487  uni5487,  CJK UNIFIED IDEOGRAPH-5487
        0x547F, # G+6431  U+547F  uni547F,  CJK UNIFIED IDEOGRAPH-547F
        0x5481, # G+6432  U+5481  uni5481,  CJK UNIFIED IDEOGRAPH-5481
        0x5491, # G+6433  U+5491  uni5491,  CJK UNIFIED IDEOGRAPH-5491
        0x5482, # G+6434  U+5482  uni5482,  CJK UNIFIED IDEOGRAPH-5482
        0x5488, # G+6435  U+5488  uni5488,  CJK UNIFIED IDEOGRAPH-5488
        0x546B, # G+6436  U+546B  uni546B,  CJK UNIFIED IDEOGRAPH-546B
        0x547A, # G+6437  U+547A  uni547A,  CJK UNIFIED IDEOGRAPH-547A
        0x547E, # G+6438  U+547E  uni547E,  CJK UNIFIED IDEOGRAPH-547E
        0x5465, # G+6439  U+5465  uni5465,  CJK UNIFIED IDEOGRAPH-5465
        0x546C, # G+6440  U+546C  uni546C,  CJK UNIFIED IDEOGRAPH-546C
        0x5474, # G+6441  U+5474  uni5474,  CJK UNIFIED IDEOGRAPH-5474
        0x5466, # G+6442  U+5466  uni5466,  CJK UNIFIED IDEOGRAPH-5466
        0x548D, # G+6443  U+548D  uni548D,  CJK UNIFIED IDEOGRAPH-548D
        0x546F, # G+6444  U+546F  uni546F,  CJK UNIFIED IDEOGRAPH-546F
        0x5461, # G+6445  U+5461  uni5461,  CJK UNIFIED IDEOGRAPH-5461
        0x5460, # G+6446  U+5460  uni5460,  CJK UNIFIED IDEOGRAPH-5460
        0x5498, # G+6447  U+5498  uni5498,  CJK UNIFIED IDEOGRAPH-5498
        0x5463, # G+6448  U+5463  uni5463,  CJK UNIFIED IDEOGRAPH-5463
        0x5467, # G+6449  U+5467  uni5467,  CJK UNIFIED IDEOGRAPH-5467
        0x5464, # G+6450  U+5464  uni5464,  CJK UNIFIED IDEOGRAPH-5464
        0x56F7, # G+6451  U+56F7  uni56F7,  CJK UNIFIED IDEOGRAPH-56F7
        0x56F9, # G+6452  U+56F9  uni56F9,  CJK UNIFIED IDEOGRAPH-56F9
        0x576F, # G+6453  U+576F  uni576F,  CJK UNIFIED IDEOGRAPH-576F
        0x5772, # G+6454  U+5772  uni5772,  CJK UNIFIED IDEOGRAPH-5772
        0x576D, # G+6455  U+576D  uni576D,  CJK UNIFIED IDEOGRAPH-576D
        0x576B, # G+6456  U+576B  uni576B,  CJK UNIFIED IDEOGRAPH-576B
        0x5771, # G+6457  U+5771  uni5771,  CJK UNIFIED IDEOGRAPH-5771
        0x5770, # G+6458  U+5770  uni5770,  CJK UNIFIED IDEOGRAPH-5770
        0x5776, # G+6459  U+5776  uni5776,  CJK UNIFIED IDEOGRAPH-5776
        0x5780, # G+6460  U+5780  uni5780,  CJK UNIFIED IDEOGRAPH-5780
        0x5775, # G+6461  U+5775  uni5775,  CJK UNIFIED IDEOGRAPH-5775
        0x577B, # G+6462  U+577B  uni577B,  CJK UNIFIED IDEOGRAPH-577B
        0x5773, # G+6463  U+5773  uni5773,  CJK UNIFIED IDEOGRAPH-5773
        0x5774, # G+6464  U+5774  uni5774,  CJK UNIFIED IDEOGRAPH-5774
        0x5762, # G+6465  U+5762  uni5762,  CJK UNIFIED IDEOGRAPH-5762
        0x5768, # G+6466  U+5768  uni5768,  CJK UNIFIED IDEOGRAPH-5768
        0x577D, # G+6467  U+577D  uni577D,  CJK UNIFIED IDEOGRAPH-577D
        0x590C, # G+6468  U+590C  uni590C,  CJK UNIFIED IDEOGRAPH-590C
        0x5945, # G+6469  U+5945  uni5945,  CJK UNIFIED IDEOGRAPH-5945
        0x59B5, # G+6470  U+59B5  uni59B5,  CJK UNIFIED IDEOGRAPH-59B5
        0x59BA, # G+6471  U+59BA  uni59BA,  CJK UNIFIED IDEOGRAPH-59BA
        0x59CF, # G+6472  U+59CF  uni59CF,  CJK UNIFIED IDEOGRAPH-59CF
        0x59CE, # G+6473  U+59CE  uni59CE,  CJK UNIFIED IDEOGRAPH-59CE
        0x59B2, # G+6474  U+59B2  uni59B2,  CJK UNIFIED IDEOGRAPH-59B2
        0x59CC, # G+6475  U+59CC  uni59CC,  CJK UNIFIED IDEOGRAPH-59CC
        0x59C1, # G+6476  U+59C1  uni59C1,  CJK UNIFIED IDEOGRAPH-59C1
        0x59B6, # G+6477  U+59B6  uni59B6,  CJK UNIFIED IDEOGRAPH-59B6
        0x59BC, # G+6478  U+59BC  uni59BC,  CJK UNIFIED IDEOGRAPH-59BC
        0x59C3, # G+6479  U+59C3  uni59C3,  CJK UNIFIED IDEOGRAPH-59C3
        0x59D6, # G+6480  U+59D6  uni59D6,  CJK UNIFIED IDEOGRAPH-59D6
        0x59B1, # G+6481  U+59B1  uni59B1,  CJK UNIFIED IDEOGRAPH-59B1
        0x59BD, # G+6482  U+59BD  uni59BD,  CJK UNIFIED IDEOGRAPH-59BD
        0x59C0, # G+6483  U+59C0  uni59C0,  CJK UNIFIED IDEOGRAPH-59C0
        0x59C8, # G+6484  U+59C8  uni59C8,  CJK UNIFIED IDEOGRAPH-59C8
        0x59B4, # G+6485  U+59B4  uni59B4,  CJK UNIFIED IDEOGRAPH-59B4
        0x59C7, # G+6486  U+59C7  uni59C7,  CJK UNIFIED IDEOGRAPH-59C7
        0x5B62, # G+6487  U+5B62  uni5B62,  CJK UNIFIED IDEOGRAPH-5B62
        0x5B65, # G+6488  U+5B65  uni5B65,  CJK UNIFIED IDEOGRAPH-5B65
        0x5B93, # G+6489  U+5B93  uni5B93,  CJK UNIFIED IDEOGRAPH-5B93
        0x5B95, # G+6490  U+5B95  uni5B95,  CJK UNIFIED IDEOGRAPH-5B95
        0x5C44, # G+6491  U+5C44  uni5C44,  CJK UNIFIED IDEOGRAPH-5C44
        0x5C47, # G+6492  U+5C47  uni5C47,  CJK UNIFIED IDEOGRAPH-5C47
        0x5CAE, # G+6493  U+5CAE  uni5CAE,  CJK UNIFIED IDEOGRAPH-5CAE
        0x5CA4, # G+6494  U+5CA4  uni5CA4,  CJK UNIFIED IDEOGRAPH-5CA4
        0x5CA0, # G+6495  U+5CA0  uni5CA0,  CJK UNIFIED IDEOGRAPH-5CA0
        0x5CB5, # G+6496  U+5CB5  uni5CB5,  CJK UNIFIED IDEOGRAPH-5CB5
        0x5CAF, # G+6497  U+5CAF  uni5CAF,  CJK UNIFIED IDEOGRAPH-5CAF
        0x5CA8, # G+6498  U+5CA8  uni5CA8,  CJK UNIFIED IDEOGRAPH-5CA8
        0x5CAC, # G+6499  U+5CAC  uni5CAC,  CJK UNIFIED IDEOGRAPH-5CAC
        0x5C9F, # G+6500  U+5C9F  uni5C9F,  CJK UNIFIED IDEOGRAPH-5C9F
        0x5CA3, # G+6501  U+5CA3  uni5CA3,  CJK UNIFIED IDEOGRAPH-5CA3
        0x5CAD, # G+6502  U+5CAD  uni5CAD,  CJK UNIFIED IDEOGRAPH-5CAD
        0x5CA2, # G+6503  U+5CA2  uni5CA2,  CJK UNIFIED IDEOGRAPH-5CA2
        0x5CAA, # G+6504  U+5CAA  uni5CAA,  CJK UNIFIED IDEOGRAPH-5CAA
        0x5CA7, # G+6505  U+5CA7  uni5CA7,  CJK UNIFIED IDEOGRAPH-5CA7
        0x5C9D, # G+6506  U+5C9D  uni5C9D,  CJK UNIFIED IDEOGRAPH-5C9D
        0x5CA5, # G+6507  U+5CA5  uni5CA5,  CJK UNIFIED IDEOGRAPH-5CA5
        0x5CB6, # G+6508  U+5CB6  uni5CB6,  CJK UNIFIED IDEOGRAPH-5CB6
        0x5CB0, # G+6509  U+5CB0  uni5CB0,  CJK UNIFIED IDEOGRAPH-5CB0
        0x5CA6, # G+6510  U+5CA6  uni5CA6,  CJK UNIFIED IDEOGRAPH-5CA6
        0x5E17, # G+6511  U+5E17  uni5E17,  CJK UNIFIED IDEOGRAPH-5E17
        0x5E14, # G+6512  U+5E14  uni5E14,  CJK UNIFIED IDEOGRAPH-5E14
        0x5E19, # G+6513  U+5E19  uni5E19,  CJK UNIFIED IDEOGRAPH-5E19
        0x5F28, # G+6514  U+5F28  uni5F28,  CJK UNIFIED IDEOGRAPH-5F28
        0x5F22, # G+6515  U+5F22  uni5F22,  CJK UNIFIED IDEOGRAPH-5F22
        0x5F23, # G+6516  U+5F23  uni5F23,  CJK UNIFIED IDEOGRAPH-5F23
        0x5F24, # G+6517  U+5F24  uni5F24,  CJK UNIFIED IDEOGRAPH-5F24
        0x5F54, # G+6518  U+5F54  uni5F54,  CJK UNIFIED IDEOGRAPH-5F54
        0x5F82, # G+6519  U+5F82  uni5F82,  CJK UNIFIED IDEOGRAPH-5F82
        0x5F7E, # G+6520  U+5F7E  uni5F7E,  CJK UNIFIED IDEOGRAPH-5F7E
        0x5F7D, # G+6521  U+5F7D  uni5F7D,  CJK UNIFIED IDEOGRAPH-5F7D
        0x5FDE, # G+6522  U+5FDE  uni5FDE,  CJK UNIFIED IDEOGRAPH-5FDE
        0x5FE5, # G+6523  U+5FE5  uni5FE5,  CJK UNIFIED IDEOGRAPH-5FE5
        0x602D, # G+6524  U+602D  uni602D,  CJK UNIFIED IDEOGRAPH-602D
        0x6026, # G+6525  U+6026  uni6026,  CJK UNIFIED IDEOGRAPH-6026
        0x6019, # G+6526  U+6019  uni6019,  CJK UNIFIED IDEOGRAPH-6019
        0x6032, # G+6527  U+6032  uni6032,  CJK UNIFIED IDEOGRAPH-6032
        0x600B, # G+6528  U+600B  uni600B,  CJK UNIFIED IDEOGRAPH-600B
        0x6034, # G+6529  U+6034  uni6034,  CJK UNIFIED IDEOGRAPH-6034
        0x600A, # G+6530  U+600A  uni600A,  CJK UNIFIED IDEOGRAPH-600A
        0x6017, # G+6531  U+6017  uni6017,  CJK UNIFIED IDEOGRAPH-6017
        0x6033, # G+6532  U+6033  uni6033,  CJK UNIFIED IDEOGRAPH-6033
        0x601A, # G+6533  U+601A  uni601A,  CJK UNIFIED IDEOGRAPH-601A
        0x601E, # G+6534  U+601E  uni601E,  CJK UNIFIED IDEOGRAPH-601E
        0x602C, # G+6535  U+602C  uni602C,  CJK UNIFIED IDEOGRAPH-602C
        0x6022, # G+6536  U+6022  uni6022,  CJK UNIFIED IDEOGRAPH-6022
        0x600D, # G+6537  U+600D  uni600D,  CJK UNIFIED IDEOGRAPH-600D
        0x6010, # G+6538  U+6010  uni6010,  CJK UNIFIED IDEOGRAPH-6010
        0x602E, # G+6539  U+602E  uni602E,  CJK UNIFIED IDEOGRAPH-602E
        0x6013, # G+6540  U+6013  uni6013,  CJK UNIFIED IDEOGRAPH-6013
        0x6011, # G+6541  U+6011  uni6011,  CJK UNIFIED IDEOGRAPH-6011
        0x600C, # G+6542  U+600C  uni600C,  CJK UNIFIED IDEOGRAPH-600C
        0x6009, # G+6543  U+6009  uni6009,  CJK UNIFIED IDEOGRAPH-6009
        0x601C, # G+6544  U+601C  uni601C,  CJK UNIFIED IDEOGRAPH-601C
        0x6214, # G+6545  U+6214  uni6214,  CJK UNIFIED IDEOGRAPH-6214
        0x623D, # G+6546  U+623D  uni623D,  CJK UNIFIED IDEOGRAPH-623D
        0x62AD, # G+6547  U+62AD  uni62AD,  CJK UNIFIED IDEOGRAPH-62AD
        0x62B4, # G+6548  U+62B4  uni62B4,  CJK UNIFIED IDEOGRAPH-62B4
        0x62D1, # G+6549  U+62D1  uni62D1,  CJK UNIFIED IDEOGRAPH-62D1
        0x62BE, # G+6550  U+62BE  uni62BE,  CJK UNIFIED IDEOGRAPH-62BE
        0x62AA, # G+6551  U+62AA  uni62AA,  CJK UNIFIED IDEOGRAPH-62AA
        0x62B6, # G+6552  U+62B6  uni62B6,  CJK UNIFIED IDEOGRAPH-62B6
        0x62CA, # G+6553  U+62CA  uni62CA,  CJK UNIFIED IDEOGRAPH-62CA
        0x62AE, # G+6554  U+62AE  uni62AE,  CJK UNIFIED IDEOGRAPH-62AE
        0x62B3, # G+6555  U+62B3  uni62B3,  CJK UNIFIED IDEOGRAPH-62B3
        0x62AF, # G+6556  U+62AF  uni62AF,  CJK UNIFIED IDEOGRAPH-62AF
        0x62BB, # G+6557  U+62BB  uni62BB,  CJK UNIFIED IDEOGRAPH-62BB
        0x62A9, # G+6558  U+62A9  uni62A9,  CJK UNIFIED IDEOGRAPH-62A9
        0x62B0, # G+6559  U+62B0  uni62B0,  CJK UNIFIED IDEOGRAPH-62B0
        0x62B8, # G+6560  U+62B8  uni62B8,  CJK UNIFIED IDEOGRAPH-62B8
        0x653D, # G+6561  U+653D  uni653D,  CJK UNIFIED IDEOGRAPH-653D
        0x65A8, # G+6562  U+65A8  uni65A8,  CJK UNIFIED IDEOGRAPH-65A8
        0x65BB, # G+6563  U+65BB  uni65BB,  CJK UNIFIED IDEOGRAPH-65BB
        0x6609, # G+6564  U+6609  uni6609,  CJK UNIFIED IDEOGRAPH-6609
        0x65FC, # G+6565  U+65FC  uni65FC,  CJK UNIFIED IDEOGRAPH-65FC
        0x6604, # G+6566  U+6604  uni6604,  CJK UNIFIED IDEOGRAPH-6604
        0x6612, # G+6567  U+6612  uni6612,  CJK UNIFIED IDEOGRAPH-6612
        0x6608, # G+6568  U+6608  uni6608,  CJK UNIFIED IDEOGRAPH-6608
        0x65FB, # G+6569  U+65FB  uni65FB,  CJK UNIFIED IDEOGRAPH-65FB
        0x6603, # G+6570  U+6603  uni6603,  CJK UNIFIED IDEOGRAPH-6603
        0x660B, # G+6571  U+660B  uni660B,  CJK UNIFIED IDEOGRAPH-660B
        0x660D, # G+6572  U+660D  uni660D,  CJK UNIFIED IDEOGRAPH-660D
        0x6605, # G+6573  U+6605  uni6605,  CJK UNIFIED IDEOGRAPH-6605
        0x65FD, # G+6574  U+65FD  uni65FD,  CJK UNIFIED IDEOGRAPH-65FD
        0x6611, # G+6575  U+6611  uni6611,  CJK UNIFIED IDEOGRAPH-6611
        0x6610, # G+6576  U+6610  uni6610,  CJK UNIFIED IDEOGRAPH-6610
        0x66F6, # G+6577  U+66F6  uni66F6,  CJK UNIFIED IDEOGRAPH-66F6
        0x670A, # G+6578  U+670A  uni670A,  CJK UNIFIED IDEOGRAPH-670A
        0x6785, # G+6579  U+6785  uni6785,  CJK UNIFIED IDEOGRAPH-6785
        0x676C, # G+6580  U+676C  uni676C,  CJK UNIFIED IDEOGRAPH-676C
        0x678E, # G+6581  U+678E  uni678E,  CJK UNIFIED IDEOGRAPH-678E
        0x6792, # G+6582  U+6792  uni6792,  CJK UNIFIED IDEOGRAPH-6792
        0x6776, # G+6583  U+6776  uni6776,  CJK UNIFIED IDEOGRAPH-6776
        0x677B, # G+6584  U+677B  uni677B,  CJK UNIFIED IDEOGRAPH-677B
        0x6798, # G+6585  U+6798  uni6798,  CJK UNIFIED IDEOGRAPH-6798
        0x6786, # G+6586  U+6786  uni6786,  CJK UNIFIED IDEOGRAPH-6786
        0x6784, # G+6587  U+6784  uni6784,  CJK UNIFIED IDEOGRAPH-6784
        0x6774, # G+6588  U+6774  uni6774,  CJK UNIFIED IDEOGRAPH-6774
        0x678D, # G+6589  U+678D  uni678D,  CJK UNIFIED IDEOGRAPH-678D
        0x678C, # G+6590  U+678C  uni678C,  CJK UNIFIED IDEOGRAPH-678C
        0x677A, # G+6591  U+677A  uni677A,  CJK UNIFIED IDEOGRAPH-677A
        0x679F, # G+6592  U+679F  uni679F,  CJK UNIFIED IDEOGRAPH-679F
        0x6791, # G+6593  U+6791  uni6791,  CJK UNIFIED IDEOGRAPH-6791
        0x6799, # G+6594  U+6799  uni6799,  CJK UNIFIED IDEOGRAPH-6799
        0x6783, # G+6595  U+6783  uni6783,  CJK UNIFIED IDEOGRAPH-6783
        0x677D, # G+6596  U+677D  uni677D,  CJK UNIFIED IDEOGRAPH-677D
        0x6781, # G+6597  U+6781  uni6781,  CJK UNIFIED IDEOGRAPH-6781
        0x6778, # G+6598  U+6778  uni6778,  CJK UNIFIED IDEOGRAPH-6778
        0x6779, # G+6599  U+6779  uni6779,  CJK UNIFIED IDEOGRAPH-6779
        0x6794, # G+6600  U+6794  uni6794,  CJK UNIFIED IDEOGRAPH-6794
        0x6B25, # G+6601  U+6B25  uni6B25,  CJK UNIFIED IDEOGRAPH-6B25
        0x6B80, # G+6602  U+6B80  uni6B80,  CJK UNIFIED IDEOGRAPH-6B80
        0x6B7E, # G+6603  U+6B7E  uni6B7E,  CJK UNIFIED IDEOGRAPH-6B7E
        0x6BDE, # G+6604  U+6BDE  uni6BDE,  CJK UNIFIED IDEOGRAPH-6BDE
        0x6C1D, # G+6605  U+6C1D  uni6C1D,  CJK UNIFIED IDEOGRAPH-6C1D
        0x6C93, # G+6606  U+6C93  uni6C93,  CJK UNIFIED IDEOGRAPH-6C93
        0x6CEC, # G+6607  U+6CEC  uni6CEC,  CJK UNIFIED IDEOGRAPH-6CEC
        0x6CEB, # G+6608  U+6CEB  uni6CEB,  CJK UNIFIED IDEOGRAPH-6CEB
        0x6CEE, # G+6609  U+6CEE  uni6CEE,  CJK UNIFIED IDEOGRAPH-6CEE
        0x6CD9, # G+6610  U+6CD9  uni6CD9,  CJK UNIFIED IDEOGRAPH-6CD9
        0x6CB6, # G+6611  U+6CB6  uni6CB6,  CJK UNIFIED IDEOGRAPH-6CB6
        0x6CD4, # G+6612  U+6CD4  uni6CD4,  CJK UNIFIED IDEOGRAPH-6CD4
        0x6CAD, # G+6613  U+6CAD  uni6CAD,  CJK UNIFIED IDEOGRAPH-6CAD
        0x6CE7, # G+6614  U+6CE7  uni6CE7,  CJK UNIFIED IDEOGRAPH-6CE7
        0x6CB7, # G+6615  U+6CB7  uni6CB7,  CJK UNIFIED IDEOGRAPH-6CB7
        0x6CD0, # G+6616  U+6CD0  uni6CD0,  CJK UNIFIED IDEOGRAPH-6CD0
        0x6CC2, # G+6617  U+6CC2  uni6CC2,  CJK UNIFIED IDEOGRAPH-6CC2
        0x6CBA, # G+6618  U+6CBA  uni6CBA,  CJK UNIFIED IDEOGRAPH-6CBA
        0x6CC3, # G+6619  U+6CC3  uni6CC3,  CJK UNIFIED IDEOGRAPH-6CC3
        0x6CC6, # G+6620  U+6CC6  uni6CC6,  CJK UNIFIED IDEOGRAPH-6CC6
        0x6CED, # G+6621  U+6CED  uni6CED,  CJK UNIFIED IDEOGRAPH-6CED
        0x6CF2, # G+6622  U+6CF2  uni6CF2,  CJK UNIFIED IDEOGRAPH-6CF2
        0x6CD2, # G+6623  U+6CD2  uni6CD2,  CJK UNIFIED IDEOGRAPH-6CD2
        0x6CDD, # G+6624  U+6CDD  uni6CDD,  CJK UNIFIED IDEOGRAPH-6CDD
        0x6CB4, # G+6625  U+6CB4  uni6CB4,  CJK UNIFIED IDEOGRAPH-6CB4
        0x6C8A, # G+6626  U+6C8A  uni6C8A,  CJK UNIFIED IDEOGRAPH-6C8A
        0x6C9D, # G+6627  U+6C9D  uni6C9D,  CJK UNIFIED IDEOGRAPH-6C9D
        0x6C80, # G+6628  U+6C80  uni6C80,  CJK UNIFIED IDEOGRAPH-6C80
        0x6CDE, # G+6629  U+6CDE  uni6CDE,  CJK UNIFIED IDEOGRAPH-6CDE
        0x6CC0, # G+6630  U+6CC0  uni6CC0,  CJK UNIFIED IDEOGRAPH-6CC0
        0x6D30, # G+6631  U+6D30  uni6D30,  CJK UNIFIED IDEOGRAPH-6D30
        0x6CCD, # G+6632  U+6CCD  uni6CCD,  CJK UNIFIED IDEOGRAPH-6CCD
        0x6CC7, # G+6633  U+6CC7  uni6CC7,  CJK UNIFIED IDEOGRAPH-6CC7
        0x6CB0, # G+6634  U+6CB0  uni6CB0,  CJK UNIFIED IDEOGRAPH-6CB0
        0x6CF9, # G+6635  U+6CF9  uni6CF9,  CJK UNIFIED IDEOGRAPH-6CF9
        0x6CCF, # G+6636  U+6CCF  uni6CCF,  CJK UNIFIED IDEOGRAPH-6CCF
        0x6CE9, # G+6637  U+6CE9  uni6CE9,  CJK UNIFIED IDEOGRAPH-6CE9
        0x6CD1, # G+6638  U+6CD1  uni6CD1,  CJK UNIFIED IDEOGRAPH-6CD1
        0x7094, # G+6639  U+7094  uni7094,  CJK UNIFIED IDEOGRAPH-7094
        0x7098, # G+6640  U+7098  uni7098,  CJK UNIFIED IDEOGRAPH-7098
        0x7085, # G+6641  U+7085  uni7085,  CJK UNIFIED IDEOGRAPH-7085
        0x7093, # G+6642  U+7093  uni7093,  CJK UNIFIED IDEOGRAPH-7093
        0x7086, # G+6643  U+7086  uni7086,  CJK UNIFIED IDEOGRAPH-7086
        0x7084, # G+6644  U+7084  uni7084,  CJK UNIFIED IDEOGRAPH-7084
        0x7091, # G+6645  U+7091  uni7091,  CJK UNIFIED IDEOGRAPH-7091
        0x7096, # G+6646  U+7096  uni7096,  CJK UNIFIED IDEOGRAPH-7096
        0x7082, # G+6647  U+7082  uni7082,  CJK UNIFIED IDEOGRAPH-7082
        0x709A, # G+6648  U+709A  uni709A,  CJK UNIFIED IDEOGRAPH-709A
        0x7083, # G+6649  U+7083  uni7083,  CJK UNIFIED IDEOGRAPH-7083
        0x726A, # G+6650  U+726A  uni726A,  CJK UNIFIED IDEOGRAPH-726A
        0x72D6, # G+6651  U+72D6  uni72D6,  CJK UNIFIED IDEOGRAPH-72D6
        0x72CB, # G+6652  U+72CB  uni72CB,  CJK UNIFIED IDEOGRAPH-72CB
        0x72D8, # G+6653  U+72D8  uni72D8,  CJK UNIFIED IDEOGRAPH-72D8
        0x72C9, # G+6654  U+72C9  uni72C9,  CJK UNIFIED IDEOGRAPH-72C9
        0x72DC, # G+6655  U+72DC  uni72DC,  CJK UNIFIED IDEOGRAPH-72DC
        0x72D2, # G+6656  U+72D2  uni72D2,  CJK UNIFIED IDEOGRAPH-72D2
        0x72D4, # G+6657  U+72D4  uni72D4,  CJK UNIFIED IDEOGRAPH-72D4
        0x72DA, # G+6658  U+72DA  uni72DA,  CJK UNIFIED IDEOGRAPH-72DA
        0x72CC, # G+6659  U+72CC  uni72CC,  CJK UNIFIED IDEOGRAPH-72CC
        0x72D1, # G+6660  U+72D1  uni72D1,  CJK UNIFIED IDEOGRAPH-72D1
        0x73A4, # G+6661  U+73A4  uni73A4,  CJK UNIFIED IDEOGRAPH-73A4
        0x73A1, # G+6662  U+73A1  uni73A1,  CJK UNIFIED IDEOGRAPH-73A1
        0x73AD, # G+6663  U+73AD  uni73AD,  CJK UNIFIED IDEOGRAPH-73AD
        0x73A6, # G+6664  U+73A6  uni73A6,  CJK UNIFIED IDEOGRAPH-73A6
        0x73A2, # G+6665  U+73A2  uni73A2,  CJK UNIFIED IDEOGRAPH-73A2
        0x73A0, # G+6666  U+73A0  uni73A0,  CJK UNIFIED IDEOGRAPH-73A0
        0x73AC, # G+6667  U+73AC  uni73AC,  CJK UNIFIED IDEOGRAPH-73AC
        0x739D, # G+6668  U+739D  uni739D,  CJK UNIFIED IDEOGRAPH-739D
        0x74DD, # G+6669  U+74DD  uni74DD,  CJK UNIFIED IDEOGRAPH-74DD
        0x74E8, # G+6670  U+74E8  uni74E8,  CJK UNIFIED IDEOGRAPH-74E8
        0x753F, # G+6671  U+753F  uni753F,  CJK UNIFIED IDEOGRAPH-753F
        0x7540, # G+6672  U+7540  uni7540,  CJK UNIFIED IDEOGRAPH-7540
        0x753E, # G+6673  U+753E  uni753E,  CJK UNIFIED IDEOGRAPH-753E
        0x758C, # G+6674  U+758C  uni758C,  CJK UNIFIED IDEOGRAPH-758C
        0x7598, # G+6675  U+7598  uni7598,  CJK UNIFIED IDEOGRAPH-7598
        0x76AF, # G+6676  U+76AF  uni76AF,  CJK UNIFIED IDEOGRAPH-76AF
        0x76F3, # G+6677  U+76F3  uni76F3,  CJK UNIFIED IDEOGRAPH-76F3
        0x76F1, # G+6678  U+76F1  uni76F1,  CJK UNIFIED IDEOGRAPH-76F1
        0x76F0, # G+6679  U+76F0  uni76F0,  CJK UNIFIED IDEOGRAPH-76F0
        0x76F5, # G+6680  U+76F5  uni76F5,  CJK UNIFIED IDEOGRAPH-76F5
        0x77F8, # G+6681  U+77F8  uni77F8,  CJK UNIFIED IDEOGRAPH-77F8
        0x77FC, # G+6682  U+77FC  uni77FC,  CJK UNIFIED IDEOGRAPH-77FC
        0x77F9, # G+6683  U+77F9  uni77F9,  CJK UNIFIED IDEOGRAPH-77F9
        0x77FB, # G+6684  U+77FB  uni77FB,  CJK UNIFIED IDEOGRAPH-77FB
        0x77FA, # G+6685  U+77FA  uni77FA,  CJK UNIFIED IDEOGRAPH-77FA
        0x77F7, # G+6686  U+77F7  uni77F7,  CJK UNIFIED IDEOGRAPH-77F7
        0x7942, # G+6687  U+7942  uni7942,  CJK UNIFIED IDEOGRAPH-7942
        0x793F, # G+6688  U+793F  uni793F,  CJK UNIFIED IDEOGRAPH-793F
        0x79C5, # G+6689  U+79C5  uni79C5,  CJK UNIFIED IDEOGRAPH-79C5
        0x7A78, # G+6690  U+7A78  uni7A78,  CJK UNIFIED IDEOGRAPH-7A78
        0x7A7B, # G+6691  U+7A7B  uni7A7B,  CJK UNIFIED IDEOGRAPH-7A7B
        0x7AFB, # G+6692  U+7AFB  uni7AFB,  CJK UNIFIED IDEOGRAPH-7AFB
        0x7C75, # G+6693  U+7C75  uni7C75,  CJK UNIFIED IDEOGRAPH-7C75
        0x7CFD, # G+6694  U+7CFD  uni7CFD,  CJK UNIFIED IDEOGRAPH-7CFD
        0x8035, # G+6695  U+8035  uni8035,  CJK UNIFIED IDEOGRAPH-8035
        0x808F, # G+6696  U+808F  uni808F,  CJK UNIFIED IDEOGRAPH-808F
        0x80AE, # G+6697  U+80AE  uni80AE,  CJK UNIFIED IDEOGRAPH-80AE
        0x80A3, # G+6698  U+80A3  uni80A3,  CJK UNIFIED IDEOGRAPH-80A3
        0x80B8, # G+6699  U+80B8  uni80B8,  CJK UNIFIED IDEOGRAPH-80B8
        0x80B5, # G+6700  U+80B5  uni80B5,  CJK UNIFIED IDEOGRAPH-80B5
        0x80AD, # G+6701  U+80AD  uni80AD,  CJK UNIFIED IDEOGRAPH-80AD
        0x8220, # G+6702  U+8220  uni8220,  CJK UNIFIED IDEOGRAPH-8220
        0x82A0, # G+6703  U+82A0  uni82A0,  CJK UNIFIED IDEOGRAPH-82A0
        0x82C0, # G+6704  U+82C0  uni82C0,  CJK UNIFIED IDEOGRAPH-82C0
        0x82AB, # G+6705  U+82AB  uni82AB,  CJK UNIFIED IDEOGRAPH-82AB
        0x829A, # G+6706  U+829A  uni829A,  CJK UNIFIED IDEOGRAPH-829A
        0x8298, # G+6707  U+8298  uni8298,  CJK UNIFIED IDEOGRAPH-8298
        0x829B, # G+6708  U+829B  uni829B,  CJK UNIFIED IDEOGRAPH-829B
        0x82B5, # G+6709  U+82B5  uni82B5,  CJK UNIFIED IDEOGRAPH-82B5
        0x82A7, # G+6710  U+82A7  uni82A7,  CJK UNIFIED IDEOGRAPH-82A7
        0x82AE, # G+6711  U+82AE  uni82AE,  CJK UNIFIED IDEOGRAPH-82AE
        0x82BC, # G+6712  U+82BC  uni82BC,  CJK UNIFIED IDEOGRAPH-82BC
        0x829E, # G+6713  U+829E  uni829E,  CJK UNIFIED IDEOGRAPH-829E
        0x82BA, # G+6714  U+82BA  uni82BA,  CJK UNIFIED IDEOGRAPH-82BA
        0x82B4, # G+6715  U+82B4  uni82B4,  CJK UNIFIED IDEOGRAPH-82B4
        0x82A8, # G+6716  U+82A8  uni82A8,  CJK UNIFIED IDEOGRAPH-82A8
        0x82A1, # G+6717  U+82A1  uni82A1,  CJK UNIFIED IDEOGRAPH-82A1
        0x82A9, # G+6718  U+82A9  uni82A9,  CJK UNIFIED IDEOGRAPH-82A9
        0x82C2, # G+6719  U+82C2  uni82C2,  CJK UNIFIED IDEOGRAPH-82C2
        0x82A4, # G+6720  U+82A4  uni82A4,  CJK UNIFIED IDEOGRAPH-82A4
        0x82C3, # G+6721  U+82C3  uni82C3,  CJK UNIFIED IDEOGRAPH-82C3
        0x82B6, # G+6722  U+82B6  uni82B6,  CJK UNIFIED IDEOGRAPH-82B6
        0x82A2, # G+6723  U+82A2  uni82A2,  CJK UNIFIED IDEOGRAPH-82A2
        0x8670, # G+6724  U+8670  uni8670,  CJK UNIFIED IDEOGRAPH-8670
        0x866F, # G+6725  U+866F  uni866F,  CJK UNIFIED IDEOGRAPH-866F
        0x866D, # G+6726  U+866D  uni866D,  CJK UNIFIED IDEOGRAPH-866D
        0x866E, # G+6727  U+866E  uni866E,  CJK UNIFIED IDEOGRAPH-866E
        0x8C56, # G+6728  U+8C56  uni8C56,  CJK UNIFIED IDEOGRAPH-8C56
        0x8FD2, # G+6729  U+8FD2  uni8FD2,  CJK UNIFIED IDEOGRAPH-8FD2
        0x8FCB, # G+6730  U+8FCB  uni8FCB,  CJK UNIFIED IDEOGRAPH-8FCB
        0x8FD3, # G+6731  U+8FD3  uni8FD3,  CJK UNIFIED IDEOGRAPH-8FD3
        0x8FCD, # G+6732  U+8FCD  uni8FCD,  CJK UNIFIED IDEOGRAPH-8FCD
        0x8FD6, # G+6733  U+8FD6  uni8FD6,  CJK UNIFIED IDEOGRAPH-8FD6
        0x8FD5, # G+6734  U+8FD5  uni8FD5,  CJK UNIFIED IDEOGRAPH-8FD5
        0x8FD7, # G+6735  U+8FD7  uni8FD7,  CJK UNIFIED IDEOGRAPH-8FD7
        0x90B2, # G+6736  U+90B2  uni90B2,  CJK UNIFIED IDEOGRAPH-90B2
        0x90B4, # G+6737  U+90B4  uni90B4,  CJK UNIFIED IDEOGRAPH-90B4
        0x90AF, # G+6738  U+90AF  uni90AF,  CJK UNIFIED IDEOGRAPH-90AF
        0x90B3, # G+6739  U+90B3  uni90B3,  CJK UNIFIED IDEOGRAPH-90B3
        0x90B0, # G+6740  U+90B0  uni90B0,  CJK UNIFIED IDEOGRAPH-90B0
        0x9639, # G+6741  U+9639  uni9639,  CJK UNIFIED IDEOGRAPH-9639
        0x963D, # G+6742  U+963D  uni963D,  CJK UNIFIED IDEOGRAPH-963D
        0x963C, # G+6743  U+963C  uni963C,  CJK UNIFIED IDEOGRAPH-963C
        0x963A, # G+6744  U+963A  uni963A,  CJK UNIFIED IDEOGRAPH-963A
        0x9643, # G+6745  U+9643  uni9643,  CJK UNIFIED IDEOGRAPH-9643
        0x4FCD, # G+6746  U+4FCD  uni4FCD,  CJK UNIFIED IDEOGRAPH-4FCD
        0x4FC5, # G+6747  U+4FC5  uni4FC5,  CJK UNIFIED IDEOGRAPH-4FC5
        0x4FD3, # G+6748  U+4FD3  uni4FD3,  CJK UNIFIED IDEOGRAPH-4FD3
        0x4FB2, # G+6749  U+4FB2  uni4FB2,  CJK UNIFIED IDEOGRAPH-4FB2
        0x4FC9, # G+6750  U+4FC9  uni4FC9,  CJK UNIFIED IDEOGRAPH-4FC9
        0x4FCB, # G+6751  U+4FCB  uni4FCB,  CJK UNIFIED IDEOGRAPH-4FCB
        0x4FC1, # G+6752  U+4FC1  uni4FC1,  CJK UNIFIED IDEOGRAPH-4FC1
        0x4FD4, # G+6753  U+4FD4  uni4FD4,  CJK UNIFIED IDEOGRAPH-4FD4
        0x4FDC, # G+6754  U+4FDC  uni4FDC,  CJK UNIFIED IDEOGRAPH-4FDC
        0x4FD9, # G+6755  U+4FD9  uni4FD9,  CJK UNIFIED IDEOGRAPH-4FD9
        0x4FBB, # G+6756  U+4FBB  uni4FBB,  CJK UNIFIED IDEOGRAPH-4FBB
        0x4FB3, # G+6757  U+4FB3  uni4FB3,  CJK UNIFIED IDEOGRAPH-4FB3
        0x4FDB, # G+6758  U+4FDB  uni4FDB,  CJK UNIFIED IDEOGRAPH-4FDB
        0x4FC7, # G+6759  U+4FC7  uni4FC7,  CJK UNIFIED IDEOGRAPH-4FC7
        0x4FD6, # G+6760  U+4FD6  uni4FD6,  CJK UNIFIED IDEOGRAPH-4FD6
        0x4FBA, # G+6761  U+4FBA  uni4FBA,  CJK UNIFIED IDEOGRAPH-4FBA
        0x4FC0, # G+6762  U+4FC0  uni4FC0,  CJK UNIFIED IDEOGRAPH-4FC0
        0x4FB9, # G+6763  U+4FB9  uni4FB9,  CJK UNIFIED IDEOGRAPH-4FB9
        0x4FEC, # G+6764  U+4FEC  uni4FEC,  CJK UNIFIED IDEOGRAPH-4FEC
        0x5244, # G+6765  U+5244  uni5244,  CJK UNIFIED IDEOGRAPH-5244
        0x5249, # G+6766  U+5249  uni5249,  CJK UNIFIED IDEOGRAPH-5249
        0x52C0, # G+6767  U+52C0  uni52C0,  CJK UNIFIED IDEOGRAPH-52C0
        0x52C2, # G+6768  U+52C2  uni52C2,  CJK UNIFIED IDEOGRAPH-52C2
        0x533D, # G+6769  U+533D  uni533D,  CJK UNIFIED IDEOGRAPH-533D
        0x537C, # G+6770  U+537C  uni537C,  CJK UNIFIED IDEOGRAPH-537C
        0x5397, # G+6771  U+5397  uni5397,  CJK UNIFIED IDEOGRAPH-5397
        0x5396, # G+6772  U+5396  uni5396,  CJK UNIFIED IDEOGRAPH-5396
        0x5399, # G+6773  U+5399  uni5399,  CJK UNIFIED IDEOGRAPH-5399
        0x5398, # G+6774  U+5398  uni5398,  CJK UNIFIED IDEOGRAPH-5398
        0x54BA, # G+6775  U+54BA  uni54BA,  CJK UNIFIED IDEOGRAPH-54BA
        0x54A1, # G+6776  U+54A1  uni54A1,  CJK UNIFIED IDEOGRAPH-54A1
        0x54AD, # G+6777  U+54AD  uni54AD,  CJK UNIFIED IDEOGRAPH-54AD
        0x54A5, # G+6778  U+54A5  uni54A5,  CJK UNIFIED IDEOGRAPH-54A5
        0x54CF, # G+6779  U+54CF  uni54CF,  CJK UNIFIED IDEOGRAPH-54CF
        0x54C3, # G+6780  U+54C3  uni54C3,  CJK UNIFIED IDEOGRAPH-54C3
        0x830D, # G+6781  U+830D  uni830D,  CJK UNIFIED IDEOGRAPH-830D
        0x54B7, # G+6782  U+54B7  uni54B7,  CJK UNIFIED IDEOGRAPH-54B7
        0x54AE, # G+6783  U+54AE  uni54AE,  CJK UNIFIED IDEOGRAPH-54AE
        0x54D6, # G+6784  U+54D6  uni54D6,  CJK UNIFIED IDEOGRAPH-54D6
        0x54B6, # G+6785  U+54B6  uni54B6,  CJK UNIFIED IDEOGRAPH-54B6
        0x54C5, # G+6786  U+54C5  uni54C5,  CJK UNIFIED IDEOGRAPH-54C5
        0x54C6, # G+6787  U+54C6  uni54C6,  CJK UNIFIED IDEOGRAPH-54C6
        0x54A0, # G+6788  U+54A0  uni54A0,  CJK UNIFIED IDEOGRAPH-54A0
        0x5470, # G+6789  U+5470  uni5470,  CJK UNIFIED IDEOGRAPH-5470
        0x54BC, # G+6790  U+54BC  uni54BC,  CJK UNIFIED IDEOGRAPH-54BC
        0x54A2, # G+6791  U+54A2  uni54A2,  CJK UNIFIED IDEOGRAPH-54A2
        0x54BE, # G+6792  U+54BE  uni54BE,  CJK UNIFIED IDEOGRAPH-54BE
        0x5472, # G+6793  U+5472  uni5472,  CJK UNIFIED IDEOGRAPH-5472
        0x54DE, # G+6794  U+54DE  uni54DE,  CJK UNIFIED IDEOGRAPH-54DE
        0x54B0, # G+6795  U+54B0  uni54B0,  CJK UNIFIED IDEOGRAPH-54B0
        0x57B5, # G+6796  U+57B5  uni57B5,  CJK UNIFIED IDEOGRAPH-57B5
        0x579E, # G+6797  U+579E  uni579E,  CJK UNIFIED IDEOGRAPH-579E
        0x579F, # G+6798  U+579F  uni579F,  CJK UNIFIED IDEOGRAPH-579F
        0x57A4, # G+6799  U+57A4  uni57A4,  CJK UNIFIED IDEOGRAPH-57A4
        0x578C, # G+6800  U+578C  uni578C,  CJK UNIFIED IDEOGRAPH-578C
        0x5797, # G+6801  U+5797  uni5797,  CJK UNIFIED IDEOGRAPH-5797
        0x579D, # G+6802  U+579D  uni579D,  CJK UNIFIED IDEOGRAPH-579D
        0x579B, # G+6803  U+579B  uni579B,  CJK UNIFIED IDEOGRAPH-579B
        0x5794, # G+6804  U+5794  uni5794,  CJK UNIFIED IDEOGRAPH-5794
        0x5798, # G+6805  U+5798  uni5798,  CJK UNIFIED IDEOGRAPH-5798
        0x578F, # G+6806  U+578F  uni578F,  CJK UNIFIED IDEOGRAPH-578F
        0x5799, # G+6807  U+5799  uni5799,  CJK UNIFIED IDEOGRAPH-5799
        0x57A5, # G+6808  U+57A5  uni57A5,  CJK UNIFIED IDEOGRAPH-57A5
        0x579A, # G+6809  U+579A  uni579A,  CJK UNIFIED IDEOGRAPH-579A
        0x5795, # G+6810  U+5795  uni5795,  CJK UNIFIED IDEOGRAPH-5795
        0x58F4, # G+6811  U+58F4  uni58F4,  CJK UNIFIED IDEOGRAPH-58F4
        0x590D, # G+6812  U+590D  uni590D,  CJK UNIFIED IDEOGRAPH-590D
        0x5953, # G+6813  U+5953  uni5953,  CJK UNIFIED IDEOGRAPH-5953
        0x59E1, # G+6814  U+59E1  uni59E1,  CJK UNIFIED IDEOGRAPH-59E1
        0x59DE, # G+6815  U+59DE  uni59DE,  CJK UNIFIED IDEOGRAPH-59DE
        0x59EE, # G+6816  U+59EE  uni59EE,  CJK UNIFIED IDEOGRAPH-59EE
        0x5A00, # G+6817  U+5A00  uni5A00,  CJK UNIFIED IDEOGRAPH-5A00
        0x59F1, # G+6818  U+59F1  uni59F1,  CJK UNIFIED IDEOGRAPH-59F1
        0x59DD, # G+6819  U+59DD  uni59DD,  CJK UNIFIED IDEOGRAPH-59DD
        0x59FA, # G+6820  U+59FA  uni59FA,  CJK UNIFIED IDEOGRAPH-59FA
        0x59FD, # G+6821  U+59FD  uni59FD,  CJK UNIFIED IDEOGRAPH-59FD
        0x59FC, # G+6822  U+59FC  uni59FC,  CJK UNIFIED IDEOGRAPH-59FC
        0x59F6, # G+6823  U+59F6  uni59F6,  CJK UNIFIED IDEOGRAPH-59F6
        0x59E4, # G+6824  U+59E4  uni59E4,  CJK UNIFIED IDEOGRAPH-59E4
        0x59F2, # G+6825  U+59F2  uni59F2,  CJK UNIFIED IDEOGRAPH-59F2
        0x59F7, # G+6826  U+59F7  uni59F7,  CJK UNIFIED IDEOGRAPH-59F7
        0x59DB, # G+6827  U+59DB  uni59DB,  CJK UNIFIED IDEOGRAPH-59DB
        0x59E9, # G+6828  U+59E9  uni59E9,  CJK UNIFIED IDEOGRAPH-59E9
        0x59F3, # G+6829  U+59F3  uni59F3,  CJK UNIFIED IDEOGRAPH-59F3
        0x59F5, # G+6830  U+59F5  uni59F5,  CJK UNIFIED IDEOGRAPH-59F5
        0x59E0, # G+6831  U+59E0  uni59E0,  CJK UNIFIED IDEOGRAPH-59E0
        0x59FE, # G+6832  U+59FE  uni59FE,  CJK UNIFIED IDEOGRAPH-59FE
        0x59F4, # G+6833  U+59F4  uni59F4,  CJK UNIFIED IDEOGRAPH-59F4
        0x59ED, # G+6834  U+59ED  uni59ED,  CJK UNIFIED IDEOGRAPH-59ED
        0x5BA8, # G+6835  U+5BA8  uni5BA8,  CJK UNIFIED IDEOGRAPH-5BA8
        0x5C4C, # G+6836  U+5C4C  uni5C4C,  CJK UNIFIED IDEOGRAPH-5C4C
        0x5CD0, # G+6837  U+5CD0  uni5CD0,  CJK UNIFIED IDEOGRAPH-5CD0
        0x5CD8, # G+6838  U+5CD8  uni5CD8,  CJK UNIFIED IDEOGRAPH-5CD8
        0x5CCC, # G+6839  U+5CCC  uni5CCC,  CJK UNIFIED IDEOGRAPH-5CCC
        0x5CD7, # G+6840  U+5CD7  uni5CD7,  CJK UNIFIED IDEOGRAPH-5CD7
        0x5CCB, # G+6841  U+5CCB  uni5CCB,  CJK UNIFIED IDEOGRAPH-5CCB
        0x5CDB, # G+6842  U+5CDB  uni5CDB,  CJK UNIFIED IDEOGRAPH-5CDB
        0x5CDE, # G+6843  U+5CDE  uni5CDE,  CJK UNIFIED IDEOGRAPH-5CDE
        0x5CDA, # G+6844  U+5CDA  uni5CDA,  CJK UNIFIED IDEOGRAPH-5CDA
        0x5CC9, # G+6845  U+5CC9  uni5CC9,  CJK UNIFIED IDEOGRAPH-5CC9
        0x5CC7, # G+6846  U+5CC7  uni5CC7,  CJK UNIFIED IDEOGRAPH-5CC7
        0x5CCA, # G+6847  U+5CCA  uni5CCA,  CJK UNIFIED IDEOGRAPH-5CCA
        0x5CD6, # G+6848  U+5CD6  uni5CD6,  CJK UNIFIED IDEOGRAPH-5CD6
        0x5CD3, # G+6849  U+5CD3  uni5CD3,  CJK UNIFIED IDEOGRAPH-5CD3
        0x5CD4, # G+6850  U+5CD4  uni5CD4,  CJK UNIFIED IDEOGRAPH-5CD4
        0x5CCF, # G+6851  U+5CCF  uni5CCF,  CJK UNIFIED IDEOGRAPH-5CCF
        0x5CC8, # G+6852  U+5CC8  uni5CC8,  CJK UNIFIED IDEOGRAPH-5CC8
        0x5CC6, # G+6853  U+5CC6  uni5CC6,  CJK UNIFIED IDEOGRAPH-5CC6
        0x5CCE, # G+6854  U+5CCE  uni5CCE,  CJK UNIFIED IDEOGRAPH-5CCE
        0x5CDF, # G+6855  U+5CDF  uni5CDF,  CJK UNIFIED IDEOGRAPH-5CDF
        0x5CF8, # G+6856  U+5CF8  uni5CF8,  CJK UNIFIED IDEOGRAPH-5CF8
        0x5DF9, # G+6857  U+5DF9  uni5DF9,  CJK UNIFIED IDEOGRAPH-5DF9
        0x5E21, # G+6858  U+5E21  uni5E21,  CJK UNIFIED IDEOGRAPH-5E21
        0x5E22, # G+6859  U+5E22  uni5E22,  CJK UNIFIED IDEOGRAPH-5E22
        0x5E23, # G+6860  U+5E23  uni5E23,  CJK UNIFIED IDEOGRAPH-5E23
        0x5E20, # G+6861  U+5E20  uni5E20,  CJK UNIFIED IDEOGRAPH-5E20
        0x5E24, # G+6862  U+5E24  uni5E24,  CJK UNIFIED IDEOGRAPH-5E24
        0x5EB0, # G+6863  U+5EB0  uni5EB0,  CJK UNIFIED IDEOGRAPH-5EB0
        0x5EA4, # G+6864  U+5EA4  uni5EA4,  CJK UNIFIED IDEOGRAPH-5EA4
        0x5EA2, # G+6865  U+5EA2  uni5EA2,  CJK UNIFIED IDEOGRAPH-5EA2
        0x5E9B, # G+6866  U+5E9B  uni5E9B,  CJK UNIFIED IDEOGRAPH-5E9B
        0x5EA3, # G+6867  U+5EA3  uni5EA3,  CJK UNIFIED IDEOGRAPH-5EA3
        0x5EA5, # G+6868  U+5EA5  uni5EA5,  CJK UNIFIED IDEOGRAPH-5EA5
        0x5F07, # G+6869  U+5F07  uni5F07,  CJK UNIFIED IDEOGRAPH-5F07
        0x5F2E, # G+6870  U+5F2E  uni5F2E,  CJK UNIFIED IDEOGRAPH-5F2E
        0x5F56, # G+6871  U+5F56  uni5F56,  CJK UNIFIED IDEOGRAPH-5F56
        0x5F86, # G+6872  U+5F86  uni5F86,  CJK UNIFIED IDEOGRAPH-5F86
        0x6037, # G+6873  U+6037  uni6037,  CJK UNIFIED IDEOGRAPH-6037
        0x6039, # G+6874  U+6039  uni6039,  CJK UNIFIED IDEOGRAPH-6039
        0x6054, # G+6875  U+6054  uni6054,  CJK UNIFIED IDEOGRAPH-6054
        0x6072, # G+6876  U+6072  uni6072,  CJK UNIFIED IDEOGRAPH-6072
        0x605E, # G+6877  U+605E  uni605E,  CJK UNIFIED IDEOGRAPH-605E
        0x6045, # G+6878  U+6045  uni6045,  CJK UNIFIED IDEOGRAPH-6045
        0x6053, # G+6879  U+6053  uni6053,  CJK UNIFIED IDEOGRAPH-6053
        0x6047, # G+6880  U+6047  uni6047,  CJK UNIFIED IDEOGRAPH-6047
        0x6049, # G+6881  U+6049  uni6049,  CJK UNIFIED IDEOGRAPH-6049
        0x605B, # G+6882  U+605B  uni605B,  CJK UNIFIED IDEOGRAPH-605B
        0x604C, # G+6883  U+604C  uni604C,  CJK UNIFIED IDEOGRAPH-604C
        0x6040, # G+6884  U+6040  uni6040,  CJK UNIFIED IDEOGRAPH-6040
        0x6042, # G+6885  U+6042  uni6042,  CJK UNIFIED IDEOGRAPH-6042
        0x605F, # G+6886  U+605F  uni605F,  CJK UNIFIED IDEOGRAPH-605F
        0x6024, # G+6887  U+6024  uni6024,  CJK UNIFIED IDEOGRAPH-6024
        0x6044, # G+6888  U+6044  uni6044,  CJK UNIFIED IDEOGRAPH-6044
        0x6058, # G+6889  U+6058  uni6058,  CJK UNIFIED IDEOGRAPH-6058
        0x6066, # G+6890  U+6066  uni6066,  CJK UNIFIED IDEOGRAPH-6066
        0x606E, # G+6891  U+606E  uni606E,  CJK UNIFIED IDEOGRAPH-606E
        0x6242, # G+6892  U+6242  uni6242,  CJK UNIFIED IDEOGRAPH-6242
        0x6243, # G+6893  U+6243  uni6243,  CJK UNIFIED IDEOGRAPH-6243
        0x62CF, # G+6894  U+62CF  uni62CF,  CJK UNIFIED IDEOGRAPH-62CF
        0x630D, # G+6895  U+630D  uni630D,  CJK UNIFIED IDEOGRAPH-630D
        0x630B, # G+6896  U+630B  uni630B,  CJK UNIFIED IDEOGRAPH-630B
        0x62F5, # G+6897  U+62F5  uni62F5,  CJK UNIFIED IDEOGRAPH-62F5
        0x630E, # G+6898  U+630E  uni630E,  CJK UNIFIED IDEOGRAPH-630E
        0x6303, # G+6899  U+6303  uni6303,  CJK UNIFIED IDEOGRAPH-6303
        0x62EB, # G+6900  U+62EB  uni62EB,  CJK UNIFIED IDEOGRAPH-62EB
        0x62F9, # G+6901  U+62F9  uni62F9,  CJK UNIFIED IDEOGRAPH-62F9
        0x630F, # G+6902  U+630F  uni630F,  CJK UNIFIED IDEOGRAPH-630F
        0x630C, # G+6903  U+630C  uni630C,  CJK UNIFIED IDEOGRAPH-630C
        0x62F8, # G+6904  U+62F8  uni62F8,  CJK UNIFIED IDEOGRAPH-62F8
        0x62F6, # G+6905  U+62F6  uni62F6,  CJK UNIFIED IDEOGRAPH-62F6
        0x6300, # G+6906  U+6300  uni6300,  CJK UNIFIED IDEOGRAPH-6300
        0x6313, # G+6907  U+6313  uni6313,  CJK UNIFIED IDEOGRAPH-6313
        0x6314, # G+6908  U+6314  uni6314,  CJK UNIFIED IDEOGRAPH-6314
        0x62FA, # G+6909  U+62FA  uni62FA,  CJK UNIFIED IDEOGRAPH-62FA
        0x6315, # G+6910  U+6315  uni6315,  CJK UNIFIED IDEOGRAPH-6315
        0x62FB, # G+6911  U+62FB  uni62FB,  CJK UNIFIED IDEOGRAPH-62FB
        0x62F0, # G+6912  U+62F0  uni62F0,  CJK UNIFIED IDEOGRAPH-62F0
        0x6541, # G+6913  U+6541  uni6541,  CJK UNIFIED IDEOGRAPH-6541
        0x6543, # G+6914  U+6543  uni6543,  CJK UNIFIED IDEOGRAPH-6543
        0x65AA, # G+6915  U+65AA  uni65AA,  CJK UNIFIED IDEOGRAPH-65AA
        0x65BF, # G+6916  U+65BF  uni65BF,  CJK UNIFIED IDEOGRAPH-65BF
        0x6636, # G+6917  U+6636  uni6636,  CJK UNIFIED IDEOGRAPH-6636
        0x6621, # G+6918  U+6621  uni6621,  CJK UNIFIED IDEOGRAPH-6621
        0x6632, # G+6919  U+6632  uni6632,  CJK UNIFIED IDEOGRAPH-6632
        0x6635, # G+6920  U+6635  uni6635,  CJK UNIFIED IDEOGRAPH-6635
        0x661C, # G+6921  U+661C  uni661C,  CJK UNIFIED IDEOGRAPH-661C
        0x6626, # G+6922  U+6626  uni6626,  CJK UNIFIED IDEOGRAPH-6626
        0x6622, # G+6923  U+6622  uni6622,  CJK UNIFIED IDEOGRAPH-6622
        0x6633, # G+6924  U+6633  uni6633,  CJK UNIFIED IDEOGRAPH-6633
        0x662B, # G+6925  U+662B  uni662B,  CJK UNIFIED IDEOGRAPH-662B
        0x663A, # G+6926  U+663A  uni663A,  CJK UNIFIED IDEOGRAPH-663A
        0x661D, # G+6927  U+661D  uni661D,  CJK UNIFIED IDEOGRAPH-661D
        0x6634, # G+6928  U+6634  uni6634,  CJK UNIFIED IDEOGRAPH-6634
        0x6639, # G+6929  U+6639  uni6639,  CJK UNIFIED IDEOGRAPH-6639
        0x662E, # G+6930  U+662E  uni662E,  CJK UNIFIED IDEOGRAPH-662E
        0x670F, # G+6931  U+670F  uni670F,  CJK UNIFIED IDEOGRAPH-670F
        0x6710, # G+6932  U+6710  uni6710,  CJK UNIFIED IDEOGRAPH-6710
        0x67C1, # G+6933  U+67C1  uni67C1,  CJK UNIFIED IDEOGRAPH-67C1
        0x67F2, # G+6934  U+67F2  uni67F2,  CJK UNIFIED IDEOGRAPH-67F2
        0x67C8, # G+6935  U+67C8  uni67C8,  CJK UNIFIED IDEOGRAPH-67C8
        0x67BA, # G+6936  U+67BA  uni67BA,  CJK UNIFIED IDEOGRAPH-67BA
        0x67DC, # G+6937  U+67DC  uni67DC,  CJK UNIFIED IDEOGRAPH-67DC
        0x67BB, # G+6938  U+67BB  uni67BB,  CJK UNIFIED IDEOGRAPH-67BB
        0x67F8, # G+6939  U+67F8  uni67F8,  CJK UNIFIED IDEOGRAPH-67F8
        0x67D8, # G+6940  U+67D8  uni67D8,  CJK UNIFIED IDEOGRAPH-67D8
        0x67C0, # G+6941  U+67C0  uni67C0,  CJK UNIFIED IDEOGRAPH-67C0
        0x67B7, # G+6942  U+67B7  uni67B7,  CJK UNIFIED IDEOGRAPH-67B7
        0x67C5, # G+6943  U+67C5  uni67C5,  CJK UNIFIED IDEOGRAPH-67C5
        0x67EB, # G+6944  U+67EB  uni67EB,  CJK UNIFIED IDEOGRAPH-67EB
        0x67E4, # G+6945  U+67E4  uni67E4,  CJK UNIFIED IDEOGRAPH-67E4
        0x67DF, # G+6946  U+67DF  uni67DF,  CJK UNIFIED IDEOGRAPH-67DF
        0x67B5, # G+6947  U+67B5  uni67B5,  CJK UNIFIED IDEOGRAPH-67B5
        0x67CD, # G+6948  U+67CD  uni67CD,  CJK UNIFIED IDEOGRAPH-67CD
        0x67B3, # G+6949  U+67B3  uni67B3,  CJK UNIFIED IDEOGRAPH-67B3
        0x67F7, # G+6950  U+67F7  uni67F7,  CJK UNIFIED IDEOGRAPH-67F7
        0x67F6, # G+6951  U+67F6  uni67F6,  CJK UNIFIED IDEOGRAPH-67F6
        0x67EE, # G+6952  U+67EE  uni67EE,  CJK UNIFIED IDEOGRAPH-67EE
        0x67E3, # G+6953  U+67E3  uni67E3,  CJK UNIFIED IDEOGRAPH-67E3
        0x67C2, # G+6954  U+67C2  uni67C2,  CJK UNIFIED IDEOGRAPH-67C2
        0x67B9, # G+6955  U+67B9  uni67B9,  CJK UNIFIED IDEOGRAPH-67B9
        0x67CE, # G+6956  U+67CE  uni67CE,  CJK UNIFIED IDEOGRAPH-67CE
        0x67E7, # G+6957  U+67E7  uni67E7,  CJK UNIFIED IDEOGRAPH-67E7
        0x67F0, # G+6958  U+67F0  uni67F0,  CJK UNIFIED IDEOGRAPH-67F0
        0x67B2, # G+6959  U+67B2  uni67B2,  CJK UNIFIED IDEOGRAPH-67B2
        0x67FC, # G+6960  U+67FC  uni67FC,  CJK UNIFIED IDEOGRAPH-67FC
        0x67C6, # G+6961  U+67C6  uni67C6,  CJK UNIFIED IDEOGRAPH-67C6
        0x67ED, # G+6962  U+67ED  uni67ED,  CJK UNIFIED IDEOGRAPH-67ED
        0x67CC, # G+6963  U+67CC  uni67CC,  CJK UNIFIED IDEOGRAPH-67CC
        0x67AE, # G+6964  U+67AE  uni67AE,  CJK UNIFIED IDEOGRAPH-67AE
        0x67E6, # G+6965  U+67E6  uni67E6,  CJK UNIFIED IDEOGRAPH-67E6
        0x67DB, # G+6966  U+67DB  uni67DB,  CJK UNIFIED IDEOGRAPH-67DB
        0x67FA, # G+6967  U+67FA  uni67FA,  CJK UNIFIED IDEOGRAPH-67FA
        0x67C9, # G+6968  U+67C9  uni67C9,  CJK UNIFIED IDEOGRAPH-67C9
        0x67CA, # G+6969  U+67CA  uni67CA,  CJK UNIFIED IDEOGRAPH-67CA
        0x67C3, # G+6970  U+67C3  uni67C3,  CJK UNIFIED IDEOGRAPH-67C3
        0x67EA, # G+6971  U+67EA  uni67EA,  CJK UNIFIED IDEOGRAPH-67EA
        0x67CB, # G+6972  U+67CB  uni67CB,  CJK UNIFIED IDEOGRAPH-67CB
        0x6B28, # G+6973  U+6B28  uni6B28,  CJK UNIFIED IDEOGRAPH-6B28
        0x6B82, # G+6974  U+6B82  uni6B82,  CJK UNIFIED IDEOGRAPH-6B82
        0x6B84, # G+6975  U+6B84  uni6B84,  CJK UNIFIED IDEOGRAPH-6B84
        0x6BB6, # G+6976  U+6BB6  uni6BB6,  CJK UNIFIED IDEOGRAPH-6BB6
        0x6BD6, # G+6977  U+6BD6  uni6BD6,  CJK UNIFIED IDEOGRAPH-6BD6
        0x6BD8, # G+6978  U+6BD8  uni6BD8,  CJK UNIFIED IDEOGRAPH-6BD8
        0x6BE0, # G+6979  U+6BE0  uni6BE0,  CJK UNIFIED IDEOGRAPH-6BE0
        0x6C20, # G+6980  U+6C20  uni6C20,  CJK UNIFIED IDEOGRAPH-6C20
        0x6C21, # G+6981  U+6C21  uni6C21,  CJK UNIFIED IDEOGRAPH-6C21
        0x6D28, # G+6982  U+6D28  uni6D28,  CJK UNIFIED IDEOGRAPH-6D28
        0x6D34, # G+6983  U+6D34  uni6D34,  CJK UNIFIED IDEOGRAPH-6D34
        0x6D2D, # G+6984  U+6D2D  uni6D2D,  CJK UNIFIED IDEOGRAPH-6D2D
        0x6D1F, # G+6985  U+6D1F  uni6D1F,  CJK UNIFIED IDEOGRAPH-6D1F
        0x6D3C, # G+6986  U+6D3C  uni6D3C,  CJK UNIFIED IDEOGRAPH-6D3C
        0x6D3F, # G+6987  U+6D3F  uni6D3F,  CJK UNIFIED IDEOGRAPH-6D3F
        0x6D12, # G+6988  U+6D12  uni6D12,  CJK UNIFIED IDEOGRAPH-6D12
        0x6D0A, # G+6989  U+6D0A  uni6D0A,  CJK UNIFIED IDEOGRAPH-6D0A
        0x6CDA, # G+6990  U+6CDA  uni6CDA,  CJK UNIFIED IDEOGRAPH-6CDA
        0x6D33, # G+6991  U+6D33  uni6D33,  CJK UNIFIED IDEOGRAPH-6D33
        0x6D04, # G+6992  U+6D04  uni6D04,  CJK UNIFIED IDEOGRAPH-6D04
        0x6D19, # G+6993  U+6D19  uni6D19,  CJK UNIFIED IDEOGRAPH-6D19
        0x6D3A, # G+6994  U+6D3A  uni6D3A,  CJK UNIFIED IDEOGRAPH-6D3A
        0x6D1A, # G+6995  U+6D1A  uni6D1A,  CJK UNIFIED IDEOGRAPH-6D1A
        0x6D11, # G+6996  U+6D11  uni6D11,  CJK UNIFIED IDEOGRAPH-6D11
        0x6D00, # G+6997  U+6D00  uni6D00,  CJK UNIFIED IDEOGRAPH-6D00
        0x6D1D, # G+6998  U+6D1D  uni6D1D,  CJK UNIFIED IDEOGRAPH-6D1D
        0x6D42, # G+6999  U+6D42  uni6D42,  CJK UNIFIED IDEOGRAPH-6D42
        0x6D01, # G+7000  U+6D01  uni6D01,  CJK UNIFIED IDEOGRAPH-6D01
        0x6D18, # G+7001  U+6D18  uni6D18,  CJK UNIFIED IDEOGRAPH-6D18
        0x6D37, # G+7002  U+6D37  uni6D37,  CJK UNIFIED IDEOGRAPH-6D37
        0x6D03, # G+7003  U+6D03  uni6D03,  CJK UNIFIED IDEOGRAPH-6D03
        0x6D0F, # G+7004  U+6D0F  uni6D0F,  CJK UNIFIED IDEOGRAPH-6D0F
        0x6D40, # G+7005  U+6D40  uni6D40,  CJK UNIFIED IDEOGRAPH-6D40
        0x6D07, # G+7006  U+6D07  uni6D07,  CJK UNIFIED IDEOGRAPH-6D07
        0x6D20, # G+7007  U+6D20  uni6D20,  CJK UNIFIED IDEOGRAPH-6D20
        0x6D2C, # G+7008  U+6D2C  uni6D2C,  CJK UNIFIED IDEOGRAPH-6D2C
        0x6D08, # G+7009  U+6D08  uni6D08,  CJK UNIFIED IDEOGRAPH-6D08
        0x6D22, # G+7010  U+6D22  uni6D22,  CJK UNIFIED IDEOGRAPH-6D22
        0x6D09, # G+7011  U+6D09  uni6D09,  CJK UNIFIED IDEOGRAPH-6D09
        0x6D10, # G+7012  U+6D10  uni6D10,  CJK UNIFIED IDEOGRAPH-6D10
        0x70B7, # G+7013  U+70B7  uni70B7,  CJK UNIFIED IDEOGRAPH-70B7
        0x709F, # G+7014  U+709F  uni709F,  CJK UNIFIED IDEOGRAPH-709F
        0x70BE, # G+7015  U+70BE  uni70BE,  CJK UNIFIED IDEOGRAPH-70BE
        0x70B1, # G+7016  U+70B1  uni70B1,  CJK UNIFIED IDEOGRAPH-70B1
        0x70B0, # G+7017  U+70B0  uni70B0,  CJK UNIFIED IDEOGRAPH-70B0
        0x70A1, # G+7018  U+70A1  uni70A1,  CJK UNIFIED IDEOGRAPH-70A1
        0x70B4, # G+7019  U+70B4  uni70B4,  CJK UNIFIED IDEOGRAPH-70B4
        0x70B5, # G+7020  U+70B5  uni70B5,  CJK UNIFIED IDEOGRAPH-70B5
        0x70A9, # G+7021  U+70A9  uni70A9,  CJK UNIFIED IDEOGRAPH-70A9
        0x7241, # G+7022  U+7241  uni7241,  CJK UNIFIED IDEOGRAPH-7241
        0x7249, # G+7023  U+7249  uni7249,  CJK UNIFIED IDEOGRAPH-7249
        0x724A, # G+7024  U+724A  uni724A,  CJK UNIFIED IDEOGRAPH-724A
        0x726C, # G+7025  U+726C  uni726C,  CJK UNIFIED IDEOGRAPH-726C
        0x7270, # G+7026  U+7270  uni7270,  CJK UNIFIED IDEOGRAPH-7270
        0x7273, # G+7027  U+7273  uni7273,  CJK UNIFIED IDEOGRAPH-7273
        0x726E, # G+7028  U+726E  uni726E,  CJK UNIFIED IDEOGRAPH-726E
        0x72CA, # G+7029  U+72CA  uni72CA,  CJK UNIFIED IDEOGRAPH-72CA
        0x72E4, # G+7030  U+72E4  uni72E4,  CJK UNIFIED IDEOGRAPH-72E4
        0x72E8, # G+7031  U+72E8  uni72E8,  CJK UNIFIED IDEOGRAPH-72E8
        0x72EB, # G+7032  U+72EB  uni72EB,  CJK UNIFIED IDEOGRAPH-72EB
        0x72DF, # G+7033  U+72DF  uni72DF,  CJK UNIFIED IDEOGRAPH-72DF
        0x72EA, # G+7034  U+72EA  uni72EA,  CJK UNIFIED IDEOGRAPH-72EA
        0x72E6, # G+7035  U+72E6  uni72E6,  CJK UNIFIED IDEOGRAPH-72E6
        0x72E3, # G+7036  U+72E3  uni72E3,  CJK UNIFIED IDEOGRAPH-72E3
        0x7385, # G+7037  U+7385  uni7385,  CJK UNIFIED IDEOGRAPH-7385
        0x73CC, # G+7038  U+73CC  uni73CC,  CJK UNIFIED IDEOGRAPH-73CC
        0x73C2, # G+7039  U+73C2  uni73C2,  CJK UNIFIED IDEOGRAPH-73C2
        0x73C8, # G+7040  U+73C8  uni73C8,  CJK UNIFIED IDEOGRAPH-73C8
        0x73C5, # G+7041  U+73C5  uni73C5,  CJK UNIFIED IDEOGRAPH-73C5
        0x73B9, # G+7042  U+73B9  uni73B9,  CJK UNIFIED IDEOGRAPH-73B9
        0x73B6, # G+7043  U+73B6  uni73B6,  CJK UNIFIED IDEOGRAPH-73B6
        0x73B5, # G+7044  U+73B5  uni73B5,  CJK UNIFIED IDEOGRAPH-73B5
        0x73B4, # G+7045  U+73B4  uni73B4,  CJK UNIFIED IDEOGRAPH-73B4
        0x73EB, # G+7046  U+73EB  uni73EB,  CJK UNIFIED IDEOGRAPH-73EB
        0x73BF, # G+7047  U+73BF  uni73BF,  CJK UNIFIED IDEOGRAPH-73BF
        0x73C7, # G+7048  U+73C7  uni73C7,  CJK UNIFIED IDEOGRAPH-73C7
        0x73BE, # G+7049  U+73BE  uni73BE,  CJK UNIFIED IDEOGRAPH-73BE
        0x73C3, # G+7050  U+73C3  uni73C3,  CJK UNIFIED IDEOGRAPH-73C3
        0x73C6, # G+7051  U+73C6  uni73C6,  CJK UNIFIED IDEOGRAPH-73C6
        0x73B8, # G+7052  U+73B8  uni73B8,  CJK UNIFIED IDEOGRAPH-73B8
        0x73CB, # G+7053  U+73CB  uni73CB,  CJK UNIFIED IDEOGRAPH-73CB
        0x74EC, # G+7054  U+74EC  uni74EC,  CJK UNIFIED IDEOGRAPH-74EC
        0x74EE, # G+7055  U+74EE  uni74EE,  CJK UNIFIED IDEOGRAPH-74EE
        0x752E, # G+7056  U+752E  uni752E,  CJK UNIFIED IDEOGRAPH-752E
        0x7547, # G+7057  U+7547  uni7547,  CJK UNIFIED IDEOGRAPH-7547
        0x7548, # G+7058  U+7548  uni7548,  CJK UNIFIED IDEOGRAPH-7548
        0x75A7, # G+7059  U+75A7  uni75A7,  CJK UNIFIED IDEOGRAPH-75A7
        0x75AA, # G+7060  U+75AA  uni75AA,  CJK UNIFIED IDEOGRAPH-75AA
        0x7679, # G+7061  U+7679  uni7679,  CJK UNIFIED IDEOGRAPH-7679
        0x76C4, # G+7062  U+76C4  uni76C4,  CJK UNIFIED IDEOGRAPH-76C4
        0x7708, # G+7063  U+7708  uni7708,  CJK UNIFIED IDEOGRAPH-7708
        0x7703, # G+7064  U+7703  uni7703,  CJK UNIFIED IDEOGRAPH-7703
        0x7704, # G+7065  U+7704  uni7704,  CJK UNIFIED IDEOGRAPH-7704
        0x7705, # G+7066  U+7705  uni7705,  CJK UNIFIED IDEOGRAPH-7705
        0x770A, # G+7067  U+770A  uni770A,  CJK UNIFIED IDEOGRAPH-770A
        0x76F7, # G+7068  U+76F7  uni76F7,  CJK UNIFIED IDEOGRAPH-76F7
        0x76FB, # G+7069  U+76FB  uni76FB,  CJK UNIFIED IDEOGRAPH-76FB
        0x76FA, # G+7070  U+76FA  uni76FA,  CJK UNIFIED IDEOGRAPH-76FA
        0x77E7, # G+7071  U+77E7  uni77E7,  CJK UNIFIED IDEOGRAPH-77E7
        0x77E8, # G+7072  U+77E8  uni77E8,  CJK UNIFIED IDEOGRAPH-77E8
        0x7806, # G+7073  U+7806  uni7806,  CJK UNIFIED IDEOGRAPH-7806
        0x7811, # G+7074  U+7811  uni7811,  CJK UNIFIED IDEOGRAPH-7811
        0x7812, # G+7075  U+7812  uni7812,  CJK UNIFIED IDEOGRAPH-7812
        0x7805, # G+7076  U+7805  uni7805,  CJK UNIFIED IDEOGRAPH-7805
        0x7810, # G+7077  U+7810  uni7810,  CJK UNIFIED IDEOGRAPH-7810
        0x780F, # G+7078  U+780F  uni780F,  CJK UNIFIED IDEOGRAPH-780F
        0x780E, # G+7079  U+780E  uni780E,  CJK UNIFIED IDEOGRAPH-780E
        0x7809, # G+7080  U+7809  uni7809,  CJK UNIFIED IDEOGRAPH-7809
        0x7803, # G+7081  U+7803  uni7803,  CJK UNIFIED IDEOGRAPH-7803
        0x7813, # G+7082  U+7813  uni7813,  CJK UNIFIED IDEOGRAPH-7813
        0x794A, # G+7083  U+794A  uni794A,  CJK UNIFIED IDEOGRAPH-794A
        0x794C, # G+7084  U+794C  uni794C,  CJK UNIFIED IDEOGRAPH-794C
        0x794B, # G+7085  U+794B  uni794B,  CJK UNIFIED IDEOGRAPH-794B
        0x7945, # G+7086  U+7945  uni7945,  CJK UNIFIED IDEOGRAPH-7945
        0x7944, # G+7087  U+7944  uni7944,  CJK UNIFIED IDEOGRAPH-7944
        0x79D5, # G+7088  U+79D5  uni79D5,  CJK UNIFIED IDEOGRAPH-79D5
        0x79CD, # G+7089  U+79CD  uni79CD,  CJK UNIFIED IDEOGRAPH-79CD
        0x79CF, # G+7090  U+79CF  uni79CF,  CJK UNIFIED IDEOGRAPH-79CF
        0x79D6, # G+7091  U+79D6  uni79D6,  CJK UNIFIED IDEOGRAPH-79D6
        0x79CE, # G+7092  U+79CE  uni79CE,  CJK UNIFIED IDEOGRAPH-79CE
        0x7A80, # G+7093  U+7A80  uni7A80,  CJK UNIFIED IDEOGRAPH-7A80
        0x7A7E, # G+7094  U+7A7E  uni7A7E,  CJK UNIFIED IDEOGRAPH-7A7E
        0x7AD1, # G+7095  U+7AD1  uni7AD1,  CJK UNIFIED IDEOGRAPH-7AD1
        0x7B00, # G+7096  U+7B00  uni7B00,  CJK UNIFIED IDEOGRAPH-7B00
        0x7B01, # G+7097  U+7B01  uni7B01,  CJK UNIFIED IDEOGRAPH-7B01
        0x7C7A, # G+7098  U+7C7A  uni7C7A,  CJK UNIFIED IDEOGRAPH-7C7A
        0x7C78, # G+7099  U+7C78  uni7C78,  CJK UNIFIED IDEOGRAPH-7C78
        0x7C79, # G+7100  U+7C79  uni7C79,  CJK UNIFIED IDEOGRAPH-7C79
        0x7C7F, # G+7101  U+7C7F  uni7C7F,  CJK UNIFIED IDEOGRAPH-7C7F
        0x7C80, # G+7102  U+7C80  uni7C80,  CJK UNIFIED IDEOGRAPH-7C80
        0x7C81, # G+7103  U+7C81  uni7C81,  CJK UNIFIED IDEOGRAPH-7C81
        0x7D03, # G+7104  U+7D03  uni7D03,  CJK UNIFIED IDEOGRAPH-7D03
        0x7D08, # G+7105  U+7D08  uni7D08,  CJK UNIFIED IDEOGRAPH-7D08
        0x7D01, # G+7106  U+7D01  uni7D01,  CJK UNIFIED IDEOGRAPH-7D01
        0x7F58, # G+7107  U+7F58  uni7F58,  CJK UNIFIED IDEOGRAPH-7F58
        0x7F91, # G+7108  U+7F91  uni7F91,  CJK UNIFIED IDEOGRAPH-7F91
        0x7F8D, # G+7109  U+7F8D  uni7F8D,  CJK UNIFIED IDEOGRAPH-7F8D
        0x7FBE, # G+7110  U+7FBE  uni7FBE,  CJK UNIFIED IDEOGRAPH-7FBE
        0x8007, # G+7111  U+8007  uni8007,  CJK UNIFIED IDEOGRAPH-8007
        0x800E, # G+7112  U+800E  uni800E,  CJK UNIFIED IDEOGRAPH-800E
        0x800F, # G+7113  U+800F  uni800F,  CJK UNIFIED IDEOGRAPH-800F
        0x8014, # G+7114  U+8014  uni8014,  CJK UNIFIED IDEOGRAPH-8014
        0x8037, # G+7115  U+8037  uni8037,  CJK UNIFIED IDEOGRAPH-8037
        0x80D8, # G+7116  U+80D8  uni80D8,  CJK UNIFIED IDEOGRAPH-80D8
        0x80C7, # G+7117  U+80C7  uni80C7,  CJK UNIFIED IDEOGRAPH-80C7
        0x80E0, # G+7118  U+80E0  uni80E0,  CJK UNIFIED IDEOGRAPH-80E0
        0x80D1, # G+7119  U+80D1  uni80D1,  CJK UNIFIED IDEOGRAPH-80D1
        0x80C8, # G+7120  U+80C8  uni80C8,  CJK UNIFIED IDEOGRAPH-80C8
        0x80C2, # G+7121  U+80C2  uni80C2,  CJK UNIFIED IDEOGRAPH-80C2
        0x80D0, # G+7122  U+80D0  uni80D0,  CJK UNIFIED IDEOGRAPH-80D0
        0x80C5, # G+7123  U+80C5  uni80C5,  CJK UNIFIED IDEOGRAPH-80C5
        0x80E3, # G+7124  U+80E3  uni80E3,  CJK UNIFIED IDEOGRAPH-80E3
        0x80D9, # G+7125  U+80D9  uni80D9,  CJK UNIFIED IDEOGRAPH-80D9
        0x80DC, # G+7126  U+80DC  uni80DC,  CJK UNIFIED IDEOGRAPH-80DC
        0x80CA, # G+7127  U+80CA  uni80CA,  CJK UNIFIED IDEOGRAPH-80CA
        0x80D5, # G+7128  U+80D5  uni80D5,  CJK UNIFIED IDEOGRAPH-80D5
        0x80C9, # G+7129  U+80C9  uni80C9,  CJK UNIFIED IDEOGRAPH-80C9
        0x80CF, # G+7130  U+80CF  uni80CF,  CJK UNIFIED IDEOGRAPH-80CF
        0x80D7, # G+7131  U+80D7  uni80D7,  CJK UNIFIED IDEOGRAPH-80D7
        0x80E6, # G+7132  U+80E6  uni80E6,  CJK UNIFIED IDEOGRAPH-80E6
        0x80CD, # G+7133  U+80CD  uni80CD,  CJK UNIFIED IDEOGRAPH-80CD
        0x81FF, # G+7134  U+81FF  uni81FF,  CJK UNIFIED IDEOGRAPH-81FF
        0x8221, # G+7135  U+8221  uni8221,  CJK UNIFIED IDEOGRAPH-8221
        0x8294, # G+7136  U+8294  uni8294,  CJK UNIFIED IDEOGRAPH-8294
        0x82D9, # G+7137  U+82D9  uni82D9,  CJK UNIFIED IDEOGRAPH-82D9
        0x82FE, # G+7138  U+82FE  uni82FE,  CJK UNIFIED IDEOGRAPH-82FE
        0x82F9, # G+7139  U+82F9  uni82F9,  CJK UNIFIED IDEOGRAPH-82F9
        0x8307, # G+7140  U+8307  uni8307,  CJK UNIFIED IDEOGRAPH-8307
        0x82E8, # G+7141  U+82E8  uni82E8,  CJK UNIFIED IDEOGRAPH-82E8
        0x8300, # G+7142  U+8300  uni8300,  CJK UNIFIED IDEOGRAPH-8300
        0x82D5, # G+7143  U+82D5  uni82D5,  CJK UNIFIED IDEOGRAPH-82D5
        0x833A, # G+7144  U+833A  uni833A,  CJK UNIFIED IDEOGRAPH-833A
        0x82EB, # G+7145  U+82EB  uni82EB,  CJK UNIFIED IDEOGRAPH-82EB
        0x82D6, # G+7146  U+82D6  uni82D6,  CJK UNIFIED IDEOGRAPH-82D6
        0x82F4, # G+7147  U+82F4  uni82F4,  CJK UNIFIED IDEOGRAPH-82F4
        0x82EC, # G+7148  U+82EC  uni82EC,  CJK UNIFIED IDEOGRAPH-82EC
        0x82E1, # G+7149  U+82E1  uni82E1,  CJK UNIFIED IDEOGRAPH-82E1
        0x82F2, # G+7150  U+82F2  uni82F2,  CJK UNIFIED IDEOGRAPH-82F2
        0x82F5, # G+7151  U+82F5  uni82F5,  CJK UNIFIED IDEOGRAPH-82F5
        0x830C, # G+7152  U+830C  uni830C,  CJK UNIFIED IDEOGRAPH-830C
        0x82FB, # G+7153  U+82FB  uni82FB,  CJK UNIFIED IDEOGRAPH-82FB
        0x82F6, # G+7154  U+82F6  uni82F6,  CJK UNIFIED IDEOGRAPH-82F6
        0x82F0, # G+7155  U+82F0  uni82F0,  CJK UNIFIED IDEOGRAPH-82F0
        0x82EA, # G+7156  U+82EA  uni82EA,  CJK UNIFIED IDEOGRAPH-82EA
        0x82E4, # G+7157  U+82E4  uni82E4,  CJK UNIFIED IDEOGRAPH-82E4
        0x82E0, # G+7158  U+82E0  uni82E0,  CJK UNIFIED IDEOGRAPH-82E0
        0x82FA, # G+7159  U+82FA  uni82FA,  CJK UNIFIED IDEOGRAPH-82FA
        0x82F3, # G+7160  U+82F3  uni82F3,  CJK UNIFIED IDEOGRAPH-82F3
        0x82ED, # G+7161  U+82ED  uni82ED,  CJK UNIFIED IDEOGRAPH-82ED
        0x8677, # G+7162  U+8677  uni8677,  CJK UNIFIED IDEOGRAPH-8677
        0x8674, # G+7163  U+8674  uni8674,  CJK UNIFIED IDEOGRAPH-8674
        0x867C, # G+7164  U+867C  uni867C,  CJK UNIFIED IDEOGRAPH-867C
        0x8673, # G+7165  U+8673  uni8673,  CJK UNIFIED IDEOGRAPH-8673
        0x8841, # G+7166  U+8841  uni8841,  CJK UNIFIED IDEOGRAPH-8841
        0x884E, # G+7167  U+884E  uni884E,  CJK UNIFIED IDEOGRAPH-884E
        0x8867, # G+7168  U+8867  uni8867,  CJK UNIFIED IDEOGRAPH-8867
        0x886A, # G+7169  U+886A  uni886A,  CJK UNIFIED IDEOGRAPH-886A
        0x8869, # G+7170  U+8869  uni8869,  CJK UNIFIED IDEOGRAPH-8869
        0x89D3, # G+7171  U+89D3  uni89D3,  CJK UNIFIED IDEOGRAPH-89D3
        0x8A04, # G+7172  U+8A04  uni8A04,  CJK UNIFIED IDEOGRAPH-8A04
        0x8A07, # G+7173  U+8A07  uni8A07,  CJK UNIFIED IDEOGRAPH-8A07
        0x8D72, # G+7174  U+8D72  uni8D72,  CJK UNIFIED IDEOGRAPH-8D72
        0x8FE3, # G+7175  U+8FE3  uni8FE3,  CJK UNIFIED IDEOGRAPH-8FE3
        0x8FE1, # G+7176  U+8FE1  uni8FE1,  CJK UNIFIED IDEOGRAPH-8FE1
        0x8FEE, # G+7177  U+8FEE  uni8FEE,  CJK UNIFIED IDEOGRAPH-8FEE
        0x8FE0, # G+7178  U+8FE0  uni8FE0,  CJK UNIFIED IDEOGRAPH-8FE0
        0x90F1, # G+7179  U+90F1  uni90F1,  CJK UNIFIED IDEOGRAPH-90F1
        0x90BD, # G+7180  U+90BD  uni90BD,  CJK UNIFIED IDEOGRAPH-90BD
        0x90BF, # G+7181  U+90BF  uni90BF,  CJK UNIFIED IDEOGRAPH-90BF
        0x90D5, # G+7182  U+90D5  uni90D5,  CJK UNIFIED IDEOGRAPH-90D5
        0x90C5, # G+7183  U+90C5  uni90C5,  CJK UNIFIED IDEOGRAPH-90C5
        0x90BE, # G+7184  U+90BE  uni90BE,  CJK UNIFIED IDEOGRAPH-90BE
        0x90C7, # G+7185  U+90C7  uni90C7,  CJK UNIFIED IDEOGRAPH-90C7
        0x90CB, # G+7186  U+90CB  uni90CB,  CJK UNIFIED IDEOGRAPH-90CB
        0x90C8, # G+7187  U+90C8  uni90C8,  CJK UNIFIED IDEOGRAPH-90C8
        0x91D4, # G+7188  U+91D4  uni91D4,  CJK UNIFIED IDEOGRAPH-91D4
        0x91D3, # G+7189  U+91D3  uni91D3,  CJK UNIFIED IDEOGRAPH-91D3
        0x9654, # G+7190  U+9654  uni9654,  CJK UNIFIED IDEOGRAPH-9654
        0x964F, # G+7191  U+964F  uni964F,  CJK UNIFIED IDEOGRAPH-964F
        0x9651, # G+7192  U+9651  uni9651,  CJK UNIFIED IDEOGRAPH-9651
        0x9653, # G+7193  U+9653  uni9653,  CJK UNIFIED IDEOGRAPH-9653
        0x964A, # G+7194  U+964A  uni964A,  CJK UNIFIED IDEOGRAPH-964A
        0x964E, # G+7195  U+964E  uni964E,  CJK UNIFIED IDEOGRAPH-964E
        0x501E, # G+7196  U+501E  uni501E,  CJK UNIFIED IDEOGRAPH-501E
        0x5005, # G+7197  U+5005  uni5005,  CJK UNIFIED IDEOGRAPH-5005
        0x5007, # G+7198  U+5007  uni5007,  CJK UNIFIED IDEOGRAPH-5007
        0x5013, # G+7199  U+5013  uni5013,  CJK UNIFIED IDEOGRAPH-5013
        0x5022, # G+7200  U+5022  uni5022,  CJK UNIFIED IDEOGRAPH-5022
        0x5030, # G+7201  U+5030  uni5030,  CJK UNIFIED IDEOGRAPH-5030
        0x501B, # G+7202  U+501B  uni501B,  CJK UNIFIED IDEOGRAPH-501B
        0x4FF5, # G+7203  U+4FF5  uni4FF5,  CJK UNIFIED IDEOGRAPH-4FF5
        0x4FF4, # G+7204  U+4FF4  uni4FF4,  CJK UNIFIED IDEOGRAPH-4FF4
        0x5033, # G+7205  U+5033  uni5033,  CJK UNIFIED IDEOGRAPH-5033
        0x5037, # G+7206  U+5037  uni5037,  CJK UNIFIED IDEOGRAPH-5037
        0x502C, # G+7207  U+502C  uni502C,  CJK UNIFIED IDEOGRAPH-502C
        0x4FF6, # G+7208  U+4FF6  uni4FF6,  CJK UNIFIED IDEOGRAPH-4FF6
        0x4FF7, # G+7209  U+4FF7  uni4FF7,  CJK UNIFIED IDEOGRAPH-4FF7
        0x5017, # G+7210  U+5017  uni5017,  CJK UNIFIED IDEOGRAPH-5017
        0x501C, # G+7211  U+501C  uni501C,  CJK UNIFIED IDEOGRAPH-501C
        0x5020, # G+7212  U+5020  uni5020,  CJK UNIFIED IDEOGRAPH-5020
        0x5027, # G+7213  U+5027  uni5027,  CJK UNIFIED IDEOGRAPH-5027
        0x5035, # G+7214  U+5035  uni5035,  CJK UNIFIED IDEOGRAPH-5035
        0x502F, # G+7215  U+502F  uni502F,  CJK UNIFIED IDEOGRAPH-502F
        0x5031, # G+7216  U+5031  uni5031,  CJK UNIFIED IDEOGRAPH-5031
        0x500E, # G+7217  U+500E  uni500E,  CJK UNIFIED IDEOGRAPH-500E
        0x515A, # G+7218  U+515A  uni515A,  CJK UNIFIED IDEOGRAPH-515A
        0x5194, # G+7219  U+5194  uni5194,  CJK UNIFIED IDEOGRAPH-5194
        0x5193, # G+7220  U+5193  uni5193,  CJK UNIFIED IDEOGRAPH-5193
        0x51CA, # G+7221  U+51CA  uni51CA,  CJK UNIFIED IDEOGRAPH-51CA
        0x51C4, # G+7222  U+51C4  uni51C4,  CJK UNIFIED IDEOGRAPH-51C4
        0x51C5, # G+7223  U+51C5  uni51C5,  CJK UNIFIED IDEOGRAPH-51C5
        0x51C8, # G+7224  U+51C8  uni51C8,  CJK UNIFIED IDEOGRAPH-51C8
        0x51CE, # G+7225  U+51CE  uni51CE,  CJK UNIFIED IDEOGRAPH-51CE
        0x5261, # G+7226  U+5261  uni5261,  CJK UNIFIED IDEOGRAPH-5261
        0x525A, # G+7227  U+525A  uni525A,  CJK UNIFIED IDEOGRAPH-525A
        0x5252, # G+7228  U+5252  uni5252,  CJK UNIFIED IDEOGRAPH-5252
        0x525E, # G+7229  U+525E  uni525E,  CJK UNIFIED IDEOGRAPH-525E
        0x525F, # G+7230  U+525F  uni525F,  CJK UNIFIED IDEOGRAPH-525F
        0x5255, # G+7231  U+5255  uni5255,  CJK UNIFIED IDEOGRAPH-5255
        0x5262, # G+7232  U+5262  uni5262,  CJK UNIFIED IDEOGRAPH-5262
        0x52CD, # G+7233  U+52CD  uni52CD,  CJK UNIFIED IDEOGRAPH-52CD
        0x530E, # G+7234  U+530E  uni530E,  CJK UNIFIED IDEOGRAPH-530E
        0x539E, # G+7235  U+539E  uni539E,  CJK UNIFIED IDEOGRAPH-539E
        0x5526, # G+7236  U+5526  uni5526,  CJK UNIFIED IDEOGRAPH-5526
        0x54E2, # G+7237  U+54E2  uni54E2,  CJK UNIFIED IDEOGRAPH-54E2
        0x5517, # G+7238  U+5517  uni5517,  CJK UNIFIED IDEOGRAPH-5517
        0x5512, # G+7239  U+5512  uni5512,  CJK UNIFIED IDEOGRAPH-5512
        0x54E7, # G+7240  U+54E7  uni54E7,  CJK UNIFIED IDEOGRAPH-54E7
        0x54F3, # G+7241  U+54F3  uni54F3,  CJK UNIFIED IDEOGRAPH-54F3
        0x54E4, # G+7242  U+54E4  uni54E4,  CJK UNIFIED IDEOGRAPH-54E4
        0x551A, # G+7243  U+551A  uni551A,  CJK UNIFIED IDEOGRAPH-551A
        0x54FF, # G+7244  U+54FF  uni54FF,  CJK UNIFIED IDEOGRAPH-54FF
        0x5504, # G+7245  U+5504  uni5504,  CJK UNIFIED IDEOGRAPH-5504
        0x5508, # G+7246  U+5508  uni5508,  CJK UNIFIED IDEOGRAPH-5508
        0x54EB, # G+7247  U+54EB  uni54EB,  CJK UNIFIED IDEOGRAPH-54EB
        0x5511, # G+7248  U+5511  uni5511,  CJK UNIFIED IDEOGRAPH-5511
        0x5505, # G+7249  U+5505  uni5505,  CJK UNIFIED IDEOGRAPH-5505
        0x54F1, # G+7250  U+54F1  uni54F1,  CJK UNIFIED IDEOGRAPH-54F1
        0x550A, # G+7251  U+550A  uni550A,  CJK UNIFIED IDEOGRAPH-550A
        0x54FB, # G+7252  U+54FB  uni54FB,  CJK UNIFIED IDEOGRAPH-54FB
        0x54F7, # G+7253  U+54F7  uni54F7,  CJK UNIFIED IDEOGRAPH-54F7
        0x54F8, # G+7254  U+54F8  uni54F8,  CJK UNIFIED IDEOGRAPH-54F8
        0x54E0, # G+7255  U+54E0  uni54E0,  CJK UNIFIED IDEOGRAPH-54E0
        0x550E, # G+7256  U+550E  uni550E,  CJK UNIFIED IDEOGRAPH-550E
        0x5503, # G+7257  U+5503  uni5503,  CJK UNIFIED IDEOGRAPH-5503
        0x550B, # G+7258  U+550B  uni550B,  CJK UNIFIED IDEOGRAPH-550B
        0x5701, # G+7259  U+5701  uni5701,  CJK UNIFIED IDEOGRAPH-5701
        0x5702, # G+7260  U+5702  uni5702,  CJK UNIFIED IDEOGRAPH-5702
        0x57CC, # G+7261  U+57CC  uni57CC,  CJK UNIFIED IDEOGRAPH-57CC
        0x5832, # G+7262  U+5832  uni5832,  CJK UNIFIED IDEOGRAPH-5832
        0x57D5, # G+7263  U+57D5  uni57D5,  CJK UNIFIED IDEOGRAPH-57D5
        0x57D2, # G+7264  U+57D2  uni57D2,  CJK UNIFIED IDEOGRAPH-57D2
        0x57BA, # G+7265  U+57BA  uni57BA,  CJK UNIFIED IDEOGRAPH-57BA
        0x57C6, # G+7266  U+57C6  uni57C6,  CJK UNIFIED IDEOGRAPH-57C6
        0x57BD, # G+7267  U+57BD  uni57BD,  CJK UNIFIED IDEOGRAPH-57BD
        0x57BC, # G+7268  U+57BC  uni57BC,  CJK UNIFIED IDEOGRAPH-57BC
        0x57B8, # G+7269  U+57B8  uni57B8,  CJK UNIFIED IDEOGRAPH-57B8
        0x57B6, # G+7270  U+57B6  uni57B6,  CJK UNIFIED IDEOGRAPH-57B6
        0x57BF, # G+7271  U+57BF  uni57BF,  CJK UNIFIED IDEOGRAPH-57BF
        0x57C7, # G+7272  U+57C7  uni57C7,  CJK UNIFIED IDEOGRAPH-57C7
        0x57D0, # G+7273  U+57D0  uni57D0,  CJK UNIFIED IDEOGRAPH-57D0
        0x57B9, # G+7274  U+57B9  uni57B9,  CJK UNIFIED IDEOGRAPH-57B9
        0x57C1, # G+7275  U+57C1  uni57C1,  CJK UNIFIED IDEOGRAPH-57C1
        0x590E, # G+7276  U+590E  uni590E,  CJK UNIFIED IDEOGRAPH-590E
        0x594A, # G+7277  U+594A  uni594A,  CJK UNIFIED IDEOGRAPH-594A
        0x5A19, # G+7278  U+5A19  uni5A19,  CJK UNIFIED IDEOGRAPH-5A19
        0x5A16, # G+7279  U+5A16  uni5A16,  CJK UNIFIED IDEOGRAPH-5A16
        0x5A2D, # G+7280  U+5A2D  uni5A2D,  CJK UNIFIED IDEOGRAPH-5A2D
        0x5A2E, # G+7281  U+5A2E  uni5A2E,  CJK UNIFIED IDEOGRAPH-5A2E
        0x5A15, # G+7282  U+5A15  uni5A15,  CJK UNIFIED IDEOGRAPH-5A15
        0x5A0F, # G+7283  U+5A0F  uni5A0F,  CJK UNIFIED IDEOGRAPH-5A0F
        0x5A17, # G+7284  U+5A17  uni5A17,  CJK UNIFIED IDEOGRAPH-5A17
        0x5A0A, # G+7285  U+5A0A  uni5A0A,  CJK UNIFIED IDEOGRAPH-5A0A
        0x5A1E, # G+7286  U+5A1E  uni5A1E,  CJK UNIFIED IDEOGRAPH-5A1E
        0x5A33, # G+7287  U+5A33  uni5A33,  CJK UNIFIED IDEOGRAPH-5A33
        0x5B6C, # G+7288  U+5B6C  uni5B6C,  CJK UNIFIED IDEOGRAPH-5B6C
        0x5BA7, # G+7289  U+5BA7  uni5BA7,  CJK UNIFIED IDEOGRAPH-5BA7
        0x5BAD, # G+7290  U+5BAD  uni5BAD,  CJK UNIFIED IDEOGRAPH-5BAD
        0x5BAC, # G+7291  U+5BAC  uni5BAC,  CJK UNIFIED IDEOGRAPH-5BAC
        0x5C03, # G+7292  U+5C03  uni5C03,  CJK UNIFIED IDEOGRAPH-5C03
        0x5C56, # G+7293  U+5C56  uni5C56,  CJK UNIFIED IDEOGRAPH-5C56
        0x5C54, # G+7294  U+5C54  uni5C54,  CJK UNIFIED IDEOGRAPH-5C54
        0x5CEC, # G+7295  U+5CEC  uni5CEC,  CJK UNIFIED IDEOGRAPH-5CEC
        0x5CFF, # G+7296  U+5CFF  uni5CFF,  CJK UNIFIED IDEOGRAPH-5CFF
        0x5CEE, # G+7297  U+5CEE  uni5CEE,  CJK UNIFIED IDEOGRAPH-5CEE
        0x5CF1, # G+7298  U+5CF1  uni5CF1,  CJK UNIFIED IDEOGRAPH-5CF1
        0x5CF7, # G+7299  U+5CF7  uni5CF7,  CJK UNIFIED IDEOGRAPH-5CF7
        0x5D00, # G+7300  U+5D00  uni5D00,  CJK UNIFIED IDEOGRAPH-5D00
        0x5CF9, # G+7301  U+5CF9  uni5CF9,  CJK UNIFIED IDEOGRAPH-5CF9
        0x5E29, # G+7302  U+5E29  uni5E29,  CJK UNIFIED IDEOGRAPH-5E29
        0x5E28, # G+7303  U+5E28  uni5E28,  CJK UNIFIED IDEOGRAPH-5E28
        0x5EA8, # G+7304  U+5EA8  uni5EA8,  CJK UNIFIED IDEOGRAPH-5EA8
        0x5EAE, # G+7305  U+5EAE  uni5EAE,  CJK UNIFIED IDEOGRAPH-5EAE
        0x5EAA, # G+7306  U+5EAA  uni5EAA,  CJK UNIFIED IDEOGRAPH-5EAA
        0x5EAC, # G+7307  U+5EAC  uni5EAC,  CJK UNIFIED IDEOGRAPH-5EAC
        0x5F33, # G+7308  U+5F33  uni5F33,  CJK UNIFIED IDEOGRAPH-5F33
        0x5F30, # G+7309  U+5F30  uni5F30,  CJK UNIFIED IDEOGRAPH-5F30
        0x5F67, # G+7310  U+5F67  uni5F67,  CJK UNIFIED IDEOGRAPH-5F67
        0x605D, # G+7311  U+605D  uni605D,  CJK UNIFIED IDEOGRAPH-605D
        0x605A, # G+7312  U+605A  uni605A,  CJK UNIFIED IDEOGRAPH-605A
        0x6067, # G+7313  U+6067  uni6067,  CJK UNIFIED IDEOGRAPH-6067
        0x6041, # G+7314  U+6041  uni6041,  CJK UNIFIED IDEOGRAPH-6041
        0x60A2, # G+7315  U+60A2  uni60A2,  CJK UNIFIED IDEOGRAPH-60A2
        0x6088, # G+7316  U+6088  uni6088,  CJK UNIFIED IDEOGRAPH-6088
        0x6080, # G+7317  U+6080  uni6080,  CJK UNIFIED IDEOGRAPH-6080
        0x6092, # G+7318  U+6092  uni6092,  CJK UNIFIED IDEOGRAPH-6092
        0x6081, # G+7319  U+6081  uni6081,  CJK UNIFIED IDEOGRAPH-6081
        0x609D, # G+7320  U+609D  uni609D,  CJK UNIFIED IDEOGRAPH-609D
        0x6083, # G+7321  U+6083  uni6083,  CJK UNIFIED IDEOGRAPH-6083
        0x6095, # G+7322  U+6095  uni6095,  CJK UNIFIED IDEOGRAPH-6095
        0x609B, # G+7323  U+609B  uni609B,  CJK UNIFIED IDEOGRAPH-609B
        0x6097, # G+7324  U+6097  uni6097,  CJK UNIFIED IDEOGRAPH-6097
        0x6087, # G+7325  U+6087  uni6087,  CJK UNIFIED IDEOGRAPH-6087
        0x609C, # G+7326  U+609C  uni609C,  CJK UNIFIED IDEOGRAPH-609C
        0x608E, # G+7327  U+608E  uni608E,  CJK UNIFIED IDEOGRAPH-608E
        0x6219, # G+7328  U+6219  uni6219,  CJK UNIFIED IDEOGRAPH-6219
        0x6246, # G+7329  U+6246  uni6246,  CJK UNIFIED IDEOGRAPH-6246
        0x62F2, # G+7330  U+62F2  uni62F2,  CJK UNIFIED IDEOGRAPH-62F2
        0x6310, # G+7331  U+6310  uni6310,  CJK UNIFIED IDEOGRAPH-6310
        0x6356, # G+7332  U+6356  uni6356,  CJK UNIFIED IDEOGRAPH-6356
        0x632C, # G+7333  U+632C  uni632C,  CJK UNIFIED IDEOGRAPH-632C
        0x6344, # G+7334  U+6344  uni6344,  CJK UNIFIED IDEOGRAPH-6344
        0x6345, # G+7335  U+6345  uni6345,  CJK UNIFIED IDEOGRAPH-6345
        0x6336, # G+7336  U+6336  uni6336,  CJK UNIFIED IDEOGRAPH-6336
        0x6343, # G+7337  U+6343  uni6343,  CJK UNIFIED IDEOGRAPH-6343
        0x63E4, # G+7338  U+63E4  uni63E4,  CJK UNIFIED IDEOGRAPH-63E4
        0x6339, # G+7339  U+6339  uni6339,  CJK UNIFIED IDEOGRAPH-6339
        0x634B, # G+7340  U+634B  uni634B,  CJK UNIFIED IDEOGRAPH-634B
        0x634A, # G+7341  U+634A  uni634A,  CJK UNIFIED IDEOGRAPH-634A
        0x633C, # G+7342  U+633C  uni633C,  CJK UNIFIED IDEOGRAPH-633C
        0x6329, # G+7343  U+6329  uni6329,  CJK UNIFIED IDEOGRAPH-6329
        0x6341, # G+7344  U+6341  uni6341,  CJK UNIFIED IDEOGRAPH-6341
        0x6334, # G+7345  U+6334  uni6334,  CJK UNIFIED IDEOGRAPH-6334
        0x6358, # G+7346  U+6358  uni6358,  CJK UNIFIED IDEOGRAPH-6358
        0x6354, # G+7347  U+6354  uni6354,  CJK UNIFIED IDEOGRAPH-6354
        0x6359, # G+7348  U+6359  uni6359,  CJK UNIFIED IDEOGRAPH-6359
        0x632D, # G+7349  U+632D  uni632D,  CJK UNIFIED IDEOGRAPH-632D
        0x6347, # G+7350  U+6347  uni6347,  CJK UNIFIED IDEOGRAPH-6347
        0x6333, # G+7351  U+6333  uni6333,  CJK UNIFIED IDEOGRAPH-6333
        0x635A, # G+7352  U+635A  uni635A,  CJK UNIFIED IDEOGRAPH-635A
        0x6351, # G+7353  U+6351  uni6351,  CJK UNIFIED IDEOGRAPH-6351
        0x6338, # G+7354  U+6338  uni6338,  CJK UNIFIED IDEOGRAPH-6338
        0x6357, # G+7355  U+6357  uni6357,  CJK UNIFIED IDEOGRAPH-6357
        0x6340, # G+7356  U+6340  uni6340,  CJK UNIFIED IDEOGRAPH-6340
        0x6348, # G+7357  U+6348  uni6348,  CJK UNIFIED IDEOGRAPH-6348
        0x654A, # G+7358  U+654A  uni654A,  CJK UNIFIED IDEOGRAPH-654A
        0x6546, # G+7359  U+6546  uni6546,  CJK UNIFIED IDEOGRAPH-6546
        0x65C6, # G+7360  U+65C6  uni65C6,  CJK UNIFIED IDEOGRAPH-65C6
        0x65C3, # G+7361  U+65C3  uni65C3,  CJK UNIFIED IDEOGRAPH-65C3
        0x65C4, # G+7362  U+65C4  uni65C4,  CJK UNIFIED IDEOGRAPH-65C4
        0x65C2, # G+7363  U+65C2  uni65C2,  CJK UNIFIED IDEOGRAPH-65C2
        0x664A, # G+7364  U+664A  uni664A,  CJK UNIFIED IDEOGRAPH-664A
        0x665F, # G+7365  U+665F  uni665F,  CJK UNIFIED IDEOGRAPH-665F
        0x6647, # G+7366  U+6647  uni6647,  CJK UNIFIED IDEOGRAPH-6647
        0x6651, # G+7367  U+6651  uni6651,  CJK UNIFIED IDEOGRAPH-6651
        0x6712, # G+7368  U+6712  uni6712,  CJK UNIFIED IDEOGRAPH-6712
        0x6713, # G+7369  U+6713  uni6713,  CJK UNIFIED IDEOGRAPH-6713
        0x681F, # G+7370  U+681F  uni681F,  CJK UNIFIED IDEOGRAPH-681F
        0x681A, # G+7371  U+681A  uni681A,  CJK UNIFIED IDEOGRAPH-681A
        0x6849, # G+7372  U+6849  uni6849,  CJK UNIFIED IDEOGRAPH-6849
        0x6832, # G+7373  U+6832  uni6832,  CJK UNIFIED IDEOGRAPH-6832
        0x6833, # G+7374  U+6833  uni6833,  CJK UNIFIED IDEOGRAPH-6833
        0x683B, # G+7375  U+683B  uni683B,  CJK UNIFIED IDEOGRAPH-683B
        0x684B, # G+7376  U+684B  uni684B,  CJK UNIFIED IDEOGRAPH-684B
        0x684F, # G+7377  U+684F  uni684F,  CJK UNIFIED IDEOGRAPH-684F
        0x6816, # G+7378  U+6816  uni6816,  CJK UNIFIED IDEOGRAPH-6816
        0x6831, # G+7379  U+6831  uni6831,  CJK UNIFIED IDEOGRAPH-6831
        0x681C, # G+7380  U+681C  uni681C,  CJK UNIFIED IDEOGRAPH-681C
        0x6835, # G+7381  U+6835  uni6835,  CJK UNIFIED IDEOGRAPH-6835
        0x682B, # G+7382  U+682B  uni682B,  CJK UNIFIED IDEOGRAPH-682B
        0x682D, # G+7383  U+682D  uni682D,  CJK UNIFIED IDEOGRAPH-682D
        0x682F, # G+7384  U+682F  uni682F,  CJK UNIFIED IDEOGRAPH-682F
        0x684E, # G+7385  U+684E  uni684E,  CJK UNIFIED IDEOGRAPH-684E
        0x6844, # G+7386  U+6844  uni6844,  CJK UNIFIED IDEOGRAPH-6844
        0x6834, # G+7387  U+6834  uni6834,  CJK UNIFIED IDEOGRAPH-6834
        0x681D, # G+7388  U+681D  uni681D,  CJK UNIFIED IDEOGRAPH-681D
        0x6812, # G+7389  U+6812  uni6812,  CJK UNIFIED IDEOGRAPH-6812
        0x6814, # G+7390  U+6814  uni6814,  CJK UNIFIED IDEOGRAPH-6814
        0x6826, # G+7391  U+6826  uni6826,  CJK UNIFIED IDEOGRAPH-6826
        0x6828, # G+7392  U+6828  uni6828,  CJK UNIFIED IDEOGRAPH-6828
        0x682E, # G+7393  U+682E  uni682E,  CJK UNIFIED IDEOGRAPH-682E
        0x684D, # G+7394  U+684D  uni684D,  CJK UNIFIED IDEOGRAPH-684D
        0x683A, # G+7395  U+683A  uni683A,  CJK UNIFIED IDEOGRAPH-683A
        0x6825, # G+7396  U+6825  uni6825,  CJK UNIFIED IDEOGRAPH-6825
        0x6820, # G+7397  U+6820  uni6820,  CJK UNIFIED IDEOGRAPH-6820
        0x6B2C, # G+7398  U+6B2C  uni6B2C,  CJK UNIFIED IDEOGRAPH-6B2C
        0x6B2F, # G+7399  U+6B2F  uni6B2F,  CJK UNIFIED IDEOGRAPH-6B2F
        0x6B2D, # G+7400  U+6B2D  uni6B2D,  CJK UNIFIED IDEOGRAPH-6B2D
        0x6B31, # G+7401  U+6B31  uni6B31,  CJK UNIFIED IDEOGRAPH-6B31
        0x6B34, # G+7402  U+6B34  uni6B34,  CJK UNIFIED IDEOGRAPH-6B34
        0x6B6D, # G+7403  U+6B6D  uni6B6D,  CJK UNIFIED IDEOGRAPH-6B6D
        0x8082, # G+7404  U+8082  uni8082,  CJK UNIFIED IDEOGRAPH-8082
        0x6B88, # G+7405  U+6B88  uni6B88,  CJK UNIFIED IDEOGRAPH-6B88
        0x6BE6, # G+7406  U+6BE6  uni6BE6,  CJK UNIFIED IDEOGRAPH-6BE6
        0x6BE4, # G+7407  U+6BE4  uni6BE4,  CJK UNIFIED IDEOGRAPH-6BE4
        0x6BE8, # G+7408  U+6BE8  uni6BE8,  CJK UNIFIED IDEOGRAPH-6BE8
        0x6BE3, # G+7409  U+6BE3  uni6BE3,  CJK UNIFIED IDEOGRAPH-6BE3
        0x6BE2, # G+7410  U+6BE2  uni6BE2,  CJK UNIFIED IDEOGRAPH-6BE2
        0x6BE7, # G+7411  U+6BE7  uni6BE7,  CJK UNIFIED IDEOGRAPH-6BE7
        0x6C25, # G+7412  U+6C25  uni6C25,  CJK UNIFIED IDEOGRAPH-6C25
        0x6D7A, # G+7413  U+6D7A  uni6D7A,  CJK UNIFIED IDEOGRAPH-6D7A
        0x6D63, # G+7414  U+6D63  uni6D63,  CJK UNIFIED IDEOGRAPH-6D63
        0x6D64, # G+7415  U+6D64  uni6D64,  CJK UNIFIED IDEOGRAPH-6D64
        0x6D76, # G+7416  U+6D76  uni6D76,  CJK UNIFIED IDEOGRAPH-6D76
        0x6D0D, # G+7417  U+6D0D  uni6D0D,  CJK UNIFIED IDEOGRAPH-6D0D
        0x6D61, # G+7418  U+6D61  uni6D61,  CJK UNIFIED IDEOGRAPH-6D61
        0x6D92, # G+7419  U+6D92  uni6D92,  CJK UNIFIED IDEOGRAPH-6D92
        0x6D58, # G+7420  U+6D58  uni6D58,  CJK UNIFIED IDEOGRAPH-6D58
        0x6D62, # G+7421  U+6D62  uni6D62,  CJK UNIFIED IDEOGRAPH-6D62
        0x6D6D, # G+7422  U+6D6D  uni6D6D,  CJK UNIFIED IDEOGRAPH-6D6D
        0x6D6F, # G+7423  U+6D6F  uni6D6F,  CJK UNIFIED IDEOGRAPH-6D6F
        0x6D91, # G+7424  U+6D91  uni6D91,  CJK UNIFIED IDEOGRAPH-6D91
        0x6D8D, # G+7425  U+6D8D  uni6D8D,  CJK UNIFIED IDEOGRAPH-6D8D
        0x6DEF, # G+7426  U+6DEF  uni6DEF,  CJK UNIFIED IDEOGRAPH-6DEF
        0x6D7F, # G+7427  U+6D7F  uni6D7F,  CJK UNIFIED IDEOGRAPH-6D7F
        0x6D86, # G+7428  U+6D86  uni6D86,  CJK UNIFIED IDEOGRAPH-6D86
        0x6D5E, # G+7429  U+6D5E  uni6D5E,  CJK UNIFIED IDEOGRAPH-6D5E
        0x6D67, # G+7430  U+6D67  uni6D67,  CJK UNIFIED IDEOGRAPH-6D67
        0x6D60, # G+7431  U+6D60  uni6D60,  CJK UNIFIED IDEOGRAPH-6D60
        0x6D97, # G+7432  U+6D97  uni6D97,  CJK UNIFIED IDEOGRAPH-6D97
        0x6D70, # G+7433  U+6D70  uni6D70,  CJK UNIFIED IDEOGRAPH-6D70
        0x6D7C, # G+7434  U+6D7C  uni6D7C,  CJK UNIFIED IDEOGRAPH-6D7C
        0x6D5F, # G+7435  U+6D5F  uni6D5F,  CJK UNIFIED IDEOGRAPH-6D5F
        0x6D82, # G+7436  U+6D82  uni6D82,  CJK UNIFIED IDEOGRAPH-6D82
        0x6D98, # G+7437  U+6D98  uni6D98,  CJK UNIFIED IDEOGRAPH-6D98
        0x6D2F, # G+7438  U+6D2F  uni6D2F,  CJK UNIFIED IDEOGRAPH-6D2F
        0x6D68, # G+7439  U+6D68  uni6D68,  CJK UNIFIED IDEOGRAPH-6D68
        0x6D8B, # G+7440  U+6D8B  uni6D8B,  CJK UNIFIED IDEOGRAPH-6D8B
        0x6D7E, # G+7441  U+6D7E  uni6D7E,  CJK UNIFIED IDEOGRAPH-6D7E
        0x6D80, # G+7442  U+6D80  uni6D80,  CJK UNIFIED IDEOGRAPH-6D80
        0x6D84, # G+7443  U+6D84  uni6D84,  CJK UNIFIED IDEOGRAPH-6D84
        0x6D16, # G+7444  U+6D16  uni6D16,  CJK UNIFIED IDEOGRAPH-6D16
        0x6D83, # G+7445  U+6D83  uni6D83,  CJK UNIFIED IDEOGRAPH-6D83
        0x6D7B, # G+7446  U+6D7B  uni6D7B,  CJK UNIFIED IDEOGRAPH-6D7B
        0x6D7D, # G+7447  U+6D7D  uni6D7D,  CJK UNIFIED IDEOGRAPH-6D7D
        0x6D75, # G+7448  U+6D75  uni6D75,  CJK UNIFIED IDEOGRAPH-6D75
        0x6D90, # G+7449  U+6D90  uni6D90,  CJK UNIFIED IDEOGRAPH-6D90
        0x70DC, # G+7450  U+70DC  uni70DC,  CJK UNIFIED IDEOGRAPH-70DC
        0x70D3, # G+7451  U+70D3  uni70D3,  CJK UNIFIED IDEOGRAPH-70D3
        0x70D1, # G+7452  U+70D1  uni70D1,  CJK UNIFIED IDEOGRAPH-70D1
        0x70DD, # G+7453  U+70DD  uni70DD,  CJK UNIFIED IDEOGRAPH-70DD
        0x70CB, # G+7454  U+70CB  uni70CB,  CJK UNIFIED IDEOGRAPH-70CB
        0x7F39, # G+7455  U+7F39  uni7F39,  CJK UNIFIED IDEOGRAPH-7F39
        0x70E2, # G+7456  U+70E2  uni70E2,  CJK UNIFIED IDEOGRAPH-70E2
        0x70D7, # G+7457  U+70D7  uni70D7,  CJK UNIFIED IDEOGRAPH-70D7
        0x70D2, # G+7458  U+70D2  uni70D2,  CJK UNIFIED IDEOGRAPH-70D2
        0x70DE, # G+7459  U+70DE  uni70DE,  CJK UNIFIED IDEOGRAPH-70DE
        0x70E0, # G+7460  U+70E0  uni70E0,  CJK UNIFIED IDEOGRAPH-70E0
        0x70D4, # G+7461  U+70D4  uni70D4,  CJK UNIFIED IDEOGRAPH-70D4
        0x70CD, # G+7462  U+70CD  uni70CD,  CJK UNIFIED IDEOGRAPH-70CD
        0x70C5, # G+7463  U+70C5  uni70C5,  CJK UNIFIED IDEOGRAPH-70C5
        0x70C6, # G+7464  U+70C6  uni70C6,  CJK UNIFIED IDEOGRAPH-70C6
        0x70C7, # G+7465  U+70C7  uni70C7,  CJK UNIFIED IDEOGRAPH-70C7
        0x70DA, # G+7466  U+70DA  uni70DA,  CJK UNIFIED IDEOGRAPH-70DA
        0x70CE, # G+7467  U+70CE  uni70CE,  CJK UNIFIED IDEOGRAPH-70CE
        0x70E1, # G+7468  U+70E1  uni70E1,  CJK UNIFIED IDEOGRAPH-70E1
        0x7242, # G+7469  U+7242  uni7242,  CJK UNIFIED IDEOGRAPH-7242
        0x7278, # G+7470  U+7278  uni7278,  CJK UNIFIED IDEOGRAPH-7278
        0x7277, # G+7471  U+7277  uni7277,  CJK UNIFIED IDEOGRAPH-7277
        0x7276, # G+7472  U+7276  uni7276,  CJK UNIFIED IDEOGRAPH-7276
        0x7300, # G+7473  U+7300  uni7300,  CJK UNIFIED IDEOGRAPH-7300
        0x72FA, # G+7474  U+72FA  uni72FA,  CJK UNIFIED IDEOGRAPH-72FA
        0x72F4, # G+7475  U+72F4  uni72F4,  CJK UNIFIED IDEOGRAPH-72F4
        0x72FE, # G+7476  U+72FE  uni72FE,  CJK UNIFIED IDEOGRAPH-72FE
        0x72F6, # G+7477  U+72F6  uni72F6,  CJK UNIFIED IDEOGRAPH-72F6
        0x72F3, # G+7478  U+72F3  uni72F3,  CJK UNIFIED IDEOGRAPH-72F3
        0x72FB, # G+7479  U+72FB  uni72FB,  CJK UNIFIED IDEOGRAPH-72FB
        0x7301, # G+7480  U+7301  uni7301,  CJK UNIFIED IDEOGRAPH-7301
        0x73D3, # G+7481  U+73D3  uni73D3,  CJK UNIFIED IDEOGRAPH-73D3
        0x73D9, # G+7482  U+73D9  uni73D9,  CJK UNIFIED IDEOGRAPH-73D9
        0x73E5, # G+7483  U+73E5  uni73E5,  CJK UNIFIED IDEOGRAPH-73E5
        0x73D6, # G+7484  U+73D6  uni73D6,  CJK UNIFIED IDEOGRAPH-73D6
        0x73BC, # G+7485  U+73BC  uni73BC,  CJK UNIFIED IDEOGRAPH-73BC
        0x73E7, # G+7486  U+73E7  uni73E7,  CJK UNIFIED IDEOGRAPH-73E7
        0x73E3, # G+7487  U+73E3  uni73E3,  CJK UNIFIED IDEOGRAPH-73E3
        0x73E9, # G+7488  U+73E9  uni73E9,  CJK UNIFIED IDEOGRAPH-73E9
        0x73DC, # G+7489  U+73DC  uni73DC,  CJK UNIFIED IDEOGRAPH-73DC
        0x73D2, # G+7490  U+73D2  uni73D2,  CJK UNIFIED IDEOGRAPH-73D2
        0x73DB, # G+7491  U+73DB  uni73DB,  CJK UNIFIED IDEOGRAPH-73DB
        0x73D4, # G+7492  U+73D4  uni73D4,  CJK UNIFIED IDEOGRAPH-73D4
        0x73DD, # G+7493  U+73DD  uni73DD,  CJK UNIFIED IDEOGRAPH-73DD
        0x73DA, # G+7494  U+73DA  uni73DA,  CJK UNIFIED IDEOGRAPH-73DA
        0x73D7, # G+7495  U+73D7  uni73D7,  CJK UNIFIED IDEOGRAPH-73D7
        0x73D8, # G+7496  U+73D8  uni73D8,  CJK UNIFIED IDEOGRAPH-73D8
        0x73E8, # G+7497  U+73E8  uni73E8,  CJK UNIFIED IDEOGRAPH-73E8
        0x74DE, # G+7498  U+74DE  uni74DE,  CJK UNIFIED IDEOGRAPH-74DE
        0x74DF, # G+7499  U+74DF  uni74DF,  CJK UNIFIED IDEOGRAPH-74DF
        0x74F4, # G+7500  U+74F4  uni74F4,  CJK UNIFIED IDEOGRAPH-74F4
        0x74F5, # G+7501  U+74F5  uni74F5,  CJK UNIFIED IDEOGRAPH-74F5
        0x7521, # G+7502  U+7521  uni7521,  CJK UNIFIED IDEOGRAPH-7521
        0x755B, # G+7503  U+755B  uni755B,  CJK UNIFIED IDEOGRAPH-755B
        0x755F, # G+7504  U+755F  uni755F,  CJK UNIFIED IDEOGRAPH-755F
        0x75B0, # G+7505  U+75B0  uni75B0,  CJK UNIFIED IDEOGRAPH-75B0
        0x75C1, # G+7506  U+75C1  uni75C1,  CJK UNIFIED IDEOGRAPH-75C1
        0x75BB, # G+7507  U+75BB  uni75BB,  CJK UNIFIED IDEOGRAPH-75BB
        0x75C4, # G+7508  U+75C4  uni75C4,  CJK UNIFIED IDEOGRAPH-75C4
        0x75C0, # G+7509  U+75C0  uni75C0,  CJK UNIFIED IDEOGRAPH-75C0
        0x75BF, # G+7510  U+75BF  uni75BF,  CJK UNIFIED IDEOGRAPH-75BF
        0x75B6, # G+7511  U+75B6  uni75B6,  CJK UNIFIED IDEOGRAPH-75B6
        0x75BA, # G+7512  U+75BA  uni75BA,  CJK UNIFIED IDEOGRAPH-75BA
        0x768A, # G+7513  U+768A  uni768A,  CJK UNIFIED IDEOGRAPH-768A
        0x76C9, # G+7514  U+76C9  uni76C9,  CJK UNIFIED IDEOGRAPH-76C9
        0x771D, # G+7515  U+771D  uni771D,  CJK UNIFIED IDEOGRAPH-771D
        0x771B, # G+7516  U+771B  uni771B,  CJK UNIFIED IDEOGRAPH-771B
        0x7710, # G+7517  U+7710  uni7710,  CJK UNIFIED IDEOGRAPH-7710
        0x7713, # G+7518  U+7713  uni7713,  CJK UNIFIED IDEOGRAPH-7713
        0x7712, # G+7519  U+7712  uni7712,  CJK UNIFIED IDEOGRAPH-7712
        0x7723, # G+7520  U+7723  uni7723,  CJK UNIFIED IDEOGRAPH-7723
        0x7711, # G+7521  U+7711  uni7711,  CJK UNIFIED IDEOGRAPH-7711
        0x7715, # G+7522  U+7715  uni7715,  CJK UNIFIED IDEOGRAPH-7715
        0x7719, # G+7523  U+7719  uni7719,  CJK UNIFIED IDEOGRAPH-7719
        0x771A, # G+7524  U+771A  uni771A,  CJK UNIFIED IDEOGRAPH-771A
        0x7722, # G+7525  U+7722  uni7722,  CJK UNIFIED IDEOGRAPH-7722
        0x7727, # G+7526  U+7727  uni7727,  CJK UNIFIED IDEOGRAPH-7727
        0x7823, # G+7527  U+7823  uni7823,  CJK UNIFIED IDEOGRAPH-7823
        0x782C, # G+7528  U+782C  uni782C,  CJK UNIFIED IDEOGRAPH-782C
        0x7822, # G+7529  U+7822  uni7822,  CJK UNIFIED IDEOGRAPH-7822
        0x7835, # G+7530  U+7835  uni7835,  CJK UNIFIED IDEOGRAPH-7835
        0x782F, # G+7531  U+782F  uni782F,  CJK UNIFIED IDEOGRAPH-782F
        0x7828, # G+7532  U+7828  uni7828,  CJK UNIFIED IDEOGRAPH-7828
        0x782E, # G+7533  U+782E  uni782E,  CJK UNIFIED IDEOGRAPH-782E
        0x782B, # G+7534  U+782B  uni782B,  CJK UNIFIED IDEOGRAPH-782B
        0x7821, # G+7535  U+7821  uni7821,  CJK UNIFIED IDEOGRAPH-7821
        0x7829, # G+7536  U+7829  uni7829,  CJK UNIFIED IDEOGRAPH-7829
        0x7833, # G+7537  U+7833  uni7833,  CJK UNIFIED IDEOGRAPH-7833
        0x782A, # G+7538  U+782A  uni782A,  CJK UNIFIED IDEOGRAPH-782A
        0x7831, # G+7539  U+7831  uni7831,  CJK UNIFIED IDEOGRAPH-7831
        0x7954, # G+7540  U+7954  uni7954,  CJK UNIFIED IDEOGRAPH-7954
        0x795B, # G+7541  U+795B  uni795B,  CJK UNIFIED IDEOGRAPH-795B
        0x794F, # G+7542  U+794F  uni794F,  CJK UNIFIED IDEOGRAPH-794F
        0x795C, # G+7543  U+795C  uni795C,  CJK UNIFIED IDEOGRAPH-795C
        0x7953, # G+7544  U+7953  uni7953,  CJK UNIFIED IDEOGRAPH-7953
        0x7952, # G+7545  U+7952  uni7952,  CJK UNIFIED IDEOGRAPH-7952
        0x7951, # G+7546  U+7951  uni7951,  CJK UNIFIED IDEOGRAPH-7951
        0x79EB, # G+7547  U+79EB  uni79EB,  CJK UNIFIED IDEOGRAPH-79EB
        0x79EC, # G+7548  U+79EC  uni79EC,  CJK UNIFIED IDEOGRAPH-79EC
        0x79E0, # G+7549  U+79E0  uni79E0,  CJK UNIFIED IDEOGRAPH-79E0
        0x79EE, # G+7550  U+79EE  uni79EE,  CJK UNIFIED IDEOGRAPH-79EE
        0x79ED, # G+7551  U+79ED  uni79ED,  CJK UNIFIED IDEOGRAPH-79ED
        0x79EA, # G+7552  U+79EA  uni79EA,  CJK UNIFIED IDEOGRAPH-79EA
        0x79DC, # G+7553  U+79DC  uni79DC,  CJK UNIFIED IDEOGRAPH-79DC
        0x79DE, # G+7554  U+79DE  uni79DE,  CJK UNIFIED IDEOGRAPH-79DE
        0x79DD, # G+7555  U+79DD  uni79DD,  CJK UNIFIED IDEOGRAPH-79DD
        0x7A86, # G+7556  U+7A86  uni7A86,  CJK UNIFIED IDEOGRAPH-7A86
        0x7A89, # G+7557  U+7A89  uni7A89,  CJK UNIFIED IDEOGRAPH-7A89
        0x7A85, # G+7558  U+7A85  uni7A85,  CJK UNIFIED IDEOGRAPH-7A85
        0x7A8B, # G+7559  U+7A8B  uni7A8B,  CJK UNIFIED IDEOGRAPH-7A8B
        0x7A8C, # G+7560  U+7A8C  uni7A8C,  CJK UNIFIED IDEOGRAPH-7A8C
        0x7A8A, # G+7561  U+7A8A  uni7A8A,  CJK UNIFIED IDEOGRAPH-7A8A
        0x7A87, # G+7562  U+7A87  uni7A87,  CJK UNIFIED IDEOGRAPH-7A87
        0x7AD8, # G+7563  U+7AD8  uni7AD8,  CJK UNIFIED IDEOGRAPH-7AD8
        0x7B10, # G+7564  U+7B10  uni7B10,  CJK UNIFIED IDEOGRAPH-7B10
        0x7B04, # G+7565  U+7B04  uni7B04,  CJK UNIFIED IDEOGRAPH-7B04
        0x7B13, # G+7566  U+7B13  uni7B13,  CJK UNIFIED IDEOGRAPH-7B13
        0x7B05, # G+7567  U+7B05  uni7B05,  CJK UNIFIED IDEOGRAPH-7B05
        0x7B0F, # G+7568  U+7B0F  uni7B0F,  CJK UNIFIED IDEOGRAPH-7B0F
        0x7B08, # G+7569  U+7B08  uni7B08,  CJK UNIFIED IDEOGRAPH-7B08
        0x7B0A, # G+7570  U+7B0A  uni7B0A,  CJK UNIFIED IDEOGRAPH-7B0A
        0x7B0E, # G+7571  U+7B0E  uni7B0E,  CJK UNIFIED IDEOGRAPH-7B0E
        0x7B09, # G+7572  U+7B09  uni7B09,  CJK UNIFIED IDEOGRAPH-7B09
        0x7B12, # G+7573  U+7B12  uni7B12,  CJK UNIFIED IDEOGRAPH-7B12
        0x7C84, # G+7574  U+7C84  uni7C84,  CJK UNIFIED IDEOGRAPH-7C84
        0x7C91, # G+7575  U+7C91  uni7C91,  CJK UNIFIED IDEOGRAPH-7C91
        0x7C8A, # G+7576  U+7C8A  uni7C8A,  CJK UNIFIED IDEOGRAPH-7C8A
        0x7C8C, # G+7577  U+7C8C  uni7C8C,  CJK UNIFIED IDEOGRAPH-7C8C
        0x7C88, # G+7578  U+7C88  uni7C88,  CJK UNIFIED IDEOGRAPH-7C88
        0x7C8D, # G+7579  U+7C8D  uni7C8D,  CJK UNIFIED IDEOGRAPH-7C8D
        0x7C85, # G+7580  U+7C85  uni7C85,  CJK UNIFIED IDEOGRAPH-7C85
        0x7D1E, # G+7581  U+7D1E  uni7D1E,  CJK UNIFIED IDEOGRAPH-7D1E
        0x7D1D, # G+7582  U+7D1D  uni7D1D,  CJK UNIFIED IDEOGRAPH-7D1D
        0x7D11, # G+7583  U+7D11  uni7D11,  CJK UNIFIED IDEOGRAPH-7D11
        0x7D0E, # G+7584  U+7D0E  uni7D0E,  CJK UNIFIED IDEOGRAPH-7D0E
        0x7D18, # G+7585  U+7D18  uni7D18,  CJK UNIFIED IDEOGRAPH-7D18
        0x7D16, # G+7586  U+7D16  uni7D16,  CJK UNIFIED IDEOGRAPH-7D16
        0x7D13, # G+7587  U+7D13  uni7D13,  CJK UNIFIED IDEOGRAPH-7D13
        0x7D1F, # G+7588  U+7D1F  uni7D1F,  CJK UNIFIED IDEOGRAPH-7D1F
        0x7D12, # G+7589  U+7D12  uni7D12,  CJK UNIFIED IDEOGRAPH-7D12
        0x7D0F, # G+7590  U+7D0F  uni7D0F,  CJK UNIFIED IDEOGRAPH-7D0F
        0x7D0C, # G+7591  U+7D0C  uni7D0C,  CJK UNIFIED IDEOGRAPH-7D0C
        0x7F5C, # G+7592  U+7F5C  uni7F5C,  CJK UNIFIED IDEOGRAPH-7F5C
        0x7F61, # G+7593  U+7F61  uni7F61,  CJK UNIFIED IDEOGRAPH-7F61
        0x7F5E, # G+7594  U+7F5E  uni7F5E,  CJK UNIFIED IDEOGRAPH-7F5E
        0x7F60, # G+7595  U+7F60  uni7F60,  CJK UNIFIED IDEOGRAPH-7F60
        0x7F5D, # G+7596  U+7F5D  uni7F5D,  CJK UNIFIED IDEOGRAPH-7F5D
        0x7F5B, # G+7597  U+7F5B  uni7F5B,  CJK UNIFIED IDEOGRAPH-7F5B
        0x7F96, # G+7598  U+7F96  uni7F96,  CJK UNIFIED IDEOGRAPH-7F96
        0x7F92, # G+7599  U+7F92  uni7F92,  CJK UNIFIED IDEOGRAPH-7F92
        0x7FC3, # G+7600  U+7FC3  uni7FC3,  CJK UNIFIED IDEOGRAPH-7FC3
        0x7FC2, # G+7601  U+7FC2  uni7FC2,  CJK UNIFIED IDEOGRAPH-7FC2
        0x7FC0, # G+7602  U+7FC0  uni7FC0,  CJK UNIFIED IDEOGRAPH-7FC0
        0x8016, # G+7603  U+8016  uni8016,  CJK UNIFIED IDEOGRAPH-8016
        0x803E, # G+7604  U+803E  uni803E,  CJK UNIFIED IDEOGRAPH-803E
        0x8039, # G+7605  U+8039  uni8039,  CJK UNIFIED IDEOGRAPH-8039
        0x80FA, # G+7606  U+80FA  uni80FA,  CJK UNIFIED IDEOGRAPH-80FA
        0x80F2, # G+7607  U+80F2  uni80F2,  CJK UNIFIED IDEOGRAPH-80F2
        0x80F9, # G+7608  U+80F9  uni80F9,  CJK UNIFIED IDEOGRAPH-80F9
        0x80F5, # G+7609  U+80F5  uni80F5,  CJK UNIFIED IDEOGRAPH-80F5
        0x8101, # G+7610  U+8101  uni8101,  CJK UNIFIED IDEOGRAPH-8101
        0x80FB, # G+7611  U+80FB  uni80FB,  CJK UNIFIED IDEOGRAPH-80FB
        0x8100, # G+7612  U+8100  uni8100,  CJK UNIFIED IDEOGRAPH-8100
        0x8201, # G+7613  U+8201  uni8201,  CJK UNIFIED IDEOGRAPH-8201
        0x822F, # G+7614  U+822F  uni822F,  CJK UNIFIED IDEOGRAPH-822F
        0x8225, # G+7615  U+8225  uni8225,  CJK UNIFIED IDEOGRAPH-8225
        0x8333, # G+7616  U+8333  uni8333,  CJK UNIFIED IDEOGRAPH-8333
        0x832D, # G+7617  U+832D  uni832D,  CJK UNIFIED IDEOGRAPH-832D
        0x8344, # G+7618  U+8344  uni8344,  CJK UNIFIED IDEOGRAPH-8344
        0x8319, # G+7619  U+8319  uni8319,  CJK UNIFIED IDEOGRAPH-8319
        0x8351, # G+7620  U+8351  uni8351,  CJK UNIFIED IDEOGRAPH-8351
        0x8325, # G+7621  U+8325  uni8325,  CJK UNIFIED IDEOGRAPH-8325
        0x8356, # G+7622  U+8356  uni8356,  CJK UNIFIED IDEOGRAPH-8356
        0x833F, # G+7623  U+833F  uni833F,  CJK UNIFIED IDEOGRAPH-833F
        0x8341, # G+7624  U+8341  uni8341,  CJK UNIFIED IDEOGRAPH-8341
        0x8326, # G+7625  U+8326  uni8326,  CJK UNIFIED IDEOGRAPH-8326
        0x831C, # G+7626  U+831C  uni831C,  CJK UNIFIED IDEOGRAPH-831C
        0x8322, # G+7627  U+8322  uni8322,  CJK UNIFIED IDEOGRAPH-8322
        0x8342, # G+7628  U+8342  uni8342,  CJK UNIFIED IDEOGRAPH-8342
        0x834E, # G+7629  U+834E  uni834E,  CJK UNIFIED IDEOGRAPH-834E
        0x831B, # G+7630  U+831B  uni831B,  CJK UNIFIED IDEOGRAPH-831B
        0x832A, # G+7631  U+832A  uni832A,  CJK UNIFIED IDEOGRAPH-832A
        0x8308, # G+7632  U+8308  uni8308,  CJK UNIFIED IDEOGRAPH-8308
        0x833C, # G+7633  U+833C  uni833C,  CJK UNIFIED IDEOGRAPH-833C
        0x834D, # G+7634  U+834D  uni834D,  CJK UNIFIED IDEOGRAPH-834D
        0x8316, # G+7635  U+8316  uni8316,  CJK UNIFIED IDEOGRAPH-8316
        0x8324, # G+7636  U+8324  uni8324,  CJK UNIFIED IDEOGRAPH-8324
        0x8320, # G+7637  U+8320  uni8320,  CJK UNIFIED IDEOGRAPH-8320
        0x8337, # G+7638  U+8337  uni8337,  CJK UNIFIED IDEOGRAPH-8337
        0x832F, # G+7639  U+832F  uni832F,  CJK UNIFIED IDEOGRAPH-832F
        0x8329, # G+7640  U+8329  uni8329,  CJK UNIFIED IDEOGRAPH-8329
        0x8347, # G+7641  U+8347  uni8347,  CJK UNIFIED IDEOGRAPH-8347
        0x8345, # G+7642  U+8345  uni8345,  CJK UNIFIED IDEOGRAPH-8345
        0x834C, # G+7643  U+834C  uni834C,  CJK UNIFIED IDEOGRAPH-834C
        0x8353, # G+7644  U+8353  uni8353,  CJK UNIFIED IDEOGRAPH-8353
        0x831E, # G+7645  U+831E  uni831E,  CJK UNIFIED IDEOGRAPH-831E
        0x832C, # G+7646  U+832C  uni832C,  CJK UNIFIED IDEOGRAPH-832C
        0x834B, # G+7647  U+834B  uni834B,  CJK UNIFIED IDEOGRAPH-834B
        0x8327, # G+7648  U+8327  uni8327,  CJK UNIFIED IDEOGRAPH-8327
        0x8348, # G+7649  U+8348  uni8348,  CJK UNIFIED IDEOGRAPH-8348
        0x8653, # G+7650  U+8653  uni8653,  CJK UNIFIED IDEOGRAPH-8653
        0x8652, # G+7651  U+8652  uni8652,  CJK UNIFIED IDEOGRAPH-8652
        0x86A2, # G+7652  U+86A2  uni86A2,  CJK UNIFIED IDEOGRAPH-86A2
        0x86A8, # G+7653  U+86A8  uni86A8,  CJK UNIFIED IDEOGRAPH-86A8
        0x8696, # G+7654  U+8696  uni8696,  CJK UNIFIED IDEOGRAPH-8696
        0x868D, # G+7655  U+868D  uni868D,  CJK UNIFIED IDEOGRAPH-868D
        0x8691, # G+7656  U+8691  uni8691,  CJK UNIFIED IDEOGRAPH-8691
        0x869E, # G+7657  U+869E  uni869E,  CJK UNIFIED IDEOGRAPH-869E
        0x8687, # G+7658  U+8687  uni8687,  CJK UNIFIED IDEOGRAPH-8687
        0x8697, # G+7659  U+8697  uni8697,  CJK UNIFIED IDEOGRAPH-8697
        0x8686, # G+7660  U+8686  uni8686,  CJK UNIFIED IDEOGRAPH-8686
        0x868B, # G+7661  U+868B  uni868B,  CJK UNIFIED IDEOGRAPH-868B
        0x869A, # G+7662  U+869A  uni869A,  CJK UNIFIED IDEOGRAPH-869A
        0x8685, # G+7663  U+8685  uni8685,  CJK UNIFIED IDEOGRAPH-8685
        0x86A5, # G+7664  U+86A5  uni86A5,  CJK UNIFIED IDEOGRAPH-86A5
        0x8699, # G+7665  U+8699  uni8699,  CJK UNIFIED IDEOGRAPH-8699
        0x86A1, # G+7666  U+86A1  uni86A1,  CJK UNIFIED IDEOGRAPH-86A1
        0x86A7, # G+7667  U+86A7  uni86A7,  CJK UNIFIED IDEOGRAPH-86A7
        0x8695, # G+7668  U+8695  uni8695,  CJK UNIFIED IDEOGRAPH-8695
        0x8698, # G+7669  U+8698  uni8698,  CJK UNIFIED IDEOGRAPH-8698
        0x868E, # G+7670  U+868E  uni868E,  CJK UNIFIED IDEOGRAPH-868E
        0x869D, # G+7671  U+869D  uni869D,  CJK UNIFIED IDEOGRAPH-869D
        0x8690, # G+7672  U+8690  uni8690,  CJK UNIFIED IDEOGRAPH-8690
        0x8694, # G+7673  U+8694  uni8694,  CJK UNIFIED IDEOGRAPH-8694
        0x8843, # G+7674  U+8843  uni8843,  CJK UNIFIED IDEOGRAPH-8843
        0x8844, # G+7675  U+8844  uni8844,  CJK UNIFIED IDEOGRAPH-8844
        0x886D, # G+7676  U+886D  uni886D,  CJK UNIFIED IDEOGRAPH-886D
        0x8875, # G+7677  U+8875  uni8875,  CJK UNIFIED IDEOGRAPH-8875
        0x8876, # G+7678  U+8876  uni8876,  CJK UNIFIED IDEOGRAPH-8876
        0x8872, # G+7679  U+8872  uni8872,  CJK UNIFIED IDEOGRAPH-8872
        0x8880, # G+7680  U+8880  uni8880,  CJK UNIFIED IDEOGRAPH-8880
        0x8871, # G+7681  U+8871  uni8871,  CJK UNIFIED IDEOGRAPH-8871
        0x887F, # G+7682  U+887F  uni887F,  CJK UNIFIED IDEOGRAPH-887F
        0x886F, # G+7683  U+886F  uni886F,  CJK UNIFIED IDEOGRAPH-886F
        0x8883, # G+7684  U+8883  uni8883,  CJK UNIFIED IDEOGRAPH-8883
        0x887E, # G+7685  U+887E  uni887E,  CJK UNIFIED IDEOGRAPH-887E
        0x8874, # G+7686  U+8874  uni8874,  CJK UNIFIED IDEOGRAPH-8874
        0x887C, # G+7687  U+887C  uni887C,  CJK UNIFIED IDEOGRAPH-887C
        0x8A12, # G+7688  U+8A12  uni8A12,  CJK UNIFIED IDEOGRAPH-8A12
        0x8C47, # G+7689  U+8C47  uni8C47,  CJK UNIFIED IDEOGRAPH-8C47
        0x8C57, # G+7690  U+8C57  uni8C57,  CJK UNIFIED IDEOGRAPH-8C57
        0x8C7B, # G+7691  U+8C7B  uni8C7B,  CJK UNIFIED IDEOGRAPH-8C7B
        0x8CA4, # G+7692  U+8CA4  uni8CA4,  CJK UNIFIED IDEOGRAPH-8CA4
        0x8CA3, # G+7693  U+8CA3  uni8CA3,  CJK UNIFIED IDEOGRAPH-8CA3
        0x8D76, # G+7694  U+8D76  uni8D76,  CJK UNIFIED IDEOGRAPH-8D76
        0x8D78, # G+7695  U+8D78  uni8D78,  CJK UNIFIED IDEOGRAPH-8D78
        0x8DB5, # G+7696  U+8DB5  uni8DB5,  CJK UNIFIED IDEOGRAPH-8DB5
        0x8DB7, # G+7697  U+8DB7  uni8DB7,  CJK UNIFIED IDEOGRAPH-8DB7
        0x8DB6, # G+7698  U+8DB6  uni8DB6,  CJK UNIFIED IDEOGRAPH-8DB6
        0x8ED1, # G+7699  U+8ED1  uni8ED1,  CJK UNIFIED IDEOGRAPH-8ED1
        0x8ED3, # G+7700  U+8ED3  uni8ED3,  CJK UNIFIED IDEOGRAPH-8ED3
        0x8FFE, # G+7701  U+8FFE  uni8FFE,  CJK UNIFIED IDEOGRAPH-8FFE
        0x8FF5, # G+7702  U+8FF5  uni8FF5,  CJK UNIFIED IDEOGRAPH-8FF5
        0x9002, # G+7703  U+9002  uni9002,  CJK UNIFIED IDEOGRAPH-9002
        0x8FFF, # G+7704  U+8FFF  uni8FFF,  CJK UNIFIED IDEOGRAPH-8FFF
        0x8FFB, # G+7705  U+8FFB  uni8FFB,  CJK UNIFIED IDEOGRAPH-8FFB
        0x9004, # G+7706  U+9004  uni9004,  CJK UNIFIED IDEOGRAPH-9004
        0x8FFC, # G+7707  U+8FFC  uni8FFC,  CJK UNIFIED IDEOGRAPH-8FFC
        0x8FF6, # G+7708  U+8FF6  uni8FF6,  CJK UNIFIED IDEOGRAPH-8FF6
        0x90D6, # G+7709  U+90D6  uni90D6,  CJK UNIFIED IDEOGRAPH-90D6
        0x90E0, # G+7710  U+90E0  uni90E0,  CJK UNIFIED IDEOGRAPH-90E0
        0x90D9, # G+7711  U+90D9  uni90D9,  CJK UNIFIED IDEOGRAPH-90D9
        0x90DA, # G+7712  U+90DA  uni90DA,  CJK UNIFIED IDEOGRAPH-90DA
        0x90E3, # G+7713  U+90E3  uni90E3,  CJK UNIFIED IDEOGRAPH-90E3
        0x90DF, # G+7714  U+90DF  uni90DF,  CJK UNIFIED IDEOGRAPH-90DF
        0x90E5, # G+7715  U+90E5  uni90E5,  CJK UNIFIED IDEOGRAPH-90E5
        0x90D8, # G+7716  U+90D8  uni90D8,  CJK UNIFIED IDEOGRAPH-90D8
        0x90DB, # G+7717  U+90DB  uni90DB,  CJK UNIFIED IDEOGRAPH-90DB
        0x90D7, # G+7718  U+90D7  uni90D7,  CJK UNIFIED IDEOGRAPH-90D7
        0x90DC, # G+7719  U+90DC  uni90DC,  CJK UNIFIED IDEOGRAPH-90DC
        0x90E4, # G+7720  U+90E4  uni90E4,  CJK UNIFIED IDEOGRAPH-90E4
        0x9150, # G+7721  U+9150  uni9150,  CJK UNIFIED IDEOGRAPH-9150
        0x914E, # G+7722  U+914E  uni914E,  CJK UNIFIED IDEOGRAPH-914E
        0x914F, # G+7723  U+914F  uni914F,  CJK UNIFIED IDEOGRAPH-914F
        0x91D5, # G+7724  U+91D5  uni91D5,  CJK UNIFIED IDEOGRAPH-91D5
        0x91E2, # G+7725  U+91E2  uni91E2,  CJK UNIFIED IDEOGRAPH-91E2
        0x91DA, # G+7726  U+91DA  uni91DA,  CJK UNIFIED IDEOGRAPH-91DA
        0x965C, # G+7727  U+965C  uni965C,  CJK UNIFIED IDEOGRAPH-965C
        0x965F, # G+7728  U+965F  uni965F,  CJK UNIFIED IDEOGRAPH-965F
        0x96BC, # G+7729  U+96BC  uni96BC,  CJK UNIFIED IDEOGRAPH-96BC
        0x98E3, # G+7730  U+98E3  uni98E3,  CJK UNIFIED IDEOGRAPH-98E3
        0x2FBD, # G+7731  U+2FBD  uni2FBD,  KANGXI RADICAL HAIR
        0x2FBF, # G+7732  U+2FBF  uni2FBF,  KANGXI RADICAL SACRIFICIAL WINE
        0x4E7F, # G+7733  U+4E7F  uni4E7F,  CJK UNIFIED IDEOGRAPH-4E7F
        0x5070, # G+7734  U+5070  uni5070,  CJK UNIFIED IDEOGRAPH-5070
        0x506A, # G+7735  U+506A  uni506A,  CJK UNIFIED IDEOGRAPH-506A
        0x5061, # G+7736  U+5061  uni5061,  CJK UNIFIED IDEOGRAPH-5061
        0x505E, # G+7737  U+505E  uni505E,  CJK UNIFIED IDEOGRAPH-505E
        0x5060, # G+7738  U+5060  uni5060,  CJK UNIFIED IDEOGRAPH-5060
        0x5053, # G+7739  U+5053  uni5053,  CJK UNIFIED IDEOGRAPH-5053
        0x504B, # G+7740  U+504B  uni504B,  CJK UNIFIED IDEOGRAPH-504B
        0x505D, # G+7741  U+505D  uni505D,  CJK UNIFIED IDEOGRAPH-505D
        0x5072, # G+7742  U+5072  uni5072,  CJK UNIFIED IDEOGRAPH-5072
        0x5048, # G+7743  U+5048  uni5048,  CJK UNIFIED IDEOGRAPH-5048
        0x504D, # G+7744  U+504D  uni504D,  CJK UNIFIED IDEOGRAPH-504D
        0x5041, # G+7745  U+5041  uni5041,  CJK UNIFIED IDEOGRAPH-5041
        0x505B, # G+7746  U+505B  uni505B,  CJK UNIFIED IDEOGRAPH-505B
        0x504A, # G+7747  U+504A  uni504A,  CJK UNIFIED IDEOGRAPH-504A
        0x5062, # G+7748  U+5062  uni5062,  CJK UNIFIED IDEOGRAPH-5062
        0x5015, # G+7749  U+5015  uni5015,  CJK UNIFIED IDEOGRAPH-5015
        0x5045, # G+7750  U+5045  uni5045,  CJK UNIFIED IDEOGRAPH-5045
        0x505F, # G+7751  U+505F  uni505F,  CJK UNIFIED IDEOGRAPH-505F
        0x5069, # G+7752  U+5069  uni5069,  CJK UNIFIED IDEOGRAPH-5069
        0x506B, # G+7753  U+506B  uni506B,  CJK UNIFIED IDEOGRAPH-506B
        0x5063, # G+7754  U+5063  uni5063,  CJK UNIFIED IDEOGRAPH-5063
        0x5064, # G+7755  U+5064  uni5064,  CJK UNIFIED IDEOGRAPH-5064
        0x5046, # G+7756  U+5046  uni5046,  CJK UNIFIED IDEOGRAPH-5046
        0x5040, # G+7757  U+5040  uni5040,  CJK UNIFIED IDEOGRAPH-5040
        0x506E, # G+7758  U+506E  uni506E,  CJK UNIFIED IDEOGRAPH-506E
        0x5073, # G+7759  U+5073  uni5073,  CJK UNIFIED IDEOGRAPH-5073
        0x5057, # G+7760  U+5057  uni5057,  CJK UNIFIED IDEOGRAPH-5057
        0x5051, # G+7761  U+5051  uni5051,  CJK UNIFIED IDEOGRAPH-5051
        0x51D0, # G+7762  U+51D0  uni51D0,  CJK UNIFIED IDEOGRAPH-51D0
        0x526B, # G+7763  U+526B  uni526B,  CJK UNIFIED IDEOGRAPH-526B
        0x526D, # G+7764  U+526D  uni526D,  CJK UNIFIED IDEOGRAPH-526D
        0x526C, # G+7765  U+526C  uni526C,  CJK UNIFIED IDEOGRAPH-526C
        0x526E, # G+7766  U+526E  uni526E,  CJK UNIFIED IDEOGRAPH-526E
        0x52D6, # G+7767  U+52D6  uni52D6,  CJK UNIFIED IDEOGRAPH-52D6
        0x52D3, # G+7768  U+52D3  uni52D3,  CJK UNIFIED IDEOGRAPH-52D3
        0x532D, # G+7769  U+532D  uni532D,  CJK UNIFIED IDEOGRAPH-532D
        0x539C, # G+7770  U+539C  uni539C,  CJK UNIFIED IDEOGRAPH-539C
        0x5575, # G+7771  U+5575  uni5575,  CJK UNIFIED IDEOGRAPH-5575
        0x5576, # G+7772  U+5576  uni5576,  CJK UNIFIED IDEOGRAPH-5576
        0x553C, # G+7773  U+553C  uni553C,  CJK UNIFIED IDEOGRAPH-553C
        0x554D, # G+7774  U+554D  uni554D,  CJK UNIFIED IDEOGRAPH-554D
        0x5550, # G+7775  U+5550  uni5550,  CJK UNIFIED IDEOGRAPH-5550
        0x5534, # G+7776  U+5534  uni5534,  CJK UNIFIED IDEOGRAPH-5534
        0x552A, # G+7777  U+552A  uni552A,  CJK UNIFIED IDEOGRAPH-552A
        0x5551, # G+7778  U+5551  uni5551,  CJK UNIFIED IDEOGRAPH-5551
        0x5562, # G+7779  U+5562  uni5562,  CJK UNIFIED IDEOGRAPH-5562
        0x5536, # G+7780  U+5536  uni5536,  CJK UNIFIED IDEOGRAPH-5536
        0x5535, # G+7781  U+5535  uni5535,  CJK UNIFIED IDEOGRAPH-5535
        0x5530, # G+7782  U+5530  uni5530,  CJK UNIFIED IDEOGRAPH-5530
        0x5552, # G+7783  U+5552  uni5552,  CJK UNIFIED IDEOGRAPH-5552
        0x5545, # G+7784  U+5545  uni5545,  CJK UNIFIED IDEOGRAPH-5545
        0x550C, # G+7785  U+550C  uni550C,  CJK UNIFIED IDEOGRAPH-550C
        0x5532, # G+7786  U+5532  uni5532,  CJK UNIFIED IDEOGRAPH-5532
        0x5565, # G+7787  U+5565  uni5565,  CJK UNIFIED IDEOGRAPH-5565
        0x554E, # G+7788  U+554E  uni554E,  CJK UNIFIED IDEOGRAPH-554E
        0x5539, # G+7789  U+5539  uni5539,  CJK UNIFIED IDEOGRAPH-5539
        0x5548, # G+7790  U+5548  uni5548,  CJK UNIFIED IDEOGRAPH-5548
        0x552D, # G+7791  U+552D  uni552D,  CJK UNIFIED IDEOGRAPH-552D
        0x553B, # G+7792  U+553B  uni553B,  CJK UNIFIED IDEOGRAPH-553B
        0x5540, # G+7793  U+5540  uni5540,  CJK UNIFIED IDEOGRAPH-5540
        0x554B, # G+7794  U+554B  uni554B,  CJK UNIFIED IDEOGRAPH-554B
        0x570A, # G+7795  U+570A  uni570A,  CJK UNIFIED IDEOGRAPH-570A
        0x5707, # G+7796  U+5707  uni5707,  CJK UNIFIED IDEOGRAPH-5707
        0x57FB, # G+7797  U+57FB  uni57FB,  CJK UNIFIED IDEOGRAPH-57FB
        0x5814, # G+7798  U+5814  uni5814,  CJK UNIFIED IDEOGRAPH-5814
        0x57E2, # G+7799  U+57E2  uni57E2,  CJK UNIFIED IDEOGRAPH-57E2
        0x57F6, # G+7800  U+57F6  uni57F6,  CJK UNIFIED IDEOGRAPH-57F6
        0x57DC, # G+7801  U+57DC  uni57DC,  CJK UNIFIED IDEOGRAPH-57DC
        0x57F4, # G+7802  U+57F4  uni57F4,  CJK UNIFIED IDEOGRAPH-57F4
        0x5800, # G+7803  U+5800  uni5800,  CJK UNIFIED IDEOGRAPH-5800
        0x57ED, # G+7804  U+57ED  uni57ED,  CJK UNIFIED IDEOGRAPH-57ED
        0x57FD, # G+7805  U+57FD  uni57FD,  CJK UNIFIED IDEOGRAPH-57FD
        0x5808, # G+7806  U+5808  uni5808,  CJK UNIFIED IDEOGRAPH-5808
        0x57F8, # G+7807  U+57F8  uni57F8,  CJK UNIFIED IDEOGRAPH-57F8
        0x580B, # G+7808  U+580B  uni580B,  CJK UNIFIED IDEOGRAPH-580B
        0x57F3, # G+7809  U+57F3  uni57F3,  CJK UNIFIED IDEOGRAPH-57F3
        0x57CF, # G+7810  U+57CF  uni57CF,  CJK UNIFIED IDEOGRAPH-57CF
        0x5807, # G+7811  U+5807  uni5807,  CJK UNIFIED IDEOGRAPH-5807
        0x57EE, # G+7812  U+57EE  uni57EE,  CJK UNIFIED IDEOGRAPH-57EE
        0x57E3, # G+7813  U+57E3  uni57E3,  CJK UNIFIED IDEOGRAPH-57E3
        0x57F2, # G+7814  U+57F2  uni57F2,  CJK UNIFIED IDEOGRAPH-57F2
        0x57E5, # G+7815  U+57E5  uni57E5,  CJK UNIFIED IDEOGRAPH-57E5
        0x57EC, # G+7816  U+57EC  uni57EC,  CJK UNIFIED IDEOGRAPH-57EC
        0x57E1, # G+7817  U+57E1  uni57E1,  CJK UNIFIED IDEOGRAPH-57E1
        0x580E, # G+7818  U+580E  uni580E,  CJK UNIFIED IDEOGRAPH-580E
        0x57FC, # G+7819  U+57FC  uni57FC,  CJK UNIFIED IDEOGRAPH-57FC
        0x5810, # G+7820  U+5810  uni5810,  CJK UNIFIED IDEOGRAPH-5810
        0x57E7, # G+7821  U+57E7  uni57E7,  CJK UNIFIED IDEOGRAPH-57E7
        0x5801, # G+7822  U+5801  uni5801,  CJK UNIFIED IDEOGRAPH-5801
        0x580C, # G+7823  U+580C  uni580C,  CJK UNIFIED IDEOGRAPH-580C
        0x57F1, # G+7824  U+57F1  uni57F1,  CJK UNIFIED IDEOGRAPH-57F1
        0x57E9, # G+7825  U+57E9  uni57E9,  CJK UNIFIED IDEOGRAPH-57E9
        0x57F0, # G+7826  U+57F0  uni57F0,  CJK UNIFIED IDEOGRAPH-57F0
        0x580D, # G+7827  U+580D  uni580D,  CJK UNIFIED IDEOGRAPH-580D
        0x5804, # G+7828  U+5804  uni5804,  CJK UNIFIED IDEOGRAPH-5804
        0x595C, # G+7829  U+595C  uni595C,  CJK UNIFIED IDEOGRAPH-595C
        0x5A60, # G+7830  U+5A60  uni5A60,  CJK UNIFIED IDEOGRAPH-5A60
        0x5A58, # G+7831  U+5A58  uni5A58,  CJK UNIFIED IDEOGRAPH-5A58
        0x5A55, # G+7832  U+5A55  uni5A55,  CJK UNIFIED IDEOGRAPH-5A55
        0x5A67, # G+7833  U+5A67  uni5A67,  CJK UNIFIED IDEOGRAPH-5A67
        0x5A5E, # G+7834  U+5A5E  uni5A5E,  CJK UNIFIED IDEOGRAPH-5A5E
        0x5A38, # G+7835  U+5A38  uni5A38,  CJK UNIFIED IDEOGRAPH-5A38
        0x5A35, # G+7836  U+5A35  uni5A35,  CJK UNIFIED IDEOGRAPH-5A35
        0x5A6D, # G+7837  U+5A6D  uni5A6D,  CJK UNIFIED IDEOGRAPH-5A6D
        0x5A50, # G+7838  U+5A50  uni5A50,  CJK UNIFIED IDEOGRAPH-5A50
        0x5A5F, # G+7839  U+5A5F  uni5A5F,  CJK UNIFIED IDEOGRAPH-5A5F
        0x5A65, # G+7840  U+5A65  uni5A65,  CJK UNIFIED IDEOGRAPH-5A65
        0x5A6C, # G+7841  U+5A6C  uni5A6C,  CJK UNIFIED IDEOGRAPH-5A6C
        0x5A53, # G+7842  U+5A53  uni5A53,  CJK UNIFIED IDEOGRAPH-5A53
        0x5A64, # G+7843  U+5A64  uni5A64,  CJK UNIFIED IDEOGRAPH-5A64
        0x5A57, # G+7844  U+5A57  uni5A57,  CJK UNIFIED IDEOGRAPH-5A57
        0x5A43, # G+7845  U+5A43  uni5A43,  CJK UNIFIED IDEOGRAPH-5A43
        0x5A5D, # G+7846  U+5A5D  uni5A5D,  CJK UNIFIED IDEOGRAPH-5A5D
        0x5A52, # G+7847  U+5A52  uni5A52,  CJK UNIFIED IDEOGRAPH-5A52
        0x5A44, # G+7848  U+5A44  uni5A44,  CJK UNIFIED IDEOGRAPH-5A44
        0x5A5B, # G+7849  U+5A5B  uni5A5B,  CJK UNIFIED IDEOGRAPH-5A5B
        0x5A48, # G+7850  U+5A48  uni5A48,  CJK UNIFIED IDEOGRAPH-5A48
        0x5A8E, # G+7851  U+5A8E  uni5A8E,  CJK UNIFIED IDEOGRAPH-5A8E
        0x5A3E, # G+7852  U+5A3E  uni5A3E,  CJK UNIFIED IDEOGRAPH-5A3E
        0x5A4D, # G+7853  U+5A4D  uni5A4D,  CJK UNIFIED IDEOGRAPH-5A4D
        0x5A39, # G+7854  U+5A39  uni5A39,  CJK UNIFIED IDEOGRAPH-5A39
        0x5A4C, # G+7855  U+5A4C  uni5A4C,  CJK UNIFIED IDEOGRAPH-5A4C
        0x5A70, # G+7856  U+5A70  uni5A70,  CJK UNIFIED IDEOGRAPH-5A70
        0x5A69, # G+7857  U+5A69  uni5A69,  CJK UNIFIED IDEOGRAPH-5A69
        0x5A47, # G+7858  U+5A47  uni5A47,  CJK UNIFIED IDEOGRAPH-5A47
        0x5A51, # G+7859  U+5A51  uni5A51,  CJK UNIFIED IDEOGRAPH-5A51
        0x5A56, # G+7860  U+5A56  uni5A56,  CJK UNIFIED IDEOGRAPH-5A56
        0x5A42, # G+7861  U+5A42  uni5A42,  CJK UNIFIED IDEOGRAPH-5A42
        0x5A5C, # G+7862  U+5A5C  uni5A5C,  CJK UNIFIED IDEOGRAPH-5A5C
        0x5B72, # G+7863  U+5B72  uni5B72,  CJK UNIFIED IDEOGRAPH-5B72
        0x5B6E, # G+7864  U+5B6E  uni5B6E,  CJK UNIFIED IDEOGRAPH-5B6E
        0x5BC1, # G+7865  U+5BC1  uni5BC1,  CJK UNIFIED IDEOGRAPH-5BC1
        0x5BC0, # G+7866  U+5BC0  uni5BC0,  CJK UNIFIED IDEOGRAPH-5BC0
        0x5C59, # G+7867  U+5C59  uni5C59,  CJK UNIFIED IDEOGRAPH-5C59
        0x5D1E, # G+7868  U+5D1E  uni5D1E,  CJK UNIFIED IDEOGRAPH-5D1E
        0x5D0B, # G+7869  U+5D0B  uni5D0B,  CJK UNIFIED IDEOGRAPH-5D0B
        0x5D1D, # G+7870  U+5D1D  uni5D1D,  CJK UNIFIED IDEOGRAPH-5D1D
        0x5D1A, # G+7871  U+5D1A  uni5D1A,  CJK UNIFIED IDEOGRAPH-5D1A
        0x5D20, # G+7872  U+5D20  uni5D20,  CJK UNIFIED IDEOGRAPH-5D20
        0x5D0C, # G+7873  U+5D0C  uni5D0C,  CJK UNIFIED IDEOGRAPH-5D0C
        0x5D28, # G+7874  U+5D28  uni5D28,  CJK UNIFIED IDEOGRAPH-5D28
        0x5D0D, # G+7875  U+5D0D  uni5D0D,  CJK UNIFIED IDEOGRAPH-5D0D
        0x5D26, # G+7876  U+5D26  uni5D26,  CJK UNIFIED IDEOGRAPH-5D26
        0x5D25, # G+7877  U+5D25  uni5D25,  CJK UNIFIED IDEOGRAPH-5D25
        0x5D0F, # G+7878  U+5D0F  uni5D0F,  CJK UNIFIED IDEOGRAPH-5D0F
        0x5D30, # G+7879  U+5D30  uni5D30,  CJK UNIFIED IDEOGRAPH-5D30
        0x5D12, # G+7880  U+5D12  uni5D12,  CJK UNIFIED IDEOGRAPH-5D12
        0x5D23, # G+7881  U+5D23  uni5D23,  CJK UNIFIED IDEOGRAPH-5D23
        0x5D1F, # G+7882  U+5D1F  uni5D1F,  CJK UNIFIED IDEOGRAPH-5D1F
        0x5D2E, # G+7883  U+5D2E  uni5D2E,  CJK UNIFIED IDEOGRAPH-5D2E
        0x5E3E, # G+7884  U+5E3E  uni5E3E,  CJK UNIFIED IDEOGRAPH-5E3E
        0x5E34, # G+7885  U+5E34  uni5E34,  CJK UNIFIED IDEOGRAPH-5E34
        0x5EB1, # G+7886  U+5EB1  uni5EB1,  CJK UNIFIED IDEOGRAPH-5EB1
        0x5EB4, # G+7887  U+5EB4  uni5EB4,  CJK UNIFIED IDEOGRAPH-5EB4
        0x5EB9, # G+7888  U+5EB9  uni5EB9,  CJK UNIFIED IDEOGRAPH-5EB9
        0x5EB2, # G+7889  U+5EB2  uni5EB2,  CJK UNIFIED IDEOGRAPH-5EB2
        0x5EB3, # G+7890  U+5EB3  uni5EB3,  CJK UNIFIED IDEOGRAPH-5EB3
        0x5F36, # G+7891  U+5F36  uni5F36,  CJK UNIFIED IDEOGRAPH-5F36
        0x5F38, # G+7892  U+5F38  uni5F38,  CJK UNIFIED IDEOGRAPH-5F38
        0x5F9B, # G+7893  U+5F9B  uni5F9B,  CJK UNIFIED IDEOGRAPH-5F9B
        0x5F96, # G+7894  U+5F96  uni5F96,  CJK UNIFIED IDEOGRAPH-5F96
        0x5F9F, # G+7895  U+5F9F  uni5F9F,  CJK UNIFIED IDEOGRAPH-5F9F
        0x608A, # G+7896  U+608A  uni608A,  CJK UNIFIED IDEOGRAPH-608A
        0x6090, # G+7897  U+6090  uni6090,  CJK UNIFIED IDEOGRAPH-6090
        0x6086, # G+7898  U+6086  uni6086,  CJK UNIFIED IDEOGRAPH-6086
        0x60BE, # G+7899  U+60BE  uni60BE,  CJK UNIFIED IDEOGRAPH-60BE
        0x60B0, # G+7900  U+60B0  uni60B0,  CJK UNIFIED IDEOGRAPH-60B0
        0x60BA, # G+7901  U+60BA  uni60BA,  CJK UNIFIED IDEOGRAPH-60BA
        0x60D3, # G+7902  U+60D3  uni60D3,  CJK UNIFIED IDEOGRAPH-60D3
        0x60D4, # G+7903  U+60D4  uni60D4,  CJK UNIFIED IDEOGRAPH-60D4
        0x60CF, # G+7904  U+60CF  uni60CF,  CJK UNIFIED IDEOGRAPH-60CF
        0x60E4, # G+7905  U+60E4  uni60E4,  CJK UNIFIED IDEOGRAPH-60E4
        0x60D9, # G+7906  U+60D9  uni60D9,  CJK UNIFIED IDEOGRAPH-60D9
        0x60DD, # G+7907  U+60DD  uni60DD,  CJK UNIFIED IDEOGRAPH-60DD
        0x60C8, # G+7908  U+60C8  uni60C8,  CJK UNIFIED IDEOGRAPH-60C8
        0x60B1, # G+7909  U+60B1  uni60B1,  CJK UNIFIED IDEOGRAPH-60B1
        0x60DB, # G+7910  U+60DB  uni60DB,  CJK UNIFIED IDEOGRAPH-60DB
        0x60B7, # G+7911  U+60B7  uni60B7,  CJK UNIFIED IDEOGRAPH-60B7
        0x60CA, # G+7912  U+60CA  uni60CA,  CJK UNIFIED IDEOGRAPH-60CA
        0x60BF, # G+7913  U+60BF  uni60BF,  CJK UNIFIED IDEOGRAPH-60BF
        0x60C3, # G+7914  U+60C3  uni60C3,  CJK UNIFIED IDEOGRAPH-60C3
        0x60CD, # G+7915  U+60CD  uni60CD,  CJK UNIFIED IDEOGRAPH-60CD
        0x60C0, # G+7916  U+60C0  uni60C0,  CJK UNIFIED IDEOGRAPH-60C0
        0x6332, # G+7917  U+6332  uni6332,  CJK UNIFIED IDEOGRAPH-6332
        0x6365, # G+7918  U+6365  uni6365,  CJK UNIFIED IDEOGRAPH-6365
        0x638A, # G+7919  U+638A  uni638A,  CJK UNIFIED IDEOGRAPH-638A
        0x6382, # G+7920  U+6382  uni6382,  CJK UNIFIED IDEOGRAPH-6382
        0x637D, # G+7921  U+637D  uni637D,  CJK UNIFIED IDEOGRAPH-637D
        0x63BD, # G+7922  U+63BD  uni63BD,  CJK UNIFIED IDEOGRAPH-63BD
        0x639E, # G+7923  U+639E  uni639E,  CJK UNIFIED IDEOGRAPH-639E
        0x63AD, # G+7924  U+63AD  uni63AD,  CJK UNIFIED IDEOGRAPH-63AD
        0x639D, # G+7925  U+639D  uni639D,  CJK UNIFIED IDEOGRAPH-639D
        0x6397, # G+7926  U+6397  uni6397,  CJK UNIFIED IDEOGRAPH-6397
        0x63AB, # G+7927  U+63AB  uni63AB,  CJK UNIFIED IDEOGRAPH-63AB
        0x638E, # G+7928  U+638E  uni638E,  CJK UNIFIED IDEOGRAPH-638E
        0x636F, # G+7929  U+636F  uni636F,  CJK UNIFIED IDEOGRAPH-636F
        0x6387, # G+7930  U+6387  uni6387,  CJK UNIFIED IDEOGRAPH-6387
        0x6390, # G+7931  U+6390  uni6390,  CJK UNIFIED IDEOGRAPH-6390
        0x636E, # G+7932  U+636E  uni636E,  CJK UNIFIED IDEOGRAPH-636E
        0x63AF, # G+7933  U+63AF  uni63AF,  CJK UNIFIED IDEOGRAPH-63AF
        0x6375, # G+7934  U+6375  uni6375,  CJK UNIFIED IDEOGRAPH-6375
        0x639C, # G+7935  U+639C  uni639C,  CJK UNIFIED IDEOGRAPH-639C
        0x636D, # G+7936  U+636D  uni636D,  CJK UNIFIED IDEOGRAPH-636D
        0x63AE, # G+7937  U+63AE  uni63AE,  CJK UNIFIED IDEOGRAPH-63AE
        0x637C, # G+7938  U+637C  uni637C,  CJK UNIFIED IDEOGRAPH-637C
        0x63A4, # G+7939  U+63A4  uni63A4,  CJK UNIFIED IDEOGRAPH-63A4
        0x633B, # G+7940  U+633B  uni633B,  CJK UNIFIED IDEOGRAPH-633B
        0x639F, # G+7941  U+639F  uni639F,  CJK UNIFIED IDEOGRAPH-639F
        0x6378, # G+7942  U+6378  uni6378,  CJK UNIFIED IDEOGRAPH-6378
        0x6385, # G+7943  U+6385  uni6385,  CJK UNIFIED IDEOGRAPH-6385
        0x6381, # G+7944  U+6381  uni6381,  CJK UNIFIED IDEOGRAPH-6381
        0x6391, # G+7945  U+6391  uni6391,  CJK UNIFIED IDEOGRAPH-6391
        0x638D, # G+7946  U+638D  uni638D,  CJK UNIFIED IDEOGRAPH-638D
        0x6370, # G+7947  U+6370  uni6370,  CJK UNIFIED IDEOGRAPH-6370
        0x6553, # G+7948  U+6553  uni6553,  CJK UNIFIED IDEOGRAPH-6553
        0x65CD, # G+7949  U+65CD  uni65CD,  CJK UNIFIED IDEOGRAPH-65CD
        0x6665, # G+7950  U+6665  uni6665,  CJK UNIFIED IDEOGRAPH-6665
        0x6661, # G+7951  U+6661  uni6661,  CJK UNIFIED IDEOGRAPH-6661
        0x665B, # G+7952  U+665B  uni665B,  CJK UNIFIED IDEOGRAPH-665B
        0x6659, # G+7953  U+6659  uni6659,  CJK UNIFIED IDEOGRAPH-6659
        0x665C, # G+7954  U+665C  uni665C,  CJK UNIFIED IDEOGRAPH-665C
        0x6662, # G+7955  U+6662  uni6662,  CJK UNIFIED IDEOGRAPH-6662
        0x6718, # G+7956  U+6718  uni6718,  CJK UNIFIED IDEOGRAPH-6718
        0x6879, # G+7957  U+6879  uni6879,  CJK UNIFIED IDEOGRAPH-6879
        0x6887, # G+7958  U+6887  uni6887,  CJK UNIFIED IDEOGRAPH-6887
        0x6890, # G+7959  U+6890  uni6890,  CJK UNIFIED IDEOGRAPH-6890
        0x689C, # G+7960  U+689C  uni689C,  CJK UNIFIED IDEOGRAPH-689C
        0x686D, # G+7961  U+686D  uni686D,  CJK UNIFIED IDEOGRAPH-686D
        0x686E, # G+7962  U+686E  uni686E,  CJK UNIFIED IDEOGRAPH-686E
        0x68AE, # G+7963  U+68AE  uni68AE,  CJK UNIFIED IDEOGRAPH-68AE
        0x68AB, # G+7964  U+68AB  uni68AB,  CJK UNIFIED IDEOGRAPH-68AB
        0x6956, # G+7965  U+6956  uni6956,  CJK UNIFIED IDEOGRAPH-6956
        0x686F, # G+7966  U+686F  uni686F,  CJK UNIFIED IDEOGRAPH-686F
        0x68A3, # G+7967  U+68A3  uni68A3,  CJK UNIFIED IDEOGRAPH-68A3
        0x68AC, # G+7968  U+68AC  uni68AC,  CJK UNIFIED IDEOGRAPH-68AC
        0x68A9, # G+7969  U+68A9  uni68A9,  CJK UNIFIED IDEOGRAPH-68A9
        0x6875, # G+7970  U+6875  uni6875,  CJK UNIFIED IDEOGRAPH-6875
        0x6874, # G+7971  U+6874  uni6874,  CJK UNIFIED IDEOGRAPH-6874
        0x68B2, # G+7972  U+68B2  uni68B2,  CJK UNIFIED IDEOGRAPH-68B2
        0x688F, # G+7973  U+688F  uni688F,  CJK UNIFIED IDEOGRAPH-688F
        0x6877, # G+7974  U+6877  uni6877,  CJK UNIFIED IDEOGRAPH-6877
        0x6892, # G+7975  U+6892  uni6892,  CJK UNIFIED IDEOGRAPH-6892
        0x687C, # G+7976  U+687C  uni687C,  CJK UNIFIED IDEOGRAPH-687C
        0x686B, # G+7977  U+686B  uni686B,  CJK UNIFIED IDEOGRAPH-686B
        0x6872, # G+7978  U+6872  uni6872,  CJK UNIFIED IDEOGRAPH-6872
        0x68AA, # G+7979  U+68AA  uni68AA,  CJK UNIFIED IDEOGRAPH-68AA
        0x6880, # G+7980  U+6880  uni6880,  CJK UNIFIED IDEOGRAPH-6880
        0x6871, # G+7981  U+6871  uni6871,  CJK UNIFIED IDEOGRAPH-6871
        0x687E, # G+7982  U+687E  uni687E,  CJK UNIFIED IDEOGRAPH-687E
        0x689B, # G+7983  U+689B  uni689B,  CJK UNIFIED IDEOGRAPH-689B
        0x6896, # G+7984  U+6896  uni6896,  CJK UNIFIED IDEOGRAPH-6896
        0x688B, # G+7985  U+688B  uni688B,  CJK UNIFIED IDEOGRAPH-688B
        0x68A0, # G+7986  U+68A0  uni68A0,  CJK UNIFIED IDEOGRAPH-68A0
        0x6889, # G+7987  U+6889  uni6889,  CJK UNIFIED IDEOGRAPH-6889
        0x68A4, # G+7988  U+68A4  uni68A4,  CJK UNIFIED IDEOGRAPH-68A4
        0x6878, # G+7989  U+6878  uni6878,  CJK UNIFIED IDEOGRAPH-6878
        0x687B, # G+7990  U+687B  uni687B,  CJK UNIFIED IDEOGRAPH-687B
        0x6891, # G+7991  U+6891  uni6891,  CJK UNIFIED IDEOGRAPH-6891
        0x688C, # G+7992  U+688C  uni688C,  CJK UNIFIED IDEOGRAPH-688C
        0x688A, # G+7993  U+688A  uni688A,  CJK UNIFIED IDEOGRAPH-688A
        0x687D, # G+7994  U+687D  uni687D,  CJK UNIFIED IDEOGRAPH-687D
        0x6B36, # G+7995  U+6B36  uni6B36,  CJK UNIFIED IDEOGRAPH-6B36
        0x6B33, # G+7996  U+6B33  uni6B33,  CJK UNIFIED IDEOGRAPH-6B33
        0x6B37, # G+7997  U+6B37  uni6B37,  CJK UNIFIED IDEOGRAPH-6B37
        0x6B38, # G+7998  U+6B38  uni6B38,  CJK UNIFIED IDEOGRAPH-6B38
        0x6B91, # G+7999  U+6B91  uni6B91,  CJK UNIFIED IDEOGRAPH-6B91
        0x6B8F, # G+8000  U+6B8F  uni6B8F,  CJK UNIFIED IDEOGRAPH-6B8F
        0x6B8D, # G+8001  U+6B8D  uni6B8D,  CJK UNIFIED IDEOGRAPH-6B8D
        0x6B8E, # G+8002  U+6B8E  uni6B8E,  CJK UNIFIED IDEOGRAPH-6B8E
        0x6B8C, # G+8003  U+6B8C  uni6B8C,  CJK UNIFIED IDEOGRAPH-6B8C
        0x6C2A, # G+8004  U+6C2A  uni6C2A,  CJK UNIFIED IDEOGRAPH-6C2A
        0x6DC0, # G+8005  U+6DC0  uni6DC0,  CJK UNIFIED IDEOGRAPH-6DC0
        0x6DAB, # G+8006  U+6DAB  uni6DAB,  CJK UNIFIED IDEOGRAPH-6DAB
        0x6DB4, # G+8007  U+6DB4  uni6DB4,  CJK UNIFIED IDEOGRAPH-6DB4
        0x6DB3, # G+8008  U+6DB3  uni6DB3,  CJK UNIFIED IDEOGRAPH-6DB3
        0x6E74, # G+8009  U+6E74  uni6E74,  CJK UNIFIED IDEOGRAPH-6E74
        0x6DAC, # G+8010  U+6DAC  uni6DAC,  CJK UNIFIED IDEOGRAPH-6DAC
        0x6DE9, # G+8011  U+6DE9  uni6DE9,  CJK UNIFIED IDEOGRAPH-6DE9
        0x6DE2, # G+8012  U+6DE2  uni6DE2,  CJK UNIFIED IDEOGRAPH-6DE2
        0x6DB7, # G+8013  U+6DB7  uni6DB7,  CJK UNIFIED IDEOGRAPH-6DB7
        0x6DF6, # G+8014  U+6DF6  uni6DF6,  CJK UNIFIED IDEOGRAPH-6DF6
        0x6DD4, # G+8015  U+6DD4  uni6DD4,  CJK UNIFIED IDEOGRAPH-6DD4
        0x6E00, # G+8016  U+6E00  uni6E00,  CJK UNIFIED IDEOGRAPH-6E00
        0x6DC8, # G+8017  U+6DC8  uni6DC8,  CJK UNIFIED IDEOGRAPH-6DC8
        0x6DE0, # G+8018  U+6DE0  uni6DE0,  CJK UNIFIED IDEOGRAPH-6DE0
        0x6DDF, # G+8019  U+6DDF  uni6DDF,  CJK UNIFIED IDEOGRAPH-6DDF
        0x6DD6, # G+8020  U+6DD6  uni6DD6,  CJK UNIFIED IDEOGRAPH-6DD6
        0x6DBE, # G+8021  U+6DBE  uni6DBE,  CJK UNIFIED IDEOGRAPH-6DBE
        0x6DE5, # G+8022  U+6DE5  uni6DE5,  CJK UNIFIED IDEOGRAPH-6DE5
        0x6DDC, # G+8023  U+6DDC  uni6DDC,  CJK UNIFIED IDEOGRAPH-6DDC
        0x6DDD, # G+8024  U+6DDD  uni6DDD,  CJK UNIFIED IDEOGRAPH-6DDD
        0x6DDB, # G+8025  U+6DDB  uni6DDB,  CJK UNIFIED IDEOGRAPH-6DDB
        0x6DF4, # G+8026  U+6DF4  uni6DF4,  CJK UNIFIED IDEOGRAPH-6DF4
        0x6DCA, # G+8027  U+6DCA  uni6DCA,  CJK UNIFIED IDEOGRAPH-6DCA
        0x6DBD, # G+8028  U+6DBD  uni6DBD,  CJK UNIFIED IDEOGRAPH-6DBD
        0x6DED, # G+8029  U+6DED  uni6DED,  CJK UNIFIED IDEOGRAPH-6DED
        0x6DF0, # G+8030  U+6DF0  uni6DF0,  CJK UNIFIED IDEOGRAPH-6DF0
        0x6DBA, # G+8031  U+6DBA  uni6DBA,  CJK UNIFIED IDEOGRAPH-6DBA
        0x6DD5, # G+8032  U+6DD5  uni6DD5,  CJK UNIFIED IDEOGRAPH-6DD5
        0x6DC2, # G+8033  U+6DC2  uni6DC2,  CJK UNIFIED IDEOGRAPH-6DC2
        0x6DCF, # G+8034  U+6DCF  uni6DCF,  CJK UNIFIED IDEOGRAPH-6DCF
        0x6DC9, # G+8035  U+6DC9  uni6DC9,  CJK UNIFIED IDEOGRAPH-6DC9
        0x6DD0, # G+8036  U+6DD0  uni6DD0,  CJK UNIFIED IDEOGRAPH-6DD0
        0x6DF2, # G+8037  U+6DF2  uni6DF2,  CJK UNIFIED IDEOGRAPH-6DF2
        0x6DD3, # G+8038  U+6DD3  uni6DD3,  CJK UNIFIED IDEOGRAPH-6DD3
        0x6DFD, # G+8039  U+6DFD  uni6DFD,  CJK UNIFIED IDEOGRAPH-6DFD
        0x6DD7, # G+8040  U+6DD7  uni6DD7,  CJK UNIFIED IDEOGRAPH-6DD7
        0x6DCD, # G+8041  U+6DCD  uni6DCD,  CJK UNIFIED IDEOGRAPH-6DCD
        0x6DE3, # G+8042  U+6DE3  uni6DE3,  CJK UNIFIED IDEOGRAPH-6DE3
        0x6DBB, # G+8043  U+6DBB  uni6DBB,  CJK UNIFIED IDEOGRAPH-6DBB
        0x70FA, # G+8044  U+70FA  uni70FA,  CJK UNIFIED IDEOGRAPH-70FA
        0x710D, # G+8045  U+710D  uni710D,  CJK UNIFIED IDEOGRAPH-710D
        0x70F7, # G+8046  U+70F7  uni70F7,  CJK UNIFIED IDEOGRAPH-70F7
        0x7117, # G+8047  U+7117  uni7117,  CJK UNIFIED IDEOGRAPH-7117
        0x70F4, # G+8048  U+70F4  uni70F4,  CJK UNIFIED IDEOGRAPH-70F4
        0x710C, # G+8049  U+710C  uni710C,  CJK UNIFIED IDEOGRAPH-710C
        0x70F0, # G+8050  U+70F0  uni70F0,  CJK UNIFIED IDEOGRAPH-70F0
        0x7104, # G+8051  U+7104  uni7104,  CJK UNIFIED IDEOGRAPH-7104
        0x70F3, # G+8052  U+70F3  uni70F3,  CJK UNIFIED IDEOGRAPH-70F3
        0x7110, # G+8053  U+7110  uni7110,  CJK UNIFIED IDEOGRAPH-7110
        0x70FC, # G+8054  U+70FC  uni70FC,  CJK UNIFIED IDEOGRAPH-70FC
        0x70FF, # G+8055  U+70FF  uni70FF,  CJK UNIFIED IDEOGRAPH-70FF
        0x7106, # G+8056  U+7106  uni7106,  CJK UNIFIED IDEOGRAPH-7106
        0x7113, # G+8057  U+7113  uni7113,  CJK UNIFIED IDEOGRAPH-7113
        0x7100, # G+8058  U+7100  uni7100,  CJK UNIFIED IDEOGRAPH-7100
        0x70F8, # G+8059  U+70F8  uni70F8,  CJK UNIFIED IDEOGRAPH-70F8
        0x70F6, # G+8060  U+70F6  uni70F6,  CJK UNIFIED IDEOGRAPH-70F6
        0x710B, # G+8061  U+710B  uni710B,  CJK UNIFIED IDEOGRAPH-710B
        0x7102, # G+8062  U+7102  uni7102,  CJK UNIFIED IDEOGRAPH-7102
        0x710E, # G+8063  U+710E  uni710E,  CJK UNIFIED IDEOGRAPH-710E
        0x727E, # G+8064  U+727E  uni727E,  CJK UNIFIED IDEOGRAPH-727E
        0x727B, # G+8065  U+727B  uni727B,  CJK UNIFIED IDEOGRAPH-727B
        0x727C, # G+8066  U+727C  uni727C,  CJK UNIFIED IDEOGRAPH-727C
        0x727F, # G+8067  U+727F  uni727F,  CJK UNIFIED IDEOGRAPH-727F
        0x731D, # G+8068  U+731D  uni731D,  CJK UNIFIED IDEOGRAPH-731D
        0x7317, # G+8069  U+7317  uni7317,  CJK UNIFIED IDEOGRAPH-7317
        0x7307, # G+8070  U+7307  uni7307,  CJK UNIFIED IDEOGRAPH-7307
        0x7311, # G+8071  U+7311  uni7311,  CJK UNIFIED IDEOGRAPH-7311
        0x7318, # G+8072  U+7318  uni7318,  CJK UNIFIED IDEOGRAPH-7318
        0x730A, # G+8073  U+730A  uni730A,  CJK UNIFIED IDEOGRAPH-730A
        0x7308, # G+8074  U+7308  uni7308,  CJK UNIFIED IDEOGRAPH-7308
        0x72FF, # G+8075  U+72FF  uni72FF,  CJK UNIFIED IDEOGRAPH-72FF
        0x730F, # G+8076  U+730F  uni730F,  CJK UNIFIED IDEOGRAPH-730F
        0x731E, # G+8077  U+731E  uni731E,  CJK UNIFIED IDEOGRAPH-731E
        0x7388, # G+8078  U+7388  uni7388,  CJK UNIFIED IDEOGRAPH-7388
        0x73F6, # G+8079  U+73F6  uni73F6,  CJK UNIFIED IDEOGRAPH-73F6
        0x73F8, # G+8080  U+73F8  uni73F8,  CJK UNIFIED IDEOGRAPH-73F8
        0x73F5, # G+8081  U+73F5  uni73F5,  CJK UNIFIED IDEOGRAPH-73F5
        0x7404, # G+8082  U+7404  uni7404,  CJK UNIFIED IDEOGRAPH-7404
        0x7401, # G+8083  U+7401  uni7401,  CJK UNIFIED IDEOGRAPH-7401
        0x73FD, # G+8084  U+73FD  uni73FD,  CJK UNIFIED IDEOGRAPH-73FD
        0x7407, # G+8085  U+7407  uni7407,  CJK UNIFIED IDEOGRAPH-7407
        0x7400, # G+8086  U+7400  uni7400,  CJK UNIFIED IDEOGRAPH-7400
        0x73FA, # G+8087  U+73FA  uni73FA,  CJK UNIFIED IDEOGRAPH-73FA
        0x73FC, # G+8088  U+73FC  uni73FC,  CJK UNIFIED IDEOGRAPH-73FC
        0x73FF, # G+8089  U+73FF  uni73FF,  CJK UNIFIED IDEOGRAPH-73FF
        0x740C, # G+8090  U+740C  uni740C,  CJK UNIFIED IDEOGRAPH-740C
        0x740B, # G+8091  U+740B  uni740B,  CJK UNIFIED IDEOGRAPH-740B
        0x73F4, # G+8092  U+73F4  uni73F4,  CJK UNIFIED IDEOGRAPH-73F4
        0x7408, # G+8093  U+7408  uni7408,  CJK UNIFIED IDEOGRAPH-7408
        0x7564, # G+8094  U+7564  uni7564,  CJK UNIFIED IDEOGRAPH-7564
        0x7563, # G+8095  U+7563  uni7563,  CJK UNIFIED IDEOGRAPH-7563
        0x75CE, # G+8096  U+75CE  uni75CE,  CJK UNIFIED IDEOGRAPH-75CE
        0x75D2, # G+8097  U+75D2  uni75D2,  CJK UNIFIED IDEOGRAPH-75D2
        0x75CF, # G+8098  U+75CF  uni75CF,  CJK UNIFIED IDEOGRAPH-75CF
        0x75CB, # G+8099  U+75CB  uni75CB,  CJK UNIFIED IDEOGRAPH-75CB
        0x75CC, # G+8100  U+75CC  uni75CC,  CJK UNIFIED IDEOGRAPH-75CC
        0x75D1, # G+8101  U+75D1  uni75D1,  CJK UNIFIED IDEOGRAPH-75D1
        0x75D0, # G+8102  U+75D0  uni75D0,  CJK UNIFIED IDEOGRAPH-75D0
        0x768F, # G+8103  U+768F  uni768F,  CJK UNIFIED IDEOGRAPH-768F
        0x7689, # G+8104  U+7689  uni7689,  CJK UNIFIED IDEOGRAPH-7689
        0x76D3, # G+8105  U+76D3  uni76D3,  CJK UNIFIED IDEOGRAPH-76D3
        0x7739, # G+8106  U+7739  uni7739,  CJK UNIFIED IDEOGRAPH-7739
        0x772F, # G+8107  U+772F  uni772F,  CJK UNIFIED IDEOGRAPH-772F
        0x772D, # G+8108  U+772D  uni772D,  CJK UNIFIED IDEOGRAPH-772D
        0x7731, # G+8109  U+7731  uni7731,  CJK UNIFIED IDEOGRAPH-7731
        0x7732, # G+8110  U+7732  uni7732,  CJK UNIFIED IDEOGRAPH-7732
        0x7734, # G+8111  U+7734  uni7734,  CJK UNIFIED IDEOGRAPH-7734
        0x7733, # G+8112  U+7733  uni7733,  CJK UNIFIED IDEOGRAPH-7733
        0x773D, # G+8113  U+773D  uni773D,  CJK UNIFIED IDEOGRAPH-773D
        0x7725, # G+8114  U+7725  uni7725,  CJK UNIFIED IDEOGRAPH-7725
        0x773B, # G+8115  U+773B  uni773B,  CJK UNIFIED IDEOGRAPH-773B
        0x7735, # G+8116  U+7735  uni7735,  CJK UNIFIED IDEOGRAPH-7735
        0x7848, # G+8117  U+7848  uni7848,  CJK UNIFIED IDEOGRAPH-7848
        0x7852, # G+8118  U+7852  uni7852,  CJK UNIFIED IDEOGRAPH-7852
        0x7849, # G+8119  U+7849  uni7849,  CJK UNIFIED IDEOGRAPH-7849
        0x784D, # G+8120  U+784D  uni784D,  CJK UNIFIED IDEOGRAPH-784D
        0x784A, # G+8121  U+784A  uni784A,  CJK UNIFIED IDEOGRAPH-784A
        0x784C, # G+8122  U+784C  uni784C,  CJK UNIFIED IDEOGRAPH-784C
        0x7826, # G+8123  U+7826  uni7826,  CJK UNIFIED IDEOGRAPH-7826
        0x7845, # G+8124  U+7845  uni7845,  CJK UNIFIED IDEOGRAPH-7845
        0x7850, # G+8125  U+7850  uni7850,  CJK UNIFIED IDEOGRAPH-7850
        0x7964, # G+8126  U+7964  uni7964,  CJK UNIFIED IDEOGRAPH-7964
        0x7967, # G+8127  U+7967  uni7967,  CJK UNIFIED IDEOGRAPH-7967
        0x7969, # G+8128  U+7969  uni7969,  CJK UNIFIED IDEOGRAPH-7969
        0x796A, # G+8129  U+796A  uni796A,  CJK UNIFIED IDEOGRAPH-796A
        0x7963, # G+8130  U+7963  uni7963,  CJK UNIFIED IDEOGRAPH-7963
        0x796B, # G+8131  U+796B  uni796B,  CJK UNIFIED IDEOGRAPH-796B
        0x7961, # G+8132  U+7961  uni7961,  CJK UNIFIED IDEOGRAPH-7961
        0x79BB, # G+8133  U+79BB  uni79BB,  CJK UNIFIED IDEOGRAPH-79BB
        0x79FA, # G+8134  U+79FA  uni79FA,  CJK UNIFIED IDEOGRAPH-79FA
        0x79F8, # G+8135  U+79F8  uni79F8,  CJK UNIFIED IDEOGRAPH-79F8
        0x79F6, # G+8136  U+79F6  uni79F6,  CJK UNIFIED IDEOGRAPH-79F6
        0x79F7, # G+8137  U+79F7  uni79F7,  CJK UNIFIED IDEOGRAPH-79F7
        0x7A8F, # G+8138  U+7A8F  uni7A8F,  CJK UNIFIED IDEOGRAPH-7A8F
        0x7A94, # G+8139  U+7A94  uni7A94,  CJK UNIFIED IDEOGRAPH-7A94
        0x7A90, # G+8140  U+7A90  uni7A90,  CJK UNIFIED IDEOGRAPH-7A90
        0x7B35, # G+8141  U+7B35  uni7B35,  CJK UNIFIED IDEOGRAPH-7B35
        0x7B3B, # G+8142  U+7B3B  uni7B3B,  CJK UNIFIED IDEOGRAPH-7B3B
        0x7B34, # G+8143  U+7B34  uni7B34,  CJK UNIFIED IDEOGRAPH-7B34
        0x7B25, # G+8144  U+7B25  uni7B25,  CJK UNIFIED IDEOGRAPH-7B25
        0x7B30, # G+8145  U+7B30  uni7B30,  CJK UNIFIED IDEOGRAPH-7B30
        0x7B22, # G+8146  U+7B22  uni7B22,  CJK UNIFIED IDEOGRAPH-7B22
        0x7B24, # G+8147  U+7B24  uni7B24,  CJK UNIFIED IDEOGRAPH-7B24
        0x7B33, # G+8148  U+7B33  uni7B33,  CJK UNIFIED IDEOGRAPH-7B33
        0x7B18, # G+8149  U+7B18  uni7B18,  CJK UNIFIED IDEOGRAPH-7B18
        0x7B2A, # G+8150  U+7B2A  uni7B2A,  CJK UNIFIED IDEOGRAPH-7B2A
        0x7B1D, # G+8151  U+7B1D  uni7B1D,  CJK UNIFIED IDEOGRAPH-7B1D
        0x7B31, # G+8152  U+7B31  uni7B31,  CJK UNIFIED IDEOGRAPH-7B31
        0x7B2B, # G+8153  U+7B2B  uni7B2B,  CJK UNIFIED IDEOGRAPH-7B2B
        0x7B2D, # G+8154  U+7B2D  uni7B2D,  CJK UNIFIED IDEOGRAPH-7B2D
        0x7B2F, # G+8155  U+7B2F  uni7B2F,  CJK UNIFIED IDEOGRAPH-7B2F
        0x7B32, # G+8156  U+7B32  uni7B32,  CJK UNIFIED IDEOGRAPH-7B32
        0x7B38, # G+8157  U+7B38  uni7B38,  CJK UNIFIED IDEOGRAPH-7B38
        0x7B1A, # G+8158  U+7B1A  uni7B1A,  CJK UNIFIED IDEOGRAPH-7B1A
        0x7B23, # G+8159  U+7B23  uni7B23,  CJK UNIFIED IDEOGRAPH-7B23
        0x7C94, # G+8160  U+7C94  uni7C94,  CJK UNIFIED IDEOGRAPH-7C94
        0x7C98, # G+8161  U+7C98  uni7C98,  CJK UNIFIED IDEOGRAPH-7C98
        0x7C96, # G+8162  U+7C96  uni7C96,  CJK UNIFIED IDEOGRAPH-7C96
        0x7CA3, # G+8163  U+7CA3  uni7CA3,  CJK UNIFIED IDEOGRAPH-7CA3
        0x7D35, # G+8164  U+7D35  uni7D35,  CJK UNIFIED IDEOGRAPH-7D35
        0x7D3D, # G+8165  U+7D3D  uni7D3D,  CJK UNIFIED IDEOGRAPH-7D3D
        0x7D38, # G+8166  U+7D38  uni7D38,  CJK UNIFIED IDEOGRAPH-7D38
        0x7D36, # G+8167  U+7D36  uni7D36,  CJK UNIFIED IDEOGRAPH-7D36
        0x7D3A, # G+8168  U+7D3A  uni7D3A,  CJK UNIFIED IDEOGRAPH-7D3A
        0x7D45, # G+8169  U+7D45  uni7D45,  CJK UNIFIED IDEOGRAPH-7D45
        0x7D2C, # G+8170  U+7D2C  uni7D2C,  CJK UNIFIED IDEOGRAPH-7D2C
        0x7D29, # G+8171  U+7D29  uni7D29,  CJK UNIFIED IDEOGRAPH-7D29
        0x7D41, # G+8172  U+7D41  uni7D41,  CJK UNIFIED IDEOGRAPH-7D41
        0x7D47, # G+8173  U+7D47  uni7D47,  CJK UNIFIED IDEOGRAPH-7D47
        0x7D3E, # G+8174  U+7D3E  uni7D3E,  CJK UNIFIED IDEOGRAPH-7D3E
        0x7D3F, # G+8175  U+7D3F  uni7D3F,  CJK UNIFIED IDEOGRAPH-7D3F
        0x7D4A, # G+8176  U+7D4A  uni7D4A,  CJK UNIFIED IDEOGRAPH-7D4A
        0x7D3B, # G+8177  U+7D3B  uni7D3B,  CJK UNIFIED IDEOGRAPH-7D3B
        0x7D28, # G+8178  U+7D28  uni7D28,  CJK UNIFIED IDEOGRAPH-7D28
        0x7F63, # G+8179  U+7F63  uni7F63,  CJK UNIFIED IDEOGRAPH-7F63
        0x7F95, # G+8180  U+7F95  uni7F95,  CJK UNIFIED IDEOGRAPH-7F95
        0x7F9C, # G+8181  U+7F9C  uni7F9C,  CJK UNIFIED IDEOGRAPH-7F9C
        0x7F9D, # G+8182  U+7F9D  uni7F9D,  CJK UNIFIED IDEOGRAPH-7F9D
        0x7F9B, # G+8183  U+7F9B  uni7F9B,  CJK UNIFIED IDEOGRAPH-7F9B
        0x7FCA, # G+8184  U+7FCA  uni7FCA,  CJK UNIFIED IDEOGRAPH-7FCA
        0x7FCB, # G+8185  U+7FCB  uni7FCB,  CJK UNIFIED IDEOGRAPH-7FCB
        0x7FCD, # G+8186  U+7FCD  uni7FCD,  CJK UNIFIED IDEOGRAPH-7FCD
        0x7FD0, # G+8187  U+7FD0  uni7FD0,  CJK UNIFIED IDEOGRAPH-7FD0
        0x7FD1, # G+8188  U+7FD1  uni7FD1,  CJK UNIFIED IDEOGRAPH-7FD1
        0x7FC7, # G+8189  U+7FC7  uni7FC7,  CJK UNIFIED IDEOGRAPH-7FC7
        0x7FCF, # G+8190  U+7FCF  uni7FCF,  CJK UNIFIED IDEOGRAPH-7FCF
        0x7FC9, # G+8191  U+7FC9  uni7FC9,  CJK UNIFIED IDEOGRAPH-7FC9
        0x801F, # G+8192  U+801F  uni801F,  CJK UNIFIED IDEOGRAPH-801F
        0x801E, # G+8193  U+801E  uni801E,  CJK UNIFIED IDEOGRAPH-801E
        0x801B, # G+8194  U+801B  uni801B,  CJK UNIFIED IDEOGRAPH-801B
        0x8047, # G+8195  U+8047  uni8047,  CJK UNIFIED IDEOGRAPH-8047
        0x8043, # G+8196  U+8043  uni8043,  CJK UNIFIED IDEOGRAPH-8043
        0x8048, # G+8197  U+8048  uni8048,  CJK UNIFIED IDEOGRAPH-8048
        0x8118, # G+8198  U+8118  uni8118,  CJK UNIFIED IDEOGRAPH-8118
        0x8125, # G+8199  U+8125  uni8125,  CJK UNIFIED IDEOGRAPH-8125
        0x8119, # G+8200  U+8119  uni8119,  CJK UNIFIED IDEOGRAPH-8119
        0x811B, # G+8201  U+811B  uni811B,  CJK UNIFIED IDEOGRAPH-811B
        0x812D, # G+8202  U+812D  uni812D,  CJK UNIFIED IDEOGRAPH-812D
        0x811F, # G+8203  U+811F  uni811F,  CJK UNIFIED IDEOGRAPH-811F
        0x812C, # G+8204  U+812C  uni812C,  CJK UNIFIED IDEOGRAPH-812C
        0x811E, # G+8205  U+811E  uni811E,  CJK UNIFIED IDEOGRAPH-811E
        0x8121, # G+8206  U+8121  uni8121,  CJK UNIFIED IDEOGRAPH-8121
        0x8115, # G+8207  U+8115  uni8115,  CJK UNIFIED IDEOGRAPH-8115
        0x8127, # G+8208  U+8127  uni8127,  CJK UNIFIED IDEOGRAPH-8127
        0x811D, # G+8209  U+811D  uni811D,  CJK UNIFIED IDEOGRAPH-811D
        0x8122, # G+8210  U+8122  uni8122,  CJK UNIFIED IDEOGRAPH-8122
        0x8211, # G+8211  U+8211  uni8211,  CJK UNIFIED IDEOGRAPH-8211
        0x8238, # G+8212  U+8238  uni8238,  CJK UNIFIED IDEOGRAPH-8238
        0x8233, # G+8213  U+8233  uni8233,  CJK UNIFIED IDEOGRAPH-8233
        0x823A, # G+8214  U+823A  uni823A,  CJK UNIFIED IDEOGRAPH-823A
        0x8234, # G+8215  U+8234  uni8234,  CJK UNIFIED IDEOGRAPH-8234
        0x8232, # G+8216  U+8232  uni8232,  CJK UNIFIED IDEOGRAPH-8232
        0x8274, # G+8217  U+8274  uni8274,  CJK UNIFIED IDEOGRAPH-8274
        0x8390, # G+8218  U+8390  uni8390,  CJK UNIFIED IDEOGRAPH-8390
        0x83A3, # G+8219  U+83A3  uni83A3,  CJK UNIFIED IDEOGRAPH-83A3
        0x83A8, # G+8220  U+83A8  uni83A8,  CJK UNIFIED IDEOGRAPH-83A8
        0x838D, # G+8221  U+838D  uni838D,  CJK UNIFIED IDEOGRAPH-838D
        0x837A, # G+8222  U+837A  uni837A,  CJK UNIFIED IDEOGRAPH-837A
        0x8373, # G+8223  U+8373  uni8373,  CJK UNIFIED IDEOGRAPH-8373
        0x83A4, # G+8224  U+83A4  uni83A4,  CJK UNIFIED IDEOGRAPH-83A4
        0x8374, # G+8225  U+8374  uni8374,  CJK UNIFIED IDEOGRAPH-8374
        0x838F, # G+8226  U+838F  uni838F,  CJK UNIFIED IDEOGRAPH-838F
        0x8381, # G+8227  U+8381  uni8381,  CJK UNIFIED IDEOGRAPH-8381
        0x8395, # G+8228  U+8395  uni8395,  CJK UNIFIED IDEOGRAPH-8395
        0x8399, # G+8229  U+8399  uni8399,  CJK UNIFIED IDEOGRAPH-8399
        0x8375, # G+8230  U+8375  uni8375,  CJK UNIFIED IDEOGRAPH-8375
        0x8394, # G+8231  U+8394  uni8394,  CJK UNIFIED IDEOGRAPH-8394
        0x83A9, # G+8232  U+83A9  uni83A9,  CJK UNIFIED IDEOGRAPH-83A9
        0x837D, # G+8233  U+837D  uni837D,  CJK UNIFIED IDEOGRAPH-837D
        0x8383, # G+8234  U+8383  uni8383,  CJK UNIFIED IDEOGRAPH-8383
        0x838C, # G+8235  U+838C  uni838C,  CJK UNIFIED IDEOGRAPH-838C
        0x839D, # G+8236  U+839D  uni839D,  CJK UNIFIED IDEOGRAPH-839D
        0x839B, # G+8237  U+839B  uni839B,  CJK UNIFIED IDEOGRAPH-839B
        0x83AA, # G+8238  U+83AA  uni83AA,  CJK UNIFIED IDEOGRAPH-83AA
        0x838B, # G+8239  U+838B  uni838B,  CJK UNIFIED IDEOGRAPH-838B
        0x837E, # G+8240  U+837E  uni837E,  CJK UNIFIED IDEOGRAPH-837E
        0x83A5, # G+8241  U+83A5  uni83A5,  CJK UNIFIED IDEOGRAPH-83A5
        0x83AF, # G+8242  U+83AF  uni83AF,  CJK UNIFIED IDEOGRAPH-83AF
        0x8388, # G+8243  U+8388  uni8388,  CJK UNIFIED IDEOGRAPH-8388
        0x8397, # G+8244  U+8397  uni8397,  CJK UNIFIED IDEOGRAPH-8397
        0x83B0, # G+8245  U+83B0  uni83B0,  CJK UNIFIED IDEOGRAPH-83B0
        0x837F, # G+8246  U+837F  uni837F,  CJK UNIFIED IDEOGRAPH-837F
        0x83A6, # G+8247  U+83A6  uni83A6,  CJK UNIFIED IDEOGRAPH-83A6
        0x8387, # G+8248  U+8387  uni8387,  CJK UNIFIED IDEOGRAPH-8387
        0x83AE, # G+8249  U+83AE  uni83AE,  CJK UNIFIED IDEOGRAPH-83AE
        0x8376, # G+8250  U+8376  uni8376,  CJK UNIFIED IDEOGRAPH-8376
        0x8659, # G+8251  U+8659  uni8659,  CJK UNIFIED IDEOGRAPH-8659
        0x8656, # G+8252  U+8656  uni8656,  CJK UNIFIED IDEOGRAPH-8656
        0x86BF, # G+8253  U+86BF  uni86BF,  CJK UNIFIED IDEOGRAPH-86BF
        0x86B7, # G+8254  U+86B7  uni86B7,  CJK UNIFIED IDEOGRAPH-86B7
        0x86C2, # G+8255  U+86C2  uni86C2,  CJK UNIFIED IDEOGRAPH-86C2
        0x86C1, # G+8256  U+86C1  uni86C1,  CJK UNIFIED IDEOGRAPH-86C1
        0x86C5, # G+8257  U+86C5  uni86C5,  CJK UNIFIED IDEOGRAPH-86C5
        0x86BA, # G+8258  U+86BA  uni86BA,  CJK UNIFIED IDEOGRAPH-86BA
        0x86B0, # G+8259  U+86B0  uni86B0,  CJK UNIFIED IDEOGRAPH-86B0
        0x86C8, # G+8260  U+86C8  uni86C8,  CJK UNIFIED IDEOGRAPH-86C8
        0x86B9, # G+8261  U+86B9  uni86B9,  CJK UNIFIED IDEOGRAPH-86B9
        0x86B3, # G+8262  U+86B3  uni86B3,  CJK UNIFIED IDEOGRAPH-86B3
        0x86B8, # G+8263  U+86B8  uni86B8,  CJK UNIFIED IDEOGRAPH-86B8
        0x86CC, # G+8264  U+86CC  uni86CC,  CJK UNIFIED IDEOGRAPH-86CC
        0x86B4, # G+8265  U+86B4  uni86B4,  CJK UNIFIED IDEOGRAPH-86B4
        0x86BB, # G+8266  U+86BB  uni86BB,  CJK UNIFIED IDEOGRAPH-86BB
        0x86BC, # G+8267  U+86BC  uni86BC,  CJK UNIFIED IDEOGRAPH-86BC
        0x86C3, # G+8268  U+86C3  uni86C3,  CJK UNIFIED IDEOGRAPH-86C3
        0x86BD, # G+8269  U+86BD  uni86BD,  CJK UNIFIED IDEOGRAPH-86BD
        0x86BE, # G+8270  U+86BE  uni86BE,  CJK UNIFIED IDEOGRAPH-86BE
        0x8852, # G+8271  U+8852  uni8852,  CJK UNIFIED IDEOGRAPH-8852
        0x8889, # G+8272  U+8889  uni8889,  CJK UNIFIED IDEOGRAPH-8889
        0x8895, # G+8273  U+8895  uni8895,  CJK UNIFIED IDEOGRAPH-8895
        0x88A8, # G+8274  U+88A8  uni88A8,  CJK UNIFIED IDEOGRAPH-88A8
        0x88A2, # G+8275  U+88A2  uni88A2,  CJK UNIFIED IDEOGRAPH-88A2
        0x88AA, # G+8276  U+88AA  uni88AA,  CJK UNIFIED IDEOGRAPH-88AA
        0x889A, # G+8277  U+889A  uni889A,  CJK UNIFIED IDEOGRAPH-889A
        0x8891, # G+8278  U+8891  uni8891,  CJK UNIFIED IDEOGRAPH-8891
        0x88A1, # G+8279  U+88A1  uni88A1,  CJK UNIFIED IDEOGRAPH-88A1
        0x889F, # G+8280  U+889F  uni889F,  CJK UNIFIED IDEOGRAPH-889F
        0x8898, # G+8281  U+8898  uni8898,  CJK UNIFIED IDEOGRAPH-8898
        0x88A7, # G+8282  U+88A7  uni88A7,  CJK UNIFIED IDEOGRAPH-88A7
        0x8899, # G+8283  U+8899  uni8899,  CJK UNIFIED IDEOGRAPH-8899
        0x889B, # G+8284  U+889B  uni889B,  CJK UNIFIED IDEOGRAPH-889B
        0x8897, # G+8285  U+8897  uni8897,  CJK UNIFIED IDEOGRAPH-8897
        0x88A4, # G+8286  U+88A4  uni88A4,  CJK UNIFIED IDEOGRAPH-88A4
        0x88AC, # G+8287  U+88AC  uni88AC,  CJK UNIFIED IDEOGRAPH-88AC
        0x888C, # G+8288  U+888C  uni888C,  CJK UNIFIED IDEOGRAPH-888C
        0x8893, # G+8289  U+8893  uni8893,  CJK UNIFIED IDEOGRAPH-8893
        0x888E, # G+8290  U+888E  uni888E,  CJK UNIFIED IDEOGRAPH-888E
        0x8982, # G+8291  U+8982  uni8982,  CJK UNIFIED IDEOGRAPH-8982
        0x89D6, # G+8292  U+89D6  uni89D6,  CJK UNIFIED IDEOGRAPH-89D6
        0x89D9, # G+8293  U+89D9  uni89D9,  CJK UNIFIED IDEOGRAPH-89D9
        0x89D5, # G+8294  U+89D5  uni89D5,  CJK UNIFIED IDEOGRAPH-89D5
        0x8A30, # G+8295  U+8A30  uni8A30,  CJK UNIFIED IDEOGRAPH-8A30
        0x8A27, # G+8296  U+8A27  uni8A27,  CJK UNIFIED IDEOGRAPH-8A27
        0x8A2C, # G+8297  U+8A2C  uni8A2C,  CJK UNIFIED IDEOGRAPH-8A2C
        0x8A1E, # G+8298  U+8A1E  uni8A1E,  CJK UNIFIED IDEOGRAPH-8A1E
        0x8C39, # G+8299  U+8C39  uni8C39,  CJK UNIFIED IDEOGRAPH-8C39
        0x8C3B, # G+8300  U+8C3B  uni8C3B,  CJK UNIFIED IDEOGRAPH-8C3B
        0x8C5C, # G+8301  U+8C5C  uni8C5C,  CJK UNIFIED IDEOGRAPH-8C5C
        0x8C5D, # G+8302  U+8C5D  uni8C5D,  CJK UNIFIED IDEOGRAPH-8C5D
        0x8C7D, # G+8303  U+8C7D  uni8C7D,  CJK UNIFIED IDEOGRAPH-8C7D
        0x8CA5, # G+8304  U+8CA5  uni8CA5,  CJK UNIFIED IDEOGRAPH-8CA5
        0x8D7D, # G+8305  U+8D7D  uni8D7D,  CJK UNIFIED IDEOGRAPH-8D7D
        0x8D7B, # G+8306  U+8D7B  uni8D7B,  CJK UNIFIED IDEOGRAPH-8D7B
        0x8D79, # G+8307  U+8D79  uni8D79,  CJK UNIFIED IDEOGRAPH-8D79
        0x8DBC, # G+8308  U+8DBC  uni8DBC,  CJK UNIFIED IDEOGRAPH-8DBC
        0x8DC2, # G+8309  U+8DC2  uni8DC2,  CJK UNIFIED IDEOGRAPH-8DC2
        0x8DB9, # G+8310  U+8DB9  uni8DB9,  CJK UNIFIED IDEOGRAPH-8DB9
        0x8DBF, # G+8311  U+8DBF  uni8DBF,  CJK UNIFIED IDEOGRAPH-8DBF
        0x8DC1, # G+8312  U+8DC1  uni8DC1,  CJK UNIFIED IDEOGRAPH-8DC1
        0x8ED8, # G+8313  U+8ED8  uni8ED8,  CJK UNIFIED IDEOGRAPH-8ED8
        0x8EDE, # G+8314  U+8EDE  uni8EDE,  CJK UNIFIED IDEOGRAPH-8EDE
        0x8EDD, # G+8315  U+8EDD  uni8EDD,  CJK UNIFIED IDEOGRAPH-8EDD
        0x8EDC, # G+8316  U+8EDC  uni8EDC,  CJK UNIFIED IDEOGRAPH-8EDC
        0x8ED7, # G+8317  U+8ED7  uni8ED7,  CJK UNIFIED IDEOGRAPH-8ED7
        0x8EE0, # G+8318  U+8EE0  uni8EE0,  CJK UNIFIED IDEOGRAPH-8EE0
        0x8EE1, # G+8319  U+8EE1  uni8EE1,  CJK UNIFIED IDEOGRAPH-8EE1
        0x9024, # G+8320  U+9024  uni9024,  CJK UNIFIED IDEOGRAPH-9024
        0x900B, # G+8321  U+900B  uni900B,  CJK UNIFIED IDEOGRAPH-900B
        0x9011, # G+8322  U+9011  uni9011,  CJK UNIFIED IDEOGRAPH-9011
        0x901C, # G+8323  U+901C  uni901C,  CJK UNIFIED IDEOGRAPH-901C
        0x900C, # G+8324  U+900C  uni900C,  CJK UNIFIED IDEOGRAPH-900C
        0x9021, # G+8325  U+9021  uni9021,  CJK UNIFIED IDEOGRAPH-9021
        0x90EF, # G+8326  U+90EF  uni90EF,  CJK UNIFIED IDEOGRAPH-90EF
        0x90EA, # G+8327  U+90EA  uni90EA,  CJK UNIFIED IDEOGRAPH-90EA
        0x90F0, # G+8328  U+90F0  uni90F0,  CJK UNIFIED IDEOGRAPH-90F0
        0x90F4, # G+8329  U+90F4  uni90F4,  CJK UNIFIED IDEOGRAPH-90F4
        0x90F2, # G+8330  U+90F2  uni90F2,  CJK UNIFIED IDEOGRAPH-90F2
        0x90F3, # G+8331  U+90F3  uni90F3,  CJK UNIFIED IDEOGRAPH-90F3
        0x90D4, # G+8332  U+90D4  uni90D4,  CJK UNIFIED IDEOGRAPH-90D4
        0x90EB, # G+8333  U+90EB  uni90EB,  CJK UNIFIED IDEOGRAPH-90EB
        0x90EC, # G+8334  U+90EC  uni90EC,  CJK UNIFIED IDEOGRAPH-90EC
        0x90E9, # G+8335  U+90E9  uni90E9,  CJK UNIFIED IDEOGRAPH-90E9
        0x9156, # G+8336  U+9156  uni9156,  CJK UNIFIED IDEOGRAPH-9156
        0x9158, # G+8337  U+9158  uni9158,  CJK UNIFIED IDEOGRAPH-9158
        0x915A, # G+8338  U+915A  uni915A,  CJK UNIFIED IDEOGRAPH-915A
        0x9153, # G+8339  U+9153  uni9153,  CJK UNIFIED IDEOGRAPH-9153
        0x9155, # G+8340  U+9155  uni9155,  CJK UNIFIED IDEOGRAPH-9155
        0x91EC, # G+8341  U+91EC  uni91EC,  CJK UNIFIED IDEOGRAPH-91EC
        0x91F4, # G+8342  U+91F4  uni91F4,  CJK UNIFIED IDEOGRAPH-91F4
        0x91F1, # G+8343  U+91F1  uni91F1,  CJK UNIFIED IDEOGRAPH-91F1
        0x91F3, # G+8344  U+91F3  uni91F3,  CJK UNIFIED IDEOGRAPH-91F3
        0x91F8, # G+8345  U+91F8  uni91F8,  CJK UNIFIED IDEOGRAPH-91F8
        0x91E4, # G+8346  U+91E4  uni91E4,  CJK UNIFIED IDEOGRAPH-91E4
        0x91F9, # G+8347  U+91F9  uni91F9,  CJK UNIFIED IDEOGRAPH-91F9
        0x91EA, # G+8348  U+91EA  uni91EA,  CJK UNIFIED IDEOGRAPH-91EA
        0x91EB, # G+8349  U+91EB  uni91EB,  CJK UNIFIED IDEOGRAPH-91EB
        0x91F7, # G+8350  U+91F7  uni91F7,  CJK UNIFIED IDEOGRAPH-91F7
        0x91E8, # G+8351  U+91E8  uni91E8,  CJK UNIFIED IDEOGRAPH-91E8
        0x91EE, # G+8352  U+91EE  uni91EE,  CJK UNIFIED IDEOGRAPH-91EE
        0x957A, # G+8353  U+957A  uni957A,  CJK UNIFIED IDEOGRAPH-957A
        0x9586, # G+8354  U+9586  uni9586,  CJK UNIFIED IDEOGRAPH-9586
        0x9588, # G+8355  U+9588  uni9588,  CJK UNIFIED IDEOGRAPH-9588
        0x967C, # G+8356  U+967C  uni967C,  CJK UNIFIED IDEOGRAPH-967C
        0x966D, # G+8357  U+966D  uni966D,  CJK UNIFIED IDEOGRAPH-966D
        0x966B, # G+8358  U+966B  uni966B,  CJK UNIFIED IDEOGRAPH-966B
        0x9671, # G+8359  U+9671  uni9671,  CJK UNIFIED IDEOGRAPH-9671
        0x966F, # G+8360  U+966F  uni966F,  CJK UNIFIED IDEOGRAPH-966F
        0x96BF, # G+8361  U+96BF  uni96BF,  CJK UNIFIED IDEOGRAPH-96BF
        0x976A, # G+8362  U+976A  uni976A,  CJK UNIFIED IDEOGRAPH-976A
        0x9804, # G+8363  U+9804  uni9804,  CJK UNIFIED IDEOGRAPH-9804
        0x98E5, # G+8364  U+98E5  uni98E5,  CJK UNIFIED IDEOGRAPH-98E5
        0x9997, # G+8365  U+9997  uni9997,  CJK UNIFIED IDEOGRAPH-9997
        0x509B, # G+8366  U+509B  uni509B,  CJK UNIFIED IDEOGRAPH-509B
        0x5095, # G+8367  U+5095  uni5095,  CJK UNIFIED IDEOGRAPH-5095
        0x5094, # G+8368  U+5094  uni5094,  CJK UNIFIED IDEOGRAPH-5094
        0x509E, # G+8369  U+509E  uni509E,  CJK UNIFIED IDEOGRAPH-509E
        0x508B, # G+8370  U+508B  uni508B,  CJK UNIFIED IDEOGRAPH-508B
        0x50A3, # G+8371  U+50A3  uni50A3,  CJK UNIFIED IDEOGRAPH-50A3
        0x5083, # G+8372  U+5083  uni5083,  CJK UNIFIED IDEOGRAPH-5083
        0x508C, # G+8373  U+508C  uni508C,  CJK UNIFIED IDEOGRAPH-508C
        0x508E, # G+8374  U+508E  uni508E,  CJK UNIFIED IDEOGRAPH-508E
        0x509D, # G+8375  U+509D  uni509D,  CJK UNIFIED IDEOGRAPH-509D
        0x5068, # G+8376  U+5068  uni5068,  CJK UNIFIED IDEOGRAPH-5068
        0x509C, # G+8377  U+509C  uni509C,  CJK UNIFIED IDEOGRAPH-509C
        0x5092, # G+8378  U+5092  uni5092,  CJK UNIFIED IDEOGRAPH-5092
        0x5082, # G+8379  U+5082  uni5082,  CJK UNIFIED IDEOGRAPH-5082
        0x5087, # G+8380  U+5087  uni5087,  CJK UNIFIED IDEOGRAPH-5087
        0x515F, # G+8381  U+515F  uni515F,  CJK UNIFIED IDEOGRAPH-515F
        0x51D4, # G+8382  U+51D4  uni51D4,  CJK UNIFIED IDEOGRAPH-51D4
        0x5312, # G+8383  U+5312  uni5312,  CJK UNIFIED IDEOGRAPH-5312
        0x5311, # G+8384  U+5311  uni5311,  CJK UNIFIED IDEOGRAPH-5311
        0x53A4, # G+8385  U+53A4  uni53A4,  CJK UNIFIED IDEOGRAPH-53A4
        0x53A7, # G+8386  U+53A7  uni53A7,  CJK UNIFIED IDEOGRAPH-53A7
        0x5591, # G+8387  U+5591  uni5591,  CJK UNIFIED IDEOGRAPH-5591
        0x55A8, # G+8388  U+55A8  uni55A8,  CJK UNIFIED IDEOGRAPH-55A8
        0x55A5, # G+8389  U+55A5  uni55A5,  CJK UNIFIED IDEOGRAPH-55A5
        0x55AD, # G+8390  U+55AD  uni55AD,  CJK UNIFIED IDEOGRAPH-55AD
        0x5577, # G+8391  U+5577  uni5577,  CJK UNIFIED IDEOGRAPH-5577
        0x5645, # G+8392  U+5645  uni5645,  CJK UNIFIED IDEOGRAPH-5645
        0x55A2, # G+8393  U+55A2  uni55A2,  CJK UNIFIED IDEOGRAPH-55A2
        0x5593, # G+8394  U+5593  uni5593,  CJK UNIFIED IDEOGRAPH-5593
        0x5588, # G+8395  U+5588  uni5588,  CJK UNIFIED IDEOGRAPH-5588
        0x558F, # G+8396  U+558F  uni558F,  CJK UNIFIED IDEOGRAPH-558F
        0x55B5, # G+8397  U+55B5  uni55B5,  CJK UNIFIED IDEOGRAPH-55B5
        0x5581, # G+8398  U+5581  uni5581,  CJK UNIFIED IDEOGRAPH-5581
        0x55A3, # G+8399  U+55A3  uni55A3,  CJK UNIFIED IDEOGRAPH-55A3
        0x5592, # G+8400  U+5592  uni5592,  CJK UNIFIED IDEOGRAPH-5592
        0x55A4, # G+8401  U+55A4  uni55A4,  CJK UNIFIED IDEOGRAPH-55A4
        0x557D, # G+8402  U+557D  uni557D,  CJK UNIFIED IDEOGRAPH-557D
        0x558C, # G+8403  U+558C  uni558C,  CJK UNIFIED IDEOGRAPH-558C
        0x55A6, # G+8404  U+55A6  uni55A6,  CJK UNIFIED IDEOGRAPH-55A6
        0x557F, # G+8405  U+557F  uni557F,  CJK UNIFIED IDEOGRAPH-557F
        0x5595, # G+8406  U+5595  uni5595,  CJK UNIFIED IDEOGRAPH-5595
        0x55A1, # G+8407  U+55A1  uni55A1,  CJK UNIFIED IDEOGRAPH-55A1
        0x558E, # G+8408  U+558E  uni558E,  CJK UNIFIED IDEOGRAPH-558E
        0x570C, # G+8409  U+570C  uni570C,  CJK UNIFIED IDEOGRAPH-570C
        0x5829, # G+8410  U+5829  uni5829,  CJK UNIFIED IDEOGRAPH-5829
        0x5837, # G+8411  U+5837  uni5837,  CJK UNIFIED IDEOGRAPH-5837
        0x5819, # G+8412  U+5819  uni5819,  CJK UNIFIED IDEOGRAPH-5819
        0x581E, # G+8413  U+581E  uni581E,  CJK UNIFIED IDEOGRAPH-581E
        0x5827, # G+8414  U+5827  uni5827,  CJK UNIFIED IDEOGRAPH-5827
        0x5823, # G+8415  U+5823  uni5823,  CJK UNIFIED IDEOGRAPH-5823
        0x5828, # G+8416  U+5828  uni5828,  CJK UNIFIED IDEOGRAPH-5828
        0x57F5, # G+8417  U+57F5  uni57F5,  CJK UNIFIED IDEOGRAPH-57F5
        0x5848, # G+8418  U+5848  uni5848,  CJK UNIFIED IDEOGRAPH-5848
        0x5825, # G+8419  U+5825  uni5825,  CJK UNIFIED IDEOGRAPH-5825
        0x581C, # G+8420  U+581C  uni581C,  CJK UNIFIED IDEOGRAPH-581C
        0x581B, # G+8421  U+581B  uni581B,  CJK UNIFIED IDEOGRAPH-581B
        0x5833, # G+8422  U+5833  uni5833,  CJK UNIFIED IDEOGRAPH-5833
        0x583F, # G+8423  U+583F  uni583F,  CJK UNIFIED IDEOGRAPH-583F
        0x5836, # G+8424  U+5836  uni5836,  CJK UNIFIED IDEOGRAPH-5836
        0x582E, # G+8425  U+582E  uni582E,  CJK UNIFIED IDEOGRAPH-582E
        0x5839, # G+8426  U+5839  uni5839,  CJK UNIFIED IDEOGRAPH-5839
        0x5838, # G+8427  U+5838  uni5838,  CJK UNIFIED IDEOGRAPH-5838
        0x582D, # G+8428  U+582D  uni582D,  CJK UNIFIED IDEOGRAPH-582D
        0x582C, # G+8429  U+582C  uni582C,  CJK UNIFIED IDEOGRAPH-582C
        0x583B, # G+8430  U+583B  uni583B,  CJK UNIFIED IDEOGRAPH-583B
        0x5961, # G+8431  U+5961  uni5961,  CJK UNIFIED IDEOGRAPH-5961
        0x5AAF, # G+8432  U+5AAF  uni5AAF,  CJK UNIFIED IDEOGRAPH-5AAF
        0x5A94, # G+8433  U+5A94  uni5A94,  CJK UNIFIED IDEOGRAPH-5A94
        0x5A9F, # G+8434  U+5A9F  uni5A9F,  CJK UNIFIED IDEOGRAPH-5A9F
        0x5A7A, # G+8435  U+5A7A  uni5A7A,  CJK UNIFIED IDEOGRAPH-5A7A
        0x5AA2, # G+8436  U+5AA2  uni5AA2,  CJK UNIFIED IDEOGRAPH-5AA2
        0x5A9E, # G+8437  U+5A9E  uni5A9E,  CJK UNIFIED IDEOGRAPH-5A9E
        0x5A78, # G+8438  U+5A78  uni5A78,  CJK UNIFIED IDEOGRAPH-5A78
        0x5AA6, # G+8439  U+5AA6  uni5AA6,  CJK UNIFIED IDEOGRAPH-5AA6
        0x5A7C, # G+8440  U+5A7C  uni5A7C,  CJK UNIFIED IDEOGRAPH-5A7C
        0x5AA5, # G+8441  U+5AA5  uni5AA5,  CJK UNIFIED IDEOGRAPH-5AA5
        0x5AAC, # G+8442  U+5AAC  uni5AAC,  CJK UNIFIED IDEOGRAPH-5AAC
        0x5A95, # G+8443  U+5A95  uni5A95,  CJK UNIFIED IDEOGRAPH-5A95
        0x5AAE, # G+8444  U+5AAE  uni5AAE,  CJK UNIFIED IDEOGRAPH-5AAE
        0x5A37, # G+8445  U+5A37  uni5A37,  CJK UNIFIED IDEOGRAPH-5A37
        0x5A84, # G+8446  U+5A84  uni5A84,  CJK UNIFIED IDEOGRAPH-5A84
        0x5A8A, # G+8447  U+5A8A  uni5A8A,  CJK UNIFIED IDEOGRAPH-5A8A
        0x5A97, # G+8448  U+5A97  uni5A97,  CJK UNIFIED IDEOGRAPH-5A97
        0x5A83, # G+8449  U+5A83  uni5A83,  CJK UNIFIED IDEOGRAPH-5A83
        0x5A8B, # G+8450  U+5A8B  uni5A8B,  CJK UNIFIED IDEOGRAPH-5A8B
        0x5AA9, # G+8451  U+5AA9  uni5AA9,  CJK UNIFIED IDEOGRAPH-5AA9
        0x5A7B, # G+8452  U+5A7B  uni5A7B,  CJK UNIFIED IDEOGRAPH-5A7B
        0x5A7D, # G+8453  U+5A7D  uni5A7D,  CJK UNIFIED IDEOGRAPH-5A7D
        0x5A8C, # G+8454  U+5A8C  uni5A8C,  CJK UNIFIED IDEOGRAPH-5A8C
        0x5A9C, # G+8455  U+5A9C  uni5A9C,  CJK UNIFIED IDEOGRAPH-5A9C
        0x5A8F, # G+8456  U+5A8F  uni5A8F,  CJK UNIFIED IDEOGRAPH-5A8F
        0x5A93, # G+8457  U+5A93  uni5A93,  CJK UNIFIED IDEOGRAPH-5A93
        0x5A9D, # G+8458  U+5A9D  uni5A9D,  CJK UNIFIED IDEOGRAPH-5A9D
        0x5BEA, # G+8459  U+5BEA  uni5BEA,  CJK UNIFIED IDEOGRAPH-5BEA
        0x5BCD, # G+8460  U+5BCD  uni5BCD,  CJK UNIFIED IDEOGRAPH-5BCD
        0x5BCB, # G+8461  U+5BCB  uni5BCB,  CJK UNIFIED IDEOGRAPH-5BCB
        0x5BD4, # G+8462  U+5BD4  uni5BD4,  CJK UNIFIED IDEOGRAPH-5BD4
        0x5BD1, # G+8463  U+5BD1  uni5BD1,  CJK UNIFIED IDEOGRAPH-5BD1
        0x5BCA, # G+8464  U+5BCA  uni5BCA,  CJK UNIFIED IDEOGRAPH-5BCA
        0x5BCE, # G+8465  U+5BCE  uni5BCE,  CJK UNIFIED IDEOGRAPH-5BCE
        0x5C0C, # G+8466  U+5C0C  uni5C0C,  CJK UNIFIED IDEOGRAPH-5C0C
        0x5C30, # G+8467  U+5C30  uni5C30,  CJK UNIFIED IDEOGRAPH-5C30
        0x5D37, # G+8468  U+5D37  uni5D37,  CJK UNIFIED IDEOGRAPH-5D37
        0x5D43, # G+8469  U+5D43  uni5D43,  CJK UNIFIED IDEOGRAPH-5D43
        0x5D6B, # G+8470  U+5D6B  uni5D6B,  CJK UNIFIED IDEOGRAPH-5D6B
        0x5D41, # G+8471  U+5D41  uni5D41,  CJK UNIFIED IDEOGRAPH-5D41
        0x5D4B, # G+8472  U+5D4B  uni5D4B,  CJK UNIFIED IDEOGRAPH-5D4B
        0x5D3F, # G+8473  U+5D3F  uni5D3F,  CJK UNIFIED IDEOGRAPH-5D3F
        0x5D35, # G+8474  U+5D35  uni5D35,  CJK UNIFIED IDEOGRAPH-5D35
        0x5D51, # G+8475  U+5D51  uni5D51,  CJK UNIFIED IDEOGRAPH-5D51
        0x5D4E, # G+8476  U+5D4E  uni5D4E,  CJK UNIFIED IDEOGRAPH-5D4E
        0x5D55, # G+8477  U+5D55  uni5D55,  CJK UNIFIED IDEOGRAPH-5D55
        0x5D33, # G+8478  U+5D33  uni5D33,  CJK UNIFIED IDEOGRAPH-5D33
        0x5D3A, # G+8479  U+5D3A  uni5D3A,  CJK UNIFIED IDEOGRAPH-5D3A
        0x5D52, # G+8480  U+5D52  uni5D52,  CJK UNIFIED IDEOGRAPH-5D52
        0x5D3D, # G+8481  U+5D3D  uni5D3D,  CJK UNIFIED IDEOGRAPH-5D3D
        0x5D31, # G+8482  U+5D31  uni5D31,  CJK UNIFIED IDEOGRAPH-5D31
        0x5D59, # G+8483  U+5D59  uni5D59,  CJK UNIFIED IDEOGRAPH-5D59
        0x5D42, # G+8484  U+5D42  uni5D42,  CJK UNIFIED IDEOGRAPH-5D42
        0x5D39, # G+8485  U+5D39  uni5D39,  CJK UNIFIED IDEOGRAPH-5D39
        0x5D49, # G+8486  U+5D49  uni5D49,  CJK UNIFIED IDEOGRAPH-5D49
        0x5D38, # G+8487  U+5D38  uni5D38,  CJK UNIFIED IDEOGRAPH-5D38
        0x5D3C, # G+8488  U+5D3C  uni5D3C,  CJK UNIFIED IDEOGRAPH-5D3C
        0x5D32, # G+8489  U+5D32  uni5D32,  CJK UNIFIED IDEOGRAPH-5D32
        0x5D36, # G+8490  U+5D36  uni5D36,  CJK UNIFIED IDEOGRAPH-5D36
        0x5D40, # G+8491  U+5D40  uni5D40,  CJK UNIFIED IDEOGRAPH-5D40
        0x5D45, # G+8492  U+5D45  uni5D45,  CJK UNIFIED IDEOGRAPH-5D45
        0x5E44, # G+8493  U+5E44  uni5E44,  CJK UNIFIED IDEOGRAPH-5E44
        0x5E41, # G+8494  U+5E41  uni5E41,  CJK UNIFIED IDEOGRAPH-5E41
        0x5F58, # G+8495  U+5F58  uni5F58,  CJK UNIFIED IDEOGRAPH-5F58
        0x5FA6, # G+8496  U+5FA6  uni5FA6,  CJK UNIFIED IDEOGRAPH-5FA6
        0x5FA5, # G+8497  U+5FA5  uni5FA5,  CJK UNIFIED IDEOGRAPH-5FA5
        0x5FAB, # G+8498  U+5FAB  uni5FAB,  CJK UNIFIED IDEOGRAPH-5FAB
        0x60C9, # G+8499  U+60C9  uni60C9,  CJK UNIFIED IDEOGRAPH-60C9
        0x60B9, # G+8500  U+60B9  uni60B9,  CJK UNIFIED IDEOGRAPH-60B9
        0x60CC, # G+8501  U+60CC  uni60CC,  CJK UNIFIED IDEOGRAPH-60CC
        0x60E2, # G+8502  U+60E2  uni60E2,  CJK UNIFIED IDEOGRAPH-60E2
        0x60CE, # G+8503  U+60CE  uni60CE,  CJK UNIFIED IDEOGRAPH-60CE
        0x60C4, # G+8504  U+60C4  uni60C4,  CJK UNIFIED IDEOGRAPH-60C4
        0x6114, # G+8505  U+6114  uni6114,  CJK UNIFIED IDEOGRAPH-6114
        0x60F2, # G+8506  U+60F2  uni60F2,  CJK UNIFIED IDEOGRAPH-60F2
        0x610A, # G+8507  U+610A  uni610A,  CJK UNIFIED IDEOGRAPH-610A
        0x6116, # G+8508  U+6116  uni6116,  CJK UNIFIED IDEOGRAPH-6116
        0x6105, # G+8509  U+6105  uni6105,  CJK UNIFIED IDEOGRAPH-6105
        0x60F5, # G+8510  U+60F5  uni60F5,  CJK UNIFIED IDEOGRAPH-60F5
        0x6113, # G+8511  U+6113  uni6113,  CJK UNIFIED IDEOGRAPH-6113
        0x60F8, # G+8512  U+60F8  uni60F8,  CJK UNIFIED IDEOGRAPH-60F8
        0x60FC, # G+8513  U+60FC  uni60FC,  CJK UNIFIED IDEOGRAPH-60FC
        0x60FE, # G+8514  U+60FE  uni60FE,  CJK UNIFIED IDEOGRAPH-60FE
        0x60C1, # G+8515  U+60C1  uni60C1,  CJK UNIFIED IDEOGRAPH-60C1
        0x6103, # G+8516  U+6103  uni6103,  CJK UNIFIED IDEOGRAPH-6103
        0x6118, # G+8517  U+6118  uni6118,  CJK UNIFIED IDEOGRAPH-6118
        0x611D, # G+8518  U+611D  uni611D,  CJK UNIFIED IDEOGRAPH-611D
        0x6110, # G+8519  U+6110  uni6110,  CJK UNIFIED IDEOGRAPH-6110
        0x60FF, # G+8520  U+60FF  uni60FF,  CJK UNIFIED IDEOGRAPH-60FF
        0x6104, # G+8521  U+6104  uni6104,  CJK UNIFIED IDEOGRAPH-6104
        0x610B, # G+8522  U+610B  uni610B,  CJK UNIFIED IDEOGRAPH-610B
        0x624A, # G+8523  U+624A  uni624A,  CJK UNIFIED IDEOGRAPH-624A
        0x6394, # G+8524  U+6394  uni6394,  CJK UNIFIED IDEOGRAPH-6394
        0x63B1, # G+8525  U+63B1  uni63B1,  CJK UNIFIED IDEOGRAPH-63B1
        0x63B0, # G+8526  U+63B0  uni63B0,  CJK UNIFIED IDEOGRAPH-63B0
        0x63CE, # G+8527  U+63CE  uni63CE,  CJK UNIFIED IDEOGRAPH-63CE
        0x63E5, # G+8528  U+63E5  uni63E5,  CJK UNIFIED IDEOGRAPH-63E5
        0x63E8, # G+8529  U+63E8  uni63E8,  CJK UNIFIED IDEOGRAPH-63E8
        0x63EF, # G+8530  U+63EF  uni63EF,  CJK UNIFIED IDEOGRAPH-63EF
        0x63C3, # G+8531  U+63C3  uni63C3,  CJK UNIFIED IDEOGRAPH-63C3
        0x649D, # G+8532  U+649D  uni649D,  CJK UNIFIED IDEOGRAPH-649D
        0x63F3, # G+8533  U+63F3  uni63F3,  CJK UNIFIED IDEOGRAPH-63F3
        0x63CA, # G+8534  U+63CA  uni63CA,  CJK UNIFIED IDEOGRAPH-63CA
        0x63E0, # G+8535  U+63E0  uni63E0,  CJK UNIFIED IDEOGRAPH-63E0
        0x63F6, # G+8536  U+63F6  uni63F6,  CJK UNIFIED IDEOGRAPH-63F6
        0x63D5, # G+8537  U+63D5  uni63D5,  CJK UNIFIED IDEOGRAPH-63D5
        0x63F2, # G+8538  U+63F2  uni63F2,  CJK UNIFIED IDEOGRAPH-63F2
        0x63F5, # G+8539  U+63F5  uni63F5,  CJK UNIFIED IDEOGRAPH-63F5
        0x6461, # G+8540  U+6461  uni6461,  CJK UNIFIED IDEOGRAPH-6461
        0x63DF, # G+8541  U+63DF  uni63DF,  CJK UNIFIED IDEOGRAPH-63DF
        0x63BE, # G+8542  U+63BE  uni63BE,  CJK UNIFIED IDEOGRAPH-63BE
        0x63DD, # G+8543  U+63DD  uni63DD,  CJK UNIFIED IDEOGRAPH-63DD
        0x63DC, # G+8544  U+63DC  uni63DC,  CJK UNIFIED IDEOGRAPH-63DC
        0x63C4, # G+8545  U+63C4  uni63C4,  CJK UNIFIED IDEOGRAPH-63C4
        0x63D8, # G+8546  U+63D8  uni63D8,  CJK UNIFIED IDEOGRAPH-63D8
        0x63D3, # G+8547  U+63D3  uni63D3,  CJK UNIFIED IDEOGRAPH-63D3
        0x63C2, # G+8548  U+63C2  uni63C2,  CJK UNIFIED IDEOGRAPH-63C2
        0x63C7, # G+8549  U+63C7  uni63C7,  CJK UNIFIED IDEOGRAPH-63C7
        0x63CC, # G+8550  U+63CC  uni63CC,  CJK UNIFIED IDEOGRAPH-63CC
        0x63CB, # G+8551  U+63CB  uni63CB,  CJK UNIFIED IDEOGRAPH-63CB
        0x63C8, # G+8552  U+63C8  uni63C8,  CJK UNIFIED IDEOGRAPH-63C8
        0x63F0, # G+8553  U+63F0  uni63F0,  CJK UNIFIED IDEOGRAPH-63F0
        0x63D7, # G+8554  U+63D7  uni63D7,  CJK UNIFIED IDEOGRAPH-63D7
        0x63D9, # G+8555  U+63D9  uni63D9,  CJK UNIFIED IDEOGRAPH-63D9
        0x6532, # G+8556  U+6532  uni6532,  CJK UNIFIED IDEOGRAPH-6532
        0x6567, # G+8557  U+6567  uni6567,  CJK UNIFIED IDEOGRAPH-6567
        0x656A, # G+8558  U+656A  uni656A,  CJK UNIFIED IDEOGRAPH-656A
        0x6564, # G+8559  U+6564  uni6564,  CJK UNIFIED IDEOGRAPH-6564
        0x655C, # G+8560  U+655C  uni655C,  CJK UNIFIED IDEOGRAPH-655C
        0x6568, # G+8561  U+6568  uni6568,  CJK UNIFIED IDEOGRAPH-6568
        0x6565, # G+8562  U+6565  uni6565,  CJK UNIFIED IDEOGRAPH-6565
        0x658C, # G+8563  U+658C  uni658C,  CJK UNIFIED IDEOGRAPH-658C
        0x659D, # G+8564  U+659D  uni659D,  CJK UNIFIED IDEOGRAPH-659D
        0x659E, # G+8565  U+659E  uni659E,  CJK UNIFIED IDEOGRAPH-659E
        0x65AE, # G+8566  U+65AE  uni65AE,  CJK UNIFIED IDEOGRAPH-65AE
        0x65D0, # G+8567  U+65D0  uni65D0,  CJK UNIFIED IDEOGRAPH-65D0
        0x65D2, # G+8568  U+65D2  uni65D2,  CJK UNIFIED IDEOGRAPH-65D2
        0x667C, # G+8569  U+667C  uni667C,  CJK UNIFIED IDEOGRAPH-667C
        0x666C, # G+8570  U+666C  uni666C,  CJK UNIFIED IDEOGRAPH-666C
        0x667B, # G+8571  U+667B  uni667B,  CJK UNIFIED IDEOGRAPH-667B
        0x6680, # G+8572  U+6680  uni6680,  CJK UNIFIED IDEOGRAPH-6680
        0x6671, # G+8573  U+6671  uni6671,  CJK UNIFIED IDEOGRAPH-6671
        0x6679, # G+8574  U+6679  uni6679,  CJK UNIFIED IDEOGRAPH-6679
        0x666A, # G+8575  U+666A  uni666A,  CJK UNIFIED IDEOGRAPH-666A
        0x6672, # G+8576  U+6672  uni6672,  CJK UNIFIED IDEOGRAPH-6672
        0x6701, # G+8577  U+6701  uni6701,  CJK UNIFIED IDEOGRAPH-6701
        0x690C, # G+8578  U+690C  uni690C,  CJK UNIFIED IDEOGRAPH-690C
        0x68D3, # G+8579  U+68D3  uni68D3,  CJK UNIFIED IDEOGRAPH-68D3
        0x6904, # G+8580  U+6904  uni6904,  CJK UNIFIED IDEOGRAPH-6904
        0x68DC, # G+8581  U+68DC  uni68DC,  CJK UNIFIED IDEOGRAPH-68DC
        0x692A, # G+8582  U+692A  uni692A,  CJK UNIFIED IDEOGRAPH-692A
        0x68EC, # G+8583  U+68EC  uni68EC,  CJK UNIFIED IDEOGRAPH-68EC
        0x68EA, # G+8584  U+68EA  uni68EA,  CJK UNIFIED IDEOGRAPH-68EA
        0x68F1, # G+8585  U+68F1  uni68F1,  CJK UNIFIED IDEOGRAPH-68F1
        0x690F, # G+8586  U+690F  uni690F,  CJK UNIFIED IDEOGRAPH-690F
        0x68D6, # G+8587  U+68D6  uni68D6,  CJK UNIFIED IDEOGRAPH-68D6
        0x68F7, # G+8588  U+68F7  uni68F7,  CJK UNIFIED IDEOGRAPH-68F7
        0x68EB, # G+8589  U+68EB  uni68EB,  CJK UNIFIED IDEOGRAPH-68EB
        0x68E4, # G+8590  U+68E4  uni68E4,  CJK UNIFIED IDEOGRAPH-68E4
        0x68F6, # G+8591  U+68F6  uni68F6,  CJK UNIFIED IDEOGRAPH-68F6
        0x6913, # G+8592  U+6913  uni6913,  CJK UNIFIED IDEOGRAPH-6913
        0x6910, # G+8593  U+6910  uni6910,  CJK UNIFIED IDEOGRAPH-6910
        0x68F3, # G+8594  U+68F3  uni68F3,  CJK UNIFIED IDEOGRAPH-68F3
        0x68E1, # G+8595  U+68E1  uni68E1,  CJK UNIFIED IDEOGRAPH-68E1
        0x6907, # G+8596  U+6907  uni6907,  CJK UNIFIED IDEOGRAPH-6907
        0x68CC, # G+8597  U+68CC  uni68CC,  CJK UNIFIED IDEOGRAPH-68CC
        0x6908, # G+8598  U+6908  uni6908,  CJK UNIFIED IDEOGRAPH-6908
        0x6970, # G+8599  U+6970  uni6970,  CJK UNIFIED IDEOGRAPH-6970
        0x68B4, # G+8600  U+68B4  uni68B4,  CJK UNIFIED IDEOGRAPH-68B4
        0x6911, # G+8601  U+6911  uni6911,  CJK UNIFIED IDEOGRAPH-6911
        0x68EF, # G+8602  U+68EF  uni68EF,  CJK UNIFIED IDEOGRAPH-68EF
        0x68C6, # G+8603  U+68C6  uni68C6,  CJK UNIFIED IDEOGRAPH-68C6
        0x6914, # G+8604  U+6914  uni6914,  CJK UNIFIED IDEOGRAPH-6914
        0x68F8, # G+8605  U+68F8  uni68F8,  CJK UNIFIED IDEOGRAPH-68F8
        0x68D0, # G+8606  U+68D0  uni68D0,  CJK UNIFIED IDEOGRAPH-68D0
        0x68FD, # G+8607  U+68FD  uni68FD,  CJK UNIFIED IDEOGRAPH-68FD
        0x68FC, # G+8608  U+68FC  uni68FC,  CJK UNIFIED IDEOGRAPH-68FC
        0x68E8, # G+8609  U+68E8  uni68E8,  CJK UNIFIED IDEOGRAPH-68E8
        0x690B, # G+8610  U+690B  uni690B,  CJK UNIFIED IDEOGRAPH-690B
        0x690A, # G+8611  U+690A  uni690A,  CJK UNIFIED IDEOGRAPH-690A
        0x6917, # G+8612  U+6917  uni6917,  CJK UNIFIED IDEOGRAPH-6917
        0x68CE, # G+8613  U+68CE  uni68CE,  CJK UNIFIED IDEOGRAPH-68CE
        0x68C8, # G+8614  U+68C8  uni68C8,  CJK UNIFIED IDEOGRAPH-68C8
        0x68DD, # G+8615  U+68DD  uni68DD,  CJK UNIFIED IDEOGRAPH-68DD
        0x68DE, # G+8616  U+68DE  uni68DE,  CJK UNIFIED IDEOGRAPH-68DE
        0x68E6, # G+8617  U+68E6  uni68E6,  CJK UNIFIED IDEOGRAPH-68E6
        0x68F4, # G+8618  U+68F4  uni68F4,  CJK UNIFIED IDEOGRAPH-68F4
        0x68D1, # G+8619  U+68D1  uni68D1,  CJK UNIFIED IDEOGRAPH-68D1
        0x6906, # G+8620  U+6906  uni6906,  CJK UNIFIED IDEOGRAPH-6906
        0x68D4, # G+8621  U+68D4  uni68D4,  CJK UNIFIED IDEOGRAPH-68D4
        0x68E9, # G+8622  U+68E9  uni68E9,  CJK UNIFIED IDEOGRAPH-68E9
        0x6915, # G+8623  U+6915  uni6915,  CJK UNIFIED IDEOGRAPH-6915
        0x6925, # G+8624  U+6925  uni6925,  CJK UNIFIED IDEOGRAPH-6925
        0x68C7, # G+8625  U+68C7  uni68C7,  CJK UNIFIED IDEOGRAPH-68C7
        0x6B39, # G+8626  U+6B39  uni6B39,  CJK UNIFIED IDEOGRAPH-6B39
        0x6B3B, # G+8627  U+6B3B  uni6B3B,  CJK UNIFIED IDEOGRAPH-6B3B
        0x6B3F, # G+8628  U+6B3F  uni6B3F,  CJK UNIFIED IDEOGRAPH-6B3F
        0x6B3C, # G+8629  U+6B3C  uni6B3C,  CJK UNIFIED IDEOGRAPH-6B3C
        0x6B94, # G+8630  U+6B94  uni6B94,  CJK UNIFIED IDEOGRAPH-6B94
        0x6B97, # G+8631  U+6B97  uni6B97,  CJK UNIFIED IDEOGRAPH-6B97
        0x6B99, # G+8632  U+6B99  uni6B99,  CJK UNIFIED IDEOGRAPH-6B99
        0x6B95, # G+8633  U+6B95  uni6B95,  CJK UNIFIED IDEOGRAPH-6B95
        0x6BBD, # G+8634  U+6BBD  uni6BBD,  CJK UNIFIED IDEOGRAPH-6BBD
        0x6BF0, # G+8635  U+6BF0  uni6BF0,  CJK UNIFIED IDEOGRAPH-6BF0
        0x6BF2, # G+8636  U+6BF2  uni6BF2,  CJK UNIFIED IDEOGRAPH-6BF2
        0x6BF3, # G+8637  U+6BF3  uni6BF3,  CJK UNIFIED IDEOGRAPH-6BF3
        0x6C30, # G+8638  U+6C30  uni6C30,  CJK UNIFIED IDEOGRAPH-6C30
        0x6DFC, # G+8639  U+6DFC  uni6DFC,  CJK UNIFIED IDEOGRAPH-6DFC
        0x6E46, # G+8640  U+6E46  uni6E46,  CJK UNIFIED IDEOGRAPH-6E46
        0x6E47, # G+8641  U+6E47  uni6E47,  CJK UNIFIED IDEOGRAPH-6E47
        0x6E1F, # G+8642  U+6E1F  uni6E1F,  CJK UNIFIED IDEOGRAPH-6E1F
        0x6E49, # G+8643  U+6E49  uni6E49,  CJK UNIFIED IDEOGRAPH-6E49
        0x6E88, # G+8644  U+6E88  uni6E88,  CJK UNIFIED IDEOGRAPH-6E88
        0x6E3C, # G+8645  U+6E3C  uni6E3C,  CJK UNIFIED IDEOGRAPH-6E3C
        0x6E3D, # G+8646  U+6E3D  uni6E3D,  CJK UNIFIED IDEOGRAPH-6E3D
        0x6E45, # G+8647  U+6E45  uni6E45,  CJK UNIFIED IDEOGRAPH-6E45
        0x6E62, # G+8648  U+6E62  uni6E62,  CJK UNIFIED IDEOGRAPH-6E62
        0x6E2B, # G+8649  U+6E2B  uni6E2B,  CJK UNIFIED IDEOGRAPH-6E2B
        0x6E3F, # G+8650  U+6E3F  uni6E3F,  CJK UNIFIED IDEOGRAPH-6E3F
        0x6E41, # G+8651  U+6E41  uni6E41,  CJK UNIFIED IDEOGRAPH-6E41
        0x6E5D, # G+8652  U+6E5D  uni6E5D,  CJK UNIFIED IDEOGRAPH-6E5D
        0x6E73, # G+8653  U+6E73  uni6E73,  CJK UNIFIED IDEOGRAPH-6E73
        0x6E1C, # G+8654  U+6E1C  uni6E1C,  CJK UNIFIED IDEOGRAPH-6E1C
        0x6E33, # G+8655  U+6E33  uni6E33,  CJK UNIFIED IDEOGRAPH-6E33
        0x6E4B, # G+8656  U+6E4B  uni6E4B,  CJK UNIFIED IDEOGRAPH-6E4B
        0x6E40, # G+8657  U+6E40  uni6E40,  CJK UNIFIED IDEOGRAPH-6E40
        0x6E51, # G+8658  U+6E51  uni6E51,  CJK UNIFIED IDEOGRAPH-6E51
        0x6E3B, # G+8659  U+6E3B  uni6E3B,  CJK UNIFIED IDEOGRAPH-6E3B
        0x6E03, # G+8660  U+6E03  uni6E03,  CJK UNIFIED IDEOGRAPH-6E03
        0x6E2E, # G+8661  U+6E2E  uni6E2E,  CJK UNIFIED IDEOGRAPH-6E2E
        0x6E5E, # G+8662  U+6E5E  uni6E5E,  CJK UNIFIED IDEOGRAPH-6E5E
        0x6E68, # G+8663  U+6E68  uni6E68,  CJK UNIFIED IDEOGRAPH-6E68
        0x6E5C, # G+8664  U+6E5C  uni6E5C,  CJK UNIFIED IDEOGRAPH-6E5C
        0x6E61, # G+8665  U+6E61  uni6E61,  CJK UNIFIED IDEOGRAPH-6E61
        0x6E31, # G+8666  U+6E31  uni6E31,  CJK UNIFIED IDEOGRAPH-6E31
        0x6E28, # G+8667  U+6E28  uni6E28,  CJK UNIFIED IDEOGRAPH-6E28
        0x6E60, # G+8668  U+6E60  uni6E60,  CJK UNIFIED IDEOGRAPH-6E60
        0x6E71, # G+8669  U+6E71  uni6E71,  CJK UNIFIED IDEOGRAPH-6E71
        0x6E6B, # G+8670  U+6E6B  uni6E6B,  CJK UNIFIED IDEOGRAPH-6E6B
        0x6E39, # G+8671  U+6E39  uni6E39,  CJK UNIFIED IDEOGRAPH-6E39
        0x6E22, # G+8672  U+6E22  uni6E22,  CJK UNIFIED IDEOGRAPH-6E22
        0x6E30, # G+8673  U+6E30  uni6E30,  CJK UNIFIED IDEOGRAPH-6E30
        0x6E53, # G+8674  U+6E53  uni6E53,  CJK UNIFIED IDEOGRAPH-6E53
        0x6E65, # G+8675  U+6E65  uni6E65,  CJK UNIFIED IDEOGRAPH-6E65
        0x6E27, # G+8676  U+6E27  uni6E27,  CJK UNIFIED IDEOGRAPH-6E27
        0x6E78, # G+8677  U+6E78  uni6E78,  CJK UNIFIED IDEOGRAPH-6E78
        0x6E64, # G+8678  U+6E64  uni6E64,  CJK UNIFIED IDEOGRAPH-6E64
        0x6E77, # G+8679  U+6E77  uni6E77,  CJK UNIFIED IDEOGRAPH-6E77
        0x6E55, # G+8680  U+6E55  uni6E55,  CJK UNIFIED IDEOGRAPH-6E55
        0x6E79, # G+8681  U+6E79  uni6E79,  CJK UNIFIED IDEOGRAPH-6E79
        0x6E52, # G+8682  U+6E52  uni6E52,  CJK UNIFIED IDEOGRAPH-6E52
        0x6E66, # G+8683  U+6E66  uni6E66,  CJK UNIFIED IDEOGRAPH-6E66
        0x6E35, # G+8684  U+6E35  uni6E35,  CJK UNIFIED IDEOGRAPH-6E35
        0x6E36, # G+8685  U+6E36  uni6E36,  CJK UNIFIED IDEOGRAPH-6E36
        0x6E5A, # G+8686  U+6E5A  uni6E5A,  CJK UNIFIED IDEOGRAPH-6E5A
        0x7120, # G+8687  U+7120  uni7120,  CJK UNIFIED IDEOGRAPH-7120
        0x711E, # G+8688  U+711E  uni711E,  CJK UNIFIED IDEOGRAPH-711E
        0x712F, # G+8689  U+712F  uni712F,  CJK UNIFIED IDEOGRAPH-712F
        0x70FB, # G+8690  U+70FB  uni70FB,  CJK UNIFIED IDEOGRAPH-70FB
        0x712E, # G+8691  U+712E  uni712E,  CJK UNIFIED IDEOGRAPH-712E
        0x7131, # G+8692  U+7131  uni7131,  CJK UNIFIED IDEOGRAPH-7131
        0x7123, # G+8693  U+7123  uni7123,  CJK UNIFIED IDEOGRAPH-7123
        0x7125, # G+8694  U+7125  uni7125,  CJK UNIFIED IDEOGRAPH-7125
        0x7122, # G+8695  U+7122  uni7122,  CJK UNIFIED IDEOGRAPH-7122
        0x7132, # G+8696  U+7132  uni7132,  CJK UNIFIED IDEOGRAPH-7132
        0x711F, # G+8697  U+711F  uni711F,  CJK UNIFIED IDEOGRAPH-711F
        0x7128, # G+8698  U+7128  uni7128,  CJK UNIFIED IDEOGRAPH-7128
        0x713A, # G+8699  U+713A  uni713A,  CJK UNIFIED IDEOGRAPH-713A
        0x711B, # G+8700  U+711B  uni711B,  CJK UNIFIED IDEOGRAPH-711B
        0x724B, # G+8701  U+724B  uni724B,  CJK UNIFIED IDEOGRAPH-724B
        0x725A, # G+8702  U+725A  uni725A,  CJK UNIFIED IDEOGRAPH-725A
        0x7288, # G+8703  U+7288  uni7288,  CJK UNIFIED IDEOGRAPH-7288
        0x7289, # G+8704  U+7289  uni7289,  CJK UNIFIED IDEOGRAPH-7289
        0x7286, # G+8705  U+7286  uni7286,  CJK UNIFIED IDEOGRAPH-7286
        0x7285, # G+8706  U+7285  uni7285,  CJK UNIFIED IDEOGRAPH-7285
        0x728B, # G+8707  U+728B  uni728B,  CJK UNIFIED IDEOGRAPH-728B
        0x7312, # G+8708  U+7312  uni7312,  CJK UNIFIED IDEOGRAPH-7312
        0x730B, # G+8709  U+730B  uni730B,  CJK UNIFIED IDEOGRAPH-730B
        0x7330, # G+8710  U+7330  uni7330,  CJK UNIFIED IDEOGRAPH-7330
        0x7322, # G+8711  U+7322  uni7322,  CJK UNIFIED IDEOGRAPH-7322
        0x7331, # G+8712  U+7331  uni7331,  CJK UNIFIED IDEOGRAPH-7331
        0x7333, # G+8713  U+7333  uni7333,  CJK UNIFIED IDEOGRAPH-7333
        0x7327, # G+8714  U+7327  uni7327,  CJK UNIFIED IDEOGRAPH-7327
        0x7332, # G+8715  U+7332  uni7332,  CJK UNIFIED IDEOGRAPH-7332
        0x732D, # G+8716  U+732D  uni732D,  CJK UNIFIED IDEOGRAPH-732D
        0x7326, # G+8717  U+7326  uni7326,  CJK UNIFIED IDEOGRAPH-7326
        0x7323, # G+8718  U+7323  uni7323,  CJK UNIFIED IDEOGRAPH-7323
        0x7335, # G+8719  U+7335  uni7335,  CJK UNIFIED IDEOGRAPH-7335
        0x730C, # G+8720  U+730C  uni730C,  CJK UNIFIED IDEOGRAPH-730C
        0x742E, # G+8721  U+742E  uni742E,  CJK UNIFIED IDEOGRAPH-742E
        0x742C, # G+8722  U+742C  uni742C,  CJK UNIFIED IDEOGRAPH-742C
        0x7430, # G+8723  U+7430  uni7430,  CJK UNIFIED IDEOGRAPH-7430
        0x742B, # G+8724  U+742B  uni742B,  CJK UNIFIED IDEOGRAPH-742B
        0x7416, # G+8725  U+7416  uni7416,  CJK UNIFIED IDEOGRAPH-7416
        0x741A, # G+8726  U+741A  uni741A,  CJK UNIFIED IDEOGRAPH-741A
        0x7421, # G+8727  U+7421  uni7421,  CJK UNIFIED IDEOGRAPH-7421
        0x742D, # G+8728  U+742D  uni742D,  CJK UNIFIED IDEOGRAPH-742D
        0x7431, # G+8729  U+7431  uni7431,  CJK UNIFIED IDEOGRAPH-7431
        0x7424, # G+8730  U+7424  uni7424,  CJK UNIFIED IDEOGRAPH-7424
        0x7423, # G+8731  U+7423  uni7423,  CJK UNIFIED IDEOGRAPH-7423
        0x741D, # G+8732  U+741D  uni741D,  CJK UNIFIED IDEOGRAPH-741D
        0x7429, # G+8733  U+7429  uni7429,  CJK UNIFIED IDEOGRAPH-7429
        0x7420, # G+8734  U+7420  uni7420,  CJK UNIFIED IDEOGRAPH-7420
        0x7432, # G+8735  U+7432  uni7432,  CJK UNIFIED IDEOGRAPH-7432
        0x74FB, # G+8736  U+74FB  uni74FB,  CJK UNIFIED IDEOGRAPH-74FB
        0x752F, # G+8737  U+752F  uni752F,  CJK UNIFIED IDEOGRAPH-752F
        0x756F, # G+8738  U+756F  uni756F,  CJK UNIFIED IDEOGRAPH-756F
        0x756C, # G+8739  U+756C  uni756C,  CJK UNIFIED IDEOGRAPH-756C
        0x75E7, # G+8740  U+75E7  uni75E7,  CJK UNIFIED IDEOGRAPH-75E7
        0x75DA, # G+8741  U+75DA  uni75DA,  CJK UNIFIED IDEOGRAPH-75DA
        0x75E1, # G+8742  U+75E1  uni75E1,  CJK UNIFIED IDEOGRAPH-75E1
        0x75E6, # G+8743  U+75E6  uni75E6,  CJK UNIFIED IDEOGRAPH-75E6
        0x75DD, # G+8744  U+75DD  uni75DD,  CJK UNIFIED IDEOGRAPH-75DD
        0x75DF, # G+8745  U+75DF  uni75DF,  CJK UNIFIED IDEOGRAPH-75DF
        0x75E4, # G+8746  U+75E4  uni75E4,  CJK UNIFIED IDEOGRAPH-75E4
        0x75D7, # G+8747  U+75D7  uni75D7,  CJK UNIFIED IDEOGRAPH-75D7
        0x7695, # G+8748  U+7695  uni7695,  CJK UNIFIED IDEOGRAPH-7695
        0x7692, # G+8749  U+7692  uni7692,  CJK UNIFIED IDEOGRAPH-7692
        0x76DA, # G+8750  U+76DA  uni76DA,  CJK UNIFIED IDEOGRAPH-76DA
        0x7746, # G+8751  U+7746  uni7746,  CJK UNIFIED IDEOGRAPH-7746
        0x7747, # G+8752  U+7747  uni7747,  CJK UNIFIED IDEOGRAPH-7747
        0x7744, # G+8753  U+7744  uni7744,  CJK UNIFIED IDEOGRAPH-7744
        0x774D, # G+8754  U+774D  uni774D,  CJK UNIFIED IDEOGRAPH-774D
        0x7745, # G+8755  U+7745  uni7745,  CJK UNIFIED IDEOGRAPH-7745
        0x774A, # G+8756  U+774A  uni774A,  CJK UNIFIED IDEOGRAPH-774A
        0x774E, # G+8757  U+774E  uni774E,  CJK UNIFIED IDEOGRAPH-774E
        0x774B, # G+8758  U+774B  uni774B,  CJK UNIFIED IDEOGRAPH-774B
        0x774C, # G+8759  U+774C  uni774C,  CJK UNIFIED IDEOGRAPH-774C
        0x77DE, # G+8760  U+77DE  uni77DE,  CJK UNIFIED IDEOGRAPH-77DE
        0x77EC, # G+8761  U+77EC  uni77EC,  CJK UNIFIED IDEOGRAPH-77EC
        0x7860, # G+8762  U+7860  uni7860,  CJK UNIFIED IDEOGRAPH-7860
        0x7864, # G+8763  U+7864  uni7864,  CJK UNIFIED IDEOGRAPH-7864
        0x7865, # G+8764  U+7865  uni7865,  CJK UNIFIED IDEOGRAPH-7865
        0x785C, # G+8765  U+785C  uni785C,  CJK UNIFIED IDEOGRAPH-785C
        0x786D, # G+8766  U+786D  uni786D,  CJK UNIFIED IDEOGRAPH-786D
        0x7871, # G+8767  U+7871  uni7871,  CJK UNIFIED IDEOGRAPH-7871
        0x786A, # G+8768  U+786A  uni786A,  CJK UNIFIED IDEOGRAPH-786A
        0x786E, # G+8769  U+786E  uni786E,  CJK UNIFIED IDEOGRAPH-786E
        0x7870, # G+8770  U+7870  uni7870,  CJK UNIFIED IDEOGRAPH-7870
        0x7869, # G+8771  U+7869  uni7869,  CJK UNIFIED IDEOGRAPH-7869
        0x7868, # G+8772  U+7868  uni7868,  CJK UNIFIED IDEOGRAPH-7868
        0x785E, # G+8773  U+785E  uni785E,  CJK UNIFIED IDEOGRAPH-785E
        0x7862, # G+8774  U+7862  uni7862,  CJK UNIFIED IDEOGRAPH-7862
        0x7974, # G+8775  U+7974  uni7974,  CJK UNIFIED IDEOGRAPH-7974
        0x7973, # G+8776  U+7973  uni7973,  CJK UNIFIED IDEOGRAPH-7973
        0x7972, # G+8777  U+7972  uni7972,  CJK UNIFIED IDEOGRAPH-7972
        0x7970, # G+8778  U+7970  uni7970,  CJK UNIFIED IDEOGRAPH-7970
        0x7A02, # G+8779  U+7A02  uni7A02,  CJK UNIFIED IDEOGRAPH-7A02
        0x7A0A, # G+8780  U+7A0A  uni7A0A,  CJK UNIFIED IDEOGRAPH-7A0A
        0x7A03, # G+8781  U+7A03  uni7A03,  CJK UNIFIED IDEOGRAPH-7A03
        0x7A0C, # G+8782  U+7A0C  uni7A0C,  CJK UNIFIED IDEOGRAPH-7A0C
        0x7A04, # G+8783  U+7A04  uni7A04,  CJK UNIFIED IDEOGRAPH-7A04
        0x7A99, # G+8784  U+7A99  uni7A99,  CJK UNIFIED IDEOGRAPH-7A99
        0x7AE6, # G+8785  U+7AE6  uni7AE6,  CJK UNIFIED IDEOGRAPH-7AE6
        0x7AE4, # G+8786  U+7AE4  uni7AE4,  CJK UNIFIED IDEOGRAPH-7AE4
        0x7B4A, # G+8787  U+7B4A  uni7B4A,  CJK UNIFIED IDEOGRAPH-7B4A
        0x7B47, # G+8788  U+7B47  uni7B47,  CJK UNIFIED IDEOGRAPH-7B47
        0x7B44, # G+8789  U+7B44  uni7B44,  CJK UNIFIED IDEOGRAPH-7B44
        0x7B48, # G+8790  U+7B48  uni7B48,  CJK UNIFIED IDEOGRAPH-7B48
        0x7B4C, # G+8791  U+7B4C  uni7B4C,  CJK UNIFIED IDEOGRAPH-7B4C
        0x7B4E, # G+8792  U+7B4E  uni7B4E,  CJK UNIFIED IDEOGRAPH-7B4E
        0x7B40, # G+8793  U+7B40  uni7B40,  CJK UNIFIED IDEOGRAPH-7B40
        0x7B58, # G+8794  U+7B58  uni7B58,  CJK UNIFIED IDEOGRAPH-7B58
        0x7B45, # G+8795  U+7B45  uni7B45,  CJK UNIFIED IDEOGRAPH-7B45
        0x7CA2, # G+8796  U+7CA2  uni7CA2,  CJK UNIFIED IDEOGRAPH-7CA2
        0x7C9E, # G+8797  U+7C9E  uni7C9E,  CJK UNIFIED IDEOGRAPH-7C9E
        0x7CA8, # G+8798  U+7CA8  uni7CA8,  CJK UNIFIED IDEOGRAPH-7CA8
        0x7CA1, # G+8799  U+7CA1  uni7CA1,  CJK UNIFIED IDEOGRAPH-7CA1
        0x7D58, # G+8800  U+7D58  uni7D58,  CJK UNIFIED IDEOGRAPH-7D58
        0x7D6F, # G+8801  U+7D6F  uni7D6F,  CJK UNIFIED IDEOGRAPH-7D6F
        0x7D63, # G+8802  U+7D63  uni7D63,  CJK UNIFIED IDEOGRAPH-7D63
        0x7D53, # G+8803  U+7D53  uni7D53,  CJK UNIFIED IDEOGRAPH-7D53
        0x7D56, # G+8804  U+7D56  uni7D56,  CJK UNIFIED IDEOGRAPH-7D56
        0x7D67, # G+8805  U+7D67  uni7D67,  CJK UNIFIED IDEOGRAPH-7D67
        0x7D6A, # G+8806  U+7D6A  uni7D6A,  CJK UNIFIED IDEOGRAPH-7D6A
        0x7D4F, # G+8807  U+7D4F  uni7D4F,  CJK UNIFIED IDEOGRAPH-7D4F
        0x7D6D, # G+8808  U+7D6D  uni7D6D,  CJK UNIFIED IDEOGRAPH-7D6D
        0x7D5C, # G+8809  U+7D5C  uni7D5C,  CJK UNIFIED IDEOGRAPH-7D5C
        0x7D6B, # G+8810  U+7D6B  uni7D6B,  CJK UNIFIED IDEOGRAPH-7D6B
        0x7D52, # G+8811  U+7D52  uni7D52,  CJK UNIFIED IDEOGRAPH-7D52
        0x7D54, # G+8812  U+7D54  uni7D54,  CJK UNIFIED IDEOGRAPH-7D54
        0x7D69, # G+8813  U+7D69  uni7D69,  CJK UNIFIED IDEOGRAPH-7D69
        0x7D51, # G+8814  U+7D51  uni7D51,  CJK UNIFIED IDEOGRAPH-7D51
        0x7D5F, # G+8815  U+7D5F  uni7D5F,  CJK UNIFIED IDEOGRAPH-7D5F
        0x7D4E, # G+8816  U+7D4E  uni7D4E,  CJK UNIFIED IDEOGRAPH-7D4E
        0x7F3E, # G+8817  U+7F3E  uni7F3E,  CJK UNIFIED IDEOGRAPH-7F3E
        0x7F3F, # G+8818  U+7F3F  uni7F3F,  CJK UNIFIED IDEOGRAPH-7F3F
        0x7F65, # G+8819  U+7F65  uni7F65,  CJK UNIFIED IDEOGRAPH-7F65
        0x7F66, # G+8820  U+7F66  uni7F66,  CJK UNIFIED IDEOGRAPH-7F66
        0x7FA2, # G+8821  U+7FA2  uni7FA2,  CJK UNIFIED IDEOGRAPH-7FA2
        0x7FA0, # G+8822  U+7FA0  uni7FA0,  CJK UNIFIED IDEOGRAPH-7FA0
        0x7FA1, # G+8823  U+7FA1  uni7FA1,  CJK UNIFIED IDEOGRAPH-7FA1
        0x7FD7, # G+8824  U+7FD7  uni7FD7,  CJK UNIFIED IDEOGRAPH-7FD7
        0x8051, # G+8825  U+8051  uni8051,  CJK UNIFIED IDEOGRAPH-8051
        0x804F, # G+8826  U+804F  uni804F,  CJK UNIFIED IDEOGRAPH-804F
        0x8050, # G+8827  U+8050  uni8050,  CJK UNIFIED IDEOGRAPH-8050
        0x80FE, # G+8828  U+80FE  uni80FE,  CJK UNIFIED IDEOGRAPH-80FE
        0x80D4, # G+8829  U+80D4  uni80D4,  CJK UNIFIED IDEOGRAPH-80D4
        0x8143, # G+8830  U+8143  uni8143,  CJK UNIFIED IDEOGRAPH-8143
        0x814A, # G+8831  U+814A  uni814A,  CJK UNIFIED IDEOGRAPH-814A
        0x8152, # G+8832  U+8152  uni8152,  CJK UNIFIED IDEOGRAPH-8152
        0x814F, # G+8833  U+814F  uni814F,  CJK UNIFIED IDEOGRAPH-814F
        0x8147, # G+8834  U+8147  uni8147,  CJK UNIFIED IDEOGRAPH-8147
        0x813D, # G+8835  U+813D  uni813D,  CJK UNIFIED IDEOGRAPH-813D
        0x814D, # G+8836  U+814D  uni814D,  CJK UNIFIED IDEOGRAPH-814D
        0x813A, # G+8837  U+813A  uni813A,  CJK UNIFIED IDEOGRAPH-813A
        0x81E6, # G+8838  U+81E6  uni81E6,  CJK UNIFIED IDEOGRAPH-81E6
        0x81EE, # G+8839  U+81EE  uni81EE,  CJK UNIFIED IDEOGRAPH-81EE
        0x81F7, # G+8840  U+81F7  uni81F7,  CJK UNIFIED IDEOGRAPH-81F7
        0x81F8, # G+8841  U+81F8  uni81F8,  CJK UNIFIED IDEOGRAPH-81F8
        0x81F9, # G+8842  U+81F9  uni81F9,  CJK UNIFIED IDEOGRAPH-81F9
        0x8204, # G+8843  U+8204  uni8204,  CJK UNIFIED IDEOGRAPH-8204
        0x823C, # G+8844  U+823C  uni823C,  CJK UNIFIED IDEOGRAPH-823C
        0x823D, # G+8845  U+823D  uni823D,  CJK UNIFIED IDEOGRAPH-823D
        0x823F, # G+8846  U+823F  uni823F,  CJK UNIFIED IDEOGRAPH-823F
        0x8275, # G+8847  U+8275  uni8275,  CJK UNIFIED IDEOGRAPH-8275
        0x833B, # G+8848  U+833B  uni833B,  CJK UNIFIED IDEOGRAPH-833B
        0x83CF, # G+8849  U+83CF  uni83CF,  CJK UNIFIED IDEOGRAPH-83CF
        0x83F9, # G+8850  U+83F9  uni83F9,  CJK UNIFIED IDEOGRAPH-83F9
        0x8423, # G+8851  U+8423  uni8423,  CJK UNIFIED IDEOGRAPH-8423
        0x83C0, # G+8852  U+83C0  uni83C0,  CJK UNIFIED IDEOGRAPH-83C0
        0x83E8, # G+8853  U+83E8  uni83E8,  CJK UNIFIED IDEOGRAPH-83E8
        0x8412, # G+8854  U+8412  uni8412,  CJK UNIFIED IDEOGRAPH-8412
        0x83E7, # G+8855  U+83E7  uni83E7,  CJK UNIFIED IDEOGRAPH-83E7
        0x83E4, # G+8856  U+83E4  uni83E4,  CJK UNIFIED IDEOGRAPH-83E4
        0x83FC, # G+8857  U+83FC  uni83FC,  CJK UNIFIED IDEOGRAPH-83FC
        0x83F6, # G+8858  U+83F6  uni83F6,  CJK UNIFIED IDEOGRAPH-83F6
        0x8410, # G+8859  U+8410  uni8410,  CJK UNIFIED IDEOGRAPH-8410
        0x83C6, # G+8860  U+83C6  uni83C6,  CJK UNIFIED IDEOGRAPH-83C6
        0x83C8, # G+8861  U+83C8  uni83C8,  CJK UNIFIED IDEOGRAPH-83C8
        0x83EB, # G+8862  U+83EB  uni83EB,  CJK UNIFIED IDEOGRAPH-83EB
        0x83E3, # G+8863  U+83E3  uni83E3,  CJK UNIFIED IDEOGRAPH-83E3
        0x83BF, # G+8864  U+83BF  uni83BF,  CJK UNIFIED IDEOGRAPH-83BF
        0x8401, # G+8865  U+8401  uni8401,  CJK UNIFIED IDEOGRAPH-8401
        0x83DD, # G+8866  U+83DD  uni83DD,  CJK UNIFIED IDEOGRAPH-83DD
        0x83E5, # G+8867  U+83E5  uni83E5,  CJK UNIFIED IDEOGRAPH-83E5
        0x83D8, # G+8868  U+83D8  uni83D8,  CJK UNIFIED IDEOGRAPH-83D8
        0x83FF, # G+8869  U+83FF  uni83FF,  CJK UNIFIED IDEOGRAPH-83FF
        0x83E1, # G+8870  U+83E1  uni83E1,  CJK UNIFIED IDEOGRAPH-83E1
        0x83CB, # G+8871  U+83CB  uni83CB,  CJK UNIFIED IDEOGRAPH-83CB
        0x83CE, # G+8872  U+83CE  uni83CE,  CJK UNIFIED IDEOGRAPH-83CE
        0x83D6, # G+8873  U+83D6  uni83D6,  CJK UNIFIED IDEOGRAPH-83D6
        0x83F5, # G+8874  U+83F5  uni83F5,  CJK UNIFIED IDEOGRAPH-83F5
        0x83C9, # G+8875  U+83C9  uni83C9,  CJK UNIFIED IDEOGRAPH-83C9
        0x8409, # G+8876  U+8409  uni8409,  CJK UNIFIED IDEOGRAPH-8409
        0x840F, # G+8877  U+840F  uni840F,  CJK UNIFIED IDEOGRAPH-840F
        0x83DE, # G+8878  U+83DE  uni83DE,  CJK UNIFIED IDEOGRAPH-83DE
        0x8411, # G+8879  U+8411  uni8411,  CJK UNIFIED IDEOGRAPH-8411
        0x8406, # G+8880  U+8406  uni8406,  CJK UNIFIED IDEOGRAPH-8406
        0x83C2, # G+8881  U+83C2  uni83C2,  CJK UNIFIED IDEOGRAPH-83C2
        0x83F3, # G+8882  U+83F3  uni83F3,  CJK UNIFIED IDEOGRAPH-83F3
        0x83D5, # G+8883  U+83D5  uni83D5,  CJK UNIFIED IDEOGRAPH-83D5
        0x83FA, # G+8884  U+83FA  uni83FA,  CJK UNIFIED IDEOGRAPH-83FA
        0x83C7, # G+8885  U+83C7  uni83C7,  CJK UNIFIED IDEOGRAPH-83C7
        0x83D1, # G+8886  U+83D1  uni83D1,  CJK UNIFIED IDEOGRAPH-83D1
        0x83EA, # G+8887  U+83EA  uni83EA,  CJK UNIFIED IDEOGRAPH-83EA
        0x8413, # G+8888  U+8413  uni8413,  CJK UNIFIED IDEOGRAPH-8413
        0x839A, # G+8889  U+839A  uni839A,  CJK UNIFIED IDEOGRAPH-839A
        0x83C3, # G+8890  U+83C3  uni83C3,  CJK UNIFIED IDEOGRAPH-83C3
        0x83EC, # G+8891  U+83EC  uni83EC,  CJK UNIFIED IDEOGRAPH-83EC
        0x83EE, # G+8892  U+83EE  uni83EE,  CJK UNIFIED IDEOGRAPH-83EE
        0x83C4, # G+8893  U+83C4  uni83C4,  CJK UNIFIED IDEOGRAPH-83C4
        0x83FB, # G+8894  U+83FB  uni83FB,  CJK UNIFIED IDEOGRAPH-83FB
        0x83D7, # G+8895  U+83D7  uni83D7,  CJK UNIFIED IDEOGRAPH-83D7
        0x83E2, # G+8896  U+83E2  uni83E2,  CJK UNIFIED IDEOGRAPH-83E2
        0x841B, # G+8897  U+841B  uni841B,  CJK UNIFIED IDEOGRAPH-841B
        0x83DB, # G+8898  U+83DB  uni83DB,  CJK UNIFIED IDEOGRAPH-83DB
        0x83FE, # G+8899  U+83FE  uni83FE,  CJK UNIFIED IDEOGRAPH-83FE
        0x86D8, # G+8900  U+86D8  uni86D8,  CJK UNIFIED IDEOGRAPH-86D8
        0x86E2, # G+8901  U+86E2  uni86E2,  CJK UNIFIED IDEOGRAPH-86E2
        0x86E6, # G+8902  U+86E6  uni86E6,  CJK UNIFIED IDEOGRAPH-86E6
        0x86D3, # G+8903  U+86D3  uni86D3,  CJK UNIFIED IDEOGRAPH-86D3
        0x86E3, # G+8904  U+86E3  uni86E3,  CJK UNIFIED IDEOGRAPH-86E3
        0x86DA, # G+8905  U+86DA  uni86DA,  CJK UNIFIED IDEOGRAPH-86DA
        0x86EA, # G+8906  U+86EA  uni86EA,  CJK UNIFIED IDEOGRAPH-86EA
        0x86DD, # G+8907  U+86DD  uni86DD,  CJK UNIFIED IDEOGRAPH-86DD
        0x86EB, # G+8908  U+86EB  uni86EB,  CJK UNIFIED IDEOGRAPH-86EB
        0x86DC, # G+8909  U+86DC  uni86DC,  CJK UNIFIED IDEOGRAPH-86DC
        0x86EC, # G+8910  U+86EC  uni86EC,  CJK UNIFIED IDEOGRAPH-86EC
        0x86E9, # G+8911  U+86E9  uni86E9,  CJK UNIFIED IDEOGRAPH-86E9
        0x86D7, # G+8912  U+86D7  uni86D7,  CJK UNIFIED IDEOGRAPH-86D7
        0x86E8, # G+8913  U+86E8  uni86E8,  CJK UNIFIED IDEOGRAPH-86E8
        0x86D1, # G+8914  U+86D1  uni86D1,  CJK UNIFIED IDEOGRAPH-86D1
        0x8848, # G+8915  U+8848  uni8848,  CJK UNIFIED IDEOGRAPH-8848
        0x8856, # G+8916  U+8856  uni8856,  CJK UNIFIED IDEOGRAPH-8856
        0x8855, # G+8917  U+8855  uni8855,  CJK UNIFIED IDEOGRAPH-8855
        0x88BA, # G+8918  U+88BA  uni88BA,  CJK UNIFIED IDEOGRAPH-88BA
        0x88D7, # G+8919  U+88D7  uni88D7,  CJK UNIFIED IDEOGRAPH-88D7
        0x88B9, # G+8920  U+88B9  uni88B9,  CJK UNIFIED IDEOGRAPH-88B9
        0x88B8, # G+8921  U+88B8  uni88B8,  CJK UNIFIED IDEOGRAPH-88B8
        0x88C0, # G+8922  U+88C0  uni88C0,  CJK UNIFIED IDEOGRAPH-88C0
        0x88BE, # G+8923  U+88BE  uni88BE,  CJK UNIFIED IDEOGRAPH-88BE
        0x88B6, # G+8924  U+88B6  uni88B6,  CJK UNIFIED IDEOGRAPH-88B6
        0x88BC, # G+8925  U+88BC  uni88BC,  CJK UNIFIED IDEOGRAPH-88BC
        0x88B7, # G+8926  U+88B7  uni88B7,  CJK UNIFIED IDEOGRAPH-88B7
        0x88BD, # G+8927  U+88BD  uni88BD,  CJK UNIFIED IDEOGRAPH-88BD
        0x88B2, # G+8928  U+88B2  uni88B2,  CJK UNIFIED IDEOGRAPH-88B2
        0x8901, # G+8929  U+8901  uni8901,  CJK UNIFIED IDEOGRAPH-8901
        0x88C9, # G+8930  U+88C9  uni88C9,  CJK UNIFIED IDEOGRAPH-88C9
        0x8995, # G+8931  U+8995  uni8995,  CJK UNIFIED IDEOGRAPH-8995
        0x8998, # G+8932  U+8998  uni8998,  CJK UNIFIED IDEOGRAPH-8998
        0x8997, # G+8933  U+8997  uni8997,  CJK UNIFIED IDEOGRAPH-8997
        0x89DD, # G+8934  U+89DD  uni89DD,  CJK UNIFIED IDEOGRAPH-89DD
        0x89DA, # G+8935  U+89DA  uni89DA,  CJK UNIFIED IDEOGRAPH-89DA
        0x89DB, # G+8936  U+89DB  uni89DB,  CJK UNIFIED IDEOGRAPH-89DB
        0x8A4E, # G+8937  U+8A4E  uni8A4E,  CJK UNIFIED IDEOGRAPH-8A4E
        0x8A4D, # G+8938  U+8A4D  uni8A4D,  CJK UNIFIED IDEOGRAPH-8A4D
        0x8A39, # G+8939  U+8A39  uni8A39,  CJK UNIFIED IDEOGRAPH-8A39
        0x8A59, # G+8940  U+8A59  uni8A59,  CJK UNIFIED IDEOGRAPH-8A59
        0x8A40, # G+8941  U+8A40  uni8A40,  CJK UNIFIED IDEOGRAPH-8A40
        0x8A57, # G+8942  U+8A57  uni8A57,  CJK UNIFIED IDEOGRAPH-8A57
        0x8A58, # G+8943  U+8A58  uni8A58,  CJK UNIFIED IDEOGRAPH-8A58
        0x8A44, # G+8944  U+8A44  uni8A44,  CJK UNIFIED IDEOGRAPH-8A44
        0x8A45, # G+8945  U+8A45  uni8A45,  CJK UNIFIED IDEOGRAPH-8A45
        0x8A52, # G+8946  U+8A52  uni8A52,  CJK UNIFIED IDEOGRAPH-8A52
        0x8A48, # G+8947  U+8A48  uni8A48,  CJK UNIFIED IDEOGRAPH-8A48
        0x8A51, # G+8948  U+8A51  uni8A51,  CJK UNIFIED IDEOGRAPH-8A51
        0x8A4A, # G+8949  U+8A4A  uni8A4A,  CJK UNIFIED IDEOGRAPH-8A4A
        0x8A4C, # G+8950  U+8A4C  uni8A4C,  CJK UNIFIED IDEOGRAPH-8A4C
        0x8A4F, # G+8951  U+8A4F  uni8A4F,  CJK UNIFIED IDEOGRAPH-8A4F
        0x8C5F, # G+8952  U+8C5F  uni8C5F,  CJK UNIFIED IDEOGRAPH-8C5F
        0x8C81, # G+8953  U+8C81  uni8C81,  CJK UNIFIED IDEOGRAPH-8C81
        0x8C80, # G+8954  U+8C80  uni8C80,  CJK UNIFIED IDEOGRAPH-8C80
        0x8CBA, # G+8955  U+8CBA  uni8CBA,  CJK UNIFIED IDEOGRAPH-8CBA
        0x8CBE, # G+8956  U+8CBE  uni8CBE,  CJK UNIFIED IDEOGRAPH-8CBE
        0x8CB0, # G+8957  U+8CB0  uni8CB0,  CJK UNIFIED IDEOGRAPH-8CB0
        0x8CB9, # G+8958  U+8CB9  uni8CB9,  CJK UNIFIED IDEOGRAPH-8CB9
        0x8CB5, # G+8959  U+8CB5  uni8CB5,  CJK UNIFIED IDEOGRAPH-8CB5
        0x8D84, # G+8960  U+8D84  uni8D84,  CJK UNIFIED IDEOGRAPH-8D84
        0x8D80, # G+8961  U+8D80  uni8D80,  CJK UNIFIED IDEOGRAPH-8D80
        0x8D89, # G+8962  U+8D89  uni8D89,  CJK UNIFIED IDEOGRAPH-8D89
        0x8DD8, # G+8963  U+8DD8  uni8DD8,  CJK UNIFIED IDEOGRAPH-8DD8
        0x8DD3, # G+8964  U+8DD3  uni8DD3,  CJK UNIFIED IDEOGRAPH-8DD3
        0x8DCD, # G+8965  U+8DCD  uni8DCD,  CJK UNIFIED IDEOGRAPH-8DCD
        0x8DC7, # G+8966  U+8DC7  uni8DC7,  CJK UNIFIED IDEOGRAPH-8DC7
        0x8DD6, # G+8967  U+8DD6  uni8DD6,  CJK UNIFIED IDEOGRAPH-8DD6
        0x8DDC, # G+8968  U+8DDC  uni8DDC,  CJK UNIFIED IDEOGRAPH-8DDC
        0x8DCF, # G+8969  U+8DCF  uni8DCF,  CJK UNIFIED IDEOGRAPH-8DCF
        0x8DD5, # G+8970  U+8DD5  uni8DD5,  CJK UNIFIED IDEOGRAPH-8DD5
        0x8DD9, # G+8971  U+8DD9  uni8DD9,  CJK UNIFIED IDEOGRAPH-8DD9
        0x8DC8, # G+8972  U+8DC8  uni8DC8,  CJK UNIFIED IDEOGRAPH-8DC8
        0x8DD7, # G+8973  U+8DD7  uni8DD7,  CJK UNIFIED IDEOGRAPH-8DD7
        0x8DC5, # G+8974  U+8DC5  uni8DC5,  CJK UNIFIED IDEOGRAPH-8DC5
        0x8EEF, # G+8975  U+8EEF  uni8EEF,  CJK UNIFIED IDEOGRAPH-8EEF
        0x8EF7, # G+8976  U+8EF7  uni8EF7,  CJK UNIFIED IDEOGRAPH-8EF7
        0x8EFA, # G+8977  U+8EFA  uni8EFA,  CJK UNIFIED IDEOGRAPH-8EFA
        0x8EF9, # G+8978  U+8EF9  uni8EF9,  CJK UNIFIED IDEOGRAPH-8EF9
        0x8EE6, # G+8979  U+8EE6  uni8EE6,  CJK UNIFIED IDEOGRAPH-8EE6
        0x8EEE, # G+8980  U+8EEE  uni8EEE,  CJK UNIFIED IDEOGRAPH-8EEE
        0x8EE5, # G+8981  U+8EE5  uni8EE5,  CJK UNIFIED IDEOGRAPH-8EE5
        0x8EF5, # G+8982  U+8EF5  uni8EF5,  CJK UNIFIED IDEOGRAPH-8EF5
        0x8EE7, # G+8983  U+8EE7  uni8EE7,  CJK UNIFIED IDEOGRAPH-8EE7
        0x8EE8, # G+8984  U+8EE8  uni8EE8,  CJK UNIFIED IDEOGRAPH-8EE8
        0x8EF6, # G+8985  U+8EF6  uni8EF6,  CJK UNIFIED IDEOGRAPH-8EF6
        0x8EEB, # G+8986  U+8EEB  uni8EEB,  CJK UNIFIED IDEOGRAPH-8EEB
        0x8EF1, # G+8987  U+8EF1  uni8EF1,  CJK UNIFIED IDEOGRAPH-8EF1
        0x8EEC, # G+8988  U+8EEC  uni8EEC,  CJK UNIFIED IDEOGRAPH-8EEC
        0x8EF4, # G+8989  U+8EF4  uni8EF4,  CJK UNIFIED IDEOGRAPH-8EF4
        0x8EE9, # G+8990  U+8EE9  uni8EE9,  CJK UNIFIED IDEOGRAPH-8EE9
        0x902D, # G+8991  U+902D  uni902D,  CJK UNIFIED IDEOGRAPH-902D
        0x9034, # G+8992  U+9034  uni9034,  CJK UNIFIED IDEOGRAPH-9034
        0x902F, # G+8993  U+902F  uni902F,  CJK UNIFIED IDEOGRAPH-902F
        0x9106, # G+8994  U+9106  uni9106,  CJK UNIFIED IDEOGRAPH-9106
        0x912C, # G+8995  U+912C  uni912C,  CJK UNIFIED IDEOGRAPH-912C
        0x9104, # G+8996  U+9104  uni9104,  CJK UNIFIED IDEOGRAPH-9104
        0x90FF, # G+8997  U+90FF  uni90FF,  CJK UNIFIED IDEOGRAPH-90FF
        0x90FC, # G+8998  U+90FC  uni90FC,  CJK UNIFIED IDEOGRAPH-90FC
        0x9108, # G+8999  U+9108  uni9108,  CJK UNIFIED IDEOGRAPH-9108
        0x90F9, # G+9000  U+90F9  uni90F9,  CJK UNIFIED IDEOGRAPH-90F9
        0x90FB, # G+9001  U+90FB  uni90FB,  CJK UNIFIED IDEOGRAPH-90FB
        0x9101, # G+9002  U+9101  uni9101,  CJK UNIFIED IDEOGRAPH-9101
        0x9100, # G+9003  U+9100  uni9100,  CJK UNIFIED IDEOGRAPH-9100
        0x9107, # G+9004  U+9107  uni9107,  CJK UNIFIED IDEOGRAPH-9107
        0x9105, # G+9005  U+9105  uni9105,  CJK UNIFIED IDEOGRAPH-9105
        0x9103, # G+9006  U+9103  uni9103,  CJK UNIFIED IDEOGRAPH-9103
        0x9161, # G+9007  U+9161  uni9161,  CJK UNIFIED IDEOGRAPH-9161
        0x9164, # G+9008  U+9164  uni9164,  CJK UNIFIED IDEOGRAPH-9164
        0x915F, # G+9009  U+915F  uni915F,  CJK UNIFIED IDEOGRAPH-915F
        0x9162, # G+9010  U+9162  uni9162,  CJK UNIFIED IDEOGRAPH-9162
        0x9160, # G+9011  U+9160  uni9160,  CJK UNIFIED IDEOGRAPH-9160
        0x9201, # G+9012  U+9201  uni9201,  CJK UNIFIED IDEOGRAPH-9201
        0x920A, # G+9013  U+920A  uni920A,  CJK UNIFIED IDEOGRAPH-920A
        0x9225, # G+9014  U+9225  uni9225,  CJK UNIFIED IDEOGRAPH-9225
        0x9203, # G+9015  U+9203  uni9203,  CJK UNIFIED IDEOGRAPH-9203
        0x921A, # G+9016  U+921A  uni921A,  CJK UNIFIED IDEOGRAPH-921A
        0x9226, # G+9017  U+9226  uni9226,  CJK UNIFIED IDEOGRAPH-9226
        0x920F, # G+9018  U+920F  uni920F,  CJK UNIFIED IDEOGRAPH-920F
        0x920C, # G+9019  U+920C  uni920C,  CJK UNIFIED IDEOGRAPH-920C
        0x9200, # G+9020  U+9200  uni9200,  CJK UNIFIED IDEOGRAPH-9200
        0x9212, # G+9021  U+9212  uni9212,  CJK UNIFIED IDEOGRAPH-9212
        0x91FF, # G+9022  U+91FF  uni91FF,  CJK UNIFIED IDEOGRAPH-91FF
        0x91FD, # G+9023  U+91FD  uni91FD,  CJK UNIFIED IDEOGRAPH-91FD
        0x9206, # G+9024  U+9206  uni9206,  CJK UNIFIED IDEOGRAPH-9206
        0x9204, # G+9025  U+9204  uni9204,  CJK UNIFIED IDEOGRAPH-9204
        0x9227, # G+9026  U+9227  uni9227,  CJK UNIFIED IDEOGRAPH-9227
        0x9202, # G+9027  U+9202  uni9202,  CJK UNIFIED IDEOGRAPH-9202
        0x921C, # G+9028  U+921C  uni921C,  CJK UNIFIED IDEOGRAPH-921C
        0x9224, # G+9029  U+9224  uni9224,  CJK UNIFIED IDEOGRAPH-9224
        0x9219, # G+9030  U+9219  uni9219,  CJK UNIFIED IDEOGRAPH-9219
        0x9217, # G+9031  U+9217  uni9217,  CJK UNIFIED IDEOGRAPH-9217
        0x9205, # G+9032  U+9205  uni9205,  CJK UNIFIED IDEOGRAPH-9205
        0x9216, # G+9033  U+9216  uni9216,  CJK UNIFIED IDEOGRAPH-9216
        0x957B, # G+9034  U+957B  uni957B,  CJK UNIFIED IDEOGRAPH-957B
        0x958D, # G+9035  U+958D  uni958D,  CJK UNIFIED IDEOGRAPH-958D
        0x958C, # G+9036  U+958C  uni958C,  CJK UNIFIED IDEOGRAPH-958C
        0x9590, # G+9037  U+9590  uni9590,  CJK UNIFIED IDEOGRAPH-9590
        0x9687, # G+9038  U+9687  uni9687,  CJK UNIFIED IDEOGRAPH-9687
        0x967E, # G+9039  U+967E  uni967E,  CJK UNIFIED IDEOGRAPH-967E
        0x9688, # G+9040  U+9688  uni9688,  CJK UNIFIED IDEOGRAPH-9688
        0x9689, # G+9041  U+9689  uni9689,  CJK UNIFIED IDEOGRAPH-9689
        0x9683, # G+9042  U+9683  uni9683,  CJK UNIFIED IDEOGRAPH-9683
        0x9680, # G+9043  U+9680  uni9680,  CJK UNIFIED IDEOGRAPH-9680
        0x96C2, # G+9044  U+96C2  uni96C2,  CJK UNIFIED IDEOGRAPH-96C2
        0x96C8, # G+9045  U+96C8  uni96C8,  CJK UNIFIED IDEOGRAPH-96C8
        0x96C3, # G+9046  U+96C3  uni96C3,  CJK UNIFIED IDEOGRAPH-96C3
        0x96F1, # G+9047  U+96F1  uni96F1,  CJK UNIFIED IDEOGRAPH-96F1
        0x96F0, # G+9048  U+96F0  uni96F0,  CJK UNIFIED IDEOGRAPH-96F0
        0x976C, # G+9049  U+976C  uni976C,  CJK UNIFIED IDEOGRAPH-976C
        0x9770, # G+9050  U+9770  uni9770,  CJK UNIFIED IDEOGRAPH-9770
        0x976E, # G+9051  U+976E  uni976E,  CJK UNIFIED IDEOGRAPH-976E
        0x9807, # G+9052  U+9807  uni9807,  CJK UNIFIED IDEOGRAPH-9807
        0x98A9, # G+9053  U+98A9  uni98A9,  CJK UNIFIED IDEOGRAPH-98A9
        0x98EB, # G+9054  U+98EB  uni98EB,  CJK UNIFIED IDEOGRAPH-98EB
        0x9CE6, # G+9055  U+9CE6  uni9CE6,  CJK UNIFIED IDEOGRAPH-9CE6
        0x2FCB, # G+9056  U+2FCB  uni2FCB,  KANGXI RADICAL EMBROIDERY
        0x4E83, # G+9057  U+4E83  uni4E83,  CJK UNIFIED IDEOGRAPH-4E83
        0x4E84, # G+9058  U+4E84  uni4E84,  CJK UNIFIED IDEOGRAPH-4E84
        0x4EB6, # G+9059  U+4EB6  uni4EB6,  CJK UNIFIED IDEOGRAPH-4EB6
        0x50BD, # G+9060  U+50BD  uni50BD,  CJK UNIFIED IDEOGRAPH-50BD
        0x50BF, # G+9061  U+50BF  uni50BF,  CJK UNIFIED IDEOGRAPH-50BF
        0x50C6, # G+9062  U+50C6  uni50C6,  CJK UNIFIED IDEOGRAPH-50C6
        0x50AE, # G+9063  U+50AE  uni50AE,  CJK UNIFIED IDEOGRAPH-50AE
        0x50C4, # G+9064  U+50C4  uni50C4,  CJK UNIFIED IDEOGRAPH-50C4
        0x50CA, # G+9065  U+50CA  uni50CA,  CJK UNIFIED IDEOGRAPH-50CA
        0x50B4, # G+9066  U+50B4  uni50B4,  CJK UNIFIED IDEOGRAPH-50B4
        0x50C8, # G+9067  U+50C8  uni50C8,  CJK UNIFIED IDEOGRAPH-50C8
        0x50C2, # G+9068  U+50C2  uni50C2,  CJK UNIFIED IDEOGRAPH-50C2
        0x50B0, # G+9069  U+50B0  uni50B0,  CJK UNIFIED IDEOGRAPH-50B0
        0x50C1, # G+9070  U+50C1  uni50C1,  CJK UNIFIED IDEOGRAPH-50C1
        0x50BA, # G+9071  U+50BA  uni50BA,  CJK UNIFIED IDEOGRAPH-50BA
        0x50B1, # G+9072  U+50B1  uni50B1,  CJK UNIFIED IDEOGRAPH-50B1
        0x50CB, # G+9073  U+50CB  uni50CB,  CJK UNIFIED IDEOGRAPH-50CB
        0x50C9, # G+9074  U+50C9  uni50C9,  CJK UNIFIED IDEOGRAPH-50C9
        0x50B6, # G+9075  U+50B6  uni50B6,  CJK UNIFIED IDEOGRAPH-50B6
        0x50B8, # G+9076  U+50B8  uni50B8,  CJK UNIFIED IDEOGRAPH-50B8
        0x51D7, # G+9077  U+51D7  uni51D7,  CJK UNIFIED IDEOGRAPH-51D7
        0x527A, # G+9078  U+527A  uni527A,  CJK UNIFIED IDEOGRAPH-527A
        0x5278, # G+9079  U+5278  uni5278,  CJK UNIFIED IDEOGRAPH-5278
        0x527B, # G+9080  U+527B  uni527B,  CJK UNIFIED IDEOGRAPH-527B
        0x527C, # G+9081  U+527C  uni527C,  CJK UNIFIED IDEOGRAPH-527C
        0x55C3, # G+9082  U+55C3  uni55C3,  CJK UNIFIED IDEOGRAPH-55C3
        0x55DB, # G+9083  U+55DB  uni55DB,  CJK UNIFIED IDEOGRAPH-55DB
        0x55CC, # G+9084  U+55CC  uni55CC,  CJK UNIFIED IDEOGRAPH-55CC
        0x55D0, # G+9085  U+55D0  uni55D0,  CJK UNIFIED IDEOGRAPH-55D0
        0x55CB, # G+9086  U+55CB  uni55CB,  CJK UNIFIED IDEOGRAPH-55CB
        0x55CA, # G+9087  U+55CA  uni55CA,  CJK UNIFIED IDEOGRAPH-55CA
        0x55DD, # G+9088  U+55DD  uni55DD,  CJK UNIFIED IDEOGRAPH-55DD
        0x55C0, # G+9089  U+55C0  uni55C0,  CJK UNIFIED IDEOGRAPH-55C0
        0x55D4, # G+9090  U+55D4  uni55D4,  CJK UNIFIED IDEOGRAPH-55D4
        0x55C4, # G+9091  U+55C4  uni55C4,  CJK UNIFIED IDEOGRAPH-55C4
        0x55E9, # G+9092  U+55E9  uni55E9,  CJK UNIFIED IDEOGRAPH-55E9
        0x55BF, # G+9093  U+55BF  uni55BF,  CJK UNIFIED IDEOGRAPH-55BF
        0x55D2, # G+9094  U+55D2  uni55D2,  CJK UNIFIED IDEOGRAPH-55D2
        0x558D, # G+9095  U+558D  uni558D,  CJK UNIFIED IDEOGRAPH-558D
        0x55CF, # G+9096  U+55CF  uni55CF,  CJK UNIFIED IDEOGRAPH-55CF
        0x55D5, # G+9097  U+55D5  uni55D5,  CJK UNIFIED IDEOGRAPH-55D5
        0x55E2, # G+9098  U+55E2  uni55E2,  CJK UNIFIED IDEOGRAPH-55E2
        0x55D6, # G+9099  U+55D6  uni55D6,  CJK UNIFIED IDEOGRAPH-55D6
        0x55C8, # G+9100  U+55C8  uni55C8,  CJK UNIFIED IDEOGRAPH-55C8
        0x55F2, # G+9101  U+55F2  uni55F2,  CJK UNIFIED IDEOGRAPH-55F2
        0x55CD, # G+9102  U+55CD  uni55CD,  CJK UNIFIED IDEOGRAPH-55CD
        0x55D9, # G+9103  U+55D9  uni55D9,  CJK UNIFIED IDEOGRAPH-55D9
        0x55C2, # G+9104  U+55C2  uni55C2,  CJK UNIFIED IDEOGRAPH-55C2
        0x5714, # G+9105  U+5714  uni5714,  CJK UNIFIED IDEOGRAPH-5714
        0x5853, # G+9106  U+5853  uni5853,  CJK UNIFIED IDEOGRAPH-5853
        0x5868, # G+9107  U+5868  uni5868,  CJK UNIFIED IDEOGRAPH-5868
        0x5864, # G+9108  U+5864  uni5864,  CJK UNIFIED IDEOGRAPH-5864
        0x584F, # G+9109  U+584F  uni584F,  CJK UNIFIED IDEOGRAPH-584F
        0x584D, # G+9110  U+584D  uni584D,  CJK UNIFIED IDEOGRAPH-584D
        0x5849, # G+9111  U+5849  uni5849,  CJK UNIFIED IDEOGRAPH-5849
        0x586F, # G+9112  U+586F  uni586F,  CJK UNIFIED IDEOGRAPH-586F
        0x5855, # G+9113  U+5855  uni5855,  CJK UNIFIED IDEOGRAPH-5855
        0x584E, # G+9114  U+584E  uni584E,  CJK UNIFIED IDEOGRAPH-584E
        0x585D, # G+9115  U+585D  uni585D,  CJK UNIFIED IDEOGRAPH-585D
        0x5859, # G+9116  U+5859  uni5859,  CJK UNIFIED IDEOGRAPH-5859
        0x5865, # G+9117  U+5865  uni5865,  CJK UNIFIED IDEOGRAPH-5865
        0x585B, # G+9118  U+585B  uni585B,  CJK UNIFIED IDEOGRAPH-585B
        0x583D, # G+9119  U+583D  uni583D,  CJK UNIFIED IDEOGRAPH-583D
        0x5863, # G+9120  U+5863  uni5863,  CJK UNIFIED IDEOGRAPH-5863
        0x5871, # G+9121  U+5871  uni5871,  CJK UNIFIED IDEOGRAPH-5871
        0x58FC, # G+9122  U+58FC  uni58FC,  CJK UNIFIED IDEOGRAPH-58FC
        0x5AC7, # G+9123  U+5AC7  uni5AC7,  CJK UNIFIED IDEOGRAPH-5AC7
        0x5AC4, # G+9124  U+5AC4  uni5AC4,  CJK UNIFIED IDEOGRAPH-5AC4
        0x5ACB, # G+9125  U+5ACB  uni5ACB,  CJK UNIFIED IDEOGRAPH-5ACB
        0x5ABA, # G+9126  U+5ABA  uni5ABA,  CJK UNIFIED IDEOGRAPH-5ABA
        0x5AB8, # G+9127  U+5AB8  uni5AB8,  CJK UNIFIED IDEOGRAPH-5AB8
        0x5AB1, # G+9128  U+5AB1  uni5AB1,  CJK UNIFIED IDEOGRAPH-5AB1
        0x5AB5, # G+9129  U+5AB5  uni5AB5,  CJK UNIFIED IDEOGRAPH-5AB5
        0x5AB0, # G+9130  U+5AB0  uni5AB0,  CJK UNIFIED IDEOGRAPH-5AB0
        0x5ABF, # G+9131  U+5ABF  uni5ABF,  CJK UNIFIED IDEOGRAPH-5ABF
        0x5AC8, # G+9132  U+5AC8  uni5AC8,  CJK UNIFIED IDEOGRAPH-5AC8
        0x5ABB, # G+9133  U+5ABB  uni5ABB,  CJK UNIFIED IDEOGRAPH-5ABB
        0x5AC6, # G+9134  U+5AC6  uni5AC6,  CJK UNIFIED IDEOGRAPH-5AC6
        0x5AB7, # G+9135  U+5AB7  uni5AB7,  CJK UNIFIED IDEOGRAPH-5AB7
        0x5AC0, # G+9136  U+5AC0  uni5AC0,  CJK UNIFIED IDEOGRAPH-5AC0
        0x5ACA, # G+9137  U+5ACA  uni5ACA,  CJK UNIFIED IDEOGRAPH-5ACA
        0x5AB4, # G+9138  U+5AB4  uni5AB4,  CJK UNIFIED IDEOGRAPH-5AB4
        0x5AB6, # G+9139  U+5AB6  uni5AB6,  CJK UNIFIED IDEOGRAPH-5AB6
        0x5ACD, # G+9140  U+5ACD  uni5ACD,  CJK UNIFIED IDEOGRAPH-5ACD
        0x5AB9, # G+9141  U+5AB9  uni5AB9,  CJK UNIFIED IDEOGRAPH-5AB9
        0x5A90, # G+9142  U+5A90  uni5A90,  CJK UNIFIED IDEOGRAPH-5A90
        0x5BD6, # G+9143  U+5BD6  uni5BD6,  CJK UNIFIED IDEOGRAPH-5BD6
        0x5BD8, # G+9144  U+5BD8  uni5BD8,  CJK UNIFIED IDEOGRAPH-5BD8
        0x5BD9, # G+9145  U+5BD9  uni5BD9,  CJK UNIFIED IDEOGRAPH-5BD9
        0x5C1F, # G+9146  U+5C1F  uni5C1F,  CJK UNIFIED IDEOGRAPH-5C1F
        0x5C33, # G+9147  U+5C33  uni5C33,  CJK UNIFIED IDEOGRAPH-5C33
        0x5D71, # G+9148  U+5D71  uni5D71,  CJK UNIFIED IDEOGRAPH-5D71
        0x5D63, # G+9149  U+5D63  uni5D63,  CJK UNIFIED IDEOGRAPH-5D63
        0x5D4A, # G+9150  U+5D4A  uni5D4A,  CJK UNIFIED IDEOGRAPH-5D4A
        0x5D65, # G+9151  U+5D65  uni5D65,  CJK UNIFIED IDEOGRAPH-5D65
        0x5D72, # G+9152  U+5D72  uni5D72,  CJK UNIFIED IDEOGRAPH-5D72
        0x5D6C, # G+9153  U+5D6C  uni5D6C,  CJK UNIFIED IDEOGRAPH-5D6C
        0x5D5E, # G+9154  U+5D5E  uni5D5E,  CJK UNIFIED IDEOGRAPH-5D5E
        0x5D68, # G+9155  U+5D68  uni5D68,  CJK UNIFIED IDEOGRAPH-5D68
        0x5D67, # G+9156  U+5D67  uni5D67,  CJK UNIFIED IDEOGRAPH-5D67
        0x5D62, # G+9157  U+5D62  uni5D62,  CJK UNIFIED IDEOGRAPH-5D62
        0x5DF0, # G+9158  U+5DF0  uni5DF0,  CJK UNIFIED IDEOGRAPH-5DF0
        0x5E4F, # G+9159  U+5E4F  uni5E4F,  CJK UNIFIED IDEOGRAPH-5E4F
        0x5E4E, # G+9160  U+5E4E  uni5E4E,  CJK UNIFIED IDEOGRAPH-5E4E
        0x5E4A, # G+9161  U+5E4A  uni5E4A,  CJK UNIFIED IDEOGRAPH-5E4A
        0x5E4D, # G+9162  U+5E4D  uni5E4D,  CJK UNIFIED IDEOGRAPH-5E4D
        0x5E4B, # G+9163  U+5E4B  uni5E4B,  CJK UNIFIED IDEOGRAPH-5E4B
        0x5EC5, # G+9164  U+5EC5  uni5EC5,  CJK UNIFIED IDEOGRAPH-5EC5
        0x5ECC, # G+9165  U+5ECC  uni5ECC,  CJK UNIFIED IDEOGRAPH-5ECC
        0x5EC6, # G+9166  U+5EC6  uni5EC6,  CJK UNIFIED IDEOGRAPH-5EC6
        0x5ECB, # G+9167  U+5ECB  uni5ECB,  CJK UNIFIED IDEOGRAPH-5ECB
        0x5EC7, # G+9168  U+5EC7  uni5EC7,  CJK UNIFIED IDEOGRAPH-5EC7
        0x5F40, # G+9169  U+5F40  uni5F40,  CJK UNIFIED IDEOGRAPH-5F40
        0x5FAF, # G+9170  U+5FAF  uni5FAF,  CJK UNIFIED IDEOGRAPH-5FAF
        0x5FAD, # G+9171  U+5FAD  uni5FAD,  CJK UNIFIED IDEOGRAPH-5FAD
        0x60F7, # G+9172  U+60F7  uni60F7,  CJK UNIFIED IDEOGRAPH-60F7
        0x6149, # G+9173  U+6149  uni6149,  CJK UNIFIED IDEOGRAPH-6149
        0x614A, # G+9174  U+614A  uni614A,  CJK UNIFIED IDEOGRAPH-614A
        0x612B, # G+9175  U+612B  uni612B,  CJK UNIFIED IDEOGRAPH-612B
        0x6145, # G+9176  U+6145  uni6145,  CJK UNIFIED IDEOGRAPH-6145
        0x6136, # G+9177  U+6136  uni6136,  CJK UNIFIED IDEOGRAPH-6136
        0x6132, # G+9178  U+6132  uni6132,  CJK UNIFIED IDEOGRAPH-6132
        0x612E, # G+9179  U+612E  uni612E,  CJK UNIFIED IDEOGRAPH-612E
        0x6146, # G+9180  U+6146  uni6146,  CJK UNIFIED IDEOGRAPH-6146
        0x612F, # G+9181  U+612F  uni612F,  CJK UNIFIED IDEOGRAPH-612F
        0x614F, # G+9182  U+614F  uni614F,  CJK UNIFIED IDEOGRAPH-614F
        0x6129, # G+9183  U+6129  uni6129,  CJK UNIFIED IDEOGRAPH-6129
        0x6140, # G+9184  U+6140  uni6140,  CJK UNIFIED IDEOGRAPH-6140
        0x6220, # G+9185  U+6220  uni6220,  CJK UNIFIED IDEOGRAPH-6220
        0x9168, # G+9186  U+9168  uni9168,  CJK UNIFIED IDEOGRAPH-9168
        0x6223, # G+9187  U+6223  uni6223,  CJK UNIFIED IDEOGRAPH-6223
        0x6225, # G+9188  U+6225  uni6225,  CJK UNIFIED IDEOGRAPH-6225
        0x6224, # G+9189  U+6224  uni6224,  CJK UNIFIED IDEOGRAPH-6224
        0x63C5, # G+9190  U+63C5  uni63C5,  CJK UNIFIED IDEOGRAPH-63C5
        0x63F1, # G+9191  U+63F1  uni63F1,  CJK UNIFIED IDEOGRAPH-63F1
        0x63EB, # G+9192  U+63EB  uni63EB,  CJK UNIFIED IDEOGRAPH-63EB
        0x6410, # G+9193  U+6410  uni6410,  CJK UNIFIED IDEOGRAPH-6410
        0x6412, # G+9194  U+6412  uni6412,  CJK UNIFIED IDEOGRAPH-6412
        0x6409, # G+9195  U+6409  uni6409,  CJK UNIFIED IDEOGRAPH-6409
        0x6420, # G+9196  U+6420  uni6420,  CJK UNIFIED IDEOGRAPH-6420
        0x6424, # G+9197  U+6424  uni6424,  CJK UNIFIED IDEOGRAPH-6424
        0x6433, # G+9198  U+6433  uni6433,  CJK UNIFIED IDEOGRAPH-6433
        0x6443, # G+9199  U+6443  uni6443,  CJK UNIFIED IDEOGRAPH-6443
        0x641F, # G+9200  U+641F  uni641F,  CJK UNIFIED IDEOGRAPH-641F
        0x6415, # G+9201  U+6415  uni6415,  CJK UNIFIED IDEOGRAPH-6415
        0x6418, # G+9202  U+6418  uni6418,  CJK UNIFIED IDEOGRAPH-6418
        0x6439, # G+9203  U+6439  uni6439,  CJK UNIFIED IDEOGRAPH-6439
        0x6437, # G+9204  U+6437  uni6437,  CJK UNIFIED IDEOGRAPH-6437
        0x6422, # G+9205  U+6422  uni6422,  CJK UNIFIED IDEOGRAPH-6422
        0x6423, # G+9206  U+6423  uni6423,  CJK UNIFIED IDEOGRAPH-6423
        0x640C, # G+9207  U+640C  uni640C,  CJK UNIFIED IDEOGRAPH-640C
        0x6426, # G+9208  U+6426  uni6426,  CJK UNIFIED IDEOGRAPH-6426
        0x6430, # G+9209  U+6430  uni6430,  CJK UNIFIED IDEOGRAPH-6430
        0x6428, # G+9210  U+6428  uni6428,  CJK UNIFIED IDEOGRAPH-6428
        0x6441, # G+9211  U+6441  uni6441,  CJK UNIFIED IDEOGRAPH-6441
        0x6435, # G+9212  U+6435  uni6435,  CJK UNIFIED IDEOGRAPH-6435
        0x642F, # G+9213  U+642F  uni642F,  CJK UNIFIED IDEOGRAPH-642F
        0x640A, # G+9214  U+640A  uni640A,  CJK UNIFIED IDEOGRAPH-640A
        0x641A, # G+9215  U+641A  uni641A,  CJK UNIFIED IDEOGRAPH-641A
        0x6440, # G+9216  U+6440  uni6440,  CJK UNIFIED IDEOGRAPH-6440
        0x6425, # G+9217  U+6425  uni6425,  CJK UNIFIED IDEOGRAPH-6425
        0x6427, # G+9218  U+6427  uni6427,  CJK UNIFIED IDEOGRAPH-6427
        0x640B, # G+9219  U+640B  uni640B,  CJK UNIFIED IDEOGRAPH-640B
        0x63E7, # G+9220  U+63E7  uni63E7,  CJK UNIFIED IDEOGRAPH-63E7
        0x641B, # G+9221  U+641B  uni641B,  CJK UNIFIED IDEOGRAPH-641B
        0x642E, # G+9222  U+642E  uni642E,  CJK UNIFIED IDEOGRAPH-642E
        0x6421, # G+9223  U+6421  uni6421,  CJK UNIFIED IDEOGRAPH-6421
        0x640E, # G+9224  U+640E  uni640E,  CJK UNIFIED IDEOGRAPH-640E
        0x656F, # G+9225  U+656F  uni656F,  CJK UNIFIED IDEOGRAPH-656F
        0x6592, # G+9226  U+6592  uni6592,  CJK UNIFIED IDEOGRAPH-6592
        0x65D3, # G+9227  U+65D3  uni65D3,  CJK UNIFIED IDEOGRAPH-65D3
        0x6686, # G+9228  U+6686  uni6686,  CJK UNIFIED IDEOGRAPH-6686
        0x668C, # G+9229  U+668C  uni668C,  CJK UNIFIED IDEOGRAPH-668C
        0x6695, # G+9230  U+6695  uni6695,  CJK UNIFIED IDEOGRAPH-6695
        0x6690, # G+9231  U+6690  uni6690,  CJK UNIFIED IDEOGRAPH-6690
        0x668B, # G+9232  U+668B  uni668B,  CJK UNIFIED IDEOGRAPH-668B
        0x668A, # G+9233  U+668A  uni668A,  CJK UNIFIED IDEOGRAPH-668A
        0x6699, # G+9234  U+6699  uni6699,  CJK UNIFIED IDEOGRAPH-6699
        0x6694, # G+9235  U+6694  uni6694,  CJK UNIFIED IDEOGRAPH-6694
        0x6678, # G+9236  U+6678  uni6678,  CJK UNIFIED IDEOGRAPH-6678
        0x6720, # G+9237  U+6720  uni6720,  CJK UNIFIED IDEOGRAPH-6720
        0x6966, # G+9238  U+6966  uni6966,  CJK UNIFIED IDEOGRAPH-6966
        0x695F, # G+9239  U+695F  uni695F,  CJK UNIFIED IDEOGRAPH-695F
        0x6938, # G+9240  U+6938  uni6938,  CJK UNIFIED IDEOGRAPH-6938
        0x694E, # G+9241  U+694E  uni694E,  CJK UNIFIED IDEOGRAPH-694E
        0x6962, # G+9242  U+6962  uni6962,  CJK UNIFIED IDEOGRAPH-6962
        0x6971, # G+9243  U+6971  uni6971,  CJK UNIFIED IDEOGRAPH-6971
        0x693F, # G+9244  U+693F  uni693F,  CJK UNIFIED IDEOGRAPH-693F
        0x6945, # G+9245  U+6945  uni6945,  CJK UNIFIED IDEOGRAPH-6945
        0x696A, # G+9246  U+696A  uni696A,  CJK UNIFIED IDEOGRAPH-696A
        0x6939, # G+9247  U+6939  uni6939,  CJK UNIFIED IDEOGRAPH-6939
        0x6942, # G+9248  U+6942  uni6942,  CJK UNIFIED IDEOGRAPH-6942
        0x6957, # G+9249  U+6957  uni6957,  CJK UNIFIED IDEOGRAPH-6957
        0x6959, # G+9250  U+6959  uni6959,  CJK UNIFIED IDEOGRAPH-6959
        0x697A, # G+9251  U+697A  uni697A,  CJK UNIFIED IDEOGRAPH-697A
        0x6948, # G+9252  U+6948  uni6948,  CJK UNIFIED IDEOGRAPH-6948
        0x6949, # G+9253  U+6949  uni6949,  CJK UNIFIED IDEOGRAPH-6949
        0x6935, # G+9254  U+6935  uni6935,  CJK UNIFIED IDEOGRAPH-6935
        0x696C, # G+9255  U+696C  uni696C,  CJK UNIFIED IDEOGRAPH-696C
        0x6933, # G+9256  U+6933  uni6933,  CJK UNIFIED IDEOGRAPH-6933
        0x693D, # G+9257  U+693D  uni693D,  CJK UNIFIED IDEOGRAPH-693D
        0x6965, # G+9258  U+6965  uni6965,  CJK UNIFIED IDEOGRAPH-6965
        0x68F0, # G+9259  U+68F0  uni68F0,  CJK UNIFIED IDEOGRAPH-68F0
        0x6978, # G+9260  U+6978  uni6978,  CJK UNIFIED IDEOGRAPH-6978
        0x6934, # G+9261  U+6934  uni6934,  CJK UNIFIED IDEOGRAPH-6934
        0x6969, # G+9262  U+6969  uni6969,  CJK UNIFIED IDEOGRAPH-6969
        0x6940, # G+9263  U+6940  uni6940,  CJK UNIFIED IDEOGRAPH-6940
        0x696F, # G+9264  U+696F  uni696F,  CJK UNIFIED IDEOGRAPH-696F
        0x6944, # G+9265  U+6944  uni6944,  CJK UNIFIED IDEOGRAPH-6944
        0x6976, # G+9266  U+6976  uni6976,  CJK UNIFIED IDEOGRAPH-6976
        0x6958, # G+9267  U+6958  uni6958,  CJK UNIFIED IDEOGRAPH-6958
        0x6941, # G+9268  U+6941  uni6941,  CJK UNIFIED IDEOGRAPH-6941
        0x6974, # G+9269  U+6974  uni6974,  CJK UNIFIED IDEOGRAPH-6974
        0x694C, # G+9270  U+694C  uni694C,  CJK UNIFIED IDEOGRAPH-694C
        0x693B, # G+9271  U+693B  uni693B,  CJK UNIFIED IDEOGRAPH-693B
        0x694B, # G+9272  U+694B  uni694B,  CJK UNIFIED IDEOGRAPH-694B
        0x6937, # G+9273  U+6937  uni6937,  CJK UNIFIED IDEOGRAPH-6937
        0x695C, # G+9274  U+695C  uni695C,  CJK UNIFIED IDEOGRAPH-695C
        0x694F, # G+9275  U+694F  uni694F,  CJK UNIFIED IDEOGRAPH-694F
        0x6951, # G+9276  U+6951  uni6951,  CJK UNIFIED IDEOGRAPH-6951
        0x6932, # G+9277  U+6932  uni6932,  CJK UNIFIED IDEOGRAPH-6932
        0x6952, # G+9278  U+6952  uni6952,  CJK UNIFIED IDEOGRAPH-6952
        0x692F, # G+9279  U+692F  uni692F,  CJK UNIFIED IDEOGRAPH-692F
        0x697B, # G+9280  U+697B  uni697B,  CJK UNIFIED IDEOGRAPH-697B
        0x693C, # G+9281  U+693C  uni693C,  CJK UNIFIED IDEOGRAPH-693C
        0x6B46, # G+9282  U+6B46  uni6B46,  CJK UNIFIED IDEOGRAPH-6B46
        0x6B45, # G+9283  U+6B45  uni6B45,  CJK UNIFIED IDEOGRAPH-6B45
        0x6B43, # G+9284  U+6B43  uni6B43,  CJK UNIFIED IDEOGRAPH-6B43
        0x6B42, # G+9285  U+6B42  uni6B42,  CJK UNIFIED IDEOGRAPH-6B42
        0x6B48, # G+9286  U+6B48  uni6B48,  CJK UNIFIED IDEOGRAPH-6B48
        0x6B41, # G+9287  U+6B41  uni6B41,  CJK UNIFIED IDEOGRAPH-6B41
        0x6B9B, # G+9288  U+6B9B  uni6B9B,  CJK UNIFIED IDEOGRAPH-6B9B
        0x6BFB, # G+9289  U+6BFB  uni6BFB,  CJK UNIFIED IDEOGRAPH-6BFB
        0x6BFC, # G+9290  U+6BFC  uni6BFC,  CJK UNIFIED IDEOGRAPH-6BFC
        0x6BF9, # G+9291  U+6BF9  uni6BF9,  CJK UNIFIED IDEOGRAPH-6BF9
        0x6BF7, # G+9292  U+6BF7  uni6BF7,  CJK UNIFIED IDEOGRAPH-6BF7
        0x6BF8, # G+9293  U+6BF8  uni6BF8,  CJK UNIFIED IDEOGRAPH-6BF8
        0x6E9B, # G+9294  U+6E9B  uni6E9B,  CJK UNIFIED IDEOGRAPH-6E9B
        0x6ED6, # G+9295  U+6ED6  uni6ED6,  CJK UNIFIED IDEOGRAPH-6ED6
        0x6EC8, # G+9296  U+6EC8  uni6EC8,  CJK UNIFIED IDEOGRAPH-6EC8
        0x6E8F, # G+9297  U+6E8F  uni6E8F,  CJK UNIFIED IDEOGRAPH-6E8F
        0x6EC0, # G+9298  U+6EC0  uni6EC0,  CJK UNIFIED IDEOGRAPH-6EC0
        0x6E9F, # G+9299  U+6E9F  uni6E9F,  CJK UNIFIED IDEOGRAPH-6E9F
        0x6E93, # G+9300  U+6E93  uni6E93,  CJK UNIFIED IDEOGRAPH-6E93
        0x6E94, # G+9301  U+6E94  uni6E94,  CJK UNIFIED IDEOGRAPH-6E94
        0x6EA0, # G+9302  U+6EA0  uni6EA0,  CJK UNIFIED IDEOGRAPH-6EA0
        0x6EB1, # G+9303  U+6EB1  uni6EB1,  CJK UNIFIED IDEOGRAPH-6EB1
        0x6EB9, # G+9304  U+6EB9  uni6EB9,  CJK UNIFIED IDEOGRAPH-6EB9
        0x6EC6, # G+9305  U+6EC6  uni6EC6,  CJK UNIFIED IDEOGRAPH-6EC6
        0x6ED2, # G+9306  U+6ED2  uni6ED2,  CJK UNIFIED IDEOGRAPH-6ED2
        0x6EBD, # G+9307  U+6EBD  uni6EBD,  CJK UNIFIED IDEOGRAPH-6EBD
        0x6EC1, # G+9308  U+6EC1  uni6EC1,  CJK UNIFIED IDEOGRAPH-6EC1
        0x6E9E, # G+9309  U+6E9E  uni6E9E,  CJK UNIFIED IDEOGRAPH-6E9E
        0x6EC9, # G+9310  U+6EC9  uni6EC9,  CJK UNIFIED IDEOGRAPH-6EC9
        0x6EB7, # G+9311  U+6EB7  uni6EB7,  CJK UNIFIED IDEOGRAPH-6EB7
        0x6EB0, # G+9312  U+6EB0  uni6EB0,  CJK UNIFIED IDEOGRAPH-6EB0
        0x6ECD, # G+9313  U+6ECD  uni6ECD,  CJK UNIFIED IDEOGRAPH-6ECD
        0x6EA6, # G+9314  U+6EA6  uni6EA6,  CJK UNIFIED IDEOGRAPH-6EA6
        0x6ECF, # G+9315  U+6ECF  uni6ECF,  CJK UNIFIED IDEOGRAPH-6ECF
        0x6EB2, # G+9316  U+6EB2  uni6EB2,  CJK UNIFIED IDEOGRAPH-6EB2
        0x6EBE, # G+9317  U+6EBE  uni6EBE,  CJK UNIFIED IDEOGRAPH-6EBE
        0x6EC3, # G+9318  U+6EC3  uni6EC3,  CJK UNIFIED IDEOGRAPH-6EC3
        0x6EDC, # G+9319  U+6EDC  uni6EDC,  CJK UNIFIED IDEOGRAPH-6EDC
        0x6ED8, # G+9320  U+6ED8  uni6ED8,  CJK UNIFIED IDEOGRAPH-6ED8
        0x6E99, # G+9321  U+6E99  uni6E99,  CJK UNIFIED IDEOGRAPH-6E99
        0x6E92, # G+9322  U+6E92  uni6E92,  CJK UNIFIED IDEOGRAPH-6E92
        0x6E8E, # G+9323  U+6E8E  uni6E8E,  CJK UNIFIED IDEOGRAPH-6E8E
        0x6E8D, # G+9324  U+6E8D  uni6E8D,  CJK UNIFIED IDEOGRAPH-6E8D
        0x6EA4, # G+9325  U+6EA4  uni6EA4,  CJK UNIFIED IDEOGRAPH-6EA4
        0x6EA1, # G+9326  U+6EA1  uni6EA1,  CJK UNIFIED IDEOGRAPH-6EA1
        0x6EBF, # G+9327  U+6EBF  uni6EBF,  CJK UNIFIED IDEOGRAPH-6EBF
        0x6EB3, # G+9328  U+6EB3  uni6EB3,  CJK UNIFIED IDEOGRAPH-6EB3
        0x6ED0, # G+9329  U+6ED0  uni6ED0,  CJK UNIFIED IDEOGRAPH-6ED0
        0x6ECA, # G+9330  U+6ECA  uni6ECA,  CJK UNIFIED IDEOGRAPH-6ECA
        0x6E97, # G+9331  U+6E97  uni6E97,  CJK UNIFIED IDEOGRAPH-6E97
        0x6EAE, # G+9332  U+6EAE  uni6EAE,  CJK UNIFIED IDEOGRAPH-6EAE
        0x6EA3, # G+9333  U+6EA3  uni6EA3,  CJK UNIFIED IDEOGRAPH-6EA3
        0x7147, # G+9334  U+7147  uni7147,  CJK UNIFIED IDEOGRAPH-7147
        0x7154, # G+9335  U+7154  uni7154,  CJK UNIFIED IDEOGRAPH-7154
        0x7152, # G+9336  U+7152  uni7152,  CJK UNIFIED IDEOGRAPH-7152
        0x7163, # G+9337  U+7163  uni7163,  CJK UNIFIED IDEOGRAPH-7163
        0x7160, # G+9338  U+7160  uni7160,  CJK UNIFIED IDEOGRAPH-7160
        0x7141, # G+9339  U+7141  uni7141,  CJK UNIFIED IDEOGRAPH-7141
        0x715D, # G+9340  U+715D  uni715D,  CJK UNIFIED IDEOGRAPH-715D
        0x7162, # G+9341  U+7162  uni7162,  CJK UNIFIED IDEOGRAPH-7162
        0x7172, # G+9342  U+7172  uni7172,  CJK UNIFIED IDEOGRAPH-7172
        0x7178, # G+9343  U+7178  uni7178,  CJK UNIFIED IDEOGRAPH-7178
        0x716A, # G+9344  U+716A  uni716A,  CJK UNIFIED IDEOGRAPH-716A
        0x7161, # G+9345  U+7161  uni7161,  CJK UNIFIED IDEOGRAPH-7161
        0x7142, # G+9346  U+7142  uni7142,  CJK UNIFIED IDEOGRAPH-7142
        0x7158, # G+9347  U+7158  uni7158,  CJK UNIFIED IDEOGRAPH-7158
        0x7143, # G+9348  U+7143  uni7143,  CJK UNIFIED IDEOGRAPH-7143
        0x714B, # G+9349  U+714B  uni714B,  CJK UNIFIED IDEOGRAPH-714B
        0x7170, # G+9350  U+7170  uni7170,  CJK UNIFIED IDEOGRAPH-7170
        0x715F, # G+9351  U+715F  uni715F,  CJK UNIFIED IDEOGRAPH-715F
        0x7150, # G+9352  U+7150  uni7150,  CJK UNIFIED IDEOGRAPH-7150
        0x7153, # G+9353  U+7153  uni7153,  CJK UNIFIED IDEOGRAPH-7153
        0x7144, # G+9354  U+7144  uni7144,  CJK UNIFIED IDEOGRAPH-7144
        0x714D, # G+9355  U+714D  uni714D,  CJK UNIFIED IDEOGRAPH-714D
        0x715A, # G+9356  U+715A  uni715A,  CJK UNIFIED IDEOGRAPH-715A
        0x724F, # G+9357  U+724F  uni724F,  CJK UNIFIED IDEOGRAPH-724F
        0x728D, # G+9358  U+728D  uni728D,  CJK UNIFIED IDEOGRAPH-728D
        0x728C, # G+9359  U+728C  uni728C,  CJK UNIFIED IDEOGRAPH-728C
        0x7291, # G+9360  U+7291  uni7291,  CJK UNIFIED IDEOGRAPH-7291
        0x7290, # G+9361  U+7290  uni7290,  CJK UNIFIED IDEOGRAPH-7290
        0x728E, # G+9362  U+728E  uni728E,  CJK UNIFIED IDEOGRAPH-728E
        0x733C, # G+9363  U+733C  uni733C,  CJK UNIFIED IDEOGRAPH-733C
        0x7342, # G+9364  U+7342  uni7342,  CJK UNIFIED IDEOGRAPH-7342
        0x733B, # G+9365  U+733B  uni733B,  CJK UNIFIED IDEOGRAPH-733B
        0x733A, # G+9366  U+733A  uni733A,  CJK UNIFIED IDEOGRAPH-733A
        0x7340, # G+9367  U+7340  uni7340,  CJK UNIFIED IDEOGRAPH-7340
        0x734A, # G+9368  U+734A  uni734A,  CJK UNIFIED IDEOGRAPH-734A
        0x7349, # G+9369  U+7349  uni7349,  CJK UNIFIED IDEOGRAPH-7349
        0x7444, # G+9370  U+7444  uni7444,  CJK UNIFIED IDEOGRAPH-7444
        0x744A, # G+9371  U+744A  uni744A,  CJK UNIFIED IDEOGRAPH-744A
        0x744B, # G+9372  U+744B  uni744B,  CJK UNIFIED IDEOGRAPH-744B
        0x7452, # G+9373  U+7452  uni7452,  CJK UNIFIED IDEOGRAPH-7452
        0x7451, # G+9374  U+7451  uni7451,  CJK UNIFIED IDEOGRAPH-7451
        0x7457, # G+9375  U+7457  uni7457,  CJK UNIFIED IDEOGRAPH-7457
        0x7440, # G+9376  U+7440  uni7440,  CJK UNIFIED IDEOGRAPH-7440
        0x744F, # G+9377  U+744F  uni744F,  CJK UNIFIED IDEOGRAPH-744F
        0x7450, # G+9378  U+7450  uni7450,  CJK UNIFIED IDEOGRAPH-7450
        0x744E, # G+9379  U+744E  uni744E,  CJK UNIFIED IDEOGRAPH-744E
        0x7442, # G+9380  U+7442  uni7442,  CJK UNIFIED IDEOGRAPH-7442
        0x7446, # G+9381  U+7446  uni7446,  CJK UNIFIED IDEOGRAPH-7446
        0x744D, # G+9382  U+744D  uni744D,  CJK UNIFIED IDEOGRAPH-744D
        0x7454, # G+9383  U+7454  uni7454,  CJK UNIFIED IDEOGRAPH-7454
        0x74E1, # G+9384  U+74E1  uni74E1,  CJK UNIFIED IDEOGRAPH-74E1
        0x74FF, # G+9385  U+74FF  uni74FF,  CJK UNIFIED IDEOGRAPH-74FF
        0x74FE, # G+9386  U+74FE  uni74FE,  CJK UNIFIED IDEOGRAPH-74FE
        0x74FD, # G+9387  U+74FD  uni74FD,  CJK UNIFIED IDEOGRAPH-74FD
        0x751D, # G+9388  U+751D  uni751D,  CJK UNIFIED IDEOGRAPH-751D
        0x7579, # G+9389  U+7579  uni7579,  CJK UNIFIED IDEOGRAPH-7579
        0x7577, # G+9390  U+7577  uni7577,  CJK UNIFIED IDEOGRAPH-7577
        0x6983, # G+9391  U+6983  uni6983,  CJK UNIFIED IDEOGRAPH-6983
        0x75EF, # G+9392  U+75EF  uni75EF,  CJK UNIFIED IDEOGRAPH-75EF
        0x760F, # G+9393  U+760F  uni760F,  CJK UNIFIED IDEOGRAPH-760F
        0x7603, # G+9394  U+7603  uni7603,  CJK UNIFIED IDEOGRAPH-7603
        0x75F7, # G+9395  U+75F7  uni75F7,  CJK UNIFIED IDEOGRAPH-75F7
        0x75FE, # G+9396  U+75FE  uni75FE,  CJK UNIFIED IDEOGRAPH-75FE
        0x75FC, # G+9397  U+75FC  uni75FC,  CJK UNIFIED IDEOGRAPH-75FC
        0x75F9, # G+9398  U+75F9  uni75F9,  CJK UNIFIED IDEOGRAPH-75F9
        0x75F8, # G+9399  U+75F8  uni75F8,  CJK UNIFIED IDEOGRAPH-75F8
        0x7610, # G+9400  U+7610  uni7610,  CJK UNIFIED IDEOGRAPH-7610
        0x75FB, # G+9401  U+75FB  uni75FB,  CJK UNIFIED IDEOGRAPH-75FB
        0x75F6, # G+9402  U+75F6  uni75F6,  CJK UNIFIED IDEOGRAPH-75F6
        0x75ED, # G+9403  U+75ED  uni75ED,  CJK UNIFIED IDEOGRAPH-75ED
        0x75F5, # G+9404  U+75F5  uni75F5,  CJK UNIFIED IDEOGRAPH-75F5
        0x75FD, # G+9405  U+75FD  uni75FD,  CJK UNIFIED IDEOGRAPH-75FD
        0x7699, # G+9406  U+7699  uni7699,  CJK UNIFIED IDEOGRAPH-7699
        0x76B5, # G+9407  U+76B5  uni76B5,  CJK UNIFIED IDEOGRAPH-76B5
        0x76DD, # G+9408  U+76DD  uni76DD,  CJK UNIFIED IDEOGRAPH-76DD
        0x7755, # G+9409  U+7755  uni7755,  CJK UNIFIED IDEOGRAPH-7755
        0x775F, # G+9410  U+775F  uni775F,  CJK UNIFIED IDEOGRAPH-775F
        0x7760, # G+9411  U+7760  uni7760,  CJK UNIFIED IDEOGRAPH-7760
        0x7752, # G+9412  U+7752  uni7752,  CJK UNIFIED IDEOGRAPH-7752
        0x7756, # G+9413  U+7756  uni7756,  CJK UNIFIED IDEOGRAPH-7756
        0x775A, # G+9414  U+775A  uni775A,  CJK UNIFIED IDEOGRAPH-775A
        0x7769, # G+9415  U+7769  uni7769,  CJK UNIFIED IDEOGRAPH-7769
        0x7767, # G+9416  U+7767  uni7767,  CJK UNIFIED IDEOGRAPH-7767
        0x7754, # G+9417  U+7754  uni7754,  CJK UNIFIED IDEOGRAPH-7754
        0x7759, # G+9418  U+7759  uni7759,  CJK UNIFIED IDEOGRAPH-7759
        0x776D, # G+9419  U+776D  uni776D,  CJK UNIFIED IDEOGRAPH-776D
        0x77E0, # G+9420  U+77E0  uni77E0,  CJK UNIFIED IDEOGRAPH-77E0
        0x7887, # G+9421  U+7887  uni7887,  CJK UNIFIED IDEOGRAPH-7887
        0x789A, # G+9422  U+789A  uni789A,  CJK UNIFIED IDEOGRAPH-789A
        0x7894, # G+9423  U+7894  uni7894,  CJK UNIFIED IDEOGRAPH-7894
        0x788F, # G+9424  U+788F  uni788F,  CJK UNIFIED IDEOGRAPH-788F
        0x7884, # G+9425  U+7884  uni7884,  CJK UNIFIED IDEOGRAPH-7884
        0x7895, # G+9426  U+7895  uni7895,  CJK UNIFIED IDEOGRAPH-7895
        0x7885, # G+9427  U+7885  uni7885,  CJK UNIFIED IDEOGRAPH-7885
        0x7886, # G+9428  U+7886  uni7886,  CJK UNIFIED IDEOGRAPH-7886
        0x78A1, # G+9429  U+78A1  uni78A1,  CJK UNIFIED IDEOGRAPH-78A1
        0x7883, # G+9430  U+7883  uni7883,  CJK UNIFIED IDEOGRAPH-7883
        0x7879, # G+9431  U+7879  uni7879,  CJK UNIFIED IDEOGRAPH-7879
        0x7899, # G+9432  U+7899  uni7899,  CJK UNIFIED IDEOGRAPH-7899
        0x7880, # G+9433  U+7880  uni7880,  CJK UNIFIED IDEOGRAPH-7880
        0x7896, # G+9434  U+7896  uni7896,  CJK UNIFIED IDEOGRAPH-7896
        0x787B, # G+9435  U+787B  uni787B,  CJK UNIFIED IDEOGRAPH-787B
        0x797C, # G+9436  U+797C  uni797C,  CJK UNIFIED IDEOGRAPH-797C
        0x7982, # G+9437  U+7982  uni7982,  CJK UNIFIED IDEOGRAPH-7982
        0x797D, # G+9438  U+797D  uni797D,  CJK UNIFIED IDEOGRAPH-797D
        0x7979, # G+9439  U+7979  uni7979,  CJK UNIFIED IDEOGRAPH-7979
        0x7A11, # G+9440  U+7A11  uni7A11,  CJK UNIFIED IDEOGRAPH-7A11
        0x7A18, # G+9441  U+7A18  uni7A18,  CJK UNIFIED IDEOGRAPH-7A18
        0x7A19, # G+9442  U+7A19  uni7A19,  CJK UNIFIED IDEOGRAPH-7A19
        0x7A12, # G+9443  U+7A12  uni7A12,  CJK UNIFIED IDEOGRAPH-7A12
        0x7A17, # G+9444  U+7A17  uni7A17,  CJK UNIFIED IDEOGRAPH-7A17
        0x7A15, # G+9445  U+7A15  uni7A15,  CJK UNIFIED IDEOGRAPH-7A15
        0x7A22, # G+9446  U+7A22  uni7A22,  CJK UNIFIED IDEOGRAPH-7A22
        0x7A13, # G+9447  U+7A13  uni7A13,  CJK UNIFIED IDEOGRAPH-7A13
        0x7A1B, # G+9448  U+7A1B  uni7A1B,  CJK UNIFIED IDEOGRAPH-7A1B
        0x7A10, # G+9449  U+7A10  uni7A10,  CJK UNIFIED IDEOGRAPH-7A10
        0x7AA3, # G+9450  U+7AA3  uni7AA3,  CJK UNIFIED IDEOGRAPH-7AA3
        0x7AA2, # G+9451  U+7AA2  uni7AA2,  CJK UNIFIED IDEOGRAPH-7AA2
        0x7A9E, # G+9452  U+7A9E  uni7A9E,  CJK UNIFIED IDEOGRAPH-7A9E
        0x7AEB, # G+9453  U+7AEB  uni7AEB,  CJK UNIFIED IDEOGRAPH-7AEB
        0x7B66, # G+9454  U+7B66  uni7B66,  CJK UNIFIED IDEOGRAPH-7B66
        0x7B64, # G+9455  U+7B64  uni7B64,  CJK UNIFIED IDEOGRAPH-7B64
        0x7B6D, # G+9456  U+7B6D  uni7B6D,  CJK UNIFIED IDEOGRAPH-7B6D
        0x7B74, # G+9457  U+7B74  uni7B74,  CJK UNIFIED IDEOGRAPH-7B74
        0x7B69, # G+9458  U+7B69  uni7B69,  CJK UNIFIED IDEOGRAPH-7B69
        0x7B72, # G+9459  U+7B72  uni7B72,  CJK UNIFIED IDEOGRAPH-7B72
        0x7B65, # G+9460  U+7B65  uni7B65,  CJK UNIFIED IDEOGRAPH-7B65
        0x7B73, # G+9461  U+7B73  uni7B73,  CJK UNIFIED IDEOGRAPH-7B73
        0x7B71, # G+9462  U+7B71  uni7B71,  CJK UNIFIED IDEOGRAPH-7B71
        0x7B70, # G+9463  U+7B70  uni7B70,  CJK UNIFIED IDEOGRAPH-7B70
        0x7B61, # G+9464  U+7B61  uni7B61,  CJK UNIFIED IDEOGRAPH-7B61
        0x7B78, # G+9465  U+7B78  uni7B78,  CJK UNIFIED IDEOGRAPH-7B78
        0x7B76, # G+9466  U+7B76  uni7B76,  CJK UNIFIED IDEOGRAPH-7B76
        0x7B63, # G+9467  U+7B63  uni7B63,  CJK UNIFIED IDEOGRAPH-7B63
        0x7CB2, # G+9468  U+7CB2  uni7CB2,  CJK UNIFIED IDEOGRAPH-7CB2
        0x7CB4, # G+9469  U+7CB4  uni7CB4,  CJK UNIFIED IDEOGRAPH-7CB4
        0x7CAF, # G+9470  U+7CAF  uni7CAF,  CJK UNIFIED IDEOGRAPH-7CAF
        0x7D88, # G+9471  U+7D88  uni7D88,  CJK UNIFIED IDEOGRAPH-7D88
        0x7D86, # G+9472  U+7D86  uni7D86,  CJK UNIFIED IDEOGRAPH-7D86
        0x7D80, # G+9473  U+7D80  uni7D80,  CJK UNIFIED IDEOGRAPH-7D80
        0x7D8D, # G+9474  U+7D8D  uni7D8D,  CJK UNIFIED IDEOGRAPH-7D8D
        0x7D7F, # G+9475  U+7D7F  uni7D7F,  CJK UNIFIED IDEOGRAPH-7D7F
        0x7D85, # G+9476  U+7D85  uni7D85,  CJK UNIFIED IDEOGRAPH-7D85
        0x7D7A, # G+9477  U+7D7A  uni7D7A,  CJK UNIFIED IDEOGRAPH-7D7A
        0x7D8E, # G+9478  U+7D8E  uni7D8E,  CJK UNIFIED IDEOGRAPH-7D8E
        0x7D7B, # G+9479  U+7D7B  uni7D7B,  CJK UNIFIED IDEOGRAPH-7D7B
        0x7D83, # G+9480  U+7D83  uni7D83,  CJK UNIFIED IDEOGRAPH-7D83
        0x7D7C, # G+9481  U+7D7C  uni7D7C,  CJK UNIFIED IDEOGRAPH-7D7C
        0x7D8C, # G+9482  U+7D8C  uni7D8C,  CJK UNIFIED IDEOGRAPH-7D8C
        0x7D94, # G+9483  U+7D94  uni7D94,  CJK UNIFIED IDEOGRAPH-7D94
        0x7D84, # G+9484  U+7D84  uni7D84,  CJK UNIFIED IDEOGRAPH-7D84
        0x7D7D, # G+9485  U+7D7D  uni7D7D,  CJK UNIFIED IDEOGRAPH-7D7D
        0x7D92, # G+9486  U+7D92  uni7D92,  CJK UNIFIED IDEOGRAPH-7D92
        0x7F6D, # G+9487  U+7F6D  uni7F6D,  CJK UNIFIED IDEOGRAPH-7F6D
        0x7F6B, # G+9488  U+7F6B  uni7F6B,  CJK UNIFIED IDEOGRAPH-7F6B
        0x7F67, # G+9489  U+7F67  uni7F67,  CJK UNIFIED IDEOGRAPH-7F67
        0x7F68, # G+9490  U+7F68  uni7F68,  CJK UNIFIED IDEOGRAPH-7F68
        0x7F6C, # G+9491  U+7F6C  uni7F6C,  CJK UNIFIED IDEOGRAPH-7F6C
        0x7FA6, # G+9492  U+7FA6  uni7FA6,  CJK UNIFIED IDEOGRAPH-7FA6
        0x7FA5, # G+9493  U+7FA5  uni7FA5,  CJK UNIFIED IDEOGRAPH-7FA5
        0x7FA7, # G+9494  U+7FA7  uni7FA7,  CJK UNIFIED IDEOGRAPH-7FA7
        0x7FDB, # G+9495  U+7FDB  uni7FDB,  CJK UNIFIED IDEOGRAPH-7FDB
        0x7FDC, # G+9496  U+7FDC  uni7FDC,  CJK UNIFIED IDEOGRAPH-7FDC
        0x8021, # G+9497  U+8021  uni8021,  CJK UNIFIED IDEOGRAPH-8021
        0x8164, # G+9498  U+8164  uni8164,  CJK UNIFIED IDEOGRAPH-8164
        0x8160, # G+9499  U+8160  uni8160,  CJK UNIFIED IDEOGRAPH-8160
        0x8177, # G+9500  U+8177  uni8177,  CJK UNIFIED IDEOGRAPH-8177
        0x815C, # G+9501  U+815C  uni815C,  CJK UNIFIED IDEOGRAPH-815C
        0x8169, # G+9502  U+8169  uni8169,  CJK UNIFIED IDEOGRAPH-8169
        0x815B, # G+9503  U+815B  uni815B,  CJK UNIFIED IDEOGRAPH-815B
        0x8162, # G+9504  U+8162  uni8162,  CJK UNIFIED IDEOGRAPH-8162
        0x8172, # G+9505  U+8172  uni8172,  CJK UNIFIED IDEOGRAPH-8172
        0x6721, # G+9506  U+6721  uni6721,  CJK UNIFIED IDEOGRAPH-6721
        0x815E, # G+9507  U+815E  uni815E,  CJK UNIFIED IDEOGRAPH-815E
        0x8176, # G+9508  U+8176  uni8176,  CJK UNIFIED IDEOGRAPH-8176
        0x8167, # G+9509  U+8167  uni8167,  CJK UNIFIED IDEOGRAPH-8167
        0x816F, # G+9510  U+816F  uni816F,  CJK UNIFIED IDEOGRAPH-816F
        0x8144, # G+9511  U+8144  uni8144,  CJK UNIFIED IDEOGRAPH-8144
        0x8161, # G+9512  U+8161  uni8161,  CJK UNIFIED IDEOGRAPH-8161
        0x821D, # G+9513  U+821D  uni821D,  CJK UNIFIED IDEOGRAPH-821D
        0x8249, # G+9514  U+8249  uni8249,  CJK UNIFIED IDEOGRAPH-8249
        0x8244, # G+9515  U+8244  uni8244,  CJK UNIFIED IDEOGRAPH-8244
        0x8240, # G+9516  U+8240  uni8240,  CJK UNIFIED IDEOGRAPH-8240
        0x8242, # G+9517  U+8242  uni8242,  CJK UNIFIED IDEOGRAPH-8242
        0x8245, # G+9518  U+8245  uni8245,  CJK UNIFIED IDEOGRAPH-8245
        0x84F1, # G+9519  U+84F1  uni84F1,  CJK UNIFIED IDEOGRAPH-84F1
        0x843F, # G+9520  U+843F  uni843F,  CJK UNIFIED IDEOGRAPH-843F
        0x8456, # G+9521  U+8456  uni8456,  CJK UNIFIED IDEOGRAPH-8456
        0x8476, # G+9522  U+8476  uni8476,  CJK UNIFIED IDEOGRAPH-8476
        0x8479, # G+9523  U+8479  uni8479,  CJK UNIFIED IDEOGRAPH-8479
        0x848F, # G+9524  U+848F  uni848F,  CJK UNIFIED IDEOGRAPH-848F
        0x848D, # G+9525  U+848D  uni848D,  CJK UNIFIED IDEOGRAPH-848D
        0x8465, # G+9526  U+8465  uni8465,  CJK UNIFIED IDEOGRAPH-8465
        0x8451, # G+9527  U+8451  uni8451,  CJK UNIFIED IDEOGRAPH-8451
        0x8440, # G+9528  U+8440  uni8440,  CJK UNIFIED IDEOGRAPH-8440
        0x8486, # G+9529  U+8486  uni8486,  CJK UNIFIED IDEOGRAPH-8486
        0x8467, # G+9530  U+8467  uni8467,  CJK UNIFIED IDEOGRAPH-8467
        0x8430, # G+9531  U+8430  uni8430,  CJK UNIFIED IDEOGRAPH-8430
        0x844D, # G+9532  U+844D  uni844D,  CJK UNIFIED IDEOGRAPH-844D
        0x847D, # G+9533  U+847D  uni847D,  CJK UNIFIED IDEOGRAPH-847D
        0x845A, # G+9534  U+845A  uni845A,  CJK UNIFIED IDEOGRAPH-845A
        0x8459, # G+9535  U+8459  uni8459,  CJK UNIFIED IDEOGRAPH-8459
        0x8474, # G+9536  U+8474  uni8474,  CJK UNIFIED IDEOGRAPH-8474
        0x8473, # G+9537  U+8473  uni8473,  CJK UNIFIED IDEOGRAPH-8473
        0x845D, # G+9538  U+845D  uni845D,  CJK UNIFIED IDEOGRAPH-845D
        0x8507, # G+9539  U+8507  uni8507,  CJK UNIFIED IDEOGRAPH-8507
        0x845E, # G+9540  U+845E  uni845E,  CJK UNIFIED IDEOGRAPH-845E
        0x8437, # G+9541  U+8437  uni8437,  CJK UNIFIED IDEOGRAPH-8437
        0x843A, # G+9542  U+843A  uni843A,  CJK UNIFIED IDEOGRAPH-843A
        0x8434, # G+9543  U+8434  uni8434,  CJK UNIFIED IDEOGRAPH-8434
        0x847A, # G+9544  U+847A  uni847A,  CJK UNIFIED IDEOGRAPH-847A
        0x8443, # G+9545  U+8443  uni8443,  CJK UNIFIED IDEOGRAPH-8443
        0x8478, # G+9546  U+8478  uni8478,  CJK UNIFIED IDEOGRAPH-8478
        0x8432, # G+9547  U+8432  uni8432,  CJK UNIFIED IDEOGRAPH-8432
        0x8445, # G+9548  U+8445  uni8445,  CJK UNIFIED IDEOGRAPH-8445
        0x8429, # G+9549  U+8429  uni8429,  CJK UNIFIED IDEOGRAPH-8429
        0x83D9, # G+9550  U+83D9  uni83D9,  CJK UNIFIED IDEOGRAPH-83D9
        0x844B, # G+9551  U+844B  uni844B,  CJK UNIFIED IDEOGRAPH-844B
        0x842F, # G+9552  U+842F  uni842F,  CJK UNIFIED IDEOGRAPH-842F
        0x8442, # G+9553  U+8442  uni8442,  CJK UNIFIED IDEOGRAPH-8442
        0x842D, # G+9554  U+842D  uni842D,  CJK UNIFIED IDEOGRAPH-842D
        0x845F, # G+9555  U+845F  uni845F,  CJK UNIFIED IDEOGRAPH-845F
        0x8470, # G+9556  U+8470  uni8470,  CJK UNIFIED IDEOGRAPH-8470
        0x8439, # G+9557  U+8439  uni8439,  CJK UNIFIED IDEOGRAPH-8439
        0x844E, # G+9558  U+844E  uni844E,  CJK UNIFIED IDEOGRAPH-844E
        0x844C, # G+9559  U+844C  uni844C,  CJK UNIFIED IDEOGRAPH-844C
        0x8452, # G+9560  U+8452  uni8452,  CJK UNIFIED IDEOGRAPH-8452
        0x846F, # G+9561  U+846F  uni846F,  CJK UNIFIED IDEOGRAPH-846F
        0x84C5, # G+9562  U+84C5  uni84C5,  CJK UNIFIED IDEOGRAPH-84C5
        0x848E, # G+9563  U+848E  uni848E,  CJK UNIFIED IDEOGRAPH-848E
        0x843B, # G+9564  U+843B  uni843B,  CJK UNIFIED IDEOGRAPH-843B
        0x8447, # G+9565  U+8447  uni8447,  CJK UNIFIED IDEOGRAPH-8447
        0x8436, # G+9566  U+8436  uni8436,  CJK UNIFIED IDEOGRAPH-8436
        0x8433, # G+9567  U+8433  uni8433,  CJK UNIFIED IDEOGRAPH-8433
        0x8468, # G+9568  U+8468  uni8468,  CJK UNIFIED IDEOGRAPH-8468
        0x847E, # G+9569  U+847E  uni847E,  CJK UNIFIED IDEOGRAPH-847E
        0x8444, # G+9570  U+8444  uni8444,  CJK UNIFIED IDEOGRAPH-8444
        0x842B, # G+9571  U+842B  uni842B,  CJK UNIFIED IDEOGRAPH-842B
        0x8460, # G+9572  U+8460  uni8460,  CJK UNIFIED IDEOGRAPH-8460
        0x8454, # G+9573  U+8454  uni8454,  CJK UNIFIED IDEOGRAPH-8454
        0x846E, # G+9574  U+846E  uni846E,  CJK UNIFIED IDEOGRAPH-846E
        0x8450, # G+9575  U+8450  uni8450,  CJK UNIFIED IDEOGRAPH-8450
        0x870B, # G+9576  U+870B  uni870B,  CJK UNIFIED IDEOGRAPH-870B
        0x8704, # G+9577  U+8704  uni8704,  CJK UNIFIED IDEOGRAPH-8704
        0x86F7, # G+9578  U+86F7  uni86F7,  CJK UNIFIED IDEOGRAPH-86F7
        0x870C, # G+9579  U+870C  uni870C,  CJK UNIFIED IDEOGRAPH-870C
        0x86FA, # G+9580  U+86FA  uni86FA,  CJK UNIFIED IDEOGRAPH-86FA
        0x86D6, # G+9581  U+86D6  uni86D6,  CJK UNIFIED IDEOGRAPH-86D6
        0x86F5, # G+9582  U+86F5  uni86F5,  CJK UNIFIED IDEOGRAPH-86F5
        0x874D, # G+9583  U+874D  uni874D,  CJK UNIFIED IDEOGRAPH-874D
        0x86F8, # G+9584  U+86F8  uni86F8,  CJK UNIFIED IDEOGRAPH-86F8
        0x870E, # G+9585  U+870E  uni870E,  CJK UNIFIED IDEOGRAPH-870E
        0x8709, # G+9586  U+8709  uni8709,  CJK UNIFIED IDEOGRAPH-8709
        0x8701, # G+9587  U+8701  uni8701,  CJK UNIFIED IDEOGRAPH-8701
        0x86F6, # G+9588  U+86F6  uni86F6,  CJK UNIFIED IDEOGRAPH-86F6
        0x870D, # G+9589  U+870D  uni870D,  CJK UNIFIED IDEOGRAPH-870D
        0x8705, # G+9590  U+8705  uni8705,  CJK UNIFIED IDEOGRAPH-8705
        0x88D6, # G+9591  U+88D6  uni88D6,  CJK UNIFIED IDEOGRAPH-88D6
        0x88CB, # G+9592  U+88CB  uni88CB,  CJK UNIFIED IDEOGRAPH-88CB
        0x88CD, # G+9593  U+88CD  uni88CD,  CJK UNIFIED IDEOGRAPH-88CD
        0x88CE, # G+9594  U+88CE  uni88CE,  CJK UNIFIED IDEOGRAPH-88CE
        0x88DE, # G+9595  U+88DE  uni88DE,  CJK UNIFIED IDEOGRAPH-88DE
        0x88DB, # G+9596  U+88DB  uni88DB,  CJK UNIFIED IDEOGRAPH-88DB
        0x88DA, # G+9597  U+88DA  uni88DA,  CJK UNIFIED IDEOGRAPH-88DA
        0x88CC, # G+9598  U+88CC  uni88CC,  CJK UNIFIED IDEOGRAPH-88CC
        0x88D0, # G+9599  U+88D0  uni88D0,  CJK UNIFIED IDEOGRAPH-88D0
        0x8985, # G+9600  U+8985  uni8985,  CJK UNIFIED IDEOGRAPH-8985
        0x899B, # G+9601  U+899B  uni899B,  CJK UNIFIED IDEOGRAPH-899B
        0x89DF, # G+9602  U+89DF  uni89DF,  CJK UNIFIED IDEOGRAPH-89DF
        0x89E5, # G+9603  U+89E5  uni89E5,  CJK UNIFIED IDEOGRAPH-89E5
        0x89E4, # G+9604  U+89E4  uni89E4,  CJK UNIFIED IDEOGRAPH-89E4
        0x89E1, # G+9605  U+89E1  uni89E1,  CJK UNIFIED IDEOGRAPH-89E1
        0x89E0, # G+9606  U+89E0  uni89E0,  CJK UNIFIED IDEOGRAPH-89E0
        0x89E2, # G+9607  U+89E2  uni89E2,  CJK UNIFIED IDEOGRAPH-89E2
        0x89DC, # G+9608  U+89DC  uni89DC,  CJK UNIFIED IDEOGRAPH-89DC
        0x89E6, # G+9609  U+89E6  uni89E6,  CJK UNIFIED IDEOGRAPH-89E6
        0x8A76, # G+9610  U+8A76  uni8A76,  CJK UNIFIED IDEOGRAPH-8A76
        0x8A86, # G+9611  U+8A86  uni8A86,  CJK UNIFIED IDEOGRAPH-8A86
        0x8A7F, # G+9612  U+8A7F  uni8A7F,  CJK UNIFIED IDEOGRAPH-8A7F
        0x8A61, # G+9613  U+8A61  uni8A61,  CJK UNIFIED IDEOGRAPH-8A61
        0x8A3F, # G+9614  U+8A3F  uni8A3F,  CJK UNIFIED IDEOGRAPH-8A3F
        0x8A77, # G+9615  U+8A77  uni8A77,  CJK UNIFIED IDEOGRAPH-8A77
        0x8A82, # G+9616  U+8A82  uni8A82,  CJK UNIFIED IDEOGRAPH-8A82
        0x8A84, # G+9617  U+8A84  uni8A84,  CJK UNIFIED IDEOGRAPH-8A84
        0x8A75, # G+9618  U+8A75  uni8A75,  CJK UNIFIED IDEOGRAPH-8A75
        0x8A83, # G+9619  U+8A83  uni8A83,  CJK UNIFIED IDEOGRAPH-8A83
        0x8A81, # G+9620  U+8A81  uni8A81,  CJK UNIFIED IDEOGRAPH-8A81
        0x8A74, # G+9621  U+8A74  uni8A74,  CJK UNIFIED IDEOGRAPH-8A74
        0x8A7A, # G+9622  U+8A7A  uni8A7A,  CJK UNIFIED IDEOGRAPH-8A7A
        0x8C3C, # G+9623  U+8C3C  uni8C3C,  CJK UNIFIED IDEOGRAPH-8C3C
        0x8C4B, # G+9624  U+8C4B  uni8C4B,  CJK UNIFIED IDEOGRAPH-8C4B
        0x8C4A, # G+9625  U+8C4A  uni8C4A,  CJK UNIFIED IDEOGRAPH-8C4A
        0x8C65, # G+9626  U+8C65  uni8C65,  CJK UNIFIED IDEOGRAPH-8C65
        0x8C64, # G+9627  U+8C64  uni8C64,  CJK UNIFIED IDEOGRAPH-8C64
        0x8C66, # G+9628  U+8C66  uni8C66,  CJK UNIFIED IDEOGRAPH-8C66
        0x8C86, # G+9629  U+8C86  uni8C86,  CJK UNIFIED IDEOGRAPH-8C86
        0x8C84, # G+9630  U+8C84  uni8C84,  CJK UNIFIED IDEOGRAPH-8C84
        0x8C85, # G+9631  U+8C85  uni8C85,  CJK UNIFIED IDEOGRAPH-8C85
        0x8CCC, # G+9632  U+8CCC  uni8CCC,  CJK UNIFIED IDEOGRAPH-8CCC
        0x8D68, # G+9633  U+8D68  uni8D68,  CJK UNIFIED IDEOGRAPH-8D68
        0x8D69, # G+9634  U+8D69  uni8D69,  CJK UNIFIED IDEOGRAPH-8D69
        0x8D91, # G+9635  U+8D91  uni8D91,  CJK UNIFIED IDEOGRAPH-8D91
        0x8D8C, # G+9636  U+8D8C  uni8D8C,  CJK UNIFIED IDEOGRAPH-8D8C
        0x8D8E, # G+9637  U+8D8E  uni8D8E,  CJK UNIFIED IDEOGRAPH-8D8E
        0x8D8F, # G+9638  U+8D8F  uni8D8F,  CJK UNIFIED IDEOGRAPH-8D8F
        0x8D8D, # G+9639  U+8D8D  uni8D8D,  CJK UNIFIED IDEOGRAPH-8D8D
        0x8D93, # G+9640  U+8D93  uni8D93,  CJK UNIFIED IDEOGRAPH-8D93
        0x8D94, # G+9641  U+8D94  uni8D94,  CJK UNIFIED IDEOGRAPH-8D94
        0x8D90, # G+9642  U+8D90  uni8D90,  CJK UNIFIED IDEOGRAPH-8D90
        0x8D92, # G+9643  U+8D92  uni8D92,  CJK UNIFIED IDEOGRAPH-8D92
        0x8DF0, # G+9644  U+8DF0  uni8DF0,  CJK UNIFIED IDEOGRAPH-8DF0
        0x8DE0, # G+9645  U+8DE0  uni8DE0,  CJK UNIFIED IDEOGRAPH-8DE0
        0x8DEC, # G+9646  U+8DEC  uni8DEC,  CJK UNIFIED IDEOGRAPH-8DEC
        0x8DF1, # G+9647  U+8DF1  uni8DF1,  CJK UNIFIED IDEOGRAPH-8DF1
        0x8DEE, # G+9648  U+8DEE  uni8DEE,  CJK UNIFIED IDEOGRAPH-8DEE
        0x8DD0, # G+9649  U+8DD0  uni8DD0,  CJK UNIFIED IDEOGRAPH-8DD0
        0x8DE9, # G+9650  U+8DE9  uni8DE9,  CJK UNIFIED IDEOGRAPH-8DE9
        0x8DE3, # G+9651  U+8DE3  uni8DE3,  CJK UNIFIED IDEOGRAPH-8DE3
        0x8DE2, # G+9652  U+8DE2  uni8DE2,  CJK UNIFIED IDEOGRAPH-8DE2
        0x8DE7, # G+9653  U+8DE7  uni8DE7,  CJK UNIFIED IDEOGRAPH-8DE7
        0x8DF2, # G+9654  U+8DF2  uni8DF2,  CJK UNIFIED IDEOGRAPH-8DF2
        0x8DEB, # G+9655  U+8DEB  uni8DEB,  CJK UNIFIED IDEOGRAPH-8DEB
        0x8DF4, # G+9656  U+8DF4  uni8DF4,  CJK UNIFIED IDEOGRAPH-8DF4
        0x8F06, # G+9657  U+8F06  uni8F06,  CJK UNIFIED IDEOGRAPH-8F06
        0x8EFF, # G+9658  U+8EFF  uni8EFF,  CJK UNIFIED IDEOGRAPH-8EFF
        0x8F01, # G+9659  U+8F01  uni8F01,  CJK UNIFIED IDEOGRAPH-8F01
        0x8F00, # G+9660  U+8F00  uni8F00,  CJK UNIFIED IDEOGRAPH-8F00
        0x8F05, # G+9661  U+8F05  uni8F05,  CJK UNIFIED IDEOGRAPH-8F05
        0x8F07, # G+9662  U+8F07  uni8F07,  CJK UNIFIED IDEOGRAPH-8F07
        0x8F08, # G+9663  U+8F08  uni8F08,  CJK UNIFIED IDEOGRAPH-8F08
        0x8F02, # G+9664  U+8F02  uni8F02,  CJK UNIFIED IDEOGRAPH-8F02
        0x8F0B, # G+9665  U+8F0B  uni8F0B,  CJK UNIFIED IDEOGRAPH-8F0B
        0x9052, # G+9666  U+9052  uni9052,  CJK UNIFIED IDEOGRAPH-9052
        0x903F, # G+9667  U+903F  uni903F,  CJK UNIFIED IDEOGRAPH-903F
        0x9044, # G+9668  U+9044  uni9044,  CJK UNIFIED IDEOGRAPH-9044
        0x9049, # G+9669  U+9049  uni9049,  CJK UNIFIED IDEOGRAPH-9049
        0x903D, # G+9670  U+903D  uni903D,  CJK UNIFIED IDEOGRAPH-903D
        0x9110, # G+9671  U+9110  uni9110,  CJK UNIFIED IDEOGRAPH-9110
        0x910D, # G+9672  U+910D  uni910D,  CJK UNIFIED IDEOGRAPH-910D
        0x910F, # G+9673  U+910F  uni910F,  CJK UNIFIED IDEOGRAPH-910F
        0x9111, # G+9674  U+9111  uni9111,  CJK UNIFIED IDEOGRAPH-9111
        0x9116, # G+9675  U+9116  uni9116,  CJK UNIFIED IDEOGRAPH-9116
        0x9114, # G+9676  U+9114  uni9114,  CJK UNIFIED IDEOGRAPH-9114
        0x910B, # G+9677  U+910B  uni910B,  CJK UNIFIED IDEOGRAPH-910B
        0x910E, # G+9678  U+910E  uni910E,  CJK UNIFIED IDEOGRAPH-910E
        0x916E, # G+9679  U+916E  uni916E,  CJK UNIFIED IDEOGRAPH-916E
        0x916F, # G+9680  U+916F  uni916F,  CJK UNIFIED IDEOGRAPH-916F
        0x9248, # G+9681  U+9248  uni9248,  CJK UNIFIED IDEOGRAPH-9248
        0x9252, # G+9682  U+9252  uni9252,  CJK UNIFIED IDEOGRAPH-9252
        0x9230, # G+9683  U+9230  uni9230,  CJK UNIFIED IDEOGRAPH-9230
        0x923A, # G+9684  U+923A  uni923A,  CJK UNIFIED IDEOGRAPH-923A
        0x9266, # G+9685  U+9266  uni9266,  CJK UNIFIED IDEOGRAPH-9266
        0x9233, # G+9686  U+9233  uni9233,  CJK UNIFIED IDEOGRAPH-9233
        0x9265, # G+9687  U+9265  uni9265,  CJK UNIFIED IDEOGRAPH-9265
        0x925E, # G+9688  U+925E  uni925E,  CJK UNIFIED IDEOGRAPH-925E
        0x9283, # G+9689  U+9283  uni9283,  CJK UNIFIED IDEOGRAPH-9283
        0x922E, # G+9690  U+922E  uni922E,  CJK UNIFIED IDEOGRAPH-922E
        0x924A, # G+9691  U+924A  uni924A,  CJK UNIFIED IDEOGRAPH-924A
        0x9246, # G+9692  U+9246  uni9246,  CJK UNIFIED IDEOGRAPH-9246
        0x926D, # G+9693  U+926D  uni926D,  CJK UNIFIED IDEOGRAPH-926D
        0x926C, # G+9694  U+926C  uni926C,  CJK UNIFIED IDEOGRAPH-926C
        0x924F, # G+9695  U+924F  uni924F,  CJK UNIFIED IDEOGRAPH-924F
        0x9260, # G+9696  U+9260  uni9260,  CJK UNIFIED IDEOGRAPH-9260
        0x9267, # G+9697  U+9267  uni9267,  CJK UNIFIED IDEOGRAPH-9267
        0x926F, # G+9698  U+926F  uni926F,  CJK UNIFIED IDEOGRAPH-926F
        0x9236, # G+9699  U+9236  uni9236,  CJK UNIFIED IDEOGRAPH-9236
        0x9261, # G+9700  U+9261  uni9261,  CJK UNIFIED IDEOGRAPH-9261
        0x9270, # G+9701  U+9270  uni9270,  CJK UNIFIED IDEOGRAPH-9270
        0x9231, # G+9702  U+9231  uni9231,  CJK UNIFIED IDEOGRAPH-9231
        0x9254, # G+9703  U+9254  uni9254,  CJK UNIFIED IDEOGRAPH-9254
        0x9263, # G+9704  U+9263  uni9263,  CJK UNIFIED IDEOGRAPH-9263
        0x9250, # G+9705  U+9250  uni9250,  CJK UNIFIED IDEOGRAPH-9250
        0x9272, # G+9706  U+9272  uni9272,  CJK UNIFIED IDEOGRAPH-9272
        0x924E, # G+9707  U+924E  uni924E,  CJK UNIFIED IDEOGRAPH-924E
        0x9253, # G+9708  U+9253  uni9253,  CJK UNIFIED IDEOGRAPH-9253
        0x924C, # G+9709  U+924C  uni924C,  CJK UNIFIED IDEOGRAPH-924C
        0x9256, # G+9710  U+9256  uni9256,  CJK UNIFIED IDEOGRAPH-9256
        0x9232, # G+9711  U+9232  uni9232,  CJK UNIFIED IDEOGRAPH-9232
        0x959F, # G+9712  U+959F  uni959F,  CJK UNIFIED IDEOGRAPH-959F
        0x959C, # G+9713  U+959C  uni959C,  CJK UNIFIED IDEOGRAPH-959C
        0x959E, # G+9714  U+959E  uni959E,  CJK UNIFIED IDEOGRAPH-959E
        0x959B, # G+9715  U+959B  uni959B,  CJK UNIFIED IDEOGRAPH-959B
        0x9692, # G+9716  U+9692  uni9692,  CJK UNIFIED IDEOGRAPH-9692
        0x9693, # G+9717  U+9693  uni9693,  CJK UNIFIED IDEOGRAPH-9693
        0x9691, # G+9718  U+9691  uni9691,  CJK UNIFIED IDEOGRAPH-9691
        0x9697, # G+9719  U+9697  uni9697,  CJK UNIFIED IDEOGRAPH-9697
        0x96CE, # G+9720  U+96CE  uni96CE,  CJK UNIFIED IDEOGRAPH-96CE
        0x96FA, # G+9721  U+96FA  uni96FA,  CJK UNIFIED IDEOGRAPH-96FA
        0x96FD, # G+9722  U+96FD  uni96FD,  CJK UNIFIED IDEOGRAPH-96FD
        0x96F8, # G+9723  U+96F8  uni96F8,  CJK UNIFIED IDEOGRAPH-96F8
        0x96F5, # G+9724  U+96F5  uni96F5,  CJK UNIFIED IDEOGRAPH-96F5
        0x9773, # G+9725  U+9773  uni9773,  CJK UNIFIED IDEOGRAPH-9773
        0x9777, # G+9726  U+9777  uni9777,  CJK UNIFIED IDEOGRAPH-9777
        0x9778, # G+9727  U+9778  uni9778,  CJK UNIFIED IDEOGRAPH-9778
        0x9772, # G+9728  U+9772  uni9772,  CJK UNIFIED IDEOGRAPH-9772
        0x980F, # G+9729  U+980F  uni980F,  CJK UNIFIED IDEOGRAPH-980F
        0x980D, # G+9730  U+980D  uni980D,  CJK UNIFIED IDEOGRAPH-980D
        0x980E, # G+9731  U+980E  uni980E,  CJK UNIFIED IDEOGRAPH-980E
        0x98AC, # G+9732  U+98AC  uni98AC,  CJK UNIFIED IDEOGRAPH-98AC
        0x98F6, # G+9733  U+98F6  uni98F6,  CJK UNIFIED IDEOGRAPH-98F6
        0x98F9, # G+9734  U+98F9  uni98F9,  CJK UNIFIED IDEOGRAPH-98F9
        0x99AF, # G+9735  U+99AF  uni99AF,  CJK UNIFIED IDEOGRAPH-99AF
        0x99B2, # G+9736  U+99B2  uni99B2,  CJK UNIFIED IDEOGRAPH-99B2
        0x99B0, # G+9737  U+99B0  uni99B0,  CJK UNIFIED IDEOGRAPH-99B0
        0x99B5, # G+9738  U+99B5  uni99B5,  CJK UNIFIED IDEOGRAPH-99B5
        0x9AAD, # G+9739  U+9AAD  uni9AAD,  CJK UNIFIED IDEOGRAPH-9AAD
        0x9AAB, # G+9740  U+9AAB  uni9AAB,  CJK UNIFIED IDEOGRAPH-9AAB
        0x9B5B, # G+9741  U+9B5B  uni9B5B,  CJK UNIFIED IDEOGRAPH-9B5B
        0x9CEA, # G+9742  U+9CEA  uni9CEA,  CJK UNIFIED IDEOGRAPH-9CEA
        0x9CED, # G+9743  U+9CED  uni9CED,  CJK UNIFIED IDEOGRAPH-9CED
        0x9CE7, # G+9744  U+9CE7  uni9CE7,  CJK UNIFIED IDEOGRAPH-9CE7
        0x9E80, # G+9745  U+9E80  uni9E80,  CJK UNIFIED IDEOGRAPH-9E80
        0x2FCC, # G+9746  U+2FCC  uni2FCC,  KANGXI RADICAL FROG
        0x50E6, # G+9747  U+50E6  uni50E6,  CJK UNIFIED IDEOGRAPH-50E6
        0x50D4, # G+9748  U+50D4  uni50D4,  CJK UNIFIED IDEOGRAPH-50D4
        0x50D7, # G+9749  U+50D7  uni50D7,  CJK UNIFIED IDEOGRAPH-50D7
        0x50E8, # G+9750  U+50E8  uni50E8,  CJK UNIFIED IDEOGRAPH-50E8
        0x50F3, # G+9751  U+50F3  uni50F3,  CJK UNIFIED IDEOGRAPH-50F3
        0x50DB, # G+9752  U+50DB  uni50DB,  CJK UNIFIED IDEOGRAPH-50DB
        0x50EA, # G+9753  U+50EA  uni50EA,  CJK UNIFIED IDEOGRAPH-50EA
        0x50DD, # G+9754  U+50DD  uni50DD,  CJK UNIFIED IDEOGRAPH-50DD
        0x50E4, # G+9755  U+50E4  uni50E4,  CJK UNIFIED IDEOGRAPH-50E4
        0x50D3, # G+9756  U+50D3  uni50D3,  CJK UNIFIED IDEOGRAPH-50D3
        0x50EC, # G+9757  U+50EC  uni50EC,  CJK UNIFIED IDEOGRAPH-50EC
        0x50F0, # G+9758  U+50F0  uni50F0,  CJK UNIFIED IDEOGRAPH-50F0
        0x50EF, # G+9759  U+50EF  uni50EF,  CJK UNIFIED IDEOGRAPH-50EF
        0x50E3, # G+9760  U+50E3  uni50E3,  CJK UNIFIED IDEOGRAPH-50E3
        0x50E0, # G+9761  U+50E0  uni50E0,  CJK UNIFIED IDEOGRAPH-50E0
        0x51D8, # G+9762  U+51D8  uni51D8,  CJK UNIFIED IDEOGRAPH-51D8
        0x5280, # G+9763  U+5280  uni5280,  CJK UNIFIED IDEOGRAPH-5280
        0x5281, # G+9764  U+5281  uni5281,  CJK UNIFIED IDEOGRAPH-5281
        0x52E9, # G+9765  U+52E9  uni52E9,  CJK UNIFIED IDEOGRAPH-52E9
        0x52EB, # G+9766  U+52EB  uni52EB,  CJK UNIFIED IDEOGRAPH-52EB
        0x5330, # G+9767  U+5330  uni5330,  CJK UNIFIED IDEOGRAPH-5330
        0x53AC, # G+9768  U+53AC  uni53AC,  CJK UNIFIED IDEOGRAPH-53AC
        0x5627, # G+9769  U+5627  uni5627,  CJK UNIFIED IDEOGRAPH-5627
        0x5615, # G+9770  U+5615  uni5615,  CJK UNIFIED IDEOGRAPH-5615
        0x560C, # G+9771  U+560C  uni560C,  CJK UNIFIED IDEOGRAPH-560C
        0x5612, # G+9772  U+5612  uni5612,  CJK UNIFIED IDEOGRAPH-5612
        0x55FC, # G+9773  U+55FC  uni55FC,  CJK UNIFIED IDEOGRAPH-55FC
        0x560F, # G+9774  U+560F  uni560F,  CJK UNIFIED IDEOGRAPH-560F
        0x561C, # G+9775  U+561C  uni561C,  CJK UNIFIED IDEOGRAPH-561C
        0x5601, # G+9776  U+5601  uni5601,  CJK UNIFIED IDEOGRAPH-5601
        0x5613, # G+9777  U+5613  uni5613,  CJK UNIFIED IDEOGRAPH-5613
        0x5602, # G+9778  U+5602  uni5602,  CJK UNIFIED IDEOGRAPH-5602
        0x55FA, # G+9779  U+55FA  uni55FA,  CJK UNIFIED IDEOGRAPH-55FA
        0x561D, # G+9780  U+561D  uni561D,  CJK UNIFIED IDEOGRAPH-561D
        0x5604, # G+9781  U+5604  uni5604,  CJK UNIFIED IDEOGRAPH-5604
        0x55FF, # G+9782  U+55FF  uni55FF,  CJK UNIFIED IDEOGRAPH-55FF
        0x55F9, # G+9783  U+55F9  uni55F9,  CJK UNIFIED IDEOGRAPH-55F9
        0x5889, # G+9784  U+5889  uni5889,  CJK UNIFIED IDEOGRAPH-5889
        0x587C, # G+9785  U+587C  uni587C,  CJK UNIFIED IDEOGRAPH-587C
        0x5890, # G+9786  U+5890  uni5890,  CJK UNIFIED IDEOGRAPH-5890
        0x5898, # G+9787  U+5898  uni5898,  CJK UNIFIED IDEOGRAPH-5898
        0x5886, # G+9788  U+5886  uni5886,  CJK UNIFIED IDEOGRAPH-5886
        0x5881, # G+9789  U+5881  uni5881,  CJK UNIFIED IDEOGRAPH-5881
        0x587F, # G+9790  U+587F  uni587F,  CJK UNIFIED IDEOGRAPH-587F
        0x5874, # G+9791  U+5874  uni5874,  CJK UNIFIED IDEOGRAPH-5874
        0x588B, # G+9792  U+588B  uni588B,  CJK UNIFIED IDEOGRAPH-588B
        0x587A, # G+9793  U+587A  uni587A,  CJK UNIFIED IDEOGRAPH-587A
        0x5887, # G+9794  U+5887  uni5887,  CJK UNIFIED IDEOGRAPH-5887
        0x5891, # G+9795  U+5891  uni5891,  CJK UNIFIED IDEOGRAPH-5891
        0x588E, # G+9796  U+588E  uni588E,  CJK UNIFIED IDEOGRAPH-588E
        0x5876, # G+9797  U+5876  uni5876,  CJK UNIFIED IDEOGRAPH-5876
        0x5882, # G+9798  U+5882  uni5882,  CJK UNIFIED IDEOGRAPH-5882
        0x5888, # G+9799  U+5888  uni5888,  CJK UNIFIED IDEOGRAPH-5888
        0x587B, # G+9800  U+587B  uni587B,  CJK UNIFIED IDEOGRAPH-587B
        0x5894, # G+9801  U+5894  uni5894,  CJK UNIFIED IDEOGRAPH-5894
        0x588F, # G+9802  U+588F  uni588F,  CJK UNIFIED IDEOGRAPH-588F
        0x58FE, # G+9803  U+58FE  uni58FE,  CJK UNIFIED IDEOGRAPH-58FE
        0x596B, # G+9804  U+596B  uni596B,  CJK UNIFIED IDEOGRAPH-596B
        0x5ADC, # G+9805  U+5ADC  uni5ADC,  CJK UNIFIED IDEOGRAPH-5ADC
        0x5AEE, # G+9806  U+5AEE  uni5AEE,  CJK UNIFIED IDEOGRAPH-5AEE
        0x5AE5, # G+9807  U+5AE5  uni5AE5,  CJK UNIFIED IDEOGRAPH-5AE5
        0x5AD5, # G+9808  U+5AD5  uni5AD5,  CJK UNIFIED IDEOGRAPH-5AD5
        0x5AEA, # G+9809  U+5AEA  uni5AEA,  CJK UNIFIED IDEOGRAPH-5AEA
        0x5ADA, # G+9810  U+5ADA  uni5ADA,  CJK UNIFIED IDEOGRAPH-5ADA
        0x5AED, # G+9811  U+5AED  uni5AED,  CJK UNIFIED IDEOGRAPH-5AED
        0x5AEB, # G+9812  U+5AEB  uni5AEB,  CJK UNIFIED IDEOGRAPH-5AEB
        0x5AF3, # G+9813  U+5AF3  uni5AF3,  CJK UNIFIED IDEOGRAPH-5AF3
        0x5AE2, # G+9814  U+5AE2  uni5AE2,  CJK UNIFIED IDEOGRAPH-5AE2
        0x5AE0, # G+9815  U+5AE0  uni5AE0,  CJK UNIFIED IDEOGRAPH-5AE0
        0x5ADB, # G+9816  U+5ADB  uni5ADB,  CJK UNIFIED IDEOGRAPH-5ADB
        0x5AEC, # G+9817  U+5AEC  uni5AEC,  CJK UNIFIED IDEOGRAPH-5AEC
        0x5ADE, # G+9818  U+5ADE  uni5ADE,  CJK UNIFIED IDEOGRAPH-5ADE
        0x5ADD, # G+9819  U+5ADD  uni5ADD,  CJK UNIFIED IDEOGRAPH-5ADD
        0x5AD9, # G+9820  U+5AD9  uni5AD9,  CJK UNIFIED IDEOGRAPH-5AD9
        0x5AE8, # G+9821  U+5AE8  uni5AE8,  CJK UNIFIED IDEOGRAPH-5AE8
        0x5ADF, # G+9822  U+5ADF  uni5ADF,  CJK UNIFIED IDEOGRAPH-5ADF
        0x5B77, # G+9823  U+5B77  uni5B77,  CJK UNIFIED IDEOGRAPH-5B77
        0x5BE0, # G+9824  U+5BE0  uni5BE0,  CJK UNIFIED IDEOGRAPH-5BE0
        0x5BE3, # G+9825  U+5BE3  uni5BE3,  CJK UNIFIED IDEOGRAPH-5BE3
        0x5C63, # G+9826  U+5C63  uni5C63,  CJK UNIFIED IDEOGRAPH-5C63
        0x5D82, # G+9827  U+5D82  uni5D82,  CJK UNIFIED IDEOGRAPH-5D82
        0x5D80, # G+9828  U+5D80  uni5D80,  CJK UNIFIED IDEOGRAPH-5D80
        0x5D7D, # G+9829  U+5D7D  uni5D7D,  CJK UNIFIED IDEOGRAPH-5D7D
        0x5D86, # G+9830  U+5D86  uni5D86,  CJK UNIFIED IDEOGRAPH-5D86
        0x5D7A, # G+9831  U+5D7A  uni5D7A,  CJK UNIFIED IDEOGRAPH-5D7A
        0x5D81, # G+9832  U+5D81  uni5D81,  CJK UNIFIED IDEOGRAPH-5D81
        0x5D77, # G+9833  U+5D77  uni5D77,  CJK UNIFIED IDEOGRAPH-5D77
        0x5D8A, # G+9834  U+5D8A  uni5D8A,  CJK UNIFIED IDEOGRAPH-5D8A
        0x5D89, # G+9835  U+5D89  uni5D89,  CJK UNIFIED IDEOGRAPH-5D89
        0x5D88, # G+9836  U+5D88  uni5D88,  CJK UNIFIED IDEOGRAPH-5D88
        0x5D7E, # G+9837  U+5D7E  uni5D7E,  CJK UNIFIED IDEOGRAPH-5D7E
        0x5D7C, # G+9838  U+5D7C  uni5D7C,  CJK UNIFIED IDEOGRAPH-5D7C
        0x5D8D, # G+9839  U+5D8D  uni5D8D,  CJK UNIFIED IDEOGRAPH-5D8D
        0x5D79, # G+9840  U+5D79  uni5D79,  CJK UNIFIED IDEOGRAPH-5D79
        0x5D7F, # G+9841  U+5D7F  uni5D7F,  CJK UNIFIED IDEOGRAPH-5D7F
        0x5E58, # G+9842  U+5E58  uni5E58,  CJK UNIFIED IDEOGRAPH-5E58
        0x5E59, # G+9843  U+5E59  uni5E59,  CJK UNIFIED IDEOGRAPH-5E59
        0x5E53, # G+9844  U+5E53  uni5E53,  CJK UNIFIED IDEOGRAPH-5E53
        0x5ED8, # G+9845  U+5ED8  uni5ED8,  CJK UNIFIED IDEOGRAPH-5ED8
        0x5ED1, # G+9846  U+5ED1  uni5ED1,  CJK UNIFIED IDEOGRAPH-5ED1
        0x5ED7, # G+9847  U+5ED7  uni5ED7,  CJK UNIFIED IDEOGRAPH-5ED7
        0x5ECE, # G+9848  U+5ECE  uni5ECE,  CJK UNIFIED IDEOGRAPH-5ECE
        0x5EDC, # G+9849  U+5EDC  uni5EDC,  CJK UNIFIED IDEOGRAPH-5EDC
        0x5ED5, # G+9850  U+5ED5  uni5ED5,  CJK UNIFIED IDEOGRAPH-5ED5
        0x5ED9, # G+9851  U+5ED9  uni5ED9,  CJK UNIFIED IDEOGRAPH-5ED9
        0x5ED2, # G+9852  U+5ED2  uni5ED2,  CJK UNIFIED IDEOGRAPH-5ED2
        0x5ED4, # G+9853  U+5ED4  uni5ED4,  CJK UNIFIED IDEOGRAPH-5ED4
        0x5F44, # G+9854  U+5F44  uni5F44,  CJK UNIFIED IDEOGRAPH-5F44
        0x5F43, # G+9855  U+5F43  uni5F43,  CJK UNIFIED IDEOGRAPH-5F43
        0x5F6F, # G+9856  U+5F6F  uni5F6F,  CJK UNIFIED IDEOGRAPH-5F6F
        0x5FB6, # G+9857  U+5FB6  uni5FB6,  CJK UNIFIED IDEOGRAPH-5FB6
        0x612C, # G+9858  U+612C  uni612C,  CJK UNIFIED IDEOGRAPH-612C
        0x6128, # G+9859  U+6128  uni6128,  CJK UNIFIED IDEOGRAPH-6128
        0x6141, # G+9860  U+6141  uni6141,  CJK UNIFIED IDEOGRAPH-6141
        0x615E, # G+9861  U+615E  uni615E,  CJK UNIFIED IDEOGRAPH-615E
        0x6171, # G+9862  U+6171  uni6171,  CJK UNIFIED IDEOGRAPH-6171
        0x6173, # G+9863  U+6173  uni6173,  CJK UNIFIED IDEOGRAPH-6173
        0x6152, # G+9864  U+6152  uni6152,  CJK UNIFIED IDEOGRAPH-6152
        0x6153, # G+9865  U+6153  uni6153,  CJK UNIFIED IDEOGRAPH-6153
        0x6172, # G+9866  U+6172  uni6172,  CJK UNIFIED IDEOGRAPH-6172
        0x616C, # G+9867  U+616C  uni616C,  CJK UNIFIED IDEOGRAPH-616C
        0x6180, # G+9868  U+6180  uni6180,  CJK UNIFIED IDEOGRAPH-6180
        0x6174, # G+9869  U+6174  uni6174,  CJK UNIFIED IDEOGRAPH-6174
        0x6154, # G+9870  U+6154  uni6154,  CJK UNIFIED IDEOGRAPH-6154
        0x617A, # G+9871  U+617A  uni617A,  CJK UNIFIED IDEOGRAPH-617A
        0x615B, # G+9872  U+615B  uni615B,  CJK UNIFIED IDEOGRAPH-615B
        0x6165, # G+9873  U+6165  uni6165,  CJK UNIFIED IDEOGRAPH-6165
        0x613B, # G+9874  U+613B  uni613B,  CJK UNIFIED IDEOGRAPH-613B
        0x616A, # G+9875  U+616A  uni616A,  CJK UNIFIED IDEOGRAPH-616A
        0x6161, # G+9876  U+6161  uni6161,  CJK UNIFIED IDEOGRAPH-6161
        0x6156, # G+9877  U+6156  uni6156,  CJK UNIFIED IDEOGRAPH-6156
        0x6229, # G+9878  U+6229  uni6229,  CJK UNIFIED IDEOGRAPH-6229
        0x6227, # G+9879  U+6227  uni6227,  CJK UNIFIED IDEOGRAPH-6227
        0x622B, # G+9880  U+622B  uni622B,  CJK UNIFIED IDEOGRAPH-622B
        0x642B, # G+9881  U+642B  uni642B,  CJK UNIFIED IDEOGRAPH-642B
        0x644D, # G+9882  U+644D  uni644D,  CJK UNIFIED IDEOGRAPH-644D
        0x645B, # G+9883  U+645B  uni645B,  CJK UNIFIED IDEOGRAPH-645B
        0x645D, # G+9884  U+645D  uni645D,  CJK UNIFIED IDEOGRAPH-645D
        0x6474, # G+9885  U+6474  uni6474,  CJK UNIFIED IDEOGRAPH-6474
        0x6476, # G+9886  U+6476  uni6476,  CJK UNIFIED IDEOGRAPH-6476
        0x6472, # G+9887  U+6472  uni6472,  CJK UNIFIED IDEOGRAPH-6472
        0x6473, # G+9888  U+6473  uni6473,  CJK UNIFIED IDEOGRAPH-6473
        0x647D, # G+9889  U+647D  uni647D,  CJK UNIFIED IDEOGRAPH-647D
        0x6475, # G+9890  U+6475  uni6475,  CJK UNIFIED IDEOGRAPH-6475
        0x6466, # G+9891  U+6466  uni6466,  CJK UNIFIED IDEOGRAPH-6466
        0x64A6, # G+9892  U+64A6  uni64A6,  CJK UNIFIED IDEOGRAPH-64A6
        0x644E, # G+9893  U+644E  uni644E,  CJK UNIFIED IDEOGRAPH-644E
        0x6482, # G+9894  U+6482  uni6482,  CJK UNIFIED IDEOGRAPH-6482
        0x645E, # G+9895  U+645E  uni645E,  CJK UNIFIED IDEOGRAPH-645E
        0x645C, # G+9896  U+645C  uni645C,  CJK UNIFIED IDEOGRAPH-645C
        0x644B, # G+9897  U+644B  uni644B,  CJK UNIFIED IDEOGRAPH-644B
        0x6453, # G+9898  U+6453  uni6453,  CJK UNIFIED IDEOGRAPH-6453
        0x6460, # G+9899  U+6460  uni6460,  CJK UNIFIED IDEOGRAPH-6460
        0x6450, # G+9900  U+6450  uni6450,  CJK UNIFIED IDEOGRAPH-6450
        0x647F, # G+9901  U+647F  uni647F,  CJK UNIFIED IDEOGRAPH-647F
        0x643F, # G+9902  U+643F  uni643F,  CJK UNIFIED IDEOGRAPH-643F
        0x646C, # G+9903  U+646C  uni646C,  CJK UNIFIED IDEOGRAPH-646C
        0x646B, # G+9904  U+646B  uni646B,  CJK UNIFIED IDEOGRAPH-646B
        0x6459, # G+9905  U+6459  uni6459,  CJK UNIFIED IDEOGRAPH-6459
        0x6465, # G+9906  U+6465  uni6465,  CJK UNIFIED IDEOGRAPH-6465
        0x6477, # G+9907  U+6477  uni6477,  CJK UNIFIED IDEOGRAPH-6477
        0x6573, # G+9908  U+6573  uni6573,  CJK UNIFIED IDEOGRAPH-6573
        0x65A0, # G+9909  U+65A0  uni65A0,  CJK UNIFIED IDEOGRAPH-65A0
        0x66A1, # G+9910  U+66A1  uni66A1,  CJK UNIFIED IDEOGRAPH-66A1
        0x66A0, # G+9911  U+66A0  uni66A0,  CJK UNIFIED IDEOGRAPH-66A0
        0x669F, # G+9912  U+669F  uni669F,  CJK UNIFIED IDEOGRAPH-669F
        0x6705, # G+9913  U+6705  uni6705,  CJK UNIFIED IDEOGRAPH-6705
        0x6704, # G+9914  U+6704  uni6704,  CJK UNIFIED IDEOGRAPH-6704
        0x6722, # G+9915  U+6722  uni6722,  CJK UNIFIED IDEOGRAPH-6722
        0x69B1, # G+9916  U+69B1  uni69B1,  CJK UNIFIED IDEOGRAPH-69B1
        0x69B6, # G+9917  U+69B6  uni69B6,  CJK UNIFIED IDEOGRAPH-69B6
        0x69C9, # G+9918  U+69C9  uni69C9,  CJK UNIFIED IDEOGRAPH-69C9
        0x69A0, # G+9919  U+69A0  uni69A0,  CJK UNIFIED IDEOGRAPH-69A0
        0x69CE, # G+9920  U+69CE  uni69CE,  CJK UNIFIED IDEOGRAPH-69CE
        0x6996, # G+9921  U+6996  uni6996,  CJK UNIFIED IDEOGRAPH-6996
        0x69B0, # G+9922  U+69B0  uni69B0,  CJK UNIFIED IDEOGRAPH-69B0
        0x69AC, # G+9923  U+69AC  uni69AC,  CJK UNIFIED IDEOGRAPH-69AC
        0x69BC, # G+9924  U+69BC  uni69BC,  CJK UNIFIED IDEOGRAPH-69BC
        0x6991, # G+9925  U+6991  uni6991,  CJK UNIFIED IDEOGRAPH-6991
        0x6999, # G+9926  U+6999  uni6999,  CJK UNIFIED IDEOGRAPH-6999
        0x698E, # G+9927  U+698E  uni698E,  CJK UNIFIED IDEOGRAPH-698E
        0x69A7, # G+9928  U+69A7  uni69A7,  CJK UNIFIED IDEOGRAPH-69A7
        0x698D, # G+9929  U+698D  uni698D,  CJK UNIFIED IDEOGRAPH-698D
        0x69A9, # G+9930  U+69A9  uni69A9,  CJK UNIFIED IDEOGRAPH-69A9
        0x69BE, # G+9931  U+69BE  uni69BE,  CJK UNIFIED IDEOGRAPH-69BE
        0x69AF, # G+9932  U+69AF  uni69AF,  CJK UNIFIED IDEOGRAPH-69AF
        0x69BF, # G+9933  U+69BF  uni69BF,  CJK UNIFIED IDEOGRAPH-69BF
        0x69C4, # G+9934  U+69C4  uni69C4,  CJK UNIFIED IDEOGRAPH-69C4
        0x69BD, # G+9935  U+69BD  uni69BD,  CJK UNIFIED IDEOGRAPH-69BD
        0x69A4, # G+9936  U+69A4  uni69A4,  CJK UNIFIED IDEOGRAPH-69A4
        0x69D4, # G+9937  U+69D4  uni69D4,  CJK UNIFIED IDEOGRAPH-69D4
        0x69B9, # G+9938  U+69B9  uni69B9,  CJK UNIFIED IDEOGRAPH-69B9
        0x69CA, # G+9939  U+69CA  uni69CA,  CJK UNIFIED IDEOGRAPH-69CA
        0x699A, # G+9940  U+699A  uni699A,  CJK UNIFIED IDEOGRAPH-699A
        0x69CF, # G+9941  U+69CF  uni69CF,  CJK UNIFIED IDEOGRAPH-69CF
        0x69B3, # G+9942  U+69B3  uni69B3,  CJK UNIFIED IDEOGRAPH-69B3
        0x6993, # G+9943  U+6993  uni6993,  CJK UNIFIED IDEOGRAPH-6993
        0x69AA, # G+9944  U+69AA  uni69AA,  CJK UNIFIED IDEOGRAPH-69AA
        0x69A1, # G+9945  U+69A1  uni69A1,  CJK UNIFIED IDEOGRAPH-69A1
        0x699E, # G+9946  U+699E  uni699E,  CJK UNIFIED IDEOGRAPH-699E
        0x69D9, # G+9947  U+69D9  uni69D9,  CJK UNIFIED IDEOGRAPH-69D9
        0x6997, # G+9948  U+6997  uni6997,  CJK UNIFIED IDEOGRAPH-6997
        0x6990, # G+9949  U+6990  uni6990,  CJK UNIFIED IDEOGRAPH-6990
        0x69C2, # G+9950  U+69C2  uni69C2,  CJK UNIFIED IDEOGRAPH-69C2
        0x69B5, # G+9951  U+69B5  uni69B5,  CJK UNIFIED IDEOGRAPH-69B5
        0x69A5, # G+9952  U+69A5  uni69A5,  CJK UNIFIED IDEOGRAPH-69A5
        0x69C6, # G+9953  U+69C6  uni69C6,  CJK UNIFIED IDEOGRAPH-69C6
        0x6B4A, # G+9954  U+6B4A  uni6B4A,  CJK UNIFIED IDEOGRAPH-6B4A
        0x6B4D, # G+9955  U+6B4D  uni6B4D,  CJK UNIFIED IDEOGRAPH-6B4D
        0x6B4B, # G+9956  U+6B4B  uni6B4B,  CJK UNIFIED IDEOGRAPH-6B4B
        0x6B9E, # G+9957  U+6B9E  uni6B9E,  CJK UNIFIED IDEOGRAPH-6B9E
        0x6B9F, # G+9958  U+6B9F  uni6B9F,  CJK UNIFIED IDEOGRAPH-6B9F
        0x6BA0, # G+9959  U+6BA0  uni6BA0,  CJK UNIFIED IDEOGRAPH-6BA0
        0x6BC3, # G+9960  U+6BC3  uni6BC3,  CJK UNIFIED IDEOGRAPH-6BC3
        0x6BC4, # G+9961  U+6BC4  uni6BC4,  CJK UNIFIED IDEOGRAPH-6BC4
        0x6BFE, # G+9962  U+6BFE  uni6BFE,  CJK UNIFIED IDEOGRAPH-6BFE
        0x6ECE, # G+9963  U+6ECE  uni6ECE,  CJK UNIFIED IDEOGRAPH-6ECE
        0x6EF5, # G+9964  U+6EF5  uni6EF5,  CJK UNIFIED IDEOGRAPH-6EF5
        0x6EF1, # G+9965  U+6EF1  uni6EF1,  CJK UNIFIED IDEOGRAPH-6EF1
        0x6F03, # G+9966  U+6F03  uni6F03,  CJK UNIFIED IDEOGRAPH-6F03
        0x6F25, # G+9967  U+6F25  uni6F25,  CJK UNIFIED IDEOGRAPH-6F25
        0x6EF8, # G+9968  U+6EF8  uni6EF8,  CJK UNIFIED IDEOGRAPH-6EF8
        0x6F37, # G+9969  U+6F37  uni6F37,  CJK UNIFIED IDEOGRAPH-6F37
        0x6EFB, # G+9970  U+6EFB  uni6EFB,  CJK UNIFIED IDEOGRAPH-6EFB
        0x6F2E, # G+9971  U+6F2E  uni6F2E,  CJK UNIFIED IDEOGRAPH-6F2E
        0x6F09, # G+9972  U+6F09  uni6F09,  CJK UNIFIED IDEOGRAPH-6F09
        0x6F4E, # G+9973  U+6F4E  uni6F4E,  CJK UNIFIED IDEOGRAPH-6F4E
        0x6F19, # G+9974  U+6F19  uni6F19,  CJK UNIFIED IDEOGRAPH-6F19
        0x6F1A, # G+9975  U+6F1A  uni6F1A,  CJK UNIFIED IDEOGRAPH-6F1A
        0x6F27, # G+9976  U+6F27  uni6F27,  CJK UNIFIED IDEOGRAPH-6F27
        0x6F18, # G+9977  U+6F18  uni6F18,  CJK UNIFIED IDEOGRAPH-6F18
        0x6F3B, # G+9978  U+6F3B  uni6F3B,  CJK UNIFIED IDEOGRAPH-6F3B
        0x6F12, # G+9979  U+6F12  uni6F12,  CJK UNIFIED IDEOGRAPH-6F12
        0x6EED, # G+9980  U+6EED  uni6EED,  CJK UNIFIED IDEOGRAPH-6EED
        0x6F0A, # G+9981  U+6F0A  uni6F0A,  CJK UNIFIED IDEOGRAPH-6F0A
        0x6F36, # G+9982  U+6F36  uni6F36,  CJK UNIFIED IDEOGRAPH-6F36
        0x6F73, # G+9983  U+6F73  uni6F73,  CJK UNIFIED IDEOGRAPH-6F73
        0x6EF9, # G+9984  U+6EF9  uni6EF9,  CJK UNIFIED IDEOGRAPH-6EF9
        0x6EEE, # G+9985  U+6EEE  uni6EEE,  CJK UNIFIED IDEOGRAPH-6EEE
        0x6F2D, # G+9986  U+6F2D  uni6F2D,  CJK UNIFIED IDEOGRAPH-6F2D
        0x6F40, # G+9987  U+6F40  uni6F40,  CJK UNIFIED IDEOGRAPH-6F40
        0x6F30, # G+9988  U+6F30  uni6F30,  CJK UNIFIED IDEOGRAPH-6F30
        0x6F3C, # G+9989  U+6F3C  uni6F3C,  CJK UNIFIED IDEOGRAPH-6F3C
        0x6F35, # G+9990  U+6F35  uni6F35,  CJK UNIFIED IDEOGRAPH-6F35
        0x6EEB, # G+9991  U+6EEB  uni6EEB,  CJK UNIFIED IDEOGRAPH-6EEB
        0x6F07, # G+9992  U+6F07  uni6F07,  CJK UNIFIED IDEOGRAPH-6F07
        0x6F0E, # G+9993  U+6F0E  uni6F0E,  CJK UNIFIED IDEOGRAPH-6F0E
        0x6F43, # G+9994  U+6F43  uni6F43,  CJK UNIFIED IDEOGRAPH-6F43
        0x6F05, # G+9995  U+6F05  uni6F05,  CJK UNIFIED IDEOGRAPH-6F05
        0x6EFD, # G+9996  U+6EFD  uni6EFD,  CJK UNIFIED IDEOGRAPH-6EFD
        0x6EF6, # G+9997  U+6EF6  uni6EF6,  CJK UNIFIED IDEOGRAPH-6EF6
        0x6F39, # G+9998  U+6F39  uni6F39,  CJK UNIFIED IDEOGRAPH-6F39
        0x6F1C, # G+9999  U+6F1C  uni6F1C,  CJK UNIFIED IDEOGRAPH-6F1C
        0x6EFC, # G+10000  U+6EFC  uni6EFC,  CJK UNIFIED IDEOGRAPH-6EFC
        0x6F3A, # G+10001  U+6F3A  uni6F3A,  CJK UNIFIED IDEOGRAPH-6F3A
        0x6F1F, # G+10002  U+6F1F  uni6F1F,  CJK UNIFIED IDEOGRAPH-6F1F
        0x6F0D, # G+10003  U+6F0D  uni6F0D,  CJK UNIFIED IDEOGRAPH-6F0D
        0x6F1E, # G+10004  U+6F1E  uni6F1E,  CJK UNIFIED IDEOGRAPH-6F1E
        0x6F08, # G+10005  U+6F08  uni6F08,  CJK UNIFIED IDEOGRAPH-6F08
        0x6F21, # G+10006  U+6F21  uni6F21,  CJK UNIFIED IDEOGRAPH-6F21
        0x7187, # G+10007  U+7187  uni7187,  CJK UNIFIED IDEOGRAPH-7187
        0x7190, # G+10008  U+7190  uni7190,  CJK UNIFIED IDEOGRAPH-7190
        0x7189, # G+10009  U+7189  uni7189,  CJK UNIFIED IDEOGRAPH-7189
        0x7180, # G+10010  U+7180  uni7180,  CJK UNIFIED IDEOGRAPH-7180
        0x7185, # G+10011  U+7185  uni7185,  CJK UNIFIED IDEOGRAPH-7185
        0x7182, # G+10012  U+7182  uni7182,  CJK UNIFIED IDEOGRAPH-7182
        0x718F, # G+10013  U+718F  uni718F,  CJK UNIFIED IDEOGRAPH-718F
        0x717B, # G+10014  U+717B  uni717B,  CJK UNIFIED IDEOGRAPH-717B
        0x7186, # G+10015  U+7186  uni7186,  CJK UNIFIED IDEOGRAPH-7186
        0x7181, # G+10016  U+7181  uni7181,  CJK UNIFIED IDEOGRAPH-7181
        0x7197, # G+10017  U+7197  uni7197,  CJK UNIFIED IDEOGRAPH-7197
        0x7244, # G+10018  U+7244  uni7244,  CJK UNIFIED IDEOGRAPH-7244
        0x7253, # G+10019  U+7253  uni7253,  CJK UNIFIED IDEOGRAPH-7253
        0x7297, # G+10020  U+7297  uni7297,  CJK UNIFIED IDEOGRAPH-7297
        0x7295, # G+10021  U+7295  uni7295,  CJK UNIFIED IDEOGRAPH-7295
        0x7293, # G+10022  U+7293  uni7293,  CJK UNIFIED IDEOGRAPH-7293
        0x7343, # G+10023  U+7343  uni7343,  CJK UNIFIED IDEOGRAPH-7343
        0x734D, # G+10024  U+734D  uni734D,  CJK UNIFIED IDEOGRAPH-734D
        0x7351, # G+10025  U+7351  uni7351,  CJK UNIFIED IDEOGRAPH-7351
        0x734C, # G+10026  U+734C  uni734C,  CJK UNIFIED IDEOGRAPH-734C
        0x7462, # G+10027  U+7462  uni7462,  CJK UNIFIED IDEOGRAPH-7462
        0x7473, # G+10028  U+7473  uni7473,  CJK UNIFIED IDEOGRAPH-7473
        0x7471, # G+10029  U+7471  uni7471,  CJK UNIFIED IDEOGRAPH-7471
        0x7475, # G+10030  U+7475  uni7475,  CJK UNIFIED IDEOGRAPH-7475
        0x7472, # G+10031  U+7472  uni7472,  CJK UNIFIED IDEOGRAPH-7472
        0x7467, # G+10032  U+7467  uni7467,  CJK UNIFIED IDEOGRAPH-7467
        0x746E, # G+10033  U+746E  uni746E,  CJK UNIFIED IDEOGRAPH-746E
        0x7500, # G+10034  U+7500  uni7500,  CJK UNIFIED IDEOGRAPH-7500
        0x7502, # G+10035  U+7502  uni7502,  CJK UNIFIED IDEOGRAPH-7502
        0x7503, # G+10036  U+7503  uni7503,  CJK UNIFIED IDEOGRAPH-7503
        0x757D, # G+10037  U+757D  uni757D,  CJK UNIFIED IDEOGRAPH-757D
        0x7590, # G+10038  U+7590  uni7590,  CJK UNIFIED IDEOGRAPH-7590
        0x7616, # G+10039  U+7616  uni7616,  CJK UNIFIED IDEOGRAPH-7616
        0x7608, # G+10040  U+7608  uni7608,  CJK UNIFIED IDEOGRAPH-7608
        0x760C, # G+10041  U+760C  uni760C,  CJK UNIFIED IDEOGRAPH-760C
        0x7615, # G+10042  U+7615  uni7615,  CJK UNIFIED IDEOGRAPH-7615
        0x7611, # G+10043  U+7611  uni7611,  CJK UNIFIED IDEOGRAPH-7611
        0x760A, # G+10044  U+760A  uni760A,  CJK UNIFIED IDEOGRAPH-760A
        0x7614, # G+10045  U+7614  uni7614,  CJK UNIFIED IDEOGRAPH-7614
        0x76B8, # G+10046  U+76B8  uni76B8,  CJK UNIFIED IDEOGRAPH-76B8
        0x7781, # G+10047  U+7781  uni7781,  CJK UNIFIED IDEOGRAPH-7781
        0x777C, # G+10048  U+777C  uni777C,  CJK UNIFIED IDEOGRAPH-777C
        0x7785, # G+10049  U+7785  uni7785,  CJK UNIFIED IDEOGRAPH-7785
        0x7782, # G+10050  U+7782  uni7782,  CJK UNIFIED IDEOGRAPH-7782
        0x776E, # G+10051  U+776E  uni776E,  CJK UNIFIED IDEOGRAPH-776E
        0x7780, # G+10052  U+7780  uni7780,  CJK UNIFIED IDEOGRAPH-7780
        0x776F, # G+10053  U+776F  uni776F,  CJK UNIFIED IDEOGRAPH-776F
        0x777E, # G+10054  U+777E  uni777E,  CJK UNIFIED IDEOGRAPH-777E
        0x7783, # G+10055  U+7783  uni7783,  CJK UNIFIED IDEOGRAPH-7783
        0x78B2, # G+10056  U+78B2  uni78B2,  CJK UNIFIED IDEOGRAPH-78B2
        0x78AA, # G+10057  U+78AA  uni78AA,  CJK UNIFIED IDEOGRAPH-78AA
        0x78B4, # G+10058  U+78B4  uni78B4,  CJK UNIFIED IDEOGRAPH-78B4
        0x78AD, # G+10059  U+78AD  uni78AD,  CJK UNIFIED IDEOGRAPH-78AD
        0x78A8, # G+10060  U+78A8  uni78A8,  CJK UNIFIED IDEOGRAPH-78A8
        0x787E, # G+10061  U+787E  uni787E,  CJK UNIFIED IDEOGRAPH-787E
        0x78AB, # G+10062  U+78AB  uni78AB,  CJK UNIFIED IDEOGRAPH-78AB
        0x789E, # G+10063  U+789E  uni789E,  CJK UNIFIED IDEOGRAPH-789E
        0x78A5, # G+10064  U+78A5  uni78A5,  CJK UNIFIED IDEOGRAPH-78A5
        0x78A0, # G+10065  U+78A0  uni78A0,  CJK UNIFIED IDEOGRAPH-78A0
        0x78AC, # G+10066  U+78AC  uni78AC,  CJK UNIFIED IDEOGRAPH-78AC
        0x78A2, # G+10067  U+78A2  uni78A2,  CJK UNIFIED IDEOGRAPH-78A2
        0x78A4, # G+10068  U+78A4  uni78A4,  CJK UNIFIED IDEOGRAPH-78A4
        0x7998, # G+10069  U+7998  uni7998,  CJK UNIFIED IDEOGRAPH-7998
        0x798A, # G+10070  U+798A  uni798A,  CJK UNIFIED IDEOGRAPH-798A
        0x798B, # G+10071  U+798B  uni798B,  CJK UNIFIED IDEOGRAPH-798B
        0x7996, # G+10072  U+7996  uni7996,  CJK UNIFIED IDEOGRAPH-7996
        0x7995, # G+10073  U+7995  uni7995,  CJK UNIFIED IDEOGRAPH-7995
        0x7994, # G+10074  U+7994  uni7994,  CJK UNIFIED IDEOGRAPH-7994
        0x7993, # G+10075  U+7993  uni7993,  CJK UNIFIED IDEOGRAPH-7993
        0x7997, # G+10076  U+7997  uni7997,  CJK UNIFIED IDEOGRAPH-7997
        0x7988, # G+10077  U+7988  uni7988,  CJK UNIFIED IDEOGRAPH-7988
        0x7992, # G+10078  U+7992  uni7992,  CJK UNIFIED IDEOGRAPH-7992
        0x7990, # G+10079  U+7990  uni7990,  CJK UNIFIED IDEOGRAPH-7990
        0x7A2B, # G+10080  U+7A2B  uni7A2B,  CJK UNIFIED IDEOGRAPH-7A2B
        0x7A4A, # G+10081  U+7A4A  uni7A4A,  CJK UNIFIED IDEOGRAPH-7A4A
        0x7A30, # G+10082  U+7A30  uni7A30,  CJK UNIFIED IDEOGRAPH-7A30
        0x7A2F, # G+10083  U+7A2F  uni7A2F,  CJK UNIFIED IDEOGRAPH-7A2F
        0x7A28, # G+10084  U+7A28  uni7A28,  CJK UNIFIED IDEOGRAPH-7A28
        0x7A26, # G+10085  U+7A26  uni7A26,  CJK UNIFIED IDEOGRAPH-7A26
        0x7AA8, # G+10086  U+7AA8  uni7AA8,  CJK UNIFIED IDEOGRAPH-7AA8
        0x7AAB, # G+10087  U+7AAB  uni7AAB,  CJK UNIFIED IDEOGRAPH-7AAB
        0x7AAC, # G+10088  U+7AAC  uni7AAC,  CJK UNIFIED IDEOGRAPH-7AAC
        0x7AEE, # G+10089  U+7AEE  uni7AEE,  CJK UNIFIED IDEOGRAPH-7AEE
        0x7B88, # G+10090  U+7B88  uni7B88,  CJK UNIFIED IDEOGRAPH-7B88
        0x7B9C, # G+10091  U+7B9C  uni7B9C,  CJK UNIFIED IDEOGRAPH-7B9C
        0x7B8A, # G+10092  U+7B8A  uni7B8A,  CJK UNIFIED IDEOGRAPH-7B8A
        0x7B91, # G+10093  U+7B91  uni7B91,  CJK UNIFIED IDEOGRAPH-7B91
        0x7B90, # G+10094  U+7B90  uni7B90,  CJK UNIFIED IDEOGRAPH-7B90
        0x7B96, # G+10095  U+7B96  uni7B96,  CJK UNIFIED IDEOGRAPH-7B96
        0x7B8D, # G+10096  U+7B8D  uni7B8D,  CJK UNIFIED IDEOGRAPH-7B8D
        0x7B8C, # G+10097  U+7B8C  uni7B8C,  CJK UNIFIED IDEOGRAPH-7B8C
        0x7B9B, # G+10098  U+7B9B  uni7B9B,  CJK UNIFIED IDEOGRAPH-7B9B
        0x7B8E, # G+10099  U+7B8E  uni7B8E,  CJK UNIFIED IDEOGRAPH-7B8E
        0x7B85, # G+10100  U+7B85  uni7B85,  CJK UNIFIED IDEOGRAPH-7B85
        0x7B98, # G+10101  U+7B98  uni7B98,  CJK UNIFIED IDEOGRAPH-7B98
        0x5284, # G+10102  U+5284  uni5284,  CJK UNIFIED IDEOGRAPH-5284
        0x7B99, # G+10103  U+7B99  uni7B99,  CJK UNIFIED IDEOGRAPH-7B99
        0x7BA4, # G+10104  U+7BA4  uni7BA4,  CJK UNIFIED IDEOGRAPH-7BA4
        0x7B82, # G+10105  U+7B82  uni7B82,  CJK UNIFIED IDEOGRAPH-7B82
        0x7CBB, # G+10106  U+7CBB  uni7CBB,  CJK UNIFIED IDEOGRAPH-7CBB
        0x7CBF, # G+10107  U+7CBF  uni7CBF,  CJK UNIFIED IDEOGRAPH-7CBF
        0x7CBC, # G+10108  U+7CBC  uni7CBC,  CJK UNIFIED IDEOGRAPH-7CBC
        0x7CBA, # G+10109  U+7CBA  uni7CBA,  CJK UNIFIED IDEOGRAPH-7CBA
        0x7DA7, # G+10110  U+7DA7  uni7DA7,  CJK UNIFIED IDEOGRAPH-7DA7
        0x7DB7, # G+10111  U+7DB7  uni7DB7,  CJK UNIFIED IDEOGRAPH-7DB7
        0x7DC2, # G+10112  U+7DC2  uni7DC2,  CJK UNIFIED IDEOGRAPH-7DC2
        0x7DA3, # G+10113  U+7DA3  uni7DA3,  CJK UNIFIED IDEOGRAPH-7DA3
        0x7DAA, # G+10114  U+7DAA  uni7DAA,  CJK UNIFIED IDEOGRAPH-7DAA
        0x7DC1, # G+10115  U+7DC1  uni7DC1,  CJK UNIFIED IDEOGRAPH-7DC1
        0x7DC0, # G+10116  U+7DC0  uni7DC0,  CJK UNIFIED IDEOGRAPH-7DC0
        0x7DC5, # G+10117  U+7DC5  uni7DC5,  CJK UNIFIED IDEOGRAPH-7DC5
        0x7D9D, # G+10118  U+7D9D  uni7D9D,  CJK UNIFIED IDEOGRAPH-7D9D
        0x7DCE, # G+10119  U+7DCE  uni7DCE,  CJK UNIFIED IDEOGRAPH-7DCE
        0x7DC4, # G+10120  U+7DC4  uni7DC4,  CJK UNIFIED IDEOGRAPH-7DC4
        0x7DC6, # G+10121  U+7DC6  uni7DC6,  CJK UNIFIED IDEOGRAPH-7DC6
        0x7DCB, # G+10122  U+7DCB  uni7DCB,  CJK UNIFIED IDEOGRAPH-7DCB
        0x7DCC, # G+10123  U+7DCC  uni7DCC,  CJK UNIFIED IDEOGRAPH-7DCC
        0x7DAF, # G+10124  U+7DAF  uni7DAF,  CJK UNIFIED IDEOGRAPH-7DAF
        0x7DB9, # G+10125  U+7DB9  uni7DB9,  CJK UNIFIED IDEOGRAPH-7DB9
        0x7D96, # G+10126  U+7D96  uni7D96,  CJK UNIFIED IDEOGRAPH-7D96
        0x7DBC, # G+10127  U+7DBC  uni7DBC,  CJK UNIFIED IDEOGRAPH-7DBC
        0x7D9F, # G+10128  U+7D9F  uni7D9F,  CJK UNIFIED IDEOGRAPH-7D9F
        0x7DA6, # G+10129  U+7DA6  uni7DA6,  CJK UNIFIED IDEOGRAPH-7DA6
        0x7DAE, # G+10130  U+7DAE  uni7DAE,  CJK UNIFIED IDEOGRAPH-7DAE
        0x7DA9, # G+10131  U+7DA9  uni7DA9,  CJK UNIFIED IDEOGRAPH-7DA9
        0x7DA1, # G+10132  U+7DA1  uni7DA1,  CJK UNIFIED IDEOGRAPH-7DA1
        0x7DC9, # G+10133  U+7DC9  uni7DC9,  CJK UNIFIED IDEOGRAPH-7DC9
        0x7F73, # G+10134  U+7F73  uni7F73,  CJK UNIFIED IDEOGRAPH-7F73
        0x7FE2, # G+10135  U+7FE2  uni7FE2,  CJK UNIFIED IDEOGRAPH-7FE2
        0x7FE3, # G+10136  U+7FE3  uni7FE3,  CJK UNIFIED IDEOGRAPH-7FE3
        0x7FE5, # G+10137  U+7FE5  uni7FE5,  CJK UNIFIED IDEOGRAPH-7FE5
        0x7FDE, # G+10138  U+7FDE  uni7FDE,  CJK UNIFIED IDEOGRAPH-7FDE
        0x8024, # G+10139  U+8024  uni8024,  CJK UNIFIED IDEOGRAPH-8024
        0x805D, # G+10140  U+805D  uni805D,  CJK UNIFIED IDEOGRAPH-805D
        0x805C, # G+10141  U+805C  uni805C,  CJK UNIFIED IDEOGRAPH-805C
        0x8189, # G+10142  U+8189  uni8189,  CJK UNIFIED IDEOGRAPH-8189
        0x8186, # G+10143  U+8186  uni8186,  CJK UNIFIED IDEOGRAPH-8186
        0x8183, # G+10144  U+8183  uni8183,  CJK UNIFIED IDEOGRAPH-8183
        0x8187, # G+10145  U+8187  uni8187,  CJK UNIFIED IDEOGRAPH-8187
        0x818D, # G+10146  U+818D  uni818D,  CJK UNIFIED IDEOGRAPH-818D
        0x818C, # G+10147  U+818C  uni818C,  CJK UNIFIED IDEOGRAPH-818C
        0x818B, # G+10148  U+818B  uni818B,  CJK UNIFIED IDEOGRAPH-818B
        0x8215, # G+10149  U+8215  uni8215,  CJK UNIFIED IDEOGRAPH-8215
        0x8497, # G+10150  U+8497  uni8497,  CJK UNIFIED IDEOGRAPH-8497
        0x84A4, # G+10151  U+84A4  uni84A4,  CJK UNIFIED IDEOGRAPH-84A4
        0x84A1, # G+10152  U+84A1  uni84A1,  CJK UNIFIED IDEOGRAPH-84A1
        0x849F, # G+10153  U+849F  uni849F,  CJK UNIFIED IDEOGRAPH-849F
        0x84BA, # G+10154  U+84BA  uni84BA,  CJK UNIFIED IDEOGRAPH-84BA
        0x84CE, # G+10155  U+84CE  uni84CE,  CJK UNIFIED IDEOGRAPH-84CE
        0x84C2, # G+10156  U+84C2  uni84C2,  CJK UNIFIED IDEOGRAPH-84C2
        0x84AC, # G+10157  U+84AC  uni84AC,  CJK UNIFIED IDEOGRAPH-84AC
        0x84AE, # G+10158  U+84AE  uni84AE,  CJK UNIFIED IDEOGRAPH-84AE
        0x84AB, # G+10159  U+84AB  uni84AB,  CJK UNIFIED IDEOGRAPH-84AB
        0x84B9, # G+10160  U+84B9  uni84B9,  CJK UNIFIED IDEOGRAPH-84B9
        0x84B4, # G+10161  U+84B4  uni84B4,  CJK UNIFIED IDEOGRAPH-84B4
        0x84C1, # G+10162  U+84C1  uni84C1,  CJK UNIFIED IDEOGRAPH-84C1
        0x84CD, # G+10163  U+84CD  uni84CD,  CJK UNIFIED IDEOGRAPH-84CD
        0x84AA, # G+10164  U+84AA  uni84AA,  CJK UNIFIED IDEOGRAPH-84AA
        0x849A, # G+10165  U+849A  uni849A,  CJK UNIFIED IDEOGRAPH-849A
        0x84B1, # G+10166  U+84B1  uni84B1,  CJK UNIFIED IDEOGRAPH-84B1
        0x84D0, # G+10167  U+84D0  uni84D0,  CJK UNIFIED IDEOGRAPH-84D0
        0x849D, # G+10168  U+849D  uni849D,  CJK UNIFIED IDEOGRAPH-849D
        0x84A7, # G+10169  U+84A7  uni84A7,  CJK UNIFIED IDEOGRAPH-84A7
        0x84BB, # G+10170  U+84BB  uni84BB,  CJK UNIFIED IDEOGRAPH-84BB
        0x84A2, # G+10171  U+84A2  uni84A2,  CJK UNIFIED IDEOGRAPH-84A2
        0x8494, # G+10172  U+8494  uni8494,  CJK UNIFIED IDEOGRAPH-8494
        0x84C7, # G+10173  U+84C7  uni84C7,  CJK UNIFIED IDEOGRAPH-84C7
        0x84CC, # G+10174  U+84CC  uni84CC,  CJK UNIFIED IDEOGRAPH-84CC
        0x849B, # G+10175  U+849B  uni849B,  CJK UNIFIED IDEOGRAPH-849B
        0x84A9, # G+10176  U+84A9  uni84A9,  CJK UNIFIED IDEOGRAPH-84A9
        0x84AF, # G+10177  U+84AF  uni84AF,  CJK UNIFIED IDEOGRAPH-84AF
        0x84A8, # G+10178  U+84A8  uni84A8,  CJK UNIFIED IDEOGRAPH-84A8
        0x84D6, # G+10179  U+84D6  uni84D6,  CJK UNIFIED IDEOGRAPH-84D6
        0x8498, # G+10180  U+8498  uni8498,  CJK UNIFIED IDEOGRAPH-8498
        0x84B6, # G+10181  U+84B6  uni84B6,  CJK UNIFIED IDEOGRAPH-84B6
        0x84CF, # G+10182  U+84CF  uni84CF,  CJK UNIFIED IDEOGRAPH-84CF
        0x84A0, # G+10183  U+84A0  uni84A0,  CJK UNIFIED IDEOGRAPH-84A0
        0x84D7, # G+10184  U+84D7  uni84D7,  CJK UNIFIED IDEOGRAPH-84D7
        0x84D4, # G+10185  U+84D4  uni84D4,  CJK UNIFIED IDEOGRAPH-84D4
        0x84D2, # G+10186  U+84D2  uni84D2,  CJK UNIFIED IDEOGRAPH-84D2
        0x84DB, # G+10187  U+84DB  uni84DB,  CJK UNIFIED IDEOGRAPH-84DB
        0x84B0, # G+10188  U+84B0  uni84B0,  CJK UNIFIED IDEOGRAPH-84B0
        0x8491, # G+10189  U+8491  uni8491,  CJK UNIFIED IDEOGRAPH-8491
        0x8661, # G+10190  U+8661  uni8661,  CJK UNIFIED IDEOGRAPH-8661
        0x8733, # G+10191  U+8733  uni8733,  CJK UNIFIED IDEOGRAPH-8733
        0x8723, # G+10192  U+8723  uni8723,  CJK UNIFIED IDEOGRAPH-8723
        0x8728, # G+10193  U+8728  uni8728,  CJK UNIFIED IDEOGRAPH-8728
        0x876B, # G+10194  U+876B  uni876B,  CJK UNIFIED IDEOGRAPH-876B
        0x8740, # G+10195  U+8740  uni8740,  CJK UNIFIED IDEOGRAPH-8740
        0x872E, # G+10196  U+872E  uni872E,  CJK UNIFIED IDEOGRAPH-872E
        0x871E, # G+10197  U+871E  uni871E,  CJK UNIFIED IDEOGRAPH-871E
        0x8721, # G+10198  U+8721  uni8721,  CJK UNIFIED IDEOGRAPH-8721
        0x8719, # G+10199  U+8719  uni8719,  CJK UNIFIED IDEOGRAPH-8719
        0x871B, # G+10200  U+871B  uni871B,  CJK UNIFIED IDEOGRAPH-871B
        0x8743, # G+10201  U+8743  uni8743,  CJK UNIFIED IDEOGRAPH-8743
        0x872C, # G+10202  U+872C  uni872C,  CJK UNIFIED IDEOGRAPH-872C
        0x8741, # G+10203  U+8741  uni8741,  CJK UNIFIED IDEOGRAPH-8741
        0x873E, # G+10204  U+873E  uni873E,  CJK UNIFIED IDEOGRAPH-873E
        0x8746, # G+10205  U+8746  uni8746,  CJK UNIFIED IDEOGRAPH-8746
        0x8720, # G+10206  U+8720  uni8720,  CJK UNIFIED IDEOGRAPH-8720
        0x8732, # G+10207  U+8732  uni8732,  CJK UNIFIED IDEOGRAPH-8732
        0x872A, # G+10208  U+872A  uni872A,  CJK UNIFIED IDEOGRAPH-872A
        0x872D, # G+10209  U+872D  uni872D,  CJK UNIFIED IDEOGRAPH-872D
        0x873C, # G+10210  U+873C  uni873C,  CJK UNIFIED IDEOGRAPH-873C
        0x8712, # G+10211  U+8712  uni8712,  CJK UNIFIED IDEOGRAPH-8712
        0x873A, # G+10212  U+873A  uni873A,  CJK UNIFIED IDEOGRAPH-873A
        0x8731, # G+10213  U+8731  uni8731,  CJK UNIFIED IDEOGRAPH-8731
        0x8735, # G+10214  U+8735  uni8735,  CJK UNIFIED IDEOGRAPH-8735
        0x8742, # G+10215  U+8742  uni8742,  CJK UNIFIED IDEOGRAPH-8742
        0x8726, # G+10216  U+8726  uni8726,  CJK UNIFIED IDEOGRAPH-8726
        0x8727, # G+10217  U+8727  uni8727,  CJK UNIFIED IDEOGRAPH-8727
        0x8738, # G+10218  U+8738  uni8738,  CJK UNIFIED IDEOGRAPH-8738
        0x8724, # G+10219  U+8724  uni8724,  CJK UNIFIED IDEOGRAPH-8724
        0x871A, # G+10220  U+871A  uni871A,  CJK UNIFIED IDEOGRAPH-871A
        0x8730, # G+10221  U+8730  uni8730,  CJK UNIFIED IDEOGRAPH-8730
        0x8711, # G+10222  U+8711  uni8711,  CJK UNIFIED IDEOGRAPH-8711
        0x88F7, # G+10223  U+88F7  uni88F7,  CJK UNIFIED IDEOGRAPH-88F7
        0x88E7, # G+10224  U+88E7  uni88E7,  CJK UNIFIED IDEOGRAPH-88E7
        0x88F1, # G+10225  U+88F1  uni88F1,  CJK UNIFIED IDEOGRAPH-88F1
        0x88F2, # G+10226  U+88F2  uni88F2,  CJK UNIFIED IDEOGRAPH-88F2
        0x88FA, # G+10227  U+88FA  uni88FA,  CJK UNIFIED IDEOGRAPH-88FA
        0x88FE, # G+10228  U+88FE  uni88FE,  CJK UNIFIED IDEOGRAPH-88FE
        0x88EE, # G+10229  U+88EE  uni88EE,  CJK UNIFIED IDEOGRAPH-88EE
        0x88FC, # G+10230  U+88FC  uni88FC,  CJK UNIFIED IDEOGRAPH-88FC
        0x88F6, # G+10231  U+88F6  uni88F6,  CJK UNIFIED IDEOGRAPH-88F6
        0x88FB, # G+10232  U+88FB  uni88FB,  CJK UNIFIED IDEOGRAPH-88FB
        0x88F0, # G+10233  U+88F0  uni88F0,  CJK UNIFIED IDEOGRAPH-88F0
        0x88EC, # G+10234  U+88EC  uni88EC,  CJK UNIFIED IDEOGRAPH-88EC
        0x88EB, # G+10235  U+88EB  uni88EB,  CJK UNIFIED IDEOGRAPH-88EB
        0x899D, # G+10236  U+899D  uni899D,  CJK UNIFIED IDEOGRAPH-899D
        0x89A1, # G+10237  U+89A1  uni89A1,  CJK UNIFIED IDEOGRAPH-89A1
        0x899F, # G+10238  U+899F  uni899F,  CJK UNIFIED IDEOGRAPH-899F
        0x899E, # G+10239  U+899E  uni899E,  CJK UNIFIED IDEOGRAPH-899E
        0x89E9, # G+10240  U+89E9  uni89E9,  CJK UNIFIED IDEOGRAPH-89E9
        0x89EB, # G+10241  U+89EB  uni89EB,  CJK UNIFIED IDEOGRAPH-89EB
        0x89E8, # G+10242  U+89E8  uni89E8,  CJK UNIFIED IDEOGRAPH-89E8
        0x8AAB, # G+10243  U+8AAB  uni8AAB,  CJK UNIFIED IDEOGRAPH-8AAB
        0x8A99, # G+10244  U+8A99  uni8A99,  CJK UNIFIED IDEOGRAPH-8A99
        0x8A8B, # G+10245  U+8A8B  uni8A8B,  CJK UNIFIED IDEOGRAPH-8A8B
        0x8A92, # G+10246  U+8A92  uni8A92,  CJK UNIFIED IDEOGRAPH-8A92
        0x8A8F, # G+10247  U+8A8F  uni8A8F,  CJK UNIFIED IDEOGRAPH-8A8F
        0x8A96, # G+10248  U+8A96  uni8A96,  CJK UNIFIED IDEOGRAPH-8A96
        0x8C3D, # G+10249  U+8C3D  uni8C3D,  CJK UNIFIED IDEOGRAPH-8C3D
        0x8C68, # G+10250  U+8C68  uni8C68,  CJK UNIFIED IDEOGRAPH-8C68
        0x8C69, # G+10251  U+8C69  uni8C69,  CJK UNIFIED IDEOGRAPH-8C69
        0x8CD5, # G+10252  U+8CD5  uni8CD5,  CJK UNIFIED IDEOGRAPH-8CD5
        0x8CCF, # G+10253  U+8CCF  uni8CCF,  CJK UNIFIED IDEOGRAPH-8CCF
        0x8CD7, # G+10254  U+8CD7  uni8CD7,  CJK UNIFIED IDEOGRAPH-8CD7
        0x8D96, # G+10255  U+8D96  uni8D96,  CJK UNIFIED IDEOGRAPH-8D96
        0x8E09, # G+10256  U+8E09  uni8E09,  CJK UNIFIED IDEOGRAPH-8E09
        0x8E02, # G+10257  U+8E02  uni8E02,  CJK UNIFIED IDEOGRAPH-8E02
        0x8DFF, # G+10258  U+8DFF  uni8DFF,  CJK UNIFIED IDEOGRAPH-8DFF
        0x8E0D, # G+10259  U+8E0D  uni8E0D,  CJK UNIFIED IDEOGRAPH-8E0D
        0x8DFD, # G+10260  U+8DFD  uni8DFD,  CJK UNIFIED IDEOGRAPH-8DFD
        0x8E0A, # G+10261  U+8E0A  uni8E0A,  CJK UNIFIED IDEOGRAPH-8E0A
        0x8E03, # G+10262  U+8E03  uni8E03,  CJK UNIFIED IDEOGRAPH-8E03
        0x8E07, # G+10263  U+8E07  uni8E07,  CJK UNIFIED IDEOGRAPH-8E07
        0x8E06, # G+10264  U+8E06  uni8E06,  CJK UNIFIED IDEOGRAPH-8E06
        0x8E05, # G+10265  U+8E05  uni8E05,  CJK UNIFIED IDEOGRAPH-8E05
        0x8DFE, # G+10266  U+8DFE  uni8DFE,  CJK UNIFIED IDEOGRAPH-8DFE
        0x8E00, # G+10267  U+8E00  uni8E00,  CJK UNIFIED IDEOGRAPH-8E00
        0x8E04, # G+10268  U+8E04  uni8E04,  CJK UNIFIED IDEOGRAPH-8E04
        0x8F10, # G+10269  U+8F10  uni8F10,  CJK UNIFIED IDEOGRAPH-8F10
        0x8F11, # G+10270  U+8F11  uni8F11,  CJK UNIFIED IDEOGRAPH-8F11
        0x8F0E, # G+10271  U+8F0E  uni8F0E,  CJK UNIFIED IDEOGRAPH-8F0E
        0x8F0D, # G+10272  U+8F0D  uni8F0D,  CJK UNIFIED IDEOGRAPH-8F0D
        0x9123, # G+10273  U+9123  uni9123,  CJK UNIFIED IDEOGRAPH-9123
        0x911C, # G+10274  U+911C  uni911C,  CJK UNIFIED IDEOGRAPH-911C
        0x9120, # G+10275  U+9120  uni9120,  CJK UNIFIED IDEOGRAPH-9120
        0x9122, # G+10276  U+9122  uni9122,  CJK UNIFIED IDEOGRAPH-9122
        0x911F, # G+10277  U+911F  uni911F,  CJK UNIFIED IDEOGRAPH-911F
        0x911D, # G+10278  U+911D  uni911D,  CJK UNIFIED IDEOGRAPH-911D
        0x911A, # G+10279  U+911A  uni911A,  CJK UNIFIED IDEOGRAPH-911A
        0x9124, # G+10280  U+9124  uni9124,  CJK UNIFIED IDEOGRAPH-9124
        0x9121, # G+10281  U+9121  uni9121,  CJK UNIFIED IDEOGRAPH-9121
        0x911B, # G+10282  U+911B  uni911B,  CJK UNIFIED IDEOGRAPH-911B
        0x917A, # G+10283  U+917A  uni917A,  CJK UNIFIED IDEOGRAPH-917A
        0x9172, # G+10284  U+9172  uni9172,  CJK UNIFIED IDEOGRAPH-9172
        0x9179, # G+10285  U+9179  uni9179,  CJK UNIFIED IDEOGRAPH-9179
        0x9173, # G+10286  U+9173  uni9173,  CJK UNIFIED IDEOGRAPH-9173
        0x92A5, # G+10287  U+92A5  uni92A5,  CJK UNIFIED IDEOGRAPH-92A5
        0x92A4, # G+10288  U+92A4  uni92A4,  CJK UNIFIED IDEOGRAPH-92A4
        0x9276, # G+10289  U+9276  uni9276,  CJK UNIFIED IDEOGRAPH-9276
        0x929B, # G+10290  U+929B  uni929B,  CJK UNIFIED IDEOGRAPH-929B
        0x927A, # G+10291  U+927A  uni927A,  CJK UNIFIED IDEOGRAPH-927A
        0x92A0, # G+10292  U+92A0  uni92A0,  CJK UNIFIED IDEOGRAPH-92A0
        0x9294, # G+10293  U+9294  uni9294,  CJK UNIFIED IDEOGRAPH-9294
        0x92AA, # G+10294  U+92AA  uni92AA,  CJK UNIFIED IDEOGRAPH-92AA
        0x928D, # G+10295  U+928D  uni928D,  CJK UNIFIED IDEOGRAPH-928D
        0x92A6, # G+10296  U+92A6  uni92A6,  CJK UNIFIED IDEOGRAPH-92A6
        0x929A, # G+10297  U+929A  uni929A,  CJK UNIFIED IDEOGRAPH-929A
        0x92AB, # G+10298  U+92AB  uni92AB,  CJK UNIFIED IDEOGRAPH-92AB
        0x9279, # G+10299  U+9279  uni9279,  CJK UNIFIED IDEOGRAPH-9279
        0x9297, # G+10300  U+9297  uni9297,  CJK UNIFIED IDEOGRAPH-9297
        0x927F, # G+10301  U+927F  uni927F,  CJK UNIFIED IDEOGRAPH-927F
        0x92A3, # G+10302  U+92A3  uni92A3,  CJK UNIFIED IDEOGRAPH-92A3
        0x92EE, # G+10303  U+92EE  uni92EE,  CJK UNIFIED IDEOGRAPH-92EE
        0x928E, # G+10304  U+928E  uni928E,  CJK UNIFIED IDEOGRAPH-928E
        0x9282, # G+10305  U+9282  uni9282,  CJK UNIFIED IDEOGRAPH-9282
        0x9295, # G+10306  U+9295  uni9295,  CJK UNIFIED IDEOGRAPH-9295
        0x92A2, # G+10307  U+92A2  uni92A2,  CJK UNIFIED IDEOGRAPH-92A2
        0x927D, # G+10308  U+927D  uni927D,  CJK UNIFIED IDEOGRAPH-927D
        0x9288, # G+10309  U+9288  uni9288,  CJK UNIFIED IDEOGRAPH-9288
        0x92A1, # G+10310  U+92A1  uni92A1,  CJK UNIFIED IDEOGRAPH-92A1
        0x928A, # G+10311  U+928A  uni928A,  CJK UNIFIED IDEOGRAPH-928A
        0x9286, # G+10312  U+9286  uni9286,  CJK UNIFIED IDEOGRAPH-9286
        0x928C, # G+10313  U+928C  uni928C,  CJK UNIFIED IDEOGRAPH-928C
        0x9299, # G+10314  U+9299  uni9299,  CJK UNIFIED IDEOGRAPH-9299
        0x92A7, # G+10315  U+92A7  uni92A7,  CJK UNIFIED IDEOGRAPH-92A7
        0x927E, # G+10316  U+927E  uni927E,  CJK UNIFIED IDEOGRAPH-927E
        0x9287, # G+10317  U+9287  uni9287,  CJK UNIFIED IDEOGRAPH-9287
        0x92A9, # G+10318  U+92A9  uni92A9,  CJK UNIFIED IDEOGRAPH-92A9
        0x929D, # G+10319  U+929D  uni929D,  CJK UNIFIED IDEOGRAPH-929D
        0x928B, # G+10320  U+928B  uni928B,  CJK UNIFIED IDEOGRAPH-928B
        0x922D, # G+10321  U+922D  uni922D,  CJK UNIFIED IDEOGRAPH-922D
        0x969E, # G+10322  U+969E  uni969E,  CJK UNIFIED IDEOGRAPH-969E
        0x96A1, # G+10323  U+96A1  uni96A1,  CJK UNIFIED IDEOGRAPH-96A1
        0x96FF, # G+10324  U+96FF  uni96FF,  CJK UNIFIED IDEOGRAPH-96FF
        0x9758, # G+10325  U+9758  uni9758,  CJK UNIFIED IDEOGRAPH-9758
        0x977D, # G+10326  U+977D  uni977D,  CJK UNIFIED IDEOGRAPH-977D
        0x977A, # G+10327  U+977A  uni977A,  CJK UNIFIED IDEOGRAPH-977A
        0x977E, # G+10328  U+977E  uni977E,  CJK UNIFIED IDEOGRAPH-977E
        0x9783, # G+10329  U+9783  uni9783,  CJK UNIFIED IDEOGRAPH-9783
        0x9780, # G+10330  U+9780  uni9780,  CJK UNIFIED IDEOGRAPH-9780
        0x9782, # G+10331  U+9782  uni9782,  CJK UNIFIED IDEOGRAPH-9782
        0x977B, # G+10332  U+977B  uni977B,  CJK UNIFIED IDEOGRAPH-977B
        0x9784, # G+10333  U+9784  uni9784,  CJK UNIFIED IDEOGRAPH-9784
        0x9781, # G+10334  U+9781  uni9781,  CJK UNIFIED IDEOGRAPH-9781
        0x977F, # G+10335  U+977F  uni977F,  CJK UNIFIED IDEOGRAPH-977F
        0x97CE, # G+10336  U+97CE  uni97CE,  CJK UNIFIED IDEOGRAPH-97CE
        0x97CD, # G+10337  U+97CD  uni97CD,  CJK UNIFIED IDEOGRAPH-97CD
        0x9816, # G+10338  U+9816  uni9816,  CJK UNIFIED IDEOGRAPH-9816
        0x98AD, # G+10339  U+98AD  uni98AD,  CJK UNIFIED IDEOGRAPH-98AD
        0x98AE, # G+10340  U+98AE  uni98AE,  CJK UNIFIED IDEOGRAPH-98AE
        0x9902, # G+10341  U+9902  uni9902,  CJK UNIFIED IDEOGRAPH-9902
        0x9900, # G+10342  U+9900  uni9900,  CJK UNIFIED IDEOGRAPH-9900
        0x9907, # G+10343  U+9907  uni9907,  CJK UNIFIED IDEOGRAPH-9907
        0x999D, # G+10344  U+999D  uni999D,  CJK UNIFIED IDEOGRAPH-999D
        0x999C, # G+10345  U+999C  uni999C,  CJK UNIFIED IDEOGRAPH-999C
        0x99C3, # G+10346  U+99C3  uni99C3,  CJK UNIFIED IDEOGRAPH-99C3
        0x99B9, # G+10347  U+99B9  uni99B9,  CJK UNIFIED IDEOGRAPH-99B9
        0x99BB, # G+10348  U+99BB  uni99BB,  CJK UNIFIED IDEOGRAPH-99BB
        0x99BA, # G+10349  U+99BA  uni99BA,  CJK UNIFIED IDEOGRAPH-99BA
        0x99C2, # G+10350  U+99C2  uni99C2,  CJK UNIFIED IDEOGRAPH-99C2
        0x99BD, # G+10351  U+99BD  uni99BD,  CJK UNIFIED IDEOGRAPH-99BD
        0x99C7, # G+10352  U+99C7  uni99C7,  CJK UNIFIED IDEOGRAPH-99C7
        0x9AB1, # G+10353  U+9AB1  uni9AB1,  CJK UNIFIED IDEOGRAPH-9AB1
        0x9AE3, # G+10354  U+9AE3  uni9AE3,  CJK UNIFIED IDEOGRAPH-9AE3
        0x9AE7, # G+10355  U+9AE7  uni9AE7,  CJK UNIFIED IDEOGRAPH-9AE7
        0x9B3E, # G+10356  U+9B3E  uni9B3E,  CJK UNIFIED IDEOGRAPH-9B3E
        0x9B3F, # G+10357  U+9B3F  uni9B3F,  CJK UNIFIED IDEOGRAPH-9B3F
        0x9B60, # G+10358  U+9B60  uni9B60,  CJK UNIFIED IDEOGRAPH-9B60
        0x9B61, # G+10359  U+9B61  uni9B61,  CJK UNIFIED IDEOGRAPH-9B61
        0x9B5F, # G+10360  U+9B5F  uni9B5F,  CJK UNIFIED IDEOGRAPH-9B5F
        0x9CF1, # G+10361  U+9CF1  uni9CF1,  CJK UNIFIED IDEOGRAPH-9CF1
        0x9CF2, # G+10362  U+9CF2  uni9CF2,  CJK UNIFIED IDEOGRAPH-9CF2
        0x9CF5, # G+10363  U+9CF5  uni9CF5,  CJK UNIFIED IDEOGRAPH-9CF5
        0x9EA7, # G+10364  U+9EA7  uni9EA7,  CJK UNIFIED IDEOGRAPH-9EA7
        0x50FF, # G+10365  U+50FF  uni50FF,  CJK UNIFIED IDEOGRAPH-50FF
        0x5103, # G+10366  U+5103  uni5103,  CJK UNIFIED IDEOGRAPH-5103
        0x5130, # G+10367  U+5130  uni5130,  CJK UNIFIED IDEOGRAPH-5130
        0x50F8, # G+10368  U+50F8  uni50F8,  CJK UNIFIED IDEOGRAPH-50F8
        0x5106, # G+10369  U+5106  uni5106,  CJK UNIFIED IDEOGRAPH-5106
        0x5107, # G+10370  U+5107  uni5107,  CJK UNIFIED IDEOGRAPH-5107
        0x50F6, # G+10371  U+50F6  uni50F6,  CJK UNIFIED IDEOGRAPH-50F6
        0x50FE, # G+10372  U+50FE  uni50FE,  CJK UNIFIED IDEOGRAPH-50FE
        0x510B, # G+10373  U+510B  uni510B,  CJK UNIFIED IDEOGRAPH-510B
        0x510C, # G+10374  U+510C  uni510C,  CJK UNIFIED IDEOGRAPH-510C
        0x50FD, # G+10375  U+50FD  uni50FD,  CJK UNIFIED IDEOGRAPH-50FD
        0x510A, # G+10376  U+510A  uni510A,  CJK UNIFIED IDEOGRAPH-510A
        0x528B, # G+10377  U+528B  uni528B,  CJK UNIFIED IDEOGRAPH-528B
        0x528C, # G+10378  U+528C  uni528C,  CJK UNIFIED IDEOGRAPH-528C
        0x52F1, # G+10379  U+52F1  uni52F1,  CJK UNIFIED IDEOGRAPH-52F1
        0x52EF, # G+10380  U+52EF  uni52EF,  CJK UNIFIED IDEOGRAPH-52EF
        0x5648, # G+10381  U+5648  uni5648,  CJK UNIFIED IDEOGRAPH-5648
        0x5642, # G+10382  U+5642  uni5642,  CJK UNIFIED IDEOGRAPH-5642
        0x564C, # G+10383  U+564C  uni564C,  CJK UNIFIED IDEOGRAPH-564C
        0x5635, # G+10384  U+5635  uni5635,  CJK UNIFIED IDEOGRAPH-5635
        0x5641, # G+10385  U+5641  uni5641,  CJK UNIFIED IDEOGRAPH-5641
        0x564A, # G+10386  U+564A  uni564A,  CJK UNIFIED IDEOGRAPH-564A
        0x5649, # G+10387  U+5649  uni5649,  CJK UNIFIED IDEOGRAPH-5649
        0x5646, # G+10388  U+5646  uni5646,  CJK UNIFIED IDEOGRAPH-5646
        0x5658, # G+10389  U+5658  uni5658,  CJK UNIFIED IDEOGRAPH-5658
        0x565A, # G+10390  U+565A  uni565A,  CJK UNIFIED IDEOGRAPH-565A
        0x5640, # G+10391  U+5640  uni5640,  CJK UNIFIED IDEOGRAPH-5640
        0x5633, # G+10392  U+5633  uni5633,  CJK UNIFIED IDEOGRAPH-5633
        0x563D, # G+10393  U+563D  uni563D,  CJK UNIFIED IDEOGRAPH-563D
        0x562C, # G+10394  U+562C  uni562C,  CJK UNIFIED IDEOGRAPH-562C
        0x563E, # G+10395  U+563E  uni563E,  CJK UNIFIED IDEOGRAPH-563E
        0x5638, # G+10396  U+5638  uni5638,  CJK UNIFIED IDEOGRAPH-5638
        0x562A, # G+10397  U+562A  uni562A,  CJK UNIFIED IDEOGRAPH-562A
        0x563A, # G+10398  U+563A  uni563A,  CJK UNIFIED IDEOGRAPH-563A
        0x571A, # G+10399  U+571A  uni571A,  CJK UNIFIED IDEOGRAPH-571A
        0x58AB, # G+10400  U+58AB  uni58AB,  CJK UNIFIED IDEOGRAPH-58AB
        0x589D, # G+10401  U+589D  uni589D,  CJK UNIFIED IDEOGRAPH-589D
        0x58B1, # G+10402  U+58B1  uni58B1,  CJK UNIFIED IDEOGRAPH-58B1
        0x58A0, # G+10403  U+58A0  uni58A0,  CJK UNIFIED IDEOGRAPH-58A0
        0x58A3, # G+10404  U+58A3  uni58A3,  CJK UNIFIED IDEOGRAPH-58A3
        0x58AF, # G+10405  U+58AF  uni58AF,  CJK UNIFIED IDEOGRAPH-58AF
        0x58AC, # G+10406  U+58AC  uni58AC,  CJK UNIFIED IDEOGRAPH-58AC
        0x58A5, # G+10407  U+58A5  uni58A5,  CJK UNIFIED IDEOGRAPH-58A5
        0x58A1, # G+10408  U+58A1  uni58A1,  CJK UNIFIED IDEOGRAPH-58A1
        0x58FF, # G+10409  U+58FF  uni58FF,  CJK UNIFIED IDEOGRAPH-58FF
        0x5AFF, # G+10410  U+5AFF  uni5AFF,  CJK UNIFIED IDEOGRAPH-5AFF
        0x5AF4, # G+10411  U+5AF4  uni5AF4,  CJK UNIFIED IDEOGRAPH-5AF4
        0x5AFD, # G+10412  U+5AFD  uni5AFD,  CJK UNIFIED IDEOGRAPH-5AFD
        0x5AF7, # G+10413  U+5AF7  uni5AF7,  CJK UNIFIED IDEOGRAPH-5AF7
        0x5AF6, # G+10414  U+5AF6  uni5AF6,  CJK UNIFIED IDEOGRAPH-5AF6
        0x5B03, # G+10415  U+5B03  uni5B03,  CJK UNIFIED IDEOGRAPH-5B03
        0x5AF8, # G+10416  U+5AF8  uni5AF8,  CJK UNIFIED IDEOGRAPH-5AF8
        0x5B02, # G+10417  U+5B02  uni5B02,  CJK UNIFIED IDEOGRAPH-5B02
        0x5AF9, # G+10418  U+5AF9  uni5AF9,  CJK UNIFIED IDEOGRAPH-5AF9
        0x5B01, # G+10419  U+5B01  uni5B01,  CJK UNIFIED IDEOGRAPH-5B01
        0x5B07, # G+10420  U+5B07  uni5B07,  CJK UNIFIED IDEOGRAPH-5B07
        0x5B05, # G+10421  U+5B05  uni5B05,  CJK UNIFIED IDEOGRAPH-5B05
        0x5B0F, # G+10422  U+5B0F  uni5B0F,  CJK UNIFIED IDEOGRAPH-5B0F
        0x5C67, # G+10423  U+5C67  uni5C67,  CJK UNIFIED IDEOGRAPH-5C67
        0x5D99, # G+10424  U+5D99  uni5D99,  CJK UNIFIED IDEOGRAPH-5D99
        0x5D97, # G+10425  U+5D97  uni5D97,  CJK UNIFIED IDEOGRAPH-5D97
        0x5D9F, # G+10426  U+5D9F  uni5D9F,  CJK UNIFIED IDEOGRAPH-5D9F
        0x5D92, # G+10427  U+5D92  uni5D92,  CJK UNIFIED IDEOGRAPH-5D92
        0x5DA2, # G+10428  U+5DA2  uni5DA2,  CJK UNIFIED IDEOGRAPH-5DA2
        0x5D93, # G+10429  U+5D93  uni5D93,  CJK UNIFIED IDEOGRAPH-5D93
        0x5D95, # G+10430  U+5D95  uni5D95,  CJK UNIFIED IDEOGRAPH-5D95
        0x5DA0, # G+10431  U+5DA0  uni5DA0,  CJK UNIFIED IDEOGRAPH-5DA0
        0x5D9C, # G+10432  U+5D9C  uni5D9C,  CJK UNIFIED IDEOGRAPH-5D9C
        0x5DA1, # G+10433  U+5DA1  uni5DA1,  CJK UNIFIED IDEOGRAPH-5DA1
        0x5D9A, # G+10434  U+5D9A  uni5D9A,  CJK UNIFIED IDEOGRAPH-5D9A
        0x5D9E, # G+10435  U+5D9E  uni5D9E,  CJK UNIFIED IDEOGRAPH-5D9E
        0x5E69, # G+10436  U+5E69  uni5E69,  CJK UNIFIED IDEOGRAPH-5E69
        0x5E5D, # G+10437  U+5E5D  uni5E5D,  CJK UNIFIED IDEOGRAPH-5E5D
        0x5E60, # G+10438  U+5E60  uni5E60,  CJK UNIFIED IDEOGRAPH-5E60
        0x5E5C, # G+10439  U+5E5C  uni5E5C,  CJK UNIFIED IDEOGRAPH-5E5C
        0x7DF3, # G+10440  U+7DF3  uni7DF3,  CJK UNIFIED IDEOGRAPH-7DF3
        0x5EDB, # G+10441  U+5EDB  uni5EDB,  CJK UNIFIED IDEOGRAPH-5EDB
        0x5EDE, # G+10442  U+5EDE  uni5EDE,  CJK UNIFIED IDEOGRAPH-5EDE
        0x5EE1, # G+10443  U+5EE1  uni5EE1,  CJK UNIFIED IDEOGRAPH-5EE1
        0x5F49, # G+10444  U+5F49  uni5F49,  CJK UNIFIED IDEOGRAPH-5F49
        0x5FB2, # G+10445  U+5FB2  uni5FB2,  CJK UNIFIED IDEOGRAPH-5FB2
        0x618B, # G+10446  U+618B  uni618B,  CJK UNIFIED IDEOGRAPH-618B
        0x6183, # G+10447  U+6183  uni6183,  CJK UNIFIED IDEOGRAPH-6183
        0x6179, # G+10448  U+6179  uni6179,  CJK UNIFIED IDEOGRAPH-6179
        0x61B1, # G+10449  U+61B1  uni61B1,  CJK UNIFIED IDEOGRAPH-61B1
        0x61B0, # G+10450  U+61B0  uni61B0,  CJK UNIFIED IDEOGRAPH-61B0
        0x61A2, # G+10451  U+61A2  uni61A2,  CJK UNIFIED IDEOGRAPH-61A2
        0x6189, # G+10452  U+6189  uni6189,  CJK UNIFIED IDEOGRAPH-6189
        0x619B, # G+10453  U+619B  uni619B,  CJK UNIFIED IDEOGRAPH-619B
        0x6193, # G+10454  U+6193  uni6193,  CJK UNIFIED IDEOGRAPH-6193
        0x61AF, # G+10455  U+61AF  uni61AF,  CJK UNIFIED IDEOGRAPH-61AF
        0x61AD, # G+10456  U+61AD  uni61AD,  CJK UNIFIED IDEOGRAPH-61AD
        0x619F, # G+10457  U+619F  uni619F,  CJK UNIFIED IDEOGRAPH-619F
        0x6192, # G+10458  U+6192  uni6192,  CJK UNIFIED IDEOGRAPH-6192
        0x61AA, # G+10459  U+61AA  uni61AA,  CJK UNIFIED IDEOGRAPH-61AA
        0x61A1, # G+10460  U+61A1  uni61A1,  CJK UNIFIED IDEOGRAPH-61A1
        0x618D, # G+10461  U+618D  uni618D,  CJK UNIFIED IDEOGRAPH-618D
        0x6166, # G+10462  U+6166  uni6166,  CJK UNIFIED IDEOGRAPH-6166
        0x61B3, # G+10463  U+61B3  uni61B3,  CJK UNIFIED IDEOGRAPH-61B3
        0x622D, # G+10464  U+622D  uni622D,  CJK UNIFIED IDEOGRAPH-622D
        0x646E, # G+10465  U+646E  uni646E,  CJK UNIFIED IDEOGRAPH-646E
        0x6470, # G+10466  U+6470  uni6470,  CJK UNIFIED IDEOGRAPH-6470
        0x6496, # G+10467  U+6496  uni6496,  CJK UNIFIED IDEOGRAPH-6496
        0x64A0, # G+10468  U+64A0  uni64A0,  CJK UNIFIED IDEOGRAPH-64A0
        0x6485, # G+10469  U+6485  uni6485,  CJK UNIFIED IDEOGRAPH-6485
        0x6497, # G+10470  U+6497  uni6497,  CJK UNIFIED IDEOGRAPH-6497
        0x649C, # G+10471  U+649C  uni649C,  CJK UNIFIED IDEOGRAPH-649C
        0x648F, # G+10472  U+648F  uni648F,  CJK UNIFIED IDEOGRAPH-648F
        0x648B, # G+10473  U+648B  uni648B,  CJK UNIFIED IDEOGRAPH-648B
        0x648A, # G+10474  U+648A  uni648A,  CJK UNIFIED IDEOGRAPH-648A
        0x648C, # G+10475  U+648C  uni648C,  CJK UNIFIED IDEOGRAPH-648C
        0x64A3, # G+10476  U+64A3  uni64A3,  CJK UNIFIED IDEOGRAPH-64A3
        0x649F, # G+10477  U+649F  uni649F,  CJK UNIFIED IDEOGRAPH-649F
        0x6468, # G+10478  U+6468  uni6468,  CJK UNIFIED IDEOGRAPH-6468
        0x64B1, # G+10479  U+64B1  uni64B1,  CJK UNIFIED IDEOGRAPH-64B1
        0x6498, # G+10480  U+6498  uni6498,  CJK UNIFIED IDEOGRAPH-6498
        0x6576, # G+10481  U+6576  uni6576,  CJK UNIFIED IDEOGRAPH-6576
        0x657A, # G+10482  U+657A  uni657A,  CJK UNIFIED IDEOGRAPH-657A
        0x6579, # G+10483  U+6579  uni6579,  CJK UNIFIED IDEOGRAPH-6579
        0x657B, # G+10484  U+657B  uni657B,  CJK UNIFIED IDEOGRAPH-657B
        0x65B2, # G+10485  U+65B2  uni65B2,  CJK UNIFIED IDEOGRAPH-65B2
        0x65B3, # G+10486  U+65B3  uni65B3,  CJK UNIFIED IDEOGRAPH-65B3
        0x66B5, # G+10487  U+66B5  uni66B5,  CJK UNIFIED IDEOGRAPH-66B5
        0x66B0, # G+10488  U+66B0  uni66B0,  CJK UNIFIED IDEOGRAPH-66B0
        0x66A9, # G+10489  U+66A9  uni66A9,  CJK UNIFIED IDEOGRAPH-66A9
        0x66B2, # G+10490  U+66B2  uni66B2,  CJK UNIFIED IDEOGRAPH-66B2
        0x66B7, # G+10491  U+66B7  uni66B7,  CJK UNIFIED IDEOGRAPH-66B7
        0x66AA, # G+10492  U+66AA  uni66AA,  CJK UNIFIED IDEOGRAPH-66AA
        0x66AF, # G+10493  U+66AF  uni66AF,  CJK UNIFIED IDEOGRAPH-66AF
        0x6A00, # G+10494  U+6A00  uni6A00,  CJK UNIFIED IDEOGRAPH-6A00
        0x6A06, # G+10495  U+6A06  uni6A06,  CJK UNIFIED IDEOGRAPH-6A06
        0x6A17, # G+10496  U+6A17  uni6A17,  CJK UNIFIED IDEOGRAPH-6A17
        0x69E5, # G+10497  U+69E5  uni69E5,  CJK UNIFIED IDEOGRAPH-69E5
        0x69F8, # G+10498  U+69F8  uni69F8,  CJK UNIFIED IDEOGRAPH-69F8
        0x6A15, # G+10499  U+6A15  uni6A15,  CJK UNIFIED IDEOGRAPH-6A15
        0x69F1, # G+10500  U+69F1  uni69F1,  CJK UNIFIED IDEOGRAPH-69F1
        0x69E4, # G+10501  U+69E4  uni69E4,  CJK UNIFIED IDEOGRAPH-69E4
        0x6A20, # G+10502  U+6A20  uni6A20,  CJK UNIFIED IDEOGRAPH-6A20
        0x69FF, # G+10503  U+69FF  uni69FF,  CJK UNIFIED IDEOGRAPH-69FF
        0x69EC, # G+10504  U+69EC  uni69EC,  CJK UNIFIED IDEOGRAPH-69EC
        0x69E2, # G+10505  U+69E2  uni69E2,  CJK UNIFIED IDEOGRAPH-69E2
        0x6A1B, # G+10506  U+6A1B  uni6A1B,  CJK UNIFIED IDEOGRAPH-6A1B
        0x6A1D, # G+10507  U+6A1D  uni6A1D,  CJK UNIFIED IDEOGRAPH-6A1D
        0x69FE, # G+10508  U+69FE  uni69FE,  CJK UNIFIED IDEOGRAPH-69FE
        0x6A27, # G+10509  U+6A27  uni6A27,  CJK UNIFIED IDEOGRAPH-6A27
        0x69F2, # G+10510  U+69F2  uni69F2,  CJK UNIFIED IDEOGRAPH-69F2
        0x69EE, # G+10511  U+69EE  uni69EE,  CJK UNIFIED IDEOGRAPH-69EE
        0x6A14, # G+10512  U+6A14  uni6A14,  CJK UNIFIED IDEOGRAPH-6A14
        0x69F7, # G+10513  U+69F7  uni69F7,  CJK UNIFIED IDEOGRAPH-69F7
        0x69E7, # G+10514  U+69E7  uni69E7,  CJK UNIFIED IDEOGRAPH-69E7
        0x6A40, # G+10515  U+6A40  uni6A40,  CJK UNIFIED IDEOGRAPH-6A40
        0x6A08, # G+10516  U+6A08  uni6A08,  CJK UNIFIED IDEOGRAPH-6A08
        0x69E6, # G+10517  U+69E6  uni69E6,  CJK UNIFIED IDEOGRAPH-69E6
        0x69FB, # G+10518  U+69FB  uni69FB,  CJK UNIFIED IDEOGRAPH-69FB
        0x6A0D, # G+10519  U+6A0D  uni6A0D,  CJK UNIFIED IDEOGRAPH-6A0D
        0x69FC, # G+10520  U+69FC  uni69FC,  CJK UNIFIED IDEOGRAPH-69FC
        0x69EB, # G+10521  U+69EB  uni69EB,  CJK UNIFIED IDEOGRAPH-69EB
        0x6A09, # G+10522  U+6A09  uni6A09,  CJK UNIFIED IDEOGRAPH-6A09
        0x6A04, # G+10523  U+6A04  uni6A04,  CJK UNIFIED IDEOGRAPH-6A04
        0x6A18, # G+10524  U+6A18  uni6A18,  CJK UNIFIED IDEOGRAPH-6A18
        0x6A25, # G+10525  U+6A25  uni6A25,  CJK UNIFIED IDEOGRAPH-6A25
        0x6A0F, # G+10526  U+6A0F  uni6A0F,  CJK UNIFIED IDEOGRAPH-6A0F
        0x69F6, # G+10527  U+69F6  uni69F6,  CJK UNIFIED IDEOGRAPH-69F6
        0x6A26, # G+10528  U+6A26  uni6A26,  CJK UNIFIED IDEOGRAPH-6A26
        0x6A07, # G+10529  U+6A07  uni6A07,  CJK UNIFIED IDEOGRAPH-6A07
        0x69F4, # G+10530  U+69F4  uni69F4,  CJK UNIFIED IDEOGRAPH-69F4
        0x6A16, # G+10531  U+6A16  uni6A16,  CJK UNIFIED IDEOGRAPH-6A16
        0x6B51, # G+10532  U+6B51  uni6B51,  CJK UNIFIED IDEOGRAPH-6B51
        0x6BA5, # G+10533  U+6BA5  uni6BA5,  CJK UNIFIED IDEOGRAPH-6BA5
        0x6BA3, # G+10534  U+6BA3  uni6BA3,  CJK UNIFIED IDEOGRAPH-6BA3
        0x6BA2, # G+10535  U+6BA2  uni6BA2,  CJK UNIFIED IDEOGRAPH-6BA2
        0x6BA6, # G+10536  U+6BA6  uni6BA6,  CJK UNIFIED IDEOGRAPH-6BA6
        0x6C01, # G+10537  U+6C01  uni6C01,  CJK UNIFIED IDEOGRAPH-6C01
        0x6C00, # G+10538  U+6C00  uni6C00,  CJK UNIFIED IDEOGRAPH-6C00
        0x6BFF, # G+10539  U+6BFF  uni6BFF,  CJK UNIFIED IDEOGRAPH-6BFF
        0x6C02, # G+10540  U+6C02  uni6C02,  CJK UNIFIED IDEOGRAPH-6C02
        0x6F41, # G+10541  U+6F41  uni6F41,  CJK UNIFIED IDEOGRAPH-6F41
        0x6F26, # G+10542  U+6F26  uni6F26,  CJK UNIFIED IDEOGRAPH-6F26
        0x6F7E, # G+10543  U+6F7E  uni6F7E,  CJK UNIFIED IDEOGRAPH-6F7E
        0x6F87, # G+10544  U+6F87  uni6F87,  CJK UNIFIED IDEOGRAPH-6F87
        0x6FC6, # G+10545  U+6FC6  uni6FC6,  CJK UNIFIED IDEOGRAPH-6FC6
        0x6F92, # G+10546  U+6F92  uni6F92,  CJK UNIFIED IDEOGRAPH-6F92
        0x6F8D, # G+10547  U+6F8D  uni6F8D,  CJK UNIFIED IDEOGRAPH-6F8D
        0x6F89, # G+10548  U+6F89  uni6F89,  CJK UNIFIED IDEOGRAPH-6F89
        0x6F8C, # G+10549  U+6F8C  uni6F8C,  CJK UNIFIED IDEOGRAPH-6F8C
        0x6F62, # G+10550  U+6F62  uni6F62,  CJK UNIFIED IDEOGRAPH-6F62
        0x6F4F, # G+10551  U+6F4F  uni6F4F,  CJK UNIFIED IDEOGRAPH-6F4F
        0x6F85, # G+10552  U+6F85  uni6F85,  CJK UNIFIED IDEOGRAPH-6F85
        0x6F5A, # G+10553  U+6F5A  uni6F5A,  CJK UNIFIED IDEOGRAPH-6F5A
        0x6F96, # G+10554  U+6F96  uni6F96,  CJK UNIFIED IDEOGRAPH-6F96
        0x6F76, # G+10555  U+6F76  uni6F76,  CJK UNIFIED IDEOGRAPH-6F76
        0x6F6C, # G+10556  U+6F6C  uni6F6C,  CJK UNIFIED IDEOGRAPH-6F6C
        0x6F82, # G+10557  U+6F82  uni6F82,  CJK UNIFIED IDEOGRAPH-6F82
        0x6F55, # G+10558  U+6F55  uni6F55,  CJK UNIFIED IDEOGRAPH-6F55
        0x6F72, # G+10559  U+6F72  uni6F72,  CJK UNIFIED IDEOGRAPH-6F72
        0x6F52, # G+10560  U+6F52  uni6F52,  CJK UNIFIED IDEOGRAPH-6F52
        0x6F50, # G+10561  U+6F50  uni6F50,  CJK UNIFIED IDEOGRAPH-6F50
        0x6F57, # G+10562  U+6F57  uni6F57,  CJK UNIFIED IDEOGRAPH-6F57
        0x6F94, # G+10563  U+6F94  uni6F94,  CJK UNIFIED IDEOGRAPH-6F94
        0x6F93, # G+10564  U+6F93  uni6F93,  CJK UNIFIED IDEOGRAPH-6F93
        0x6F5D, # G+10565  U+6F5D  uni6F5D,  CJK UNIFIED IDEOGRAPH-6F5D
        0x6F00, # G+10566  U+6F00  uni6F00,  CJK UNIFIED IDEOGRAPH-6F00
        0x6F61, # G+10567  U+6F61  uni6F61,  CJK UNIFIED IDEOGRAPH-6F61
        0x6F6B, # G+10568  U+6F6B  uni6F6B,  CJK UNIFIED IDEOGRAPH-6F6B
        0x6F7D, # G+10569  U+6F7D  uni6F7D,  CJK UNIFIED IDEOGRAPH-6F7D
        0x6F67, # G+10570  U+6F67  uni6F67,  CJK UNIFIED IDEOGRAPH-6F67
        0x6F90, # G+10571  U+6F90  uni6F90,  CJK UNIFIED IDEOGRAPH-6F90
        0x6F53, # G+10572  U+6F53  uni6F53,  CJK UNIFIED IDEOGRAPH-6F53
        0x6F8B, # G+10573  U+6F8B  uni6F8B,  CJK UNIFIED IDEOGRAPH-6F8B
        0x6F69, # G+10574  U+6F69  uni6F69,  CJK UNIFIED IDEOGRAPH-6F69
        0x6F7F, # G+10575  U+6F7F  uni6F7F,  CJK UNIFIED IDEOGRAPH-6F7F
        0x6F95, # G+10576  U+6F95  uni6F95,  CJK UNIFIED IDEOGRAPH-6F95
        0x6F63, # G+10577  U+6F63  uni6F63,  CJK UNIFIED IDEOGRAPH-6F63
        0x6F77, # G+10578  U+6F77  uni6F77,  CJK UNIFIED IDEOGRAPH-6F77
        0x6F6A, # G+10579  U+6F6A  uni6F6A,  CJK UNIFIED IDEOGRAPH-6F6A
        0x6F7B, # G+10580  U+6F7B  uni6F7B,  CJK UNIFIED IDEOGRAPH-6F7B
        0x71B2, # G+10581  U+71B2  uni71B2,  CJK UNIFIED IDEOGRAPH-71B2
        0x71AF, # G+10582  U+71AF  uni71AF,  CJK UNIFIED IDEOGRAPH-71AF
        0x719B, # G+10583  U+719B  uni719B,  CJK UNIFIED IDEOGRAPH-719B
        0x71B0, # G+10584  U+71B0  uni71B0,  CJK UNIFIED IDEOGRAPH-71B0
        0x71A0, # G+10585  U+71A0  uni71A0,  CJK UNIFIED IDEOGRAPH-71A0
        0x719A, # G+10586  U+719A  uni719A,  CJK UNIFIED IDEOGRAPH-719A
        0x71A9, # G+10587  U+71A9  uni71A9,  CJK UNIFIED IDEOGRAPH-71A9
        0x71B5, # G+10588  U+71B5  uni71B5,  CJK UNIFIED IDEOGRAPH-71B5
        0x719D, # G+10589  U+719D  uni719D,  CJK UNIFIED IDEOGRAPH-719D
        0x71A5, # G+10590  U+71A5  uni71A5,  CJK UNIFIED IDEOGRAPH-71A5
        0x719E, # G+10591  U+719E  uni719E,  CJK UNIFIED IDEOGRAPH-719E
        0x71A4, # G+10592  U+71A4  uni71A4,  CJK UNIFIED IDEOGRAPH-71A4
        0x71A1, # G+10593  U+71A1  uni71A1,  CJK UNIFIED IDEOGRAPH-71A1
        0x71AA, # G+10594  U+71AA  uni71AA,  CJK UNIFIED IDEOGRAPH-71AA
        0x719C, # G+10595  U+719C  uni719C,  CJK UNIFIED IDEOGRAPH-719C
        0x71A7, # G+10596  U+71A7  uni71A7,  CJK UNIFIED IDEOGRAPH-71A7
        0x71B3, # G+10597  U+71B3  uni71B3,  CJK UNIFIED IDEOGRAPH-71B3
        0x7298, # G+10598  U+7298  uni7298,  CJK UNIFIED IDEOGRAPH-7298
        0x729A, # G+10599  U+729A  uni729A,  CJK UNIFIED IDEOGRAPH-729A
        0x7358, # G+10600  U+7358  uni7358,  CJK UNIFIED IDEOGRAPH-7358
        0x7352, # G+10601  U+7352  uni7352,  CJK UNIFIED IDEOGRAPH-7352
        0x735E, # G+10602  U+735E  uni735E,  CJK UNIFIED IDEOGRAPH-735E
        0x735F, # G+10603  U+735F  uni735F,  CJK UNIFIED IDEOGRAPH-735F
        0x7360, # G+10604  U+7360  uni7360,  CJK UNIFIED IDEOGRAPH-7360
        0x735D, # G+10605  U+735D  uni735D,  CJK UNIFIED IDEOGRAPH-735D
        0x735B, # G+10606  U+735B  uni735B,  CJK UNIFIED IDEOGRAPH-735B
        0x7361, # G+10607  U+7361  uni7361,  CJK UNIFIED IDEOGRAPH-7361
        0x735A, # G+10608  U+735A  uni735A,  CJK UNIFIED IDEOGRAPH-735A
        0x7359, # G+10609  U+7359  uni7359,  CJK UNIFIED IDEOGRAPH-7359
        0x7362, # G+10610  U+7362  uni7362,  CJK UNIFIED IDEOGRAPH-7362
        0x7487, # G+10611  U+7487  uni7487,  CJK UNIFIED IDEOGRAPH-7487
        0x7489, # G+10612  U+7489  uni7489,  CJK UNIFIED IDEOGRAPH-7489
        0x748A, # G+10613  U+748A  uni748A,  CJK UNIFIED IDEOGRAPH-748A
        0x7486, # G+10614  U+7486  uni7486,  CJK UNIFIED IDEOGRAPH-7486
        0x7481, # G+10615  U+7481  uni7481,  CJK UNIFIED IDEOGRAPH-7481
        0x747D, # G+10616  U+747D  uni747D,  CJK UNIFIED IDEOGRAPH-747D
        0x7485, # G+10617  U+7485  uni7485,  CJK UNIFIED IDEOGRAPH-7485
        0x7488, # G+10618  U+7488  uni7488,  CJK UNIFIED IDEOGRAPH-7488
        0x747C, # G+10619  U+747C  uni747C,  CJK UNIFIED IDEOGRAPH-747C
        0x7479, # G+10620  U+7479  uni7479,  CJK UNIFIED IDEOGRAPH-7479
        0x7508, # G+10621  U+7508  uni7508,  CJK UNIFIED IDEOGRAPH-7508
        0x7507, # G+10622  U+7507  uni7507,  CJK UNIFIED IDEOGRAPH-7507
        0x757E, # G+10623  U+757E  uni757E,  CJK UNIFIED IDEOGRAPH-757E
        0x7625, # G+10624  U+7625  uni7625,  CJK UNIFIED IDEOGRAPH-7625
        0x761E, # G+10625  U+761E  uni761E,  CJK UNIFIED IDEOGRAPH-761E
        0x7619, # G+10626  U+7619  uni7619,  CJK UNIFIED IDEOGRAPH-7619
        0x761D, # G+10627  U+761D  uni761D,  CJK UNIFIED IDEOGRAPH-761D
        0x761C, # G+10628  U+761C  uni761C,  CJK UNIFIED IDEOGRAPH-761C
        0x7623, # G+10629  U+7623  uni7623,  CJK UNIFIED IDEOGRAPH-7623
        0x761A, # G+10630  U+761A  uni761A,  CJK UNIFIED IDEOGRAPH-761A
        0x7628, # G+10631  U+7628  uni7628,  CJK UNIFIED IDEOGRAPH-7628
        0x761B, # G+10632  U+761B  uni761B,  CJK UNIFIED IDEOGRAPH-761B
        0x769C, # G+10633  U+769C  uni769C,  CJK UNIFIED IDEOGRAPH-769C
        0x769D, # G+10634  U+769D  uni769D,  CJK UNIFIED IDEOGRAPH-769D
        0x769E, # G+10635  U+769E  uni769E,  CJK UNIFIED IDEOGRAPH-769E
        0x769B, # G+10636  U+769B  uni769B,  CJK UNIFIED IDEOGRAPH-769B
        0x778D, # G+10637  U+778D  uni778D,  CJK UNIFIED IDEOGRAPH-778D
        0x778F, # G+10638  U+778F  uni778F,  CJK UNIFIED IDEOGRAPH-778F
        0x7789, # G+10639  U+7789  uni7789,  CJK UNIFIED IDEOGRAPH-7789
        0x7788, # G+10640  U+7788  uni7788,  CJK UNIFIED IDEOGRAPH-7788
        0x78CD, # G+10641  U+78CD  uni78CD,  CJK UNIFIED IDEOGRAPH-78CD
        0x78BB, # G+10642  U+78BB  uni78BB,  CJK UNIFIED IDEOGRAPH-78BB
        0x78CF, # G+10643  U+78CF  uni78CF,  CJK UNIFIED IDEOGRAPH-78CF
        0x78CC, # G+10644  U+78CC  uni78CC,  CJK UNIFIED IDEOGRAPH-78CC
        0x78D1, # G+10645  U+78D1  uni78D1,  CJK UNIFIED IDEOGRAPH-78D1
        0x78CE, # G+10646  U+78CE  uni78CE,  CJK UNIFIED IDEOGRAPH-78CE
        0x78D4, # G+10647  U+78D4  uni78D4,  CJK UNIFIED IDEOGRAPH-78D4
        0x78C8, # G+10648  U+78C8  uni78C8,  CJK UNIFIED IDEOGRAPH-78C8
        0x78C3, # G+10649  U+78C3  uni78C3,  CJK UNIFIED IDEOGRAPH-78C3
        0x78C4, # G+10650  U+78C4  uni78C4,  CJK UNIFIED IDEOGRAPH-78C4
        0x78C9, # G+10651  U+78C9  uni78C9,  CJK UNIFIED IDEOGRAPH-78C9
        0x799A, # G+10652  U+799A  uni799A,  CJK UNIFIED IDEOGRAPH-799A
        0x79A1, # G+10653  U+79A1  uni79A1,  CJK UNIFIED IDEOGRAPH-79A1
        0x79A0, # G+10654  U+79A0  uni79A0,  CJK UNIFIED IDEOGRAPH-79A0
        0x799C, # G+10655  U+799C  uni799C,  CJK UNIFIED IDEOGRAPH-799C
        0x79A2, # G+10656  U+79A2  uni79A2,  CJK UNIFIED IDEOGRAPH-79A2
        0x799B, # G+10657  U+799B  uni799B,  CJK UNIFIED IDEOGRAPH-799B
        0x6B76, # G+10658  U+6B76  uni6B76,  CJK UNIFIED IDEOGRAPH-6B76
        0x7A39, # G+10659  U+7A39  uni7A39,  CJK UNIFIED IDEOGRAPH-7A39
        0x7AB2, # G+10660  U+7AB2  uni7AB2,  CJK UNIFIED IDEOGRAPH-7AB2
        0x7AB4, # G+10661  U+7AB4  uni7AB4,  CJK UNIFIED IDEOGRAPH-7AB4
        0x7AB3, # G+10662  U+7AB3  uni7AB3,  CJK UNIFIED IDEOGRAPH-7AB3
        0x7BB7, # G+10663  U+7BB7  uni7BB7,  CJK UNIFIED IDEOGRAPH-7BB7
        0x7BCB, # G+10664  U+7BCB  uni7BCB,  CJK UNIFIED IDEOGRAPH-7BCB
        0x7BBE, # G+10665  U+7BBE  uni7BBE,  CJK UNIFIED IDEOGRAPH-7BBE
        0x7BAC, # G+10666  U+7BAC  uni7BAC,  CJK UNIFIED IDEOGRAPH-7BAC
        0x7BCE, # G+10667  U+7BCE  uni7BCE,  CJK UNIFIED IDEOGRAPH-7BCE
        0x7BAF, # G+10668  U+7BAF  uni7BAF,  CJK UNIFIED IDEOGRAPH-7BAF
        0x7BB9, # G+10669  U+7BB9  uni7BB9,  CJK UNIFIED IDEOGRAPH-7BB9
        0x7BCA, # G+10670  U+7BCA  uni7BCA,  CJK UNIFIED IDEOGRAPH-7BCA
        0x7BB5, # G+10671  U+7BB5  uni7BB5,  CJK UNIFIED IDEOGRAPH-7BB5
        0x7CC5, # G+10672  U+7CC5  uni7CC5,  CJK UNIFIED IDEOGRAPH-7CC5
        0x7CC8, # G+10673  U+7CC8  uni7CC8,  CJK UNIFIED IDEOGRAPH-7CC8
        0x7CCC, # G+10674  U+7CCC  uni7CCC,  CJK UNIFIED IDEOGRAPH-7CCC
        0x7CCB, # G+10675  U+7CCB  uni7CCB,  CJK UNIFIED IDEOGRAPH-7CCB
        0x7DF7, # G+10676  U+7DF7  uni7DF7,  CJK UNIFIED IDEOGRAPH-7DF7
        0x7DDB, # G+10677  U+7DDB  uni7DDB,  CJK UNIFIED IDEOGRAPH-7DDB
        0x7DEA, # G+10678  U+7DEA  uni7DEA,  CJK UNIFIED IDEOGRAPH-7DEA
        0x7DE7, # G+10679  U+7DE7  uni7DE7,  CJK UNIFIED IDEOGRAPH-7DE7
        0x7DD7, # G+10680  U+7DD7  uni7DD7,  CJK UNIFIED IDEOGRAPH-7DD7
        0x7DE1, # G+10681  U+7DE1  uni7DE1,  CJK UNIFIED IDEOGRAPH-7DE1
        0x7E03, # G+10682  U+7E03  uni7E03,  CJK UNIFIED IDEOGRAPH-7E03
        0x7DFA, # G+10683  U+7DFA  uni7DFA,  CJK UNIFIED IDEOGRAPH-7DFA
        0x7DE6, # G+10684  U+7DE6  uni7DE6,  CJK UNIFIED IDEOGRAPH-7DE6
        0x7DF6, # G+10685  U+7DF6  uni7DF6,  CJK UNIFIED IDEOGRAPH-7DF6
        0x7DF1, # G+10686  U+7DF1  uni7DF1,  CJK UNIFIED IDEOGRAPH-7DF1
        0x7DF0, # G+10687  U+7DF0  uni7DF0,  CJK UNIFIED IDEOGRAPH-7DF0
        0x7DEE, # G+10688  U+7DEE  uni7DEE,  CJK UNIFIED IDEOGRAPH-7DEE
        0x7DDF, # G+10689  U+7DDF  uni7DDF,  CJK UNIFIED IDEOGRAPH-7DDF
        0x7F76, # G+10690  U+7F76  uni7F76,  CJK UNIFIED IDEOGRAPH-7F76
        0x7FAC, # G+10691  U+7FAC  uni7FAC,  CJK UNIFIED IDEOGRAPH-7FAC
        0x7FB0, # G+10692  U+7FB0  uni7FB0,  CJK UNIFIED IDEOGRAPH-7FB0
        0x7FAD, # G+10693  U+7FAD  uni7FAD,  CJK UNIFIED IDEOGRAPH-7FAD
        0x7FED, # G+10694  U+7FED  uni7FED,  CJK UNIFIED IDEOGRAPH-7FED
        0x7FEB, # G+10695  U+7FEB  uni7FEB,  CJK UNIFIED IDEOGRAPH-7FEB
        0x7FEA, # G+10696  U+7FEA  uni7FEA,  CJK UNIFIED IDEOGRAPH-7FEA
        0x7FEC, # G+10697  U+7FEC  uni7FEC,  CJK UNIFIED IDEOGRAPH-7FEC
        0x7FE6, # G+10698  U+7FE6  uni7FE6,  CJK UNIFIED IDEOGRAPH-7FE6
        0x7FE8, # G+10699  U+7FE8  uni7FE8,  CJK UNIFIED IDEOGRAPH-7FE8
        0x8064, # G+10700  U+8064  uni8064,  CJK UNIFIED IDEOGRAPH-8064
        0x8067, # G+10701  U+8067  uni8067,  CJK UNIFIED IDEOGRAPH-8067
        0x81A3, # G+10702  U+81A3  uni81A3,  CJK UNIFIED IDEOGRAPH-81A3
        0x819F, # G+10703  U+819F  uni819F,  CJK UNIFIED IDEOGRAPH-819F
        0x819E, # G+10704  U+819E  uni819E,  CJK UNIFIED IDEOGRAPH-819E
        0x8195, # G+10705  U+8195  uni8195,  CJK UNIFIED IDEOGRAPH-8195
        0x81A2, # G+10706  U+81A2  uni81A2,  CJK UNIFIED IDEOGRAPH-81A2
        0x8199, # G+10707  U+8199  uni8199,  CJK UNIFIED IDEOGRAPH-8199
        0x8197, # G+10708  U+8197  uni8197,  CJK UNIFIED IDEOGRAPH-8197
        0x8216, # G+10709  U+8216  uni8216,  CJK UNIFIED IDEOGRAPH-8216
        0x824F, # G+10710  U+824F  uni824F,  CJK UNIFIED IDEOGRAPH-824F
        0x8253, # G+10711  U+8253  uni8253,  CJK UNIFIED IDEOGRAPH-8253
        0x8252, # G+10712  U+8252  uni8252,  CJK UNIFIED IDEOGRAPH-8252
        0x8250, # G+10713  U+8250  uni8250,  CJK UNIFIED IDEOGRAPH-8250
        0x824E, # G+10714  U+824E  uni824E,  CJK UNIFIED IDEOGRAPH-824E
        0x8251, # G+10715  U+8251  uni8251,  CJK UNIFIED IDEOGRAPH-8251
        0x8524, # G+10716  U+8524  uni8524,  CJK UNIFIED IDEOGRAPH-8524
        0x853B, # G+10717  U+853B  uni853B,  CJK UNIFIED IDEOGRAPH-853B
        0x850F, # G+10718  U+850F  uni850F,  CJK UNIFIED IDEOGRAPH-850F
        0x8500, # G+10719  U+8500  uni8500,  CJK UNIFIED IDEOGRAPH-8500
        0x8529, # G+10720  U+8529  uni8529,  CJK UNIFIED IDEOGRAPH-8529
        0x850E, # G+10721  U+850E  uni850E,  CJK UNIFIED IDEOGRAPH-850E
        0x8509, # G+10722  U+8509  uni8509,  CJK UNIFIED IDEOGRAPH-8509
        0x850D, # G+10723  U+850D  uni850D,  CJK UNIFIED IDEOGRAPH-850D
        0x851F, # G+10724  U+851F  uni851F,  CJK UNIFIED IDEOGRAPH-851F
        0x850A, # G+10725  U+850A  uni850A,  CJK UNIFIED IDEOGRAPH-850A
        0x8527, # G+10726  U+8527  uni8527,  CJK UNIFIED IDEOGRAPH-8527
        0x851C, # G+10727  U+851C  uni851C,  CJK UNIFIED IDEOGRAPH-851C
        0x84FB, # G+10728  U+84FB  uni84FB,  CJK UNIFIED IDEOGRAPH-84FB
        0x852B, # G+10729  U+852B  uni852B,  CJK UNIFIED IDEOGRAPH-852B
        0x84FA, # G+10730  U+84FA  uni84FA,  CJK UNIFIED IDEOGRAPH-84FA
        0x8508, # G+10731  U+8508  uni8508,  CJK UNIFIED IDEOGRAPH-8508
        0x850C, # G+10732  U+850C  uni850C,  CJK UNIFIED IDEOGRAPH-850C
        0x84F4, # G+10733  U+84F4  uni84F4,  CJK UNIFIED IDEOGRAPH-84F4
        0x852A, # G+10734  U+852A  uni852A,  CJK UNIFIED IDEOGRAPH-852A
        0x84F2, # G+10735  U+84F2  uni84F2,  CJK UNIFIED IDEOGRAPH-84F2
        0x8515, # G+10736  U+8515  uni8515,  CJK UNIFIED IDEOGRAPH-8515
        0x84F7, # G+10737  U+84F7  uni84F7,  CJK UNIFIED IDEOGRAPH-84F7
        0x84EB, # G+10738  U+84EB  uni84EB,  CJK UNIFIED IDEOGRAPH-84EB
        0x84F3, # G+10739  U+84F3  uni84F3,  CJK UNIFIED IDEOGRAPH-84F3
        0x84FC, # G+10740  U+84FC  uni84FC,  CJK UNIFIED IDEOGRAPH-84FC
        0x8512, # G+10741  U+8512  uni8512,  CJK UNIFIED IDEOGRAPH-8512
        0x84EA, # G+10742  U+84EA  uni84EA,  CJK UNIFIED IDEOGRAPH-84EA
        0x84E9, # G+10743  U+84E9  uni84E9,  CJK UNIFIED IDEOGRAPH-84E9
        0x8516, # G+10744  U+8516  uni8516,  CJK UNIFIED IDEOGRAPH-8516
        0x84FE, # G+10745  U+84FE  uni84FE,  CJK UNIFIED IDEOGRAPH-84FE
        0x8528, # G+10746  U+8528  uni8528,  CJK UNIFIED IDEOGRAPH-8528
        0x851D, # G+10747  U+851D  uni851D,  CJK UNIFIED IDEOGRAPH-851D
        0x852E, # G+10748  U+852E  uni852E,  CJK UNIFIED IDEOGRAPH-852E
        0x8502, # G+10749  U+8502  uni8502,  CJK UNIFIED IDEOGRAPH-8502
        0x84FD, # G+10750  U+84FD  uni84FD,  CJK UNIFIED IDEOGRAPH-84FD
        0x851E, # G+10751  U+851E  uni851E,  CJK UNIFIED IDEOGRAPH-851E
        0x84F6, # G+10752  U+84F6  uni84F6,  CJK UNIFIED IDEOGRAPH-84F6
        0x8531, # G+10753  U+8531  uni8531,  CJK UNIFIED IDEOGRAPH-8531
        0x8526, # G+10754  U+8526  uni8526,  CJK UNIFIED IDEOGRAPH-8526
        0x84E7, # G+10755  U+84E7  uni84E7,  CJK UNIFIED IDEOGRAPH-84E7
        0x84E8, # G+10756  U+84E8  uni84E8,  CJK UNIFIED IDEOGRAPH-84E8
        0x84F0, # G+10757  U+84F0  uni84F0,  CJK UNIFIED IDEOGRAPH-84F0
        0x84EF, # G+10758  U+84EF  uni84EF,  CJK UNIFIED IDEOGRAPH-84EF
        0x84F9, # G+10759  U+84F9  uni84F9,  CJK UNIFIED IDEOGRAPH-84F9
        0x8518, # G+10760  U+8518  uni8518,  CJK UNIFIED IDEOGRAPH-8518
        0x8520, # G+10761  U+8520  uni8520,  CJK UNIFIED IDEOGRAPH-8520
        0x8530, # G+10762  U+8530  uni8530,  CJK UNIFIED IDEOGRAPH-8530
        0x850B, # G+10763  U+850B  uni850B,  CJK UNIFIED IDEOGRAPH-850B
        0x8519, # G+10764  U+8519  uni8519,  CJK UNIFIED IDEOGRAPH-8519
        0x852F, # G+10765  U+852F  uni852F,  CJK UNIFIED IDEOGRAPH-852F
        0x8662, # G+10766  U+8662  uni8662,  CJK UNIFIED IDEOGRAPH-8662
        0x8756, # G+10767  U+8756  uni8756,  CJK UNIFIED IDEOGRAPH-8756
        0x8763, # G+10768  U+8763  uni8763,  CJK UNIFIED IDEOGRAPH-8763
        0x8764, # G+10769  U+8764  uni8764,  CJK UNIFIED IDEOGRAPH-8764
        0x8777, # G+10770  U+8777  uni8777,  CJK UNIFIED IDEOGRAPH-8777
        0x87E1, # G+10771  U+87E1  uni87E1,  CJK UNIFIED IDEOGRAPH-87E1
        0x8773, # G+10772  U+8773  uni8773,  CJK UNIFIED IDEOGRAPH-8773
        0x8758, # G+10773  U+8758  uni8758,  CJK UNIFIED IDEOGRAPH-8758
        0x8754, # G+10774  U+8754  uni8754,  CJK UNIFIED IDEOGRAPH-8754
        0x875B, # G+10775  U+875B  uni875B,  CJK UNIFIED IDEOGRAPH-875B
        0x8752, # G+10776  U+8752  uni8752,  CJK UNIFIED IDEOGRAPH-8752
        0x8761, # G+10777  U+8761  uni8761,  CJK UNIFIED IDEOGRAPH-8761
        0x875A, # G+10778  U+875A  uni875A,  CJK UNIFIED IDEOGRAPH-875A
        0x8751, # G+10779  U+8751  uni8751,  CJK UNIFIED IDEOGRAPH-8751
        0x875E, # G+10780  U+875E  uni875E,  CJK UNIFIED IDEOGRAPH-875E
        0x876D, # G+10781  U+876D  uni876D,  CJK UNIFIED IDEOGRAPH-876D
        0x876A, # G+10782  U+876A  uni876A,  CJK UNIFIED IDEOGRAPH-876A
        0x8750, # G+10783  U+8750  uni8750,  CJK UNIFIED IDEOGRAPH-8750
        0x874E, # G+10784  U+874E  uni874E,  CJK UNIFIED IDEOGRAPH-874E
        0x875F, # G+10785  U+875F  uni875F,  CJK UNIFIED IDEOGRAPH-875F
        0x875D, # G+10786  U+875D  uni875D,  CJK UNIFIED IDEOGRAPH-875D
        0x876F, # G+10787  U+876F  uni876F,  CJK UNIFIED IDEOGRAPH-876F
        0x876C, # G+10788  U+876C  uni876C,  CJK UNIFIED IDEOGRAPH-876C
        0x877A, # G+10789  U+877A  uni877A,  CJK UNIFIED IDEOGRAPH-877A
        0x876E, # G+10790  U+876E  uni876E,  CJK UNIFIED IDEOGRAPH-876E
        0x875C, # G+10791  U+875C  uni875C,  CJK UNIFIED IDEOGRAPH-875C
        0x8765, # G+10792  U+8765  uni8765,  CJK UNIFIED IDEOGRAPH-8765
        0x874F, # G+10793  U+874F  uni874F,  CJK UNIFIED IDEOGRAPH-874F
        0x877B, # G+10794  U+877B  uni877B,  CJK UNIFIED IDEOGRAPH-877B
        0x8775, # G+10795  U+8775  uni8775,  CJK UNIFIED IDEOGRAPH-8775
        0x8762, # G+10796  U+8762  uni8762,  CJK UNIFIED IDEOGRAPH-8762
        0x8767, # G+10797  U+8767  uni8767,  CJK UNIFIED IDEOGRAPH-8767
        0x8769, # G+10798  U+8769  uni8769,  CJK UNIFIED IDEOGRAPH-8769
        0x885A, # G+10799  U+885A  uni885A,  CJK UNIFIED IDEOGRAPH-885A
        0x8905, # G+10800  U+8905  uni8905,  CJK UNIFIED IDEOGRAPH-8905
        0x890C, # G+10801  U+890C  uni890C,  CJK UNIFIED IDEOGRAPH-890C
        0x8914, # G+10802  U+8914  uni8914,  CJK UNIFIED IDEOGRAPH-8914
        0x890B, # G+10803  U+890B  uni890B,  CJK UNIFIED IDEOGRAPH-890B
        0x8917, # G+10804  U+8917  uni8917,  CJK UNIFIED IDEOGRAPH-8917
        0x8918, # G+10805  U+8918  uni8918,  CJK UNIFIED IDEOGRAPH-8918
        0x8919, # G+10806  U+8919  uni8919,  CJK UNIFIED IDEOGRAPH-8919
        0x8906, # G+10807  U+8906  uni8906,  CJK UNIFIED IDEOGRAPH-8906
        0x8916, # G+10808  U+8916  uni8916,  CJK UNIFIED IDEOGRAPH-8916
        0x8911, # G+10809  U+8911  uni8911,  CJK UNIFIED IDEOGRAPH-8911
        0x890E, # G+10810  U+890E  uni890E,  CJK UNIFIED IDEOGRAPH-890E
        0x8909, # G+10811  U+8909  uni8909,  CJK UNIFIED IDEOGRAPH-8909
        0x89A2, # G+10812  U+89A2  uni89A2,  CJK UNIFIED IDEOGRAPH-89A2
        0x89A4, # G+10813  U+89A4  uni89A4,  CJK UNIFIED IDEOGRAPH-89A4
        0x89A3, # G+10814  U+89A3  uni89A3,  CJK UNIFIED IDEOGRAPH-89A3
        0x89ED, # G+10815  U+89ED  uni89ED,  CJK UNIFIED IDEOGRAPH-89ED
        0x89F0, # G+10816  U+89F0  uni89F0,  CJK UNIFIED IDEOGRAPH-89F0
        0x89EC, # G+10817  U+89EC  uni89EC,  CJK UNIFIED IDEOGRAPH-89EC
        0x8ACF, # G+10818  U+8ACF  uni8ACF,  CJK UNIFIED IDEOGRAPH-8ACF
        0x8AC6, # G+10819  U+8AC6  uni8AC6,  CJK UNIFIED IDEOGRAPH-8AC6
        0x8AB8, # G+10820  U+8AB8  uni8AB8,  CJK UNIFIED IDEOGRAPH-8AB8
        0x8AD3, # G+10821  U+8AD3  uni8AD3,  CJK UNIFIED IDEOGRAPH-8AD3
        0x8AD1, # G+10822  U+8AD1  uni8AD1,  CJK UNIFIED IDEOGRAPH-8AD1
        0x8AD4, # G+10823  U+8AD4  uni8AD4,  CJK UNIFIED IDEOGRAPH-8AD4
        0x8AD5, # G+10824  U+8AD5  uni8AD5,  CJK UNIFIED IDEOGRAPH-8AD5
        0x8ABB, # G+10825  U+8ABB  uni8ABB,  CJK UNIFIED IDEOGRAPH-8ABB
        0x8AD7, # G+10826  U+8AD7  uni8AD7,  CJK UNIFIED IDEOGRAPH-8AD7
        0x8ABE, # G+10827  U+8ABE  uni8ABE,  CJK UNIFIED IDEOGRAPH-8ABE
        0x8AC0, # G+10828  U+8AC0  uni8AC0,  CJK UNIFIED IDEOGRAPH-8AC0
        0x8AC5, # G+10829  U+8AC5  uni8AC5,  CJK UNIFIED IDEOGRAPH-8AC5
        0x8AD8, # G+10830  U+8AD8  uni8AD8,  CJK UNIFIED IDEOGRAPH-8AD8
        0x8AC3, # G+10831  U+8AC3  uni8AC3,  CJK UNIFIED IDEOGRAPH-8AC3
        0x8ABA, # G+10832  U+8ABA  uni8ABA,  CJK UNIFIED IDEOGRAPH-8ABA
        0x8ABD, # G+10833  U+8ABD  uni8ABD,  CJK UNIFIED IDEOGRAPH-8ABD
        0x8AD9, # G+10834  U+8AD9  uni8AD9,  CJK UNIFIED IDEOGRAPH-8AD9
        0x8C3E, # G+10835  U+8C3E  uni8C3E,  CJK UNIFIED IDEOGRAPH-8C3E
        0x8C4D, # G+10836  U+8C4D  uni8C4D,  CJK UNIFIED IDEOGRAPH-8C4D
        0x8C8F, # G+10837  U+8C8F  uni8C8F,  CJK UNIFIED IDEOGRAPH-8C8F
        0x8CE5, # G+10838  U+8CE5  uni8CE5,  CJK UNIFIED IDEOGRAPH-8CE5
        0x8CDF, # G+10839  U+8CDF  uni8CDF,  CJK UNIFIED IDEOGRAPH-8CDF
        0x8CD9, # G+10840  U+8CD9  uni8CD9,  CJK UNIFIED IDEOGRAPH-8CD9
        0x8CE8, # G+10841  U+8CE8  uni8CE8,  CJK UNIFIED IDEOGRAPH-8CE8
        0x8CDA, # G+10842  U+8CDA  uni8CDA,  CJK UNIFIED IDEOGRAPH-8CDA
        0x8CDD, # G+10843  U+8CDD  uni8CDD,  CJK UNIFIED IDEOGRAPH-8CDD
        0x8CE7, # G+10844  U+8CE7  uni8CE7,  CJK UNIFIED IDEOGRAPH-8CE7
        0x8DA0, # G+10845  U+8DA0  uni8DA0,  CJK UNIFIED IDEOGRAPH-8DA0
        0x8D9C, # G+10846  U+8D9C  uni8D9C,  CJK UNIFIED IDEOGRAPH-8D9C
        0x8DA1, # G+10847  U+8DA1  uni8DA1,  CJK UNIFIED IDEOGRAPH-8DA1
        0x8D9B, # G+10848  U+8D9B  uni8D9B,  CJK UNIFIED IDEOGRAPH-8D9B
        0x8E20, # G+10849  U+8E20  uni8E20,  CJK UNIFIED IDEOGRAPH-8E20
        0x8E23, # G+10850  U+8E23  uni8E23,  CJK UNIFIED IDEOGRAPH-8E23
        0x8E25, # G+10851  U+8E25  uni8E25,  CJK UNIFIED IDEOGRAPH-8E25
        0x8E24, # G+10852  U+8E24  uni8E24,  CJK UNIFIED IDEOGRAPH-8E24
        0x8E2E, # G+10853  U+8E2E  uni8E2E,  CJK UNIFIED IDEOGRAPH-8E2E
        0x8E15, # G+10854  U+8E15  uni8E15,  CJK UNIFIED IDEOGRAPH-8E15
        0x8E1B, # G+10855  U+8E1B  uni8E1B,  CJK UNIFIED IDEOGRAPH-8E1B
        0x8E16, # G+10856  U+8E16  uni8E16,  CJK UNIFIED IDEOGRAPH-8E16
        0x8E11, # G+10857  U+8E11  uni8E11,  CJK UNIFIED IDEOGRAPH-8E11
        0x8E19, # G+10858  U+8E19  uni8E19,  CJK UNIFIED IDEOGRAPH-8E19
        0x8E26, # G+10859  U+8E26  uni8E26,  CJK UNIFIED IDEOGRAPH-8E26
        0x8E27, # G+10860  U+8E27  uni8E27,  CJK UNIFIED IDEOGRAPH-8E27
        0x8E14, # G+10861  U+8E14  uni8E14,  CJK UNIFIED IDEOGRAPH-8E14
        0x8E12, # G+10862  U+8E12  uni8E12,  CJK UNIFIED IDEOGRAPH-8E12
        0x8E18, # G+10863  U+8E18  uni8E18,  CJK UNIFIED IDEOGRAPH-8E18
        0x8E13, # G+10864  U+8E13  uni8E13,  CJK UNIFIED IDEOGRAPH-8E13
        0x8E1C, # G+10865  U+8E1C  uni8E1C,  CJK UNIFIED IDEOGRAPH-8E1C
        0x8E17, # G+10866  U+8E17  uni8E17,  CJK UNIFIED IDEOGRAPH-8E17
        0x8E1A, # G+10867  U+8E1A  uni8E1A,  CJK UNIFIED IDEOGRAPH-8E1A
        0x8F2C, # G+10868  U+8F2C  uni8F2C,  CJK UNIFIED IDEOGRAPH-8F2C
        0x8F24, # G+10869  U+8F24  uni8F24,  CJK UNIFIED IDEOGRAPH-8F24
        0x8F18, # G+10870  U+8F18  uni8F18,  CJK UNIFIED IDEOGRAPH-8F18
        0x8F1A, # G+10871  U+8F1A  uni8F1A,  CJK UNIFIED IDEOGRAPH-8F1A
        0x8F20, # G+10872  U+8F20  uni8F20,  CJK UNIFIED IDEOGRAPH-8F20
        0x8F23, # G+10873  U+8F23  uni8F23,  CJK UNIFIED IDEOGRAPH-8F23
        0x8F16, # G+10874  U+8F16  uni8F16,  CJK UNIFIED IDEOGRAPH-8F16
        0x8F17, # G+10875  U+8F17  uni8F17,  CJK UNIFIED IDEOGRAPH-8F17
        0x9073, # G+10876  U+9073  uni9073,  CJK UNIFIED IDEOGRAPH-9073
        0x9070, # G+10877  U+9070  uni9070,  CJK UNIFIED IDEOGRAPH-9070
        0x906F, # G+10878  U+906F  uni906F,  CJK UNIFIED IDEOGRAPH-906F
        0x9067, # G+10879  U+9067  uni9067,  CJK UNIFIED IDEOGRAPH-9067
        0x906B, # G+10880  U+906B  uni906B,  CJK UNIFIED IDEOGRAPH-906B
        0x912F, # G+10881  U+912F  uni912F,  CJK UNIFIED IDEOGRAPH-912F
        0x912B, # G+10882  U+912B  uni912B,  CJK UNIFIED IDEOGRAPH-912B
        0x9129, # G+10883  U+9129  uni9129,  CJK UNIFIED IDEOGRAPH-9129
        0x912A, # G+10884  U+912A  uni912A,  CJK UNIFIED IDEOGRAPH-912A
        0x9132, # G+10885  U+9132  uni9132,  CJK UNIFIED IDEOGRAPH-9132
        0x9126, # G+10886  U+9126  uni9126,  CJK UNIFIED IDEOGRAPH-9126
        0x912E, # G+10887  U+912E  uni912E,  CJK UNIFIED IDEOGRAPH-912E
        0x9185, # G+10888  U+9185  uni9185,  CJK UNIFIED IDEOGRAPH-9185
        0x9186, # G+10889  U+9186  uni9186,  CJK UNIFIED IDEOGRAPH-9186
        0x918A, # G+10890  U+918A  uni918A,  CJK UNIFIED IDEOGRAPH-918A
        0x9181, # G+10891  U+9181  uni9181,  CJK UNIFIED IDEOGRAPH-9181
        0x9182, # G+10892  U+9182  uni9182,  CJK UNIFIED IDEOGRAPH-9182
        0x9184, # G+10893  U+9184  uni9184,  CJK UNIFIED IDEOGRAPH-9184
        0x9180, # G+10894  U+9180  uni9180,  CJK UNIFIED IDEOGRAPH-9180
        0x92D0, # G+10895  U+92D0  uni92D0,  CJK UNIFIED IDEOGRAPH-92D0
        0x92C3, # G+10896  U+92C3  uni92C3,  CJK UNIFIED IDEOGRAPH-92C3
        0x92C4, # G+10897  U+92C4  uni92C4,  CJK UNIFIED IDEOGRAPH-92C4
        0x92C0, # G+10898  U+92C0  uni92C0,  CJK UNIFIED IDEOGRAPH-92C0
        0x92D9, # G+10899  U+92D9  uni92D9,  CJK UNIFIED IDEOGRAPH-92D9
        0x92B6, # G+10900  U+92B6  uni92B6,  CJK UNIFIED IDEOGRAPH-92B6
        0x92CF, # G+10901  U+92CF  uni92CF,  CJK UNIFIED IDEOGRAPH-92CF
        0x92F1, # G+10902  U+92F1  uni92F1,  CJK UNIFIED IDEOGRAPH-92F1
        0x92DF, # G+10903  U+92DF  uni92DF,  CJK UNIFIED IDEOGRAPH-92DF
        0x92D8, # G+10904  U+92D8  uni92D8,  CJK UNIFIED IDEOGRAPH-92D8
        0x92E9, # G+10905  U+92E9  uni92E9,  CJK UNIFIED IDEOGRAPH-92E9
        0x92D7, # G+10906  U+92D7  uni92D7,  CJK UNIFIED IDEOGRAPH-92D7
        0x92DD, # G+10907  U+92DD  uni92DD,  CJK UNIFIED IDEOGRAPH-92DD
        0x92CC, # G+10908  U+92CC  uni92CC,  CJK UNIFIED IDEOGRAPH-92CC
        0x92EF, # G+10909  U+92EF  uni92EF,  CJK UNIFIED IDEOGRAPH-92EF
        0x92C2, # G+10910  U+92C2  uni92C2,  CJK UNIFIED IDEOGRAPH-92C2
        0x92E8, # G+10911  U+92E8  uni92E8,  CJK UNIFIED IDEOGRAPH-92E8
        0x92CA, # G+10912  U+92CA  uni92CA,  CJK UNIFIED IDEOGRAPH-92CA
        0x92C8, # G+10913  U+92C8  uni92C8,  CJK UNIFIED IDEOGRAPH-92C8
        0x92CE, # G+10914  U+92CE  uni92CE,  CJK UNIFIED IDEOGRAPH-92CE
        0x92E6, # G+10915  U+92E6  uni92E6,  CJK UNIFIED IDEOGRAPH-92E6
        0x92CD, # G+10916  U+92CD  uni92CD,  CJK UNIFIED IDEOGRAPH-92CD
        0x92D5, # G+10917  U+92D5  uni92D5,  CJK UNIFIED IDEOGRAPH-92D5
        0x92C9, # G+10918  U+92C9  uni92C9,  CJK UNIFIED IDEOGRAPH-92C9
        0x92E0, # G+10919  U+92E0  uni92E0,  CJK UNIFIED IDEOGRAPH-92E0
        0x92DE, # G+10920  U+92DE  uni92DE,  CJK UNIFIED IDEOGRAPH-92DE
        0x92E7, # G+10921  U+92E7  uni92E7,  CJK UNIFIED IDEOGRAPH-92E7
        0x92D1, # G+10922  U+92D1  uni92D1,  CJK UNIFIED IDEOGRAPH-92D1
        0x92D3, # G+10923  U+92D3  uni92D3,  CJK UNIFIED IDEOGRAPH-92D3
        0x92B5, # G+10924  U+92B5  uni92B5,  CJK UNIFIED IDEOGRAPH-92B5
        0x92E1, # G+10925  U+92E1  uni92E1,  CJK UNIFIED IDEOGRAPH-92E1
        0x9325, # G+10926  U+9325  uni9325,  CJK UNIFIED IDEOGRAPH-9325
        0x92C6, # G+10927  U+92C6  uni92C6,  CJK UNIFIED IDEOGRAPH-92C6
        0x92B4, # G+10928  U+92B4  uni92B4,  CJK UNIFIED IDEOGRAPH-92B4
        0x957C, # G+10929  U+957C  uni957C,  CJK UNIFIED IDEOGRAPH-957C
        0x95AC, # G+10930  U+95AC  uni95AC,  CJK UNIFIED IDEOGRAPH-95AC
        0x95AB, # G+10931  U+95AB  uni95AB,  CJK UNIFIED IDEOGRAPH-95AB
        0x95AE, # G+10932  U+95AE  uni95AE,  CJK UNIFIED IDEOGRAPH-95AE
        0x95B0, # G+10933  U+95B0  uni95B0,  CJK UNIFIED IDEOGRAPH-95B0
        0x96A4, # G+10934  U+96A4  uni96A4,  CJK UNIFIED IDEOGRAPH-96A4
        0x96A2, # G+10935  U+96A2  uni96A2,  CJK UNIFIED IDEOGRAPH-96A2
        0x96D3, # G+10936  U+96D3  uni96D3,  CJK UNIFIED IDEOGRAPH-96D3
        0x9705, # G+10937  U+9705  uni9705,  CJK UNIFIED IDEOGRAPH-9705
        0x9708, # G+10938  U+9708  uni9708,  CJK UNIFIED IDEOGRAPH-9708
        0x9702, # G+10939  U+9702  uni9702,  CJK UNIFIED IDEOGRAPH-9702
        0x975A, # G+10940  U+975A  uni975A,  CJK UNIFIED IDEOGRAPH-975A
        0x978A, # G+10941  U+978A  uni978A,  CJK UNIFIED IDEOGRAPH-978A
        0x978E, # G+10942  U+978E  uni978E,  CJK UNIFIED IDEOGRAPH-978E
        0x9788, # G+10943  U+9788  uni9788,  CJK UNIFIED IDEOGRAPH-9788
        0x97D0, # G+10944  U+97D0  uni97D0,  CJK UNIFIED IDEOGRAPH-97D0
        0x97CF, # G+10945  U+97CF  uni97CF,  CJK UNIFIED IDEOGRAPH-97CF
        0x981E, # G+10946  U+981E  uni981E,  CJK UNIFIED IDEOGRAPH-981E
        0x981D, # G+10947  U+981D  uni981D,  CJK UNIFIED IDEOGRAPH-981D
        0x9826, # G+10948  U+9826  uni9826,  CJK UNIFIED IDEOGRAPH-9826
        0x9829, # G+10949  U+9829  uni9829,  CJK UNIFIED IDEOGRAPH-9829
        0x9828, # G+10950  U+9828  uni9828,  CJK UNIFIED IDEOGRAPH-9828
        0x9820, # G+10951  U+9820  uni9820,  CJK UNIFIED IDEOGRAPH-9820
        0x981B, # G+10952  U+981B  uni981B,  CJK UNIFIED IDEOGRAPH-981B
        0x9827, # G+10953  U+9827  uni9827,  CJK UNIFIED IDEOGRAPH-9827
        0x98B2, # G+10954  U+98B2  uni98B2,  CJK UNIFIED IDEOGRAPH-98B2
        0x9908, # G+10955  U+9908  uni9908,  CJK UNIFIED IDEOGRAPH-9908
        0x98FA, # G+10956  U+98FA  uni98FA,  CJK UNIFIED IDEOGRAPH-98FA
        0x9911, # G+10957  U+9911  uni9911,  CJK UNIFIED IDEOGRAPH-9911
        0x9914, # G+10958  U+9914  uni9914,  CJK UNIFIED IDEOGRAPH-9914
        0x9916, # G+10959  U+9916  uni9916,  CJK UNIFIED IDEOGRAPH-9916
        0x9917, # G+10960  U+9917  uni9917,  CJK UNIFIED IDEOGRAPH-9917
        0x9915, # G+10961  U+9915  uni9915,  CJK UNIFIED IDEOGRAPH-9915
        0x99DC, # G+10962  U+99DC  uni99DC,  CJK UNIFIED IDEOGRAPH-99DC
        0x99CD, # G+10963  U+99CD  uni99CD,  CJK UNIFIED IDEOGRAPH-99CD
        0x99CF, # G+10964  U+99CF  uni99CF,  CJK UNIFIED IDEOGRAPH-99CF
        0x99D3, # G+10965  U+99D3  uni99D3,  CJK UNIFIED IDEOGRAPH-99D3
        0x99D4, # G+10966  U+99D4  uni99D4,  CJK UNIFIED IDEOGRAPH-99D4
        0x99CE, # G+10967  U+99CE  uni99CE,  CJK UNIFIED IDEOGRAPH-99CE
        0x99C9, # G+10968  U+99C9  uni99C9,  CJK UNIFIED IDEOGRAPH-99C9
        0x99D6, # G+10969  U+99D6  uni99D6,  CJK UNIFIED IDEOGRAPH-99D6
        0x99D8, # G+10970  U+99D8  uni99D8,  CJK UNIFIED IDEOGRAPH-99D8
        0x99CB, # G+10971  U+99CB  uni99CB,  CJK UNIFIED IDEOGRAPH-99CB
        0x99D7, # G+10972  U+99D7  uni99D7,  CJK UNIFIED IDEOGRAPH-99D7
        0x99CC, # G+10973  U+99CC  uni99CC,  CJK UNIFIED IDEOGRAPH-99CC
        0x9AB3, # G+10974  U+9AB3  uni9AB3,  CJK UNIFIED IDEOGRAPH-9AB3
        0x9AEC, # G+10975  U+9AEC  uni9AEC,  CJK UNIFIED IDEOGRAPH-9AEC
        0x9AEB, # G+10976  U+9AEB  uni9AEB,  CJK UNIFIED IDEOGRAPH-9AEB
        0x9AF3, # G+10977  U+9AF3  uni9AF3,  CJK UNIFIED IDEOGRAPH-9AF3
        0x9AF2, # G+10978  U+9AF2  uni9AF2,  CJK UNIFIED IDEOGRAPH-9AF2
        0x9AF1, # G+10979  U+9AF1  uni9AF1,  CJK UNIFIED IDEOGRAPH-9AF1
        0x9B46, # G+10980  U+9B46  uni9B46,  CJK UNIFIED IDEOGRAPH-9B46
        0x9B43, # G+10981  U+9B43  uni9B43,  CJK UNIFIED IDEOGRAPH-9B43
        0x9B67, # G+10982  U+9B67  uni9B67,  CJK UNIFIED IDEOGRAPH-9B67
        0x9B74, # G+10983  U+9B74  uni9B74,  CJK UNIFIED IDEOGRAPH-9B74
        0x9B71, # G+10984  U+9B71  uni9B71,  CJK UNIFIED IDEOGRAPH-9B71
        0x9B66, # G+10985  U+9B66  uni9B66,  CJK UNIFIED IDEOGRAPH-9B66
        0x9B76, # G+10986  U+9B76  uni9B76,  CJK UNIFIED IDEOGRAPH-9B76
        0x9B75, # G+10987  U+9B75  uni9B75,  CJK UNIFIED IDEOGRAPH-9B75
        0x9B70, # G+10988  U+9B70  uni9B70,  CJK UNIFIED IDEOGRAPH-9B70
        0x9B68, # G+10989  U+9B68  uni9B68,  CJK UNIFIED IDEOGRAPH-9B68
        0x9B64, # G+10990  U+9B64  uni9B64,  CJK UNIFIED IDEOGRAPH-9B64
        0x9B6C, # G+10991  U+9B6C  uni9B6C,  CJK UNIFIED IDEOGRAPH-9B6C
        0x9CFC, # G+10992  U+9CFC  uni9CFC,  CJK UNIFIED IDEOGRAPH-9CFC
        0x9CFA, # G+10993  U+9CFA  uni9CFA,  CJK UNIFIED IDEOGRAPH-9CFA
        0x9CFD, # G+10994  U+9CFD  uni9CFD,  CJK UNIFIED IDEOGRAPH-9CFD
        0x9CFF, # G+10995  U+9CFF  uni9CFF,  CJK UNIFIED IDEOGRAPH-9CFF
        0x9CF7, # G+10996  U+9CF7  uni9CF7,  CJK UNIFIED IDEOGRAPH-9CF7
        0x9D07, # G+10997  U+9D07  uni9D07,  CJK UNIFIED IDEOGRAPH-9D07
        0x9D00, # G+10998  U+9D00  uni9D00,  CJK UNIFIED IDEOGRAPH-9D00
        0x9CF9, # G+10999  U+9CF9  uni9CF9,  CJK UNIFIED IDEOGRAPH-9CF9
        0x9CFB, # G+11000  U+9CFB  uni9CFB,  CJK UNIFIED IDEOGRAPH-9CFB
        0x9D08, # G+11001  U+9D08  uni9D08,  CJK UNIFIED IDEOGRAPH-9D08
        0x9D05, # G+11002  U+9D05  uni9D05,  CJK UNIFIED IDEOGRAPH-9D05
        0x9D04, # G+11003  U+9D04  uni9D04,  CJK UNIFIED IDEOGRAPH-9D04
        0x9E83, # G+11004  U+9E83  uni9E83,  CJK UNIFIED IDEOGRAPH-9E83
        0x9ED3, # G+11005  U+9ED3  uni9ED3,  CJK UNIFIED IDEOGRAPH-9ED3
        0x9F0F, # G+11006  U+9F0F  uni9F0F,  CJK UNIFIED IDEOGRAPH-9F0F
        0x9F10, # G+11007  U+9F10  uni9F10,  CJK UNIFIED IDEOGRAPH-9F10
        0x511C, # G+11008  U+511C  uni511C,  CJK UNIFIED IDEOGRAPH-511C
        0x5113, # G+11009  U+5113  uni5113,  CJK UNIFIED IDEOGRAPH-5113
        0x5117, # G+11010  U+5117  uni5117,  CJK UNIFIED IDEOGRAPH-5117
        0x511A, # G+11011  U+511A  uni511A,  CJK UNIFIED IDEOGRAPH-511A
        0x5111, # G+11012  U+5111  uni5111,  CJK UNIFIED IDEOGRAPH-5111
        0x51DE, # G+11013  U+51DE  uni51DE,  CJK UNIFIED IDEOGRAPH-51DE
        0x5334, # G+11014  U+5334  uni5334,  CJK UNIFIED IDEOGRAPH-5334
        0x53E1, # G+11015  U+53E1  uni53E1,  CJK UNIFIED IDEOGRAPH-53E1
        0x5670, # G+11016  U+5670  uni5670,  CJK UNIFIED IDEOGRAPH-5670
        0x5660, # G+11017  U+5660  uni5660,  CJK UNIFIED IDEOGRAPH-5660
        0x566E, # G+11018  U+566E  uni566E,  CJK UNIFIED IDEOGRAPH-566E
        0x5673, # G+11019  U+5673  uni5673,  CJK UNIFIED IDEOGRAPH-5673
        0x5666, # G+11020  U+5666  uni5666,  CJK UNIFIED IDEOGRAPH-5666
        0x5663, # G+11021  U+5663  uni5663,  CJK UNIFIED IDEOGRAPH-5663
        0x566D, # G+11022  U+566D  uni566D,  CJK UNIFIED IDEOGRAPH-566D
        0x5672, # G+11023  U+5672  uni5672,  CJK UNIFIED IDEOGRAPH-5672
        0x565E, # G+11024  U+565E  uni565E,  CJK UNIFIED IDEOGRAPH-565E
        0x5677, # G+11025  U+5677  uni5677,  CJK UNIFIED IDEOGRAPH-5677
        0x571C, # G+11026  U+571C  uni571C,  CJK UNIFIED IDEOGRAPH-571C
        0x571B, # G+11027  U+571B  uni571B,  CJK UNIFIED IDEOGRAPH-571B
        0x58C8, # G+11028  U+58C8  uni58C8,  CJK UNIFIED IDEOGRAPH-58C8
        0x58BD, # G+11029  U+58BD  uni58BD,  CJK UNIFIED IDEOGRAPH-58BD
        0x58C9, # G+11030  U+58C9  uni58C9,  CJK UNIFIED IDEOGRAPH-58C9
        0x58BF, # G+11031  U+58BF  uni58BF,  CJK UNIFIED IDEOGRAPH-58BF
        0x58BA, # G+11032  U+58BA  uni58BA,  CJK UNIFIED IDEOGRAPH-58BA
        0x58C2, # G+11033  U+58C2  uni58C2,  CJK UNIFIED IDEOGRAPH-58C2
        0x58BC, # G+11034  U+58BC  uni58BC,  CJK UNIFIED IDEOGRAPH-58BC
        0x58C6, # G+11035  U+58C6  uni58C6,  CJK UNIFIED IDEOGRAPH-58C6
        0x5B17, # G+11036  U+5B17  uni5B17,  CJK UNIFIED IDEOGRAPH-5B17
        0x5B19, # G+11037  U+5B19  uni5B19,  CJK UNIFIED IDEOGRAPH-5B19
        0x5B1B, # G+11038  U+5B1B  uni5B1B,  CJK UNIFIED IDEOGRAPH-5B1B
        0x5B21, # G+11039  U+5B21  uni5B21,  CJK UNIFIED IDEOGRAPH-5B21
        0x5B14, # G+11040  U+5B14  uni5B14,  CJK UNIFIED IDEOGRAPH-5B14
        0x5B13, # G+11041  U+5B13  uni5B13,  CJK UNIFIED IDEOGRAPH-5B13
        0x5B10, # G+11042  U+5B10  uni5B10,  CJK UNIFIED IDEOGRAPH-5B10
        0x5B16, # G+11043  U+5B16  uni5B16,  CJK UNIFIED IDEOGRAPH-5B16
        0x5B28, # G+11044  U+5B28  uni5B28,  CJK UNIFIED IDEOGRAPH-5B28
        0x5B1A, # G+11045  U+5B1A  uni5B1A,  CJK UNIFIED IDEOGRAPH-5B1A
        0x5B20, # G+11046  U+5B20  uni5B20,  CJK UNIFIED IDEOGRAPH-5B20
        0x5B1E, # G+11047  U+5B1E  uni5B1E,  CJK UNIFIED IDEOGRAPH-5B1E
        0x5BEF, # G+11048  U+5BEF  uni5BEF,  CJK UNIFIED IDEOGRAPH-5BEF
        0x5DAC, # G+11049  U+5DAC  uni5DAC,  CJK UNIFIED IDEOGRAPH-5DAC
        0x5DB1, # G+11050  U+5DB1  uni5DB1,  CJK UNIFIED IDEOGRAPH-5DB1
        0x5DA9, # G+11051  U+5DA9  uni5DA9,  CJK UNIFIED IDEOGRAPH-5DA9
        0x5DA7, # G+11052  U+5DA7  uni5DA7,  CJK UNIFIED IDEOGRAPH-5DA7
        0x5DB5, # G+11053  U+5DB5  uni5DB5,  CJK UNIFIED IDEOGRAPH-5DB5
        0x5DB0, # G+11054  U+5DB0  uni5DB0,  CJK UNIFIED IDEOGRAPH-5DB0
        0x5DAE, # G+11055  U+5DAE  uni5DAE,  CJK UNIFIED IDEOGRAPH-5DAE
        0x5DAA, # G+11056  U+5DAA  uni5DAA,  CJK UNIFIED IDEOGRAPH-5DAA
        0x5DA8, # G+11057  U+5DA8  uni5DA8,  CJK UNIFIED IDEOGRAPH-5DA8
        0x5DB2, # G+11058  U+5DB2  uni5DB2,  CJK UNIFIED IDEOGRAPH-5DB2
        0x5DAD, # G+11059  U+5DAD  uni5DAD,  CJK UNIFIED IDEOGRAPH-5DAD
        0x5DAF, # G+11060  U+5DAF  uni5DAF,  CJK UNIFIED IDEOGRAPH-5DAF
        0x5DB4, # G+11061  U+5DB4  uni5DB4,  CJK UNIFIED IDEOGRAPH-5DB4
        0x5E67, # G+11062  U+5E67  uni5E67,  CJK UNIFIED IDEOGRAPH-5E67
        0x5E68, # G+11063  U+5E68  uni5E68,  CJK UNIFIED IDEOGRAPH-5E68
        0x5E66, # G+11064  U+5E66  uni5E66,  CJK UNIFIED IDEOGRAPH-5E66
        0x5E6F, # G+11065  U+5E6F  uni5E6F,  CJK UNIFIED IDEOGRAPH-5E6F
        0x5EE9, # G+11066  U+5EE9  uni5EE9,  CJK UNIFIED IDEOGRAPH-5EE9
        0x5EE7, # G+11067  U+5EE7  uni5EE7,  CJK UNIFIED IDEOGRAPH-5EE7
        0x5EE6, # G+11068  U+5EE6  uni5EE6,  CJK UNIFIED IDEOGRAPH-5EE6
        0x5EE8, # G+11069  U+5EE8  uni5EE8,  CJK UNIFIED IDEOGRAPH-5EE8
        0x5EE5, # G+11070  U+5EE5  uni5EE5,  CJK UNIFIED IDEOGRAPH-5EE5
        0x5F4B, # G+11071  U+5F4B  uni5F4B,  CJK UNIFIED IDEOGRAPH-5F4B
        0x5FBC, # G+11072  U+5FBC  uni5FBC,  CJK UNIFIED IDEOGRAPH-5FBC
        0x5FBB, # G+11073  U+5FBB  uni5FBB,  CJK UNIFIED IDEOGRAPH-5FBB
        0x619D, # G+11074  U+619D  uni619D,  CJK UNIFIED IDEOGRAPH-619D
        0x61A8, # G+11075  U+61A8  uni61A8,  CJK UNIFIED IDEOGRAPH-61A8
        0x6196, # G+11076  U+6196  uni6196,  CJK UNIFIED IDEOGRAPH-6196
        0x61C5, # G+11077  U+61C5  uni61C5,  CJK UNIFIED IDEOGRAPH-61C5
        0x61B4, # G+11078  U+61B4  uni61B4,  CJK UNIFIED IDEOGRAPH-61B4
        0x61C6, # G+11079  U+61C6  uni61C6,  CJK UNIFIED IDEOGRAPH-61C6
        0x61C1, # G+11080  U+61C1  uni61C1,  CJK UNIFIED IDEOGRAPH-61C1
        0x61CC, # G+11081  U+61CC  uni61CC,  CJK UNIFIED IDEOGRAPH-61CC
        0x61BA, # G+11082  U+61BA  uni61BA,  CJK UNIFIED IDEOGRAPH-61BA
        0x61BF, # G+11083  U+61BF  uni61BF,  CJK UNIFIED IDEOGRAPH-61BF
        0x61B8, # G+11084  U+61B8  uni61B8,  CJK UNIFIED IDEOGRAPH-61B8
        0x618C, # G+11085  U+618C  uni618C,  CJK UNIFIED IDEOGRAPH-618C
        0x64D7, # G+11086  U+64D7  uni64D7,  CJK UNIFIED IDEOGRAPH-64D7
        0x64D6, # G+11087  U+64D6  uni64D6,  CJK UNIFIED IDEOGRAPH-64D6
        0x64D0, # G+11088  U+64D0  uni64D0,  CJK UNIFIED IDEOGRAPH-64D0
        0x64CF, # G+11089  U+64CF  uni64CF,  CJK UNIFIED IDEOGRAPH-64CF
        0x64C9, # G+11090  U+64C9  uni64C9,  CJK UNIFIED IDEOGRAPH-64C9
        0x64BD, # G+11091  U+64BD  uni64BD,  CJK UNIFIED IDEOGRAPH-64BD
        0x6489, # G+11092  U+6489  uni6489,  CJK UNIFIED IDEOGRAPH-6489
        0x64C3, # G+11093  U+64C3  uni64C3,  CJK UNIFIED IDEOGRAPH-64C3
        0x64DB, # G+11094  U+64DB  uni64DB,  CJK UNIFIED IDEOGRAPH-64DB
        0x64F3, # G+11095  U+64F3  uni64F3,  CJK UNIFIED IDEOGRAPH-64F3
        0x64D9, # G+11096  U+64D9  uni64D9,  CJK UNIFIED IDEOGRAPH-64D9
        0x6533, # G+11097  U+6533  uni6533,  CJK UNIFIED IDEOGRAPH-6533
        0x657F, # G+11098  U+657F  uni657F,  CJK UNIFIED IDEOGRAPH-657F
        0x657C, # G+11099  U+657C  uni657C,  CJK UNIFIED IDEOGRAPH-657C
        0x65A2, # G+11100  U+65A2  uni65A2,  CJK UNIFIED IDEOGRAPH-65A2
        0x66C8, # G+11101  U+66C8  uni66C8,  CJK UNIFIED IDEOGRAPH-66C8
        0x66BE, # G+11102  U+66BE  uni66BE,  CJK UNIFIED IDEOGRAPH-66BE
        0x66C0, # G+11103  U+66C0  uni66C0,  CJK UNIFIED IDEOGRAPH-66C0
        0x66CA, # G+11104  U+66CA  uni66CA,  CJK UNIFIED IDEOGRAPH-66CA
        0x66CB, # G+11105  U+66CB  uni66CB,  CJK UNIFIED IDEOGRAPH-66CB
        0x66CF, # G+11106  U+66CF  uni66CF,  CJK UNIFIED IDEOGRAPH-66CF
        0x66BD, # G+11107  U+66BD  uni66BD,  CJK UNIFIED IDEOGRAPH-66BD
        0x66BB, # G+11108  U+66BB  uni66BB,  CJK UNIFIED IDEOGRAPH-66BB
        0x66BA, # G+11109  U+66BA  uni66BA,  CJK UNIFIED IDEOGRAPH-66BA
        0x66CC, # G+11110  U+66CC  uni66CC,  CJK UNIFIED IDEOGRAPH-66CC
        0x6723, # G+11111  U+6723  uni6723,  CJK UNIFIED IDEOGRAPH-6723
        0x6A34, # G+11112  U+6A34  uni6A34,  CJK UNIFIED IDEOGRAPH-6A34
        0x6A66, # G+11113  U+6A66  uni6A66,  CJK UNIFIED IDEOGRAPH-6A66
        0x6A49, # G+11114  U+6A49  uni6A49,  CJK UNIFIED IDEOGRAPH-6A49
        0x6A67, # G+11115  U+6A67  uni6A67,  CJK UNIFIED IDEOGRAPH-6A67
        0x6A32, # G+11116  U+6A32  uni6A32,  CJK UNIFIED IDEOGRAPH-6A32
        0x6A68, # G+11117  U+6A68  uni6A68,  CJK UNIFIED IDEOGRAPH-6A68
        0x6A3E, # G+11118  U+6A3E  uni6A3E,  CJK UNIFIED IDEOGRAPH-6A3E
        0x6A5D, # G+11119  U+6A5D  uni6A5D,  CJK UNIFIED IDEOGRAPH-6A5D
        0x6A6D, # G+11120  U+6A6D  uni6A6D,  CJK UNIFIED IDEOGRAPH-6A6D
        0x6A76, # G+11121  U+6A76  uni6A76,  CJK UNIFIED IDEOGRAPH-6A76
        0x6A5B, # G+11122  U+6A5B  uni6A5B,  CJK UNIFIED IDEOGRAPH-6A5B
        0x6A51, # G+11123  U+6A51  uni6A51,  CJK UNIFIED IDEOGRAPH-6A51
        0x6A28, # G+11124  U+6A28  uni6A28,  CJK UNIFIED IDEOGRAPH-6A28
        0x6A5A, # G+11125  U+6A5A  uni6A5A,  CJK UNIFIED IDEOGRAPH-6A5A
        0x6A3B, # G+11126  U+6A3B  uni6A3B,  CJK UNIFIED IDEOGRAPH-6A3B
        0x6A3F, # G+11127  U+6A3F  uni6A3F,  CJK UNIFIED IDEOGRAPH-6A3F
        0x6A41, # G+11128  U+6A41  uni6A41,  CJK UNIFIED IDEOGRAPH-6A41
        0x6A6A, # G+11129  U+6A6A  uni6A6A,  CJK UNIFIED IDEOGRAPH-6A6A
        0x6A64, # G+11130  U+6A64  uni6A64,  CJK UNIFIED IDEOGRAPH-6A64
        0x6A50, # G+11131  U+6A50  uni6A50,  CJK UNIFIED IDEOGRAPH-6A50
        0x6A4F, # G+11132  U+6A4F  uni6A4F,  CJK UNIFIED IDEOGRAPH-6A4F
        0x6A54, # G+11133  U+6A54  uni6A54,  CJK UNIFIED IDEOGRAPH-6A54
        0x6A6F, # G+11134  U+6A6F  uni6A6F,  CJK UNIFIED IDEOGRAPH-6A6F
        0x6A69, # G+11135  U+6A69  uni6A69,  CJK UNIFIED IDEOGRAPH-6A69
        0x6A60, # G+11136  U+6A60  uni6A60,  CJK UNIFIED IDEOGRAPH-6A60
        0x6A3C, # G+11137  U+6A3C  uni6A3C,  CJK UNIFIED IDEOGRAPH-6A3C
        0x6A5E, # G+11138  U+6A5E  uni6A5E,  CJK UNIFIED IDEOGRAPH-6A5E
        0x6A56, # G+11139  U+6A56  uni6A56,  CJK UNIFIED IDEOGRAPH-6A56
        0x6A55, # G+11140  U+6A55  uni6A55,  CJK UNIFIED IDEOGRAPH-6A55
        0x6A4D, # G+11141  U+6A4D  uni6A4D,  CJK UNIFIED IDEOGRAPH-6A4D
        0x6A4E, # G+11142  U+6A4E  uni6A4E,  CJK UNIFIED IDEOGRAPH-6A4E
        0x6A46, # G+11143  U+6A46  uni6A46,  CJK UNIFIED IDEOGRAPH-6A46
        0x6B55, # G+11144  U+6B55  uni6B55,  CJK UNIFIED IDEOGRAPH-6B55
        0x6B54, # G+11145  U+6B54  uni6B54,  CJK UNIFIED IDEOGRAPH-6B54
        0x6B56, # G+11146  U+6B56  uni6B56,  CJK UNIFIED IDEOGRAPH-6B56
        0x6BA7, # G+11147  U+6BA7  uni6BA7,  CJK UNIFIED IDEOGRAPH-6BA7
        0x6BAA, # G+11148  U+6BAA  uni6BAA,  CJK UNIFIED IDEOGRAPH-6BAA
        0x6BAB, # G+11149  U+6BAB  uni6BAB,  CJK UNIFIED IDEOGRAPH-6BAB
        0x6BC8, # G+11150  U+6BC8  uni6BC8,  CJK UNIFIED IDEOGRAPH-6BC8
        0x6BC7, # G+11151  U+6BC7  uni6BC7,  CJK UNIFIED IDEOGRAPH-6BC7
        0x6C04, # G+11152  U+6C04  uni6C04,  CJK UNIFIED IDEOGRAPH-6C04
        0x6C03, # G+11153  U+6C03  uni6C03,  CJK UNIFIED IDEOGRAPH-6C03
        0x6C06, # G+11154  U+6C06  uni6C06,  CJK UNIFIED IDEOGRAPH-6C06
        0x6FAD, # G+11155  U+6FAD  uni6FAD,  CJK UNIFIED IDEOGRAPH-6FAD
        0x6FCB, # G+11156  U+6FCB  uni6FCB,  CJK UNIFIED IDEOGRAPH-6FCB
        0x6FA3, # G+11157  U+6FA3  uni6FA3,  CJK UNIFIED IDEOGRAPH-6FA3
        0x6FC7, # G+11158  U+6FC7  uni6FC7,  CJK UNIFIED IDEOGRAPH-6FC7
        0x6FBC, # G+11159  U+6FBC  uni6FBC,  CJK UNIFIED IDEOGRAPH-6FBC
        0x6FCE, # G+11160  U+6FCE  uni6FCE,  CJK UNIFIED IDEOGRAPH-6FCE
        0x6FC8, # G+11161  U+6FC8  uni6FC8,  CJK UNIFIED IDEOGRAPH-6FC8
        0x6F5E, # G+11162  U+6F5E  uni6F5E,  CJK UNIFIED IDEOGRAPH-6F5E
        0x6FC4, # G+11163  U+6FC4  uni6FC4,  CJK UNIFIED IDEOGRAPH-6FC4
        0x6FBD, # G+11164  U+6FBD  uni6FBD,  CJK UNIFIED IDEOGRAPH-6FBD
        0x6F9E, # G+11165  U+6F9E  uni6F9E,  CJK UNIFIED IDEOGRAPH-6F9E
        0x6FCA, # G+11166  U+6FCA  uni6FCA,  CJK UNIFIED IDEOGRAPH-6FCA
        0x6FA8, # G+11167  U+6FA8  uni6FA8,  CJK UNIFIED IDEOGRAPH-6FA8
        0x7004, # G+11168  U+7004  uni7004,  CJK UNIFIED IDEOGRAPH-7004
        0x6FA5, # G+11169  U+6FA5  uni6FA5,  CJK UNIFIED IDEOGRAPH-6FA5
        0x6FAE, # G+11170  U+6FAE  uni6FAE,  CJK UNIFIED IDEOGRAPH-6FAE
        0x6FBA, # G+11171  U+6FBA  uni6FBA,  CJK UNIFIED IDEOGRAPH-6FBA
        0x6FAC, # G+11172  U+6FAC  uni6FAC,  CJK UNIFIED IDEOGRAPH-6FAC
        0x6FAA, # G+11173  U+6FAA  uni6FAA,  CJK UNIFIED IDEOGRAPH-6FAA
        0x6FCF, # G+11174  U+6FCF  uni6FCF,  CJK UNIFIED IDEOGRAPH-6FCF
        0x6FBF, # G+11175  U+6FBF  uni6FBF,  CJK UNIFIED IDEOGRAPH-6FBF
        0x6FB8, # G+11176  U+6FB8  uni6FB8,  CJK UNIFIED IDEOGRAPH-6FB8
        0x6FA2, # G+11177  U+6FA2  uni6FA2,  CJK UNIFIED IDEOGRAPH-6FA2
        0x6FC9, # G+11178  U+6FC9  uni6FC9,  CJK UNIFIED IDEOGRAPH-6FC9
        0x6FAB, # G+11179  U+6FAB  uni6FAB,  CJK UNIFIED IDEOGRAPH-6FAB
        0x6FCD, # G+11180  U+6FCD  uni6FCD,  CJK UNIFIED IDEOGRAPH-6FCD
        0x6FAF, # G+11181  U+6FAF  uni6FAF,  CJK UNIFIED IDEOGRAPH-6FAF
        0x6FB2, # G+11182  U+6FB2  uni6FB2,  CJK UNIFIED IDEOGRAPH-6FB2
        0x6FB0, # G+11183  U+6FB0  uni6FB0,  CJK UNIFIED IDEOGRAPH-6FB0
        0x71C5, # G+11184  U+71C5  uni71C5,  CJK UNIFIED IDEOGRAPH-71C5
        0x71C2, # G+11185  U+71C2  uni71C2,  CJK UNIFIED IDEOGRAPH-71C2
        0x71BF, # G+11186  U+71BF  uni71BF,  CJK UNIFIED IDEOGRAPH-71BF
        0x71B8, # G+11187  U+71B8  uni71B8,  CJK UNIFIED IDEOGRAPH-71B8
        0x71D6, # G+11188  U+71D6  uni71D6,  CJK UNIFIED IDEOGRAPH-71D6
        0x71C0, # G+11189  U+71C0  uni71C0,  CJK UNIFIED IDEOGRAPH-71C0
        0x71C1, # G+11190  U+71C1  uni71C1,  CJK UNIFIED IDEOGRAPH-71C1
        0x71CB, # G+11191  U+71CB  uni71CB,  CJK UNIFIED IDEOGRAPH-71CB
        0x71D4, # G+11192  U+71D4  uni71D4,  CJK UNIFIED IDEOGRAPH-71D4
        0x71CA, # G+11193  U+71CA  uni71CA,  CJK UNIFIED IDEOGRAPH-71CA
        0x71C7, # G+11194  U+71C7  uni71C7,  CJK UNIFIED IDEOGRAPH-71C7
        0x71CF, # G+11195  U+71CF  uni71CF,  CJK UNIFIED IDEOGRAPH-71CF
        0x71BD, # G+11196  U+71BD  uni71BD,  CJK UNIFIED IDEOGRAPH-71BD
        0x71D8, # G+11197  U+71D8  uni71D8,  CJK UNIFIED IDEOGRAPH-71D8
        0x71BC, # G+11198  U+71BC  uni71BC,  CJK UNIFIED IDEOGRAPH-71BC
        0x71C6, # G+11199  U+71C6  uni71C6,  CJK UNIFIED IDEOGRAPH-71C6
        0x71DA, # G+11200  U+71DA  uni71DA,  CJK UNIFIED IDEOGRAPH-71DA
        0x71DB, # G+11201  U+71DB  uni71DB,  CJK UNIFIED IDEOGRAPH-71DB
        0x729D, # G+11202  U+729D  uni729D,  CJK UNIFIED IDEOGRAPH-729D
        0x729E, # G+11203  U+729E  uni729E,  CJK UNIFIED IDEOGRAPH-729E
        0x7369, # G+11204  U+7369  uni7369,  CJK UNIFIED IDEOGRAPH-7369
        0x7366, # G+11205  U+7366  uni7366,  CJK UNIFIED IDEOGRAPH-7366
        0x7367, # G+11206  U+7367  uni7367,  CJK UNIFIED IDEOGRAPH-7367
        0x736C, # G+11207  U+736C  uni736C,  CJK UNIFIED IDEOGRAPH-736C
        0x7365, # G+11208  U+7365  uni7365,  CJK UNIFIED IDEOGRAPH-7365
        0x736B, # G+11209  U+736B  uni736B,  CJK UNIFIED IDEOGRAPH-736B
        0x736A, # G+11210  U+736A  uni736A,  CJK UNIFIED IDEOGRAPH-736A
        0x747F, # G+11211  U+747F  uni747F,  CJK UNIFIED IDEOGRAPH-747F
        0x749A, # G+11212  U+749A  uni749A,  CJK UNIFIED IDEOGRAPH-749A
        0x74A0, # G+11213  U+74A0  uni74A0,  CJK UNIFIED IDEOGRAPH-74A0
        0x7494, # G+11214  U+7494  uni7494,  CJK UNIFIED IDEOGRAPH-7494
        0x7492, # G+11215  U+7492  uni7492,  CJK UNIFIED IDEOGRAPH-7492
        0x7495, # G+11216  U+7495  uni7495,  CJK UNIFIED IDEOGRAPH-7495
        0x74A1, # G+11217  U+74A1  uni74A1,  CJK UNIFIED IDEOGRAPH-74A1
        0x750B, # G+11218  U+750B  uni750B,  CJK UNIFIED IDEOGRAPH-750B
        0x7580, # G+11219  U+7580  uni7580,  CJK UNIFIED IDEOGRAPH-7580
        0x762F, # G+11220  U+762F  uni762F,  CJK UNIFIED IDEOGRAPH-762F
        0x762D, # G+11221  U+762D  uni762D,  CJK UNIFIED IDEOGRAPH-762D
        0x7631, # G+11222  U+7631  uni7631,  CJK UNIFIED IDEOGRAPH-7631
        0x763D, # G+11223  U+763D  uni763D,  CJK UNIFIED IDEOGRAPH-763D
        0x7633, # G+11224  U+7633  uni7633,  CJK UNIFIED IDEOGRAPH-7633
        0x763C, # G+11225  U+763C  uni763C,  CJK UNIFIED IDEOGRAPH-763C
        0x7635, # G+11226  U+7635  uni7635,  CJK UNIFIED IDEOGRAPH-7635
        0x7632, # G+11227  U+7632  uni7632,  CJK UNIFIED IDEOGRAPH-7632
        0x7630, # G+11228  U+7630  uni7630,  CJK UNIFIED IDEOGRAPH-7630
        0x76BB, # G+11229  U+76BB  uni76BB,  CJK UNIFIED IDEOGRAPH-76BB
        0x76E6, # G+11230  U+76E6  uni76E6,  CJK UNIFIED IDEOGRAPH-76E6
        0x779A, # G+11231  U+779A  uni779A,  CJK UNIFIED IDEOGRAPH-779A
        0x779D, # G+11232  U+779D  uni779D,  CJK UNIFIED IDEOGRAPH-779D
        0x77A1, # G+11233  U+77A1  uni77A1,  CJK UNIFIED IDEOGRAPH-77A1
        0x779C, # G+11234  U+779C  uni779C,  CJK UNIFIED IDEOGRAPH-779C
        0x779B, # G+11235  U+779B  uni779B,  CJK UNIFIED IDEOGRAPH-779B
        0x77A2, # G+11236  U+77A2  uni77A2,  CJK UNIFIED IDEOGRAPH-77A2
        0x77A3, # G+11237  U+77A3  uni77A3,  CJK UNIFIED IDEOGRAPH-77A3
        0x7795, # G+11238  U+7795  uni7795,  CJK UNIFIED IDEOGRAPH-7795
        0x7799, # G+11239  U+7799  uni7799,  CJK UNIFIED IDEOGRAPH-7799
        0x7797, # G+11240  U+7797  uni7797,  CJK UNIFIED IDEOGRAPH-7797
        0x78DD, # G+11241  U+78DD  uni78DD,  CJK UNIFIED IDEOGRAPH-78DD
        0x78E9, # G+11242  U+78E9  uni78E9,  CJK UNIFIED IDEOGRAPH-78E9
        0x78E5, # G+11243  U+78E5  uni78E5,  CJK UNIFIED IDEOGRAPH-78E5
        0x78EA, # G+11244  U+78EA  uni78EA,  CJK UNIFIED IDEOGRAPH-78EA
        0x78DE, # G+11245  U+78DE  uni78DE,  CJK UNIFIED IDEOGRAPH-78DE
        0x78E3, # G+11246  U+78E3  uni78E3,  CJK UNIFIED IDEOGRAPH-78E3
        0x78DB, # G+11247  U+78DB  uni78DB,  CJK UNIFIED IDEOGRAPH-78DB
        0x78E1, # G+11248  U+78E1  uni78E1,  CJK UNIFIED IDEOGRAPH-78E1
        0x78E2, # G+11249  U+78E2  uni78E2,  CJK UNIFIED IDEOGRAPH-78E2
        0x78ED, # G+11250  U+78ED  uni78ED,  CJK UNIFIED IDEOGRAPH-78ED
        0x78DF, # G+11251  U+78DF  uni78DF,  CJK UNIFIED IDEOGRAPH-78DF
        0x78E0, # G+11252  U+78E0  uni78E0,  CJK UNIFIED IDEOGRAPH-78E0
        0x79A4, # G+11253  U+79A4  uni79A4,  CJK UNIFIED IDEOGRAPH-79A4
        0x7A44, # G+11254  U+7A44  uni7A44,  CJK UNIFIED IDEOGRAPH-7A44
        0x7A48, # G+11255  U+7A48  uni7A48,  CJK UNIFIED IDEOGRAPH-7A48
        0x7A47, # G+11256  U+7A47  uni7A47,  CJK UNIFIED IDEOGRAPH-7A47
        0x7AB6, # G+11257  U+7AB6  uni7AB6,  CJK UNIFIED IDEOGRAPH-7AB6
        0x7AB8, # G+11258  U+7AB8  uni7AB8,  CJK UNIFIED IDEOGRAPH-7AB8
        0x7AB5, # G+11259  U+7AB5  uni7AB5,  CJK UNIFIED IDEOGRAPH-7AB5
        0x7AB1, # G+11260  U+7AB1  uni7AB1,  CJK UNIFIED IDEOGRAPH-7AB1
        0x7AB7, # G+11261  U+7AB7  uni7AB7,  CJK UNIFIED IDEOGRAPH-7AB7
        0x7BDE, # G+11262  U+7BDE  uni7BDE,  CJK UNIFIED IDEOGRAPH-7BDE
        0x7BE3, # G+11263  U+7BE3  uni7BE3,  CJK UNIFIED IDEOGRAPH-7BE3
        0x7BE7, # G+11264  U+7BE7  uni7BE7,  CJK UNIFIED IDEOGRAPH-7BE7
        0x7BDD, # G+11265  U+7BDD  uni7BDD,  CJK UNIFIED IDEOGRAPH-7BDD
        0x7BD5, # G+11266  U+7BD5  uni7BD5,  CJK UNIFIED IDEOGRAPH-7BD5
        0x7BE5, # G+11267  U+7BE5  uni7BE5,  CJK UNIFIED IDEOGRAPH-7BE5
        0x7BDA, # G+11268  U+7BDA  uni7BDA,  CJK UNIFIED IDEOGRAPH-7BDA
        0x7BE8, # G+11269  U+7BE8  uni7BE8,  CJK UNIFIED IDEOGRAPH-7BE8
        0x7BF9, # G+11270  U+7BF9  uni7BF9,  CJK UNIFIED IDEOGRAPH-7BF9
        0x7BD4, # G+11271  U+7BD4  uni7BD4,  CJK UNIFIED IDEOGRAPH-7BD4
        0x7BEA, # G+11272  U+7BEA  uni7BEA,  CJK UNIFIED IDEOGRAPH-7BEA
        0x7BE2, # G+11273  U+7BE2  uni7BE2,  CJK UNIFIED IDEOGRAPH-7BE2
        0x7BDC, # G+11274  U+7BDC  uni7BDC,  CJK UNIFIED IDEOGRAPH-7BDC
        0x7BEB, # G+11275  U+7BEB  uni7BEB,  CJK UNIFIED IDEOGRAPH-7BEB
        0x7BD8, # G+11276  U+7BD8  uni7BD8,  CJK UNIFIED IDEOGRAPH-7BD8
        0x7BDF, # G+11277  U+7BDF  uni7BDF,  CJK UNIFIED IDEOGRAPH-7BDF
        0x7CD2, # G+11278  U+7CD2  uni7CD2,  CJK UNIFIED IDEOGRAPH-7CD2
        0x7CD4, # G+11279  U+7CD4  uni7CD4,  CJK UNIFIED IDEOGRAPH-7CD4
        0x7CD7, # G+11280  U+7CD7  uni7CD7,  CJK UNIFIED IDEOGRAPH-7CD7
        0x7CD0, # G+11281  U+7CD0  uni7CD0,  CJK UNIFIED IDEOGRAPH-7CD0
        0x7CD1, # G+11282  U+7CD1  uni7CD1,  CJK UNIFIED IDEOGRAPH-7CD1
        0x7E12, # G+11283  U+7E12  uni7E12,  CJK UNIFIED IDEOGRAPH-7E12
        0x7E21, # G+11284  U+7E21  uni7E21,  CJK UNIFIED IDEOGRAPH-7E21
        0x7E17, # G+11285  U+7E17  uni7E17,  CJK UNIFIED IDEOGRAPH-7E17
        0x7E0C, # G+11286  U+7E0C  uni7E0C,  CJK UNIFIED IDEOGRAPH-7E0C
        0x7E1F, # G+11287  U+7E1F  uni7E1F,  CJK UNIFIED IDEOGRAPH-7E1F
        0x7E20, # G+11288  U+7E20  uni7E20,  CJK UNIFIED IDEOGRAPH-7E20
        0x7E13, # G+11289  U+7E13  uni7E13,  CJK UNIFIED IDEOGRAPH-7E13
        0x7E0E, # G+11290  U+7E0E  uni7E0E,  CJK UNIFIED IDEOGRAPH-7E0E
        0x7E1C, # G+11291  U+7E1C  uni7E1C,  CJK UNIFIED IDEOGRAPH-7E1C
        0x7E15, # G+11292  U+7E15  uni7E15,  CJK UNIFIED IDEOGRAPH-7E15
        0x7E1A, # G+11293  U+7E1A  uni7E1A,  CJK UNIFIED IDEOGRAPH-7E1A
        0x7E22, # G+11294  U+7E22  uni7E22,  CJK UNIFIED IDEOGRAPH-7E22
        0x7E0B, # G+11295  U+7E0B  uni7E0B,  CJK UNIFIED IDEOGRAPH-7E0B
        0x7E0F, # G+11296  U+7E0F  uni7E0F,  CJK UNIFIED IDEOGRAPH-7E0F
        0x7E16, # G+11297  U+7E16  uni7E16,  CJK UNIFIED IDEOGRAPH-7E16
        0x7E0D, # G+11298  U+7E0D  uni7E0D,  CJK UNIFIED IDEOGRAPH-7E0D
        0x7E14, # G+11299  U+7E14  uni7E14,  CJK UNIFIED IDEOGRAPH-7E14
        0x7E25, # G+11300  U+7E25  uni7E25,  CJK UNIFIED IDEOGRAPH-7E25
        0x7E24, # G+11301  U+7E24  uni7E24,  CJK UNIFIED IDEOGRAPH-7E24
        0x7F43, # G+11302  U+7F43  uni7F43,  CJK UNIFIED IDEOGRAPH-7F43
        0x7F7B, # G+11303  U+7F7B  uni7F7B,  CJK UNIFIED IDEOGRAPH-7F7B
        0x7F7C, # G+11304  U+7F7C  uni7F7C,  CJK UNIFIED IDEOGRAPH-7F7C
        0x7F7A, # G+11305  U+7F7A  uni7F7A,  CJK UNIFIED IDEOGRAPH-7F7A
        0x7FB1, # G+11306  U+7FB1  uni7FB1,  CJK UNIFIED IDEOGRAPH-7FB1
        0x7FEF, # G+11307  U+7FEF  uni7FEF,  CJK UNIFIED IDEOGRAPH-7FEF
        0x802A, # G+11308  U+802A  uni802A,  CJK UNIFIED IDEOGRAPH-802A
        0x8029, # G+11309  U+8029  uni8029,  CJK UNIFIED IDEOGRAPH-8029
        0x806C, # G+11310  U+806C  uni806C,  CJK UNIFIED IDEOGRAPH-806C
        0x81B1, # G+11311  U+81B1  uni81B1,  CJK UNIFIED IDEOGRAPH-81B1
        0x81A6, # G+11312  U+81A6  uni81A6,  CJK UNIFIED IDEOGRAPH-81A6
        0x81AE, # G+11313  U+81AE  uni81AE,  CJK UNIFIED IDEOGRAPH-81AE
        0x81B9, # G+11314  U+81B9  uni81B9,  CJK UNIFIED IDEOGRAPH-81B9
        0x81B5, # G+11315  U+81B5  uni81B5,  CJK UNIFIED IDEOGRAPH-81B5
        0x81AB, # G+11316  U+81AB  uni81AB,  CJK UNIFIED IDEOGRAPH-81AB
        0x81B0, # G+11317  U+81B0  uni81B0,  CJK UNIFIED IDEOGRAPH-81B0
        0x81AC, # G+11318  U+81AC  uni81AC,  CJK UNIFIED IDEOGRAPH-81AC
        0x81B4, # G+11319  U+81B4  uni81B4,  CJK UNIFIED IDEOGRAPH-81B4
        0x81B2, # G+11320  U+81B2  uni81B2,  CJK UNIFIED IDEOGRAPH-81B2
        0x81B7, # G+11321  U+81B7  uni81B7,  CJK UNIFIED IDEOGRAPH-81B7
        0x81A7, # G+11322  U+81A7  uni81A7,  CJK UNIFIED IDEOGRAPH-81A7
        0x81F2, # G+11323  U+81F2  uni81F2,  CJK UNIFIED IDEOGRAPH-81F2
        0x8255, # G+11324  U+8255  uni8255,  CJK UNIFIED IDEOGRAPH-8255
        0x8256, # G+11325  U+8256  uni8256,  CJK UNIFIED IDEOGRAPH-8256
        0x8257, # G+11326  U+8257  uni8257,  CJK UNIFIED IDEOGRAPH-8257
        0x8556, # G+11327  U+8556  uni8556,  CJK UNIFIED IDEOGRAPH-8556
        0x8545, # G+11328  U+8545  uni8545,  CJK UNIFIED IDEOGRAPH-8545
        0x856B, # G+11329  U+856B  uni856B,  CJK UNIFIED IDEOGRAPH-856B
        0x854D, # G+11330  U+854D  uni854D,  CJK UNIFIED IDEOGRAPH-854D
        0x8553, # G+11331  U+8553  uni8553,  CJK UNIFIED IDEOGRAPH-8553
        0x8561, # G+11332  U+8561  uni8561,  CJK UNIFIED IDEOGRAPH-8561
        0x8558, # G+11333  U+8558  uni8558,  CJK UNIFIED IDEOGRAPH-8558
        0x8540, # G+11334  U+8540  uni8540,  CJK UNIFIED IDEOGRAPH-8540
        0x8546, # G+11335  U+8546  uni8546,  CJK UNIFIED IDEOGRAPH-8546
        0x8564, # G+11336  U+8564  uni8564,  CJK UNIFIED IDEOGRAPH-8564
        0x8541, # G+11337  U+8541  uni8541,  CJK UNIFIED IDEOGRAPH-8541
        0x8562, # G+11338  U+8562  uni8562,  CJK UNIFIED IDEOGRAPH-8562
        0x8544, # G+11339  U+8544  uni8544,  CJK UNIFIED IDEOGRAPH-8544
        0x8551, # G+11340  U+8551  uni8551,  CJK UNIFIED IDEOGRAPH-8551
        0x8547, # G+11341  U+8547  uni8547,  CJK UNIFIED IDEOGRAPH-8547
        0x8563, # G+11342  U+8563  uni8563,  CJK UNIFIED IDEOGRAPH-8563
        0x853E, # G+11343  U+853E  uni853E,  CJK UNIFIED IDEOGRAPH-853E
        0x855B, # G+11344  U+855B  uni855B,  CJK UNIFIED IDEOGRAPH-855B
        0x8571, # G+11345  U+8571  uni8571,  CJK UNIFIED IDEOGRAPH-8571
        0x854E, # G+11346  U+854E  uni854E,  CJK UNIFIED IDEOGRAPH-854E
        0x856E, # G+11347  U+856E  uni856E,  CJK UNIFIED IDEOGRAPH-856E
        0x8575, # G+11348  U+8575  uni8575,  CJK UNIFIED IDEOGRAPH-8575
        0x8555, # G+11349  U+8555  uni8555,  CJK UNIFIED IDEOGRAPH-8555
        0x8567, # G+11350  U+8567  uni8567,  CJK UNIFIED IDEOGRAPH-8567
        0x8560, # G+11351  U+8560  uni8560,  CJK UNIFIED IDEOGRAPH-8560
        0x858C, # G+11352  U+858C  uni858C,  CJK UNIFIED IDEOGRAPH-858C
        0x8566, # G+11353  U+8566  uni8566,  CJK UNIFIED IDEOGRAPH-8566
        0x855D, # G+11354  U+855D  uni855D,  CJK UNIFIED IDEOGRAPH-855D
        0x8554, # G+11355  U+8554  uni8554,  CJK UNIFIED IDEOGRAPH-8554
        0x8565, # G+11356  U+8565  uni8565,  CJK UNIFIED IDEOGRAPH-8565
        0x856C, # G+11357  U+856C  uni856C,  CJK UNIFIED IDEOGRAPH-856C
        0x8663, # G+11358  U+8663  uni8663,  CJK UNIFIED IDEOGRAPH-8663
        0x8665, # G+11359  U+8665  uni8665,  CJK UNIFIED IDEOGRAPH-8665
        0x8664, # G+11360  U+8664  uni8664,  CJK UNIFIED IDEOGRAPH-8664
        0x87A4, # G+11361  U+87A4  uni87A4,  CJK UNIFIED IDEOGRAPH-87A4
        0x879B, # G+11362  U+879B  uni879B,  CJK UNIFIED IDEOGRAPH-879B
        0x878F, # G+11363  U+878F  uni878F,  CJK UNIFIED IDEOGRAPH-878F
        0x8797, # G+11364  U+8797  uni8797,  CJK UNIFIED IDEOGRAPH-8797
        0x8793, # G+11365  U+8793  uni8793,  CJK UNIFIED IDEOGRAPH-8793
        0x8792, # G+11366  U+8792  uni8792,  CJK UNIFIED IDEOGRAPH-8792
        0x8788, # G+11367  U+8788  uni8788,  CJK UNIFIED IDEOGRAPH-8788
        0x8781, # G+11368  U+8781  uni8781,  CJK UNIFIED IDEOGRAPH-8781
        0x8796, # G+11369  U+8796  uni8796,  CJK UNIFIED IDEOGRAPH-8796
        0x8798, # G+11370  U+8798  uni8798,  CJK UNIFIED IDEOGRAPH-8798
        0x8779, # G+11371  U+8779  uni8779,  CJK UNIFIED IDEOGRAPH-8779
        0x8787, # G+11372  U+8787  uni8787,  CJK UNIFIED IDEOGRAPH-8787
        0x87A3, # G+11373  U+87A3  uni87A3,  CJK UNIFIED IDEOGRAPH-87A3
        0x8785, # G+11374  U+8785  uni8785,  CJK UNIFIED IDEOGRAPH-8785
        0x8790, # G+11375  U+8790  uni8790,  CJK UNIFIED IDEOGRAPH-8790
        0x8791, # G+11376  U+8791  uni8791,  CJK UNIFIED IDEOGRAPH-8791
        0x879D, # G+11377  U+879D  uni879D,  CJK UNIFIED IDEOGRAPH-879D
        0x8784, # G+11378  U+8784  uni8784,  CJK UNIFIED IDEOGRAPH-8784
        0x8794, # G+11379  U+8794  uni8794,  CJK UNIFIED IDEOGRAPH-8794
        0x879C, # G+11380  U+879C  uni879C,  CJK UNIFIED IDEOGRAPH-879C
        0x879A, # G+11381  U+879A  uni879A,  CJK UNIFIED IDEOGRAPH-879A
        0x8789, # G+11382  U+8789  uni8789,  CJK UNIFIED IDEOGRAPH-8789
        0x891E, # G+11383  U+891E  uni891E,  CJK UNIFIED IDEOGRAPH-891E
        0x8926, # G+11384  U+8926  uni8926,  CJK UNIFIED IDEOGRAPH-8926
        0x8930, # G+11385  U+8930  uni8930,  CJK UNIFIED IDEOGRAPH-8930
        0x892D, # G+11386  U+892D  uni892D,  CJK UNIFIED IDEOGRAPH-892D
        0x892E, # G+11387  U+892E  uni892E,  CJK UNIFIED IDEOGRAPH-892E
        0x8927, # G+11388  U+8927  uni8927,  CJK UNIFIED IDEOGRAPH-8927
        0x8931, # G+11389  U+8931  uni8931,  CJK UNIFIED IDEOGRAPH-8931
        0x8922, # G+11390  U+8922  uni8922,  CJK UNIFIED IDEOGRAPH-8922
        0x8929, # G+11391  U+8929  uni8929,  CJK UNIFIED IDEOGRAPH-8929
        0x8923, # G+11392  U+8923  uni8923,  CJK UNIFIED IDEOGRAPH-8923
        0x892F, # G+11393  U+892F  uni892F,  CJK UNIFIED IDEOGRAPH-892F
        0x892C, # G+11394  U+892C  uni892C,  CJK UNIFIED IDEOGRAPH-892C
        0x891F, # G+11395  U+891F  uni891F,  CJK UNIFIED IDEOGRAPH-891F
        0x89F1, # G+11396  U+89F1  uni89F1,  CJK UNIFIED IDEOGRAPH-89F1
        0x8AE0, # G+11397  U+8AE0  uni8AE0,  CJK UNIFIED IDEOGRAPH-8AE0
        0x8AE2, # G+11398  U+8AE2  uni8AE2,  CJK UNIFIED IDEOGRAPH-8AE2
        0x8AF2, # G+11399  U+8AF2  uni8AF2,  CJK UNIFIED IDEOGRAPH-8AF2
        0x8AF4, # G+11400  U+8AF4  uni8AF4,  CJK UNIFIED IDEOGRAPH-8AF4
        0x8AF5, # G+11401  U+8AF5  uni8AF5,  CJK UNIFIED IDEOGRAPH-8AF5
        0x8ADD, # G+11402  U+8ADD  uni8ADD,  CJK UNIFIED IDEOGRAPH-8ADD
        0x8B14, # G+11403  U+8B14  uni8B14,  CJK UNIFIED IDEOGRAPH-8B14
        0x8AE4, # G+11404  U+8AE4  uni8AE4,  CJK UNIFIED IDEOGRAPH-8AE4
        0x8ADF, # G+11405  U+8ADF  uni8ADF,  CJK UNIFIED IDEOGRAPH-8ADF
        0x8AF0, # G+11406  U+8AF0  uni8AF0,  CJK UNIFIED IDEOGRAPH-8AF0
        0x8AC8, # G+11407  U+8AC8  uni8AC8,  CJK UNIFIED IDEOGRAPH-8AC8
        0x8ADE, # G+11408  U+8ADE  uni8ADE,  CJK UNIFIED IDEOGRAPH-8ADE
        0x8AE1, # G+11409  U+8AE1  uni8AE1,  CJK UNIFIED IDEOGRAPH-8AE1
        0x8AE8, # G+11410  U+8AE8  uni8AE8,  CJK UNIFIED IDEOGRAPH-8AE8
        0x8AFF, # G+11411  U+8AFF  uni8AFF,  CJK UNIFIED IDEOGRAPH-8AFF
        0x8AEF, # G+11412  U+8AEF  uni8AEF,  CJK UNIFIED IDEOGRAPH-8AEF
        0x8AFB, # G+11413  U+8AFB  uni8AFB,  CJK UNIFIED IDEOGRAPH-8AFB
        0x8C91, # G+11414  U+8C91  uni8C91,  CJK UNIFIED IDEOGRAPH-8C91
        0x8C92, # G+11415  U+8C92  uni8C92,  CJK UNIFIED IDEOGRAPH-8C92
        0x8C90, # G+11416  U+8C90  uni8C90,  CJK UNIFIED IDEOGRAPH-8C90
        0x8CF5, # G+11417  U+8CF5  uni8CF5,  CJK UNIFIED IDEOGRAPH-8CF5
        0x8CEE, # G+11418  U+8CEE  uni8CEE,  CJK UNIFIED IDEOGRAPH-8CEE
        0x8CF1, # G+11419  U+8CF1  uni8CF1,  CJK UNIFIED IDEOGRAPH-8CF1
        0x8CF0, # G+11420  U+8CF0  uni8CF0,  CJK UNIFIED IDEOGRAPH-8CF0
        0x8CF3, # G+11421  U+8CF3  uni8CF3,  CJK UNIFIED IDEOGRAPH-8CF3
        0x8D6C, # G+11422  U+8D6C  uni8D6C,  CJK UNIFIED IDEOGRAPH-8D6C
        0x8D6E, # G+11423  U+8D6E  uni8D6E,  CJK UNIFIED IDEOGRAPH-8D6E
        0x8DA5, # G+11424  U+8DA5  uni8DA5,  CJK UNIFIED IDEOGRAPH-8DA5
        0x8DA7, # G+11425  U+8DA7  uni8DA7,  CJK UNIFIED IDEOGRAPH-8DA7
        0x8E33, # G+11426  U+8E33  uni8E33,  CJK UNIFIED IDEOGRAPH-8E33
        0x8E3E, # G+11427  U+8E3E  uni8E3E,  CJK UNIFIED IDEOGRAPH-8E3E
        0x8E38, # G+11428  U+8E38  uni8E38,  CJK UNIFIED IDEOGRAPH-8E38
        0x8E40, # G+11429  U+8E40  uni8E40,  CJK UNIFIED IDEOGRAPH-8E40
        0x8E45, # G+11430  U+8E45  uni8E45,  CJK UNIFIED IDEOGRAPH-8E45
        0x8E36, # G+11431  U+8E36  uni8E36,  CJK UNIFIED IDEOGRAPH-8E36
        0x8E3C, # G+11432  U+8E3C  uni8E3C,  CJK UNIFIED IDEOGRAPH-8E3C
        0x8E3D, # G+11433  U+8E3D  uni8E3D,  CJK UNIFIED IDEOGRAPH-8E3D
        0x8E41, # G+11434  U+8E41  uni8E41,  CJK UNIFIED IDEOGRAPH-8E41
        0x8E30, # G+11435  U+8E30  uni8E30,  CJK UNIFIED IDEOGRAPH-8E30
        0x8E3F, # G+11436  U+8E3F  uni8E3F,  CJK UNIFIED IDEOGRAPH-8E3F
        0x8EBD, # G+11437  U+8EBD  uni8EBD,  CJK UNIFIED IDEOGRAPH-8EBD
        0x8F36, # G+11438  U+8F36  uni8F36,  CJK UNIFIED IDEOGRAPH-8F36
        0x8F2E, # G+11439  U+8F2E  uni8F2E,  CJK UNIFIED IDEOGRAPH-8F2E
        0x8F35, # G+11440  U+8F35  uni8F35,  CJK UNIFIED IDEOGRAPH-8F35
        0x8F32, # G+11441  U+8F32  uni8F32,  CJK UNIFIED IDEOGRAPH-8F32
        0x8F39, # G+11442  U+8F39  uni8F39,  CJK UNIFIED IDEOGRAPH-8F39
        0x8F37, # G+11443  U+8F37  uni8F37,  CJK UNIFIED IDEOGRAPH-8F37
        0x8F34, # G+11444  U+8F34  uni8F34,  CJK UNIFIED IDEOGRAPH-8F34
        0x9076, # G+11445  U+9076  uni9076,  CJK UNIFIED IDEOGRAPH-9076
        0x9079, # G+11446  U+9079  uni9079,  CJK UNIFIED IDEOGRAPH-9079
        0x907B, # G+11447  U+907B  uni907B,  CJK UNIFIED IDEOGRAPH-907B
        0x9086, # G+11448  U+9086  uni9086,  CJK UNIFIED IDEOGRAPH-9086
        0x90FA, # G+11449  U+90FA  uni90FA,  CJK UNIFIED IDEOGRAPH-90FA
        0x9133, # G+11450  U+9133  uni9133,  CJK UNIFIED IDEOGRAPH-9133
        0x9135, # G+11451  U+9135  uni9135,  CJK UNIFIED IDEOGRAPH-9135
        0x9136, # G+11452  U+9136  uni9136,  CJK UNIFIED IDEOGRAPH-9136
        0x9193, # G+11453  U+9193  uni9193,  CJK UNIFIED IDEOGRAPH-9193
        0x9190, # G+11454  U+9190  uni9190,  CJK UNIFIED IDEOGRAPH-9190
        0x9191, # G+11455  U+9191  uni9191,  CJK UNIFIED IDEOGRAPH-9191
        0x918D, # G+11456  U+918D  uni918D,  CJK UNIFIED IDEOGRAPH-918D
        0x918F, # G+11457  U+918F  uni918F,  CJK UNIFIED IDEOGRAPH-918F
        0x9327, # G+11458  U+9327  uni9327,  CJK UNIFIED IDEOGRAPH-9327
        0x931E, # G+11459  U+931E  uni931E,  CJK UNIFIED IDEOGRAPH-931E
        0x9308, # G+11460  U+9308  uni9308,  CJK UNIFIED IDEOGRAPH-9308
        0x931F, # G+11461  U+931F  uni931F,  CJK UNIFIED IDEOGRAPH-931F
        0x9306, # G+11462  U+9306  uni9306,  CJK UNIFIED IDEOGRAPH-9306
        0x930F, # G+11463  U+930F  uni930F,  CJK UNIFIED IDEOGRAPH-930F
        0x937A, # G+11464  U+937A  uni937A,  CJK UNIFIED IDEOGRAPH-937A
        0x9338, # G+11465  U+9338  uni9338,  CJK UNIFIED IDEOGRAPH-9338
        0x933C, # G+11466  U+933C  uni933C,  CJK UNIFIED IDEOGRAPH-933C
        0x931B, # G+11467  U+931B  uni931B,  CJK UNIFIED IDEOGRAPH-931B
        0x9323, # G+11468  U+9323  uni9323,  CJK UNIFIED IDEOGRAPH-9323
        0x9312, # G+11469  U+9312  uni9312,  CJK UNIFIED IDEOGRAPH-9312
        0x9301, # G+11470  U+9301  uni9301,  CJK UNIFIED IDEOGRAPH-9301
        0x9346, # G+11471  U+9346  uni9346,  CJK UNIFIED IDEOGRAPH-9346
        0x932D, # G+11472  U+932D  uni932D,  CJK UNIFIED IDEOGRAPH-932D
        0x930E, # G+11473  U+930E  uni930E,  CJK UNIFIED IDEOGRAPH-930E
        0x930D, # G+11474  U+930D  uni930D,  CJK UNIFIED IDEOGRAPH-930D
        0x92CB, # G+11475  U+92CB  uni92CB,  CJK UNIFIED IDEOGRAPH-92CB
        0x931D, # G+11476  U+931D  uni931D,  CJK UNIFIED IDEOGRAPH-931D
        0x92FA, # G+11477  U+92FA  uni92FA,  CJK UNIFIED IDEOGRAPH-92FA
        0x9313, # G+11478  U+9313  uni9313,  CJK UNIFIED IDEOGRAPH-9313
        0x92F9, # G+11479  U+92F9  uni92F9,  CJK UNIFIED IDEOGRAPH-92F9
        0x92F7, # G+11480  U+92F7  uni92F7,  CJK UNIFIED IDEOGRAPH-92F7
        0x9334, # G+11481  U+9334  uni9334,  CJK UNIFIED IDEOGRAPH-9334
        0x9302, # G+11482  U+9302  uni9302,  CJK UNIFIED IDEOGRAPH-9302
        0x9324, # G+11483  U+9324  uni9324,  CJK UNIFIED IDEOGRAPH-9324
        0x92FF, # G+11484  U+92FF  uni92FF,  CJK UNIFIED IDEOGRAPH-92FF
        0x9329, # G+11485  U+9329  uni9329,  CJK UNIFIED IDEOGRAPH-9329
        0x9339, # G+11486  U+9339  uni9339,  CJK UNIFIED IDEOGRAPH-9339
        0x9335, # G+11487  U+9335  uni9335,  CJK UNIFIED IDEOGRAPH-9335
        0x932A, # G+11488  U+932A  uni932A,  CJK UNIFIED IDEOGRAPH-932A
        0x9314, # G+11489  U+9314  uni9314,  CJK UNIFIED IDEOGRAPH-9314
        0x930C, # G+11490  U+930C  uni930C,  CJK UNIFIED IDEOGRAPH-930C
        0x930B, # G+11491  U+930B  uni930B,  CJK UNIFIED IDEOGRAPH-930B
        0x92FE, # G+11492  U+92FE  uni92FE,  CJK UNIFIED IDEOGRAPH-92FE
        0x9309, # G+11493  U+9309  uni9309,  CJK UNIFIED IDEOGRAPH-9309
        0x9300, # G+11494  U+9300  uni9300,  CJK UNIFIED IDEOGRAPH-9300
        0x92FB, # G+11495  U+92FB  uni92FB,  CJK UNIFIED IDEOGRAPH-92FB
        0x9316, # G+11496  U+9316  uni9316,  CJK UNIFIED IDEOGRAPH-9316
        0x95BC, # G+11497  U+95BC  uni95BC,  CJK UNIFIED IDEOGRAPH-95BC
        0x95CD, # G+11498  U+95CD  uni95CD,  CJK UNIFIED IDEOGRAPH-95CD
        0x95BE, # G+11499  U+95BE  uni95BE,  CJK UNIFIED IDEOGRAPH-95BE
        0x95B9, # G+11500  U+95B9  uni95B9,  CJK UNIFIED IDEOGRAPH-95B9
        0x95BA, # G+11501  U+95BA  uni95BA,  CJK UNIFIED IDEOGRAPH-95BA
        0x95B6, # G+11502  U+95B6  uni95B6,  CJK UNIFIED IDEOGRAPH-95B6
        0x95BF, # G+11503  U+95BF  uni95BF,  CJK UNIFIED IDEOGRAPH-95BF
        0x95B5, # G+11504  U+95B5  uni95B5,  CJK UNIFIED IDEOGRAPH-95B5
        0x95BD, # G+11505  U+95BD  uni95BD,  CJK UNIFIED IDEOGRAPH-95BD
        0x96A9, # G+11506  U+96A9  uni96A9,  CJK UNIFIED IDEOGRAPH-96A9
        0x96D4, # G+11507  U+96D4  uni96D4,  CJK UNIFIED IDEOGRAPH-96D4
        0x970B, # G+11508  U+970B  uni970B,  CJK UNIFIED IDEOGRAPH-970B
        0x9712, # G+11509  U+9712  uni9712,  CJK UNIFIED IDEOGRAPH-9712
        0x9710, # G+11510  U+9710  uni9710,  CJK UNIFIED IDEOGRAPH-9710
        0x9799, # G+11511  U+9799  uni9799,  CJK UNIFIED IDEOGRAPH-9799
        0x9797, # G+11512  U+9797  uni9797,  CJK UNIFIED IDEOGRAPH-9797
        0x9794, # G+11513  U+9794  uni9794,  CJK UNIFIED IDEOGRAPH-9794
        0x97F0, # G+11514  U+97F0  uni97F0,  CJK UNIFIED IDEOGRAPH-97F0
        0x97F8, # G+11515  U+97F8  uni97F8,  CJK UNIFIED IDEOGRAPH-97F8
        0x9835, # G+11516  U+9835  uni9835,  CJK UNIFIED IDEOGRAPH-9835
        0x982F, # G+11517  U+982F  uni982F,  CJK UNIFIED IDEOGRAPH-982F
        0x9832, # G+11518  U+9832  uni9832,  CJK UNIFIED IDEOGRAPH-9832
        0x9924, # G+11519  U+9924  uni9924,  CJK UNIFIED IDEOGRAPH-9924
        0x991F, # G+11520  U+991F  uni991F,  CJK UNIFIED IDEOGRAPH-991F
        0x9927, # G+11521  U+9927  uni9927,  CJK UNIFIED IDEOGRAPH-9927
        0x9929, # G+11522  U+9929  uni9929,  CJK UNIFIED IDEOGRAPH-9929
        0x999E, # G+11523  U+999E  uni999E,  CJK UNIFIED IDEOGRAPH-999E
        0x99EE, # G+11524  U+99EE  uni99EE,  CJK UNIFIED IDEOGRAPH-99EE
        0x99EC, # G+11525  U+99EC  uni99EC,  CJK UNIFIED IDEOGRAPH-99EC
        0x99E5, # G+11526  U+99E5  uni99E5,  CJK UNIFIED IDEOGRAPH-99E5
        0x99E4, # G+11527  U+99E4  uni99E4,  CJK UNIFIED IDEOGRAPH-99E4
        0x99F0, # G+11528  U+99F0  uni99F0,  CJK UNIFIED IDEOGRAPH-99F0
        0x99E3, # G+11529  U+99E3  uni99E3,  CJK UNIFIED IDEOGRAPH-99E3
        0x99EA, # G+11530  U+99EA  uni99EA,  CJK UNIFIED IDEOGRAPH-99EA
        0x99E9, # G+11531  U+99E9  uni99E9,  CJK UNIFIED IDEOGRAPH-99E9
        0x99E7, # G+11532  U+99E7  uni99E7,  CJK UNIFIED IDEOGRAPH-99E7
        0x9AB9, # G+11533  U+9AB9  uni9AB9,  CJK UNIFIED IDEOGRAPH-9AB9
        0x9ABF, # G+11534  U+9ABF  uni9ABF,  CJK UNIFIED IDEOGRAPH-9ABF
        0x9AB4, # G+11535  U+9AB4  uni9AB4,  CJK UNIFIED IDEOGRAPH-9AB4
        0x9ABB, # G+11536  U+9ABB  uni9ABB,  CJK UNIFIED IDEOGRAPH-9ABB
        0x9AF6, # G+11537  U+9AF6  uni9AF6,  CJK UNIFIED IDEOGRAPH-9AF6
        0x9AFA, # G+11538  U+9AFA  uni9AFA,  CJK UNIFIED IDEOGRAPH-9AFA
        0x9AF9, # G+11539  U+9AF9  uni9AF9,  CJK UNIFIED IDEOGRAPH-9AF9
        0x9AF7, # G+11540  U+9AF7  uni9AF7,  CJK UNIFIED IDEOGRAPH-9AF7
        0x9B33, # G+11541  U+9B33  uni9B33,  CJK UNIFIED IDEOGRAPH-9B33
        0x9B80, # G+11542  U+9B80  uni9B80,  CJK UNIFIED IDEOGRAPH-9B80
        0x9B85, # G+11543  U+9B85  uni9B85,  CJK UNIFIED IDEOGRAPH-9B85
        0x9B87, # G+11544  U+9B87  uni9B87,  CJK UNIFIED IDEOGRAPH-9B87
        0x9B7C, # G+11545  U+9B7C  uni9B7C,  CJK UNIFIED IDEOGRAPH-9B7C
        0x9B7E, # G+11546  U+9B7E  uni9B7E,  CJK UNIFIED IDEOGRAPH-9B7E
        0x9B7B, # G+11547  U+9B7B  uni9B7B,  CJK UNIFIED IDEOGRAPH-9B7B
        0x9B82, # G+11548  U+9B82  uni9B82,  CJK UNIFIED IDEOGRAPH-9B82
        0x9B93, # G+11549  U+9B93  uni9B93,  CJK UNIFIED IDEOGRAPH-9B93
        0x9B92, # G+11550  U+9B92  uni9B92,  CJK UNIFIED IDEOGRAPH-9B92
        0x9B90, # G+11551  U+9B90  uni9B90,  CJK UNIFIED IDEOGRAPH-9B90
        0x9B7A, # G+11552  U+9B7A  uni9B7A,  CJK UNIFIED IDEOGRAPH-9B7A
        0x9B95, # G+11553  U+9B95  uni9B95,  CJK UNIFIED IDEOGRAPH-9B95
        0x9B7D, # G+11554  U+9B7D  uni9B7D,  CJK UNIFIED IDEOGRAPH-9B7D
        0x9B88, # G+11555  U+9B88  uni9B88,  CJK UNIFIED IDEOGRAPH-9B88
        0x9D25, # G+11556  U+9D25  uni9D25,  CJK UNIFIED IDEOGRAPH-9D25
        0x9D17, # G+11557  U+9D17  uni9D17,  CJK UNIFIED IDEOGRAPH-9D17
        0x9D20, # G+11558  U+9D20  uni9D20,  CJK UNIFIED IDEOGRAPH-9D20
        0x9D1E, # G+11559  U+9D1E  uni9D1E,  CJK UNIFIED IDEOGRAPH-9D1E
        0x9D14, # G+11560  U+9D14  uni9D14,  CJK UNIFIED IDEOGRAPH-9D14
        0x9D29, # G+11561  U+9D29  uni9D29,  CJK UNIFIED IDEOGRAPH-9D29
        0x9D1D, # G+11562  U+9D1D  uni9D1D,  CJK UNIFIED IDEOGRAPH-9D1D
        0x9D18, # G+11563  U+9D18  uni9D18,  CJK UNIFIED IDEOGRAPH-9D18
        0x9D22, # G+11564  U+9D22  uni9D22,  CJK UNIFIED IDEOGRAPH-9D22
        0x9D10, # G+11565  U+9D10  uni9D10,  CJK UNIFIED IDEOGRAPH-9D10
        0x9D19, # G+11566  U+9D19  uni9D19,  CJK UNIFIED IDEOGRAPH-9D19
        0x9D1F, # G+11567  U+9D1F  uni9D1F,  CJK UNIFIED IDEOGRAPH-9D1F
        0x9E88, # G+11568  U+9E88  uni9E88,  CJK UNIFIED IDEOGRAPH-9E88
        0x9E86, # G+11569  U+9E86  uni9E86,  CJK UNIFIED IDEOGRAPH-9E86
        0x9E87, # G+11570  U+9E87  uni9E87,  CJK UNIFIED IDEOGRAPH-9E87
        0x9EAE, # G+11571  U+9EAE  uni9EAE,  CJK UNIFIED IDEOGRAPH-9EAE
        0x9EAD, # G+11572  U+9EAD  uni9EAD,  CJK UNIFIED IDEOGRAPH-9EAD
        0x9ED5, # G+11573  U+9ED5  uni9ED5,  CJK UNIFIED IDEOGRAPH-9ED5
        0x9ED6, # G+11574  U+9ED6  uni9ED6,  CJK UNIFIED IDEOGRAPH-9ED6
        0x9EFA, # G+11575  U+9EFA  uni9EFA,  CJK UNIFIED IDEOGRAPH-9EFA
        0x9F12, # G+11576  U+9F12  uni9F12,  CJK UNIFIED IDEOGRAPH-9F12
        0x9F3D, # G+11577  U+9F3D  uni9F3D,  CJK UNIFIED IDEOGRAPH-9F3D
        0x5126, # G+11578  U+5126  uni5126,  CJK UNIFIED IDEOGRAPH-5126
        0x5125, # G+11579  U+5125  uni5125,  CJK UNIFIED IDEOGRAPH-5125
        0x5122, # G+11580  U+5122  uni5122,  CJK UNIFIED IDEOGRAPH-5122
        0x5124, # G+11581  U+5124  uni5124,  CJK UNIFIED IDEOGRAPH-5124
        0x5120, # G+11582  U+5120  uni5120,  CJK UNIFIED IDEOGRAPH-5120
        0x5129, # G+11583  U+5129  uni5129,  CJK UNIFIED IDEOGRAPH-5129
        0x52F4, # G+11584  U+52F4  uni52F4,  CJK UNIFIED IDEOGRAPH-52F4
        0x5693, # G+11585  U+5693  uni5693,  CJK UNIFIED IDEOGRAPH-5693
        0x568C, # G+11586  U+568C  uni568C,  CJK UNIFIED IDEOGRAPH-568C
        0x568D, # G+11587  U+568D  uni568D,  CJK UNIFIED IDEOGRAPH-568D
        0x5686, # G+11588  U+5686  uni5686,  CJK UNIFIED IDEOGRAPH-5686
        0x5684, # G+11589  U+5684  uni5684,  CJK UNIFIED IDEOGRAPH-5684
        0x5683, # G+11590  U+5683  uni5683,  CJK UNIFIED IDEOGRAPH-5683
        0x567E, # G+11591  U+567E  uni567E,  CJK UNIFIED IDEOGRAPH-567E
        0x5682, # G+11592  U+5682  uni5682,  CJK UNIFIED IDEOGRAPH-5682
        0x567F, # G+11593  U+567F  uni567F,  CJK UNIFIED IDEOGRAPH-567F
        0x5681, # G+11594  U+5681  uni5681,  CJK UNIFIED IDEOGRAPH-5681
        0x58D6, # G+11595  U+58D6  uni58D6,  CJK UNIFIED IDEOGRAPH-58D6
        0x58D4, # G+11596  U+58D4  uni58D4,  CJK UNIFIED IDEOGRAPH-58D4
        0x58CF, # G+11597  U+58CF  uni58CF,  CJK UNIFIED IDEOGRAPH-58CF
        0x58D2, # G+11598  U+58D2  uni58D2,  CJK UNIFIED IDEOGRAPH-58D2
        0x5B2D, # G+11599  U+5B2D  uni5B2D,  CJK UNIFIED IDEOGRAPH-5B2D
        0x5B25, # G+11600  U+5B25  uni5B25,  CJK UNIFIED IDEOGRAPH-5B25
        0x5B32, # G+11601  U+5B32  uni5B32,  CJK UNIFIED IDEOGRAPH-5B32
        0x5B23, # G+11602  U+5B23  uni5B23,  CJK UNIFIED IDEOGRAPH-5B23
        0x5B2C, # G+11603  U+5B2C  uni5B2C,  CJK UNIFIED IDEOGRAPH-5B2C
        0x5B27, # G+11604  U+5B27  uni5B27,  CJK UNIFIED IDEOGRAPH-5B27
        0x5B26, # G+11605  U+5B26  uni5B26,  CJK UNIFIED IDEOGRAPH-5B26
        0x5B2F, # G+11606  U+5B2F  uni5B2F,  CJK UNIFIED IDEOGRAPH-5B2F
        0x5B2E, # G+11607  U+5B2E  uni5B2E,  CJK UNIFIED IDEOGRAPH-5B2E
        0x5B7B, # G+11608  U+5B7B  uni5B7B,  CJK UNIFIED IDEOGRAPH-5B7B
        0x5BF1, # G+11609  U+5BF1  uni5BF1,  CJK UNIFIED IDEOGRAPH-5BF1
        0x5BF2, # G+11610  U+5BF2  uni5BF2,  CJK UNIFIED IDEOGRAPH-5BF2
        0x5DB7, # G+11611  U+5DB7  uni5DB7,  CJK UNIFIED IDEOGRAPH-5DB7
        0x5E6C, # G+11612  U+5E6C  uni5E6C,  CJK UNIFIED IDEOGRAPH-5E6C
        0x5E6A, # G+11613  U+5E6A  uni5E6A,  CJK UNIFIED IDEOGRAPH-5E6A
        0x5FBE, # G+11614  U+5FBE  uni5FBE,  CJK UNIFIED IDEOGRAPH-5FBE
        0x61C3, # G+11615  U+61C3  uni61C3,  CJK UNIFIED IDEOGRAPH-61C3
        0x61B5, # G+11616  U+61B5  uni61B5,  CJK UNIFIED IDEOGRAPH-61B5
        0x61BC, # G+11617  U+61BC  uni61BC,  CJK UNIFIED IDEOGRAPH-61BC
        0x61E7, # G+11618  U+61E7  uni61E7,  CJK UNIFIED IDEOGRAPH-61E7
        0x61E0, # G+11619  U+61E0  uni61E0,  CJK UNIFIED IDEOGRAPH-61E0
        0x61E5, # G+11620  U+61E5  uni61E5,  CJK UNIFIED IDEOGRAPH-61E5
        0x61E4, # G+11621  U+61E4  uni61E4,  CJK UNIFIED IDEOGRAPH-61E4
        0x61E8, # G+11622  U+61E8  uni61E8,  CJK UNIFIED IDEOGRAPH-61E8
        0x61DE, # G+11623  U+61DE  uni61DE,  CJK UNIFIED IDEOGRAPH-61DE
        0x64EF, # G+11624  U+64EF  uni64EF,  CJK UNIFIED IDEOGRAPH-64EF
        0x64E9, # G+11625  U+64E9  uni64E9,  CJK UNIFIED IDEOGRAPH-64E9
        0x64E3, # G+11626  U+64E3  uni64E3,  CJK UNIFIED IDEOGRAPH-64E3
        0x64EB, # G+11627  U+64EB  uni64EB,  CJK UNIFIED IDEOGRAPH-64EB
        0x64E4, # G+11628  U+64E4  uni64E4,  CJK UNIFIED IDEOGRAPH-64E4
        0x64E8, # G+11629  U+64E8  uni64E8,  CJK UNIFIED IDEOGRAPH-64E8
        0x6581, # G+11630  U+6581  uni6581,  CJK UNIFIED IDEOGRAPH-6581
        0x6580, # G+11631  U+6580  uni6580,  CJK UNIFIED IDEOGRAPH-6580
        0x65B6, # G+11632  U+65B6  uni65B6,  CJK UNIFIED IDEOGRAPH-65B6
        0x65DA, # G+11633  U+65DA  uni65DA,  CJK UNIFIED IDEOGRAPH-65DA
        0x66D2, # G+11634  U+66D2  uni66D2,  CJK UNIFIED IDEOGRAPH-66D2
        0x6A8D, # G+11635  U+6A8D  uni6A8D,  CJK UNIFIED IDEOGRAPH-6A8D
        0x6A96, # G+11636  U+6A96  uni6A96,  CJK UNIFIED IDEOGRAPH-6A96
        0x6A81, # G+11637  U+6A81  uni6A81,  CJK UNIFIED IDEOGRAPH-6A81
        0x6AA5, # G+11638  U+6AA5  uni6AA5,  CJK UNIFIED IDEOGRAPH-6AA5
        0x6A89, # G+11639  U+6A89  uni6A89,  CJK UNIFIED IDEOGRAPH-6A89
        0x6A9F, # G+11640  U+6A9F  uni6A9F,  CJK UNIFIED IDEOGRAPH-6A9F
        0x6A9B, # G+11641  U+6A9B  uni6A9B,  CJK UNIFIED IDEOGRAPH-6A9B
        0x6AA1, # G+11642  U+6AA1  uni6AA1,  CJK UNIFIED IDEOGRAPH-6AA1
        0x6A9E, # G+11643  U+6A9E  uni6A9E,  CJK UNIFIED IDEOGRAPH-6A9E
        0x6A87, # G+11644  U+6A87  uni6A87,  CJK UNIFIED IDEOGRAPH-6A87
        0x6A93, # G+11645  U+6A93  uni6A93,  CJK UNIFIED IDEOGRAPH-6A93
        0x6A8E, # G+11646  U+6A8E  uni6A8E,  CJK UNIFIED IDEOGRAPH-6A8E
        0x6A95, # G+11647  U+6A95  uni6A95,  CJK UNIFIED IDEOGRAPH-6A95
        0x6A83, # G+11648  U+6A83  uni6A83,  CJK UNIFIED IDEOGRAPH-6A83
        0x6AA8, # G+11649  U+6AA8  uni6AA8,  CJK UNIFIED IDEOGRAPH-6AA8
        0x6AA4, # G+11650  U+6AA4  uni6AA4,  CJK UNIFIED IDEOGRAPH-6AA4
        0x6A91, # G+11651  U+6A91  uni6A91,  CJK UNIFIED IDEOGRAPH-6A91
        0x6A7F, # G+11652  U+6A7F  uni6A7F,  CJK UNIFIED IDEOGRAPH-6A7F
        0x6AA6, # G+11653  U+6AA6  uni6AA6,  CJK UNIFIED IDEOGRAPH-6AA6
        0x6A9A, # G+11654  U+6A9A  uni6A9A,  CJK UNIFIED IDEOGRAPH-6A9A
        0x6A85, # G+11655  U+6A85  uni6A85,  CJK UNIFIED IDEOGRAPH-6A85
        0x6A8C, # G+11656  U+6A8C  uni6A8C,  CJK UNIFIED IDEOGRAPH-6A8C
        0x6A92, # G+11657  U+6A92  uni6A92,  CJK UNIFIED IDEOGRAPH-6A92
        0x6B5B, # G+11658  U+6B5B  uni6B5B,  CJK UNIFIED IDEOGRAPH-6B5B
        0x6BAD, # G+11659  U+6BAD  uni6BAD,  CJK UNIFIED IDEOGRAPH-6BAD
        0x6C09, # G+11660  U+6C09  uni6C09,  CJK UNIFIED IDEOGRAPH-6C09
        0x6FCC, # G+11661  U+6FCC  uni6FCC,  CJK UNIFIED IDEOGRAPH-6FCC
        0x6FA9, # G+11662  U+6FA9  uni6FA9,  CJK UNIFIED IDEOGRAPH-6FA9
        0x6FF4, # G+11663  U+6FF4  uni6FF4,  CJK UNIFIED IDEOGRAPH-6FF4
        0x6FD4, # G+11664  U+6FD4  uni6FD4,  CJK UNIFIED IDEOGRAPH-6FD4
        0x6FE3, # G+11665  U+6FE3  uni6FE3,  CJK UNIFIED IDEOGRAPH-6FE3
        0x6FDC, # G+11666  U+6FDC  uni6FDC,  CJK UNIFIED IDEOGRAPH-6FDC
        0x6FED, # G+11667  U+6FED  uni6FED,  CJK UNIFIED IDEOGRAPH-6FED
        0x6FE7, # G+11668  U+6FE7  uni6FE7,  CJK UNIFIED IDEOGRAPH-6FE7
        0x6FE6, # G+11669  U+6FE6  uni6FE6,  CJK UNIFIED IDEOGRAPH-6FE6
        0x6FDE, # G+11670  U+6FDE  uni6FDE,  CJK UNIFIED IDEOGRAPH-6FDE
        0x6FF2, # G+11671  U+6FF2  uni6FF2,  CJK UNIFIED IDEOGRAPH-6FF2
        0x6FDD, # G+11672  U+6FDD  uni6FDD,  CJK UNIFIED IDEOGRAPH-6FDD
        0x6FE2, # G+11673  U+6FE2  uni6FE2,  CJK UNIFIED IDEOGRAPH-6FE2
        0x6FE8, # G+11674  U+6FE8  uni6FE8,  CJK UNIFIED IDEOGRAPH-6FE8
        0x71E1, # G+11675  U+71E1  uni71E1,  CJK UNIFIED IDEOGRAPH-71E1
        0x71F1, # G+11676  U+71F1  uni71F1,  CJK UNIFIED IDEOGRAPH-71F1
        0x71E8, # G+11677  U+71E8  uni71E8,  CJK UNIFIED IDEOGRAPH-71E8
        0x71F2, # G+11678  U+71F2  uni71F2,  CJK UNIFIED IDEOGRAPH-71F2
        0x71E4, # G+11679  U+71E4  uni71E4,  CJK UNIFIED IDEOGRAPH-71E4
        0x71F0, # G+11680  U+71F0  uni71F0,  CJK UNIFIED IDEOGRAPH-71F0
        0x71E2, # G+11681  U+71E2  uni71E2,  CJK UNIFIED IDEOGRAPH-71E2
        0x7373, # G+11682  U+7373  uni7373,  CJK UNIFIED IDEOGRAPH-7373
        0x736E, # G+11683  U+736E  uni736E,  CJK UNIFIED IDEOGRAPH-736E
        0x736F, # G+11684  U+736F  uni736F,  CJK UNIFIED IDEOGRAPH-736F
        0x7497, # G+11685  U+7497  uni7497,  CJK UNIFIED IDEOGRAPH-7497
        0x74B2, # G+11686  U+74B2  uni74B2,  CJK UNIFIED IDEOGRAPH-74B2
        0x74AB, # G+11687  U+74AB  uni74AB,  CJK UNIFIED IDEOGRAPH-74AB
        0x7490, # G+11688  U+7490  uni7490,  CJK UNIFIED IDEOGRAPH-7490
        0x74AA, # G+11689  U+74AA  uni74AA,  CJK UNIFIED IDEOGRAPH-74AA
        0x74AD, # G+11690  U+74AD  uni74AD,  CJK UNIFIED IDEOGRAPH-74AD
        0x74B1, # G+11691  U+74B1  uni74B1,  CJK UNIFIED IDEOGRAPH-74B1
        0x74A5, # G+11692  U+74A5  uni74A5,  CJK UNIFIED IDEOGRAPH-74A5
        0x74AF, # G+11693  U+74AF  uni74AF,  CJK UNIFIED IDEOGRAPH-74AF
        0x7510, # G+11694  U+7510  uni7510,  CJK UNIFIED IDEOGRAPH-7510
        0x7511, # G+11695  U+7511  uni7511,  CJK UNIFIED IDEOGRAPH-7511
        0x7512, # G+11696  U+7512  uni7512,  CJK UNIFIED IDEOGRAPH-7512
        0x750F, # G+11697  U+750F  uni750F,  CJK UNIFIED IDEOGRAPH-750F
        0x7584, # G+11698  U+7584  uni7584,  CJK UNIFIED IDEOGRAPH-7584
        0x7643, # G+11699  U+7643  uni7643,  CJK UNIFIED IDEOGRAPH-7643
        0x7648, # G+11700  U+7648  uni7648,  CJK UNIFIED IDEOGRAPH-7648
        0x7649, # G+11701  U+7649  uni7649,  CJK UNIFIED IDEOGRAPH-7649
        0x7647, # G+11702  U+7647  uni7647,  CJK UNIFIED IDEOGRAPH-7647
        0x76A4, # G+11703  U+76A4  uni76A4,  CJK UNIFIED IDEOGRAPH-76A4
        0x76E9, # G+11704  U+76E9  uni76E9,  CJK UNIFIED IDEOGRAPH-76E9
        0x77B5, # G+11705  U+77B5  uni77B5,  CJK UNIFIED IDEOGRAPH-77B5
        0x77AB, # G+11706  U+77AB  uni77AB,  CJK UNIFIED IDEOGRAPH-77AB
        0x77B2, # G+11707  U+77B2  uni77B2,  CJK UNIFIED IDEOGRAPH-77B2
        0x77B7, # G+11708  U+77B7  uni77B7,  CJK UNIFIED IDEOGRAPH-77B7
        0x77B6, # G+11709  U+77B6  uni77B6,  CJK UNIFIED IDEOGRAPH-77B6
        0x77B4, # G+11710  U+77B4  uni77B4,  CJK UNIFIED IDEOGRAPH-77B4
        0x77B1, # G+11711  U+77B1  uni77B1,  CJK UNIFIED IDEOGRAPH-77B1
        0x77A8, # G+11712  U+77A8  uni77A8,  CJK UNIFIED IDEOGRAPH-77A8
        0x77F0, # G+11713  U+77F0  uni77F0,  CJK UNIFIED IDEOGRAPH-77F0
        0x78F3, # G+11714  U+78F3  uni78F3,  CJK UNIFIED IDEOGRAPH-78F3
        0x78FD, # G+11715  U+78FD  uni78FD,  CJK UNIFIED IDEOGRAPH-78FD
        0x7902, # G+11716  U+7902  uni7902,  CJK UNIFIED IDEOGRAPH-7902
        0x78FB, # G+11717  U+78FB  uni78FB,  CJK UNIFIED IDEOGRAPH-78FB
        0x78FC, # G+11718  U+78FC  uni78FC,  CJK UNIFIED IDEOGRAPH-78FC
        0x78FF, # G+11719  U+78FF  uni78FF,  CJK UNIFIED IDEOGRAPH-78FF
        0x78F2, # G+11720  U+78F2  uni78F2,  CJK UNIFIED IDEOGRAPH-78F2
        0x7905, # G+11721  U+7905  uni7905,  CJK UNIFIED IDEOGRAPH-7905
        0x78F9, # G+11722  U+78F9  uni78F9,  CJK UNIFIED IDEOGRAPH-78F9
        0x78FE, # G+11723  U+78FE  uni78FE,  CJK UNIFIED IDEOGRAPH-78FE
        0x7904, # G+11724  U+7904  uni7904,  CJK UNIFIED IDEOGRAPH-7904
        0x79AB, # G+11725  U+79AB  uni79AB,  CJK UNIFIED IDEOGRAPH-79AB
        0x79A8, # G+11726  U+79A8  uni79A8,  CJK UNIFIED IDEOGRAPH-79A8
        0x7A5C, # G+11727  U+7A5C  uni7A5C,  CJK UNIFIED IDEOGRAPH-7A5C
        0x7A5B, # G+11728  U+7A5B  uni7A5B,  CJK UNIFIED IDEOGRAPH-7A5B
        0x7A56, # G+11729  U+7A56  uni7A56,  CJK UNIFIED IDEOGRAPH-7A56
        0x7A58, # G+11730  U+7A58  uni7A58,  CJK UNIFIED IDEOGRAPH-7A58
        0x7A54, # G+11731  U+7A54  uni7A54,  CJK UNIFIED IDEOGRAPH-7A54
        0x7A5A, # G+11732  U+7A5A  uni7A5A,  CJK UNIFIED IDEOGRAPH-7A5A
        0x7ABE, # G+11733  U+7ABE  uni7ABE,  CJK UNIFIED IDEOGRAPH-7ABE
        0x7AC0, # G+11734  U+7AC0  uni7AC0,  CJK UNIFIED IDEOGRAPH-7AC0
        0x7AC1, # G+11735  U+7AC1  uni7AC1,  CJK UNIFIED IDEOGRAPH-7AC1
        0x7C05, # G+11736  U+7C05  uni7C05,  CJK UNIFIED IDEOGRAPH-7C05
        0x7C0F, # G+11737  U+7C0F  uni7C0F,  CJK UNIFIED IDEOGRAPH-7C0F
        0x7BF2, # G+11738  U+7BF2  uni7BF2,  CJK UNIFIED IDEOGRAPH-7BF2
        0x7C00, # G+11739  U+7C00  uni7C00,  CJK UNIFIED IDEOGRAPH-7C00
        0x7BFF, # G+11740  U+7BFF  uni7BFF,  CJK UNIFIED IDEOGRAPH-7BFF
        0x7BFB, # G+11741  U+7BFB  uni7BFB,  CJK UNIFIED IDEOGRAPH-7BFB
        0x7C0E, # G+11742  U+7C0E  uni7C0E,  CJK UNIFIED IDEOGRAPH-7C0E
        0x7BF4, # G+11743  U+7BF4  uni7BF4,  CJK UNIFIED IDEOGRAPH-7BF4
        0x7C0B, # G+11744  U+7C0B  uni7C0B,  CJK UNIFIED IDEOGRAPH-7C0B
        0x7BF3, # G+11745  U+7BF3  uni7BF3,  CJK UNIFIED IDEOGRAPH-7BF3
        0x7C02, # G+11746  U+7C02  uni7C02,  CJK UNIFIED IDEOGRAPH-7C02
        0x7C09, # G+11747  U+7C09  uni7C09,  CJK UNIFIED IDEOGRAPH-7C09
        0x7C03, # G+11748  U+7C03  uni7C03,  CJK UNIFIED IDEOGRAPH-7C03
        0x7C01, # G+11749  U+7C01  uni7C01,  CJK UNIFIED IDEOGRAPH-7C01
        0x7BF8, # G+11750  U+7BF8  uni7BF8,  CJK UNIFIED IDEOGRAPH-7BF8
        0x7BFD, # G+11751  U+7BFD  uni7BFD,  CJK UNIFIED IDEOGRAPH-7BFD
        0x7C06, # G+11752  U+7C06  uni7C06,  CJK UNIFIED IDEOGRAPH-7C06
        0x7BF0, # G+11753  U+7BF0  uni7BF0,  CJK UNIFIED IDEOGRAPH-7BF0
        0x7BF1, # G+11754  U+7BF1  uni7BF1,  CJK UNIFIED IDEOGRAPH-7BF1
        0x7C10, # G+11755  U+7C10  uni7C10,  CJK UNIFIED IDEOGRAPH-7C10
        0x7C0A, # G+11756  U+7C0A  uni7C0A,  CJK UNIFIED IDEOGRAPH-7C0A
        0x7CE8, # G+11757  U+7CE8  uni7CE8,  CJK UNIFIED IDEOGRAPH-7CE8
        0x7E2D, # G+11758  U+7E2D  uni7E2D,  CJK UNIFIED IDEOGRAPH-7E2D
        0x7E3C, # G+11759  U+7E3C  uni7E3C,  CJK UNIFIED IDEOGRAPH-7E3C
        0x7E42, # G+11760  U+7E42  uni7E42,  CJK UNIFIED IDEOGRAPH-7E42
        0x7E33, # G+11761  U+7E33  uni7E33,  CJK UNIFIED IDEOGRAPH-7E33
        0x9848, # G+11762  U+9848  uni9848,  CJK UNIFIED IDEOGRAPH-9848
        0x7E38, # G+11763  U+7E38  uni7E38,  CJK UNIFIED IDEOGRAPH-7E38
        0x7E2A, # G+11764  U+7E2A  uni7E2A,  CJK UNIFIED IDEOGRAPH-7E2A
        0x7E49, # G+11765  U+7E49  uni7E49,  CJK UNIFIED IDEOGRAPH-7E49
        0x7E40, # G+11766  U+7E40  uni7E40,  CJK UNIFIED IDEOGRAPH-7E40
        0x7E47, # G+11767  U+7E47  uni7E47,  CJK UNIFIED IDEOGRAPH-7E47
        0x7E29, # G+11768  U+7E29  uni7E29,  CJK UNIFIED IDEOGRAPH-7E29
        0x7E4C, # G+11769  U+7E4C  uni7E4C,  CJK UNIFIED IDEOGRAPH-7E4C
        0x7E30, # G+11770  U+7E30  uni7E30,  CJK UNIFIED IDEOGRAPH-7E30
        0x7E3B, # G+11771  U+7E3B  uni7E3B,  CJK UNIFIED IDEOGRAPH-7E3B
        0x7E36, # G+11772  U+7E36  uni7E36,  CJK UNIFIED IDEOGRAPH-7E36
        0x7E44, # G+11773  U+7E44  uni7E44,  CJK UNIFIED IDEOGRAPH-7E44
        0x7E3A, # G+11774  U+7E3A  uni7E3A,  CJK UNIFIED IDEOGRAPH-7E3A
        0x7F45, # G+11775  U+7F45  uni7F45,  CJK UNIFIED IDEOGRAPH-7F45
        0x7F7F, # G+11776  U+7F7F  uni7F7F,  CJK UNIFIED IDEOGRAPH-7F7F
        0x7F7E, # G+11777  U+7F7E  uni7F7E,  CJK UNIFIED IDEOGRAPH-7F7E
        0x7F7D, # G+11778  U+7F7D  uni7F7D,  CJK UNIFIED IDEOGRAPH-7F7D
        0x7FF4, # G+11779  U+7FF4  uni7FF4,  CJK UNIFIED IDEOGRAPH-7FF4
        0x7FF2, # G+11780  U+7FF2  uni7FF2,  CJK UNIFIED IDEOGRAPH-7FF2
        0x802C, # G+11781  U+802C  uni802C,  CJK UNIFIED IDEOGRAPH-802C
        0x81BB, # G+11782  U+81BB  uni81BB,  CJK UNIFIED IDEOGRAPH-81BB
        0x81C4, # G+11783  U+81C4  uni81C4,  CJK UNIFIED IDEOGRAPH-81C4
        0x81CC, # G+11784  U+81CC  uni81CC,  CJK UNIFIED IDEOGRAPH-81CC
        0x81CA, # G+11785  U+81CA  uni81CA,  CJK UNIFIED IDEOGRAPH-81CA
        0x81C5, # G+11786  U+81C5  uni81C5,  CJK UNIFIED IDEOGRAPH-81C5
        0x81C7, # G+11787  U+81C7  uni81C7,  CJK UNIFIED IDEOGRAPH-81C7
        0x81BC, # G+11788  U+81BC  uni81BC,  CJK UNIFIED IDEOGRAPH-81BC
        0x81E9, # G+11789  U+81E9  uni81E9,  CJK UNIFIED IDEOGRAPH-81E9
        0x825B, # G+11790  U+825B  uni825B,  CJK UNIFIED IDEOGRAPH-825B
        0x825A, # G+11791  U+825A  uni825A,  CJK UNIFIED IDEOGRAPH-825A
        0x825C, # G+11792  U+825C  uni825C,  CJK UNIFIED IDEOGRAPH-825C
        0x8583, # G+11793  U+8583  uni8583,  CJK UNIFIED IDEOGRAPH-8583
        0x8580, # G+11794  U+8580  uni8580,  CJK UNIFIED IDEOGRAPH-8580
        0x858F, # G+11795  U+858F  uni858F,  CJK UNIFIED IDEOGRAPH-858F
        0x85A7, # G+11796  U+85A7  uni85A7,  CJK UNIFIED IDEOGRAPH-85A7
        0x8595, # G+11797  U+8595  uni8595,  CJK UNIFIED IDEOGRAPH-8595
        0x85A0, # G+11798  U+85A0  uni85A0,  CJK UNIFIED IDEOGRAPH-85A0
        0x858B, # G+11799  U+858B  uni858B,  CJK UNIFIED IDEOGRAPH-858B
        0x85A3, # G+11800  U+85A3  uni85A3,  CJK UNIFIED IDEOGRAPH-85A3
        0x857B, # G+11801  U+857B  uni857B,  CJK UNIFIED IDEOGRAPH-857B
        0x85A4, # G+11802  U+85A4  uni85A4,  CJK UNIFIED IDEOGRAPH-85A4
        0x859A, # G+11803  U+859A  uni859A,  CJK UNIFIED IDEOGRAPH-859A
        0x859E, # G+11804  U+859E  uni859E,  CJK UNIFIED IDEOGRAPH-859E
        0x8577, # G+11805  U+8577  uni8577,  CJK UNIFIED IDEOGRAPH-8577
        0x857C, # G+11806  U+857C  uni857C,  CJK UNIFIED IDEOGRAPH-857C
        0x8589, # G+11807  U+8589  uni8589,  CJK UNIFIED IDEOGRAPH-8589
        0x85A1, # G+11808  U+85A1  uni85A1,  CJK UNIFIED IDEOGRAPH-85A1
        0x857A, # G+11809  U+857A  uni857A,  CJK UNIFIED IDEOGRAPH-857A
        0x8578, # G+11810  U+8578  uni8578,  CJK UNIFIED IDEOGRAPH-8578
        0x8557, # G+11811  U+8557  uni8557,  CJK UNIFIED IDEOGRAPH-8557
        0x858E, # G+11812  U+858E  uni858E,  CJK UNIFIED IDEOGRAPH-858E
        0x8596, # G+11813  U+8596  uni8596,  CJK UNIFIED IDEOGRAPH-8596
        0x8586, # G+11814  U+8586  uni8586,  CJK UNIFIED IDEOGRAPH-8586
        0x858D, # G+11815  U+858D  uni858D,  CJK UNIFIED IDEOGRAPH-858D
        0x8599, # G+11816  U+8599  uni8599,  CJK UNIFIED IDEOGRAPH-8599
        0x859D, # G+11817  U+859D  uni859D,  CJK UNIFIED IDEOGRAPH-859D
        0x8581, # G+11818  U+8581  uni8581,  CJK UNIFIED IDEOGRAPH-8581
        0x85A2, # G+11819  U+85A2  uni85A2,  CJK UNIFIED IDEOGRAPH-85A2
        0x8582, # G+11820  U+8582  uni8582,  CJK UNIFIED IDEOGRAPH-8582
        0x8588, # G+11821  U+8588  uni8588,  CJK UNIFIED IDEOGRAPH-8588
        0x8585, # G+11822  U+8585  uni8585,  CJK UNIFIED IDEOGRAPH-8585
        0x8579, # G+11823  U+8579  uni8579,  CJK UNIFIED IDEOGRAPH-8579
        0x8576, # G+11824  U+8576  uni8576,  CJK UNIFIED IDEOGRAPH-8576
        0x8598, # G+11825  U+8598  uni8598,  CJK UNIFIED IDEOGRAPH-8598
        0x8590, # G+11826  U+8590  uni8590,  CJK UNIFIED IDEOGRAPH-8590
        0x859F, # G+11827  U+859F  uni859F,  CJK UNIFIED IDEOGRAPH-859F
        0x8668, # G+11828  U+8668  uni8668,  CJK UNIFIED IDEOGRAPH-8668
        0x87BE, # G+11829  U+87BE  uni87BE,  CJK UNIFIED IDEOGRAPH-87BE
        0x87AA, # G+11830  U+87AA  uni87AA,  CJK UNIFIED IDEOGRAPH-87AA
        0x87AD, # G+11831  U+87AD  uni87AD,  CJK UNIFIED IDEOGRAPH-87AD
        0x87C5, # G+11832  U+87C5  uni87C5,  CJK UNIFIED IDEOGRAPH-87C5
        0x87B0, # G+11833  U+87B0  uni87B0,  CJK UNIFIED IDEOGRAPH-87B0
        0x87AC, # G+11834  U+87AC  uni87AC,  CJK UNIFIED IDEOGRAPH-87AC
        0x87B9, # G+11835  U+87B9  uni87B9,  CJK UNIFIED IDEOGRAPH-87B9
        0x87B5, # G+11836  U+87B5  uni87B5,  CJK UNIFIED IDEOGRAPH-87B5
        0x87BC, # G+11837  U+87BC  uni87BC,  CJK UNIFIED IDEOGRAPH-87BC
        0x87AE, # G+11838  U+87AE  uni87AE,  CJK UNIFIED IDEOGRAPH-87AE
        0x87C9, # G+11839  U+87C9  uni87C9,  CJK UNIFIED IDEOGRAPH-87C9
        0x87C3, # G+11840  U+87C3  uni87C3,  CJK UNIFIED IDEOGRAPH-87C3
        0x87C2, # G+11841  U+87C2  uni87C2,  CJK UNIFIED IDEOGRAPH-87C2
        0x87CC, # G+11842  U+87CC  uni87CC,  CJK UNIFIED IDEOGRAPH-87CC
        0x87B7, # G+11843  U+87B7  uni87B7,  CJK UNIFIED IDEOGRAPH-87B7
        0x87AF, # G+11844  U+87AF  uni87AF,  CJK UNIFIED IDEOGRAPH-87AF
        0x87C4, # G+11845  U+87C4  uni87C4,  CJK UNIFIED IDEOGRAPH-87C4
        0x87CA, # G+11846  U+87CA  uni87CA,  CJK UNIFIED IDEOGRAPH-87CA
        0x87B4, # G+11847  U+87B4  uni87B4,  CJK UNIFIED IDEOGRAPH-87B4
        0x87B6, # G+11848  U+87B6  uni87B6,  CJK UNIFIED IDEOGRAPH-87B6
        0x87BF, # G+11849  U+87BF  uni87BF,  CJK UNIFIED IDEOGRAPH-87BF
        0x87B8, # G+11850  U+87B8  uni87B8,  CJK UNIFIED IDEOGRAPH-87B8
        0x87BD, # G+11851  U+87BD  uni87BD,  CJK UNIFIED IDEOGRAPH-87BD
        0x87DE, # G+11852  U+87DE  uni87DE,  CJK UNIFIED IDEOGRAPH-87DE
        0x87B2, # G+11853  U+87B2  uni87B2,  CJK UNIFIED IDEOGRAPH-87B2
        0x8935, # G+11854  U+8935  uni8935,  CJK UNIFIED IDEOGRAPH-8935
        0x8933, # G+11855  U+8933  uni8933,  CJK UNIFIED IDEOGRAPH-8933
        0x893C, # G+11856  U+893C  uni893C,  CJK UNIFIED IDEOGRAPH-893C
        0x893E, # G+11857  U+893E  uni893E,  CJK UNIFIED IDEOGRAPH-893E
        0x8941, # G+11858  U+8941  uni8941,  CJK UNIFIED IDEOGRAPH-8941
        0x8952, # G+11859  U+8952  uni8952,  CJK UNIFIED IDEOGRAPH-8952
        0x8937, # G+11860  U+8937  uni8937,  CJK UNIFIED IDEOGRAPH-8937
        0x8942, # G+11861  U+8942  uni8942,  CJK UNIFIED IDEOGRAPH-8942
        0x89AD, # G+11862  U+89AD  uni89AD,  CJK UNIFIED IDEOGRAPH-89AD
        0x89AF, # G+11863  U+89AF  uni89AF,  CJK UNIFIED IDEOGRAPH-89AF
        0x89AE, # G+11864  U+89AE  uni89AE,  CJK UNIFIED IDEOGRAPH-89AE
        0x89F2, # G+11865  U+89F2  uni89F2,  CJK UNIFIED IDEOGRAPH-89F2
        0x89F3, # G+11866  U+89F3  uni89F3,  CJK UNIFIED IDEOGRAPH-89F3
        0x8B1E, # G+11867  U+8B1E  uni8B1E,  CJK UNIFIED IDEOGRAPH-8B1E
        0x8B18, # G+11868  U+8B18  uni8B18,  CJK UNIFIED IDEOGRAPH-8B18
        0x8B16, # G+11869  U+8B16  uni8B16,  CJK UNIFIED IDEOGRAPH-8B16
        0x8B11, # G+11870  U+8B11  uni8B11,  CJK UNIFIED IDEOGRAPH-8B11
        0x8B05, # G+11871  U+8B05  uni8B05,  CJK UNIFIED IDEOGRAPH-8B05
        0x8B0B, # G+11872  U+8B0B  uni8B0B,  CJK UNIFIED IDEOGRAPH-8B0B
        0x8B22, # G+11873  U+8B22  uni8B22,  CJK UNIFIED IDEOGRAPH-8B22
        0x8B0F, # G+11874  U+8B0F  uni8B0F,  CJK UNIFIED IDEOGRAPH-8B0F
        0x8B12, # G+11875  U+8B12  uni8B12,  CJK UNIFIED IDEOGRAPH-8B12
        0x8B15, # G+11876  U+8B15  uni8B15,  CJK UNIFIED IDEOGRAPH-8B15
        0x8B07, # G+11877  U+8B07  uni8B07,  CJK UNIFIED IDEOGRAPH-8B07
        0x8B0D, # G+11878  U+8B0D  uni8B0D,  CJK UNIFIED IDEOGRAPH-8B0D
        0x8B08, # G+11879  U+8B08  uni8B08,  CJK UNIFIED IDEOGRAPH-8B08
        0x8B06, # G+11880  U+8B06  uni8B06,  CJK UNIFIED IDEOGRAPH-8B06
        0x8B1C, # G+11881  U+8B1C  uni8B1C,  CJK UNIFIED IDEOGRAPH-8B1C
        0x8B13, # G+11882  U+8B13  uni8B13,  CJK UNIFIED IDEOGRAPH-8B13
        0x8B1A, # G+11883  U+8B1A  uni8B1A,  CJK UNIFIED IDEOGRAPH-8B1A
        0x8C4F, # G+11884  U+8C4F  uni8C4F,  CJK UNIFIED IDEOGRAPH-8C4F
        0x8C70, # G+11885  U+8C70  uni8C70,  CJK UNIFIED IDEOGRAPH-8C70
        0x8C72, # G+11886  U+8C72  uni8C72,  CJK UNIFIED IDEOGRAPH-8C72
        0x8C71, # G+11887  U+8C71  uni8C71,  CJK UNIFIED IDEOGRAPH-8C71
        0x8C6F, # G+11888  U+8C6F  uni8C6F,  CJK UNIFIED IDEOGRAPH-8C6F
        0x8C95, # G+11889  U+8C95  uni8C95,  CJK UNIFIED IDEOGRAPH-8C95
        0x8C94, # G+11890  U+8C94  uni8C94,  CJK UNIFIED IDEOGRAPH-8C94
        0x8CF9, # G+11891  U+8CF9  uni8CF9,  CJK UNIFIED IDEOGRAPH-8CF9
        0x8D6F, # G+11892  U+8D6F  uni8D6F,  CJK UNIFIED IDEOGRAPH-8D6F
        0x8E4E, # G+11893  U+8E4E  uni8E4E,  CJK UNIFIED IDEOGRAPH-8E4E
        0x8E4D, # G+11894  U+8E4D  uni8E4D,  CJK UNIFIED IDEOGRAPH-8E4D
        0x8E53, # G+11895  U+8E53  uni8E53,  CJK UNIFIED IDEOGRAPH-8E53
        0x8E50, # G+11896  U+8E50  uni8E50,  CJK UNIFIED IDEOGRAPH-8E50
        0x8E4C, # G+11897  U+8E4C  uni8E4C,  CJK UNIFIED IDEOGRAPH-8E4C
        0x8E47, # G+11898  U+8E47  uni8E47,  CJK UNIFIED IDEOGRAPH-8E47
        0x8F43, # G+11899  U+8F43  uni8F43,  CJK UNIFIED IDEOGRAPH-8F43
        0x8F40, # G+11900  U+8F40  uni8F40,  CJK UNIFIED IDEOGRAPH-8F40
        0x9085, # G+11901  U+9085  uni9085,  CJK UNIFIED IDEOGRAPH-9085
        0x907E, # G+11902  U+907E  uni907E,  CJK UNIFIED IDEOGRAPH-907E
        0x9138, # G+11903  U+9138  uni9138,  CJK UNIFIED IDEOGRAPH-9138
        0x919A, # G+11904  U+919A  uni919A,  CJK UNIFIED IDEOGRAPH-919A
        0x91A2, # G+11905  U+91A2  uni91A2,  CJK UNIFIED IDEOGRAPH-91A2
        0x919B, # G+11906  U+919B  uni919B,  CJK UNIFIED IDEOGRAPH-919B
        0x9199, # G+11907  U+9199  uni9199,  CJK UNIFIED IDEOGRAPH-9199
        0x919F, # G+11908  U+919F  uni919F,  CJK UNIFIED IDEOGRAPH-919F
        0x91A1, # G+11909  U+91A1  uni91A1,  CJK UNIFIED IDEOGRAPH-91A1
        0x919D, # G+11910  U+919D  uni919D,  CJK UNIFIED IDEOGRAPH-919D
        0x91A0, # G+11911  U+91A0  uni91A0,  CJK UNIFIED IDEOGRAPH-91A0
        0x93A1, # G+11912  U+93A1  uni93A1,  CJK UNIFIED IDEOGRAPH-93A1
        0x9383, # G+11913  U+9383  uni9383,  CJK UNIFIED IDEOGRAPH-9383
        0x93AF, # G+11914  U+93AF  uni93AF,  CJK UNIFIED IDEOGRAPH-93AF
        0x9364, # G+11915  U+9364  uni9364,  CJK UNIFIED IDEOGRAPH-9364
        0x9356, # G+11916  U+9356  uni9356,  CJK UNIFIED IDEOGRAPH-9356
        0x9347, # G+11917  U+9347  uni9347,  CJK UNIFIED IDEOGRAPH-9347
        0x937C, # G+11918  U+937C  uni937C,  CJK UNIFIED IDEOGRAPH-937C
        0x9358, # G+11919  U+9358  uni9358,  CJK UNIFIED IDEOGRAPH-9358
        0x935C, # G+11920  U+935C  uni935C,  CJK UNIFIED IDEOGRAPH-935C
        0x9376, # G+11921  U+9376  uni9376,  CJK UNIFIED IDEOGRAPH-9376
        0x9349, # G+11922  U+9349  uni9349,  CJK UNIFIED IDEOGRAPH-9349
        0x9350, # G+11923  U+9350  uni9350,  CJK UNIFIED IDEOGRAPH-9350
        0x9351, # G+11924  U+9351  uni9351,  CJK UNIFIED IDEOGRAPH-9351
        0x9360, # G+11925  U+9360  uni9360,  CJK UNIFIED IDEOGRAPH-9360
        0x936D, # G+11926  U+936D  uni936D,  CJK UNIFIED IDEOGRAPH-936D
        0x938F, # G+11927  U+938F  uni938F,  CJK UNIFIED IDEOGRAPH-938F
        0x934C, # G+11928  U+934C  uni934C,  CJK UNIFIED IDEOGRAPH-934C
        0x936A, # G+11929  U+936A  uni936A,  CJK UNIFIED IDEOGRAPH-936A
        0x9379, # G+11930  U+9379  uni9379,  CJK UNIFIED IDEOGRAPH-9379
        0x9357, # G+11931  U+9357  uni9357,  CJK UNIFIED IDEOGRAPH-9357
        0x9355, # G+11932  U+9355  uni9355,  CJK UNIFIED IDEOGRAPH-9355
        0x9352, # G+11933  U+9352  uni9352,  CJK UNIFIED IDEOGRAPH-9352
        0x934F, # G+11934  U+934F  uni934F,  CJK UNIFIED IDEOGRAPH-934F
        0x9371, # G+11935  U+9371  uni9371,  CJK UNIFIED IDEOGRAPH-9371
        0x9377, # G+11936  U+9377  uni9377,  CJK UNIFIED IDEOGRAPH-9377
        0x937B, # G+11937  U+937B  uni937B,  CJK UNIFIED IDEOGRAPH-937B
        0x9361, # G+11938  U+9361  uni9361,  CJK UNIFIED IDEOGRAPH-9361
        0x935E, # G+11939  U+935E  uni935E,  CJK UNIFIED IDEOGRAPH-935E
        0x9363, # G+11940  U+9363  uni9363,  CJK UNIFIED IDEOGRAPH-9363
        0x9367, # G+11941  U+9367  uni9367,  CJK UNIFIED IDEOGRAPH-9367
        0x934E, # G+11942  U+934E  uni934E,  CJK UNIFIED IDEOGRAPH-934E
        0x9359, # G+11943  U+9359  uni9359,  CJK UNIFIED IDEOGRAPH-9359
        0x95C7, # G+11944  U+95C7  uni95C7,  CJK UNIFIED IDEOGRAPH-95C7
        0x95C0, # G+11945  U+95C0  uni95C0,  CJK UNIFIED IDEOGRAPH-95C0
        0x95C9, # G+11946  U+95C9  uni95C9,  CJK UNIFIED IDEOGRAPH-95C9
        0x95C3, # G+11947  U+95C3  uni95C3,  CJK UNIFIED IDEOGRAPH-95C3
        0x95C5, # G+11948  U+95C5  uni95C5,  CJK UNIFIED IDEOGRAPH-95C5
        0x95B7, # G+11949  U+95B7  uni95B7,  CJK UNIFIED IDEOGRAPH-95B7
        0x96AE, # G+11950  U+96AE  uni96AE,  CJK UNIFIED IDEOGRAPH-96AE
        0x96B0, # G+11951  U+96B0  uni96B0,  CJK UNIFIED IDEOGRAPH-96B0
        0x96AC, # G+11952  U+96AC  uni96AC,  CJK UNIFIED IDEOGRAPH-96AC
        0x9720, # G+11953  U+9720  uni9720,  CJK UNIFIED IDEOGRAPH-9720
        0x971F, # G+11954  U+971F  uni971F,  CJK UNIFIED IDEOGRAPH-971F
        0x9718, # G+11955  U+9718  uni9718,  CJK UNIFIED IDEOGRAPH-9718
        0x971D, # G+11956  U+971D  uni971D,  CJK UNIFIED IDEOGRAPH-971D
        0x9719, # G+11957  U+9719  uni9719,  CJK UNIFIED IDEOGRAPH-9719
        0x979A, # G+11958  U+979A  uni979A,  CJK UNIFIED IDEOGRAPH-979A
        0x97A1, # G+11959  U+97A1  uni97A1,  CJK UNIFIED IDEOGRAPH-97A1
        0x979C, # G+11960  U+979C  uni979C,  CJK UNIFIED IDEOGRAPH-979C
        0x979E, # G+11961  U+979E  uni979E,  CJK UNIFIED IDEOGRAPH-979E
        0x979D, # G+11962  U+979D  uni979D,  CJK UNIFIED IDEOGRAPH-979D
        0x97D5, # G+11963  U+97D5  uni97D5,  CJK UNIFIED IDEOGRAPH-97D5
        0x97D4, # G+11964  U+97D4  uni97D4,  CJK UNIFIED IDEOGRAPH-97D4
        0x97F1, # G+11965  U+97F1  uni97F1,  CJK UNIFIED IDEOGRAPH-97F1
        0x9841, # G+11966  U+9841  uni9841,  CJK UNIFIED IDEOGRAPH-9841
        0x9844, # G+11967  U+9844  uni9844,  CJK UNIFIED IDEOGRAPH-9844
        0x984A, # G+11968  U+984A  uni984A,  CJK UNIFIED IDEOGRAPH-984A
        0x9849, # G+11969  U+9849  uni9849,  CJK UNIFIED IDEOGRAPH-9849
        0x9845, # G+11970  U+9845  uni9845,  CJK UNIFIED IDEOGRAPH-9845
        0x9843, # G+11971  U+9843  uni9843,  CJK UNIFIED IDEOGRAPH-9843
        0x9925, # G+11972  U+9925  uni9925,  CJK UNIFIED IDEOGRAPH-9925
        0x992B, # G+11973  U+992B  uni992B,  CJK UNIFIED IDEOGRAPH-992B
        0x992C, # G+11974  U+992C  uni992C,  CJK UNIFIED IDEOGRAPH-992C
        0x992A, # G+11975  U+992A  uni992A,  CJK UNIFIED IDEOGRAPH-992A
        0x9933, # G+11976  U+9933  uni9933,  CJK UNIFIED IDEOGRAPH-9933
        0x9932, # G+11977  U+9932  uni9932,  CJK UNIFIED IDEOGRAPH-9932
        0x992F, # G+11978  U+992F  uni992F,  CJK UNIFIED IDEOGRAPH-992F
        0x992D, # G+11979  U+992D  uni992D,  CJK UNIFIED IDEOGRAPH-992D
        0x9931, # G+11980  U+9931  uni9931,  CJK UNIFIED IDEOGRAPH-9931
        0x9930, # G+11981  U+9930  uni9930,  CJK UNIFIED IDEOGRAPH-9930
        0x9998, # G+11982  U+9998  uni9998,  CJK UNIFIED IDEOGRAPH-9998
        0x99A3, # G+11983  U+99A3  uni99A3,  CJK UNIFIED IDEOGRAPH-99A3
        0x99A1, # G+11984  U+99A1  uni99A1,  CJK UNIFIED IDEOGRAPH-99A1
        0x9A02, # G+11985  U+9A02  uni9A02,  CJK UNIFIED IDEOGRAPH-9A02
        0x99FA, # G+11986  U+99FA  uni99FA,  CJK UNIFIED IDEOGRAPH-99FA
        0x99F4, # G+11987  U+99F4  uni99F4,  CJK UNIFIED IDEOGRAPH-99F4
        0x99F7, # G+11988  U+99F7  uni99F7,  CJK UNIFIED IDEOGRAPH-99F7
        0x99F9, # G+11989  U+99F9  uni99F9,  CJK UNIFIED IDEOGRAPH-99F9
        0x99F8, # G+11990  U+99F8  uni99F8,  CJK UNIFIED IDEOGRAPH-99F8
        0x99F6, # G+11991  U+99F6  uni99F6,  CJK UNIFIED IDEOGRAPH-99F6
        0x99FB, # G+11992  U+99FB  uni99FB,  CJK UNIFIED IDEOGRAPH-99FB
        0x99FD, # G+11993  U+99FD  uni99FD,  CJK UNIFIED IDEOGRAPH-99FD
        0x99FE, # G+11994  U+99FE  uni99FE,  CJK UNIFIED IDEOGRAPH-99FE
        0x99FC, # G+11995  U+99FC  uni99FC,  CJK UNIFIED IDEOGRAPH-99FC
        0x9A03, # G+11996  U+9A03  uni9A03,  CJK UNIFIED IDEOGRAPH-9A03
        0x9ABE, # G+11997  U+9ABE  uni9ABE,  CJK UNIFIED IDEOGRAPH-9ABE
        0x9AFE, # G+11998  U+9AFE  uni9AFE,  CJK UNIFIED IDEOGRAPH-9AFE
        0x9AFD, # G+11999  U+9AFD  uni9AFD,  CJK UNIFIED IDEOGRAPH-9AFD
        0x9B01, # G+12000  U+9B01  uni9B01,  CJK UNIFIED IDEOGRAPH-9B01
        0x9AFC, # G+12001  U+9AFC  uni9AFC,  CJK UNIFIED IDEOGRAPH-9AFC
        0x9B48, # G+12002  U+9B48  uni9B48,  CJK UNIFIED IDEOGRAPH-9B48
        0x9B9A, # G+12003  U+9B9A  uni9B9A,  CJK UNIFIED IDEOGRAPH-9B9A
        0x9BA8, # G+12004  U+9BA8  uni9BA8,  CJK UNIFIED IDEOGRAPH-9BA8
        0x9B9E, # G+12005  U+9B9E  uni9B9E,  CJK UNIFIED IDEOGRAPH-9B9E
        0x9B9B, # G+12006  U+9B9B  uni9B9B,  CJK UNIFIED IDEOGRAPH-9B9B
        0x9BA6, # G+12007  U+9BA6  uni9BA6,  CJK UNIFIED IDEOGRAPH-9BA6
        0x9BA1, # G+12008  U+9BA1  uni9BA1,  CJK UNIFIED IDEOGRAPH-9BA1
        0x9BA5, # G+12009  U+9BA5  uni9BA5,  CJK UNIFIED IDEOGRAPH-9BA5
        0x9BA4, # G+12010  U+9BA4  uni9BA4,  CJK UNIFIED IDEOGRAPH-9BA4
        0x9B86, # G+12011  U+9B86  uni9B86,  CJK UNIFIED IDEOGRAPH-9B86
        0x9BA2, # G+12012  U+9BA2  uni9BA2,  CJK UNIFIED IDEOGRAPH-9BA2
        0x9BA0, # G+12013  U+9BA0  uni9BA0,  CJK UNIFIED IDEOGRAPH-9BA0
        0x9BAF, # G+12014  U+9BAF  uni9BAF,  CJK UNIFIED IDEOGRAPH-9BAF
        0x9D33, # G+12015  U+9D33  uni9D33,  CJK UNIFIED IDEOGRAPH-9D33
        0x9D41, # G+12016  U+9D41  uni9D41,  CJK UNIFIED IDEOGRAPH-9D41
        0x9D67, # G+12017  U+9D67  uni9D67,  CJK UNIFIED IDEOGRAPH-9D67
        0x9D36, # G+12018  U+9D36  uni9D36,  CJK UNIFIED IDEOGRAPH-9D36
        0x9D2E, # G+12019  U+9D2E  uni9D2E,  CJK UNIFIED IDEOGRAPH-9D2E
        0x9D2F, # G+12020  U+9D2F  uni9D2F,  CJK UNIFIED IDEOGRAPH-9D2F
        0x9D31, # G+12021  U+9D31  uni9D31,  CJK UNIFIED IDEOGRAPH-9D31
        0x9D38, # G+12022  U+9D38  uni9D38,  CJK UNIFIED IDEOGRAPH-9D38
        0x9D30, # G+12023  U+9D30  uni9D30,  CJK UNIFIED IDEOGRAPH-9D30
        0x9D45, # G+12024  U+9D45  uni9D45,  CJK UNIFIED IDEOGRAPH-9D45
        0x9D42, # G+12025  U+9D42  uni9D42,  CJK UNIFIED IDEOGRAPH-9D42
        0x9D43, # G+12026  U+9D43  uni9D43,  CJK UNIFIED IDEOGRAPH-9D43
        0x9D3E, # G+12027  U+9D3E  uni9D3E,  CJK UNIFIED IDEOGRAPH-9D3E
        0x9D37, # G+12028  U+9D37  uni9D37,  CJK UNIFIED IDEOGRAPH-9D37
        0x9D40, # G+12029  U+9D40  uni9D40,  CJK UNIFIED IDEOGRAPH-9D40
        0x9D3D, # G+12030  U+9D3D  uni9D3D,  CJK UNIFIED IDEOGRAPH-9D3D
        0x7FF5, # G+12031  U+7FF5  uni7FF5,  CJK UNIFIED IDEOGRAPH-7FF5
        0x9D2D, # G+12032  U+9D2D  uni9D2D,  CJK UNIFIED IDEOGRAPH-9D2D
        0x9E8A, # G+12033  U+9E8A  uni9E8A,  CJK UNIFIED IDEOGRAPH-9E8A
        0x9E89, # G+12034  U+9E89  uni9E89,  CJK UNIFIED IDEOGRAPH-9E89
        0x9E8D, # G+12035  U+9E8D  uni9E8D,  CJK UNIFIED IDEOGRAPH-9E8D
        0x9EB0, # G+12036  U+9EB0  uni9EB0,  CJK UNIFIED IDEOGRAPH-9EB0
        0x9EC8, # G+12037  U+9EC8  uni9EC8,  CJK UNIFIED IDEOGRAPH-9EC8
        0x9EDA, # G+12038  U+9EDA  uni9EDA,  CJK UNIFIED IDEOGRAPH-9EDA
        0x9EFB, # G+12039  U+9EFB  uni9EFB,  CJK UNIFIED IDEOGRAPH-9EFB
        0x9EFF, # G+12040  U+9EFF  uni9EFF,  CJK UNIFIED IDEOGRAPH-9EFF
        0x9F24, # G+12041  U+9F24  uni9F24,  CJK UNIFIED IDEOGRAPH-9F24
        0x9F23, # G+12042  U+9F23  uni9F23,  CJK UNIFIED IDEOGRAPH-9F23
        0x9F22, # G+12043  U+9F22  uni9F22,  CJK UNIFIED IDEOGRAPH-9F22
        0x9F54, # G+12044  U+9F54  uni9F54,  CJK UNIFIED IDEOGRAPH-9F54
        0x2FD5, # G+12045  U+2FD5  uni2FD5,  KANGXI RADICAL FLUTE
        0x5131, # G+12046  U+5131  uni5131,  CJK UNIFIED IDEOGRAPH-5131
        0x512D, # G+12047  U+512D  uni512D,  CJK UNIFIED IDEOGRAPH-512D
        0x512E, # G+12048  U+512E  uni512E,  CJK UNIFIED IDEOGRAPH-512E
        0x5698, # G+12049  U+5698  uni5698,  CJK UNIFIED IDEOGRAPH-5698
        0x569C, # G+12050  U+569C  uni569C,  CJK UNIFIED IDEOGRAPH-569C
        0x5697, # G+12051  U+5697  uni5697,  CJK UNIFIED IDEOGRAPH-5697
        0x569A, # G+12052  U+569A  uni569A,  CJK UNIFIED IDEOGRAPH-569A
        0x569D, # G+12053  U+569D  uni569D,  CJK UNIFIED IDEOGRAPH-569D
        0x5699, # G+12054  U+5699  uni5699,  CJK UNIFIED IDEOGRAPH-5699
        0x5970, # G+12055  U+5970  uni5970,  CJK UNIFIED IDEOGRAPH-5970
        0x5B3C, # G+12056  U+5B3C  uni5B3C,  CJK UNIFIED IDEOGRAPH-5B3C
        0x5C69, # G+12057  U+5C69  uni5C69,  CJK UNIFIED IDEOGRAPH-5C69
        0x5C6A, # G+12058  U+5C6A  uni5C6A,  CJK UNIFIED IDEOGRAPH-5C6A
        0x5DC0, # G+12059  U+5DC0  uni5DC0,  CJK UNIFIED IDEOGRAPH-5DC0
        0x5E6D, # G+12060  U+5E6D  uni5E6D,  CJK UNIFIED IDEOGRAPH-5E6D
        0x5E6E, # G+12061  U+5E6E  uni5E6E,  CJK UNIFIED IDEOGRAPH-5E6E
        0x61D8, # G+12062  U+61D8  uni61D8,  CJK UNIFIED IDEOGRAPH-61D8
        0x61DF, # G+12063  U+61DF  uni61DF,  CJK UNIFIED IDEOGRAPH-61DF
        0x61ED, # G+12064  U+61ED  uni61ED,  CJK UNIFIED IDEOGRAPH-61ED
        0x61EE, # G+12065  U+61EE  uni61EE,  CJK UNIFIED IDEOGRAPH-61EE
        0x61F1, # G+12066  U+61F1  uni61F1,  CJK UNIFIED IDEOGRAPH-61F1
        0x61EA, # G+12067  U+61EA  uni61EA,  CJK UNIFIED IDEOGRAPH-61EA
        0x61F0, # G+12068  U+61F0  uni61F0,  CJK UNIFIED IDEOGRAPH-61F0
        0x61EB, # G+12069  U+61EB  uni61EB,  CJK UNIFIED IDEOGRAPH-61EB
        0x61D6, # G+12070  U+61D6  uni61D6,  CJK UNIFIED IDEOGRAPH-61D6
        0x61E9, # G+12071  U+61E9  uni61E9,  CJK UNIFIED IDEOGRAPH-61E9
        0x64FF, # G+12072  U+64FF  uni64FF,  CJK UNIFIED IDEOGRAPH-64FF
        0x6504, # G+12073  U+6504  uni6504,  CJK UNIFIED IDEOGRAPH-6504
        0x64FD, # G+12074  U+64FD  uni64FD,  CJK UNIFIED IDEOGRAPH-64FD
        0x64F8, # G+12075  U+64F8  uni64F8,  CJK UNIFIED IDEOGRAPH-64F8
        0x6501, # G+12076  U+6501  uni6501,  CJK UNIFIED IDEOGRAPH-6501
        0x6503, # G+12077  U+6503  uni6503,  CJK UNIFIED IDEOGRAPH-6503
        0x64FC, # G+12078  U+64FC  uni64FC,  CJK UNIFIED IDEOGRAPH-64FC
        0x6594, # G+12079  U+6594  uni6594,  CJK UNIFIED IDEOGRAPH-6594
        0x65DB, # G+12080  U+65DB  uni65DB,  CJK UNIFIED IDEOGRAPH-65DB
        0x66DA, # G+12081  U+66DA  uni66DA,  CJK UNIFIED IDEOGRAPH-66DA
        0x66DB, # G+12082  U+66DB  uni66DB,  CJK UNIFIED IDEOGRAPH-66DB
        0x66D8, # G+12083  U+66D8  uni66D8,  CJK UNIFIED IDEOGRAPH-66D8
        0x6AC5, # G+12084  U+6AC5  uni6AC5,  CJK UNIFIED IDEOGRAPH-6AC5
        0x6AB9, # G+12085  U+6AB9  uni6AB9,  CJK UNIFIED IDEOGRAPH-6AB9
        0x6ABD, # G+12086  U+6ABD  uni6ABD,  CJK UNIFIED IDEOGRAPH-6ABD
        0x6AE1, # G+12087  U+6AE1  uni6AE1,  CJK UNIFIED IDEOGRAPH-6AE1
        0x6AC6, # G+12088  U+6AC6  uni6AC6,  CJK UNIFIED IDEOGRAPH-6AC6
        0x6ABA, # G+12089  U+6ABA  uni6ABA,  CJK UNIFIED IDEOGRAPH-6ABA
        0x6AB6, # G+12090  U+6AB6  uni6AB6,  CJK UNIFIED IDEOGRAPH-6AB6
        0x6AB7, # G+12091  U+6AB7  uni6AB7,  CJK UNIFIED IDEOGRAPH-6AB7
        0x6AC7, # G+12092  U+6AC7  uni6AC7,  CJK UNIFIED IDEOGRAPH-6AC7
        0x6AB4, # G+12093  U+6AB4  uni6AB4,  CJK UNIFIED IDEOGRAPH-6AB4
        0x6AAD, # G+12094  U+6AAD  uni6AAD,  CJK UNIFIED IDEOGRAPH-6AAD
        0x6B5E, # G+12095  U+6B5E  uni6B5E,  CJK UNIFIED IDEOGRAPH-6B5E
        0x6BC9, # G+12096  U+6BC9  uni6BC9,  CJK UNIFIED IDEOGRAPH-6BC9
        0x6C0B, # G+12097  U+6C0B  uni6C0B,  CJK UNIFIED IDEOGRAPH-6C0B
        0x7007, # G+12098  U+7007  uni7007,  CJK UNIFIED IDEOGRAPH-7007
        0x700C, # G+12099  U+700C  uni700C,  CJK UNIFIED IDEOGRAPH-700C
        0x700D, # G+12100  U+700D  uni700D,  CJK UNIFIED IDEOGRAPH-700D
        0x7001, # G+12101  U+7001  uni7001,  CJK UNIFIED IDEOGRAPH-7001
        0x7005, # G+12102  U+7005  uni7005,  CJK UNIFIED IDEOGRAPH-7005
        0x7014, # G+12103  U+7014  uni7014,  CJK UNIFIED IDEOGRAPH-7014
        0x700E, # G+12104  U+700E  uni700E,  CJK UNIFIED IDEOGRAPH-700E
        0x6FFF, # G+12105  U+6FFF  uni6FFF,  CJK UNIFIED IDEOGRAPH-6FFF
        0x7000, # G+12106  U+7000  uni7000,  CJK UNIFIED IDEOGRAPH-7000
        0x6FFB, # G+12107  U+6FFB  uni6FFB,  CJK UNIFIED IDEOGRAPH-6FFB
        0x7026, # G+12108  U+7026  uni7026,  CJK UNIFIED IDEOGRAPH-7026
        0x6FFC, # G+12109  U+6FFC  uni6FFC,  CJK UNIFIED IDEOGRAPH-6FFC
        0x6FF7, # G+12110  U+6FF7  uni6FF7,  CJK UNIFIED IDEOGRAPH-6FF7
        0x700A, # G+12111  U+700A  uni700A,  CJK UNIFIED IDEOGRAPH-700A
        0x7201, # G+12112  U+7201  uni7201,  CJK UNIFIED IDEOGRAPH-7201
        0x71FF, # G+12113  U+71FF  uni71FF,  CJK UNIFIED IDEOGRAPH-71FF
        0x71F9, # G+12114  U+71F9  uni71F9,  CJK UNIFIED IDEOGRAPH-71F9
        0x7203, # G+12115  U+7203  uni7203,  CJK UNIFIED IDEOGRAPH-7203
        0x71FD, # G+12116  U+71FD  uni71FD,  CJK UNIFIED IDEOGRAPH-71FD
        0x7376, # G+12117  U+7376  uni7376,  CJK UNIFIED IDEOGRAPH-7376
        0x74B8, # G+12118  U+74B8  uni74B8,  CJK UNIFIED IDEOGRAPH-74B8
        0x74C0, # G+12119  U+74C0  uni74C0,  CJK UNIFIED IDEOGRAPH-74C0
        0x74B5, # G+12120  U+74B5  uni74B5,  CJK UNIFIED IDEOGRAPH-74B5
        0x74C1, # G+12121  U+74C1  uni74C1,  CJK UNIFIED IDEOGRAPH-74C1
        0x74BE, # G+12122  U+74BE  uni74BE,  CJK UNIFIED IDEOGRAPH-74BE
        0x74B6, # G+12123  U+74B6  uni74B6,  CJK UNIFIED IDEOGRAPH-74B6
        0x74BB, # G+12124  U+74BB  uni74BB,  CJK UNIFIED IDEOGRAPH-74BB
        0x74C2, # G+12125  U+74C2  uni74C2,  CJK UNIFIED IDEOGRAPH-74C2
        0x7514, # G+12126  U+7514  uni7514,  CJK UNIFIED IDEOGRAPH-7514
        0x7513, # G+12127  U+7513  uni7513,  CJK UNIFIED IDEOGRAPH-7513
        0x765C, # G+12128  U+765C  uni765C,  CJK UNIFIED IDEOGRAPH-765C
        0x7664, # G+12129  U+7664  uni7664,  CJK UNIFIED IDEOGRAPH-7664
        0x7659, # G+12130  U+7659  uni7659,  CJK UNIFIED IDEOGRAPH-7659
        0x7650, # G+12131  U+7650  uni7650,  CJK UNIFIED IDEOGRAPH-7650
        0x7653, # G+12132  U+7653  uni7653,  CJK UNIFIED IDEOGRAPH-7653
        0x7657, # G+12133  U+7657  uni7657,  CJK UNIFIED IDEOGRAPH-7657
        0x765A, # G+12134  U+765A  uni765A,  CJK UNIFIED IDEOGRAPH-765A
        0x76A6, # G+12135  U+76A6  uni76A6,  CJK UNIFIED IDEOGRAPH-76A6
        0x76BD, # G+12136  U+76BD  uni76BD,  CJK UNIFIED IDEOGRAPH-76BD
        0x76EC, # G+12137  U+76EC  uni76EC,  CJK UNIFIED IDEOGRAPH-76EC
        0x77C2, # G+12138  U+77C2  uni77C2,  CJK UNIFIED IDEOGRAPH-77C2
        0x77BA, # G+12139  U+77BA  uni77BA,  CJK UNIFIED IDEOGRAPH-77BA
        0x790C, # G+12140  U+790C  uni790C,  CJK UNIFIED IDEOGRAPH-790C
        0x7913, # G+12141  U+7913  uni7913,  CJK UNIFIED IDEOGRAPH-7913
        0x7914, # G+12142  U+7914  uni7914,  CJK UNIFIED IDEOGRAPH-7914
        0x7909, # G+12143  U+7909  uni7909,  CJK UNIFIED IDEOGRAPH-7909
        0x7910, # G+12144  U+7910  uni7910,  CJK UNIFIED IDEOGRAPH-7910
        0x7912, # G+12145  U+7912  uni7912,  CJK UNIFIED IDEOGRAPH-7912
        0x7911, # G+12146  U+7911  uni7911,  CJK UNIFIED IDEOGRAPH-7911
        0x79AD, # G+12147  U+79AD  uni79AD,  CJK UNIFIED IDEOGRAPH-79AD
        0x79AC, # G+12148  U+79AC  uni79AC,  CJK UNIFIED IDEOGRAPH-79AC
        0x7A5F, # G+12149  U+7A5F  uni7A5F,  CJK UNIFIED IDEOGRAPH-7A5F
        0x7C1C, # G+12150  U+7C1C  uni7C1C,  CJK UNIFIED IDEOGRAPH-7C1C
        0x7C29, # G+12151  U+7C29  uni7C29,  CJK UNIFIED IDEOGRAPH-7C29
        0x7C19, # G+12152  U+7C19  uni7C19,  CJK UNIFIED IDEOGRAPH-7C19
        0x7C20, # G+12153  U+7C20  uni7C20,  CJK UNIFIED IDEOGRAPH-7C20
        0x7C1F, # G+12154  U+7C1F  uni7C1F,  CJK UNIFIED IDEOGRAPH-7C1F
        0x7C2D, # G+12155  U+7C2D  uni7C2D,  CJK UNIFIED IDEOGRAPH-7C2D
        0x7C1D, # G+12156  U+7C1D  uni7C1D,  CJK UNIFIED IDEOGRAPH-7C1D
        0x7C26, # G+12157  U+7C26  uni7C26,  CJK UNIFIED IDEOGRAPH-7C26
        0x7C28, # G+12158  U+7C28  uni7C28,  CJK UNIFIED IDEOGRAPH-7C28
        0x7C22, # G+12159  U+7C22  uni7C22,  CJK UNIFIED IDEOGRAPH-7C22
        0x7C25, # G+12160  U+7C25  uni7C25,  CJK UNIFIED IDEOGRAPH-7C25
        0x7C30, # G+12161  U+7C30  uni7C30,  CJK UNIFIED IDEOGRAPH-7C30
        0x7E5C, # G+12162  U+7E5C  uni7E5C,  CJK UNIFIED IDEOGRAPH-7E5C
        0x7E50, # G+12163  U+7E50  uni7E50,  CJK UNIFIED IDEOGRAPH-7E50
        0x7E56, # G+12164  U+7E56  uni7E56,  CJK UNIFIED IDEOGRAPH-7E56
        0x7E63, # G+12165  U+7E63  uni7E63,  CJK UNIFIED IDEOGRAPH-7E63
        0x7E58, # G+12166  U+7E58  uni7E58,  CJK UNIFIED IDEOGRAPH-7E58
        0x7E62, # G+12167  U+7E62  uni7E62,  CJK UNIFIED IDEOGRAPH-7E62
        0x7E5F, # G+12168  U+7E5F  uni7E5F,  CJK UNIFIED IDEOGRAPH-7E5F
        0x7E51, # G+12169  U+7E51  uni7E51,  CJK UNIFIED IDEOGRAPH-7E51
        0x7E60, # G+12170  U+7E60  uni7E60,  CJK UNIFIED IDEOGRAPH-7E60
        0x7E57, # G+12171  U+7E57  uni7E57,  CJK UNIFIED IDEOGRAPH-7E57
        0x7E53, # G+12172  U+7E53  uni7E53,  CJK UNIFIED IDEOGRAPH-7E53
        0x7FB5, # G+12173  U+7FB5  uni7FB5,  CJK UNIFIED IDEOGRAPH-7FB5
        0x7FB3, # G+12174  U+7FB3  uni7FB3,  CJK UNIFIED IDEOGRAPH-7FB3
        0x7FF7, # G+12175  U+7FF7  uni7FF7,  CJK UNIFIED IDEOGRAPH-7FF7
        0x7FF8, # G+12176  U+7FF8  uni7FF8,  CJK UNIFIED IDEOGRAPH-7FF8
        0x8075, # G+12177  U+8075  uni8075,  CJK UNIFIED IDEOGRAPH-8075
        0x81D1, # G+12178  U+81D1  uni81D1,  CJK UNIFIED IDEOGRAPH-81D1
        0x81D2, # G+12179  U+81D2  uni81D2,  CJK UNIFIED IDEOGRAPH-81D2
        0x81D0, # G+12180  U+81D0  uni81D0,  CJK UNIFIED IDEOGRAPH-81D0
        0x825F, # G+12181  U+825F  uni825F,  CJK UNIFIED IDEOGRAPH-825F
        0x825E, # G+12182  U+825E  uni825E,  CJK UNIFIED IDEOGRAPH-825E
        0x85B4, # G+12183  U+85B4  uni85B4,  CJK UNIFIED IDEOGRAPH-85B4
        0x85C6, # G+12184  U+85C6  uni85C6,  CJK UNIFIED IDEOGRAPH-85C6
        0x85C0, # G+12185  U+85C0  uni85C0,  CJK UNIFIED IDEOGRAPH-85C0
        0x85C3, # G+12186  U+85C3  uni85C3,  CJK UNIFIED IDEOGRAPH-85C3
        0x85C2, # G+12187  U+85C2  uni85C2,  CJK UNIFIED IDEOGRAPH-85C2
        0x85B3, # G+12188  U+85B3  uni85B3,  CJK UNIFIED IDEOGRAPH-85B3
        0x85B5, # G+12189  U+85B5  uni85B5,  CJK UNIFIED IDEOGRAPH-85B5
        0x85BD, # G+12190  U+85BD  uni85BD,  CJK UNIFIED IDEOGRAPH-85BD
        0x85C7, # G+12191  U+85C7  uni85C7,  CJK UNIFIED IDEOGRAPH-85C7
        0x85C4, # G+12192  U+85C4  uni85C4,  CJK UNIFIED IDEOGRAPH-85C4
        0x85BF, # G+12193  U+85BF  uni85BF,  CJK UNIFIED IDEOGRAPH-85BF
        0x85CB, # G+12194  U+85CB  uni85CB,  CJK UNIFIED IDEOGRAPH-85CB
        0x85CE, # G+12195  U+85CE  uni85CE,  CJK UNIFIED IDEOGRAPH-85CE
        0x85C8, # G+12196  U+85C8  uni85C8,  CJK UNIFIED IDEOGRAPH-85C8
        0x85C5, # G+12197  U+85C5  uni85C5,  CJK UNIFIED IDEOGRAPH-85C5
        0x85B1, # G+12198  U+85B1  uni85B1,  CJK UNIFIED IDEOGRAPH-85B1
        0x85B6, # G+12199  U+85B6  uni85B6,  CJK UNIFIED IDEOGRAPH-85B6
        0x85D2, # G+12200  U+85D2  uni85D2,  CJK UNIFIED IDEOGRAPH-85D2
        0x8624, # G+12201  U+8624  uni8624,  CJK UNIFIED IDEOGRAPH-8624
        0x85B8, # G+12202  U+85B8  uni85B8,  CJK UNIFIED IDEOGRAPH-85B8
        0x85B7, # G+12203  U+85B7  uni85B7,  CJK UNIFIED IDEOGRAPH-85B7
        0x85BE, # G+12204  U+85BE  uni85BE,  CJK UNIFIED IDEOGRAPH-85BE
        0x8669, # G+12205  U+8669  uni8669,  CJK UNIFIED IDEOGRAPH-8669
        0x87E7, # G+12206  U+87E7  uni87E7,  CJK UNIFIED IDEOGRAPH-87E7
        0x87E6, # G+12207  U+87E6  uni87E6,  CJK UNIFIED IDEOGRAPH-87E6
        0x87E2, # G+12208  U+87E2  uni87E2,  CJK UNIFIED IDEOGRAPH-87E2
        0x87DB, # G+12209  U+87DB  uni87DB,  CJK UNIFIED IDEOGRAPH-87DB
        0x87EB, # G+12210  U+87EB  uni87EB,  CJK UNIFIED IDEOGRAPH-87EB
        0x87EA, # G+12211  U+87EA  uni87EA,  CJK UNIFIED IDEOGRAPH-87EA
        0x87E5, # G+12212  U+87E5  uni87E5,  CJK UNIFIED IDEOGRAPH-87E5
        0x87DF, # G+12213  U+87DF  uni87DF,  CJK UNIFIED IDEOGRAPH-87DF
        0x87F3, # G+12214  U+87F3  uni87F3,  CJK UNIFIED IDEOGRAPH-87F3
        0x87E4, # G+12215  U+87E4  uni87E4,  CJK UNIFIED IDEOGRAPH-87E4
        0x87D4, # G+12216  U+87D4  uni87D4,  CJK UNIFIED IDEOGRAPH-87D4
        0x87DC, # G+12217  U+87DC  uni87DC,  CJK UNIFIED IDEOGRAPH-87DC
        0x87D3, # G+12218  U+87D3  uni87D3,  CJK UNIFIED IDEOGRAPH-87D3
        0x87ED, # G+12219  U+87ED  uni87ED,  CJK UNIFIED IDEOGRAPH-87ED
        0x87D8, # G+12220  U+87D8  uni87D8,  CJK UNIFIED IDEOGRAPH-87D8
        0x87E3, # G+12221  U+87E3  uni87E3,  CJK UNIFIED IDEOGRAPH-87E3
        0x87D7, # G+12222  U+87D7  uni87D7,  CJK UNIFIED IDEOGRAPH-87D7
        0x87D9, # G+12223  U+87D9  uni87D9,  CJK UNIFIED IDEOGRAPH-87D9
        0x8801, # G+12224  U+8801  uni8801,  CJK UNIFIED IDEOGRAPH-8801
        0x87F4, # G+12225  U+87F4  uni87F4,  CJK UNIFIED IDEOGRAPH-87F4
        0x87E8, # G+12226  U+87E8  uni87E8,  CJK UNIFIED IDEOGRAPH-87E8
        0x87DD, # G+12227  U+87DD  uni87DD,  CJK UNIFIED IDEOGRAPH-87DD
        0x8953, # G+12228  U+8953  uni8953,  CJK UNIFIED IDEOGRAPH-8953
        0x894B, # G+12229  U+894B  uni894B,  CJK UNIFIED IDEOGRAPH-894B
        0x894F, # G+12230  U+894F  uni894F,  CJK UNIFIED IDEOGRAPH-894F
        0x894C, # G+12231  U+894C  uni894C,  CJK UNIFIED IDEOGRAPH-894C
        0x8946, # G+12232  U+8946  uni8946,  CJK UNIFIED IDEOGRAPH-8946
        0x8950, # G+12233  U+8950  uni8950,  CJK UNIFIED IDEOGRAPH-8950
        0x8951, # G+12234  U+8951  uni8951,  CJK UNIFIED IDEOGRAPH-8951
        0x8949, # G+12235  U+8949  uni8949,  CJK UNIFIED IDEOGRAPH-8949
        0x8B2A, # G+12236  U+8B2A  uni8B2A,  CJK UNIFIED IDEOGRAPH-8B2A
        0x8B27, # G+12237  U+8B27  uni8B27,  CJK UNIFIED IDEOGRAPH-8B27
        0x8B23, # G+12238  U+8B23  uni8B23,  CJK UNIFIED IDEOGRAPH-8B23
        0x8B33, # G+12239  U+8B33  uni8B33,  CJK UNIFIED IDEOGRAPH-8B33
        0x8B30, # G+12240  U+8B30  uni8B30,  CJK UNIFIED IDEOGRAPH-8B30
        0x8B35, # G+12241  U+8B35  uni8B35,  CJK UNIFIED IDEOGRAPH-8B35
        0x8B47, # G+12242  U+8B47  uni8B47,  CJK UNIFIED IDEOGRAPH-8B47
        0x8B2F, # G+12243  U+8B2F  uni8B2F,  CJK UNIFIED IDEOGRAPH-8B2F
        0x8B3C, # G+12244  U+8B3C  uni8B3C,  CJK UNIFIED IDEOGRAPH-8B3C
        0x8B3E, # G+12245  U+8B3E  uni8B3E,  CJK UNIFIED IDEOGRAPH-8B3E
        0x8B31, # G+12246  U+8B31  uni8B31,  CJK UNIFIED IDEOGRAPH-8B31
        0x8B25, # G+12247  U+8B25  uni8B25,  CJK UNIFIED IDEOGRAPH-8B25
        0x8B37, # G+12248  U+8B37  uni8B37,  CJK UNIFIED IDEOGRAPH-8B37
        0x8B26, # G+12249  U+8B26  uni8B26,  CJK UNIFIED IDEOGRAPH-8B26
        0x8B36, # G+12250  U+8B36  uni8B36,  CJK UNIFIED IDEOGRAPH-8B36
        0x8B2E, # G+12251  U+8B2E  uni8B2E,  CJK UNIFIED IDEOGRAPH-8B2E
        0x8B24, # G+12252  U+8B24  uni8B24,  CJK UNIFIED IDEOGRAPH-8B24
        0x8B3B, # G+12253  U+8B3B  uni8B3B,  CJK UNIFIED IDEOGRAPH-8B3B
        0x8B3D, # G+12254  U+8B3D  uni8B3D,  CJK UNIFIED IDEOGRAPH-8B3D
        0x8B3A, # G+12255  U+8B3A  uni8B3A,  CJK UNIFIED IDEOGRAPH-8B3A
        0x8C42, # G+12256  U+8C42  uni8C42,  CJK UNIFIED IDEOGRAPH-8C42
        0x8C75, # G+12257  U+8C75  uni8C75,  CJK UNIFIED IDEOGRAPH-8C75
        0x8C99, # G+12258  U+8C99  uni8C99,  CJK UNIFIED IDEOGRAPH-8C99
        0x8C98, # G+12259  U+8C98  uni8C98,  CJK UNIFIED IDEOGRAPH-8C98
        0x8C97, # G+12260  U+8C97  uni8C97,  CJK UNIFIED IDEOGRAPH-8C97
        0x8CFE, # G+12261  U+8CFE  uni8CFE,  CJK UNIFIED IDEOGRAPH-8CFE
        0x8D04, # G+12262  U+8D04  uni8D04,  CJK UNIFIED IDEOGRAPH-8D04
        0x8D02, # G+12263  U+8D02  uni8D02,  CJK UNIFIED IDEOGRAPH-8D02
        0x8D00, # G+12264  U+8D00  uni8D00,  CJK UNIFIED IDEOGRAPH-8D00
        0x8E5C, # G+12265  U+8E5C  uni8E5C,  CJK UNIFIED IDEOGRAPH-8E5C
        0x8E62, # G+12266  U+8E62  uni8E62,  CJK UNIFIED IDEOGRAPH-8E62
        0x8E60, # G+12267  U+8E60  uni8E60,  CJK UNIFIED IDEOGRAPH-8E60
        0x8E57, # G+12268  U+8E57  uni8E57,  CJK UNIFIED IDEOGRAPH-8E57
        0x8E56, # G+12269  U+8E56  uni8E56,  CJK UNIFIED IDEOGRAPH-8E56
        0x8E5E, # G+12270  U+8E5E  uni8E5E,  CJK UNIFIED IDEOGRAPH-8E5E
        0x8E65, # G+12271  U+8E65  uni8E65,  CJK UNIFIED IDEOGRAPH-8E65
        0x8E67, # G+12272  U+8E67  uni8E67,  CJK UNIFIED IDEOGRAPH-8E67
        0x8E5B, # G+12273  U+8E5B  uni8E5B,  CJK UNIFIED IDEOGRAPH-8E5B
        0x8E5A, # G+12274  U+8E5A  uni8E5A,  CJK UNIFIED IDEOGRAPH-8E5A
        0x8E61, # G+12275  U+8E61  uni8E61,  CJK UNIFIED IDEOGRAPH-8E61
        0x8E5D, # G+12276  U+8E5D  uni8E5D,  CJK UNIFIED IDEOGRAPH-8E5D
        0x8E69, # G+12277  U+8E69  uni8E69,  CJK UNIFIED IDEOGRAPH-8E69
        0x8E54, # G+12278  U+8E54  uni8E54,  CJK UNIFIED IDEOGRAPH-8E54
        0x8F46, # G+12279  U+8F46  uni8F46,  CJK UNIFIED IDEOGRAPH-8F46
        0x8F47, # G+12280  U+8F47  uni8F47,  CJK UNIFIED IDEOGRAPH-8F47
        0x8F48, # G+12281  U+8F48  uni8F48,  CJK UNIFIED IDEOGRAPH-8F48
        0x8F4B, # G+12282  U+8F4B  uni8F4B,  CJK UNIFIED IDEOGRAPH-8F4B
        0x9128, # G+12283  U+9128  uni9128,  CJK UNIFIED IDEOGRAPH-9128
        0x913A, # G+12284  U+913A  uni913A,  CJK UNIFIED IDEOGRAPH-913A
        0x913B, # G+12285  U+913B  uni913B,  CJK UNIFIED IDEOGRAPH-913B
        0x913E, # G+12286  U+913E  uni913E,  CJK UNIFIED IDEOGRAPH-913E
        0x91A8, # G+12287  U+91A8  uni91A8,  CJK UNIFIED IDEOGRAPH-91A8
        0x91A5, # G+12288  U+91A5  uni91A5,  CJK UNIFIED IDEOGRAPH-91A5
        0x91A7, # G+12289  U+91A7  uni91A7,  CJK UNIFIED IDEOGRAPH-91A7
        0x91AF, # G+12290  U+91AF  uni91AF,  CJK UNIFIED IDEOGRAPH-91AF
        0x91AA, # G+12291  U+91AA  uni91AA,  CJK UNIFIED IDEOGRAPH-91AA
        0x93B5, # G+12292  U+93B5  uni93B5,  CJK UNIFIED IDEOGRAPH-93B5
        0x938C, # G+12293  U+938C  uni938C,  CJK UNIFIED IDEOGRAPH-938C
        0x9392, # G+12294  U+9392  uni9392,  CJK UNIFIED IDEOGRAPH-9392
        0x93B7, # G+12295  U+93B7  uni93B7,  CJK UNIFIED IDEOGRAPH-93B7
        0x939B, # G+12296  U+939B  uni939B,  CJK UNIFIED IDEOGRAPH-939B
        0x939D, # G+12297  U+939D  uni939D,  CJK UNIFIED IDEOGRAPH-939D
        0x9389, # G+12298  U+9389  uni9389,  CJK UNIFIED IDEOGRAPH-9389
        0x93A7, # G+12299  U+93A7  uni93A7,  CJK UNIFIED IDEOGRAPH-93A7
        0x938E, # G+12300  U+938E  uni938E,  CJK UNIFIED IDEOGRAPH-938E
        0x93AA, # G+12301  U+93AA  uni93AA,  CJK UNIFIED IDEOGRAPH-93AA
        0x939E, # G+12302  U+939E  uni939E,  CJK UNIFIED IDEOGRAPH-939E
        0x93A6, # G+12303  U+93A6  uni93A6,  CJK UNIFIED IDEOGRAPH-93A6
        0x9395, # G+12304  U+9395  uni9395,  CJK UNIFIED IDEOGRAPH-9395
        0x9388, # G+12305  U+9388  uni9388,  CJK UNIFIED IDEOGRAPH-9388
        0x9399, # G+12306  U+9399  uni9399,  CJK UNIFIED IDEOGRAPH-9399
        0x939F, # G+12307  U+939F  uni939F,  CJK UNIFIED IDEOGRAPH-939F
        0x9380, # G+12308  U+9380  uni9380,  CJK UNIFIED IDEOGRAPH-9380
        0x938D, # G+12309  U+938D  uni938D,  CJK UNIFIED IDEOGRAPH-938D
        0x93B1, # G+12310  U+93B1  uni93B1,  CJK UNIFIED IDEOGRAPH-93B1
        0x9391, # G+12311  U+9391  uni9391,  CJK UNIFIED IDEOGRAPH-9391
        0x93B2, # G+12312  U+93B2  uni93B2,  CJK UNIFIED IDEOGRAPH-93B2
        0x93A4, # G+12313  U+93A4  uni93A4,  CJK UNIFIED IDEOGRAPH-93A4
        0x93A8, # G+12314  U+93A8  uni93A8,  CJK UNIFIED IDEOGRAPH-93A8
        0x93B4, # G+12315  U+93B4  uni93B4,  CJK UNIFIED IDEOGRAPH-93B4
        0x93A3, # G+12316  U+93A3  uni93A3,  CJK UNIFIED IDEOGRAPH-93A3
        0x95D2, # G+12317  U+95D2  uni95D2,  CJK UNIFIED IDEOGRAPH-95D2
        0x95D3, # G+12318  U+95D3  uni95D3,  CJK UNIFIED IDEOGRAPH-95D3
        0x95D1, # G+12319  U+95D1  uni95D1,  CJK UNIFIED IDEOGRAPH-95D1
        0x96B3, # G+12320  U+96B3  uni96B3,  CJK UNIFIED IDEOGRAPH-96B3
        0x96D7, # G+12321  U+96D7  uni96D7,  CJK UNIFIED IDEOGRAPH-96D7
        0x96DA, # G+12322  U+96DA  uni96DA,  CJK UNIFIED IDEOGRAPH-96DA
        0x5DC2, # G+12323  U+5DC2  uni5DC2,  CJK UNIFIED IDEOGRAPH-5DC2
        0x96DF, # G+12324  U+96DF  uni96DF,  CJK UNIFIED IDEOGRAPH-96DF
        0x96D8, # G+12325  U+96D8  uni96D8,  CJK UNIFIED IDEOGRAPH-96D8
        0x96DD, # G+12326  U+96DD  uni96DD,  CJK UNIFIED IDEOGRAPH-96DD
        0x9723, # G+12327  U+9723  uni9723,  CJK UNIFIED IDEOGRAPH-9723
        0x9722, # G+12328  U+9722  uni9722,  CJK UNIFIED IDEOGRAPH-9722
        0x9725, # G+12329  U+9725  uni9725,  CJK UNIFIED IDEOGRAPH-9725
        0x97AC, # G+12330  U+97AC  uni97AC,  CJK UNIFIED IDEOGRAPH-97AC
        0x97AE, # G+12331  U+97AE  uni97AE,  CJK UNIFIED IDEOGRAPH-97AE
        0x97A8, # G+12332  U+97A8  uni97A8,  CJK UNIFIED IDEOGRAPH-97A8
        0x97AB, # G+12333  U+97AB  uni97AB,  CJK UNIFIED IDEOGRAPH-97AB
        0x97A4, # G+12334  U+97A4  uni97A4,  CJK UNIFIED IDEOGRAPH-97A4
        0x97AA, # G+12335  U+97AA  uni97AA,  CJK UNIFIED IDEOGRAPH-97AA
        0x97A2, # G+12336  U+97A2  uni97A2,  CJK UNIFIED IDEOGRAPH-97A2
        0x97A5, # G+12337  U+97A5  uni97A5,  CJK UNIFIED IDEOGRAPH-97A5
        0x97D7, # G+12338  U+97D7  uni97D7,  CJK UNIFIED IDEOGRAPH-97D7
        0x97D9, # G+12339  U+97D9  uni97D9,  CJK UNIFIED IDEOGRAPH-97D9
        0x97D6, # G+12340  U+97D6  uni97D6,  CJK UNIFIED IDEOGRAPH-97D6
        0x97D8, # G+12341  U+97D8  uni97D8,  CJK UNIFIED IDEOGRAPH-97D8
        0x97FA, # G+12342  U+97FA  uni97FA,  CJK UNIFIED IDEOGRAPH-97FA
        0x9850, # G+12343  U+9850  uni9850,  CJK UNIFIED IDEOGRAPH-9850
        0x9851, # G+12344  U+9851  uni9851,  CJK UNIFIED IDEOGRAPH-9851
        0x9852, # G+12345  U+9852  uni9852,  CJK UNIFIED IDEOGRAPH-9852
        0x98B8, # G+12346  U+98B8  uni98B8,  CJK UNIFIED IDEOGRAPH-98B8
        0x9941, # G+12347  U+9941  uni9941,  CJK UNIFIED IDEOGRAPH-9941
        0x993C, # G+12348  U+993C  uni993C,  CJK UNIFIED IDEOGRAPH-993C
        0x993A, # G+12349  U+993A  uni993A,  CJK UNIFIED IDEOGRAPH-993A
        0x9A0F, # G+12350  U+9A0F  uni9A0F,  CJK UNIFIED IDEOGRAPH-9A0F
        0x9A0B, # G+12351  U+9A0B  uni9A0B,  CJK UNIFIED IDEOGRAPH-9A0B
        0x9A09, # G+12352  U+9A09  uni9A09,  CJK UNIFIED IDEOGRAPH-9A09
        0x9A0D, # G+12353  U+9A0D  uni9A0D,  CJK UNIFIED IDEOGRAPH-9A0D
        0x9A04, # G+12354  U+9A04  uni9A04,  CJK UNIFIED IDEOGRAPH-9A04
        0x9A11, # G+12355  U+9A11  uni9A11,  CJK UNIFIED IDEOGRAPH-9A11
        0x9A0A, # G+12356  U+9A0A  uni9A0A,  CJK UNIFIED IDEOGRAPH-9A0A
        0x9A05, # G+12357  U+9A05  uni9A05,  CJK UNIFIED IDEOGRAPH-9A05
        0x9A07, # G+12358  U+9A07  uni9A07,  CJK UNIFIED IDEOGRAPH-9A07
        0x9A06, # G+12359  U+9A06  uni9A06,  CJK UNIFIED IDEOGRAPH-9A06
        0x9AC0, # G+12360  U+9AC0  uni9AC0,  CJK UNIFIED IDEOGRAPH-9AC0
        0x9ADC, # G+12361  U+9ADC  uni9ADC,  CJK UNIFIED IDEOGRAPH-9ADC
        0x9B08, # G+12362  U+9B08  uni9B08,  CJK UNIFIED IDEOGRAPH-9B08
        0x9B04, # G+12363  U+9B04  uni9B04,  CJK UNIFIED IDEOGRAPH-9B04
        0x9B05, # G+12364  U+9B05  uni9B05,  CJK UNIFIED IDEOGRAPH-9B05
        0x9B29, # G+12365  U+9B29  uni9B29,  CJK UNIFIED IDEOGRAPH-9B29
        0x9B35, # G+12366  U+9B35  uni9B35,  CJK UNIFIED IDEOGRAPH-9B35
        0x9B4A, # G+12367  U+9B4A  uni9B4A,  CJK UNIFIED IDEOGRAPH-9B4A
        0x9B4C, # G+12368  U+9B4C  uni9B4C,  CJK UNIFIED IDEOGRAPH-9B4C
        0x9B4B, # G+12369  U+9B4B  uni9B4B,  CJK UNIFIED IDEOGRAPH-9B4B
        0x9BC7, # G+12370  U+9BC7  uni9BC7,  CJK UNIFIED IDEOGRAPH-9BC7
        0x9BC6, # G+12371  U+9BC6  uni9BC6,  CJK UNIFIED IDEOGRAPH-9BC6
        0x9BC3, # G+12372  U+9BC3  uni9BC3,  CJK UNIFIED IDEOGRAPH-9BC3
        0x9BBF, # G+12373  U+9BBF  uni9BBF,  CJK UNIFIED IDEOGRAPH-9BBF
        0x9BC1, # G+12374  U+9BC1  uni9BC1,  CJK UNIFIED IDEOGRAPH-9BC1
        0x9BB5, # G+12375  U+9BB5  uni9BB5,  CJK UNIFIED IDEOGRAPH-9BB5
        0x9BB8, # G+12376  U+9BB8  uni9BB8,  CJK UNIFIED IDEOGRAPH-9BB8
        0x9BD3, # G+12377  U+9BD3  uni9BD3,  CJK UNIFIED IDEOGRAPH-9BD3
        0x9BB6, # G+12378  U+9BB6  uni9BB6,  CJK UNIFIED IDEOGRAPH-9BB6
        0x9BC4, # G+12379  U+9BC4  uni9BC4,  CJK UNIFIED IDEOGRAPH-9BC4
        0x9BB9, # G+12380  U+9BB9  uni9BB9,  CJK UNIFIED IDEOGRAPH-9BB9
        0x9BBD, # G+12381  U+9BBD  uni9BBD,  CJK UNIFIED IDEOGRAPH-9BBD
        0x9D5C, # G+12382  U+9D5C  uni9D5C,  CJK UNIFIED IDEOGRAPH-9D5C
        0x9D53, # G+12383  U+9D53  uni9D53,  CJK UNIFIED IDEOGRAPH-9D53
        0x9D4F, # G+12384  U+9D4F  uni9D4F,  CJK UNIFIED IDEOGRAPH-9D4F
        0x9D4A, # G+12385  U+9D4A  uni9D4A,  CJK UNIFIED IDEOGRAPH-9D4A
        0x9D5B, # G+12386  U+9D5B  uni9D5B,  CJK UNIFIED IDEOGRAPH-9D5B
        0x9D4B, # G+12387  U+9D4B  uni9D4B,  CJK UNIFIED IDEOGRAPH-9D4B
        0x9D59, # G+12388  U+9D59  uni9D59,  CJK UNIFIED IDEOGRAPH-9D59
        0x9D56, # G+12389  U+9D56  uni9D56,  CJK UNIFIED IDEOGRAPH-9D56
        0x9D4C, # G+12390  U+9D4C  uni9D4C,  CJK UNIFIED IDEOGRAPH-9D4C
        0x9D57, # G+12391  U+9D57  uni9D57,  CJK UNIFIED IDEOGRAPH-9D57
        0x9D52, # G+12392  U+9D52  uni9D52,  CJK UNIFIED IDEOGRAPH-9D52
        0x9D54, # G+12393  U+9D54  uni9D54,  CJK UNIFIED IDEOGRAPH-9D54
        0x9D5F, # G+12394  U+9D5F  uni9D5F,  CJK UNIFIED IDEOGRAPH-9D5F
        0x9D58, # G+12395  U+9D58  uni9D58,  CJK UNIFIED IDEOGRAPH-9D58
        0x9D5A, # G+12396  U+9D5A  uni9D5A,  CJK UNIFIED IDEOGRAPH-9D5A
        0x9E8E, # G+12397  U+9E8E  uni9E8E,  CJK UNIFIED IDEOGRAPH-9E8E
        0x9E8C, # G+12398  U+9E8C  uni9E8C,  CJK UNIFIED IDEOGRAPH-9E8C
        0x9EDF, # G+12399  U+9EDF  uni9EDF,  CJK UNIFIED IDEOGRAPH-9EDF
        0x9F01, # G+12400  U+9F01  uni9F01,  CJK UNIFIED IDEOGRAPH-9F01
        0x9F00, # G+12401  U+9F00  uni9F00,  CJK UNIFIED IDEOGRAPH-9F00
        0x9F16, # G+12402  U+9F16  uni9F16,  CJK UNIFIED IDEOGRAPH-9F16
        0x9F25, # G+12403  U+9F25  uni9F25,  CJK UNIFIED IDEOGRAPH-9F25
        0x9F2B, # G+12404  U+9F2B  uni9F2B,  CJK UNIFIED IDEOGRAPH-9F2B
        0x9F2A, # G+12405  U+9F2A  uni9F2A,  CJK UNIFIED IDEOGRAPH-9F2A
        0x9F29, # G+12406  U+9F29  uni9F29,  CJK UNIFIED IDEOGRAPH-9F29
        0x9F28, # G+12407  U+9F28  uni9F28,  CJK UNIFIED IDEOGRAPH-9F28
        0x9F4C, # G+12408  U+9F4C  uni9F4C,  CJK UNIFIED IDEOGRAPH-9F4C
        0x9F55, # G+12409  U+9F55  uni9F55,  CJK UNIFIED IDEOGRAPH-9F55
        0x5134, # G+12410  U+5134  uni5134,  CJK UNIFIED IDEOGRAPH-5134
        0x5135, # G+12411  U+5135  uni5135,  CJK UNIFIED IDEOGRAPH-5135
        0x5296, # G+12412  U+5296  uni5296,  CJK UNIFIED IDEOGRAPH-5296
        0x52F7, # G+12413  U+52F7  uni52F7,  CJK UNIFIED IDEOGRAPH-52F7
        0x53B4, # G+12414  U+53B4  uni53B4,  CJK UNIFIED IDEOGRAPH-53B4
        0x56AB, # G+12415  U+56AB  uni56AB,  CJK UNIFIED IDEOGRAPH-56AB
        0x56AD, # G+12416  U+56AD  uni56AD,  CJK UNIFIED IDEOGRAPH-56AD
        0x56A6, # G+12417  U+56A6  uni56A6,  CJK UNIFIED IDEOGRAPH-56A6
        0x56A7, # G+12418  U+56A7  uni56A7,  CJK UNIFIED IDEOGRAPH-56A7
        0x56AA, # G+12419  U+56AA  uni56AA,  CJK UNIFIED IDEOGRAPH-56AA
        0x56AC, # G+12420  U+56AC  uni56AC,  CJK UNIFIED IDEOGRAPH-56AC
        0x58DA, # G+12421  U+58DA  uni58DA,  CJK UNIFIED IDEOGRAPH-58DA
        0x58DD, # G+12422  U+58DD  uni58DD,  CJK UNIFIED IDEOGRAPH-58DD
        0x58DB, # G+12423  U+58DB  uni58DB,  CJK UNIFIED IDEOGRAPH-58DB
        0x5912, # G+12424  U+5912  uni5912,  CJK UNIFIED IDEOGRAPH-5912
        0x5B3D, # G+12425  U+5B3D  uni5B3D,  CJK UNIFIED IDEOGRAPH-5B3D
        0x5B3E, # G+12426  U+5B3E  uni5B3E,  CJK UNIFIED IDEOGRAPH-5B3E
        0x5B3F, # G+12427  U+5B3F  uni5B3F,  CJK UNIFIED IDEOGRAPH-5B3F
        0x5DC3, # G+12428  U+5DC3  uni5DC3,  CJK UNIFIED IDEOGRAPH-5DC3
        0x5E70, # G+12429  U+5E70  uni5E70,  CJK UNIFIED IDEOGRAPH-5E70
        0x5FBF, # G+12430  U+5FBF  uni5FBF,  CJK UNIFIED IDEOGRAPH-5FBF
        0x61FB, # G+12431  U+61FB  uni61FB,  CJK UNIFIED IDEOGRAPH-61FB
        0x6507, # G+12432  U+6507  uni6507,  CJK UNIFIED IDEOGRAPH-6507
        0x6510, # G+12433  U+6510  uni6510,  CJK UNIFIED IDEOGRAPH-6510
        0x650D, # G+12434  U+650D  uni650D,  CJK UNIFIED IDEOGRAPH-650D
        0x6509, # G+12435  U+6509  uni6509,  CJK UNIFIED IDEOGRAPH-6509
        0x650C, # G+12436  U+650C  uni650C,  CJK UNIFIED IDEOGRAPH-650C
        0x650E, # G+12437  U+650E  uni650E,  CJK UNIFIED IDEOGRAPH-650E
        0x6584, # G+12438  U+6584  uni6584,  CJK UNIFIED IDEOGRAPH-6584
        0x65DE, # G+12439  U+65DE  uni65DE,  CJK UNIFIED IDEOGRAPH-65DE
        0x65DD, # G+12440  U+65DD  uni65DD,  CJK UNIFIED IDEOGRAPH-65DD
        0x66DE, # G+12441  U+66DE  uni66DE,  CJK UNIFIED IDEOGRAPH-66DE
        0x6AE7, # G+12442  U+6AE7  uni6AE7,  CJK UNIFIED IDEOGRAPH-6AE7
        0x6AE0, # G+12443  U+6AE0  uni6AE0,  CJK UNIFIED IDEOGRAPH-6AE0
        0x6ACC, # G+12444  U+6ACC  uni6ACC,  CJK UNIFIED IDEOGRAPH-6ACC
        0x6AD1, # G+12445  U+6AD1  uni6AD1,  CJK UNIFIED IDEOGRAPH-6AD1
        0x6AD9, # G+12446  U+6AD9  uni6AD9,  CJK UNIFIED IDEOGRAPH-6AD9
        0x6ACB, # G+12447  U+6ACB  uni6ACB,  CJK UNIFIED IDEOGRAPH-6ACB
        0x6ADF, # G+12448  U+6ADF  uni6ADF,  CJK UNIFIED IDEOGRAPH-6ADF
        0x6ADC, # G+12449  U+6ADC  uni6ADC,  CJK UNIFIED IDEOGRAPH-6ADC
        0x6AD0, # G+12450  U+6AD0  uni6AD0,  CJK UNIFIED IDEOGRAPH-6AD0
        0x6AEB, # G+12451  U+6AEB  uni6AEB,  CJK UNIFIED IDEOGRAPH-6AEB
        0x6ACF, # G+12452  U+6ACF  uni6ACF,  CJK UNIFIED IDEOGRAPH-6ACF
        0x6ACD, # G+12453  U+6ACD  uni6ACD,  CJK UNIFIED IDEOGRAPH-6ACD
        0x6ADE, # G+12454  U+6ADE  uni6ADE,  CJK UNIFIED IDEOGRAPH-6ADE
        0x6B60, # G+12455  U+6B60  uni6B60,  CJK UNIFIED IDEOGRAPH-6B60
        0x6BB0, # G+12456  U+6BB0  uni6BB0,  CJK UNIFIED IDEOGRAPH-6BB0
        0x6C0C, # G+12457  U+6C0C  uni6C0C,  CJK UNIFIED IDEOGRAPH-6C0C
        0x7019, # G+12458  U+7019  uni7019,  CJK UNIFIED IDEOGRAPH-7019
        0x7027, # G+12459  U+7027  uni7027,  CJK UNIFIED IDEOGRAPH-7027
        0x7020, # G+12460  U+7020  uni7020,  CJK UNIFIED IDEOGRAPH-7020
        0x7016, # G+12461  U+7016  uni7016,  CJK UNIFIED IDEOGRAPH-7016
        0x702B, # G+12462  U+702B  uni702B,  CJK UNIFIED IDEOGRAPH-702B
        0x7021, # G+12463  U+7021  uni7021,  CJK UNIFIED IDEOGRAPH-7021
        0x7022, # G+12464  U+7022  uni7022,  CJK UNIFIED IDEOGRAPH-7022
        0x7023, # G+12465  U+7023  uni7023,  CJK UNIFIED IDEOGRAPH-7023
        0x7029, # G+12466  U+7029  uni7029,  CJK UNIFIED IDEOGRAPH-7029
        0x7017, # G+12467  U+7017  uni7017,  CJK UNIFIED IDEOGRAPH-7017
        0x7024, # G+12468  U+7024  uni7024,  CJK UNIFIED IDEOGRAPH-7024
        0x701C, # G+12469  U+701C  uni701C,  CJK UNIFIED IDEOGRAPH-701C
        0x720C, # G+12470  U+720C  uni720C,  CJK UNIFIED IDEOGRAPH-720C
        0x720A, # G+12471  U+720A  uni720A,  CJK UNIFIED IDEOGRAPH-720A
        0x7207, # G+12472  U+7207  uni7207,  CJK UNIFIED IDEOGRAPH-7207
        0x7202, # G+12473  U+7202  uni7202,  CJK UNIFIED IDEOGRAPH-7202
        0x7205, # G+12474  U+7205  uni7205,  CJK UNIFIED IDEOGRAPH-7205
        0x72A5, # G+12475  U+72A5  uni72A5,  CJK UNIFIED IDEOGRAPH-72A5
        0x72A6, # G+12476  U+72A6  uni72A6,  CJK UNIFIED IDEOGRAPH-72A6
        0x72A4, # G+12477  U+72A4  uni72A4,  CJK UNIFIED IDEOGRAPH-72A4
        0x72A3, # G+12478  U+72A3  uni72A3,  CJK UNIFIED IDEOGRAPH-72A3
        0x72A1, # G+12479  U+72A1  uni72A1,  CJK UNIFIED IDEOGRAPH-72A1
        0x74CB, # G+12480  U+74CB  uni74CB,  CJK UNIFIED IDEOGRAPH-74CB
        0x74C5, # G+12481  U+74C5  uni74C5,  CJK UNIFIED IDEOGRAPH-74C5
        0x74B7, # G+12482  U+74B7  uni74B7,  CJK UNIFIED IDEOGRAPH-74B7
        0x74C3, # G+12483  U+74C3  uni74C3,  CJK UNIFIED IDEOGRAPH-74C3
        0x7516, # G+12484  U+7516  uni7516,  CJK UNIFIED IDEOGRAPH-7516
        0x7660, # G+12485  U+7660  uni7660,  CJK UNIFIED IDEOGRAPH-7660
        0x77C9, # G+12486  U+77C9  uni77C9,  CJK UNIFIED IDEOGRAPH-77C9
        0x77CA, # G+12487  U+77CA  uni77CA,  CJK UNIFIED IDEOGRAPH-77CA
        0x77C4, # G+12488  U+77C4  uni77C4,  CJK UNIFIED IDEOGRAPH-77C4
        0x77F1, # G+12489  U+77F1  uni77F1,  CJK UNIFIED IDEOGRAPH-77F1
        0x791D, # G+12490  U+791D  uni791D,  CJK UNIFIED IDEOGRAPH-791D
        0x791B, # G+12491  U+791B  uni791B,  CJK UNIFIED IDEOGRAPH-791B
        0x7921, # G+12492  U+7921  uni7921,  CJK UNIFIED IDEOGRAPH-7921
        0x791C, # G+12493  U+791C  uni791C,  CJK UNIFIED IDEOGRAPH-791C
        0x7917, # G+12494  U+7917  uni7917,  CJK UNIFIED IDEOGRAPH-7917
        0x791E, # G+12495  U+791E  uni791E,  CJK UNIFIED IDEOGRAPH-791E
        0x79B0, # G+12496  U+79B0  uni79B0,  CJK UNIFIED IDEOGRAPH-79B0
        0x7A67, # G+12497  U+7A67  uni7A67,  CJK UNIFIED IDEOGRAPH-7A67
        0x7A68, # G+12498  U+7A68  uni7A68,  CJK UNIFIED IDEOGRAPH-7A68
        0x7C33, # G+12499  U+7C33  uni7C33,  CJK UNIFIED IDEOGRAPH-7C33
        0x7C3C, # G+12500  U+7C3C  uni7C3C,  CJK UNIFIED IDEOGRAPH-7C3C
        0x7C39, # G+12501  U+7C39  uni7C39,  CJK UNIFIED IDEOGRAPH-7C39
        0x7C2C, # G+12502  U+7C2C  uni7C2C,  CJK UNIFIED IDEOGRAPH-7C2C
        0x7C3B, # G+12503  U+7C3B  uni7C3B,  CJK UNIFIED IDEOGRAPH-7C3B
        0x7CEC, # G+12504  U+7CEC  uni7CEC,  CJK UNIFIED IDEOGRAPH-7CEC
        0x7CEA, # G+12505  U+7CEA  uni7CEA,  CJK UNIFIED IDEOGRAPH-7CEA
        0x7E76, # G+12506  U+7E76  uni7E76,  CJK UNIFIED IDEOGRAPH-7E76
        0x7E75, # G+12507  U+7E75  uni7E75,  CJK UNIFIED IDEOGRAPH-7E75
        0x7E78, # G+12508  U+7E78  uni7E78,  CJK UNIFIED IDEOGRAPH-7E78
        0x7E70, # G+12509  U+7E70  uni7E70,  CJK UNIFIED IDEOGRAPH-7E70
        0x7E77, # G+12510  U+7E77  uni7E77,  CJK UNIFIED IDEOGRAPH-7E77
        0x7E6F, # G+12511  U+7E6F  uni7E6F,  CJK UNIFIED IDEOGRAPH-7E6F
        0x7E7A, # G+12512  U+7E7A  uni7E7A,  CJK UNIFIED IDEOGRAPH-7E7A
        0x7E72, # G+12513  U+7E72  uni7E72,  CJK UNIFIED IDEOGRAPH-7E72
        0x7E74, # G+12514  U+7E74  uni7E74,  CJK UNIFIED IDEOGRAPH-7E74
        0x7E68, # G+12515  U+7E68  uni7E68,  CJK UNIFIED IDEOGRAPH-7E68
        0x7F4B, # G+12516  U+7F4B  uni7F4B,  CJK UNIFIED IDEOGRAPH-7F4B
        0x7F4A, # G+12517  U+7F4A  uni7F4A,  CJK UNIFIED IDEOGRAPH-7F4A
        0x7F83, # G+12518  U+7F83  uni7F83,  CJK UNIFIED IDEOGRAPH-7F83
        0x7F86, # G+12519  U+7F86  uni7F86,  CJK UNIFIED IDEOGRAPH-7F86
        0x7FB7, # G+12520  U+7FB7  uni7FB7,  CJK UNIFIED IDEOGRAPH-7FB7
        0x7FFD, # G+12521  U+7FFD  uni7FFD,  CJK UNIFIED IDEOGRAPH-7FFD
        0x7FFE, # G+12522  U+7FFE  uni7FFE,  CJK UNIFIED IDEOGRAPH-7FFE
        0x8078, # G+12523  U+8078  uni8078,  CJK UNIFIED IDEOGRAPH-8078
        0x81D7, # G+12524  U+81D7  uni81D7,  CJK UNIFIED IDEOGRAPH-81D7
        0x81D5, # G+12525  U+81D5  uni81D5,  CJK UNIFIED IDEOGRAPH-81D5
        0x820B, # G+12526  U+820B  uni820B,  CJK UNIFIED IDEOGRAPH-820B
        0x8264, # G+12527  U+8264  uni8264,  CJK UNIFIED IDEOGRAPH-8264
        0x8261, # G+12528  U+8261  uni8261,  CJK UNIFIED IDEOGRAPH-8261
        0x8263, # G+12529  U+8263  uni8263,  CJK UNIFIED IDEOGRAPH-8263
        0x85EB, # G+12530  U+85EB  uni85EB,  CJK UNIFIED IDEOGRAPH-85EB
        0x85F1, # G+12531  U+85F1  uni85F1,  CJK UNIFIED IDEOGRAPH-85F1
        0x85ED, # G+12532  U+85ED  uni85ED,  CJK UNIFIED IDEOGRAPH-85ED
        0x85D9, # G+12533  U+85D9  uni85D9,  CJK UNIFIED IDEOGRAPH-85D9
        0x85E1, # G+12534  U+85E1  uni85E1,  CJK UNIFIED IDEOGRAPH-85E1
        0x85E8, # G+12535  U+85E8  uni85E8,  CJK UNIFIED IDEOGRAPH-85E8
        0x85DA, # G+12536  U+85DA  uni85DA,  CJK UNIFIED IDEOGRAPH-85DA
        0x85D7, # G+12537  U+85D7  uni85D7,  CJK UNIFIED IDEOGRAPH-85D7
        0x85EC, # G+12538  U+85EC  uni85EC,  CJK UNIFIED IDEOGRAPH-85EC
        0x85F2, # G+12539  U+85F2  uni85F2,  CJK UNIFIED IDEOGRAPH-85F2
        0x85F8, # G+12540  U+85F8  uni85F8,  CJK UNIFIED IDEOGRAPH-85F8
        0x85D8, # G+12541  U+85D8  uni85D8,  CJK UNIFIED IDEOGRAPH-85D8
        0x85DF, # G+12542  U+85DF  uni85DF,  CJK UNIFIED IDEOGRAPH-85DF
        0x85E3, # G+12543  U+85E3  uni85E3,  CJK UNIFIED IDEOGRAPH-85E3
        0x85DC, # G+12544  U+85DC  uni85DC,  CJK UNIFIED IDEOGRAPH-85DC
        0x85D1, # G+12545  U+85D1  uni85D1,  CJK UNIFIED IDEOGRAPH-85D1
        0x85F0, # G+12546  U+85F0  uni85F0,  CJK UNIFIED IDEOGRAPH-85F0
        0x85E6, # G+12547  U+85E6  uni85E6,  CJK UNIFIED IDEOGRAPH-85E6
        0x85EF, # G+12548  U+85EF  uni85EF,  CJK UNIFIED IDEOGRAPH-85EF
        0x85DE, # G+12549  U+85DE  uni85DE,  CJK UNIFIED IDEOGRAPH-85DE
        0x85E2, # G+12550  U+85E2  uni85E2,  CJK UNIFIED IDEOGRAPH-85E2
        0x8800, # G+12551  U+8800  uni8800,  CJK UNIFIED IDEOGRAPH-8800
        0x87FA, # G+12552  U+87FA  uni87FA,  CJK UNIFIED IDEOGRAPH-87FA
        0x8803, # G+12553  U+8803  uni8803,  CJK UNIFIED IDEOGRAPH-8803
        0x87F6, # G+12554  U+87F6  uni87F6,  CJK UNIFIED IDEOGRAPH-87F6
        0x87F7, # G+12555  U+87F7  uni87F7,  CJK UNIFIED IDEOGRAPH-87F7
        0x8809, # G+12556  U+8809  uni8809,  CJK UNIFIED IDEOGRAPH-8809
        0x880C, # G+12557  U+880C  uni880C,  CJK UNIFIED IDEOGRAPH-880C
        0x880B, # G+12558  U+880B  uni880B,  CJK UNIFIED IDEOGRAPH-880B
        0x8806, # G+12559  U+8806  uni8806,  CJK UNIFIED IDEOGRAPH-8806
        0x87FC, # G+12560  U+87FC  uni87FC,  CJK UNIFIED IDEOGRAPH-87FC
        0x8808, # G+12561  U+8808  uni8808,  CJK UNIFIED IDEOGRAPH-8808
        0x87FF, # G+12562  U+87FF  uni87FF,  CJK UNIFIED IDEOGRAPH-87FF
        0x880A, # G+12563  U+880A  uni880A,  CJK UNIFIED IDEOGRAPH-880A
        0x8802, # G+12564  U+8802  uni8802,  CJK UNIFIED IDEOGRAPH-8802
        0x8962, # G+12565  U+8962  uni8962,  CJK UNIFIED IDEOGRAPH-8962
        0x895A, # G+12566  U+895A  uni895A,  CJK UNIFIED IDEOGRAPH-895A
        0x895B, # G+12567  U+895B  uni895B,  CJK UNIFIED IDEOGRAPH-895B
        0x8957, # G+12568  U+8957  uni8957,  CJK UNIFIED IDEOGRAPH-8957
        0x8961, # G+12569  U+8961  uni8961,  CJK UNIFIED IDEOGRAPH-8961
        0x895C, # G+12570  U+895C  uni895C,  CJK UNIFIED IDEOGRAPH-895C
        0x8958, # G+12571  U+8958  uni8958,  CJK UNIFIED IDEOGRAPH-8958
        0x895D, # G+12572  U+895D  uni895D,  CJK UNIFIED IDEOGRAPH-895D
        0x8959, # G+12573  U+8959  uni8959,  CJK UNIFIED IDEOGRAPH-8959
        0x8988, # G+12574  U+8988  uni8988,  CJK UNIFIED IDEOGRAPH-8988
        0x89B7, # G+12575  U+89B7  uni89B7,  CJK UNIFIED IDEOGRAPH-89B7
        0x89B6, # G+12576  U+89B6  uni89B6,  CJK UNIFIED IDEOGRAPH-89B6
        0x89F6, # G+12577  U+89F6  uni89F6,  CJK UNIFIED IDEOGRAPH-89F6
        0x8B50, # G+12578  U+8B50  uni8B50,  CJK UNIFIED IDEOGRAPH-8B50
        0x8B48, # G+12579  U+8B48  uni8B48,  CJK UNIFIED IDEOGRAPH-8B48
        0x8B4A, # G+12580  U+8B4A  uni8B4A,  CJK UNIFIED IDEOGRAPH-8B4A
        0x8B40, # G+12581  U+8B40  uni8B40,  CJK UNIFIED IDEOGRAPH-8B40
        0x8B53, # G+12582  U+8B53  uni8B53,  CJK UNIFIED IDEOGRAPH-8B53
        0x8B56, # G+12583  U+8B56  uni8B56,  CJK UNIFIED IDEOGRAPH-8B56
        0x8B54, # G+12584  U+8B54  uni8B54,  CJK UNIFIED IDEOGRAPH-8B54
        0x8B4B, # G+12585  U+8B4B  uni8B4B,  CJK UNIFIED IDEOGRAPH-8B4B
        0x8B55, # G+12586  U+8B55  uni8B55,  CJK UNIFIED IDEOGRAPH-8B55
        0x8B51, # G+12587  U+8B51  uni8B51,  CJK UNIFIED IDEOGRAPH-8B51
        0x8B42, # G+12588  U+8B42  uni8B42,  CJK UNIFIED IDEOGRAPH-8B42
        0x8B52, # G+12589  U+8B52  uni8B52,  CJK UNIFIED IDEOGRAPH-8B52
        0x8B57, # G+12590  U+8B57  uni8B57,  CJK UNIFIED IDEOGRAPH-8B57
        0x8C43, # G+12591  U+8C43  uni8C43,  CJK UNIFIED IDEOGRAPH-8C43
        0x8C77, # G+12592  U+8C77  uni8C77,  CJK UNIFIED IDEOGRAPH-8C77
        0x8C76, # G+12593  U+8C76  uni8C76,  CJK UNIFIED IDEOGRAPH-8C76
        0x8C9A, # G+12594  U+8C9A  uni8C9A,  CJK UNIFIED IDEOGRAPH-8C9A
        0x8D06, # G+12595  U+8D06  uni8D06,  CJK UNIFIED IDEOGRAPH-8D06
        0x8D07, # G+12596  U+8D07  uni8D07,  CJK UNIFIED IDEOGRAPH-8D07
        0x8D09, # G+12597  U+8D09  uni8D09,  CJK UNIFIED IDEOGRAPH-8D09
        0x8DAC, # G+12598  U+8DAC  uni8DAC,  CJK UNIFIED IDEOGRAPH-8DAC
        0x8DAA, # G+12599  U+8DAA  uni8DAA,  CJK UNIFIED IDEOGRAPH-8DAA
        0x8DAD, # G+12600  U+8DAD  uni8DAD,  CJK UNIFIED IDEOGRAPH-8DAD
        0x8DAB, # G+12601  U+8DAB  uni8DAB,  CJK UNIFIED IDEOGRAPH-8DAB
        0x8E6D, # G+12602  U+8E6D  uni8E6D,  CJK UNIFIED IDEOGRAPH-8E6D
        0x8E78, # G+12603  U+8E78  uni8E78,  CJK UNIFIED IDEOGRAPH-8E78
        0x8E73, # G+12604  U+8E73  uni8E73,  CJK UNIFIED IDEOGRAPH-8E73
        0x8E6A, # G+12605  U+8E6A  uni8E6A,  CJK UNIFIED IDEOGRAPH-8E6A
        0x8E6F, # G+12606  U+8E6F  uni8E6F,  CJK UNIFIED IDEOGRAPH-8E6F
        0x8E7B, # G+12607  U+8E7B  uni8E7B,  CJK UNIFIED IDEOGRAPH-8E7B
        0x8EC2, # G+12608  U+8EC2  uni8EC2,  CJK UNIFIED IDEOGRAPH-8EC2
        0x8F52, # G+12609  U+8F52  uni8F52,  CJK UNIFIED IDEOGRAPH-8F52
        0x8F51, # G+12610  U+8F51  uni8F51,  CJK UNIFIED IDEOGRAPH-8F51
        0x8F4F, # G+12611  U+8F4F  uni8F4F,  CJK UNIFIED IDEOGRAPH-8F4F
        0x8F50, # G+12612  U+8F50  uni8F50,  CJK UNIFIED IDEOGRAPH-8F50
        0x8F53, # G+12613  U+8F53  uni8F53,  CJK UNIFIED IDEOGRAPH-8F53
        0x8FB4, # G+12614  U+8FB4  uni8FB4,  CJK UNIFIED IDEOGRAPH-8FB4
        0x9140, # G+12615  U+9140  uni9140,  CJK UNIFIED IDEOGRAPH-9140
        0x913F, # G+12616  U+913F  uni913F,  CJK UNIFIED IDEOGRAPH-913F
        0x91B0, # G+12617  U+91B0  uni91B0,  CJK UNIFIED IDEOGRAPH-91B0
        0x91AD, # G+12618  U+91AD  uni91AD,  CJK UNIFIED IDEOGRAPH-91AD
        0x93DE, # G+12619  U+93DE  uni93DE,  CJK UNIFIED IDEOGRAPH-93DE
        0x93C7, # G+12620  U+93C7  uni93C7,  CJK UNIFIED IDEOGRAPH-93C7
        0x93CF, # G+12621  U+93CF  uni93CF,  CJK UNIFIED IDEOGRAPH-93CF
        0x93C2, # G+12622  U+93C2  uni93C2,  CJK UNIFIED IDEOGRAPH-93C2
        0x93DA, # G+12623  U+93DA  uni93DA,  CJK UNIFIED IDEOGRAPH-93DA
        0x93D0, # G+12624  U+93D0  uni93D0,  CJK UNIFIED IDEOGRAPH-93D0
        0x93F9, # G+12625  U+93F9  uni93F9,  CJK UNIFIED IDEOGRAPH-93F9
        0x93EC, # G+12626  U+93EC  uni93EC,  CJK UNIFIED IDEOGRAPH-93EC
        0x93CC, # G+12627  U+93CC  uni93CC,  CJK UNIFIED IDEOGRAPH-93CC
        0x93D9, # G+12628  U+93D9  uni93D9,  CJK UNIFIED IDEOGRAPH-93D9
        0x93A9, # G+12629  U+93A9  uni93A9,  CJK UNIFIED IDEOGRAPH-93A9
        0x93E6, # G+12630  U+93E6  uni93E6,  CJK UNIFIED IDEOGRAPH-93E6
        0x93CA, # G+12631  U+93CA  uni93CA,  CJK UNIFIED IDEOGRAPH-93CA
        0x93D4, # G+12632  U+93D4  uni93D4,  CJK UNIFIED IDEOGRAPH-93D4
        0x93EE, # G+12633  U+93EE  uni93EE,  CJK UNIFIED IDEOGRAPH-93EE
        0x93E3, # G+12634  U+93E3  uni93E3,  CJK UNIFIED IDEOGRAPH-93E3
        0x93D5, # G+12635  U+93D5  uni93D5,  CJK UNIFIED IDEOGRAPH-93D5
        0x93C4, # G+12636  U+93C4  uni93C4,  CJK UNIFIED IDEOGRAPH-93C4
        0x93CE, # G+12637  U+93CE  uni93CE,  CJK UNIFIED IDEOGRAPH-93CE
        0x93C0, # G+12638  U+93C0  uni93C0,  CJK UNIFIED IDEOGRAPH-93C0
        0x93D2, # G+12639  U+93D2  uni93D2,  CJK UNIFIED IDEOGRAPH-93D2
        0x93A5, # G+12640  U+93A5  uni93A5,  CJK UNIFIED IDEOGRAPH-93A5
        0x93E7, # G+12641  U+93E7  uni93E7,  CJK UNIFIED IDEOGRAPH-93E7
        0x957D, # G+12642  U+957D  uni957D,  CJK UNIFIED IDEOGRAPH-957D
        0x95DA, # G+12643  U+95DA  uni95DA,  CJK UNIFIED IDEOGRAPH-95DA
        0x95DB, # G+12644  U+95DB  uni95DB,  CJK UNIFIED IDEOGRAPH-95DB
        0x96E1, # G+12645  U+96E1  uni96E1,  CJK UNIFIED IDEOGRAPH-96E1
        0x9729, # G+12646  U+9729  uni9729,  CJK UNIFIED IDEOGRAPH-9729
        0x972B, # G+12647  U+972B  uni972B,  CJK UNIFIED IDEOGRAPH-972B
        0x972C, # G+12648  U+972C  uni972C,  CJK UNIFIED IDEOGRAPH-972C
        0x9728, # G+12649  U+9728  uni9728,  CJK UNIFIED IDEOGRAPH-9728
        0x9726, # G+12650  U+9726  uni9726,  CJK UNIFIED IDEOGRAPH-9726
        0x97B3, # G+12651  U+97B3  uni97B3,  CJK UNIFIED IDEOGRAPH-97B3
        0x97B7, # G+12652  U+97B7  uni97B7,  CJK UNIFIED IDEOGRAPH-97B7
        0x97B6, # G+12653  U+97B6  uni97B6,  CJK UNIFIED IDEOGRAPH-97B6
        0x97DD, # G+12654  U+97DD  uni97DD,  CJK UNIFIED IDEOGRAPH-97DD
        0x97DE, # G+12655  U+97DE  uni97DE,  CJK UNIFIED IDEOGRAPH-97DE
        0x97DF, # G+12656  U+97DF  uni97DF,  CJK UNIFIED IDEOGRAPH-97DF
        0x985C, # G+12657  U+985C  uni985C,  CJK UNIFIED IDEOGRAPH-985C
        0x9859, # G+12658  U+9859  uni9859,  CJK UNIFIED IDEOGRAPH-9859
        0x985D, # G+12659  U+985D  uni985D,  CJK UNIFIED IDEOGRAPH-985D
        0x9857, # G+12660  U+9857  uni9857,  CJK UNIFIED IDEOGRAPH-9857
        0x98BF, # G+12661  U+98BF  uni98BF,  CJK UNIFIED IDEOGRAPH-98BF
        0x98BD, # G+12662  U+98BD  uni98BD,  CJK UNIFIED IDEOGRAPH-98BD
        0x98BB, # G+12663  U+98BB  uni98BB,  CJK UNIFIED IDEOGRAPH-98BB
        0x98BE, # G+12664  U+98BE  uni98BE,  CJK UNIFIED IDEOGRAPH-98BE
        0x9948, # G+12665  U+9948  uni9948,  CJK UNIFIED IDEOGRAPH-9948
        0x9947, # G+12666  U+9947  uni9947,  CJK UNIFIED IDEOGRAPH-9947
        0x9943, # G+12667  U+9943  uni9943,  CJK UNIFIED IDEOGRAPH-9943
        0x99A6, # G+12668  U+99A6  uni99A6,  CJK UNIFIED IDEOGRAPH-99A6
        0x99A7, # G+12669  U+99A7  uni99A7,  CJK UNIFIED IDEOGRAPH-99A7
        0x9A1A, # G+12670  U+9A1A  uni9A1A,  CJK UNIFIED IDEOGRAPH-9A1A
        0x9A15, # G+12671  U+9A15  uni9A15,  CJK UNIFIED IDEOGRAPH-9A15
        0x9A25, # G+12672  U+9A25  uni9A25,  CJK UNIFIED IDEOGRAPH-9A25
        0x9A1D, # G+12673  U+9A1D  uni9A1D,  CJK UNIFIED IDEOGRAPH-9A1D
        0x9A24, # G+12674  U+9A24  uni9A24,  CJK UNIFIED IDEOGRAPH-9A24
        0x9A1B, # G+12675  U+9A1B  uni9A1B,  CJK UNIFIED IDEOGRAPH-9A1B
        0x9A22, # G+12676  U+9A22  uni9A22,  CJK UNIFIED IDEOGRAPH-9A22
        0x9A20, # G+12677  U+9A20  uni9A20,  CJK UNIFIED IDEOGRAPH-9A20
        0x9A27, # G+12678  U+9A27  uni9A27,  CJK UNIFIED IDEOGRAPH-9A27
        0x9A23, # G+12679  U+9A23  uni9A23,  CJK UNIFIED IDEOGRAPH-9A23
        0x9A1E, # G+12680  U+9A1E  uni9A1E,  CJK UNIFIED IDEOGRAPH-9A1E
        0x9A1C, # G+12681  U+9A1C  uni9A1C,  CJK UNIFIED IDEOGRAPH-9A1C
        0x9A14, # G+12682  U+9A14  uni9A14,  CJK UNIFIED IDEOGRAPH-9A14
        0x9AC2, # G+12683  U+9AC2  uni9AC2,  CJK UNIFIED IDEOGRAPH-9AC2
        0x9B0B, # G+12684  U+9B0B  uni9B0B,  CJK UNIFIED IDEOGRAPH-9B0B
        0x9B0A, # G+12685  U+9B0A  uni9B0A,  CJK UNIFIED IDEOGRAPH-9B0A
        0x9B0E, # G+12686  U+9B0E  uni9B0E,  CJK UNIFIED IDEOGRAPH-9B0E
        0x9B0C, # G+12687  U+9B0C  uni9B0C,  CJK UNIFIED IDEOGRAPH-9B0C
        0x9B37, # G+12688  U+9B37  uni9B37,  CJK UNIFIED IDEOGRAPH-9B37
        0x9BEA, # G+12689  U+9BEA  uni9BEA,  CJK UNIFIED IDEOGRAPH-9BEA
        0x9BEB, # G+12690  U+9BEB  uni9BEB,  CJK UNIFIED IDEOGRAPH-9BEB
        0x9BE0, # G+12691  U+9BE0  uni9BE0,  CJK UNIFIED IDEOGRAPH-9BE0
        0x9BDE, # G+12692  U+9BDE  uni9BDE,  CJK UNIFIED IDEOGRAPH-9BDE
        0x9BE4, # G+12693  U+9BE4  uni9BE4,  CJK UNIFIED IDEOGRAPH-9BE4
        0x9BE6, # G+12694  U+9BE6  uni9BE6,  CJK UNIFIED IDEOGRAPH-9BE6
        0x9BE2, # G+12695  U+9BE2  uni9BE2,  CJK UNIFIED IDEOGRAPH-9BE2
        0x9BF0, # G+12696  U+9BF0  uni9BF0,  CJK UNIFIED IDEOGRAPH-9BF0
        0x9BD4, # G+12697  U+9BD4  uni9BD4,  CJK UNIFIED IDEOGRAPH-9BD4
        0x9BD7, # G+12698  U+9BD7  uni9BD7,  CJK UNIFIED IDEOGRAPH-9BD7
        0x9BEC, # G+12699  U+9BEC  uni9BEC,  CJK UNIFIED IDEOGRAPH-9BEC
        0x9BDC, # G+12700  U+9BDC  uni9BDC,  CJK UNIFIED IDEOGRAPH-9BDC
        0x9BD9, # G+12701  U+9BD9  uni9BD9,  CJK UNIFIED IDEOGRAPH-9BD9
        0x9BE5, # G+12702  U+9BE5  uni9BE5,  CJK UNIFIED IDEOGRAPH-9BE5
        0x9BD5, # G+12703  U+9BD5  uni9BD5,  CJK UNIFIED IDEOGRAPH-9BD5
        0x9BE1, # G+12704  U+9BE1  uni9BE1,  CJK UNIFIED IDEOGRAPH-9BE1
        0x9BDA, # G+12705  U+9BDA  uni9BDA,  CJK UNIFIED IDEOGRAPH-9BDA
        0x9D77, # G+12706  U+9D77  uni9D77,  CJK UNIFIED IDEOGRAPH-9D77
        0x9D81, # G+12707  U+9D81  uni9D81,  CJK UNIFIED IDEOGRAPH-9D81
        0x9D8A, # G+12708  U+9D8A  uni9D8A,  CJK UNIFIED IDEOGRAPH-9D8A
        0x9D84, # G+12709  U+9D84  uni9D84,  CJK UNIFIED IDEOGRAPH-9D84
        0x9D88, # G+12710  U+9D88  uni9D88,  CJK UNIFIED IDEOGRAPH-9D88
        0x9D71, # G+12711  U+9D71  uni9D71,  CJK UNIFIED IDEOGRAPH-9D71
        0x9D80, # G+12712  U+9D80  uni9D80,  CJK UNIFIED IDEOGRAPH-9D80
        0x9D78, # G+12713  U+9D78  uni9D78,  CJK UNIFIED IDEOGRAPH-9D78
        0x9D86, # G+12714  U+9D86  uni9D86,  CJK UNIFIED IDEOGRAPH-9D86
        0x9D8B, # G+12715  U+9D8B  uni9D8B,  CJK UNIFIED IDEOGRAPH-9D8B
        0x9D8C, # G+12716  U+9D8C  uni9D8C,  CJK UNIFIED IDEOGRAPH-9D8C
        0x9D7D, # G+12717  U+9D7D  uni9D7D,  CJK UNIFIED IDEOGRAPH-9D7D
        0x9D6B, # G+12718  U+9D6B  uni9D6B,  CJK UNIFIED IDEOGRAPH-9D6B
        0x9D74, # G+12719  U+9D74  uni9D74,  CJK UNIFIED IDEOGRAPH-9D74
        0x9D75, # G+12720  U+9D75  uni9D75,  CJK UNIFIED IDEOGRAPH-9D75
        0x9D70, # G+12721  U+9D70  uni9D70,  CJK UNIFIED IDEOGRAPH-9D70
        0x9D69, # G+12722  U+9D69  uni9D69,  CJK UNIFIED IDEOGRAPH-9D69
        0x9D85, # G+12723  U+9D85  uni9D85,  CJK UNIFIED IDEOGRAPH-9D85
        0x9D73, # G+12724  U+9D73  uni9D73,  CJK UNIFIED IDEOGRAPH-9D73
        0x9D7B, # G+12725  U+9D7B  uni9D7B,  CJK UNIFIED IDEOGRAPH-9D7B
        0x9D82, # G+12726  U+9D82  uni9D82,  CJK UNIFIED IDEOGRAPH-9D82
        0x9D6F, # G+12727  U+9D6F  uni9D6F,  CJK UNIFIED IDEOGRAPH-9D6F
        0x9D79, # G+12728  U+9D79  uni9D79,  CJK UNIFIED IDEOGRAPH-9D79
        0x9D7F, # G+12729  U+9D7F  uni9D7F,  CJK UNIFIED IDEOGRAPH-9D7F
        0x9D87, # G+12730  U+9D87  uni9D87,  CJK UNIFIED IDEOGRAPH-9D87
        0x9D68, # G+12731  U+9D68  uni9D68,  CJK UNIFIED IDEOGRAPH-9D68
        0x9E94, # G+12732  U+9E94  uni9E94,  CJK UNIFIED IDEOGRAPH-9E94
        0x9E91, # G+12733  U+9E91  uni9E91,  CJK UNIFIED IDEOGRAPH-9E91
        0x9EC0, # G+12734  U+9EC0  uni9EC0,  CJK UNIFIED IDEOGRAPH-9EC0
        0x9EFC, # G+12735  U+9EFC  uni9EFC,  CJK UNIFIED IDEOGRAPH-9EFC
        0x9F2D, # G+12736  U+9F2D  uni9F2D,  CJK UNIFIED IDEOGRAPH-9F2D
        0x9F40, # G+12737  U+9F40  uni9F40,  CJK UNIFIED IDEOGRAPH-9F40
        0x9F41, # G+12738  U+9F41  uni9F41,  CJK UNIFIED IDEOGRAPH-9F41
        0x9F4D, # G+12739  U+9F4D  uni9F4D,  CJK UNIFIED IDEOGRAPH-9F4D
        0x9F56, # G+12740  U+9F56  uni9F56,  CJK UNIFIED IDEOGRAPH-9F56
        0x9F57, # G+12741  U+9F57  uni9F57,  CJK UNIFIED IDEOGRAPH-9F57
        0x9F58, # G+12742  U+9F58  uni9F58,  CJK UNIFIED IDEOGRAPH-9F58
        0x5337, # G+12743  U+5337  uni5337,  CJK UNIFIED IDEOGRAPH-5337
        0x56B2, # G+12744  U+56B2  uni56B2,  CJK UNIFIED IDEOGRAPH-56B2
        0x56B5, # G+12745  U+56B5  uni56B5,  CJK UNIFIED IDEOGRAPH-56B5
        0x56B3, # G+12746  U+56B3  uni56B3,  CJK UNIFIED IDEOGRAPH-56B3
        0x58E3, # G+12747  U+58E3  uni58E3,  CJK UNIFIED IDEOGRAPH-58E3
        0x5B45, # G+12748  U+5B45  uni5B45,  CJK UNIFIED IDEOGRAPH-5B45
        0x5DC6, # G+12749  U+5DC6  uni5DC6,  CJK UNIFIED IDEOGRAPH-5DC6
        0x5DC7, # G+12750  U+5DC7  uni5DC7,  CJK UNIFIED IDEOGRAPH-5DC7
        0x5EEE, # G+12751  U+5EEE  uni5EEE,  CJK UNIFIED IDEOGRAPH-5EEE
        0x5EEF, # G+12752  U+5EEF  uni5EEF,  CJK UNIFIED IDEOGRAPH-5EEF
        0x5FC0, # G+12753  U+5FC0  uni5FC0,  CJK UNIFIED IDEOGRAPH-5FC0
        0x5FC1, # G+12754  U+5FC1  uni5FC1,  CJK UNIFIED IDEOGRAPH-5FC1
        0x61F9, # G+12755  U+61F9  uni61F9,  CJK UNIFIED IDEOGRAPH-61F9
        0x6517, # G+12756  U+6517  uni6517,  CJK UNIFIED IDEOGRAPH-6517
        0x6516, # G+12757  U+6516  uni6516,  CJK UNIFIED IDEOGRAPH-6516
        0x6515, # G+12758  U+6515  uni6515,  CJK UNIFIED IDEOGRAPH-6515
        0x6513, # G+12759  U+6513  uni6513,  CJK UNIFIED IDEOGRAPH-6513
        0x65DF, # G+12760  U+65DF  uni65DF,  CJK UNIFIED IDEOGRAPH-65DF
        0x66E8, # G+12761  U+66E8  uni66E8,  CJK UNIFIED IDEOGRAPH-66E8
        0x66E3, # G+12762  U+66E3  uni66E3,  CJK UNIFIED IDEOGRAPH-66E3
        0x66E4, # G+12763  U+66E4  uni66E4,  CJK UNIFIED IDEOGRAPH-66E4
        0x6AF3, # G+12764  U+6AF3  uni6AF3,  CJK UNIFIED IDEOGRAPH-6AF3
        0x6AF0, # G+12765  U+6AF0  uni6AF0,  CJK UNIFIED IDEOGRAPH-6AF0
        0x6AEA, # G+12766  U+6AEA  uni6AEA,  CJK UNIFIED IDEOGRAPH-6AEA
        0x6AE8, # G+12767  U+6AE8  uni6AE8,  CJK UNIFIED IDEOGRAPH-6AE8
        0x6AF9, # G+12768  U+6AF9  uni6AF9,  CJK UNIFIED IDEOGRAPH-6AF9
        0x6AF1, # G+12769  U+6AF1  uni6AF1,  CJK UNIFIED IDEOGRAPH-6AF1
        0x6AEE, # G+12770  U+6AEE  uni6AEE,  CJK UNIFIED IDEOGRAPH-6AEE
        0x6AEF, # G+12771  U+6AEF  uni6AEF,  CJK UNIFIED IDEOGRAPH-6AEF
        0x703C, # G+12772  U+703C  uni703C,  CJK UNIFIED IDEOGRAPH-703C
        0x7035, # G+12773  U+7035  uni7035,  CJK UNIFIED IDEOGRAPH-7035
        0x702F, # G+12774  U+702F  uni702F,  CJK UNIFIED IDEOGRAPH-702F
        0x7037, # G+12775  U+7037  uni7037,  CJK UNIFIED IDEOGRAPH-7037
        0x7034, # G+12776  U+7034  uni7034,  CJK UNIFIED IDEOGRAPH-7034
        0x7031, # G+12777  U+7031  uni7031,  CJK UNIFIED IDEOGRAPH-7031
        0x7042, # G+12778  U+7042  uni7042,  CJK UNIFIED IDEOGRAPH-7042
        0x7038, # G+12779  U+7038  uni7038,  CJK UNIFIED IDEOGRAPH-7038
        0x703F, # G+12780  U+703F  uni703F,  CJK UNIFIED IDEOGRAPH-703F
        0x703A, # G+12781  U+703A  uni703A,  CJK UNIFIED IDEOGRAPH-703A
        0x7039, # G+12782  U+7039  uni7039,  CJK UNIFIED IDEOGRAPH-7039
        0x702A, # G+12783  U+702A  uni702A,  CJK UNIFIED IDEOGRAPH-702A
        0x7040, # G+12784  U+7040  uni7040,  CJK UNIFIED IDEOGRAPH-7040
        0x703B, # G+12785  U+703B  uni703B,  CJK UNIFIED IDEOGRAPH-703B
        0x7033, # G+12786  U+7033  uni7033,  CJK UNIFIED IDEOGRAPH-7033
        0x7041, # G+12787  U+7041  uni7041,  CJK UNIFIED IDEOGRAPH-7041
        0x7213, # G+12788  U+7213  uni7213,  CJK UNIFIED IDEOGRAPH-7213
        0x7214, # G+12789  U+7214  uni7214,  CJK UNIFIED IDEOGRAPH-7214
        0x72A8, # G+12790  U+72A8  uni72A8,  CJK UNIFIED IDEOGRAPH-72A8
        0x737D, # G+12791  U+737D  uni737D,  CJK UNIFIED IDEOGRAPH-737D
        0x737C, # G+12792  U+737C  uni737C,  CJK UNIFIED IDEOGRAPH-737C
        0x74BA, # G+12793  U+74BA  uni74BA,  CJK UNIFIED IDEOGRAPH-74BA
        0x76AB, # G+12794  U+76AB  uni76AB,  CJK UNIFIED IDEOGRAPH-76AB
        0x76AA, # G+12795  U+76AA  uni76AA,  CJK UNIFIED IDEOGRAPH-76AA
        0x76BE, # G+12796  U+76BE  uni76BE,  CJK UNIFIED IDEOGRAPH-76BE
        0x76ED, # G+12797  U+76ED  uni76ED,  CJK UNIFIED IDEOGRAPH-76ED
        0x77CC, # G+12798  U+77CC  uni77CC,  CJK UNIFIED IDEOGRAPH-77CC
        0x77CE, # G+12799  U+77CE  uni77CE,  CJK UNIFIED IDEOGRAPH-77CE
        0x77CF, # G+12800  U+77CF  uni77CF,  CJK UNIFIED IDEOGRAPH-77CF
        0x77CD, # G+12801  U+77CD  uni77CD,  CJK UNIFIED IDEOGRAPH-77CD
        0x77F2, # G+12802  U+77F2  uni77F2,  CJK UNIFIED IDEOGRAPH-77F2
        0x7925, # G+12803  U+7925  uni7925,  CJK UNIFIED IDEOGRAPH-7925
        0x7923, # G+12804  U+7923  uni7923,  CJK UNIFIED IDEOGRAPH-7923
        0x7927, # G+12805  U+7927  uni7927,  CJK UNIFIED IDEOGRAPH-7927
        0x7928, # G+12806  U+7928  uni7928,  CJK UNIFIED IDEOGRAPH-7928
        0x7924, # G+12807  U+7924  uni7924,  CJK UNIFIED IDEOGRAPH-7924
        0x7929, # G+12808  U+7929  uni7929,  CJK UNIFIED IDEOGRAPH-7929
        0x79B2, # G+12809  U+79B2  uni79B2,  CJK UNIFIED IDEOGRAPH-79B2
        0x7A6E, # G+12810  U+7A6E  uni7A6E,  CJK UNIFIED IDEOGRAPH-7A6E
        0x7A6C, # G+12811  U+7A6C  uni7A6C,  CJK UNIFIED IDEOGRAPH-7A6C
        0x7A6D, # G+12812  U+7A6D  uni7A6D,  CJK UNIFIED IDEOGRAPH-7A6D
        0x7AF7, # G+12813  U+7AF7  uni7AF7,  CJK UNIFIED IDEOGRAPH-7AF7
        0x7C49, # G+12814  U+7C49  uni7C49,  CJK UNIFIED IDEOGRAPH-7C49
        0x7C48, # G+12815  U+7C48  uni7C48,  CJK UNIFIED IDEOGRAPH-7C48
        0x7C4A, # G+12816  U+7C4A  uni7C4A,  CJK UNIFIED IDEOGRAPH-7C4A
        0x7C47, # G+12817  U+7C47  uni7C47,  CJK UNIFIED IDEOGRAPH-7C47
        0x7C45, # G+12818  U+7C45  uni7C45,  CJK UNIFIED IDEOGRAPH-7C45
        0x7CEE, # G+12819  U+7CEE  uni7CEE,  CJK UNIFIED IDEOGRAPH-7CEE
        0x7E7B, # G+12820  U+7E7B  uni7E7B,  CJK UNIFIED IDEOGRAPH-7E7B
        0x7E7E, # G+12821  U+7E7E  uni7E7E,  CJK UNIFIED IDEOGRAPH-7E7E
        0x7E81, # G+12822  U+7E81  uni7E81,  CJK UNIFIED IDEOGRAPH-7E81
        0x7E80, # G+12823  U+7E80  uni7E80,  CJK UNIFIED IDEOGRAPH-7E80
        0x7FBA, # G+12824  U+7FBA  uni7FBA,  CJK UNIFIED IDEOGRAPH-7FBA
        0x7FFF, # G+12825  U+7FFF  uni7FFF,  CJK UNIFIED IDEOGRAPH-7FFF
        0x8079, # G+12826  U+8079  uni8079,  CJK UNIFIED IDEOGRAPH-8079
        0x81DB, # G+12827  U+81DB  uni81DB,  CJK UNIFIED IDEOGRAPH-81DB
        0x81D9, # G+12828  U+81D9  uni81D9,  CJK UNIFIED IDEOGRAPH-81D9
        0x8268, # G+12829  U+8268  uni8268,  CJK UNIFIED IDEOGRAPH-8268
        0x8269, # G+12830  U+8269  uni8269,  CJK UNIFIED IDEOGRAPH-8269
        0x8622, # G+12831  U+8622  uni8622,  CJK UNIFIED IDEOGRAPH-8622
        0x85FF, # G+12832  U+85FF  uni85FF,  CJK UNIFIED IDEOGRAPH-85FF
        0x8601, # G+12833  U+8601  uni8601,  CJK UNIFIED IDEOGRAPH-8601
        0x85FE, # G+12834  U+85FE  uni85FE,  CJK UNIFIED IDEOGRAPH-85FE
        0x861B, # G+12835  U+861B  uni861B,  CJK UNIFIED IDEOGRAPH-861B
        0x8600, # G+12836  U+8600  uni8600,  CJK UNIFIED IDEOGRAPH-8600
        0x85F6, # G+12837  U+85F6  uni85F6,  CJK UNIFIED IDEOGRAPH-85F6
        0x8604, # G+12838  U+8604  uni8604,  CJK UNIFIED IDEOGRAPH-8604
        0x8609, # G+12839  U+8609  uni8609,  CJK UNIFIED IDEOGRAPH-8609
        0x8605, # G+12840  U+8605  uni8605,  CJK UNIFIED IDEOGRAPH-8605
        0x860C, # G+12841  U+860C  uni860C,  CJK UNIFIED IDEOGRAPH-860C
        0x85FD, # G+12842  U+85FD  uni85FD,  CJK UNIFIED IDEOGRAPH-85FD
        0x8819, # G+12843  U+8819  uni8819,  CJK UNIFIED IDEOGRAPH-8819
        0x8810, # G+12844  U+8810  uni8810,  CJK UNIFIED IDEOGRAPH-8810
        0x8811, # G+12845  U+8811  uni8811,  CJK UNIFIED IDEOGRAPH-8811
        0x8817, # G+12846  U+8817  uni8817,  CJK UNIFIED IDEOGRAPH-8817
        0x8813, # G+12847  U+8813  uni8813,  CJK UNIFIED IDEOGRAPH-8813
        0x8816, # G+12848  U+8816  uni8816,  CJK UNIFIED IDEOGRAPH-8816
        0x8963, # G+12849  U+8963  uni8963,  CJK UNIFIED IDEOGRAPH-8963
        0x8966, # G+12850  U+8966  uni8966,  CJK UNIFIED IDEOGRAPH-8966
        0x89B9, # G+12851  U+89B9  uni89B9,  CJK UNIFIED IDEOGRAPH-89B9
        0x89F7, # G+12852  U+89F7  uni89F7,  CJK UNIFIED IDEOGRAPH-89F7
        0x8B60, # G+12853  U+8B60  uni8B60,  CJK UNIFIED IDEOGRAPH-8B60
        0x8B6A, # G+12854  U+8B6A  uni8B6A,  CJK UNIFIED IDEOGRAPH-8B6A
        0x8B5D, # G+12855  U+8B5D  uni8B5D,  CJK UNIFIED IDEOGRAPH-8B5D
        0x8B68, # G+12856  U+8B68  uni8B68,  CJK UNIFIED IDEOGRAPH-8B68
        0x8B63, # G+12857  U+8B63  uni8B63,  CJK UNIFIED IDEOGRAPH-8B63
        0x8B65, # G+12858  U+8B65  uni8B65,  CJK UNIFIED IDEOGRAPH-8B65
        0x8B67, # G+12859  U+8B67  uni8B67,  CJK UNIFIED IDEOGRAPH-8B67
        0x8B6D, # G+12860  U+8B6D  uni8B6D,  CJK UNIFIED IDEOGRAPH-8B6D
        0x8DAE, # G+12861  U+8DAE  uni8DAE,  CJK UNIFIED IDEOGRAPH-8DAE
        0x8E86, # G+12862  U+8E86  uni8E86,  CJK UNIFIED IDEOGRAPH-8E86
        0x8E88, # G+12863  U+8E88  uni8E88,  CJK UNIFIED IDEOGRAPH-8E88
        0x8E84, # G+12864  U+8E84  uni8E84,  CJK UNIFIED IDEOGRAPH-8E84
        0x8F59, # G+12865  U+8F59  uni8F59,  CJK UNIFIED IDEOGRAPH-8F59
        0x8F56, # G+12866  U+8F56  uni8F56,  CJK UNIFIED IDEOGRAPH-8F56
        0x8F57, # G+12867  U+8F57  uni8F57,  CJK UNIFIED IDEOGRAPH-8F57
        0x8F55, # G+12868  U+8F55  uni8F55,  CJK UNIFIED IDEOGRAPH-8F55
        0x8F58, # G+12869  U+8F58  uni8F58,  CJK UNIFIED IDEOGRAPH-8F58
        0x8F5A, # G+12870  U+8F5A  uni8F5A,  CJK UNIFIED IDEOGRAPH-8F5A
        0x908D, # G+12871  U+908D  uni908D,  CJK UNIFIED IDEOGRAPH-908D
        0x9143, # G+12872  U+9143  uni9143,  CJK UNIFIED IDEOGRAPH-9143
        0x9141, # G+12873  U+9141  uni9141,  CJK UNIFIED IDEOGRAPH-9141
        0x91B7, # G+12874  U+91B7  uni91B7,  CJK UNIFIED IDEOGRAPH-91B7
        0x91B5, # G+12875  U+91B5  uni91B5,  CJK UNIFIED IDEOGRAPH-91B5
        0x91B2, # G+12876  U+91B2  uni91B2,  CJK UNIFIED IDEOGRAPH-91B2
        0x91B3, # G+12877  U+91B3  uni91B3,  CJK UNIFIED IDEOGRAPH-91B3
        0x940B, # G+12878  U+940B  uni940B,  CJK UNIFIED IDEOGRAPH-940B
        0x9413, # G+12879  U+9413  uni9413,  CJK UNIFIED IDEOGRAPH-9413
        0x93FB, # G+12880  U+93FB  uni93FB,  CJK UNIFIED IDEOGRAPH-93FB
        0x9420, # G+12881  U+9420  uni9420,  CJK UNIFIED IDEOGRAPH-9420
        0x940F, # G+12882  U+940F  uni940F,  CJK UNIFIED IDEOGRAPH-940F
        0x9414, # G+12883  U+9414  uni9414,  CJK UNIFIED IDEOGRAPH-9414
        0x93FE, # G+12884  U+93FE  uni93FE,  CJK UNIFIED IDEOGRAPH-93FE
        0x9415, # G+12885  U+9415  uni9415,  CJK UNIFIED IDEOGRAPH-9415
        0x9410, # G+12886  U+9410  uni9410,  CJK UNIFIED IDEOGRAPH-9410
        0x9428, # G+12887  U+9428  uni9428,  CJK UNIFIED IDEOGRAPH-9428
        0x9419, # G+12888  U+9419  uni9419,  CJK UNIFIED IDEOGRAPH-9419
        0x940D, # G+12889  U+940D  uni940D,  CJK UNIFIED IDEOGRAPH-940D
        0x93F5, # G+12890  U+93F5  uni93F5,  CJK UNIFIED IDEOGRAPH-93F5
        0x9400, # G+12891  U+9400  uni9400,  CJK UNIFIED IDEOGRAPH-9400
        0x93F7, # G+12892  U+93F7  uni93F7,  CJK UNIFIED IDEOGRAPH-93F7
        0x9407, # G+12893  U+9407  uni9407,  CJK UNIFIED IDEOGRAPH-9407
        0x940E, # G+12894  U+940E  uni940E,  CJK UNIFIED IDEOGRAPH-940E
        0x9416, # G+12895  U+9416  uni9416,  CJK UNIFIED IDEOGRAPH-9416
        0x9412, # G+12896  U+9412  uni9412,  CJK UNIFIED IDEOGRAPH-9412
        0x93FA, # G+12897  U+93FA  uni93FA,  CJK UNIFIED IDEOGRAPH-93FA
        0x9409, # G+12898  U+9409  uni9409,  CJK UNIFIED IDEOGRAPH-9409
        0x93F8, # G+12899  U+93F8  uni93F8,  CJK UNIFIED IDEOGRAPH-93F8
        0x943C, # G+12900  U+943C  uni943C,  CJK UNIFIED IDEOGRAPH-943C
        0x940A, # G+12901  U+940A  uni940A,  CJK UNIFIED IDEOGRAPH-940A
        0x93FF, # G+12902  U+93FF  uni93FF,  CJK UNIFIED IDEOGRAPH-93FF
        0x93FC, # G+12903  U+93FC  uni93FC,  CJK UNIFIED IDEOGRAPH-93FC
        0x940C, # G+12904  U+940C  uni940C,  CJK UNIFIED IDEOGRAPH-940C
        0x93F6, # G+12905  U+93F6  uni93F6,  CJK UNIFIED IDEOGRAPH-93F6
        0x9411, # G+12906  U+9411  uni9411,  CJK UNIFIED IDEOGRAPH-9411
        0x9406, # G+12907  U+9406  uni9406,  CJK UNIFIED IDEOGRAPH-9406
        0x95DE, # G+12908  U+95DE  uni95DE,  CJK UNIFIED IDEOGRAPH-95DE
        0x95E0, # G+12909  U+95E0  uni95E0,  CJK UNIFIED IDEOGRAPH-95E0
        0x95DF, # G+12910  U+95DF  uni95DF,  CJK UNIFIED IDEOGRAPH-95DF
        0x972E, # G+12911  U+972E  uni972E,  CJK UNIFIED IDEOGRAPH-972E
        0x972F, # G+12912  U+972F  uni972F,  CJK UNIFIED IDEOGRAPH-972F
        0x97B9, # G+12913  U+97B9  uni97B9,  CJK UNIFIED IDEOGRAPH-97B9
        0x97BB, # G+12914  U+97BB  uni97BB,  CJK UNIFIED IDEOGRAPH-97BB
        0x97FD, # G+12915  U+97FD  uni97FD,  CJK UNIFIED IDEOGRAPH-97FD
        0x97FE, # G+12916  U+97FE  uni97FE,  CJK UNIFIED IDEOGRAPH-97FE
        0x9860, # G+12917  U+9860  uni9860,  CJK UNIFIED IDEOGRAPH-9860
        0x9862, # G+12918  U+9862  uni9862,  CJK UNIFIED IDEOGRAPH-9862
        0x9863, # G+12919  U+9863  uni9863,  CJK UNIFIED IDEOGRAPH-9863
        0x985F, # G+12920  U+985F  uni985F,  CJK UNIFIED IDEOGRAPH-985F
        0x98C1, # G+12921  U+98C1  uni98C1,  CJK UNIFIED IDEOGRAPH-98C1
        0x98C2, # G+12922  U+98C2  uni98C2,  CJK UNIFIED IDEOGRAPH-98C2
        0x9950, # G+12923  U+9950  uni9950,  CJK UNIFIED IDEOGRAPH-9950
        0x994E, # G+12924  U+994E  uni994E,  CJK UNIFIED IDEOGRAPH-994E
        0x9959, # G+12925  U+9959  uni9959,  CJK UNIFIED IDEOGRAPH-9959
        0x994C, # G+12926  U+994C  uni994C,  CJK UNIFIED IDEOGRAPH-994C
        0x994B, # G+12927  U+994B  uni994B,  CJK UNIFIED IDEOGRAPH-994B
        0x9953, # G+12928  U+9953  uni9953,  CJK UNIFIED IDEOGRAPH-9953
        0x9A32, # G+12929  U+9A32  uni9A32,  CJK UNIFIED IDEOGRAPH-9A32
        0x9A34, # G+12930  U+9A34  uni9A34,  CJK UNIFIED IDEOGRAPH-9A34
        0x9A31, # G+12931  U+9A31  uni9A31,  CJK UNIFIED IDEOGRAPH-9A31
        0x9A2C, # G+12932  U+9A2C  uni9A2C,  CJK UNIFIED IDEOGRAPH-9A2C
        0x9A2A, # G+12933  U+9A2A  uni9A2A,  CJK UNIFIED IDEOGRAPH-9A2A
        0x9A36, # G+12934  U+9A36  uni9A36,  CJK UNIFIED IDEOGRAPH-9A36
        0x9A29, # G+12935  U+9A29  uni9A29,  CJK UNIFIED IDEOGRAPH-9A29
        0x9A2E, # G+12936  U+9A2E  uni9A2E,  CJK UNIFIED IDEOGRAPH-9A2E
        0x9A38, # G+12937  U+9A38  uni9A38,  CJK UNIFIED IDEOGRAPH-9A38
        0x9A2D, # G+12938  U+9A2D  uni9A2D,  CJK UNIFIED IDEOGRAPH-9A2D
        0x9AC7, # G+12939  U+9AC7  uni9AC7,  CJK UNIFIED IDEOGRAPH-9AC7
        0x9ACA, # G+12940  U+9ACA  uni9ACA,  CJK UNIFIED IDEOGRAPH-9ACA
        0x9AC6, # G+12941  U+9AC6  uni9AC6,  CJK UNIFIED IDEOGRAPH-9AC6
        0x9B10, # G+12942  U+9B10  uni9B10,  CJK UNIFIED IDEOGRAPH-9B10
        0x9B12, # G+12943  U+9B12  uni9B12,  CJK UNIFIED IDEOGRAPH-9B12
        0x9B11, # G+12944  U+9B11  uni9B11,  CJK UNIFIED IDEOGRAPH-9B11
        0x9C0B, # G+12945  U+9C0B  uni9C0B,  CJK UNIFIED IDEOGRAPH-9C0B
        0x9C08, # G+12946  U+9C08  uni9C08,  CJK UNIFIED IDEOGRAPH-9C08
        0x9BF7, # G+12947  U+9BF7  uni9BF7,  CJK UNIFIED IDEOGRAPH-9BF7
        0x9C05, # G+12948  U+9C05  uni9C05,  CJK UNIFIED IDEOGRAPH-9C05
        0x9C12, # G+12949  U+9C12  uni9C12,  CJK UNIFIED IDEOGRAPH-9C12
        0x9BF8, # G+12950  U+9BF8  uni9BF8,  CJK UNIFIED IDEOGRAPH-9BF8
        0x9C40, # G+12951  U+9C40  uni9C40,  CJK UNIFIED IDEOGRAPH-9C40
        0x9C07, # G+12952  U+9C07  uni9C07,  CJK UNIFIED IDEOGRAPH-9C07
        0x9C0E, # G+12953  U+9C0E  uni9C0E,  CJK UNIFIED IDEOGRAPH-9C0E
        0x9C06, # G+12954  U+9C06  uni9C06,  CJK UNIFIED IDEOGRAPH-9C06
        0x9C17, # G+12955  U+9C17  uni9C17,  CJK UNIFIED IDEOGRAPH-9C17
        0x9C14, # G+12956  U+9C14  uni9C14,  CJK UNIFIED IDEOGRAPH-9C14
        0x9C09, # G+12957  U+9C09  uni9C09,  CJK UNIFIED IDEOGRAPH-9C09
        0x9D9F, # G+12958  U+9D9F  uni9D9F,  CJK UNIFIED IDEOGRAPH-9D9F
        0x9D99, # G+12959  U+9D99  uni9D99,  CJK UNIFIED IDEOGRAPH-9D99
        0x9DA4, # G+12960  U+9DA4  uni9DA4,  CJK UNIFIED IDEOGRAPH-9DA4
        0x9D9D, # G+12961  U+9D9D  uni9D9D,  CJK UNIFIED IDEOGRAPH-9D9D
        0x9D92, # G+12962  U+9D92  uni9D92,  CJK UNIFIED IDEOGRAPH-9D92
        0x9D98, # G+12963  U+9D98  uni9D98,  CJK UNIFIED IDEOGRAPH-9D98
        0x9D90, # G+12964  U+9D90  uni9D90,  CJK UNIFIED IDEOGRAPH-9D90
        0x9D9B, # G+12965  U+9D9B  uni9D9B,  CJK UNIFIED IDEOGRAPH-9D9B
        0x9DA0, # G+12966  U+9DA0  uni9DA0,  CJK UNIFIED IDEOGRAPH-9DA0
        0x9D94, # G+12967  U+9D94  uni9D94,  CJK UNIFIED IDEOGRAPH-9D94
        0x9D9C, # G+12968  U+9D9C  uni9D9C,  CJK UNIFIED IDEOGRAPH-9D9C
        0x9DAA, # G+12969  U+9DAA  uni9DAA,  CJK UNIFIED IDEOGRAPH-9DAA
        0x9D97, # G+12970  U+9D97  uni9D97,  CJK UNIFIED IDEOGRAPH-9D97
        0x9DA1, # G+12971  U+9DA1  uni9DA1,  CJK UNIFIED IDEOGRAPH-9DA1
        0x9D9A, # G+12972  U+9D9A  uni9D9A,  CJK UNIFIED IDEOGRAPH-9D9A
        0x9DA2, # G+12973  U+9DA2  uni9DA2,  CJK UNIFIED IDEOGRAPH-9DA2
        0x9DA8, # G+12974  U+9DA8  uni9DA8,  CJK UNIFIED IDEOGRAPH-9DA8
        0x9D9E, # G+12975  U+9D9E  uni9D9E,  CJK UNIFIED IDEOGRAPH-9D9E
        0x9DA3, # G+12976  U+9DA3  uni9DA3,  CJK UNIFIED IDEOGRAPH-9DA3
        0x9DBF, # G+12977  U+9DBF  uni9DBF,  CJK UNIFIED IDEOGRAPH-9DBF
        0x9DA9, # G+12978  U+9DA9  uni9DA9,  CJK UNIFIED IDEOGRAPH-9DA9
        0x9D96, # G+12979  U+9D96  uni9D96,  CJK UNIFIED IDEOGRAPH-9D96
        0x9DA6, # G+12980  U+9DA6  uni9DA6,  CJK UNIFIED IDEOGRAPH-9DA6
        0x9DA7, # G+12981  U+9DA7  uni9DA7,  CJK UNIFIED IDEOGRAPH-9DA7
        0x9E99, # G+12982  U+9E99  uni9E99,  CJK UNIFIED IDEOGRAPH-9E99
        0x9E9B, # G+12983  U+9E9B  uni9E9B,  CJK UNIFIED IDEOGRAPH-9E9B
        0x9E9A, # G+12984  U+9E9A  uni9E9A,  CJK UNIFIED IDEOGRAPH-9E9A
        0x9EE5, # G+12985  U+9EE5  uni9EE5,  CJK UNIFIED IDEOGRAPH-9EE5
        0x9EE4, # G+12986  U+9EE4  uni9EE4,  CJK UNIFIED IDEOGRAPH-9EE4
        0x9EE7, # G+12987  U+9EE7  uni9EE7,  CJK UNIFIED IDEOGRAPH-9EE7
        0x9EE6, # G+12988  U+9EE6  uni9EE6,  CJK UNIFIED IDEOGRAPH-9EE6
        0x9F30, # G+12989  U+9F30  uni9F30,  CJK UNIFIED IDEOGRAPH-9F30
        0x9F2E, # G+12990  U+9F2E  uni9F2E,  CJK UNIFIED IDEOGRAPH-9F2E
        0x9F5B, # G+12991  U+9F5B  uni9F5B,  CJK UNIFIED IDEOGRAPH-9F5B
        0x9F60, # G+12992  U+9F60  uni9F60,  CJK UNIFIED IDEOGRAPH-9F60
        0x9F5E, # G+12993  U+9F5E  uni9F5E,  CJK UNIFIED IDEOGRAPH-9F5E
        0x9F5D, # G+12994  U+9F5D  uni9F5D,  CJK UNIFIED IDEOGRAPH-9F5D
        0x9F59, # G+12995  U+9F59  uni9F59,  CJK UNIFIED IDEOGRAPH-9F59
        0x9F91, # G+12996  U+9F91  uni9F91,  CJK UNIFIED IDEOGRAPH-9F91
        0x513A, # G+12997  U+513A  uni513A,  CJK UNIFIED IDEOGRAPH-513A
        0x5139, # G+12998  U+5139  uni5139,  CJK UNIFIED IDEOGRAPH-5139
        0x5298, # G+12999  U+5298  uni5298,  CJK UNIFIED IDEOGRAPH-5298
        0x5297, # G+13000  U+5297  uni5297,  CJK UNIFIED IDEOGRAPH-5297
        0x56C3, # G+13001  U+56C3  uni56C3,  CJK UNIFIED IDEOGRAPH-56C3
        0x56BD, # G+13002  U+56BD  uni56BD,  CJK UNIFIED IDEOGRAPH-56BD
        0x56BE, # G+13003  U+56BE  uni56BE,  CJK UNIFIED IDEOGRAPH-56BE
        0x5B48, # G+13004  U+5B48  uni5B48,  CJK UNIFIED IDEOGRAPH-5B48
        0x5B47, # G+13005  U+5B47  uni5B47,  CJK UNIFIED IDEOGRAPH-5B47
        0x5DCB, # G+13006  U+5DCB  uni5DCB,  CJK UNIFIED IDEOGRAPH-5DCB
        0x5DCF, # G+13007  U+5DCF  uni5DCF,  CJK UNIFIED IDEOGRAPH-5DCF
        0x5EF1, # G+13008  U+5EF1  uni5EF1,  CJK UNIFIED IDEOGRAPH-5EF1
        0x61FD, # G+13009  U+61FD  uni61FD,  CJK UNIFIED IDEOGRAPH-61FD
        0x651B, # G+13010  U+651B  uni651B,  CJK UNIFIED IDEOGRAPH-651B
        0x6B02, # G+13011  U+6B02  uni6B02,  CJK UNIFIED IDEOGRAPH-6B02
        0x6AFC, # G+13012  U+6AFC  uni6AFC,  CJK UNIFIED IDEOGRAPH-6AFC
        0x6B03, # G+13013  U+6B03  uni6B03,  CJK UNIFIED IDEOGRAPH-6B03
        0x6AF8, # G+13014  U+6AF8  uni6AF8,  CJK UNIFIED IDEOGRAPH-6AF8
        0x6B00, # G+13015  U+6B00  uni6B00,  CJK UNIFIED IDEOGRAPH-6B00
        0x7043, # G+13016  U+7043  uni7043,  CJK UNIFIED IDEOGRAPH-7043
        0x7044, # G+13017  U+7044  uni7044,  CJK UNIFIED IDEOGRAPH-7044
        0x704A, # G+13018  U+704A  uni704A,  CJK UNIFIED IDEOGRAPH-704A
        0x7048, # G+13019  U+7048  uni7048,  CJK UNIFIED IDEOGRAPH-7048
        0x7049, # G+13020  U+7049  uni7049,  CJK UNIFIED IDEOGRAPH-7049
        0x7045, # G+13021  U+7045  uni7045,  CJK UNIFIED IDEOGRAPH-7045
        0x7046, # G+13022  U+7046  uni7046,  CJK UNIFIED IDEOGRAPH-7046
        0x721D, # G+13023  U+721D  uni721D,  CJK UNIFIED IDEOGRAPH-721D
        0x721A, # G+13024  U+721A  uni721A,  CJK UNIFIED IDEOGRAPH-721A
        0x7219, # G+13025  U+7219  uni7219,  CJK UNIFIED IDEOGRAPH-7219
        0x737E, # G+13026  U+737E  uni737E,  CJK UNIFIED IDEOGRAPH-737E
        0x7517, # G+13027  U+7517  uni7517,  CJK UNIFIED IDEOGRAPH-7517
        0x766A, # G+13028  U+766A  uni766A,  CJK UNIFIED IDEOGRAPH-766A
        0x77D0, # G+13029  U+77D0  uni77D0,  CJK UNIFIED IDEOGRAPH-77D0
        0x792D, # G+13030  U+792D  uni792D,  CJK UNIFIED IDEOGRAPH-792D
        0x7931, # G+13031  U+7931  uni7931,  CJK UNIFIED IDEOGRAPH-7931
        0x792F, # G+13032  U+792F  uni792F,  CJK UNIFIED IDEOGRAPH-792F
        0x7C54, # G+13033  U+7C54  uni7C54,  CJK UNIFIED IDEOGRAPH-7C54
        0x7C53, # G+13034  U+7C53  uni7C53,  CJK UNIFIED IDEOGRAPH-7C53
        0x7CF2, # G+13035  U+7CF2  uni7CF2,  CJK UNIFIED IDEOGRAPH-7CF2
        0x7E8A, # G+13036  U+7E8A  uni7E8A,  CJK UNIFIED IDEOGRAPH-7E8A
        0xEB45, # G+13037  U+EB45  uniEB45,  
        0x7E88, # G+13038  U+7E88  uni7E88,  CJK UNIFIED IDEOGRAPH-7E88
        0x7E8B, # G+13039  U+7E8B  uni7E8B,  CJK UNIFIED IDEOGRAPH-7E8B
        0x7E86, # G+13040  U+7E86  uni7E86,  CJK UNIFIED IDEOGRAPH-7E86
        0x7E8D, # G+13041  U+7E8D  uni7E8D,  CJK UNIFIED IDEOGRAPH-7E8D
        0x7F4D, # G+13042  U+7F4D  uni7F4D,  CJK UNIFIED IDEOGRAPH-7F4D
        0x7FBB, # G+13043  U+7FBB  uni7FBB,  CJK UNIFIED IDEOGRAPH-7FBB
        0x8030, # G+13044  U+8030  uni8030,  CJK UNIFIED IDEOGRAPH-8030
        0x81DD, # G+13045  U+81DD  uni81DD,  CJK UNIFIED IDEOGRAPH-81DD
        0x8618, # G+13046  U+8618  uni8618,  CJK UNIFIED IDEOGRAPH-8618
        0x862A, # G+13047  U+862A  uni862A,  CJK UNIFIED IDEOGRAPH-862A
        0x8626, # G+13048  U+8626  uni8626,  CJK UNIFIED IDEOGRAPH-8626
        0x861F, # G+13049  U+861F  uni861F,  CJK UNIFIED IDEOGRAPH-861F
        0x8623, # G+13050  U+8623  uni8623,  CJK UNIFIED IDEOGRAPH-8623
        0x861C, # G+13051  U+861C  uni861C,  CJK UNIFIED IDEOGRAPH-861C
        0x8619, # G+13052  U+8619  uni8619,  CJK UNIFIED IDEOGRAPH-8619
        0x8627, # G+13053  U+8627  uni8627,  CJK UNIFIED IDEOGRAPH-8627
        0x862E, # G+13054  U+862E  uni862E,  CJK UNIFIED IDEOGRAPH-862E
        0x8621, # G+13055  U+8621  uni8621,  CJK UNIFIED IDEOGRAPH-8621
        0x8620, # G+13056  U+8620  uni8620,  CJK UNIFIED IDEOGRAPH-8620
        0x8629, # G+13057  U+8629  uni8629,  CJK UNIFIED IDEOGRAPH-8629
        0x861E, # G+13058  U+861E  uni861E,  CJK UNIFIED IDEOGRAPH-861E
        0x8625, # G+13059  U+8625  uni8625,  CJK UNIFIED IDEOGRAPH-8625
        0x8829, # G+13060  U+8829  uni8829,  CJK UNIFIED IDEOGRAPH-8829
        0x881D, # G+13061  U+881D  uni881D,  CJK UNIFIED IDEOGRAPH-881D
        0x881B, # G+13062  U+881B  uni881B,  CJK UNIFIED IDEOGRAPH-881B
        0x8820, # G+13063  U+8820  uni8820,  CJK UNIFIED IDEOGRAPH-8820
        0x8824, # G+13064  U+8824  uni8824,  CJK UNIFIED IDEOGRAPH-8824
        0x881C, # G+13065  U+881C  uni881C,  CJK UNIFIED IDEOGRAPH-881C
        0x882B, # G+13066  U+882B  uni882B,  CJK UNIFIED IDEOGRAPH-882B
        0x884A, # G+13067  U+884A  uni884A,  CJK UNIFIED IDEOGRAPH-884A
        0x896D, # G+13068  U+896D  uni896D,  CJK UNIFIED IDEOGRAPH-896D
        0x8969, # G+13069  U+8969  uni8969,  CJK UNIFIED IDEOGRAPH-8969
        0x896E, # G+13070  U+896E  uni896E,  CJK UNIFIED IDEOGRAPH-896E
        0x896B, # G+13071  U+896B  uni896B,  CJK UNIFIED IDEOGRAPH-896B
        0x89FA, # G+13072  U+89FA  uni89FA,  CJK UNIFIED IDEOGRAPH-89FA
        0x8B79, # G+13073  U+8B79  uni8B79,  CJK UNIFIED IDEOGRAPH-8B79
        0x8B78, # G+13074  U+8B78  uni8B78,  CJK UNIFIED IDEOGRAPH-8B78
        0x8B45, # G+13075  U+8B45  uni8B45,  CJK UNIFIED IDEOGRAPH-8B45
        0x8B7A, # G+13076  U+8B7A  uni8B7A,  CJK UNIFIED IDEOGRAPH-8B7A
        0x8B7B, # G+13077  U+8B7B  uni8B7B,  CJK UNIFIED IDEOGRAPH-8B7B
        0x8D10, # G+13078  U+8D10  uni8D10,  CJK UNIFIED IDEOGRAPH-8D10
        0x8D14, # G+13079  U+8D14  uni8D14,  CJK UNIFIED IDEOGRAPH-8D14
        0x8DAF, # G+13080  U+8DAF  uni8DAF,  CJK UNIFIED IDEOGRAPH-8DAF
        0x8E8E, # G+13081  U+8E8E  uni8E8E,  CJK UNIFIED IDEOGRAPH-8E8E
        0x8E8C, # G+13082  U+8E8C  uni8E8C,  CJK UNIFIED IDEOGRAPH-8E8C
        0x8F5E, # G+13083  U+8F5E  uni8F5E,  CJK UNIFIED IDEOGRAPH-8F5E
        0x8F5B, # G+13084  U+8F5B  uni8F5B,  CJK UNIFIED IDEOGRAPH-8F5B
        0x8F5D, # G+13085  U+8F5D  uni8F5D,  CJK UNIFIED IDEOGRAPH-8F5D
        0x9146, # G+13086  U+9146  uni9146,  CJK UNIFIED IDEOGRAPH-9146
        0x9144, # G+13087  U+9144  uni9144,  CJK UNIFIED IDEOGRAPH-9144
        0x9145, # G+13088  U+9145  uni9145,  CJK UNIFIED IDEOGRAPH-9145
        0x91B9, # G+13089  U+91B9  uni91B9,  CJK UNIFIED IDEOGRAPH-91B9
        0x943F, # G+13090  U+943F  uni943F,  CJK UNIFIED IDEOGRAPH-943F
        0x943B, # G+13091  U+943B  uni943B,  CJK UNIFIED IDEOGRAPH-943B
        0x9436, # G+13092  U+9436  uni9436,  CJK UNIFIED IDEOGRAPH-9436
        0x9429, # G+13093  U+9429  uni9429,  CJK UNIFIED IDEOGRAPH-9429
        0x943D, # G+13094  U+943D  uni943D,  CJK UNIFIED IDEOGRAPH-943D
        0x9430, # G+13095  U+9430  uni9430,  CJK UNIFIED IDEOGRAPH-9430
        0x9439, # G+13096  U+9439  uni9439,  CJK UNIFIED IDEOGRAPH-9439
        0x942A, # G+13097  U+942A  uni942A,  CJK UNIFIED IDEOGRAPH-942A
        0x9437, # G+13098  U+9437  uni9437,  CJK UNIFIED IDEOGRAPH-9437
        0x942C, # G+13099  U+942C  uni942C,  CJK UNIFIED IDEOGRAPH-942C
        0x9440, # G+13100  U+9440  uni9440,  CJK UNIFIED IDEOGRAPH-9440
        0x9431, # G+13101  U+9431  uni9431,  CJK UNIFIED IDEOGRAPH-9431
        0x95E5, # G+13102  U+95E5  uni95E5,  CJK UNIFIED IDEOGRAPH-95E5
        0x95E4, # G+13103  U+95E4  uni95E4,  CJK UNIFIED IDEOGRAPH-95E4
        0x95E3, # G+13104  U+95E3  uni95E3,  CJK UNIFIED IDEOGRAPH-95E3
        0x9735, # G+13105  U+9735  uni9735,  CJK UNIFIED IDEOGRAPH-9735
        0x973A, # G+13106  U+973A  uni973A,  CJK UNIFIED IDEOGRAPH-973A
        0x97BF, # G+13107  U+97BF  uni97BF,  CJK UNIFIED IDEOGRAPH-97BF
        0x97E1, # G+13108  U+97E1  uni97E1,  CJK UNIFIED IDEOGRAPH-97E1
        0x9864, # G+13109  U+9864  uni9864,  CJK UNIFIED IDEOGRAPH-9864
        0x98C9, # G+13110  U+98C9  uni98C9,  CJK UNIFIED IDEOGRAPH-98C9
        0x98C6, # G+13111  U+98C6  uni98C6,  CJK UNIFIED IDEOGRAPH-98C6
        0x98C0, # G+13112  U+98C0  uni98C0,  CJK UNIFIED IDEOGRAPH-98C0
        0x9958, # G+13113  U+9958  uni9958,  CJK UNIFIED IDEOGRAPH-9958
        0x9956, # G+13114  U+9956  uni9956,  CJK UNIFIED IDEOGRAPH-9956
        0x9A39, # G+13115  U+9A39  uni9A39,  CJK UNIFIED IDEOGRAPH-9A39
        0x9A3D, # G+13116  U+9A3D  uni9A3D,  CJK UNIFIED IDEOGRAPH-9A3D
        0x9A46, # G+13117  U+9A46  uni9A46,  CJK UNIFIED IDEOGRAPH-9A46
        0x9A44, # G+13118  U+9A44  uni9A44,  CJK UNIFIED IDEOGRAPH-9A44
        0x9A42, # G+13119  U+9A42  uni9A42,  CJK UNIFIED IDEOGRAPH-9A42
        0x9A41, # G+13120  U+9A41  uni9A41,  CJK UNIFIED IDEOGRAPH-9A41
        0x9A3A, # G+13121  U+9A3A  uni9A3A,  CJK UNIFIED IDEOGRAPH-9A3A
        0x9A3F, # G+13122  U+9A3F  uni9A3F,  CJK UNIFIED IDEOGRAPH-9A3F
        0x9ACD, # G+13123  U+9ACD  uni9ACD,  CJK UNIFIED IDEOGRAPH-9ACD
        0x9B15, # G+13124  U+9B15  uni9B15,  CJK UNIFIED IDEOGRAPH-9B15
        0x9B17, # G+13125  U+9B17  uni9B17,  CJK UNIFIED IDEOGRAPH-9B17
        0x9B18, # G+13126  U+9B18  uni9B18,  CJK UNIFIED IDEOGRAPH-9B18
        0x9B16, # G+13127  U+9B16  uni9B16,  CJK UNIFIED IDEOGRAPH-9B16
        0x9B3A, # G+13128  U+9B3A  uni9B3A,  CJK UNIFIED IDEOGRAPH-9B3A
        0x9B52, # G+13129  U+9B52  uni9B52,  CJK UNIFIED IDEOGRAPH-9B52
        0x9C2B, # G+13130  U+9C2B  uni9C2B,  CJK UNIFIED IDEOGRAPH-9C2B
        0x9C1D, # G+13131  U+9C1D  uni9C1D,  CJK UNIFIED IDEOGRAPH-9C1D
        0x9C1C, # G+13132  U+9C1C  uni9C1C,  CJK UNIFIED IDEOGRAPH-9C1C
        0x9C2C, # G+13133  U+9C2C  uni9C2C,  CJK UNIFIED IDEOGRAPH-9C2C
        0x9C23, # G+13134  U+9C23  uni9C23,  CJK UNIFIED IDEOGRAPH-9C23
        0x9C28, # G+13135  U+9C28  uni9C28,  CJK UNIFIED IDEOGRAPH-9C28
        0x9C29, # G+13136  U+9C29  uni9C29,  CJK UNIFIED IDEOGRAPH-9C29
        0x9C24, # G+13137  U+9C24  uni9C24,  CJK UNIFIED IDEOGRAPH-9C24
        0x9C21, # G+13138  U+9C21  uni9C21,  CJK UNIFIED IDEOGRAPH-9C21
        0x9DB7, # G+13139  U+9DB7  uni9DB7,  CJK UNIFIED IDEOGRAPH-9DB7
        0x9DB6, # G+13140  U+9DB6  uni9DB6,  CJK UNIFIED IDEOGRAPH-9DB6
        0x9DBC, # G+13141  U+9DBC  uni9DBC,  CJK UNIFIED IDEOGRAPH-9DBC
        0x9DC1, # G+13142  U+9DC1  uni9DC1,  CJK UNIFIED IDEOGRAPH-9DC1
        0x9DC7, # G+13143  U+9DC7  uni9DC7,  CJK UNIFIED IDEOGRAPH-9DC7
        0x9DCA, # G+13144  U+9DCA  uni9DCA,  CJK UNIFIED IDEOGRAPH-9DCA
        0x9DCF, # G+13145  U+9DCF  uni9DCF,  CJK UNIFIED IDEOGRAPH-9DCF
        0x9DBE, # G+13146  U+9DBE  uni9DBE,  CJK UNIFIED IDEOGRAPH-9DBE
        0x9DC5, # G+13147  U+9DC5  uni9DC5,  CJK UNIFIED IDEOGRAPH-9DC5
        0x9DC3, # G+13148  U+9DC3  uni9DC3,  CJK UNIFIED IDEOGRAPH-9DC3
        0x9DBB, # G+13149  U+9DBB  uni9DBB,  CJK UNIFIED IDEOGRAPH-9DBB
        0x9DB5, # G+13150  U+9DB5  uni9DB5,  CJK UNIFIED IDEOGRAPH-9DB5
        0x9DCE, # G+13151  U+9DCE  uni9DCE,  CJK UNIFIED IDEOGRAPH-9DCE
        0x9DB9, # G+13152  U+9DB9  uni9DB9,  CJK UNIFIED IDEOGRAPH-9DB9
        0x9DBA, # G+13153  U+9DBA  uni9DBA,  CJK UNIFIED IDEOGRAPH-9DBA
        0x9DAC, # G+13154  U+9DAC  uni9DAC,  CJK UNIFIED IDEOGRAPH-9DAC
        0x9DC8, # G+13155  U+9DC8  uni9DC8,  CJK UNIFIED IDEOGRAPH-9DC8
        0x9DB1, # G+13156  U+9DB1  uni9DB1,  CJK UNIFIED IDEOGRAPH-9DB1
        0x9DAD, # G+13157  U+9DAD  uni9DAD,  CJK UNIFIED IDEOGRAPH-9DAD
        0x9DCC, # G+13158  U+9DCC  uni9DCC,  CJK UNIFIED IDEOGRAPH-9DCC
        0x9DB3, # G+13159  U+9DB3  uni9DB3,  CJK UNIFIED IDEOGRAPH-9DB3
        0x9DCD, # G+13160  U+9DCD  uni9DCD,  CJK UNIFIED IDEOGRAPH-9DCD
        0x9DB2, # G+13161  U+9DB2  uni9DB2,  CJK UNIFIED IDEOGRAPH-9DB2
        0x9E7A, # G+13162  U+9E7A  uni9E7A,  CJK UNIFIED IDEOGRAPH-9E7A
        0x9E9C, # G+13163  U+9E9C  uni9E9C,  CJK UNIFIED IDEOGRAPH-9E9C
        0x9EEB, # G+13164  U+9EEB  uni9EEB,  CJK UNIFIED IDEOGRAPH-9EEB
        0x9EEE, # G+13165  U+9EEE  uni9EEE,  CJK UNIFIED IDEOGRAPH-9EEE
        0x9EED, # G+13166  U+9EED  uni9EED,  CJK UNIFIED IDEOGRAPH-9EED
        0x9F1B, # G+13167  U+9F1B  uni9F1B,  CJK UNIFIED IDEOGRAPH-9F1B
        0x9F18, # G+13168  U+9F18  uni9F18,  CJK UNIFIED IDEOGRAPH-9F18
        0x9F1A, # G+13169  U+9F1A  uni9F1A,  CJK UNIFIED IDEOGRAPH-9F1A
        0x9F31, # G+13170  U+9F31  uni9F31,  CJK UNIFIED IDEOGRAPH-9F31
        0x9F4E, # G+13171  U+9F4E  uni9F4E,  CJK UNIFIED IDEOGRAPH-9F4E
        0x9F65, # G+13172  U+9F65  uni9F65,  CJK UNIFIED IDEOGRAPH-9F65
        0x9F64, # G+13173  U+9F64  uni9F64,  CJK UNIFIED IDEOGRAPH-9F64
        0x9F92, # G+13174  U+9F92  uni9F92,  CJK UNIFIED IDEOGRAPH-9F92
        0x4EB9, # G+13175  U+4EB9  uni4EB9,  CJK UNIFIED IDEOGRAPH-4EB9
        0x56C6, # G+13176  U+56C6  uni56C6,  CJK UNIFIED IDEOGRAPH-56C6
        0x56C5, # G+13177  U+56C5  uni56C5,  CJK UNIFIED IDEOGRAPH-56C5
        0x56CB, # G+13178  U+56CB  uni56CB,  CJK UNIFIED IDEOGRAPH-56CB
        0x5971, # G+13179  U+5971  uni5971,  CJK UNIFIED IDEOGRAPH-5971
        0x5B4B, # G+13180  U+5B4B  uni5B4B,  CJK UNIFIED IDEOGRAPH-5B4B
        0x5B4C, # G+13181  U+5B4C  uni5B4C,  CJK UNIFIED IDEOGRAPH-5B4C
        0x5DD5, # G+13182  U+5DD5  uni5DD5,  CJK UNIFIED IDEOGRAPH-5DD5
        0x5DD1, # G+13183  U+5DD1  uni5DD1,  CJK UNIFIED IDEOGRAPH-5DD1
        0x5EF2, # G+13184  U+5EF2  uni5EF2,  CJK UNIFIED IDEOGRAPH-5EF2
        0x6521, # G+13185  U+6521  uni6521,  CJK UNIFIED IDEOGRAPH-6521
        0x6520, # G+13186  U+6520  uni6520,  CJK UNIFIED IDEOGRAPH-6520
        0x6526, # G+13187  U+6526  uni6526,  CJK UNIFIED IDEOGRAPH-6526
        0x6522, # G+13188  U+6522  uni6522,  CJK UNIFIED IDEOGRAPH-6522
        0x6B0B, # G+13189  U+6B0B  uni6B0B,  CJK UNIFIED IDEOGRAPH-6B0B
        0x6B08, # G+13190  U+6B08  uni6B08,  CJK UNIFIED IDEOGRAPH-6B08
        0x6B09, # G+13191  U+6B09  uni6B09,  CJK UNIFIED IDEOGRAPH-6B09
        0x6C0D, # G+13192  U+6C0D  uni6C0D,  CJK UNIFIED IDEOGRAPH-6C0D
        0x7055, # G+13193  U+7055  uni7055,  CJK UNIFIED IDEOGRAPH-7055
        0x7056, # G+13194  U+7056  uni7056,  CJK UNIFIED IDEOGRAPH-7056
        0x7057, # G+13195  U+7057  uni7057,  CJK UNIFIED IDEOGRAPH-7057
        0x7052, # G+13196  U+7052  uni7052,  CJK UNIFIED IDEOGRAPH-7052
        0x721E, # G+13197  U+721E  uni721E,  CJK UNIFIED IDEOGRAPH-721E
        0x721F, # G+13198  U+721F  uni721F,  CJK UNIFIED IDEOGRAPH-721F
        0x72A9, # G+13199  U+72A9  uni72A9,  CJK UNIFIED IDEOGRAPH-72A9
        0x737F, # G+13200  U+737F  uni737F,  CJK UNIFIED IDEOGRAPH-737F
        0x74D8, # G+13201  U+74D8  uni74D8,  CJK UNIFIED IDEOGRAPH-74D8
        0x74D5, # G+13202  U+74D5  uni74D5,  CJK UNIFIED IDEOGRAPH-74D5
        0x74D9, # G+13203  U+74D9  uni74D9,  CJK UNIFIED IDEOGRAPH-74D9
        0x74D7, # G+13204  U+74D7  uni74D7,  CJK UNIFIED IDEOGRAPH-74D7
        0x766D, # G+13205  U+766D  uni766D,  CJK UNIFIED IDEOGRAPH-766D
        0x76AD, # G+13206  U+76AD  uni76AD,  CJK UNIFIED IDEOGRAPH-76AD
        0x7935, # G+13207  U+7935  uni7935,  CJK UNIFIED IDEOGRAPH-7935
        0x79B4, # G+13208  U+79B4  uni79B4,  CJK UNIFIED IDEOGRAPH-79B4
        0x7A70, # G+13209  U+7A70  uni7A70,  CJK UNIFIED IDEOGRAPH-7A70
        0x7A71, # G+13210  U+7A71  uni7A71,  CJK UNIFIED IDEOGRAPH-7A71
        0x7C57, # G+13211  U+7C57  uni7C57,  CJK UNIFIED IDEOGRAPH-7C57
        0x7C5C, # G+13212  U+7C5C  uni7C5C,  CJK UNIFIED IDEOGRAPH-7C5C
        0x7C59, # G+13213  U+7C59  uni7C59,  CJK UNIFIED IDEOGRAPH-7C59
        0x7C5B, # G+13214  U+7C5B  uni7C5B,  CJK UNIFIED IDEOGRAPH-7C5B
        0x7C5A, # G+13215  U+7C5A  uni7C5A,  CJK UNIFIED IDEOGRAPH-7C5A
        0x7CF4, # G+13216  U+7CF4  uni7CF4,  CJK UNIFIED IDEOGRAPH-7CF4
        0x7CF1, # G+13217  U+7CF1  uni7CF1,  CJK UNIFIED IDEOGRAPH-7CF1
        0x7E91, # G+13218  U+7E91  uni7E91,  CJK UNIFIED IDEOGRAPH-7E91
        0x7F4F, # G+13219  U+7F4F  uni7F4F,  CJK UNIFIED IDEOGRAPH-7F4F
        0x7F87, # G+13220  U+7F87  uni7F87,  CJK UNIFIED IDEOGRAPH-7F87
        0x81DE, # G+13221  U+81DE  uni81DE,  CJK UNIFIED IDEOGRAPH-81DE
        0x826B, # G+13222  U+826B  uni826B,  CJK UNIFIED IDEOGRAPH-826B
        0x8634, # G+13223  U+8634  uni8634,  CJK UNIFIED IDEOGRAPH-8634
        0x8635, # G+13224  U+8635  uni8635,  CJK UNIFIED IDEOGRAPH-8635
        0x8633, # G+13225  U+8633  uni8633,  CJK UNIFIED IDEOGRAPH-8633
        0x862C, # G+13226  U+862C  uni862C,  CJK UNIFIED IDEOGRAPH-862C
        0x8632, # G+13227  U+8632  uni8632,  CJK UNIFIED IDEOGRAPH-8632
        0x8636, # G+13228  U+8636  uni8636,  CJK UNIFIED IDEOGRAPH-8636
        0x882C, # G+13229  U+882C  uni882C,  CJK UNIFIED IDEOGRAPH-882C
        0x8828, # G+13230  U+8828  uni8828,  CJK UNIFIED IDEOGRAPH-8828
        0x8826, # G+13231  U+8826  uni8826,  CJK UNIFIED IDEOGRAPH-8826
        0x882A, # G+13232  U+882A  uni882A,  CJK UNIFIED IDEOGRAPH-882A
        0x8825, # G+13233  U+8825  uni8825,  CJK UNIFIED IDEOGRAPH-8825
        0x8971, # G+13234  U+8971  uni8971,  CJK UNIFIED IDEOGRAPH-8971
        0x89BF, # G+13235  U+89BF  uni89BF,  CJK UNIFIED IDEOGRAPH-89BF
        0x89BE, # G+13236  U+89BE  uni89BE,  CJK UNIFIED IDEOGRAPH-89BE
        0x89FB, # G+13237  U+89FB  uni89FB,  CJK UNIFIED IDEOGRAPH-89FB
        0x8B7E, # G+13238  U+8B7E  uni8B7E,  CJK UNIFIED IDEOGRAPH-8B7E
        0x8B84, # G+13239  U+8B84  uni8B84,  CJK UNIFIED IDEOGRAPH-8B84
        0x8B82, # G+13240  U+8B82  uni8B82,  CJK UNIFIED IDEOGRAPH-8B82
        0x8B86, # G+13241  U+8B86  uni8B86,  CJK UNIFIED IDEOGRAPH-8B86
        0x8B85, # G+13242  U+8B85  uni8B85,  CJK UNIFIED IDEOGRAPH-8B85
        0x8B7F, # G+13243  U+8B7F  uni8B7F,  CJK UNIFIED IDEOGRAPH-8B7F
        0x8D15, # G+13244  U+8D15  uni8D15,  CJK UNIFIED IDEOGRAPH-8D15
        0x8E95, # G+13245  U+8E95  uni8E95,  CJK UNIFIED IDEOGRAPH-8E95
        0x8E94, # G+13246  U+8E94  uni8E94,  CJK UNIFIED IDEOGRAPH-8E94
        0x8E9A, # G+13247  U+8E9A  uni8E9A,  CJK UNIFIED IDEOGRAPH-8E9A
        0x8E92, # G+13248  U+8E92  uni8E92,  CJK UNIFIED IDEOGRAPH-8E92
        0x8E90, # G+13249  U+8E90  uni8E90,  CJK UNIFIED IDEOGRAPH-8E90
        0x8E96, # G+13250  U+8E96  uni8E96,  CJK UNIFIED IDEOGRAPH-8E96
        0x8E97, # G+13251  U+8E97  uni8E97,  CJK UNIFIED IDEOGRAPH-8E97
        0x8F60, # G+13252  U+8F60  uni8F60,  CJK UNIFIED IDEOGRAPH-8F60
        0x8F62, # G+13253  U+8F62  uni8F62,  CJK UNIFIED IDEOGRAPH-8F62
        0x9147, # G+13254  U+9147  uni9147,  CJK UNIFIED IDEOGRAPH-9147
        0x944C, # G+13255  U+944C  uni944C,  CJK UNIFIED IDEOGRAPH-944C
        0x9450, # G+13256  U+9450  uni9450,  CJK UNIFIED IDEOGRAPH-9450
        0x944A, # G+13257  U+944A  uni944A,  CJK UNIFIED IDEOGRAPH-944A
        0x944B, # G+13258  U+944B  uni944B,  CJK UNIFIED IDEOGRAPH-944B
        0x944F, # G+13259  U+944F  uni944F,  CJK UNIFIED IDEOGRAPH-944F
        0x9447, # G+13260  U+9447  uni9447,  CJK UNIFIED IDEOGRAPH-9447
        0x9445, # G+13261  U+9445  uni9445,  CJK UNIFIED IDEOGRAPH-9445
        0x9448, # G+13262  U+9448  uni9448,  CJK UNIFIED IDEOGRAPH-9448
        0x9449, # G+13263  U+9449  uni9449,  CJK UNIFIED IDEOGRAPH-9449
        0x9446, # G+13264  U+9446  uni9446,  CJK UNIFIED IDEOGRAPH-9446
        0x973F, # G+13265  U+973F  uni973F,  CJK UNIFIED IDEOGRAPH-973F
        0x97E3, # G+13266  U+97E3  uni97E3,  CJK UNIFIED IDEOGRAPH-97E3
        0x986A, # G+13267  U+986A  uni986A,  CJK UNIFIED IDEOGRAPH-986A
        0x9869, # G+13268  U+9869  uni9869,  CJK UNIFIED IDEOGRAPH-9869
        0x98CB, # G+13269  U+98CB  uni98CB,  CJK UNIFIED IDEOGRAPH-98CB
        0x9954, # G+13270  U+9954  uni9954,  CJK UNIFIED IDEOGRAPH-9954
        0x995B, # G+13271  U+995B  uni995B,  CJK UNIFIED IDEOGRAPH-995B
        0x9A4E, # G+13272  U+9A4E  uni9A4E,  CJK UNIFIED IDEOGRAPH-9A4E
        0x9A53, # G+13273  U+9A53  uni9A53,  CJK UNIFIED IDEOGRAPH-9A53
        0x9A54, # G+13274  U+9A54  uni9A54,  CJK UNIFIED IDEOGRAPH-9A54
        0x9A4C, # G+13275  U+9A4C  uni9A4C,  CJK UNIFIED IDEOGRAPH-9A4C
        0x9A4F, # G+13276  U+9A4F  uni9A4F,  CJK UNIFIED IDEOGRAPH-9A4F
        0x9A48, # G+13277  U+9A48  uni9A48,  CJK UNIFIED IDEOGRAPH-9A48
        0x9A4A, # G+13278  U+9A4A  uni9A4A,  CJK UNIFIED IDEOGRAPH-9A4A
        0x9A49, # G+13279  U+9A49  uni9A49,  CJK UNIFIED IDEOGRAPH-9A49
        0x9A52, # G+13280  U+9A52  uni9A52,  CJK UNIFIED IDEOGRAPH-9A52
        0x9A50, # G+13281  U+9A50  uni9A50,  CJK UNIFIED IDEOGRAPH-9A50
        0x9AD0, # G+13282  U+9AD0  uni9AD0,  CJK UNIFIED IDEOGRAPH-9AD0
        0x9B19, # G+13283  U+9B19  uni9B19,  CJK UNIFIED IDEOGRAPH-9B19
        0x9B2B, # G+13284  U+9B2B  uni9B2B,  CJK UNIFIED IDEOGRAPH-9B2B
        0x9B3B, # G+13285  U+9B3B  uni9B3B,  CJK UNIFIED IDEOGRAPH-9B3B
        0x9B56, # G+13286  U+9B56  uni9B56,  CJK UNIFIED IDEOGRAPH-9B56
        0x9B55, # G+13287  U+9B55  uni9B55,  CJK UNIFIED IDEOGRAPH-9B55
        0x9C46, # G+13288  U+9C46  uni9C46,  CJK UNIFIED IDEOGRAPH-9C46
        0x9C48, # G+13289  U+9C48  uni9C48,  CJK UNIFIED IDEOGRAPH-9C48
        0x9C3F, # G+13290  U+9C3F  uni9C3F,  CJK UNIFIED IDEOGRAPH-9C3F
        0x9C44, # G+13291  U+9C44  uni9C44,  CJK UNIFIED IDEOGRAPH-9C44
        0x9C39, # G+13292  U+9C39  uni9C39,  CJK UNIFIED IDEOGRAPH-9C39
        0x9C33, # G+13293  U+9C33  uni9C33,  CJK UNIFIED IDEOGRAPH-9C33
        0x9C41, # G+13294  U+9C41  uni9C41,  CJK UNIFIED IDEOGRAPH-9C41
        0x9C3C, # G+13295  U+9C3C  uni9C3C,  CJK UNIFIED IDEOGRAPH-9C3C
        0x9C37, # G+13296  U+9C37  uni9C37,  CJK UNIFIED IDEOGRAPH-9C37
        0x9C34, # G+13297  U+9C34  uni9C34,  CJK UNIFIED IDEOGRAPH-9C34
        0x9C32, # G+13298  U+9C32  uni9C32,  CJK UNIFIED IDEOGRAPH-9C32
        0x9C3D, # G+13299  U+9C3D  uni9C3D,  CJK UNIFIED IDEOGRAPH-9C3D
        0x9C36, # G+13300  U+9C36  uni9C36,  CJK UNIFIED IDEOGRAPH-9C36
        0x9DDB, # G+13301  U+9DDB  uni9DDB,  CJK UNIFIED IDEOGRAPH-9DDB
        0x9DD2, # G+13302  U+9DD2  uni9DD2,  CJK UNIFIED IDEOGRAPH-9DD2
        0x9DDE, # G+13303  U+9DDE  uni9DDE,  CJK UNIFIED IDEOGRAPH-9DDE
        0x9DDA, # G+13304  U+9DDA  uni9DDA,  CJK UNIFIED IDEOGRAPH-9DDA
        0x9DCB, # G+13305  U+9DCB  uni9DCB,  CJK UNIFIED IDEOGRAPH-9DCB
        0x9DD0, # G+13306  U+9DD0  uni9DD0,  CJK UNIFIED IDEOGRAPH-9DD0
        0x9DDC, # G+13307  U+9DDC  uni9DDC,  CJK UNIFIED IDEOGRAPH-9DDC
        0x9DD1, # G+13308  U+9DD1  uni9DD1,  CJK UNIFIED IDEOGRAPH-9DD1
        0x9DDF, # G+13309  U+9DDF  uni9DDF,  CJK UNIFIED IDEOGRAPH-9DDF
        0x9DE9, # G+13310  U+9DE9  uni9DE9,  CJK UNIFIED IDEOGRAPH-9DE9
        0x9DD9, # G+13311  U+9DD9  uni9DD9,  CJK UNIFIED IDEOGRAPH-9DD9
        0x9DD8, # G+13312  U+9DD8  uni9DD8,  CJK UNIFIED IDEOGRAPH-9DD8
        0x9DD6, # G+13313  U+9DD6  uni9DD6,  CJK UNIFIED IDEOGRAPH-9DD6
        0x9DF5, # G+13314  U+9DF5  uni9DF5,  CJK UNIFIED IDEOGRAPH-9DF5
        0x9DD5, # G+13315  U+9DD5  uni9DD5,  CJK UNIFIED IDEOGRAPH-9DD5
        0x9DDD, # G+13316  U+9DDD  uni9DDD,  CJK UNIFIED IDEOGRAPH-9DDD
        0x9EB6, # G+13317  U+9EB6  uni9EB6,  CJK UNIFIED IDEOGRAPH-9EB6
        0x9EF0, # G+13318  U+9EF0  uni9EF0,  CJK UNIFIED IDEOGRAPH-9EF0
        0x9F35, # G+13319  U+9F35  uni9F35,  CJK UNIFIED IDEOGRAPH-9F35
        0x9F33, # G+13320  U+9F33  uni9F33,  CJK UNIFIED IDEOGRAPH-9F33
        0x9F32, # G+13321  U+9F32  uni9F32,  CJK UNIFIED IDEOGRAPH-9F32
        0x9F42, # G+13322  U+9F42  uni9F42,  CJK UNIFIED IDEOGRAPH-9F42
        0x9F6B, # G+13323  U+9F6B  uni9F6B,  CJK UNIFIED IDEOGRAPH-9F6B
        0x9F95, # G+13324  U+9F95  uni9F95,  CJK UNIFIED IDEOGRAPH-9F95
        0x9FA2, # G+13325  U+9FA2  uni9FA2,  CJK UNIFIED IDEOGRAPH-9FA2
        0x513D, # G+13326  U+513D  uni513D,  CJK UNIFIED IDEOGRAPH-513D
        0x5299, # G+13327  U+5299  uni5299,  CJK UNIFIED IDEOGRAPH-5299
        0x58E8, # G+13328  U+58E8  uni58E8,  CJK UNIFIED IDEOGRAPH-58E8
        0x58E7, # G+13329  U+58E7  uni58E7,  CJK UNIFIED IDEOGRAPH-58E7
        0x5972, # G+13330  U+5972  uni5972,  CJK UNIFIED IDEOGRAPH-5972
        0x5B4D, # G+13331  U+5B4D  uni5B4D,  CJK UNIFIED IDEOGRAPH-5B4D
        0x5DD8, # G+13332  U+5DD8  uni5DD8,  CJK UNIFIED IDEOGRAPH-5DD8
        0x882F, # G+13333  U+882F  uni882F,  CJK UNIFIED IDEOGRAPH-882F
        0x5F4F, # G+13334  U+5F4F  uni5F4F,  CJK UNIFIED IDEOGRAPH-5F4F
        0x6201, # G+13335  U+6201  uni6201,  CJK UNIFIED IDEOGRAPH-6201
        0x6203, # G+13336  U+6203  uni6203,  CJK UNIFIED IDEOGRAPH-6203
        0x6204, # G+13337  U+6204  uni6204,  CJK UNIFIED IDEOGRAPH-6204
        0x6529, # G+13338  U+6529  uni6529,  CJK UNIFIED IDEOGRAPH-6529
        0x6525, # G+13339  U+6525  uni6525,  CJK UNIFIED IDEOGRAPH-6525
        0x6596, # G+13340  U+6596  uni6596,  CJK UNIFIED IDEOGRAPH-6596
        0x66EB, # G+13341  U+66EB  uni66EB,  CJK UNIFIED IDEOGRAPH-66EB
        0x6B11, # G+13342  U+6B11  uni6B11,  CJK UNIFIED IDEOGRAPH-6B11
        0x6B12, # G+13343  U+6B12  uni6B12,  CJK UNIFIED IDEOGRAPH-6B12
        0x6B0F, # G+13344  U+6B0F  uni6B0F,  CJK UNIFIED IDEOGRAPH-6B0F
        0x6BCA, # G+13345  U+6BCA  uni6BCA,  CJK UNIFIED IDEOGRAPH-6BCA
        0x705B, # G+13346  U+705B  uni705B,  CJK UNIFIED IDEOGRAPH-705B
        0x705A, # G+13347  U+705A  uni705A,  CJK UNIFIED IDEOGRAPH-705A
        0x7222, # G+13348  U+7222  uni7222,  CJK UNIFIED IDEOGRAPH-7222
        0x7382, # G+13349  U+7382  uni7382,  CJK UNIFIED IDEOGRAPH-7382
        0x7381, # G+13350  U+7381  uni7381,  CJK UNIFIED IDEOGRAPH-7381
        0x7383, # G+13351  U+7383  uni7383,  CJK UNIFIED IDEOGRAPH-7383
        0x7670, # G+13352  U+7670  uni7670,  CJK UNIFIED IDEOGRAPH-7670
        0x77D4, # G+13353  U+77D4  uni77D4,  CJK UNIFIED IDEOGRAPH-77D4
        0x7C67, # G+13354  U+7C67  uni7C67,  CJK UNIFIED IDEOGRAPH-7C67
        0x7C66, # G+13355  U+7C66  uni7C66,  CJK UNIFIED IDEOGRAPH-7C66
        0x7E95, # G+13356  U+7E95  uni7E95,  CJK UNIFIED IDEOGRAPH-7E95
        0x826C, # G+13357  U+826C  uni826C,  CJK UNIFIED IDEOGRAPH-826C
        0x863A, # G+13358  U+863A  uni863A,  CJK UNIFIED IDEOGRAPH-863A
        0x8640, # G+13359  U+8640  uni8640,  CJK UNIFIED IDEOGRAPH-8640
        0x8639, # G+13360  U+8639  uni8639,  CJK UNIFIED IDEOGRAPH-8639
        0x863C, # G+13361  U+863C  uni863C,  CJK UNIFIED IDEOGRAPH-863C
        0x8631, # G+13362  U+8631  uni8631,  CJK UNIFIED IDEOGRAPH-8631
        0x863B, # G+13363  U+863B  uni863B,  CJK UNIFIED IDEOGRAPH-863B
        0x863E, # G+13364  U+863E  uni863E,  CJK UNIFIED IDEOGRAPH-863E
        0x8830, # G+13365  U+8830  uni8830,  CJK UNIFIED IDEOGRAPH-8830
        0x8832, # G+13366  U+8832  uni8832,  CJK UNIFIED IDEOGRAPH-8832
        0x882E, # G+13367  U+882E  uni882E,  CJK UNIFIED IDEOGRAPH-882E
        0x8833, # G+13368  U+8833  uni8833,  CJK UNIFIED IDEOGRAPH-8833
        0x8976, # G+13369  U+8976  uni8976,  CJK UNIFIED IDEOGRAPH-8976
        0x8974, # G+13370  U+8974  uni8974,  CJK UNIFIED IDEOGRAPH-8974
        0x8973, # G+13371  U+8973  uni8973,  CJK UNIFIED IDEOGRAPH-8973
        0x89FE, # G+13372  U+89FE  uni89FE,  CJK UNIFIED IDEOGRAPH-89FE
        0x8B8C, # G+13373  U+8B8C  uni8B8C,  CJK UNIFIED IDEOGRAPH-8B8C
        0x8B8E, # G+13374  U+8B8E  uni8B8E,  CJK UNIFIED IDEOGRAPH-8B8E
        0x8B8B, # G+13375  U+8B8B  uni8B8B,  CJK UNIFIED IDEOGRAPH-8B8B
        0x8B88, # G+13376  U+8B88  uni8B88,  CJK UNIFIED IDEOGRAPH-8B88
        0x8C45, # G+13377  U+8C45  uni8C45,  CJK UNIFIED IDEOGRAPH-8C45
        0x8D19, # G+13378  U+8D19  uni8D19,  CJK UNIFIED IDEOGRAPH-8D19
        0x8E98, # G+13379  U+8E98  uni8E98,  CJK UNIFIED IDEOGRAPH-8E98
        0x8F64, # G+13380  U+8F64  uni8F64,  CJK UNIFIED IDEOGRAPH-8F64
        0x8F63, # G+13381  U+8F63  uni8F63,  CJK UNIFIED IDEOGRAPH-8F63
        0x91BC, # G+13382  U+91BC  uni91BC,  CJK UNIFIED IDEOGRAPH-91BC
        0x9462, # G+13383  U+9462  uni9462,  CJK UNIFIED IDEOGRAPH-9462
        0x9455, # G+13384  U+9455  uni9455,  CJK UNIFIED IDEOGRAPH-9455
        0x945D, # G+13385  U+945D  uni945D,  CJK UNIFIED IDEOGRAPH-945D
        0x9457, # G+13386  U+9457  uni9457,  CJK UNIFIED IDEOGRAPH-9457
        0x945E, # G+13387  U+945E  uni945E,  CJK UNIFIED IDEOGRAPH-945E
        0x97C4, # G+13388  U+97C4  uni97C4,  CJK UNIFIED IDEOGRAPH-97C4
        0x97C5, # G+13389  U+97C5  uni97C5,  CJK UNIFIED IDEOGRAPH-97C5
        0x9800, # G+13390  U+9800  uni9800,  CJK UNIFIED IDEOGRAPH-9800
        0x9A56, # G+13391  U+9A56  uni9A56,  CJK UNIFIED IDEOGRAPH-9A56
        0x9A59, # G+13392  U+9A59  uni9A59,  CJK UNIFIED IDEOGRAPH-9A59
        0x9B1E, # G+13393  U+9B1E  uni9B1E,  CJK UNIFIED IDEOGRAPH-9B1E
        0x9B1F, # G+13394  U+9B1F  uni9B1F,  CJK UNIFIED IDEOGRAPH-9B1F
        0x9B20, # G+13395  U+9B20  uni9B20,  CJK UNIFIED IDEOGRAPH-9B20
        0x9C52, # G+13396  U+9C52  uni9C52,  CJK UNIFIED IDEOGRAPH-9C52
        0x9C58, # G+13397  U+9C58  uni9C58,  CJK UNIFIED IDEOGRAPH-9C58
        0x9C50, # G+13398  U+9C50  uni9C50,  CJK UNIFIED IDEOGRAPH-9C50
        0x9C4A, # G+13399  U+9C4A  uni9C4A,  CJK UNIFIED IDEOGRAPH-9C4A
        0x9C4D, # G+13400  U+9C4D  uni9C4D,  CJK UNIFIED IDEOGRAPH-9C4D
        0x9C4B, # G+13401  U+9C4B  uni9C4B,  CJK UNIFIED IDEOGRAPH-9C4B
        0x9C55, # G+13402  U+9C55  uni9C55,  CJK UNIFIED IDEOGRAPH-9C55
        0x9C59, # G+13403  U+9C59  uni9C59,  CJK UNIFIED IDEOGRAPH-9C59
        0x9C4C, # G+13404  U+9C4C  uni9C4C,  CJK UNIFIED IDEOGRAPH-9C4C
        0x9C4E, # G+13405  U+9C4E  uni9C4E,  CJK UNIFIED IDEOGRAPH-9C4E
        0x9DFB, # G+13406  U+9DFB  uni9DFB,  CJK UNIFIED IDEOGRAPH-9DFB
        0x9DF7, # G+13407  U+9DF7  uni9DF7,  CJK UNIFIED IDEOGRAPH-9DF7
        0x9DEF, # G+13408  U+9DEF  uni9DEF,  CJK UNIFIED IDEOGRAPH-9DEF
        0x9DE3, # G+13409  U+9DE3  uni9DE3,  CJK UNIFIED IDEOGRAPH-9DE3
        0x9DEB, # G+13410  U+9DEB  uni9DEB,  CJK UNIFIED IDEOGRAPH-9DEB
        0x9DF8, # G+13411  U+9DF8  uni9DF8,  CJK UNIFIED IDEOGRAPH-9DF8
        0x9DE4, # G+13412  U+9DE4  uni9DE4,  CJK UNIFIED IDEOGRAPH-9DE4
        0x9DF6, # G+13413  U+9DF6  uni9DF6,  CJK UNIFIED IDEOGRAPH-9DF6
        0x9DE1, # G+13414  U+9DE1  uni9DE1,  CJK UNIFIED IDEOGRAPH-9DE1
        0x9DEE, # G+13415  U+9DEE  uni9DEE,  CJK UNIFIED IDEOGRAPH-9DEE
        0x9DE6, # G+13416  U+9DE6  uni9DE6,  CJK UNIFIED IDEOGRAPH-9DE6
        0x9DF2, # G+13417  U+9DF2  uni9DF2,  CJK UNIFIED IDEOGRAPH-9DF2
        0x9DF0, # G+13418  U+9DF0  uni9DF0,  CJK UNIFIED IDEOGRAPH-9DF0
        0x9DE2, # G+13419  U+9DE2  uni9DE2,  CJK UNIFIED IDEOGRAPH-9DE2
        0x9DEC, # G+13420  U+9DEC  uni9DEC,  CJK UNIFIED IDEOGRAPH-9DEC
        0x9DF4, # G+13421  U+9DF4  uni9DF4,  CJK UNIFIED IDEOGRAPH-9DF4
        0x9DF3, # G+13422  U+9DF3  uni9DF3,  CJK UNIFIED IDEOGRAPH-9DF3
        0x9DE8, # G+13423  U+9DE8  uni9DE8,  CJK UNIFIED IDEOGRAPH-9DE8
        0x9DED, # G+13424  U+9DED  uni9DED,  CJK UNIFIED IDEOGRAPH-9DED
        0x9EC2, # G+13425  U+9EC2  uni9EC2,  CJK UNIFIED IDEOGRAPH-9EC2
        0x9ED0, # G+13426  U+9ED0  uni9ED0,  CJK UNIFIED IDEOGRAPH-9ED0
        0x9EF2, # G+13427  U+9EF2  uni9EF2,  CJK UNIFIED IDEOGRAPH-9EF2
        0x9EF3, # G+13428  U+9EF3  uni9EF3,  CJK UNIFIED IDEOGRAPH-9EF3
        0x9F06, # G+13429  U+9F06  uni9F06,  CJK UNIFIED IDEOGRAPH-9F06
        0x9F1C, # G+13430  U+9F1C  uni9F1C,  CJK UNIFIED IDEOGRAPH-9F1C
        0x9F38, # G+13431  U+9F38  uni9F38,  CJK UNIFIED IDEOGRAPH-9F38
        0x9F37, # G+13432  U+9F37  uni9F37,  CJK UNIFIED IDEOGRAPH-9F37
        0x9F36, # G+13433  U+9F36  uni9F36,  CJK UNIFIED IDEOGRAPH-9F36
        0x9F43, # G+13434  U+9F43  uni9F43,  CJK UNIFIED IDEOGRAPH-9F43
        0x9F4F, # G+13435  U+9F4F  uni9F4F,  CJK UNIFIED IDEOGRAPH-9F4F
        0x9F71, # G+13436  U+9F71  uni9F71,  CJK UNIFIED IDEOGRAPH-9F71
        0x9F70, # G+13437  U+9F70  uni9F70,  CJK UNIFIED IDEOGRAPH-9F70
        0x9F6E, # G+13438  U+9F6E  uni9F6E,  CJK UNIFIED IDEOGRAPH-9F6E
        0x9F6F, # G+13439  U+9F6F  uni9F6F,  CJK UNIFIED IDEOGRAPH-9F6F
        0x56D3, # G+13440  U+56D3  uni56D3,  CJK UNIFIED IDEOGRAPH-56D3
        0x56CD, # G+13441  U+56CD  uni56CD,  CJK UNIFIED IDEOGRAPH-56CD
        0x5B4E, # G+13442  U+5B4E  uni5B4E,  CJK UNIFIED IDEOGRAPH-5B4E
        0x5C6D, # G+13443  U+5C6D  uni5C6D,  CJK UNIFIED IDEOGRAPH-5C6D
        0x652D, # G+13444  U+652D  uni652D,  CJK UNIFIED IDEOGRAPH-652D
        0x66ED, # G+13445  U+66ED  uni66ED,  CJK UNIFIED IDEOGRAPH-66ED
        0x66EE, # G+13446  U+66EE  uni66EE,  CJK UNIFIED IDEOGRAPH-66EE
        0x6B13, # G+13447  U+6B13  uni6B13,  CJK UNIFIED IDEOGRAPH-6B13
        0x705F, # G+13448  U+705F  uni705F,  CJK UNIFIED IDEOGRAPH-705F
        0x7061, # G+13449  U+7061  uni7061,  CJK UNIFIED IDEOGRAPH-7061
        0x705D, # G+13450  U+705D  uni705D,  CJK UNIFIED IDEOGRAPH-705D
        0x7060, # G+13451  U+7060  uni7060,  CJK UNIFIED IDEOGRAPH-7060
        0x7223, # G+13452  U+7223  uni7223,  CJK UNIFIED IDEOGRAPH-7223
        0x74DB, # G+13453  U+74DB  uni74DB,  CJK UNIFIED IDEOGRAPH-74DB
        0x74E5, # G+13454  U+74E5  uni74E5,  CJK UNIFIED IDEOGRAPH-74E5
        0x77D5, # G+13455  U+77D5  uni77D5,  CJK UNIFIED IDEOGRAPH-77D5
        0x7938, # G+13456  U+7938  uni7938,  CJK UNIFIED IDEOGRAPH-7938
        0x79B7, # G+13457  U+79B7  uni79B7,  CJK UNIFIED IDEOGRAPH-79B7
        0x79B6, # G+13458  U+79B6  uni79B6,  CJK UNIFIED IDEOGRAPH-79B6
        0x7C6A, # G+13459  U+7C6A  uni7C6A,  CJK UNIFIED IDEOGRAPH-7C6A
        0x7E97, # G+13460  U+7E97  uni7E97,  CJK UNIFIED IDEOGRAPH-7E97
        0x7F89, # G+13461  U+7F89  uni7F89,  CJK UNIFIED IDEOGRAPH-7F89
        0x826D, # G+13462  U+826D  uni826D,  CJK UNIFIED IDEOGRAPH-826D
        0x8643, # G+13463  U+8643  uni8643,  CJK UNIFIED IDEOGRAPH-8643
        0x8838, # G+13464  U+8838  uni8838,  CJK UNIFIED IDEOGRAPH-8838
        0x8837, # G+13465  U+8837  uni8837,  CJK UNIFIED IDEOGRAPH-8837
        0x8835, # G+13466  U+8835  uni8835,  CJK UNIFIED IDEOGRAPH-8835
        0x884B, # G+13467  U+884B  uni884B,  CJK UNIFIED IDEOGRAPH-884B
        0x8B94, # G+13468  U+8B94  uni8B94,  CJK UNIFIED IDEOGRAPH-8B94
        0x8B95, # G+13469  U+8B95  uni8B95,  CJK UNIFIED IDEOGRAPH-8B95
        0x8E9E, # G+13470  U+8E9E  uni8E9E,  CJK UNIFIED IDEOGRAPH-8E9E
        0x8E9F, # G+13471  U+8E9F  uni8E9F,  CJK UNIFIED IDEOGRAPH-8E9F
        0x8EA0, # G+13472  U+8EA0  uni8EA0,  CJK UNIFIED IDEOGRAPH-8EA0
        0x8E9D, # G+13473  U+8E9D  uni8E9D,  CJK UNIFIED IDEOGRAPH-8E9D
        0x91BE, # G+13474  U+91BE  uni91BE,  CJK UNIFIED IDEOGRAPH-91BE
        0x91BD, # G+13475  U+91BD  uni91BD,  CJK UNIFIED IDEOGRAPH-91BD
        0x91C2, # G+13476  U+91C2  uni91C2,  CJK UNIFIED IDEOGRAPH-91C2
        0x946B, # G+13477  U+946B  uni946B,  CJK UNIFIED IDEOGRAPH-946B
        0x9468, # G+13478  U+9468  uni9468,  CJK UNIFIED IDEOGRAPH-9468
        0x9469, # G+13479  U+9469  uni9469,  CJK UNIFIED IDEOGRAPH-9469
        0x96E5, # G+13480  U+96E5  uni96E5,  CJK UNIFIED IDEOGRAPH-96E5
        0x9746, # G+13481  U+9746  uni9746,  CJK UNIFIED IDEOGRAPH-9746
        0x9743, # G+13482  U+9743  uni9743,  CJK UNIFIED IDEOGRAPH-9743
        0x9747, # G+13483  U+9747  uni9747,  CJK UNIFIED IDEOGRAPH-9747
        0x97C7, # G+13484  U+97C7  uni97C7,  CJK UNIFIED IDEOGRAPH-97C7
        0x97E5, # G+13485  U+97E5  uni97E5,  CJK UNIFIED IDEOGRAPH-97E5
        0x9A5E, # G+13486  U+9A5E  uni9A5E,  CJK UNIFIED IDEOGRAPH-9A5E
        0x9AD5, # G+13487  U+9AD5  uni9AD5,  CJK UNIFIED IDEOGRAPH-9AD5
        0x9B59, # G+13488  U+9B59  uni9B59,  CJK UNIFIED IDEOGRAPH-9B59
        0x9C63, # G+13489  U+9C63  uni9C63,  CJK UNIFIED IDEOGRAPH-9C63
        0x9C67, # G+13490  U+9C67  uni9C67,  CJK UNIFIED IDEOGRAPH-9C67
        0x9C66, # G+13491  U+9C66  uni9C66,  CJK UNIFIED IDEOGRAPH-9C66
        0x9C62, # G+13492  U+9C62  uni9C62,  CJK UNIFIED IDEOGRAPH-9C62
        0x9C5E, # G+13493  U+9C5E  uni9C5E,  CJK UNIFIED IDEOGRAPH-9C5E
        0x9C60, # G+13494  U+9C60  uni9C60,  CJK UNIFIED IDEOGRAPH-9C60
        0x9E02, # G+13495  U+9E02  uni9E02,  CJK UNIFIED IDEOGRAPH-9E02
        0x9DFE, # G+13496  U+9DFE  uni9DFE,  CJK UNIFIED IDEOGRAPH-9DFE
        0x9E07, # G+13497  U+9E07  uni9E07,  CJK UNIFIED IDEOGRAPH-9E07
        0x9E03, # G+13498  U+9E03  uni9E03,  CJK UNIFIED IDEOGRAPH-9E03
        0x9E06, # G+13499  U+9E06  uni9E06,  CJK UNIFIED IDEOGRAPH-9E06
        0x9E05, # G+13500  U+9E05  uni9E05,  CJK UNIFIED IDEOGRAPH-9E05
        0x9E00, # G+13501  U+9E00  uni9E00,  CJK UNIFIED IDEOGRAPH-9E00
        0x9E01, # G+13502  U+9E01  uni9E01,  CJK UNIFIED IDEOGRAPH-9E01
        0x9E09, # G+13503  U+9E09  uni9E09,  CJK UNIFIED IDEOGRAPH-9E09
        0x9DFF, # G+13504  U+9DFF  uni9DFF,  CJK UNIFIED IDEOGRAPH-9DFF
        0x9DFD, # G+13505  U+9DFD  uni9DFD,  CJK UNIFIED IDEOGRAPH-9DFD
        0x9E04, # G+13506  U+9E04  uni9E04,  CJK UNIFIED IDEOGRAPH-9E04
        0x9EA0, # G+13507  U+9EA0  uni9EA0,  CJK UNIFIED IDEOGRAPH-9EA0
        0x9F1E, # G+13508  U+9F1E  uni9F1E,  CJK UNIFIED IDEOGRAPH-9F1E
        0x9F46, # G+13509  U+9F46  uni9F46,  CJK UNIFIED IDEOGRAPH-9F46
        0x9F74, # G+13510  U+9F74  uni9F74,  CJK UNIFIED IDEOGRAPH-9F74
        0x9F75, # G+13511  U+9F75  uni9F75,  CJK UNIFIED IDEOGRAPH-9F75
        0x9F76, # G+13512  U+9F76  uni9F76,  CJK UNIFIED IDEOGRAPH-9F76
        0x56D4, # G+13513  U+56D4  uni56D4,  CJK UNIFIED IDEOGRAPH-56D4
        0x652E, # G+13514  U+652E  uni652E,  CJK UNIFIED IDEOGRAPH-652E
        0x65B8, # G+13515  U+65B8  uni65B8,  CJK UNIFIED IDEOGRAPH-65B8
        0x6B18, # G+13516  U+6B18  uni6B18,  CJK UNIFIED IDEOGRAPH-6B18
        0x6B19, # G+13517  U+6B19  uni6B19,  CJK UNIFIED IDEOGRAPH-6B19
        0x6B17, # G+13518  U+6B17  uni6B17,  CJK UNIFIED IDEOGRAPH-6B17
        0x6B1A, # G+13519  U+6B1A  uni6B1A,  CJK UNIFIED IDEOGRAPH-6B1A
        0x7062, # G+13520  U+7062  uni7062,  CJK UNIFIED IDEOGRAPH-7062
        0x7226, # G+13521  U+7226  uni7226,  CJK UNIFIED IDEOGRAPH-7226
        0x72AA, # G+13522  U+72AA  uni72AA,  CJK UNIFIED IDEOGRAPH-72AA
        0x77D8, # G+13523  U+77D8  uni77D8,  CJK UNIFIED IDEOGRAPH-77D8
        0x77D9, # G+13524  U+77D9  uni77D9,  CJK UNIFIED IDEOGRAPH-77D9
        0x7939, # G+13525  U+7939  uni7939,  CJK UNIFIED IDEOGRAPH-7939
        0x7C69, # G+13526  U+7C69  uni7C69,  CJK UNIFIED IDEOGRAPH-7C69
        0x7C6B, # G+13527  U+7C6B  uni7C6B,  CJK UNIFIED IDEOGRAPH-7C6B
        0x7CF6, # G+13528  U+7CF6  uni7CF6,  CJK UNIFIED IDEOGRAPH-7CF6
        0x7E9A, # G+13529  U+7E9A  uni7E9A,  CJK UNIFIED IDEOGRAPH-7E9A
        0x7E98, # G+13530  U+7E98  uni7E98,  CJK UNIFIED IDEOGRAPH-7E98
        0x7E9B, # G+13531  U+7E9B  uni7E9B,  CJK UNIFIED IDEOGRAPH-7E9B
        0x7E99, # G+13532  U+7E99  uni7E99,  CJK UNIFIED IDEOGRAPH-7E99
        0x81E0, # G+13533  U+81E0  uni81E0,  CJK UNIFIED IDEOGRAPH-81E0
        0x81E1, # G+13534  U+81E1  uni81E1,  CJK UNIFIED IDEOGRAPH-81E1
        0x8646, # G+13535  U+8646  uni8646,  CJK UNIFIED IDEOGRAPH-8646
        0x8647, # G+13536  U+8647  uni8647,  CJK UNIFIED IDEOGRAPH-8647
        0x8648, # G+13537  U+8648  uni8648,  CJK UNIFIED IDEOGRAPH-8648
        0x8979, # G+13538  U+8979  uni8979,  CJK UNIFIED IDEOGRAPH-8979
        0x897A, # G+13539  U+897A  uni897A,  CJK UNIFIED IDEOGRAPH-897A
        0x897C, # G+13540  U+897C  uni897C,  CJK UNIFIED IDEOGRAPH-897C
        0x897B, # G+13541  U+897B  uni897B,  CJK UNIFIED IDEOGRAPH-897B
        0x89FF, # G+13542  U+89FF  uni89FF,  CJK UNIFIED IDEOGRAPH-89FF
        0x8B98, # G+13543  U+8B98  uni8B98,  CJK UNIFIED IDEOGRAPH-8B98
        0x8B99, # G+13544  U+8B99  uni8B99,  CJK UNIFIED IDEOGRAPH-8B99
        0x8EA5, # G+13545  U+8EA5  uni8EA5,  CJK UNIFIED IDEOGRAPH-8EA5
        0x8EA4, # G+13546  U+8EA4  uni8EA4,  CJK UNIFIED IDEOGRAPH-8EA4
        0x8EA3, # G+13547  U+8EA3  uni8EA3,  CJK UNIFIED IDEOGRAPH-8EA3
        0x946E, # G+13548  U+946E  uni946E,  CJK UNIFIED IDEOGRAPH-946E
        0x946D, # G+13549  U+946D  uni946D,  CJK UNIFIED IDEOGRAPH-946D
        0x946F, # G+13550  U+946F  uni946F,  CJK UNIFIED IDEOGRAPH-946F
        0x9471, # G+13551  U+9471  uni9471,  CJK UNIFIED IDEOGRAPH-9471
        0x9473, # G+13552  U+9473  uni9473,  CJK UNIFIED IDEOGRAPH-9473
        0x9749, # G+13553  U+9749  uni9749,  CJK UNIFIED IDEOGRAPH-9749
        0x9872, # G+13554  U+9872  uni9872,  CJK UNIFIED IDEOGRAPH-9872
        0x995F, # G+13555  U+995F  uni995F,  CJK UNIFIED IDEOGRAPH-995F
        0x9C68, # G+13556  U+9C68  uni9C68,  CJK UNIFIED IDEOGRAPH-9C68
        0x9C6E, # G+13557  U+9C6E  uni9C6E,  CJK UNIFIED IDEOGRAPH-9C6E
        0x9C6D, # G+13558  U+9C6D  uni9C6D,  CJK UNIFIED IDEOGRAPH-9C6D
        0x9E0B, # G+13559  U+9E0B  uni9E0B,  CJK UNIFIED IDEOGRAPH-9E0B
        0x9E0D, # G+13560  U+9E0D  uni9E0D,  CJK UNIFIED IDEOGRAPH-9E0D
        0x9E10, # G+13561  U+9E10  uni9E10,  CJK UNIFIED IDEOGRAPH-9E10
        0x9E0F, # G+13562  U+9E0F  uni9E0F,  CJK UNIFIED IDEOGRAPH-9E0F
        0x9E12, # G+13563  U+9E12  uni9E12,  CJK UNIFIED IDEOGRAPH-9E12
        0x9E11, # G+13564  U+9E11  uni9E11,  CJK UNIFIED IDEOGRAPH-9E11
        0x9EA1, # G+13565  U+9EA1  uni9EA1,  CJK UNIFIED IDEOGRAPH-9EA1
        0x9EF5, # G+13566  U+9EF5  uni9EF5,  CJK UNIFIED IDEOGRAPH-9EF5
        0x9F09, # G+13567  U+9F09  uni9F09,  CJK UNIFIED IDEOGRAPH-9F09
        0x9F47, # G+13568  U+9F47  uni9F47,  CJK UNIFIED IDEOGRAPH-9F47
        0x9F78, # G+13569  U+9F78  uni9F78,  CJK UNIFIED IDEOGRAPH-9F78
        0x9F7B, # G+13570  U+9F7B  uni9F7B,  CJK UNIFIED IDEOGRAPH-9F7B
        0x9F7A, # G+13571  U+9F7A  uni9F7A,  CJK UNIFIED IDEOGRAPH-9F7A
        0x9F79, # G+13572  U+9F79  uni9F79,  CJK UNIFIED IDEOGRAPH-9F79
        0x571E, # G+13573  U+571E  uni571E,  CJK UNIFIED IDEOGRAPH-571E
        0x7066, # G+13574  U+7066  uni7066,  CJK UNIFIED IDEOGRAPH-7066
        0x7C6F, # G+13575  U+7C6F  uni7C6F,  CJK UNIFIED IDEOGRAPH-7C6F
        0x883C, # G+13576  U+883C  uni883C,  CJK UNIFIED IDEOGRAPH-883C
        0x8DB2, # G+13577  U+8DB2  uni8DB2,  CJK UNIFIED IDEOGRAPH-8DB2
        0x8EA6, # G+13578  U+8EA6  uni8EA6,  CJK UNIFIED IDEOGRAPH-8EA6
        0x91C3, # G+13579  U+91C3  uni91C3,  CJK UNIFIED IDEOGRAPH-91C3
        0x9474, # G+13580  U+9474  uni9474,  CJK UNIFIED IDEOGRAPH-9474
        0x9478, # G+13581  U+9478  uni9478,  CJK UNIFIED IDEOGRAPH-9478
        0x9476, # G+13582  U+9476  uni9476,  CJK UNIFIED IDEOGRAPH-9476
        0x9475, # G+13583  U+9475  uni9475,  CJK UNIFIED IDEOGRAPH-9475
        0x9A60, # G+13584  U+9A60  uni9A60,  CJK UNIFIED IDEOGRAPH-9A60
        0x9B2E, # G+13585  U+9B2E  uni9B2E,  CJK UNIFIED IDEOGRAPH-9B2E
        0x9C74, # G+13586  U+9C74  uni9C74,  CJK UNIFIED IDEOGRAPH-9C74
        0x9C73, # G+13587  U+9C73  uni9C73,  CJK UNIFIED IDEOGRAPH-9C73
        0x9C71, # G+13588  U+9C71  uni9C71,  CJK UNIFIED IDEOGRAPH-9C71
        0x9C75, # G+13589  U+9C75  uni9C75,  CJK UNIFIED IDEOGRAPH-9C75
        0x9E14, # G+13590  U+9E14  uni9E14,  CJK UNIFIED IDEOGRAPH-9E14
        0x9E13, # G+13591  U+9E13  uni9E13,  CJK UNIFIED IDEOGRAPH-9E13
        0x9EF6, # G+13592  U+9EF6  uni9EF6,  CJK UNIFIED IDEOGRAPH-9EF6
        0x9F0A, # G+13593  U+9F0A  uni9F0A,  CJK UNIFIED IDEOGRAPH-9F0A
        0x9FA4, # G+13594  U+9FA4  uni9FA4,  CJK UNIFIED IDEOGRAPH-9FA4
        0x7068, # G+13595  U+7068  uni7068,  CJK UNIFIED IDEOGRAPH-7068
        0x7065, # G+13596  U+7065  uni7065,  CJK UNIFIED IDEOGRAPH-7065
        0x7CF7, # G+13597  U+7CF7  uni7CF7,  CJK UNIFIED IDEOGRAPH-7CF7
        0x866A, # G+13598  U+866A  uni866A,  CJK UNIFIED IDEOGRAPH-866A
        0x883E, # G+13599  U+883E  uni883E,  CJK UNIFIED IDEOGRAPH-883E
        0x883D, # G+13600  U+883D  uni883D,  CJK UNIFIED IDEOGRAPH-883D
        0x883F, # G+13601  U+883F  uni883F,  CJK UNIFIED IDEOGRAPH-883F
        0x8B9E, # G+13602  U+8B9E  uni8B9E,  CJK UNIFIED IDEOGRAPH-8B9E
        0x8C9C, # G+13603  U+8C9C  uni8C9C,  CJK UNIFIED IDEOGRAPH-8C9C
        0x8EA9, # G+13604  U+8EA9  uni8EA9,  CJK UNIFIED IDEOGRAPH-8EA9
        0x8EC9, # G+13605  U+8EC9  uni8EC9,  CJK UNIFIED IDEOGRAPH-8EC9
        0x974B, # G+13606  U+974B  uni974B,  CJK UNIFIED IDEOGRAPH-974B
        0x9873, # G+13607  U+9873  uni9873,  CJK UNIFIED IDEOGRAPH-9873
        0x9874, # G+13608  U+9874  uni9874,  CJK UNIFIED IDEOGRAPH-9874
        0x98CC, # G+13609  U+98CC  uni98CC,  CJK UNIFIED IDEOGRAPH-98CC
        0x9961, # G+13610  U+9961  uni9961,  CJK UNIFIED IDEOGRAPH-9961
        0x99AB, # G+13611  U+99AB  uni99AB,  CJK UNIFIED IDEOGRAPH-99AB
        0x9A64, # G+13612  U+9A64  uni9A64,  CJK UNIFIED IDEOGRAPH-9A64
        0x9A66, # G+13613  U+9A66  uni9A66,  CJK UNIFIED IDEOGRAPH-9A66
        0x9A67, # G+13614  U+9A67  uni9A67,  CJK UNIFIED IDEOGRAPH-9A67
        0x9B24, # G+13615  U+9B24  uni9B24,  CJK UNIFIED IDEOGRAPH-9B24
        0x9E15, # G+13616  U+9E15  uni9E15,  CJK UNIFIED IDEOGRAPH-9E15
        0x9E17, # G+13617  U+9E17  uni9E17,  CJK UNIFIED IDEOGRAPH-9E17
        0x9F48, # G+13618  U+9F48  uni9F48,  CJK UNIFIED IDEOGRAPH-9F48
        0x6207, # G+13619  U+6207  uni6207,  CJK UNIFIED IDEOGRAPH-6207
        0x6B1E, # G+13620  U+6B1E  uni6B1E,  CJK UNIFIED IDEOGRAPH-6B1E
        0x7227, # G+13621  U+7227  uni7227,  CJK UNIFIED IDEOGRAPH-7227
        0x864C, # G+13622  U+864C  uni864C,  CJK UNIFIED IDEOGRAPH-864C
        0x8EA8, # G+13623  U+8EA8  uni8EA8,  CJK UNIFIED IDEOGRAPH-8EA8
        0x9482, # G+13624  U+9482  uni9482,  CJK UNIFIED IDEOGRAPH-9482
        0x9480, # G+13625  U+9480  uni9480,  CJK UNIFIED IDEOGRAPH-9480
        0x9481, # G+13626  U+9481  uni9481,  CJK UNIFIED IDEOGRAPH-9481
        0x9A69, # G+13627  U+9A69  uni9A69,  CJK UNIFIED IDEOGRAPH-9A69
        0x9A68, # G+13628  U+9A68  uni9A68,  CJK UNIFIED IDEOGRAPH-9A68
        0x9E19, # G+13629  U+9E19  uni9E19,  CJK UNIFIED IDEOGRAPH-9E19
        0x864B, # G+13630  U+864B  uni864B,  CJK UNIFIED IDEOGRAPH-864B
        0x8B9F, # G+13631  U+8B9F  uni8B9F,  CJK UNIFIED IDEOGRAPH-8B9F
        0x9483, # G+13632  U+9483  uni9483,  CJK UNIFIED IDEOGRAPH-9483
        0x9C79, # G+13633  U+9C79  uni9C79,  CJK UNIFIED IDEOGRAPH-9C79
        0x9EB7, # G+13634  U+9EB7  uni9EB7,  CJK UNIFIED IDEOGRAPH-9EB7
        0x7675, # G+13635  U+7675  uni7675,  CJK UNIFIED IDEOGRAPH-7675
        0x9A6B, # G+13636  U+9A6B  uni9A6B,  CJK UNIFIED IDEOGRAPH-9A6B
        0x9C7A, # G+13637  U+9C7A  uni9C7A,  CJK UNIFIED IDEOGRAPH-9C7A
        0x9E1D, # G+13638  U+9E1D  uni9E1D,  CJK UNIFIED IDEOGRAPH-9E1D
        0x7069, # G+13639  U+7069  uni7069,  CJK UNIFIED IDEOGRAPH-7069
        0x706A, # G+13640  U+706A  uni706A,  CJK UNIFIED IDEOGRAPH-706A
        0x7229, # G+13641  U+7229  uni7229,  CJK UNIFIED IDEOGRAPH-7229
        0x9EA4, # G+13642  U+9EA4  uni9EA4,  CJK UNIFIED IDEOGRAPH-9EA4
        0x9F7E, # G+13643  U+9F7E  uni9F7E,  CJK UNIFIED IDEOGRAPH-9F7E
        0x9F49, # G+13644  U+9F49  uni9F49,  CJK UNIFIED IDEOGRAPH-9F49
        0x9F98, # G+13645  U+9F98  uni9F98,  CJK UNIFIED IDEOGRAPH-9F98
        0x0000, # G+13646  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13647  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13648  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13649  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13650  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13651  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13652  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13653  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13654  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13655  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13656  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13657  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13658  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13659  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13660  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13661  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13662  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13663  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13664  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13665  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13666  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13667  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13668  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13669  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13670  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13671  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13672  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13673  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13674  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13675  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13676  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13677  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13678  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13679  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13680  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13681  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13682  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13683  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13684  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13685  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13686  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13687  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13688  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13689  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13690  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13691  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13692  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13693  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13694  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13695  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13696  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13697  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13698  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13699  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13700  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13701  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13702  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13703  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13704  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13705  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13706  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13707  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13708  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13709  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13710  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13711  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13712  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13713  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13714  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13715  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13716  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13717  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13718  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13719  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13720  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13721  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13722  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13723  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13724  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13725  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13726  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13727  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13728  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13729  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13730  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13731  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13732  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13733  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13734  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13735  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13736  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13737  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13738  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13739  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13740  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13741  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13742  U+0000  .notdef,  UNDEFINED
        0xFE33, # G+13743  U+FE33  uniFE33,  PRESENTATION FORM FOR VERTICAL LOW LINE
        0x0000, # G+13744  U+0000  .notdef,  UNDEFINED
        0xFE34, # G+13745  U+FE34  uniFE34,  PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
        0xFE4F, # G+13746  U+FE4F  uniFE4F,  WAVY LOW LINE
        0x00A8, # G+13747  U+00A8  dieresis,  DIAERESIS
        0x02C6, # G+13748  U+02C6  circumflex,  MODIFIER LETTER CIRCUMFLEX ACCENT
        0x30FD, # G+13749  U+30FD  uni30FD,  KATAKANA ITERATION MARK
        0x30FE, # G+13750  U+30FE  uni30FE,  KATAKANA VOICED ITERATION MARK
        0x309D, # G+13751  U+309D  uni309D,  HIRAGANA ITERATION MARK
        0x309E, # G+13752  U+309E  uni309E,  HIRAGANA VOICED ITERATION MARK
        0x0000, # G+13753  U+0000  .notdef,  UNDEFINED
        0x3005, # G+13754  U+3005  uni3005,  IDEOGRAPHIC ITERATION MARK
        0x3006, # G+13755  U+3006  uni3006,  IDEOGRAPHIC CLOSING MARK
        0x3007, # G+13756  U+3007  uni3007,  IDEOGRAPHIC NUMBER ZERO
        0x30FC, # G+13757  U+30FC  uni30FC,  KATAKANA-HIRAGANA PROLONGED SOUND MARK
        0xFF3B, # G+13758  U+FF3B  uniFF3B,  FULLWIDTH LEFT SQUARE BRACKET
        0xFF3D, # G+13759  U+FF3D  uniFF3D,  FULLWIDTH RIGHT SQUARE BRACKET
        0x273D, # G+13760  U+273D  a56,  HEAVY TEARDROP-SPOKED ASTERISK
        0x3041, # G+13761  U+3041  uni3041,  HIRAGANA LETTER SMALL A
        0x3042, # G+13762  U+3042  uni3042,  HIRAGANA LETTER A
        0x3043, # G+13763  U+3043  uni3043,  HIRAGANA LETTER SMALL I
        0x3044, # G+13764  U+3044  uni3044,  HIRAGANA LETTER I
        0x3045, # G+13765  U+3045  uni3045,  HIRAGANA LETTER SMALL U
        0x3046, # G+13766  U+3046  uni3046,  HIRAGANA LETTER U
        0x3047, # G+13767  U+3047  uni3047,  HIRAGANA LETTER SMALL E
        0x3048, # G+13768  U+3048  uni3048,  HIRAGANA LETTER E
        0x3049, # G+13769  U+3049  uni3049,  HIRAGANA LETTER SMALL O
        0x304A, # G+13770  U+304A  uni304A,  HIRAGANA LETTER O
        0x304B, # G+13771  U+304B  uni304B,  HIRAGANA LETTER KA
        0x304C, # G+13772  U+304C  uni304C,  HIRAGANA LETTER GA
        0x304D, # G+13773  U+304D  uni304D,  HIRAGANA LETTER KI
        0x304E, # G+13774  U+304E  uni304E,  HIRAGANA LETTER GI
        0x304F, # G+13775  U+304F  uni304F,  HIRAGANA LETTER KU
        0x3050, # G+13776  U+3050  uni3050,  HIRAGANA LETTER GU
        0x3051, # G+13777  U+3051  uni3051,  HIRAGANA LETTER KE
        0x3052, # G+13778  U+3052  uni3052,  HIRAGANA LETTER GE
        0x3053, # G+13779  U+3053  uni3053,  HIRAGANA LETTER KO
        0x3054, # G+13780  U+3054  uni3054,  HIRAGANA LETTER GO
        0x3055, # G+13781  U+3055  uni3055,  HIRAGANA LETTER SA
        0x3056, # G+13782  U+3056  uni3056,  HIRAGANA LETTER ZA
        0x3057, # G+13783  U+3057  uni3057,  HIRAGANA LETTER SI
        0x3058, # G+13784  U+3058  uni3058,  HIRAGANA LETTER ZI
        0x3059, # G+13785  U+3059  uni3059,  HIRAGANA LETTER SU
        0x305A, # G+13786  U+305A  uni305A,  HIRAGANA LETTER ZU
        0x305B, # G+13787  U+305B  uni305B,  HIRAGANA LETTER SE
        0x305C, # G+13788  U+305C  uni305C,  HIRAGANA LETTER ZE
        0x305D, # G+13789  U+305D  uni305D,  HIRAGANA LETTER SO
        0x305E, # G+13790  U+305E  uni305E,  HIRAGANA LETTER ZO
        0x305F, # G+13791  U+305F  uni305F,  HIRAGANA LETTER TA
        0x3060, # G+13792  U+3060  uni3060,  HIRAGANA LETTER DA
        0x3061, # G+13793  U+3061  uni3061,  HIRAGANA LETTER TI
        0x3062, # G+13794  U+3062  uni3062,  HIRAGANA LETTER DI
        0x3063, # G+13795  U+3063  uni3063,  HIRAGANA LETTER SMALL TU
        0x3064, # G+13796  U+3064  uni3064,  HIRAGANA LETTER TU
        0x3065, # G+13797  U+3065  uni3065,  HIRAGANA LETTER DU
        0x3066, # G+13798  U+3066  uni3066,  HIRAGANA LETTER TE
        0x3067, # G+13799  U+3067  uni3067,  HIRAGANA LETTER DE
        0x3068, # G+13800  U+3068  uni3068,  HIRAGANA LETTER TO
        0x3069, # G+13801  U+3069  uni3069,  HIRAGANA LETTER DO
        0x306A, # G+13802  U+306A  uni306A,  HIRAGANA LETTER NA
        0x306B, # G+13803  U+306B  uni306B,  HIRAGANA LETTER NI
        0x306C, # G+13804  U+306C  uni306C,  HIRAGANA LETTER NU
        0x306D, # G+13805  U+306D  uni306D,  HIRAGANA LETTER NE
        0x306E, # G+13806  U+306E  uni306E,  HIRAGANA LETTER NO
        0x306F, # G+13807  U+306F  uni306F,  HIRAGANA LETTER HA
        0x3070, # G+13808  U+3070  uni3070,  HIRAGANA LETTER BA
        0x3071, # G+13809  U+3071  uni3071,  HIRAGANA LETTER PA
        0x3072, # G+13810  U+3072  uni3072,  HIRAGANA LETTER HI
        0x3073, # G+13811  U+3073  uni3073,  HIRAGANA LETTER BI
        0x3074, # G+13812  U+3074  uni3074,  HIRAGANA LETTER PI
        0x3075, # G+13813  U+3075  uni3075,  HIRAGANA LETTER HU
        0x3076, # G+13814  U+3076  uni3076,  HIRAGANA LETTER BU
        0x3077, # G+13815  U+3077  uni3077,  HIRAGANA LETTER PU
        0x3078, # G+13816  U+3078  uni3078,  HIRAGANA LETTER HE
        0x3079, # G+13817  U+3079  uni3079,  HIRAGANA LETTER BE
        0x307A, # G+13818  U+307A  uni307A,  HIRAGANA LETTER PE
        0x307B, # G+13819  U+307B  uni307B,  HIRAGANA LETTER HO
        0x307C, # G+13820  U+307C  uni307C,  HIRAGANA LETTER BO
        0x307D, # G+13821  U+307D  uni307D,  HIRAGANA LETTER PO
        0x307E, # G+13822  U+307E  uni307E,  HIRAGANA LETTER MA
        0x307F, # G+13823  U+307F  uni307F,  HIRAGANA LETTER MI
        0x3080, # G+13824  U+3080  uni3080,  HIRAGANA LETTER MU
        0x3081, # G+13825  U+3081  uni3081,  HIRAGANA LETTER ME
        0x3082, # G+13826  U+3082  uni3082,  HIRAGANA LETTER MO
        0x3083, # G+13827  U+3083  uni3083,  HIRAGANA LETTER SMALL YA
        0x3084, # G+13828  U+3084  uni3084,  HIRAGANA LETTER YA
        0x3085, # G+13829  U+3085  uni3085,  HIRAGANA LETTER SMALL YU
        0x3086, # G+13830  U+3086  uni3086,  HIRAGANA LETTER YU
        0x3087, # G+13831  U+3087  uni3087,  HIRAGANA LETTER SMALL YO
        0x3088, # G+13832  U+3088  uni3088,  HIRAGANA LETTER YO
        0x3089, # G+13833  U+3089  uni3089,  HIRAGANA LETTER RA
        0x308A, # G+13834  U+308A  uni308A,  HIRAGANA LETTER RI
        0x308B, # G+13835  U+308B  uni308B,  HIRAGANA LETTER RU
        0x308C, # G+13836  U+308C  uni308C,  HIRAGANA LETTER RE
        0x308D, # G+13837  U+308D  uni308D,  HIRAGANA LETTER RO
        0x308E, # G+13838  U+308E  uni308E,  HIRAGANA LETTER SMALL WA
        0x308F, # G+13839  U+308F  uni308F,  HIRAGANA LETTER WA
        0x3090, # G+13840  U+3090  uni3090,  HIRAGANA LETTER WI
        0x3091, # G+13841  U+3091  uni3091,  HIRAGANA LETTER WE
        0x3092, # G+13842  U+3092  uni3092,  HIRAGANA LETTER WO
        0x3093, # G+13843  U+3093  uni3093,  HIRAGANA LETTER N
        0x30A1, # G+13844  U+30A1  uni30A1,  KATAKANA LETTER SMALL A
        0x30A2, # G+13845  U+30A2  uni30A2,  KATAKANA LETTER A
        0x30A3, # G+13846  U+30A3  uni30A3,  KATAKANA LETTER SMALL I
        0x30A4, # G+13847  U+30A4  uni30A4,  KATAKANA LETTER I
        0x30A5, # G+13848  U+30A5  uni30A5,  KATAKANA LETTER SMALL U
        0x30A6, # G+13849  U+30A6  uni30A6,  KATAKANA LETTER U
        0x30A7, # G+13850  U+30A7  uni30A7,  KATAKANA LETTER SMALL E
        0x30A8, # G+13851  U+30A8  uni30A8,  KATAKANA LETTER E
        0x30A9, # G+13852  U+30A9  uni30A9,  KATAKANA LETTER SMALL O
        0x30AA, # G+13853  U+30AA  uni30AA,  KATAKANA LETTER O
        0x30AB, # G+13854  U+30AB  uni30AB,  KATAKANA LETTER KA
        0x30AC, # G+13855  U+30AC  uni30AC,  KATAKANA LETTER GA
        0x30AD, # G+13856  U+30AD  uni30AD,  KATAKANA LETTER KI
        0x30AE, # G+13857  U+30AE  uni30AE,  KATAKANA LETTER GI
        0x30AF, # G+13858  U+30AF  uni30AF,  KATAKANA LETTER KU
        0x30B0, # G+13859  U+30B0  uni30B0,  KATAKANA LETTER GU
        0x30B1, # G+13860  U+30B1  uni30B1,  KATAKANA LETTER KE
        0x30B2, # G+13861  U+30B2  uni30B2,  KATAKANA LETTER GE
        0x30B3, # G+13862  U+30B3  uni30B3,  KATAKANA LETTER KO
        0x30B4, # G+13863  U+30B4  uni30B4,  KATAKANA LETTER GO
        0x30B5, # G+13864  U+30B5  uni30B5,  KATAKANA LETTER SA
        0x30B6, # G+13865  U+30B6  uni30B6,  KATAKANA LETTER ZA
        0x30B7, # G+13866  U+30B7  uni30B7,  KATAKANA LETTER SI
        0x30B8, # G+13867  U+30B8  uni30B8,  KATAKANA LETTER ZI
        0x30B9, # G+13868  U+30B9  uni30B9,  KATAKANA LETTER SU
        0x30BA, # G+13869  U+30BA  uni30BA,  KATAKANA LETTER ZU
        0x30BB, # G+13870  U+30BB  uni30BB,  KATAKANA LETTER SE
        0x30BC, # G+13871  U+30BC  uni30BC,  KATAKANA LETTER ZE
        0x30BD, # G+13872  U+30BD  uni30BD,  KATAKANA LETTER SO
        0x30BE, # G+13873  U+30BE  uni30BE,  KATAKANA LETTER ZO
        0x30BF, # G+13874  U+30BF  uni30BF,  KATAKANA LETTER TA
        0x30C0, # G+13875  U+30C0  uni30C0,  KATAKANA LETTER DA
        0x30C1, # G+13876  U+30C1  uni30C1,  KATAKANA LETTER TI
        0x30C2, # G+13877  U+30C2  uni30C2,  KATAKANA LETTER DI
        0x30C3, # G+13878  U+30C3  uni30C3,  KATAKANA LETTER SMALL TU
        0x30C4, # G+13879  U+30C4  uni30C4,  KATAKANA LETTER TU
        0x30C5, # G+13880  U+30C5  uni30C5,  KATAKANA LETTER DU
        0x30C6, # G+13881  U+30C6  uni30C6,  KATAKANA LETTER TE
        0x30C7, # G+13882  U+30C7  uni30C7,  KATAKANA LETTER DE
        0x30C8, # G+13883  U+30C8  uni30C8,  KATAKANA LETTER TO
        0x30C9, # G+13884  U+30C9  uni30C9,  KATAKANA LETTER DO
        0x30CA, # G+13885  U+30CA  uni30CA,  KATAKANA LETTER NA
        0x30CB, # G+13886  U+30CB  uni30CB,  KATAKANA LETTER NI
        0x30CC, # G+13887  U+30CC  uni30CC,  KATAKANA LETTER NU
        0x30CD, # G+13888  U+30CD  uni30CD,  KATAKANA LETTER NE
        0x30CE, # G+13889  U+30CE  uni30CE,  KATAKANA LETTER NO
        0x30CF, # G+13890  U+30CF  uni30CF,  KATAKANA LETTER HA
        0x30D0, # G+13891  U+30D0  uni30D0,  KATAKANA LETTER BA
        0x30D1, # G+13892  U+30D1  uni30D1,  KATAKANA LETTER PA
        0x30D2, # G+13893  U+30D2  uni30D2,  KATAKANA LETTER HI
        0x30D3, # G+13894  U+30D3  uni30D3,  KATAKANA LETTER BI
        0x30D4, # G+13895  U+30D4  uni30D4,  KATAKANA LETTER PI
        0x30D5, # G+13896  U+30D5  uni30D5,  KATAKANA LETTER HU
        0x30D6, # G+13897  U+30D6  uni30D6,  KATAKANA LETTER BU
        0x30D7, # G+13898  U+30D7  uni30D7,  KATAKANA LETTER PU
        0x30D8, # G+13899  U+30D8  uni30D8,  KATAKANA LETTER HE
        0x30D9, # G+13900  U+30D9  uni30D9,  KATAKANA LETTER BE
        0x30DA, # G+13901  U+30DA  uni30DA,  KATAKANA LETTER PE
        0x30DB, # G+13902  U+30DB  uni30DB,  KATAKANA LETTER HO
        0x30DC, # G+13903  U+30DC  uni30DC,  KATAKANA LETTER BO
        0x30DD, # G+13904  U+30DD  uni30DD,  KATAKANA LETTER PO
        0x30DE, # G+13905  U+30DE  uni30DE,  KATAKANA LETTER MA
        0x30DF, # G+13906  U+30DF  uni30DF,  KATAKANA LETTER MI
        0x30E0, # G+13907  U+30E0  uni30E0,  KATAKANA LETTER MU
        0x30E1, # G+13908  U+30E1  uni30E1,  KATAKANA LETTER ME
        0x30E2, # G+13909  U+30E2  uni30E2,  KATAKANA LETTER MO
        0x30E3, # G+13910  U+30E3  uni30E3,  KATAKANA LETTER SMALL YA
        0x30E4, # G+13911  U+30E4  uni30E4,  KATAKANA LETTER YA
        0x30E5, # G+13912  U+30E5  uni30E5,  KATAKANA LETTER SMALL YU
        0x30E6, # G+13913  U+30E6  uni30E6,  KATAKANA LETTER YU
        0x30E7, # G+13914  U+30E7  uni30E7,  KATAKANA LETTER SMALL YO
        0x30E8, # G+13915  U+30E8  uni30E8,  KATAKANA LETTER YO
        0x30E9, # G+13916  U+30E9  uni30E9,  KATAKANA LETTER RA
        0x30EA, # G+13917  U+30EA  uni30EA,  KATAKANA LETTER RI
        0x30EB, # G+13918  U+30EB  uni30EB,  KATAKANA LETTER RU
        0x30EC, # G+13919  U+30EC  uni30EC,  KATAKANA LETTER RE
        0x30ED, # G+13920  U+30ED  uni30ED,  KATAKANA LETTER RO
        0x30EE, # G+13921  U+30EE  uni30EE,  KATAKANA LETTER SMALL WA
        0x30EF, # G+13922  U+30EF  uni30EF,  KATAKANA LETTER WA
        0x30F0, # G+13923  U+30F0  uni30F0,  KATAKANA LETTER WI
        0x30F1, # G+13924  U+30F1  uni30F1,  KATAKANA LETTER WE
        0x30F2, # G+13925  U+30F2  uni30F2,  KATAKANA LETTER WO
        0x30F3, # G+13926  U+30F3  uni30F3,  KATAKANA LETTER N
        0x30F4, # G+13927  U+30F4  uni30F4,  KATAKANA LETTER VU
        0x30F5, # G+13928  U+30F5  uni30F5,  KATAKANA LETTER SMALL KA
        0x30F6, # G+13929  U+30F6  uni30F6,  KATAKANA LETTER SMALL KE
        0x0410, # G+13930  U+0410  afii10017,  CYRILLIC CAPITAL LETTER A
        0x0411, # G+13931  U+0411  afii10018,  CYRILLIC CAPITAL LETTER BE
        0x0412, # G+13932  U+0412  afii10019,  CYRILLIC CAPITAL LETTER VE
        0x0413, # G+13933  U+0413  afii10020,  CYRILLIC CAPITAL LETTER GHE
        0x0414, # G+13934  U+0414  afii10021,  CYRILLIC CAPITAL LETTER DE
        0x0415, # G+13935  U+0415  afii10022,  CYRILLIC CAPITAL LETTER IE
        0x0401, # G+13936  U+0401  afii10023,  CYRILLIC CAPITAL LETTER IO
        0x0416, # G+13937  U+0416  afii10024,  CYRILLIC CAPITAL LETTER ZHE
        0x0417, # G+13938  U+0417  afii10025,  CYRILLIC CAPITAL LETTER ZE
        0x0418, # G+13939  U+0418  afii10026,  CYRILLIC CAPITAL LETTER I
        0x0419, # G+13940  U+0419  afii10027,  CYRILLIC CAPITAL LETTER SHORT I
        0x041A, # G+13941  U+041A  afii10028,  CYRILLIC CAPITAL LETTER KA
        0x041B, # G+13942  U+041B  afii10029,  CYRILLIC CAPITAL LETTER EL
        0x041C, # G+13943  U+041C  afii10030,  CYRILLIC CAPITAL LETTER EM
        0x041D, # G+13944  U+041D  afii10031,  CYRILLIC CAPITAL LETTER EN
        0x041E, # G+13945  U+041E  afii10032,  CYRILLIC CAPITAL LETTER O
        0x041F, # G+13946  U+041F  afii10033,  CYRILLIC CAPITAL LETTER PE
        0x0420, # G+13947  U+0420  afii10034,  CYRILLIC CAPITAL LETTER ER
        0x0421, # G+13948  U+0421  afii10035,  CYRILLIC CAPITAL LETTER ES
        0x0422, # G+13949  U+0422  afii10036,  CYRILLIC CAPITAL LETTER TE
        0x0423, # G+13950  U+0423  afii10037,  CYRILLIC CAPITAL LETTER U
        0x0424, # G+13951  U+0424  afii10038,  CYRILLIC CAPITAL LETTER EF
        0x0425, # G+13952  U+0425  afii10039,  CYRILLIC CAPITAL LETTER HA
        0x0426, # G+13953  U+0426  afii10040,  CYRILLIC CAPITAL LETTER TSE
        0x0427, # G+13954  U+0427  afii10041,  CYRILLIC CAPITAL LETTER CHE
        0x0428, # G+13955  U+0428  afii10042,  CYRILLIC CAPITAL LETTER SHA
        0x0429, # G+13956  U+0429  afii10043,  CYRILLIC CAPITAL LETTER SHCHA
        0x042A, # G+13957  U+042A  afii10044,  CYRILLIC CAPITAL LETTER HARD SIGN
        0x042B, # G+13958  U+042B  afii10045,  CYRILLIC CAPITAL LETTER YERU
        0x042C, # G+13959  U+042C  afii10046,  CYRILLIC CAPITAL LETTER SOFT SIGN
        0x042D, # G+13960  U+042D  afii10047,  CYRILLIC CAPITAL LETTER E
        0x042E, # G+13961  U+042E  afii10048,  CYRILLIC CAPITAL LETTER YU
        0x042F, # G+13962  U+042F  afii10049,  CYRILLIC CAPITAL LETTER YA
        0x0430, # G+13963  U+0430  afii10065,  CYRILLIC SMALL LETTER A
        0x0431, # G+13964  U+0431  afii10066,  CYRILLIC SMALL LETTER BE
        0x0432, # G+13965  U+0432  afii10067,  CYRILLIC SMALL LETTER VE
        0x0433, # G+13966  U+0433  afii10068,  CYRILLIC SMALL LETTER GHE
        0x0434, # G+13967  U+0434  afii10069,  CYRILLIC SMALL LETTER DE
        0x0435, # G+13968  U+0435  afii10070,  CYRILLIC SMALL LETTER IE
        0x0451, # G+13969  U+0451  afii10071,  CYRILLIC SMALL LETTER IO
        0x0436, # G+13970  U+0436  afii10072,  CYRILLIC SMALL LETTER ZHE
        0x0437, # G+13971  U+0437  afii10073,  CYRILLIC SMALL LETTER ZE
        0x0438, # G+13972  U+0438  afii10074,  CYRILLIC SMALL LETTER I
        0x0439, # G+13973  U+0439  afii10075,  CYRILLIC SMALL LETTER SHORT I
        0x043A, # G+13974  U+043A  afii10076,  CYRILLIC SMALL LETTER KA
        0x043B, # G+13975  U+043B  afii10077,  CYRILLIC SMALL LETTER EL
        0x043C, # G+13976  U+043C  afii10078,  CYRILLIC SMALL LETTER EM
        0x043D, # G+13977  U+043D  afii10079,  CYRILLIC SMALL LETTER EN
        0x043E, # G+13978  U+043E  afii10080,  CYRILLIC SMALL LETTER O
        0x043F, # G+13979  U+043F  afii10081,  CYRILLIC SMALL LETTER PE
        0x0440, # G+13980  U+0440  afii10082,  CYRILLIC SMALL LETTER ER
        0x0441, # G+13981  U+0441  afii10083,  CYRILLIC SMALL LETTER ES
        0x0442, # G+13982  U+0442  afii10084,  CYRILLIC SMALL LETTER TE
        0x0443, # G+13983  U+0443  afii10085,  CYRILLIC SMALL LETTER U
        0x0444, # G+13984  U+0444  afii10086,  CYRILLIC SMALL LETTER EF
        0x0445, # G+13985  U+0445  afii10087,  CYRILLIC SMALL LETTER HA
        0x0446, # G+13986  U+0446  afii10088,  CYRILLIC SMALL LETTER TSE
        0x0447, # G+13987  U+0447  afii10089,  CYRILLIC SMALL LETTER CHE
        0x0448, # G+13988  U+0448  afii10090,  CYRILLIC SMALL LETTER SHA
        0x0449, # G+13989  U+0449  afii10091,  CYRILLIC SMALL LETTER SHCHA
        0x044A, # G+13990  U+044A  afii10092,  CYRILLIC SMALL LETTER HARD SIGN
        0x044B, # G+13991  U+044B  afii10093,  CYRILLIC SMALL LETTER YERU
        0x044C, # G+13992  U+044C  afii10094,  CYRILLIC SMALL LETTER SOFT SIGN
        0x044D, # G+13993  U+044D  afii10095,  CYRILLIC SMALL LETTER E
        0x044E, # G+13994  U+044E  afii10096,  CYRILLIC SMALL LETTER YU
        0x044F, # G+13995  U+044F  afii10097,  CYRILLIC SMALL LETTER YA
        0x21E7, # G+13996  U+21E7  uni21E7,  UPWARDS WHITE ARROW
        0x21B8, # G+13997  U+21B8  uni21B8,  NORTH WEST ARROW TO LONG BAR
        0x21B9, # G+13998  U+21B9  uni21B9,  LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR
        0x4E41, # G+13999  U+4E41  uni4E41,  CJK UNIFIED IDEOGRAPH-4E41
        0x200CC,    # G+14000  U+200CC  uni200CC,  CJK UNIFIED IDEOGRAPH-200CC
        0x4E5A, # G+14001  U+4E5A  uni4E5A,  CJK UNIFIED IDEOGRAPH-4E5A
        0x2008A,    # G+14002  U+2008A  uni2008A,  CJK UNIFIED IDEOGRAPH-2008A
        0x5202, # G+14003  U+5202  uni5202,  CJK UNIFIED IDEOGRAPH-5202
        0x4491, # G+14004  U+4491  uni4491,  CJK UNIFIED IDEOGRAPH-4491
        0xF7EB, # G+14005  U+F7EB  Edieresissmall,  
        0x5188, # G+14006  U+5188  uni5188,  CJK UNIFIED IDEOGRAPH-5188
        0x361D, # G+14007  U+361D  uni361D,  CJK UNIFIED IDEOGRAPH-361D
        0x27607,    # G+14008  U+27607  uni27607,  CJK UNIFIED IDEOGRAPH-27607
        0x0000, # G+14009  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14010  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14011  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14012  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14013  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14014  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14015  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14016  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14017  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14018  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14019  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14020  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14021  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14022  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14023  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14024  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14025  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14026  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14027  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14028  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14029  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14030  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14031  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14032  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14033  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14034  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14035  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14036  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14037  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14038  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14039  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14040  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14041  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14042  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14043  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14044  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14045  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14046  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14047  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14048  U+0000  .notdef,  UNDEFINED
        0x00AC, # G+14049  U+00AC  logicalnot,  NOT SIGN
        0xFFE4, # G+14050  U+FFE4  uniFFE4,  FULLWIDTH BROKEN BAR
        0xFF07, # G+14051  U+FF07  uniFF07,  FULLWIDTH APOSTROPHE
        0xFF02, # G+14052  U+FF02  uniFF02,  FULLWIDTH QUOTATION MARK
        0x3231, # G+14053  U+3231  uni3231,  PARENTHESIZED IDEOGRAPH STOCK
        0x2116, # G+14054  U+2116  afii61352,  NUMERO SIGN
        0x2121, # G+14055  U+2121  uni2121,  TELEPHONE SIGN
        0x7881, # G+14056  U+7881  uni7881,  CJK UNIFIED IDEOGRAPH-7881
        0x92B9, # G+14057  U+92B9  uni92B9,  CJK UNIFIED IDEOGRAPH-92B9
        0x88CF, # G+14058  U+88CF  uni88CF,  CJK UNIFIED IDEOGRAPH-88CF
        0x58BB, # G+14059  U+58BB  uni58BB,  CJK UNIFIED IDEOGRAPH-58BB
        0x6052, # G+14060  U+6052  uni6052,  CJK UNIFIED IDEOGRAPH-6052
        0x7CA7, # G+14061  U+7CA7  uni7CA7,  CJK UNIFIED IDEOGRAPH-7CA7
        0x5AFA, # G+14062  U+5AFA  uni5AFA,  CJK UNIFIED IDEOGRAPH-5AFA
        0x2554, # G+14063  U+2554  SF390000,  BOX DRAWINGS DOUBLE DOWN AND RIGHT
        0x2566, # G+14064  U+2566  SF410000,  BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
        0x2557, # G+14065  U+2557  SF250000,  BOX DRAWINGS DOUBLE DOWN AND LEFT
        0x2560, # G+14066  U+2560  SF420000,  BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
        0x256C, # G+14067  U+256C  SF440000,  BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
        0x2563, # G+14068  U+2563  SF230000,  BOX DRAWINGS DOUBLE VERTICAL AND LEFT
        0x255A, # G+14069  U+255A  SF380000,  BOX DRAWINGS DOUBLE UP AND RIGHT
        0x2569, # G+14070  U+2569  SF400000,  BOX DRAWINGS DOUBLE UP AND HORIZONTAL
        0x255D, # G+14071  U+255D  SF260000,  BOX DRAWINGS DOUBLE UP AND LEFT
        0x2552, # G+14072  U+2552  SF510000,  BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
        0x2564, # G+14073  U+2564  SF470000,  BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
        0x2555, # G+14074  U+2555  SF220000,  BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
        0x0000, # G+14075  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14076  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14077  U+0000  .notdef,  UNDEFINED
        0x2558, # G+14078  U+2558  SF500000,  BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
        0x2567, # G+14079  U+2567  SF450000,  BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
        0x255B, # G+14080  U+255B  SF280000,  BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
        0x2553, # G+14081  U+2553  SF520000,  BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
        0x2565, # G+14082  U+2565  SF480000,  BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
        0x2556, # G+14083  U+2556  SF210000,  BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
        0x255F, # G+14084  U+255F  SF370000,  BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
        0x256B, # G+14085  U+256B  SF530000,  BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
        0x2562, # G+14086  U+2562  SF200000,  BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
        0x2559, # G+14087  U+2559  SF490000,  BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
        0x2568, # G+14088  U+2568  SF460000,  BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
        0x255C, # G+14089  U+255C  SF270000,  BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
        0x2551, # G+14090  U+2551  SF240000,  BOX DRAWINGS DOUBLE VERTICAL
        0x0000, # G+14091  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14092  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14093  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14094  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14095  U+0000  .notdef,  UNDEFINED
        0x2593, # G+14096  U+2593  dkshade,  DARK SHADE
        0x0000, # G+14097  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14098  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14099  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14100  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14101  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14102  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14103  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14104  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14105  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14106  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14107  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14108  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14109  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14110  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14111  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14112  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14113  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14114  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14115  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14116  U+0000  .notdef,  UNDEFINED
        