# -*- cperl -*-

use Test::More tests => 1 + 12;

use locale;

BEGIN { use_ok( 'Lingua::PT::PLNbase' ); }

my @ss = frases(<<"EOT");
O dr. Joo Rato comeu a D. Carochinha.
O Eng. visitou a av. do Marqus.
O Ex. Sr. Antnio foi prof. de Matemtica.
O Pe. Joaquim casou o Arq. Joo com a Prof. Joana.
Os profs. vo ao lg. do Pao.
Os profs. vo ao lgo. do Pao.
As profas. tambm vo ao lgo. do Pao.
No sc. V A.C. j no existiam dinossauros.
Os Exmos. Srs. deputados que...
Os Exmos. Srs. Drs. vo almoar ao Snack-Bar.
Na rua Cel. Antnio virar  esquerda, pela avenida do Sen. Joaquim.
A empresa de Marco Correia e Cia. Lda. fica na Trv. Mrio Soares.
EOT

my $i = 0;
my @sts = (q/O dr. Joo Rato comeu a D. Carochinha./,
	   q/O Eng. visitou a av. do Marqus./,
	   q/O Ex. Sr. Antnio foi prof. de Matemtica./,
	   q/O Pe. Joaquim casou o Arq. Joo com a Prof. Joana./,
	   q/Os profs. vo ao lg. do Pao./,
	   q/Os profs. vo ao lgo. do Pao./,
	   q/As profas. tambm vo ao lgo. do Pao./,
	   q/No sc. V A.C. j no existiam dinossauros./,
	   q/Os Exmos. Srs. deputados que.../,
	   q/Os Exmos. Srs. Drs. vo almoar ao Snack-Bar./,
	   q/Na rua Cel. Antnio virar  esquerda, pela avenida do Sen. Joaquim./,
	   q/A empresa de Marco Correia e Cia. Lda. fica na Trv. Mrio Soares./,
	  );

for (@sts) {
  is(trim($ss[$i++]),$_)
}


##------
sub trim {
  my $x = shift;
  $x =~ s/^[\n\s]*//;
  $x =~ s![\n\s]*$!!;
  $x
}
