![Build
Status](https://travis-ci.org/araraloren/perl6-getopt-advance.svg?branch=master)
![Windows Build
Status](https://ci.appveyor.com/api/projects/status/1aknogb99475ak53/branch/master?svg=true)


# Getopt::Advance

  An advance command line parsing module.

# Description

`Getopt::Advance` is a powerful command line option parsing module, it
suppot many style such as: `unix-style`、`gnu-style`、`bsd-style`.etc. It
support `Hash`、`Array` option compared to traditional command line
tools. In addition, it also support `radio`、`multi` group mechanism
which can manage option realtionship. And to handle non-option argument,
it provide `main`、`pos` and `cmd` feature.

# Usage

## Try it

### Normal version

``` perl6
use Getopt::Advance;

my OptionSet $os .= new();

$os.push(
    "h|help=b",
    "print help message.",
    callback => sub ($, $) {
        say "The h option is set by user";
    });

&getopt($os);
say "Exit!";
```

### With react

``` perl6
use Getopt::Advance;

my OptionSet $os .= new();

$os.push("h|help=b", "print help message.");

react {
    whenever $os.Supply("h") {
        say "The h option is set by user";
    }
    whenever &getopt($os) {
        say "Exit!";
        done;
    }
}
```

## Document

[Getopt-Advance](doc/Getopt/Advance.adoc)

## Example

### App::snippet

[Run your c/c++ code.](https://github.com/araraloren/perl6-app-snippet)

### App::FindSource

[Find your source file
easily\!](https://github.com/araraloren/perl6-app-findsource)

### xcp

A [script](sample/xcp.p6) display the copy progress.

### pdnf

[pdnf](sample/pdnf.p6) added some sort command to dnf(package manager of
some linux distribution).

### find-file

[find-file](sample/find-file.p6)

#### usage

**help.**

``` shell
$ ./find-file.p6
Usage:
./sample/find-file.p6 [directory] OPTIONs

-d               specify file type to directory

-v|--version     print program version.

--size=<integer> the minimum size limit of file.

-?               same as -h.

-h|--help        print this help.

-f               specify file type to normal file

-l               specify file type to symlink
```

**find.**

``` shell
$ ./find-file.p6 ../t '1\d.*t$'
../t/11-bsd-style.t
../t/10-x-style.t
```

# Installation

  - install with zef

        zef install Getopt::Advance

# Lincese

The MIT License (MIT).

# TODO

  - Update documents

  - Update subs feature
