package main;
use Evo::Base -strict;
use Test::More tests => 1;
use Promises6 'deferred';

# resolve
my ($count, $d, $err);
$count = 0;
$d     = deferred;
$d->promise->then(sub { ThenableCircularA->single })
  ->then(sub {fail}, sub($r) { $err = $r });

$d->resolve(undef);
like $err, qr/Circular thenable.+ThenableCircularA/, 'right error';

{

  package ThenableCircularA;
  sub single { state $o = bless {}, shift }

  sub then {
    $_[1]->(ThenableCircularB->single);
    die "recursion" if ++$count > 1;
  }

  package ThenableCircularB;
  sub single { state $o = bless {}, shift }

  sub then { $_[1]->(ThenableCircularA->single) }

}

