package UAP;
use Evo::Base 'Mojo::UserAgent';
use Promises6 'promise';

sub _gen_cb {
  my ($resolve, $reject, $notify) = @_;
  my $cb = sub ($ua, $tx) {
    return $resolve->($tx->success) if $tx->success;

    my $err = $tx->error;
    return $reject->("$err->{code} response: $err->{message}") if $err->{code};
    $reject->("Connection error: $err->{message}");
  };
}


sub start {
  my ($self, $tx) = @_;
  my $url = $tx->req->url;

  promise {
    my ($resolve, $reject, $notify) = @_;
    $tx->res->on(progress => $notify);
    $self->SUPER::start($tx, _gen_cb($resolve, $reject, $notify))
  };

}

1;
