package Evo::Class::Common::GenBase;
use Evo '-Class::Common::Util; -Internal::Util; Carp croak';

my $KEY = 'EVO_CLASS_GEN';

sub register ($me, $package) {
  my $self;
  if ($self = Evo::Internal::Util::pkg_stash($package, $KEY)) {
    croak "$package already has $self, can't register $me" if ref($self) ne $me;
    return $self;
  }
  $self = $me->new($package);
  Evo::Internal::Util::pkg_stash($package, $KEY, $self);
  return $self;
}

sub find_or_croak ($self, $package) {
  Evo::Internal::Util::pkg_stash($package, 'EVO_CLASS_GEN') or croak "$package isn't Evo::Class";
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Class::Common::GenBase

=head1 VERSION

version 0.0226

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
