package main;
use Evo '-Try *', '-Lib *', '-Want *';
use Test::More;


sub do_test(&) {
  my $want     = 'bad';
  my $passed   = shift;
  my $sub_void = sub { $want = wantarray };
  $passed->($sub_void);
  ok want_is_void($want);

  my $sub_scalar = sub { $want = wantarray; return 'foo'; };
  my $val = $passed->($sub_scalar);
  ok want_is_scalar($want);
  is $val, 'foo';

  my $sub_list = sub {
    $want = wantarray;
    my @ret = (1, 2, 3);
    @ret;
  };
  my @val = $passed->($sub_list);
  ok want_is_list($want);
  is_deeply \@val, [1, 2, 3];
}

sub do_void_test(&) {
  my $want     = 'bad';
  my $passed   = shift;
  my $sub_void = sub { $want = wantarray };
  $passed->($sub_void);
  ok want_is_void($want);
  my $val = $passed->($sub_void);
  ok want_is_void($want);
  my @val = $passed->($sub_void);
  ok want_is_void($want);
}

## try_catch
# try
do_test {
  my $sub = shift;
  try_catch sub { $sub->() }, sub {1};
};

# catch
do_test {
  my $sub = shift;
  try_catch sub { die; }, sub { $sub->() };
};

# fin
do_test {
  my $sub = shift;
  try_catch sub {1}, undef, sub { $sub->() };
};

# fin
do_test {
  my $sub = shift;
  try_catch sub {die}, sub {1}, sub { $sub->() };
};

do_void_test {
  my $sub = shift;
  local $@;
  eval {
    try_catch sub { die "Foo\n" }, undef, sub { $sub->() };
  };
  is $@, "Foo\n";
};

do_void_test {
  my $sub = shift;
  local $@;
  eval {
    try_catch sub {die}, sub { die "Foo\n" }, sub { $sub->() };
  };
  is $@, "Foo\n";
};


done_testing;

