use Evo::Base -strict;
use Benchmark ':all';
use Evo::Guard;
use Test::More;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $EXPECT = 400_000 * $ENV{TEST_EVO_PERF};
my $N      = 1000_000;

my $t = timeit(
  $N,
  sub {
    my $res;
    my $guard = Evo::Guard->new(always => sub { $res++ });
    undef $guard;
    die unless $res;
  }
);

diag timestr $t;
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

#XS_GUARD: {
#  last XS_GUARD unless eval { require Guard };
#  my $txs = timeit(
#    1000_000,
#    sub {
#      my $res;
#      my $guard = Guard::guard(sub { $res++ });
#      undef $guard;
#      die unless $res;
#    }
#  );
#  diag timestr $txs;
#  my $perfxs = $N / $txs->cpu_a;
#  ok $perfxs > $EXPECT, "$perfxs > $EXPECT";
#}


done_testing;
