use Evo::Base -strict;
use Test::More tests => 13;
use Evo::Guard;
use Test::Fatal;

my @WARNS;
local $SIG{__WARN__} = sub { push @WARNS, shift };

# die in always, see what happens
TEST: {
  my @res;
  like exception {
    my $guard = Evo::Guard->new(
      error  => sub { push @res, 'e' },
      always => sub { push @res, 'a'; die "IN_ALWAYS" }
    );
    die 'foo';
  }, qr/foo/;

  is_deeply \@res, ['e', 'a'];
  like shift(@WARNS), qr/IN_ALWAYS/;
  ok !@WARNS;
}

# die in error
TEST: {
  my @res;
  like exception {
    my $guard = Evo::Guard->new(
      error => sub { push @res, 'e'; die "IN_ERROR" },
      always => sub { push @res, 'a'; }
    );
    die 'foo';
  }, qr/foo/;

  is_deeply \@res, ['e', 'a'];
  like shift(@WARNS), qr/IN_ERROR/;
  ok !@WARNS;
}

# die in error
TEST: {
  my @res;
  like exception {
    my $guard = Evo::Guard->new(
      error  => sub { push @res, 'e'; die "IN_ERROR" },
      always => sub { push @res, 'a'; die "IN_ALWAYS" }
    );
    die 'foo';
  }, qr/foo/;

  is_deeply \@res, ['e', 'a'];
  like shift(@WARNS), qr/IN_ERROR/;
  like shift(@WARNS), qr/IN_ALWAYS/;
  ok !@WARNS;
}
