use Evo::Base -strict;
use Test::More tests => 5;
use Test::Fatal;
use Evo::Manager;

my $rlw = Evo::Manager->singleton;

$rlw->dsl_call(
  {foo => 'bar'},
  sub {

    like exception {
      $rlw->dsl_extend({foo => 'baz'}, sub { })
    }, qr/existing key 'foo'/, 'attemt to override';

    $rlw->dsl_extend(
      {a => 2},
      1, 2,
      sub {
        is_deeply \@_, [1, 2], 'right args';
        is_deeply $rlw->current, {a => 2, foo => 'bar'}, 'extended';
      }
    );

    is_deeply $rlw->current, {foo => 'bar'}, 'not affected';

  }
);


like exception {
  $rlw->dsl_extend({foo => 'baz'}, sub { })
}, qr/outside/, 'extend without init';

done_testing;

1;
