use Evo::Base -strict;
use Evo::Manager;
use Guard;
use Benchmark ':all';
use Time::Piece;

my ($start, $end, $dur);
my $m      = Evo::Manager->new;
my $train = $m->build_train;

$train->way->add(sub { $m->current('train') });
$train->start;

my $N = 100_000;

# pure  100_000, 1, 18

$start = localtime;
foreach my $n (1 .. $N) {
  $train->way->add(sub {@_})->add(sub {"foo $n"})->add(sub {"bad"});
}
$end = localtime;
$dur = $end - $start;
say "Build $N:, $dur";

$start = localtime;
$train->start();
$end = localtime;
$dur = $end - $start;
say "Run $N:, $dur";

