use Devel::CheckLib;
check_lib_or_exit(lib => 'LLVM-3.1');
# This Makefile.PL for  was generated by Dist::Zilla.
# Don't edit it but the dist.ini used to construct it.

use strict;
use warnings;
use ExtUtils::MakeMaker 6.30;

my %WriteMakefileArgs = (
  'ABSTRACT' => 'Perl bindings to the Low Level Virtual Machine',
  'AUTHOR' => 'Alessandro Ghedini <alexbio@cpan.org>',
  'BUILD_REQUIRES' => {
    'Capture::Tiny' => '0',
    'File::Find' => '0',
    'File::Slurp' => '0',
    'File::Temp' => '0',
    'Test::More' => '0'
  },
  'CCFLAGS' => '-I/usr/lib/llvm-3.1/include  -DNDEBUG -D_GNU_SOURCE -D__STDC_CONSTANT_MACROS -D__STDC_FORMAT_MACROS -D__STDC_LIMIT_MACROS -g -O2 -fomit-frame-pointer -fPIC',
  'CONFIGURE_REQUIRES' => {
    'Devel::CheckLib' => '0',
    'ExtUtils::MakeMaker' => '6.30'
  },
  'DISTNAME' => 'LLVM',
  'EXE_FILES' => [],
  'INC' => '-I.',
  'LIBS' => '-lLLVM-3.1',
  'LICENSE' => 'perl',
  'NAME' => 'LLVM',
  'OBJECT' => '$(O_FILES)',
  'PREREQ_PM' => {
    'XSLoader' => '0',
    'strict' => '0',
    'warnings' => '0'
  },
  'VERSION' => '0.09',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

